// Revision: 94 1.15.2.5 source/ui/cnr/icnrctlm.hpp, container, ioc.v400, 001006 
/* NOSHIP */
#ifndef _ICNRCTLM_
#define _ICNRCTLM_

/*******************************************************************************
* FILE NAME: icnrctlm.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the interface for the ICnrControlData class that is     *
*   used to hide Motif unique utilities from the public interface.             *
*                                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C" {
#include <Xm/Xm.h>
}

#include <irect.hpp>
#include <ihandle.hpp>
#include <istring.hpp>
#include <iwidlist.hpp>
#include <isizehdr.hpp>
#include <ikeyhdr.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IContainerControl;
class IContainerColumn;
class ICnrControlData ;
class ICnrDirectEdit;
class IMultiLineEdit;
class IWindow;

#include <iseq2.h>
#include <ikeyset.h>

// Sequence contains an entry for each IContainerColumn that has been added
// to this Container
typedef IVPtrSequence<IContainerColumn*> ColumnSequenceType;

// Declarations used for filtering
class ICnrFilterPackage;
typedef bool (*PCNRFILTERFN) (const IMiniCnrRecord*, ICnrFilterPackage*);

#pragma enum(4)
#pragma pack(push,4)

class IPointerElement {
public:
  IPointerElement  ( const IPointerHandle& pointer,
                     const Widget&         gadget ) ;
  ~IPointerElement ( );

  IPointerHandle pointerHandle;
  unsigned long lph;

private:
  friend unsigned long const& key ( IPointerElement* const& k );
  IPointerElement ( const IPointerElement& );
  IPointerElement
    &operator =   ( const IPointerElement& );
};

class ICnrPointerSet : public IKeySet < IPointerElement*, unsigned long >
{
public:
  ICnrPointerSet();
  ~ICnrPointerSet();

ICnrPointerSet
  &addPointerElement( const IPointerHandle& pointer,
                      const Widget&         gadget ) ;
ICnrPointerSet
  &empty() ;
};

inline unsigned long const& key (IPointerElement* const& k)
{
  return k->lph;
}

/*------------------------------------------------------------------------------
| ICnrHdrPrivateData class                                                     |
|
|   Keeps list of widgets that were selected last time dispatchHandlerEvent
/   was called. We need this list for simulating the way PM doles out
/   selection emphasis events.
------------------------------------------------------------------------------*/
class ICnrHdrPrivateData {
public:
   ICnrHdrPrivateData() ;
   ~ICnrHdrPrivateData() ;
   void setOldSelections(WidgetList newList, int count) ;
   void addToOldSelections(Widget wid) ;
   void removeFromOldSelections(Widget wid) ;

    WidgetList oldSelections;
    int        oldCount;

} ; // ICnrHdrPrivateData

// handle resize of bulletin board children
class ICnrControlDataHandler: public IHandler
{
public:
   ICnrControlDataHandler(ICnrControlData* pCnrCtlData) ;
   virtual ~ICnrControlDataHandler() ;
protected:
   virtual bool dispatchHandlerEvent(IEvent& evt) ;
private:
   ICnrControlData    *pCnrData ;
   ICnrHdrPrivateData *ppd ;
} ; // class ICnrControlDataHandler

// handle use of <Key>Enter on Motif
class ICnrControlDataKeyboardHandler : public IKeyboardHandler
{
public:
   ICnrControlDataKeyboardHandler(ICnrControlData* pCnrCtlData) ;
   virtual ~ICnrControlDataKeyboardHandler() ;
   virtual bool virtualKeyPress(IKeyboardEvent& evt) ;
private:
   ICnrControlData *pCnrData ;
} ; // class ICnrControlDataKeyboardHandler


/*------------------------------------------------------------------------------
| ICnrControlData class                                                        |
------------------------------------------------------------------------------*/
class ICnrControlData {
friend class ICnrDirectEdit;
friend IWindowHandle mleParentWidget( IWindow * container );
public:
  // Data
  IContainerControl* theIContainer;

  IWindowHandle bulletinBoard
               ,form
               ,titleLabel
               ,titleSeparator
               ,scrolledWindow
               ,clipWindow
               ,horizontalScroll
               ,verticalScroll
               ,container
               ;
  ColumnSequenceType columnSeq;

  unsigned long flWindowAttr;        // those attributes, for which no
                                     // 1:1 Motif resource exists

  unsigned long ulStyle;             // those styles, for which no
                                     // 1:1 Motif resource exists

  IWidgetList* pwidgetList;           // holds widgets to be managed

  // Functions
  ICnrControlData(IContainerControl* aContainer);
  ~ICnrControlData();

  void createContainer (const IWindowHandle& handle);

  void createContainer (unsigned long id,
                        IWindow* pwndParent,
                        IWindow* pwndOwner,
                        const IRectangle& rectInit,
                        WidgetClass cnrClass = 0
                        );

  void addMotifCallbacks() ;
  void removeMotifCallbacks() ;

  // Remaining functions are for processing PM style messages that
  // the IContainerControl::sendEvent override intercepts

  void setSelection(unsigned long style);

  void setDetailInfo(PFIELDINFO pfldinfo,
                     PFIELDINFOINSERT pfldinfoinsert);

  PFIELDINFO queryDetailInfo(PFIELDINFO pfldinfo,
                             unsigned short cmd);

  int removeDetailInfo(PFIELDINFO *pfldinfoArr,
                         unsigned long removeNum,
                         unsigned long flags);

  void updateColumns();

  IRectangle titleRectangle() ;

  IRectangle detailsTitleRectangle() ;

  void arrangeIconView();                                   /* LJO */

  void showStretchedIcons(const ISize& iconSize) ;

  void showMiniIcons() ;

  void showScaledIcons(const ISize& iconSize) ;

  void showLargeIcons() ;

  bool resizeIcon(const IContainerObject& cnrObj, const ISize& iconSize) ;

  void resetIconSize(const IContainerObject& cnrObj) ;

  void setLineSpacing(long lLineSpacing) ;

  bool isSingleSelection() const ;

  bool isExtendedSelection() const ;

  bool isMultipleSelection() const ;

  IRectangle viewPortOnWorkspace() ; 

  static void updateFont( const IWindowHandle & cnr, XmFontList fontList );

  void removeRecord(IMiniCnrRecord** ppcnrrec,
                    unsigned long removeNum,
                    unsigned long flags);

  void setCnrInfo(ICnrInfo* pcnrInfo, unsigned long setFlag);

  void setWindowAttr(unsigned long flags);

  IEventResult queryRecordEmphasis(unsigned long whichOne,
                                   unsigned long whichEmphasis);

  IMiniCnrRecord* getFirstSelected(Widget root);

  void setRefreshOn(bool bRefreshState) ;

  void refresh() ;

  void setGadgetEmphasis(Widget iconG,
                         bool turnOn,
                         unsigned long emphType);

  IEventResult queryRecord(IMiniCnrRecord* pCnrRec,
                           unsigned short position,
                           unsigned short order);

  IEventResult queryRecordRect(PRECTL pRectl,
                               PQUERYRECORDRECT pQueryRecordRect );

  IEventResult queryViewPortRect(PRECTL pRectl,
                           unsigned short coordinateSpace,
                           unsigned short rightSplitWindow);

  IEventResult queryRecordFromRect( PRECORDCORE pSearchAfter,
                               PQUERYRECFROMRECT pQueryRecFromRect );

  void invalidateRecord(IMiniCnrRecord** pRecArr,
                        unsigned short cNumRecord,
                        unsigned short fInvalidateRecord);


  bool strMatch(PSEARCHSTRING pSrchStr,
                Widget curIconG,
                unsigned long numCols,
                bool exact);

  Widget nextBranchGadget(Widget curIconG);


  Widget nextSearchStringGadget(Widget curIconG, unsigned long view);

  IMiniCnrRecord* searchString(PSEARCHSTRING pSrchStr,
                               IMiniCnrRecord* startRec);


  void filterContainer(PCNRFILTERFN pfn,
                       ICnrFilterPackage* pFilterPckg);

  unsigned long queryContainerWidget();

  void queryCnrInfo(ICnrInfo* pInfo);

  bool queryRecordInfo(IMiniCnrRecord** ppMCR);

  void expandCollapseTree(Widget startGadget, unsigned char state);

  IContainerColumn * columnUnderPoint( const IPoint& pt );

  IRectangle detailsCellRectangle (IContainerObject* object,
                                   const IContainerColumn* column) const;

  void openEdit( PCNREDITDATA pmEditStruct );

  void closeEdit( const IWindowHandle& hwnd );

  void installDirectEditTranslations();
  IWindowHandle mleParent();                   // direct-edit
  void dismissMle();                           // direct-edit
  void deleteMle();                            // direct-edit

  IContainerObject* firstObject() ;
  void firstObject(IContainerObject* pcnrObj) ;
  IContainerObject* lastObject() ;
  void lastObject(IContainerObject* pcnrObj) ;

#if 1 /* EMPTY_CNR_REGION */
  static void clipWindowEvents( Widget widget_id, XtPointer client_data,
                          XEvent * call_data, ::Boolean *continue_to_dispatch );
#endif

  static void scrollBarCallback( Widget widget_id, XtPointer client_data,
                                                   XtPointer call_data );

  static void traversalCallback( Widget widget_id, XtPointer client_data,
                                                  XtPointer call_data );
  IEventResult scrollWindow( unsigned short direction, long increment );

  bool isStyleReadonly();

  bool isTitleWriteable() ;

  IPoint xToWinCoords( const XPoint& xPoint,
                       const IWindowHandle* widgetFrom = 0 ) const;
  IRectangle xToWinCoords( const XRectangle& xRect ) const;

  XPoint winToXCoords( const IPoint& winPoint ) const;
  XRectangle winToXCoords( const IRectangle& iRect ) const;

  enum ContainerManagementT {SHOW_TITLE, HIDE_TITLE, SET_TITLE,
                             SHOW_SEPARATOR, HIDE_SEPARATOR, NULL_REQUEST};
  void containerManagement( enum ContainerManagementT cnrRequest);
  void resizeBulletinBoard() ;

#if 1       /* DETECT_OVERFLOW */

  class Overflow {   /* nested class for managing overflow */
    public:
      Overflow();
      ~Overflow();
      void check( const IContainerControl * cnrCtl,
                  unsigned long eventId = 0,
                  bool directEditCheck = false );
    private:
      unsigned long lastEventId;
  };

  Overflow overflow;
#endif

 private:

  PFIELDINFO colInfo( const IContainerColumn * col );

  bool sendEventFromCnr( unsigned long           eventId,
                         const IEventParameter1& parm1,
                         const IEventParameter2& parm2) const;

  void postEventFromCnr   ( unsigned long           eventId,
                            const IEventParameter1& parm1,
                            const IEventParameter2& parm2) const;

  bool isSelectionPolicy(unsigned char cPolicy) const ;

  void saveEditState( );
  void restoreEditState( );

  IContainerObject* getRecord ( IContainerObject* pObject,
                                unsigned short position,
                                unsigned short order) ;

  unsigned short cnrMarginHeight;
  unsigned short cnrMarginWidth;
  unsigned short scrollCellHeight;
  unsigned short scrollCellWidth;

  ICnrDirectEdit                 *directEdit;
  ICnrControlDataHandler         *pHandler ;
  ICnrControlDataKeyboardHandler *pKeyboardHandler ;
  ICnrPointerSet                 pointerSet ;
  bool                           bUseSmallImages, bUseScaledImages ;
  ISize                          scaledIconSize ;
  ISize                          miniIconSize ;
  IContainerObject               *pFirstObject, *pLastObject ;

};


/*------------------------------------------------------------------------------
| ICnrIGCursor    class                                                        |
------------------------------------------------------------------------------*/
class ICnrIGCursor {
// For getting all IconGadgets in Container regardless of whether they
// are currently managed
public:
  ICnrIGCursor(IContainerControl* cnr);
 ~ICnrIGCursor();

  void
    setToFirst(),
    setToNext();

  inline bool
    isValid ( )
    {
      return ( ( curPos < numChildren )  &&  widgetList );
    }

  Widget
    current();

private:
  unsigned long
    numChildren,
    curPos;

  WidgetList
    widgetList;

  bool
    validPos;
};

/*------------------------------------------------------------------------------
| ICnrDirectEdit class                                                         |
------------------------------------------------------------------------------*/
class ICnrDirectEdit { // For managing direct edit state, etc
    friend class ICnrControlData;
  public:
    enum IObjWnd { leftDetail, rightDetail, record };
    enum EditState { editingNothing, editingDetailsView, editingDetailsHeading,
                     editingRecord, editingTitle};

    ICnrDirectEdit( ICnrControlData* );
    ~ICnrDirectEdit();

    IWindowHandle createMle();
    void editCnrTitle();
    void editColTitle( IObjWnd split,
                       IContainerColumn* col, unsigned short colIndex );
    void editObject( IObjWnd split,
                     IContainerColumn* col, unsigned short colIndex,
                     IContainerObject* obj);

    static void bbEvents( Widget widget_id, XtPointer client_data,
                           XEvent * call_data, ::Boolean *continue_to_dispatch );

    static void mleEvents( Widget widget_id, XtPointer client_data,
                           XEvent * call_data, ::Boolean *continue_to_dispatch );

    static void beginEdit(Widget w, XEvent *ev,
                          String *params, Cardinal *numParams);

  private:

    void openMle( const IString & val );
    bool mleManaged();
    void openEdit( int x, int y );
    void dismissMle();
    void deleteMle();
    void update();
    bool updateUserEntry( const IString & newtext );
    bool userDetailsEntry( char** & ppData, PFIELDINFO & pFieldInfo );
    void setupEditData( CNREDITDATA & cnrEditData );
    EditState locateForEdit( int x, int y,
                             unsigned short & colPos,
                             IContainerObject* & obj,
                             IContainerColumn* & col );
    IContainerColumn * visibleColumn( unsigned short colSequence );

    ICnrControlData* cnrControlData;
    IWindowHandle  mleText;               // XmText Widget
    IMultiLineEdit * imle;
    Widget prevFocusWidget;
    bool dismissInProgress;

    struct State {                        // direct-edit state
      State();
      void clear();

      EditState         current;
      IContainerColumn* col;
      unsigned short    colIndex;
      IContainerObject* obj;
      bool              altKeyPressed;
    } state;

    struct ICnrState {                     // direct-edit container state
      ICnrState();
      unsigned long flWindowAttr;          // from ICnrInfo
    } cnrState;
};


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICNRCTLM_ */
