// Revision: 93 1.24.2.4 source/ui/cnr/icnrctlm.cpp, container, ioc.v400, 001006 

/*******************************************************************************
* FILE NAME: icnrctlm.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation for the ICnrControlData member       *
*   functions that are called by IContainerControl::sendEvent().               *
*                                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ilanglvl.hpp>

extern "C" {
// #include <X11/IntrinsicP.h>
// #include <X11/Composite.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <X11/keysym.h>
#include <cnr.h>
#include <icong.h>
}

#include <icnrrec.hpp>
#include <icnrctlm.hpp>
#include <icnrctl.hpp>
#include <icnrobjp.hpp>
#include <icnrobj.hpp>
#include <icnrcol.hpp>
#include <iexcept.hpp>
#include <icconst.h>
#include <itrace.hpp>
#include <imstring.hpp>
#include <imle.hpp>
#include <iwinpriv.hpp>
#include <icoordsy.hpp>
#include <isizrect.hpp>
#include <imenuprv.hpp>
#include <inotifev.hpp>
#include <ibmpstat.hpp>
#include <ibmpdata.hpp>

#ifdef IC_PAGETUNE
   #define _ICNRCTLM_CPP_
   #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| Translations for invoking direct edit                                        |
------------------------------------------------------------------------------*/
static XtActionsRec editActionsTable[] =
    {
       { "BeginEdit", ICnrDirectEdit::beginEdit },
    };

static char editTranslations[] =
    "~c ~s  a <Btn1Down>: BeginEdit()\n"
    " c ~s  a <Btn1Down>: BeginEdit()"
    ;

ICnrHdrPrivateData::ICnrHdrPrivateData() :
     oldSelections(NULL),
     oldCount(0)
{
}

ICnrHdrPrivateData::~ICnrHdrPrivateData()
{
  delete [] oldSelections;
}

void ICnrHdrPrivateData::setOldSelections(WidgetList newList, int count)
{
  delete [] oldSelections;
  oldSelections = new Widget[count];
  oldCount = count;
  for (int i = 0; i < count; i++)
    oldSelections[i] = newList[i];
}

void ICnrHdrPrivateData::addToOldSelections(Widget wid)
{
  WidgetList newList = new Widget[ oldCount + 1 ];
  for( int i = 0; i < oldCount; i++ )
    newList[i] = oldSelections[i];
  newList[ i ] = wid;    // add new item

  delete [] oldSelections;
  oldSelections = newList;
  oldCount++;
}

void ICnrHdrPrivateData::removeFromOldSelections(Widget wid)
{
  int inew = 0, iold = 0;
  const int newCount = oldCount - 1;
  WidgetList newList = new Widget[ newCount ];
  while( inew < newCount )
  {
    if( oldSelections[iold] == wid )
      iold++;
    else
    {
      newList[inew] = oldSelections[iold];
      inew++; iold++;
    }
  }

  delete [] oldSelections;
  oldSelections = newList;
  oldCount = newCount;
}

/*------------------------------------------------------------------------------
| widgetInList                                                                 |
/   non-member function used for determining if selection emphasis changed     /
------------------------------------------------------------------------------*/
static bool widgetInList(Widget needle, WidgetList list, int size)
{
  for(int i = 0; i < size; i++)
    if(list[i] == needle)
       return true;
  return false;
}

/*------------------------------------------------------------------------------
| IContainerControl::handleForChildCreation                                    |
------------------------------------------------------------------------------*/
IWindowHandle IContainerControl::handleForChildCreation() const
{
   return ppd->container ;
}

/*------------------------------------------------------------------------------
| IContainerControlData::ICnrControlDataHandler                                |
------------------------------------------------------------------------------*/
ICnrControlDataHandler::ICnrControlDataHandler(ICnrControlData* pCnrCtlData)
   : IHandler()
    ,pCnrData(pCnrCtlData)
    ,ppd(new ICnrHdrPrivateData())
{
}

ICnrControlDataHandler::~ICnrControlDataHandler()
{
   if (ppd)
      delete ppd ;
}

bool ICnrControlDataHandler::dispatchHandlerEvent(IEvent& evt)
{
   bool bStopHandlingEvent(false) ;

   switch(evt.eventId())
   {
      //case xEvent(MapNotify):
      //{
      //   ITRACE_DEVELOP("IContainerControl::MapNotify") ;
      //   if (evt.parameter1().asUnsignedLong() == true ) // first time window is shown
      //      pCnrData->resizeBulletinBoard() ;
      //   break;
      //}
      case xEvent(ConfigureNotify):
      case IC_UM_SIZE:
      {
         ITRACE_DEVELOP("IContainerControl::ConfigureNotify") ;
         ISizeRectangle *sizeRect =
           (ISizeRectangle *) evt.parameter1().asUnsignedLong();
         IRectangle orect = sizeRect->oldRectangle() ;
         IRectangle nrect = sizeRect->newRectangle() ;
         ITRACE_DEVELOP("old rectangle " + orect.asString()) ;
         ITRACE_DEVELOP("width " + IString(orect.width())) ;
         ITRACE_DEVELOP("height " + IString(orect.height())) ;
         ITRACE_DEVELOP("new rectangle " + nrect.asString()) ;
         ITRACE_DEVELOP("width " + IString(nrect.width())) ;
         ITRACE_DEVELOP("height " + IString(nrect.height())) ;
         if ( sizeRect->sizeChanged() )
            pCnrData->resizeBulletinBoard() ;
         break;
      }

      case motifEvent(XmCR_INUSE_CHANGE):
      {
         IContainerObject* pcnrObj(NULL)  ;
         IContainerControl* pCnr((IContainerControl *) evt.controlWindow()) ;
         NOTIFYRECORDEMPHASIS notifyEmphasis ;
         notifyEmphasis.hwndCnr       = evt.controlWindow()->handle() ;
         notifyEmphasis.pRecord       = NULL ;
         notifyEmphasis.fAcquired     = false ;
         notifyEmphasis.fEmphasisMask = CRA_INUSE ;

         XmIconGadgetInuseEmphasisCallbackStruct* csc =
           (XmIconGadgetInuseEmphasisCallbackStruct*)(void*)evt.parameter1();
         XtVaGetValues(csc->aGadget,
                       XmNuserData, (XtPointer) &pcnrObj,
                       NULL) ;
         if (pcnrObj)
            notifyEmphasis.pRecord = (PRECORDCORE) IRecFromObj(pcnrObj) ;

         if (csc->emphasis == XmINUSE)
            notifyEmphasis.fAcquired = true ;

         pCnr->sendEvent(WM_CONTROL,
                         IEventParameter1(pCnr->id(), CN_EMPHASIS),
                         IEventParameter2(&notifyEmphasis)) ;

         bStopHandlingEvent = true ;
         break;
      }

      case motifEvent(XmCR_CURSORED_CHANGE):
      {
         IContainerObject* pcnrobj(NULL)  ;
         IContainerControl* pCnr = (IContainerControl *) evt.controlWindow() ;
         NOTIFYRECORDEMPHASIS notifyEmphasis ;
         notifyEmphasis.hwndCnr       = evt.controlWindow()->handle() ;
         notifyEmphasis.pRecord       = NULL ;
         notifyEmphasis.fAcquired     = false ;
         notifyEmphasis.fEmphasisMask = CRA_CURSORED ;

         XmContainerCursoredCallbackStruct* csc =
            (XmContainerCursoredCallbackStruct*)(void*)evt.parameter1();
         XtVaGetValues(csc->cursored_item,
                       XmNuserData, (XtPointer) &pcnrobj,
                       NULL) ;
         if (pcnrobj)
            notifyEmphasis.pRecord = (PRECORDCORE) IRecFromObj(pcnrobj) ;

         if (csc->cursored_operation == XmCURSORED_ADD)
            notifyEmphasis.fAcquired = true ;

         pCnr->sendEvent(WM_CONTROL,
                         IEventParameter1(pCnr->id(), CN_EMPHASIS),
                         IEventParameter2(&notifyEmphasis)) ;

         bStopHandlingEvent = true ;
         break;
      }

      case motifEvent(XmCR_DEFAULT_ACTION):
      {
         IContainerControl* pCnr = (IContainerControl *) evt.controlWindow() ;
         NOTIFYRECORDENTER notifyEnter ;
         notifyEnter.hwndCnr = evt.controlWindow()->handle() ;
         notifyEnter.fKey    = false ;
         notifyEnter.pRecord = NULL ;

         XmContainerSelectCallbackStruct* csc =
           (XmContainerSelectCallbackStruct*)(void*)evt.parameter1();
         XEvent *pXEvent = csc->event ;
         if (pXEvent)
            if (pXEvent->xany.type == KeyPress | pXEvent->xany.type == KeyRelease)
            {
               XKeyEvent *pKeyEvent = &(pXEvent->xkey) ;
               KeySym keySym ;
               XLookupString( pKeyEvent, NULL, 0, &keySym, NULL );
               if (keySym == XK_Return)
                  notifyEnter.fKey = true ;
            }

         IContainerObject* pObj(NULL);
         XtVaGetValues(csc->selected_items[0],
                       XmNuserData, (XtPointer)&pObj,
                       NULL);
         if (pObj)
            notifyEnter.pRecord = (PRECORDCORE) IRecFromObj(pObj) ;

         pCnr->sendEvent( WM_CONTROL,
                          IEventParameter1( pCnr->id(), CN_ENTER ),
                          IEventParameter2( &notifyEnter ));

         //if (pwndControl->isEnabledForNotification())                  /* LJO */
         //   pwndControl->notifyObservers(INotificationEvent(           /* LJO */
         //                                IContainerControl::enterId,   /* LJO */
         //                                *pwndControl,true,            /* LJO */
         //                                (void*)&cenevt));             /* LJO */

         bStopHandlingEvent = true ;
         break;
      }

      case motifEvent(XmCR_SINGLE_SELECT):
      case motifEvent(XmCR_BROWSE_SELECT):
      case motifEvent(XmCR_MULTIPLE_SELECT):
      case motifEvent(XmCR_EXTENDED_SELECT):
      {
         int i;
         IContainerControl* pCnr((IContainerControl *) evt.controlWindow()) ;
         IContainerObject* pcnrobj(NULL) ;
         NOTIFYRECORDEMPHASIS notifyEmphasis ;
         notifyEmphasis.hwndCnr       = evt.controlWindow()->handle() ;
         notifyEmphasis.pRecord       = NULL ;
         notifyEmphasis.fAcquired     = false ;
         notifyEmphasis.fEmphasisMask = CRA_SELECTED ;

         XmContainerSelectCallbackStruct* csc =
            (XmContainerSelectCallbackStruct*)(void*)evt.parameter1();

         if( csc->select_operation == XmSELECT_ADD )
         {
            // Items are added to selected list without invoking
            // selectedChanged.
            for(i=0; i < csc->selected_item_count; i++)
               if (!widgetInList( csc->selected_items[i],
                                  ppd->oldSelections,
                                  ppd->oldCount))
               {
                  // add to list
                  ppd->addToOldSelections(csc->selected_items[i]);
               }
         } // XmSELECT_ADD
         else if( csc->select_operation == XmSELECT_REMOVE )
         {
            // Items are removed from selected list without invoking
            // selectedChanged.
            for(i=0; i < csc->selected_item_count; i++)
               if (widgetInList( csc->selected_items[i],
                                 ppd->oldSelections,
                                 ppd->oldCount))
               {
                  // remove from list
                  ppd->removeFromOldSelections(csc->selected_items[i]);
               }
         } // XmSELECT_REMOVE
         else   // XmSELECT_CHANGE
         {
            // handle each widget that lost emphasis
            for(i=0; i < ppd->oldCount; i++)
               if (!widgetInList(ppd->oldSelections[i],
                                 csc->selected_items,
                                 csc->selected_item_count))
               {
                  // Sorry, but if an object was removed from the container
                  // ppd->oldSelections[i] could be referencing a Widget
                  // that was destroyed
                  WidgetList conChildren;
                  int conChildrenCount;
                  XtVaGetValues(pCnr->handleForChildCreation(),
                                XmNchildren, &conChildren,
                                XmNnumChildren, &conChildrenCount, NULL);
                  // d8175 - Check for widget being destroyed.
                  // if (widgetInList(ppd->oldSelections[i],
                  //                  conChildren,
                  //                  conChildrenCount))
                  if (widgetInList(ppd->oldSelections[i],
                                   conChildren,
                                   conChildrenCount)
                      && ! XuiclIsGadgetBeingDestroyed(ppd->oldSelections[i]))
                  {
                     XtVaGetValues(ppd->oldSelections[i],
                                   XmNuserData, (XtPointer)&pcnrobj,
                                   NULL);
                     if (pcnrobj)
                        notifyEmphasis.pRecord = (PRECORDCORE) IRecFromObj(pcnrobj) ;

                     notifyEmphasis.fAcquired = false ;

                     pCnr->sendEvent( WM_CONTROL,
                                      IEventParameter1( pCnr->id(), CN_EMPHASIS ),
                                      IEventParameter2( &notifyEmphasis ));

                  }
               } // for lost emphasis loop

            // handle each widget that is acquiring emphasis
            for(i=0; i < csc->selected_item_count; i++)
               if (!widgetInList(csc->selected_items[i],
                                 ppd->oldSelections,
                                ppd->oldCount))
            {
               XtVaGetValues(csc->selected_items[i],
                             XmNuserData, (XtPointer)&pcnrobj,
                             NULL);
               if (pcnrobj)
                  notifyEmphasis.pRecord = (PRECORDCORE) IRecFromObj(pcnrobj) ;

               notifyEmphasis.fAcquired = true ;

               pCnr->sendEvent( WM_CONTROL,
                                IEventParameter1( pCnr->id(), CN_EMPHASIS ),
                                IEventParameter2( &notifyEmphasis ));

            } // for acquiring emphasis loop

           // save current selected items for next time through
           ppd->setOldSelections(csc->selected_items,
                                 csc->selected_item_count);

         } // XmSELECT_CHANGE

         bStopHandlingEvent = true ;
         break;
      }

      case motifEvent(XmCR_COLLAPSED):
      case motifEvent(XmCR_EXPANDED):
      {
         // dismiss direct-edit mle if its up
         pCnrData->dismissMle();

         IContainerControl* pCnr = (IContainerControl *) evt.controlWindow() ;
         IContainerObject* pcnrobj(NULL);
         IMiniCnrRecord* pRec(NULL) ;

         XmContainerOutlineCallbackStruct* coc =
            (XmContainerOutlineCallbackStruct*)(void*)evt.parameter1();
         XtVaGetValues(coc->item,
                       XmNuserData, (XtPointer)&pcnrobj,
                       NULL);
         if (pcnrobj)
            pRec = IRecFromObj(pcnrobj) ;

         unsigned short messageId(CN_EXPANDTREE) ;
         if (evt.eventId() == motifEvent(XmCR_COLLAPSED))
            messageId = CN_COLLAPSETREE ;

         pCnr->sendEvent( WM_CONTROL,
                          IEventParameter1( pCnr->id(), messageId ),
                          IEventParameter2( pRec ));

         bStopHandlingEvent = true ;
         break;
      }

      case motifEvent(XmCR_HELP):
      {
         IContainerControl* pCnr = (IContainerControl *) evt.controlWindow() ;
         IContainerObject* pcnrobj(NULL);
         IMiniCnrRecord* pRec(NULL) ;

         pcnrobj = pCnr->currentEditObject();
         if (! pcnrobj)
            pcnrobj = pCnr->cursoredObject() ;
         if (pcnrobj)
            pRec = IRecFromObj(pcnrobj) ;
         else
            pRec = (IMiniCnrRecord *) -1 ;

         pCnr->sendEvent( WM_CONTROL,
                          IEventParameter1( pCnr->id(), CN_HELP ),
                          IEventParameter2( pRec ));

         bStopHandlingEvent = true ;
         break;
      }

      default:
         break;
   } // switch

   return bStopHandlingEvent ;
} // dispatchEventHandler

/*------------------------------------------------------------------------------
| IContainerControlData::ICnrControlDataKeyboardHandler                        |
------------------------------------------------------------------------------*/
ICnrControlDataKeyboardHandler::ICnrControlDataKeyboardHandler(ICnrControlData* pCnrCtlData)
   : IKeyboardHandler()
    ,pCnrData(pCnrCtlData)
{
}

ICnrControlDataKeyboardHandler::~ICnrControlDataKeyboardHandler()
{
}

bool ICnrControlDataKeyboardHandler::virtualKeyPress(IKeyboardEvent& evt)
{
      // enter key is being eaten by one of the widgets we put on top of XmContainer
      // bypass the lot by using this handler
      IKeyboardEvent::VirtualKey aKey = evt.virtualKey() ;
      if (aKey == IKeyboardEvent::enter)
      {
         XEvent* pXEvent = (XEvent *) (void *) evt.parameter2() ;
         XtCallActionProc(pCnrData->container,
                          "ContainerActivate",
                          pXEvent,
                          NULL,
                          0 ) ;
      }
   return false ;
}

/*------------------------------------------------------------------------------
| ICnrControlData::setRefreshOn                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::setRefreshOn(bool bRefreshState)
{
   if (bRefreshState)
      XtVaSetValues(container, XmNrefreshCnr, ::True, NULL)  ;
   else
      XtVaSetValues(container, XmNrefreshCnr, ::False, NULL)  ;
}

/*------------------------------------------------------------------------------
| ICnrControlData::refresh                                                     |
------------------------------------------------------------------------------*/
void ICnrControlData::refresh()
{
   // This code does nothing but waste cycles right now since
   // invalidateRecord() doesn't process cma_noreposition right now.
   // leave this be until I have more to investigate
   /* We need to ensure that any filtered/unfiltered records get */
   /* processed correctly, but we don't want a double paint.     */
   theIContainer->sendEvent(CM_INVALIDATERECORD,0,
             MPFROM2SHORT(0,CMA_NOREPOSITION));

   /*********************************************************************/
   /* Because the CM_INVALIDATERECORD call sometimes has problems       */
   /* updating the scroll bars in details view, and because the external*/
   /* container recordcore is copied internally by the invalidation     */
   /* above, it is safe to use CM_INVALIDATEDETAILFIELDINFO to simply   */
   /* refresh the screen and alleviate the scrollbar problems.          */
   /*********************************************************************/
   theIContainer->sendEvent(CM_INVALIDATEDETAILFIELDINFO);
   unsigned long  fsFlags = CMA_REPOSITION | CMA_ERASE;
   theIContainer->sendEvent(CM_INVALIDATERECORD,0,
                MPFROM2SHORT(0,fsFlags));
} // refresh

// Following functions and their equivalents in ICnrObjPrivateData
// are to support IContainer::Cursor.
// If we have filtering on, filtered objects are unmanaged by Motif
// so the regular way of getting the objects set via XmNchildren
// does not work.
// see the comments for ICnrControlData::getRecord for a complete description
/*------------------------------------------------------------------------------
| ICnrControlData::lastObject(IContainerObject*)                               |
------------------------------------------------------------------------------*/
void ICnrControlData::lastObject(IContainerObject* pCnrObj)
{
   pLastObject = pCnrObj ;
   if (pFirstObject == NULL) 
      pFirstObject = pCnrObj ;
} // lastObject(pCnrObj)

/*------------------------------------------------------------------------------
| ICnrControlData::lastObject                                                  |
------------------------------------------------------------------------------*/
IContainerObject* ICnrControlData::lastObject()
{
   return pLastObject ;
} // lastObject

/*------------------------------------------------------------------------------
| ICnrControlData::firstObject                                                 |
------------------------------------------------------------------------------*/
IContainerObject* ICnrControlData::firstObject()
{
   return pFirstObject ;
} // firstObject

/*------------------------------------------------------------------------------
| ICnrControlData::firstObject(IContainerObject*)                              |
------------------------------------------------------------------------------*/
void ICnrControlData::firstObject(IContainerObject* pCnrObj)
{
   pFirstObject = pCnrObj ;
   if (pLastObject == NULL) 
      pLastObject = pCnrObj ;
} // firstObject(pCnrObj)

/*------------------------------------------------------------------------------
| resizeIcon                                                                   |
------------------------------------------------------------------------------*/
bool ICnrControlData::resizeIcon(const IContainerObject& cnrObj, const ISize& iconSize)
{
   IFUNCTRACE_DEVELOP() ;

   bool bSuccess(false) ;

   IContainerObject* pCnrObj = (IContainerObject*) &cnrObj ;  // cast away the const
   Widget gadgetH = IGadgetFromObj(pCnrObj, theIContainer, 0) ;
   if (gadgetH)
   {
      IPointerHandle cnrObjPix ;
      if (theIContainer->isInUse(pCnrObj))
         cnrObjPix = pCnrObj->inUseIcon() ;    // TODO : find a better way to
      else                                     // get currently used icon
         cnrObjPix = pCnrObj->icon() ;
      if (cnrObjPix)
      {
         IPointerHandle newIconH =
            IBitmapStaticPtr::sizePointerTo(cnrObjPix, iconSize) ;
         if (newIconH)
         {
            Arg args[5] ;
            int n(0) ;
            pointerSet.addPointerElement(newIconH, gadgetH) ;
            Pixmap shapeMask = IBitmapStaticPtr::shapeMaskFor(newIconH) ;
            if (shapeMask)
            {
               XtSetArg(args[n], XmNlargeIconMask, shapeMask) ; n++ ;
               XtSetArg(args[n], XmNsmallIconMask, shapeMask) ; n++ ;
            }
            XtSetArg(args[n], XmNlargeIconPixmap, newIconH) ; n++ ;
            XtSetArg(args[n], XmNsmallIconPixmap, newIconH) ; n++ ;
            XmContainerRelayout(container);
            XtSetValues(gadgetH, args, n) ;
            bSuccess = true ;
         }
      }
   }
   return bSuccess ;
} // resizeIcon

/*------------------------------------------------------------------------------
| resetIconSize                                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::resetIconSize(const IContainerObject& cnrObj)
{
   IFUNCTRACE_DEVELOP() ;
   if (bUseSmallImages)
      resizeIcon(cnrObj, miniIconSize) ;
   else if (bUseScaledImages)
      resizeIcon(cnrObj, scaledIconSize) ;
} // resetIconSize

/*------------------------------------------------------------------------------
| showMiniIcons                                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::showMiniIcons()
{
   IFUNCTRACE_DEVELOP() ;

   if (! bUseSmallImages)
   {
      ISize miniSize(20,20) ;
      showStretchedIcons(miniSize) ;
      bUseSmallImages  = true  ;
      bUseScaledImages = false ;
   }
} // showMiniIcons

/*------------------------------------------------------------------------------
| showScaledIcons                                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::showScaledIcons(const ISize& scaledSize)
{
   IFUNCTRACE_DEVELOP() ;

   if (bUseScaledImages                              &&
       scaledIconSize.width()  == scaledSize.width() &&
       scaledIconSize.height() == scaledSize.height()  )
      return ;

   scaledIconSize.setWidth(scaledSize.width()) ;
   scaledIconSize.setHeight(scaledSize.height()) ;
   showStretchedIcons(scaledIconSize) ;
   bUseSmallImages  = false  ;
   bUseScaledImages = true ;
} // showScaledIcons

/*------------------------------------------------------------------------------
| showStretchedIcons                                                           |
------------------------------------------------------------------------------*/
void ICnrControlData::showStretchedIcons(const ISize& iconSize)
{
   IFUNCTRACE_DEVELOP() ;

   IContainerControl::ObjectCursor cursor(*theIContainer) ;

   for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
      resizeIcon(*(cursor.current()), iconSize) ;

} // showStretchedIcons

/*------------------------------------------------------------------------------
| showLargeIcons                                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::showLargeIcons()
{
   IFUNCTRACE_DEVELOP() ;

   if ( bUseSmallImages )
   {
      IContainerControl::ObjectCursor cursor(*theIContainer) ;

      Arg args[5] ;
      int n(0) ;
      for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
      {
         n = 0 ;
         IContainerObject* pCnrObj = cursor.current() ;
         Widget gadgetH = IGadgetFromObj(pCnrObj, theIContainer, 0) ;
         IPointerHandle newIcon ;
         if (theIContainer->isInUse(pCnrObj))
            newIcon = pCnrObj->inUseIcon() ;
         else
            newIcon = pCnrObj->icon() ;
         Pixmap shapeMask = IBitmapStaticPtr::shapeMaskFor(newIcon) ;
         if (shapeMask)
         {
            XtSetArg(args[n], XmNlargeIconMask, shapeMask) ; n++ ;
            XtSetArg(args[n], XmNsmallIconMask, shapeMask) ; n++ ;
         }
         XtSetArg(args[n], XmNlargeIconPixmap, newIcon) ; n++ ;
         XtSetArg(args[n], XmNsmallIconPixmap, newIcon) ; n++ ;
         XtSetValues(gadgetH, args, n) ;
      }
      bUseSmallImages  = false ;
      bUseScaledImages = false ;
      pointerSet.empty() ;
   }
} // showLargeIcons

/*------------------------------------------------------------------------------
| titleRectangle                                                               |
------------------------------------------------------------------------------*/
IRectangle ICnrControlData::titleRectangle()
{
   if (XtIsManaged(titleLabel))
   {
      Dimension width(0), height(0) ;
      XtVaGetValues(titleLabel,
                    XmNwidth  , &width,
                    XmNheight , &height,
                    NULL) ;
      XPoint origin ; origin.x = 0 ; origin.y = 0 ;
      XPoint opposite ; opposite.x = width ; opposite.y = height ;
      return IRectangle(xToWinCoords(origin  , &titleLabel),
                        xToWinCoords(opposite, &titleLabel) ) ;
   }
   else
      return IRectangle() ;
} // titleRectangle

/*------------------------------------------------------------------------------
| detailsTitleRectangle                                                        |
------------------------------------------------------------------------------*/
IRectangle ICnrControlData::detailsTitleRectangle()
{
   if (theIContainer->isDetailsView())
   {
      XRectangle rect ;
      XuiclDetailsTitleRectangle(container, &rect) ;
      //if (theIContainer->isTitleVisible())
      //   rect.y += (theIContainer->titleRectangle()).height() ;
      return xToWinCoords(rect) ;
   }
   else
      return IRectangle() ;
} // detailsTitleRectangle

/*------------------------------------------------------------------------------
| setLineSpacing                                                               |
------------------------------------------------------------------------------*/
void ICnrControlData::setLineSpacing(long lLineSpacing)
{
   XtVaSetValues(container,
                 XmNdetailsLineSpacing, lLineSpacing,
                 NULL) ;
} // setLineSpacing

/*------------------------------------------------------------------------------
| setWindowAttr                                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::setWindowAttr(unsigned long flags)
{
  Arg            args[15];
  int            n = 0;
  // Need Motif Boolean, not ICLUI.  LJO
  ::Boolean      needArrange;                                  /* LJO */

  // For now, don't need to check for CV_FLOW since we've
  // hard-coded the GRID place style in createContainer

  if (flags & CV_TREE)
  {
    XtSetArg(args[n], XmNlayoutType, XmOUTLINE); n++;
    if( flags & CV_DETAIL )
    {
      // Setting SMALL_ICON keeps us out of detail tree view (possible
      // with the Container widget but not defined in UICL).
      // SMALL_ICON also matches the PM tree view layouts
      XtSetArg(args[n], XmNentryViewType, XmSMALL_ICON); n++;
    }
  }
  else
  {
    XtSetArg(args[n], XmNlayoutType, XmSPATIAL); n++;
  }

  if (flags & CV_DETAIL)
  {
    XtSetArg(args[n], XmNentryViewType, XmDETAIL); n++;
  }

  if (flags & CV_ICON)
  {
    XtSetArg(args[n], XmNentryViewType, XmLARGE_ICON); n++;
    XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
    // In treeIcon view, both CV_TREE and CV_ICON are set.  We only want
    // placeStyle set to XmNONE for pure CV_ICON.
    if (flags & CV_TREE)                                              /* LJO */
    {                                                                 /* LJO */
       XtSetArg(args[n], XmNplaceStyle, XmGRID); n++;                 /* LJO */
    }                                                                 /* LJO */
    else                                                              /* LJO */
    {                                                                 /* LJO */
       // If autoPosition is on, we need the grid style; otherwise,
       // free for all (XmNONE).
       if (ulStyle & CCS_AUTOPOSITION)                                /* LJO */
       {                                                              /* LJO */
          XtSetArg(args[n], XmNplaceStyle, XmGRID); n++;                 /* LJO */
       }                                                              /* LJO */
       else                                                           /* LJO */
       {                                                              /* LJO */
          XtSetArg(args[n], XmNplaceStyle, XmNONE); n++;                 /* LJO */
       }                                                              /* LJO */
    }                                                                 /* LJO */
  }                                                                   /* LJO */
  else                                                                /* LJO */
  // All views except CV_ICON use grid style.
  {                                                                   /* LJO */
     XtSetArg(args[n], XmNplaceStyle, XmGRID); n++;                    /* LJO */
  }                                                                   /* LJO */

  if (flags & CV_NAME )
  {
    XtSetArg(args[n], XmNentryViewType, XmSMALL_ICON); n++;
    XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
    // Placeholder for if we decide to support CV_FLOW.
    if (flags & CV_FLOW)                                              /* LJO */
    {                                                                 /* LJO */
    }                                                                 /* LJO */
    else                                                              /* LJO */
    {                                                                 /* LJO */
    }                                                                 /* LJO */
  }

  if (flags & CV_TEXT )
  {
    /* Defect 4704.
     * Was setting XmLARGE_ICON here - caused hide/show tree lines
     * to switch to treeIconView from treeTextView.
     */
    XtSetArg(args[n], XmNentryViewType, XmSMALL_ICON); n++;
    XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
    // Placeholder for if we decide to support CV_FLOW.
    if (flags & CV_FLOW)                                              /* LJO */
    {                                                                 /* LJO */
    }                                                                 /* LJO */
    else                                                              /* LJO */
    {                                                                 /* LJO */
    }                                                                 /* LJO */
    XtSetArg(args[n], XmNshowTextView, True); n++;
  }
  else
  {
    XtSetArg(args[n], XmNshowTextView, False); n++;
  }

  if (flags & CA_TREELINE)
  {
     XtSetArg(args[n], XmNoutlineLineStyle, XmSINGLE); n++;
  }
  else
  {
     XtSetArg(args[n], XmNoutlineLineStyle, XmNO_LINE); n++;
  }

  if (flags & CA_DETAILSVIEWTITLES)
  {
     if (!(flWindowAttr & CA_DETAILSVIEWTITLES))
     {
        flWindowAttr |= CA_DETAILSVIEWTITLES;
        updateColumns();
     }
  }
  else
  {
     if (flWindowAttr & CA_DETAILSVIEWTITLES)
     {
        flWindowAttr &= ~CA_DETAILSVIEWTITLES;
        updateColumns();
     }
  }

  XtSetValues(container, args, n);
  // Check to see if we need to do an arrange after changing the view.
  // We shouldn't have to check the view - it should be set correctly.
  // Be sure to check == True since this is the Motif Boolean type.
  XtVaGetValues (container, XmNneedArrange, &needArrange, NULL);  /* LJO */
  if (needArrange == True)                             /* LJO */
     arrangeIconView();                                /* LJO */

  if (flags & CA_CONTAINERTITLE)
  {
     if (! XtIsManaged(titleLabel))
     containerManagement(ICnrControlData::SHOW_TITLE);
  }
  else
  {
     if (XtIsManaged(titleLabel))
     containerManagement(ICnrControlData::HIDE_TITLE);
  }

  if (flags & CA_TITLEREADONLY)
     flWindowAttr |= CA_TITLEREADONLY ;
  else
     flWindowAttr &= ~CA_TITLEREADONLY ;

  if (flags & CV_MINI)
  {
     showMiniIcons() ;
     flWindowAttr |= CV_MINI ;
  }
  else
  {
     showLargeIcons() ;
     flWindowAttr &= ~CV_MINI ;
  }

  if (titleLabel) {

     if (flags & CA_TITLELEFT)
        XtVaSetValues(titleLabel,
                      XmNalignment, XmALIGNMENT_BEGINNING,
                      NULL);
     else if (flags & CA_TITLERIGHT)
        XtVaSetValues(titleLabel,
                      XmNalignment, XmALIGNMENT_END,
                      NULL);
     else if (flags & CA_TITLECENTER)
        XtVaSetValues(titleLabel,
                      XmNalignment, XmALIGNMENT_CENTER,
                      NULL);

  }

} // setWindowAttr

/*------------------------------------------------------------------------------
| updateColumns                                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::updateColumns()
{
  // update the column headings
  unsigned long numCols = columnSeq.numberOfElements();
  if (numCols != 0)             // ER - wanted to eliminate this check
                                // Doing so causes problems if columns added
                                // after objects
  {
    // Allocate an XmStringTable for setting Container detailColumnHeading
    XmStringTable strTable =
      (XmStringTable) new char[numCols * sizeof(XmString)];

    ColumnSequenceType::Cursor cursor(columnSeq);
    int visibleCols = 0;
    for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
    {
       IContainerColumn* curCol = columnSeq.elementAt(cursor);
       if (curCol->isVisible())
         strTable[visibleCols++] =
           XmStringCreateLtoR(curCol->headingText(), XmFONTLIST_DEFAULT_TAG);
    }
    // Set the Container's detailColumnHeading and detailCount resources
    // Note: this is the spot where we set XmNdetailCount, updateEntryDetail()
    // that is called below only affects IconGadget's entryDetail constraint
    // resource
    if (visibleCols > 0)
    {
      XtVaSetValues(container,
                    XmNdetailCount, visibleCols,
                    XmNdetailColumnHeading,
                      (flWindowAttr & CA_DETAILSVIEWTITLES) ? strTable : NULL ,
                    NULL);
      // free the storage used by the XmStringTable
      for (int i=0; i<visibleCols; i++)
        XmStringFree(strTable[i]);
    }
    delete [] strTable;
  }

  // Now for something really ugly
  // Since we just changed the columns, if there are exising root IconGadgets
  // in the Container already, we have to update their entryDetail resources.
  Widget     curIconG, parent;
  IContainerObject* pObj;

  ICnrIGCursor cursor(theIContainer);
  for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
  {
    curIconG = cursor.current();
    XtVaGetValues(curIconG,
                  XmNentryParent, &parent,
                  XmNuserData, &pObj,
                  NULL);
    if(parent==NULL)
      pObj->ppd->updateEntryDetail(theIContainer);
  }
}

/* LJO next function */
/*------------------------------------------------------------------------------
| arrangeIconView                                                              |
------------------------------------------------------------------------------*/
void ICnrControlData::arrangeIconView()
{
   // If we're visible, do the arrange; otherwise, set the flag so it will
   // be done later when we're shown.

   //if (theIContainer->isVisible())
   if (theIContainer->isShowing())
   {
      unsigned char place_style;
      XtVaGetValues (container, XmNplaceStyle, &place_style, NULL );

      // Likewise, if we're not in icon view, set the flag so we will arrange
      // later when the view is switched.

      if (place_style == XmNONE)
      {
         // If autoposition style is on, we don't need to do an arrange - its
         // already done.

         if(!(ulStyle & CCS_AUTOPOSITION))
         {
            // Trick the widget into doing a grid relayout by changing the
            // place style temporarily and then back.

            XtVaSetValues(container, XmNplaceStyle, XmGRID,
                                     NULL);
            bool  currentState = theIContainer->isRefreshOn();
            theIContainer->setRefreshOn();
            XmContainerRelayout(container);
            theIContainer->setRefreshOn(currentState);
            XtVaSetValues(container, XmNplaceStyle, XmNONE,
                                     XmNneedArrange, False,
                                     NULL);
         }
      }
      else
         XtVaSetValues(container, XmNneedArrange, True, NULL);
   }
   else
      XtVaSetValues(container, XmNneedArrange, True, NULL);
}

/*------------------------------------------------------------------------------
| updateFont                                                                   |
------------------------------------------------------------------------------*/
void ICnrControlData::updateFont( const IWindowHandle & cnrhandle,
                                  XmFontList fontList )
{
  // This is a helper method for ifontSetWidgetFontList()
  IContainerControl * icnr =
          (IContainerControl*)IWindow::windowWithHandle( cnrhandle );

  // d8175 - Check for icnr null.  cnrhandle's window may be gone by now.
  if ( icnr )
   {
    ICnrControlData * This = icnr->ppd;

    This->dismissMle();

    if( This->titleLabel )
        XtVaSetValues( This->titleLabel, XmNfontList, fontList, NULL );

    // update the column headings
    This->updateColumns();

#if DETECT_OVERFLOW
    This->overflow.check( This->theIContainer );
#endif
   }
}

/*------------------------------------------------------------------------------
| removeRecord                                                                 |
------------------------------------------------------------------------------*/
void ICnrControlData::removeRecord(IMiniCnrRecord** ppcnrrec,
                                   unsigned long removeNum,
                                   unsigned long flags)
{
   IContainerObject* pObj;

   if(removeNum==0)
   {
     ITRACE_DEVELOP(IString("REMOVERECORDS: all"));
     // Delete all objects from the Container
     WidgetList widgetList = NULL;
     int rootItems = XmContainerGetItemChildren(container,
                                                NULL, &widgetList);
     for(int i = 0; i < rootItems; i++)
     {
       pObj = IObjFromGadget(widgetList[i]);
       // removeFromCnr will recursively delete all children of this item
       pObj->ppd->removeFromCnr(theIContainer,flags);
     }
     if( widgetList ) XtFree( (char*)widgetList );
   }
   else
   {
     // The address of the IMiniCnrRecord is passed
     // to support deleteing an array of IMiniCnrRecord's.
     // The common code currently passes 0 or 1 as the removeNum but
     // doesn't hurt to support this in case the PM or Windows guys
     // change the common .cpp files.

     for(int i = 0; i < removeNum; i++)
     {
       pObj = IObjFromRec(ppcnrrec[i]);
       // removeFromCnr will recursively delete all children of this item
       pObj->ppd->removeFromCnr(theIContainer,flags);
     }
   }
}

/*------------------------------------------------------------------------------
| setCnrInfo                                                                   |
------------------------------------------------------------------------------*/
void ICnrControlData::setCnrInfo(ICnrInfo* pcnrInfo, unsigned long setFlag)
{
  IFUNCTRACE_DEVELOP() ;

  Arg args[10];
  int n = 0;

  if (setFlag & CMA_FLWINDOWATTR)
  {
      setWindowAttr(pcnrInfo->flWindowAttr);
  }

  if (setFlag & CMA_CXTREEINDENT)
  {
    XtSetArg(args[n], XmNoutlineIndentation, pcnrInfo->cxTreeIndent); n++;
  }

  if (setFlag & CMA_TREEICON)
  {
    XtSetArg(args[n], XmNcollapsedStatePixmap, pcnrInfo->hptrCollapsed); n++;
    XtSetArg(args[n], XmNexpandedStatePixmap, pcnrInfo->hptrExpanded); n++;
  }

  // There are other CMA_ flags we may support in the future

  XtSetValues(container, args, n); n = 0;

  if (setFlag & CMA_CNRTITLE)
  {
    XmString title = XmStringCreateLtoR((char*)pcnrInfo->strCnrTitle,
                                         XmFONTLIST_DEFAULT_TAG);

    XtVaSetValues(titleLabel,
                  XmNlabelString, title,
                  NULL);

    XmStringFree(title);

    if (XtIsManaged(titleLabel))
       resizeBulletinBoard() ; // force a relayout. Sometimes after a
                               // direct edit of the title, the form
                               // widget does not know that the title widget
                               // has changed and things get relaid out to
                               // minimumSize ...

    theIContainer->notifyObservers(INotificationEvent(
                                   IContainerControl::titleId,
                                   *theIContainer, true,
                                   (char *) pcnrInfo->strCnrTitle));
  }

  if (setFlag & CMA_LINESPACING)
     setLineSpacing(pcnrInfo->cyLineSpacing) ;

  if (setFlag & CMA_SLBITMAPORICON)
  {
     ISize iconSize(pcnrInfo->slBitmapOrIcon.cx,
                    pcnrInfo->slBitmapOrIcon.cy ) ;
     showScaledIcons(iconSize) ;
  }
}

/*------------------------------------------------------------------------------
| queryRecordEmphasis                                                          |
------------------------------------------------------------------------------*/
IEventResult ICnrControlData::queryRecordEmphasis(unsigned long whichOne,
                                                  unsigned long whichEmphasis)

// return IMiniCnrRecord for first selected object
// showSourceEmphasis(false) in icnrctl7.cpp uses this with CRA_CURSORED
// as a PM workaround. We don't need to support this here (can't anyway).
// In the PM API, mp1 could contain an IMiniCnrRecord* that indicates
// where we should start looking in the Container. This would be very
// inefficient to implement under Motif, but fortunately this interface
// is not currently used by any of the Container classes. If it's ever
// added to the PM icnr*.cpp files, we will hit the following Assert.
{
   IASSERTPARM(whichOne == CMA_FIRST && whichEmphasis == CRA_SELECTED);
   IMiniCnrRecord* pRec = getFirstSelected(NULL);
   return IEventResult(pRec);
}

/*------------------------------------------------------------------------------
| setDetailInfo                                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::setDetailInfo(PFIELDINFO pfldinfo,
                                    PFIELDINFOINSERT pfldinfoinsert)
{
  // Note that we have to use offsetof macro below, rather than
  // IContainerObject::iconOffset() or IContainerObject::iconTextOffset().
  // Have to do this because addColumn() subtracts IFIELDINBASE from
  // offStruct before calling us.

  unsigned long offset = pfldinfo->offStruct;
  IContainerColumn* curCol = (IContainerColumn*)pfldinfo->pUserData;

  if (offset == ((size_t) &(((IMiniCnrRecord *)0)->hptrIcon)))
  {
      ::Boolean bIconCol(False) ;
      XtVaGetValues(container, XmNshowIconInDetail, &bIconCol, NULL) ;
      if (bIconCol)
      {
         ITHROWGUIERROR("Already have an icon column") ;
      }

      columnSeq.addAsFirst(curCol);
      XtVaSetValues(container, XmNshowIconInDetail, True, NULL);
  }
  else
    if (pfldinfoinsert->pFieldInfoOrder == (PFIELDINFO)CMA_END)
    {
      columnSeq.addAsLast(curCol);
    }
    else  // insert after specified column
    {
      IContainerColumn* afterCol =
        (IContainerColumn*)pfldinfoinsert->pFieldInfoOrder->pUserData;
      ColumnSequenceType::Cursor cursor(columnSeq);
      for(cursor.setToFirst();
          cursor.isValid() && columnSeq.elementAt(cursor) != afterCol;
          cursor.setToNext());

      if(cursor.isValid())
      {
        columnSeq.addAsNext(curCol, cursor);
      }
      else
        ITHROWGUIERROR("Tried to addColumn() after non-existant column");
    }

    updateColumns();

}

/*------------------------------------------------------------------------------
| queryDetailInfo                                                              |
------------------------------------------------------------------------------*/
PFIELDINFO ICnrControlData::queryDetailInfo(PFIELDINFO pfldinfo,
                                            unsigned short cmd)
{
    ColumnSequenceType::Cursor cursor(columnSeq);

  #ifndef CMA_DATAWIDTH // see icnrctlm2.cpp(IContainerColumn::displayWidth())
    #define CMA_DATAWIDTH  0X0200
  #endif

    switch (cmd)
    {
        case CMA_FIRST:
        {
            cursor.setToFirst();
            break;
        }

        case CMA_LAST:
        {
            cursor.setToLast();
            break;
        }

        case CMA_PREV:
        case CMA_NEXT:
        {

            IContainerColumn* searchCol =(IContainerColumn*)pfldinfo->pUserData;

            for( cursor.setToFirst();
                 cursor.isValid() && columnSeq.elementAt(cursor) != searchCol;
                 cursor.setToNext());

            if(cursor.isValid())
            {
                // found

                if (cmd == CMA_PREV)
                    cursor.setToPrevious();
                else
                    cursor.setToNext();
            }
            break;
        }

        case CMA_DATAWIDTH:
        {
            IContainerColumn* searchCol =(IContainerColumn*)pfldinfo->pUserData;
            int visibleCol;

            for( cursor.setToFirst(), visibleCol=0;
                 cursor.isValid() && columnSeq.elementAt(cursor) != searchCol;
                 cursor.setToNext())
            {
                if( columnSeq.elementAt(cursor)->isVisible() ) visibleCol++;
            }

            if(cursor.isValid())
            {
                // found, use visible col no to return display width
                // Note: the return data type does not match the default
                //       type. This is poor practice, but go with it for
                //       now.

                unsigned long width = XuiclTabWidth( container, visibleCol );

                return (PFIELDINFO)width;
            }
            break;
        }

        default:
        {
            return 0;
        }
    } // end switch

    if(cursor.isValid())
    {
        return columnSeq.elementAt(cursor)->columnInfo();
    }

    return 0;
}

/*------------------------------------------------------------------------------
| removeDetailInfo                                                             |
------------------------------------------------------------------------------*/
int  ICnrControlData::removeDetailInfo(PFIELDINFO *pfldinfoArr,
                                        unsigned long removeNum,
                                        unsigned long flags)
{
  IFUNCTRACE_DEVELOP();

  PFIELDINFO pfldinfo;
  long  ret=0;

  if(removeNum==0)
  {
    // Remove all
    ColumnSequenceType::Cursor cursor(columnSeq);

    // Have to keep setting to first to maintain valid cursor because
    // we are doing removes
    for (cursor.setToFirst(); cursor.isValid(); cursor.setToFirst())
      columnSeq.removeAt(cursor);
    // If we had been showing the icon, we aren't anymore
    XtVaSetValues(container, XmNshowIconInDetail, False, NULL);
  }
  else
  {
    // Remove given array elements

    if (!pfldinfoArr)
    {
      ITRACE_DEVELOP(IString("got NULL pfldinfoArr[]"));
      return -1;
    }

    for (int i=0; i<removeNum; i++)
    {
      pfldinfo = pfldinfoArr[i];
      unsigned long offset = pfldinfo->offStruct;

      IContainerColumn* removeCol = (IContainerColumn*)pfldinfo->pUserData;
      ColumnSequenceType::Cursor cursor(columnSeq);
      for(cursor.setToFirst();
          cursor.isValid() && columnSeq.elementAt(cursor) != removeCol;
          cursor.setToNext());

      if(cursor.isValid())
      {
        columnSeq.removeAt(cursor);
        // Tell the container to stop displaying the icon
        if (offset == offsetof(IMiniCnrRecord,hptrIcon) )
          XtVaSetValues(container, XmNshowIconInDetail, False, NULL);
      }
      else
      {
        ITRACE_DEVELOP(IString("Tried to removeColumn() for non-existant column"));
        ret = -1;
      }

    }
  }

  updateColumns();

  // check for flags:
  // flags: CMA_FREE: not used by IContainer
  //        CMA_INVALIDATE: in the Motif port invalidate is
  //                        always done; (updateColumns())

  if (ret)
    // error occured
    return ret;
  else
    return (int)columnSeq.numberOfElements();
}


/*------------------------------------------------------------------------------
| setGadgetEmphasis                                                            |
------------------------------------------------------------------------------*/
void ICnrControlData::setGadgetEmphasis(Widget iconG,
                              bool turnOn,
                              unsigned long emphType)
{
  // For now ignore emphType and turn on selected emphasis for both
  // cursored and inuse. Will have to modify the IconGadget to support
  // other types of emphasis if we really need this.
  unsigned char emphasis;

  if (turnOn && ( emphType == CRA_CURSORED || emphType == CRA_SELECTED) )
    XuiclSetLocationCursor(iconG); 

  if (emphType == CRA_CURSORED)
  {
    emphasis = (turnOn ? XmCURSORED : XmNOT_CURSORED);
    XtVaSetValues(iconG, XmNcursorEmphasis, emphasis, NULL);
  }
  else if (emphType == CRA_SELECTED)
  {
    emphasis = (turnOn ? XmSELECTED : XmNOT_SELECTED);
    XtVaSetValues(iconG, XmNvisualEmphasis, emphasis, NULL);
    if (turnOn)
    {
       emphasis = XmCURSORED ;
       XtVaSetValues(iconG, XmNcursorEmphasis, emphasis, NULL);
    }
  }
  else if (emphType == CRA_INUSE) {
     emphasis = (turnOn ? XmINUSE : XmNOT_INUSE);
     XtVaSetValues(iconG, XmNinUseEmphasis, emphasis, NULL);
  }
} // setGadgetEmphasis

// in order to support IContainerControl::Cursor when objects are filtered,
// we keep a linked list of objects in the container
// At the cnr level, we keep pointers to the 1st and last objects in the cnr.
// for each object, we keep pointers to the previous and next objects. If an
// object is a parent, we also keep pointers to the first and last child objects.
// This information along with the code in IContaineControl::Cursor allows us
// to traverse all objects in a cnr.
/******************************************************************************
| ICnrControlData::getRecord                                                  |                                                                              
******************************************************************************/
IContainerObject* ICnrControlData::getRecord(IContainerObject* pObject,
                                  unsigned short position,
                                  unsigned short order)
{
 
   switch (position) {
 
     case CMA_FIRST:
       return pFirstObject ;
 
     case CMA_LAST:
       return pLastObject ; 
 
     case CMA_NEXT:
         return pObject->ppd->nextObject(theIContainer) ; 
 
     case CMA_PREV:
         return pObject->ppd->previousObject(theIContainer) ;
 
      case CMA_PARENT:
      {
         Widget parentW = 0 ;
         IContainerObject* parentObj(NULL) ;
         IWindowHandle aGadget = IGadgetFromObj(pObject, theIContainer) ;
         if (aGadget)
            XtVaGetValues(aGadget, XmNentryParent, &parentW, NULL);
         if (parentW)
            XtVaGetValues(parentW, XmNuserData, &parentObj, NULL);
         return parentObj ;
      }
 
     case CMA_FIRSTCHILD:
         return pObject->ppd->firstChildObject(theIContainer) ;
 
     case CMA_LASTCHILD:
         return pObject->ppd->lastChildObject(theIContainer) ;
     default:
       return NULL;
   }

} // getRecord

/*------------------------------------------------------------------------------
| queryRecord                                                                  |
------------------------------------------------------------------------------*/
IEventResult ICnrControlData::queryRecord(IMiniCnrRecord* pCnrRec,
                                          unsigned short position,
                                          unsigned short order)
{
   IContainerObject* pObj = IObjFromRec(pCnrRec);
   pObj = getRecord(pObj, position, order);

   if (! pObj) 
      return IEventResult(0);

  return IEventResult(IRecFromObj(pObj));
} // queryRecord

/*------------------------------------------------------------------------------
| queryRecordRect                                                              |
------------------------------------------------------------------------------*/
IEventResult ICnrControlData::queryRecordRect( PRECTL pRectl,
                               PQUERYRECORDRECT pQueryRecordRect )
{
   unsigned long xmExtent;
   IContainerObject * obj = IObjFromRec( pQueryRecordRect->pRecord );
   Widget gadget = IGadgetFromObj( obj, theIContainer,
                                   true ); // throwIfNotFound == True

   if( pQueryRecordRect->fsExtent == (CMA_ICON | CMA_TEXT) )
   {
      // text and icon
      xmExtent = (XmICON_EXTENT | XmTEXT_EXTENT);
   }
   else if( pQueryRecordRect->fsExtent == CMA_ICON )
   {
      // icon only
      xmExtent = XmICON_EXTENT;
   }
   else if( pQueryRecordRect->fsExtent == CMA_TEXT )
   {
      // text only
      xmExtent = XmTEXT_EXTENT;
   }
   else if( pQueryRecordRect->fsExtent == 0 )
   {
      // details rectangle, or empty rectangle positioned at record
      xmExtent = 0;;
   }
   else return IEventResult( false );   // bad parms

   XRectangle xrect = XuiclRectangle( (Widget)container, gadget, xmExtent, -1 );

   if( xrect.x == -1 && xrect.y == -1 &&
                   xrect.height == 0 && xrect.width == 0 )
       return IEventResult( false );   // bad rectangle

   IRectangle wrect = xToWinCoords( xrect );

   pRectl->lXLeft   = wrect.left();
   pRectl->lYBottom = wrect.bottom();
   pRectl->lXRight  = wrect.right();
   pRectl->lYTop    = wrect.top();

   return IEventResult( true );   // return OK
}

/*------------------------------------------------------------------------------
| viewPortOnWorkspace                                                          |
------------------------------------------------------------------------------*/
// Note that this is not correct for ICoordinateSystem::originLowerLeft.
// Will need to remedy this later. And when I do, need to verify the logic
// in IDMTargetOperation::dropPosition() as well
IRectangle ICnrControlData::viewPortOnWorkspace() 
{
   RECTL rectl ;
   rectl.lXLeft = rectl.lYTop = rectl.lXRight = rectl.lYBottom = 0 ;
   queryViewPortRect( &rectl, CMA_WORKSPACE, false) ;

   return IRectangle(rectl.lXLeft, rectl.lYTop, rectl.lXRight, rectl.lYBottom) ;
} // viewportOnWorkspace

/*------------------------------------------------------------------------------
| queryViewPortRect                                                           |
------------------------------------------------------------------------------*/
IEventResult ICnrControlData::queryViewPortRect( PRECTL pRectl,
                           unsigned short coordinateSpace,
                           unsigned short rightSplitWindow)
{
   IFUNCTRACE_DEVELOP() ;

   // ignore rightSplitWindow since we don't support details-view splitwindows

   Dimension clipWindow_width, clipWindow_height,
             container_width,  container_height,
             scrollBar_height, spacing;
   Arg args[ 3 ]; int n=0;

   XtSetArg(args[n], XmNwidth,  &container_width); n++;
   XtSetArg(args[n], XmNheight, &container_height); n++;
   XtGetValues(container, args, n); n = 0;

   XtSetArg(args[n], XmNwidth,  &clipWindow_width); n++;
   XtSetArg(args[n], XmNheight, &clipWindow_height); n++;
   XtGetValues(clipWindow, args, n); n = 0;

   if( container_width > clipWindow_width )  // horizontal scrollBar visible?
   {
       XtSetArg(args[n], XmNheight, &scrollBar_height); n++;
       XtGetValues(horizontalScroll, args, n); n = 0;

       XtSetArg(args[n], XmNspacing, &spacing); n++;
       XtGetValues(scrolledWindow, args, n); n = 0;
   }
   else
   {
       scrollBar_height = 0;
       spacing          = 0;
   }

   if( coordinateSpace == CMA_WINDOW )            // ...viewPortOnWindow
   {
       ITRACE_DEVELOP("on CMA_WINDOW") ;
       pRectl->lXLeft   = 0;
       pRectl->lXRight  = clipWindow_width;
       pRectl->lYBottom = clipWindow_height ;
       pRectl->lYTop    = 0 ;

       ITRACE_DEVELOP("AIX rectangle:") ;
       ITRACE_DEVELOP("lXLeft =" + IString(pRectl->lXLeft)) ;
       ITRACE_DEVELOP("lYTop =" + IString(pRectl->lYTop)) ;
       ITRACE_DEVELOP("lXRight =" + IString(pRectl->lXRight)) ;
       ITRACE_DEVELOP("lYBottom =" + IString(pRectl->lYBottom)) ;

       Dimension titleHeight(0) ;
       if (XtIsManaged(titleLabel))
       {
          XtVaGetValues(titleLabel,
                        XmNheight, &titleHeight,
                        NULL) ;
          ITRACE_DEVELOP("title height = " + IString((unsigned int) titleHeight)) ;
       }

       Dimension separatorHeight(0) ;
       if (XtIsManaged(titleSeparator))
       {
          XtVaGetValues(titleSeparator,
                        XmNheight, &separatorHeight, 
                        NULL) ;
          ITRACE_DEVELOP("title height = " + IString((unsigned int) separatorHeight)) ;
       }

       pRectl->lYTop    += titleHeight + separatorHeight ;
       pRectl->lYBottom += titleHeight + separatorHeight ;

       ITRACE_DEVELOP("AIX rectangle:") ;
       ITRACE_DEVELOP("lXLeft =" + IString(pRectl->lXLeft)) ;
       ITRACE_DEVELOP("lYTop =" + IString(pRectl->lYTop)) ;
       ITRACE_DEVELOP("lXRight =" + IString(pRectl->lXRight)) ;
       ITRACE_DEVELOP("lYBottom =" + IString(pRectl->lYBottom)) ;
       return IEventResult( true );   // success
   }
   else if( coordinateSpace == CMA_WORKSPACE )    // ...viewPortOnWorkspace
   {
       ITRACE_DEVELOP("In viewportforWorkspace") ;
       Widget wfrom = (Widget)clipWindow;
       Widget wto   = (Widget)container;

       XPoint from, to, offset;
       XtTranslateCoords(wfrom, 0, 0, &from.x, &from.y);
       XtTranslateCoords(wto,   0, 0, &to.x,   &to.y);

       offset.x = from.x - to.x;
       offset.y = from.y - to.y;

       ITRACE_DEVELOP("container widget width  = " + IString(container_width)) ;
       ITRACE_DEVELOP("container widget height = " + IString(container_height)) ;
       ITRACE_DEVELOP("clip window width  = " + IString(clipWindow_width)) ;
       ITRACE_DEVELOP("clip window height = " + IString(clipWindow_height)) ;
       ITRACE_DEVELOP("offset.x  = " + IString(offset.x)) ;
       ITRACE_DEVELOP("offset.y  = " + IString(offset.y)) ;

       pRectl->lXLeft   = (offset.x > 0) ? offset.x : 0 ; // max(offset.x,0)
       pRectl->lYTop    = (offset.y > 0) ? offset.x : 0 ;
       pRectl->lXRight  = (container_width < pRectl->lXLeft + clipWindow_width) ?
                            container_width : pRectl->lXLeft + clipWindow_width ;
       pRectl->lYBottom = (container_height < pRectl->lYTop + clipWindow_height) ?
                            container_height : pRectl->lYTop + clipWindow_height ;

       ITRACE_DEVELOP("AIX rectangle:") ;
       ITRACE_DEVELOP("lXLeft =" + IString(pRectl->lXLeft)) ;
       ITRACE_DEVELOP("lYTop =" + IString(pRectl->lYTop)) ;
       ITRACE_DEVELOP("lXRight =" + IString(pRectl->lXRight)) ;
       ITRACE_DEVELOP("lYBottom =" + IString(pRectl->lYBottom)) ;

       return IEventResult( true );   // success
   }
   else return IEventResult( false ); // fail
}

/*------------------------------------------------------------------------------
| queryRecordFromRect                                                          |
------------------------------------------------------------------------------*/
IEventResult ICnrControlData::queryRecordFromRect( PRECORDCORE pSearchAfter,
                               PQUERYRECFROMRECT pQueryRecFromRect )
{
   RECTL * pmR = & pQueryRecFromRect->rect;
   const IRectangle queryRect( pmR->lXLeft, pmR->lYBottom,
                               pmR->lXRight, pmR->lYTop);

   IMiniCnrRecord * pCnrRec;

   if( pSearchAfter == (IMiniCnrRecord*)CMA_FIRST )
   {
      pCnrRec = (IMiniCnrRecord*) (void*) queryRecord( 0, CMA_FIRST,
                                               pQueryRecFromRect->fsSearch
                                             );
   }
   else
   {
      pCnrRec = (IMiniCnrRecord*) (void*) queryRecord( pSearchAfter,
                                               CMA_FIRSTCHILD,
                                               pQueryRecFromRect->fsSearch );
      if( pCnrRec == NULL )
          pCnrRec = (IMiniCnrRecord*) (void*) queryRecord( pSearchAfter,
                                               CMA_NEXT,
                                               pQueryRecFromRect->fsSearch );
   }

   // The below query functions are surprisingly inefficient.
   // Avoid calling them within the while loop.
   #define VIEW_ICON     1
   #define VIEW_NAME     2
   #define VIEW_TEXT     3
   #define VIEW_DETAILS  4
   unsigned long cnrView = 0;
   if ( theIContainer->isIconView() )
   {
      cnrView = VIEW_ICON;
   }
   else if ( theIContainer->isNameView() )
   {
      cnrView = VIEW_NAME;
   }
   else if ( theIContainer->isTextView() )
   {
      cnrView = VIEW_TEXT;
   }
   else if ( theIContainer->isDetailsView() )
   {
      cnrView = VIEW_DETAILS;
   }
   else
   {
      return IEventResult( (PRECORDCORE) -1 );   // error
   }

   while( pCnrRec )
   {
      IRectangle         objRect;     // in window coordinates
      IMiniCnrRecord   * pNxtRec;
      IContainerObject * obj = IObjFromRec( pCnrRec );

      switch ( cnrView )
      {
         case VIEW_ICON:
         case VIEW_NAME:
            objRect = theIContainer->iconRectangle( obj, true ); //include text
            break;
         case VIEW_TEXT:
            objRect = theIContainer->textRectangle( obj );
            break;
         case VIEW_DETAILS:
         default:
            objRect = theIContainer->detailsObjectRectangle( obj );
            break;
      }

      // Does queryRect overlap or intersect with objRect
      if( ((pQueryRecFromRect->fsSearch & CMA_COMPLETE) &&
           queryRect.contains( objRect ))
                        ||
          ((pQueryRecFromRect->fsSearch & CMA_PARTIAL) &&
           (queryRect.contains( objRect ) || queryRect.intersects( objRect ))))
      {
         return IEventResult( (PRECORDCORE)IRecFromObj( obj ) );
      }

      pNxtRec = (IMiniCnrRecord*) (void*) queryRecord( pCnrRec,
                                               CMA_FIRSTCHILD,
                                               pQueryRecFromRect->fsSearch );

      if( pNxtRec == NULL )
          pNxtRec = (IMiniCnrRecord*) (void*) queryRecord( pCnrRec,
                                               CMA_NEXT,
                                               pQueryRecFromRect->fsSearch );
      if( pNxtRec == NULL )
      {
          pNxtRec = pCnrRec;
          while (
              (pNxtRec = (IMiniCnrRecord*) (void*) queryRecord( pNxtRec,
                                               CMA_PARENT,
                                               pQueryRecFromRect->fsSearch ))
              &&
                        ((IMiniCnrRecord*) (void*) queryRecord( pNxtRec,
                                               CMA_NEXT,
                                               pQueryRecFromRect->fsSearch )
                        == NULL)
                )
             ;
          if( pNxtRec )
              pNxtRec = (IMiniCnrRecord*) (void*) queryRecord( pNxtRec,
                                               CMA_NEXT,
                                               pQueryRecFromRect->fsSearch );
      }
      pCnrRec = pNxtRec;
   }

   return IEventResult( (PRECORDCORE) 0 );   // not-found
}

/*------------------------------------------------------------------------------
| invalidateRecord                                                             |
------------------------------------------------------------------------------*/
void ICnrControlData::invalidateRecord(IMiniCnrRecord** pRecArr,
                                       unsigned short cNumRecord,
                                       unsigned short fInvalidateRecord)
{
   IFUNCTRACE_DEVELOP() ;
   /* f7351 - support repositioning with place_style == XmNONE in spatial view.
    */
   if( fInvalidateRecord & CMA_REPOSITION ) 
   {
      unsigned char place_style;
      Dimension xmCnrHeight, marginHeight, marginWidth;
      XtVaGetValues( container, XmNplaceStyle, &place_style,
                                XmNheight, &xmCnrHeight,
                                XmNmarginHeight, &marginHeight,
                                XmNmarginWidth, &marginWidth,
                                NULL );
      if( place_style == XmNONE             &&
          (!theIContainer->isTreeView())    &&
          (!theIContainer->isDetailsView()) &&
          (!(ulStyle & CCS_AUTOPOSITION))      )   // Only do the reposition if autoPosition style is not on. 
      {
         IMiniCnrRecord* pRec = *pRecArr;
         IContainerObject * iobj = IObjFromRec(pRec);

         IPoint iconPoint(pRec->ptlIcon.x, pRec->ptlIcon.y) ;
         XPoint iconXPoint = winToXCoords(iconPoint) ;
         Dimension motif_x( iconXPoint.x );
         Dimension motif_y( iconXPoint.y );
         ITRACE_DEVELOP("native cnr coords") ;
         ITRACE_DEVELOP("x = " + IString(motif_x)) ;
         ITRACE_DEVELOP("y = " + IString(motif_y)) ;

         if (iobj)
         {
            Widget iconGadget = IGadgetFromObj( iobj, theIContainer, true);
   
   //       XtVaSetValues(iconGadget, XmNsmallIconX, motif_x,
   //                                 XmNsmallIconY, motif_y,
   //                                 XmNlargeIconX, motif_x,
   //                                 XmNlargeIconY, motif_y, NULL);
   
            // Set the x and y on the gadget.
            XtVaSetValues(iconGadget, XmNiconViewX, motif_x,        
                                      XmNiconViewY, motif_y, NULL); 
         }
      } 

      // Force a relayout.
      bool  currentState = theIContainer->isRefreshOn();       
      theIContainer->setRefreshOn();                           
      XmContainerRelayout(container);                          
      theIContainer->setRefreshOn(currentState);               
   } // CMA_REPOSITION 

   if ( fInvalidateRecord & CMA_TEXTCHANGED &&
        theIContainer->isRefreshOn() )
   {
      updateColumns() ;
   }

   // Flowmark had added code here that would do an XtVaSetValues
   // for the labelString, largeIconPixmap, and smallIconPixmap
   // resources. This code no longer needed since IconGadget and
   // Container can now handle changes to these resources.

   // Skip the below optimization, since it makes things slower:
   // If objects were added with refresh off, they are all in
   // pwidgetlist. manage() does an XtManageChildren for all of them
   // in one gulp - this was our big performance enhancement.
   // if (pwidgetList != 0)
   // {
   //   pwidgetList->manage();
   //   XuiclRefresh( (Widget)container );
   // }
}

/*------------------------------------------------------------------------------
| strMatch                                                                     |
------------------------------------------------------------------------------*/
bool ICnrControlData::strMatch(PSEARCHSTRING pSrchStr,
                                         Widget curIconG,
                                         unsigned long numCols,
                                         bool exact)
{
  bool found = false;
  bool keepGoing = true;
  IString curStr;

  // set up the search string
  IString searchStr(pSrchStr->pszSearch);
  if (!pSrchStr->fsCaseSensitive) searchStr = searchStr.upperCase();

  XmStringTable strTable = NULL;
                      // Set the curString for non-details view,
  curStr = IMString(curIconG, XmNlabelString).asString();

  // If we are in details view, numCols will be the total number of visible
  // columns (including the possible icon in column 0).
  if (numCols > 0)
  {                   // Set the curString for details view
    XtVaGetValues(curIconG, XmNentryDetail, &strTable, NULL);
    // find the first column
    // if it is visible, and icon, set curStr to labelString
    // else, set to strTable[0]
    ColumnSequenceType::Cursor cursor(columnSeq);
    cursor.setToFirst();
    if( cursor.isValid() )
    {
       IContainerColumn* curCol = columnSeq.elementAt(cursor);
       if (curCol->isVisible() &&          // visible
          (curCol->isIconHandle()))        // icon
           curStr = IMString(curIconG, XmNlabelString).asString();
       else
           curStr = IMString(strTable[0]);
    }
  }

  unsigned long curCol = 1;        // column 0 done - set to col 1

  while(!found && keepGoing)
  {
    if (!pSrchStr->fsCaseSensitive)
      curStr = curStr.upperCase();

    unsigned long indexPos = curStr.indexOf(searchStr);

    if (exact)
    {
      if (indexPos == 1 && (curStr.length() == searchStr.length()))
        found = true;
      else
        found = false;
    }
    else
      if (pSrchStr->fsPrefix)
        found = (indexPos == 1 ? true : false);
      else
        found = indexPos;

    if (!found && curCol < numCols)
    {
      curStr = IMString(strTable[curCol]);
      curCol++;
    }
    else
      keepGoing = false;
  }

  if( numCols > 0 )
  {
    // free the storage used by the XmStringTable
    for (int i=0; i<numCols; i++) XmStringFree(strTable[i]);
    delete strTable;
  }

  return found;
}

/*------------------------------------------------------------------------------
| nextBranchGadget                                                             |
------------------------------------------------------------------------------*/
Widget ICnrControlData::nextBranchGadget(Widget curIconG)
{
   Widget parentIconG = XuiclQueryRecord(curIconG, CMA_PARENT, 0);
   if (parentIconG == 0)
     return parentIconG;

   Widget resultIconG = XuiclQueryRecord(parentIconG, CMA_NEXT, 0);
   if (resultIconG != 0)
     return resultIconG;

   return nextBranchGadget(parentIconG);
}

/*------------------------------------------------------------------------------
| nextSearchStringGadget                                                       |
------------------------------------------------------------------------------*/
Widget ICnrControlData::nextSearchStringGadget(Widget curIconG,
                                               unsigned long view)
{
  if (!(view & CV_TREE))
    return XuiclQueryRecord(curIconG, CMA_NEXT, 0);
  else
  {  // Need to descend tree when in tree view
     // This routine (including the recursive nextBranchGadget) uses the
     // same algorithm as nextObject() and nextBranchObject() in
     // IContainerControl::ObjectCursor.
     // Couldn't use an ObjectCursor because we'd need to construct one
     // for all objects after a given object.
     Widget resultIconG = XuiclQueryRecord(curIconG, CMA_FIRSTCHILD, 0);
     if (resultIconG)
       return resultIconG;

     resultIconG = XuiclQueryRecord(curIconG, CMA_NEXT, 0);
     if (resultIconG)
       return resultIconG;

     return nextBranchGadget(curIconG);
  }
}

/*------------------------------------------------------------------------------
| searchString                                                                 |
------------------------------------------------------------------------------*/
IMiniCnrRecord* ICnrControlData::searchString(PSEARCHSTRING pSrchStr,
                                              IMiniCnrRecord* startRec)
{
  IMiniCnrRecord* result = 0;
  Widget curIconG;
  bool exact = false;

  if ((long)startRec == CMA_FIRST)
    curIconG = XuiclQueryRecord(container, CMA_FIRST, 0);
  else
    curIconG = nextSearchStringGadget(
                  IGadgetFromObj(IObjFromRec(startRec), theIContainer),
                  pSrchStr->usView);

  unsigned long numCols = 0;
  // Won't use hidden columns
  if (pSrchStr->usView & CV_DETAIL)
    XtVaGetValues(container,
                  XmNdetailCount, &numCols,
                  NULL);

  // See if an exact match wanted
  if (pSrchStr->usView & CV_EXACTMATCH)
    exact = true;

  while (result == 0 && curIconG)
    if (strMatch(pSrchStr, curIconG, numCols, exact))
    {
      IContainerObject* pObj;
      XtVaGetValues(curIconG,
                    XmNuserData, &pObj,
                    NULL);
      result = IRecFromObj(pObj);
    }
    else
      curIconG = nextSearchStringGadget(curIconG, pSrchStr->usView);

  return result;
}

/*------------------------------------------------------------------------------
| filterContainer                                                              |
------------------------------------------------------------------------------*/
void ICnrControlData::filterContainer(PCNRFILTERFN pfn,
                                      ICnrFilterPackage* pFilterPckg)
{
  // Can't use an ObjectCursor here because that won't pick up
  // filtered (ie. Unmanaged widgets)
  Widget     curIconG;
  IContainerObject* pcurObj;
  ICnrIGCursor cursor(theIContainer);

  for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
  {
    curIconG = cursor.current();
    XtVaGetValues(curIconG,
                  XmNuserData, &pcurObj,
                  NULL);

    // in this function, we trust, that in XmWidgetList
    // XmNchildren, the order of widgets keeps the same
    // as on widget creation.
    // else we first would have to make a copy
    // and order widgets according to their entryParents:
    // e.g. P1 C11 C12 P2 C21 C22 C23 ....

    if((*pfn)(IRecFromObj(pcurObj), pFilterPckg))
    {
      Widget entryParent;

      XtVaGetValues(curIconG,
                    XmNentryParent, &entryParent,
                    NULL);

      // XtManage only if entryParent is not filtered

      if(!XtIsManaged(curIconG))
      {
          if (entryParent == NULL || XtIsManaged(entryParent))
              XtManageChild(curIconG);
      }
      else
      {
          if (entryParent != NULL && !XtIsManaged(entryParent))
          {
              unsigned char selectionState;
              XtVaGetValues(curIconG, XmNvisualEmphasis, &selectionState, NULL);
              if( selectionState == XmSELECTED )
                  theIContainer->setSelected( pcurObj, false ); // deselect it
              XtUnmanageChild(curIconG);
          }
      }
    }
    else
    {
      if(XtIsManaged(curIconG))
      {
          unsigned char selectionState;
          XtVaGetValues(curIconG, XmNvisualEmphasis, &selectionState, NULL);
          if( selectionState == XmSELECTED )
              theIContainer->setSelected( pcurObj, false ); // deselect it
          XtUnmanageChild(curIconG);
      }
    }
  }

  XmContainerRelayout(container);
}

/*------------------------------------------------------------------------------
| getFirstSelected                                                             |
------------------------------------------------------------------------------*/
IMiniCnrRecord* ICnrControlData::getFirstSelected(Widget root)
{
  WidgetList curList = NULL;
  int curListCount, i;
  unsigned char visualEmphasis;
  IContainerObject* pObj;
  IMiniCnrRecord* branchResult;

  curListCount = XmContainerGetItemChildren(container, root, &curList);
  for(i=0; i < curListCount; i++)
  {
    XtVaGetValues(curList[i],
                  XmNvisualEmphasis, &visualEmphasis,
                  XmNuserData, &pObj,
                  NULL);
    if (visualEmphasis == XmSELECTED)
    {
      XtFree( (char*)curList );
      return IRecFromObj(pObj);
    }
    else
    {
      if (branchResult = getFirstSelected(curList[i]))
      {
         XtFree( (char*)curList );
         return branchResult;
      }
    }
  }
  XtFree( (char*)curList );
  return 0;
}

/*------------------------------------------------------------------------------
| queryContainerWidget                                                         |
------------------------------------------------------------------------------*/
unsigned long ICnrControlData::queryContainerWidget()
{
   // this function is symmetric to setContainerWidget()

   IContainerControl* pCnr = theIContainer;
   unsigned long flags = 0;
   Arg            args[9];
   int            n = 0;
   unsigned char  layout, entryView, orientation, outline_style, placeStyle; /* LJO */
   ::Boolean      isTextView;

   XtSetArg(args[n], XmNlayoutType, &layout); n++;
   XtSetArg(args[n], XmNentryViewType, &entryView); n++;
   XtSetArg(args[n], XmNorientation, &orientation); n++;
   XtSetArg(args[n], XmNoutlineLineStyle, &outline_style); n++;
   XtSetArg(args[n], XmNshowTextView, &isTextView); n++;
   XtSetArg(args[n], XmNplaceStyle, &placeStyle); n++;               /* LJO */
   XtGetValues(container, args, n);

   // CV_DETAIL, CV_ICON, CV_TEXT, CV_NAME, CV_TREE, CV_FLOW
   if (entryView == XmDETAIL)
      flags |= CV_DETAIL;
   else
   {
      // detailsView overwrites other view types
      if (layout == XmOUTLINE)
         flags |= CV_TREE;

      if (entryView == XmLARGE_ICON)
         flags |= CV_ICON;

      if (entryView == XmSMALL_ICON)
      {
         // can be CV_NAME or CV_TEXT
         if( isTextView )
            flags |= CV_TEXT;
         else
            flags |= CV_NAME;
         if (placeStyle == XmGRID)                            /* LJO */
            flags |= CV_FLOW;                                 /* LJO */
      }
   }

   // treeline
   if (outline_style == XmSINGLE)
     flags |= CA_TREELINE;

   if (flWindowAttr & CA_DETAILSVIEWTITLES)
     flags |= CA_DETAILSVIEWTITLES;

   // title & separator
   if (XtIsManaged(titleLabel)) {
     flags |= CA_CONTAINERTITLE;
   }
   if (XtIsManaged(titleSeparator)) {
     flags |= CA_TITLESEPARATOR;
   }

   if (flWindowAttr & CA_TITLEREADONLY)
     flags |= CA_TITLEREADONLY ;

   if (flWindowAttr & CV_MINI)
     flags |= CV_MINI ;

   return flags;
}

/*------------------------------------------------------------------------------
| queryCnrInfo                                                                 |
------------------------------------------------------------------------------*/
void ICnrControlData::queryCnrInfo(ICnrInfo* pInfo)
{
  // need to add more to this later

  // count number of IconGadgets in Container
  // can't use XmNnumChildren since this includes outline buttons
  unsigned long cRecords = 0;
  ICnrIGCursor cursor(theIContainer);
  for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
    cRecords++;
  pInfo->cRecords = cRecords;

  pInfo->cFields = columnSeq.numberOfElements() ;

  pInfo->flWindowAttr=queryContainerWidget();

  unsigned char outline;
  long          lLineSpacing(0) ;
  XtVaGetValues(container,
                XmNoutlineLineStyle  , &outline,
                XmNdetailsLineSpacing, &lLineSpacing,
                NULL);

  if (outline == XmNO_LINE)
     pInfo->cxTreeLine=0;
  else
     pInfo->cxTreeLine=1;       // 1 pixel width

  pInfo->cyLineSpacing = lLineSpacing ;

  // icon size
  IContainerObject *pCnrObj = theIContainer->cursoredObject() ;
  if (pCnrObj)
  {
     IWindowHandle gadgetH = IGadgetFromObj(pCnrObj, theIContainer, 0) ;
     Pixmap gadgetPix ;
     XtVaGetValues(gadgetH, XmNlargeIconPixmap, &gadgetPix, NULL) ;
     ISize iconSize = IBitmapStaticPtr::pointerSet().find(gadgetPix)->size() ;
     pInfo->slBitmapOrIcon.cx = iconSize.width() ;
     pInfo->slBitmapOrIcon.cy = iconSize.height() ;
  }


}

/*------------------------------------------------------------------------------
| containerManagement                                                          |
------------------------------------------------------------------------------*/
void ICnrControlData :: containerManagement (ContainerManagementT cnrRequest)
{

  IFUNCTRACE_DEVELOP() ;

  Dimension width, height;

  Widget attachedWidget;

    switch (cnrRequest) {

    case SHOW_TITLE:
       {
          XtManageChild(titleLabel);
          break;
       }

    case HIDE_TITLE:
       {
          ITRACE_DEVELOP("hide_title") ;
          XtUnmanageChild(titleLabel);
          break;
       }

    case SHOW_SEPARATOR:
       {
          ITRACE_DEVELOP("show_separator") ;
          XtManageChild(titleSeparator);
          break;
       }

    case HIDE_SEPARATOR:
       {
          ITRACE_DEVELOP("hide_separator") ;
          XtUnmanageChild(titleSeparator);
          break;
       }

    case SET_TITLE:
       {
        /* do nothing */
       ITRACE_DEVELOP("set_title") ;
        break;
       }
    }

    // we are responsible for layout of the title and cnr widget
    resizeBulletinBoard() ;

} // containerManagement

/*------------------------------------------------------------------------------
| resizeBulletinBoard                                                          |
------------------------------------------------------------------------------*/
void ICnrControlData::resizeBulletinBoard()
{
   IFUNCTRACE_DEVELOP() ;

   Dimension width(0), height(0) ;
   Dimension titleHeight(0) ;

   // XiclCanvas inherits from XmBulletinBoard so we get to resize all
   // the children.
   // first get the size we are supposed to be at then layout the various
   // child widgets depending on what's visible

   if ( (! XtIsRealized(bulletinBoard)) || (! XtIsRealized(container)) 
        || ! XtIsManaged(bulletinBoard) || ! XtIsManaged(container) )
      return ;

   XtVaGetValues(bulletinBoard,
                 XmNwidth, &width,
                 XmNheight, &height,
                 NULL);

   ITRACE_DEVELOP("desired width " + IString(width)) ;
   ITRACE_DEVELOP("desired height " + IString(height)) ;

   XtVaSetValues(form,
                 XmNwidth, width,
                 XmNheight, height,
                 NULL);

   if (XtIsManaged(titleLabel))
   {
      XtVaSetValues(titleLabel,
                    XmNx, 0, 
                    XmNy, 0,
                    XmNwidth, (width-1),
                    NULL) ;
      XtVaGetValues(titleLabel,
                    XmNheight, &titleHeight,
                    NULL) ;
      ITRACE_DEVELOP("title height " + IString(titleHeight)) ;
      titleHeight = (titleHeight > 0) ? titleHeight : 0 ;
   }

   if (XtIsManaged(titleSeparator))
   {
      XtVaSetValues(titleSeparator,
                    XmNx, 0,
                    XmNy, (titleHeight+1),
                    XmNwidth, (width-1),
                    NULL) ;
      Dimension separatorHeight(0) ;
      XtVaGetValues(titleSeparator,
                    XmNheight, &separatorHeight, 
                    NULL) ;
      titleHeight += separatorHeight ;
      ITRACE_DEVELOP("separator managed title height " + IString(titleHeight)) ;
      titleHeight = (titleHeight > 0) ? titleHeight : (Dimension) 0 ;
   }

   Dimension newHeight = height - (titleHeight + 1) ;
   newHeight = (newHeight > 0) ? newHeight : (Dimension) 0 ;
   XtVaSetValues(scrolledWindow,
                 XmNx, 0,
                 XmNy, titleHeight,
                 XmNwidth, width-1,
                 XmNheight, newHeight,
                 NULL) ;

   ITRACE_DEVELOP("scrolled window width " + IString(width)) ;
   ITRACE_DEVELOP("scrolled window height " + IString((unsigned int) newHeight)) ;

   // fix for defect 26636
   // for some unknown reason, if it's the 2nd instance of a container
   // with a title and no title separator, the X window associated with the
   // scrolledWindow widget is not moved when we reset the widget's XmNx and
   // XmNy resources. The widgets are updated correctly ( I checked by
   // flashing everthing in editres ), only the windows are out of sync.
   // I'm going to use XConfigureWindow() to force the windows in the correct
   // places.
   // All the manuals urge you not to use xconfigure window in application code
   // but I'm rationalizing it this way : this is the appropriate spot in the
   // code to put this fix ( all widgets involved are known and the resize is
   // initiated here ) and I'm just making sure the windows follow the widgets.
   // I created another defect (26695) so that we can return to this if need be.

   XWindowAttributes xscrollwinattr ;
   Display* pScrolledWindowDisplay = XtDisplay((Widget)scrolledWindow) ;
   Window   scrolledWindowWindow   = XtWindow((Widget)scrolledWindow) ;
   XGetWindowAttributes(pScrolledWindowDisplay, 
                        scrolledWindowWindow, 
                        &xscrollwinattr) ;

   if ( XtIsManaged(titleLabel) && 
        titleHeight > 0 && 
        xscrollwinattr.y == 0 )
   {
      XWindowAttributes xtitlewinattr ;
      XGetWindowAttributes(XtDisplay((Widget)titleLabel), 
                           XtWindow((Widget)titleLabel), 
                           &xtitlewinattr) ;

      XWindowChanges xchanges ;
      xchanges.y = xtitlewinattr.height ;
      XConfigureWindow(pScrolledWindowDisplay,
                       scrolledWindowWindow,
                       CWY,
                       &xchanges) ;
   }
} // resizeBulletinBoard

/*------------------------------------------------------------------------------
| queryRecordInfo                                                              |
------------------------------------------------------------------------------*/
bool ICnrControlData::queryRecordInfo(IMiniCnrRecord** ppMCR)
{
  //ER: general point of discussion:
  //    PM Programming Reference: page 24-46: CM_QUERYRECORDINFO:
  //
  // Remarks: The flRecordAttr and ptlIcon fields are updated internally
  //          when they change, but not in the external RECORDCORE struct.
  //
  // (All our set.. functions, like setIconText rely on this fact on PM:
  // they first set the component (here strIcon) and then check for
  // isRefreshOn(); it refreshOn is true, the call refresh();)
  //

  IMiniCnrRecord* pRec = *ppMCR;
  Widget iconGadget;

  // containsObject calls this. If the object is not in the container
  // then IGadgetFromObj will return 0 since we've set 3rd parm to false
  //
  iconGadget = IGadgetFromObj(IObjFromRec(pRec), theIContainer, false);
  if (iconGadget == 0)
    return false;

  /* only checking CRA_SELECTED, CRA_FILTERED, CRA_EXPANDED and
   * CRA_COLLAPSED now, will need to add more later
   */

  // preserve CRA_READONLY, since this is not changed by the query
  // Note that it is not necessary to query the gadget for
  // readonly status, since this information is preserved in the
  // attribute!
  // clear all other flags
  pRec->flRecordAttr &=  CRA_RECORDREADONLY;

  unsigned char sel_emphasis,
                cur_emphasis,
                inuse_emphasis,
                outlineState;

  Arg            args[9];
  int            n = 0;
  XtSetArg(args[n], XmNvisualEmphasis, &sel_emphasis); n++;
  XtSetArg(args[n], XmNcursorEmphasis, &cur_emphasis); n++;
  XtSetArg(args[n], XmNinUseEmphasis, &inuse_emphasis); n++;
  XtSetArg(args[n], XmNoutlineState, &outlineState); n++;
  XtGetValues(iconGadget, args, n);

  // got cursored emphasis ?
  if (cur_emphasis == XmCURSORED)
    pRec->flRecordAttr |= CRA_CURSORED;

  // got selection emphasis ?
  if (sel_emphasis == XmSELECTED)
    pRec->flRecordAttr |= CRA_SELECTED;

  // got inUse emphasis ?
  if (inuse_emphasis == XmINUSE)
    pRec->flRecordAttr |= CRA_INUSE;

  // outlineState XmEXPANDED, XmCOLLAPSED ?
  if (outlineState == XmEXPANDED)
    pRec->flRecordAttr |= CRA_EXPANDED;
  else
    pRec->flRecordAttr |= CRA_COLLAPSED;

  // is it filtered?
  if (!XtIsManaged(iconGadget))
    pRec->flRecordAttr |= CRA_FILTERED;

  return true;
}

/*------------------------------------------------------------------------------
| columnUnderPoint                                                             |
------------------------------------------------------------------------------*/
IContainerColumn * ICnrControlData::columnUnderPoint( const IPoint& pt )
{
  if( theIContainer->isDetailsView() )
  {
     const XPoint xPoint = winToXCoords( pt );
     int   colPos;

     XuiclPointerInfo( container,
                       xPoint.x, xPoint.y,
                       &colPos,
                       NULL,   // not interested in heading
                       NULL );

     if( colPos >= 0 )
     {
        return directEdit->visibleColumn( (unsigned short) colPos );
     }
     else return NULL;
  }
  else return NULL;
}

/*------------------------------------------------------------------------------
| detailsCellRectangle                                                         |
------------------------------------------------------------------------------*/
IRectangle ICnrControlData::detailsCellRectangle (
                                   IContainerObject* object,
                                   const IContainerColumn* column) const
{
  IRectangle irectNull( 0, 0, 0, 0 );
  XRectangle xrect;
  int colPos;

  IContainerControl::ColumnCursor colCursor (*theIContainer, true ); // visible
  for( colPos = -1, colCursor.setToFirst();
         colCursor.isValid();
           colCursor.setToNext(), colPos++ )
  {
    if( colCursor.current() == column )   // found ?
    {
      colPos++;   // initially -1
      break;
    }
  }

  if( colPos == -1 )
  {
     /* not-found */
     return irectNull;
  }

  if( XuiclLocation( container, IGadgetFromObj( object, theIContainer ),
                      colPos, NULL, NULL, & xrect ) )
  {
     return xToWinCoords( xrect );   // return IRectangle
  }
  else
  {
    /* not-found */
     return irectNull;
  }
}

/*------------------------------------------------------------------------------
| expandCollapseTree                                                           |
------------------------------------------------------------------------------*/
void ICnrControlData::expandCollapseTree(Widget startGadget,
                                         unsigned char newstate)
{
    if( startGadget ) {                  // gadget-only, no children
        XuiclExpandCollapseTree( startGadget, newstate, False ); // pass gadget
    }
    else {                              // all the gadgets and their children
        XuiclExpandCollapseTree( container, newstate, True );   // pass widget
    }
}

/*------------------------------------------------------------------------------
| mleParent                                                                    |
------------------------------------------------------------------------------*/
IWindowHandle ICnrControlData::mleParent()
{
   /*  The direct edit mle is created as a child of the bulletin board.
    *  This allows the IMultiLineEdit control to appear on top of,
    *  instead of inside the container.
    */
   return bulletinBoard;
}

/*------------------------------------------------------------------------------
| dismissMle                                                                   |
------------------------------------------------------------------------------*/
void ICnrControlData::dismissMle()
{
    directEdit->dismissMle();
}

/*------------------------------------------------------------------------------
| deleteMle                                                                    |
------------------------------------------------------------------------------*/
void ICnrControlData::deleteMle()
{
    directEdit->deleteMle();
}

/*------------------------------------------------------------------------------
| openEdit                                                                     |
------------------------------------------------------------------------------*/
void ICnrControlData::openEdit( PCNREDITDATA pmEditStruct )
{
  // Check that the container has non-readonly style
  if( isStyleReadonly() ) return; // TTD need to check for columns ...

  // Call the appropriate method for editing data
  //
  const IWindowHandle cnrHandle = pmEditStruct->hwndCnr;
  ColumnSequenceType::Cursor cursor(columnSeq);
  ICnrDirectEdit::IObjWnd split = ICnrDirectEdit::record;
  unsigned short colIndex = 0;

  switch( pmEditStruct->id )
  {
    case CID_CNRTITLEWND:         /* editContainerTitle */
    {
      if (! isTitleWriteable()) return ;
      directEdit->editCnrTitle();
      break;
    }
    case CID_RIGHTCOLTITLEWND:    /* editColumnTitle */
    {
      split = ICnrDirectEdit::rightDetail;
    }
    case CID_LEFTCOLTITLEWND:     // MUST follow CID_RIGHTCOLTITLEWND
    {
      if( split == ICnrDirectEdit::record ) split = ICnrDirectEdit::leftDetail;

      IContainerColumn * col =
                 (IContainerColumn*)pmEditStruct->pFieldInfo->pUserData;

      for( cursor.setToFirst(), colIndex=0;
           cursor.isValid() && columnSeq.elementAt(cursor) != col;
           cursor.setToNext(), colIndex++ )
               ;

      if(cursor.isValid())
      {                         // found!
        directEdit->editColTitle( split, col, colIndex );
        break;
      }
      else return;
    }
    case CID_LEFTDVWND:         /* editObject (column) */
    {
       split = ICnrDirectEdit::leftDetail;
    }
    case CID_RIGHTDVWND:        // MUST follow CID_LEFTDVWND
    {
      if( split == ICnrDirectEdit::record ) split = ICnrDirectEdit::rightDetail;

      IContainerObject * obj =
                 (IContainerObject*)IObjFromRec( pmEditStruct->pRecord );
      IContainerColumn * col =
                 (IContainerColumn*)pmEditStruct->pFieldInfo->pUserData;

      for( cursor.setToFirst(), colIndex=0;
           cursor.isValid() && columnSeq.elementAt(cursor) != col;
           cursor.setToNext(), colIndex++ )
               ;

      if(cursor.isValid())
      {                         // found!
        directEdit->editObject( split, col, colIndex, obj );
        break;
      }
      else return;
    }
    case 0:                    /* editObject (record) */
    {
      IContainerObject * obj =
                 (IContainerObject*)IObjFromRec( pmEditStruct->pRecord );
      directEdit->editObject( ICnrDirectEdit::record, NULL, 0, obj );
      break;
    }
    default:
    {
      return;
    }
  }
}

/*------------------------------------------------------------------------------
| closeEdit                                                                    |
------------------------------------------------------------------------------*/
void ICnrControlData::closeEdit( const IWindowHandle& cnrHandle )
{
  IFUNCTRACE_DEVELOP() ;
  directEdit->update();
  directEdit->dismissMle();
}

/*------------------------------------------------------------------------------
| scrollBarCallback                                                            |
------------------------------------------------------------------------------*/
void ICnrControlData::scrollBarCallback( Widget widget,
                                               XtPointer client_data,
                                               XtPointer call_data )
{
   /* defect 3932 deals with the problem that, for say 110 items in details
    * view, clicking on the scrollBar arrow-up/down (increment/decrement)
    * scrolls the container 9-10 lines at a time, whereas performing
    * page-up/down scrolls the container 6-7 lines at a time.
    * In XmScrolledWindow widget XmAUTOMATIC mode, the scrollBars cannot
    * be manipulated directly to control scrolling. To work around d3932
    * We reset the increment and decrement values in the XmScrollBar
    * widget to the page_size/5+1. We do this when the scrollbar callbacks
    * are invoked or when the container is scrolled using the arrow keys.
    * Note that the increment or decrement callback is invoked AFTER the
    * item is scrolled, so that it is too late to correct the problem
    * for that increment or decrement. Thus if the very first scroll action
    * is an increment or decrement, it will scroll 9-10 lines, and thus
    * appear to have no effect. However subsequent increment or decrements
    * will appear to work OK. This is the best we can do for now.
    */

   Widget scrollBar = widget;
   int value, slider_size, increment, page_increment;
   XmScrollBarGetValues( scrollBar, & value, & slider_size,
                                        & increment, & page_increment );
   increment = page_increment/5 + 1;
   XmScrollBarSetValues( scrollBar, value, slider_size,
                                        increment, page_increment, False );
}

/*------------------------------------------------------------------------------
| traversalCallback                                                            |
------------------------------------------------------------------------------*/
void ICnrControlData::traversalCallback( Widget widget, XtPointer client_data,
                                                        XtPointer call_data )
{
   ICnrControlData * This = (ICnrControlData*) client_data;
   XmContainerTraversalCallbackStruct * cbs =
                               (XmContainerTraversalCallbackStruct*)call_data;
   IContainerControl * cnrctl = This->theIContainer;
   IContainerObject * pcnrobj = IObjFromGadget( cbs->traversal_destination );
   IRectangle rectViewport    = cnrctl->viewPortOnWindow();
   IRectangle rectObject      = cnrctl->iconRectangle(pcnrobj, true);
   long margin                = 15;

   if (cnrctl->isDetailsView())
   {
     if ( rectObject.top() > rectViewport.top() ||
          rectObject.bottom() < rectViewport.bottom() )
     {
        cnrctl->scrollVertically(
                 rectViewport.top() - rectObject.top() - margin);
     }
   }
   else
     if ( ! rectViewport.contains( rectObject.center() ) )
     {
        cnrctl->scroll(rectViewport.top() - rectObject.top() - margin,
                       rectObject.left() - margin);
     }

   /* d3932, also reset the scrollbar up/down increment values
    */
   Widget hscrollBar = This->horizontalScroll;
   Widget vscrollBar = This->verticalScroll;
   int value, slider_size, increment, page_increment;
   XmScrollBarGetValues( hscrollBar, & value, & slider_size,
                                        & increment, & page_increment );
   increment = page_increment/5 + 1;
   XmScrollBarSetValues( hscrollBar, value, slider_size,
                                        increment, page_increment, False );

   XmScrollBarGetValues( vscrollBar, & value, & slider_size,
                                        & increment, & page_increment );
   increment = page_increment/5 + 1;
   XmScrollBarSetValues( vscrollBar, value, slider_size,
                                        increment, page_increment, False );
}

/*------------------------------------------------------------------------------
| scrollWindow                                                                 |
------------------------------------------------------------------------------*/
IEventResult ICnrControlData::scrollWindow(
                         unsigned short direction,
                         long           increment )
{
   /* if increment > 0,
    *    scroll to the right or down,
    * else
    *    scroll to the left or up.
    */
   Widget scrollBar;
   if (direction == CMA_VERTICAL)
   {
      scrollBar = verticalScroll;
   }
   else if (direction == CMA_HORIZONTAL)
   {
      scrollBar = horizontalScroll;
   }
   else return IEventResult( false );   // unspecified direction

   int value, slider_size, increment_size, page_increment;

   XmScrollBarGetValues( scrollBar, & value, & slider_size,
                                    & increment_size, & page_increment );

   value += increment;

   XmScrollBarSetValues( scrollBar, value, slider_size, increment_size,
                                    page_increment, True ); // notify True

   return IEventResult( true );   // success
}

/*------------------------------------------------------------------------------
| isStyleReadonly                                                              |
------------------------------------------------------------------------------*/
bool ICnrControlData::isStyleReadonly()
{
  return (ulStyle & IContainerControl::readOnly.asUnsignedLong()) ? true: false;
}

/*------------------------------------------------------------------------------
| isTitleWriteable                                                             |
------------------------------------------------------------------------------*/
bool ICnrControlData::isTitleWriteable()
{
  return (flWindowAttr & CA_TITLEREADONLY) ? false: true ;
}

/*------------------------------------------------------------------------------
| xToWinCoords                                                                 |
------------------------------------------------------------------------------*/
IRectangle ICnrControlData::xToWinCoords( const XRectangle & xRectangle ) const
{
  if( xRectangle.x      == 0 && xRectangle.y      == 0 &&
      xRectangle.height == 0 && xRectangle.width  == 0    )
  {
    return IRectangle( IPoint(0,0), IPoint(0,0) );
  }
  else
  {
    XPoint xpt1, xpt2;

    xpt1.x = xRectangle.x;
    xpt1.y = xRectangle.y;

    xpt2.x = xRectangle.x + xRectangle.width;
    xpt2.y = xRectangle.y + xRectangle.height;

    return IRectangle( xToWinCoords(xpt1), xToWinCoords(xpt2) );
  }
}

IPoint ICnrControlData::xToWinCoords( const XPoint & xPoint , const IWindowHandle* widgetFrom) const
{
  // Convert the container coordinates from X to window coords
  // (need to translate container coords to form coords)
  // Window coords are 0,0 at lower left.
  // X      coords are 0,0 at upper left

  //Widget wfrom = (Widget)theIContainer->handleForChildCreation();    // container
  //Widget wto   = (Widget)theIContainer->handle(); // form
  Widget wfrom ;
  if (widgetFrom)
     wfrom = (Widget) *widgetFrom ;
  else
      wfrom = (Widget) container ;
  Widget wto   = (Widget) bulletinBoard ;

  XPoint from, to;
  XtTranslateCoords(wfrom, 0, 0, &from.x, &from.y);
  XtTranslateCoords(wto,   0, 0, &to.x,   &to.y);

  if (ICoordinateSystem::applicationOrientation() == ICoordinateSystem::originUpperLeft)
     return IPoint(xPoint.x + (from.x - to.x),
                   xPoint.y + (from.y - to.y)
                  ) ;
  else {
     Position toHeight;
     XtVaGetValues( wto  , XmNheight, & toHeight,   NULL );

     return IPoint( xPoint.x + (from.x - to.x)
                  , toHeight - (xPoint.y + (from.y - to.y))
                  );
  }

}

/*------------------------------------------------------------------------------
| winToXCoords                                                                 |
------------------------------------------------------------------------------*/
XRectangle ICnrControlData::winToXCoords( const IRectangle & iRectangle ) const
{
  XPoint xpt1 = winToXCoords( iRectangle.topLeft() );
  XPoint xpt2 = winToXCoords( iRectangle.bottomRight() );

  XRectangle xrect;

  xrect.x      = xpt1.x;
  xrect.y      = xpt1.y;
  xrect.width  = xpt2.x - xpt1.x;
  xrect.height = xpt2.y - xpt1.y;

  return xrect;
}

XPoint ICnrControlData::winToXCoords( const IPoint & iPoint ) const
{
  // Convert the container coordinates from window to X coords
  // (need to translate form coords to container coords)
  // Window coords are 0,0 at lower left.
  // X      coords are 0,0 at upper left

  //Widget wfrom = (Widget)theIContainer->handle(); // form
  //Widget wto   = (Widget)theIContainer->handleForChildCreation();    // container
  Widget wfrom = (Widget) bulletinBoard ;
  Widget wto   = (Widget) container ;

  XPoint from, to;
  XtTranslateCoords(wfrom, 0, 0, &from.x, &from.y);
  XtTranslateCoords(wto,   0, 0, &to.x,   &to.y);

  XPoint xPoint;
  if (ICoordinateSystem::applicationOrientation() == ICoordinateSystem::originUpperLeft) {
     xPoint.x = iPoint.x() + (from.x - to.x) ;
     xPoint.y = iPoint.y() + (from.y - to.y) ;
  }
  else {
     Position toHeight, fromHeight;
     XtVaGetValues( wto,   XmNheight, &toHeight,   NULL );
     XtVaGetValues( wfrom, XmNheight, &fromHeight, NULL );

     xPoint.x = iPoint.x() + (from.x - to.x);
     xPoint.y = (fromHeight - iPoint.y()) + (from.y - to.y);
  }

  return xPoint;
}

/*------------------------------------------------------------------------------
| colInfo                                                                      |
------------------------------------------------------------------------------*/
PFIELDINFO ICnrControlData::colInfo( const IContainerColumn * col )
{
  return col->columnInfo();       // protected member
}

/*------------------------------------------------------------------------------
| sendFromCnrEvent                                                             |
------------------------------------------------------------------------------*/
bool ICnrControlData::sendEventFromCnr(
                            unsigned long           eventId,
                            const IEventParameter1& parm1,
                            const IEventParameter2& parm2 ) const
{
    IContainerControl * pwin =
        (IContainerControl*)IWindow::windowWithHandle(theIContainer->handle() );
    if( pwin ) {
        return pwin->sendEvent( IWindow::control, parm1, parm2 );
    }
    else {
        ITHROWLIBRARYERROR1(IC_INVALID_CLASS,
                            IBaseErrorInfo::accessError,
                            IException::recoverable,
                            "IContainer");
    }
    return false;
}

/*------------------------------------------------------------------------------
| postFromCnrEvent                                                             |
------------------------------------------------------------------------------*/
void ICnrControlData::postEventFromCnr(
                            unsigned long           eventId,
                            const IEventParameter1& parm1,
                            const IEventParameter2& parm2 ) const
{
    IContainerControl * pwin =
        (IContainerControl*)IWindow::windowWithHandle(theIContainer->handle() );
    if( pwin ) {
        pwin->postEvent( IWindow::control, parm1, parm2 );
    }
    else {
        ITHROWLIBRARYERROR1(IC_INVALID_CLASS,
                            IBaseErrorInfo::accessError,
                            IException::recoverable,
                            "IContainer");
    }
}

/*------------------------------------------------------------------------------
| installDirectEditTranslations                                                |
------------------------------------------------------------------------------*/
void ICnrControlData::installDirectEditTranslations( )
{
  /* Install the translations for invoking direct-edit on the container widget
   */
  XtTranslations transTable; /* compiled translations */

  // Register the action functions
  XtAppContext appContext = XtWidgetToApplicationContext( (Widget)container );
  XtAppAddActions( appContext, editActionsTable, XtNumber( editActionsTable ) );

  // Compile the translation table
  transTable = XtParseTranslationTable( editTranslations );

  // Override the translations
  XtOverrideTranslations( (Widget)container, transTable );
  XtOverrideTranslations( (Widget)titleLabel, transTable );
}

#if EMPTY_CNR_REGION
/*------------------------------------------------------------------------------
| clipWindowEvents - button clicks on the clipWindow                           |
------------------------------------------------------------------------------*/
void ICnrControlData::clipWindowEvents( Widget widget_id, XtPointer client_data,
                          XEvent * call_data, ::Boolean *continue_to_dispatch )
{
  // See comment in ICnrControlData::installEmptyContainerRegionHandler()

   IFUNCTRACE_DEVELOP();

  ICnrControlData * This = (ICnrControlData*)client_data;

  switch( call_data->xany.type )
  {
     case ButtonRelease:
     case ButtonPress:
     {
       XButtonEvent * xbutton = &call_data->xbutton;
       if( xbutton->button == Button1 )
       {
            // translate the coodinates from the clipWindow to the container
            Widget wfrom = widget_id;
            Widget wto   = This->container;

            XPoint from, to, offset, saved;
            saved.x = xbutton->x;
            saved.y = xbutton->y;
            XtTranslateCoords(wfrom, 0, 0, &from.x, &from.y);
            XtTranslateCoords(wto,   0, 0, &to.x,   &to.y);
            offset.x = from.x - to.x;
            offset.y = from.y - to.y;
            xbutton->x += offset.x;
            xbutton->y += offset.y;

#ifdef IC_TRACE_DEVELOP
            IString action("button 1 ");
            if( call_data->xany.type == ButtonPress )
              action += "down (";
            else if( call_data->xany.type == ButtonRelease )
              action += "up (";
            else
              action += "? (";
            action += IString( xbutton->x );
            action += ",";
            action += IString( xbutton->y );
            action += ") state: ";
            action += xbutton->state;
            ITRACE_DEVELOP( action );
#endif /* IC_TRACE_DEVELOP */

           if( ( call_data->xany.type == ButtonPress &&
                       xbutton->state == 0 ) ||
               ( call_data->xany.type == ButtonRelease &&
                       xbutton->state == Button1Mask ) )
            {
              String params = "";
              Cardinal numParams = 0;

              // invoke Container action proc
              XuiclMouseAction( This->container, xbutton,
                                & params, & numParams );
            }

            // Perform bb Event processing - use same client data
            This->directEdit->bbEvents( This->bulletinBoard, client_data,
                                        call_data, continue_to_dispatch );

            // restore the saved coordinates
            xbutton->x = saved.x;
            xbutton->y = saved.y;
       }
       break;
     }
  }
}
#endif /* EMPTY_CNR_REGION */

/*------------------------------------------------------------------------------
| createMle                                                                    |
------------------------------------------------------------------------------*/
IWindowHandle ICnrDirectEdit::createMle()
{
    Arg args[10];
    int n;

    imle = new IMultiLineEdit( CID_MLE,
                               cnrControlData->theIContainer,
                               cnrControlData->theIContainer,
                               IRectangle(), IWindow::visible);
#if 0
    imle->setAutoDeleteObject();
#endif

    mleText = imle->handle();

    n=0;
    XtSetArg(args[n], XmNmarginHeight, 3 ); n++;   // force
    XtSetArg(args[n], XmNmarginWidth,  3 ); n++;   // force
    XtSetValues( mleText, args, n );

    // add event handler
    XtAddEventHandler( mleText, KeyPressMask | KeyReleaseMask, False,
                                (XtEventHandler)mleEvents,
                                cnrControlData );
    return mleText;
}

/*------------------------------------------------------------------------------
| editCnrTitle                                                                 |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::editCnrTitle()
{

   if( ! cnrControlData->isTitleWriteable() ) return;

   const IString val = cnrControlData->theIContainer->title();

   state.current  = editingTitle;
   openMle( val );
}

/*------------------------------------------------------------------------------
| DirectEdit                                                                   |
------------------------------------------------------------------------------*/
ICnrDirectEdit :: ICnrDirectEdit( ICnrControlData * owner )
                            : cnrControlData( owner )
                            , mleText(0)
                            , imle(0)
                            , prevFocusWidget(0)
                            , dismissInProgress(false)
{
}

/*------------------------------------------------------------------------------
| ~DirectEdit                                                                  |
------------------------------------------------------------------------------*/
ICnrDirectEdit :: ~ICnrDirectEdit( )
{
    dismissMle();
    delete imle;
}

/*------------------------------------------------------------------------------
| editColTitle                                                                 |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::editColTitle( IObjWnd kind,
                                   IContainerColumn* cnrCol,
                                   unsigned short colIndex )
{
  IFUNCTRACE_DEVELOP();

  if((! cnrCol->isVisible()  )
  || (! cnrCol->isHeadingWriteable() )
  || (! cnrCol->isHeadingString() )) return;

  if( mleManaged() ) return;         // mle already present

  switch( kind )
  {
    case leftDetail:
    case rightDetail:
    {
       /* Details view heading edit
        * ignore leftDetail, rightDetail since there is no details view
        * split bar.
        */

       if( ! cnrCol->isVisible() ) break;

       const IString val = cnrCol->headingText();

       /* Set edit state
        */
       state.current  = editingDetailsHeading;
       state.col      = cnrCol;
       state.colIndex = colIndex;
       state.obj      = NULL;

       /* Open the mle and edit the field
        */
       openMle( val );

       break;
    }
  }
}

/*------------------------------------------------------------------------------
| editObject                                                                   |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::editObject( IObjWnd kind,
                                 IContainerColumn* cnrCol,
                                 unsigned short colIndex,
                                 IContainerObject* cnrObj)
{
  if( ! cnrObj->isWriteable(cnrControlData->theIContainer) ) return;
  if( mleManaged() ) return;         // mle already present

  switch( kind )
  {
    case leftDetail:
    case rightDetail:
    {
       /* Details view object edit
        * ignore leftDetail, rightDetail since there is no details view
        * split bar.
        */

       if((! cnrCol->isWriteable())
       || (! cnrCol->isVisible() )
       || (! cnrCol->isString()  )) break;

       const IString val = cnrCol->dataAsString( cnrObj );

       /* Set edit state
        */
       state.current  = editingDetailsView;
       state.col      = cnrCol;
       state.colIndex = colIndex;
       state.obj      = cnrObj;

       /* Open the mle and edit the field
        */
       openMle( val );

       break;
    }
    case record:
    {
       /* Object record edit
        */

       const IString val = cnrObj->iconText();

       /* Set edit state
        */
       state.current  = editingRecord;
       state.col      = cnrCol;
       state.colIndex = colIndex;
       state.obj      = cnrObj;

       /* Open the mle and edit the field
        */
       openMle( val );

       break;
    }
  }
}

/*------------------------------------------------------------------------------
| openEdit                                                                     |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::openEdit( int x, int y )
{
    // Check that the container has non-readonly style
    if( cnrControlData->isStyleReadonly() ) return;

    IContainerObject * obj;
    IContainerColumn * col;
    unsigned short columnPos;
    EditState stateToSet = locateForEdit( x, y, columnPos, obj, col );
    switch( stateToSet )
    {
      case editingDetailsView: {
         editObject( leftDetail,                  // get from Widget???
                     col, columnPos, obj);
         break;
       }
      case editingDetailsHeading: {
         editColTitle( leftDetail,
                       col, columnPos );
         break;
       }
      case editingRecord: {
         editObject( record,
                     NULL, 0, obj);
         break;
       }
      default: {
         break;
       }
    }
}

/*------------------------------------------------------------------------------
| update                                                                       |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::update()
{
   IFUNCTRACE_DEVELOP() ;

    switch( state.current )
    {
        case editingDetailsView: {        /* update DetailsView */
            if( ! updateUserEntry( imle->text() ) ) {
                state.obj->setIconText( (char*)imle->text() );
            }
            cnrControlData->updateColumns();
            break;
        }
        case editingDetailsHeading: {     /* update DetailsHeading */
            state.col->setHeadingText( (char*)imle->text() );
            break;
        }
        case editingRecord: {             /* update Record */
            state.obj->setIconText( (char*)imle->text() );
            cnrControlData->updateColumns();
            break;
        }
        case editingTitle: {             /* update Title */
            cnrControlData->theIContainer->setTitle(imle->text() ) ;
            break;
        }
        default: {
            break;
        }
    }
}

/*------------------------------------------------------------------------------
| updateUserEntry                                                              |
|  returns True if the details entry is a user-added column                    |
|  also updates the column data                                                |
------------------------------------------------------------------------------*/
bool ICnrDirectEdit::updateUserEntry( const IString & newtext )
{
    char** ppData;      // set by userDetailsEntry, pointer to pointer to
                        // data to be updated

    PFIELDINFO pfieldInfo; // required for CNREDITDATA, below

    bool userEntry = userDetailsEntry( ppData, pfieldInfo );

    /* returns False if the details entry is the icon text entry
     */
    if( ! userEntry ) return false;

    /* compare IStrings, no reallocation required if no-change
     */
    if( (IString)*ppData == newtext ) return true;

    /* Use the FIELDINFO.offStruct to obtain the pointer to either an
     * IString (normal case), or char* (special case).
     *
     * Send an event to allow the edit handler reallocStringi() to be called.
     * This reallocates the storage before update. The default method
     * copy-constructs a new IString but the user can override this
     * behavior to realloc a buffer in any other way.
     *
     * If the storage was reallocated successfully,
     * the new data is copied into the buffer using memcpy, and
     * the NULL terminating byte is set.
     */

    unsigned long newlen = newtext.length();  // excludes terminating NULL

    CNREDITDATA cnrEditData;
    cnrEditData.cb         = sizeof( CNREDITDATA );
    cnrEditData.hwndCnr    = cnrControlData->theIContainer->handle();
    cnrEditData.pRecord    = (PRECORDCORE)IRecFromObj( state.obj );
    cnrEditData.pFieldInfo = pfieldInfo;
    cnrEditData.ppszText   = (PSZ*)ppData;;
    cnrEditData.cbText     = newlen+1;            // note: +1
    cnrEditData.id         = CID_LEFTDVWND;

    /******************************************/
    /* Call edit handler reallocateString() here, which reallocates storage
     *
     * Remember that the user-written handler must realloc (newlen+1) bytes.
     */
    /******************************************/

    bool storageReallocated = cnrControlData->sendEventFromCnr(
                                      WM_COMMAND,
                                      IEventData(0,CN_REALLOCPSZ),
                                      &cnrEditData );
#if 1
    if( storageReallocated ) { // if reallocated, copy the data
        // copy the new data to the reallocated storage
        memcpy( *ppData, (char*)(IString&)newtext, newlen );
        (*ppData)[ newlen ] = '\0';
    }
#else         // to clarify - this is what the handler does
    if( ! storageReallocated ) { // if not reallocated, reallocate it yourself
       IString * pIString = (IString*)ppData;
       *pIString = IString( (void*)NULL, newlen );  // buffer initialization
    }

    // copy the new data to the reallocated storage
    memcpy( *ppData, (char*)(IString&)newtext, newlen );
    (*ppData)[ newlen ] = '\0';
#endif
    return true;
}

/*------------------------------------------------------------------------------
| userDetailsEntry                                                             |
------------------------------------------------------------------------------*/
bool ICnrDirectEdit::userDetailsEntry( char** & ppData,
                                       PFIELDINFO & pFieldInfo )
{
    IMiniCnrRecord* pcnrrec = IRecFromObj( state.obj );
    pFieldInfo =  cnrControlData->colInfo( state.col );

    ppData = (char**)( ((char*)pcnrrec) + (pFieldInfo->offStruct) );

    /* To determine whether the entry is a user entry or
     * the default icon text entry, check the address of the
     * data pointer
     */
    if( (IString*) ppData != & pcnrrec->strIcon )
        return true;
    else
        return false;
}

/*------------------------------------------------------------------------------
| locateForEdit                                                                |
------------------------------------------------------------------------------*/
ICnrDirectEdit::EditState ICnrDirectEdit::locateForEdit(
                             int x, int y,
                             unsigned short & colPos,
                             IContainerObject* & obj,
                             IContainerColumn* & col )
{
   ::Boolean columnHeading;
   int columnIndex;
   EditState state = editingNothing;

   Widget widget = XuiclPointerInfo( cnrControlData->container, x, y,
                                      &columnIndex, &columnHeading, NULL );

   if( widget == 0 ) return editingNothing;

   if( columnIndex >= 0 )
   {
       colPos = (unsigned short)columnIndex;
       col = visibleColumn( colPos );
       if( columnHeading )
       {                                     /* details view column heading */
           state = editingDetailsHeading;
           obj = NULL;
       }
       else                                  /* details view item  */
       {
           state = editingDetailsView;
           obj = IObjFromGadget( widget );
       }
   }
   else  /* columnIndex < 0 */
   {                                         /* record */
       state = editingRecord;
       col = NULL;
       obj = IObjFromGadget( widget );
   }

   return state;
}

/*------------------------------------------------------------------------------
| visibleColumn                                                                |
------------------------------------------------------------------------------*/
IContainerColumn * ICnrDirectEdit::visibleColumn( unsigned short colPos )
{
   ColumnSequenceType & colSeq = cnrControlData->columnSeq;

   ColumnSequenceType::Cursor cursor(colSeq);
   IContainerColumn * col = NULL;
   int i = 0;

   for( cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
   {
       if( colSeq.elementAt(cursor)->isVisible() )
       {
           if( i++ == colPos )
           {
              col = colSeq.elementAt(cursor);
              break;
           }
       }
   }
   return col;
}

/*------------------------------------------------------------------------------
| openMle                                                                      |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::openMle( const IString & val )
{
   /* Get:
   *          text to edit
   *          co-ords for positioning the mle
   *          font
   *
   * Set some state in ICnrControlData
   */

  Arg args[20]; int n,i,j;
  ::Boolean result;
  Position x = 0;
  Position y = 0;
  XmFontList fontList;   // no need to free the fontList afterwards
  IWindowHandle gadget;
  unsigned char xAlignment ;
  Dimension titleHeight(0), titleWidth(0) ;

  n=0;
  XtSetArg(args[n], XmNfontList, &fontList ); n++;
  XtGetValues(cnrControlData->container, args, n );

  // if title is showing, need to shift MLE's position down by
  // height of title label
  Dimension yTitleOffset(0) ;
  if (cnrControlData->theIContainer->isTitleVisible())
     XtVaGetValues(cnrControlData->titleLabel,
                   XmNheight, &yTitleOffset,
                   NULL ) ;

  switch( state.current )
  {
     case editingTitle:
     {
        yTitleOffset = 0 ;
        result = true ;
        Arg args[10] ;
        Cardinal n(0) ;
        Position xLabelPos(0), yLabelPos(0) ;
        XmFontList titleFontList ;
        XmString labelTitle ;
        XtSetArg(args[n], XmNheight,      &titleHeight) ;     n++ ;
        XtSetArg(args[n], XmNwidth,       &titleWidth) ;      n++ ;
        XtSetArg(args[n], XmNfontList,    &titleFontList );   n++;
        XtSetArg(args[n], XmNlabelString, &labelTitle );      n++;
        XtSetArg(args[n], XmNx,           &xLabelPos );       n++;
        XtSetArg(args[n], XmNy,           &yLabelPos );       n++;
        XtSetArg(args[n], XmNalignment,   &xAlignment );      n++;
        XtGetValues(cnrControlData->titleLabel, args, n) ;
        Dimension w(0), h(0) ;
        XmStringExtent(titleFontList, labelTitle, &w, &h) ; // find out text rectangle
        XmStringFree(labelTitle) ;
        x = (int) ((titleWidth  - w) / 2) + xLabelPos;
        y = (int) ((titleHeight - h) / 2) + yLabelPos ;
        break ;
     }
     case editingRecord: {
       gadget = IGadgetFromObj( state.obj, cnrControlData->theIContainer );

       result = XuiclLocation( cnrControlData->container, gadget,
                               -1, &x, &y, NULL );
       break;
     }
     case editingDetailsView: {
       gadget = IGadgetFromObj( state.obj, cnrControlData->theIContainer );

       result = XuiclLocation( cnrControlData->container, gadget,
                               state.colIndex, &x, &y, NULL );
       break;
     }
     case editingDetailsHeading: {
       result = XuiclLocation( cnrControlData->container, (Widget)0,
                               state.colIndex, &x, &y, NULL );
       break;
     }
  }

  if( result == False ) return;

  if( ! imle )
  {
     createMle();
  }

  // get the background color, in case it has changed from the default
  // then set the new color
  Pixel backgroundColor;
  XtVaGetValues(cnrControlData->container,
                XmNbackground, &backgroundColor, NULL );
  IXmColor::setBackgroundColor( mleText, backgroundColor );

  /*  calculate nrows and ncolumns for sizing XmText widget
   */
  short nrows = 1 + val.occurrencesOf("\n");
  short ncols = 0;
  for( n=0,i=1,j=i; n < nrows ; n++ ) {
    j = val.indexOf( '\n', i );
    if( j < i ) {
      j = val.length() + 1;  // last row
    }
    ncols = ( ncols < j-i )? j-i: ncols;   // MAX( ncols, j-i );
    i = j+1;
  }

  n=0;
  XtSetArg(args[n], XmNfontList, fontList ); n++;
  XtSetArg(args[n], XmNvalue, (char*)val ); n++;
  XtSetArg(args[n], XmNrows, nrows); n++;
  XtSetArg(args[n], XmNcolumns, ncols ); n++;
  XtSetValues( mleText, args, n );

  /* y is positioned at the top of the text. Subtract the
   * Text XmNhighlightThickness and XmNshadowThickness and move the widget
   * to position it correctly
   */
  Dimension highlightThickness, shadowThickness, h, w;
  Dimension editWidth(0) ;
  n=0;
  XtSetArg(args[n], XmNhighlightThickness, &highlightThickness ); n++;
  XtSetArg(args[n], XmNshadowThickness,    &shadowThickness );    n++;
  XtSetArg(args[n], XmNmarginHeight,       &h ); n++;
  XtSetArg(args[n], XmNmarginWidth,        &w ); n++;
  XtSetArg(args[n], XmNwidth,              &editWidth ); n++;
  XtGetValues(mleText, args, n );

  if (state.current == editingTitle)
  {
     if (xAlignment == XmALIGNMENT_BEGINNING)
        x = 0 ;
     else if (xAlignment == XmALIGNMENT_END)
        x = titleWidth - editWidth  ;
  }

  x = x - ( w + highlightThickness + shadowThickness );
  y = y - ( h + highlightThickness + shadowThickness );
  y += yTitleOffset ;
  // we want the MLE to be completely in the widget, not half-hidden behind
  // some screen decorations
  if (x < 0) x = 2  ;
  if (y < 0) y = 2  ;

  n=0;
  XtSetArg(args[n], XmNx, x ); n++;
  XtSetArg(args[n], XmNy, y ); n++;
  XtSetValues( mleText, args, n );
  /* now manage the widget to make it visible */
  XtManageChild(mleText);

  // set the currentEditMLE, (cleared on dismissEdit)
  cnrControlData->theIContainer->setEditMLE( imle );

  CNREDITDATA cnrEditData;   // used for WM_COMMAND

  setupEditData( cnrEditData );

  cnrEditData.cbText = 0;    // override! (must be 0 for CN_BEGINEDIT)

  // send an open edit event
  cnrControlData->sendEventFromCnr( WM_COMMAND,
                                    IEventData(0,CN_BEGINEDIT),
                                    &cnrEditData );

  // if the mle is ineligible to receive the input focus, dismiss and return
  if( ! XmIsTraversable( mleText ) )
  {
    dismissMle();
    return;
  }
  else
  {
    // save the old focus so you can give it back afterwards
    prevFocusWidget = XmGetFocusWidget( (Widget) cnrControlData->container );

    // set the focus to the container if it doesn't already have it
    if( ! cnrControlData->theIContainer->hasFocus() )
    {
       cnrControlData->theIContainer->setFocus();
    }

    // save the prev focus, if not alreay saved
    if( prevFocusWidget == NULL )
        prevFocusWidget = XmGetFocusWidget((Widget) cnrControlData->container);

    // set the focus to the mle
    imle->setFocus();
  }
}

/*------------------------------------------------------------------------------
| dismissMle                                                                   |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::dismissMle()
{
  if( (!dismissInProgress) && mleManaged() )
  {
    dismissInProgress = true;

    CNREDITDATA cnrEditData;

    setupEditData( cnrEditData );

    // Send a close edit event.
    //
    // The close edit event ends up calling ICnrEditHandler::endEdit()
    // which has access to the container and can execute methods on it.
    // These methods can change the state of the container. The one case
    // we know about is when the ICnrEditEvent query methods are called,
    // such as ICnrEditEvent::isDetailsData(). This updates the container
    // attribute object. However if you were in the process of changing
    // the container state, the update can over write your changes.
    // So to prevent these situations, we need to save and restore some
    // state information. We use ICnrControlData::ICnrEditState for this
    // purpose.
    // Note that dismissInProgress serialises ICnrState.

    cnrControlData->saveEditState();

    cnrControlData->sendEventFromCnr( WM_COMMAND,
                                      IEventData(0,CN_ENDEDIT),
                                      &cnrEditData );
    cnrControlData->restoreEditState();

    XtUnmanageChild( this->mleText );

    // set focus to widget that had focus before mle
    if( prevFocusWidget && XmIsTraversable( prevFocusWidget ) )
        XmProcessTraversal( prevFocusWidget, XmTRAVERSE_CURRENT );
    else
        cnrControlData->theIContainer->setFocus();
    prevFocusWidget = 0;

// disabled this code because it was interfering with direct edit
#if 0                       // !! This is temporary and needs to be eliminated
    // In details view, the first column icons sometimes do not get repainted
    // when the mle goes away. Workaround is to do a refresh.
    // In the long run, should try and get expose to work correctly.
    // Defect 4181 addresses this.
    if( cnrControlData->theIContainer->isDetailsView() )
    {
        IContainerControl::ColumnCursor
                  colCursor (*cnrControlData->theIContainer, true ); // visible
        colCursor.setToFirst();              // first visible column
        if( colCursor.isValid() )
        {
          IContainerColumn * col = colCursor.current();
          if( col->isIconHandle() )
            if( state.obj )              // editing object
            {
              Widget gadget = IGadgetFromObj( state.obj,
                                            cnrControlData->theIContainer,
                                            false );    // no exception!
              if( gadget && XmIsTraversable( gadget ) )
                 cnrControlData->theIContainer->refresh(); // try and eliminate
            }
            else if( state.col )         // editing column title
                 cnrControlData->theIContainer->refresh(); // try and eliminate
        }
    }
#endif

    // clear the currentEditMLE
    cnrControlData->theIContainer->setEditMLE( NULL );

    dismissInProgress = false;
  }
  state.clear();
}

/*------------------------------------------------------------------------------
| deleteMle                                                                    |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::deleteMle()
{
  delete imle;
  imle = NULL;
  mleText = 0;
  state.clear();
}

/*------------------------------------------------------------------------------
| setupEditData                                                                |
|                                                                              |
| Set up CNREDITDATA for CN_BEGINEDIT, CN_ENDEDIT (not used for CN_REALLOCPSZ) |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::setupEditData(CNREDITDATA & cnrEditData )
{
  if( state.current == editingNothing ) return;

  cnrEditData.cb         = sizeof( CNREDITDATA );
  cnrEditData.hwndCnr    = cnrControlData->theIContainer->handle();

  switch( state.current )
  {
     case editingRecord:
     {
       cnrEditData.pRecord    = (PRECORDCORE)IRecFromObj( state.obj );
       cnrEditData.pFieldInfo = NULL;
       cnrEditData.ppszText   = (char**)&cnrEditData.pRecord->strIcon;
       cnrEditData.cbText     = cnrEditData.pRecord->strIcon.length() + 1;
       cnrEditData.id         = 0; // note, by convention this is set to id(),
                                   //    ie cnrControlData->theIContainer->id()
                                   //    but this can lead to ambiguous results
       break;
     }
     case editingDetailsView:
     {
       cnrEditData.pRecord    = (PRECORDCORE)IRecFromObj( state.obj );
       userDetailsEntry( cnrEditData.ppszText, cnrEditData.pFieldInfo );
       cnrEditData.cbText     = IString( *cnrEditData.ppszText ).length()+1;
       cnrEditData.id         = CID_LEFTDVWND;
       break;
     }
     case editingDetailsHeading:
     {
       cnrEditData.pRecord    = NULL;
       cnrEditData.pFieldInfo = cnrControlData->colInfo( state.col );
       cnrEditData.ppszText   = (char**)&cnrEditData.pFieldInfo->pTitleData;
       cnrEditData.cbText     = IString( *cnrEditData.ppszText ).length()+1;
       cnrEditData.id         = CID_LEFTCOLTITLEWND;
       break;
     }
     case editingTitle:
     {
       cnrEditData.pRecord    = NULL;
       cnrEditData.pFieldInfo = NULL;
       cnrEditData.ppszText   = (char **) &(cnrControlData->theIContainer->strContainerTitle) ;
       cnrEditData.cbText     = (cnrControlData->theIContainer->strContainerTitle).length()+1;
       cnrEditData.id         = CID_CNRTITLEWND ;
       break;
     }
  }
}

/*------------------------------------------------------------------------------
| mleManaged                                                                   |
------------------------------------------------------------------------------*/
bool ICnrDirectEdit::mleManaged()
{
   return (mleText && XtIsManaged( mleText ));
}

/*------------------------------------------------------------------------------
| editEvents                                                                   |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::mleEvents( Widget widget_id,
                                XtPointer client_data,
                                XEvent * call_data,
                                ::Boolean * continue_to_dispatch
                                )
{
  ICnrControlData * controlData = (ICnrControlData*)client_data;

  ICnrDirectEdit * This = controlData->directEdit;

  KeySym keysym;
  XKeyEvent * xkey;

  switch( call_data->xany.type )
  {
    case KeyPress: {

      xkey = &call_data->xkey;
      XLookupString( xkey, NULL, 0, &keysym, NULL );

      switch( keysym ) {
        case XK_Alt_L:
        case XK_Alt_R: {
          This->state.altKeyPressed = true;
          break;
        }
      }
      break;
    }
    case KeyRelease: {

      xkey = &call_data->xkey;

      XLookupString( xkey, NULL, 0, &keysym, NULL );
      switch( keysym )
      {
        case XK_Escape: {
          This->dismissMle(); /* dismiss the mle */
          break;
        }
        case XK_Alt_L:
        case XK_Alt_R: {
          if( This->state.altKeyPressed == true ) {
              This->dismissMle(); /* sets state.altKeyPressed False */
          }
          break;
        }
        default: {
          break;
        }
      }
      break;
    }
    default: {
      break;
    }
  }
}

/*------------------------------------------------------------------------------
| beginEdit - invoked by translations                                          |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::beginEdit(
           Widget w, XEvent *ev, String *params, Cardinal *numParams)
{
  IFUNCTRACE_DEVELOP();

  bool doingTitle(false) ;
  Widget thisWidget(NULL) ;

  // get the outermost XiclCanvas widget since ICLUI knows us via that widget
  if (XmIsLabel(w)) {
     thisWidget = XtParent(XtParent(w)) ;
     doingTitle = true ;
  }
  else if (XmIsContainer(w)) {
     thisWidget = XtParent(XtParent(XtParent(XtParent(w)))) ;
  }

  IContainerControl * icnr =
     (IContainerControl*)IWindow::windowWithHandle( thisWidget );

  if( icnr )
  {
     ICnrDirectEdit * This = icnr->ppd->directEdit;
     XButtonPressedEvent * xbutton = &ev->xbutton;

     switch (This->state.current)
     {
       case editingDetailsView:
       case editingDetailsHeading:
       case editingRecord:
       case editingTitle:
         This->update();
#if DETECT_OVERFLOW
         /* check XmContainer oveflow condition */
         icnr->ppd->overflow.check( icnr, 0, true );  // keyboardEvent
#endif
         This->dismissMle();                // set state to editingNothing
         break;
       default:
         break;
     }

     if (doingTitle)
        This->editCnrTitle() ;
     else
        This->openEdit( xbutton->x, xbutton->y );
  } // cnr
} // BeginEdit

/*------------------------------------------------------------------------------
| bbEvents                                                                     |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::bbEvents( Widget widget_id,
                               XtPointer client_data,
                               XEvent * call_data,
                               ::Boolean * continue_to_dispatch )
{
  ICnrControlData * controlData = (ICnrControlData*)client_data;

  ICnrDirectEdit * This = controlData->directEdit;

  switch( call_data->xany.type )
  {
    case ButtonPress: {
      XButtonPressedEvent * xbutton = &call_data->xbutton;
      if( xbutton->button == Button1 )              // Button1Down
      {
        switch( This->state.current )
        {
          case editingDetailsView:
          case editingDetailsHeading:
          case editingRecord:
          case editingTitle:
            This->update();
#if DETECT_OVERFLOW
            /* check XmContainer oveflow condition */
            controlData->overflow.check( controlData->theIContainer, 0, true );
#endif
            This->dismissMle();                // set state to editingNothing
            break;
          default:
            break;
        } // switch(state.current)
      }
      break;
    }
    default:
       break;
  } // switch(type)
}

/*------------------------------------------------------------------------------
| State                                                                        |
------------------------------------------------------------------------------*/
ICnrDirectEdit::State::State()
              : current(editingNothing)
              , col(NULL)
              , colIndex(0)
              , obj(NULL)
              , altKeyPressed(false)
{
}

/*------------------------------------------------------------------------------
| State::clear                                                                 |
------------------------------------------------------------------------------*/
void ICnrDirectEdit::State::clear()
{
    current = editingNothing;
    col = NULL;
    colIndex = 0;
    obj = NULL;
    altKeyPressed = false;
}

/*------------------------------------------------------------------------------
| ICnrState                                                                    |
------------------------------------------------------------------------------*/
ICnrDirectEdit::ICnrState::ICnrState()
                          : flWindowAttr(0)
{
}

/*------------------------------------------------------------------------------
| ICnrEditState::save                                                          |
------------------------------------------------------------------------------*/
void ICnrControlData::saveEditState()
{
  // See ICnrDirectEdit::dismissMle() for the rationale for this method
  //
  directEdit->cnrState.flWindowAttr = theIContainer->pcnrinfoCl->flWindowAttr;
}

/*------------------------------------------------------------------------------
| ICnrEditState::restore                                                       |
------------------------------------------------------------------------------*/
void ICnrControlData::restoreEditState()
{
  // See ICnrDirectEdit::dismissMle() for the rationale for this method
  //
  theIContainer->pcnrinfoCl->flWindowAttr = directEdit->cnrState.flWindowAttr;
}

/*------------------------------------------------------------------------------
| IPointerElement::IPointerElement                                             |
| Elements for the ICnrPointerSet class.  Each represents the currently used   |
| pixmap of an IconGadget in the container widget. We keep this list so that   |
| the pixmaps used for mini and scaled icons are not reference counted out of  |
| existence                                                                    |
------------------------------------------------------------------------------*/
IPointerElement::IPointerElement( const IPointerHandle& pointer,
                                  const Widget&         gadget  )
: pointerHandle(pointer)
{
   lph = (unsigned long) gadget ;
}

/*------------------------------------------------------------------------------
| IPointerElement::~IPointerElement                                            |
------------------------------------------------------------------------------*/
IPointerElement::~IPointerElement( )
{
}

/*------------------------------------------------------------------------------
| ICnrPointerSet::ICnrPointerSet                                               |
| A set of pointer handles that reflect the pixmaps used when we are showing   |
| mini or scaled icons                                                         |
------------------------------------------------------------------------------*/
ICnrPointerSet::ICnrPointerSet()
  // Initially allocate 20 IPointerElements
: IKeySet < IPointerElement*, unsigned long > ( 20 )
{}

/*------------------------------------------------------------------------------
| ICnrPointerSet::~ICnrPointerSet                                              |
------------------------------------------------------------------------------*/
ICnrPointerSet::~ICnrPointerSet()
{
   empty() ;
}

/*------------------------------------------------------------------------------
| ICnrPointerSet::empty                                                        |                                                                              |
------------------------------------------------------------------------------*/
ICnrPointerSet& ICnrPointerSet::empty()
{
   ICnrPointerSet::Cursor cursor(*this);

   forCursor (cursor)
     delete this->elementAt( cursor );

   this->removeAll();

   return *this ;
}

/*------------------------------------------------------------------------------
| ICnrPointerSet::addPointerElement                                            |                                                                              |
------------------------------------------------------------------------------*/
ICnrPointerSet& ICnrPointerSet::addPointerElement( const IPointerHandle& pointer,
                                                   const Widget&         gadget  )
{
  IFUNCTRACE_DEVELOP() ;

  unsigned long elementKey = (unsigned long) gadget ;
  ICnrPointerSet::Cursor cursor(*this) ;
  if (locateElementWithKey(elementKey, cursor))
  {
     delete this->elementAt(cursor) ;
     removeAt(cursor) ;
  }

  IPointerElement* newPointerElement(new IPointerElement(pointer, gadget));
  this->add( newPointerElement );
  return *this;
}

#if DETECT_OVERFLOW
/*------------------------------------------------------------------------------
| ICnrControlData::Overflow::Overflow                                          |
------------------------------------------------------------------------------*/
ICnrControlData::Overflow::Overflow( )
                          : lastEventId(0)
{ }

/*------------------------------------------------------------------------------
| ICnrControlData::Overflow::~Overflow                                         |
------------------------------------------------------------------------------*/
ICnrControlData::Overflow::~Overflow( )
{ }

/*------------------------------------------------------------------------------
| ICnrControlData::Overflow::check                                             |
| Check widget layout overflow. Call XmNoveflowCallback                        |
------------------------------------------------------------------------------*/
void ICnrControlData::Overflow::check( const IContainerControl * cnrCtl,
                      unsigned long eventId, bool keyboardEvent )
{
  /* Gadget overflow count in XmContainer widget might have been set
   * during one of the Layout's. Clear it and call overflow callback list.
   */

  Widget wid = cnrCtl->handleForChildCreation(); 
  int n = XuiclGetOverflowCount( wid );   /* also clears count */

  if( n == 0 ) return;  /* no need to continue if no overflow present */

  /* We need to maintain the state of the previous event id to prevent
   * cascade of callbacks. For example you only want one callback
   * invocation when adding multiple objects to the container.
   */

  bool ignore_overflow = false;

  switch( eventId )
  {
    case CM_INSERTRECORD:
    case CM_REMOVERECORD:
                          if( ! cnrCtl->isRefreshOn() )
                          {
                             lastEventId = 0;
                             ignore_overflow = true;
                          }
                          break;
    case CM_INVALIDATERECORD:
                          if( cnrCtl->isRefreshOn() )
                          {
                             if( lastEventId == eventId )
                             {
                                 lastEventId = 0;
                                 ignore_overflow = true;
                             }
                          }
                          else  /* refresh off */
                          {
                             lastEventId = 0;
                             ignore_overflow = true;
                          }
                          break;
    default: break;
  }
  if( ignore_overflow ) return;     /* No need to continue */

  if( ! keyboardEvent )
      lastEventId = eventId;        /* save lastEventId */
  else
      lastEventId = 0;              /* on keyboardEvent, clear lastEventId */

  /* call user callbacks
   */
  XmContainerOverflowCallbackStruct cbs;
  cbs.event  = NULL;
  cbs.item   = wid;
  cbs.overflowCount = n;
  if( keyboardEvent )
  {
      cbs.reason = XmCR_KBEVENT;        // Keyboard Event
  }
  else
  {
      cbs.reason = XmCR_CMEVENT;        // Command Event
  }
  XtCallCallbacks( wid, XmNoverflowCallback, (XtPointer)&cbs );
}
#endif  /* DETECT_OVERFLOW */
