// Revision: 89 1.5.1.7 source/ui/cnr/icnrctl8.cpp, container, ioc.v400, 001006  
/*******************************************************************************
* FILE NAME: icnrctl8.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of the sorting and filtering         *
*   functions for class IContainerControl, declared in icnrctl.hpp.            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#define INCL_WINSTDCNR
#define INCL_WINCOUNTRY
#define INCL_DOSNLS

#include <icnrrec.hpp>  // Must be first for OS flags

#include <icnrctl.hpp>
#include <iexcept.hpp>
#include <itrace.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _ICNRCTL8_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
#include <icnrctlm.hpp>
#include <string.h>
#endif

#ifdef IC_PMWIN
#include <icnrctlw.hpp>
#endif

/*------------------------------------------------------------------------------
   Imbedded classes: definition and implementation
------------------------------------------------------------------------------*/
#pragma enum(4)
#pragma pack(push,4)

class ICnrSortPackage {
public:
const IContainerControl::CompareFn
 *pCompareFn;

IContainerControl
 *pcnrctl;
}; // ICnrSortPackage

class ICnrFilterPackage {
public:
const IContainerControl::FilterFn
 *pFilterFn;

IContainerControl
 *pcnrctl;
}; // ICnrFilterPackage

// Keep the compiler from generating the following statically
IContainerControl::FilterFn::FilterFn ( ) { }
IContainerControl::FilterFn::~FilterFn ( ) { }
IContainerControl::CompareFn::CompareFn ( ) { }
IContainerControl::CompareFn::~CompareFn ( ) { }

class ICnrSortByIcon : public IContainerControl::CompareFn {
public:
  ICnrSortByIcon ( bool ascending );
 ~ICnrSortByIcon ( );
int
  isEqual ( IContainerObject*  pcnrobj1,
            IContainerObject*  pcnrobj2,
            IContainerControl* pcnrctl ) const;
private:
bool
  fAscending;
}; // ICnrSortByIcon

#pragma pack(pop)
#pragma enum(pop)

/* Functions to sort by icon */
ICnrSortByIcon :: ICnrSortByIcon (bool ascending) : fAscending(ascending) {}
ICnrSortByIcon :: ~ICnrSortByIcon ( ) {}
int ICnrSortByIcon :: isEqual( IContainerObject*  pcnrobj1,
                               IContainerObject*  pcnrobj2,
                               IContainerControl* pcnrctl) const
{

 if(fAscending)
    return pcnrctl->nlsCompare( pcnrobj1->iconText(),
                                pcnrobj2->iconText());
 else
    return pcnrctl->nlsCompare( pcnrobj2->iconText(),
                                pcnrobj1->iconText());
}

#pragma enum(4)
#pragma pack(push,4)

class ICnrFilterNone : public IContainerControl::FilterFn {
public:
  ICnrFilterNone ( );
 ~ICnrFilterNone ( );
virtual bool
  isMemberOf ( IContainerObject*  object,
               IContainerControl* container ) const;
}; // ICnrFilterNone

#pragma pack(pop)
#pragma enum(pop)

bool ICnrFilterNone :: isMemberOf( IContainerObject* object,
                IContainerControl* container) const
{ return true; }

ICnrFilterNone::ICnrFilterNone ( ) { }
ICnrFilterNone::~ICnrFilterNone ( ) { }


/*-----------------------------------------------------------------------------
 Function Name:  IContainerControl__compare

 Implementation: Non-member function to compare two objects text.
------------------------------------------------------------------------------*/
#ifdef IC_PMWIN

#ifdef IC_WIN
long  CALLBACK
#endif
#ifdef IC_PM
long  _System
#endif
IContainerControl__compare ( const IMiniCnrRecord* pcnrrec1,
                             const IMiniCnrRecord* pcnrrec2,
                             ICnrSortPackage*      pSortPackage )
{
   long ulReturn;
   if(pSortPackage)
   {
     if (pSortPackage->pcnrctl->ppd->pmCompatible)
       ulReturn = pSortPackage->pCompareFn->isEqual( IObjFromRec(pcnrrec1),
                                            IObjFromRec(pcnrrec2),
                                            pSortPackage->pcnrctl);
     else
       ulReturn = pSortPackage->pCompareFn->isEqual(
                                              (IContainerObject*)pcnrrec1,
                                              (IContainerObject*)pcnrrec2,
                                              pSortPackage->pcnrctl);
   }
   else
      ulReturn = IContainerControl::nlsCompare(pcnrrec1->strIcon, pcnrrec2->strIcon);

   return ulReturn;
}
#endif //IC_PMWIN

#ifdef IC_MOTIF
// The sorting is done in the Container widget since it must manipulate
// the linked list of CwidNodes that it maintains. But you can't get
// the widget to pass you MiniRecordCore's. It can get an IContainerObject
// from the IconGadget's userData. That will do the job...

long _System IContainerControl__compare ( IContainerObject* pObj1,
                                          IContainerObject* pObj2,
                                          ICnrSortPackage*  pSortPackage )
{
   long ulReturn;
   if(pSortPackage)
       ulReturn = pSortPackage->pCompareFn->isEqual( pObj1,
                                          pObj2,
                                          pSortPackage->pcnrctl);
   else
      ulReturn = IContainerControl::nlsCompare(pObj1->iconText(),
                                               pObj2->iconText());

   return ulReturn;
}
#endif


/*-----------------------------------------------------------------------------
 Function Name: IContainerControl :: sort

 Implementation: Sort by the User Defined Sort function.
------------------------------------------------------------------------------*/
IContainerControl& IContainerControl :: sort(const IContainerControl::CompareFn& sortFunction)
{
   ICnrSortPackage cnrsort = {&sortFunction, this};

   unsigned fSuccess = sendEvent( CM_SORTRECORD,
                                 MPFROMP(IContainerControl__compare),
                                 MPFROMP(&cnrsort));
   if(!fSuccess)
   {
      ITHROWGUIERROR("CM_SORTRECORD");
   }
   return *this;
}


/*-----------------------------------------------------------------------------
 Function Name: IContainerControl__filter

 Implementation: Non-memeber filter function.
------------------------------------------------------------------------------*/
#ifdef IC_WIN
bool CALLBACK IContainerControl__filterFn( const IMiniCnrRecord* pcnrrec,
                                           ICnrFilterPackage* pFilterPackage)
#endif
#ifdef IC_MOTIFPM
bool _System IContainerControl__filterFn( const IMiniCnrRecord* pcnrrec,
                                          ICnrFilterPackage* pFilterPackage)
#endif
{
   return pFilterPackage->pFilterFn->isMemberOf(IObjFromRec(pcnrrec), pFilterPackage->pcnrctl);
}


/*-----------------------------------------------------------------------------
 Function Name: IContainerControl :: filter

 Implementation: Filter the container with User Defined Filter.
------------------------------------------------------------------------------*/
IContainerControl& IContainerControl :: filter(const IContainerControl::FilterFn& filterFn)
{
   ICnrFilterPackage cnrfilter = {&filterFn, this};

   unsigned fSuccess = true;
   // Only filter the container if there are objects as the WC_CONTAINER
   // views this as an error

#ifdef IC_PMWIN
   ICnrInfo cnrInfo;
   containerInfo(&cnrInfo);
#endif
#ifdef IC_MOTIF
   // The below is temporary code. It verifies that the container has
   // at least one object in it, and is a replacement for not calling
   // the containerInfo function which is not yet fully implemented
   // on AIX.
   ICnrIGCursor cursor(this);
   cursor.setToFirst();
   if (cursor.isValid())
#endif
#ifdef IC_PMWIN
   if (cnrInfo.cRecords > 0)
#endif
      fSuccess = sendEvent( CM_FILTER,
                            MPFROMP(IContainerControl__filterFn),
                            &cnrfilter);
   if(!fSuccess)
      ITHROWGUIERROR("CM_FILTER");
   return *this;
}


/*-----------------------------------------------------------------------------
 Function Name: IContainerControl :: filter

 Implementation: Restore filtered item in the container.
------------------------------------------------------------------------------*/
IContainerControl& IContainerControl :: filter()
{
   ICnrFilterNone filterNone;
   ICnrFilterPackage cnrfilter = {&filterNone, this};

   unsigned fSuccess = true;
   // Only filter the container if there are objects as the WC_CONTAINER
   // views this as an error
#ifdef IC_PMWIN
   ICnrInfo cnrInfo;
   containerInfo(&cnrInfo);
#endif
#ifdef IC_MOTIF
   // The below is temporary code. It verifies that the container has
   // at least one object in it, and is a replacement for not calling
   // the containerInfo function which is not yet fully implemented
   // on AIX.
   ICnrIGCursor cursor(this);
   cursor.setToFirst();
   if (cursor.isValid())
#endif
#ifdef IC_PMWIN
   if (cnrInfo.cRecords > 0)
#endif
      fSuccess = sendEvent( CM_FILTER,
                            MPFROMP(IContainerControl__filterFn),
                            &cnrfilter);
   if(!fSuccess)
      ITHROWGUIERROR("CM_FILTER");

   return *this;
}


/*-----------------------------------------------------------------------------
 Function Name: IContainerControl :: sortByIconText

 Implementation: Sort the container by the icons text.
------------------------------------------------------------------------------*/
IContainerControl& IContainerControl :: sortByIconText(bool ascending)
{
   ICnrSortByIcon iconSort(ascending);
   return sort(iconSort);
}


/*-----------------------------------------------------------------------------
 Function Name: IContainerControl :: nlsCompare

 Implementation: Compare two strings with National Language Support.
------------------------------------------------------------------------------*/
long IContainerControl :: nlsCompare(const char* pszString1,
                                      const char* pszString2)
{
  IASSERT(pszString1!=0 && pszString2!=0);

  unsigned long  ulLength = 0;
#ifdef IC_MOTIFWIN
  long ulResult = 0;
#endif
#ifdef IC_PM
  unsigned long  ulResult = 0;
#endif
  long      lCompare = 1;

#ifdef IC_PM
  COUNTRYCODE cntry;
  COUNTRYINFO cntryinfo;
  cntry.country = 0;
  cntry.codepage = 0;

  ulResult = DosGetCtryInfo(sizeof(cntryinfo),
                        &cntry,
                        &cntryinfo,
                        &ulLength);

  if (ulResult==0)
  {
     ulResult = WinCompareStrings ((HAB)0, cntry.codepage,
                                    cntry.country,
                                    (PSZ)pszString1,
                                    (PSZ)pszString2,
                                    0);
     if (ulResult == WCS_EQ)
        lCompare = 0;
     else if (ulResult == WCS_LT)
        lCompare = -1;
     else   /* greater then by default */
        lCompare = 1;
  }
#endif //IC_PM

#ifdef IC_MOTIFWIN
#ifdef IC_MOTIF
  ulResult = strcoll(pszString1, pszString2);
#endif
#ifdef IC_WIN
  ulResult = lstrcmp(pszString1, pszString2);
#endif

  if (ulResult == 0)
     lCompare = 0;
  else if (ulResult < 0)
     lCompare = -11;
  else   /* greater then by default */
     lCompare = 1;


#endif //IC_MOTIFWIN

  return lCompare;
}
