#ifndef _SLIDERP_
#define _SLIDERP_

/* Revision: 62 1.5.1.1 source/ui/cclnt/slider/sliderp.h, cclslid, ioc.v400, 001006  */
/**********************************************************************/
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*        (IBM Confidential-Restricted when combined with the         */
/*         aggregated OCO source modules for this program)            */
/*                                                                    */
/*                       OCO SOURCE MATERIALS                         */
/*                                                                    */
/*         20G0400 (C) Copyright IBM Corp. 1992, 1997 (Unpublished)   */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/*                                                                    */
/*                           S L I D E R                              */
/*                                                                    */
/*                       Filename: SLIDERP.H                          */
/*                                                                    */
/*              ( Windows NT Slider Control Component )               */
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*                (C) Copyright IBM Corporation 1997                  */
/*                       All Rights Reserved                          */
/*            Licensed Material - Program Property of IBM             */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/* Product: SLIDER.DLL                                                */
/* Filename: SLIDERP.H - Private include file for the Slider control  */
/*                                                                    */
/* Flag    Date    By:  Description                                   */
/* ----  --------  ---  --------------------------------------------- */
/* JEH1  06/21/93  JEH  Initial modifications for NT execution        */
/* EVB2  10/26/95  EVB  NT QueryPresParam add                         */
/**********************************************************************/
#if defined(__IBMC__)
#pragma info(nocnd)
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#define QWL_USER              0

/**********************************************************************/
/*                                                                    */
/**********************************************************************/
#ifndef IDOF                                                            /*DAB2*/
#define IDOF(hwnd)            (GetWindowLong( hwnd, GWL_ID ))           /*DAB2*/
#endif                                                                  /*DAB2*/
#ifndef STYLEOF                                                         /*DAB2*/
#define STYLEOF(hwnd)         (GetWindowLong( hwnd, GWL_STYLE ))        /*DAB2*/
#endif                                                                  /*DAB2*/
#ifndef PARENTOF                                                        /*DAB2*/
#define PARENTOF(hwnd)        (GetParent( hwnd ))                       /*DAB2*/
#endif                                                                  /*DAB2*/

/**********************************************************************/
/* Linked list structure for saving Slider application instance info  */
/**********************************************************************/
typedef struct _INSTDATA {
  HANDLE   hInstance;             /* application's instance handle    */
  struct   _INSTDATA NEAR *pNext; /* pointer to the next instance node*//*JEH1*/
  USHORT     iUseCount;           /* usage count                      *//*JEH1*/
} INSTDATA, NEAR *PINSTDATA;

typedef PINSTDATA NEAR *PPINSTDATA;

/**********************************************************************/
/* Linked list structure for saving tick information                  */
/**********************************************************************/
typedef struct _TICKDATA
{
  NPSTR    pszText;              /* Pointer to text string            *//*JEH1*/
  struct   _TICKDATA *pNext;     /* pointer to the next tick node     *//*JEH1*/
  USHORT   usTickNum;            /* Tick number                       *//*JEH1*/
  USHORT   usScale;              /* Scale tick is on ( 1 or 2 )       *//*JEH1*/
  USHORT   usTickSize;           /* Size of tick at position          *//*JEH1*/
} TICKDATA, *PTICKDATA;

/**********************************************************************/
/* Linked list structure for saving detent information                */
/**********************************************************************/
typedef struct _DETENTDATA
{
  USHORT   usDetentPos;            /* Detent position from home       *//*JEH1*/
  USHORT   usScale;                /* Scale set on ( 1 or 2 )         *//*JEH1*/
  struct   _DETENTDATA *pNext;     /* pointer to the next detent node */
} DETENTDATA, *PDETENTDATA;

/**********************************************************************/
/* Linked list structure for saving slider task handles               */
/**********************************************************************/
typedef struct _THDATA  /* pd */
{
  HANDLE   hCurrentTask;           /* link list task handle           */
  HDC      hdcMem;                 /* memory device context - jdr     */
  struct   _THDATA *pthNext;       /* pointer to the next th node     */
  struct   _THDATA *pthPrev;       /* pointer to the next th node     */
} THDATA, *PTHDATA;

/**********************************************************************/
/* Internal control block                                             */
/**********************************************************************/
typedef struct _ISLDDATA
{
  RECT      rclSliderArm;       /* position of slider arm bitmap      */
  HBITMAP   hbmArm;             /* Bitmap for slider arm              */
  PTICKDATA pTickData;          /* Linked list for Scale information  */
  PDETENTDATA pDetentData;      /* Linked list for detent information */
  HFONT     hSliderFont;        /* The font to use for slider's text  *//*JEH1*/
  ULONG     ulColorVal[2];      /* Color array for slider painting    *//*JEH1*/
  ULONG     ulStyle;            /* Style of slider last used          *//*JEH1*/
  USHORT    usScale1Increments; /* # of divisions on ruler scale      *//*JEH1*/
  USHORT    usScale1Spacing;    /* Space in pels between increments   *//*JEH1*/
  USHORT    usScale2Increments; /* # of divisions on ruler scale      *//*JEH1*/
  USHORT    usScale2Spacing;    /* Space in pels between increments   *//*JEH1*/
  SHORT     xButton;            /* Slider button position (x coord)   *//*JEH1*/
  SHORT     yButton;            /* Slider button position (y coord)   *//*JEH1*/
  SHORT     xShaft;             /* Slider shaft position (x coord)    *//*JEH1*/
  SHORT     yShaft;             /* Slider shaft position (y coord)    *//*JEH1*/
  USHORT    usArmPos;           /* Slider arm position (in pixels)    *//*JEH1*/
  USHORT    usArmBreadth;       /* Breadth of slider arm              *//*JEH1*/
  USHORT    usArmLength;        /* Length of slider arm               *//*JEH1*/
  USHORT    usShaftBreadth;     /* Breadth of slider shaft            *//*JEH1*/
  USHORT    usShaftLength;      /* Length of slider shaft             *//*JEH1*/
  USHORT    usPreviousArmPos;   /* Previous position (if drag cancel) *//*JEH1*/
  USHORT    usStatusSld;        /* Internal bit flags                 *//*JEH1*/
} ISLDDATA, *PISLDDATA;

/**********************************************************************/
/* Slider status flag definitions                                     */
/**********************************************************************/
#define FL_SLDHASFOCUS         0x0001  /* Set if slider has the focus */
#define FL_SLDINITIALSCALE2    0x0002  /* Set if ruler 2 first primary*/
#define FL_SLDDECREMENTDOWN    0x0004  /* Set if decr.button depressed*/
#define FL_SLDINCREMENTDOWN    0x0008  /* Set if incr.button depressed*/
#define FL_SLDINITIALTIMER     0x0010  /* Set when timer first started*/
#define FL_SLDBUTTONPRESS      0x0020  /* Set when button pressed     */
#define FL_SLDINITIALINCR      0x0040  /* Set when dragging arm       */
#define FL_SLDDRAGGINGARM      0x0080  /* Set when dragging arm       */
#define FL_SLDOWNERPOSITIONED  0x0100  /* Set if owner positions shaft*/
#define FL_SLDARMATLOWEND      0x0200  /* Set if arm reaches low end  */
#define FL_SLDARMATHIGHEND     0x0400  /* Set if arm reaches high end */
#define FL_AUTOINCREMENT1      0x0800
#define FL_AUTOINCREMENT2      0x1000
#define FL_SLDFOCUSCHANGE      0x2000  /* Indicates whether arm is    */
                                       /* being redrawn because of a  */
                                       /* focus change                */

/**********************************************************************/
/* Bit Settings for DrawMask                                          */
/**********************************************************************/
#define DI_START        0x0001
#define DI_SLIDE        0x0002
#define DI_END          0x0004
#ifndef MAKEHDC
#define HDCBIT          0x00000001L
#define MAKEHDC(hps)    (HDC)((ULONG)hps & ~HDCBIT)                     /*JEH1*/
#endif
#define VHAB            ((HAB) 0)

/**********************************************************************/
/* Equates for checking device resolution in GetDefaultSize           */
/**********************************************************************/
//#define EGA        0
//#define EGA_CX   640
//#define EGA_CY   350
//#define VGA        1          /* VGA is default if other resolution */
#define VGA_CX   640
#define VGA_CY   480
//#define BGA        2
//#define BGA_CX  1024
//#define BGA_CY   768

/**********************************************************************/
/* Minimum shaft/arm breadth and minimum arm length definitions       */
/**********************************************************************/
#define SLD_MINSHAFTBREADTH   6
#define SLD_MINARMLENGTH      4
#define SLD_ROARMLENGTH       1

/**********************************************************************/
/* Default lengths of shaft and arm based on resolution               */
/**********************************************************************/
//#define EGA_DEFSHAFTBREADTH   6
//#define EGA_DEFARMLENGTH      6
//#define EGA_DEFARMBREADTH    10
#define VGA_DEFSHAFTBREADTH   8
#define VGA_DEFARMLENGTH      8
#define VGA_DEFARMBREADTH    12
//#define BGA_DEFSHAFTBREADTH  12
//#define BGA_DEFARMLENGTH     12
//#define BGA_DEFARMBREADTH    18

/**********************************************************************/
/* Indices for getting default values                                 */
/**********************************************************************/
#define SLD_DEFSHAFTBREADTH   1
#define SLD_DEFARMLENGTH      0
#define SLD_DEFARMBREADTH     2

/**********************************************************************/
/* Painting offsets and spacing                                       */
/**********************************************************************/
#define BORDERWIDTH     2
#define BUTTONSPACE     2

/**********************************************************************/
/* Arrow bitmap size definitions                                      */
/**********************************************************************/
#define ARROW_SIZE_STD        7
#define ARROW_SIZE_SMALL_X    3
#define ARROW_SIZE_SMALL_Y    5

/**********************************************************************/
/* DosLoadModule module name                                          */
/**********************************************************************/
#define SLIDERDLL    CCL_SLIDER_DLL   /* defined in fclsldw.h         */

/**********************************************************************/
/* Window word offset definitions                                     */
/**********************************************************************/
#define QWL_SLDCTL   4             /* 4 byte offset from QWL_USER     */
#define SRC_BITMAP   1L
/**********************************************************************/
/* Bitmap Ids for arrow bitmaps (note these can't collide with the    */
/* resource IDs from any of the other controls)                       */
/**********************************************************************/
#define IDB_HORZ_DEC    21        /* Horizontal decrement arrow       *//*JEH1*/
//#define IDB_HORZ_INC    22        /* Horizontal increment arrow       */
//#define IDB_VERT_DEC    23        /* Vertical decrement arrow         */
//#define IDB_VERT_INC    24        /* Vertical increment arrow         */
//#define IDB_HORZ_DEC_S  25        /* Small Horizontal decrement arrow */
//#define IDB_HORZ_INC_S  26        /* Small Horizontal increment arrow */
//#define IDB_VERT_DEC_S  27        /* Small Vertical decrement arrow   */
//#define IDB_VERT_INC_S  28        /* Small Vertical increment arrow   */
//#define IDB_HORZ_DEC_D  29 /* Horizontal decrement arrow disabled     */
//#define IDB_HORZ_INC_D  30 /* Horizontal increment arrow disabled     */
//#define IDB_VERT_DEC_D  31 /* Vertical decrement arrow disabled       */
//#define IDB_VERT_INC_D  32 /* Vertical increment arrow disabled       */
//#define IDB_HORZ_DEC_SD 33 /* Small horizontal decrement arrow disable*/
//#define IDB_HORZ_INC_SD 34 /* Small horizontal increment arrow disable*/
//#define IDB_VERT_DEC_SD 35 /* Small vertical decrement arrow disabled */
//#define IDB_VERT_INC_SD 36 /* Small vertical increment arrow disabled */

/**********************************************************************/
/* Timer ID for incrementing slider while buttons depressed           */
/**********************************************************************/
#define TID_SLIDERBUTTONS    1018
#define ALT_KEY_PRESSED      0x20000000
/**********************************************************************/
/* Color definitions for slider painting (presparam controlled)       */
/**********************************************************************/
#define CLR_SLDBACKGROUND       0
#define CLR_SLDFOREGROUND       1

/**********************************************************************/
/* Internal mask of style bits for slider only styles which if changed*/
/* need to cause updates of slider positioning/painting               */
/**********************************************************************/
#define SLS_TYPEMASK   0x000002c8

/**********************************************************************/
/* Define macros that perform a simple "error break" and sets         */
/* a break point value. (The break point value is typically a return  */
/* code that can be tested during exit processing.)                   */
/**********************************************************************/
#define ErrorBreak  goto ERROR_BREAK_EXIT
#define ErrorBreakRC(bpv,bp) { bpv = bp;  ErrorBreak; }

/**********************************************************************/
/* Function prototypes for functions in sliderm.c                     */
/**********************************************************************/
LRESULT CALLBACK SliderWndProc( HWND hwnd, UINT msg, WPARAM wParam,
                                LPARAM mp2 );                           /*JEH1*/
LONG   InitializeSlider  ( HANDLE hwndSld, LPSLDCDATA pSldData );       /*JEH1*/
BOOL   SetupSliderFromCB ( HANDLE hwndSld, PISLDDATA pIntData,
                           LPSLDCDATA pSldData );
VOID   TerminateSlider   ( HANDLE hwndSld, PISLDDATA pIntData );
USHORT GetDefaultSize    ( USHORT usValue, ULONG ulStyle );             /*JEH1*/
VOID   UpdateSliderValues( HANDLE hwndSld, PISLDDATA pIntData,
                           ULONG ulStyle);                              /*JEH1*/
VOID   CalcShaftSize( HWND hwndSld, PISLDDATA pIntData);

/**********************************************************************/
/* Function prototypes for functions in sldinit.c                     */
/**********************************************************************/
BOOL CreateSliderBitmaps( PTHDATA pth );
VOID DeleteSliderBitmaps( void );
VOID FAR PASCAL SldExitProc( USHORT usTermCode );                       /*JEH1*/
BOOL AddTaskNode (void);
VOID DeleteTaskNode (void);
PTHDATA FindTaskData (void);

#if 0                                                                   /*JEH1*/
BOOL AddInstNode (HANDLE hInstance, PPINSTDATA pList);
BOOL DeleteInstNode (HANDLE hInstance, PPINSTDATA pList);
PINSTDATA FindInstData (HANDLE hInstance, PINSTDATA pHead);
PINSTDATA FindLastInstNode (PINSTDATA pList);
#endif


/**********************************************************************/
/* Function prototypes for functions in slidera.c                     */
/**********************************************************************/
USHORT CalcArmPosFromPt ( HANDLE hwndSld, PISLDDATA pIntData, LONG sCx, /*JEH1*/
                          LONG sCy );                                   /*JEH1*/
VOID CreateSliderArm    ( HANDLE hwndSld, PISLDDATA pIntData );
VOID DrawDraggedArm     ( PISLDDATA pIntData, HDC hps, USHORT fs );     /*JEH1*/
VOID DrawSliderArm      ( HANDLE hwndSld, PISLDDATA pIntData );
VOID IncrementArmPosition( HANDLE hwndSld, PISLDDATA pIntData,
                           BOOL bBump );
VOID MoveSliderArm      ( HANDLE hwndSld, PISLDDATA pIntData,
                          USHORT usArmPos, BOOL bDrawArm,               /*JEH1*/
                          BOOL bNotify );
VOID MoveToNextDetent   ( HANDLE hwndSld, PISLDDATA pIntData, BOOL bDir );
VOID SldProcessArmPress ( HANDLE hwndSld, PISLDDATA pIntData, HDC hps );
VOID SldProcessButtonPress( HANDLE hwndSld, PISLDDATA pIntData,
                            LONG sCx, LONG sCy, BOOL bRepaint );        /*JEH1*/
BOOL SldProcessVirtKey  ( HANDLE hwndSld, PISLDDATA pIntData, UINT usVrtlKey,
                          ULONG ulKeyInfo );                            /*JEH1*/
VOID SldProcessFocusChg ( HANDLE hwndSld, PISLDDATA pIntData, BOOL bFocus);
BOOL SldProcessMouseDown( HANDLE hwndSld, PISLDDATA pIntData,
                          LONG sCx, LONG sCy, BOOL bSelectBtn );        /*JEH1*/
VOID SldProcessMouseMove( HANDLE hwndSld, PISLDDATA pIntData,
                          LONG sCx, LONG sCy );                         /*JEH1*/
BOOL SldProcessMouseUp  ( HANDLE hwndSld, PISLDDATA pIntData );
VOID SldProcessShaftPress( HANDLE hwndSld, PISLDDATA pIntData,
                           LONG sCx, LONG sCy, BOOL bSelectBtn );       /*JEH1*/
VOID SldProcessTimer    ( HANDLE hwndSld, PISLDDATA pIntData,
                          UINT usTimerId );                             /*JEH1*/
//BOOL SldQueryWindowParms( PISLDDATA pIntData, PWNDPARAMS pwndParm );
//BOOL SldSetWindowParms  ( HANDLE hwndSld, PISLDDATA pIntData,
//                          PWNDPARAMS pwndParm );

/**********************************************************************/
/* Function prototypes for functions in sliders.c                     */
/**********************************************************************/
PDETENTDATA AddDetent( HANDLE hwndSld, PISLDDATA pIntData,
                       USHORT usDetentPos );                            /*JEH1*/
PTICKDATA AddTick( PISLDDATA pIntData );
ULONG  QueryClosestTick( HANDLE hwndSld, PISLDDATA pIntData,            /*JEH1*/
                        USHORT usArmPos );                              /*JEH1*/
LONG  QueryDetentPos( PISLDDATA pIntData, PDETENTDATA pDetentId );      /*JEH1*/
USHORT QueryMaxRange( HANDLE hwndSld, PISLDDATA pIntData );             /*JEH1*/
USHORT QueryScaleSpacing( HANDLE hwndSld, PISLDDATA pIntData );         /*JEH1*/
LONG  QueryScaleText( HANDLE hwndSld, PISLDDATA pIntData,               /*JEH1*/
                      USHORT usTickNum, USHORT usBufLen,                /*JEH1*/
                      LPSTR pszTickText );
LONG  QuerySliderInfo( HANDLE hwndSld, PISLDDATA pIntData,              /*JEH1*/
                       USHORT usInfoType, USHORT usArmPosType );        /*JEH1*/
ULONG QueryTickPos( HANDLE hwndSld, PISLDDATA pIntData, USHORT usScale, /*JEH1*/
                    USHORT usTickNum );                                 /*JEH1*/
LONG  QueryTickSize( HANDLE hwndSld, PISLDDATA pIntData,                /*JEH1*/
                      USHORT usTickNum );                               /*JEH1*/
BOOL  RemoveDetent( HANDLE hwndSld, PISLDDATA pIntData,
                   PDETENTDATA pDetentId );
PTICKDATA SearchForTick( HANDLE hwndSld, PISLDDATA pIntData,
                         USHORT usTickNum );                            /*JEH1*/
BOOL SetScaleText( HANDLE hwndSld, PISLDDATA pIntData, USHORT usTickNum,/*JEH1*/
                   LPSTR pszTickText );
BOOL SetSliderInfo( HANDLE hwndSld, PISLDDATA pIntData,
                    USHORT usInfoType, USHORT usArmPosType,             /*JEH1*/
                    ULONG ulInfo );                                     /*JEH1*/
BOOL SetTickSize( HANDLE hwndSld, PISLDDATA pIntData,USHORT usTickNum,  /*JEH1*/
                  USHORT usTickSize );                                  /*JEH1*/
VOID SldInitPresParam    ( PISLDDATA pIntData );
BOOL SldSetPresParam( PISLDDATA pIntData, USHORT wColorToChange,        /*JEH1*/
                      COLORREF crColor );
LONG SldQueryPresParam( PISLDDATA pIntData, USHORT wColorToReturn);     /*EVBx*/
BOOL SldResetPresParam( PISLDDATA pIntData, USHORT wColorToReturn);     /*EVBx*/
BOOL VerifyTickNum( HANDLE hwndSld, PISLDDATA pIntData,
                    USHORT usTickNum, BOOL bStyle, USHORT usScale );    /*JEH1*/
BOOL CheckForEndOfScale( HWND hwndSld, PISLDDATA pIntData,
                         USHORT  usTickPos );                           /*JEH1*/

/**********************************************************************/
/* Function prototypes for functions in sliderp.c                     */
/**********************************************************************/
VOID BltCopy( HBITMAP hbmSrc, HDC hpsDst, LONG xSrc, LONG ySrc,         /*JEH1*/
              LONG cx, LONG cy, LONG xDst, LONG yDst, ULONG rop,        /*JEH1*/
              ULONG mode );                                             /*JEH1*/
VOID CalcArmRectangle( HANDLE hwndSld, PISLDDATA pIntData,
                       LPRECT prclArm, USHORT usArmPos );               /*JEH1*/
VOID CalcArrowRectangles( HANDLE hwndSld, PISLDDATA pIntData,
                          LPRECT prclDecr, LPRECT prclIncr );
USHORT CalcButtonLength( PISLDDATA pIntData );                          /*JEH1*/
VOID CalcDetentRectangle( HANDLE hwndSld, PISLDDATA pIntData,
                          PDETENTDATA pDetentId, USHORT usDetentSize,   /*JEH1*/
                          LPRECT prclCalc );
VOID CalcRectangle( HANDLE hwndSld, PISLDDATA pIntData, USHORT xStart,  /*JEH1*/
                    USHORT yStart, USHORT usLength, LPRECT prclCalc );  /*JEH1*/
VOID CalcRibbonRectangles( HANDLE hwndSld, LPRECT prclShaft,
                           LPRECT prclArm, LPRECT prclCalc1,
                           LPRECT prclCalc2 );
LONG CalcShaftnButtonEdges( HANDLE hwndSld, LPRECT prclBorder,          /*JEH1*/
                            LPRECT prclButton, BOOL bOuter );
VOID CalcShaftnButtonPos( HANDLE hwndSld, PISLDDATA pIntData );
SIZE CalcTextRect( HDC hps, int usLen, LPSTR pszText );                 /*JEH1*/
VOID DrawSlider( HANDLE hwndSld, PISLDDATA pIntData );
BOOL PaintBackground( HANDLE hwndSld, PISLDDATA pIntData, HDC hps,
                      LPRECT prclPaint, LPRECT prclQuad, BOOL bPaintIt );
VOID PaintBorder( HANDLE hwndSld, PISLDDATA pIntData, HDC hps,
                  LPRECT prclBorder, LPRECT prclButton, LPRECT prclArm);
VOID PaintButtonOutline( PISLDDATA pIntData, HDC hps, HANDLE hwndSld,
                         LPRECT prclBtn, BOOL bDown );
VOID PaintButtons( HANDLE hwndSld, PISLDDATA pIntData, HDC hps );
VOID PaintDetents( HANDLE hwndSld, PISLDDATA pIntData, HDC hps );
VOID PaintShaft( HANDLE hwndSld, HDC hps, LPRECT prclBorder,
                 LPRECT prclArm );
VOID PaintTicks( HANDLE hwndSld, PISLDDATA pIntData, HDC hps );
SHORT UpdateArmPosition( HANDLE hwndSld, PISLDDATA pIntData,            /*JEH1*/
                         USHORT usArmPos );                             /*JEH1*/

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // SLIDERP header guard
