/* Revision: 22 1.4.1.5 source/ui/cclnt/cnr/cnrs3p5.c, cclcnr, ioc.v400, 001006  */
/**********************************************************************/
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*        (IBM Confidential-Restricted when combined with the         */
/*         aggregated OCO source modules for this program)            */
/*                                                                    */
/*                       OCO SOURCE MATERIALS                         */
/*                                                                    */
/*         20G0400 (C) Copyright IBM Corp. 1992, 1997 (Unpublished)   */
/*                                                                    */
/* ================================================================== */
/*                                                                    */
/*                         C O N T A I N E R                          */
/*                                                                    */
/*                        Filename: CNRS3P5.C                         */
/*                                                                    */
/*             ( Windows NT Container Control Component )             */
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*                (C) Copyright IBM Corporation 1997                  */
/*                       All Rights Reserved                          */
/*            Licensed Material - Program Property of IBM             */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/* Product: ICLUINT.DLL                                               */
/* Filename: CNRS3P5.C - Handler routines for container control       */
/*                                                                    */
/* Flag    Date    By:  Description                                   */
/* ----  --------  ---  --------------------------------------------- */
/* DAB1  11/16/93  DAB  Initial modifications for NT execution        */
/* DAB2  03/17/94  DAB  Spacebar H to Hawaii problem                  */
/* D6386  1/16/96  ASM  Enable message passing in Win32s environment  */
/*                      Change SendMessage to SENDMESSAGE             */
/* PPB1  01/29/96  PPB  Ensure scroll position > 0 defect 6948        */
/* RKK1  05/01/96  RKK  Add changes required for Wind/U.              */
/* DAB4   4/25/97  DAB  Defect 21242 - Fix custom cursor painting     */
/**********************************************************************/
#include <string.h>
#include <windows.h>
#include <iclccl.h>     /* CCL common include file */
#include "cnr2win.h"
#include "iclcnrw.h"

#include "cnrcbn.h"

//#include "storwin.h"

#ifdef SEGMENTOR
#define CNRS3P5_C
#include "cnrpragw.h"
#endif

/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrFindRecordStringMatch                       */
/*                                                                    */
/*  Descriptive Name:  Find the record which matches the passed in    */
/*                     text string.                                   */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/*                                                                    */
/*  Input:                                                            */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/**********************************************************************/
LPRECORDCOREN FAR CnrFindRecordStringMatch(HANDLE hwnd,
                                     LPRECORDCOREN pRecord,
                                     LPRECORDCOREN pRecordEnd,
                                     LPSTR pString, BOOL fsCaseSensitive,
                                     BOOL fsPrefix, DWORD ulView,
                                     BOOL flVisibleOnly)
{
  LPRECORDCOREN pRecordReturn=NULL;     /* Ptr to return record        */
  LPSTR         pRecordString;          /* Ptr to record text string   */
  WORD          stringLength=0;         /* Length of input string      */
  WORD          recordStringLength=0;   /* Length of record string     */
  WORD          recordStringIdx;
  WORD          stringFound=1;
  LPFIELDINFO   pFieldInfo;
  LPCNRINFON    pccinfon;                   /* Container instance data   */
  LPCNRINFO     pccinfo;
//ERRORID       ErrorID;

  /********************************************************************/
  /* Get ptr to Container instance data                               */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  stringLength = lstrlen(pString);
  if (!stringLength)
  {
    return NULL;
  }

  /********************************************************************/
  /* Loop until a string match is found, or the end of the record     */
  /* list is reached.                                                 */
  /********************************************************************/
  while (pRecord && stringFound)
  {
    if (flVisibleOnly && !(ISRECORDVISIBLEINVIEW(pccinfo, pRecord)))
    {
      pRecord = (pccinfo->flWindowAttr & CV_TREE) ?
                 TRVGetNextItem(pRecord) : pRecord->preccNextItem;
    }
    else
    {
      if (!(ulView & CV_TREE) && (ulView & CV_DETAIL))
      {
         if (flVisibleOnly)
         {
            pFieldInfo = pccinfon->pFirstVisibleFI;
         }
         else
         {
            pFieldInfo = pccinfon->pFirstFI;
         }
      }

      if (!(pRecordString = CnrQueryRecordStringText (hwnd,
                                                      pRecord->preccX,
                                                      pFieldInfo,
                                                      ulView)))
      {
//       ErrorID = WinGetLastError (WinQueryAnchorBlock          //->@XXX
//                                  (HANDLE_DESKTOP));
//
//       if (ErrorID == PMERR_INSUFFICIENT_MEMORY)
//       {
//          SETERROR(ErrorID);
//          return ((LPRECORDCORE)NULL);
//       }
//
//       SETERROR(ErrorID);                                      //@XXX<-
      }

      /******************************************************************/
      /* Get the length of the record string text. Assume 0 if NULL.    */
      /******************************************************************/
      if (pRecordString)
      {
        recordStringLength = lstrlen(pRecordString);
      }

      while(pRecordString)
      {
        /****************************************************************/
        /* Index through the record until a match is found for pString, */
        /* or the end of the record string is reached.  The record text */
        /* must be the same length or larger than the pString text in   */
        /* order for a match to be possible.                            */
        /****************************************************************/
        for (recordStringIdx=0;
             ((stringLength <= (recordStringLength - recordStringIdx)) &&
              (stringFound)); recordStringIdx++ )
        {
          /**************************************************************/
          /* If fsCaseSensitive is on, the string comparison is case    */
          /* sensitive.                                                 */
          /**************************************************************/
          if (fsCaseSensitive)
          {
            stringFound = strncmp(pString,&(pRecordString[recordStringIdx]),
                                  stringLength);
          }
          /**************************************************************/
          /* If fsCaseSensitive is off, the string comparison is not    */
          /* case sensitive.                                            */
          /**************************************************************/
          else
          {
            stringFound = strnicmp(pString,&(pRecordString[recordStringIdx]),
                                  stringLength);
          }

          /**************************************************************/
          /* If fsPrefix is on, Match occurs only if the leading        */
          /* characters of the record contain characters specified by   */
          /* pString.                                                   */
          /**************************************************************/
          if (fsPrefix)
          {
            recordStringIdx = recordStringLength - (WORD)1;
          }

          /**************************************************************/
          /* If exact match, the lengths of the strings must also match.*/
          /**************************************************************/
          if ( ulView & CV_EXACTMATCH )
          {
            if ( stringFound == 0 )
            {  /* A match was found, now check the lengths. */
               if ( stringLength != recordStringLength )
               {  /* No match after all, since the lengths don't match. */
                  stringFound = 1;
               }
            }
            recordStringIdx = recordStringLength - (WORD)1;
          }
        }

        /****************************************************************/
        /* If we are searching details view, check all columns with     */
        /* data.                                                        */
        /****************************************************************/
        if (stringFound && (ulView & CV_DETAIL))
        {
          if (flVisibleOnly)
          {
             pFieldInfo = NEXTVISIBLEFI(pFieldInfo);
          }
          else
          {
             pFieldInfo = NEXTFI(pFieldInfo);
          }

          if (!(pRecordString = CnrQueryRecordStringText (hwnd,
                                pRecord->preccX, pFieldInfo, ulView)))
          {
//           ErrorID = WinGetLastError (WinQueryAnchorBlock      //->@XXX
//                                      (HANDLE_DESKTOP));
//
//           if (ErrorID == PMERR_INSUFFICIENT_MEMORY)
//           {
//              SETERROR(ErrorID);
//              return ((LPRECORDCORE)NULL);
//           }
//
//           SETERROR(ErrorID);                                  //@XXX<-
          }
        }
        else
        {
          pRecordString = NULL;
        }
      }
      /****************************************************************/
      /* If no match is found, index to next record.                  */
      /****************************************************************/
      if (stringFound)
      {
        if (pRecord == pRecordEnd)
        {
          pRecord = NULL;
        }
        else
        {
          pRecord = (pccinfo->flWindowAttr & CV_TREE) ?
                  TRVGetNextItem(pRecord) : pRecord->preccNextItem;
        }
      }
      else
      {
        return pRecord;
      }
    }
  }
  return pRecord;
}
/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrQueryRecordStringText                       */
/*                                                                    */
/*  Descriptive Name:  Return a pointer to the app defined text for   */
/*                     the specified view.                            */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/*                                                                    */
/*  Input:                                                            */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/**********************************************************************/
LPSTR FAR CnrQueryRecordStringText(HANDLE hwnd, LPRECORDCORE pRecord,
                             LPFIELDINFO pFieldInfo, WORD usView)
{
  LPCNRINFON pccinfon;                   /* Container instance data   */

  /********************************************************************/
  /* Get ptr to Container instance data                               */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);

  /********************************************************************/
  /* Determine text string based on the specified view.               */
  /********************************************************************/
  if (usView & CV_TREE)
  {
    /******************************************************************/
    /* Tree View                                                      */
    /******************************************************************/
    return (GETLPSTRFORTRV(pRecord));
  }
  else
  if (usView & CV_ICON)
  {
    /******************************************************************/
    /* Icon View                                                      */
    /******************************************************************/
    return (pRecord->pszIcon);
  }
  else
  if (usView & CV_NAME)
  {
    /******************************************************************/
    /* Name View                                                      */
    /******************************************************************/
    return(GETLPSTRFORNV(pRecord));
  }
  else
  if (usView & CV_TEXT)
  {
    /******************************************************************/
    /* Text View                                                      */
    /******************************************************************/
    return(GETLPSTRFORTV(pRecord));
  }
  else
  if (usView & CV_DETAIL)
  {
    /******************************************************************/
    /* Details View - Index to string field infos                     */
    /******************************************************************/
    while (pFieldInfo && !(pFieldInfo->flData & CFA_STRING))
    {
      pFieldInfo = PFINFROMX(pFieldInfo)->pNextFieldInfo;
    }
    return(CnrGetColumnData(hwnd, pRecord, pFieldInfo));
  }
  else
  {
    /******************************************************************/
    /* Invalid View specified                                         */
    /******************************************************************/
    return(NULL);
  }
}
/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrProcessCharKey                              */
/*                                                                    */
/*  Descriptive Name:  Process the key entered via the keyboard.      */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/*  Input:                                                            */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/**********************************************************************/
BOOL FAR CnrProcessCharKey( HWND hwnd, UINT uschr, HDC hps )            /*DAB1*/
{
  LPCNRINFON     pccinfon;               /* Container instance data   */
  LPCNRINFO      pccinfo;
  LPRECORDCOREN  pRecord = NULL;          /* ptr to matched record    */
  DWORD          windowStyle;
//ERRORID        ErrorID;
  BOOL           Processed = FALSE;

  /********************************************************************/
  /* Space bar sends both a WM_KEYDOWN and a WM_CHAR so don't process */
  /* here for WM_CHAR since it was already processed on the WM_KEYDOWN*/
  /********************************************************************/
  if (uschr == ' ')                                                     /*DAB2*/
    return (FALSE);                                                     /*DAB2*/

  /********************************************************************/
  /* Get ptr to Container instance data                               */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /********************************************************************/
  /* Determine if character matches the starting character of a       */
  /* record. Start search at record with the cursor emphasis.         */
  /********************************************************************/
  if (pccinfon->preccCursor)
  {
    if (!(pRecord = CnrFindRecordStringMatch(hwnd,
                      GetNextVisualItem(hwnd, pccinfon->preccCursor),
                      (LPRECORDCOREN)CMA_END,
                      (LPSTR)&uschr, FALSE, TRUE,
                      LOWORD(pccinfo->flWindowAttr), TRUE)))
    {
//     ErrorID = WinGetLastError (WinQueryAnchorBlock            //->@XXX
//                                (HANDLE_DESKTOP));
//
//     if (ErrorID == PMERR_INSUFFICIENT_MEMORY)
//     {
//        SETERROR(ErrorID);
//        return (FALSE);
//     }
//
//     SETERROR(ErrorID);                                        //@XXX<-
    }

    /********************************************************************/
    /* If no match is found start search with first record in item      */
    /* order.                                                           */
    /********************************************************************/
    if (!pRecord)
    {
      if (!(pRecord = CnrFindRecordStringMatch( hwnd,
                        pccinfon->preccItem, pccinfon->preccCursor,
                        (LPSTR)&uschr, FALSE, TRUE,
                        LOWORD(pccinfo->flWindowAttr), TRUE)))
      {
//       ErrorID = WinGetLastError (WinQueryAnchorBlock          //->@XXX
//                                  (HANDLE_DESKTOP));
//
//       if (ErrorID == PMERR_INSUFFICIENT_MEMORY)
//       {
//          SETERROR(ErrorID);
//          return (FALSE);
//       }
//
//       SETERROR(ErrorID);                                      //@XXX<-
      }
    }
    /********************************************************************/
    /* If a record matching the character is found apply appropriate    */
    /* target emphasis.                                                 */
    /********************************************************************/
    if (pRecord)
    {
      Processed = TRUE;
      if (pRecord != pccinfon->preccCursor)
      {
        if (!(ScrollToRecord (hwnd, pccinfon->preccCursor,
                              pRecord, TRUE, TRUE)))
        {
           return (TRUE);
        }

        pccinfon->preccCursor = pRecord;
      }
      else
      {
        if (!(pccinfo->flWindowAttr & CV_TREE) )
        {
          /************************************************************/
          /* If this is multiple selection or extended selection with */
          /* the control key pressed, the selection state of the item */
          /* should toggle.  It may be that the precord is preccCursor*/
          /* and the selection state should toggle.                   */
          /************************************************************/
          windowStyle = GetWindowLong( hwnd, GWL_STYLE );

          if ((windowStyle & CCS_MULTIPLESEL) ||
              ((windowStyle & CCS_EXTENDSEL) &&
              (GetKeyState (VK_CONTROL) < 0)))
          {
            if (!SetEmphasisBits (hwnd, hps, pRecord, CRA_SELECTED,
                                  SEB_TOGGLE))
            {
              return (TRUE);
            }

            pccinfon->preccAnchor = pRecord;
            pccinfon->preccPrevEndOfRange = pRecord;

            if (pRecord->flRecordAttr & CRA_SELECTED)
            {
               pccinfon->fAnchorState = TRUE;
            }
            else
            {
               pccinfon->fAnchorState = FALSE;
            } /* endif */
          }
          else
          {
            if (!SetEmphasisBits (hwnd, hps, pRecord, CRA_SELECTED,
                                  SEB_SET))
            {
              return (TRUE);
            }
            pccinfon->preccAnchor = pRecord;
            pccinfon->preccPrevEndOfRange = pRecord;
            pccinfon->fAnchorState = TRUE;
          }
        } /* endif */
      }
    }
  }

  if (Processed)
  {
    return (TRUE);
  }
  else
  {
    return (FALSE);
  }
}

/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrSetCursorFirstItemInView                    */
/*                                                                    */
/*  Descriptive Name:  Set cursor pointer to first item in view       */
/*                                                                    */
/*  Functional Description:  Reset the cursored record pointer to     */
/*                           the first item in view.                  */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/*  Input:                                                            */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/**********************************************************************/
BOOL FAR CnrSetCursorFirstItemInView(HANDLE hwnd, HDC hps, BOOL fSelect)
{
  LPCNRINFON    pccinfon;                 /* Container instance data   */
  LPRECORDCOREN preccFirst=NULL;          /* ptr to first item         */

  /********************************************************************/
  /* Get ptr to Container instance data                               */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);

  preccFirst = GetFirstItemInView(hwnd);

  /********************************************************************/
  /* Reset the cursor emphasis record pointer and invalidate the      */
  /* previous and new cursored record.                                */
  /********************************************************************/
  if (preccFirst)
  {
    if (!(CnrResetCursorRecord(hwnd, hps, preccFirst, fSelect)))
    {
       return (FALSE);
    }
  }

  return (TRUE);
}
/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrResetCursorRecord                           */
/*                                                                    */
/*  Descriptive Name:  Reset the cursored record pointer              */
/*                                                                    */
/*  Functional Description:  Reset the cursored record pointer to     */
/*                           passed record and redraw both.           */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/*  Input:                                                            */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/**********************************************************************/
BOOL FAR CnrResetCursorRecord(HANDLE hwnd, HDC hps, LPRECORDCOREN pRecord,
                          BOOL fSelect)

{
  LPCNRINFON pccinfon;                   /* Container instance data   */
  LPCNRINFO  pccinfo;
  DWORD      windowStyle;

  /********************************************************************/
  /* Get ptr to Container instance data                               */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  if (!pRecord)
  {
     return(FALSE);
  }

  /********************************************************************/
  /* If cursor hasn't moved, then do nothing.                         */
  /********************************************************************/
  if (pccinfon->preccCursor == pRecord)
  {
     return(TRUE);
  }

  if (pccinfo->flWindowAttr & CV_TREE)
  {
    return (TRVMoveCursor(hwnd, hps, pRecord));
  } /* endif */

  if (!(CnrChangeCursor( hwnd, pRecord, hps, FALSE )))
  {
     return(FALSE);
  }

  if (fSelect)
  {
    windowStyle = GetWindowLong( hwnd, GWL_STYLE );
    if ((!(windowStyle & CCS_MULTIPLESEL)) &&
        (!(pccinfon->ulFlagSet & FL_ADDMODE)))
    {
      if (!(CnrFindAndDeemphasizeRecords(hwnd, hps,
         pRecord, CRA_SELECTED)))
      {
         return (FALSE);
      }

      if (!SetEmphasisBits (hwnd, hps, pRecord, CRA_SELECTED, SEB_SET))
      {
        return (FALSE);
      }

      pccinfon->preccAnchor = pRecord;
      pccinfon->preccPrevEndOfRange = pRecord;

      if (pccinfon->preccAnchor->flRecordAttr & CRA_SELECTED)
      {
         pccinfon->fAnchorState = TRUE;
      }
      else
      {
         pccinfon->fAnchorState = FALSE;
      } /* endif */
    }
  }

  return (TRUE);
}

/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  CnrProcessChar                                     */
/*                                                                    */
/* USAGES : External                                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:                                                  */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:                                            */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:                                                             */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/*                                                                    */
/**********************************************************************/
BOOL FAR CnrProcessChar( HWND hwnd, UINT msg, WPARAM wParam,            /*DAB1*/
                         LPARAM lParam )                                /*DAB1*/
{
  LPCNRINFON     pccinfon;              /* Internal CNR control data */
  LPCNRINFO      pccinfo;
  LPRECORDCOREN  lpRecordn;             /* General purpose record    */
  LPRECORDCORE   lpRecord;              /* used for help notification*/
  HDC            hps;                   /* HDC used in default paint */
  int            keyCtrlState;
  int            keyShiftState;
  long           windowStyle;
  long           flCursorAttrOld;
  int            Scrollbar;
  int            ScrollUnit;
  long           lScroll;
  int            sScrollPos;
  LPINT          HScrollPos;
  LPINT          HScrollMax;
  BOOL           Processed = FALSE;
  BOOL           fClear;
  WORD           usKeyCtl;
  NOTIFYRECORDENTER  nRecordEnter;      /* CN_ENTER notfify record   */

  /*****************************************************************/
  /* Get ptr to internal CNRINFO control data.  The pointer to the */
  /* external control data is beyond the pointer to the internal   */
  /* control data.                                                 */
  /*****************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  hps = PMGetFlippedDC(hwnd);
  usKeyCtl = HIWORD(lParam);

  keyCtrlState = GetKeyState (VK_CONTROL);
  keyShiftState = GetKeyState (VK_SHIFT);

  windowStyle = GetWindowLong (hwnd, GWL_STYLE);

  /**************************************************************/
  /* If the help key, F1 was pressed, send a CN_HELP            */
  /* notification.                                              */
  /**************************************************************/
  if (msg == WM_HELP)
  {
    // Need to handle win32s case...
    HELPINFO helpInfo=*((LPHELPINFO)(void *)lParam);
    if (helpInfo.iContextType == HELPINFO_MENUITEM)
    {
      ReleaseDC (hwnd, hps);
      return (FALSE);
    }

    if (pccinfon->preccCursor)
    {
      COPYNDATATOX(pccinfon->preccCursor);
      lpRecord = pccinfon->preccCursor->preccX;
    }
    else
    {
      // fixed problem where lpRecord = 0 caused the notification to never
      // be sent.  This is because NotifyOwner sends a WM_COMMAND, which is
      // converted to WM_CONTROL except when parm2=0.  now pass -1.
      lpRecord = (LPVOID) -1;					/*RKK1*/
    }
    NotifyOwner (hwnd, CN_HELP, (LPVOID)lpRecord);
    ReleaseDC (hwnd, hps);
    return (TRUE);
  }

  /****************************************************************/
  /* Check for virtual key presses.                               */
  /****************************************************************/
  else if (msg == WM_KEYDOWN)
  {
    if (!(pccinfo->flWindowAttr & CV_TREE))
    {
      /**************************************************************/
      /* Check for add mode (shift + f8)                            */
      /**************************************************************/
      if ((wParam == VK_F8) && (keyShiftState < 0) &&
           (windowStyle & CCS_EXTENDSEL) &&
           !(usKeyCtl & 0x2000) && !(keyCtrlState < 0))
      {
        Processed = TRUE;
        if ((pccinfon->ulFlagSet & FL_ADDMODE) &&
            (pccinfon->preccCursor))
        {
          /********************************************************/
          /* Toggle add mode off. The selection cursor changes to */
          /* a dotted outline box.                                */
          /********************************************************/
          pccinfon->ulFlagSet &= ~FL_ADDMODE;

          if (!(CnrSetBlinkTimer(hwnd)))
          {
             ReleaseDC (hwnd, hps);
             return (TRUE);
          }
        }
        else if (pccinfon->preccCursor)
        {
          /********************************************************/
          /* Toggle add mode on. The selection cursor changes to  */
          /* a blinking dotted outline box.                       */
          /********************************************************/
          pccinfon->ulFlagSet |= FL_ADDMODE;

          if (!(CnrSetBlinkTimer(hwnd)))
          {
             ReleaseDC (hwnd, hps);
             return (TRUE);
          }
        }

        keyCtrlState = 0;
        keyShiftState = 0;
      } /* VK_F8 */
      /******************************************************************/
      /* If the F6 key is hit, and details View is split in 2, toggle   */
      /* the focus of the window we will horizontally scroll with the   */
      /* keyboard.                                                      */
      /******************************************************************/
      else if ((wParam == VK_F6) && !(usKeyCtl & 0x2000) &&
               !(keyCtrlState < 0) && !(keyShiftState < 0))
      {
        if ((pccinfo->flWindowAttr & CV_DETAIL) &&
            !(pccinfon->ulFlagSet & FL_UNSPLIT))
        {
           Processed = TRUE;
           pccinfon->ulFlagSet2 ^= FL2_FOCUSLEFT;
        }
      }
      /**************************************************************/
      /* Check for Spacebar.                                        */
      /**************************************************************/
      else if (wParam == VK_SPACE)
      {
        if (!pccinfon->preccCursor)
        {
          ReleaseDC (hwnd, hps);
          return (FALSE);
        }

        if ((pccinfon->ulFlagSet & FL_ADDMODE) &&
            (windowStyle & (CCS_EXTENDSEL | CCS_MULTIPLESEL)))
        {
          /**********************************************************/
          /*  Add Mode + Spacebar + Shift + Ctrl                    */
          /*   1) Toggles all choices from the anchor point to the  */
          /*      current cursor location                           */
          /*   2) Preserves all other selections except those       */
          /*      established by the most recent anchor point       */
          /*   3) Preserves the anchor point                        */
          /**********************************************************/
          /**********************************************************/
          /*  Add Mode + Spacebar + Shift                           */
          /*   1) Toggles all choices from the anchor point to the  */
          /*      current cursor location                           */
          /*   2) Preserves all other selections except those       */
          /*      established by the most recent anchor point       */
          /*   3) Preserves the anchor point                        */
          /**********************************************************/
          if (((keyCtrlState < 0) && (keyShiftState < 0)) || (keyShiftState < 0))
          {
            Processed = TRUE;
            keyCtrlState = 0;
            keyShiftState = 0;
            flCursorAttrOld = pccinfon->preccCursor->flRecordAttr;

            if (!(CnrExtendedSelection(hwnd, hps, pccinfon->preccCursor,
                                       TOGGLE, FALSE)))
            {
               ReleaseDC (hwnd, hps);
               return (TRUE);
            }

            if (!(CnrDrawEmphChange(hwnd, hps, pccinfon->preccCursor,
                                    flCursorAttrOld)))
            {
               ReleaseDC (hwnd, hps);
               return (TRUE);
            }
          }

          /**********************************************************/
          /*  Add Mode + Spacebar  OR  Add Mode + SpaceBar + Ctrl   */
          /*   1) Toggles the selection state at the cursor location*/
          /*   2) Preserves selection state of all other choices    */
          /*   3) Sets the anchor point to the cursor location      */
          /**********************************************************/
          else
          {
            Processed = TRUE;

            if (!SetEmphasisBits (hwnd, hps, pccinfon->preccCursor,
                                  CRA_SELECTED, SEB_TOGGLE))
            {
              ReleaseDC (hwnd, hps);
              return (FALSE);
            }

            pccinfon->preccAnchor = pccinfon->preccCursor;
            pccinfon->preccPrevEndOfRange = pccinfon->preccCursor;

            if (pccinfon->preccAnchor->flRecordAttr & CRA_SELECTED)
            {
               pccinfon->fAnchorState = TRUE;
            }
            else
            {
               pccinfon->fAnchorState = FALSE;
            } /* endif */
          }
        } /* Add Mode */
        else
        {
          /**********************************************************/
          /*  SpaceBar + Shift OR SpaceBar + Shift + Ctrl           */
          /*   1) Toggles all choices from the anchor point to the  */
          /*      current cursor location                           */
          /*   2) De-Selects all other choices                      */
          /*   3) Preserves the anchor point                        */
          /**********************************************************/
          if ((keyShiftState < 0) &&
              (windowStyle & (CCS_EXTENDSEL | CCS_MULTIPLESEL)) &&
              (!(pccinfo->flWindowAttr & CV_ICON)) )
          {
            Processed = TRUE;
            if (windowStyle & CCS_EXTENDSEL)
            {
              fClear = TRUE;
            }
            else
            {
              fClear = FALSE;
            }
            if (!(CnrExtendedSelection(hwnd, hps, pccinfon->preccCursor,
                                       TOGGLE, fClear)))
            {
               ReleaseDC (hwnd, hps);
               return (TRUE);
            }
          }
          /**********************************************************/
          /*  SpaceBar  OR SpaceBar + Ctrl                          */
          /*   1) Selects the choice at the cursor location         */
          /*   2) De-Selects all other choices                      */
          /*   3) Sets the anchor point at the cursor location      */
          /**********************************************************/
          else
          {
             if (windowStyle & CCS_EXTENDSEL)
             {
               Processed = TRUE;
               if (!(CnrFindAndDeemphasizeRecords(hwnd, hps,
                  pccinfon->preccCursor,CRA_SELECTED)))
               {
                  ReleaseDC (hwnd, hps);
                  return (TRUE);
               }

             }
             if (windowStyle & (CCS_EXTENDSEL | CCS_MULTIPLESEL))
             {
               Processed = TRUE;
               if (!SetEmphasisBits (hwnd, hps, pccinfon->preccCursor,
                                     CRA_SELECTED, SEB_TOGGLE))
               {
                  ReleaseDC (hwnd, hps);
                  return (TRUE);
               }

               pccinfon->preccAnchor = pccinfon->preccCursor;
               pccinfon->preccPrevEndOfRange = pccinfon->preccCursor;

               if (pccinfon->preccAnchor->flRecordAttr & CRA_SELECTED)
               {
                  pccinfon->fAnchorState = TRUE;
               }
               else
               {
                  pccinfon->fAnchorState = FALSE;
               } /* endif */
             }
          }
        } /* Non Add Mode */
      } /* VK_SPACE */
    } /* Tree view */

    /******************************************************************/
    /* The stupid if statement is here because of CUA's braindamaged  */
    /* vision of keyboard support in container.  Because of this the  */
    /* if statement is provided in english:  The arrow keys should    */
    /* only be processed by the container if:                         */
    /* 1) None of the augmentation keys are pressed (ALT, SHIFT, CTRL)*/
    /*    or                                                          */
    /* 2) Only the Shift key is pressed.                              */
    /*    or                                                          */
    /* 3) Both the Control and the Shift key are pressed and not the  */
    /*    ALT key.                                                    */
    /******************************************************************/
    if ((!(usKeyCtl & 0x2000) && !(keyCtrlState < 0) && !(keyShiftState < 0)) ||
         ((keyShiftState < 0) && !(usKeyCtl & 0x2000) &&
          !(keyCtrlState < 0)) ||
         ((keyShiftState < 0) && (keyCtrlState < 0) &&
          !(usKeyCtl & 0x2000)))
    {
      /******************************************************************/
      /* Check for up or down arrow                                     */
      /******************************************************************/
      if ((wParam == VK_UP) ||
          (wParam == VK_DOWN))
      {
        if (!pccinfon->preccCursor)
        {
          ReleaseDC (hwnd, hps);
          return (FALSE);
        }

        if (lpRecordn = FindRecordVert( hwnd, pccinfon->preccCursor,
                                (wParam == VK_UP) ? RD_ABOVE : RD_BELOW))
        {
          Processed = TRUE;
          if (!(ScrollToRecord( hwnd, pccinfon->preccCursor, lpRecordn,
                                TRUE, FALSE)))
          {
             ReleaseDC (hwnd, hps);
             return (TRUE);
          }
        }
      }
      /******************************************************************/
      /* Check for left or right arrow                                  */
      /******************************************************************/
      else if ((wParam == VK_RIGHT) ||
                (wParam == VK_LEFT))
      {
        if (pccinfo->flWindowAttr & CV_DETAIL)
        {
           Processed = TRUE;
           ScrollUnit = (int)pccinfon->lAveCharWidth;

           if (wParam == VK_LEFT)
           {
             ScrollUnit = -ScrollUnit;
           }

           if (pccinfon->ulFlagSet2 & FL2_FOCUSLEFT)
           {
              Scrollbar  = CID_HSCROLL;
              HScrollPos = &pccinfon->sHscrollPos;
              HScrollMax = &pccinfon->sHscrollMax;
           }
           else
           {
              Scrollbar  = CID_RIGHTHSCROLL;
              HScrollPos = &pccinfon->sHscrollPosRight;
              HScrollMax = &pccinfon->sHscrollMaxRight;
           }

           if ((long)ScrollUnit % (long)(pccinfon->sHscrollFactor))
           {
              lScroll = ((long)ScrollUnit /
                         (long)(pccinfon->sHscrollFactor)) + 1;
           }
           else
           {
              lScroll = (long)ScrollUnit /
                        (long)(pccinfon->sHscrollFactor);
           }

           sScrollPos = min((long)(*HScrollMax),                        /*DAB1*/
                                    (long)(*HScrollPos) + lScroll);

           if ( sScrollPos < 0 )                                        /*PPB1*/
             sScrollPos = 0;                                            /*PPB1*/

           SENDMESSAGE( hwnd, WM_HSCROLL,
                        MAKELONG( SB_THUMBPOSITION, sScrollPos ),       /*DAB1*/
                        (LPARAM)GetDlgItem( hwnd, Scrollbar ));         /*DAB1*/
        } /* Details view */
        else if ( !(pccinfo->flWindowAttr & CV_ICON)  &&
                  !(pccinfo->flWindowAttr & CV_FLOW) )
        {
          if (wParam == VK_RIGHT)
            SENDMESSAGE( hwnd, WM_HSCROLL,
                         MAKELONG( SB_LINEDOWN, 0 ),                    /*DAB1*/
                         (LPARAM)GetDlgItem( hwnd, CID_HSCROLL ));      /*DAB1*/
          else
            SENDMESSAGE( hwnd, WM_HSCROLL,
                         MAKELONG( SB_LINEUP, 0 ),                      /*DAB1*/
                         (LPARAM)GetDlgItem( hwnd, CID_HSCROLL ));      /*DAB1*/
        }
        else
        {
          if (!pccinfon->preccCursor)
          {
            ReleaseDC (hwnd, hps);
            return (FALSE);
          }

          if ( lpRecordn = FindRecordHorz( hwnd, pccinfon->preccCursor,
               ( wParam == VK_RIGHT ) ? RD_RIGHT : RD_LEFT ))
          {
            Processed = TRUE;
            if (!(ScrollToRecord( hwnd, pccinfon->preccCursor, lpRecordn,
                             TRUE, FALSE)))
            {
               ReleaseDC (hwnd, hps);
               return (TRUE);
            }
          }
        }
      } /* VK_RIGHT, VK_LEFT */
    } /* CUA augmentation keys */

    /******************************************************************/
    /* Check for page down or for page up                             */
    /******************************************************************/
    if (((wParam == VK_NEXT) ||
          (wParam == VK_PRIOR)) &&
          !(usKeyCtl & 0x2000) && !(keyShiftState < 0))
    {
      WORD  wViewportID;

      if (!pccinfon->preccCursor)
      {
        ReleaseDC (hwnd, hps);
        return (FALSE);
      }

      Processed = TRUE;

      if ((pccinfo->flWindowAttr & CV_DETAIL)  &&
          (keyCtrlState < 0))
      {
        if (pccinfon->ulFlagSet2 & FL2_FOCUSLEFT)
        {
          wViewportID = CID_HSCROLL;
        }
        else
        {
          wViewportID = CID_RIGHTHSCROLL;
        }
      }
      else
      {
        wViewportID = (keyCtrlState < 0)  ?
                          CID_HSCROLL  :
                          CID_VSCROLL;
      }

      SENDMESSAGE( hwnd, ((wViewportID == CID_VSCROLL) ?
                   WM_VSCROLL :  WM_HSCROLL), MAKELONG(                 /*DAB1*/
                   ((wParam == VK_NEXT) ? SB_PAGEDOWN : SB_PAGEUP), 0 ),/*DAB1*/
                   (LPARAM)GetDlgItem( hwnd, wViewportID));             /*DAB1*/

      /***************************************************************/
      /* Set current cursored and first item in all views except     */
      /* icon view(no auto_pos specified)                            */
      /***************************************************************/
      if ((!(!(pccinfo->flWindowAttr & CV_TREE) &&
            (pccinfo->flWindowAttr & CV_ICON) &&
            !(GetWindowLong(hwnd, GWL_STYLE ) &
              CCS_AUTOPOSITION))) &&
          !(CnrSetCursorFirstItemInView(hwnd, hps, TRUE)))
      {
         ReleaseDC (hwnd, hps);
         return (TRUE);
      }
    } /* VK_PRIOR, VK_NEXT */
    /*****************************************************************/
    /* Check for end or home                                         */
    /*****************************************************************/
    else if (((wParam == VK_END) ||
             (wParam == VK_HOME)) &&
             !(usKeyCtl & 0x2000) && !(keyShiftState < 0))
    {
      if (!pccinfon->preccCursor)
      {
        ReleaseDC (hwnd, hps);
        return (FALSE);
      }

      Processed = TRUE;

      if (wParam == VK_END)
      {
        if ((pccinfo->flWindowAttr & CV_ICON) &&
            !(pccinfo->flWindowAttr & CV_TREE) &&
             (!(GetWindowLong (hwnd, GWL_STYLE) &
              CCS_AUTOPOSITION)))
        {
          lpRecordn = GetHomeOrEndInIconView(hwnd, VK_END);
        }
        else
        {
          lpRecordn = pccinfon->preccLastItem;
        }

        while (lpRecordn && !(ISRECORDVISIBLE(lpRecordn)))
        {
          lpRecordn = lpRecordn->preccPrevItem;
        }
        if (lpRecordn && (pccinfo->flWindowAttr & CV_TREE))
        {
          lpRecordn = TRVFindLastUnfiltered(hwnd, lpRecordn);
        }
      }
      else
      {
        if ((pccinfo->flWindowAttr & CV_ICON) &&
            !(pccinfo->flWindowAttr & CV_TREE) &&
             (!(GetWindowLong (hwnd, GWL_STYLE) &
               CCS_AUTOPOSITION)))
        {
          lpRecordn = GetHomeOrEndInIconView(hwnd, VK_HOME);
        }
        else
        {
          lpRecordn = pccinfon->preccItem;
        }

        while (lpRecordn && !(ISRECORDVISIBLE(lpRecordn)))
        {
          lpRecordn = lpRecordn->preccNextItem;
        }
      }

      if (lpRecordn)
      {
        if (!(ScrollToRecord( hwnd, pccinfon->preccCursor, lpRecordn,
                              TRUE, FALSE)))
        {
           ReleaseDC (hwnd, hps);
           return (TRUE);
        }
      }
      pccinfon->preccCursor = lpRecordn;
    } /* VK_HOME, VK_END */
  } /* WM_KEYDOWN */
  else if ( msg == WM_CHAR )
  {
    /**************************************************************/
    /* If the "new line" key was pressed, send a CN_ENTER         */
    /* notification.                                              */
    /**************************************************************/
    if ( wParam == VK_RETURN  &&
         !(usKeyCtl & 0x2000) && !(keyCtrlState < 0) &&
         !(keyShiftState < 0))
    {
      Processed = TRUE;
      if (pccinfon->preccCursor)
      {
        COPYNDATATOX(pccinfon->preccCursor);
        nRecordEnter.pRecord = pccinfon->preccCursor->preccX;
      }
      else
      {
        nRecordEnter.pRecord = NULL;
      }
      nRecordEnter.hwndCnr = hwnd;
      nRecordEnter.fKey = TRUE;
      NotifyOwner (hwnd, CN_ENTER, (LPVOID)&nRecordEnter);
    }

    /*****************************************************************/
    /* If in tree view and receive the + or - keystroke then         */
    /*      "+" -> Expand the cursored item                          */
    /*      "-" -> Collapse the cursored item                        */
    /*****************************************************************/
    else if ( (pccinfo->flWindowAttr & CV_TREE) &&
              ((wParam == '+') || (wParam == '-')) &&
              pccinfon->preccCursor)
    {
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      if (wParam == '+')
      {
        CnrTRVExpandCollapse(hwnd, CM_EXPANDTREE,
                             pccinfon->preccCursor);
      }
      else
      {
        CnrTRVExpandCollapse(hwnd, CM_COLLAPSETREE,
                             pccinfon->preccCursor);
      }
      Processed = TRUE;
    }
    else if ((keyCtrlState < 0) &&
             ((wParam == '/') || (wParam == '\\')))
    {
      SelectDeselectAll(hwnd, hps, wParam);
      Processed = TRUE;
    }
    else if (!pccinfon->preccCursor)
    {
      ReleaseDC (hwnd, hps);
      return (FALSE);
    }

    if ( ! Processed  &&
         CnrProcessCharKey( hwnd, wParam, hps ) )
    {
      Processed = TRUE;
    }
  } /* WM_CHAR */

  ReleaseDC (hwnd, hps);

  if (Processed)
  {
     return (TRUE);
  }
  else
  {
     return (FALSE);
  }
}

/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  SelectDeselectAll                                  */
/*                                                                    */
/* USAGES : External                                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:                                                  */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:                                            */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/*********************************************************************/
BOOL FAR SelectDeselectAll(HWND hwnd, HDC hps, WPARAM wParam)           /*DAB1*/
{
  LPCNRINFON    pccinfon;
  LPCNRINFO     pccinfo;
  WORD          fsControl;
  LPRECORDCOREN preccCurrent;

  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  if (!(pccinfo->flWindowAttr & CV_TREE) &&
      (GetWindowLong(hwnd, GWL_STYLE ) &
       (CCS_MULTIPLESEL | CCS_EXTENDSEL)))
  {
    if (wParam == '/')
    {
      fsControl = SEB_SET;
    }
    else
    {
      fsControl = SEB_CLEAR;
    }
    preccCurrent = pccinfon->preccItem;

    /*****************************************************************/
    /* Deselect ar deselect all.                                     */
    /*****************************************************************/
    while (preccCurrent)
    {
      if (ISRECORDVISIBLE(preccCurrent))
      {
        SetEmphasisBits (hwnd, hps, preccCurrent, CRA_SELECTED,
                         fsControl);
      }
      else
      {
        SetEmphasisBits (hwnd, NULL, preccCurrent, CRA_SELECTED,
                         fsControl);
      }
      preccCurrent = preccCurrent->preccNextItem;
    }
  }
  return TRUE;
}

/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  CnrProcessMouseMove                                */
/*                                                                    */
/* USAGES : External                                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:                                                  */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:                                            */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:                                                             */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/*                                                                    */
/**********************************************************************/
BOOL FAR CnrProcessMouseMove( HANDLE hwnd, LPARAM mp1 )                 /*DAB1*/
{
  LPCNRINFON    pccinfon;               /* Internal CNR control data  */
  LPCNRINFO     pccinfo;
  LPRECORDCOREN pRecord;                /* General purpose record     */
  HDC           hps;                    /* HDC used in default paint  */
  POINT         mousePt;
  long          windowStyle;            /* Determine selections style */
  HICON         hptrArrow;
  RECT          rctlInvalid;
  RECT          rctlHScroll;
  RECT          rctlIcon;
  RECT          rctlLTitle;
  RECT          rctlColumnTitle;
  POINT         slIcon;
  LPMARQUEEREC  pmrMarquee;
  RECT          rctlMarqueeBox;
  WORD          fControl;

  SENDMESSAGE( hwnd, WM_SETCURSOR, (WPARAM)hwnd,                        /*DAB4*/
               MAKELONG(HTCLIENT, WM_MOUSEMOVE) );                      /*DAB4*/

  /*****************************************************************/
  /* Get ptr to internal CNRINFO control data.  The pointer to the */
  /* external control data is beyond the pointer to the internal   */
  /* control data.                                                 */
  /*****************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  CnrQuerySizeRect(hwnd, &slIcon, &rctlLTitle, &rctlInvalid, NULL,
                   &rctlHScroll);

  if ((pccinfo->flWindowAttr & CV_ICON) &&
      (pccinfon->ulFlagSet & FL_CAPTURE) &&
      (!(pccinfon->ulFlagSet & FL_DRAGSELECT)))
  {

     hps = PMGetFlippedDC(hwnd);
     if (!GetCapture ())
     {
        SetCapture (hwnd);
     }
     /************************************************************/
     /* If icon view and capturing the mouse, draw the box OFF,  */
     /* get new coords, and draw the box ON.                     */
     /************************************************************/
     CnrDrawBoxOutline(hwnd, hps, &pccinfon->ptlStart, &pccinfon->ptlEnd);

     /************************************************************/
     /* If icon view and capturing the mouse and first mouse move*/
     /* message then create linked list of viewable records to   */
     /* allow for dynamic selection during maquee selection.     */
     /************************************************************/
     rctlInvalid.bottom += rctlLTitle.bottom;
     rctlInvalid.top    += rctlLTitle.bottom;

     PMGetCursorPos (&pccinfon->ptlEnd);
     ScreenToClient (hwnd, &pccinfon->ptlEnd);

     /**************************************************************/
     /* If marquee mouse goes out of container only draw it inside */
     /* the containers area                                        */
     /**************************************************************/
     if (pccinfon->ptlEnd.x < 0)
     {
       pccinfon->ptlEnd.x = 0;
     }
     if (pccinfon->ptlEnd.x > rctlInvalid.right)
     {
       pccinfon->ptlEnd.x = rctlInvalid.right-1;
     }
     if (pccinfon->ptlEnd.y > (rctlLTitle.bottom + rctlInvalid.bottom))
     {
       pccinfon->ptlEnd.y = rctlLTitle.bottom + rctlInvalid.bottom;
     }
     if (pccinfon->ptlEnd.y < rctlLTitle.bottom)
     {
       pccinfon->ptlEnd.y = rctlLTitle.bottom + 1;
     }

     /*****************************************************************/
     /* Search viewable items for any records contained within the    */
     /* marquee box, select all records within and preserve prev.     */
     /* state of all others.                                          */
     /*****************************************************************/
     pmrMarquee = pccinfon->pmrFirstMarquee;
     while (pmrMarquee)
     {
       CnrQueryIconTextRect(hwnd, pmrMarquee->pRecord, &slIcon,
                            FALSE, &rctlIcon, NULL);
       rctlMarqueeBox.top    = min(pccinfon->ptlEnd.y,
                                     pccinfon->ptlStart.y);
       rctlMarqueeBox.bottom = max(pccinfon->ptlEnd.y,
                                     pccinfon->ptlStart.y);
       rctlMarqueeBox.right  = max(pccinfon->ptlEnd.x,
                                     pccinfon->ptlStart.x);
       rctlMarqueeBox.left   = min(pccinfon->ptlEnd.x,
                                     pccinfon->ptlStart.x);

       if ( (pmrMarquee->fSelected) ||
            ( (rctlIcon.top    >= rctlMarqueeBox.top) &&
              (rctlIcon.bottom <= rctlMarqueeBox.bottom) &&
              (rctlIcon.right  <= rctlMarqueeBox.right) &&
              (rctlIcon.left   >= rctlMarqueeBox.left) )  )
       {
         fControl = SEB_SET;
       }
       else
       {
         fControl = SEB_CLEAR;
       }
       if (!SetEmphasisBits (hwnd, hps, pmrMarquee->pRecord,
                             CRA_SELECTED, fControl))
       {
          ReleaseDC (hwnd, hps);
          return (FALSE);
       }
       pmrMarquee = pmrMarquee->pmrNextItem;
     }

     CnrDrawBoxOutline(hwnd, hps, &pccinfon->ptlStart,
       &pccinfon->ptlEnd);

     ReleaseDC (hwnd, hps);
  }
  else
  {
    if ((pccinfon->ulFlagSet & FL_DRAGSELECT) &&
        (!(pccinfon->ulFlagSet & FL_CAPTURE)))
    {
      mousePt.x  = LOWORD(mp1);
      mousePt.y  = HIWORD(mp1);

      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
         CnrQueryColumnTitleWndRect (hwnd, TRUE, &rctlColumnTitle);
         mousePt.y -= (rctlLTitle.bottom + rctlColumnTitle.bottom);
      }

      pRecord = CnrOverRecord(hwnd, mousePt.x, mousePt.y);

      if (!pRecord)
      {
         ReleaseDC (hwnd, hps);
      }

      windowStyle = GetWindowLong( hwnd, GWL_STYLE );

      hps = PMGetFlippedDC(hwnd);

      if ((!(windowStyle & (CCS_MULTIPLESEL | CCS_EXTENDSEL)))
            && pRecord)
      {
#if 0
        if (pRecord != pccinfon->preccCursor)
        {
          if (!CnrFindAndDeemphasizeRecords (hwnd,hps,pRecord,CRA_SELECTED) ||
              !SetEmphasisBits (hwnd, hps, pRecord, CRA_SELECTED, SEB_SET)  ||
              !CnrChangeCursor( hwnd, pRecord, hps, FALSE ))
          {
            ReleaseDC (hwnd, hps);
            return (FALSE);
          }
        }
#endif
        if (pccinfon->preccCursor != pRecord)
        {
          if (pccinfon->preccCursor)
          {
            SetEmphasisBits (hwnd, hps, pccinfon->preccCursor,
                             CRA_CURSORED | CRA_SELECTED, SEB_CLEAR);
          }
          SetEmphasisBits (hwnd, hps, pRecord,
                           CRA_SELECTED | CRA_CURSORED, SEB_SET);
          pccinfon->preccCursor = pRecord;
        }
      }
      else
      {
        /**************************************************************/
        /* If Icon View, this is touch swipe, otherwise it is range   */
        /* swipe.                                                     */
        /**************************************************************/
        if (pccinfo->flWindowAttr & CV_ICON)
        {
          if (( windowStyle & CCS_MULTIPLESEL) ||
              ((windowStyle & CCS_EXTENDSEL) &&
              (GetKeyState (VK_CONTROL) < 0)))
          {

            if ((pRecord) && (pRecord != pccinfon->preccSelTarget))
            {

              if (!CnrChangeCursor (hwnd, pRecord, hps, FALSE) ||
                  !SetEmphasisBits (hwnd, hps, pRecord,
                                    (DWORD)CRA_SELECTED,
                                    (WORD)((pccinfon->fAnchorState) ?
                                    SEB_SET : SEB_CLEAR)))
              {
                 ReleaseDC (hwnd, hps);
                 return (FALSE);
              }

              pccinfon->preccSelTarget = pRecord;
            }
          }
          else
          {
            if ((windowStyle & CCS_EXTENDSEL) &&
                pRecord && (pRecord != pccinfon->preccSelTarget))
            {

#if 0
              if (!CnrChangeCursor( hwnd, pRecord, hps, FALSE ) ||
                  !SetEmphasisBits (hwnd, hps, pRecord, CRA_SELECTED,
                                    SEB_SET))
              {
                 ReleaseDC (hwnd, hps);
                 return (FALSE);
              }
#endif
              if (pccinfon->preccCursor != pRecord)
              {
                if (pccinfon->preccCursor)
                {
                  SetEmphasisBits (hwnd, hps, pccinfon->preccCursor,
                                   CRA_CURSORED, SEB_CLEAR);
                }
                SetEmphasisBits (hwnd, hps, pRecord,
                                 CRA_SELECTED | CRA_CURSORED, SEB_SET);
                pccinfon->preccCursor = pRecord;
              }
              pccinfon->preccSelTarget = pRecord;
            }
          }
        }
        else
        {
          /**************************************************************/
          /* This is the other views, and range swipe select.           */
          /**************************************************************/
          if ((windowStyle & CCS_MULTIPLESEL) ||
              ((windowStyle & CCS_EXTENDSEL) &&
              (pccinfon->ulFlagSet & FL_BUTTON1DOWN)))
          {
            if (!(CnrExtendedSelection(hwnd, hps, pRecord, TOGGLE,
                   FALSE)))
            {
               ReleaseDC (hwnd, hps);
               return (FALSE);
            }
          }
          else
          {
            if (windowStyle & CCS_EXTENDSEL)
            {
              if (!(CnrExtendedSelection(hwnd, hps, pRecord, SELECT,
                       FALSE)))
              {
                 ReleaseDC (hwnd, hps);
                 return (FALSE);
              }
            }
          }
        }
      } /* endif */
      ReleaseDC (hwnd, hps);
    }
  }
  return (TRUE);
}

/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrProcessSearchString                         */
/*                                                                    */
/*  Descriptive Name:  Process CM_SEARCHSTRING message                */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/*    This message returns a pointer to the container record that     */
/*    that matches the input text string.                             */
/*                                                                    */
/*    Parameters for the CM_SEARCHSTRING message are                  */
/*      mp1 :                                                         */
/*        pSearchString(LPSEARCHSTRING) - Pointer to the SEARCHSTRING */
/*          message.                                                  */
/*      mp2 :                                                         */
/*        pSearchAfter(LPRECORDCORE) - Pointer to the starting        */
/*          record.                                                   */
/*                                                                    */
/*  Input:                                                            */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/**********************************************************************/
LPRECORDCORE FAR CnrProcessSearchString(HANDLE hwnd,
                                        LPSEARCHSTRING pSearchString,
                                        LPRECORDCORE pSearchAfter)
{
  LPCNRINFON     pccinfon;                /* Container instance data   */
  LPRECORDCOREN  preccn;
  unsigned long  view;

  /********************************************************************/
  /* Get ptr to Container instance data                               */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);

  /********************************************************************/
  /* Make sure the size field is set properly before entering.        */
  /********************************************************************/
  if (!pSearchString || (pSearchString->cb != sizeof (SEARCHSTRING)))
  {
    SETERROR(PMERR_INVALID_PARAMETERS);
    return ((LPRECORDCORE)ERRORFLAG);
  }

  /********************************************************************/
  /* Make sure the view is valid                                      */
  /********************************************************************/
  /* Strip out other bits like CV_EXACTMATCH from the view field. */
  view = pSearchString->usView &
            ( CV_TEXT | CV_NAME | CV_ICON | CV_DETAIL | CV_TREE );
  switch ( view )
  {
     case CV_TEXT:
       break;

     case CV_NAME:
       break;

     case CV_ICON:
       break;

     case CV_DETAIL:
       break;

     case CV_TREE:
       break;

     default:
       return ((LPRECORDCORE)ERRORFLAG);
       break;
   } /* end switch */

  /********************************************************************/
  /* Determine where to begin record search.                          */
  /********************************************************************/
  if (pSearchAfter == (LPRECORDCORE)CMA_FIRST)
  {
    /******************************************************************/
    /* IF CMA_FIRST specified, start at first record in item order.   */
    /******************************************************************/
    preccn = pccinfon->preccItem;
  }
  else if (pSearchAfter)
  {
    /******************************************************************/
    /* IF a record pointer, start with first record after.            */
    /******************************************************************/
    if ((GetWindowLong (hwnd, GWL_STYLE) & CCS_VERIFYPOINTERS) &&
        !(CnrVerifyPointers(hwnd, (LPVOID) (&pSearchAfter), (DWORD)1)))
    {
      SETERROR (PMERR_INVALID_PARAMETERS);
      return ((LPRECORDCORE)ERRORFLAG);
    }

    /******************************************************************/
    /* Get the internal record from the external one passed in.  If   */
    /* it's NULL, return error.                                       */
    /******************************************************************/
    if (!(preccn = GetRecordNFromX (hwnd, pSearchAfter)))
    {
      SETERROR(PMERR_INVALID_PARAMETERS);
      return ((LPRECORDCORE)ERRORFLAG);
    }
    preccn = GetNextItem (pccinfon, preccn);
  }
  else
  {
    /******************************************************************/
    /* IF search parameter is invalid, return error.                  */
    /******************************************************************/
    SETERROR(PMERR_INVALID_PARAMETERS);
    return ((LPRECORDCORE)ERRORFLAG);
  }

  /********************************************************************/
  /* Find record that mathces the string                              */
  /********************************************************************/
  if (preccn = (CnrFindRecordStringMatch(hwnd, preccn, NULL,
                                     pSearchString->pszSearch,
                                     pSearchString->fsCaseSensitive,
                                     pSearchString->fsPrefix,
                                     pSearchString->usView, FALSE)))
  {
    COPYNDATATOX(preccn);
    return (preccn->preccX);
  }
  return (NULL);
}
/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  CnrProcessMouseButton1Down                         */
/*                                                                    */
/* USAGES : External                                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:                                                  */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:                                            */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:                                                             */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/*   xtai                                                             */
/**********************************************************************/
BOOL FAR CnrProcessMouseButton1Down( HANDLE hwnd, long mp1 )
{
  LPCNRINFON     pccinfon;               /* Internal CNR control data */
  LPCNRINFO      pccinfo;
  HDC            hps;                    /* HDC used in default paint */
  POINT          mousePt;
  long           windowStyle;
  int            keyCtrlState;
  int            keyShiftState;
  LPRECORDCOREN  pMouseRecord;
  BOOL           fClear;

  SetFocus (hwnd);                     // do we really need to do this twice?

  /*****************************************************************/
  /* Get ptr to internal CNRINFO control data.  The pointer to the */
  /* external control data is beyond the pointer to the internal   */
  /* control data.                                                 */
  /*****************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  if (pccinfo->flWindowAttr & CV_TREE)
  {
    return TRVProcessButton1Down(hwnd, mp1);
  } /* endif */

  /****************************************************************/
  /* If in add mode and mouse selection interaction occurs, turn  */
  /* off add mode. Mouse and keyboard techniques shouldn't mix.   */
  /****************************************************************/
  if (pccinfon->ulFlagSet & FL_ADDMODE)
  {
     /********************************************************/
     /* Toggle add mode off. The selection cursor changes to */
     /* a dotted outline box.                                */
     /********************************************************/
     pccinfon->ulFlagSet &= ~FL_ADDMODE;
     CnrSetBlinkTimer(hwnd);
  }

  keyCtrlState = GetKeyState (VK_CONTROL);
  keyShiftState = GetKeyState (VK_SHIFT);

  mousePt.x =  LOWORD(mp1);
  mousePt.y  = HIWORD(mp1);

  windowStyle = GetWindowLong( hwnd, GWL_STYLE );

  pMouseRecord = CnrOverRecord(hwnd, mousePt.x, mousePt.y);

  pccinfon->fFirstMouseMove = TRUE;

  hps = PMGetFlippedDC(hwnd);

  /****************************************************************/
  /* Ctrl + Shift + Click                                         */
  /*   1) Toggles all choices from the anchor point to the        */
  /*      selected choice                                         */
  /*   2) Preserves selection state of all other choices          */
  /*   3) Preserves the anchor point                              */
  /****************************************************************/
  if ((keyCtrlState < 0)  && (keyShiftState < 0))
  {

     keyCtrlState = FALSE;
     keyShiftState = FALSE;

     if ((windowStyle & (CCS_EXTENDSEL | CCS_MULTIPLESEL)) &&
         pMouseRecord &&
         (pccinfo->flWindowAttr & (CV_TEXT | CV_NAME | CV_DETAIL)))
     {
        if (pccinfon->fAnchorState)
        {
          if (!(CnrExtendedSelection(hwnd, hps, pMouseRecord,
            SELECT, FALSE)))
          {
             ReleaseDC (hwnd, hps);
             return (FALSE);
          }
        }
        else
        {
          if (!(CnrExtendedSelection(hwnd, hps, pMouseRecord,
            DESELECT, FALSE)))
          {
             ReleaseDC (hwnd, hps);
             return (FALSE);
          }
        } /* endif */
     }

  }
  /****************************************************************/
  /* Shift + Click                                                */
  /*   1) Selects all choices from the anchor point to the        */
  /*      selected choice                                         */
  /*   2) De-selects all other choices                            */
  /*   3) Preserves the anchor point                              */
  /****************************************************************/
  else
  {
    if (keyShiftState < 0)
    {

      keyCtrlState = FALSE;
      keyShiftState = FALSE;

     if ((windowStyle & (CCS_EXTENDSEL | CCS_MULTIPLESEL)) &&
         pMouseRecord &&
         (pccinfo->flWindowAttr & (CV_TEXT | CV_NAME | CV_DETAIL)))
     {
        if (windowStyle & CCS_MULTIPLESEL)
        {
          fClear = FALSE;
        }
        else
        {
          fClear = TRUE;
        }
        if (!(CnrExtendedSelection(hwnd, hps, pMouseRecord,
          SELECT, fClear)))
        {
           ReleaseDC (hwnd, hps);
           return (FALSE);
        }
     }
    }
    /****************************************************************/
    /* Ctrl + Click                                                 */
    /*   1) Toggles selection state of the choice                   */
    /*   2) Preserves selection state of all other choices          */
    /*   3) Sets the anchor point                                   */
    /****************************************************************/
    else
    {
      if ((keyCtrlState < 0 ) && (keyShiftState >=0))
      {

        keyCtrlState = FALSE;
        pccinfon->ulFlagSet |= FL_BUTTON1DOWN;

       if ((windowStyle & (CCS_EXTENDSEL | CCS_MULTIPLESEL)) &&
           pMouseRecord &&
           (pccinfo->flWindowAttr & (CV_TEXT | CV_NAME | CV_DETAIL)))
       {
         if (pMouseRecord != pccinfon->preccCursor)
         {
           if (!(CnrChangeCursor(hwnd, pMouseRecord, hps, FALSE )))
           {
              return (FALSE);
           }
         }

         if (!SetEmphasisBits (hwnd, hps, pMouseRecord, CRA_SELECTED,
                               SEB_TOGGLE))
         {
            ReleaseDC (hwnd, hps);
            return (FALSE);
         }

         pccinfon->preccAnchor = pMouseRecord;
         pccinfon->preccPrevEndOfRange = pMouseRecord;

         if (pMouseRecord->flRecordAttr & CRA_SELECTED)
         {
            pccinfon->fAnchorState = TRUE;
         }
         else
         {
            pccinfon->fAnchorState = FALSE;
         } /* endif */
       }
       else
       {
         if ((windowStyle & (CCS_EXTENDSEL | CCS_MULTIPLESEL)) &&
             (pccinfo->flWindowAttr & CV_ICON))
         {
           if (!(CnrButtonState(hwnd, hps, LOWORD(mp1),
                          HIWORD(mp1), pMouseRecord)))
           {
              ReleaseDC (hwnd, hps);
              return (FALSE);
           }
         }
       }

       if ((!(pccinfon->ulFlagSet & FL_CAPTURE)) &&
           (windowStyle & (CCS_MULTIPLESEL | CCS_EXTENDSEL)) &&
           (!(GetCapture ())))
       {
         SetCapture (hwnd);
         pccinfon->ulFlagSet |= FL_DRAGSELECT;
       }

      }
      /****************************************************************/
      /* Drag Select                                                  */
      /*   1) Sets the anchor point                                   */
      /*   2) De-selects all other choices                            */
      /*   3) Selects all choices between mouse button down and mouse */
      /*      button up                                               */
      /****************************************************************/
      else
      {
        /*********************************************************/
        /* Simple click, either it is over a record or in white  */
        /* space.  Goto CnrButtonState to determine if record    */
        /* should be selected or if marquee selection has been   */
        /* initiated.                                            */
        /*********************************************************/
        pccinfon->preccSelTarget = NULL;

        if ((keyCtrlState >= 0) && (keyShiftState >= 0))
        {
          if (!(CnrButtonState(hwnd, hps, LOWORD(mp1),
                         HIWORD(mp1), pMouseRecord)))
          {
             ReleaseDC (hwnd, hps);
             return (FALSE);
          }
        }

        if ((!(pccinfon->ulFlagSet & FL_CAPTURE)) &&
            (!(GetCapture ())))
        {
          SetCapture (hwnd);
          pccinfon->ulFlagSet |= FL_DRAGSELECT;
        }
      }
    }
  }
  ReleaseDC (hwnd, hps);
  return (TRUE);
}

/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  TRVProcessButton1Down                              */
/*                                                                    */
/* USAGES :                                                           */
/*                                                                    */
/* DESCRIPTIVE NAME:                                                  */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:                                            */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:                                                             */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/*                                                                    */
/*********************************************************************/
BOOL FAR TRVProcessButton1Down(hwnd, mp1)
HANDLE      hwnd;
long        mp1;

{
  LPCNRINFON    pccinfon;                  /* Internal CNR control data */
  LPRECORDCOREN preccOver;

  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);

  pccinfon->ulFlagSet2 &= ~FL2_ONTREENODE;
  if (preccOver = CnrTRVOverRecord(hwnd, LOWORD(mp1), HIWORD(mp1)))
  {
    if (preccOver != pccinfon->preccCursor)
    {
      HDC          hps;
      LPRECORDCOREN preccOldCursor;

      hps = PMGetFlippedDC (hwnd);

      preccOldCursor = pccinfon->preccCursor;
      pccinfon->preccCursor = preccOver;

      SetEmphasisBits( hwnd, hps, preccOldCursor,
                       (CRA_CURSORED | CRA_SELECTED), SEB_CLEAR);

      SetEmphasisBits( hwnd, (pccinfon->ulFlagSet2 & FL2_ONTREENODE) ?
                       NULL : hps, pccinfon->preccCursor,
                       (CRA_CURSORED | CRA_SELECTED), SEB_SET);

      ReleaseDC (hwnd, hps);
    }

    if (pccinfon->ulFlagSet2 & FL2_ONTREENODE)
    {
      if (preccOver->flRecordAttr & CRA_COLLAPSED)
      {
        CnrTRVExpandCollapse(hwnd, CM_EXPANDTREE, preccOver);
      }
      else
      {
        CnrTRVExpandCollapse(hwnd, CM_COLLAPSETREE, preccOver);
      } /* endif */
    }
  }
  return TRUE;
}


/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  CnrProcessMouseButton1Up                           */
/*                                                                    */
/* USAGES : External                                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:                                                  */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:                                            */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:                                                             */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/*                                                                    */
/**********************************************************************/
BOOL  FAR CnrProcessMouseButton1Up(HANDLE hwnd)
{
  LPCNRINFON  pccinfon;                  /* Internal CNR control data */
  LPCNRINFO   pccinfo;
  HDC         hps;                       /* HDC used in default paint */

  /*****************************************************************/
  /* Get ptr to internal CNRINFO control data.  The pointer to the */
  /* external control data is beyond the pointer to the internal   */
  /* control data.                                                 */
  /*****************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /***********************************************************/
  /* If in icon view and the mouse capture is TRUE, draw the */
  /* box off, and release the mouse capture.                 */
  /***********************************************************/
  hps = PMGetFlippedDC(hwnd);
  if (!(pccinfo->flWindowAttr & CV_TREE) &&
      (pccinfo->flWindowAttr & CV_ICON) &&
      (pccinfon->ulFlagSet & FL_CAPTURE) &&
      (!(pccinfon->ulFlagSet & FL_DRAGSELECT)))
  {
    /*************************************************************/
    /* Free memory of the temporary marquee viewable items list. */
    /*************************************************************/
    if (!pccinfon->fFirstMouseMove)
    {
//    LPVOID        pSatPtr;
      LPMARQUEEREC  pmrCurrent;
      LPMARQUEEREC  pmrNext;

      pccinfon->fFirstMouseMove = TRUE;
//    pSatPtr = (LPVOID)GetWindowLong (hwnd, QWL_STORAGEPTR);
      pmrCurrent = pccinfon->pmrFirstMarquee;
      while (pmrCurrent)
      {
        pmrNext = pmrCurrent->pmrNextItem;
//      StmFreeStorage (pSatPtr, (LPVOID)(pmrCurrent));
        GlobalFree( pmrCurrent );                                       /*DAB1*/
        pmrCurrent = pmrNext;
      }
    }

    CnrDrawBoxOutline(hwnd, hps, &pccinfon->ptlStart,
                      &pccinfon->ptlEnd);

    SetCapture (NULL);

    pccinfon->ulFlagSet &= ~FL_CAPTURE;
  }
  else
  {
    if ((pccinfon->ulFlagSet & FL_DRAGSELECT) &&
       (!(pccinfon->ulFlagSet & FL_CAPTURE)))
    {
      SetCapture (NULL);
      pccinfon->ulFlagSet &= ~FL_DRAGSELECT;
      pccinfon->ulFlagSet &= ~FL_BUTTON1DOWN;
      pccinfon->preccSelTarget = NULL;
    }
  } /* endif */
  ReleaseDC (hwnd, hps);
  return (TRUE);
}
/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  CnrProcessOpenEdit                                 */
/*                                                                    */
/* USAGES : External                                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:                                                  */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:                                            */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:                                                             */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/*                                                                    */
/*********************************************************************/
BOOL FAR CnrProcessOpenEdit(HANDLE hwnd, long mp1)
{
  LPCNRINFON    pccinfon;
  LPCNRINFO     pccinfo;
  LPCNREDITDATA pCnrEditData;
  LPRECORDCOREN preccn;

  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);
  pCnrEditData = (LPCNREDITDATA)(LPVOID)mp1;

  /***************************************************************/
  /* If in edit mode, save the text  and close MLE               */
  /***************************************************************/
  if (pccinfon->ulFlagSet & FL_EDITMODE)
  {
    CnrCloseMLE(hwnd);
  }

  /********************************************************************/
  /* If the container was created as a Read-only container, we cannot */
  /* open direct edit.  Just return TRUE since there really isn't an  */
  /* error here.                                                      */
  /********************************************************************/
  if (GetWindowLong (hwnd, GWL_STYLE) & CCS_READONLY)
  {
     return (TRUE);
  }

  /********************************************************************/
  /* Verify that the control block size is set correctly.             */
  /********************************************************************/
  if (pCnrEditData->cb != sizeof(CNREDITDATA))
  {
    SETERROR (PMERR_INVALID_PARAMETERS);
    return(FALSE);
  }

  if ((pCnrEditData->id == getWindowId(hwnd)) ||
      (pCnrEditData->id == CID_LEFTDVWND) ||
      (pCnrEditData->id == CID_RIGHTDVWND))
  {
    if ((GetWindowLong(hwnd, GWL_STYLE) & CCS_VERIFYPOINTERS) &&
        !CnrVerifyPointers(hwnd, (LPVOID)(&pCnrEditData->pRecord), 1L))
    {
      SETERROR (PMERR_INVALID_PARAMETERS);
      return(FALSE);
    }

    preccn = GetRecordNFromX(hwnd, pCnrEditData->pRecord);

    /*****************************************************************/
    /* If the item is not visible,.......                            */
    /*****************************************************************/
    if (!ISRECORDVISIBLEINVIEW(pccinfo, preccn))
    {
      SETERROR (PMERR_INVALID_PARAMETERS);
      return(FALSE);
    }
  }

  if ((pCnrEditData->id == CID_LEFTDVWND) ||
      (pCnrEditData->id == CID_RIGHTDVWND) ||
      (pCnrEditData->id == CID_LEFTCOLTITLEWND) ||
      (pCnrEditData->id == CID_RIGHTCOLTITLEWND))
  {
    if ((GetWindowLong(hwnd, GWL_STYLE) & CCS_VERIFYPOINTERS) &&
        !CnrVerifyFieldInfoPtrs(hwnd, pCnrEditData->pFieldInfo, 1))
    {
      SETERROR (PMERR_INVALID_PARAMETERS);
      return(FALSE);
    }

    /******************************************************************/
    /* If the item is not visible,.......                             */
    /******************************************************************/
    if (pCnrEditData->pFieldInfo->flData & CFA_INVISIBLE)
    {
      SETERROR (PMERR_INVALID_PARAMETERS);
      return(FALSE);
    }
  }

  if (pCnrEditData->id == getWindowId(hwnd))
  {
    if (!(pccinfo->flWindowAttr & CV_DETAIL))
    {
      if (OpenRecordTextMLE (hwnd, preccn))
      {
         return (TRUE);
      }
      else
      {
        SETERROR(PMERR_INVALID_PARAMETERS);
        return (FALSE);
      }
    }
    else
    {
      SETERROR(PMERR_INVALID_PARAMETERS);
      return (FALSE);
    }
  }

  switch (pCnrEditData->id)
  {
    case CID_CNRTITLEWND:
      if (pccinfo->flWindowAttr & CA_CONTAINERTITLE)
      {
        if (CnrOpenTitleTextMLE (GetDlgItem (hwnd,
                                                  CID_CNRTITLEWND)))
        {
          return (TRUE);
        }
        else
        {
          return (FALSE);
        }
      }
      else
      {
        SETERROR(PMERR_INVALID_PARAMETERS);
        return (FALSE);
      }
    break;

    case CID_LEFTDVWND:
      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
         if ((preccn) && (pCnrEditData->pFieldInfo) &&
             (pCnrEditData->pFieldInfo->flData & CFA_STRING))
         {
            return ((OpenColDataTextMLE (hwnd, preccn,
                                    pCnrEditData->pFieldInfo, TRUE)));
         }
         else
         {
            SETERROR(PMERR_INVALID_PARAMETERS);
            return (FALSE);
         }
      }
      else
      {
         SETERROR(PMERR_INVALID_PARAMETERS);
         return (FALSE);
      }
    break;

    case CID_RIGHTDVWND:
      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
         if ((preccn) && (pCnrEditData->pFieldInfo) &&
             (!(pccinfon->ulFlagSet & FL_UNSPLIT)) &&
             (pCnrEditData->pFieldInfo->flData & CFA_STRING) &&
           (CnrVerifyFieldInfoPtrs (hwnd, pccinfon->pFieldInfoLast, 1)))
         {
            /**********************************************************/
            /* Make sure there is data in the right window.           */
            /**********************************************************/
            if (NEXTVISIBLEFI(pccinfon->pFieldInfoLast))
            {
               return ((OpenColDataTextMLE (hwnd, preccn,
                                     pCnrEditData->pFieldInfo, FALSE)));
            }
            else
            {
               SETERROR(PMERR_INVALID_PARAMETERS);
               return (FALSE);
            }
         }
         else
         {
            SETERROR(PMERR_INVALID_PARAMETERS);
            return (FALSE);
         }
      }
      else
      {
         SETERROR(PMERR_INVALID_PARAMETERS);
         return (FALSE);
      }
    break;

    case CID_LEFTCOLTITLEWND:
      if ((pccinfo->flWindowAttr & CV_DETAIL) &&
          (pccinfo->flWindowAttr & CA_DETAILSVIEWTITLES) &&
          (!(pCnrEditData->pFieldInfo->flTitle & CFA_BITMAPORICON)))
      {
         if (pCnrEditData->pFieldInfo)
         {
            return (OpenColTitleTextMLE (hwnd,
                                         pCnrEditData->pFieldInfo,
                                         TRUE));
         }
         else
         {
            SETERROR(PMERR_INVALID_PARAMETERS);
            return (FALSE);
         }
      }
      else
      {
         SETERROR(PMERR_INVALID_PARAMETERS);
         return (FALSE);
      }
    break;

    case CID_RIGHTCOLTITLEWND:
      if ((pccinfo->flWindowAttr & CV_DETAIL) &&
          (pccinfo->flWindowAttr & CA_DETAILSVIEWTITLES) &&
          (!(pCnrEditData->pFieldInfo->flTitle & CFA_BITMAPORICON)))
      {
         if ((pCnrEditData->pFieldInfo) &&
             (!(pccinfon->ulFlagSet & FL_UNSPLIT)) &&
           (CnrVerifyFieldInfoPtrs (hwnd, pccinfon->pFieldInfoLast, 1)))
         {
            /**********************************************************/
            /* Make sure there is data in the right window.           */
            /**********************************************************/
            if (NEXTVISIBLEFI(pccinfon->pFieldInfoLast))
            {
               return (OpenColTitleTextMLE (hwnd,
                                            pCnrEditData->pFieldInfo,
                                            FALSE));
            }
            else
            {
               SETERROR(PMERR_INVALID_PARAMETERS);
               return (FALSE);
            }
         }
         else
         {
            SETERROR(PMERR_INVALID_PARAMETERS);
            return (FALSE);
         }
      }
      else
      {
         SETERROR(PMERR_INVALID_PARAMETERS);
         return (FALSE);
      }
    break;

    default:
      SETERROR(PMERR_INVALID_PARAMETERS);
      return (FALSE);
  }
  return 0;
}

/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  GetHomeOrEndInIconView                             */
/*                                                                    */
/* DESCRIPTIVE NAME:                                                  */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:                                            */
/*     In icon view we need to search for the top-leftmost item for   */
/*     the home key and search for the bottom-right most item for     */
/*     the end key.  We can not use the first and last items in the   */
/*     linked list as we do in the other linear views.                */
/*                                                                    */
/*********************************************************************/
LPRECORDCOREN FAR GetHomeOrEndInIconView (HWND hwnd, int Direction)
{
  POINT         ComparisonPoint;
  LPRECORDCOREN pRecordNext=NULL;
  LPRECORDCOREN pRecordReturn=NULL;
  long          cxNext;
  long          cyNext;
  DWORD         distanceMin=0xffffffff;
  DWORD         distanceNext;
  POINT         iconSize;
  LPCNRINFON    pccinfon;

  /********************************************************************/
  /* Get pointer to Container internal data.                          */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);

  /******************************************************************/
  /* Calculate the icon rectangle                                   */
  /******************************************************************/
  CnrCalcIconSize (hwnd, &iconSize);

  /********************************************************************/
  /*  Set up the Comparison point:                                    */
  /*          END -> bottomright corner of workspac                   */
  /*          HOME-> topleft corner of workspace                      */
  /*  Adjust for the icons center point.                              */
  /********************************************************************/
  if ( Direction == VK_END )
  {
    ComparisonPoint.x = pccinfon->rctlWorkplaceItems.right;
    ComparisonPoint.y = pccinfon->rctlWorkplaceItems.bottom;
  }
  else
  {
    ComparisonPoint.x = pccinfon->rctlWorkplaceItems.left;
    ComparisonPoint.y = pccinfon->rctlWorkplaceItems.top;
  }
  ComparisonPoint.x -= iconSize.x / 2;
  ComparisonPoint.y -= iconSize.y / 2;

  /********************************************************************/
  /*  Loop trough the visible items in the container and  save the    */
  /*  closest item to the comparison point.  This is the one we want. */
  /********************************************************************/
  pRecordNext = pccinfon->preccItem;
  while (pRecordNext && !(ISRECORDVISIBLE(pRecordNext)))
  {
    pRecordNext = pRecordNext->preccNextItem;
  }

  while (pRecordNext)
  {
    cxNext = (long)ComparisonPoint.x - (long)pRecordNext->ptlIcon.x;
    cyNext = (long)ComparisonPoint.y - (long)pRecordNext->ptlIcon.y;
    distanceNext = cyNext*cyNext + cxNext*cxNext;

    if (distanceNext < distanceMin)
    {
      distanceMin = distanceNext;
      pRecordReturn = pRecordNext;
    }
    pRecordNext = GetNextUnfilteredItem( pRecordNext );
  }

  return( pRecordReturn);
}
