/* Revision: 19 1.4.1.3 source/ui/cclnt/cnr/cnrs3p2.c, cclcnr, ioc.v400, 001006  */
/**********************************************************************/
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*        (IBM Confidential-Restricted when combined with the         */
/*         aggregated OCO source modules for this program)            */
/*                                                                    */
/*                       OCO SOURCE MATERIALS                         */
/*                                                                    */
/*         20G0400 (C) Copyright IBM Corp. 1992, 1997 (Unpublished)   */
/*                                                                    */
/* ================================================================== */
/*                                                                    */
/*                         C O N T A I N E R                          */
/*                                                                    */
/*                        Filename: CNRS3P2.C                         */
/*                                                                    */
/*             ( Windows NT Container Control Component )             */
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*                (C) Copyright IBM Corporation 1997                  */
/*                       All Rights Reserved                          */
/*            Licensed Material - Program Property of IBM             */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/* Product: ICLUINT.DLL                                               */
/* Filename: CNRS3P2.C - Main window procedure for container control  */
/*                                                                    */
/* Flag    Date    By:  Description                                   */
/* ----  --------  ---  --------------------------------------------- */
/* DAB1  11/16/93  DAB  Initial modifications for NT execution        */
/* DAB2  01/19/94  DAB  Corrected NLS formatting bug                  */
/* DAB3  02/03/94  DAB  Modified CM_* message APIs to match OS/2 2.x  */
/* DAB4  03/17/94  DAB  Fix International string overwriting problem  */
/* DAB5  03/17/94  DAB  Fix direct edit for container w/in a dialog   */
/* DAB6  10/27/95  DAB  Add context menu support to container         */
/* DAB7  11/26/95  DAB  Fix context menu record over support          */
/* D6386  1/16/95  ASM  Enable message passing in Win32s environment  */
/*                      Change SendMessage to SENDMESSAGE             */
/* D6337  1/19/96  EVB  Process CM_QUERYCNRCOLORS                     */
/* RKK1   4/30/96  RKK  Add changes required for Wind/U.              */
/**********************************************************************/
#include <windows.h>
#include <iclccl.h>     /* CCL common include file */
#include "cnr2win.h"
#include "iclcnrw.h"

#include "cnrcbn.h"

//#include "storwin.h"

#ifdef SEGMENTOR
#define CNRS3P2_C
#include "cnrpragw.h"
#endif

extern HANDLE  vhCNRInstance;
extern int viUseCount;

/**********************************************************************/
/*                                                                    */
/*  Procedure Name:    GateProc                                       */
/*                                                                    */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/**********************************************************************/
LRESULT CALLBACK CnrGateProc( HWND hwnd, UINT msg, WPARAM wParam,       /*DAB1*/
                              LPARAM lParam )                           /*DAB1*/
{
  LPCNRINFON     pccinfon;               /* Internal CNR control data */
  LPCNRINFO      pccinfo;
  LPRECORDCORE   pRecord;                /* General purpose record    */
  HDC            hps;                    /* HDC used in default paint */
  int            KeyState1;
  int            KeyState2;
  int            KeyState3;
  POINT          ptrPos;
  HANDLE         hwndWindow;
  LPRECORDCOREN  preccn;
  MSG            qmsg;
  NOTIFYRECORDENTER  nRecordEnter;       /* CN_ENTER notfify record   */
  CNRMENUINIT    nMenuInit;              /* CN_CONTEXTMENU notify blk *//*DAB6*/

  /********************************************************************/
  /* Following variables are used in functions which are under        */
  /* development.  They will be defined later or moved to a function  */
  /********************************************************************/

  /********************************************************************/
  /* Get ptr to internal CNRINFO control data.  The pointer to the    */
  /* external control data is beyond the pointer to the internal      */
  /* control data.                                                    */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  switch (msg)
  {
    /******************************************************************/
    /*                          Container messages                    */
    /******************************************************************/

    case CM_SEARCHSTRING:
      /****************************************************************/
      /* Process the SEARCHSTRING message. Parameters are             */
      /* mp1 - (LPSEARCHSTRING) pSearchString                         */
      /* mp2 - (LPRECORDCORE)   pSearchAfter                          */
      /****************************************************************/
      return((long)CnrProcessSearchString(hwnd, (LPVOID)wParam,         /*DAB3*/
                                          (LPVOID)lParam ));            /*DAB3*/

    case CM_ALLOCDETAILFIELDINFO:
    /******************************************************************/
    /* CnrAllocDetailFieldInfo is contained in cnrdetv.c.  mp1 is     */
    /* passed as a parameter and contains the number of FieldInfo     */
    /* Structures to be allocated.                                    */
    /******************************************************************/
      return ((long)(CnrAllocDetailFieldInfo (hwnd, wParam)));

    case CM_ALLOCRECORD:
    /*****************************************************************/
    /* CnrAllocRecord is contained in cnrmmr.c.  mp1 contains the    */
    /* number of extra bytes the application wants to allocate for   */
    /* each Recordcore structure.  mp2 contains the number of        */
    /* Records to be allocated.                                      */
    /*****************************************************************/
    return ((long)(CnrAllocRecord( hwnd, wParam, LOWORD(lParam))));     /*DAB1*/

    case CM_ARRANGE:

      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      /***************************************************************/
      /* Set the flag FL_NEEDARRANGE on, so that when painting       */
      /* icon view, the control rearranges the records in the        */
      /* container.                                                  */
      /***************************************************************/
      pccinfon->ulFlagSet |= FL_NEEDARRANGE;
      if (!(pccinfo->flWindowAttr & CV_TREE) &&
          (pccinfo->flWindowAttr & CV_ICON))
      {
        PMInvalidateRect( hwnd, NULL, FALSE );
      } /* endif */
      return ((long)TRUE);


    case CM_CLOSEEDIT:
       /***************************************************************/
       /* If in edit mode, save the text  and close MLE               */
       /***************************************************************/
       if (pccinfon->ulFlagSet & FL_EDITMODE)
       {
         if (!(CnrSaveTextCloseMLE(hwnd)))
         {
           return ((long)NULL);
         }
       }
       return ((long)TRUE);

    case CM_COLLAPSETREE:
    case CM_EXPANDTREE:

      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }

      pRecord = (LPRECORDCORE)wParam;                                   /*DAB3*/
      if ((pRecord) &&
          (GetWindowLong (hwnd, GWL_STYLE) & CCS_VERIFYPOINTERS) &&
            !CnrVerifyPointers(hwnd, &pRecord, (DWORD)1))
      {
        return ((long)FALSE);
      }

      return (long)(CnrTRVExpandCollapse(hwnd, msg,
                          GetRecordNFromX(hwnd, pRecord)));

    case CM_ERASERECORD:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      /*****************************************************************/
      /* CnrEraseRecord is in cnrgen.c. This message is used in        */
      /* conjunction with direct manipulation to erase the source      */
      /* record from the current view when a move has occurred.        */
      /* mp1 - pointer to the record to be erased from the current view*/
      /*****************************************************************/
      pRecord = (LPVOID)wParam;                                         /*DAB3*/

      if ((GetWindowLong( hwnd, GWL_STYLE ) & CCS_VERIFYPOINTERS) &&
            !CnrVerifyPointers(hwnd, &pRecord, (DWORD)1) )
      {
        return ((long)FALSE);
      }
      else
      {
        hps = PMGetFlippedDC(hwnd);

        if (!(CnrEraseRecord(hwnd, hps, GetRecordNFromX(hwnd, pRecord))))
        {
           ReleaseDC(hwnd, hps);
           return ((long)NULL);
        }

        ReleaseDC(hwnd, hps);
        return ((long)TRUE);
      } /* endif */

    case CM_FILTER:

      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
    /*****************************************************************/
    /* CnrFilter is in cnrgen.c. This message is used in             */
    /* filtering or unfiltering records.                             */
    /* mp1 - pointer to function that determines if a record         */
    /*       is filtered. If mp1 is NULL, unfilter the filtered      */
    /*       records.                                                */
    /*****************************************************************/
      return ((long)CnrFilter(hwnd, wParam, lParam));                   /*DAB3*/

    /******************************************************************/
    /* Free the Field Information structures used for details view    */
    /*   mp1: padfi - pointer to an array of pointers to field        */
    /*                information structures which are to be freed    */
    /*   mp2: ulFICount - number of field info structures to be freed */
    /*   reply:                                                       */
    /******************************************************************/
    case CM_FREEDETAILFIELDINFO:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      return ((long)CnrFreeDetailFieldInfo (hwnd, wParam, lParam));     /*DAB3*/

   case CM_FREERECORD:
   /******************************************************************/
   /* CnrFreeRecord is contained in cnrmmr.c.  mp1 contains a        */
   /* pointer to an array of pointers to RECRORDCORE structures to   */
   /* be freed.  mp2 contains the number of records that are to be   */
   /* freed.  The last parameter tells CnrFreeRecord to check each   */
   /* pointer passed in to see if it currently inserted or not.      */
   /******************************************************************/
   return ((long)CnrFreeRecord (hwnd, wParam, lParam, TRUE));           /*DAB3*/

   case CM_HORZSCROLLSPLITWINDOW:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
   /*******************************************************************/
   /* CnrHorzScrollSplitWindow is contained in cnrdetv.c  mp1         */
   /* contains a window indicator (CMA_LEFT or CMA_RIGHT) to dictate  */
   /* which window is to be scrolled.  mp2 contains a positive or     */
   /* negative value indicating the direction and amount to scroll    */
   /* window.                                                         */
   /*******************************************************************/
   return ((long)CnrHorzScrollSplitWindow (hwnd, wParam, lParam));

   case CM_INSERTDETAILFIELDINFO:
     if (pccinfon->ulFlagSet & FL_EDITMODE)
     {
       CnrCloseMLE(hwnd);
     }

     if ((!wParam) || (!lParam))                                        /*DAB3*/
     {
       SETERROR(PMERR_INVALID_PARAMETERS);
       return (FALSE);
     }
     return ((long)CnrInsertDetailFieldInfo (hwnd, wParam, lParam));    /*DAB3*/

   case CM_INSERTRECORD:

      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      /***************************************************************/
      /* CnrInsertRecord is in cnrgen.c.  This message is used to    */
      /* insert records into the container control.                  */
      /* mp1 - pointer to record core structure(s) to be inserted    */
      /* mp2 - RECORDINSERT data structure defining the record item  */
      /*       order, z order, and number of records to be inserted  */
      /* NOTE: update for multiple records.                          */
      /***************************************************************/
      if ((!wParam) || (!lParam))                                       /*DAB3*/
      {
        SETERROR(PMERR_INVALID_PARAMETERS);
        return (FALSE);
      }
      return ((long)CnrInsertRecord (hwnd, wParam, lParam ));           /*DAB3*/

    case CM_INVALIDATEDETAILFIELDINFO:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      return ((long)CnrInvalidateDetailFieldInfo (hwnd));

   case CM_INVALIDATERECORD:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      /***************************************************************/
      /*                                      This message notifies  */
      /* the container that a record(s) and needs to be refreshed.   */
      /* mp1 - pointer to an array of pointers to RECORDCORE         */
      /*       structures which are to be refreshed.                 */
      /* mp2 - number of records to be refreshed. If = 0, all the    */
      /*       records in the container are refreshed and mp1 is     */
      /*       ignored.                                              */
      /***************************************************************/
      return ((long)CnrInvalidateRecord (hwnd, wParam, lParam ));       /*DAB3*/

    case CM_OPENEDIT:
       SetFocus( hwnd);
       return ((long)CnrProcessOpenEdit(hwnd, wParam));                 /*DAB3*/

    case CM_PAINTBACKGROUND:   //what the hey?
      return(FALSE);

    case CM_QUERYCNRINFO:
      /***************************************************************/
      /* CnrQueryCnrInfo is in cnrgen.c.  This message is used to    */
      /* query container data.                                       */
      /* mp1 - pointer to buffer in which to copy data               */
      /* mp2 - number of bytes copied                                */
      /***************************************************************/
      return((long)CnrQueryCnrInfo(hwnd, wParam, lParam));              /*DAB3*/

   case CM_QUERYDETAILFIELDINFO:
      /****************************************************************/
      /* CnrQueryDetailFieldInfo is contained in cnrdetv.c.  mp1 and  */
      /* mp2 are passed as parameters and contain: mp1 - pointer to a */
      /* FieldInfo structure for which information is requested.      */
      /* mp2 - Command indicating which FieldInfo structure to        */
      /* retreive.                                                    */
      /****************************************************************/
      return ((long)CnrQueryDetailFieldInfo (hwnd, wParam, lParam));    /*DAB3*/

   case CM_QUERYRECORD:
      /***************************************************************/
      /* CnrRecord is in cnrgen.c.  This message is used to query    */
      /* a specified record.                                         */
      /* mp1 - pointer to record for which data is requested         */
      /* mp2 - data structure containing which record to retrieve,   */
      /*       and an enumeration order flag.                        */
      /***************************************************************/
      return((long)CnrQueryRecord(hwnd, wParam, lParam ));              /*DAB3*/

   case CM_QUERYRECORDINFO:
      /****************************************************************/
      /* This message is sent to query the attributes of a specific   */
      /* record.  The view specific attributes are returned to the    */
      /* application.                                                 */
      /****************************************************************/
      return ((long)(CnrQueryRecordInfo (hwnd, wParam, lParam)));       /*DAB3*/

   case CM_QUERYRECORDEMPHASIS:
      /***************************************************************/
      /* CnrRecordEmphasis is in cnrgen.c.  This message is used to  */
      /* query the record with the specified emphasis attributes.    */
      /* mp1 - pointer to specified record                           */
      /* mp2 - emphasis mask of the record                           */
      /***************************************************************/
      return((long)CnrQueryRecordEmphasis(hwnd, wParam, lParam));       /*DAB3*/


   case CM_QUERYRECORDFROMRECT:
      /***************************************************************/
      /* CnrRecordFromRect is in cnrgen.c. This message is used to   */
      /* enumerate records bounded by a specified rectangle.         */
      /* mp1 - pointer to start record                               */
      /* mp2 - data structure containing the rectangle coordinates   */
      /*       to query and search control flags                     */
      /***************************************************************/
      preccn = CnrQueryRecordFromRect (hwnd, wParam, lParam );          /*DAB3*/
      if ((preccn) && (preccn != ((LPRECORDCOREN)ERRORFLAG)))
      {
         return ((long)preccn->preccX);
      }
      return ((long)preccn);


   case CM_QUERYRECORDRECT:
      /***************************************************************/
      /* CnrQueryRecordRect is in cnrgen.c. This message returns the */
      /* rectangle of a specified record.                            */
      /* mp1 - pointer to rectangle into which the rectangular coords*/
      /*       are placed.                                           */
      /* mp2 - data structure containing the specified record and    */
      /*       search flags                                          */
      /***************************************************************/
      return((long)CnrQueryRecordRect(hwnd, wParam, lParam ));          /*DAB3*/


   case CM_QUERYVIEWPORTRECT:
      /***************************************************************/
      /* CnrQueryViewPortRect is in cnrgen.c.  This message is used  */
      /* to return a rectangle containing the coordinates of the     */
      /* visible portion of the container's data area, in virtual    */
      /* coordinates relative to the origin of the container.        */
      /* mp1 - pointer to RECT structure into which to write the     */
      /*       coordinates                                           */
      /* mp2 - coordinate space indicator                            */
      /*     - window indicator                                      */
      /***************************************************************/
      return ((long)CnrQueryViewportRect(hwnd, wParam, lParam ));       /*DAB3*/

   case CM_REMOVEDETAILFIELDINFO:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      /****************************************************************/
      /* CnrRemoveDetailFieldInfo is contained in cnrdetv.c.  mp1 and */
      /* mp2 are passed as parameters and contain: mp1 - pointer to   */
      /* an array of pointers to FieldInfo structures which are to be */
      /* removed.  mp2 - The number of FieldInfo structures to be     */
      /* removed, and a BOOL indicating if they are to be freed after */
      /* removal.                                                     */
      /****************************************************************/
      return ((long)CnrRemoveDetailFieldInfo (hwnd, wParam, lParam ));  /*DAB3*/

   case CM_REMOVERECORD:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      /***************************************************************/
      /* CnrRemoveRecord is in cnrgen.c.  This message removes one,  */
      /* multiple, or all the records in the container.  If the      */
      /* flRemoveFree flag is TRUE, memory associated with the       */
      /* records is freed.                                           */
      /* mp1 - pointer to an array of RECORDCORE structures which    */
      /*       are to be removed. If 0, all are removed.             */
      /* mp2 - data structure containing the number of records to    */
      /*       be freed and a flag indicating if memory is freed.    */
      /***************************************************************/
      return((long)CnrRemoveRecord(hwnd, wParam, lParam ));             /*DAB3*/

   case CM_SCROLLWINDOW:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      /***************************************************************/
      /* CnrScrollWindow is in cnrgen.c.  This message scrolls       */
      /* the window in the given direction(mp1: CSW_VERTICAL,        */
      /* CSW_HORIZONTAL) and by the given distance(mp2:sScrollInc).  */
      /* mp1 - direction in which to scroll the container window.    */
      /*       (CSW_VERTICAL, CSW_HORIZONTAL)                        */
      /* mp2 - distance to scroll the window (in pixels)             */
      /***************************************************************/
      return ((long)CnrScrollWindow(hwnd, wParam, lParam));

   case CM_SETCNRCOLORS:
      /***************************************************************/
      /* This message sets the colors for the container control.     */
      /*   wParam - set color attribute                              */
      /*   lParam - colorref used to set color                       */
      /*                                                             */
      /* Note: This message simulates the presentation parameters    */
      /*       support that is available in PM.                      */
      /***************************************************************/
      return ((long)CnrRefreshColors( hwnd, pccinfon, LOWORD(wParam),   /*DAB1*/
                                      lParam));

   case CM_QUERYCNRCOLORS:
      /***************************************************************/
      /* This message queryies the colors for the container control. */
      /*   wParam - set color attribute                              */
      /*   lParam - colorref used to set color                       */
      /*                                                             */
      /* Note: This message simulates the presentation parameters    */
      /*       support that is available in PM.                      */
      /***************************************************************/
      return ((long)CnrQueryColors( hwnd, pccinfon, LOWORD(wParam)));   /*EVB1*/

   case CM_SETCNRINFO:

      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }
      /***************************************************************/
      /* CnrSetCnrInfo is in cnrgen.c.    This message sets the      */
      /* data for the container control.                             */
      /* mp1 - pointer to the CNRINFO from which to set the data     */
      /* mp2 - flags indicating which items are to be set            */
      /***************************************************************/
      return ((long)CnrSetCnrInfo(hwnd, wParam, lParam));               /*DAB3*/


   case CM_SETRECORDEMPHASIS:
      /***************************************************************/
      /* CnrSetRecordEmphasis is in cnrgen.c.  This message sets the */
      /* the emphasis attributes of the specified record.            */
      /* mp1 - pointer to the specified record.                      */
      /* mp2 - data structure containing a change emphasis attribute */
      /*       flag and emphasis attributes of the record.           */
      /***************************************************************/
      return ((long)CnrSetRecordEmphasis(hwnd, wParam, lParam ));       /*DAB3*/


  case CM_SORTRECORD:
    if (pccinfon->ulFlagSet & FL_EDITMODE)
    {
      CnrCloseMLE(hwnd);
    }
    /*****************************************************************/
    /* CnrSort                   This message is used in             */
    /* sorting records in the container.                             */
    /* mp1 - pointer to function that compares two records.          */
    /*****************************************************************/
    return ((long)CnrSort(hwnd, wParam, lParam, TRUE));                 /*DAB3*/

  case CM_SETREALLOCRESULT:                                             /*DAB5*/
    /*****************************************************************/
    /* This message is provided for direct editing support within a  */
    /* Windows Dialog since the dialog does not preserve the value   */
    /* returned on the WM_COMMAND message (already used by dialogs)  */
    /*   wParam - Return value (TRUE/FALSE)                          */
    /*   lParam - reserved                                           */
    /*****************************************************************/
    pccinfon->bRPZinDlgRet = (BOOL)LOWORD(wParam);                      /*DAB5*/
    return ((long)TRUE);                                                /*DAB5*/

/*====================================================================*/
/*                        General window messages                     */
/*====================================================================*/

    /******************************************************************/
    /* If mouse button 1 is double clicked over the container (or the */
    /*  mouse open action is received - find out over which record    */
    /*  it was depressed                                              */
    /*   wParam: virtual key down - Not used                          */
    /*   lParam: xmouse - pointing device x coordinate                */
    /*           ymouse - pointing device y coordinate                */
    /*   reply: none                                                  */
    /******************************************************************/
   case WM_LBUTTONDBLCLK:
      /****************************************************************/
      /* Determine which record the mouse pointer is over             */
      /****************************************************************/
      if (preccn = CnrOverRecord(hwnd, LOWORD(lParam), HIWORD(lParam)))
      {
        COPYNDATATOX(preccn);
        nRecordEnter.pRecord = preccn->preccX;
      }
      else
      {
        nRecordEnter.pRecord = NULL;
      }

      nRecordEnter.hwndCnr = hwnd;
      nRecordEnter.fKey = FALSE;

      if ((pccinfo->flWindowAttr & CV_DETAIL) &&
          (!(pccinfon->ulFlagSet2 & FL2_BUTTONLEFT)) &&
          (!(pccinfon->ulFlagSet2 & FL2_BUTTONRIGHT)))
      {
         nRecordEnter.pRecord = NULL;
      }

      pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);

      /****************************************************************/
      /* Send a CN_ENTER notification to the owner                    */
      /*  mp1                                                         */
      /*     id (int)       - Container control ID                    */
      /*     CN_ENTER (int) - Notification code                       */
      /*  mp2                                                         */
      /*     pNotifyRecordEnter(PNOTIFYRECORDENTER)                   */
      /****************************************************************/
      NotifyOwner (hwnd, CN_ENTER, (LPVOID)&nRecordEnter);
      return (long)NULL;


    /******************************************************************/
    /*   wParam: virtual key down - Not used                          */
    /*   lParam: xmouse - pointing device x coordinate                */
    /*           ymouse - pointing device y coordinate                */
    /*   reply: none                                                  */
    /******************************************************************/
   case WM_LBUTTONDOWN:                    /* most of case changed */
      SetFocus( hwnd);
      /***************************************************************/
      /* If in edit mode, save the text  and close MLE               */
      /***************************************************************/
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        if (GetKeyState( VK_MENU) < 0)
        {
          pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);
          CnrCloseMLE(hwnd);
          return ((long)(TRUE));
        }
        else
        {
          if (!(CnrSaveTextCloseMLE(hwnd)))
          {
            pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);
            return ((long)NULL);
          }
          pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);
          return ((long)TRUE);
        } /* endif */
      }
      else if (GetKeyState(VK_MENU) < 0)
      {
        return (CnrStartDirectEdit (hwnd, msg, wParam, lParam));
      } /* endif */

      KeyState1 = GetKeyState ( VK_CONTROL);
      KeyState2 = GetKeyState ( VK_SHIFT);

      /****************************************************************/
      /* If the button 1 down is occuring over the split bar, then we */
      /* need to track it.                                            */
      /****************************************************************/
      if ((pccinfo->flWindowAttr & CV_DETAIL) &&
         (!(KeyState1 < 0)) && (!(KeyState2 < 0)) &&
         (!(pccinfon->ulFlagSet2 & FL2_BUTTONLEFT)) &&
         (!(pccinfon->ulFlagSet2 & FL2_BUTTONRIGHT)))
      {
         /*************************************************************/
         /* If Details View is split into 2 windows, and thus, has a  */
         /* a split bar, we have to track the guy.                    */
         /*************************************************************/
         POINT   ptlMouse;                                              /*DAB1*/
         ptlMouse.x = LOWORD(lParam);                                   /*DAB1*/
         ptlMouse.y = HIWORD(lParam);                                   /*DAB1*/
         if (!(pccinfon->ulFlagSet & FL_UNSPLIT) &&
             IsOverSplitbar (hwnd, ptlMouse ))                          /*DAB1*/
         {
           CnrTrackSplitbar (hwnd);
           return ((long)TRUE);
         }
      }
      else
      {
        if ( CnrProcessMouseButton1Down( hwnd, lParam ))
        {
          pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);
          return ((long)TRUE);
        }
      }

      pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);
      return (DefWindowProc(hwnd, msg, wParam, lParam));

    case WM_LBUTTONUP:
      pccinfon->ulFlagSet &= ~FL_SELECTING;

      if (CnrProcessMouseButton1Up( hwnd ))
        return ((long)TRUE);
      else
        return ( DefWindowProc(hwnd, msg, wParam, lParam));

    case WM_RBUTTONDOWN:
    case WM_MBUTTONDBLCLK:
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE(hwnd);
      }

      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
        POINT   ptlMouse;                                               /*DAB1*/
        ptlMouse.x = LOWORD(lParam);                                    /*DAB1*/
        ptlMouse.y = HIWORD(lParam);                                    /*DAB1*/

        KeyState1 = GetKeyState ( VK_CONTROL);
        KeyState2 = GetKeyState ( VK_SHIFT);
        KeyState3 = GetKeyState ( VK_MENU);

        /*************************************************************/
        /* If Details View is split into 2 windows, and thus, has a  */
        /* a split bar, and button 2 is occuring over the splitbar   */
        /* then we need to track it.                                 */
        /*************************************************************/
        if ((!(pccinfon->ulFlagSet & FL_UNSPLIT))       &&
            (!(KeyState1 < 0)) && (!(KeyState2 < 0))    &&
            (!(KeyState3 < 0))                          &&
            (!(pccinfon->ulFlagSet2 & FL2_BUTTONLEFT))  &&
            (!(pccinfon->ulFlagSet2 & FL2_BUTTONRIGHT)) &&
             IsOverSplitbar (hwnd, ptlMouse ))                          /*DAB1*/
        {
          CnrTrackSplitbar (hwnd);
          return ((long)TRUE);
        }
      }
//    else
//    {
//      /*---------------*/
//      /* drag the icon */
//      /*---------------*/
//      if (CnrDragIcon (hwnd, LOWORD (lParam), HIWORD (lParam)))       /*DAB6*/
//      {                                                               /*DAB6*/
//        pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);
//        return ((long)TRUE);
//      }                                                               /*DAB6*/
//    }
      pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);
      return (DefWindowProc(hwnd, msg, wParam, lParam));

    case WM_RBUTTONUP:
    case WM_MBUTTONUP:
      SetFocus( hwnd);

      /***********************************************************/
      /* Dragging ended.                                         */
      /***********************************************************/
      return (DefWindowProc(hwnd, msg, wParam, lParam));                /*DAB6*/


    /******************************************************************/
    /* If context menu is requested, send notification to owner       */
    /*   wParam:                                                      */
    /*   lParam: xmouse - pointing device x coordinate                */
    /*           ymouse - pointing device y coordinate                */
    /******************************************************************/
    case WM_CONTEXTMENU:

      /**************************************************************/
      /* Convert pointer position to container window coordinates   */
      /**************************************************************/
      ptrPos.x = LOWORD(lParam);                                        /*DAB7*/
      ptrPos.y = HIWORD(lParam);                                        /*DAB7*/
      ScreenToClient( hwnd, &ptrPos);                                   /*DAB7*/

      /**************************************************************/
      /* Check to see if mouse is over record.                      */
      /**************************************************************/
      if (!(pccinfon->ulFlagSet2 & FL2_NULLCONTEXT) &&                  /*DAB6*/
        (preccn = CnrOverRecord( hwnd, ptrPos.x, ptrPos.y )))           /*DAB7*/
      {                                                                 /*DAB6*/
        COPYNDATATOX(preccn);                                           /*DAB6*/
        nMenuInit.pRecord = preccn->preccX;                             /*DAB6*/
      }                                                                 /*DAB6*/
      else                                                              /*DAB6*/
      {                                                                 /*DAB6*/
        nMenuInit.pRecord = NULL;                                       /*DAB6*/
        pccinfon->ulFlagSet2 &= ~FL2_NULLCONTEXT;                       /*DAB6*/
      }                                                                 /*DAB6*/
      nMenuInit.hwndCnr = hwnd;                                         /*DAB6*/
      nMenuInit.x       = ptrPos.x;                                     /*DAB7*/
      nMenuInit.y       = ptrPos.y;                                     /*DAB7*/

      NotifyOwner( hwnd, CN_CONTEXTMENU, (LPVOID)&nMenuInit );          /*DAB6*/
      return (long)NULL;                                                /*DAB6*/

    /******************************************************************/
    /* If character keys are pressed, check container for action      */
    /*   mp1: usKeyCtl   - Keyboard control code                      */
    /*   mp2: usCharCode - Character code                             */
    /*        usVrtlKey  - Virtual key translation value of kbd event */
    /*   reply: TRUE - if keystroke processed                         */
    /*          FALSE - if keystroke ignored                          */
    /******************************************************************/
    case WM_CHAR:
    case WM_KEYDOWN:
    case WM_HELP:
      /****************************************************************/
      /* If we process the character, return TRUE.  If we don't       */
      /* process it, call DefWindowProc to pass it on to the app.     */
      /****************************************************************/
      if (!(pccinfon->ulFlagSet & FL_CAPTURE))
      {
        if (CnrProcessChar (hwnd, msg, wParam, lParam))
        {
           return ((long)TRUE);
        }
        else
        {
          if ((GetKeyState ( VK_CONTROL) < 0) &&
              (GetKeyState ( VK_MENU)    < 0) &&
              (GetKeyState ( VK_SHIFT)   < 0) &&
              ((wParam == 'O') || (wParam == 'o')))
          {
            CnrDisplayData (hwnd);
            return ((long)TRUE);
          }
          return (DefWindowProc (hwnd, msg, wParam, lParam));
        }
      }
      return ((long)FALSE);

    /******************************************************************/
    /* If a mouse move message comes in, process it                   */
    /*   wParam: virtual key down - Not used                          */
    /*   lParam: xmouse - pointing device x coordinate                */
    /*           ymouse - pointing device y coordinate                */
    /*   reply: none                                                  */
    /******************************************************************/
    case WM_MOUSEMOVE:

      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
        /**************************************************************/
        /* When the Mouse is moved, and we are in Details View, this  */
        /* means the user is dragging the Splitbar.  We then change   */
        /* the Mouse Pointer to a special one in order to amaze the   */
        /* user.  (This has a Gee-Whiz factor of 7)                   */
        /**************************************************************/
        GetCursorPos (&ptrPos);

        ScreenToClient( hwnd, &ptrPos);
        hwndWindow = WINDOWFROMPOINT (hwnd, ptrPos, TRUE);

        /****************************************************************/
        /* If the mouse is over the splitbar draw the splitbar pointer. */
        /****************************************************************/
        if (!(pccinfon->ulFlagSet & FL_SELECTING) &&
            (hwndWindow == hwnd) &&
            (IsWindowEnabled (hwnd)))
        {
          SetCursor ( pccinfon->hptrSplitPtr);
          return ((long)TRUE);
        }
      }
        if ( CnrProcessMouseMove( hwnd, lParam ))
          return ((long)TRUE);
      return (DefWindowProc (hwnd, msg, wParam, lParam));

    case WM_CREATE:
      return (CnrCreate (hwnd));

    case WM_DESTROY:
      return (CnrDestroy (hwnd));

    case WM_ERASEBKGND:
      return(DefWindowProc(hwnd, msg, wParam, lParam));

    /******************************************************************/
    /* Note: Fall through from Size into Paint is intentional         */
    /******************************************************************/
    case WM_SIZE:

      /***************************************************************/
      /* If in edit mode, save the text  and close MLE               */
      /***************************************************************/
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        if (!(CnrSaveTextCloseMLE(hwnd)))
        {
           return ((long)NULL);
        }
      }

    case WM_PAINT:
      if (pccinfo->flWindowAttr & CV_TREE)
      {
        return ((long)CnrTreeVCtlProc( hwnd, msg, wParam, lParam));
      }
      else if (pccinfo->flWindowAttr & (CV_TEXT | CV_NAME))
      {
        return ((long)CnrNameTextVCtlProc( hwnd, msg, wParam, lParam));
      }
      else if (pccinfo->flWindowAttr & CV_DETAIL)
      {
        return ((long)CnrDetailsVCtlProc( hwnd, msg, wParam, lParam));
      }
      else
        return ((long)CnrIconVCtlProc( hwnd, msg, wParam, lParam));

    case WM_SETFOCUS:
    case WM_KILLFOCUS:

      /***************************************************************/
      /* Send CN_SETFOCUS or CN_KILLFOCUS to the application.        */
      /*                                                             */
      /***************************************************************/
      return((long)CnrProcessSetFocus( hwnd, (msg == WM_SETFOCUS) ?
                                       TRUE : FALSE ));

    case WM_VSCROLL:
    case WM_HSCROLL:

      /***************************************************************/
      /* If in edit mode, save the text  and close MLE               */
      /***************************************************************/
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrCloseMLE (hwnd);
      } /* endif */

      /****************************************************************/
      /* Process any WM_PAINT messages in the queue before we scroll  */
      /* the window.                                                  */
      /****************************************************************/
      while (PeekMessage (&qmsg, NULL,            // SHOULD NOT WORK JEH
                          WM_PAINT, WM_PAINT, PM_REMOVE))
      {
        TranslateMessage (&qmsg);
        DispatchMessage ( &qmsg);
      }

      if (pccinfo->flWindowAttr & CV_TREE)
      {
        return ((long)CnrTreeVCtlProc( hwnd, msg, wParam, lParam));
      }
      else if (pccinfo->flWindowAttr & (CV_TEXT | CV_NAME))
      {
        return ((long)CnrNameTextVCtlProc( hwnd, msg, wParam, lParam));
      }
      else if (pccinfo->flWindowAttr & CV_DETAIL)
      {
        return ((long)CnrDetailsVCtlProc( hwnd, msg, wParam, lParam));
      }
      else
        return ((long)CnrIconVCtlProc( hwnd, msg, wParam, lParam));

    case WM_TIMER:

      /***************************************************************/
      /* Process WM_TIMER message by calling CnrProcessTimer.        */
      /* (in cnrgen.c)                                               */
      /***************************************************************/
      return (CnrProcessTimer(hwnd, msg, wParam, lParam));

    /******************************************************************/
    /* If a WM_SETFONT message comes in, set the hVSFont field of     */
    /* the value set's internal data.                                 */
    /*   wParam: font handle - handle of the new font, if NULL then   */
    /*                      system font will be used                  */
    /*   lParam: if TRUE, redraw container immediately, FALSE, don't  */
    /******************************************************************/
    case WM_SETFONT:

      pccinfon->hCnrFont = (HFONT)wParam;
      ResetWindowForFontChange (hwnd);
      if (lParam)
        InvalidateChildren (hwnd, TRUE, FALSE);
      break;

    /******************************************************************/
    /* If a WM_GETFONT message comes in, return the hCnrFont field    */
    /* of the container's internal data.                              */
    /******************************************************************/
    case WM_GETFONT:

      return ((long)pccinfon->hCnrFont);
      break;

    /******************************************************************/
    /* If a WM_GETDLGCODE message comes in, the container is in a     */
    /* dialog.  Tell the dialog which keys we want to process.        */
    /******************************************************************/
    case WM_GETDLGCODE:

      return ((long)DLGC_WANTARROWS | DLGC_WANTCHARS);
      break;

    /******************************************************************/
    /* Default case                                                   */
    /******************************************************************/
    default:
      return(DefWindowProc(hwnd, msg, wParam, lParam));
  }

  return (long)0;                                                       /*DAB1*/
}


/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  CnrEdgeProc                                        */
/*                                                                    */
/* USAGES : External                                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:  Container Control Edge  Window Control Proc     */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:  This procedure will handle all messages   */
/*   for the edge  window   of the container.  Any messages that      */
/*   require special handling for the edge  window   will be handled  */
/*   here                                                             */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:  HANDLE hwndCnr - window handle for the container.          */
/*         WORD msg - message.                                        */
/*         long mp1 - message parameter 1.                            */
/*         long mp2 - message parameter 2.                            */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/*                                                                    */
/**********************************************************************/
LRESULT CALLBACK CnrEdgeProc( HWND hwnd, UINT msg, WPARAM wParam,       /*DAB1*/
                              LPARAM lParam )                           /*DAB1*/
{
  HANDLE    hwndCnr;
  LPCNRINFON pccinfon;

  hwndCnr = PARENTOF (hwnd);
  pccinfon = (LPCNRINFON)GetWindowLong (hwndCnr, QWL_CONTAINER);

  switch (msg)
  {
    case WM_LBUTTONDOWN:
    case WM_RBUTTONDOWN:
    case WM_MBUTTONDOWN:
    case WM_MBUTTONDBLCLK:
    case WM_RBUTTONDBLCLK:
      SetFocus( hwndCnr);

      /***************************************************************/
      /* If in edit mode, save the text  and close MLE               */
      /***************************************************************/
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
        CnrSaveTextCloseMLE(hwndCnr);
      } /* endif */

      return 0;

    case WM_PAINT:
      /***************************************************************/
      /* Paint the edge window. (CnrPaintEdgeWin in cnrcfunc.c)      */
      /***************************************************************/
      CnrPaintEdgeWin(hwnd);
      return 0;

    case WM_SIZE:
      PMInvalidateRect(hwnd, NULL, TRUE);
      return 0;

    default:
      return(DefWindowProc(hwnd, msg, wParam, lParam));
  }
  return ((long)TRUE);
}

/* ********************************************************************/
/*                                                                    */
/*  Function Name:     CnrButtonState                                 */
/*                                                                    */
/*  Descriptive Name:  Container button processing.                   */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  Notes:                                                            */
/*     Forward Declaration:  long CnrButtonState(                     */
/*                               HANDLE       hwnd,                   */
/*                               int      xPos,                       */
/*                               int      yPos)                       */
/*                               )                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*  Input:   hwnd    - container control handle                       */
/*           xPos    - x position passed in on message                */
/*           yPos    - y position passed in on message                */
/*                                                                    */
/*  Output:  TRUE  - Button down over record                          */
/*           FALSE - Button down was not over record, pass            */
/*                   WM_BUTTONXDOWN message to DefWindowProc          */
/*                                                                    */
/*  Exit-Normal:   TRUE                                               */
/*                                                                    */
/*  Exit-Error:    FALSE                                              */
/*                                                                    */
/*  Side Effects:  None                                               */
/*                                                                    */
/**********************************************************************/
long FAR CnrButtonState(HANDLE hwnd, HDC hps, int xPos, int yPos,
  LPRECORDCOREN pMouseRecord)
{
   LPRECORDCOREN pRecord;               /* Record button clicked over */
   LPCNRINFON    pccinfon;              /* Internal control data      */
   LPCNRINFO     pccinfo;
   BOOL          found = FALSE;         /* Record found               */
   long          windowStyle;           /* Determine selections style */
   RECT          rctlVScroll;           /* Rctl for vertical scroll bar*/
   RECT          rctlHScroll;           /* Rctl for horiz scroll bar   */
   RECT          rctlLTitle;            /* Rctl for title              */
   RECT          windowRect;            /* Rctl for window rectangle   */
   POINT         mousePt;               /* x and y positions           */
   DWORD         flRecordAttrOld;       /* Record attrib before change */
   BOOL          fDeselect = FALSE;
   DWORD         flCursorAttrOld = FALSE;

   pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
   pccinfo  = PCCINFOXFROMN(pccinfon);
   windowStyle = GetWindowLong (hwnd, GWL_STYLE);

   if (!pMouseRecord)
   {
     pRecord = CnrOverRecord(hwnd, xPos, yPos);
   }
   else
   {
      pRecord = pMouseRecord;
   }

   /*******************************************************************/
   /* If the mouse is clicked over a valid item, process the button   */
   /* state, else default the message and return FALSE.               */
   /*******************************************************************/
   if (pRecord)
   {
     /*****************************************************************/
     /* Button was clicked over a container record.                   */
     /*****************************************************************/
     found = TRUE;

#if 0
     if (windowStyle & CCS_MULTIPLESEL)
     {
       /***************************************************************/
       /* If multiple selection, toggle the state of the record.      */
       /***************************************************************/
       flRecordAttrOld =  pRecord->flRecordAttr;
       SetEmphasisBits (hwnd, NULL, pRecord, CRA_SELECTED, SEB_TOGGLE);
     }
     else if (pRecord->flRecordAttr & CRA_SELECTED)
     {
       /***************************************************************/
       /* If Extended selection and ctrl key is pressed, don't        */
       /* deselect, toggle the record.                                */
       /***************************************************************/
       if ((windowStyle & CCS_EXTENDSEL) &&
          (GetKeyState( VK_CONTROL) < 0))
       {
         flRecordAttrOld =  pRecord->flRecordAttr;
         SetEmphasisBits (hwnd, NULL, pRecord, CRA_SELECTED, SEB_CLEAR);
       }
       else
       {
          if (windowStyle & CCS_EXTENDSEL)
          {
            if (!(CnrFindAndDeemphasizeRecords(hwnd, hps, pRecord,
                                    CRA_SELECTED | CRA_CURSORED)))
            {
               return ((long)NULL);
            }
            else
            {
               fDeselect = TRUE;
            }
          }
       }
     }
     else
     {
       /***************************************************************/
       /* Find and deselect the selected record. If the ctrl          */
       /* key is pressed, don't desselect all in extended sel.        */
       /***************************************************************/
       if ((!(windowStyle & (CCS_MULTIPLESEL | CCS_EXTENDSEL))) ||
           ((windowStyle & CCS_EXTENDSEL) &&
            (GetKeyState( VK_CONTROL) >= 0)))
       {
         if (!(CnrFindAndDeemphasizeRecords(hwnd, hps, pRecord,
                                      CRA_SELECTED | CRA_CURSORED)))
         {
            return ((long)NULL);
         }
         else
         {
            fDeselect = TRUE;
         }
       }
       flRecordAttrOld =  pRecord->flRecordAttr;
       SetEmphasisBits (hwnd, NULL, pRecord, CRA_SELECTED, SEB_SET);
     }

     pccinfon->preccSelTarget = pRecord;

     /*****************************************************************/
     /* Reset the cursor emphasis record pointer and invalidate the   */
     /* previous and new cursored record.                             */
     /*****************************************************************/
     if (!(CnrChangeCursor( hwnd, pRecord, hps, fDeselect )))
     {
        return (FALSE);
     }

     pccinfon->preccAnchor = pRecord;
     pccinfon->preccPrevEndOfRange = pRecord;

     if (pRecord->flRecordAttr & CRA_SELECTED)
     {
        pccinfon->fAnchorState = TRUE;
     }
     else
     {
        pccinfon->fAnchorState = FALSE;
     } /* endif */

     if (!(CnrDrawEmphChange(hwnd, hps, pRecord, flRecordAttrOld)))
     {
        return (FALSE);
     }
#endif

     flRecordAttrOld =  pRecord->flRecordAttr;

     if ((windowStyle & CCS_MULTIPLESEL) ||
         ((windowStyle & CCS_EXTENDSEL) &&
          (GetKeyState(VK_CONTROL) < 0)))
     {
       /***************************************************************/
       /* If multiple selection, or extended selection and ctl key    */
       /* is pressed, toggle the state of the record and move the     */
       /* cursor.                                                     */
       /***************************************************************/
       SetEmphasisBits (hwnd, NULL, pRecord, CRA_SELECTED, SEB_TOGGLE);
       SetEmphasisBits (hwnd, NULL, pRecord, CRA_CURSORED, SEB_SET);
       if (pccinfon->preccCursor && (pccinfon->preccCursor != pRecord))
       {
         SetEmphasisBits (hwnd, hps, pccinfon->preccCursor,
                          CRA_CURSORED, SEB_CLEAR);
       }
     }
     else
     {
       /***************************************************************/
       /* Find and deselect the selected record.                      */
       /***************************************************************/
       if (windowStyle & CCS_EXTENDSEL)
       {
         if (!(CnrFindAndDeemphasizeRecords(hwnd, hps, pRecord,
                                      CRA_SELECTED | CRA_CURSORED)))
         {
            return ((long)NULL);
         }
       }
       else
       {
         if (pccinfon->preccCursor &&
             (pccinfon->preccCursor != pRecord))
         {
           SetEmphasisBits (hwnd, hps, pccinfon->preccCursor,
                            CRA_CURSORED | CRA_SELECTED, SEB_CLEAR);
         }
       }
       SetEmphasisBits (hwnd, NULL, pRecord,
                        CRA_SELECTED | CRA_CURSORED, SEB_SET);
     }

     pccinfon->preccSelTarget = pRecord;
     pccinfon->preccAnchor = pRecord;
     pccinfon->preccPrevEndOfRange = pRecord;

     if (pRecord->flRecordAttr & CRA_SELECTED)
     {
        pccinfon->fAnchorState = TRUE;
     }
     else
     {
        pccinfon->fAnchorState = FALSE;
     } /* endif */

     pccinfon->preccCursor = pRecord;

     if (!(CnrDrawEmphChange(hwnd, hps, pRecord, flRecordAttrOld)))
     {
        return (FALSE);
     }

   }
   else
   {
     /*****************************************************************/
     /* If the mouse button wasn't clicked over a record and if       */
     /* multiple or extended selection and icon view, deselect all    */
     /* selected records.                                             */
     /*****************************************************************/
      if ((pccinfo->flWindowAttr & CV_ICON) &&
          (windowStyle & (CCS_MULTIPLESEL | CCS_EXTENDSEL)))
      {
        /**************************************************************/
        /* Set flag indicating that the button message shouldn't be   */
        /* passed to the default proc.                                */
        /**************************************************************/
        found = TRUE;

        /**************************************************************/
        /* Find the horizontal and vertical scroll bar rctls, the     */
        /* rctl for the title, and the size of the window             */
        /**************************************************************/
        CnrQueryScrollBarRect(hwnd, &rctlVScroll, &rctlHScroll);
        CnrQueryTitleRect(hwnd, &rctlLTitle, NULL);
        PMGetClientRect(hwnd, &windowRect);

        /**************************************************************/
        /* Calculate the available space for the user to click in     */
        /**************************************************************/
        windowRect.bottom += rctlHScroll.bottom - rctlHScroll.top;
        windowRect.right -= rctlVScroll. right - rctlVScroll.left;

        windowRect.top +=  rctlLTitle.bottom;
        mousePt.x = xPos;
        mousePt.y = yPos;

        /**************************************************************/
        /* If the mouse was clicked in the available space, find and  */
        /* deselect all the records.                                  */
        /**************************************************************/
        if (PMPtInRect( &windowRect, mousePt))
        {
          LPRECORDCOREN pRec;
//        LPVOID        pSatPtr;
          RECT          rctlInvalid;
          RECT          rctlHScroll;
          RECT          rctlTitle;
          POINT         slIcon;

          if ( (GetKeyState( VK_CONTROL) >= 0) &&
               (windowStyle & CCS_EXTENDSEL) )
           {
             if (!(CnrFindAndDeemphasizeRecords (hwnd, hps,
                                                 NULL, CRA_SELECTED)))
             {
                return ((long)NULL);
             }
           }

          /*****************************************************************/
          /* If this is the first mouse move message of this marquee sel.  */
          /* then create linked list in reverse z order of the viewable    */
          /* items only to improve dynamic performance of marquee selection*/
          /*****************************************************************/
          if (pccinfon->fFirstMouseMove)
          {
            LPMARQUEEREC pmrMarquee;
            LPMARQUEEREC pmrPrevMarquee;

            CnrQuerySizeRect(hwnd, &slIcon, &rctlTitle, &rctlInvalid, NULL,
                             &rctlHScroll) ;
            rctlInvalid.bottom += rctlTitle.bottom;
            rctlInvalid.top    += rctlTitle.bottom;

            pccinfon->fFirstMouseMove = FALSE;
            pRec = pccinfon->preccZTail;

            while (pRec && !(ISRECORDVISIBLE(pRec)))
            {
              pRec = pRec->preccPrevZ;
            }
            pccinfon->pmrFirstMarquee = NULL;
            pccinfon->pmrLastMarquee  = NULL;
//          pSatPtr = (LPVOID)GetWindowLong (hwnd, QWL_STORAGEPTR);

            while (pRec)
            {
              if (IsInIconViewport(pRec,
                                   &(pccinfo->ptlOrigin),
                                   &rctlInvalid, &slIcon))
              {
//              if (!(pmrMarquee = (LPMARQUEEREC)StmAllocateStorage(pSatPtr,
                if (!(pmrMarquee = (LPMARQUEEREC)GlobalAlloc( GPTR,     /*DAB1*/
                                          (DWORD)sizeof(MARQUEEREC))))
                {
                  SETERROR(PMERR_INSUFFICIENT_MEMORY);
                  return ((long)NULL);
                }

                pmrMarquee->pRecord = pRec;
                if (pRec->flRecordAttr & CRA_SELECTED)
                {
                  pmrMarquee->fSelected = TRUE;
                }
                else
                {
                  pmrMarquee->fSelected = FALSE;
                }
                pmrMarquee->pmrNextItem = NULL;
                if (!pccinfon->pmrFirstMarquee)
                {
                  pmrMarquee->pmrPrevItem   = NULL;
                  pccinfon->pmrFirstMarquee = pmrMarquee;
                }
                else
                {
                  pmrMarquee->pmrPrevItem     = pmrPrevMarquee;
                  pmrPrevMarquee->pmrNextItem = pmrMarquee;
                }
                pmrPrevMarquee = pmrMarquee;
              }
              pRec = pRec->preccPrevZ;

              while (pRec && !(ISRECORDVISIBLE(pRec)))
              {
                pRec = pRec->preccPrevZ;
              }
            }
            pccinfon->pmrLastMarquee  = pmrMarquee;
          }

           /***********************************************************/
           /* Set the beginning point for the marquee box and start   */
           /* to draw the box.                                        */
           /***********************************************************/
           pccinfon->ptlStart.x = pccinfon->ptlEnd.x = xPos;
           pccinfon->ptlStart.y = pccinfon->ptlEnd.y = yPos;

           /***********************************************************/
           /* Capture the mouse for marquee selection.                */
           /***********************************************************/
           pccinfon->ulFlagSet |= FL_CAPTURE;

           CnrDrawBoxOutline(hwnd, hps, &pccinfon->ptlStart,
                             &pccinfon->ptlEnd);
        }
      }
      else
      {
        /**************************************************************/
        /* If extended selection and icon view, deselect all, per CUA */
        /* Added white space to non-icon views also, so we should     */
        /* should deselect in all non tree views.                     */
        /**************************************************************/
        if (!(pccinfo->flWindowAttr & CV_TREE) &&
            (windowStyle &  CCS_EXTENDSEL))
        {
          if (!(CnrFindAndDeemphasizeRecords (hwnd, hps,
                                              NULL, CRA_SELECTED)))
          {
             return ((long)NULL);
          }
        }
      }
   }
   return((long)found);
}

/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrCreate                                      */
/*                                                                    */
/*  Descriptive Name:  Container creation processing.                 */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  Notes:                                                            */
/*     Forward Declaration:  long CnrCreate(                          */
/*                               HANDLE       hwnd,                   */
/*                               )                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*  Input:   hwnd    - container control handle                       */
/*           hwndCnrAssoc - handle of container to associate this     */
/*                     container with                                 */
/*                                                                    */
/*  Output:  TRUE  - An error occurred, terminate window creation     */
/*           FALSE - No error, continue creation                      */
/*                                                                    */
/*                                                                    */
/*  Exit-Normal:   FALSE                                              */
/*                                                                    */
/*  Exit-Error:    TRUE                                               */
/*                                                                    */
/*  Side Effects:  None                                               */
/*                                                                    */
/**********************************************************************/
long FAR CnrCreate (HANDLE hwnd)
{
  LPCNRINFON pccinfon;
  LPCNRINFO  pccinfo;
//LPVOID     pSatPtr;

  /*******************************************************************/
  /* Create child windows                                            */
  /*******************************************************************/
  if (!CreateWindow(WC_EDGE,             /* Edge window           */
                    NULL,
                    WS_VISIBLE | WS_CLIPSIBLINGS | WS_CHILD,
                    0,0,0,0,
                    hwnd,
                    (HMENU)CID_BLANKBOX,                                /*DAB1*/
                    vhCNRInstance,
                    NULL) ||
      !CreateWindow("SCROLLBAR",         /* horizontal scroll bar */
                    NULL,
                    SBS_HORZ | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CHILD,
                    0,0,0,0,
                    hwnd,
                    (HMENU)CID_HSCROLL,                                 /*DAB1*/
                    vhCNRInstance,
                    NULL) ||
      !CreateWindow(WC_CNRTITLE,         /* list title            */
                    NULL,
                    WS_VISIBLE | WS_CLIPSIBLINGS | WS_CHILD,
                    0,0,0,0,
                    hwnd,
                    (HMENU)CID_CNRTITLEWND,                             /*DAB1*/
                    vhCNRInstance,
                    NULL) ||
      !CreateWindow("SCROLLBAR",         /* vertical scroll bar   */
                    NULL,
                    SBS_VERT | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CHILD,
                    0,0,0,0,
                    hwnd,
                    (HMENU)CID_VSCROLL,                                 /*DAB1*/
                    vhCNRInstance,
                    NULL))
  {
    /********************************************************/
    /* if we can't create all of the children, abort window */
    /* creation (the children we did create successfully,   */
    /* if any, will be destroyed by the system              */
    /********************************************************/
    return (-1L);                                                       /*DAB1*/
  }

  /******************************************************************/
  /* Call the Storage Manager function to initialize the storage    */
  /* space that we'll be using.  All memory will be allocated and   */
  /* deallocated through the use of the common Storage Manager.     */
  /******************************************************************/
//if (!(pSatPtr = StmInitStorageSpace (0L, 0L)))                        /*DAB1*/
//{
//  SETERROR (PMERR_INSUFFICIENT_MEMORY);
//  return (-1);
//}

  /******************************************************************/
  /* Call Storage Manager to allocate control block for internal    */
  /* and external data and allocate the DRAGNOTIFY Structure.       */
  /******************************************************************/
//if (!(pccinfon = StmAllocateStorage (pSatPtr,
  if (!(pccinfon = (LPCNRINFON)GlobalAlloc( GPTR,                       /*DAB1*/
                      (DWORD)(sizeof(CNRINFO) + sizeof(CNRINFON)))))
  {
     SETERROR (PMERR_INSUFFICIENT_MEMORY);
     return (-1L);                                                      /*DAB1*/
  }

//if (!(pccinfon->pRecordInsertN = StmAllocateStorage (pSatPtr,
  if (!(pccinfon->pRecordInsertN = (LPRECORDINSERTN)GlobalAlloc( GPTR,  /*DAB1*/
                                   (DWORD)(sizeof(RECORDINSERTN)))))
  {
     SETERROR (PMERR_INSUFFICIENT_MEMORY);
     return (-1L);                                                      /*DAB1*/
  }

  /******************************************************************/
  /* Get the handle for the splitbar pointer                        */
  /******************************************************************/
#ifdef IC_WU
  {                                                             /*RKK1*/
    // With Wind/U need to do a LoadLibrary() before the LoadCursor()
    HANDLE hLib = LoadLibrary( ICL_CONTAINER_DLL );
    pccinfon->hptrSplitPtr = LoadCursor( hLib,
                                         MAKEINTRESOURCE(SPLITBARPTR) );
    FreeLibrary( hLib );
  }                                                             /*RKK1*/
#else
  pccinfon->hptrSplitPtr = LoadCursor( vhCNRInstance,                   /*DAB8*/
                                       MAKEINTRESOURCE(SPLITBARPTR));
#endif
  /********************************************************************/
  /* Save the storage space pointer and internal control block in     */
  /*  this containers window words for access                         */
  /********************************************************************/
//SetWindowLong (hwnd, QWL_STORAGEPTR, (DWORD)pSatPtr);
  SetWindowLong (hwnd, QWL_CONTAINER, (DWORD)pccinfon);
  pccinfo = PCCINFOXFROMN(pccinfon);

#if 0
  /*******************************************************************/
  /* Create MLE for direct edit only if the container is not Read    */
  /* Only.                                                           */
  /*******************************************************************/
  if (!(GetWindowLong (hwnd, GWL_STYLE) & CCS_READONLY))
  {
     hwndMLE = CreateWindow((LPSTR)"Edit",
                             (LPSTR)NULL,
                             (WS_BORDER | WS_VISIBLE | CNR_REQUIREDSTYLES |
                              ES_MULTILINE | ES_AUTOHSCROLL | ES_AUTOVSCROLL |
                              ES_LEFT),
                             0, 0, 0, 0,
                             hwnd,
                             (HMENU)CID_MLE,
                             vhCNRInstance,
                             (LPSTR)NULL);
  }

  /********************************************************************/
  /* Subclass the MLE and save the procedure handle for future use    */
  /********************************************************************/
  pccinfon->pfnwpMLE = SetWindowLong(hwndMLE, GWL_WNDPROC, (DWORD)MLESubProc);
#endif

  /********************************************************************/
  /* Set up the default data for the container.                       */
  /********************************************************************/
  pccinfo->cb = (DWORD)sizeof(CNRINFO);
  pccinfo->flWindowAttr  = CV_ICON | CA_DRAWICON;
  pccinfo->cyLineSpacing = MINCY_BETWEENITEMS;

  /*******************************************************************/
  /* Initialize the flags                                            */
  /*******************************************************************/
  pccinfon->ulFlagSet2 = ( FL2_VDYNAMICSCROLL | FL2_HDYNAMICSCROLL |
                            FL2_MINIMIZED | FL2_FOCUSLEFT );

  /*******************************************************************/
  /* Set internal flag if autoposition style bit is set              */
  /*******************************************************************/
  if (GetWindowLong( hwnd, GWL_STYLE ) & CCS_AUTOPOSITION)
    pccinfon->ulFlagSet |= FL_NEEDARRANGE;

  /********************************************************************/
  /* Initialize the information for Details View.                     */
  /********************************************************************/
  pccinfon->sVscrollFactor = 1;
  pccinfon->sHscrollFactor = 1;
  pccinfon->ulFlagSet |= FL_UNSPLIT;
  pccinfo->xVertSplitbar = -1L;                                         /*DAB1*/
  pccinfo->cxTreeIndent = -1L;                                          /*DAB1*/
  pccinfo->cxTreeLine = 1;

  /********************************************************************/
  /* Initialize default color values ...                              */
  /********************************************************************/
  pccinfon->ulColorPPSupport[CMA_FOREGROUNDCOLOR] =
                                           GetSysColor (COLOR_WINDOWTEXT);
  pccinfon->ulColorPPSupport[CMA_BACKGROUNDCOLOR] =
                                           GetSysColor (COLOR_WINDOW);
  pccinfon->ulColorPPSupport[CMA_SELECTFOREGROUNDCOLOR] =
                                           GetSysColor (COLOR_HIGHLIGHTTEXT);
  pccinfon->ulColorPPSupport[CMA_SELECTBACKGROUNDCOLOR] =
                                           GetSysColor (COLOR_HIGHLIGHT);
  pccinfon->ulColorPPSupport[CMA_SEPARATORCOLOR] =
                                           GetSysColor (COLOR_WINDOWFRAME);

  /********************************************************************/
  /* Initialize default font value (System)                           */
  /********************************************************************/
  pccinfon->hCnrFont = NULL;

  /********************************************************************/
  /* Get the default fontmetrics information for painting             */
  /********************************************************************/
  CnrQueryFontMetrics (hwnd, hwnd, FALSE, NULL, NULL);

  pccinfon->fFirstMouseMove = TRUE;
  pccinfon->preccPrevEndOfRange = NULL;

  /********************************************************************/
  /* Get the information from OS2.INI for NLS stuff for Date and Time */
  /* formatting.                                                      */
  /********************************************************************/
  CnrInitNLSInfo (hwnd);

  /********************************************************************/
  /* Increment use count                                              */
  /********************************************************************/
  viUseCount++;

 /*********************************************************************/
 /* Return successfully.  Remember that returning FALSE from          */
 /* WM_CREATE means that everying was ay-ok.                          */
 /*********************************************************************/
  return ((long)FALSE);
}

VOID FAR CnrDisplayData (hwndCnr)

HANDLE hwndCnr;
{
#if 0
 char People[400];


 lstrcpy (People, "Pete Brightbill               Peter Haggar\n\n");
 lstrcat (People, "Tai Woo Nam                   Ruth Taylor\n\n");
 lstrcat (People, "Mark Benge                    Dave Bernath\n\n");
 lstrcat (People, "Jon Holliday                  Morgan Kinne\n\n");
 lstrcat (People, "Diana Mack                    Jeff Robison\n\n");
 lstrcat (People, "Steve Robinson                Tim Wolf\n\n");
 lstrcat (People, "Sandeep Singhal    Documentation: Fred Brown");

 MessageBox ( hwndCnr,
              (LPSTR)People,
              (LPSTR)"The Container Control has been brought to you by:",
              MB_OK);
#endif
 return;
hwndCnr;
}

/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrDestroy                                     */
/*                                                                    */
/*  Descriptive Name:  Container termination processing               */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  Notes:                                                            */
/*     Forward Declaration:  long CnrDestroy(                         */
/*                               HANDLE    hwndCnr                    */
/*                               )                                    */
/*                                                                    */
/*  Input:   hwnd    - container control handle                       */
/*                                                                    */
/*  Output:  NULL  - Control window terminated                        */
/*                                                                    */
/**********************************************************************/
long FAR CnrDestroy (HANDLE hwndCnr)
{
//LPVOID     pSatPtr;
  HWND       hwndMLE;
  LPCNRINFON pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);

  /********************************************************************/
  /* MLE must be destroyed before internal data structure is freed    */
  /* because subclass proc needs pointer to original mle proc which   */
  /* is stored in the internal data structure.                        */
  /********************************************************************/
  if (hwndMLE = GetDlgItem(hwndCnr,CID_MLE))
    DestroyWindow(hwndMLE);

  /********************************************************************/
  /* Decrement use count and release resources if this is the last    */
  /* container destroyed.                                             */
  /********************************************************************/
  if (!(--viUseCount))
  {
//   DeleteObject (vhbmCollapse);
//   DeleteObject (vhbmExpand);
//   DestroyCursor (vhcurSplitPtr);
  }

  /********************************************************************/
  /* This call will remove all currently inserted records in the      */
  /* container, and free the memory occupied by the internal          */
  /* RECORDCORE's of each, as well as the external RECORDCORE's if    */
  /* they are not currently inserted into any other container.        */
  /* It will also free the memory occupied by the icon metrics for    */
  /* each record.                                                     */
  /********************************************************************/
  CnrRemoveRecord (hwndCnr, 0, MAKELONG(0, CMA_FREE));                  /*DAB1*/

  /********************************************************************/
  /* Now remove all of the FieldInfo structures currently inserted    */
  /* and free the memory that they occupy.                            */
  /********************************************************************/
  CnrRemoveDetailFieldInfo (hwndCnr, 0, MAKELONG(0, CMA_FREE));         /*DAB1*/

  /********************************************************************/
  /* Now clean up some other structures that are laying around.....   */
  /********************************************************************/
//pSatPtr = PSATOF(hwndCnr);
//StmFreeStorage (pSatPtr, pccinfon->pRecordInsertN);
  GlobalFree( pccinfon->pRecordInsertN );                               /*DAB1*/

  /********************************************************************/
  /* Now free the 2 controls blocks used by container: CNRINFON and   */
  /* CNRINFO.  We can free both with the one call because they        */
  /* were allocated contiguously and pccinfon is a pointer to the     */
  /* beginning of the block of memory.                                */
  /********************************************************************/
//StmFreeStorage (pSatPtr, pccinfon);
  GlobalFree( pccinfon );                                               /*DAB1*/

  /********************************************************************/
  /* Get container storage space pointer                              */
  /********************************************************************/
//return ((long)StmTermStorageSpace (pSatPtr));
  return 0;                                                             /*DAB1*/
}


/**********************************************************************/
/*                                                                    */
/*  Function Name:  CnrInitNLSInfo                                    */
/*                                                                    */
/*  Descriptive Name:  Initialize NLS information                     */
/*                                                                    */
/*  Functional Description:                                           */
/*                                                                    */
/*  This function will read the appropriate information from the      */
/*  OS2.INI file and store it in CNRINFON.  This information will be  */
/*  used for Date Time and Number formatting in Details View.         */
/*                                                                    */
/*  Notes:  N/A                                                       */
/*                                                                    */
/*  Input:  hwndCnr - Handle of the Container Window.                 */
/*                                                                    */
/*  Output: N/A                                                       */
/*                                                                    */
/*  Exit-Normal:                                                      */
/*                                                                    */
/*  Exit-Error:   N/A                                                 */
/*                                                                    */
/*  Side Effects:  None                                               */
/*                                                                    */
/*  Author:  Peter Haggar                                             */
/**********************************************************************/
VOID FAR CnrInitNLSInfo (hwndCnr)

HANDLE  hwndCnr;

{
 LPCNRINFON    pccinfon;
 DWORD        cbl;
 WORD         cbs;
 char         szAppName[12];

 cbs;
 cbl;

 pccinfon = (LPCNRINFON)GetWindowLong (hwndCnr,QWL_CONTAINER);

 /*-----------------------------------------------------*/
 /* put the app name on the stack so multiple copies of */
 /* "PM_National" don't end up in the data segment      */
 /*-----------------------------------------------------*/
 lstrcpy (szAppName, "intl");                                           /*DAB2*/

 /*********************************************************************/
 /* Determine if the win.ini file has the Date and Time defined.  If  */
 /* so, we process it.  Otherwise, we get all the information from    */
 /* the DosGetCtryInfo API.                                           */
 /*********************************************************************/
// if (PrfQueryProfileSize (HINI_USER, szAppName, "sDate", &cbl))
// {
    /******************************************************************/
    /* Get the Time format.  This will return 0 for Twelve Hour       */
    /* format or 1 for 24 Hour format.                                */
    /******************************************************************/
    pccinfon->MilitaryFormat = GetProfileInt ( szAppName, (LPSTR)"iTime", 0);

    /******************************************************************/
    /* Get the Date Format.  This will return 0 for Month, Day, Year, */
    /* 1 for Day, Month, Year, or 2 for Year, Month, Day.             */
    /******************************************************************/
    pccinfon->DateFormat = GetProfileInt ( szAppName, (LPSTR)"iDate", 0);

    /******************************************************************/
    /* Determine if a Leading Zero is specified.  This will determine */
    /* if we pad the dates and times.                                 */
    /******************************************************************/
    pccinfon->LeadingZero = GetProfileInt( szAppName, (LPSTR)"iLzero", 0);

    /******************************************************************/
    /* Get the Date Separator.                                        */
    /******************************************************************/
    GetProfileString ( szAppName, (LPSTR)"sDate", (LPSTR)"/",
                       pccinfon->DateSep, 2);                           /*DAB4*/

    /******************************************************************/
    /* Get the Time Separator.                                        */
    /******************************************************************/
    GetProfileString ( szAppName, (LPSTR)"sTime", (LPSTR)":",
                       pccinfon->TimeSep, 2);                           /*DAB4*/

    /******************************************************************/
    /* Get the Number Separator.                                      */
    /******************************************************************/
    GetProfileString ( szAppName, (LPSTR)"sThousand", (LPSTR)",",
                       pccinfon->Thousands, 2);                         /*DAB4*/

    /******************************************************************/
    /* Get the AM string.                                             */
    /******************************************************************/
    GetProfileString ( szAppName, (LPSTR)"s1159", (LPSTR)"am",
                       pccinfon->AM, 9);                                /*DAB4*/

    /******************************************************************/
    /* Get the PM string.                                             */
    /******************************************************************/
    GetProfileString ( szAppName, (LPSTR)"s2359", (LPSTR)"pm",
                       pccinfon->PM, 9);                                /*DAB4*/
 return;
}

/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrChangeCursor                                */
/*                                                                    */
/*  Descriptive Name:  Reset the cursored record pointer              */
/*                                                                    */
/*  Functional Description:  Reset the cursored record pointer to     */
/*                           passed record and redraw old one.        */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/*  Input:                                                            */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/**********************************************************************/
BOOL FAR CnrChangeCursor (HANDLE hwnd, LPRECORDCOREN pRecord, HDC hps,
                           BOOL fDeselect)
{
  LPCNRINFON pccinfon;                  /* Internal control data      */

  pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);

  if (pRecord != pccinfon->preccCursor)
  {
    /******************************************************************/
    /* Remove cursor emphasis from the old cursored record            */
    /******************************************************************/
    if (pccinfon->preccCursor)
    {
      if (!SetEmphasisBits (hwnd, (fDeselect) ? NULL : hps,
                            pccinfon->preccCursor, CRA_CURSORED, SEB_CLEAR))
      {
         return (FALSE);
      }
    }

    pccinfon->preccCursor = pRecord;

    /******************************************************************/
    /* Apply cursor emphasis to the new record under the cursor       */
    /******************************************************************/
    if (!SetEmphasisBits (hwnd, hps, pRecord, CRA_CURSORED, SEB_SET))
    {
      return (FALSE);
    }
  }

  return(TRUE);
}


/**********************************************************************/
/*                                                                    */
/*  Function Name:     CnrStartDirectEdit                             */
/*                                                                    */
/*  Descriptive Name:  Starts a direct edit operation                 */
/*                                                                    */
/*  Functional Description: This function starts a direct edit        */
/*     operation on a record.                                         */
/*                                                                    */
/*  Notes:                                                            */
/*     Forward Declaration:                                           */
/*                                                                    */
/*  Input:   standard winproc parameters                              */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/*  Exit-Normal:                                                      */
/*                                                                    */
/*  Exit-Error:                                                       */
/*                                                                    */
/*  Side Effects:                                                     */
/*                                                                    */
/**********************************************************************/
LONG FAR CnrStartDirectEdit( HWND hwnd, UINT msg, WPARAM wParam,        /*DAB1*/
                             LPARAM lParam )                            /*DAB1*/
{
  LPCNRINFON    pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);
  LPCNRINFO     pccinfo;
  BOOL          LeftWindow = TRUE;

  pccinfo  = PCCINFOXFROMN(pccinfon);

  /***********************************************************/
  /* Open MLE to edit the text of the record under pointer   */
  /* by calling CnrOpenRecordTextMLE(in cnrcfunc.c)          */
  /***********************************************************/
  if (!(pccinfo->flWindowAttr & CV_DETAIL))
  {
    CnrOpenRecordTextMLE (hwnd, lParam);
  }

  else if (pccinfon->ulFlagSet2 & (FL2_BUTTONLEFT | FL2_BUTTONRIGHT))
  {
    CnrOpenColDataTextMLE (hwnd,
                           (long)LOWORD(lParam),
                           (long)HIWORD(lParam),
                           (BOOL)((pccinfon->ulFlagSet2 & FL2_BUTTONLEFT) ?
                           TRUE : FALSE));
  }

  pccinfon->ulFlagSet2 &= ~(FL2_BUTTONLEFT | FL2_BUTTONRIGHT);
  return (DefWindowProc (hwnd, msg, wParam, lParam));
}

/* =========================================================================
 *
 *  Function:     NotifyOwner
 *
 *  Description:  Sends a WM_COMMAND message to the owner of a window.
 *
 *  Input:        hwnd         - window whose owner is to be notified
 *                usNotifyCode - WM_COMMAND message to be sent
 *                lpData       - Notification data
 *
 *  Output:       TRUE  - success
 *                FALSE - failure
 *
 * ========================================================================= */

long FAR NotifyOwner ( HWND hwnd, WORD usNotifyCode, LPVOID lpData )
{

  long         rc;                       /* return code               */
  LPCNRINFON   pccinfon;                 /* Internal CNR control data *//*DAB5*/
  BOOL         bRet=FALSE;                                              /*DAB5*/

  /********************************************************************/
  /* If realloc psz, special processing required do to WM_COMMAND     */
  /* default processing within Windows                                */
  /********************************************************************/
  if (usNotifyCode == CN_REALLOCPSZ)                                    /*DAB5*/
  {                                                                     /*DAB5*/
    char pszName[20];                                                   /*DAB5*/
    char pszAtom[20];                                                   /*DAB5*/

    /******************************************************************/
    /* Get ptr to internal CNRINFO control data and reset return info */
    /******************************************************************/
    pccinfon = (LPCNRINFON)GetWindowLong(hwnd,QWL_CONTAINER);           /*DAB5*/
    pccinfon->bRPZinDlgRet = FALSE;                                     /*DAB5*/

    /******************************************************************/
    /* If a Container is placed within a Dialog Box, then WM_COMMAND  */
    /* processing of Windows will reset the return value.  Check      */
    /* the parent of the Container here to see if this is the case.   */
    /******************************************************************/
    GetClassName( GetParent( hwnd ), pszName, 20 );                     /*DAB5*/
    GetAtomName( (ATOM)WC_DIALOG, (LPSTR)pszAtom, 20 );                 /*DAB5*/

    /******************************************************************/
    /* Modified to check for default dialog class name OR special     */
    /*  BORLAND dialog class name which has the same restriction      */
    /******************************************************************/
    if ( (!(lstrcmp( pszName, pszAtom ))) ||                            /*DAB5*/
         (!(lstrcmp( pszName, "bordlg" ))) )                            /*DAB5*/
      /****************************************************************/
      /* If container in dialog, then set flag                        */
      /****************************************************************/
      bRet = TRUE;                                                      /*DAB5*/
  }

  /********************************************************************/
  /* Send notification message, passing data block and notify codes   */
  /********************************************************************/
  rc = SENDMESSAGE( GetParent(hwnd), WM_COMMAND,                        /*DAB1*/
                    (WPARAM)MAKELONG( IDOF(hwnd), usNotifyCode ),       /*DAB1*/
                    (LPARAM)lpData );                                   /*DAB1*/

  /********************************************************************/
  /* If container is within a dialog, then get app returned value     */
  /********************************************************************/
  if (bRet)                                                             /*DAB5*/
    rc = pccinfon->bRPZinDlgRet;                                        /*DAB5*/

  return(rc);
}
