/* Revision: 10 1.4.1.3 source/ui/cclnt/cnr/cnrs1p4.c, cclcnr, ioc.v400, 001006  */
/**********************************************************************/
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*        (IBM Confidential-Restricted when combined with the         */
/*         aggregated OCO source modules for this program)            */
/*                                                                    */
/*                       OCO SOURCE MATERIALS                         */
/*                                                                    */
/*         20G0400 (C) Copyright IBM Corp. 1992, 1997 (Unpublished)   */
/*                                                                    */
/* ================================================================== */
/*                                                                    */
/*                         C O N T A I N E R                          */
/*                                                                    */
/*                        Filename: CNRS1P4.C                         */
/*                                                                    */
/*             ( Windows NT Container Control Component )             */
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*                (C) Copyright IBM Corporation 1997                  */
/*                       All Rights Reserved                          */
/*            Licensed Material - Program Property of IBM             */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/* Product: ICLUINT.DLL                                               */
/* Filename: CNRS1P4.C - MLE, Title, Font and drawing routines for    */
/*                       the container control                        */
/*                                                                    */
/* Flag    Date    By:  Description                                   */
/* ----  --------  ---  --------------------------------------------- */
/* DAB1  11/16/93  DAB  Initial modifications for NT execution        */
/* DAB2  10/11/95  DAB  Fixed problem with ownerdraw cnr id in mp1    */
/* D6386  1/16/96  ASM  Enable message passing in Win32s environment  */
/*                      Change SendMessage to SENDMESSAGE             */
/* RKK1   4/30/96  RKK  Add changes required for Wind/U.              */
/* DAB3   8/01/96  DAB  Defect 8172 - Fixed CM_PAINTBACKGROUND parms  */
/* D7092  8/06/96  LJO  Add support for icon resizing.                */
/* D7144  8/06/96  LJO  Fix null popup menu over title.               */
/* D7931  8/06/96  LJO  Fix paint of non-expanded items in tree view. */
/* DAB4   4/25/97  DAB  Defect 21242 - Fix custom cursor painting     */
/**********************************************************************/
#include <windows.h>
#include <iclccl.h>     /* CCL common include file  */
#include <string.h>
#include "cnr2win.h"
#include "iclcnrw.h"

#include "cnrcbn.h"
//#include "storwin.h"

#ifdef SEGMENTOR
#define CNRS1P4_C
#include "cnrpragw.h"
#endif

extern HANDLE  vhCNRInstance;

/* *******************************************************************/
/*                                                                   */
/*  Function Name:  MLESubProc                                       */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   SubProc of MLE Proc                          */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function handles the msgs passed to the MLE              */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd - handle of the container window.                  */
/*           msg                                                     */
/*           mp1                                                     */
/*           mp2                                                     */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
LRESULT CALLBACK MLESubProc( HWND hwnd, UINT msg, WPARAM wParam,        /*DAB1*/
                             LPARAM lParam)                             /*DAB1*/
{
  HANDLE      hwndCnr;
  LPCNRINFON  pccinfon;

  hwndCnr = PARENTOF (hwnd);
  pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);

  switch (msg)
  {
    case WM_KEYDOWN:
      if (wParam == VK_TAB)
      {
        return((long)FALSE);
      }

      if (wParam == VK_ESCAPE)
      {
        CnrCloseMLE(hwndCnr);
        return((long)FALSE);
      } /*endif */

      /* If the out-board enter key is pressed whilst in direct
       * edit, this means that the user wants to save the text
       * in the MLE.
       */
      if (wParam == VK_EXECUTE)
      {
        CnrSaveTextCloseMLE (hwndCnr);
        return((long)FALSE);
      } /*endif */
      break;

    default:
      break;
  } /* end switch */

 #ifdef STRICT
  return ((CallWindowProc( (WNDPROC)pccinfon->pfnwpMLE, hwnd, msg,
                            wParam, lParam)));
 #else
  return ((CallWindowProc ((FARPROC)pccinfon->pfnwpMLE, hwnd, msg,
                            wParam, lParam)));
 #endif
}

/*********************************************************************/
/*                                                                   */
/* FUNCTION NAME:  CnrCalcIconSize                                   */
/*                                                                   */
/* Usage: External                                                   */
/*                                                                   */
/* DESCRIPTIVE NAME:  Container Common Function Calculate Icon Size  */
/*                                                                   */
/* FUNCTIONAL DESCRIPTION:  This function calculates the icon size   */
/*   based on the user provided information.  This function is used  */
/*   by the Name and Icon views.                                     */
/*                                                                   */
/* NOTES:                                                            */
/*    FORWARD DECLARATION:                                           */
/*                                                                   */
/* INPUT:  PCNRINFON privateSelf - pointer to internal container     */
/*             data structure                                        */
/*         LPPOINT iconSize - icon size structure                    */
/*                                                                   */
/* OUTPUT:                                                           */
/*                                                                   */
/*                                                                   */
/* EXIT-NORMAL:                                                      */
/*                                                                   */
/* EXIT-ERROR:                                                       */
/*                                                                   */
/* SIDE EFFECTS:                                                     */
/*                                                                   */
/*********************************************************************/
VOID FAR  CnrCalcIconSize( hwndCnr, iconSize )
HANDLE   hwndCnr;
LPPOINT  iconSize;
{
 LPCNRINFON pccinfon;
 LPCNRINFO  pccinfo;

 pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);
 pccinfo  = PCCINFOXFROMN(pccinfon);

  if (pccinfo->flWindowAttr & CV_MINI)
  {
     pccinfo->slBitmapOrIcon.x = iconSize->x = GetSystemMetrics(SM_CXSMICON);
     pccinfo->slBitmapOrIcon.y = iconSize->y = GetSystemMetrics(SM_CYSMICON);
  }                                                                 /* D7092 */
  else
  {
    if ((pccinfo->slBitmapOrIcon.x == 0) && (pccinfo->slBitmapOrIcon.y == 0))
    {
      pccinfo->slBitmapOrIcon.x =
            iconSize->x = GetSystemMetrics(SM_CXICON);
      pccinfo->slBitmapOrIcon.y =
            iconSize->y = GetSystemMetrics(SM_CYICON);
    }
    else
    {
      iconSize->x = pccinfo->slBitmapOrIcon.x;
      iconSize->y = pccinfo->slBitmapOrIcon.y;
    }
  }
  return;
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:  CnrCloseMLE                                      */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Close MLE without saving the text.           */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function handles the msgs passed to the MLE              */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd - handle of the container window.                  */
/*           msg                                                     */
/*           mp1                                                     */
/*           mp2                                                     */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
BOOL FAR  CnrCloseMLE(hwndCnr)
HANDLE       hwndCnr;

{
  HANDLE      hwndMLE;
  LPCNRINFON  pccinfon;

  pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);

  hwndMLE = GetDlgItem(hwndCnr,CID_MLE);

  pccinfon->ulFlagSet &= ~FL_EDITMODE;
  /***************************************************************/
  /* Send a notification msg CN_ENDEDIT.                         */
  /***************************************************************/
  NotifyOwner (hwndCnr, CN_ENDEDIT, (LPVOID)&pccinfon->ceData);

  DestroyWindow (hwndMLE);

  SetFocus (hwndCnr);
  pccinfon->pFIEdit = NULL;
  return TRUE;
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:  CnrCreateMLE                                     */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Create MLE                                   */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function creates a MLE                                   */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd - handle of the container window.                  */
/*           pszText - text string                                   */
/*           rctlTitle - rectangle of the MLE                        */
/*           usGeneration - generation of the MLE from Cnr window    */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
HANDLE FAR CnrCreateMLE(                                       /*RKK1*/
  HANDLE       hwnd,
  LPSTR        pszText,
  RECT         rctlTitle,
  WORD         usGeneration )                                  /*RKK1*/
{
  HWND         hwndMLE;                                                 /*DAB1*/
  HWND         hwndCnr;                                                 /*DAB1*/
  LPCNRINFON   pccinfon;
  HDC          hDC = NULL;
  RECT         rctlClient;
  BOOL         isWinNT, isNTNewshell, isWin32s;
  MLEINFO      mleInfo;
  long         minHeight;

  if (usGeneration == 1)
  {
    /*****************************************************************/
    /* We are handling the items in the container window.            */
    /*****************************************************************/
    hwndCnr = hwnd;
  }
  else
  {
    if (usGeneration == 2)
    {
      /***************************************************************/
      /* We are handling the text in a child window such as the      */
      /* container title.                                            */
      /***************************************************************/
      hwndCnr = PARENTOF(hwnd);
    }
  }
  pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);

  /********************************************************************/
  /* Set the MLE window.                                              */
  /********************************************************************/
  hwndMLE = CreateWindow((LPSTR)"Edit", (LPSTR)NULL,
                       (WS_BORDER | WS_VISIBLE | CNR_REQUIREDSTYLES |
                        ES_MULTILINE | ES_AUTOHSCROLL | ES_AUTOVSCROLL |
                        ES_LEFT), 0, 0, 0, 0, hwndCnr,
                        (HMENU)CID_MLE, vhCNRInstance, (LPSTR)NULL);

  /********************************************************************/
  /* Subclass the MLE and save the procedure handle for future use    */
  /********************************************************************/
  pccinfon->pfnwpMLE = SetWindowLong( hwndMLE, GWL_WNDPROC,
                                      (DWORD)MLESubProc );

  /********************************************************************/
  /* Send a notification msg with ceData to the application           */
  /********************************************************************/
  NotifyOwner (hwndCnr, CN_BEGINEDIT, &pccinfon->ceData);

  /********************************************************************/
  /* Set the user specified font - If NULL use default (System)       */
  /********************************************************************/
  if (pccinfon->hCnrFont)
  {
    SENDMESSAGE (hwndMLE, WM_SETFONT,
                 (WPARAM)pccinfon->hCnrFont,                            /*DAB1*/
                 (LPARAM)TRUE);                                         /*DAB1*/

  }

  /*******************************************************************/
  /* Send the message to set background color                        */
  /*******************************************************************/
   if (pccinfon->ulColorPPSupport[CMA_BACKGROUNDCOLOR])
  {
    if (hDC = GetDC (hwndMLE))
    {
      SetBkMode (hDC, TRANSPARENT);
      SetBkColor(hDC, pccinfon->ulColorPPSupport[CMA_BACKGROUNDCOLOR]);
    }
  }

  /*******************************************************************/
  /* Send the message to select an area of text.                     */
  /*******************************************************************/
  SENDMESSAGE (hwndMLE, EM_SETSEL,
               (WPARAM)0, (LPARAM)0);                                   /*DAB1*/

  if (pszText && !(*pszText == '\0') )
  {
    /*****************************************************************/
    /* Send message to the MLE to insert the text to the MLE.        */
    /*****************************************************************/
    SetWindowText (hwndMLE, pszText);
  }

  CnrQuerySizeRect(hwndCnr, NULL, NULL, &rctlClient, NULL, NULL);


  isWinNT = (GetVersion() < 0x80000000ul);
  isNTNewshell = isWinNT && (LOBYTE(LOWORD(GetVersion())) == 4);

  if (isNTNewshell)
     MoveWindow (hwndMLE,
                 max(rctlTitle.left, rctlClient.left),
                 rctlTitle.top,
                 min((rctlTitle.right - rctlTitle.left), rctlClient.right),
                 (rctlTitle.bottom - rctlTitle.top),
                 TRUE);
  else
     {
     CnrQueryFontMetrics( hwndCnr, NULL, TRUE, &mleInfo, NULL );
     minHeight = (mleInfo.lMaxBaselineExt * 3 + 1) / 2;
     MoveWindow( hwndMLE,
                 max(rctlTitle.left, rctlClient.left),
                 rctlTitle.top,
                 min((rctlTitle.right - rctlTitle.left), rctlClient.right),
                 max((rctlTitle.bottom - rctlTitle.top), minHeight),
                 TRUE);
     }

  if (hwndCnr != hwnd)
  {
    SetWindowPos (hwndMLE,
                  HWND_TOP,
                  0, 0, 0, 0,
                  SWP_SHOWWINDOW | SWP_NOMOVE | SWP_NOSIZE);
  }

  SetFocus (hwndMLE);

  /*******************************************************************/
  /* Send the message to select an area of text.                     */
  /*******************************************************************/
  SENDMESSAGE (hwndMLE, EM_SETSEL,
               (WPARAM)0, (LPARAM)0);                                   /*DAB1*/

  if (hDC)
    ReleaseDC (hwndMLE, hDC);

  return(hwndMLE);
}

/*********************************************************************/
/* FUNCTION NAME:  CnrDrawCursorBox                                  */
/*                                                                   */
/* DESCRIPTIVE NAME: Draw Or Erase Cursored Emph Box                 */
/*                                                                   */
/* FUNCTIONAL DESCRIPTION:  This function draws the cursored emph    */
/*                          box.                                     */
/*                                                                   */
/* NOTES:                                                            */
/*    FORWARD DECLARATION:                                           */
/*                                                                   */
/* INPUT:  HANDLE hwndCnr - handle to the container window           */
/*         HDC  hps - handle of the presentation space               */
/*         LPRECORDCORE precord - pointer to the record structure     */
/*         RECT rctlBox - rectangle of the box                       */
/*         BOOL flDraw - flag to indicate to draw or to erase        */
/*              TRUE - draw cursored emph box                        */
/*              FALSE - erase cursored emph box                      */
/*                                                                   */
/* OUTPUT:                                                           */
/*                                                                   */
/*                                                                   */
/* EXIT-NORMAL:                                                      */
/*                                                                   */
/* EXIT-ERROR:                                                       */
/*                                                                   */
/* SIDE EFFECTS:                                                     */
/*********************************************************************/
VOID FAR  CnrDrawCursorBox(hwndCnr, hps, precord, rctlBox, flDraw)
HANDLE        hwndCnr;
HDC           hps;
LPRECORDCOREN precord;
RECT          rctlBox;
BOOL          flDraw;
{
  LPCNRINFON   pccinfon;
  LPCNRINFO    pccinfo;
  long         lLineColor;           /* color of the line of the box */
  HPEN         hpenOld;
  HPEN         hpenCurrent;
  HBRUSH       hbrushOld;
  int          oldBkMode;            /* save old background mode */
  int          nSavedDC;
  int          sLineType;            /* type of the line */

  /********************************************************************/
  /* Make sure the record is visible, and the container window has    */
  /* the focus before we try to draw the cursor emphasis.             */
  /********************************************************************/
  if ((precord && ISRECORDVISIBLE(precord)) &&
      ((hwndCnr == GetFocus ()) || !(flDraw)))
  {
    pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);
    pccinfo  = PCCINFOXFROMN(pccinfon);

    /******************************************************************/
    /* If we are in Details View and everything is ownerdraw, don't   */
    /* draw the cursor.                                               */
    /******************************************************************/
    if ((pccinfo->flWindowAttr & CV_DETAIL) &&
        (pccinfo->flWindowAttr & CA_OWNERDRAW))
    {
       return;
    }

    if (flDraw)
    {
      /****************************************************************/
      /* If we are in Details View, we use a different color for the  */
      /* cursor depending on whether the item is selected or not.     */
      /****************************************************************/
      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
        if (precord->flRecordAttr & CRA_SELECTED)
        {
          lLineColor = pccinfon->ulColorPPSupport[CMA_SELECTFOREGROUNDCOLOR];
        }
        else
        {
          lLineColor = pccinfon->ulColorPPSupport[CMA_SELECTBACKGROUNDCOLOR];
        }
      }
      else
      {
        lLineColor = pccinfon->ulColorPPSupport[CMA_SELECTBACKGROUNDCOLOR];
      }
      sLineType = PS_DOT;
    }
    else
    /******************************************************************/
    /* We are going to erase the cursor.                              */
    /******************************************************************/
    {
      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
         if (precord->flRecordAttr & CRA_SELECTED)
         {
           lLineColor = pccinfon->ulColorPPSupport[CMA_SELECTBACKGROUNDCOLOR];
         }
         else
         {
           lLineColor = pccinfon->ulColorPPSupport[CMA_BACKGROUNDCOLOR];
         }
      }
      else
      {
        lLineColor = pccinfon->ulColorPPSupport[CMA_BACKGROUNDCOLOR];
      }
      sLineType = PS_SOLID;
    }

    /*****************************************************************/
    /* Save current PS attributes                                    */
    /*****************************************************************/
    if (!(nSavedDC = SaveDC (hps)))
      return;

    /*****************************************************************/
    /* Draw the box from the current pos to the top right pos        */
    /*****************************************************************/
    if (hpenCurrent = CreatePen (sLineType, 1, lLineColor))
    {
      hpenOld = SelectObject (hps, hpenCurrent);
      oldBkMode = SetBkMode (hps, TRANSPARENT);
      hbrushOld = SelectObject (hps, GetStockObject (NULL_BRUSH));
      Rectangle (hps, rctlBox.left, rctlBox.top, rctlBox.right,
                 rctlBox.bottom);

      /*****************************************************************/
      /* Select the old brush                                          */
      /*****************************************************************/
      SelectObject (hps, hbrushOld);

      /*****************************************************************/
      /* Select the old pen color and free resource.                   */
      /*****************************************************************/
      DeleteObject (SelectObject (hps, hpenOld));

      /*****************************************************************/
      /* Select the old background mode                                */
      /*****************************************************************/
      SetBkMode (hps, oldBkMode);
    }

    /*****************************************************************/
    /* Restore the previous PS attributes                            */
    /*****************************************************************/
    RestoreDC (hps, nSavedDC);
  }

  return;
}

/*********************************************************************/
/* FUNCTION NAME:  CnrDrawIconOnly                                   */
/*                                                                   */
/* DESCRIPTIVE NAME: Draw Icon Only in All Views                     */
/*                                                                   */
/* FUNCTIONAL DESCRIPTION:  This function draws the icon only        */
/*                          for a record.                            */
/*                                                                   */
/* NOTES:                                                            */
/*    FORWARD DECLARATION:                                           */
/*                                                                   */
/* INPUT:  HANDLE hwndCnr - handle to the container window           */
/*         HDC  hps - handle of the presentation space               */
/*         LPRECORDCORE precord - pointer to the record structure     */
/*         RECT rctlIcon - rectangle of the icon                     */
/*                                                                   */
/* OUTPUT:                                                           */
/*                                                                   */
/*                                                                   */
/* EXIT-NORMAL:                                                      */
/*                                                                   */
/* EXIT-ERROR:                                                       */
/*                                                                   */
/* SIDE EFFECTS:                                                     */
/*                                                                   */
/*********************************************************************/
VOID FAR  CnrDrawIconOnly( hwndCnr, hps, precord, sDrawWhat,
                           rctlIcon, rctlIconCur)
HANDLE        hwndCnr;
HDC           hps;
LPRECORDCOREN precord;
int           sDrawWhat;
RECT          rctlIcon;
RECT          rctlIconCur;
{
  BOOL            blOwnerdrawIcon; /* Flag for the owner draw style */
  HANDLE          hwndOwner;       /* handle of the owner window */
  HBITMAP         hbmDraw;         /* handle of the bitmap to be drawn.    */
  DRAWITEMSTRUCT  DrawItem;        /* structure passed to the owner window */
                                   /* for the owner draw */
  LPCNRINFON      pccinfon;
  LPCNRINFO       pccinfo;
  LPICONRESIZED   pirsDraw;
  UINT            wWinID;          /* window ID */                      /*DAB1*/
  CNRDRAWITEMINFO CnrDrawItemInfo;
  int             nSavedDC;

  pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /*******************************************************************/
  /* If the container has the OWNERDRAW style, then send the         */
  /* WM_DRAWITEM message to the owner.  If, either the owner did     */
  /* not draw the record (returned FALSE), or the container was not  */
  /* OWNERDRAW, then we will paint the record.                       */
  /*******************************************************************/
  blOwnerdrawIcon = FALSE;

  hwndOwner = PARENTOF (hwndCnr);
  wWinID = getWindowId( hwndCnr );                                     /*DAB1*/
  if (pccinfo->flWindowAttr & CA_OWNERDRAW)
  {
    nSavedDC = SaveDC (hps);

    /******************************************************************/
    /* Set DrawItem data by calling CnrSetDrawItem (in cnrdfunc.c)    */
    /******************************************************************/
    CnrSetDrawItem (hwndCnr, hps, &DrawItem, CMA_ICON);

    /******************************************************************/
    /* Set container control ID.                                      */
    /******************************************************************/
    DrawItem.CtlID = wWinID;

    /******************************************************************/
    /* Set rcItem as the rectangle of the icon.                       */
    /******************************************************************/
    DrawItem.rcItem = rctlIconCur;

    /******************************************************************/
    /* Set up the CnrDrawItemInfo structure, and pass it back in the  */
    /* hItem field.                                                   */
    /******************************************************************/
    COPYNDATATOX(precord);
    CnrDrawItemInfo.pRecord = precord->preccX;
    CnrDrawItemInfo.pFieldInfo = NULL;
    DrawItem.itemData = (DWORD)(LPVOID)&CnrDrawItemInfo;

    /******************************************************************/
    /* Send WM_DRAWITEM for the owner drawing if the icon.            */
    /******************************************************************/
    blOwnerdrawIcon = SENDMESSAGE( hwndOwner,WM_DRAWITEM,(WPARAM)wWinID,/*DAB2*/
                                  (DWORD)((LPDRAWITEMSTRUCT)&DrawItem));

    if (nSavedDC)
      RestoreDC (hps, nSavedDC);
  }

  /********************************************************************/
  /* If the owner did not draw the item, then we should draw it here  */
  /********************************************************************/
  if (!blOwnerdrawIcon)
  {
    /******************************************************************/
    /* Check if the icon is to be drawn (not just cursor)             */
    /******************************************************************/
    if (sDrawWhat & DRAW_ICON)
    {
      /****************************************************************/
      /* Get the information to use for drawing                       */
      /****************************************************************/
      CnrSetupDrawInfo (hwndCnr, precord, &hbmDraw, &pirsDraw);

      /****************************************************************/
      /* If no icon or bitmap to draw exists and WM_DRAWITEM is not   */
      /* sent before, send WM_DRAWITEM to the owner of the container  */
      /* for the app to provide a bitmap or icon or to draw it.       */
      /* (James Taylor requirement)                                   */
      /****************************************************************/
      if (!(hbmDraw || pirsDraw) &&
          !(pccinfo->flWindowAttr & CA_OWNERDRAW))
      {
        CnrSetDrawItem (hwndCnr, hps, &DrawItem, CMA_ICON);

        DrawItem.CtlID = wWinID;
        DrawItem.rcItem = rctlIcon;

        /*******************************************************************/
        /* Set up the CnrDrawItemInfo structure, and pass it back in the   */
        /* hItem field.                                                    */
        /*******************************************************************/
        COPYNDATATOX(precord);
        CnrDrawItemInfo.pRecord = precord->preccX;
        CnrDrawItemInfo.pFieldInfo = NULL;
        DrawItem.itemData = (DWORD)(LPVOID)&CnrDrawItemInfo;

        blOwnerdrawIcon = SENDMESSAGE( hwndOwner, WM_DRAWITEM,
                 (WPARAM)wWinID, (DWORD)((LPDRAWITEMSTRUCT)&DrawItem)); /*DAB2*/
        if (!blOwnerdrawIcon)
        {
          CnrSetupDrawInfo( hwndCnr, precord, &hbmDraw, &pirsDraw );
        }
      }

      if ((hbmDraw || pirsDraw ) && (!blOwnerdrawIcon))
      {
        /**************************************************************/
        /* Once we have the image to be drawn set up, draw it         */
        /**************************************************************/
        IcnDrawIcon (hps, pirsDraw, hbmDraw,
                     (precord->flRecordAttr & CRA_INUSE) ?
                     (precord->flRecordAttr | CRA_INUSE) :
                     precord->flRecordAttr, rctlIcon, pccinfon);
      }
    }

    /******************************************************************/
    /* Check if the cursor is to be drawn (or erased) as well         */
    /******************************************************************/
    if ((sDrawWhat & DRAW_CURSOR) && (!blOwnerdrawIcon))
    {
      CnrDrawCursorBox(hwndCnr, hps, precord, rctlIconCur, TRUE);
    }
    else
    {
      if ((sDrawWhat & ERASE_CURSOR) && (!blOwnerdrawIcon))
      {
        CnrDrawCursorBox(hwndCnr, hps, precord, rctlIconCur, FALSE);
      }
    }
  } /* endif ! Owner draw */

  return;
}


/**********************************************************************/
/* FUNCTION NAME:  CnrSetupDrawInfo                                   */
/*                                                                    */
/* DESCRIPTIVE NAME: Setup Draw information in all views              */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:  This function will setup the correct      */
/*                          values of pirsDraw and hbmDraw based on   */
/*                          the container attributes set              */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:  HANDLE hwndCnr - handle to the container window            */
/*         LPRECORDCORE precord - pointer to the record structure      */
/*         HBITMAP *hbmDraw - pointer to handle of bitmap to return   */
/*         PICONRESIZED *pirsDraw - pointer of resized icon to return */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/**********************************************************************/
BOOL FAR CnrSetupDrawInfo (HANDLE hwndCnr, LPRECORDCOREN precord,
                      HBITMAP FAR *hbmDraw, LPICONRESIZED FAR *pirsDraw)
{
  LPCNRINFON  pccinfon;
  LPCNRINFO   pccinfo;

  /********************************************************************/
  /* Get external pointer to container information from window words  */
  /********************************************************************/
  pccinfon = (LPCNRINFON)GetWindowLong( hwndCnr, QWL_CONTAINER );
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /********************************************************************/
  /* Set the icon value to NULL                                       */
  /********************************************************************/
  *pirsDraw = NULL;

  /********************************************************************/
  /* Set the bitmap value to NULL                                     */
  /********************************************************************/
  *hbmDraw = NULL;

  /********************************************************************/
  /* If so, check if record is a full size record or a small one      */
  /********************************************************************/
  if (precord->preccX->cb == sizeof(RECORDCORE))
  {
    /******************************************************************/
    /* If full, check if we are to use the bitmap or icon info        */
    /*  to represent the record in this view                          */
    /******************************************************************/
    if ((pccinfo->flWindowAttr & CA_DRAWBITMAP) &&
        !(pccinfo->flWindowAttr & CA_DRAWICON))
    {
      /****************************************************************/
      /* Check if tree view selected                                  */
      /****************************************************************/
      if (pccinfo->flWindowAttr & CV_TREE)
      {
        /**************************************************************/
        /* Check if tree name view being set                          */
        /**************************************************************/
        if (pccinfo->flWindowAttr & CV_NAME)
        {
          /************************************************************/
          /* Now check if the record is collapsed                     */
          /************************************************************/
          if ((precord->flRecordAttr & CRA_COLLAPSED) &&
              TRVhasVisibleChild (precord))
          {
            if (precord->preccX->pTreeItemDesc)
            {
              *hbmDraw = precord->preccX->pTreeItemDesc->hbmCollapsed;
            }
          }
          /************************************************************/
          /* otherwise check if it is expanded                        */
          /************************************************************/
          else if ((precord->flRecordAttr & CRA_EXPANDED) &&
                TRVhasVisibleChild (precord))
          {
            if (precord->preccX->pTreeItemDesc)
            {
              *hbmDraw = precord->preccX->pTreeItemDesc->hbmExpanded;
            }
          }
          /************************************************************/
          /* If neither, then use regular bitmap                      */
          /************************************************************/
          else
          {
            *hbmDraw = precord->preccX->hbmBitmap;
          }
        }
        /**************************************************************/
        /* If not tree name, then tree text or icon so use regular    */
        /**************************************************************/
        else
        {
          *hbmDraw = precord->preccX->hbmBitmap;
        }
      }
      /****************************************************************/
      /* Otherwise a non tree view was selected so use normal bitmaps */
      /****************************************************************/
      else
      {
        /**************************************************************/
        /* and check if we are to use the full size or mini-bitmap    */
        /**************************************************************/
        if (pccinfo->flWindowAttr & CV_MINI)
        {
          /************************************************************/
          /* If mini, check if it exists and if so use it             */
          /************************************************************/
          if (precord->preccX->hbmMiniBitmap)
          {
            *hbmDraw = precord->preccX->hbmMiniBitmap;
          }
          /************************************************************/
          /* Otherwise use the full size bitmap                       */
          /************************************************************/
          else
          {
            *hbmDraw = precord->preccX->hbmBitmap;
          }
        }
        /**************************************************************/
        /* If not mini                                                */
        /**************************************************************/
        else
        {
          /************************************************************/
          /* Check if the full size bitmap exists and if so use it    */
          /************************************************************/
          if (precord->preccX->hbmBitmap)
          {
            *hbmDraw = precord->preccX->hbmBitmap;
          }
          /************************************************************/
          /* Otherwise use the mini bitmap                            */
          /************************************************************/
          else
          {
            *hbmDraw = precord->preccX->hbmMiniBitmap;
          }
        }
      }
    }
    /******************************************************************/
    /* Otherwise use icon information to represent the record         */
    /******************************************************************/
    else
    {
      /****************************************************************/
      /* Check if tree view selected                                  */
      /****************************************************************/
      if (pccinfo->flWindowAttr & CV_TREE)
      {
        /**************************************************************/
        /* Check if tree name view being set                          */
        /**************************************************************/
        if (pccinfo->flWindowAttr & CV_NAME)
        {
          *pirsDraw = TRVFindPirs (hwndCnr, precord);
        }
        else
        {
          *pirsDraw = FindPirs (hwndCnr, precord->preccX, TRUE);
        }
      }
      /****************************************************************/
      /* Otherwise a non tree view was selected so use normal icons   */
      /****************************************************************/
      else
      {
        /**************************************************************/
        /* and check if we are to use the full size or mini-icon      */
        /**************************************************************/
        if (pccinfo->flWindowAttr & CV_MINI)
        {
          *pirsDraw = FindPirs(hwndCnr, precord->preccX, FALSE);
        }
        else
        {
          *pirsDraw = FindPirs(hwndCnr, precord->preccX, TRUE);
        }
      }
      /****************************************************************/
      /* Check if pointer to icon returned                            */
      /****************************************************************/
      if (!(*pirsDraw))
      {
        return (FALSE);
      }
    }
  }
  /********************************************************************/
  /* If small record, then only full size icon pointer exists so      */
  /*  use it to represent the record - set bitmap handle to NULL      */
  /********************************************************************/
  else
  {
     if (pccinfo->flWindowAttr & CV_MINI)
     {
        if (!(*pirsDraw = FindPirs (hwndCnr, precord->preccX, FALSE)))
           return (FALSE);
     }
     else
     {
        if (!(*pirsDraw = FindPirs (hwndCnr, precord->preccX, TRUE)))
           return (FALSE);
     }                                                              /* D7092 */
  }
  return (TRUE);
}

/*********************************************************************/
/* FUNCTION NAME:  CnrDrawTextOnly                                   */
/*                                                                   */
/* DESCRIPTIVE NAME: Draw Text Only in All Views                     */
/*                                                                   */
/* FUNCTIONAL DESCRIPTION:  This function draws the text only        */
/*                          for a record.                            */
/*                                                                   */
/* NOTES:                                                            */
/*    FORWARD DECLARATION:                                           */
/*                                                                   */
/* INPUT:  HANDLE hwndCnr - handle to the container window           */
/*         HDC  hps - handle of the presentation space               */
/*         LPRECORDCORE precord - pointer to the record structure     */
/*         RECT rctlText - rectangle of the text                     */
/*                                                                   */
/* OUTPUT:                                                           */
/*                                                                   */
/*                                                                   */
/* EXIT-NORMAL:                                                      */
/*                                                                   */
/* EXIT-ERROR:                                                       */
/*                                                                   */
/* SIDE EFFECTS:                                                     */
/*********************************************************************/
VOID FAR  CnrDrawTextOnly(hwndCnr, hps, precord, sDrawWhat,
                          rctlText, rctlTextCur)
HANDLE        hwndCnr;
HDC           hps;
LPRECORDCOREN  precord;
int           sDrawWhat;
RECT          rctlText;
RECT          rctlTextCur;
{
  BOOL            blOwnerdrawText; /* Flag for the owner draw style */
  HANDLE          hwndOwner;       /* handle of the owner window */
  DRAWITEMSTRUCT  DrawItem;        /* structure passed to the owner window */
                                   /* for the owner draw */
  LPCNRINFON      pccinfon;
  LPCNRINFO       pccinfo;
  UINT            wWinID;         /* window ID */                       /*DAB1*/
  CNRDRAWITEMINFO CnrDrawItemInfo;
  int             nSavedDC;

  pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /*******************************************************************/
  /* If the container has the OWNERDRAW style, then send the         */
  /* WM_DRAWITEM message to the owner.  If, either the owner did     */
  /* not draw the record (returned FALSE), or the container was not  */
  /* OWNERDRAW, then we will paint the record.                       */
  /*******************************************************************/
  blOwnerdrawText = FALSE;
  if (pccinfo->flWindowAttr & CA_OWNERDRAW)
  {
    nSavedDC = SaveDC (hps);
    hwndOwner = PARENTOF (hwndCnr);
    wWinID = getWindowId( hwndCnr );                                   /*DAB1*/

    /*****************************************************************/
    /* Set DrawItem data by calling CnrSetDrawItem (in cnrdfunc.c) */
    /*****************************************************************/
    CnrSetDrawItem (hwndCnr, hps, &DrawItem, CMA_TEXT);

    /******************************************************************/
    /* Set container control ID.                                      */
    /******************************************************************/
    DrawItem.CtlID = wWinID;

    /******************************************************************/
    /* Set rcItem as the rectangle of the text.                       */
    /******************************************************************/
    DrawItem.rcItem = rctlTextCur;

    /******************************************************************/
    /* Set up the CnrDrawItemInfo structure, and pass it back in the  */
    /* hItem field.                                                   */
    /******************************************************************/
    COPYNDATATOX(precord);
    CnrDrawItemInfo.pRecord = precord->preccX;
    CnrDrawItemInfo.pFieldInfo = NULL;
    DrawItem.itemData = (DWORD)(LPVOID)&CnrDrawItemInfo;

    /******************************************************************/
    /* Send WM_DRAWITEM for the owner drawing if the text.            */
    /******************************************************************/
    blOwnerdrawText = SENDMESSAGE( hwndOwner,WM_DRAWITEM,(WPARAM)wWinID,/*DAB2*/
                                  (DWORD)((LPDRAWITEMSTRUCT)&DrawItem));

    if (nSavedDC)
      RestoreDC (hps, nSavedDC);
  }

  if (!blOwnerdrawText)
  {
    if (sDrawWhat & DRAW_TEXT)
    {
      /****************************************************************/
      /* Check if tree view is currently displayed                    */
      /****************************************************************/
      if (pccinfo->flWindowAttr & CV_TREE)
      {
        IcnDrawText (hps, GETLPSTRFORTRV(precord->preccX), rctlText,
                     (precord->flRecordAttr & CRA_INUSE) ?
                     (precord->flRecordAttr | CRA_INUSE) :
                     precord->flRecordAttr, IS_SIDETEXT, pccinfon);
      }
      /****************************************************************/
      /* If not, then check if name view is currently displayed       */
      /****************************************************************/
      else if (pccinfo->flWindowAttr & CV_NAME)
      {
        IcnDrawText (hps, GETLPSTRFORNV(precord->preccX), rctlText,
                     (precord->flRecordAttr & CRA_INUSE) ?
                     (precord->flRecordAttr | CRA_INUSE) :
                     precord->flRecordAttr, IS_SIDETEXT, pccinfon);
      }
      /****************************************************************/
      /* If not, then check if text view is currently displayed       */
      /****************************************************************/
      else if (pccinfo->flWindowAttr & CV_TEXT)
      {
        IcnDrawText (hps, GETLPSTRFORTV(precord->preccX), rctlText,
                     (precord->flRecordAttr & CRA_INUSE) ?
                     (precord->flRecordAttr | CRA_INUSE) :
                     precord->flRecordAttr, IS_SIDETEXT, pccinfon);

      }
      /****************************************************************/
      /* If not, then check if icon view is currently displayed       */
      /****************************************************************/
      else if (pccinfo->flWindowAttr & CV_ICON)
      {
        IcnDrawText (hps, precord->preccX->pszIcon, rctlText,
                     (precord->flRecordAttr & CRA_INUSE) ?
                     (precord->flRecordAttr | CRA_INUSE) :
                     precord->flRecordAttr, IS_BENEATHTEXT, pccinfon);
      }
    }
    if (sDrawWhat & DRAW_CURSOR)
    {
      CnrDrawCursorBox(hwndCnr, hps, precord, rctlTextCur, TRUE);
    }
    else
    {
      if (sDrawWhat & ERASE_CURSOR)
      {
        CnrDrawCursorBox(hwndCnr, hps, precord, rctlTextCur, FALSE);
      }
    }
  }

  return;
}


/*********************************************************************/
/*                                                                   */
/*  FUNCTION NAME:  CnrDrawRecord                                    */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  DESCRIPTIVE NAME:  Container Control Draw Name                   */
/*                                                                   */
/*  FUNCTIONAL DESCRIPTION:  This function paints the specific Record*/
/*     in the current view by calling CnrDrawXxxx.                   */
/*                                                                   */
/*  NOTES:                                                           */
/*     FORWARD DECLARATION:                                          */
/*                                                                   */
/*  INPUT:  HANDLE hwndCnr - handle to the container window          */
/*          LPCNRINFON pccinfon - pointer to internal container       */
/*                                 data structure                    */
/*          LPRECORDCORE pRecord - pointer to the record structure    */
/*          BOOL        flChangeZorder - flag indicating changing    */
/*                                 Z order when drawing an item in   */
/*                                 the icon view                     */
/*                                                                   */
/*  OUTPUT:                                                          */
/*                                                                   */
/*                                                                   */
/*  EXIT-NORMAL:                                                     */
/*                                                                   */
/*  EXIT-ERROR:                                                      */
/*                                                                   */
/*  SIDE EFFECTS:                                                    */
/*                                                                   */
/*********************************************************************/
BOOL FAR  CnrDrawRecord( hwndCnr, hps, precord, flChangeZorder)
HANDLE        hwndCnr;
HDC           hps;
LPRECORDCOREN  precord;
BOOL          flChangeZorder;
{
  LPCNRINFON    pccinfon;
  LPCNRINFO     pccinfo;

  pccinfon = PCCINFONOF( hwndCnr );
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /********************************************************************/
  /* Check if record to be drawn is in tree view                      */
  /********************************************************************/
  if (pccinfo->flWindowAttr & CV_TREE)
  {
    POINT     slTreeIcon;
    POINT     slIcon;
    RECT      rctlIcon;
    RECT      rctlTreeIcon;
    RECT      rctlText;

    // If this branch of the tree isn't visible, don't draw and just return
    // success.
    if (!IsTreeVisible(precord))                                     /* D7931 */
       return (TRUE);                                                /* D7931 */

    CnrCalcIconSize( hwndCnr, &slIcon );
    CnrTRVCalcTreeIconSize( hwndCnr, &slTreeIcon);
    CnrTRVQueryIconTextRect(hwndCnr, precord, FALSE,
                            slIcon, slTreeIcon,
                            &rctlIcon, &rctlTreeIcon, &rctlText);
    CnrTRVDrawItem( hwndCnr, hps, precord,
                    rctlIcon, rctlTreeIcon, rctlText,
                    DE_ICON | DE_TREEICON | DE_TEXT);
  }
  /********************************************************************/
  /* If not, check if record to be drawn is in icon view              */
  /********************************************************************/
  else if (pccinfo->flWindowAttr & CV_ICON)
  {
    if (!(CnrDrawIcon( hwndCnr, hps, precord, flChangeZorder)))
    {
      return (FALSE);
    }
  }
  /********************************************************************/
  /* If not, check if record to be drawn is in name or text view      */
  /********************************************************************/
  else if (pccinfo->flWindowAttr & (CV_NAME | CV_TEXT))
  {
    /******************************************************************/
    /* This is drawing, so set flag blIsDraw as TRUE                  */
    /******************************************************************/
    if (!(CnrDrawEraseNameText( hwndCnr, hps, precord, TRUE)))
    {
      return (FALSE);
    }
  }

  return (TRUE);
}

/*********************************************************************/
/*                                                                   */
/*  FUNCTION NAME:  CnrEraseRecord                                   */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  DESCRIPTIVE NAME:  Container Control Erase Name                  */
/*                                                                   */
/*  FUNCTIONAL DESCRIPTION:  This function erase the specific Record */
/*     in the current view by calling CnrEraseXxxx.                  */
/*                                                                   */
/*  NOTES:                                                           */
/*     FORWARD DECLARATION:                                          */
/*                                                                   */
/*  INPUT:  HANDLE hwndCnr - handle to the container window          */
/*          LPCNRINFON pccinfon - pointer to internal container       */
/*                                 data structure                    */
/*          LPRECORDCORE pRecord - pointer to the record structure    */
/*                                                                   */
/*  OUTPUT:                                                          */
/*                                                                   */
/*                                                                   */
/*  EXIT-NORMAL:                                                     */
/*                                                                   */
/*  EXIT-ERROR:                                                      */
/*                                                                   */
/*  SIDE EFFECTS:                                                    */
/*********************************************************************/

BOOL FAR  CnrEraseRecord( hwndCnr, hps, precord)
HANDLE        hwndCnr;
HDC           hps;
LPRECORDCOREN  precord;
{
  LPCNRINFON    pccinfon;
  LPCNRINFO     pccinfo;

  pccinfon = PCCINFONOF (hwndCnr);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /********************************************************************/
  /* Check if record to be drawn is in tree view                      */
  /********************************************************************/
  if (pccinfo->flWindowAttr & CV_TREE)
  {
    POINT     slTreeIcon;
    POINT     slIcon;
    RECT      rctlIcon;
    RECT      rctlTreeIcon;
    RECT      rctlText;

    CnrCalcIconSize (hwndCnr, &slIcon);
    CnrTRVCalcTreeIconSize (hwndCnr, &slTreeIcon);
    CnrTRVQueryIconTextRect (hwndCnr, precord, FALSE,
                             slIcon, slTreeIcon,
                             &rctlIcon, &rctlTreeIcon, &rctlText);
    CnrTRVEraseItem (hwndCnr, hps, precord,
                     rctlIcon, rctlTreeIcon, rctlText,
                     DE_ICON | DE_TREEICON | DE_TEXT);
  }
  else if (pccinfo->flWindowAttr & CV_ICON)
  {
    /******************************************************************/
    /* Set the last parameter as TRUE because we want to redraw       */
    /* the items below the erased item.                               */
    /******************************************************************/
    CnrEraseIcon (hwndCnr, hps, precord, TRUE);
  }
  else if (pccinfo->flWindowAttr & (CV_NAME | CV_TEXT))
  {
    /******************************************************************/
    /* This is not drawing, so set flag blIsDraw as FALSE             */
    /******************************************************************/
    if (!(CnrDrawEraseNameText (hwndCnr, hps, precord, FALSE)))
    {
      return (FALSE);
    }
  }
  else if (pccinfo->flWindowAttr & CV_DETAIL)
  {
    /******************************************************************/
    /* Erase the row specified by precord in Details View.            */
    /******************************************************************/
    if (!(CnrDrawEraseRow (hwndCnr, precord, FALSE)))
    {
      return (FALSE);
    }
  }

  return (TRUE);
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:  CnrOpenTitleTextMLE                              */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Open Title Text MLE                          */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function opens the Title Text MLE with proper size.      */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd - handle of the container window.                  */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
HWND FAR CnrOpenTitleTextMLE(HWND hwnd)                                 /*DAB1*/

{
  HWND       hwndParent;                                                /*DAB1*/
  HWND       hwndMLE;                                                   /*DAB1*/
  HDC        hps;
  LPCNRINFON  pccinfon;
  LPCNRINFO   pccinfo;
  RECT       rctlTitle;
  RECT       rctlClient;
  RECT       rctlHScroll;
  RECT       rctlVScroll;
  MLEINFO    mleInfo;

  /*******************************************************************/
  /* Get containr window (parent of the title window )               */
  /*******************************************************************/
  hwndParent = PARENTOF (hwnd);
  pccinfon = (LPCNRINFON)GetWindowLong(hwndParent, QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /*******************************************************************/
  /* If in edit mode, save the text  and close MLE                   */
  /*******************************************************************/
  if (pccinfon->ulFlagSet & FL_EDITMODE)
  {
    if (!(CnrSaveTextCloseMLE(hwndParent)))
    {
       return ((HWND)NULL);                                             /*DAB1*/
    }
  } /* endif */

  if (!(GetWindowLong(hwndParent, GWL_STYLE) & CCS_READONLY) &&
      !(pccinfo->flWindowAttr & CA_TITLEREADONLY) )
  {
    pccinfon->preccEdit = NULL;
    pccinfon->hwndEdit = hwnd;
    pccinfon->pFIEdit = NULL;
    pccinfon->ulFlagSet |= FL_EDITMODE;

    pccinfon->ceData.ppszText = &(pccinfo->pszCnrTitle);
    pccinfon->ceData.cbText = 0;
    pccinfon->ceData.pRecord = NULL;
    pccinfon->ceData.hwndCnr = hwndParent;
    pccinfon->ceData.pFieldInfo = NULL;
    // we probably only need to do this sizeof once
    pccinfon->ceData.cb = sizeof(CNREDITDATA);
    pccinfon->ceData.id = IDOF (hwnd);

    hps = PMGetFlippedDC(hwnd);

    /*****************************************************************/
    /* Get viewport rect and  H scroll bar rect.                     */
    /* left-bottom point is (0, 0)                                   */
    /*****************************************************************/
    CnrQuerySizeRect(hwndParent, NULL, NULL, &rctlClient, &rctlVScroll,
                     &rctlHScroll) ;

    /*****************************************************************/
    /* Get title text rectangle by calling CnrQueryTitleTextRect     */
    /* which is relative to the origin of the Title Window           */
    /*****************************************************************/
    CnrQueryTitleTextRect(hwnd, hps, &rctlTitle);

    if ((!pccinfo->pszCnrTitle) || (*pccinfo->pszCnrTitle =='\0'))
    {
      CnrQueryFontMetrics( hwndParent, hwnd, FALSE, NULL, NULL );

      rctlTitle.bottom = rctlTitle.top + GETCYCHAR(pccinfon);

      if (pccinfo->flWindowAttr & CA_TITLELEFT)
      {
          rctlTitle.right = rctlTitle.right +
                            10 * pccinfon->lAveCharWidth;

      }
      else
      {
        if (pccinfo->flWindowAttr & CA_TITLERIGHT)
        {
          rctlTitle.left = rctlTitle.left -
                            10 * pccinfon->lAveCharWidth;

        }
        else
        {
          rctlTitle.left = rctlTitle.left -
                            5 * pccinfon->lAveCharWidth;
          rctlTitle.right = rctlTitle.right +
                            5 * pccinfon->lAveCharWidth;

        } /* endif */
      }
    } /* endif */

    ReleaseDC(hwnd, hps);

    /******************************************************************/
    /* Because the MLE is the way it is, get the fontmetrics          */
    /* for the DeskTop.                                               */
    /******************************************************************/
    CnrQueryFontMetrics( hwndParent, NULL, TRUE, &mleInfo, NULL );

    rctlTitle.left -= mleInfo.lAveCharWidth / 2;
    rctlTitle.right += mleInfo.lAveCharWidth / 2 + TXT_SIDEMARGIN;
    rctlTitle.bottom +=  (int)mleInfo.lMaxBaselineExt / 4;
    rctlTitle.top -=  (int)mleInfo.lMaxBaselineExt / 2;

    rctlTitle.left = max(rctlClient.left, rctlTitle.left);
    rctlTitle.right = min((rctlClient.right + rctlHScroll.right),
                           rctlTitle.right);


    /*****************************************************************/
    /* Create MLE by calling CnrCreateMLE(in cnrcfunc.c)             */
    /* usGeneration(last parameter) is 2 because title window is     */
    /* child of the container window.                                */
    /*****************************************************************/
    hwndMLE = CnrCreateMLE(hwnd, pccinfo->pszCnrTitle, rctlTitle, 2);
  }

  return hwndMLE;
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:  CnrOpenRecordTextMLE                             */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Open Record Text MLE                         */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function opens the Title Text MLE with proper size.      */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd - handle of the container window.                  */
/*           mp1                                                     */
/*           mp2                                                     */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
HWND FAR  CnrOpenRecordTextMLE(hwnd, mp1)
HWND      hwnd;
long      mp1;

{
  LPRECORDCOREN preccObj;           /* record to be edited       */

  if (!(GetWindowLong(hwnd, GWL_STYLE) & CCS_READONLY))
  {
    /*****************************************************************/
    /* Get the record under the pointer.                             */
    /*****************************************************************/
    preccObj = CnrOverRecord(hwnd, LOWORD(mp1), HIWORD(mp1));
    OpenRecordTextMLE(hwnd, preccObj);
  } /* endif */

  return NULL;

}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:  OpenRecordTextMLE                                */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Open Record Text MLE                         */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function opens the Title Text MLE with proper size.      */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd - handle of the container window.                  */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
HWND FAR OpenRecordTextMLE(hwnd, preccEdit)
HWND           hwnd;
LPRECORDCOREN  preccEdit;

{
  HWND        hwndMLE;
  long        cyChar;
  LPCNRINFON   pccinfon;
  LPCNRINFO    pccinfo;
  LPSTR       pszText;             /* text string               */
  RECT        rctlText;            /*rectangle of the text      */
  RECT        rctlClient;
  POINT       iconSize;            /* size of the icon          */
  MLEINFO     mleInfo;
  POINT       slTreeIcon;

  pccinfon = (LPCNRINFON)GetWindowLong(hwnd, QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  /*****************************************************************/
  /* If there is an item.....                                      */
  /*****************************************************************/
  if (preccEdit && !(preccEdit->flRecordAttr & CRA_RECORDREADONLY))
  {
    pccinfon->preccEdit = preccEdit;
    pccinfon->hwndEdit = hwnd;
    pccinfon->ulFlagSet |= FL_EDITMODE;

    /***************************************************************/
    /* Get viewport rect and  H scroll bar rect.                   */
    /* left-bottom point is (0, 0)                                 */
    /***************************************************************/
    CnrQuerySizeRect( hwnd, &iconSize, NULL, &rctlClient, NULL,
                      NULL );

    if (pccinfo->flWindowAttr & CV_TREE)
    {
      CnrTRVCalcTreeIconSize(hwnd, &slTreeIcon);
      CnrTRVQueryIconTextRect(hwnd, preccEdit, TRUE, iconSize,
                              slTreeIcon, NULL, NULL,
                              &rctlText);
    }
    else
    {
      CnrQueryIconTextRect(hwnd, preccEdit, &iconSize, FALSE,
                           NULL, &rctlText);
    }

    cyChar = GETCYCHAR(pccinfon);
    rctlText.bottom = max(rctlText.bottom,
                           (rctlText.top + cyChar));

    /***************************************************************/
    /* Get the proper size of MLE.                                 */
    /***************************************************************/
    CnrQueryFontMetrics (hwnd, NULL, TRUE, &mleInfo, NULL);

    rctlText.left -= mleInfo.lAveCharWidth / 2;
    rctlText.right += mleInfo.lAveCharWidth / 2 +
                       TXT_SIDEMARGIN;
    rctlText.bottom += mleInfo.lMaxBaselineExt / 6;
    rctlText.top -= mleInfo.lMaxBaselineExt / 6;

    rctlText.right = min(rctlClient.right, rctlText.right);
    rctlText.left = max(rctlClient.left, rctlText.left);

    /******************************************************************/
    /* Check if we are working with a full size record                */
    /******************************************************************/
    if (preccEdit->preccX->cb == sizeof(RECORDCORE))
    {
      /****************************************************************/
      /* If so, then check if we are editing title from the tree view */
      /****************************************************************/
      if (pccinfo->flWindowAttr & CV_TREE)
      {
        pszText = GETLPSTRFORTRV(preccEdit->preccX);
        pccinfon->ceData.ppszText =
                         &(pccinfon->preccEdit->preccX->pszTree);
      }
      /****************************************************************/
      /* If so, then check if we are editing title from the icon view */
      /****************************************************************/
      else if (pccinfo->flWindowAttr & CV_ICON)
      {
        pszText = preccEdit->preccX->pszIcon;
        pccinfon->ceData.ppszText =
                         &(pccinfon->preccEdit->preccX->pszIcon);
      }
      /****************************************************************/
      /* If not, then check if we are editing title from the name view*/
      /****************************************************************/
      else if (pccinfo->flWindowAttr & CV_NAME)
      {
        pszText = GETLPSTRFORNV(preccEdit->preccX);
        pccinfon->ceData.ppszText =
                         &(pccinfon->preccEdit->preccX->pszName);
      }
      /****************************************************************/
      /* If not, then check if we are editing title from the text view*/
      /****************************************************************/
      else if (pccinfo->flWindowAttr & CV_TEXT)
      {
        pszText = GETLPSTRFORTV(preccEdit->preccX);
        pccinfon->ceData.ppszText =
                         &(pccinfon->preccEdit->preccX->pszText);
      }
    }
    /******************************************************************/
    /* otherwise if small record, default to use icon text only       */
    /******************************************************************/
    else
    {
      pszText = preccEdit->preccX->pszIcon;
      pccinfon->ceData.ppszText =
                       &(pccinfon->preccEdit->preccX->pszIcon);
    }

    pccinfon->ceData.cbText = 0;
    COPYNDATATOX(preccEdit);
    pccinfon->ceData.pRecord = preccEdit->preccX;
    pccinfon->ceData.hwndCnr = hwnd;
    pccinfon->ceData.pFieldInfo = NULL;
    // we probably only need to do this sizeof once
    pccinfon->ceData.cb = sizeof(CNREDITDATA);
    pccinfon->ceData.id = IDOF (hwnd);

    /*****************************************************************/
    /* Create MLE by calling CnrCreateMLE(in cnrcfunc.c)             */
    /* usGeneration(last parameter) is 1 because this is the         */
    /* container window itself                                       */
    /*****************************************************************/
    hwndMLE = CnrCreateMLE(hwnd, pszText, rctlText, 1);
    return hwndMLE;
  }

  return NULL;
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:     CnrPaintCnrTitleWin                           */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Paint Cnr Title Window                       */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function gets proper rectangle for the title             */
/*     string, and draw the title inside the rectangle by            */
/*     IcnDrawText                                                   */
/*                                                                   */
/*                                                                   */
/*  Notes:                                                           */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd    - container control handle                      */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
VOID FAR  CnrPaintCnrTitleWin(HANDLE hwnd)
{
  HDC             hps;
  HANDLE          hwndParent;        /* handle of the parent window */
  OWNERBACKGROUND ownerBack;
  LPCNRINFON      pccinfon;
  LPCNRINFO       pccinfo;
  PAINTSTRUCT     paintStruct;       /* paint structure */
  RECT            rctInvalid;
  RECT            rctlTitle;         /* rectangle of the title text */
  DWORD           ulTextStyle;       /* style of the text: one of */
                                     /* IS_BENEATHTEXT (centered ) */
                                     /* IS_SIDETEXT (left-justified */
                                     /* IS_SIDERIGHTTEXT (right-justified */

  /*******************************************************************/
  /* Get containr window (parent of the title window )               */
  /*******************************************************************/
  hwndParent = PARENTOF (hwnd);

  pccinfon = (LPCNRINFON)GetWindowLong(hwndParent, QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  hps = BeginPaint(hwnd, (LPPAINTSTRUCT)&paintStruct);

  /*******************************************************************/
  /* Paint only when title window exists.                            */
  /*******************************************************************/
  if (pccinfo->flWindowAttr & CA_CONTAINERTITLE)
  {
    GetClientRect(hwnd, &rctInvalid);

    /*****************************************************************/
    /* Clean up whole window for new painting.                       */
    /*****************************************************************/
    ownerBack.hwnd = hwnd;
    ownerBack.hps = hps;
    ownerBack.rclBackground = paintStruct.rcPaint;
    ownerBack.idWindow = getWindowId(hwnd);                             /*DAB1*/

    if (!(pccinfo->flWindowAttr & CA_OWNERPAINTBACKGROUND) ||
        !(SENDMESSAGE( hwndParent, CM_PAINTBACKGROUND,                  /*DAB1*/
                       (DWORD)((LPOWNERBACKGROUND)&ownerBack), 0)))     /*DAB3*/
    {
      CnrPaintBackground (hwndParent, hps, &rctInvalid);
    }

    /*****************************************************************/
    /* Get title text rectangle by calling CnrQueryTitleTextRect     */
    /* (in cnrcfunc.c)                                               */
    /*****************************************************************/
    CnrQueryTitleTextRect(hwnd, hps, &rctlTitle);

    /*****************************************************************/
    /* Get text style.                                               */
    /*****************************************************************/
    if (pccinfo->flWindowAttr & CA_TITLECENTER)
    {
      ulTextStyle = IS_BENEATHTEXT;
    }
    else
    {
      if (pccinfo->flWindowAttr & CA_TITLELEFT)
      {
        ulTextStyle = IS_SIDETEXT;
      }
      else
      {
        if (pccinfo->flWindowAttr & CA_TITLERIGHT)
        {
          ulTextStyle = IS_SIDERIGHTTEXT;
        }
        else
        {
          ulTextStyle = IS_BENEATHTEXT;
        }
      }
    }

    /*****************************************************************/
    /* Draw the title inside the title rectangle                     */
    /* (IcnDrawText   is in cnriconc.c)                              */
    /*****************************************************************/
    IcnDrawText (hps, pccinfo->pszCnrTitle, rctlTitle,
                  0L, ulTextStyle, pccinfon);

    /*****************************************************************/
    /* If CA_TITLESEPARATOR is specified, draw the separator.        */
    /* (DrawSeparator is in cnrcfunc.c)                              */
    /*****************************************************************/
    if (pccinfo->flWindowAttr & CA_TITLESEPARATOR)
    {
      DrawSeparator(hps, &(rctInvalid), pccinfon);
    }
  }

  EndPaint (hwnd, (LPPAINTSTRUCT)&paintStruct);
  return;
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:     CnrQueryClientRect                            */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Control Query Viewport Rect                  */
/*                                                                   */
/*  Functional Description: This function calculates the rectangle   */
/*     the viewport of the Cnr window.                               */
/*     Origin of the rectangle is (0,0)                              */
/*                                                                   */
/*  Notes:                                                           */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd    - container control handle                      */
/*           LPRECT - pointer to the Viewport rectangle              */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
VOID FAR CnrQueryClientRect(hwnd, prctlViewport)

HANDLE       hwnd;
LPRECT     prctlViewport;
{
  RECT     rctlLTitle;
  RECT     rctlVScroll;
  RECT     rctlHScroll;

  PMGetClientRect( hwnd, prctlViewport);

  /*******************************************************************/
  /* When query rectangle top-left point is always (0, 0)            */
  /*******************************************************************/
  CnrQueryScrollBarRect(hwnd, &rctlVScroll, &rctlHScroll);
  CnrQueryTitleRect(hwnd, &rctlLTitle, NULL);

  /*******************************************************************/
  /* Get real client area by subtracting title, scroll bars area     */
  /* Still top-left point is (0, 0)                                  */
  /*******************************************************************/
  prctlViewport->right -= rctlVScroll.right;
  prctlViewport->bottom -= (rctlLTitle.bottom + rctlHScroll.bottom);

  return;

}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:     CnrQueryIconTextRect                          */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Control Query Title Rect                     */
/*                                                                   */
/*  Functional Description: This function calculates the rectangles  */
/*     of the icon and text if they are specified as parameters.     */
/*     Icon rectangle includes the maximum emph space if flIncEmph   */
/*     is set as TRUE. And the rectangle is relative to the origin   */
/*     of the Cnr window.                                            */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:  long CnrDrawTargetEmph(                 */
/*                               HANDLE       hwnd                   */
/*                               LPRECT     prctlLTitle              */
/*                               LPRECT     prctlCTitle              */
/*                               )                                   */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd    - container control handle                      */
/*           precord - pointer to the record                         */
/*           flIncEmph - flag to ask if include emph space in icon   */
/*                       rect                                        */
/*           prctl - pointer to the Icon rectangle                   */
/*           prctl - pointer to the text rectangle                   */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
VOID FAR  CnrQueryIconTextRect(hwnd, precord, piconSize, flIncEmph,
                         prctlIcon, prctlText)
HANDLE       hwnd;
LPRECORDCOREN precord;
LPPOINT      piconSize;
BOOL         flIncEmph;          /* ask if icon rect include emph space */
LPRECT       prctlIcon;
LPRECT       prctlText;
{
  LPCNRINFON   pccinfon;
  LPCNRINFO    pccinfo;
  POINT        ptlOrigin;          /* origin of the window relative to */
                                   /* the workplace */
  POINT        ptlRecord;          /* position of the record relative */
                                   /* to the workplace */
  SIZEL        textSize;           /* size of the text */

  /*******************************************************************/
  /* Get pointer to locals                                           */
  /*******************************************************************/
  pccinfon = PCCINFONOF (hwnd);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  if (!(pccinfo->flWindowAttr & CV_TEXT))
  {
    /*****************************************************************/
    /* If the pointer to the icon rect is given get icon rect        */
    /*****************************************************************/
    if (prctlIcon)
    {
      if (pccinfo->flWindowAttr & CV_ICON)
      {
        ptlOrigin = pccinfo->ptlOrigin;
        ptlRecord = precord->ptlIcon;
      }
      else
      {
        if (pccinfo->flWindowAttr & CV_NAME)
        {
          ptlOrigin = pccinfon->ptlNonIconOrg;
          ptlRecord = precord->ptlNonIconPos;
        }
      }

      /***************************************************************/
      /* Calculate icon rectl which is relative to the window origin.*/
      /***************************************************************/
      prctlIcon->left = ptlRecord.x - ptlOrigin.x;
      prctlIcon->top = ptlRecord.y - ptlOrigin.y;
      prctlIcon->right = prctlIcon->left + piconSize->x;
      prctlIcon->bottom = prctlIcon->top + piconSize->y;

      if (flIncEmph)
      {
        /*************************************************************/
        /* Calculate icon rectangle including selection space.       */
        /*************************************************************/
        prctlIcon->left -= ICN_EMPHSPACE;
        prctlIcon->bottom += ICN_EMPHSPACE;
        prctlIcon->right += ICN_EMPHSPACE;
        prctlIcon->top -= ICN_EMPHSPACE;
      }
    }
  }


  /********************************************************************/
  /* if pointer to the text rect is given get the value               */
  /********************************************************************/
  if (prctlText)
  {
    textSize = precord->slTextSize;

    /******************************************************************/
    /* If current view is icon                                        */
    /******************************************************************/
    if (pccinfo->flWindowAttr & CV_ICON)
    {
      ptlOrigin = pccinfo->ptlOrigin;

      /****************************************************************/
      /* Position of the record is position of the icon. So, we need  */
      /* adjust to center the text relative to the icon.              */
      /*           ____           a:from left of the icon to the      */
      /*          |    |            left of the text (textSize.x -    */
      /*    |< a >|____|            piconSize->x + TXT_SIDEMAGGIN)/2  */
      /*    ________b_________    b:the space between text and icon   */
      /*    |________________| c    lExternalLeading + ICN_EMPHSPACE  */
      /*            d               + TXT_TOPMARGIN                   */
      /*      c: textSize.y                                           */
      /*      d: textSize.x                                           */
      /****************************************************************/
      prctlText->left = precord->ptlIcon.x - ptlOrigin.x -
                        ((textSize.cx - piconSize->x +                  /*DAB1*/
                             TXT_SIDEMARGIN) / 2);
      prctlText->right = (prctlText->left + textSize.cx);               /*DAB1*/
      prctlText->top = precord->ptlIcon.y - ptlOrigin.y +
                       piconSize->y +
                       pccinfon->lExternalLeading +
                       ICN_EMPHSPACE + TXT_TOPMARGIN;
      prctlText->bottom = (prctlText->top + textSize.cy +               /*DAB1*/
                          TXT_BTMMARGIN);

    }
    /*****************************************************************/
    /* Otherwise current view is not icon                            */
    /*****************************************************************/
    else
    {
      ptlOrigin = pccinfon->ptlNonIconOrg;

      /****************************************************************/
      /* If current view is name view                                 */
      /****************************************************************/
      if (pccinfo->flWindowAttr & CV_NAME)
      {
        /**************************************************************/
        /* Position of the record is position of the icon. So, we need*/
        /* adjust to center the text relative to the icon.            */
        /*  ______           a:from Bottom of the icon to the bottom  */
        /* |      |  _____d_____    of the text (iconSize.y -        */
        /* |      | b|_________|c   textSize.y/2                     */
        /* |______|   a             b:the space between text and icon*/
        /*                            lAveCharWidth                   */
        /*      c: textSize.y                                        */
        /*      d: textSize.x                                        */
        /**************************************************************/
        prctlText->left = precord->ptlNonIconPos.x - ptlOrigin.x +
                          piconSize->x + pccinfon->lAveCharWidth;
        prctlText->right = prctlText->left +
                           precord->usLongestLine;
        prctlText->top = precord->ptlNonIconPos.y - ptlOrigin.y -
                         ((textSize.cy - piconSize->y) / 2);            /*DAB1*/
        prctlText->bottom = (prctlText->top + textSize.cy);             /*DAB1*/
      }
      /****************************************************************/
      /* otherwise if current view is text view                       */
      /****************************************************************/
      else if (pccinfo->flWindowAttr & CV_TEXT)
      {
        /**************************************************************/
        /* In text view position of the record is the origin of the   */
        /* text rectangle. Make the pos to be relative to the         */
        /* Cnr window by subtractin ptlOrigin                         */
        /**************************************************************/
        prctlText->left   = precord->ptlNonIconPos.x - ptlOrigin.x;
        prctlText->right  = prctlText->left + precord->usLongestLine;
        prctlText->top    = precord->ptlNonIconPos.y -
                            ptlOrigin.y;
        prctlText->bottom = (prctlText->top + textSize.cy);             /*DAB1*/
      }
    }
  }

  return;
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:     CnrQueryScrollBarRect                         */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Control Query Scroll Bar Rect                */
/*                                                                   */
/*  Functional Description: This function queries the rectangle      */
/*     of the scroll bars specified as parameters.                   */
/*     Origin of the rectangle is (0,0)                              */
/*                                                                   */
/*  Notes:                                                           */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd    - container control handle                      */
/*           LPRECT - pointer to the V scroll bar rectangle          */
/*           LPRECT - pointer to the H scroll bar rectangle          */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
VOID FAR  CnrQueryScrollBarRect(hwnd, prctlVScroll, prctlHScroll)

HANDLE     hwnd;
LPRECT     prctlVScroll;
LPRECT     prctlHScroll;
{
  HANDLE       hwndVScroll;
  HANDLE       hwndHScroll;

  /*******************************************************************/
  /* If pointer to the the rectangle of the vertical scroll bar is   */
  /* specified, then, query the rectangle.                           */
  /*******************************************************************/
  if (prctlVScroll)
  {
    hwndVScroll = GetDlgItem(hwnd, CID_VSCROLL);
    PMGetClientRect( hwndVScroll, prctlVScroll );
  }

  /*******************************************************************/
  /* If pointer to the the rectangle of the H scroll bar is          */
  /* specified, then, query the rectangle.                           */
  /*******************************************************************/
  if (prctlHScroll)
  {
    hwndHScroll = GetDlgItem(hwnd, CID_HSCROLL);
    PMGetClientRect( hwndHScroll, prctlHScroll );
  }

  return;
}

/* ********************************************************************/
/*                                                                    */
/*  Function Name:     CnrQueryTitleRect                              */
/*                                                                    */
/*  Usage: External                                                   */
/*                                                                    */
/*  Descriptive Name:   Control Query Title Rect                      */
/*                                                                    */
/*  Functional Description:  This function queries the rectangles     */
/*     of the titles (list title/ column titles). Query only if       */
/*     there are/is pointer(s) to the rectangle(s) as parameters      */
/*     Origin of the rectangle is (0,0)                               */
/*                                                                    */
/*  Notes:                                                            */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*  Input:   hwnd    - container control handle                       */
/*           LPRECT - pointer to the List title rectangle             */
/*           LPRECT - pointer to the Column title rectangle           */
/*                                                                    */
/*  Output:                                                           */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*  Exit-Normal:                                                      */
/*                                                                    */
/*  Exit-Error:                                                       */
/*                                                                    */
/*  Side Effects:                                                     */
/*                                                                    */
/**********************************************************************/
VOID FAR  CnrQueryTitleRect(hwnd, prctlLTitle, prctlCTitle)

HANDLE     hwnd;
LPRECT     prctlLTitle;
LPRECT     prctlCTitle;
{
  HANDLE       hwndLTitle;
  HANDLE       hwndCTitle;

  /*******************************************************************/
  /* If pointer to the the rectangle of the list title is            */
  /* specified, then, query the rectangle.                           */
  /*******************************************************************/
  if (prctlLTitle)
  {
    hwndLTitle = GetDlgItem(hwnd, CID_CNRTITLEWND);
    PMGetClientRect( hwndLTitle, prctlLTitle );
  }

  /*******************************************************************/
  /* If pointer to the the rectangle of the column title  is         */
  /* specified, then, query the rectangle.                           */
  /*******************************************************************/
  if (prctlCTitle)
  {
    if (hwndCTitle = GetDlgItem(hwnd, CID_LEFTCOLTITLEWND))
    {
      PMGetClientRect (hwndCTitle, prctlCTitle);
    }
    else
    {
      prctlCTitle->left = 0;
      prctlCTitle->right = 0;
      prctlCTitle->bottom = 0;
      prctlCTitle->top = 0;
    }
  }

  return;
}

/*********************************************************************/
/*                                                                   */
/* FUNCTION NAME:  CnrQuerySizeRect                                  */
/*                                                                   */
/* Usage: External                                                   */
/*                                                                   */
/* DESCRIPTIVE NAME:  Container Common Function Calculate Icon Size  */
/*                                                                   */
/* FUNCTIONAL DESCRIPTION:  This function quries most of the useful  */
/*   rectangles and icon size if they are specified as the           */
/*   parameters                                                      */
/*                                                                   */
/* NOTES:                                                            */
/*    FORWARD DECLARATION:                                           */
/*                                                                   */
/* INPUT:  HANDLE hwndCnr - handle of the window                     */
/*         LPPOINT piconSize - pointer to the icon size structure   */
/*         LPRECT prctlLTitle - pointer to the list title rect       */
/*         LPRECT prctlViewport - pointer to the viewport rect       */
/*         LPRECT prctlVscroll - pointer to the V scroll bar         */
/*         LPRECT prctlHscroll - pointer to the H scroll bar         */
/*                                                                   */
/* OUTPUT:                                                           */
/*                                                                   */
/*                                                                   */
/* EXIT-NORMAL:                                                      */
/*                                                                   */
/* EXIT-ERROR:                                                       */
/*                                                                   */
/* SIDE EFFECTS:                                                     */
/*                                                                   */
/*********************************************************************/
VOID FAR  CnrQuerySizeRect(hwndCnr, piconSize, prctlLTitle,
                           prctlViewport, prctlVscroll, prctlHscroll)
HANDLE       hwndCnr;
LPPOINT      piconSize;
LPRECT       prctlLTitle;
LPRECT       prctlViewport;
LPRECT       prctlVscroll;
LPRECT       prctlHscroll;
{
  if (piconSize)
  {
    /*****************************************************************/
    /* Set icon dimensions.                                          */
    /*****************************************************************/
    CnrCalcIconSize( hwndCnr, piconSize );
  }

  if (prctlLTitle)
  {
    /*****************************************************************/
    /* Get List title box rectangle                                  */
    /*****************************************************************/
    CnrQueryTitleRect ( hwndCnr, prctlLTitle, NULL);
  }

  if (prctlViewport)
  {
    /*****************************************************************/
    /* Set viewport rect. left-top point is (0, 0)                   */
    /*****************************************************************/
    CnrQueryClientRect(hwndCnr, prctlViewport);
  }

  if (prctlVscroll || prctlHscroll)
  {
    /*****************************************************************/
    /* Query the scroll bar rectangles.                              */
    /*****************************************************************/
    CnrQueryScrollBarRect (hwndCnr, prctlVscroll, prctlHscroll);
  }

  return;

}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:     CnrQueryTitleTextRect                         */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Query Title Rectangle                        */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function calculates the rectangle of the title           */
/*     text relative to the origin of the Title window               */
/*                                                                   */
/*                                                                   */
/*  Notes:                                                           */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd    - container control handle                      */
/*           hps                                                     */
/*                                                                   */
/*  Output:  prctlTitle                                              */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
BOOL FAR CnrQueryTitleTextRect(HANDLE hwnd, HDC hps, LPRECT prctlTitle)
{
  HANDLE        hwndParent;        /* handle of the parent window */
  LPCNRINFON    pccinfon;
  LPCNRINFO     pccinfo;
  RECT          rctlWin;           /* rectangle of the wiindow */
  SIZEL         slTitle;           /* size of the title text */
  POINT         iconSize;          /* size of the icon */

  /*******************************************************************/
  /* Get container window (parent of the title window )              */
  /*******************************************************************/
  hwndParent = PARENTOF (hwnd);

  pccinfon = (LPCNRINFON)GetWindowLong(hwndParent, QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  PMGetClientRect(hwnd, &rctlWin);

  /*******************************************************************/
  /* No icon exists in the title. So, initialize as (0,0)            */
  /*******************************************************************/
  iconSize.x = 0;
  iconSize.y = 0;

  /*******************************************************************/
  /* Calculate text size.  No icon exists in the title, so use       */
  /*  IS_SIDETEXT to calculate text size.                            */
  /*******************************************************************/
  IcnCalcTextSize (hps, iconSize, pccinfon, pccinfo->pszCnrTitle,
                   IS_SIDETEXT, &slTitle);

  /*******************************************************************/
  /* Calculate text rectangle in the title window.                   */
  /* Start painting TITLE_MARGIN below the top of the window.        */
  /* And because title window is properly sized, we don't need to    */
  /* worry about the bottom of the rectangle.(Set as bottommost)     */
  /*******************************************************************/
  prctlTitle->top = rctlWin.top + pccinfon->lAveCharWidth;
  prctlTitle->bottom = min(rctlWin.bottom,
                           (prctlTitle->top + slTitle.cy));             /*DAB1*/

  if ((pccinfo->flWindowAttr & CA_TITLELEFT) &&
      !(pccinfo->flWindowAttr & CA_TITLECENTER))
  {
    /*****************************************************************/
    /* Have the left margin (lAveCharWidth) for the left             */
    /* justified title.                                              */
    /*****************************************************************/
    prctlTitle->left = pccinfon->lAveCharWidth;
  }
  else if ((pccinfo->flWindowAttr & CA_TITLERIGHT) &&
           !(pccinfo->flWindowAttr & CA_TITLECENTER))
  {
    /*****************************************************************/
    /* Have the right margin (lAveCharWidth) for the right           */
    /* justified title.                                              */
    /* The left of the title rectangle should be on or               */
    /* right of the left boundary of the title window.               */
    /*****************************************************************/
    prctlTitle->left = max((int)pccinfon->lAveCharWidth,
                           (rctlWin.right - slTitle.cx -                /*DAB1*/
                                 pccinfon->lAveCharWidth));
  }
  else
  {
    /*****************************************************************/
    /* Title rectangle is centered.                                  */
    /* The left of the title rectangle should be on or               */
    /* right of the left boundary of the title window.               */
    /*****************************************************************/
    prctlTitle->left = max((int)pccinfon->lAveCharWidth,
       (rctlWin.left + ((rctlWin.right - slTitle.cx) / 2)));            /*DAB1*/
  }

  /*******************************************************************/
  /* right of Title rectangle is calculated.                         */
  /* The right of the title rectangle should be on or                */
  /* left of the right boundary of the title window.                 */
  /*******************************************************************/
  prctlTitle->right = min(rctlWin.right,
                         (prctlTitle->left + slTitle.cx));              /*DAB1*/

  return TRUE;
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:  CnrSaveTextCloseMLE                              */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   SubProc of MLE Proc For 1st Generation       */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function handles the msgs passed to the MLE              */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd - handle of the container window.                  */
/*           msg                                                     */
/*           mp1                                                     */
/*           mp2                                                     */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
BOOL FAR  CnrSaveTextCloseMLE(hwndCnr)
HANDLE       hwndCnr;

{
  HWND        hwndMLE;
  LPCNRINFON  pccinfon;
  LPCNRINFO   pccinfo;
  SIZEL       TextSize;
  HDC         hps;
  LPSTR       pszTemp;
//LPVOID      pSatPtr;

//pSatPtr = (LPVOID)GetWindowLong (hwndCnr, QWL_STORAGEPTR);
  pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  hwndMLE = GetDlgItem(hwndCnr,CID_MLE);

  /***************************************************************/
  /* Save the length of the new text in ceData. We need to add   */
  /* one because WinQuery... returns the length of the text that */
  /* doesn't include '\0'                                        */
  /***************************************************************/
  pccinfon->ceData.cbText = (WORD)GetWindowTextLength(hwndMLE) +
                            (WORD)1;
  pccinfon->ceData.pRecord = ((pccinfon->preccEdit) ?
                               pccinfon->preccEdit->preccX :
                               NULL);

  pccinfon->ceData.hwndCnr = hwndCnr;
  pccinfon->ceData.pFieldInfo = pccinfon->pFIEdit;
  pccinfon->ceData.cb = sizeof(CNREDITDATA);
  pccinfon->ceData.id = IDOF (pccinfon->hwndEdit);

//pszTemp = (LPSTR)StmAllocateStorage(pSatPtr,
  pszTemp = (LPSTR)GlobalAlloc( GPTR,                                   /*DAB1*/
                        (lstrlen(*(pccinfon->ceData.ppszText))+ 1) );
  lstrcpy(pszTemp, *(pccinfon->ceData.ppszText) );

  /***************************************************************/
  /* Send a notification msg with ceData so that the application */
  /* can resize the memory segment for the new text.             */
  /***************************************************************/
  if (NotifyOwner (hwndCnr, CN_REALLOCPSZ, (LPVOID)&pccinfon->ceData))
  {
     /***************************************************************/
     /* Copy new text into proper LPSTR.                            */
     /***************************************************************/
     GetWindowText(hwndMLE, *(pccinfon->ceData.ppszText),
                   pccinfon->ceData.cbText);

     if (pccinfon->ulFlagSet & FL_EDITMODE)
     {
       CnrCloseMLE(hwndCnr);
     }

     if ( !(lstrcmp(pszTemp, *(pccinfon->ceData.ppszText))) )
     {
//     StmFreeStorage(pSatPtr, (LPVOID)pszTemp);
       GlobalFree( (LPVOID)pszTemp );                                   /*DAB1*/
       return (TRUE);
     }
//   StmFreeStorage(pSatPtr, (LPVOID)pszTemp);
     GlobalFree( (LPVOID)pszTemp );                                     /*DAB1*/
  }
  else
  {
//   StmFreeStorage(pSatPtr, (LPVOID)pszTemp);
     GlobalFree( (LPVOID)pszTemp );                                     /*DAB1*/
     /***************************************************************/
     /* Re-adjust the CNREDITDATA.cbText field to the original      */
     /* text size since FALSE was returned from CN_REALLOCPSZ       */
     /***************************************************************/
     pccinfon->ceData.cbText =
               strlen(*(pccinfon->ceData.ppszText)) + 1;

     if (pccinfon->ulFlagSet & FL_EDITMODE)
     {
       CnrCloseMLE(hwndCnr);
     }

     return (TRUE);
  }

  /*******************************************************************/
  /* Record Specific, so need to invalidate all other views if       */
  /* there are others.                                               */
  /*******************************************************************/
  if (pccinfon->preccEdit || pccinfon->pFIEdit)
  {
    InvalidateForEdit (hwndCnr);
  }
  else
  {
    TextSize.cy = pccinfon->slCnrTitle.cy;                              /*DAB1*/
    /****************************************************************/
    /* Determine if the whole window needs to be updated, or just   */
    /* title window.  We do this by checking to see if the height   */
    /* of the text changed as a result of the direct edit.          */
    /****************************************************************/
    hps = PMGetFlippedDC(hwndCnr);
    CnrUpdateTitleSize(hwndCnr, hps);
    pccinfon->ulFlagSet2 |= FL2_TITLESIZECALC;

    ReleaseDC(hwndCnr, hps);

    /****************************************************************/
    /* If the text size is different from the title height, or the  */
    /* title was a NULL string, repaint everything.                 */
    /****************************************************************/
    if (TextSize.cy != pccinfon->slCnrTitle.cy)                         /*DAB1*/
    {
      /**************************************************************/
      /* Flags are off to reposition items and reset Title window   */
      /**************************************************************/
      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
        CnrInvalidateDetailFieldInfo (hwndCnr);
      }
      else
      {
        pccinfon->ulFlagSet &= ~( FL_CNRPOSITION | FL_SETCNRTITLE );
        PMInvalidateRect( hwndCnr, NULL, TRUE );
      }
    }
    else
    {
      PMInvalidateRect( GetDlgItem( hwndCnr, CID_CNRTITLEWND),
                         NULL, FALSE );
    }
  }

  return TRUE;
}

/* *******************************************************************/
/*                                                                   */
/*  Function Name:  InvalidateForEdit                                */
/*                                                                   */
/*  Descriptive Name:                                                */
/*                                                                   */
/*  Functional Description:                                          */
/*                                                                   */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*  Input:   hwnd - handle of the container window.                  */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
BOOL FAR InvalidateForEdit(HANDLE hwndCnr)
{
  LPCNRINFON   pccinfon;
  LPCNRINFO    pccinfo;

  pccinfon = (LPCNRINFON)GetWindowLong(hwndCnr, QWL_CONTAINER);
  pccinfo  = PCCINFOXFROMN(pccinfon);

  if (pccinfon->preccEdit)
  {
    InvalidateRecord (hwndCnr, &pccinfon->preccEdit,
                      1, (CMA_TEXTCHANGED | CMA_ERASE));
  }
  else
  {
    if (pccinfon->pFIEdit)
    {
      if (pccinfo->flWindowAttr & CV_DETAIL)
      {
        if ((CnrColTitleHeightChanged (hwndCnr)) ||
            (!(CnrAllColumnsFixedWidth (hwndCnr))))
        {
          CnrInvalidateDetailFieldInfo (hwndCnr);
        }
        else
        {
          pccinfon->ulFlagSet &= ~FL_POSITIONCOLTITLES;

          PMInvalidateRect (GetDlgItem (hwndCnr,
                             CID_LEFTCOLTITLEWND),
                             NULL, FALSE);


          if ((!(pccinfon->ulFlagSet & FL_UNSPLIT)) &&
              (CnrVerifyFieldInfoPtrs (hwndCnr,
                                       pccinfon->pFieldInfoLast,
                                       1)))
          {
            PMInvalidateRect (GetDlgItem (hwndCnr,
                               CID_RIGHTCOLTITLEWND),
                               NULL, FALSE);
          }
        }
      }
    }
  }
  return TRUE;
}

/*********************************************************************/
/*                                                                   */
/*  Function Name:  CnrSetDrawItem                                  */
/*                                                                   */
/*  Usage: External                                                  */
/*                                                                   */
/*  Descriptive Name:   Set DRAWITEMSTRUCT fields                    */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function sets the fields of DRAWITEMSTRUCT               */
/*                                                                   */
/*  Notes:                                                           */
/*     Forward Declaration:                                          */
/*                                                                   */
/*                                                                   */
/*  Input:   hwnd - handle of the specified container window.        */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
BOOL FAR CnrSetDrawItem (hwnd, hDC, lpDrawItem, Item)
HWND              hwnd;
HDC               hDC;
LPDRAWITEMSTRUCT  lpDrawItem;
int               Item;

{
  /*******************************************************************/
  /* Set the control type                                           */
  /*******************************************************************/
  lpDrawItem->CtlType = ODT_CONTAINER;

  /*******************************************************************/
  /* Identify the item being drawn                                   */
  /*******************************************************************/
  lpDrawItem->itemID = Item;

  /*******************************************************************/
  /* Reserved values not used by the container.                      */
  /*******************************************************************/
  lpDrawItem->itemAction = 0;
  lpDrawItem->itemState = 0;

  /*******************************************************************/
  /* Set the handle of the DrawItem as handle of the specified       */
  /* Container window.                                               */
  /*******************************************************************/
  lpDrawItem->hwndItem = hwnd;

  /*******************************************************************/
  /* Set lpDrawItem->hDC as the current hDC of the container.        */
  /*******************************************************************/
  lpDrawItem->hDC = hDC;

  /******************************************************************/
  /* The view specific information for the record can be obtained   */
  /* via lpDrawItem->itemData->pRecord->flRecordAttr.  (e.g. record */
  /* attributes)                                                    */
  /******************************************************************/
  return (TRUE);
}


/**********************************************************************/
/* Function: CnrQueryFontMetrics                                      */
/* Usage: Internal                                                    */
/* Descriptive Name: Query for the current Fontmetrics information    */
/* Functional Description: This routine will query for the pertinent  */
/*                         information about the current font in use  */
/*                         for painting/positioning in the container. */
/*                                                                    */
/* Inputs: hwndCnr  - handle of the container window.                 */
/*         hwndQuery - handle of the window to query fontmetrics of   */
/*         bDesktop - If TRUE, use HANDLE_DESKTOP for query and return  */
/*                    font information in pMLEInfo                    */
/*                    If FALSE, use hwndCnr for query and return      */
/*                    font information in pccinfon area               */
/*         pMLEInfo - pointer to font information for MLE processing  */
/*         pFattrs  - pointer to a font attribute structure           */
/*                    (If NULL, this is not filled in - used for MLE) */
/*                                                                    */
/* Output: If TRUE, query was successful and pccinfon updated with    */
/*           new font information                                     */
/**********************************************************************/
VOID FAR CnrQueryFontMetrics (HANDLE hwndCnr, HANDLE hwndQuery,
                   BOOL bDesktop, LPMLEINFO pMLEInfo, PFATTRS pFattrs)
{
  LPCNRINFON  pccinfon;
  HDC         hps;
  TEXTMETRIC  textMetrics;
  HANDLE      hwndDesktop;
  HFONT       hOldFont = NULL;        /* save old font */

  /********************************************************************/
  /* Get internal container information pointer                       */
  /********************************************************************/
  pccinfon = PCCINFONOF (hwndCnr);

  /********************************************************************/
  /* Get the hps to use for query                                     */
  /********************************************************************/
  if (bDesktop)
  {
    hwndDesktop = GetDesktopWindow ();                                  /*DAB1*/
    hps = PMGetFlippedDC (hwndDesktop);
  }
  else
    hps = PMGetFlippedDC (hwndQuery);

  /********************************************************************/
  /* Set the user specified font - If NULL use default (System)       */
  /********************************************************************/
  if (pccinfon->hCnrFont)
    hOldFont = SelectObject (hps, pccinfon->hCnrFont);

  /********************************************************************/
  /* Query for the text metrics information for the current hps       */
  /********************************************************************/
  GetTextMetrics (hps, (LPTEXTMETRIC)&textMetrics);

  /********************************************************************/
  /* Reset the old font if it was changed                             */
  /********************************************************************/
  if (hOldFont)
    SelectObject (hps, hOldFont);

  /********************************************************************/
  /* Fill in the information needed for positioning and painting into */
  /*  the internal data block (don't need entire fontmetrics block)   */
  /********************************************************************/
  if (bDesktop)
  {
    /******************************************************************/
    /* If desktop and mleinfo structure passed fill it                */
    /******************************************************************/
    if (pMLEInfo)
    {
      pMLEInfo->lAveCharWidth    = textMetrics.tmAveCharWidth;
      pMLEInfo->lMaxBaselineExt  = textMetrics.tmHeight;
    }
  }
  else
  {
    /******************************************************************/
    /* otherwise fill up the internal data area with font information */
    /******************************************************************/
    pccinfon->lAveCharWidth    = textMetrics.tmAveCharWidth;
    pccinfon->lMaxBaselineExt  = textMetrics.tmHeight;
    pccinfon->lMaxAscender     = textMetrics.tmAscent;
    pccinfon->lMaxDescender    = textMetrics.tmDescent;
    pccinfon->lExternalLeading = textMetrics.tmExternalLeading;
  }

  if (bDesktop)
  {
    ReleaseDC (hwndDesktop, hps);
  }
  else
  {
    ReleaseDC (hwndQuery, hps);
  }
  return;
}


/*********************************************************************/
/*                                                                   */
/*  Function Name:     DrawSeparator                                 */
/*                                                                   */
/*  Usage: Internal                                                  */
/*                                                                   */
/*  Descriptive Name:   Draw the Separator in Title Window           */
/*                                                                   */
/*  Functional Description:                                          */
/*     This function draws the separator.                            */
/*                                                                   */
/*                                                                   */
/*  Notes:                                                           */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Input:   hps          - presentation space handle                */
/*           prectlTitle  - pointer to title rect                    */
/*           pccinfon     - pointer to internal container Info       */
/*                                                                   */
/*  Output:                                                          */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*  Exit-Normal:                                                     */
/*                                                                   */
/*  Exit-Error:                                                      */
/*                                                                   */
/*  Side Effects:                                                    */
/*                                                                   */
/*********************************************************************/
VOID FAR DrawSeparator(HDC hps, LPRECT prectlTitle, LPCNRINFON pccinfon)
{
  POINT   ptl;
  HPEN    hpenOld;
  HPEN    hpenCurrent;
  int     nSavedDC;

  ptl.x = 0;
  ptl.y = prectlTitle->bottom - 1;
  MoveToEx (hps, ptl.x, ptl.y, NULL);                                   /*DAB1*/

  ptl.x = prectlTitle->right + 1;   /* add 1 to make point inclusive */
                                    /* for LineTo                    */

  /*******************************************************************/
  /* Save current PS attributes                                      */
  /*******************************************************************/
  if (!(nSavedDC = SaveDC (hps)))
    return;

  /*******************************************************************/
  /* Set the pencolor for the lines of the separator                 */
  /*******************************************************************/
  if (hpenCurrent = CreatePen (PS_SOLID, 1,
                          pccinfon->ulColorPPSupport[CMA_SEPARATORCOLOR]))
  {
    hpenOld = SelectObject (hps, hpenCurrent);

    /*****************************************************************/
    /* Draw a line from the first point to the second point.         */
    /*****************************************************************/
    LineTo (hps, ptl.x, ptl.y);

    /*****************************************************************/
    /* Select the old pen color and free resource.                   */
    /*****************************************************************/
    DeleteObject (SelectObject (hps, hpenOld));
  }

  /*******************************************************************/
  /* Restore the previous PS attributes                              */
  /*******************************************************************/
  RestoreDC (hps, nSavedDC);

  return;
}

/**********************************************************************/
/*                                                                    */
/* FUNCTION NAME:  CnrTitleProc                                       */
/*                                                                    */
/* USAGES : External                                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:  Container Control Title window Control Proc     */
/*                                                                    */
/* FUNCTIONAL DESCRIPTION:  This procedure will handle all messages   */
/*   for the title window   of the container.  Any messages that      */
/*   require special handling for the title window   will be handled  */
/*   here                                                             */
/*                                                                    */
/* NOTES:                                                             */
/*    FORWARD DECLARATION:                                            */
/*                                                                    */
/* INPUT:  HANDLE hwndCnr - window handle for the container.          */
/*         WORD   msg - message.                                      */
/*         WORD   wParam - message parameter 1.                       */
/*         DWORD  lParam - message parameter 2.                       */
/*                                                                    */
/* OUTPUT:                                                            */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL:                                                       */
/*                                                                    */
/* EXIT-ERROR:                                                        */
/*                                                                    */
/* SIDE EFFECTS:                                                      */
/*                                                                    */
/**********************************************************************/
LRESULT CALLBACK CnrTitleProc( HWND  hwnd, UINT msg, WPARAM wParam,     /*DAB1*/
                               LPARAM lParam )                          /*DAB1*/
{
  HWND         hwndCnr;                                                 /*DAB1*/
  LPCNRINFON   pccinfon;
  HCURSOR      hptrArrow;
//HCURSOR      hptrRet;

  hwndCnr = PARENTOF (hwnd);
  pccinfon = (LPCNRINFON)GetWindowLong (hwndCnr, QWL_CONTAINER);

  switch (msg)
  {
    case WM_CREATE:
      return (FALSE);

    case WM_LBUTTONDOWN:

      SetFocus (hwndCnr);

      /***************************************************************/
      /* If in edit mode, save the text  and close MLE               */
      /***************************************************************/
      if (pccinfon->ulFlagSet & FL_EDITMODE)
      {
         if (GetKeyState (VK_MENU) < 0)
         {
            CnrCloseMLE (hwndCnr);
            return ((long)TRUE);
         }
         else
         {
            if (!(CnrSaveTextCloseMLE(hwndCnr)))
            {
               return ((long)NULL);
            }
         }
      }
      else
      {
        if (GetKeyState (VK_MENU) < 0)
        {
          /***********************************************************/
          /* Open Multi Line Entry Field to edit the title text by   */
          /* calling CnrOpenTitleTextMLE (in cnrcfunc.c)             */
          /***********************************************************/
          if (!(CnrOpenTitleTextMLE(hwnd)))
          {
             return ((long)NULL);
          }
        } /* endif */
      } /* endif */

      return (FALSE);
      break;

    case WM_MBUTTONDBLCLK:
    case WM_RBUTTONDBLCLK:
      SetFocus (hwndCnr);
      return (FALSE);
      break;

    case WM_PAINT:
      /***************************************************************/
      /* Paint the title window. (CnrPaintTitleWin in cnrcfunc.c)    */
      /***************************************************************/
      CnrPaintCnrTitleWin(hwnd);
      return (FALSE);
      break;

    case WM_SIZE:
      PMInvalidateRect(hwnd, NULL, TRUE);
      return (FALSE);
      break;

    case WM_MOUSEMOVE:
      SENDMESSAGE( hwndCnr, WM_SETCURSOR, (WPARAM)hwndCnr,              /*DAB4*/
                   MAKELONG(HTCLIENT, WM_MOUSEMOVE) );                  /*DAB4*/
      return ((long)TRUE);

    case WM_RBUTTONUP:                                              /* D7144 */
      return (FALSE);

    default:
      return (DefWindowProc (hwnd, msg, wParam, lParam));
      break;
  }
  return ((long)TRUE);
}
