// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
#ifndef _CNRPRAGW_
#define _CNRPRAGW_

/* Revision: 05 1.3.2.3 source/ui/cclnt/cnr/cnrpragw.h, cclcnr, ioc.v400, 001006  */
#ifdef CNRREG_C
BOOL CnrIsRegistered( HANDLE hInstance , PREGDATA prdat );
int FAR PASCAL LibMain( HANDLE hInstance , WORD wDataSeg , WORD cbHeapSize , LPSTR lpszCmdLine );
#endif

#ifdef CNRS1P1_C
long FAR PASCAL CnrDetailsVCtlProc( HANDLE hwndCnr , WORD msg , WORD wParam , DWORD lParam );
BOOL FAR CnrDrawColumnTitlesLeft( HANDLE hwnd , HDC hps , RECT InvalidRect );
VOID FAR CnrCalcCellRectForDV( HANDLE hwndCnr , LPRECORDCOREN pRecord , LPFIELDINFO pFieldInfo , BOOL LeftWindow , BOOL ColumnTitleWnd , LPRECT CellRect );
VOID FAR CnrCalcRowRect( HANDLE hwndCnr , LPRECORDCOREN pRecord , BOOL LeftWindow , LPRECT RowRect );
VOID FAR CnrCalcSelectionRect( HANDLE hwndCnr , LPRECORDCOREN pRecord , LPFIELDINFO pFieldInfo , BOOL LeftWindow , LPRECT SelectionRect );
LPSTR FAR CnrBuildDateTimeString( int Field , LPSTR pszDateTime , LPSTR DateTimeSep , BOOL LeadingZero );
VOID FAR CnrCreateNLSDateString( HANDLE hwndCnr , LPCDATE pDate , LPSTR pszDate );
VOID FAR CnrCreateNLSTimeString( HANDLE hwndCnr , LPCTIME pTime , LPSTR pszTime );
VOID FAR CnrCalcRectForDV( HANDLE hwndCnr , LPRECORDCOREN pRecord , LPFIELDINFO pFieldInfo , SIZEL ItemSize , BOOL FirstColLeft , RECT CellRect , LPRECT ItemRect );
BOOL CnrCreateNLSNumberString( HWND hwndCnr , DWORD dwNumber , LPSTR lpNumber );
VOID FAR reverse( LPSTR psz );
VOID FAR CnrCalcRectForDVTitles( HANDLE hwndCnr , LPFIELDINFO pFieldInfo , SIZEL ItemSize , BOOL FirstColLeft , RECT CellRect , LPRECT ItemRect );
BOOL FAR CnrDrawColumnTitlesRight( HANDLE hwnd , HDC hps , RECT InvalidRect );
long FAR PASCAL CnrLeftColumnTitlesProc( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
long FAR PASCAL CnrRightColumnTitlesProc( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
BOOL FAR CnrAllColumnsFixedWidth( HANDLE hwndCnr );
BOOL FAR CnrColTitleHeightChanged( HANDLE hwndCnr );
VOID FAR CnrCalcColumnRect( HANDLE hwndCnr , LPFIELDINFO pFieldInfo , BOOL LeftWindow , LPRECT ColumnRect );
BOOL FAR CnrOpenColDataTextMLE( HANDLE hwndCnr , long xMousePos , long yMousePos , BOOL LeftWindow );
VOID FAR CnrOpenColTitleTextMLE( HANDLE hwndCnr , int xMousePos , int yMousePos , BOOL LeftWindow );
LPFIELDINFO FAR CnrOverColumn( HANDLE hwndCnr , long xMousePos , long yMousePos , BOOL LeftWindow );
BOOL OpenColDataTextMLE( HANDLE hwndCnr , LPRECORDCOREN pRecord , LPFIELDINFO pFieldInfo , BOOL LeftWindow );
BOOL OpenColTitleTextMLE( HANDLE hwndCnr , LPFIELDINFO pFieldInfo , BOOL LeftWindow );
#endif

#ifdef CNRS1P2_C
VOID FAR CnrQueryColumnTitleWndRect( HANDLE hwndCnr , BOOL LeftWindow , LPRECT TitleWndRect );
BOOL FAR CnrPositionDetailsView( HANDLE hwnd , HDC hps , LPRECORDCOREN LastValidRec );
BOOL FAR CnrInvalidateDetailFieldInfo( HANDLE hwndCnr );
VOID FAR CnrProcessVisibleColumns( HANDLE hwndCnr );
VOID FAR CnrPaintSplitbar( HANDLE hwndCnr , HDC hps );
VOID FAR CnrPositionColumnTitles( HANDLE hwndCnr , HDC hps );
VOID FAR CnrSetFirstColInView( HANDLE hwndCnr , BOOL WindowLeft );
BOOL FAR CnrInViewRect( HANDLE hwndCnr , RECT ItemRect , RECT ViewRect );
int FAR CnrQueryColumnPosInDV( HANDLE hwndCnr , LPFIELDINFO pStartFI , LPFIELDINFO pFieldInfo , BOOL LeftSide , BOOL Last );
LPFIELDINFO FAR CnrQueryLastColumnInView( HANDLE hwndCnr , LPFIELDINFO pFirstInView , BOOL LeftWindow );
int FAR CnrQueryRowPosInDV( LPRECORDCOREN pRecord , long TopOrBot );
BOOL FAR CnrVerifyFieldInfoPtrs( HANDLE hwndCnr , LPFIELDINFO pFieldInfo , WORD NumFieldInfo );
BOOL FAR CnrProcessColumnData( HANDLE hwndCnr , HDC hps , LPRECORDCOREN pRecord , LPFIELDINFO pFieldInfo , RECT InvalidRect , BOOL LeftWindow , BOOL FirstColLeft );
BOOL FAR CnrProcessTitleData( HANDLE hwndCnr , HDC hps , LPFIELDINFO pFieldInfo , long xColumnPos , RECT InvalidRect , BOOL LeftWindow , BOOL FirstColLeft );
VOID FAR CnrSizeColumnTitleWindows( HANDLE hwndCnr , int right , int bottom );
VOID FAR CnrSetFirstRowInView( HANDLE hwndCnr , LPRECORDCOREN preccCurrent , BOOL FromAbove );
BOOL FAR CnrRowHeightChanged( HANDLE hwndCnr , LPRECORDCOREN pRecord );
#endif

#ifdef CNRS1P3_C
LPVOID FAR CnrGetColumnData( HANDLE hwndCnr , LPRECORDCORE pRecord , LPFIELDINFO pFieldInfo );
WORD FAR CnrInsertDetailFieldInfo( HANDLE hwndCnr , long mp1 , long mp2 );
VOID FAR CnrHScrollDetailsView( HANDLE hwndCnr , DWORD lParam , WORD wNotifyCode );
LPRECORDCOREN FAR CnrGetFirstItemInRect( HWND hwndCnr , RECT rctlRedraw );
VOID FAR CnrDrawHorzSep( HANDLE hwndCnr , HDC hps , LPFIELDINFO pFieldInfo , long xColumnPos , BOOL LeftWindow );
VOID FAR CnrDrawVertSep( HANDLE hwndCnr , HDC hps , BOOL LeftWindow , BOOL ColumnTitles );
BOOL FAR CnrDrawLeftDetailsWindow( HANDLE hwnd , HDC hps , RECT InvalidRect );
BOOL FAR CnrDrawRightDetailsWindow( HANDLE hwnd , HDC hps , RECT InvalidRect );
VOID FAR CnrSetDetailsViewScroll( HANDLE hwndCnr );
VOID FAR CnrVScrollDetailsView( HANDLE hwndCnr , DWORD lParam , WORD wNotifyCode );
BOOL FAR CnrDrawEraseRow( HANDLE hwndCnr , LPRECORDCOREN pRecord , BOOL Draw );
#endif

#ifdef CNRS1P4_C
VOID FAR CnrCalcIconSize( HANDLE hwndCnr , LPPOINT iconSize );
VOID FAR CnrQueryClientRect( HANDLE hwnd , LPRECT prctlViewport );
VOID FAR CnrQueryIconTextRect( HANDLE hwnd , LPRECORDCOREN precord , LPPOINT piconSize , BOOL flIncEmph , LPRECT prctlIcon , LPRECT prctlText );
VOID FAR CnrQueryScrollBarRect( HANDLE hwnd , LPRECT prctlVScroll , LPRECT prctlHScroll );
VOID FAR CnrQuerySizeRect( HANDLE hwndCnr , LPPOINT piconSize , LPRECT prctlLTitle , LPRECT prctlViewport , LPRECT prctlVscroll , LPRECT prctlHscroll );
VOID FAR CnrQueryTitleRect( HANDLE hwnd , LPRECT prctlLTitle , LPRECT prctlCTitle );
VOID FAR CnrPaintCnrTitleWin( HANDLE hwnd );
BOOL FAR CnrQueryTitleTextRect( HANDLE hwnd , HDC hps , LPRECT prctlTitle );
VOID FAR DrawSeparator( HDC hps , LPRECT prectlTitle , LPCNRINFON pccinfon );
BOOL FAR CnrDrawRecord( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , BOOL flChangeZorder );
VOID FAR CnrDrawCursorBox( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , RECT rctlBox , BOOL flDraw );
BOOL FAR CnrSetupDrawInfo( HANDLE hwndCnr , LPRECORDCOREN precord , HBITMAP FAR * hbmDraw , LPICONRESIZED FAR * pirsDraw );
BOOL FAR CnrSetDrawItem( HWND hwnd , HDC hDC , LPDRAWITEMSTRUCT lpDrawItem , int Item );
long FAR PASCAL CnrTitleProc( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
BOOL FAR CnrEraseRecord( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord );
VOID FAR CnrDrawIconOnly( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , int sDrawWhat , RECT rctlIcon , RECT rctlIconCur );
VOID FAR CnrDrawTextOnly( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , int sDrawWhat , RECT rctlText , RECT rctlTextCur );
VOID FAR CnrQueryFontMetrics( HANDLE hwndCnr , HANDLE hwndQuery , BOOL bDesktop , LPMLEINFO pMLEInfo , PFATTRS pFattrs );
BOOL FAR InvalidateForEdit( HANDLE hwndCnr );
BOOL FAR CnrCloseMLE( HANDLE hwndCnr );
HANDLE FAR CnrOpenTitleTextMLE( HANDLE hwnd );
BOOL FAR CnrSaveTextCloseMLE( HANDLE hwndCnr );
long FAR PASCAL MLESubProc( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
HANDLE FAR CnrCreateMLE( HANDLE hwnd , LPSTR pszText , RECT rctlTitle , WORD usGeneration );
HANDLE FAR CnrOpenRecordTextMLE( HANDLE hwnd , long mp1 );
HANDLE FAR OpenRecordTextMLE( HANDLE hwnd , LPRECORDCOREN preccEdit );
#endif

#ifdef CNRS1P5_C
BOOL FAR CnrPaintBackground( HANDLE hwnd , HDC hps , LPRECT prctlPaint );
WORD FAR CnrStrcspn( LPSTR pszSrc , LPSTR pszSet );
VOID FAR IcnCalcTextSize( HDC hps , POINT iconSize , LPCNRINFON pccinfon , LPSTR textString , DWORD iconStyle , LPSIZEL ptextSize );
VOID FAR IcnDrawText( HDC hps , LPSTR textString , RECT textRect , DWORD iconAttr , DWORD iconStyle , LPCNRINFON pccinfon );
BOOL FAR CnrDrawIcon( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , BOOL flChangeZorder );
BOOL FAR CnrDrawNameTextViewItem( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , LPPOINT piconSize );
BOOL FAR CnrPaintNameTextView( HANDLE hwndCnr , HDC hps , LPRECT prctlWindow );
VOID FAR IcnDrawIcon( HDC hps , LPICONRESIZED pirsIcon , HBITMAP hbmIcon , DWORD iconAttr , RECT iconRect , LPCNRINFON pccinfon );
VOID FAR IcnDrawSelectEmph( HDC hps , RECT rctlBack , BOOL flIsForIcon , LPCNRINFON pccinfon );
BOOL FAR xDrawIcon( HANDLE hwndCnr , HDC hps , LPRECORDCOREN pRecord , LPPOINT pslIcon );
VOID FAR IcnDrawIconInDV( HDC hps , LPICONRESIZED pirsIcon , HBITMAP hbmIcon , DWORD iconAttr , RECT iconRect , RECT rctlEmph , BOOL DrawEmph , LPCNRINFON pccinfon );
VOID FAR IcnDrawTextInDV( HDC hps , LPSTR textString , RECT textRect , RECT rctlEmph , DWORD iconAttr , DWORD iconStyle , LPCNRINFON pccinfon );
VOID FAR CnrEraseIcon( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , BOOL flRedraw );
VOID FAR IcnDrawInUseEmph( HDC hps , RECT rctlBack , LPCNRINFON pccinfon );
VOID FAR IcnDrawBox( HDC hps , DWORD iconAttr , LPRECT prctlBox );
BOOL FAR CnrDrawEraseNameText( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , BOOL blIsDraw );
#endif

#ifdef CNRS2P1_C
BOOL FAR PASCAL CnrEnumWindowsProc( HWND hwndChild , DWORD lParam );
long FAR PASCAL CnrNameTextVCtlProc( HANDLE hwndCnr , WORD msg , WORD wParam , DWORD lParam );
VOID FAR CnrSetFirstItemInNTV( HANDLE hwndCnr , LPRECORDCOREN preccCurrent , BOOL flFromAboveLeft );
VOID FAR CnrSetNameTextViewScroll( HANDLE hwndCnr , BOOL flChangeHeight );
void FAR SetHscrollInNFView( HANDLE hwndHscroll , LPCNRINFON pccinfon , int sLTPos , int sRBPos , RECT rctlClient );
void FAR SetVscrollInNFView( HANDLE hwnd , HANDLE hwndVscroll , int sRBPos , int sLTPos , RECT rctlClient );
void FAR CalcTextSizeInIV( HANDLE hwnd , HDC hps );
int FAR CnrQueryPtOfItemInNTV( HANDLE hwndCnr , LPRECORDCOREN precord , LPPOINT piconSize , long lDir );
VOID FAR CnrSetFirstItemInNFNTV( HANDLE hwndCnr , LPRECORDCOREN preccCurrent , BOOL flFromAbove );
VOID FAR CnrSetNFNameTextViewScroll( HANDLE hwndCnr );
VOID FAR CnrPositionNameTextView( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord );
VOID FAR CnrSetFlowedNameTextViewScroll( HANDLE hwndCnr , BOOL flChangeHeight );
VOID FAR CnrSetFirstItemInFlowedNTV( HANDLE hwndCnr , LPRECORDCOREN preccCurrent , BOOL flFromLeft );
LPRECORDCOREN FAR CnrGetLastItemInView( HWND hwndCnr );
#endif

#ifdef CNRS2P2_C
VOID FAR CnrEraseRect( HANDLE hwndCnr , HDC hps , RECT rctlObj );
VOID FAR CnrSizeCnrTitle( HANDLE hwnd , HDC hps , RECT rectCnr );
int FAR CalcScrollFactor( HANDLE hwndCnr , int lScrollRange , BOOL isV );
BOOL FAR CnrInsertDeleteResizedIconInDV( HANDLE hwnd , HICON hptrObject , BOOL fsInsert );
BOOL FAR CnrProcessIconsForDV( HANDLE hwndCnr , LPRECORDCOREN pRecord , LPFIELDINFO pFieldInfo , BOOL Insert , BOOL FromRecordInsert );
BOOL FAR CnrInsertDeleteResizedIcon( HANDLE hwnd , LPRECORDCORE preccObject , BOOL fsInsert , BOOL fsRegular );
BOOL FAR CnrOpenIRSMetrics( HANDLE hwnd );
VOID FAR CnrSetupIconPirsInfo( HANDLE hwndCnr , LPRECORDCORE pRecord , BOOL fsRegular , HICON FAR * hptrCurr , LPICONRESIZED FAR * FAR * pirsCurr );
BOOL FAR CnrTRVInsDelResizedIcon( HANDLE hwnd , LPRECORDCORE preccObj , BOOL fsInsert );
VOID FAR IcnResizeIcon( LPICONRESIZED pirsNew , POINT slIcon );
BOOL FAR InsertDeleteResizedIcon( HANDLE hwnd , LPICONRESIZED FAR * ppirsFirst , HICON hptrResize , POINT iconSize , BOOL fsInsert );
BOOL FAR CnrDeleteAllResizedIcon( HANDLE hwnd );
BOOL FAR CnrUpdateWorkplace( HANDLE hwnd , HDC hps , LPRECORDCOREN preccnObject , BOOL flInsert );
VOID FAR GetIconTextRectInWorkplace( HANDLE hwnd , LPRECORDCOREN preccnObject , LPPOINT piconSize , LPSIZEL ptextSize , LPRECT prctlIcon , LPRECT prctlText );
BOOL FAR GetNewWorkplace( HANDLE hwnd );
VOID FAR IcnCalcTileSize( LPPOINT piconSize , LPSIZEL ptextSize , DWORD iconStyle , LPCNRINFON pccinfon , LPSIZEL ptileSize );
BOOL FAR UpdateWorkplaceForInsert( HANDLE hwnd , LPRECT prctlIcon , LPRECT prctlText );
LPRECORDCOREN FAR CnrOverRecord( HANDLE hwnd , int xPos , int yPos );
VOID FAR FixHeap( PALPRECORDCOREN ptrArray , long lRoot , LPRECORDCOREN preccnKey , long lBound , DWORD mp1 , DWORD mp2 );
VOID FAR HeapSort( PALPRECORDCOREN ptrArray , long n , DWORD mp1 , DWORD mp2 );
LPICONRESIZED FAR FindPirs( HANDLE hwnd , LPRECORDCORE preccObject , BOOL fsRegular );
VOID FAR IcnDrawScaledIcon( HDC hps , LPICONRESIZED pirsDraw , int xDst , int yDst , LPCNRINFON pccinfon , BOOL SourceEmph );
LPRECORDCOREN FAR CnrTRVOverRecord( HANDLE hwnd , int xPos , int yPos );
LPRECORDCOREN FAR GetFirstItemInView( HANDLE hwndCnr );
LPICONRESIZED FAR FindPirsForDV( HANDLE hwnd , HICON hptrFind );
BOOL FAR CnrChangeSizeInIRSMetrics( HANDLE hwnd );
BOOL FAR CnrChangeSizeInIRSTreeMetrics( HANDLE hwnd );
BOOL FAR CnrTRVInsDelResizedTreeIcon( HANDLE hwnd , BOOL fsInsert );
BOOL FAR CnrUpdateDetailsViewIcons( HANDLE hwndCnr );
VOID FAR CnrUpdateTitleSize( HWND hwnd , HDC hDC );
VOID FAR CnrBltStretch( HBITMAP hbmSrc , HDC hpsDst , int xSrc , int ySrc , WORD cxSrc , WORD cySrc , int xDst , int yDst , WORD cxDst , WORD cyDst , DWORD rop , DWORD mode );
HBITMAP FAR CopyBitmap( HBITMAP hbm , WORD cx , WORD cy , DWORD flBlt , HDC hdcMem );
VOID FAR GetMinInvalidateRect( HANDLE hwnd , LPRECT prctlClient );
VOID FAR UpdateMaxHeightForDel( HANDLE hwnd , LPRECORDCOREN preccInvalidate );
BOOL FAR UpdateWorkplaceForDelete( HANDLE hwnd , LPRECT prctlWorkplaceItems , LPRECT prctlIcon , LPRECT prctlText );
#endif

#ifdef CNRS2P3_C
VOID FAR CalcTextSize( HANDLE hwndCnr , LPRECORDCOREN preccnNew , POINT iconSize );
long FAR CnrInsertRecord( HANDLE hwnd , long mp1 , long mp2 );
BOOL FAR ConvertPRItoPRIN( HANDLE hwnd , LPRECORDINSERT pRecordInsert );
BOOL FAR CnrArrangeIconView( HANDLE hwndCnr , HDC hps );
VOID FAR CnrSetUpNewView( HANDLE hwndCnr , HDC hps );
VOID FAR GetInvalidateRect( HANDLE hwnd , LPRECORDCOREN preccInvalid , LPRECT prctlInvalid );
VOID FAR InvalidateContainer( HANDLE hwnd , BOOL bInvalidateAll , LPRECT prctlInvalid );
BOOL FAR CnrTRVExpandCollapse( HANDLE hwnd , WORD msg , LPRECORDCOREN preccObj );
void FAR TRVInvalidateForExpCol( HANDLE hwnd , LPRECORDCOREN preccInvalid );
BOOL FAR InvalidateForInsert( HANDLE hwnd , HDC hps , LPRECORDCORE pRecordCore , LPRECORDCOREN preccnFirstInvalid , LPRECORDINSERT pRecordInsert , BOOL flNoSiblings );
BOOL FAR CnrTRVSetUpNewView( HANDLE hwndCnr , HDC hps );
VOID FAR TRVGetInvalidateRect( HANDLE hwnd , LPRECORDCOREN preccInvalid , LPRECT prctlInvalid );
void FAR TRVInvalidateFrom( HANDLE hwnd , HDC hps , LPCNRINFON pccinfon , LPRECORDCOREN preccInvalid );
BOOL InsertRecord( HANDLE hwnd , LPRECORDCOREN preccnBegin , LPRECORDCOREN preccnEnd , LPRECORDCOREN preccnPrev , LPRECORDCOREN preccnParent , BOOL flItemOrder );
LPRECORDCOREN InsertRecordsInChain( HANDLE hwnd , LPRECORDINSERTN pRecordInsertN , LPRECORDCORE preccInsert );
BOOL FAR CnrFilter( HANDLE hwnd , long mp1 , long mp2 );
BOOL FAR CnrSetUpNewViewForDV( HANDLE hwndCnr , HDC hps );
VOID FAR InvalidateChildren( HANDLE hwnd , BOOL bEraseBackground , BOOL bSizingDetails );
BOOL FAR TRVExpandCollapseAll( HANDLE hwnd , DWORD ulOldState , DWORD ulNewState , WORD usNotify );
#endif

#ifdef CNRS2P4_C
BOOL FAR CheckNeedResize( HANDLE hwndCnr );
LPVOID FAR FindFirstIteminColumn( HANDLE hwndCnr , LPRECORDCOREN preccCurrent );
long FAR PASCAL CnrIconVCtlProc( HANDLE hwndCnr , WORD msg , WORD wParam , DWORD lParam );
VOID FAR CnrINTViewHScroll( HANDLE hwndCnr , DWORD lParam , WORD wNotifyCode );
VOID FAR CnrINTViewVScroll( HANDLE hwndCnr , DWORD lParam , WORD wNotifyCode );
VOID FAR CnrSetIconViewScroll( HANDLE hwndCnr );
LPRECORDCOREN FAR FindFirstIteminRow( HANDLE hwndCnr , LPRECORDCOREN preccCurrent );
VOID FAR SetScrollBar( HANDLE hwndCnr , HANDLE hwndScroll , int clientRB , int workplaceRB , int workplaceLT , int originXY , LPINT psScrollPos , LPINT psScrollMax , LPINT psScrollFactor , BOOL isV );
VOID FAR CnrSetFirstItemAutoPosIconV( HANDLE hwndCnr , LPRECORDCOREN preccCurrent , BOOL flFromAbove );
BOOL FAR CnrPaintIconView( HANDLE hwndCnr , HDC hps , LPRECT prctlInvalid );
BOOL FAR IsInIconViewport( LPRECORDCOREN pRecord , LPPOINT pptlOrigin , LPRECT prctlWindow , LPPOINT piconSize );
BOOL FAR InvalidateRecord( HANDLE hwnd , LPRECORDCOREN FAR * pRecordArray , WORD cNumRecord , WORD flInvalidate );
BOOL FAR CnrInvalidateRecord( HANDLE hwndCnr , long mp1 , long mp2 );
BOOL FAR TRVInvalidateRecord( HANDLE hwnd , LPRECORDCOREN FAR * pRecordArray , WORD cNumRecord , WORD flInvalidate );
#endif

#ifdef CNRS2P5_C
void FAR TRVProcessOpenTree( HANDLE hwnd );
void FAR TRVProcessCloseTree( HANDLE hwnd );
VOID FAR CnrSize( HANDLE hwnd , WORD cxNew , WORD cyNew );
VOID FAR CnrResetInstanceData( HANDLE hwnd );
BOOL FAR CnrSort( HANDLE hwnd , long mp1 , long mp2 , BOOL fPaintRecord );
VOID FAR UpdateFirstItemInView( HANDLE hwnd , LPRECORDCOREN preccDel );
BOOL FAR CnrFreeAll( HANDLE hwnd , BOOL flRecords );
BOOL FAR CreateDVWindows( HWND hwnd );
BOOL FAR CnrSetCnrInfo( HANDLE hwnd , long mp1 , long mp2 );
void FAR InitWindowViewAttr( HANDLE hwnd );
BOOL FAR ProcessChangeLineSpace( HANDLE hwnd );
VOID FAR ProcessChangeOrigin( HANDLE hwnd );
BOOL FAR ProcessChangePSortRecord( HANDLE hwnd );
BOOL FAR DestroyDVWindows( HWND hwnd );
VOID FAR CnrRemoveAllInternal( HANDLE hwndCnr );
BOOL FAR CnrFreeRecord( HANDLE hwnd , long mp1 , long mp2 , BOOL Verify );
#endif

#ifdef CNRS2P6_C
LPRECORDCORE FAR CnrQueryRecord( HANDLE hwnd , long mp1 , long mp2 );
LPRECORDCOREN FAR GetNextItem( LPCNRINFON pccinfon , LPRECORDCOREN preccPrev );
LPRECORDCOREN FAR GetRecordNFromX( HANDLE hwndCnr , LPRECORDCORE pRecord );
void FAR RemoveChildrenRecordN( HANDLE hwndCnr , LPRECORDCOREN preccnRemove , WORD flFree );
void FAR RemoveRecordN( HANDLE hwndCnr , LPRECORDCOREN preccnRemove , WORD flFree );
BOOL FAR AfterLastInViewport( HANDLE hwnd , LPRECORDCOREN preccInvalid );
BOOL FAR CallQuickSort( HANDLE hwnd , long mp1 , long mp2 , LPRECORDCOREN preccFirstSibling , BOOL flRootLevel );
LPRECORDCOREN FAR AllocRecordN( HANDLE hwndCnr , LPRECORDCORE pRecord );
LPRECORDCOREN FAR CnrAllocRecordN( HANDLE hwndCnr , LPRECORDCORE pRecord );
BOOL FAR TRVInvalidateForRemove( HANDLE hwnd , HDC hps , LPRECORDCOREN preccInvalid , BOOL invalidateAll );
LPRECORDCOREN FAR GetPrevVisualItem( HANDLE hwnd , LPRECORDCOREN preccNext );
void FAR UpdateCursorForDel( HANDLE hwnd , LPRECORDCOREN preccDel );
LPRECORDCOREN FAR UpdateFirstDel( HANDLE hwnd , LPRECORDCOREN preccEnumArray , LPRECORDCOREN preccFirstDel );
BOOL FAR Before1stInView( HANDLE hwnd , LPRECORDCOREN preccnInvalid );
long FAR CnrRemoveRecord( HANDLE hwnd , long mp1 , long mp2 );
void FAR CnrRemoveRecordN( HANDLE hwndCnr , LPRECORDCORE preccLink , WORD flFree );
void FAR DeleteRecord( HANDLE hwnd , LPRECORDCOREN preccObject , BOOL flItemOrder );
BOOL FAR InvalidateForRemove( HANDLE hwnd , HDC hps , LPRECORDCOREN preccInvalid , BOOL invalidateAll , WORD cNumRecords , LPRECORDCORE FAR * pRecordArray );
BOOL FAR IsBefore( HANDLE hwnd , LPRECORDCOREN preccBefore , LPRECORDCOREN preccAfter );
VOID FAR FreeRecords( HANDLE hwndCnr );
BOOL FAR CheckFirstInView( HANDLE hwnd );
WORD FAR ChangeColumnLength( LPRECORDCOREN precord , SIZEL slNewTextSize );
BOOL FAR NeedUpdateWorkplace( HANDLE hwnd , HDC hps , LPRECORDCOREN preccObject );
LPRECORDCOREN FAR GetNextVisualItem( HANDLE hwnd , LPRECORDCOREN preccPrev );
BOOL FAR ChangeRowHeight( HANDLE hwnd , LPRECORDCOREN precord , SIZEL slNewTextSize );
BOOL FAR CnrProcessDelta( HANDLE hwndCnr , BOOL scrollDirection );
LPRECORDCOREN FAR GetPrevItem( LPCNRINFON pccinfon , LPRECORDCOREN preccNext );
BOOL FAR ChangeItemHeight( HANDLE hwnd , LPRECORDCOREN precord , SIZEL slNewTextSize , POINT slIcon );
WORD FAR CnrQueryCnrInfo( HANDLE hwnd , long mp1 , long mp2 );
VOID FAR UpdateColumnLongest( HANDLE hwnd , LPRECORDCOREN precord , WORD usLongestLine );
BOOL FAR DrawSelCurItemsInView( HANDLE hwnd , HDC hps , BOOL flDraw );
#endif

#ifdef CNRS3P1_C
BOOL FAR CnrProcessSetFocus( HWND hwnd , BOOL bSettingFocus );
VOID FAR CnrTrackSplitbar( HWND hwndCnr );
BOOL FAR IsOverSplitbar( HWND hwnd , POINT ptMouse );
void FAR WorkspaceToScreen( HWND hwnd , LPPOINT lppt );
int FAR CnrRemoveDetailFieldInfo( HANDLE hwndCnr , long mp1 , long mp2 );
void FAR DrawTrackRect( HDC hdc , LPRECT lprc );
BOOL FAR WinTrackRect( HWND hwnd , LPTRACKINFO lpTrackInfo , HICON hcurSplit );
LPFIELDINFO FAR CnrAllocDetailFieldInfo( HANDLE hwndCnr , long mp1 );
long FAR PASCAL CnrLeftDetailsWndProc( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
long FAR PASCAL CnrRightDetailsWndProc( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
void FAR CnrDragIcon( HWND hwnd , int xMouse , int yMouse );
BOOL FAR DrawDraggedIcon( HDC hdc , HICON hIcon , WORD x , WORD y , WORD fs );
void FAR ScreenToWorkspace( HWND hwnd , LPPOINT lppt );
BOOL FAR CnrFreeDetailFieldInfo( HANDLE hwndCnr , long mp1 , long mp2 );
BOOL FAR CnrHorzScrollSplitWindow( HANDLE hwndCnr , int Window , long ScrollUnit );
LPFIELDINFO FAR CnrQueryDetailFieldInfo( HANDLE hwndCnr , long mp1 , long mp2 );
VOID FAR DrawBlinkEmphBox( HANDLE hwnd , HDC hps , LPRECORDCOREN preccObject , DWORD flAttr );
BOOL FAR DrawCursorTargetRecord( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , DWORD ulWhich , BOOL flChangeZorder );
BOOL FAR DrawSelectionRecord( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , BOOL flChangeZorder , BOOL flBoth );
BOOL FAR xSetTimer( HANDLE hwnd , WORD usDuration , BOOL flOn );
#endif

#ifdef CNRS3P2_C
long FAR NotifyOwner( HANDLE hwnd , WORD usNotifyCode , LPVOID lpData );
long FAR CnrDestroy( HANDLE hwndCnr );
long FAR CnrButtonState( HANDLE hwnd , HDC hps , int xPos , int yPos , LPRECORDCOREN pMouseRecord );
long FAR PASCAL CnrEdgeProc( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
long FAR PASCAL CnrGateProc( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
long FAR CnrCreate( HANDLE hwnd );
VOID FAR CnrInitNLSInfo( HANDLE hwndCnr );
BOOL FAR CnrChangeCursor( HANDLE hwnd , LPRECORDCOREN pRecord , HDC hps , BOOL fDeselect );
VOID FAR CnrDisplayData( HANDLE hwndCnr );
long FAR CnrStartDirectEdit( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
#endif

#ifdef CNRS3P3_C
BOOL FAR CnrDrawEmphChange( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precordn , DWORD flRecordAttrOld );
BOOL FAR CnrTRVDrawEmphChange( HANDLE hwnd , HDC hps , LPRECORDCOREN preccnChange , DWORD flRecordAttrOld );
VOID FAR EraseIconOnlyInIV( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , BOOL flRedraw , BOOL flInclEmph );
VOID FAR EraseTextOnlyInIV( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord );
VOID FAR CnrPaintEdgeWin( HANDLE hwnd );
BOOL FAR CnrIsRecordInTree( LPRECORDCOREN preccRoot , LPRECORDCORE preccComp );
BOOL FAR CnrVerifyPointers( HANDLE hwnd , LPRECORDCORE FAR * pRecordArray , DWORD cNumRecord );
VOID FAR BlinkCursoredEmph( HANDLE hwnd , HDC hps , LPRECORDCOREN preccObject , BOOL flOn );
BOOL FAR CnrSetBlinkTimer( HANDLE hwnd );
#endif

#ifdef CNRS3P4_C
VOID FAR CnrDrawBoxOutline( HANDLE hwnd , HDC hps , POINT FAR * pptlStart , POINT FAR * pptlEnd );
BOOL FAR SetEmphasisBits( HANDLE hwnd , HDC hps , LPRECORDCOREN preccnChange , DWORD flMask , WORD fsControl );
BOOL FAR CnrQueryViewportRect( HANDLE hwnd , long mp1 , long mp2 );
BOOL FAR CnrSetRecordEmphasis( HANDLE hwnd , long mp1 , long mp2 );
BOOL FAR CnrScrollWindow( HANDLE hwndCnr , long mp1 , long mp2 );
LPRECORDCORE FAR CnrAllocRecord( HANDLE hwnd , WORD ExtraBytes , WORD NumRecords );
BOOL FAR CnrQueryRecordRect( HANDLE hwnd , long mp1 , long mp2 );
VOID FAR ResetWindowForFontChange( HANDLE hwnd );
LPRECORDCOREN FAR CnrQueryRecordFromRect( HANDLE hwnd , long mp1 , long mp2 );
VOID FAR CnrQueryRowRectForDV( HANDLE hwndCnr , LPRECORDCOREN pRecord , LPRECT RowRect );
BOOL FAR CnrRefreshColors( HWND hwndCnr , LPCNRINFON pccinfon , WORD wCnrAttr , COLORREF crColor );
LPRECORDCORE FAR CnrQueryRecordEmphasis( HANDLE hwnd , long mp1 , long mp2 );
BOOL FAR IsInRoot( HANDLE hwnd , LPRECORDCORE preccObj );
long FAR CnrProcessTimer( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
BOOL FAR CnrQueryRecordInfo( HANDLE hwndCnr , long mp1 , long mp2 );
#endif

#ifdef CNRS3P5_C
BOOL FAR CnrProcessMouseMove( HANDLE hwnd , long mp1 );
BOOL FAR CnrProcessMouseButton1Up( HANDLE hwnd );
BOOL FAR CnrProcessMouseButton1Down( HANDLE hwnd , long mp1 );
BOOL FAR TRVProcessButton1Down( HANDLE hwnd , long mp1 );
BOOL FAR CnrProcessChar( HANDLE hwnd , WORD msg , WORD wParam , DWORD lParam );
LPRECORDCOREN FAR CnrFindRecordStringMatch( HANDLE hwnd , LPRECORDCOREN pRecord , LPRECORDCOREN pRecordEnd , LPSTR pString , BOOL fsCaseSensitive , BOOL fsPrefix , DWORD ulView , BOOL flVisibleOnly );
BOOL FAR CnrProcessCharKey( HANDLE hwnd , WORD uschr , HDC hps );
LPRECORDCORE FAR CnrProcessSearchString( HANDLE hwnd , LPSEARCHSTRING pSearchString , LPRECORDCORE pSearchAfter );
LPSTR FAR CnrQueryRecordStringText( HANDLE hwnd , LPRECORDCORE pRecord , LPFIELDINFO pFieldInfo , WORD usView );
LPRECORDCOREN FAR GetHomeOrEndInIconView( HWND hwnd , int Direction );
BOOL FAR CnrProcessOpenEdit( HANDLE hwnd , long mp1 );
BOOL FAR CnrResetCursorRecord( HANDLE hwnd , HDC hps , LPRECORDCOREN pRecord , BOOL fSelect );
BOOL FAR CnrSetCursorFirstItemInView( HANDLE hwnd , HDC hps , BOOL fSelect );
BOOL FAR SelectDeselectAll( HWND hwnd , HDC hps , WORD wParam );
#endif

#ifdef CNRS3P6_C
BOOL FAR CnrFindAndDeemphasizeRecords( HANDLE hwnd , HDC hps , LPRECORDCOREN pRecord , long attribute );
VOID FAR CnrSetRect( LPRECT pSearchRect , LPPOINT ptlEnd , LPPOINT ptlStart );
LPRECORDCOREN FAR FindRecordVert( HANDLE hwnd , LPRECORDCOREN pRecord , DWORD dirFlag );
LPRECORDCOREN FAR FindRecordHorz( HANDLE hwnd , LPRECORDCOREN pRecord , DWORD dirFlag );
long FAR CalcScrollIncrementHorz( HANDLE hwnd , LPRECORDCOREN pRecord );
long FAR CalcScrollIncrementVert( HANDLE hwnd , LPRECORDCOREN pRecord );
BOOL FAR CnrExtendedSelection( HANDLE hwnd , HDC hps , LPRECORDCOREN pMouseRecord , WORD fSelectionState , BOOL fClearSelect );
BOOL FAR ScrollToRecord( HANDLE hwnd , LPRECORDCOREN pRecordCursor , LPRECORDCOREN pRecordCursorNew , BOOL fSelect , BOOL fHToHawaii );
BOOL FAR CnrSetRecordSelection( HANDLE hwnd , HDC hps , LPRECT pSearchRect );
#endif

#ifdef CNRS4P1_C
VOID FAR CnrTRVCalcTreeIconSize( HANDLE hwndCnr , LPPOINT pslTreeIcon );
LPRECORDCOREN FAR TRVGetNextItem( LPRECORDCOREN preccPrev );
BOOL FAR IsTreeVisible( LPRECORDCOREN precord );
BOOL FAR CnrTRVEraseItem( HANDLE hwnd , HDC hps , LPRECORDCOREN preccItem , RECT rctlIcon , RECT rctlTreeIcon , RECT rctlText , WORD usWhat );
BOOL FAR CnrPaintTreeView( HANDLE hwndCnr , HDC hps , RECT rctlWindow );
long FAR PASCAL CnrTreeVCtlProc( HANDLE hwndCnr , WORD msg , WORD wParam , DWORD lParam );
VOID FAR CnrTRVSetScroll( HANDLE hwnd );
BOOL FAR TRVCheckNeedResize( HANDLE hwnd );
VOID FAR CnrTRVSetFirstItem( HANDLE hwndCnr , LPRECORDCOREN preccCurrent , BOOL flFromAbove );
VOID FAR CnrPositionTreeView( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord );
WORD FAR TRVGetCy( HANDLE hwnd , LPRECORDCOREN preccObj , POINT slIcon , POINT slTreeIcon );
WORD FAR TRVNodeLevel( LPRECORDCOREN preccObj );
int FAR TRVPositionRecords( HANDLE hwnd , HDC hps , LPRECORDCOREN preccFrom , long yPrevTop , WORD usLevel , WORD usIndent , WORD usLeftMargin , WORD cyBetween , POINT slIcon , POINT slTreeIcon , LPINT lpcyPrevText , LPINT lpcyPrevItem );
BOOL FAR CnrTRVDrawItem( HANDLE hwndCnr , HDC hps , LPRECORDCOREN precord , RECT rctlIcon , RECT rctlTreeIcon , RECT rctlText , WORD usWhat );
int FAR CnrTRVDrawLine( HANDLE hwnd , HDC hps , LPRECORDCOREN preccItem , POINT ptlLine , RECT rctlIcon , RECT rctlTreeIcon , RECT rctlText );
VOID FAR CnrTRVQueryIconTextRect( HANDLE hwnd , LPRECORDCOREN precord , BOOL flIncEmph , POINT slIcon , POINT slTreeIcon , LPRECT prctlIcon , LPRECT prctlTreeIcon , LPRECT prctlText );
int FAR CnrTRVQueryPtOfItem( HANDLE hwndCnr , RECT rctlIcon , RECT rctlTreeIcon , RECT rctlText , long lDir );
void FAR GetLineTop( HANDLE hwnd , LPCNRINFO pccinfo , LPRECORDCOREN preccItem , POINT slIcon , POINT slTreeIcon , LPPOINT pptlLineTop );
int FAR TRVDrawRecords( HANDLE hwnd , HDC hps , LPRECORDCOREN preccEnum , RECT rctlClient , POINT slIcon , POINT slTreeIcon );
BOOL FAR TRVhasVisibleChild( LPRECORDCOREN precord );
LPRECORDCOREN FAR GetNextUnfilteredItem( LPRECORDCOREN preccObj );
LPRECORDCOREN FAR GetPrevUnfilteredItem( LPRECORDCOREN preccObj );
LPRECORDCOREN FAR TRVFindLastUnfiltered( HANDLE hwnd , LPRECORDCOREN preccParent );
LPRECORDCOREN FAR TRVGetNextVisualItem( LPRECORDCOREN preccPrev );
LPRECORDCOREN FAR TRVGetPrevVisualItem( HANDLE hwnd , LPRECORDCOREN preccNext );
BOOL FAR TRVIsAncestor( LPRECORDCOREN preccAncestor , LPRECORDCOREN preccDescendant );
LPICONRESIZED FAR TRVFindTreePirs( HANDLE hwnd , LPRECORDCOREN preccObject );
LPICONRESIZED FAR TRVFindPirs( HANDLE hwnd , LPRECORDCOREN preccObject );
BOOL FAR TRVMoveCursor( HANDLE hwnd , HDC hps , LPRECORDCOREN preccNewCursor );
LPRECORDCOREN FAR TRVFindLast( LPRECORDCOREN preccParent );
LPRECORDCOREN FAR TRVGetPrevItem( LPRECORDCOREN preccNext );
LPRECORDCOREN FAR TRVGetRoot( LPRECORDCOREN preccObj );
#endif

#ifdef STORWIN_C
PVOID AllocateSystemStorage( ULONG ulLength , PSAT pStorageSpace , PULONG pAllocatedLength );
PVOID AllocMem( ULONG ulRequestedSize , PULONG pAllocatedLength );
PSTORAGEBLOCK CommonFreeStorage( PSAT pStorageSpace , PSTORAGEBLOCK pAddress , ULONG ulLength );
PVOID GrowSeg( PSAT pStorageSpace , ULONG ulRequestedSize , PULONG pAllocatedLength );
PSTORAGEBLOCK ReleaseSystemStorage( PSTORAGEBLOCK pFreeBlock );
PVOID APIENTRY StmAllocateStorage( PSAT pStorageSpace , ULONG ulRequestedLength );
BOOL APIENTRY StmDecrementUseCount( PSAT pStorageSpace , PVOID pLastBlockAllocated , ULONG ulDecrement );
BOOL APIENTRY StmFreeStorage( PSAT pStorageSpace , PVOID pAddress );
BOOL APIENTRY StmIncrementUseCount( PSAT pStorageSpace , PVOID pLastBlockAllocated , ULONG ulIncrement );
PVOID APIENTRY StmInitStorageSpace( ULONG ulDefaultBlockSize , PFN pfnShareRoutine );
BOOL APIENTRY StmTermStorageSpace( PSAT pStorageSpace );
#endif

#ifdef CNRREG_C
#pragma alloc_text (INIT_TEXT, CnrIsRegistered, LibMain)
#endif

#ifdef CNRS1P1_C
#pragma alloc_text (SG13, CnrDetailsVCtlProc)
#pragma alloc_text (SG19, CnrDrawColumnTitlesLeft)
#pragma alloc_text (SG24, CnrCalcCellRectForDV, CnrCalcRowRect, CnrCalcSelectionRect)
#pragma alloc_text (SG26, CnrBuildDateTimeString, CnrCreateNLSDateString, CnrCreateNLSTimeString)
#pragma alloc_text (SG29, CnrCalcRectForDV)
#pragma alloc_text (_STORSEG, CnrCreateNLSNumberString, reverse)
#pragma alloc_text (SG33, CnrCalcRectForDVTitles, CnrDrawColumnTitlesRight, CnrLeftColumnTitlesProc)
#pragma alloc_text (SG33, CnrRightColumnTitlesProc)
#pragma alloc_text (SG39, CnrAllColumnsFixedWidth, CnrColTitleHeightChanged)
#pragma alloc_text (SG44, CnrCalcColumnRect)
#pragma alloc_text (SG46, CnrOpenColDataTextMLE, CnrOpenColTitleTextMLE, CnrOverColumn)
#pragma alloc_text (SG46, OpenColDataTextMLE, OpenColTitleTextMLE)
#endif

#ifdef CNRS1P2_C
#pragma alloc_text (SG1, CnrQueryColumnTitleWndRect)
#pragma alloc_text (SG4, CnrPositionDetailsView)
#pragma alloc_text (SG11, CnrInvalidateDetailFieldInfo, CnrProcessVisibleColumns)
#pragma alloc_text (SG13, CnrPaintSplitbar, CnrPositionColumnTitles, CnrSetFirstColInView)
#pragma alloc_text (SG24, CnrInViewRect, CnrQueryColumnPosInDV, CnrQueryLastColumnInView)
#pragma alloc_text (SG24, CnrQueryRowPosInDV, CnrVerifyFieldInfoPtrs)
#pragma alloc_text (SG29, CnrProcessColumnData)
#pragma alloc_text (SG33, CnrProcessTitleData, CnrSizeColumnTitleWindows)
#pragma alloc_text (SG43, CnrSetFirstRowInView)
#pragma alloc_text (SG47, CnrRowHeightChanged)
#endif

#ifdef CNRS1P3_C
#pragma alloc_text (SG4, CnrGetColumnData)
#pragma alloc_text (SG11, CnrInsertDetailFieldInfo)
#pragma alloc_text (SG13, CnrHScrollDetailsView)
#pragma alloc_text (SG16, CnrGetFirstItemInRect)
#pragma alloc_text (SG24, CnrDrawHorzSep, CnrDrawVertSep)
#pragma alloc_text (SG27, CnrDrawLeftDetailsWindow)
#pragma alloc_text (SG29, CnrDrawRightDetailsWindow)
#pragma alloc_text (SG31, CnrSetDetailsViewScroll)
#pragma alloc_text (SG43, CnrVScrollDetailsView)
#pragma alloc_text (SG48, CnrDrawEraseRow)
#endif

#ifdef CNRS1P4_C
#pragma alloc_text (SG1, CnrCalcIconSize, CnrQueryClientRect, CnrQueryIconTextRect)
#pragma alloc_text (SG1, CnrQueryScrollBarRect, CnrQuerySizeRect, CnrQueryTitleRect)
#pragma alloc_text (SG11, CnrPaintCnrTitleWin, CnrQueryTitleTextRect, DrawSeparator)
#pragma alloc_text (SG15, CnrDrawRecord)
#pragma alloc_text (SG17, CnrDrawCursorBox, CnrSetupDrawInfo)
#pragma alloc_text (SG22, CnrSetDrawItem)
#pragma alloc_text (SG28, CnrTitleProc)
#pragma alloc_text (SG30, CnrEraseRecord)
#pragma alloc_text (SG31, CnrDrawIconOnly, CnrDrawTextOnly)
#pragma alloc_text (SG35, CnrQueryFontMetrics)
#pragma alloc_text (SG39, InvalidateForEdit)
#pragma alloc_text (SG40, CnrCloseMLE, CnrOpenTitleTextMLE, CnrSaveTextCloseMLE)
#pragma alloc_text (SG40, MLESubProc)
#pragma alloc_text (SG46, CnrCreateMLE, CnrOpenRecordTextMLE, OpenRecordTextMLE)
#endif

#ifdef CNRS1P5_C
#pragma alloc_text (SG1, CnrPaintBackground)
#pragma alloc_text (SG4, CnrStrcspn, IcnCalcTextSize, IcnDrawText)
#pragma alloc_text (SG15, CnrDrawIcon)
#pragma alloc_text (SG16, CnrDrawNameTextViewItem, CnrPaintNameTextView)
#pragma alloc_text (SG17, IcnDrawIcon, IcnDrawSelectEmph, xDrawIcon)
#pragma alloc_text (SG29, IcnDrawIconInDV, IcnDrawTextInDV)
#pragma alloc_text (SG30, CnrEraseIcon)
#pragma alloc_text (SG39, IcnDrawInUseEmph)
#pragma alloc_text (SG44, IcnDrawBox)
#pragma alloc_text (SG48, CnrDrawEraseNameText)
#endif

#ifdef CNRS2P1_C
#pragma alloc_text (SG2, CnrEnumWindowsProc, CnrNameTextVCtlProc, CnrSetFirstItemInNTV)
#pragma alloc_text (SG2, CnrSetNameTextViewScroll)
#pragma alloc_text (SG3, SetHscrollInNFView, SetVscrollInNFView)
#pragma alloc_text (SG4, CalcTextSizeInIV)
#pragma alloc_text (SG16, CnrQueryPtOfItemInNTV, CnrSetFirstItemInNFNTV, CnrSetNFNameTextViewScroll)
#pragma alloc_text (SG18, CnrPositionNameTextView)
#pragma alloc_text (SG26, CnrSetFlowedNameTextViewScroll)
#pragma alloc_text (SG30, CnrSetFirstItemInFlowedNTV)
#pragma alloc_text (SG43, CnrGetLastItemInView)
#endif

#ifdef CNRS2P2_C
#pragma alloc_text (SG1, CnrEraseRect)
#pragma alloc_text (SG2, CnrSizeCnrTitle)
#pragma alloc_text (SG3, CalcScrollFactor)
#pragma alloc_text (SG4, CnrInsertDeleteResizedIconInDV, CnrProcessIconsForDV)
#pragma alloc_text (SG5, CnrInsertDeleteResizedIcon, CnrOpenIRSMetrics, CnrSetupIconPirsInfo)
#pragma alloc_text (SG5, CnrTRVInsDelResizedIcon, IcnResizeIcon, InsertDeleteResizedIcon)
#pragma alloc_text (SG6, CnrDeleteAllResizedIcon, CnrUpdateWorkplace, GetIconTextRectInWorkplace)
#pragma alloc_text (SG6, GetNewWorkplace, IcnCalcTileSize, UpdateWorkplaceForInsert)
#pragma alloc_text (SG14, CnrOverRecord)
#pragma alloc_text (SG15, FixHeap, HeapSort)
#pragma alloc_text (SG17, FindPirs, IcnDrawScaledIcon)
#pragma alloc_text (SG23, CnrTRVOverRecord)
#pragma alloc_text (SG25, GetFirstItemInView)
#pragma alloc_text (SG29, FindPirsForDV)
#pragma alloc_text (SG34, CnrChangeSizeInIRSMetrics, CnrChangeSizeInIRSTreeMetrics)
#pragma alloc_text (SG34, CnrTRVInsDelResizedTreeIcon, CnrUpdateDetailsViewIcons)
#pragma alloc_text (SG34, CnrUpdateTitleSize)
#pragma alloc_text (SG44, CnrBltStretch, CopyBitmap, GetMinInvalidateRect, UpdateMaxHeightForDel)
#pragma alloc_text (SG45, UpdateWorkplaceForDelete)
#endif

#ifdef CNRS2P3_C
#pragma alloc_text (SG5, CalcTextSize, CnrInsertRecord, ConvertPRItoPRIN)
#pragma alloc_text (SG6, CnrArrangeIconView, CnrSetUpNewView, GetInvalidateRect)
#pragma alloc_text (SG6, InvalidateContainer)
#pragma alloc_text (SG8, CnrTRVExpandCollapse, TRVInvalidateForExpCol)
#pragma alloc_text (SG9, InvalidateForInsert)
#pragma alloc_text (SG12, CnrTRVSetUpNewView, TRVGetInvalidateRect, TRVInvalidateFrom)
#pragma alloc_text (SG19, InsertRecord, InsertRecordsInChain)
#pragma alloc_text (SG23, CnrFilter)
#pragma alloc_text (SG31, CnrSetUpNewViewForDV)
#pragma alloc_text (SG34, InvalidateChildren)
#pragma alloc_text (SG45, TRVExpandCollapseAll)
#endif

#ifdef CNRS2P4_C
#pragma alloc_text (SG1, CheckNeedResize, FindFirstIteminColumn)
#pragma alloc_text (SG2, CnrIconVCtlProc, CnrINTViewHScroll, CnrINTViewVScroll)
#pragma alloc_text (SG3, CnrSetIconViewScroll, FindFirstIteminRow, SetScrollBar)
#pragma alloc_text (SG7, CnrSetFirstItemAutoPosIconV)
#pragma alloc_text (SG17, CnrPaintIconView, IsInIconViewport)
#pragma alloc_text (SG21, InvalidateRecord)
#pragma alloc_text (SG35, CnrInvalidateRecord)
#pragma alloc_text (SG44, TRVInvalidateRecord)
#endif

#ifdef CNRS2P5_C
#pragma alloc_text (SG4, TRVProcessOpenTree)
#pragma alloc_text (SG10, TRVProcessCloseTree)
#pragma alloc_text (SG12, CnrSize)
#pragma alloc_text (SG13, CnrResetInstanceData)
#pragma alloc_text (SG15, CnrSort)
#pragma alloc_text (SG23, UpdateFirstItemInView)
#pragma alloc_text (_STORSEG, CnrFreeAll)
#pragma alloc_text (SG33, CreateDVWindows)
#pragma alloc_text (SG34, CnrSetCnrInfo, InitWindowViewAttr, ProcessChangeLineSpace)
#pragma alloc_text (SG34, ProcessChangeOrigin, ProcessChangePSortRecord)
#pragma alloc_text (SG39, DestroyDVWindows)
#pragma alloc_text (SG40, CnrRemoveAllInternal)
#pragma alloc_text (SG43, CnrFreeRecord)
#endif

#ifdef CNRS2P6_C
#pragma alloc_text (SG3, CnrQueryRecord)
#pragma alloc_text (SG4, GetNextItem)
#pragma alloc_text (SG5, GetRecordNFromX, RemoveChildrenRecordN, RemoveRecordN)
#pragma alloc_text (SG10, AfterLastInViewport)
#pragma alloc_text (SG15, CallQuickSort)
#pragma alloc_text (SG19, AllocRecordN, CnrAllocRecordN, TRVInvalidateForRemove)
#pragma alloc_text (SG23, GetPrevVisualItem, UpdateCursorForDel, UpdateFirstDel)
#pragma alloc_text (SG25, Before1stInView, CnrRemoveRecord, CnrRemoveRecordN, DeleteRecord)
#pragma alloc_text (SG25, InvalidateForRemove)
#pragma alloc_text (SG27, IsBefore)
#pragma alloc_text (_STORSEG, FreeRecords)
#pragma alloc_text (SG34, CheckFirstInView)
#pragma alloc_text (SG37, ChangeColumnLength, NeedUpdateWorkplace)
#pragma alloc_text (SG38, GetNextVisualItem)
#pragma alloc_text (SG41, ChangeRowHeight)
#pragma alloc_text (SG43, CnrProcessDelta, GetPrevItem)
#pragma alloc_text (SG44, ChangeItemHeight)
#pragma alloc_text (SG45, CnrQueryCnrInfo, UpdateColumnLongest)
#pragma alloc_text (SG48, DrawSelCurItemsInView)
#endif

#ifdef CNRS3P1_C
#pragma alloc_text (SG7, CnrProcessSetFocus)
#pragma alloc_text (SG9, CnrTrackSplitbar, IsOverSplitbar, WorkspaceToScreen)
#pragma alloc_text (SG10, CnrRemoveDetailFieldInfo)
#pragma alloc_text (SG14, DrawTrackRect, WinTrackRect)
#pragma alloc_text (SG26, CnrAllocDetailFieldInfo)
#pragma alloc_text (SG27, CnrLeftDetailsWndProc)
#pragma alloc_text (SG33, CnrRightDetailsWndProc)
#pragma alloc_text (SG35, CnrDragIcon, DrawDraggedIcon, ScreenToWorkspace)
#pragma alloc_text (SG36, CnrFreeDetailFieldInfo)
#pragma alloc_text (SG39, CnrHorzScrollSplitWindow)
#pragma alloc_text (SG43, CnrQueryDetailFieldInfo)
#pragma alloc_text (SG44, DrawBlinkEmphBox)
#pragma alloc_text (SG48, DrawCursorTargetRecord, DrawSelectionRecord, xSetTimer)
#endif

#ifdef CNRS3P2_C
#pragma alloc_text (SG7, NotifyOwner)
#pragma alloc_text (SG10, CnrDestroy)
#pragma alloc_text (SG14, CnrButtonState)
#pragma alloc_text (SG28, CnrEdgeProc, CnrGateProc)
#pragma alloc_text (SG35, CnrCreate, CnrInitNLSInfo)
#pragma alloc_text (SG42, CnrChangeCursor)
#pragma alloc_text (SG44, CnrDisplayData)
#pragma alloc_text (SG46, CnrStartDirectEdit)
#endif

#ifdef CNRS3P3_C
#pragma alloc_text (SG7, CnrDrawEmphChange)
#pragma alloc_text (SG11, CnrTRVDrawEmphChange)
#pragma alloc_text (SG17, EraseIconOnlyInIV, EraseTextOnlyInIV)
#pragma alloc_text (SG19, CnrPaintEdgeWin)
#pragma alloc_text (SG23, CnrIsRecordInTree, CnrVerifyPointers)
#pragma alloc_text (SG44, BlinkCursoredEmph)
#pragma alloc_text (SG48, CnrSetBlinkTimer)
#endif

#ifdef CNRS3P4_C
#pragma alloc_text (SG1, CnrDrawBoxOutline, SetEmphasisBits)
#pragma alloc_text (SG9, CnrQueryViewportRect, CnrSetRecordEmphasis)
#pragma alloc_text (SG11, CnrScrollWindow)
#pragma alloc_text (_STORSEG, CnrAllocRecord)
#pragma alloc_text (SG36, CnrQueryRecordRect)
#pragma alloc_text (SG37, ResetWindowForFontChange)
#pragma alloc_text (SG38, CnrQueryRecordFromRect, CnrQueryRowRectForDV)
#pragma alloc_text (SG39, CnrRefreshColors)
#pragma alloc_text (SG41, CnrQueryRecordEmphasis, IsInRoot)
#pragma alloc_text (SG44, CnrProcessTimer)
#pragma alloc_text (SG45, CnrQueryRecordInfo)
#endif

#ifdef CNRS3P5_C
#pragma alloc_text (SG1, CnrProcessMouseMove)
#pragma alloc_text (SG8, CnrProcessMouseButton1Up)
#pragma alloc_text (SG14, CnrProcessMouseButton1Down, TRVProcessButton1Down)
#pragma alloc_text (SG20, CnrProcessChar)
#pragma alloc_text (SG37, CnrFindRecordStringMatch, CnrProcessCharKey, CnrProcessSearchString)
#pragma alloc_text (SG37, CnrQueryRecordStringText)
#pragma alloc_text (SG39, GetHomeOrEndInIconView)
#pragma alloc_text (SG40, CnrProcessOpenEdit)
#pragma alloc_text (SG42, CnrResetCursorRecord, CnrSetCursorFirstItemInView)
#pragma alloc_text (SG44, SelectDeselectAll)
#endif

#ifdef CNRS3P6_C
#pragma alloc_text (SG20, CnrFindAndDeemphasizeRecords)
#pragma alloc_text (SG37, CnrSetRect)
#pragma alloc_text (SG38, FindRecordVert)
#pragma alloc_text (SG40, FindRecordHorz)
#pragma alloc_text (SG41, CalcScrollIncrementHorz)
#pragma alloc_text (SG42, CalcScrollIncrementVert, CnrExtendedSelection, ScrollToRecord)
#pragma alloc_text (SG48, CnrSetRecordSelection)
#endif

#ifdef CNRS4P1_C
#pragma alloc_text (SG1, CnrTRVCalcTreeIconSize)
#pragma alloc_text (SG4, TRVGetNextItem)
#pragma alloc_text (SG9, IsTreeVisible)
#pragma alloc_text (SG11, CnrTRVEraseItem)
#pragma alloc_text (SG12, CnrPaintTreeView, CnrTreeVCtlProc, CnrTRVSetScroll, TRVCheckNeedResize)
#pragma alloc_text (SG15, CnrTRVSetFirstItem)
#pragma alloc_text (SG18, CnrPositionTreeView, TRVGetCy, TRVNodeLevel, TRVPositionRecords)
#pragma alloc_text (SG22, CnrTRVDrawItem, CnrTRVDrawLine, CnrTRVQueryIconTextRect)
#pragma alloc_text (SG22, CnrTRVQueryPtOfItem, GetLineTop, TRVDrawRecords, TRVhasVisibleChild)
#pragma alloc_text (SG23, GetNextUnfilteredItem, GetPrevUnfilteredItem, TRVFindLastUnfiltered)
#pragma alloc_text (SG23, TRVGetNextVisualItem, TRVGetPrevVisualItem, TRVIsAncestor)
#pragma alloc_text (SG26, TRVFindTreePirs)
#pragma alloc_text (SG35, TRVFindPirs)
#pragma alloc_text (SG42, TRVMoveCursor)
#pragma alloc_text (SG43, TRVFindLast, TRVGetPrevItem)
#pragma alloc_text (SG45, TRVGetRoot)
#endif

#ifdef STORWIN_C
#pragma alloc_text (_STORSEG, AllocateSystemStorage, AllocMem, CommonFreeStorage, GrowSeg)
#pragma alloc_text (_STORSEG, ReleaseSystemStorage, StmAllocateStorage, StmDecrementUseCount)
#pragma alloc_text (_STORSEG, StmFreeStorage, StmIncrementUseCount, StmInitStorageSpace)
#pragma alloc_text (_STORSEG, StmTermStorageSpace)
#endif


#endif // CNRPRAGW header guard
