#ifndef _CNRCBN_
#define _CNRCBN_

/* Revision: 02 1.3.3.1 source/ui/cclnt/cnr/cnrcbn.h, cclcnr, ioc.v400, 001006  */
/**********************************************************************/
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*        (IBM Confidential-Restricted when combined with the         */
/*         aggregated OCO source modules for this program)            */
/*                                                                    */
/*                       OCO SOURCE MATERIALS                         */
/*                                                                    */
/*         20G0400 (C) Copyright IBM Corp. 1992, 1997 (Unpublished)   */
/*                                                                    */
/* ================================================================== */
/*                                                                    */
/*                         C O N T A I N E R                          */
/*                                                                    */
/*                        Filename: CNRCBN.H                          */
/*                                                                    */
/*             ( Windows NT Container Control Component )             */
/*                                                                    */
/*                         IBM CONFIDENTIAL                           */
/*                                                                    */
/*                (C) Copyright IBM Corporation 1997                  */
/*                       All Rights Reserved                          */
/*            Licensed Material - Program Property of IBM             */
/*                                                                    */
/**********************************************************************/
/******************************************************************************/
/* Product: ICLUINT.DLL                                                       */
/* Filename: CNRCBN.H - Internal control block header file for the            */
/*                      container control                                     */
/*                                                                            */
/* Flag    Date    InitialsDescription                                        */
/* ----  --------  ------  -------------------------------------------------- */
/* DAB1  11/16/93          Initial modifications for NT execution             */
/* DAB2  01/19/94          Corrected parameter declaration errors             */
/* DAB3  03/17/94          Fix International string overwriting problem       */
/* DAB4  03/17/94          Fix direct edit for container w/in a dialog        */
/* EVB1  01/19/96          Added CnrQueryColors                               */
/* MAB1  02/09/96  6613    Rename "CCL Xxxx" window classes to "ICL Xxxx"     */
/* D7092 08/06/96  LJO     Add support for icon sizing.                       */
/******************************************************************************/
#if defined(__IBMC__)
#pragma info(nocnd)
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

/**********************************************************************/
/* Offset in the window words to the pointer to CNRINFO               */
/**********************************************************************/
#define QWL_CONTAINER   (0)
#define QWL_STORAGEPTR  (QWL_CONTAINER + sizeof(DWORD))
#define QWL_CNRSIZE     (QWL_STORAGEPTR + sizeof(DWORD))

/**********************************************************************/
/* Window class defines                                               */
/**********************************************************************/
#define WC_EDGE        "ICL Container Edge"                            //->@MAB1
#define WC_CNRTITLE    "ICL Container Title"
#define WC_LDETAIL     "ICL Container LDetail"
#define WC_RDETAIL     "ICL Container RDetail"
#define WC_LCOLTITLE   "ICL Container LColumn Title"
#define WC_RCOLTITLE   "ICL Container RColumn Title"                   //@MAB1<-

/**********************************************************************/
/* added in support of windows as replacement for BLTMODE_SRC_BITMAP  */
/**********************************************************************/
#define SRC_BITMAP   1L

/**********************************************************************/
/* added in support of WinTrackRect function in PM                    */
/**********************************************************************/
typedef struct _TRACKINFO {
    int     cxBorder;
    int     cyBorder;
    int     cxGrid;
    int     cyGrid;
    int     cxKeyboard;
    int     cyKeyboard;
    RECT    rclTrack;
    RECT    rclBoundary;
    POINT   ptlMinTrackSize;
    POINT   ptlMaxTrackSize;
    WORD    fs;
} TRACKINFO;
typedef TRACKINFO FAR *LPTRACKINFO;

/**********************************************************************/
/* Internal structure for tracking record data specific information   */
/**********************************************************************/
typedef struct _RECORDCOREN  /* reccn */
{
  HANDLE                  hwndCnr;          /* Handle to container window    */
  struct _RECORDCOREN FAR *preccnNext;      /* ptr to next internal record   */
  struct _RECORDCOREN FAR *preccPrevItem;   /* ptr to prev rec in item order */
  struct _RECORDCOREN FAR *preccNextItem;   /* ptr to next rec in item order */
  struct _RECORDCOREN FAR *preccPrevZ;      /* ptr to prev rec in zorder     */
  struct _RECORDCOREN FAR *preccNextZ;      /* ptr to next rec in zorder     */
  struct _RECORDCOREN FAR *preccParent;     /* ptr to parent in tree         */
  struct _RECORDCOREN FAR *preccFirstChild; /* ptr to first child            */
  DWORD                   flRecordAttr;     /* record attributes             */
  POINT                   ptlIcon;          /* Position of record in Icon V. */
  POINT                   ptlNonIconPos;    /* item pos for non-icon view    */
  SIZEL                   slTextSize;       /* cx and cy of text for each    *///@B02
                                            /* record                        */
  WORD                    usLongestLine;    /* longest text line in flowed   */
                                            /* column                        */
  BOOL                    flSelecting;      /* selection state for marquee   */
  WORD                    RowHeight;        /* Height of each row in DV.     */
  LPRECORDCORE            preccX;           /* ptr to external RecordCore    */
} RECORDCOREN, FAR *LPRECORDCOREN;

/*******************************************************************/
/* Internal data structure definitions                             */
/*******************************************************************/
typedef struct _ICONRESIZED
{
   WORD         cUsage;                     /* count how many records shares */
   HICON        hptrOrigin;                 /* handle of the original ptr    */
   HBITMAP      hbmPointer;                 /* handle of the first bitmap    */
   HBITMAP      hbmColor;                   /* handle of the second bitmap   */
   POINT        slIcon;                     /* size of the icon              */
   struct _ICONRESIZED FAR *pirsNext;       /* ptr to next resized icon str  */
} ICONRESIZED, FAR *LPICONRESIZED;

typedef struct _MARQUEEREC
{
   LPRECORDCOREN           pRecord;
   BOOL                    fSelected;
   struct _MARQUEEREC FAR *pmrNextItem;
   struct _MARQUEEREC FAR *pmrPrevItem;
} MARQUEEREC, FAR *LPMARQUEEREC;

/**********************************************************************/
/* Data structure for CM_INSERTRECORD                                 */
/**********************************************************************/
typedef struct _RECORDINSERTN {  /* recinsn */
    DWORD          cb;
    BOOL           fInvalidateRecord;
    WORD           cRecordsInsert;
    LPRECORDCOREN  pRecordOrderN;
    LPRECORDCOREN  pRecordParentN;
    LPRECORDCOREN  zOrderN;
} RECORDINSERTN;
typedef RECORDINSERTN FAR *LPRECORDINSERTN;

/**********************************************************************/
/* Internal structure for tracking container data specific information*/
/**********************************************************************/
typedef struct _CNRINFON  /* ccinfon */
{
  LPRECORDCOREN preccLastValid;      /* ptr to last valid item        */
  LPRECORDCOREN preccItem;           /* ptr to record for item order  */
  LPRECORDCOREN preccLastItem;
  LPRECORDCOREN preccZ;              /* ptr to z order record         */
  LPRECORDCOREN preccZTail;          /* ptr to last z order item      */
  LPRECORDCOREN preccCursor;         /* ptr to the record which has   */
                                     /* the cursor                    */
  LPRECORDCOREN preccFirstinAutoPosIV;/* ptr to the first item in     */
                                     /* Auto Positioned Icon View     */
  LPRECORDCOREN preccFirstinNV;      /* ptr to the first item in name */
                                     /* view                          */
  LPRECORDCOREN preccFirstinTV;      /* ptr to the first item in text */
                                     /* view                          */
  LPRECORDCOREN preccFirstinFNV;     /* ptr to the first item in      */
                                     /* flowed name view              */
  LPRECORDCOREN preccFirstinFTV;     /* ptr to the first item in      */
                                     /* flowed text view              */
  LPRECORDCOREN preccFirstRowInDV;   /* pointer to the first row      */
                                     /* (record) in view.             */
//  LPRECORDCOREN preccLastinNV;       /* ptr to the last  item in name */
//                                     /* view                          */
//  LPRECORDCOREN preccLastinTV;       /* ptr to the last  item in text */
//                                     /* view                          */
//  LPRECORDCOREN preccLastinFNV;      /* ptr to the last  item in      */
//                                     /* flowed name view              */
//  LPRECORDCOREN preccLastinFTV;      /* ptr to the last  item in      */
                                     /* flowed text view              */
  LPRECORDCOREN preccFirstinTRV;     /* ptr to the first item in tree */
                                     /* view                          */
//  LPRECORDCOREN preccLastRowInDV;    /* pointer to the last  row      */
//                                     /* (record) in view.             */
//  LPRECORDCOREN pRecordDrop;         /* pointer to the dropped record */
//  CNRDRAGINFO  cnrDragInfo;          /* CnrDragInfo structure.        */
  LPFIELDINFO   pFIFirstColLeftInDV; /* pointer to the first column   */
                                     /* in view in the left window.   */
  LPFIELDINFO   pFIFirstColRightInDV;/* pointer to the first column   */
                                     /* in view in the right window.  */
  LPFIELDINFO   pFILastColLeftInDV;  /* pointer to the last column in */
                                     /* view in the left window.      */
  LPFIELDINFO   pFILastColRightInDV; /* pointer to the last column in */
                                     /* view in the right window.     */
  LPRECORDCOREN preccTarget;         /* ptr to the item with target   */
                                     /* emphasis                      */
  LPRECORDCOREN preccSelTarget;      /* ptr to the selection target   */
  LPRECORDCOREN preccEdit;           /* ptr to the record which is to */
                                     /* be direct edited.             */
  LPRECORDCOREN preccAnchor;         /* anchor pt for extended sel    */
  LPRECORDCOREN preccLastMouse;      /* last record mouse was over    */
  LPRECORDCOREN preccPrevEndOfRange; /* Previous Range sel. term. rec.*/
  LPMARQUEEREC  pmrFirstMarquee;     /* First Marquee Record in view. */
  LPMARQUEEREC  pmrLastMarquee;      /* Last Marquee Record in view.  */
  BOOL          fFirstMouseMove;     /* flag for first mouse mov. mes.*/
  LPFIELDINFO   pFirstFI;            /* ptr to first FieldInfo        */
  LPFIELDINFO   pFIEdit;             /* Pointer to the column which   */
                                     /* is being direct edited.       */
  HWND          hwndEdit;            /* hwnd in which edit processed  */
  LPFIELDINFO   pFirstVisibleFI;     /* ptr to first visible FieldInfo*/
  LPFIELDINFO   pFieldInfoLast;      /* pointer to last column in     */
                                     /*   left pane of a split window.*/
  LPICONRESIZED pirsMetrics;         /* ptr to the metrics of resized */
                                     /* bitmaps.                      */
  LPICONRESIZED pirsMiniMetrics;     /* ptr to the metrics of resized */
                                     /* bitmaps for mini view.        */
  LPICONRESIZED pirsTreeMetrics;     /* ptr to the metrics of resized */
                                     /* bitmaps for tree view.        */
  POINT         ptlNonIconOrg;       /* viewport org in non-icon view */
  POINT         ptlStart;            /* starting pt for marquee sel   */
  POINT         ptlEnd;              /* ending pt for marquee sel     */
  POINT         ptlInitDrag;         /* starting pt for dragging      */
  POINT         ptlPrevIconOrg;      /* org before maximizing cnr     */
//  PCNRDRAGINIT  pCnrDragInit;        /* drag initialization structure */
  DWORD         dragRecordEmphPos;   /* orderedtargetepmhasis flag    */
  DWORD         ulFlagSet;           /* used for the flags below and  */
                                     /* more. see Flag Set Definition */
  DWORD         ulFlagSet2;          /* used for the flags below and  */
                                     /* more. see Flag Set Definition */
  RECT          rctlWorkplaceItems;  /* rectangle of the workplace    */
  RECT          rctlWorkplace;       /* rectangle of the workplace    */
  int           lMaxHeight;          /* height of the tallest item    */
                                     /* in N/T view used to set V     */
                                     /* scroll in flowed V            */
  int           xTreeRight;          /* Rightmost point of tree       */
  int           yTreeBottom;         /* Bottommost point of tree      */
  int           sVscrollPos;         /* position of  V scroll bar     */
                                     /* slider pos                    */
  int           sHscrollPos;         /* position of  H scroll bar     */
                                     /* slider pos                    */
  int           sVscrollMax;         /* max pos  of  V scroll bar     */
                                     /* slider                        */
  int           sHscrollMax;         /* max pos  of  H scroll bar     */
                                     /* slider                        */
  int           sHscrollPosRight;    /* Positon of H scrollbar slider */
                                     /* in Right window of DV.        */
  int           sHscrollMaxRight;    /* Max positon of H scrollbar    */
                                     /* slider in Right window of DV. */
  int           sVscrollFactor;      /* minimum unit for scrolling    */
  int           sHscrollFactor;      /* minimum unit for scrolling    */
  WORD          usEndDragMsg;        /*                               */
  HICON         hptrSplitPtr;        /* Handle of the Pointer for the */
                                     /* Splitbar in Details View.     */
  DWORD         pfnwpMLE;            /* pointer to MLE Win Proc       */
  CNREDITDATA   ceData;              /* pointer to current edit data  */
  BOOL          fAnchorState;        /* Selection state of anchor pt  */
  long          RightWndxOrg;        /* This is the x origin of the   */
                                     /* Right window in Details View. */
                                     /* For all other views, we use   */
                                     /* ptlNonIconOrg.  It is used for*/
                                     /* the left window in Details    */
                                     /* View, and we need another for */
                                     /* the right window.             */
  WORD          MaxColTitleHeight;   /* Height of the tallest column  */
                                     /* title.                        */
  POINT         FirstTitlePos;       /* x,y position of the first     */
                                     /* column title in Details View. */
  SIZEL         slFirstTitleSize;    /* width and height of the first */
                                     /* column title in Details View. */
  SIZEL         slCnrTitle;          /* Size of CnrContainerTitle.    */
  BOOL          MilitaryFormat;      /* 12 or 24 hour time format.    */
  DWORD         DateFormat;          /* Date Format - DMY, YMD, MDY.  */
  BOOL          LeadingZero;         /* Leading Zero pad.             */
  char          Thousands[2];        /* Thousands separator string.   */
  char          DateSep[2];          /* Date Separator string.        */
  char          TimeSep[2];          /* Time Separator string.        */
  char          AM[9];               /* Antemeridiem string.          *//*DAB3*/
  char          PM[9];               /* Postmeridiem string.          *//*DAB3*/
  DWORD         ulColorPPSupport[5]; /* Color ref for color support   */
//  WORD          CnrTitleHeight;      /* Height of container title.    */
  int           lAveCharWidth;       /* Font's average character width*/
  int           lMaxBaselineExt;     /* Font's maximum baseline extnsn*/
  int           lMaxAscender;        /* Font's max ascending height   */
  int           lMaxDescender;       /* Font's max decending depth    */
  int           lExternalLeading;    /* Font's add'l space between row*/
  LPRECORDCORE  preccFreeFirst;
  LPRECORDCORE  preccFreeLast;
  LPRECORDINSERTN pRecordInsertN;    /* ptr to the internal record    */
                                     /* insert data structure.        */
  BOOL          bRPZinDlgRet;        /* Return val for CN_REALLOCPSZ  *//*DAB4*/
                                     /* if cnr is in dialog           *//*DAB4*/
  HFONT         hCnrFont;            /* Font for the container to use */
} CNRINFON, FAR *LPCNRINFON;

/*---------------------*/
/* handy helper macros */
/*---------------------*/
#define LPSTRATOFFSET(precc,off) (*((PLPSTR)(((LPBYTE) precc) + off)))
#ifndef IDOF
#define IDOF(hwnd)         (GetWindowLong (hwnd, GWL_ID))
#endif
#ifndef STYLEOF
#define STYLEOF(hwnd)      (GetWindowLong (hwnd, GWL_STYLE))
#endif
#define PSATOF(hwnd)       ((LPVOID)GetWindowLong (hwnd, QWL_STORAGEPTR))
#define PCCINFONOF(hwnd)   ((LPCNRINFON)GetWindowLong (hwnd, QWL_CONTAINER))
#define OLDHEIGHTOF(hwnd)  (HIWORD(GetWindowLong (hwnd, QWL_CNRSIZE)))
#define OLDWIDTHOF(hwnd)   (LOWORD(GetWindowLong (hwnd, QWL_CNRSIZE)))
#define SAVESIZEOF(hwnd, x) (SetWindowLong (hwnd, QWL_CNRSIZE, (DWORD)x))


#define CNRDLLNAME         ICL_CONTAINER_DLL /* defined in iclcnrw.h */

#ifndef PARENTOF
#define PARENTOF(hwnd)     (GetParent (hwnd))
#endif
#ifndef OWNEROF
#define OWNEROF(hwnd)      (GetWindow (hwnd, GW_OWNER))
#endif
#define WINDOWFROMPOINT(hwnd,ptl,fChildren) \
                           (ChildWindowFromPoint (hwnd, ptl))
//#define CnrAllocateStorage(a,b)  (StmAllocateStorage(a,b))
//#define CnrFreeStorage(a,b)      (StmFreeStorage(a,b))

#define SETERROR(err) {}

/*---------------------------------------------------------------------*/

/**********************************************************************/
/* Internal structure for tracking fieldinfo data specific information*/
/**********************************************************************/
typedef struct _FIELDINFON {
  LPFIELDINFO pNextFieldInfo;
  LPFIELDINFO pNextVisibleFI;
  LPSTR       pszTitle16;
  BOOL        fTitleCopied;
  WORD        usLongestLine;
} FIELDINFON, FAR *LPFIELDINFON;

/**********************************************************************/
/* Internal structure for returning font information for MLE setup    */
/**********************************************************************/
typedef struct _MLEINFO {
  long        lAveCharWidth;        /* Font's average character width*/
  long        lMaxBaselineExt;      /* Font's maximum baseline extnsn*/
} MLEINFO, FAR *LPMLEINFO;


typedef  LPWORD         FAR *PLPWORD;
typedef  HICON          FAR *PHICON;
typedef  HBITMAP        FAR *PHBITMAP;
typedef  LPSTR          FAR *PLPSTR;
typedef  LPFIELDINFO    FAR *PLPFIELDINFO;
typedef  LPRECORDCOREN (FAR *PALPRECORDCOREN)[1];
typedef  LPSTR         (FAR *PALPSTR)[1];
typedef  LPRECORDCORE   FAR *PLPRECORDCORE;
typedef  LPRECORDCOREN  FAR *PLPRECORDCOREN;

/*******************************************************************/
/* Error Definitions                                               */
/*******************************************************************/
#define ERRORFLAG  -1

/*******************************************************************/
/* Constant definitions                                            */
/*******************************************************************/
#define SPLITBARPTR  100         /* Definition for Splitbar Pointer */
#define TREEPLUS     101         /* Definition for Tree plus bitmap */
#define TREEMINUS    102         /* Definition for Tree minus bitmap*/
#define NUM_ODD      0x00000001L
#define MAX_EXTRA_BYTES  64000
#define MAX_SEGMENT_SIZE 65500
#define    ROUND     15
#define    NEG16    -16

/* Define some constants that represent the maximum sizes of the date,
 * time, and number strings...plus a few extra bytes for grins.
 */
#define DATESIZE  26
#define TIMESIZE  26
#define NUMSIZE   30

/*******************************************************************/
/* Icon Control Constants                                          */
/*******************************************************************/
#define ICN_EMPHSPACE     0x0004
#define ICN_SELSPACE      0x0002
#define ICN_BOXSPACE      0x0002
#define ICN_SIDEMARGIN    0x0001
#define ICN_TOPMARGIN     0x0001
#define TXT_SIDEMARGIN    0x0001
#define TXT_BTMMARGIN     0x0001
#define TXT_TOPMARGIN     0x0001
//#define WIN_TARGETEMPHSPACE 0x0001
#define TITLE_MARGIN      0x0003

#define FUZZY_RANGE          3
#define WIN_MARGIN        0x0002

#define CX_BETWEENLINES   0x0004
#define CY_BETWEENLINES   0x0004

#define IN_ITEM  1
#define IN_Z     2

#define PT_TOP            0x0001
#define PT_BOTTOM         0x0002
#define PT_LEFT           0x0004
#define PT_RIGHT          0x0008

#define DRAW_ICON     0x0001
#define DRAW_TEXT     0x0002
#define DRAW_CURSOR   0x0004
#define ERASE_CURSOR  0x0008

#define DE_ICON        0x0001
#define DE_TREEICON    0x0002
#define DE_TEXT        0x0004

#define MINCX_TREELEFTMARGIN 0x0005
#define MINCY_BETWEENITEMS   0x0002

/*******************************************************************/
/* icon style                                                      */
/*******************************************************************/
#define IS_MINI          0x0001
#define IS_REGULAR       0x0002
#define IS_SIDETEXT      0x0004
#define IS_BENEATHTEXT   0x0008
#define IS_SIDERIGHTTEXT 0x0010

/*******************************************************************/
/* Record direction flags (FindRecordVert and FindRecordHorz)      */
/*******************************************************************/
#define RD_LEFT          0x00000001L
#define RD_RIGHT         0x00000010L
#define RD_ABOVE         0x00000100L
#define RD_BELOW         0x00001000L

#ifdef DRAG_DONE
/*******************************************************************/
/* Drag target emphasis flags                                      */
/*******************************************************************/
#define DRAGTARGETEMPHOFF     0x00000001L
#define DRAGTARGETEMPHON      0x00000010L
#define DRAGTARGETEMPHWINDOW  0x00000100L
#define DRAGTARGETEMPHRECORD  0x00001000L
#define DRAGTARGETEMPHABOVE   0x00010000L
#define DRAGTARGETEMPHBELOW   0x00100000L
#endif
/*********************************************************************/
/* icon attributes                                                   */
/*********************************************************************/
#define IC_SELECTED    0x00000001L  /* record is selected            */
#define IC_TARGET      0x00000002L  /* record has target emphasis    */
#define IC_CURSORED    0x00000004L  /* cursor is on the record       */
#define IC_INUSE       0x00000008L  /* record has in-use emphasis    */
#define IC_FILTERED    0x00000010L  /* record has been filtered      */
#define IC_HIDDEN      0x00000020L  /* record is hidden              */
#define IC_DISABLED    0x00000040L  /* record has disabled emphasis  */

/*********************************************************************/
/* Flag set definition                                               */
/*********************************************************************/
/* used for the positioning and painting : first 8 bits (Tai) */
#define FL_TEXTCALC      0x00000001L
#define FL_CNRPOSITION   0x00000002L
#define FL_CNRWINOPEN    0x00000004L /* Cnr Window is open : ON     */
#define FL_NEWVIEWSCROLLSET 0x00000008L /* When change view set off */
                                     /* : used in setting scroll bar*/
#define FL_SETCNRTITLE   0x00000010L /* When created or changed  */
                                      /* font for the title, is 0   */
                                     /* to reset cnr title when painting */
#define FL_SETWORKPLACE  0x00000020L /* When created or changed  */
                                     /* font or invalidated item   */
                                     /* to reset workplace when painting */
#define FL_NEEDARRANGE   0x00000040L /* need rearrangement or not*/
#define FL_SIZECHILDREN  0x00000080L /* need resizing children   */
#define FL_SETSCROLL     0x01000000L /* need resetting scroll bar*/
#define FL_ITEMNUMCHANGED  0x80000000L /* autopos - readjust workpl*/

/* used for the dragging and ...    : next 8 bits (Diana)   */
#define FL_DRAGPROGRESS  0x00000100L
#define FL_WINTARGETEMPH 0x00000200L
#define FL_SHIFTKEY      0x00000400L   /* Shift key up or down      */
#define FL_CTRLKEY       0x00000800L   /* Ctrl key up or down       */
#define FL_ALTKEY        0x00001000L   /* Alt key up or down        */
#define FL_ADDMODE       0x00002000L   /* Shift + F8 - Select emph  */

/* used for the selection and ... : last 8 bits (Ruth)      */
#define FL_CAPTURE       0x00010000L   /* marquee sel, track rect   */
#define FL_SHIFTARROW    0x00020000L   /* shift+arrow selection     */
#define FL_DRAGSELECT    0x00040000L   /* swipe sel in progress     */
#define FL_BUTTON1DOWN   0x00080000L   /* swipe sel in progress     */

#define FL_TIMER         0x00100000L   /* timer for swipe sel       */
#define FL_BLINK         0x00200000L   /* box is drawn or not       */
#define FL_EDITMODE      0x00400000L   /* MLE is open if TRUE       */

/* Flags used for Details View.   Peter H.                          */
#define FL_UNSPLIT       0x00800000L   /* The app. specified that   */
                                       /* Details View was to be    */
                                       /* unsplit. ie. 1 window.    */
#define FL_SIZECOLTITLES 0x02000000L   /* Size the Column Titles    */
#define FL_POSITIONCOLTITLES 0x04000000L /*Position Column Titles   */
#define FL_BELOWINVRECT  0x08000000L   /* Below the invalid Rect    */
#define FL_RIGHTOFINVRECT 0x10000000L  /* Right of the invalid Rect */

#define FL_SETFIRSTINVIEW 0x20000000L  /* Right of the invalid Rect */
#define FL_SELECTING      0x40000000L  /* Indicates if we are in the*/
                                       /* process of Selecting in DV*/

#define FL2_HDYNAMICSCROLL 0x00000001L
#define FL2_VDYNAMICSCROLL 0x00000002L
//#define FL2_SCROLLDOWNLEFT  0x00000004L
//#define FL2_SCROLLDOWNRIGHT 0x00000008L
#define FL2_SCROLLRIGHT     0x00000010L
#define FL2_BUTTONLEFT      0x00000020L
#define FL2_BUTTONRIGHT     0x00000040L
#define FL2_FOCUSLEFT       0x00000080L
#define FL2_MINIMIZED       0x00000100L
#define FL2_WINDOWSIZED     0x00000200L
#define FL2_MAXIMIZED       0x00000400L
#define FL2_ONTREENODE      0x00000800L
#define FL2_INITPAINT       0x00001000L
#define FL2_TITLESIZECALC   0x00002000L
#define FL2_NULLCONTEXT     0x00004000L

#define FL2_WMKEYDOWNPROC   0x80000000L  //prevent double processing of
                                         //expand '+' & collapse '-' keys

/********************************************************************/
/* Flags for QuickSort                                              */
/********************************************************************/
#define QSF_ZORDER       0x00000001L   /* sort z-order tree         */
#define QSF_ITEMORDER    0x00000002L   /* sort itemorder tree       */
#define QSF_SIBLINGORDER 0x00000004L   /* sort sibling tree         */

/********************************************************************/
/* Flags for set emphasis bits                                      */
/********************************************************************/
#define SEB_SET        1
#define SEB_CLEAR      2
#define SEB_TOGGLE     3
#define SEB_REPLACE    4

/*******************************************************************/
/* Selection Constants                                             */
/*******************************************************************/
#define SELECT          0x0001
#define DESELECT        0x0002
#define TOGGLE          0x0004
#define CNR_AUTOSCROLL  0x0008

/*******************************************************************/
/* IDs                                                             */
/*******************************************************************/
#define ID_TIMER       0xFF10

/*******************************************************************/
/* helper macros                                                   */
/*******************************************************************/
#define PRECCXFROMLPVOID(pMem)    ((LPRECORDCORE) ((LPDWORD)pMem + 1))
#define LPVOIDFROMPRECCX(precc)   ((LPVOID) ((LPDWORD)precc - 1))
#define PRECCFIRSTNFROMX(preccx) (*(PLPRECORDCOREN)((LPDWORD)preccx-1))
#define PFINFROMX(pfi)           (((LPFIELDINFON) pfi) - 1)
#define PFIXFROMN(pfi)           ((LPFIELDINFO) (pfi + 1))
#define NEXTFI(pfi)              (PFINFROMX(pfi)->pNextFieldInfo)
#define NEXTVISIBLEFI(pfi)       (PFINFROMX(pfi)->pNextVisibleFI)
#define PCCINFOXFROMN(pccinfon)  ((LPCNRINFO) (pccinfon + 1))
#define COPYNDATATOX(preccn)                            \
 {                                                      \
   preccn->preccX->flRecordAttr = preccn->flRecordAttr; \
   preccn->preccX->ptlIcon = preccn->ptlIcon;           \
 }
#define COPYNATTRTOX(preccn)                            \
   preccn->preccX->flRecordAttr = preccn->flRecordAttr;
#define COPYNPTLTOX(preccn)                             \
   preccn->preccX->ptlIcon = preccn->ptlIcon;

//#define GETPS(hwnd)(GetDC(hwnd))/*twn02*/
//#define GETPS(hwnd)((HDC)WinGetClipPS((HANDLE)hwnd, NULL, PSF_CLIPCHILDREN|PSF_CLIPSIBLINGS))/*twn02*/

//#define RELEASEPS(hwnd, hps) (ReleaseDC(hwnd, (HDC)hps))

#ifndef MAKEHDC
#define HDCBIT         0x00000001L
#define MAKEHDC(hps)   (HDC)((DWORD)hps & ~HDCBIT)
#endif

//#define GETDRAGCOOR(pDragInfo, dragCoor) { }
//#define SETCNRDRAGINFO(pRecordT, pSDragInfo){}

#define  ISRECORDVISIBLE(pRecord)                                       \
                         !(pRecord->flRecordAttr & CRA_FILTERED)
#define  GETCYCHAR(pccin)  (pccin->lMaxAscender +       \
                            pccin->lMaxDescender +      \
                            pccin->lExternalLeading)

#define GETLPSTRFORNV(preccx) ((preccx->cb == sizeof(RECORDCORE)) ?  \
                            preccx->pszName : preccx->pszIcon)

#define GETLPSTRFORTV(preccx) ((preccx->cb == sizeof(RECORDCORE)) ?  \
                            preccx->pszText : preccx->pszIcon)

#define GETLPSTRFORTRV(preccx) ((preccx->cb == sizeof(RECORDCORE)) ? \
                             preccx->pszTree : preccx->pszIcon)

#define ISRECORDVISIBLEINVIEW(pccinfo, precord)                       \
                         (precord &&                                  \
                          ISRECORDVISIBLE(precord) &&                 \
                          ((!(pccinfo->flWindowAttr & CV_TREE) &&     \
                            !precord->preccParent) ||                 \
                           ((pccinfo->flWindowAttr & CV_TREE) &&      \
                            IsTreeVisible(precord))))

/**********************************************************************/
/* Procedures declared in CNRS1P1.C                                   */
/**********************************************************************/
LRESULT CALLBACK CnrDetailsVCtlProc (HWND, UINT, WPARAM, LPARAM);       /*JEH1*/
LRESULT CALLBACK CnrLeftColumnTitlesProc (HWND, UINT, WPARAM, LPARAM);  /*JEH1*/
LRESULT CALLBACK CnrRightColumnTitlesProc (HWND, UINT, WPARAM, LPARAM); /*JEH1*/
BOOL FAR  CnrAllColumnsFixedWidth (HANDLE);
VOID FAR CnrCreateNLSDateString (HANDLE, LPCDATE, LPSTR);
VOID FAR CnrCreateNLSTimeString (HANDLE, LPCTIME, LPSTR);
LPSTR  FAR CnrBuildDateTimeString (int, LPSTR, LPSTR, BOOL);
VOID FAR reverse (LPSTR);
BOOL FAR CnrCreateNLSNumberString (HWND, DWORD, LPSTR);
BOOL FAR CnrColTitleHeightChanged (HANDLE);
VOID FAR CnrCalcCellRectForDV (HANDLE, LPRECORDCOREN, LPFIELDINFO, BOOL,
                                BOOL, LPRECT);
BOOL FAR  CnrOpenColDataTextMLE (HANDLE, long, long, BOOL);
BOOL FAR  OpenColDataTextMLE (HANDLE, LPRECORDCOREN, LPFIELDINFO, BOOL);
VOID FAR CnrOpenColTitleTextMLE (HANDLE, int, int, BOOL);
BOOL FAR  OpenColTitleTextMLE (HANDLE, LPFIELDINFO, BOOL);
VOID FAR CnrCalcColumnRect (HANDLE, LPFIELDINFO, BOOL, LPRECT);
LPFIELDINFO FAR CnrOverColumn (HANDLE, long, long, BOOL);
VOID FAR CnrCalcRectForDVTitles (HANDLE, LPFIELDINFO, SIZEL,
                                  BOOL, RECT, LPRECT);
VOID FAR CnrCalcRectForDV (HANDLE, LPRECORDCOREN, LPFIELDINFO, SIZEL,
                            BOOL, RECT, LPRECT);
VOID FAR  CnrCalcRowRect (HANDLE, LPRECORDCOREN, BOOL, LPRECT);
VOID FAR CnrCalcSelectionRect (HANDLE, LPRECORDCOREN, LPFIELDINFO,
                                BOOL, LPRECT);
BOOL FAR CnrDrawColumnTitlesLeft (HANDLE, HDC, RECT);
BOOL FAR CnrDrawColumnTitlesRight (HANDLE, HDC, RECT);

/**********************************************************************/
/* Procedures declared in CNRS1P2.C                                   */
/**********************************************************************/
int  FAR  CnrQueryColumnPosInDV (HANDLE, LPFIELDINFO, LPFIELDINFO,
                                 BOOL, BOOL);
VOID FAR  CnrQueryColumnTitleWndRect (HANDLE, BOOL, LPRECT);
LPFIELDINFO FAR CnrQueryLastColumnInView (HANDLE, LPFIELDINFO, BOOL);
int  FAR  CnrQueryRowPosInDV (LPRECORDCOREN, long);
BOOL FAR  CnrRowHeightChanged (HANDLE, LPRECORDCOREN);
VOID FAR CnrSetFirstColInView (HANDLE, BOOL);
VOID FAR  CnrSetFirstRowInView (HANDLE, LPRECORDCOREN, BOOL);
VOID FAR  CnrSizeColumnTitleWindows (HANDLE, int, int);
BOOL FAR  CnrVerifyFieldInfoPtrs (HANDLE, LPFIELDINFO, WORD);           /*DAB2*/
BOOL FAR CnrProcessTitleData (HANDLE, HDC, LPFIELDINFO, long,
                          RECT, BOOL, BOOL);
BOOL FAR CnrProcessColumnData (HANDLE, HDC, LPRECORDCOREN, LPFIELDINFO,
                           RECT, BOOL, BOOL);
VOID FAR  CnrProcessVisibleColumns (HANDLE);
BOOL FAR  CnrInvalidateDetailFieldInfo (HANDLE);
BOOL FAR  CnrInViewRect (HANDLE, RECT, RECT);
VOID FAR  CnrPaintSplitbar (HANDLE, HDC);
VOID FAR  CnrPositionColumnTitles (HANDLE, HDC);
BOOL FAR  CnrPositionDetailsView (HANDLE, HDC, LPRECORDCOREN);

/**********************************************************************/
/* Procedures declared in CNRS1P3.C                                   */
/**********************************************************************/
BOOL FAR  CnrDrawLeftDetailsWindow (HANDLE, HDC, RECT);
BOOL FAR  CnrDrawRightDetailsWindow (HANDLE, HDC, RECT);
LPRECORDCOREN FAR CnrGetFirstItemInRect (HWND, RECT);
BOOL FAR  CnrDrawEraseRow (HANDLE, LPRECORDCOREN, BOOL);
VOID FAR  CnrDrawHorzSep (HANDLE, HDC, LPFIELDINFO, long, BOOL);
VOID FAR  CnrDrawVertSep (HANDLE, HDC, BOOL, BOOL);
LPVOID FAR CnrGetColumnData (HANDLE, LPRECORDCORE, LPFIELDINFO);
VOID FAR CnrHScrollDetailsView (HWND hwndCnr, HWND hwndHscroll, int nThumbPos,
                                UINT wNotifyCode);
VOID FAR CnrVScrollDetailsView (HWND hwndCnr, HWND hwndHscroll, int nThumbPos,
                                UINT wNotifyCode);
VOID FAR  CnrSetDetailsViewScroll (HANDLE);
WORD FAR CnrInsertDetailFieldInfo (HANDLE, long, long);

/**********************************************************************/
/* Procedures declared in CNRS1P4.C                                   */
/**********************************************************************/
LRESULT CALLBACK  MLESubProc (HWND, UINT, WPARAM, LPARAM);              /*JEH1*/
VOID FAR  CnrCalcIconSize (HANDLE, LPPOINT);
BOOL FAR  CnrCloseMLE (HANDLE);
HANDLE FAR CnrCreateMLE (HANDLE, LPSTR, RECT, WORD);
VOID FAR  CnrDrawCursorBox (HANDLE, HDC, LPRECORDCOREN, RECT, BOOL);
VOID FAR  CnrDrawIconOnly (HANDLE, HDC, LPRECORDCOREN, int, RECT, RECT);
BOOL FAR  CnrSetupDrawInfo (HANDLE hwndCnr, LPRECORDCOREN precord,
                    HBITMAP FAR *hbmDraw, LPICONRESIZED FAR *pirsDraw);
VOID FAR  CnrDrawTextOnly (HANDLE, HDC, LPRECORDCOREN, int, RECT, RECT);
BOOL FAR  CnrDrawRecord (HANDLE, HDC, LPRECORDCOREN, BOOL);
BOOL FAR  CnrEraseRecord (HANDLE, HDC, LPRECORDCOREN);
HWND FAR  CnrOpenTitleTextMLE (HWND);
HWND FAR  CnrOpenRecordTextMLE (HWND, long);
HWND FAR OpenRecordTextMLE (HWND, LPRECORDCOREN);
VOID FAR  CnrPaintCnrTitleWin (HANDLE);
VOID FAR CnrQueryClientRect (HANDLE, LPRECT);
VOID FAR  CnrQueryIconTextRect (HANDLE, LPRECORDCOREN, LPPOINT,
                                BOOL, LPRECT, LPRECT);
VOID FAR  CnrQueryScrollBarRect (HANDLE, LPRECT, LPRECT);
VOID FAR  CnrQueryTitleRect (HANDLE, LPRECT, LPRECT);
VOID FAR  CnrQuerySizeRect (HANDLE, LPPOINT, LPRECT, LPRECT, LPRECT,
                            LPRECT);
BOOL FAR CnrQueryTitleTextRect (HANDLE, HDC, LPRECT);
BOOL FAR  CnrSaveTextCloseMLE (HANDLE);
BOOL FAR  CnrSetDrawItem (HWND, HDC, LPDRAWITEMSTRUCT, int);
VOID FAR CnrQueryFontMetrics (HANDLE hwndCnr, HANDLE hwndQuery,
                   BOOL bDesktop, LPMLEINFO pMLEInfo, PFATTRS pFattrs);
VOID FAR  DrawSeparator (HDC, LPRECT, LPCNRINFON);
LRESULT CALLBACK  CnrTitleProc (HWND, UINT, WPARAM, LPARAM);            /*JEH1*/
BOOL FAR InvalidateForEdit (HANDLE);

/**********************************************************************/
/* Procedures declared in CNRS1P5.C                                   */
/**********************************************************************/
BOOL FAR CnrDrawEraseNameText (HANDLE, HDC, LPRECORDCOREN, BOOL);
BOOL FAR CnrDrawNameTextViewItem (HANDLE, HDC, LPRECORDCOREN, LPPOINT);
BOOL FAR  CnrPaintNameTextView (HANDLE, HDC, LPRECT);
BOOL FAR  CnrDrawIcon (HANDLE, HDC, LPRECORDCOREN, BOOL);
VOID FAR  CnrEraseIcon (HANDLE, HDC, LPRECORDCOREN, BOOL);
BOOL FAR  xDrawIcon (HANDLE, HDC, LPRECORDCOREN, LPPOINT);
VOID FAR  IcnCalcTextSize (HDC, POINT, LPCNRINFON, LPSTR, DWORD,
                           PSIZEL);
VOID FAR  IcnDrawBox (HDC, DWORD, LPRECT);
VOID FAR  IcnDrawIcon (HDC, LPICONRESIZED, HBITMAP, DWORD,
                       RECT, LPCNRINFON);
VOID FAR  IcnDrawText (HDC, LPSTR, RECT, DWORD, DWORD,
                        LPCNRINFON);
VOID FAR IcnDrawIconInDV (HDC, LPICONRESIZED, HBITMAP, DWORD,
                           RECT, RECT, BOOL, LPCNRINFON);
VOID FAR IcnDrawTextInDV (HDC, LPSTR, RECT, RECT, DWORD,
                            DWORD, LPCNRINFON);
VOID FAR IcnDrawInUseEmph (HDC, RECT, LPCNRINFON);
VOID FAR IcnDrawSelectEmph (HDC, RECT, BOOL, LPCNRINFON);
BOOL FAR CnrPaintBackground (HANDLE, HDC, LPRECT);
WORD FAR CnrStrcspn (LPSTR, LPSTR);

/**********************************************************************/
/* Procedures declared in CNRS2P1.C                                   */
/**********************************************************************/
LRESULT CALLBACK  CnrNameTextVCtlProc (HWND, UINT, WPARAM, LPARAM);     /*JEH1*/
VOID CalcTextSizeInIV (HANDLE, HDC);
VOID FAR CnrPositionNameTextView (HANDLE, HDC, LPRECORDCOREN);
int  FAR  CnrQueryPtOfItemInNTV (HANDLE, LPRECORDCOREN, LPPOINT, long);
VOID FAR CnrSetFirstItemInNTV (HANDLE, LPRECORDCOREN, BOOL);
VOID FAR CnrSetFirstItemInNFNTV (HANDLE, LPRECORDCOREN, BOOL);
VOID FAR CnrSetFirstItemInFlowedNTV (HANDLE, LPRECORDCOREN, BOOL);
//VOID FAR  CnrSetLastItemInView (HANDLE hwndCnr, BOOL flowFlag);
LPRECORDCOREN FAR  CnrGetLastItemInView (HWND hwndCnr);
VOID FAR CnrSetNameTextViewScroll (HANDLE, BOOL);
VOID FAR CnrSetNFNameTextViewScroll (HANDLE);
void FAR SetVscrollInNFView (HANDLE, HANDLE, int, int, RECT);
void FAR SetHscrollInNFView (HANDLE, LPCNRINFON, int, int, RECT);
VOID FAR CnrSetFlowedNameTextViewScroll (HANDLE, BOOL);
BOOL FAR PASCAL CnrEnumWindowsProc(HWND, DWORD);

/**********************************************************************/
/* Procedures declared in CNRS2P2.C                                   */
/**********************************************************************/
BOOL FAR CnrUpdateDetailsViewIcons(HANDLE);
LPRECORDCOREN FAR  CnrOverRecord(HANDLE hwnd,int xPos,int yPos);
LPRECORDCOREN FAR  CnrTRVOverRecord(HANDLE, int, int);
int FAR  CalcScrollFactor(HANDLE, int, BOOL);
LPRECORDCOREN FAR GetFirstItemInView(HANDLE);
BOOL FAR CnrChangeSizeInIRSMetrics(HANDLE);
BOOL FAR CnrChangeSizeInIRSTreeMetrics(HANDLE);
VOID FAR CnrSetupIconPirsInfo (HANDLE hwndCnr, LPRECORDCORE pRecord,
                                BOOL fsRegular, HICON FAR *hptrCurr,
                                LPICONRESIZED FAR * FAR *pirsCurr);
LPICONRESIZED FAR  FindPirs(HANDLE, LPRECORDCORE, BOOL);
LPICONRESIZED FAR  FindPirsForDV(HANDLE, HICON);
BOOL FAR CnrOpenIRSMetrics(HANDLE);
BOOL FAR CnrInsertDeleteResizedIcon(HANDLE, LPRECORDCORE, BOOL, BOOL);
BOOL FAR CnrTRVInsDelResizedIcon (HANDLE, LPRECORDCORE, BOOL);
BOOL FAR CnrTRVInsDelResizedTreeIcon (HANDLE, BOOL);
BOOL FAR CnrInsertDeleteResizedIconInDV (HANDLE, HICON, BOOL);
BOOL FAR InsertDeleteResizedIcon (HANDLE hwnd, LPICONRESIZED FAR *ppirsFirst,
                             HICON hptrResize, POINT iconSize,
                             BOOL fsInsert);
BOOL FAR CnrDeleteAllResizedIcon (HANDLE);
VOID FAR  CnrEraseRect (HANDLE, HDC, RECT);
BOOL FAR  CnrProcessIconsForDV (HANDLE, LPRECORDCOREN, LPFIELDINFO,
                                BOOL, BOOL);
VOID FAR CnrSizeCnrTitle (HANDLE, HDC, RECT);
VOID FAR CnrUpdateTitleSize(HWND, HDC);
BOOL FAR CnrUpdateWorkplace(HANDLE, HDC, LPRECORDCOREN, BOOL);
VOID FAR GetIconTextRectInWorkplace(HWND, LPRECORDCOREN, LPPOINT,
                                PSIZEL, LPRECT, LPRECT);
VOID FAR GetMinInvalidateRect(HANDLE hwnd, LPRECT prctlInvalid);
BOOL FAR GetNewWorkplace (HANDLE);
//VOID FAR QuickSort (HANDLE, PALPRECORDCOREN, long, long, long, long);
//VOID FAR swap(PALPRECORDCOREN, DWORD, DWORD);
VOID FAR HeapSort(PALPRECORDCOREN, long, DWORD, DWORD);
VOID FAR FixHeap(PALPRECORDCOREN, long, LPRECORDCOREN, long,
                  DWORD, DWORD);
VOID FAR UpdateMaxHeightForDel (HANDLE, LPRECORDCOREN);
BOOL FAR UpdateWorkplaceForInsert (HANDLE, LPRECT, LPRECT);
BOOL FAR UpdateWorkplaceForDelete (HANDLE, LPRECT, LPRECT, LPRECT);
VOID FAR IcnCalcTileSize (LPPOINT, PSIZEL, DWORD, LPCNRINFON,
                          PSIZEL);
VOID FAR IcnDrawScaledIcon (HDC, LPICONRESIZED, int, int, LPCNRINFON, BOOL);
VOID FAR CnrBltStretch (HDC hdcSrc, HDC hdcDst, int xSrc,
                  int ySrc, int  cxSrc, int  cySrc, int xDst,
                  int yDst, int  cxDst, int  cyDst, DWORD rop, DWORD mode);/* D7092 */
VOID FAR IcnResizeIcon(LPICONRESIZED, HWND, POINT);                 /* D7092 */
HBITMAP FAR CopyBitmap (HBITMAP hbm, WORD cx, WORD cy, DWORD flBlt,
                    HDC vhpsMem);                                   /* D7092 */

/**********************************************************************/
/* Procedures declared in CNRS2P3.C                                   */
/**********************************************************************/
BOOL FAR CnrArrangeIconView (HANDLE, HDC);
BOOL FAR CnrTRVExpandCollapse (HANDLE, UINT, LPRECORDCOREN);            /*DAB1*/
BOOL FAR TRVExpandCollapseAll (HANDLE, DWORD, DWORD, WORD);
void FAR TRVInvalidateFrom(HANDLE, HDC, LPCNRINFON, LPRECORDCOREN);
void FAR TRVInvalidateForExpCol(HANDLE, LPRECORDCOREN);
BOOL FAR CnrFilter(HANDLE, long, long);
long FAR CnrInsertRecord(HANDLE, long, long);
VOID FAR CalcTextSize (HANDLE hwndCnr, LPRECORDCOREN preccNew,
                       POINT iconSize);
BOOL FAR ConvertPRItoPRIN(HANDLE, LPRECORDINSERT);
LPRECORDCOREN InsertRecordsInChain(HANDLE hwnd, LPRECORDINSERTN pRecordInsertN,
                                   LPRECORDCORE preccInsert);
BOOL InsertRecord(HANDLE, LPRECORDCOREN, LPRECORDCOREN,
                  LPRECORDCOREN, LPRECORDCOREN, BOOL);
BOOL FAR InvalidateForInsert(HANDLE, HDC, LPRECORDCORE, LPRECORDCOREN,
                              LPRECORDINSERT, BOOL);
VOID FAR InvalidateContainer (HANDLE hwnd, BOOL bInvalidateAll,
                               LPRECT prctlInvalid);
VOID FAR GetInvalidateRect(HANDLE, LPRECORDCOREN, LPRECT);
VOID FAR TRVGetInvalidateRect (HANDLE hwnd, LPRECORDCOREN preccInvalid,
                               LPRECT prctlInvalid);
VOID FAR CnrSetUpNewView(HANDLE hwndCnr, HDC hps);
BOOL FAR CnrTRVSetUpNewView (HANDLE, HDC);
BOOL FAR CnrSetUpNewViewForDV (HANDLE, HDC);
VOID FAR InvalidateChildren (HANDLE hwnd, BOOL bEraseBackground,
                             BOOL bSizingDetails);

/**********************************************************************/
/* Procedures declared in CNRS2P4.C                                   */
/**********************************************************************/
LRESULT CALLBACK  CnrIconVCtlProc (HWND, UINT, WPARAM, LPARAM);         /*JEH1*/
BOOL FAR CheckNeedResize (HANDLE hwndCnr);
LPVOID FAR FindFirstIteminColumn (HANDLE, LPRECORDCOREN);
BOOL FAR CnrPaintIconView (HANDLE, HDC, LPRECT);
VOID FAR CnrINTViewHScroll (HWND, HWND, int, WORD);                     /*JEH1*/
VOID FAR CnrINTViewVScroll (HWND, HWND, int, WORD);                     /*JEH1*/
VOID FAR CnrSetFirstItemAutoPosIconV (HANDLE, LPRECORDCOREN, BOOL);
LPRECORDCOREN FAR FindFirstIteminRow (HANDLE, LPRECORDCOREN);
VOID FAR CnrSetIconViewScroll (HANDLE);
VOID FAR SetScrollBar (HANDLE, HANDLE, int, int, int, int,
                  LPINT, LPINT, LPINT, BOOL);
BOOL FAR IsInIconViewport(LPRECORDCOREN, LPPOINT, LPRECT, LPPOINT);
BOOL FAR CnrInvalidateRecord (HANDLE, long, long);
BOOL FAR InvalidateRecord (HANDLE, PLPRECORDCOREN, WORD, WORD);
BOOL FAR TRVInvalidateRecord (HANDLE, PLPRECORDCOREN, WORD, WORD);

/**********************************************************************/
/* Procedures declared in CNRS2P5.C                                   */
/**********************************************************************/
VOID FAR UpdateFirstItemInView (HANDLE, LPRECORDCOREN);
VOID FAR CnrResetInstanceData(HANDLE);
BOOL FAR CnrSetCnrInfo(HANDLE, long, long);
VOID FAR InitWindowViewAttr(HANDLE);
BOOL FAR DestroyDVWindows(HWND hwnd);
BOOL FAR CreateDVWindows(HWND hwnd);
VOID FAR TRVProcessOpenTree(HANDLE);
VOID FAR TRVProcessCloseTree(HANDLE);
BOOL FAR CnrSort(HANDLE, long, long, BOOL);
BOOL FAR ProcessChangeLineSpace (HANDLE);
BOOL FAR ProcessChangePSortRecord (HANDLE);
VOID FAR ProcessChangeOrigin (HANDLE);
VOID FAR CnrSize (HANDLE hwnd, UINT cxNew, UINT cyNew);
BOOL FAR CnrFreeAll (HANDLE hwnd, BOOL FreeRecords);
VOID FAR CnrRemoveAllInternal (HANDLE);
BOOL FAR CnrFreeRecord (HANDLE hwnd, long mp1,
                           long mp2, BOOL Verify);
BOOL FAR CnrFreeViewRecord (LPRECORDCOREN preccn, LPVOID pSatPtr);

/**********************************************************************/
/* Procedures declared in CNRS2P6.C                                   */
/**********************************************************************/
LPRECORDCOREN FAR GetRecordNFromX (HANDLE, LPRECORDCORE);
LPRECORDCOREN FAR CnrAllocRecordN (HANDLE, LPRECORDCORE);
LPRECORDCOREN FAR AllocRecordN (HANDLE, LPRECORDCORE);
BOOL FAR DrawSelCurItemsInView( HANDLE, HDC, BOOL);
BOOL FAR Before1stInView(HANDLE, LPRECORDCOREN);
BOOL FAR AfterLastInViewport(HANDLE hwnd, LPRECORDCOREN preccInvalid);
BOOL FAR CallQuickSort(HANDLE, long, long, LPRECORDCOREN, BOOL);
BOOL FAR CheckFirstInView(HANDLE);
BOOL FAR CnrProcessDelta(HANDLE,BOOL);
WORD FAR CnrQueryCnrInfo(HANDLE hwnd, long mp1, long mp2);
LPRECORDCORE FAR  CnrQueryRecord(HANDLE, long, long);
LONG FAR CnrRemoveRecord (HANDLE, long, long);
VOID FAR FreeRecords (HANDLE);
BOOL FAR IsBefore(HANDLE, LPRECORDCOREN, LPRECORDCOREN);
LPRECORDCOREN FAR UpdateFirstDel  (HANDLE, LPRECORDCOREN, LPRECORDCOREN);
BOOL FAR NeedUpdateWorkplace (HANDLE, HDC, LPRECORDCOREN);
VOID FAR UpdateCursorForDel(HANDLE, LPRECORDCOREN);
VOID FAR DeleteRecord(HANDLE, LPRECORDCOREN, BOOL);
VOID FAR CnrRemoveRecordN (HANDLE, LPRECORDCORE, WORD);
VOID FAR RemoveChildrenRecordN (HANDLE, LPRECORDCOREN, WORD);
VOID FAR RemoveRecordN (HANDLE, LPRECORDCOREN, WORD);
LPRECORDCOREN FAR GetNextVisualItem (HANDLE, LPRECORDCOREN);
LPRECORDCOREN FAR GetPrevVisualItem (HANDLE, LPRECORDCOREN);
LPRECORDCOREN FAR GetNextItem (LPCNRINFON, LPRECORDCOREN);
LPRECORDCOREN FAR GetPrevItem (LPCNRINFON, LPRECORDCOREN);
BOOL FAR InvalidateForRemove (HANDLE hwnd, HDC hps, LPRECORDCOREN preccInvalid,
                              BOOL invalidateAll, WORD cNumRecords,
                              LPRECORDCORE FAR *pRecordArray);
BOOL FAR TRVInvalidateForRemove (HANDLE, HDC, LPRECORDCOREN, BOOL);
BOOL FAR ChangeItemHeight (HANDLE, LPRECORDCOREN, SIZEL, POINT);
BOOL FAR ChangeRowHeight (HANDLE, LPRECORDCOREN, SIZEL);
WORD FAR ChangeColumnLength (LPRECORDCOREN, SIZEL);
VOID FAR UpdateColumnLongest (HANDLE, LPRECORDCOREN, WORD);

/**********************************************************************/
/* Procedures declared in CNRS3P1.C                                   */
/**********************************************************************/
LRESULT CALLBACK  CnrLeftDetailsWndProc (HWND, UINT, WPARAM, LPARAM);   /*JEH1*/
LRESULT CALLBACK  CnrRightDetailsWndProc (HWND, UINT, WPARAM, LPARAM);  /*JEH1*/
LPFIELDINFO FAR CnrAllocDetailFieldInfo (HANDLE, long);
//VOID FAR CnrDrawTargetEmphBInDV (HANDLE, LPRECORDCOREN, DWORD);
BOOL FAR CnrFreeDetailFieldInfo (HANDLE, long, long);
INT FAR CnrRemoveDetailFieldInfo (HANDLE, long, long);
LPFIELDINFO FAR CnrQueryDetailFieldInfo (HANDLE, long, long);
BOOL FAR CnrHorzScrollSplitWindow (HANDLE, int, long);
VOID FAR CnrTrackSplitbar (HWND);
BOOL FAR CnrProcessSetFocus (HWND, BOOL);
VOID FAR DrawBlinkEmphBox (HANDLE, HDC, LPRECORDCOREN, DWORD);
BOOL FAR DrawCursorTargetRecord (HANDLE, HDC, LPRECORDCOREN, DWORD, BOOL);
BOOL FAR DrawSelectionRecord (HANDLE, HDC, LPRECORDCOREN, BOOL, BOOL);
BOOL FAR xSetTimer (HANDLE, WORD, BOOL);
BOOL FAR WinTrackRect (HWND, LPTRACKINFO, HICON);
VOID FAR DrawTrackRect (HDC, LPRECT);
BOOL FAR CnrDragIcon (HWND, int, int);
BOOL FAR IsOverSplitbar (HWND, POINT);
VOID FAR WorkspaceToScreen (HWND hwnd, LPPOINT lppt);
VOID FAR ScreenToWorkspace (HWND hwnd, LPPOINT lppt);
BOOL FAR DrawDraggedIcon (HDC hdc, HICON hIcon, WORD x, WORD y, WORD fs);

#define DDI_START   0x0001
#define DDI_DRAG    0x0002
#define DDI_END     0x0004
#define DDI_ICON    0x0008
#define DDI_BITMAP  0x0010

/**********************************************************************/
/* Procedures declared in CNRS3P2.C                                   */
/**********************************************************************/
LRESULT CALLBACK  CnrGateProc (HWND, UINT, WPARAM, LPARAM);             /*JEH1*/
LRESULT CALLBACK  CnrEdgeProc (HWND, UINT, WPARAM, LPARAM);             /*JEH1*/
LONG FAR CnrButtonState (HANDLE hwnd, HDC hps, int xPos, int yPos,
                             LPRECORDCOREN pMouseRecord);
LONG FAR CnrCreate (HANDLE hwnd);
LONG FAR CnrDestroy (HANDLE hwndCnr);
VOID FAR CnrDisplayData (HANDLE);
VOID FAR CnrInitNLSInfo(HANDLE);
BOOL FAR CnrChangeCursor (HANDLE, LPRECORDCOREN, HDC, BOOL);
LONG FAR CnrStartDirectEdit( HWND, UINT, WPARAM, LPARAM );              /*DAB1*/
LONG FAR NotifyOwner(HWND hwnd, WORD usNotifyCode, LPVOID lpData);

/**********************************************************************/
/* Procedures declared in CNRS3P3.C                                   */
/**********************************************************************/
VOID FAR EraseIconOnlyInIV (HANDLE, HDC, LPRECORDCOREN, BOOL, BOOL);
VOID FAR  EraseTextOnlyInIV (HANDLE, HDC, LPRECORDCOREN);
VOID FAR BlinkCursoredEmph (HANDLE, HDC, LPRECORDCOREN, BOOL);
BOOL FAR CnrDrawEmphChange (HANDLE, HDC, LPRECORDCOREN, DWORD);
BOOL FAR  CnrTRVDrawEmphChange (HANDLE, HDC, LPRECORDCOREN, DWORD);
//VOID FAR CnrDrawRecTargetEmph (HANDLE, HDC, LPRECORDCOREN);
//VOID FAR CnrDrawTargetEmphB (HANDLE, HDC, LPRECORDCOREN, DWORD);
//VOID FAR CnrDrawWinTargetEmph (HANDLE, HDC, BOOL);
VOID FAR  CnrPaintEdgeWin (HANDLE hwnd);
BOOL FAR  CnrSetBlinkTimer (HANDLE);
BOOL FAR  CnrVerifyPointers (HANDLE, LPRECORDCORE FAR *, DWORD);        /*DAB2*/
BOOL FAR CnrIsRecordInTree (LPRECORDCOREN, LPRECORDCORE);

/**********************************************************************/
/* Procedures declared in CNRS3P4.C                                   */
/**********************************************************************/
LPRECORDCORE FAR CnrQueryRecordEmphasis (HANDLE, long, long);
BOOL FAR IsInRoot (HANDLE, LPRECORDCORE);
LPRECORDCOREN FAR CnrQueryRecordFromRect (HANDLE, long, long);
BOOL FAR CnrQueryRecordRect (HANDLE, long, long);
BOOL FAR CnrQueryViewportRect (HANDLE, long, long);
VOID FAR CnrQueryRowRectForDV (HANDLE, LPRECORDCOREN, LPRECT);
BOOL FAR CnrScrollWindow (HANDLE, long, long);
LONG FAR CnrProcessTimer (HWND, UINT, WPARAM, LPARAM);                  /*DAB1*/
//DWORD FAR CnrQueryRecordTargetEmphPos (HANDLE hwnd, LPRECORDCOREN pRecord,
//                                        long yPos );
//BOOL  FAR CnrDrawDragTargetEmph (HANDLE hwnd, LPRECORDCOREN pRecord,
//                                  DWORD dragEmphFlag);
//BOOL FAR IsEmphasisBetweenRecords (PCNRINFON pccinfon );
VOID FAR CnrDrawBoxOutline (HANDLE hwnd, HDC hps, POINT FAR *pptlStart,
                             POINT FAR *pptlEnd );
LPRECORDCORE FAR CnrAllocRecord (HANDLE, DWORD, WORD);                  /*DAB1*/
BOOL FAR CnrRefreshColors (HWND hwndCnr, LPCNRINFON pccinfon, WORD wCnrAttr,
                           COLORREF crColor);
LONG FAR CnrQueryColors (HWND hwndCnr, LPCNRINFON pccinfon, WORD wCnrAttr); /*EVB1*/
VOID FAR ResetWindowForFontChange (HANDLE);
BOOL FAR CnrSetRecordEmphasis (HANDLE, long, long );
BOOL FAR PASCAL InitContainer (void);
BOOL FAR SetEmphasisBits (HANDLE, HDC, LPRECORDCOREN, DWORD, WORD);
BOOL FAR CnrQueryRecordInfo (HANDLE, long, long);

/**********************************************************************/
/* Procedures declared in CNRS3P5.C                                   */
/**********************************************************************/
LPRECORDCOREN FAR CnrFindRecordStringMatch (HANDLE, LPRECORDCOREN,
                                            LPRECORDCOREN, LPSTR,
                                            BOOL, BOOL, DWORD, BOOL);
LPSTR  FAR CnrQueryRecordStringText (HANDLE, LPRECORDCORE, LPFIELDINFO,
                                     WORD);
BOOL FAR CnrProcessCharKey (HWND, UINT, HDC );                          /*DAB1*/
BOOL FAR CnrSetCursorFirstItemInView (HANDLE, HDC, BOOL);
BOOL FAR CnrResetCursorRecord (HANDLE, HDC, LPRECORDCOREN, BOOL);
BOOL FAR CnrProcessChar (HWND, UINT, WPARAM, LPARAM);                   /*DAB1*/
BOOL FAR SelectDeselectAll(HWND hwnd, HDC hps, WPARAM wParam);          /*DAB1*/
BOOL FAR CnrProcessMouseMove (HANDLE hwnd, LPARAM mp1);                 /*DAB1*/
LPRECORDCORE FAR CnrProcessSearchString (HANDLE, LPSEARCHSTRING,
                                         LPRECORDCORE);
BOOL FAR CnrProcessMouseButton1Down (HANDLE hwnd, long mp1);
BOOL FAR TRVProcessButton1Down (HANDLE hwnd, long mp1);
BOOL FAR CnrProcessMouseButton1Up (HANDLE hwnd);
BOOL FAR CnrProcessOpenEdit (HANDLE hwnd, long mp1);
LPRECORDCOREN FAR GetHomeOrEndInIconView (HWND hwnd, int Direction);             //yppb

/**********************************************************************/
/* Procedures declared in CNRS3P6.C                                   */
/**********************************************************************/
BOOL FAR CnrExtendedSelection (HANDLE, HDC, LPRECORDCOREN, WORD, BOOL);
BOOL FAR CnrSetRecordSelection (HANDLE, HDC, LPRECT);
VOID FAR CnrSetRect (LPRECT, LPPOINT, LPPOINT);
LPRECORDCOREN FAR FindRecordVert (HANDLE, LPRECORDCOREN, DWORD);
LPRECORDCOREN FAR FindRecordHorz (HANDLE, LPRECORDCOREN, DWORD);
LONG FAR CalcScrollIncrementVert (HANDLE, LPRECORDCOREN);
LONG FAR CalcScrollIncrementHorz (HANDLE, LPRECORDCOREN);
BOOL FAR ScrollToRecord (HANDLE hwnd, LPRECORDCOREN pRecordCursor,
          LPRECORDCOREN pRecordCursorNew, BOOL fSelect, BOOL fHToHawaii);
BOOL FAR  CnrFindAndDeemphasizeRecords (HANDLE, HDC, LPRECORDCOREN, long);

/**********************************************************************/
/* Procedures declared in CNRS4P1.C                                   */
/**********************************************************************/
LRESULT CALLBACK  CnrTreeVCtlProc (HWND, UINT, WPARAM, LPARAM);         /*JEH1*/
VOID FAR CnrPositionTreeView (HANDLE, HDC, LPRECORDCOREN);
INT  FAR TRVPositionRecords (HANDLE, HDC, LPRECORDCOREN, long, WORD,
                              WORD, WORD, WORD, POINT, POINT,
                              LPINT, LPINT);
BOOL FAR TRVCheckNeedResize (HANDLE hwnd);
VOID FAR CnrTRVSetScroll (HANDLE hwnd);
BOOL FAR  CnrPaintTreeView (HANDLE, HDC, RECT);
INT FAR TRVDrawRecords (HANDLE, HDC, LPRECORDCOREN, RECT,
                          POINT, POINT);
BOOL FAR CnrTRVDrawItem (HANDLE, HDC, LPRECORDCOREN, RECT,
                        RECT, RECT, WORD);
BOOL FAR CnrTRVEraseItem (HANDLE, HDC, LPRECORDCOREN, RECT,
                         RECT, RECT, WORD);
INT  FAR CnrTRVDrawLine (HANDLE, HDC, LPRECORDCOREN, POINT, RECT,
                         RECT, RECT);
WORD FAR TRVNodeLevel(LPRECORDCOREN);
BOOL FAR TRVIsAncestor(LPRECORDCOREN, LPRECORDCOREN);
LPRECORDCOREN FAR TRVGetRoot(LPRECORDCOREN preccObj);
WORD FAR TRVGetCy (HANDLE, LPRECORDCOREN, POINT, POINT);
int  FAR  CnrTRVQueryPtOfItem (HANDLE, RECT, RECT, RECT, long);
VOID FAR  CnrTRVQueryIconTextRect (HANDLE, LPRECORDCOREN, BOOL, POINT,
                                  POINT, LPRECT, LPRECT, LPRECT);
VOID FAR  CnrTRVCalcTreeIconSize (HANDLE, LPPOINT);
VOID FAR CnrTRVSetFirstItem (HANDLE, LPRECORDCOREN, BOOL);
LPRECORDCOREN FAR GetNextUnfilteredItem (LPRECORDCOREN);
LPRECORDCOREN FAR GetPrevUnfilteredItem (LPRECORDCOREN);
LPRECORDCOREN FAR TRVGetNextVisualItem (LPRECORDCOREN);
LPRECORDCOREN FAR TRVGetPrevVisualItem (HANDLE, LPRECORDCOREN);
LPRECORDCOREN FAR TRVGetNextItem(LPRECORDCOREN);
LPRECORDCOREN FAR TRVGetPrevItem(LPRECORDCOREN);
LPRECORDCOREN FAR TRVFindLastUnfiltered (HANDLE, LPRECORDCOREN);
LPRECORDCOREN FAR TRVFindLast(LPRECORDCOREN);
BOOL FAR TRVMoveCursor (HANDLE, HDC, LPRECORDCOREN);
LPICONRESIZED FAR TRVFindPirs (HANDLE, LPRECORDCOREN);
LPICONRESIZED FAR TRVFindTreePirs (HANDLE, LPRECORDCOREN);
BOOL FAR IsTreeVisible (LPRECORDCOREN);
BOOL FAR TRVhasVisibleChild (LPRECORDCOREN);
VOID FAR GetLineTop(HANDLE hwnd, LPCNRINFO pccinfo, LPRECORDCOREN preccItem,
                     POINT slIcon, POINT slTreeIcon,
                     LPPOINT pptlLineTop);

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // CNRCBN header guard
