// Revision: 84 1.6.1.8 source/ui/basectl/istrgen.hpp, listctls, ioc.v400, 001006 
#ifndef _ISTRGEN_
  #define _ISTRGEN_
/*******************************************************************************
* FILE NAME: istrgen.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IStringGenerator                                                         *
*     IStringGeneratorFn                                                       *
*     IStringGeneratorMemberFn                                                 *
*     IStringGeneratorRefMemberFn                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <imrefcnt.hpp>
#include <icntptr.hpp>
#include <istring.hpp>

#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

template < class T >
class IStringGeneratorFn : public IMRefCounted {

typedef IMRefCounted
  Inherited;

public:

  IStringGeneratorFn  ( ){}

virtual
 ~IStringGeneratorFn  ( ){}

/*------------------------- Generate String ----------------------------------*/
virtual IString
  stringFor           ( const T& object ) const = 0;

private:
/*------------------------- Hidden Members -----------------------------------*/
  IStringGeneratorFn  ( const IStringGeneratorFn<T>& generatorFunction );

IStringGeneratorFn<T>
 &operator=           ( const IStringGeneratorFn<T>& generatorFunction );

}; // class IStringGeneratorFn<T>



template < class T >
class IStringGeneratorasString : public IStringGeneratorFn<T> {

typedef IStringGeneratorFn<T>
  Inherited;

public:
/*------------------------- Constructors -------------------------------------*/
  IStringGeneratorasString ( );

virtual
 ~IStringGeneratorasString ( );

/*------------------------- Generate String ----------------------------------*/
virtual IString
  stringFor                ( const T& element ) const;

private:
/*------------------------- Hidden Members -----------------------------------*/
  IStringGeneratorasString ( const IStringGeneratorasString<T>&
                                generatorMemberFunction );

IStringGeneratorasString<T>
 &operator=                ( const IStringGeneratorasString<T>&
                                generatorMemberFunction );

/*------------------------- Private ------------------------------------------*/

}; // IStringGeneratorasString<T>



template < class T >
class IStringGeneratorMemberFn : public IStringGeneratorFn<T> {

typedef IStringGeneratorFn<T>
  Inherited;

public:
/*------------------------- Constructors -------------------------------------*/
  IStringGeneratorMemberFn ( IString ( T::* member )( ) );

virtual
 ~IStringGeneratorMemberFn ( );

/*------------------------- Generate String ----------------------------------*/
virtual IString
  stringFor                ( const T& object ) const;

private:
/*------------------------- Hidden Members -----------------------------------*/
  IStringGeneratorMemberFn ( const IStringGeneratorMemberFn<T>&
                                generatorMemberFunction );

IStringGeneratorMemberFn<T>
 &operator=                ( const IStringGeneratorMemberFn<T>&
                                generatorMemberFunction );

/*------------------------- Private ------------------------------------------*/

IString ( T::
 *memberFunction )( );

}; // IStringGeneratorMemberFn<T>





template < class T, class U>
class IStringGeneratorRefMemberFn : public IStringGeneratorFn<T> {

typedef IStringGeneratorFn<T>
  Inherited;

public:
/*------------------------- Constructors -------------------------------------*/
  IStringGeneratorRefMemberFn ( IString ( U :: *member )( ) );

virtual
 ~IStringGeneratorRefMemberFn ( );

/*------------------------- Generate String ----------------------------------*/
virtual IString
  stringFor                   ( const T& object ) const;


private:
/*------------------------- Hidden Members -----------------------------------*/
  IStringGeneratorRefMemberFn ( const IStringGeneratorRefMemberFn<T,U>&
                                   generatorRefMemberFunction );

IStringGeneratorRefMemberFn<T,U>
 &operator=                   ( const IStringGeneratorRefMemberFn<T,U>&
                                   generatorRefMemberFunction );

/*------------------------- Private ------------------------------------------*/
IString ( U::
 *memberFunction )( );
}; // IStringGeneratorRefMemberFn<T,U>





template <class Element> class IStringGenerator {

public:
/*------------------------- Constructors -------------------------------------*/
  IStringGenerator ( const ICountedPointerTo< IStringGeneratorFn<Element> >&
                                                      generatorFunction = 0 );

  IStringGenerator ( const IStringGenerator<Element>& stringGenerator );

IStringGenerator<Element>
 &operator=        ( const IStringGenerator<Element>& stringGenerator );

virtual
 ~IStringGenerator ( );

/*------------------------- Generate String ----------------------------------*/
IString
  stringFor        ( const Element& element ) const;

private:
/*------------------------- Private ------------------------------------------*/
ICountedPointerTo < IStringGeneratorFn<Element> >
  fgeneratorFunction;

}; // IStringGenerator<Element>

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if ! defined(__TEMPINC__)
#include <istrgen.c>
#endif

#endif  /* _ISTRGEN_ */
