// Revision: 80 1.32.2.1 source/ui/basectl/istattxt.cpp, staticctls, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: istattxt.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in istattxt.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

// #define IC_TRACE_ALL

extern "C" {
  #define INCL_WINSTATICS
  #define INCL_WINSYS
  #include <iwindefs.h>
}

#ifdef IC_MOTIF
  #include <imstring.hpp>
  #include <ixmlabel.hpp>
  #include <Xm/Label.h>
#endif

#include <istattxt.hpp>
#include <icconst.h>
#include <icolor.hpp>
#include <iexcept.hpp>
#include <ifont.hpp>
#include <ihandle.hpp>
#include <inotifev.hpp>
#include <iplatfrm.hpp>
#include <ipoint.hpp>
#include <irect.hpp>
#include <istathdr.hpp>
#include <istring.hpp>
#include <iwcname.hpp>
#include <ilanglvl.hpp>

#ifdef IC_WIN
  #include <ibrushdr.hpp>
#endif


// Segment definitions.
#ifdef IC_PAGETUNE
  #define _ISTATTXT_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| Public static text styles.                                                   |
------------------------------------------------------------------------------*/
#ifdef IC_PMWIN
const IStaticText::Style
  IStaticText::left              ( 0, IDT_LEFT ),
  IStaticText::top               ( 0, IDT_TOP ),
  IStaticText::underscore        ( 0, IDT_UNDERSCORE ),
  IStaticText::strikeout         ( 0, IDT_STRIKEOUT ),
#ifdef IC_PM
  IStaticText::center            = DT_CENTER,
  IStaticText::right             = DT_RIGHT,
  IStaticText::vertCenter        = DT_VCENTER,
  IStaticText::bottom            = DT_BOTTOM,
  IStaticText::wordBreak         = DT_WORDBREAK,
  IStaticText::mnemonic          = DT_MNEMONIC,
  IStaticText::halftone          = DT_HALFTONE,
  IStaticText::fillBackground    = DT_ERASERECT,
  IStaticText::border3D          ( 0 ),
  IStaticText::classDefaultStyle ( WS_VISIBLE | DT_ERASERECT,
                                   IDT_TOP | IDT_LEFT );
#endif
#ifdef IC_WIN
  IStaticText::center            = SS_CENTER,
  IStaticText::right             = SS_RIGHT,
  IStaticText::vertCenter        ( 0, IDT_VCENTER ),
  IStaticText::bottom            ( 0, IDT_BOTTOM ),
  IStaticText::wordBreak         ( 0, IDT_WORDBREAK ),
  IStaticText::mnemonic          ( 0, IDT_MNEMONIC ),
  IStaticText::halftone          ( 0, IDT_HALFTONE ),
  IStaticText::fillBackground    ( 0, IDT_ERASERECT ),
  IStaticText::border3D          ( 0, WS_EX_CLIENTEDGE ),
  IStaticText::classDefaultStyle ( WS_VISIBLE ,
                                   IDT_TOP | IDT_LEFT |
                                   IDT_ERASERECT );
#endif
#endif // IC_PMWIN

#ifdef IC_MOTIF
const IStaticText::Style
  IStaticText::left(DT_QUERYEXTENT),
  IStaticText::center(DT_CENTER),
  IStaticText::right(DT_RIGHT),
  IStaticText::top(DT_EXTERNALLEADING),
  IStaticText::vertCenter(DT_VCENTER),
  IStaticText::bottom(DT_BOTTOM),
  IStaticText::wordBreak(DT_WORDBREAK),
  IStaticText::mnemonic(DT_MNEMONIC),
  IStaticText::halftone(DT_HALFTONE),
  IStaticText::underscore(WS_MULTISELECT),
  IStaticText::strikeout(WS_ANIMATE),
  IStaticText::fillBackground(DT_ERASERECT),
  IStaticText::border3D          ( 0 ),
  IStaticText::classDefaultStyle =
                     DT_EXTERNALLEADING | DT_QUERYEXTENT |
                     WS_VISIBLE | DT_ERASERECT;
#endif // IC_MOTIF


/*------------------------------------------------------------------------------
| Default style for new objects (initial value).                               |
------------------------------------------------------------------------------*/
#ifdef IC_PM
  IStaticText::Style
      IStaticText::currentDefaultStyle ( WS_VISIBLE | DT_ERASERECT,
                                         IDT_TOP | IDT_LEFT );
#endif // IC_PM

#ifdef IC_WIN
  IStaticText::Style
      IStaticText::currentDefaultStyle ( WS_VISIBLE,
                                         IDT_TOP | IDT_LEFT | IDT_ERASERECT );
#endif // IC_WIN

#ifdef IC_MOTIF
  IStaticText::Style
      IStaticText::currentDefaultStyle =
                   ( DT_EXTERNALLEADING | DT_QUERYEXTENT | WS_VISIBLE |
                     DT_ERASERECT );
#endif // IC_MOTIF


#ifdef IC_WIN
/*******************************************************************************
* IStaticHandler class                                                         *
* This is a handler used only when the system static text control is painting  *
* the static text.  This handler responds to the messages used to retrieve the *
* colors for the control, and also insures correct hit test behavior.          *
* This handler is NOT needed when we are using an IStaticTextHandler object    *
* to draw the static text.                                                     *
*******************************************************************************/
#pragma enum(4)
#pragma pack(push,4)

class IStaticHandler : public IHandler
{
typedef IHandler
  Inherited;
public :
  IStaticHandler ( );
virtual
 ~IStaticHandler ( );

protected:
virtual bool
  dispatchHandlerEvent ( IEvent& event );
}; // IStaticHandler

#pragma pack(pop)
#pragma enum(pop)

#endif // IC_WIN

#ifdef IC_PMWIN
#pragma enum(4)
#pragma pack(push,4)

class IStaticTextData {
/*******************************************************************************
* The IStaticTextData class encapsulates private data and functions            *
* used by the IStaticText class.  An object of this class is created in the    *
* IStaticText constructors.  This is the os2/windows version.                  *
* Note:                                                                        *
*    The implementation of the IStaticTextHandler relies upon the fact that    *
*    a separate instance of it is created for each IStaticText control. It     *
*    stores a pointer to the IStaticText object.                               *
*******************************************************************************/
public:
  IStaticTextData ( );

 ~IStaticTextData ( );

#ifdef IC_WIN
IStaticHandler
  fStaticHandler;
IBrushHandler
  fBrushHandler;
#endif

IColor
  clrfill;

bool
  clrset,
  fDefaultAdded;

IStaticTextHandler
  fdefaultHandler;

static bool
  isDrawingHandlerNeeded ( unsigned long style,
                           unsigned long extStyle );
#ifdef IC_WIN
static IStaticText::Alignment
  alignmentFromStyle     ( unsigned long style,
                           unsigned long extendedStyle );
#endif
}; // IStaticTextData

#pragma pack(pop)
#pragma enum(pop)

/*------------------------------------------------------------------------------
| IStaticTextData::IStaticTextData                                             |
|                                                                              |
------------------------------------------------------------------------------*/
IStaticTextData::IStaticTextData ( )
  : clrfill( IColor::kPaleGray )
  , clrset( false )
#ifdef IC_WIN
  , fStaticHandler(  )
  , fBrushHandler( )
#endif
  , fDefaultAdded( false )
  , fdefaultHandler( )
{ }

/*------------------------------------------------------------------------------
| IStaticTextData::~IStaticTextData                                            |
|                                                                              |
------------------------------------------------------------------------------*/
IStaticTextData::~IStaticTextData ( )
{
}

#ifdef IC_WIN

/*------------------------------------------------------------------------------
| IStaticHandler::IStaticHandler                                               |
|                                                                              |
------------------------------------------------------------------------------*/
IStaticHandler::IStaticHandler ( )
{ }

/*------------------------------------------------------------------------------
| IStaticHandler::~IStaticHandler                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IStaticHandler::~IStaticHandler ( )
{ }

/*------------------------------------------------------------------------------
| IStaticHandler::dispatchHandlerEvent                                         |
|                                                                              |
------------------------------------------------------------------------------*/
bool IStaticHandler::dispatchHandlerEvent ( IEvent& event )
{
  switch( event.eventId() )
  {
    case WM_NCHITTEST:
    {
      bool result = false;
      IWindowHandle parent = IPARENTOF( event.handle() );
      if ( ! parent  ||
           IWindowClassName( parent ) != WC_BUTTON )
      {
         // Avoid HTTRANSPARENT from the Static window procedure to
         // allow mouse button presses and mouse enter/leaves on static
         // controls.
         MRESULT mr = IDEFWINDOWPROC( event.handle(),
                                      (UINT)event.eventId(),
                                      event.parameter1(),
                                      event.parameter2() );
         event.setResult( IEventResult( (unsigned long)mr ) );
         result = true;
      }
      else
      {
         // Allow default behavior to occur when the parent is a button
         // such as IGraphicPushButton, to allow the user to click in the
         // graphic.
      }
      return result;
    }
    default:
      break;
  }
  return false;
}
#endif // IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF
#pragma enum(4)
#pragma pack(push,4)

class IStaticTextData {
/*******************************************************************************
* The IStaticTextData class encapsulates private data and functions            *
* used by the IStaticText class.  An object of this class is created in the    *
*IStaticText constructors.                                                     *
* Note:                                                                        *
*    The implementation of the IStaticTextHandler relies upon the fact that    *
*    a separate instance of it is created for each IStaticText control. It     *
*    stores a pointer to the IStaticText object.                               *
*******************************************************************************/
public:
    IStaticTextData( )
                    : verticalAlignment (IStaticText::center),
                      minMarginHeight (0),
                      minMarginWidth (0),
                      isMnemonic (0),
                      fdefaultHandler(  ),
                      fOriginalText( ),
                      fModifiedForWrap( false )
                      { }
   ~IStaticTextData() { }

// Computes the layout of the text.  Returns the height of the text after it
// is formatted.  On return, the labelString argument contains the value to
// place in the widget's label resource.
long layoutText    ( IStaticText*           statictext,
                     IMString&              labelString,
                     IStaticText::Alignment newAlignment);

  IStaticText::Style verticalAlignment;
  Dimension          minMarginHeight,
                     minMarginWidth;
  bool               isMnemonic;
  IStaticTextHandler fdefaultHandler;
  IString            fOriginalText;
  bool               fModifiedForWrap;
private:
#if IC_EXTENDED_RTTI_ENABLED
  IStaticTextData ( const IStaticTextData& )
    : verticalAlignment (IStaticText::center)
  { }
#else
  IStaticTextData ( const IStaticTextData& );
#endif
  IStaticTextData& operator= ( const IStaticTextData& );
}; // IStaticTextData

#pragma pack(pop)
#pragma enum(pop)


/*------------------------------------------------------------------------------
| IStaticTextData::layoutText                                                  |
------------------------------------------------------------------------------*/
long IStaticTextData::layoutText( IStaticText*           statictext,
                                  IMString&              labelString,
                                  IStaticText::Alignment newAlignment)
{
  IFUNCTRACE_DEVELOP();
  long      result(0);
  Dimension height(0);
  XtVaGetValues(statictext->handle(), XmNheight, &height, 0);

  if (newAlignment == IStaticText::topLeftWrapped)
  {  //Modify the text if needed for word wrapping.

     // Get the current geometry of the widget to determine width of area
     // for text.
     Dimension borderWidth, shadowThickness, highlightThickness, width;
     XtVaGetValues (statictext->handle(),
                    XmNwidth,              &width,
                    XmNborderWidth,        &borderWidth,
                    XmNshadowThickness,    &shadowThickness,
                    XmNhighlightThickness, &highlightThickness,
                    0);
     ISize  textArea ( statictext->size().width() -
                         2 * (borderWidth + shadowThickness + highlightThickness) -
                         this->minMarginWidth,
                       statictext->size().height() -
                         2 * (borderWidth + shadowThickness + highlightThickness) -
                         this->minMarginHeight);
     long  maxWidth (textArea.width());

     // Get the current label text and modify it if needed for wrapping.
     IString text   (statictext->text() );
     this->fModifiedForWrap =
       IXmLabel::applyWordBreak( maxWidth,
                                 statictext->handle(),
                                 text,
                                 &(this->fOriginalText) );
     labelString = IMString(text);
  }
  else if (this->fModifiedForWrap)
  {  //Remove previous word wrap because it is no longer specified.
     this->fModifiedForWrap = false;
     labelString = IMString(fOriginalText);
     fOriginalText = IString();
  }
  else
  {  // Word wrapping modifications do not need to be added or removed.
     // Extract label from widget.
     labelString = IMString(statictext->handle(), XmNlabelString );
  }

  // Compute the vertical height of the text.
  // Vertical margin values depend on font size and number of lines of text.
  // Note: Using IMString::size is equivalent to calling displaySize() for the
  // labelString but saves a number of conversions to do the same thing.
  long textHeight = labelString.size( statictext->handle() ).height() ;
  result = MAX (0, height - textHeight);

  return result;
}

#endif // IC_MOTIF

/*------------------------------------------------------------------------------
| IStaticText::IStaticText                                                     |
|                                                                              |
| Constructor to create a static text control on a standard window.            |
------------------------------------------------------------------------------*/
IStaticText::IStaticText ( unsigned long ulId,
                           IWindow* pwndParent,
                           IWindow* pwndOwner,
                           const IRectangle& rectInit,
                           const Style& style )
  :  ulClLimit( 0 ),
     fStaticTextData(new IStaticTextData( ))
{
  // Assertions on input parms.
  IASSERTPARM( pwndParent != 0 );

  // Check the extended style value for defaults that may not be set
  // and update if appropriate
  unsigned long exStyle = extendedStyle() | style.asExtendedUnsignedLong();
#ifdef IC_WIN
  if ( !(exStyle & (IStaticText::vertCenter.asExtendedUnsignedLong() |
                    IStaticText::bottom.asExtendedUnsignedLong())))
#endif
#ifdef IC_MOTIFPM
  if ( !(style.asUnsignedLong() & (IStaticText::vertCenter.asUnsignedLong() |
                                   IStaticText::bottom.asUnsignedLong())))
#endif
    exStyle |= IStaticText::top.asExtendedUnsignedLong();

  if ( !(style.asUnsignedLong() & (IStaticText::right.asUnsignedLong() |
                                   IStaticText::center.asUnsignedLong())))
    exStyle |= IStaticText::left.asExtendedUnsignedLong();

  // Save the extended style to make sure we have a copy of it stored.
  this->setExtendedStyle( exStyle );

#ifdef IC_PMWIN
  unsigned long
    guiStyle = this->convertToGUIStyle( style );

  // Create static text control.
  IWindowHandle ownerHandle = IWindowHandle( 0 );
  if ( pwndOwner )
     ownerHandle = pwndOwner->handle();
  IWindowHandle whStaticText =
      this->create( ulId,
                    0,
                    guiStyle,
                    WC_STATIC,
                    pwndParent->handleForChildCreation(),
                    ownerHandle,
                    rectInit,
                    0,
                    0,
                    defaultOrdering(),
                    convertToGUIStyle( style, true ) );

  this->startHandlingEventsFor( whStaticText );

  exStyle = this->extendedStyle();
#ifdef IC_WIN
  if ( IBidiSettings::isBidiSupported() )
  {  // Explicitly set the alignment.  Not doing this on WinNT 4.0
     // with the WS_EX_RIGHT and/or WS_EX_RTLREADING styles results
     // in right-justified text, which IStaticTextHandler draws as
     // left-justified.
     Alignment
       alignment = IStaticTextData::alignmentFromStyle( guiStyle, exStyle );
     this->setAlignment( alignment );
  }
#endif

  if ( IStaticTextData::isDrawingHandlerNeeded( IStaticText::style(),
                                                exStyle ) )
  {
     this->addDrawingHandler();
  }
#ifdef IC_WIN
  else
  {
    fStaticTextData->fStaticHandler.handleEventsFor(this);
    fStaticTextData->fBrushHandler.handleEventsFor(this);
  }
#endif // IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF
  IWindowHandle  whStaticText;
  unsigned char  align;
  Arg            args[6];
  int            n = 0;
  Dimension      marginHeight, marginTop, marginBottom,
                 marginWidth, marginLeft, marginRight;

  if ( style != IWindow::noStyle )
  {
     //interpret style flags
     if (style & IStaticText::right)
        align = XmALIGNMENT_END;
     else if (style & IStaticText::center)
        align = XmALIGNMENT_CENTER;
     else  // default is IStaticText::left
        align = XmALIGNMENT_BEGINNING;

     XtSetArg(args[n], XmNalignment, align);  n++;

     if (style & IStaticText::mnemonic)
        fStaticTextData->isMnemonic = true;
  }

  // Don't want widget changing its size.
  XtSetArg (args[n], XmNrecomputeSize, false); n++;

  whStaticText =
     Inherited::create(
        ulId,
        NULL,
        style.asUnsignedLong(),
        (IXmCreateFunction)XmCreateLabel,
        pwndParent->handleForChildCreation(),
        pwndOwner ? pwndOwner->handle() : desktopWindow()->handle(),
        rectInit,
        args,
        n);

  // Add handle to the window this.
  startHandlingEventsFor( whStaticText );

  // If the label string is equal to the widget name, set it to the null
  // string.  MUST do this conditionally after create to allow the use of
  // resource files.
  IMString labelString( whStaticText, XmNlabelString );
  if ( IXmLabel::initializeXmLabelString( labelString, IString( ulId ),
                                     fStaticTextData->isMnemonic ) )
  {
     XtVaSetValues (whStaticText,
                    XmNlabelString, (XmString)labelString,
                    NULL );
  }

  // Get the minimum margin height and width for the XmLabel widget.
  // It will be used by calcMinimumSize.
  XtVaGetValues (whStaticText,
                 XmNmarginHeight, &marginHeight,
                 XmNmarginTop,    &marginTop,
                 XmNmarginBottom, &marginBottom,
                 XmNmarginWidth,  &marginWidth,
                 XmNmarginLeft,   &marginLeft,
                 XmNmarginRight,  &marginRight,
                 NULL);
  fStaticTextData->minMarginHeight = 2*marginHeight + marginTop + marginBottom;
  fStaticTextData->minMarginWidth = 2*marginWidth + marginLeft + marginRight;

  if ( style != IWindow::noStyle )
  {
     // Handle the vertical alignment flags.

     Dimension  topMargin = 0, bottomMargin = 0, marginHeight = 0,
                textHeight, margins, height;

     // vertical margin values depend on widget height and font size
     XtVaGetValues (whStaticText,
                    XmNheight, &height,
                    NULL);

     textHeight = labelString.size (IWindowHandle(whStaticText)).height();
     margins = MAX (0, height - textHeight);

     if (style & IStaticText::bottom)
     {
        topMargin = margins;
        fStaticTextData->verticalAlignment = IStaticText::bottom;
     }
     else if (style & IStaticText::vertCenter)
     {
        marginHeight = margins / 2;
        fStaticTextData->verticalAlignment = IStaticText::center;
     }
     else if (style & IStaticText::wordBreak)
     {
        bottomMargin = margins;
        fStaticTextData->verticalAlignment = IStaticText::wordBreak;
     }
     else
     // Have to force default in this case.
     {
        bottomMargin = margins;
        fStaticTextData->verticalAlignment = IStaticText::top;
     }
     //All of the margin space will be at top or bottom.
     XtVaSetValues (whStaticText,
                    XmNmarginHeight, marginHeight,
                    XmNmarginTop,    topMargin,
                    XmNmarginBottom, bottomMargin,
                    NULL);
  }

  // Attach default handler.
  fStaticTextData->fdefaultHandler.handleEventsFor( this );
#endif // IC_MOTIF
}


/*------------------------------------------------------------------------------
| IStaticText::IStaticText                                                     |
|                                                                              |
| Constructor to create an instance for template window.                       |
------------------------------------------------------------------------------*/
IStaticText::IStaticText ( unsigned long ulId,
                           IWindow* parent )
  : ulClLimit( 0 ),
    fStaticTextData(new IStaticTextData( ))
{
  IASSERTPARM(parent!=0);

#ifdef IC_PMWIN
  setAutoDestroyWindow( false );
  reserveUserWindowWord( false );
  this->startHandlingEventsFor( ulId, parent );

  /*********************************************************/
  /* Set the style without causing a refresh (i.e. don't   */
  /* call enableFillBackground).                           */
  /*********************************************************/
#ifdef IC_PM
  setStyle( style() | fillBackground.asUnsignedLong() );
#endif
#ifdef IC_WIN
  setExtendedStyle( extendedStyle() | fillBackground.asExtendedUnsignedLong() );
#endif

#ifdef IC_WIN
  // Update extended style information
  unsigned long ulStyle = style();
  unsigned long ulExtStyle = extendedStyle();
  if (!(ulStyle & (DT_RIGHT | DT_CENTER)))
  {
    if (ulStyle & DT_WORDBREAK)
      ulExtStyle |= wordBreak.asExtendedUnsignedLong();
  }
  if (ulStyle & DT_RIGHT)
    ulStyle |= right.asUnsignedLong();
  if (ulStyle & DT_CENTER)
    ulStyle |= center.asUnsignedLong();
  if (ulStyle & DT_VCENTER)
    ulExtStyle |= vertCenter.asExtendedUnsignedLong();
  if (!(ulStyle & DT_NOPREFIX))
    ulExtStyle |= mnemonic.asExtendedUnsignedLong();
  if (ulStyle & WS_EX_CLIENTEDGE)
    ulExtStyle |= border3D.asExtendedUnsignedLong();
  setExtendedStyle(ulExtStyle);
#endif
  if ( IStaticTextData::isDrawingHandlerNeeded( IStaticText::style(),
                                                extendedStyle() ))
  {
    this->addDrawingHandler();
  }
#ifdef IC_WIN
  else
  {
    fStaticTextData->fStaticHandler.handleEventsFor(this);
    fStaticTextData->fBrushHandler.handleEventsFor(this);
  }
#endif // IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF
  IWindowHandle whStaticText =
         XtNameToWidget(parent->handle(), (char *)IString(ulId) );
  if (whStaticText == 0)
     ITHROWLIBRARYERROR1( IC_CONTROL_NOT_FOUND,
                          IBaseErrorInfo::accessError,
                          IException::recoverable,
                          "XtNameToWidget (label)");
  if (!(XtIsSubclass (whStaticText, xmLabelWidgetClass)))
  {
     ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                          IBaseErrorInfo::accessError,
                          IException::recoverable,
                          "XmLabel");
  }

  // Ensure that the xmLabel has XmNrecomputeSize set to false;
  // otherwise, we have an infinite loop since we are processing
  // configure notify events via the default handler.  We do so in order
  // to force the alignment.
  XtVaSetValues (whStaticText,
                 XmNrecomputeSize, false,
                 NULL);

  // Get the minimum margin height and width for the XmLabel widget.
  // It will be used by calcMinimumSize.
  XtVaGetValues (whStaticText,
                 XmNmarginHeight, &fStaticTextData->minMarginHeight,
                 XmNmarginWidth,  &fStaticTextData->minMarginWidth,
                 NULL);

  // Set initial alignment.
  Dimension  topMargin, bottomMargin;

  XtVaGetValues (whStaticText,
                 XmNmarginTop,    &topMargin,
                 XmNmarginBottom, &bottomMargin,
                 NULL);
  if (topMargin == 0 && bottomMargin != 0)
     fStaticTextData->verticalAlignment = IStaticText::top;
  else if (topMargin != 0 && bottomMargin == 0)
     fStaticTextData->verticalAlignment = IStaticText::bottom;
  else
     fStaticTextData->verticalAlignment = IStaticText::center;

  setAutoDestroyWindow (false);
  prepareForUse(whStaticText);
  setOwner (parent);

  // Attach default handler.
  fStaticTextData->fdefaultHandler.handleEventsFor( this );
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IStaticText::IStaticText                                                     |
|                                                                              |
| Constructor to instantiate from an existing static text control.             |
------------------------------------------------------------------------------*/
IStaticText::IStaticText ( const IWindowHandle& handle )
  :  ulClLimit( 0 ),
     fStaticTextData(new IStaticTextData( ))
{
  IASSERTPARM(handle!=0);

#ifdef IC_PMWIN
  this->setAutoDestroyWindow( false );
  reserveUserWindowWord( false );
  this->startHandlingEventsFor( handle );

  /*********************************************************/
  /* Set the style without causing a refresh (i.e. don't   */
  /* call enableFillBackground).                           */
  /*********************************************************/
#ifdef IC_PM
  setStyle( style() | fillBackground.asUnsignedLong() );
#endif
#ifdef IC_WIN
  setExtendedStyle( extendedStyle() | fillBackground.asExtendedUnsignedLong() );
#endif

#ifdef IC_WIN
  // Update extended style information
  unsigned long ulStyle = style();
  unsigned long ulExtStyle = extendedStyle();
  if (!(ulStyle & (DT_RIGHT | DT_CENTER)))
  {
    if (ulStyle & DT_WORDBREAK)
      ulExtStyle |= wordBreak.asExtendedUnsignedLong();
  }
  if (ulStyle & DT_RIGHT)
    ulStyle |= right.asUnsignedLong();
  if (ulStyle & DT_CENTER)
    ulStyle |= center.asUnsignedLong();
  if (ulStyle & DT_VCENTER)
    ulExtStyle |= vertCenter.asExtendedUnsignedLong();
  if (!(ulStyle & DT_NOPREFIX))
    ulExtStyle |= mnemonic.asExtendedUnsignedLong();
  if (ulStyle & WS_EX_CLIENTEDGE)
    ulExtStyle |= border3D.asExtendedUnsignedLong();
  setExtendedStyle(ulExtStyle);
#endif
  if ( IStaticTextData::isDrawingHandlerNeeded( IStaticText::style(),
                                                extendedStyle() ))
  {
    this->addDrawingHandler();
  }
#ifdef IC_WIN
  else
  {
    fStaticTextData->fStaticHandler.handleEventsFor(this);
    fStaticTextData->fBrushHandler.handleEventsFor(this);
  }
#endif // IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF
  if (!(XtIsSubclass ((Widget) handle, xmLabelWidgetClass)))
  {
     ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                          IBaseErrorInfo::accessError,
                          IException::recoverable,
                          "XmLabel");
  }

  // Ensure that the xmLabel has XmNrecomputeSize set to false;
  // otherwise, we have an infinite loop since we are processing
  // configure notify events via the default handler.  We do so in order
  // to force the alignment.
  XtVaSetValues (handle,
                 XmNrecomputeSize, false,
                 NULL);

  // Get the minimum margin height and width for the XmLabel widget.
  // It will be used by calcMinimumSize.
  XtVaGetValues (handle,
                 XmNmarginHeight, &fStaticTextData->minMarginHeight,
                 XmNmarginWidth,  &fStaticTextData->minMarginWidth,
                 NULL);

  // Set initial alignment.
  Dimension  topMargin, bottomMargin;

  XtVaGetValues (handle,
                 XmNmarginTop,    &topMargin,
                 XmNmarginBottom, &bottomMargin,
                 NULL);
  if (topMargin == 0 && bottomMargin != 0)
     fStaticTextData->verticalAlignment = IStaticText::top;
  else if (topMargin != 0 && bottomMargin == 0)
     fStaticTextData->verticalAlignment = IStaticText::bottom;
  else
     fStaticTextData->verticalAlignment = IStaticText::center;

  setAutoDestroyWindow( false );
  prepareForUse(handle);

  // Attach default handler.
  fStaticTextData->fdefaultHandler.handleEventsFor( this );
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IStaticText::~IStaticText                                                    |
------------------------------------------------------------------------------*/
IStaticText::~IStaticText ( )
{
#ifdef IC_PMWIN
  if (fStaticTextData->fDefaultAdded)
    fStaticTextData->fdefaultHandler.stopHandlingEventsFor( this );
#ifdef IC_WIN
  fStaticTextData->fStaticHandler.stopHandlingEventsFor(this);
  fStaticTextData->fBrushHandler.stopHandlingEventsFor(this);
#endif // IC_WIN
#endif //IC_PMWIN

#ifdef IC_MOTIF
  fStaticTextData->fdefaultHandler.stopHandlingEventsFor (this);
#endif
  delete fStaticTextData;
}

/*------------------------------------------------------------------------------
| IStaticText::defaultStyle                                                    |
|                                                                              |
| Return the default style for new static text objects.                        |
------------------------------------------------------------------------------*/
IStaticText::Style IStaticText::defaultStyle ( )
{
  return currentDefaultStyle;
}

/*------------------------------------------------------------------------------
| IStaticText::setDefaultStyle                                                 |
|                                                                              |
| Set the default style for new static text objects.                           |
------------------------------------------------------------------------------*/
void IStaticText::setDefaultStyle ( const Style& style )
{
  currentDefaultStyle = style;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticText::convertToGUIStyle                                               |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (extendedOnly) is set.                                         |
------------------------------------------------------------------------------*/
unsigned long IStaticText::convertToGUIStyle ( const IBitFlag& style,
                                               bool extendedOnly ) const
{
  // Obtain the style from the class (ITextControl) that we inherit from.
  unsigned long ulStyle = Inherited::convertToGUIStyle( style, extendedOnly );

  if ( extendedOnly )
  {
    // Use mask to only return extended styles that we don't overlap with our
    // extended styles.
    ulStyle |= style.asExtendedUnsignedLong() & ISS_EXTGUIMASK;

  }
  else
  {
    // SS_ styles have a one-to-one correspondence to our style bits, and
    // inhabit the lower word of the base GUI style.  Therefore, obtain
    // that portion asis, masking out the upper word.
    ulStyle |= style.asUnsignedLong() & IDT_MASK;

#ifdef IC_PM
    ulStyle |= SS_TEXT;               // Add required style.
#endif
#ifdef IC_WIN
    ulStyle |= SS_LEFT | WS_CHILD;    // Add required style ...
    // If mnemonics not requested, set noprefix style
    if (!(style.asExtendedUnsignedLong() & IDT_MNEMONIC))
       ulStyle |= SS_NOPREFIX;
#endif
  }

  return ulStyle;
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IStaticText::alignment                                                       |
------------------------------------------------------------------------------*/
IStaticText::Alignment IStaticText::alignment ( ) const
{
#ifdef IC_PMWIN
  Alignment result = topLeft;     // (Can't test for top or left.)
#ifdef IC_PM
  unsigned long ulStyle = this->style();

  if ( ulStyle & right.asUnsignedLong() )
  {
     if ( ulStyle & bottom.asUnsignedLong() )
        result = bottomRight;

     else if ( ulStyle & vertCenter.asUnsignedLong() )
        result = centerRight;

     else     // (Can't test for IStaticText::top.)
        result = topRight;
  }

  else if ( ulStyle & center.asUnsignedLong() )
  {
     if ( ulStyle & bottom.asUnsignedLong() )
        result = bottomCenter;

     else if ( ulStyle & vertCenter.asUnsignedLong() )
        result = centerCenter;

     else     // (Can't test for IStaticText::top.)
        result = topCenter;
  }

  else if ( ulStyle & bottom.asUnsignedLong() )
     result = bottomLeft;

  else if ( ulStyle & vertCenter.asUnsignedLong() )
     result = centerLeft;

  else if ( ulStyle & wordBreak.asUnsignedLong() )
     result = topLeftWrapped;
#endif // IC_PM
#ifdef IC_WIN
  unsigned long ulStyle = this->style();
  unsigned long ulExStyle = this->extendedStyle();

  if ( IBidiSettings::isBidiSupported() )
  {
     IBidiSettings
       bidiSettings( *this );
     if ( bidiSettings.windowLayout() == IBidiSettings::layoutRightToLeft )
     {  // The alignment returned by this function is always assumed to be
        // appropriate for a left-to-right environment.  To transparently
        // support an application ported to a bidi environment with
        // minimal changes to the application, we reverse the alignment
        // stored in the control and used to give it a right-to-left look.
        if ( ulStyle & IStaticText::right.asUnsignedLong() )
        {
           ulStyle &= ~IStaticText::right.asUnsignedLong();
           ulExStyle |= IStaticText::left.asExtendedUnsignedLong();
        }
        else
        {
           if ( ! ( ulStyle & IStaticText::center.asUnsignedLong() ) )
           {
              ulStyle |= IStaticText::right.asUnsignedLong();
              ulExStyle &= ~IStaticText::left.asExtendedUnsignedLong();
           }
        }
     }
  }

  result = IStaticTextData::alignmentFromStyle( ulStyle, ulExStyle );
#endif // IC_WIN

  return result;
#endif // IC_PMWIN

#ifdef IC_MOTIF
  unsigned char align = 0;
  Alignment     curAlign;

  XtVaGetValues((Widget) this->handle(),
                XmNalignment, &align,
                NULL);

  if (align == XmALIGNMENT_END )
  {
     if (fStaticTextData->verticalAlignment == IStaticText::top)
        curAlign = topRight;
     else if (fStaticTextData->verticalAlignment == IStaticText::bottom)
        curAlign = bottomRight;
     else if (fStaticTextData->verticalAlignment == IStaticText::center)
        curAlign = centerRight;
  }
  else if (align == XmALIGNMENT_CENTER )
  {
     if (fStaticTextData->verticalAlignment == IStaticText::top)
        curAlign = topCenter;
     else if (fStaticTextData->verticalAlignment == IStaticText::bottom)
        curAlign = bottomCenter;
     else if (fStaticTextData->verticalAlignment == IStaticText::center)
        curAlign = centerCenter;
  }
  else
  {
     if (fStaticTextData->verticalAlignment == IStaticText::top)
        curAlign = topLeft;
     if (fStaticTextData->verticalAlignment == IStaticText::wordBreak)
        curAlign = topLeftWrapped;
     else if (fStaticTextData->verticalAlignment == IStaticText::bottom)
        curAlign = bottomLeft;
     else if (fStaticTextData->verticalAlignment == IStaticText::center)
        curAlign = centerLeft;
  }

  return curAlign;
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IStaticText::setAlignment                                                    |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::setAlignment ( Alignment alignType )
{
#ifdef IC_PMWIN
  unsigned long ulStyles = this->style();
  unsigned long ulOldStyles = ulStyles;
#ifdef IC_WIN
  unsigned long ulExStyles = this->extendedStyle();
  unsigned long ulExOldStyles = ulExStyles;
#endif

  /********************************************************************/
  /* Mask off only the alignment flags ...                            */
  /********************************************************************/
#ifdef IC_PM
  ulStyles &= ~( center.asUnsignedLong() | right.asUnsignedLong() |
                 bottom.asUnsignedLong() | vertCenter.asUnsignedLong() |
                 wordBreak.asUnsignedLong() );
#endif
#ifdef IC_WIN
  ulStyles   &=~( center.asUnsignedLong() | right.asUnsignedLong() );
  ulExStyles &= ~( left.asExtendedUnsignedLong() |
                 top.asExtendedUnsignedLong() |
                 bottom.asExtendedUnsignedLong() |
                 vertCenter.asExtendedUnsignedLong() |
                 wordBreak.asExtendedUnsignedLong() );
#endif

  /********************************************************************/
  /* NOTE:  The flag definitions for top and left are 0 for both PM   */
  /*        and Windows.                                              */
  /********************************************************************/
  switch ( alignType )
  {                                    // Add new alignment.
    case topLeft:
#ifdef IC_WIN
      ulExStyles |= left.asExtendedUnsignedLong()
                               | top.asExtendedUnsignedLong();
#endif
      break;

    case topLeftWrapped:
#ifdef IC_PM
      ulStyles |= wordBreak.asUnsignedLong();
#endif
#ifdef IC_WIN
      ulExStyles |= wordBreak.asExtendedUnsignedLong();
#endif
      break;

    case topCenter:
      ulStyles |= center.asUnsignedLong();
#ifdef IC_WIN
      ulExStyles |= top.asExtendedUnsignedLong();
#endif
      break;

    case topRight:
      ulStyles |= right.asUnsignedLong();
#ifdef IC_WIN
      ulExStyles |= top.asExtendedUnsignedLong();
#endif
      break;

    case centerLeft:
      if (!fStaticTextData->fDefaultAdded)
      {
        this->addDrawingHandler( );
        fStaticTextData->fDefaultAdded = true;
      }
#ifdef IC_PM
      ulStyles |= vertCenter.asUnsignedLong();
#endif
#ifdef IC_WIN
      ulExStyles |= vertCenter.asExtendedUnsignedLong()
                         | left.asExtendedUnsignedLong();
#endif
      break;

    case centerCenter:
      if (!fStaticTextData->fDefaultAdded)
      {
        this->addDrawingHandler( );
        fStaticTextData->fDefaultAdded = true;
      }
#ifdef IC_PM
      ulStyles |= vertCenter.asUnsignedLong() | center.asUnsignedLong();
#endif
#ifdef IC_WIN
      ulStyles |= center.asUnsignedLong();
      ulExStyles |= vertCenter.asExtendedUnsignedLong();
#endif
      break;

    case centerRight:
      if (!fStaticTextData->fDefaultAdded)
      {
        this->addDrawingHandler( );
        fStaticTextData->fDefaultAdded = true;
      }
#ifdef IC_PM
      ulStyles |= vertCenter.asUnsignedLong() | right.asUnsignedLong();
#endif
#ifdef IC_WIN
      ulStyles |= right.asUnsignedLong();
      ulExStyles |= vertCenter.asExtendedUnsignedLong();
#endif
      break;

    case bottomLeft:
      if (!fStaticTextData->fDefaultAdded)
      {
        this->addDrawingHandler( );
        fStaticTextData->fDefaultAdded = true;
      }
#ifdef IC_PM
      ulStyles |= bottom.asUnsignedLong();
#endif
#ifdef IC_WIN
      ulExStyles |= bottom.asExtendedUnsignedLong()
                       | left.asExtendedUnsignedLong();
#endif
      break;

    case bottomCenter:
      if (!fStaticTextData->fDefaultAdded)
      {
        this->addDrawingHandler( );
        fStaticTextData->fDefaultAdded = true;
      }
#ifdef IC_PM
      ulStyles |= bottom.asUnsignedLong() | center.asUnsignedLong();
#endif
#ifdef IC_WIN
      ulStyles |= center.asUnsignedLong();
      ulExStyles |= bottom.asExtendedUnsignedLong();
#endif
      break;

    case bottomRight:
      if (!fStaticTextData->fDefaultAdded)
      {
        this->addDrawingHandler( );
        fStaticTextData->fDefaultAdded = true;
      }
#ifdef IC_PM
      ulStyles |= bottom.asUnsignedLong() | right.asUnsignedLong();
#endif
#ifdef IC_WIN
      ulStyles |= right.asUnsignedLong();
      ulExStyles |= bottom.asExtendedUnsignedLong();
#endif
      break;

    default:
      ITHROWLIBRARYERROR( IC_INVALIDENUMVALUE,
                          IBaseErrorInfo::invalidParameter,
                          IException::recoverable );
      break;
  }

#ifdef IC_WIN
  if ( IBidiSettings::isBidiSupported() )
  {
     IBidiSettings
       bidiSettings( *this );
     if ( bidiSettings.windowLayout() == IBidiSettings::layoutRightToLeft )
     {  // The alignment passed to this function is always assumed to be
        // appropriate for a left-to-right environment.  To transparently
        // support an application ported to a bidi environment with
        // minimal changes to the application, we reverse the alignment
        // to give a right-to-left look.  We do that here so we can store
        // the alignment that the control should paint with via its styles.
        // Remapping here allows IStaticTextPaintHandler to avoid having
        // to remap styles.  This allows controls created by the user
        // outside of IStaticText, but wrappered with IStaticText, to not
        // be modified.  This gives the user complete control over controls
        // that he creates himself.
        if ( ulStyles & IStaticText::right.asUnsignedLong() )
        {
           ulStyles &= ~IStaticText::right.asUnsignedLong();
           ulExStyles |= IStaticText::left.asExtendedUnsignedLong();
        }
        else
        {
           if ( ! ( ulStyles & IStaticText::center.asUnsignedLong() ) )
           {
              ulStyles |= IStaticText::right.asUnsignedLong();
              ulExStyles &= ~IStaticText::left.asExtendedUnsignedLong();
           }
        }
     }
  }
#endif // IC_WIN

#ifdef IC_PM
  if ( ulStyles != ulOldStyles )
  {
     this->setStyle( ulStyles );
     this->refresh();
  }
#endif
#ifdef IC_WIN
  if (( ulStyles != ulOldStyles ) || ( ulExStyles != ulExOldStyles ))
  {
     this->setStyle( ulStyles );
     this->setExtendedStyle( ulExStyles );
     this->refresh();
  }
#endif
#endif // IC_PMWIN

#ifdef IC_MOTIF
  unsigned char align = 0;
  Dimension     topMargin = 0, bottomMargin = 0, marginHeight = 0, margins;
  IMString      labelString;

  // Determine the current label text and its vertical height.  If necessary
  // and indicated by the alignment type, word wrappping is done to the text.
  margins = fStaticTextData->layoutText( this, labelString, alignType );

  switch (alignType)
  {
     case topLeftWrapped:
        bottomMargin = margins;
        align = XmALIGNMENT_BEGINNING;
        fStaticTextData->verticalAlignment = IStaticText::wordBreak;
        break;
     case topLeft:
        bottomMargin = margins;
        align = XmALIGNMENT_BEGINNING;
        fStaticTextData->verticalAlignment = IStaticText::top;
        break;
     case topCenter:
        bottomMargin = margins;
        align = XmALIGNMENT_CENTER;
        fStaticTextData->verticalAlignment = IStaticText::top;
        break;
     case topRight:
        bottomMargin = margins;
        align = XmALIGNMENT_END;
        fStaticTextData->verticalAlignment = IStaticText::top;
        break;
     case centerLeft:
        marginHeight = margins / 2;
        align = XmALIGNMENT_BEGINNING;
        fStaticTextData->verticalAlignment = IStaticText::center;
        break;
     case centerCenter:
        marginHeight = margins / 2;
        align = XmALIGNMENT_CENTER;
        fStaticTextData->verticalAlignment = IStaticText::center;
        break;
     case centerRight:
        marginHeight = margins / 2;
        align = XmALIGNMENT_END;
        fStaticTextData->verticalAlignment = IStaticText::center;
        break;
     case bottomLeft:
        topMargin = margins;
        align = XmALIGNMENT_BEGINNING;
        fStaticTextData->verticalAlignment = IStaticText::bottom;
        break;
     case bottomCenter:
        topMargin = margins;
        align = XmALIGNMENT_CENTER;
        fStaticTextData->verticalAlignment = IStaticText::bottom;
        break;
     case bottomRight:
        topMargin = margins;
        align = XmALIGNMENT_END;
        fStaticTextData->verticalAlignment = IStaticText::bottom;
        break;
     default:                     // uninitialized enum
        ITHROWLIBRARYERROR(IC_INVALIDENUMVALUE,
                           IBaseErrorInfo::invalidParameter,
                           IException::recoverable);
        break;
  }

  // Clear text.  (If margins change, widget may not clear old text.)
  IMString  nullString;                // an empty XmString
  XtVaSetValues ((Widget) handle(),
                 XmNlabelString, (XmString)nullString,
                 NULL);

  XtVaSetValues((Widget) handle(),
                XmNalignment, align,
                XmNmarginTop, topMargin,
                XmNmarginBottom, bottomMargin,
                XmNmarginHeight, marginHeight,
                NULL);

  // Force a rewrite of the text to cause new alignment to take effect.
  // Rewrite must be forced because XmLabel widget won't dynamically
  // update.
  XtVaSetValues ((Widget) handle(),
                 XmNlabelString, (XmString)labelString,
                 NULL);
#endif // IC_MOTIF

  return *this;
}

/*------------------------------------------------------------------------------
| IStaticText::disableFillBackground                                           |
|                                                                              |
| Turn off fill background style.                                              |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::disableFillBackground ( )
{
  return this->enableFillBackground( false );
}

/*------------------------------------------------------------------------------
| IStaticText:: disableHalftone                                                |
|                                                                              |
| Turn off halftone style.                                                     |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::disableHalftone ( )
{
  return this->enableHalftone( false );
}

/*------------------------------------------------------------------------------
| IStaticText::enableFillBackground                                            |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::enableFillBackground ( bool enable )
{
#ifdef IC_PMWIN
#ifdef IC_WIN
  unsigned long ulStyles = this->extendedStyle();
#else
  unsigned long ulStyles = this->style();
#endif
  unsigned long ulOldStyles = ulStyles;

#ifdef IC_WIN
  if ( enable )
  {
     ulStyles |= fillBackground.asExtendedUnsignedLong();
  }
  else
  {
     ulStyles &= ~fillBackground.asExtendedUnsignedLong();
  }
#else
  if ( enable )
  {
     ulStyles |= fillBackground.asUnsignedLong();
  }
  else
  {
     ulStyles &= ~fillBackground.asUnsignedLong();
  }
#endif

  if ( ulStyles != ulOldStyles )
  {
#ifdef IC_WIN
     this->setExtendedStyle( ulStyles );
#else
     this->setStyle( ulStyles );
#endif
     if ( IStaticTextData::isDrawingHandlerNeeded( style(),
                                                   extendedStyle() ))
         this->addDrawingHandler();
     this->refresh();
     this->notify( IStaticText::fillBackgroundId, enable );
  }
#endif // IC_PMWIN

  return *this;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticText::hasFillBackground                                               |
------------------------------------------------------------------------------*/
bool IStaticText::hasFillBackground ( ) const
{
#ifdef IC_PM
  return( (this->style() & fillBackground.asUnsignedLong()) ? true : false );
#endif
#ifdef IC_WIN
  return( (extendedStyle() & fillBackground.asExtendedUnsignedLong()) ? true
                                                                      : false );
#endif
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IStaticText::enableHalftone                                                  |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::enableHalftone ( bool enable )
{
#ifdef IC_PMWIN
#ifdef IC_PM
  unsigned long ulStyles = this->style();
#else
  unsigned long ulStyles = this->extendedStyle();
#endif
  unsigned long ulOldStyles = ulStyles;

#ifdef IC_PM
  if ( enable )
  {
     ulStyles |= halftone.asUnsignedLong();
  }
  else
  {
     ulStyles &= ~halftone.asUnsignedLong();
  }
#else
  if ( enable )
  {
     ulStyles |= halftone.asExtendedUnsignedLong();
  }
  else
  {
     ulStyles &= ~halftone.asExtendedUnsignedLong();
  }
#endif

  if ( ulStyles != ulOldStyles )
  {
#ifdef IC_PM
     this->setStyle( ulStyles );
#endif
#ifdef IC_WIN
     this->setExtendedStyle( ulStyles );
#endif
     if ( IStaticTextData::isDrawingHandlerNeeded( style(),
                                                   extendedStyle() ))
         this->addDrawingHandler();

     this->refresh();
     this->notify( IStaticText::halftoneId, enable );
  }
#endif // IC_PMWIN

  return *this;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticText::isHalftone                                                      |
------------------------------------------------------------------------------*/
bool IStaticText::isHalftone ( ) const
{
#ifdef IC_PM
  return( (style() & halftone.asUnsignedLong()) ? true : false );
#endif
#ifdef IC_WIN
  return( (extendedStyle() & halftone.asExtendedUnsignedLong()) ? true
                                                                : false );
#endif
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IStaticText:: disableUnderscore                                              |
|                                                                              |
| Turn off underscore style.                                                   |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::disableUnderscore ( )
{
  return this->enableUnderscore( false );
}

/*------------------------------------------------------------------------------
| IStaticText:: disableStrikeout                                               |
|                                                                              |
| Turn off strikeout style.                                                    |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::disableStrikeout ( )
{
  return this->enableStrikeout( false );
}

/*------------------------------------------------------------------------------
| IStaticText::enableUnderscore                                                |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::enableUnderscore ( bool enable )
{
#ifdef IC_PMWIN
  unsigned long ulExtStyles = this->extendedStyle();
  unsigned long ulOldExtStyles = ulExtStyles;

  if ( enable )
  {
     ulExtStyles |= underscore.asExtendedUnsignedLong();
  }
  else
  {
     ulExtStyles &= ~underscore.asExtendedUnsignedLong();
  }

  if ( ulExtStyles != ulOldExtStyles )
  {
     this->setExtendedStyle( ulExtStyles );
     if ( IStaticTextData::isDrawingHandlerNeeded( style(),
                                                   extendedStyle() ))
         this->addDrawingHandler();
     this->refresh();
     this->notify( IStaticText::underscoreId, enable );
  }
#endif // IC_PMWIN

  return *this;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticText::isUnderscore                                                    |
------------------------------------------------------------------------------*/
bool IStaticText::isUnderscore ( ) const
{
  return( (extendedStyle() & underscore.asExtendedUnsignedLong()) ? true
                                                                  : false );
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IStaticText::enableStrikeout                                                 |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::enableStrikeout ( bool enable )
{
#ifdef IC_PMWIN
  unsigned long ulExtStyles = this->extendedStyle();
  unsigned long ulOldExtStyles = ulExtStyles;

  if ( enable )
  {
     ulExtStyles |= strikeout.asExtendedUnsignedLong();
  }
  else
  {
     ulExtStyles &= ~strikeout.asExtendedUnsignedLong();
  }

  if ( ulExtStyles != ulOldExtStyles )
  {
     this->setExtendedStyle( ulExtStyles );
     if ( IStaticTextData::isDrawingHandlerNeeded( style(),
                                                   extendedStyle() ))
         this->addDrawingHandler();
     this->refresh();
     this->notify( IStaticText::strikeoutId, enable );
  }
#endif // IC_PMWIN

  return *this;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticText::isStrikeout                                                     |
------------------------------------------------------------------------------*/
bool IStaticText::isStrikeout ( ) const
{
  return( (extendedStyle() & strikeout.asExtendedUnsignedLong()) ? true
                                                                 : false );
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IStaticText::calcMinimumSize                                                 |
------------------------------------------------------------------------------*/
ISize IStaticText::calcMinimumSize ( ) const
{
  ISize sizNew = this->displaySize( text() );

#ifdef IC_PMWIN
  /**********************************************************/
  /* Calculate a new minimum size if the text limit is set. */
  /**********************************************************/
  if ( this->ulClLimit )
  {
     ISize sizLimit = this->calcLimitSize();
     if ( sizLimit.height() != sizNew.height() ) // The height could grow OR shrink, depending
        sizNew.setHeight( sizLimit.height() );   // on how they changed the limit.

     if ( sizLimit.width() != sizNew.width() )   // Ditto the width.
        sizNew.setWidth( sizLimit.width() );
  }

  if ( ( extendedStyle() & border3D.asExtendedUnsignedLong() ) &&
       ( IPlatform::isWin9x() || IPlatform::isNTNewShell() ))

  {
     // look for api's to get this value programmatically.
     sizNew += ISize(4,4);
  }
#endif // IC_PMWIN

#ifdef IC_MOTIF
  Dimension borderWidth, shadowThickness, highlightThickness;

  // Add in the border width, shadow thickness, highlight thickness,
  // margin heights, and margin widths.
  XtVaGetValues (handle(),
                 XmNborderWidth,        &borderWidth,
                 XmNshadowThickness,    &shadowThickness,
                 XmNhighlightThickness, &highlightThickness,
                 NULL);
  sizNew.setHeight (sizNew.height() +
                    2 * (borderWidth + shadowThickness + highlightThickness) +
                    fStaticTextData->minMarginHeight);
  sizNew.setWidth (sizNew.width() +
                    2 * (borderWidth + shadowThickness + highlightThickness) +
                    fStaticTextData->minMarginWidth);

  if (ulClLimit)                       // Smarter minimum size
  {                                    // Check text limit
     ISize sizLimit = calcLimitSize();
     if (sizLimit.height() > sizNew.height())
     {                                 // Grow the height
        sizNew.setHeight(sizLimit.height());
     }
     if (sizLimit.width() > sizNew.width())
     {                                 // Grow the width
        sizNew.setWidth(sizLimit.width());
     }
  }
#endif // IC_MOTIF

  return sizNew;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticText::foregroundColor                                                 |
|                                                                              |
| Returns the foreground color for the IStaticText control.                    |
------------------------------------------------------------------------------*/
IColor IStaticText::foregroundColor ( ) const
{
  return IWindow::color( PP_FOREGROUNDCOLOR,
                         IColor( IColor::kWindowStaticText ) );
}

/*------------------------------------------------------------------------------
| IStaticText::backgroundColor                                                 |
|                                                                              |
| Returns the background color for the IStaticText control.                    |
------------------------------------------------------------------------------*/
IColor IStaticText::backgroundColor ( ) const
{
#ifdef IC_WIN
  return IWindow::color( PP_BACKGROUNDCOLOR );
#endif
#ifdef IC_PM
  return IWindow::color( PP_BACKGROUNDCOLOR,
                         IColor( IColor::kWindowBgnd) );
#endif
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IStaticText::fillColor                                                       |
|                                                                              |
| Returns the fillColor for the IStaticText control.                           |
| In Motif fillColor and background color are the same.                        |
------------------------------------------------------------------------------*/
IColor IStaticText::fillColor ( ) const
{
#ifdef IC_PMWIN
  if ( this->fStaticTextData->clrset )
     return this->fStaticTextData->clrfill;
#endif

  return this->backgroundColor();
}

/*------------------------------------------------------------------------------
| IStaticText::setFillColor                                                    |
|                                                                              |
| Sets the fill color for the IStaticText control.                             |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::setFillColor ( const IColor &color )
{
#ifdef IC_PMWIN
  if ( this->fStaticTextData->clrfill != color )
  {
     this->fStaticTextData->clrset  = true;
     this->fStaticTextData->clrfill = color;
     this->refresh( );
     this->notify( IStaticText::fillColorId,
                   false );
  }
#endif

#ifdef IC_MOTIF
   this->setBackgroundColor( color );
   this->notifyObservers(INotificationEvent(
     IStaticText::fillColorId, *this));
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IStaticText::resetFillColor                                                  |
|                                                                              |
| Resets the fill color of the IStaticText control.                            |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::resetFillColor ( )
{
#ifdef IC_PMWIN
  if ( this->fStaticTextData->clrset )
  {
     this->fStaticTextData->clrset  = false;
     this->fStaticTextData->clrfill = this->fillColor( );
     this->refresh( );
     this->notify( IStaticText::fillColorId,
                   false );
  }
#endif

#ifdef IC_MOTIF
   this->resetBackgroundColor();
   this->notifyObservers(INotificationEvent(
     IStaticText::fillColorId, *this));
#endif

  return *this;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticText::notify                                                          |
|                                                                              |
| Notifies observers of an event.                                              |
------------------------------------------------------------------------------*/
void IStaticText::notify ( INotificationId nId, bool enabled )
{
  if ( nId == IStaticText::fillColorId )
  {
     this->notifyObservers( INotificationEvent( nId, *this ));
  }
  else if ( nId == IStaticText::limitId )
  {
     unsigned long limit = this->limit();
     this->notifyObservers( INotificationEvent( nId, *this, true,
                                                (void*)limit ));
  }
  else if (( nId == IStaticText::strikeoutId )      ||
           ( nId == IStaticText::underscoreId )     ||
           ( nId == IStaticText::fillBackgroundId ) ||
           ( nId == IStaticText::halftoneId ))
  {
     this->notifyObservers( INotificationEvent( nId, *this, true,
                                                (void*)enabled ));
  }
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IStaticText::setText                                                         |
|                                                                              |
| Changes the text used by the static text control, and notifies the parent    |
| canvas.                                                                      |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::setText ( const char* pszText )
{
  ISize sizPreviousMinimum = this->minimumSize();

#ifdef IC_PMWIN
  /*********************************************************/
  /* Change the displayed text.                            */
  /*********************************************************/
  Inherited::setText( pszText );

#endif
#ifdef IC_MOTIF
  IString newText = IString (pszText);
  // If mnemonic style, remove first mnemonic.
  if ( fStaticTextData->isMnemonic )
    IXmLabel::removeMnemonic( newText );

  Inherited::setText(newText);         // Change the displayed text

  if ( fStaticTextData->fModifiedForWrap )
  {  // Update stored version of original text.
     fStaticTextData->fOriginalText = newText;
  }
  setAlignment (alignment());
#endif // IC_MOTIF

  // Force IWindow::minimumSize to call calcMinimumSize.
  this->saveMinimumSize( ISize( 0, 0 ) );

  ISize sizNewMinimum = this->minimumSize();

  /*********************************************************/
  /* See if a significant change has occurred.             */
  /*********************************************************/
  if ( sizPreviousMinimum != sizNewMinimum )
  {           // Text change has caused a new minimum size.
     this->setLayoutDistorted( IWindow::minimumSizeChanged, 0 );
              // Flag this for parent canvas.
     this->setLayoutDistorted( 0, IWindow::minimumSizeChanged );
              // Optimization to use just-calculated, cached min size.
  }

  return *this;
}

/*------------------------------------------------------------------------------
| IStaticText::setText                                                         |
|                                                                              |
| Changes the text used by the static text control from a string table.        |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::setText ( const IResourceId & residText )
{
  Inherited::setText( residText );
  return *this;
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IStaticText::text                                                            |
------------------------------------------------------------------------------*/
IString IStaticText::text ( ) const
{
  if (fStaticTextData->fModifiedForWrap)
     return fStaticTextData->fOriginalText;
  else
     return Inherited::text();
}
#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| IStaticText::setLimit                                                        |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::setLimit ( unsigned long limit )
{
  /**********************************************************/
  /* Change the limit iff the new limit is different.       */
  /**********************************************************/
  if ( limit != this->ulClLimit )
  {                                    // Value change.
     this->ulClLimit = limit;

     /*******************************************************/
     /* Give canvas an opportunity to resize if a canvas is */
     /* the owner.                                          */
     /*******************************************************/
     this->setLayoutDistorted( IWindow::minimumSizeChanged |
                                 IWindow::immediateUpdate, 0 );
#ifdef IC_PMWIN
     this->notify( IStaticText::limitId, false );
#endif
#ifdef IC_MOTIF
     this->notifyObservers(INotificationEvent(
       IStaticText::limitId, *this, true, (void*)(limit)) );
#endif
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IStaticText::calcLimitSize                                                   |
------------------------------------------------------------------------------*/
ISize IStaticText::calcLimitSize ( ) const
{
#ifdef IC_PMWIN
  ISize sizChar;

  /*********************************************************/
  /* Calculate iff the text limit has been specified.      */
  /*********************************************************/
  if ( this->ulClLimit )
  {
     sizChar = ((IStaticText*)this)->characterSize();
     unsigned long ulWidth = sizChar.width();

     /**************************************************************/
     /* The below block only exists because work-around logic in   */
     /* displaySize will cause its returned height to exceed the   */
     /* characterSize height (IFont::maxCharHeight value), and we  */
     /* want the tallest height that this font will yield.         */
     /**************************************************************/
     unsigned long ulBlankHeight = this->displaySize( " " ).height();
     if ( ulBlankHeight > sizChar.height() )
        sizChar.setHeight( ulBlankHeight );   // Have taller value.

     /**************************************************************/
     /* Use a step function to reflect the fact that you are more  */
     /* likely to exceed an average character width with an        */
     /* individual character, but a long string will likely be ok  */
     /* with this average value.                                   */
     /**************************************************************/
     sizChar *= ISize( this->ulClLimit, 1 );  // Convert avg chars to pels.
     IFont font(this);
     if ( !font.isFixed() )
     {
        if (this->ulClLimit <= 2)
           ulWidth = ulWidth * this->ulClLimit * 3;
        else
           ulWidth = ulWidth * (this->ulClLimit + 5);
        sizChar.setWidth(ulWidth);
     }   // is proportional
     // If wordBreak style is on, determine the height needed to contain the text.
#ifdef IC_PM
     unsigned long ulStyle = this->style();
     if (ulStyle & wordBreak.asUnsignedLong())
#endif
#ifdef IC_WIN
     unsigned long ulStyle = this->extendedStyle();
     if (ulStyle & wordBreak.asExtendedUnsignedLong())
#endif
     {
        long numberOfLines = font.textLines (this->text(), sizChar.width());
        long maxHeight = font.maxCharHeight();
        sizChar.setHeight (numberOfLines * maxHeight);
     }
  }

  return sizChar;
#endif // IC_PMWIN

#ifdef IC_MOTIF
  Dimension borderWidth, shadowThickness, highlightThickness;

  ISize sizChar;
  if (ulClLimit)
  {                                    // Text limit specified
     sizChar = ((IStaticText*) this)->characterSize();
     unsigned long ulWidth = sizChar.width();

     unsigned long ulBlankHeight = displaySize(" ").height();
     if (ulBlankHeight > sizChar.height())
     {                                 // Have taller value
        sizChar.setHeight(ulBlankHeight);
     }

     // Use a step function to reflect the fact that you are more
     // likely to exceed an average character width with an
     // individual character, but a long string will likely be ok
     // with this average value.
     if (ulClLimit <= 2)
        ulWidth = ulWidth * ulClLimit * 3;
     else
        ulWidth = ulWidth * (ulClLimit + 5);
     sizChar.setWidth(ulWidth);

     // If wordBreak style is on, determine the height needed to contain the text.
     if (fStaticTextData->verticalAlignment == IStaticText::wordBreak )
     {
        IFont font(this);
        long numberOfLines = font.textLines (this->text(), sizChar.width());
        long maxHeight = font.maxCharHeight();
        sizChar.setHeight (numberOfLines * maxHeight);
     }
  }

  // Add in the border width, shadow thickness, highlight thickness,
  // margin heights, and margin widths.
  XtVaGetValues (handle(),
                 XmNborderWidth,        &borderWidth,
                 XmNshadowThickness,    &shadowThickness,
                 XmNhighlightThickness, &highlightThickness,
                 NULL);
  sizChar.setHeight (sizChar.height() +
                     2 * (borderWidth + shadowThickness + highlightThickness) +
                          fStaticTextData->minMarginHeight);
  sizChar.setWidth (sizChar.width() +
                     2 * (borderWidth + shadowThickness + highlightThickness) +
                          fStaticTextData->minMarginWidth);

  return sizChar;
#endif // IC_MOTIF
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IStaticText::setBidiSettings                                                 |
|                                                                              |
| Provide processing specific to a static text control for a change to its     |
| bidirectional attributes.                                                    |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::setBidiSettings( const IBidiSettings& bidiSettings,
                                           bool childInherit,
                                           bool refresh )
{
  IBidiSettings
    prevBidiSettings( *this );
  if ( prevBidiSettings.windowLayout() != bidiSettings.windowLayout() )
  {  // A change is being made to the layout of the control, which
     // means the alignment of the control may need to be adjusted.
     Alignment
       align = this->alignment(),
       prevAlign = align;
     switch ( align )
     {
        case ( IStaticText::topLeft ):
        case ( IStaticText::topLeftWrapped ):
           align = IStaticText::topRight;
           break;
        case ( IStaticText::topRight ):
           align = IStaticText::topLeft;
           break;
        case ( IStaticText::centerLeft ):
           align = IStaticText::centerRight;
           break;
        case ( IStaticText::centerRight ):
           align = IStaticText::centerLeft;
           break;
        case ( IStaticText::bottomLeft ):
           align = IStaticText::bottomRight;
           break;
        case ( IStaticText::bottomRight ):
           align = IStaticText::bottomLeft;
           break;
        default:
           // Don't change the alignment.
           break;
     }

     if ( align != prevAlign )
     {
        if ( ! refresh )
        {  // Prevent the control from repainting as a result of
           // calling IStaticText::setAlignment.
           this->disableUpdate();
        }

        unsigned long
          extStyles = this->extendedStyle();
        this->setAlignment( align );
        if ( extStyles & wordBreak.asExtendedUnsignedLong() )
        {  // Preserve the word break style.
           extStyles = this->extendedStyle();
           extStyles |= wordBreak.asExtendedUnsignedLong();
           this->setExtendedStyle( extStyles );
        }

        if ( ! refresh )
        {
           this->enableUpdate();
        }
     }
  }

  this->Inherited::setBidiSettings( bidiSettings, childInherit, refresh );

  return *this;
}
#endif // IC_WIN

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IStaticText::passEventToOwner                                                |
|                                                                              |
| Returns whether or not the event can be passed up to the owner of this       |
| control.                                                                     |
------------------------------------------------------------------------------*/
bool IStaticText::passEventToOwner( IEvent& event )

{
  switch ( event.eventId() )
  {
    case WM_BUTTON1CLICK:
    case WM_BUTTON2CLICK:
    case WM_BUTTON3CLICK:
//    case WM_BUTTON1DBLCLK:
//    case WM_BUTTON2DBLCLK:
//    case WM_BUTTON3DBLCLK:
    case WM_CHORD:
      event.setPassToOwner( false );
      break;
    default:
      Inherited::passEventToOwner( event );
      break;
  }
  return event.passToOwner();
}
#endif // IC_MOTIF

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticTextData::isDrawingHandlerNeeded                                      |
------------------------------------------------------------------------------*/
bool IStaticTextData::isDrawingHandlerNeeded( unsigned long style,
                                              unsigned long extStyle )
{
#ifdef IC_WIN
  if ( IBidiSettings::isBidiSupported() ||
       (extStyle & ( IStaticText::border3D.asExtendedUnsignedLong()        |
                     IStaticText::bottom.asExtendedUnsignedLong()          |
                     IStaticText::fillBackground.asExtendedUnsignedLong()  |
                     IStaticText::halftone.asExtendedUnsignedLong()        |
                     IStaticText::strikeout.asExtendedUnsignedLong()       |
                     IStaticText::vertCenter.asExtendedUnsignedLong()      |
                     IStaticText::underscore.asExtendedUnsignedLong()      |
                     IStaticText::wordBreak.asExtendedUnsignedLong() )))
  {
    return true;
  }
  return false;
#endif
#ifdef IC_PM
  // The drawing handler is always needed in OS/2 so that the fillBackground
  // style works as specified.  The handler is needed to avoid overpainting
  // the background if the style is disabled, and needed to get the correct
  // color if it is enabled.
  return true;
#endif
}
#endif // IC_PMWIN

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IStaticText::addDrawingHandler                                               |
------------------------------------------------------------------------------*/
IStaticText& IStaticText::addDrawingHandler()
{
  if ( !fStaticTextData->fDefaultAdded )
  {
    fStaticTextData->fdefaultHandler.handleEventsFor( this );
    fStaticTextData->fDefaultAdded = true;
#ifdef IC_WIN
    // Remove the alternate default handler used for colors
    fStaticTextData->fStaticHandler.stopHandlingEventsFor(this);
    fStaticTextData->fBrushHandler.stopHandlingEventsFor(this);
#endif
  }
  return *this;
}
#endif // IC_PMWIN

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IStaticTextData::alignmentFromStyle                                          |
------------------------------------------------------------------------------*/
IStaticText::Alignment
  IStaticTextData::alignmentFromStyle ( unsigned long style,
                                        unsigned long extendedStyle )
{
  IStaticText::Alignment
    alignment = IStaticText::topLeft;

  if ( style & IStaticText::right.asUnsignedLong() )
  {
     if ( extendedStyle & IStaticText::bottom.asExtendedUnsignedLong() )
     {
        alignment = IStaticText::bottomRight;
     }
     else if ( extendedStyle & IStaticText::vertCenter.asExtendedUnsignedLong() )
     {
        alignment = IStaticText::centerRight;
     }
     else     // (Can't test for IStaticText::top.)
     {
        alignment = IStaticText::topRight;
     }
  }
  else if ( style & IStaticText::center.asUnsignedLong() )
  {
     if ( extendedStyle & IStaticText::bottom.asExtendedUnsignedLong() )
     {
        alignment = IStaticText::bottomCenter;
     }
     else if ( extendedStyle & IStaticText::vertCenter.asExtendedUnsignedLong() )
     {
        alignment = IStaticText::centerCenter;
     }
     else     // (Can't test for IStaticText::top.)
     {
        alignment = IStaticText::topCenter;
     }
  }
  else   // Left aligned.
  {
     if ( extendedStyle & IStaticText::bottom.asExtendedUnsignedLong() )
     {
        alignment = IStaticText::bottomLeft;
     }
     else if ( extendedStyle & IStaticText::vertCenter.asExtendedUnsignedLong() )
     {
        alignment = IStaticText::centerLeft;
     }
     else if ( extendedStyle & IStaticText::wordBreak.asExtendedUnsignedLong() )
     {
        alignment = IStaticText::topLeftWrapped;
     }
  }
  return alignment;
}
#endif // IC_WIN
