// Revision: 50 1.10 source/ui/basectl/islider1.cpp, slidectls, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: islider1.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the initialization of static strings used in the        *
*   IProgressIndicator class.                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481324 )

#define INCL_WINSTDSLIDER

extern "C" {
  #include <iwindefs.h>
}
#include <inotify.hpp>
#include <islider.hpp>
#include <islidenh.hpp>
#include <inotifev.hpp>
#include <ictlevt.hpp>
#include <icconst.h>
#ifndef IC_MOTIF
  #include <iwcname.hpp>
#endif
#ifdef IC_WIN
  #include <iclsldw.h>
#endif

// Segment definitions
#ifdef IC_PAGETUNE
  #define _ISLIDER1_CPP_
  #include <ipagetun.h>
#endif

// Initialize static objects and notification strings.
INotificationId const IProgressIndicator::scaleId          =
                                    "IProgressIndicator::scale";
INotificationId const IProgressIndicator::armChangeId      =
                                    "IProgressIndicator::armChange";
INotificationId const ISlider::armTrackId = "ISlider::armTrack";

/*------------------------------------------------------------------------------
| IProgressIndicator::enableNotification                                       |
|                                                                              |
| Flags this part as being ready to accept notifications.  A Notifier, like    |
| IProgressIndicator, does not send notifications to observer objects until it |
| is enabled.                                                                  |
|                                                                              |
| In the window hierarchy we override this function to allocate the correct    |
| notification handler.                                                        |
------------------------------------------------------------------------------*/
IProgressIndicator& IProgressIndicator::enableNotification(bool enabled)
{
  if (!notificationHandler())
  {
    setNotificationHandler( new IProgressIndicatorNotifyHandler() );
  }
  IWindow::enableNotification(enabled);
  return *this;
}

/*------------------------------------------------------------------------------
| IProgressIndicatorNotifyHandler::IProgressIndicatorNotifyHandler             |
|                                                                              |
| Default constructor.                                                         |
------------------------------------------------------------------------------*/
IProgressIndicatorNotifyHandler::IProgressIndicatorNotifyHandler()
{}

/*------------------------------------------------------------------------------
| IProgressIndicatorNotifyHandler::~IProgressIndicatorNotifyHandler            |
|                                                                              |
| Destructor.                                                                  |
------------------------------------------------------------------------------*/
IProgressIndicatorNotifyHandler::~IProgressIndicatorNotifyHandler()
{}

/*------------------------------------------------------------------------------
| IProgressIndicatorNotifyHandler::dispatchHandlerEvent                        |
|                                                                              |
| This notifies IProgressIndicator Windows of the following events:            |
|                                                                              |
| armChange(Id)                                                                |
| armTrack(Id)                                                                 |
------------------------------------------------------------------------------*/
bool IProgressIndicatorNotifyHandler::dispatchHandlerEvent(IEvent& anEvent)
{
  switch (anEvent.eventId())
  {
    case WM_CONTROL:
    {
      IControlEvent ctlevt(anEvent);
      IWindow* pwndControl = ctlevt.controlWindow();
      unsigned long ulMsg  = ctlevt.parameter1().highNumber();
      IWindow* thisWindow;
      IWindowHandle hwndControl;

      if (pwndControl)
      {
        hwndControl = pwndControl->handle();
        thisWindow = pwndControl;
      }
      else
      {
        hwndControl = IWindow::handleWithParent(ctlevt.controlId(),
                                                ctlevt.handle());
        thisWindow = IWindow::windowWithOwner(ctlevt.controlId(),
                                              ctlevt.window());
      }

      if (hwndControl && thisWindow)
      {
#ifdef IC_PMWIN
        IWindowClassName className(hwndControl);
#ifdef IC_WIN
        if (className == WC_SLIDER ||
            className == WC_NATIVESLIDER)
            
#else
        if (className == WC_SLIDER)
#endif
#endif // IC_PMWIN
        // Use a dynamic cast to verify that we have a progress indicator
        // or slider.  Since objects of these classes are our own composites,
        // we don't have a single widget class we can check.  Also, we can't
        // have a case of the handler attached to the parent/owner of an
        // unwrappered instance of these controls.
				{
	        IProgressIndicator
	           *progressInd = dynamic_cast<IProgressIndicator*>(thisWindow);
	        if (progressInd)
	        {
	        	unsigned long parameter2Val = progressInd->armPixelOffset();
	        	
	          if (ulMsg == SLN_CHANGE)
	          {
	            thisWindow->notifyObservers(INotificationEvent(
	                                        IProgressIndicator::armChangeId,
	                                        *thisWindow, true,
	                                        (void *)parameter2Val));
	          }
	          else if (ulMsg == SLN_SLIDERTRACK)
	          {
	            thisWindow->notifyObservers(INotificationEvent(
	                                        ISlider::armTrackId,
	                                        *thisWindow, true,
	                                        (void *)parameter2Val));
	          }
	        }
        }
      }
    break;
    } /* end WM_CONTROL */

    default:
      break;
  }  /* end switch */

  return (Inherited::dispatchHandlerEvent(anEvent));
}

