// Revision: 48 1.16 source/ui/basectl/islider.hpp, slidectls, ioc.v400, 001006 
#ifndef _ISLIDER_
#define _ISLIDER_
/*******************************************************************************
* FILE NAME: islider.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISlider                                                                  *
*     IProgressIndicator                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPoint;
class ISize;
class IString;
class IRectangle;
class IColor;
class IWindowHandle;
class IResourceId;
class IProgressIndicatorData;
class IPMProgressIndicatorData;
class ISliderData;

struct HWND__;

#pragma enum(4)
#pragma pack(push,4)

class IProgressIndicator : public IControl  {
typedef IControl
  Inherited;

public:
class Style;

/*------------------------------ Constructors --------------------------------*/
  IProgressIndicator  ( unsigned long        windowId,
                        IWindow*             parent,
                        IWindow*             owner,
                        const IRectangle&    initial,
                        unsigned long        numberOfTicks,
                        unsigned long        tickSpacing = 0,
                        const Style&         style = defaultStyle() );
  IProgressIndicator  ( unsigned long        windowId,
                        IWindow*             parent,
                        IWindow*             owner,
                        const IRectangle&    initial,
                        unsigned long        scale1NumberOfTicks,
                        unsigned long        scale1TickSpacing,
                        unsigned long        scale2NumberOfTicks,
                        unsigned long        scale2TickSpacing = 0,
                        const Style&         style = defaultStyle() );
#ifdef IC_PMWIN
  IProgressIndicator  ( unsigned long        windowId,
                        IWindow*             parent );
  IProgressIndicator  ( const IWindowHandle& handle );
#endif

virtual
 ~IProgressIndicator  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IProgressIndicator, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
#ifndef IC_MOTIF_FLAGNOP
  IC_IMPORTU pmCompatible,
#endif
  IC_IMPORTU horizontal,
  IC_IMPORTU vertical,
  IC_IMPORTU alignCentered,
  IC_IMPORTU alignTop,
  IC_IMPORTU alignBottom,
  IC_IMPORTU alignLeft,
  IC_IMPORTU alignRight,
  IC_IMPORTU homeTop,
  IC_IMPORTU homeBottom,
  IC_IMPORTU homeLeft,
  IC_IMPORTU homeRight,
  IC_IMPORTU primaryScale1,
  IC_IMPORTU primaryScale2,
  IC_IMPORTU snapToTickMark,
  IC_IMPORTU ribbonStrip;
#ifndef IC_MOTIF_FLAGNOP
static const Style
  IC_IMPORTU handleDrawItem;
#endif
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------------ Related Types -------------------------------*/
enum Alignment {
  topRight,
  bottomLeft,
  centered };
enum HomePosition {
  homeTopRight,
  homeBottomLeft };
enum Scale {
  scale1,
  scale2 };

/*----------------------------- Style Functions ------------------------------*/
Alignment
  alignment ( ) const;

HomePosition
  homePosition ( ) const;

Scale
  primaryScale ( ) const;

bool
  isVertical           ( ) const,
  isRibbonStripEnabled ( ) const,
  isSnapToTickEnabled  ( ) const,
  isDrawItemEnabled    ( ) const;
#ifndef IC_MOTIF_FLAGNOP
bool
  isPMCompatible       ( ) const;
#endif

virtual IProgressIndicator
 &setHomePosition    ( HomePosition home = homeBottomLeft ),
 &setPrimaryScale    ( Scale        primaryScale = scale1 ),
 &enableSnapToTick   ( bool      enableSnapToTick = true ),
 &disableSnapToTick  ( ),
 &enableRibbonStrip  ( bool      enableRibbonStrip = true ),
 &disableRibbonStrip ( );
#ifndef IC_MOTIF_FLAGNOP
virtual IProgressIndicator
 &enableDrawItem     ( bool      enableDrawItem = true ),
 &disableDrawItem    ( );
#endif

/*----------------------------- Tick Operations ------------------------------*/
IString
  tickText ( unsigned long tickNumber ) const;

IPoint
  tickPosition ( unsigned long tickNumber ) const;

unsigned long
  tickLength    ( unsigned long tickNumber ) const,
  tickSpacing   ( Scale         scale ) const,
  numberOfTicks ( Scale         scale ) const;

virtual IProgressIndicator
 &setTickLength ( unsigned long      tickNumber,
                  unsigned long      length ),
 &setTickLength ( unsigned long      length ),
 &setTicks      ( unsigned long      scale1NumberOfTicks,
                  unsigned long      scale2NumberOfTicks,
                  unsigned long      scale1TickSpacing = 0,
                  unsigned long      scale2TickSpacing = 0 ),
 &setTicks      ( Scale              scale,
                  unsigned long      numberOfTicks,
                  unsigned long      tickSpacing = 0 ),
 &setTickText   ( unsigned long      tickNumber,
                  const char*        text ),
 &setTickText   ( unsigned long      tickNumber,
                  const IResourceId& text );

/*----------------------------- Shaft Operations -----------------------------*/
virtual IPoint
  shaftPosition ( ) const;

virtual ISize
  shaftSize ( ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual IProgressIndicator
 &setShaftPosition ( const IPoint& position );
#endif
virtual IProgressIndicator
 &setShaftBreadth  ( unsigned long breadth );

/*------------------------------ Arm Operations ------------------------------*/
virtual unsigned long
  armRange       ( ) const,
  armPixelOffset ( ) const,
  armTickOffset  ( ) const;

virtual IProgressIndicator
 &moveArmToTick  ( unsigned long tickNumber ),
 &moveArmToPixel ( unsigned long armOffset );

/*---------------------------- Color Functions -------------------------------*/
virtual IColor
  backgroundColor ( ) const;

#ifdef IC_MOTIF
virtual IColor
  foregroundColor ( ) const;
virtual IProgressIndicator
  &setBackgroundColor ( const IColor& color ),
  &setForegroundColor ( const IColor& color );
#endif

/*------------------------- Layout Support -----------------------------------*/
virtual IProgressIndicator
 &setLayoutDistorted  ( unsigned long layoutAttributesOn,
                        unsigned long layoutAttributesOff );

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU scaleId,
  IC_IMPORTU armChangeId;

/*----------------------- Observer Notification ------------------------------*/
virtual IProgressIndicator
 &enableNotification ( bool enable=true );


protected:
/*------------------------------ Implementation ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

void
  initialize ( unsigned long     windowId,
               IWindowHandle     parent,
               IWindowHandle     owner,
               unsigned long     style,
               const IRectangle& initial,
               void*             sliderData );
#ifdef IC_WIN
void
  initialize ( IWindowHandle     handle );
#endif


/*-------------------------- Protected Constructors --------------------------*/
  IProgressIndicator ( );


/*---------------------------- Color Functions -------------------------------*/
#ifdef IC_MOTIF
virtual IProgressIndicator
 &setColor         ( unsigned long colorArea,
                     const IColor& color );
#endif
private:
/*------------------------------ Hidden Members ------------------------------*/
  IProgressIndicator ( const IProgressIndicator& progIndicator );
IProgressIndicator
 &operator=          ( const IProgressIndicator& progIndicator );

/*--------------------------------- Private ----------------------------------*/
#ifdef IC_PMWIN
char*
  getTickText ( unsigned long tickNumber,
                char*         buffer = 0,
                unsigned long bufferLength = 0 ) const;
unsigned long
  tickTextLength ( unsigned long tickNumber ) const;

IPMProgressIndicatorData
 *fPMProgressIndicatorData;
#endif

IProgressIndicatorData
 *fProgressIndicatorData;

static Style
  currentDefaultStyle;

#ifdef IC_WIN
friend class INativeSliderHandler;
 #ifdef IC_WIN_STRICT
friend long  __stdcall
   isliderTrackbarWinProc( struct HWND__* hwnd,
                           unsigned int   msg,
                           unsigned int   mp1,
                           long           mp2 );
 #else
friend long  __stdcall
   isliderTrackbarWinProc( void*         hwnd,
                           unsigned int  msg,
                           unsigned int  mp1,
                           long          mp2 );
 #endif
#endif // IC_WIN

/*--------------------------Obsolete Data and Functions ----------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
public:
static INotificationId const
  IC_IMPORTU armTickOffsetId,
  IC_IMPORTU armPixelOffsetId;
#endif
};  // IProgressIndicator

INESTEDBITFLAGCLASSFUNCS(Style, IProgressIndicator)


class ISlider : public IProgressIndicator  {
typedef IProgressIndicator
  Inherited;

public:
class Style;

/*------------------------------ Constructors --------------------------------*/
  ISlider  ( unsigned long         windowId,
             IWindow*              parent,
             IWindow*              owner,
             const IRectangle&     initial,
             unsigned long         numberOfTicks,
             unsigned long         tickSpacing = 0,
             const Style&          style = defaultStyle() );
  ISlider  ( unsigned long         windowId,
             IWindow*              parent,
             IWindow*              owner,
             const IRectangle&     initial,
             unsigned long         scale1NumberOfTicks,
             unsigned long         scale1TickSpacing,
             unsigned long         scale2NumberOfTicks,
             unsigned long         scale2TickSpacing = 0,
             const Style&          style = defaultStyle() );
#ifdef IC_PMWIN
  ISlider  ( unsigned long         windowId,
             IWindow*              parent );
  ISlider  ( const IWindowHandle&  handle );
#endif

virtual
  ~ISlider ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, ISlider, IWindow, IControl, IProgressIndicator);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU buttonsTop,
  IC_IMPORTU buttonsBottom,
  IC_IMPORTU buttonsLeft,
  IC_IMPORTU buttonsRight;

/*----------------------------- Style Members --------------------------------*/
static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

enum ButtonsPosition {
  top,
  bottom,
  left,
  right,
  none
};

ButtonsPosition
  buttonsPosition ( ) const;

/*---------------------------- Detent Operations -----------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual unsigned long
  detentPosition ( unsigned long detentId ) const,  // in pixels
  addDetent      ( unsigned long offset );
#endif

#ifndef IC_MOTIF_FLAGNOP
virtual ISlider
 &removeDetent ( unsigned long detentId );
#endif

/*------------------------------ Arm Operations ------------------------------*/
ISize
  armSize   ( ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual ISlider
 &setArmSize ( const ISize&  sliderArm );
#endif

/*-------------------------------- Attributes --------------------------------*/
#ifdef IC_MOTIFWIN
virtual bool
  hasFocus ( ) const;
#endif

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU armTrackId;


private:
/*------------------------------ Hidden Members ------------------------------*/
  ISlider   ( const ISlider& slider );
ISlider
 &operator= ( const ISlider& slider );

/*--------------------------------- Private ----------------------------------*/
ISliderData
 *fSliderData;

static Style
  currentDefaultStyle;

friend class IProgressIndicatorData;
friend class IPMProgressIndicatorData;
}; // ISlider

INESTEDBITFLAGCLASSFUNCS(Style, ISlider)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <islider.inl>

#endif /* _ISLIDER_ */
