// Revision: 41 1.18 source/ui/basectl/isetcv.hpp, canvas, ioc.v400, 001006 
#ifndef _ISETCV_
  #define _ISETCV_
/*******************************************************************************
* FILE NAME: isetcv.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISetCanvas                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IResourceId;
class IString;
class ISetCanvasData;
class ISetCanvasResizeHandler;

#pragma enum(4)
#pragma pack(push,4)

class ISetCanvas : public ICanvas {
typedef ICanvas
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  ISetCanvas  ( unsigned long     windowIdentifier,
                IWindow*          parent,
                IWindow*          owner,
                const IRectangle& initial = IRectangle(),
                const Style&      style = defaultStyle() );
virtual
 ~ISetCanvas  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, ISetCanvas, ICanvas, IWindow);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU explicitAddsNeeded,
  IC_IMPORTU horizontalDecks,
  IC_IMPORTU verticalDecks,
  IC_IMPORTU packTight,
  IC_IMPORTU packEven,
  IC_IMPORTU packExpanded,
  IC_IMPORTU leftAlign,
  IC_IMPORTU rightAlign,
  IC_IMPORTU centerAlign,
  IC_IMPORTU topAlign,
  IC_IMPORTU bottomAlign,
  IC_IMPORTU centerVerticalAlign,
  IC_IMPORTU decksByGroup;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;

/*--------------------------- Adding Child Windows ---------------------------*/
virtual ISetCanvas
 &add                   ( IWindow* child ),
 &remove                ( IWindow* child ),
 &replaceChildWith      ( IWindow* existingChild,
                          IWindow* newChild );
virtual bool
  isInLayout            ( IWindow* child ) const;
bool
  areExplicitAddsNeeded ( ) const;

/*------------------------- Spacing of Child Windows -------------------------*/
enum Alignment {
  topLeft,
  topCenter,
  topRight,
  centerLeft,
  centerCenter,
  centerRight,
  bottomLeft,
  bottomCenter,
  bottomRight
  };
enum PackType {
  tight,
  even,
  expanded
  };

Alignment
  alignment    ( ) const;
virtual ISetCanvas
 &setAlignment ( Alignment     value );
PackType
  packType     ( ) const;
virtual ISetCanvas
 &setPackType  ( PackType      value );
ISize
  margin       ( ) const,
  pad          ( ) const;
unsigned long
  groupPad     ( ) const;
virtual ISetCanvas
 &setMargin    ( const ISize&  margin ),
 &setPad       ( const ISize&  pad ),
 &setGroupPad  ( unsigned long groupPad );

/*---------------------------------- Decks -----------------------------------*/
enum DeckOrientation {
  horizontal,
  vertical
  };
DeckOrientation
  deckOrientation    ( ) const;
unsigned long
  deckCount          ( ) const;
virtual ISetCanvas
 &setDeckOrientation ( DeckOrientation value ),
 &setDeckCount       ( unsigned long   decks );
bool
  hasDecksAlignedByGroup ( ) const;
ISetCanvas
 &alignDecksByGroup      ( bool alignDecksByGroup=true);

/*------------------------------ Layout Support ------------------------------*/
virtual bool
  hasChildrenToLayout ( ) const;
virtual ISetCanvas
 &setLayoutDistorted  ( unsigned long layoutAttributesOn,
                        unsigned long layoutAttributesOff );

/*--------------------------- Notification Members ---------------------------*/
static INotificationId const
  IC_IMPORTU deckOrientationId;

protected:
/*------------------------------- Constructors -------------------------------*/
  ISetCanvas ( );

/*------------------------ Constructor Implementation ------------------------*/
ISetCanvas
 &initialize ( unsigned long     windowIdentifier,
               IWindow*          parent,
               IWindow*          owner,
               const IRectangle& initialRect,
               unsigned long     style,
               unsigned long     extendedStyle );

/*---------------------------------- Layout ----------------------------------*/
virtual ISetCanvas
 &layout ( );

/*----------------------------------- Text -----------------------------------*/
virtual ISetCanvas
 &expandForText ( );

private:
/*----------------------------- Hidden Members -------------------------------*/
  ISetCanvas ( const ISetCanvas& canvas );
ISetCanvas
 &operator=  ( const ISetCanvas& canvas );

/*--------------------------------- Private ----------------------------------*/
friend class ISetCanvasResizeHandler;
friend class ISetCanvasObserver;
#ifdef IC_MOTIF
//
// The WM_SIZE processing was placed in this handler TEMPORARILY!
// Thus friendship with ISetCanvasShowHandler required only until
// the common Paint Handler has been implemented
//
friend class ISetCanvasShowHandler;
#endif // IC_MOTIF

ISetCanvas
 &initializeObject ( );

static Style
  currentDefaultStyle;

static DataHandle
  fClassDataHandle;

unsigned long
  ulClNumDecks,
  ulClGroupPad;
ISize
  sizClMargin,
  sizClPad;
bool
  fExplicitAdds;
ISetCanvasResizeHandler
 *sizeHandler;

ISetCanvasData
 *fSetCanvasData;

/*----------------------- Obsolete Data and Functions ------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
/*----------------------------------- Text -----------------------------------*/
virtual ISetCanvas
 &setText ( const char*        text ),
 &setText ( const IResourceId& text );
virtual IString
  text    ( ) const;
#endif // IC_OBSOLETE
}; // ISetCanvas

INESTEDBITFLAGCLASSFUNCS(Style, ISetCanvas)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

/*----------------------------- Inline Functions -----------------------------*/
#include <isetcv.inl>

#endif /* _ISETCV_ */
