// Revision: 37 1.4.1.9 source/ui/basectl/isetbut.cpp, buttonctls, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: isetbut.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in isetbut.hpp.                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

extern "C"
{
  #define INCL_WINBUTTONS
  #define INCL_WINDIALOGS
  #include <iwindefs.h>
}

#ifdef IC_MOTIF
  #include <Xm/Label.h>
  #include <Xm/ToggleB.h>
#endif // IC_MOTIF

#include <ibidiset.hpp>
#include <inotifev.hpp>
#include <iradiobp.hpp>
#include <iradiobt.hpp>
#include <isetbut.hpp>

#ifdef IC_PAGETUNE
  #define _ISETBUT_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| ISettingButton::ISettingButton                                               |
------------------------------------------------------------------------------*/
ISettingButton::ISettingButton ( )
{ }

/*------------------------------------------------------------------------------
| ISettingButton::~ISettingButton                                              |
------------------------------------------------------------------------------*/
ISettingButton::~ISettingButton ( )
{ }

/*------------------------------------------------------------------------------
| ISettingButton::isSelected                                                   |
------------------------------------------------------------------------------*/
bool  ISettingButton::isSelected() const
{
#ifdef IC_PMWIN
  IEventResult evt = handle().sendEvent(BM_QUERYCHECK,
                             IEventParameter1(0),
                             IEventParameter2(0));
  if (evt.asUnsignedLong())
     return true;
  else
     return false;
#endif // IC_PMWIN

#ifdef IC_MOTIF
  bool bSet = false;

  bSet = XmToggleButtonGetState( handle());

  if (bSet)
    return true;
  else
    return false;
#endif // IC_MOTIF
}


/*------------------------------------------------------------------------------
| ISettingButton::select                                                       |
------------------------------------------------------------------------------*/
ISettingButton&  ISettingButton::select(bool sel)
{
#ifdef IC_PMWIN
  if ((sel && (!(this->isSelected()))) ||
      (!sel && (this->isSelected())))
  {
    ISize siz = size();
    bool wasvisible=isVisible();

    if (wasvisible && ((siz.width()==0) || (siz.height()==0)))
      hide();

    handle().sendEvent(BM_SETCHECK,
                       IEventParameter1(sel),
                       IEventParameter2(0));
                       
    //this is to insure at least one tabstop is in a group of radio buttons
    if (!(sel) &&
        (handle().sendEvent(WM_QUERYDLGCODE, 0, 0) & DLGC_RADIOBUTTON))
    {
      enableTabStop();
    }

#ifdef IC_WIN
    IWindowHandle hwnd = this->handle();
    if ((sel) &&
        (hwnd.sendEvent(WM_QUERYDLGCODE, 0, 0) & DLGC_RADIOBUTTON))
       {
       // We have to uncheck any other radio buttons in the group
       // ourselves.  Note that this code does not handle disabled
       // radio buttons properly.  There is code in the iradiobt.cpp
       // to do that since we have to handle that case when the button
       // is clicked by the user as well as set manually.
       IWindowHandle
          parent  ( IPARENTOF( hwnd ) ) ,
          first   (0),
          current (0);

       first = current = GetNextDlgGroupItem( parent, hwnd, FALSE);
       if (current != 0)
          {
          do
             {
             if (current != hwnd)
                {
                // Uncheck the button.
                current.sendEvent(BM_SETCHECK,
                                  IEventParameter1(0),
                                  IEventParameter2(0));
                // If tabstop is set turn it off.  Otherwise we have
                // key navigation problems.
                unsigned long style = ISTYLEOF(current);
                if (style & WS_TABSTOP)
                   {
                   style &= (unsigned long)~WS_TABSTOP;
                   ISETWINDOWSTYLE(current, style);
                   }
                }
             current = GetNextDlgGroupItem( parent, current, FALSE);
             }
          while (current != first );
          }
       }  // if radio button
#endif

    if (wasvisible && ((siz.width()==0) || (siz.height()==0)))
      show();

    this->notifyObservers(INotificationEvent(IButton::buttonClickId,
                                             *this, false));
  }
#endif // IC_PMWIN

#ifdef IC_MOTIF
  if ((sel && (!(this->isSelected()))) ||
      (!sel && (this->isSelected())))
  {
     //Because XmToggleButtonSetState notify parameter is false,
     //XmNvalueChangedCallback is NOT generated.  This is to keep the selected
     //function of any ISelectHandler from being called.  We must reset other
     //radio buttons and generate notifications here because they too rely
     //upon the callbacks.
     XmToggleButtonSetState( handle(), sel, false);
     if (sel && dynamic_cast<IRadioButton*>( this ))
     {  // Reset other radio buttons in group.
        IRadioButtonData::groupSelection( handle(), true );
     }

     this->notifyObservers(INotificationEvent(
                              IButton::buttonClickId,   *this, false));
     this->notifyObservers(INotificationEvent(
                              ISettingButton::selectId, *this, true, sel));
  }
#endif // IC_MOTIF

  return *this;
}


/*------------------------------------------------------------------------------
| ISettingButton::deselect                                                     |
------------------------------------------------------------------------------*/
ISettingButton&  ISettingButton::deselect()
{
  this->select(false);
  return *this;
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| ISettingButton::passEventToOwner                                                |
|                                                                              |
| Returns whether or not the event can be passed up to the owner of this       |
| control.                                                                     |
------------------------------------------------------------------------------*/
bool ISettingButton::passEventToOwner( IEvent& event )

{
  switch ( event.eventId() )
  {
    case WM_BUTTON1CLICK:
    case WM_BUTTON2CLICK:
    case WM_BUTTON3CLICK:
    case WM_CHORD:
      event.setPassToOwner( false );
      break;
    default:
      Inherited::passEventToOwner( event );
      break;
  }
  return event.passToOwner();
}
#endif // IC_MOTIF

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| ISettingButton::setBidiSettings                                              |
|                                                                              |
| Provide processing specific to a check box or radio button for a change to   |
| its bidirectional attributes.                                                |
------------------------------------------------------------------------------*/
ISettingButton&
  ISettingButton::setBidiSettings( const IBidiSettings& bidiSettings,
                                   bool childInherit,
                                   bool refresh )
{
  // Get the previous bidi attributes of the button.
  IBidiSettings
    prevBidiSettings( *this );

  // Let IWindow change the bidi attributes of the button.
  this->Inherited::setBidiSettings( bidiSettings, childInherit, refresh );

  if ( bidiSettings.windowLayout() == IBidiSettings::layoutLeftToRight  &&
       prevBidiSettings.windowLayout() == IBidiSettings::layoutRightToLeft )
  {  // The orientation of the button was changed from RTL to LTR.
     // Adjust the styles of the button to make it LTR.
     unsigned long
       styles = this->style();
     styles &= (unsigned long)( ~( BS_RIGHT | BS_RIGHTBUTTON ) );
     styles |= BS_LEFT;
     this->setStyle( styles );
  }
  else
  if ( bidiSettings.windowLayout() == IBidiSettings::layoutRightToLeft  &&
       prevBidiSettings.windowLayout() == IBidiSettings::layoutLeftToRight )
  {  // The orientation of the button was changed from LTR to RTL.
     // Adjust the styles of the button to make it RTL.
     unsigned long
       styles = this->style();
     styles &= (unsigned long)( ~BS_LEFT );
     styles |= ( BS_RIGHT | BS_RIGHTBUTTON );
     this->setStyle( styles );
  }

  return *this;
}
#endif // IC_WIN
