// Revision: 35 1.10.1.1 source/ui/basectl/iscroll1.cpp, slidectls, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: iscroll1.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in isclnhdr.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481324 )

#define INCL_WINSCROLLBARS
extern "C" {
  #include <iwindefs.h>
}

#ifdef IC_MOTIF
  #include <Xm/ScrollBar.h>
  #include <ictlevt.hpp>
#endif
#include <iwindow.hpp>
#include <iscroll.hpp>
#include <isclnhdr.hpp>
#include <ievent.hpp>
#include <inotifev.hpp>
#include <icconst.h>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _ISCROLL1_CPP_
  #include <ipagetun.h>
#endif

// Initialize static objects and notification strings.
INotificationId const IScrollBar::scrollBoxChangeId
                                       = "IScrollBar::scrollBoxChange";
INotificationId const IScrollBar::scrollBoxTrackId
                                       = "IScrollBar::scrollBoxTrack";
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
INotificationId const IScrollBar::scrollBoxPositionId
                                       = "IScrollBar::scrollBoxPosition";
#endif // IC_OBSOLETE


/*------------------------------------------------------------------------------
| IScrollBar::enableNotification                                               |
|                                                                              |
| Flags this part as being ready to accept notifications.  A Notifier, like    |
| IScrollBar, does not send notifications to observer objects until it is      |
| enabled.                                                                     |
|                                                                              |
| In the window hierarchy we override this function to allocate the correct    |
| notification handler.                                                        |
------------------------------------------------------------------------------*/
IScrollBar& IScrollBar::enableNotification (bool enabled)
{
  if (!notificationHandler())
  {
    setNotificationHandler( new IScrollBarNotifyHandler() );
  }
  IWindow::enableNotification(enabled);
  return(*this);
}

/*------------------------------------------------------------------------------
| IScrollBarNotifyHandler::IScrollBarNotifyHandler                             |
|                                                                              |
| Default constructor.                                                         |
------------------------------------------------------------------------------*/
IScrollBarNotifyHandler::IScrollBarNotifyHandler()
{}

/*------------------------------------------------------------------------------
| IScrollBarNotifyHandler::~IScrollBarNotifyHandler                            |
|                                                                              |
| Destructor.                                                                  |
------------------------------------------------------------------------------*/
IScrollBarNotifyHandler::~IScrollBarNotifyHandler()
{}

/*------------------------------------------------------------------------------
| IScrollBarNotifyHandler::dispatchHandlerEvent                                |
|                                                                              |
| This notifies IScrollBar Windows of the following events:                    |
|                                                                              |
| scrollBoxPosition(Id)                                                        |
------------------------------------------------------------------------------*/
#ifdef IC_PMWIN
bool IScrollBarNotifyHandler::dispatchHandlerEvent (IEvent& anEvent)
{
  IWindow* thisWindow = anEvent.window();

  if (thisWindow)
  {
    switch (anEvent.eventId())
    {
#ifdef IC_WIN
      case WM_CTLCOLORSCROLLBAR:
      {
//      if (anEvent.dispatchingWindow()->handle() == anEvent.parameter2())
        if ( anEvent.dispatchingWindow()->handle() ==
                            (IWindowHandle::Value) anEvent.parameter2() )
        {
           thisWindow->notifyObservers(INotificationEvent(
                                       IScrollBar::backgroundColorId,
                                       *thisWindow));
        }
      break;
      }
#endif

      case SBM_SETPOS:

        /**************************************************************/
        /* Post private message to delay notification until after     */
        /* the selection state has been modified                      */
        /**************************************************************/
        thisWindow->postEvent( IC_UM_DELAYNOTIFY,
                               IEventParameter1( anEvent.parameter1() ),
                               IEventParameter2( IC_NOTDEL_SCRL_POS ));
        break;


      /****************************************************************/
      /* This is the delayed notification message.  Check to see which*/
      /* notification should be sent to the observers based on info   */
      /* stored in parameter 2 of the private message.  Parameter 1   */
      /* contains the information passed in the original event that   */
      /* needs to be sent with the notification                       */
      /****************************************************************/
      case IC_UM_DELAYNOTIFY:

#if (IC_OBSOLETE <= IC_OBSOLETE_2)
        if (anEvent.parameter2().asUnsignedLong() == IC_NOTDEL_SCRL_POS)
        {
          thisWindow->notifyObservers(INotificationEvent(
                                      IScrollBar::scrollBoxPositionId,
                                      *thisWindow, true,
                                      (void*)anEvent.parameter1()));
        }
#endif // IC_OBSOLETE

        if (anEvent.parameter2().asUnsignedLong() == SB_SLIDERPOSITION )
        {
          unsigned long sliderPosition;
#ifdef IC_WIN
          sliderPosition = GetScrollPos(thisWindow->handle(),SB_CTL);
#endif
#ifdef IC_PM
          sliderPosition = thisWindow->sendEvent(SBM_QUERYPOS).asUnsignedLong();
#endif
          // Only notify observers if the position actually changed
          if ( sliderPosition != anEvent.parameter1())
          {
              thisWindow->notifyObservers(INotificationEvent(
                                          IScrollBar::scrollBoxChangeId,
                                          *thisWindow, true,
                                          (void*)sliderPosition));
          }
        }

        if (anEvent.parameter2().asUnsignedLong() == SB_SLIDERTRACK )
        {
          unsigned long sliderPosition;
#ifdef IC_WIN
          sliderPosition = GetScrollPos(thisWindow->handle(),SB_CTL);
#endif
#ifdef IC_PM
          sliderPosition = thisWindow->sendEvent(SBM_QUERYPOS).asUnsignedLong();
#endif
          // Only notify observers if the position actually changed
          if ( sliderPosition != anEvent.parameter1())
          {
              thisWindow->notifyObservers(INotificationEvent(
                                          IScrollBar::scrollBoxTrackId,
                                          *thisWindow, true,
                                          (void*)sliderPosition));
          }
        }

        break;

      case WM_VSCROLL:
      case WM_HSCROLL:
        {
          // Get the correct scroll bar control window
          thisWindow = anEvent.dispatchingWindow();
          if ( !thisWindow )
             thisWindow = anEvent.window();

          unsigned long sliderCommand;
          unsigned long sliderPosition;

#ifdef IC_WIN
          sliderCommand  = anEvent.parameter1().number1();
          sliderPosition = GetScrollPos(thisWindow->handle(),SB_CTL);
#endif
#ifdef IC_PM
          sliderCommand  = anEvent.parameter2().number2();
          sliderPosition = thisWindow->sendEvent(SBM_QUERYPOS).asUnsignedLong();
#endif
          switch ( sliderCommand )
          {
            case SB_SLIDERTRACK:
              thisWindow->postEvent( IC_UM_DELAYNOTIFY,
                                     IEventParameter1( sliderPosition ),
                                     IEventParameter2( SB_SLIDERTRACK ));
              break;
            case SB_LINELEFT:   // also SB_LINEUP
            case SB_LINERIGHT:  // also SB_LINEDOWN
            case SB_PAGELEFT:   // also SB_PAGEUP
            case SB_PAGERIGHT:  // also SB_PAGEDOWN
#ifdef IC_WIN
            case SB_BOTTOM:
            case SB_TOP:
#endif
              thisWindow->postEvent( IC_UM_DELAYNOTIFY,
                                     IEventParameter1( sliderPosition ),
                                     IEventParameter2( SB_SLIDERPOSITION ));
              break;
            // This is an "end track" condition and we need to notify the
            // user that we have completed tracking
            case SB_SLIDERPOSITION:
              thisWindow->postEvent( IC_UM_DELAYNOTIFY,
                                     IEventParameter1( 0 ),
                                     IEventParameter2( SB_SLIDERPOSITION ));
              break;
          }
        }
        break;

      default:
        break;
    }  /* end switch */
  }
  return (Inherited::dispatchHandlerEvent(anEvent));
}
#endif // IC_PMWIN

#ifdef IC_MOTIF
bool IScrollBarNotifyHandler::dispatchHandlerEvent (IEvent& anEvent)
{
  if (anEvent.eventId() == motifEvent(XmCR_VALUE_CHANGED))
  {
       IControlEvent ctlevt(anEvent);
       IWindow* pwndControl = ctlevt.controlWindow();
       IWindow* thisWindow;
       IWindowHandle hwndControl;

       if (pwndControl)
       {
         hwndControl = pwndControl->handle();
         thisWindow = pwndControl;
       }
       else
       {
         hwndControl = IWindow::handleWithParent(ctlevt.controlId(),
                                            ctlevt.handle());
         thisWindow = IWindow::windowWithOwner(ctlevt.controlId(),
                                            ctlevt.window());
       }
       if ( (thisWindow) && (hwndControl) )
       {
         if (XtIsSubclass((Widget)hwndControl, xmScrollBarWidgetClass))
         {
           unsigned long callbackStructPtr = anEvent.parameter1();
           XmScrollBarCallbackStruct *callbackStruct =
             (XmScrollBarCallbackStruct * ) callbackStructPtr;
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
           thisWindow->notifyObservers(INotificationEvent(
             IScrollBar::scrollBoxPositionId, *thisWindow, true,
             (void*)callbackStruct->value));
#endif
         }
       }
   }  /* end if */

   return (Inherited::dispatchHandlerEvent(anEvent));
}
#endif // IC_MOTIF
