// Revision: 12 1.38.2.4 source/ui/basectl/imle.cpp, editctls, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: imle.cpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in imle.hpp.                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

#define IUSING_OLE
#ifdef WIN32_LEAN_AND_MEAN
  #undef WIN32_LEAN_AND_MEAN
#endif
#ifdef _OLE2_H_
  #undef _OLE2_H_
#endif

extern "C" {
  #define INCL_WINMLE
  #define INCL_WINCLIPBOARD
  #define INCL_WININPUT             // WM_CHAR, etc.
  #define INCL_WINMESSAGEMGR        // for WNDPARAM struct
  #define INCL_WINWINDOWMGR         // WinQueryWindowULong
  #define INCL_GPIPRIMITIVES
  #define INCL_WINSYS
  #include <iwindefs.h>

#ifdef IC_PMWIN
  #include <sys\stat.h>
#endif
#ifdef IC_MOTIF
  #include <sys/stat.h>
#endif
  #include <stdio.h>              // include standard IO routines
}

#ifdef IC_MOTIF
  #define MLEIOBUFFERSIZE 1024*16  /* size of buffer for file IO */
  #define MARGINBORDERPIXELS 2     /* pixels for Margin style */

  #include <X11/IntrinsicP.h>     // for CoreP.h
  #include <X11/CoreP.h>          // for core.being_destroyed
  #include <Xm/Text.h>
  #include <Xm/ScrolledW.h>
#endif

#include <imle.hpp>
#include <ibidiset.hpp>
#include <icconst.h>
#include <icolor.hpp>
#include <icoordsy.hpp>
#include <iexcept.hpp>
#include <ifont.hpp>
#include <iinhratt.hpp>
#include <imcevt.hpp>
#include <imphdr.hpp>
#include <inotifev.hpp>
#include <iplatfrm.hpp>
#include <irect.hpp>
#include <ireslib.hpp>
#include <istring.hpp>
#include <itrace.hpp>
#ifdef IC_WIN
  #include <ibrushdr.hpp>
#endif

#ifdef IC_MOTIF
  #include <cnr.h>         // XmIsContainer
  #include <icnrobj.hpp>   // For icnrctlm.hpp
  #include <icnrrec.hpp>   // For icnrctlm.hpp
  #include <icnrctlm.hpp>  // ICnrControlData::mleParent
  #include <icnrctl.hpp>   // IContainerControl
  #include <iclcreat.h>    // XiclCreateScrolledText
#endif // IC_MOTIF

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IMLE_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
#pragma enum(4)
#pragma pack(push,4)

class IMLEOpenFile {
/*******************************************************************************
* Simplistic wrapper for FILE * objects.  Construct by passing a               *
* FILE * object, typically the return of fopen, as in:                         *
*  IMLEOpenFile inFile( fopen(pszFileName, "rb") );                            *
* To be useful, this object should be on the stack, since the destructor       *
* closes the file.                                                             *
*******************************************************************************/
public:
  IMLEOpenFile ( FILE * openFile );
 ~IMLEOpenFile ( );

  operator FILE* ( ) const { return fileP; }

private:
  FILE * fileP;
}; // IMLEOpenFile

#pragma pack(pop)
#pragma enum(pop)

/*------------------------------------------------------------------------------
| IMLEOpenFile::IMLEOpenFile                                                   |
------------------------------------------------------------------------------*/
IMLEOpenFile::IMLEOpenFile( FILE * openFile ) :
   fileP( openFile )
{
   if (!fileP)
     ITHROWCLIBERROR("fopen",
                      IBaseErrorInfo::accessError,
                      IException::recoverable);
}

/*------------------------------------------------------------------------------
| IMLEOpenFile::~IMLEOpenFile                                                  |
------------------------------------------------------------------------------*/
IMLEOpenFile::~IMLEOpenFile( )
{
   fclose(fileP);
}

/*------------------------------------------------------------------------------
|  Callback function prototype.                                                |
------------------------------------------------------------------------------*/
extern void imleMotifCallback( Widget w,
                               XtPointer clientdata,
                               XtPointer calldata);

static void imleMbcsCheck ( Widget w,
                            XtPointer clientdata,
                            XtPointer calldata);

static const char unixNewline = 0xa;

#endif // IC_MOTIF

#ifdef IC_PMWIN
// defect: 29763
// Create new support class to give us access to IBuffer::isDBCSLead( c )
class IDBCSChecker : public IBuffer
{
  public:
  static bool isDBCSLeader( char c )
  {
      if( init == 0 )
        init = IBuffer::initialize();
      return IBuffer::isDBCSLead( c );
  }
  private:
    static IBuffer *init;
    // no instances of this class allowed
    IDBCSChecker  (); // Constructor
    IDBCSChecker  (const IDBCSChecker& srcObject); // Copy constructor
    ~IDBCSChecker () {}; // Destructor
};
IBuffer* IDBCSChecker::init = 0;
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| Public multiple-line entry field control styles                              |
------------------------------------------------------------------------------*/
const IMultiLineEdit::Style
#ifdef IC_MOTIFPM
  IMultiLineEdit::wordWrap          = MLS_WORDWRAP,
  IMultiLineEdit::ignoreTab         = MLS_IGNORETAB,
#endif
#ifdef IC_WIN
  IMultiLineEdit::wordWrap          ( 0, IMLS_WORDWRAP ),
  IMultiLineEdit::ignoreTab         ( 0, IMLS_IGNORETAB ),
#endif
#ifdef IC_PMWIN
  IMultiLineEdit::border3D          ( 0, IWS_BORDER3D ),
#endif
#ifdef IC_MOTIF
  IMultiLineEdit::border3D          ( 0 ),
#endif
  IMultiLineEdit::border            = MLS_BORDER,
  IMultiLineEdit::verticalScroll    = MLS_VSCROLL,
  IMultiLineEdit::horizontalScroll  = MLS_HSCROLL,
  IMultiLineEdit::readOnly          = MLS_READONLY,
  IMultiLineEdit::classDefaultStyle ( WS_VISIBLE  |
                                      MLS_BORDER  |
                                      MLS_VSCROLL
#ifdef IC_MOTIFPM
                                      | MLS_WORDWRAP );
#endif
#ifdef IC_WIN
                                      , IMLS_WORDWRAP | IWS_BORDER3D );
#endif

const long IMultiLineEdit::deselect = -1;
const long IMultiLineEdit::end = -2;

/*------------------------------------------------------------------------------
| Default style for new objects (initial value).                               |
------------------------------------------------------------------------------*/
IMultiLineEdit::Style
  IMultiLineEdit::currentDefaultStyle ( WS_VISIBLE  |
                                        MLS_BORDER  |
                                        MLS_VSCROLL
#ifdef IC_MOTIFPM
                                      | MLS_WORDWRAP );
#endif
#ifdef IC_WIN
                                      , IMLS_WORDWRAP | IWS_BORDER3D );
#endif


#ifdef IC_WIN
// Workaround for NT bug with not returning WS_BORDER style
#define IMLS_BORDERNTHACK           0x00000008ul
#endif

#ifdef IC_WIN
#pragma enum(4)
#pragma pack(push,4)

class IMultiLineHandler : public IHandler {
/*------------------------------------------------------------------------------
| The IMultiLineHandler class is the default handler for IMultiLineEdit.       |
------------------------------------------------------------------------------*/
typedef IHandler
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IMultiLineHandler ( );

virtual
 ~IMultiLineHandler ( );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

}; // class IMultiLineHandler

#pragma pack(pop)
#pragma enum(pop)
#endif //IC_WIN

#ifdef IC_MOTIFWIN
#pragma enum(4)
#pragma pack(push,4)

class IMultiLineEditData  {
/*------------------------------------------------------------------------------
| The IMultiLineEditData class encapsulates private data and functions         |
| used by the IMultiLineEdit class.  An object of this class is created in the |
| IMultiLineEdit constructors.                                                 |
------------------------------------------------------------------------------*/
public:
  IMultiLineEditData ( );

 ~IMultiLineEditData ( );

#ifdef IC_MOTIF

enum ReadStatus {
  doesntMatter,
  wasInput,
  wasRead,
  wasInputButReset,
  wasReadButReset
  };

ReadStatus
  eReadStatus;

enum Flags {                    // values for flagsCl
  autoTab     = 1,
  unreadable  = 2,
  command     = 4,
  replaceMode = 8,
  ignoreTab   = 16,
  changed     = 64
  };

unsigned long
  flagsCl;

IString                         // actual value for unreadable
  urValueCl;

int
  iClrestOfMinimumWidth,
  iClrestOfMinimumHeight;

unsigned long
  lineFromPosition      ( unsigned long pos ) const;
unsigned long
  positionFromLine      ( unsigned long linenumber ) const;
enum LinePosDirection   {
  dLineFromPosition,
  dPositionFromLine
  };
unsigned long
  lineToFromPosition    ( unsigned long posOrLinenumber,
                          LinePosDirection direction ) const;
unsigned long
  lineLength            ( unsigned long     ipt ) const;

void
  registerCallbacks(IMultiLineEdit* mle);
void
  unregisterCallbacks(IMultiLineEdit* mle);

Widget
  textWidget (Widget topParent);
IWindowHandle
  textHandle;
#endif // IC_MOTIF

#ifdef IC_WIN
bool
  pointInSelectedText(const IEvent& evt);

bool
  bCheckingRightDragStart;
IPoint
  pointRButtonDown;
IMultiLineHandler
  fdefaultHandler;
IBrushHandler
  fBrushHandler;
#endif // IC_WIN

private:
  IMultiLineEditData ( const IMultiLineEditData& );
IMultiLineEditData
 &operator=          ( const IMultiLineEditData& );
}; // IMultiLineEditData

#pragma pack(pop)
#pragma enum(pop)

/*------------------------------------------------------------------------------
| IMultiLineEditData::IMultiLineEditData                                                 |
|                                                                              |
------------------------------------------------------------------------------*/
IMultiLineEditData::IMultiLineEditData ( )
#ifdef IC_WIN
    : bCheckingRightDragStart(false)
    , pointRButtonDown()
    , fdefaultHandler()
    , fBrushHandler()
#endif // IC_WIN
#ifdef IC_MOTIF
    : eReadStatus( doesntMatter )
    , flagsCl( 0 )
    , urValueCl( )
    , iClrestOfMinimumWidth( 36 )
    , iClrestOfMinimumHeight( 20 )
    , textHandle(0)
#endif // IC_MOTIF
{ }

/*------------------------------------------------------------------------------
| IMultiLineEditData::~IMultiLineEditData                                      |
|                                                                              |
------------------------------------------------------------------------------*/
IMultiLineEditData::~IMultiLineEditData ( )
{
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMultiLineEditData::textWidget( Widget topParent )                           |
|                                                                              |
------------------------------------------------------------------------------*/
Widget IMultiLineEditData :: textWidget ( Widget topParent )
{
  Cardinal numChildren;
  WidgetList children;
  XtVaGetValues( ( Widget) topParent,
    XmNnumChildren, &numChildren,
    XmNchildren, &children,
    NULL );

  for ( int i = 0; i < numChildren; i++ )
    {
      if (XtIsSubclass((Widget)children[i], xmTextWidgetClass))
         {
         XtManageChild(children[i]);
         return (Widget)children[i];
         }
    }
  return 0;
}
/*------------------------------------------------------------------------------
| IMultiLineEditData::registerCallbacks                                        |
------------------------------------------------------------------------------*/
void IMultiLineEditData :: registerCallbacks (IMultiLineEdit* mle)
{
   if ( !XtIsSubclass(textHandle, xmTextWidgetClass) )
     ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                          IBaseErrorInfo::accessError,
                          IException::recoverable,
                          "XmText");

   // Add the callback to handle the changed flag
   XtAddCallback(
      (Widget)textHandle,       // widget
      XmNvalueChangedCallback,  // callback name
      imleMotifCallback,  // callback routine
      this);                    // client data
   // Add the callback to handle replacemode and styles
   XtAddCallback(
      (Widget)textHandle,       // widget
      XmNmodifyVerifyCallback,  // callback name
      imleMotifCallback,  // callback routine
      this);                    // client data


   // Explicitly add X event handler for mle focus events
   XtAddEventHandler(
      (Widget)textHandle,             // widget
      FocusChangeMask,                // ask for FocusIn and FocusOut events
      True,                           // indicate we also want nonmaskable events
      iwindowXEventCallback,          // event handler routine
      (XtPointer) mle);               // save reference to this IWindow in client data
}

/*------------------------------------------------------------------------------
| IMultiLineEditData::unregisterCallbacks                                      |
------------------------------------------------------------------------------*/
void IMultiLineEditData :: unregisterCallbacks (IMultiLineEdit* mle)
{
  if (mle->isValid())
  {
    Widget wHandle = (Widget)mle->handle();
    // Only unregister callbacks if widget not to be destroyed
    if (!wHandle->core.being_destroyed)
    {
     if ( !XtIsSubclass(textHandle, xmTextWidgetClass) )
       ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                            IBaseErrorInfo::accessError,
                            IException::recoverable,
                            "XmText");

     // Remove the callback to handle the changed flag
     XtRemoveCallback(
        (Widget)textHandle,           // widget
        XmNvalueChangedCallback,  // callback name
        imleMotifCallback, // callback routine
        this);                     // client data
     // remove the callback to handle replacemode and styles
     XtRemoveCallback(
        (Widget)textHandle,           // widget
        XmNmodifyVerifyCallback,  // callback name
        imleMotifCallback, // callback routine
        this);                     // client data

     XtRemoveEventHandler(
        (Widget)textHandle,             // widget
        FocusChangeMask,                // ask for FocusIn and FocusOut events
        True,                           // indicate we also want nonmaskable events
        iwindowXEventCallback,          // event handler routine
        (XtPointer) mle);               // save reference to this IWindow in client data
    }
  }
}

#endif //IC_MOTIF

#endif // IC_MOTIFWIN (IMultiLineEditData)


#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMultiLineHandler::IMultiLineHandler                                                 |
|                                                                              |
| Empty constructor here for page tuning.                                      |
------------------------------------------------------------------------------*/
IMultiLineHandler::IMultiLineHandler()
{ }

/*------------------------------------------------------------------------------
| IMultiLineHandler::~IMultiLineHandler                                                |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IMultiLineHandler::~IMultiLineHandler()
{ }

/*------------------------------------------------------------------------------
| IMultiLineHandler::dispatchHandlerEvent                                          |
|                                                                              |
| Intercepts control color event                                               |
|    This handler returns false for all other events.                          |
------------------------------------------------------------------------------*/
bool IMultiLineHandler::dispatchHandlerEvent( IEvent& event )
{
  bool
    result = false;

  switch( event.eventId() )
  {
    case WM_CHAR:

      if ((unsigned long)event.parameter1() == VK_TAB )
      {
        IMultiLineEdit* mle = (IMultiLineEdit*)event.window();
        if ( mle->extendedStyle() & IMLS_IGNORETAB )
        {
          IWindow* owner = mle->owner();
          if (!owner)
            owner = mle->parent();
          owner->sendEvent(event);
          result = true;
        }
      }
      if ((unsigned long)event.parameter1() == VK_ESCAPE )
      {
        IMultiLineEdit* mle = (IMultiLineEdit*)event.window();
        IWindow* owner = mle->owner();
        if (!owner)
          owner = mle->parent();
        owner->sendEvent(event);
        result = true;
      }
      break;

    // Adding code to trap accelerator/mnemonics and send directly to
    // owner (allowing it to naturally progress through dispatcher results
    // in an audible beep caused by the default window procedure because
    // it cannot find a match for a mnemonic that we process in
    // ICanvas or IFrameWindow), eating original event.
    case WM_SYSCHAR:
    {
      IWindow* window = event.window();
      IWindow* owner = window->owner();
      if (!owner)
        owner = window->parent();
      if (owner)
      {
        owner->sendEvent( event );
        result = true;
      }
      break;
    }
    default:
      break;
  }
  return result;
}

#endif // IC_WIN (IMultiLineHandler)


/*------------------------------------------------------------------------------
| IMultiLineEdit::IMultiLineEdit                                               |
|                                                                              |
| Constructor to create a MLE control on a standard window.                    |
------------------------------------------------------------------------------*/
IMultiLineEdit::IMultiLineEdit( unsigned long ulId,
                                IWindow* pwndParent,
                                IWindow* pwndOwner,
                                const IRectangle& rectInit,
                                const Style& style )
                                 : bRefresh ( true )
                                 , fMultiLineEditData ( 0 )
#ifdef IC_WIN
                                 , fcharLimit( 0 )
                                 , flimitSet( false )
#endif
{
#ifdef IC_MOTIFWIN
  fMultiLineEditData = new IMultiLineEditData( );
#endif //IC_MOTIFWIN

  // assertions on input parms
  IASSERTPARM(pwndParent!=0);

  // Save the extended style to make sure we have a copy of it stored
  setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

#ifdef IC_PMWIN
  IWindowHandle parentHandle(0);
  IWindowHandle ownerHandle(0);
  if (pwndParent)
    parentHandle = pwndParent->handleForChildCreation();
  else
    parentHandle = IWindow::desktopWindow()->handle();
  if (pwndOwner)
    ownerHandle = pwndOwner->handle();

  unsigned long
    windowStyle = this->convertToGUIStyle( style );

#ifdef IC_WIN
  if( style & horizontalScroll )
     disableWordWrap();

  // Check if we need to supply bidi support to give the MLE a
  // right-to-left look.
  bool
    rightToLeft = false;
  if ( IBidiSettings::isBidiSupported() )
  {
     // IWindow bidi styles take precedence over inherited bidi
     // attributes.
     if ( style & IWindow::rightToLeft )
     {
        rightToLeft = true;
     }
     else if ( ! ( style & IWindow::leftToRight ) )
     {
        // The mle inherits bidi attributes from its parent window.
        IBidiSettings
          bidiValues( *pwndParent );
        if ( bidiValues.windowLayout() ==
                           IBidiSettings::layoutRightToLeft )
        {
           rightToLeft = true;
        }
     }
     if ( rightToLeft )
     {
        // Change the left-aligned control into a right-to-left one.
        windowStyle |= ES_RIGHT;
     }
  }
#endif // IC_WIN

  IWindowHandle whMLE(
      this -> create( ulId,
                      0,
                      windowStyle,
                      WC_MLE,
                      parentHandle,
                      ownerHandle,
                      rectInit,
                      0,
                      0,
                      defaultOrdering(),
                      convertToGUIStyle( style, true ) ) );

  startHandlingEventsFor(whMLE);
#ifndef IC_WIN
  setEditRegion();
#endif
#ifdef IC_WIN
  fMultiLineEditData->fdefaultHandler.handleEventsFor( this );
  fMultiLineEditData->fBrushHandler.handleEventsFor(this);

  // To get an MLE with a right-to-left layout, we must reset the extended
  // styles again.  The WS_EX_LEFTSCROLLBAR style seems to be ignored at
  // create time, but is honored if added afterwards.
  if ( rightToLeft )
  {
    unsigned long
      extendedStyle = GetWindowLong( whMLE, GWL_EXSTYLE );
    SetWindowLong( whMLE, GWL_EXSTYLE,
                   extendedStyle );
  }
#endif
  IMousePointerHandler::defaultHandler()->handleEventsFor(this);
#endif // IC_PMWIN

#ifdef IC_MOTIF
  IWindowHandle  whWidget;
  Arg            args[10];
  int            n = 0;

  /************************************/
  /*handle the size and location info */
  /************************************/

  if ( style != IWindow::noStyle )
  {
    if (style & IMultiLineEdit::border)
    {
      // sets a default border  -  in PM it is 1/2 a character
      XtSetArg(args[n], XmNborderWidth, MARGINBORDERPIXELS ); n++;
    }
    if (style & IMultiLineEdit::readOnly)
    {
      XtSetArg(args[n], XmNeditable, False ); n++;
      bRefresh = false;  // false indicates the field is RO.
    }
    if (style & IMultiLineEdit::wordWrap)
    {
      XtSetArg(args[n], XmNwordWrap, True ); n++;
    }
    /***********************************************************/
    /*Some of the styles need to be handled by logic in ientry-*/
    /*fieldMotifCallback.Save the style flags for this purpose.*/
    /***********************************************************/
    if (style & IMultiLineEdit::ignoreTab)
         fMultiLineEditData->flagsCl |= IMultiLineEditData::ignoreTab;
  }
  else
  {
    /************************************************/
    /*default is undo on without any style settings, but undo not supported in Motif */
    /************************************************/
  }

  XtSetArg( args[n], XmNeditMode, XmMULTI_LINE_EDIT ); n++;


  if ((style & IMultiLineEdit::horizontalScroll) ||
      (style & IMultiLineEdit::verticalScroll) )
  {
    /*******************************************************/
    /*to get scroll bars we use the convenience function to*/
    /*create the ScrolledWindow widget with the Text widget*/
    /*as a child.  Returned widget is the Text widget.     */
    /*Name of the ScrolledWindow is IString(ulId) + "SW"   */
    /*******************************************************/
    if ( !(style & IMultiLineEdit::horizontalScroll) )
    {
      // no horizontal scroll bar
      XtSetArg(args[n], XmNscrollHorizontal, False ); n++;
    }
    if ( !(style & IMultiLineEdit::verticalScroll) )
    {
      // no vertical scroll bar
      XtSetArg(args[n], XmNscrollVertical, False ); n++;
    }

    IWindowHandle parentHandle(0);
    IWindowHandle ownerHandle(0);
    if (pwndParent)
      parentHandle = pwndParent->handleForChildCreation();
    else
      parentHandle = IWindow::desktopWindow()->handle();
    if (pwndOwner)
      ownerHandle = pwndOwner->handle();
    whWidget =
        Inherited::create(
            ulId,
            NULL,
            style.asUnsignedLong(),
            (IXmCreateFunction)XiclCreateScrolledText,
            parentHandle,
            ownerHandle,
            rectInit,
            args,
            n);

    // the Text widget needs to be managed.  The ScrolledWindow
    // is managed by IWindow::show() at the appropriate time
    // to actually show the construct on the screen.
//    XtManageChild (whMLE);
  }
  else
  {
    /***********************************************************/
    /* When creating an mle as a child of the container widget */
    /* use the handle returned by the container method         */
    /* mleParent(). This is to allow the direct-edit mle to be */
    /* created on top of, and not inside the container.        */
    /* Note: the direct edit mle is created non-scrolled.      */
    /***********************************************************/

    IWindowHandle mleParentHandle;
    if( XmIsContainer(pwndParent->handleForChildCreation()) )
    {
      IContainerControl * icnr = (IContainerControl*)pwndParent;
      mleParentHandle = icnr->ppd->mleParent();
      whWidget =
         Inherited::create(
              ulId,
              NULL,
              style.asUnsignedLong(),
              (IXmCreateFunction)XmCreateText,
              mleParentHandle,
              pwndOwner ? pwndOwner->handle() : desktopWindow()->handle(),
              rectInit,
              args,
              n);
    }
    else
    {
      mleParentHandle = pwndParent->handle();
      IWindowHandle ownerHandle(0);
      if (pwndOwner)
      {
        ownerHandle = pwndOwner->handle();
      }
      whWidget =
         Inherited::create(
              ulId,
              NULL,
              style.asUnsignedLong(),
              (IXmCreateFunction)XmCreateText,
              mleParentHandle,
              ownerHandle,
              rectInit,
              args,
              n);
    }

  }
  // Stash away text widget handle
  if (XtIsSubclass((Widget)whWidget, xmTextWidgetClass))
    fMultiLineEditData->textHandle = whWidget;
  else
    fMultiLineEditData->textHandle = fMultiLineEditData->textWidget(whWidget);

   startHandlingEventsFor(whWidget);

   fMultiLineEditData->registerCallbacks(this);
#endif // IC_MOTIF
#ifdef IC_MOTIFWIN
  // add the inheritColor attribute to the window. MLE does
  // not inherit background color.
  IInheritColorAttribute
    inheritColor( IInheritColorAttribute::kForegroundColor );
  this->addOrReplaceAttribute( IAttributeName("IInheritColorAttribute"),
                               inheritColor );
#endif
#ifdef IC_WIN
  // the background color of the mle is dialog independant.
  setColor( PP_BACKGROUNDCOLOR, IColor::kEntryFieldBgnd);

  setLimit(0);  // sets to maximum limit on windows
#endif // IC_WIN
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::IMultiLineEdit                                               |
|                                                                              |
| Constructor to instantiate an object for a dialog template.                  |
------------------------------------------------------------------------------*/
IMultiLineEdit::IMultiLineEdit( unsigned long ulId,
                                IWindow* pwndParent )
                                 : bRefresh ( true )
                                 , fMultiLineEditData ( 0 )
#ifdef IC_WIN
                                 , fcharLimit( 0 )
                                 , flimitSet( false )
#endif
{
#ifdef IC_MOTIFWIN
  fMultiLineEditData = new IMultiLineEditData( );
#endif // IC_MOTIFWIN

  setAutoDestroyWindow(false);

#ifdef IC_PMWIN
  reserveUserWindowWord( false );
  startHandlingEventsFor(ulId, pwndParent);
#ifdef IC_PM
  setEditRegion();
#endif
#ifdef IC_WIN
  fMultiLineEditData->fdefaultHandler.handleEventsFor( this );
  fMultiLineEditData->fBrushHandler.handleEventsFor(this);
#endif
  IMousePointerHandler::defaultHandler()->handleEventsFor(this);
#endif //IC_PMWIN

  // Get the system style and look for extended styles.  Set if found.
  unsigned long sysStyle = style();

  // Extended style should always be zero
  unsigned long extStyle = extendedStyle();

#ifdef IC_PMWIN
#ifdef IC_WIN
  // Since we can't query the WS_BORDER style due to a NT bug, assume the
  // wrappered control always has a border (will be correct in most cases)
  extStyle |= IMLS_BORDERNTHACK;
#endif

  // Check for the 3D border style - will be WS_EX_CLIENTEDGE in NT and zero
  // otherwise
  if ((sysStyle & IWS_BORDER3D) || (sysStyle & MLS_BORDER))
     extStyle |= IWS_BORDER3D;

#ifdef IC_WIN
  // If auto horizontal scroll is not set, then we want wordwrap in NT
  if (!(sysStyle & ES_AUTOHSCROLL))
     extStyle |= IMLS_WORDWRAP;
  else disableWordWrap();

  setLimit(0);  // sets to maximum limit on windows
#endif // IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF
   IWindowHandle handle=NULL;

   handle =  XtNameToWidget(pwndParent->handle(), (char *)IString(ulId) );
   if (handle == 0)
   {
     IWindowHandle swHandle = XtNameToWidget (pwndParent->handle(),
                              (char *)(IString(ulId) + "SW"));
     if (swHandle)
       handle = XtNameToWidget (swHandle, (char*)IString(ulId));

     if (handle == 0)
      ITHROWLIBRARYERROR1( IC_CONTROL_NOT_FOUND,
                           IBaseErrorInfo::accessError,
                           IException::recoverable,
                           "XtNameToWidget (XmText)");
   }

  // Stash away text widget handle
  if (XtIsSubclass((Widget)handle, xmTextWidgetClass))
    fMultiLineEditData->textHandle = handle;
  else
    fMultiLineEditData->textHandle = fMultiLineEditData->textWidget(handle);

   fMultiLineEditData->registerCallbacks(this);
   wrapIt(handle );
#endif // IC_MOTIF

  // Set the extended style
  setExtendedStyle (extStyle);
#ifdef IC_MOTIFWIN
  // add the inheritColor attribute to the window. MLE does
  // not inherit background color.
  IInheritColorAttribute
    inheritColor( IInheritColorAttribute::kForegroundColor );
  this->addOrReplaceAttribute( IAttributeName("IInheritColorAttribute"),
                               inheritColor );
#endif
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::IMultiLineEdit                                               |
|                                                                              |
| Constructor to instantiate from an existing MLE control.                     |
------------------------------------------------------------------------------*/
IMultiLineEdit::IMultiLineEdit ( const IWindowHandle& wh )
                                 : bRefresh ( true )
                                 , fMultiLineEditData ( 0 )
#ifdef IC_WIN
                                 , fcharLimit( 0 )
                                 , flimitSet( false )
#endif
{
#ifdef IC_MOTIFWIN
  fMultiLineEditData = new IMultiLineEditData( );
#endif // IC_MOTIFWIN
  setAutoDestroyWindow(false);

#ifdef IC_PMWIN
#ifdef IC_WIN
  fMultiLineEditData->fdefaultHandler.handleEventsFor( this );
  fMultiLineEditData->fBrushHandler.handleEventsFor(this);
#endif
  reserveUserWindowWord( false );
  startHandlingEventsFor(wh);
  IMousePointerHandler::defaultHandler()->handleEventsFor(this);
#endif //IC_PMWIN

  // Get the system style and look for extended styles.  Set if found.
  unsigned long sysStyle = style();

  // Extended style should always be zero
  unsigned long extStyle = extendedStyle();

#ifdef IC_PMWIN
#ifdef IC_WIN
  // Since we can't query the WS_BORDER style due to a NT bug, assume the
  // wrappered control always has a border (will be correct in most cases)
  extStyle |= IMLS_BORDERNTHACK;
#endif

  // Check for the 3D border style - will be WS_EX_CLIENTEDGE in NT and zero
  // otherwise
  if ((sysStyle & IWS_BORDER3D) || (sysStyle & MLS_BORDER))
     extStyle |= IWS_BORDER3D;

#ifdef IC_WIN
  // If auto horizontal scroll is not set, then we want wordwrap in NT
  if (!(sysStyle & ES_AUTOHSCROLL))
     extStyle |= IMLS_WORDWRAP;
  else disableWordWrap();

  setLimit(0);  // sets to maximum limit on windows
#endif // IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF

  // Stash away text widget handle
  if (XtIsSubclass((Widget)wh, xmTextWidgetClass))
    fMultiLineEditData->textHandle = wh;
  else
    fMultiLineEditData->textHandle = fMultiLineEditData->textWidget(wh);

   fMultiLineEditData->registerCallbacks(this);
   wrapIt(wh);
#endif // IC_MOTIF

  // Set the extended style
  setExtendedStyle (extStyle);
#ifdef IC_MOTIFWIN
  // add the inheritColor attribute to the window. MLE does
  // not inherit background color.
  IInheritColorAttribute
    inheritColor( IInheritColorAttribute::kForegroundColor );
  this->addOrReplaceAttribute( IAttributeName("IInheritColorAttribute"),
                               inheritColor );
#endif
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::~IMultiLineEdit                                              |
|                                                                              |
| Remove the default mouse pointer handler                                     |
------------------------------------------------------------------------------*/
IMultiLineEdit::~IMultiLineEdit()
{
#ifdef IC_PMWIN
  IMousePointerHandler::defaultHandler()->stopHandlingEventsFor(this);
#endif

#ifdef IC_WIN
  fMultiLineEditData->fdefaultHandler.stopHandlingEventsFor( this );
  fMultiLineEditData->fBrushHandler.stopHandlingEventsFor(this);
#endif // IC_WIN

#ifdef IC_MOTIF
  fMultiLineEditData->unregisterCallbacks(this);
#endif //IC_MOTIF

#ifdef IC_MOTIFWIN
  delete fMultiLineEditData;
#endif // IC_MOTIFWIN
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::Style  IMultiLineEdit::defaultStyle                          |
|                                                                              |
| Return the default style for new entry field objects.                        |
------------------------------------------------------------------------------*/
IMultiLineEdit::Style  IMultiLineEdit::defaultStyle()
{
  return currentDefaultStyle;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::setDefaultStyle                                              |
|                                                                              |
| Replace the default style for new entry field objects.                       |
------------------------------------------------------------------------------*/
void  IMultiLineEdit::setDefaultStyle(const Style& mlsStyle)
{
  currentDefaultStyle = mlsStyle;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::convertToGUIStyle                                            |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit :: convertToGUIStyle(const IBitFlag& guiStyle,
                                                  bool bExtOnly) const
{
  // Obtain the style from the class (ITextControl) that we inherit from
  unsigned long ulStyle = Inherited::convertToGUIStyle( guiStyle, bExtOnly );

  if (bExtOnly)
  {
    // Use mask to only return extended styles in the user defined range
    ulStyle |= guiStyle.asExtendedUnsignedLong() & ( IS_EXTMASK | ITC_EXTGUIMASK);
#ifdef IC_WIN
    if ( !(guiStyle.asUnsignedLong() & IMultiLineEdit::border.asUnsignedLong()))
    {
      // if border is not specified then remove border3D
      ulStyle &= (unsigned long)~IWS_BORDER3D;
    }
    else
    // Hack around bug in Windows NT 3.51 which does not allow the WS_BORDER
    // style to be queried back after use on create - Use our own style for now
      ((IMultiLineEdit*)this)->setExtendedStyle( extendedStyle() |
         IMLS_BORDERNTHACK );
#endif

  }
  else
  {
    // Let the clean MLS_ styles, flow thru
    ulStyle |= guiStyle.asUnsignedLong() & IMLS_MASK;

#ifdef IC_WIN
    // For Windows it is always a child and always has multiline style
    ulStyle |= WS_CHILD | ES_MULTILINE | ES_AUTOVSCROLL;

    // If extended style of IMLS_WORDWRAP is NOT set, then add auto hscroll
    if (!( guiStyle.asExtendedUnsignedLong() & IMLS_WORDWRAP))
      ulStyle |= ES_AUTOHSCROLL;
#endif
  }

  return( ulStyle );
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setTextChangedFlag                                           |
|                                                                              |
| Set a flag to indicate that the MLE contents have changed.                   |
------------------------------------------------------------------------------*/
IMultiLineEdit&   IMultiLineEdit::setTextChangedFlag( bool changed )
{
#ifdef IC_PMWIN
   handle().sendEvent(MLM_SETCHANGED, IEventParameter1(changed),
                                      IEventParameter2(0));
#endif // IC_PMWIN

#ifdef IC_MOTIF
  if ( changed )
    fMultiLineEditData->flagsCl |=  IMultiLineEditData::changed;
  else
    fMultiLineEditData->flagsCl &= ~IMultiLineEditData::changed;
#endif //IC_MOTIF
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::resetTextChangedFlag                                         |
|                                                                              |
| Reset the flag that indicates that the MLE contents have changed.            |
------------------------------------------------------------------------------*/
IMultiLineEdit&   IMultiLineEdit::resetTextChangedFlag( )
{
   setTextChangedFlag( false );
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::hasTextChanged                                               |
|                                                                              |
| Queries whether the MLE text has changed since the last time the changed     |
| flag was cleared.                                                            |
------------------------------------------------------------------------------*/
bool  IMultiLineEdit::hasTextChanged( ) const
{
#ifdef IC_PMWIN
  IEventResult evt(handle().sendEvent(MLM_QUERYCHANGED,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));
  return ( evt.asUnsignedLong() != 0 );
#endif // IC_PMWIN
#ifdef IC_MOTIF
  return ( (fMultiLineEditData->flagsCl & IMultiLineEditData::changed) ? true : false);
#endif // IC_MOTIF
}



/*------------------------------------------------------------------------------
| IMultiLineEdit::disableDataUpdate                                            |
|                                                                              |
| Set the MLE to read-only mode, preventing updates to the text.               |
------------------------------------------------------------------------------*/
IMultiLineEdit&   IMultiLineEdit::disableDataUpdate()
{
   enableDataUpdate(false);
   return *this;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::enableDataUpdate                                             |
|                                                                              |
| Sets the MLE to read-write mode which allows the user to update the MLE text.|
------------------------------------------------------------------------------*/
IMultiLineEdit&  IMultiLineEdit::enableDataUpdate ( bool update )
{
#ifdef IC_PMWIN
  bool writeable = this->isWriteable();

  /***************************/
  /* Only set if we need to. */
  /***************************/
  if ((update && !writeable) || (!update && writeable))
  {
    handle().sendEvent(MLM_SETREADONLY, IEventParameter1(!update),
                                        IEventParameter2(0));
  }
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if ((update && (!(this->isWriteable()))) ||
    (!update && (this->isWriteable())))
    this->notifyObservers(INotificationEvent(
                          IMultiLineEdit::dataUpdateId, *this,
                          true, update ? True : False ));
  XtVaSetValues(fMultiLineEditData->textHandle, XmNeditable, update, NULL);
  bRefresh = update;  // Remember this for enableUpdate.
#endif // IC_MOTIF

  return *this;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::isWriteable                                                  |
------------------------------------------------------------------------------*/
bool IMultiLineEdit::isWriteable() const
{
#ifdef IC_PMWIN
#ifdef IC_WIN
  if ( style() & readOnly.asUnsignedLong() )
#else
  IEventResult evt(handle().sendEvent(MLM_QUERYREADONLY,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));
  if (evt.asUnsignedLong())
#endif
     return false;
  else
     return true;
#endif // IC_PMWIN
#ifdef IC_MOTIF
   ::Boolean isRW = False;
   XtVaGetValues(fMultiLineEditData->textHandle, XmNeditable, &isRW, NULL);
   if (isRW)
      return true;
   else
      return false;
#endif // IC_MOTIF
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::disableUpdate                                                |
|                                                                              |
| Disable screen updates.                                                      |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::disableUpdate()
{
  enableUpdate( false );
  return *this;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::enableUpdate                                                 |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::enableUpdate( bool update )
{
#ifdef IC_PMWIN
  Inherited::enableUpdate( update );
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if ( bRefresh ) XtVaSetValues(fMultiLineEditData->textHandle,
                                XmNeditable, update, NULL);
#endif // IC_MOTIF
  return *this;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::setText                                                      |
|                                                                              |
| Changes the control text given a string.                                     |
------------------------------------------------------------------------------*/
IMultiLineEdit&  IMultiLineEdit::setText(const char* pszText)
{
  this->setText( pszText, 0 );
  return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setText                                                      |
|                                                                              |
| Changes the control text using the string table.                             |
------------------------------------------------------------------------------*/
IMultiLineEdit&  IMultiLineEdit::setText(const IResourceId& residText)
{
  Inherited::setText( residText );
  return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setText                                                      |
|                                                                              |
| Changes the control text to the text passed in the buffer.                   |
|                                                                              |
| Motif Notes:                                                                 |
| Changes the control text to the text passed in the buffer. Since the Motif   |
| XmText widget does not support imbedded NULLs (or any imbedded non-printable |
| characters), the ulBufferSize parameter is ignored; only text up to the      |
| first NULL is loaded into the control. To insure portability, you should not |
| attempt to load text containing NULLS into an IMLE. This is dangerous        |
| regardless of portability issues, as imbedded NULLS or other non-printable   |
| characters cannot be seen by the user and are likely to be typed over,       |
| deleted, or otherwise inadvertently destroyed.                               |
|                                                                              |
------------------------------------------------------------------------------*/
IMultiLineEdit&  IMultiLineEdit::setText( const char*   pszBuffer,
                                          unsigned long ulBufferSize )
{
#ifdef IC_PMWIN
   /*******************************************************************/
   /* If no buffer size passed, then use the entire character buffer  */
   /*******************************************************************/
   if (pszBuffer && !ulBufferSize)
     ulBufferSize = strlen(pszBuffer);

#ifdef IC_WIN
   if (ulBufferSize <= limit())
   {
      /*******************************************************************/
      /* Create a temporary buffer, so that we can take into account the */
      /*  buffer size (in case a truncation is necessary)                */
      /*******************************************************************/
      IString textString( pszBuffer, (unsigned int)ulBufferSize );

      /**************************************************************/
      /* No import support in Windows so just set the text          */
      /**************************************************************/
      Inherited::setText( textString );
   }
   else
   {
      ITHROWLIBRARYERROR( IC_INVALIDSIZE_LIMIT,
                          IBaseErrorInfo::invalidParameter,
                          IException::recoverable );
   } /* endif */
#endif
#ifdef IC_PM
   removeAll();                   // First clear out the MLE text

   /**************************************************************/
   /* Handle setting the MLE text to NULL                        */
   /**************************************************************/
   if ( !pszBuffer )
     return *this;

   /**************************************************************/
   /* Specify the origin of the text to be imported from the     */
   /* buffer as the current cursor position.                     */
   /**************************************************************/
   long ipt = -1;

   /**************************************************************/
   /* Specify the buffer for MLE object import operation.        */
   /**************************************************************/
   importFromBuffer(&ipt,ulBufferSize,pszBuffer);   // Import text from buffer
#endif
#endif // IC_PMWIN
#ifdef IC_MOTIF
   IString str;
   if (ulBufferSize == 0)
     str = IString(pszBuffer);    // use entire buffer (up to 1st null)
   else  {
     str = IString(pszBuffer, ulBufferSize );     // extract the part we want
     str += NULL;                //insure it is null-terminated
   }
   XmTextSetString(fMultiLineEditData->textHandle, str);
#endif // IC_PMWIN
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::text                                                         |
|                                                                              |
| Returns the current contents of the MLE                                      |
------------------------------------------------------------------------------*/
IString IMultiLineEdit::text() const
{
#ifdef IC_WIN
   /**************************************************************/
   /* No export support in Windows so just get the text string   */
   /**************************************************************/
   return Inherited::text();
#endif // IC_WIN
#ifdef IC_PM
   unsigned long numChars;             // Number of characters exported
   long ipt(0);

   unsigned long ulMyBufSize(textLengthAfterFormat() + 1);
                                  // Set buffer length

   char* pszNewBuf = new char[ulMyBufSize];
                                  // Create buffer

   numChars = ((IMultiLineEdit *)this)->exportToBuffer(&ipt,ulMyBufSize-1,pszNewBuf);
                                  // Export text to buffer

   *(pszNewBuf + numChars) = '\0';// Add a null terminator
   IString str( pszNewBuf );
   delete pszNewBuf;
   return str;
#endif // IC_PM
#ifdef IC_MOTIF
   char* pszNewBuf = XmTextGetString( fMultiLineEditData->textHandle );
   //No need to add null terminator; widget value includes one.
   IString str( pszNewBuf );
   XtFree(pszNewBuf);
   return str;
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::text                                                         |
|                                                                              |
| Returns the current contents of the MLE at the specified line number.        |
------------------------------------------------------------------------------*/
IString IMultiLineEdit::text(unsigned long lLineNumber) const
{
#ifdef IC_PMWIN
   LONG  numChars;                // Number of chars exported
   long  ipt(0);
   char* pszNewBuf;
   unsigned long ulMyBufSize;

   if (lLineNumber < numberOfLines())
   {
      ipt = (long)((unsigned long) handle().sendEvent(MLM_CHARFROMLINE,
                                 IEventParameter1(lLineNumber),
                                 IEventParameter2(0)));
   } else {
      return IString();
   }
   ulMyBufSize = (unsigned long) handle().sendEvent(MLM_QUERYLINELENGTH,
                              IEventParameter1((unsigned long)ipt),
                              IEventParameter2(0));

   pszNewBuf = new char[ulMyBufSize + 1]; // Create buffer
#ifdef IC_WIN
   // Windows GetLine function requires buffer size to be in first word
   // so set it there and pass line number and buffer for query
   pszNewBuf[0] = (char)ulMyBufSize;
   numChars = handle().sendEvent( EM_GETLINE,
                                  IEventParameter1(lLineNumber),
                                  IEventParameter2(pszNewBuf) );
#else
   numChars = ((IMultiLineEdit *)this)->exportToBuffer(&ipt,ulMyBufSize,pszNewBuf);
                                      // Export text to buffer
#endif
   *(pszNewBuf + numChars) = '\0';    // Add a null terminator
   IString str( pszNewBuf );
   delete pszNewBuf;
   return str;
#endif // IC_PMWIN
#ifdef IC_MOTIF
  long ipt = 0, iptNext = 0;
  char* pszNewBuf;
  unsigned long ulMyBufSize;

  if (lLineNumber < numberOfLines())
    ipt = positionFromLine(lLineNumber);               // start pos
  else
    return IString();

  pszNewBuf = XmTextGetString( fMultiLineEditData->textHandle );

  if ((lLineNumber+1) < numberOfLines())
  {
    iptNext = positionFromLine(lLineNumber+1) - 1;     // end pos
    ulMyBufSize = iptNext - ipt;                       // length wanted
    // Note: The above buffer size does not include the last char of the
    //       line. This is OK for all lines except the last line since
    //       for all those lines the last char is a newline char ('\n').
  }
  else
  {
    iptNext = textLength() - 1;                        // end of text
    // Check if last char is a newline char
    if ( *(pszNewBuf+iptNext) == '\n' )
      ulMyBufSize = iptNext - ipt;     // length wanted - exclude '\n'
    else
      ulMyBufSize = iptNext - ipt + 1; // length wanted - include last char
  }

  IString str( pszNewBuf+ipt, ulMyBufSize );   // extract the part we want
  XtFree(pszNewBuf);                           // free buffer
  return str;
#endif // IC_MOTIF
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::addAtOffset                                                  |
|                                                                              |
| Insert the specified text into the MLE at the specified insertion point.     |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::addAtOffset( const char*   pszBuffer,
                                             unsigned long lInsertionPoint,
                                             unsigned long ulBufferSize,
                                             EOLFormat     type )
{
  long ipt;
  if (ulBufferSize == 0)                 // If no size specified,
    ulBufferSize = strlen(pszBuffer);   // Assume null-terminated string
#ifdef IC_PM
  long lNumInserted;
  long iptCursor;

  ipt = lInsertionPoint;                 // Input to zero-based
  switch (type)
  {
    case cfText:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_CFTEXT),
                                         IEventParameter2(0));
      break;
    case noTran:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_NOTRANS),
                                         IEventParameter2(0));
      break;
    case MLEFormat:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_WINFMT),
                                        IEventParameter2(0));
      break;
  } /* endswitch */

  /**************************************************************/
  /* Import text from the buffer into the MLE                   */
  /**************************************************************/
  lNumInserted = (long)importFromBuffer(&ipt,ulBufferSize,pszBuffer);
  IEventResult evt(handle().sendEvent(MLM_QUERYSEL,
                                       IEventParameter1(MLFQS_CURSORSEL),
                                       IEventParameter2(0)));
  iptCursor = evt.asUnsignedLong();
  if (iptCursor > lInsertionPoint)
  {                                      // If text was inserted before
    iptCursor += lNumInserted;           // the cursor location, reset the
    setCursorPosition( iptCursor );      // cursor position
  } /* endif */
#endif // IC_PM
#ifdef IC_WIN
  IRange  initMarked, newMarked;
  bool bMustRestore = false;

  /*******************************************************************/
  /* If selected text exists, save range away to restore later       */
  /*******************************************************************/
  if (hasSelectedText())
  {
    bMustRestore = true;
    initMarked = selectedRange();
    newMarked = initMarked;
  }

  /*******************************************************************/
  /* Disable refresh while modifications are made to avoid flashing  */
  /*******************************************************************/
  bool bOldRefresh=bRefresh;

  unsigned long style = this->style();
  if ( bRefresh && (style & WS_VISIBLE) )
    disableUpdate();

  /*******************************************************************/
  /* Place cursor at indicated position and insert text              */
  /*******************************************************************/
  ipt = lInsertionPoint;
  setCursorPosition( ipt );
  handle().sendEvent( EM_REPLACESEL,
                      IEventParameter1(0),
                      IEventParameter2((char*)pszBuffer) );


  /*******************************************************************/
  /* Restore refresh (if required) after text inserted.  Must enable */
  /* window prior to selection or cursor update.                     */
  /*******************************************************************/
  if (bOldRefresh && (style & WS_VISIBLE) )
    enableUpdate();

  /*******************************************************************/
  /* If a range was selected before, then restore that range         */
  /*******************************************************************/
  if (bMustRestore)
  {
    /*****************************************************************/
    /* If text inserted is before selected range, move range up      */
    /*****************************************************************/
    if ( initMarked.lowerBound() > ipt )
      newMarked.setLowerBound( initMarked.lowerBound() + ulBufferSize);

    /*****************************************************************/
    /* If text is inserted into the selected area, then change upper */
    /*****************************************************************/
    else if ( (initMarked.lowerBound() <= ipt) &&
              (initMarked.upperBound() > ipt) )
    {
      newMarked.setUpperBound(initMarked.upperBound() + ulBufferSize);
    }

    /*****************************************************************/
    /* If inserted above, then original range is still valid so in   */
    /* any case, must restore selection.                             */
    /*****************************************************************/
    selectRange( newMarked );
  }
  else
    setCursorPosition(ipt+ulBufferSize);

#endif // IC_WIN
#ifdef IC_MOTIF
  if (ulBufferSize == 0)                 // If no size is specified,
    XmTextInsert(                        // assume null-terminated string
       fMultiLineEditData->textHandle,            // widget
       lInsertionPoint,     // character to insert after
       (char *)pszBuffer);  // string, assumed to be already null-terminated
  else
  {
    IString str (pszBuffer, ulBufferSize);  //create substring
    str += '\0';         // insure it's null-terminated
    XmTextInsert(
       fMultiLineEditData->textHandle,         // widget
       lInsertionPoint,  // character to insert after
       str);             // sub-string
  }

  // No need to adjust the cursor; XmText always leaves cursor unchanged.
#endif // IC_MOTIF
   return *this;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::addAsLast                                                    |
|                                                                              |
| Insert the specified text into the MLE at the end of the existing text.      |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::addAsLast( const char*   pszBuffer,
                                           unsigned long ulBufferSize,
                                           EOLFormat     type)
{
#ifdef IC_PM
  if (ulBufferSize == 0)                 // If no size specified,
     ulBufferSize = strlen(pszBuffer);   // Assume null-terminated string
  long ipt(textLengthAfterFormat());

  switch (type)
  {
    case cfText:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_CFTEXT),
                                         IEventParameter2(0));
      break;
    case noTran:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_NOTRANS),
                                         IEventParameter2(0));
      break;
    case MLEFormat:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_WINFMT),
                                         IEventParameter2(0));
      break;
  } /* endswitch */

  /**************************************************************/
  /* Import text from the buffer into the MLE                   */
  /**************************************************************/
  importFromBuffer(&ipt,ulBufferSize,pszBuffer);

  // Position cursor after newly inserted text; ipt now is insertion
  // point + buffer size
  setCursorPosition( ipt );
#endif // IC_PM
#ifdef IC_WIN
  if (ulBufferSize == 0)                 // If no size specified,
     ulBufferSize = strlen(pszBuffer);   // Assume null-terminated string
  IRange  initMarked;
  bool bMustRestore = false;

  /*******************************************************************/
  /* If selected text exists, save range away to restore later       */
  /*******************************************************************/
  if (hasSelectedText())
  {
    bMustRestore = true;
    initMarked = selectedRange();
  }

  /*******************************************************************/
  /* Disable refresh while modifications are made to avoid flashing  */
  /*******************************************************************/
  bool bOldRefresh=bRefresh;
  unsigned long style = this->style();

  if ( bRefresh && (style & WS_VISIBLE) )
    disableUpdate();

  /*******************************************************************/
  /* Place cursor at end of text and insert                          */
  /*******************************************************************/
  long ipt = textLength();
  setCursorPosition( ipt + 1 );
  handle().sendEvent( EM_REPLACESEL,
                       IEventParameter1(0),
                       IEventParameter2((char*)pszBuffer) );

  /*******************************************************************/
  /* Restore refresh (if required) after text inserted.  Must enable */
  /* window prior to selection or cursor update.                     */
  /*******************************************************************/
  if (bOldRefresh && (style & WS_VISIBLE) )
    enableUpdate();

  /*******************************************************************/
  /* If original selection, restore, otherwise put cursor after text */
  /*******************************************************************/
  if (bMustRestore)
    selectRange( initMarked );
  else
    setCursorPosition(ipt+ulBufferSize);

#endif // IC_WIN
#ifdef IC_MOTIF
  long lInsertionPoint = textLength();   //get pos of "end of existing text"

  if (ulBufferSize == 0)                 // If no size is specified,
    XmTextInsert(                        // assume null-terminated string
       fMultiLineEditData->textHandle,            // widget
       lInsertionPoint,     // character to insert after
       (char *)pszBuffer);  // string, assumed to be already null-terminated
  else
  {
    IString str (pszBuffer, ulBufferSize);  //create substring
    str += '\0';         // insure it's null-terminated
    XmTextInsert(
       fMultiLineEditData->textHandle,         // widget
       lInsertionPoint,  // character to insert after
       str);             // sub-string
  }

  // No need to adjust the cursor; XmText always leaves cursor unchanged.
#endif // IC_MOTIF
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::add                                                          |
|                                                                              |
| Insert the specified text into the MLE at the current cursor position.       |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::add( const char*   pszBuffer,
                                     unsigned long ulBufferSize,
                                     EOLFormat     type )
{
#ifdef IC_PMWIN
  if (ulBufferSize == 0)                 // If no size specified,
     ulBufferSize = strlen(pszBuffer);   // Assume null-terminated string
  long ipt(-1);                          // Insert at current cursor position
#endif //IC_PMWIN

#ifdef IC_WIN
  ipt = cursorPosition();
  setCursorPosition(ipt);                // Deselect any current selection
  handle().sendEvent( EM_REPLACESEL,
                       IEventParameter1(0),
                       IEventParameter2((char*)pszBuffer) );
  setCursorPosition(ipt+ulBufferSize);   // Position cursor after newly
                                          // inserted text
#endif // IC_WIN
#ifdef IC_PM
  switch (type)
  {
    case cfText:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_CFTEXT),
                                     IEventParameter2(0));
      break;
    case noTran:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_NOTRANS),
                                     IEventParameter2(0));
      break;
    case MLEFormat:
      handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_WINFMT),
                                     IEventParameter2(0));
      break;
  } /* endswitch */

  /**************************************************************/
  /* Import text from the buffer into the MLE                   */
  /**************************************************************/
  importFromBuffer( &ipt, ulBufferSize, pszBuffer );

  // Position cursor after newly inserted text; ipt now is insertion
  // point + buffer size
  setCursorPosition( ipt );
#endif // IC_PM
#ifdef IC_MOTIF
  long lInsertionPoint = XmTextGetInsertionPosition( fMultiLineEditData->textHandle );
  if (ulBufferSize == 0)
    {
    // If no size is specified assume null-terminated string
    XmTextInsert(
       fMultiLineEditData->textHandle,             // widget
       lInsertionPoint,      // character to insert after
       (char *)pszBuffer);   // string, assumed to be already null-terminated
    ulBufferSize = strlen(pszBuffer);
    }
  else
    {
    IString str (pszBuffer, ulBufferSize);  //create substring
    str += '\0';         // insure it's null-terminated
    XmTextInsert(
       fMultiLineEditData->textHandle,         // widget
       lInsertionPoint,  // character to insert after
       str);             // sub-string
    }

  lInsertionPoint += (long) ulBufferSize;
  setCursorPosition(lInsertionPoint+1);  // Position cursor after newly inserted text
#endif // IC_MOTIF
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::importFromFile                                               |
|                                                                              |
| Insert the contents of the specified file into the MLE at the current cursor |
| position.                                                                    |
| Notes: Prior to importing a file to the MLE, the file must exist (in binary  |
|          format).                                                            |
------------------------------------------------------------------------------*/
unsigned long  IMultiLineEdit::importFromFile( const char* pszFileName,
                                               EOLFormat   type )
{
#ifdef IC_PMWIN
  FILE*          filePtr;

  /***********************************************************************/
  /* Open the specified file.                                            */
  /***********************************************************************/
  if ((filePtr = fopen(pszFileName, "rb")) == (FILE *)0)
  {
     ITHROWCLIBERROR( "fopen",
                      IBaseErrorInfo::accessError,
                      IException::recoverable );
  }

  struct stat buf;
  if (stat(pszFileName,&buf))
  {  // We can't malloc if we don't know the size.
     ITHROWCLIBERROR( "stat",
                      IBaseErrorInfo::accessError,
                      IException::recoverable );
  }
  IString data(0,(unsigned int)(buf.st_size+1)*2);  // could become twice as big

  /***********************************************************************/
  /* Read a line from the file till the end of file                      */
  /***********************************************************************/
  bool bOldRefresh=bRefresh;
  unsigned long style = this->style();

  if ( bRefresh && (style & WS_VISIBLE) )
    disableUpdate();

  unsigned long cursor = 0;
  char* alias = (char*)data;
  char current;

  // defect: 29763
  // fix the import code to allow dbcs chars through the logic
  while( fread( &current, 1,1, filePtr ) == 1 )
  {
    if( IDBCSChecker::isDBCSLeader( current ) == true )
    {
        // current char is dbcs, let next one through with no checking
        alias[cursor] = current;
        cursor++;
        if( fread( &current, 1,1, filePtr ) == 1 )
        {
            alias[cursor] = current;
            cursor++;
            continue;       // get next character
        }
        else
            // fread failed, thus we leave read loop
            break;
    }

    if( current == '\n' )
    {
      if( cursor > 0 && alias[cursor-1] != '\r' )
      {
        alias[cursor] = '\r';
        cursor++;
        alias[cursor] = '\n';
      }
      else
      {
        alias[cursor] = current;
      }
      cursor++;
    }
    else
    {
      alias[cursor] = current;
      cursor++;
    }
  }

  add(data.subString( 0, cursor ),cursor,type);

  if (bOldRefresh && (style & WS_VISIBLE) )
    enableUpdate();

  fclose(filePtr);

  setCursorPosition( 0 );
  return cursor;
#endif // IC_PMWIN
#ifdef IC_MOTIF
  /***********************************************************************/
  /* Open the specified file.                                            */
  /***********************************************************************/
  IMLEOpenFile inFile( fopen(pszFileName, "rb") );

  unsigned long     ulNumChars = 0;
  char     *line    = new char [MLEIOBUFFERSIZE + 1];

  /***********************************************************************/
  /* Read a line from the file till the end of file                      */
  /***********************************************************************/

  while (!feof( (FILE *)inFile ))
     {
     int numRead = fread( line, sizeof(char), MLEIOBUFFERSIZE, inFile );
     if (numRead)
        {
        line[numRead] = '\0';
        add( line );         // note, use default of 0 for \0 terminated char*
        ulNumChars += numRead;
        }
     else
        {
        if ( ferror( (FILE *)inFile ) )
           {
           ITHROWCLIBERROR("fread",
                            IBaseErrorInfo::accessError,
                            IException::recoverable);
           }
        }  // else
     } // while

  delete [] line;

  //scroll to top of file
  XmTextSetInsertionPosition(fMultiLineEditData->textHandle, 0);

  return ulNumChars;
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::exportToFile                                                 |
|                                                                              |
| Save the contents of the MLE to the specified file.                          |
------------------------------------------------------------------------------*/
unsigned long  IMultiLineEdit::exportToFile( const char* pszFileName,
                                             EOLFormat   type )
{
#ifdef IC_PMWIN
  if (textLengthAfterFormat())
  {
#ifdef IC_WIN
    handle().sendEvent( EM_FMTLINES,
                        IEventParameter1(type == MLEFormat),
                        IEventParameter2(0));
#endif // IC_WIN
#ifdef IC_PM
    switch (type)
    {
      case cfText:
        handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_CFTEXT),
                                       IEventParameter2(0));
        break;
      case noTran:
        handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_NOTRANS),
                                       IEventParameter2(0));
        break;
      case MLEFormat:
        handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_WINFMT),
                                       IEventParameter2(0));
        break;
    } /* endswitch */
#endif //IC_PM

    return exportFile(pszFileName, FALSE);

  }
  else
  {

    return 0;

  } /* endif */
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if (textLengthAfterFormat())
     return exportFile(pszFileName, FALSE);
  else
     return 0;
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::exportSelectedTextToFile                                     |
|                                                                              |
| Export the marked area of MLE to a file.                                     |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::exportSelectedTextToFile ( const char* fileName,
                                                         EOLFormat   type)
{
  IASSERTSTATE(hasSelectedText());
#ifdef IC_PM
  switch (type)
  {
    case cfText:
         handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_CFTEXT),
                                        IEventParameter2(0));
         break;
    case noTran:
         handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_NOTRANS),
                                        IEventParameter2(0));
         break;
    case MLEFormat:
         handle().sendEvent(MLM_FORMAT, IEventParameter1(MLFIE_WINFMT),
                                        IEventParameter2(0));
         break;
  } /* endswitch */
#endif // IC_PM
  return exportFile(fileName, TRUE);
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::setLimit                                                     |
|                                                                              |
| Set the limit on the number of bytes that can be input into the MLE.         |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setLimit( unsigned long lNewLimit )
{
#ifdef IC_WIN
  if ( lNewLimit == 0 )
  {  // Maximum value.
     if ( IPlatform::isWin9x() )
     {
        IASSERTSTATE( this->text().length() <= USHRT_MAX );
     }
     else
     {
        IASSERTSTATE( this->text().length() <= ULONG_MAX );
     }
  }
  else
#endif
  IASSERTSTATE(text().length() <= lNewLimit);

#ifdef IC_PMWIN
  /********************************************************************/
  /* If the limit is already the value passed, don't do anything      */
  /********************************************************************/
  if (lNewLimit != this->limit())
  {
    /******************************************************************/
    /* Now set the new edit limit for the mle                         */
    /******************************************************************/
    IEventResult evt(handle().sendEvent(MLM_SETTEXTLIMIT,
                                        IEventParameter1(lNewLimit),
                                        IEventParameter2(0)));
#ifdef IC_PM
    // Check error code returned only on PM
    if (evt.asUnsignedLong())
    {
      ITHROWGUIERROR("MLM_SETTEXTLIMIT");
    }
#endif
  }
#endif // IC_PMWIN
#ifdef IC_MOTIF
  XmTextSetMaxLength( fMultiLineEditData->textHandle, lNewLimit);
  this->notifyObservers(INotificationEvent(
                        IMultiLineEdit::limitId, *this,
                        true, lNewLimit));
#endif // IC_MOTIF
  return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::limit                                                        |
|                                                                              |
| Returns the maximum number of bytes allowed that the MLE can hold.           |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::limit() const
{
#ifdef IC_PM
  IEventResult evt(handle().sendEvent(MLM_QUERYTEXTLIMIT,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));

  if (evt.asLong() < 0)
     return ULONG_MAX;
  else
     return evt.asUnsignedLong();
#endif // IC_PM
#ifdef IC_WIN
  IEventResult evt(handle().sendEvent(EM_GETLIMITTEXT,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));
  unsigned long
    maxBytes = evt.asUnsignedLong();
  if ( maxBytes == 0 )
  {
     maxBytes = IPlatform::isWin9x() ? USHRT_MAX : ULONG_MAX;
  }
  return maxBytes;
#endif // IC_WIN
#ifdef IC_MOTIF
  long tempvalue =
      (long)XmTextGetMaxLength( fMultiLineEditData->textHandle );
  if (tempvalue<0)
     return ULONG_MAX;
  else
     return (unsigned long)tempvalue;
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::selectRange                                                  |
|                                                                              |
| Specifies a range of characters.                                             |
| Notes: If upper range is not specified, default is last character in the MLE.|
------------------------------------------------------------------------------*/
IMultiLineEdit&  IMultiLineEdit::selectRange( const IRange& range,
                                              unsigned long timestamp )
{
#ifdef IC_PMWIN
   long start(range.lowerBound());
   long stop(range.upperBound());

   /*******************************************************************/
   /* If first parameter is deselect, then set up parameters to do so */
   /*******************************************************************/
   if (start == deselect)
   {
#ifdef IC_WIN
     stop = 0;
#endif
#ifdef IC_PM
     start = cursorPosition();
     stop = start;
#endif
   }
   /*******************************************************************/
   /* otherwise we are selecting, so validate parameters passed       */
   /*******************************************************************/
   else
   {
     if (start == end)
        start = textLength()+1;

     if (stop == end)
        stop = textLength()+1;

     if ( stop  < 0)
        stop  = 0;

     if ( start < 0)
        start = 0;

     if (start > stop )
        start++;   //Need to move cursor past character so we can select it
     else
        stop++;    //Need to move cursor past character so we can select it
   }

   handle().sendEvent(MLM_SETSEL, IEventParameter1((unsigned long)start),
                                  IEventParameter2((unsigned long)stop));
#endif // IC_PMWIN
#ifdef IC_MOTIF
   long start = range.lowerBound();
   long stop = range.upperBound();
   unsigned long lastChar = textLength()-1;

   if (start == end)
      start = lastChar;

   if (stop == end)
      stop = lastChar;

   if ( stop  < 0)       // no negative values allowed
      stop  = 0;

   if ( start < 0)
      start = 0;

   if (start > stop )       //insure they're in the right order
   {
     long temp = start;
     start = stop;
     stop = temp;
   }

   if (stop > lastChar)         //XmTextSetSel ignored if stop > lastChar
     stop = lastChar;

   stop++;    // Need to move cursor past character so we can select it
              // In IMLE, you never set a "null" selection with this method
              // (e.g., just to set cursor pos), as you might in native Motif.

   XmTextSetSelection(
      fMultiLineEditData->textHandle,            // aWidget
      start,               // first char (0 based)
      stop,                // last char
      timestamp);          // timestamp
#endif // IC_MOTIF
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::selectedRange                                                |
|                                                                              |
| Gets the bound of the marked or selected text.  Index of marked characters   |
| is returned as 0-based.                                                      |
------------------------------------------------------------------------------*/
IRange  IMultiLineEdit::selectedRange() const
{
  IASSERTSTATE(hasSelectedText());
  IRange rangMarked;

#ifdef IC_PMWIN
#ifdef IC_WIN
  IEventResult minSel, maxSel;
  handle().sendEvent(EM_GETSEL,
                     IEventParameter1(&minSel),
                     IEventParameter2(&maxSel));
#endif
#ifdef IC_PM
  IEventResult minSel( handle().sendEvent(MLM_QUERYSEL,
                                          IEventParameter1(MLFQS_MINSEL),
                                          IEventParameter2(0)));
  IEventResult maxSel( handle().sendEvent(MLM_QUERYSEL,
                                          IEventParameter1(MLFQS_MAXSEL),
                                          IEventParameter2(0)));
#endif
  rangMarked = IRange(minSel.asUnsignedLong(), maxSel.asUnsignedLong());
  if (rangMarked.lowerBound() != rangMarked.upperBound())
     rangMarked.setUpperBound(rangMarked.upperBound() - 1);
                                  // Make upper the last selected character
#endif // IC_PMWIN
#ifdef IC_MOTIF
   XmTextPosition
      left, right;
   if (!XmTextGetSelectionPosition(
          fMultiLineEditData->textHandle,            // widget
          &left,               // left selected pos (0 based)
          &right))             // right selected pos (0 based)
      {
      XmTextPosition pos = XmTextGetInsertionPosition( fMultiLineEditData->textHandle );
      return IRange(pos,pos);
      }     // this widget doesn't own selection, so return
            // current cursor pos as a range
   else
     if (left == right )
       {
       XmTextPosition pos = XmTextGetInsertionPosition( fMultiLineEditData->textHandle );
       return IRange(pos,pos);     // return current cursor position, as a range
       }
     else
       // Decrement right position by 1, so we're point to last selected
       // character and not the one after it (as native Motif does).
       return IRange(left, right-1);
#endif // IC_MOTIF
  return rangMarked;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::selectedText                                                 |
|                                                                              |
| Gets the marked (selected) text.                                             |
------------------------------------------------------------------------------*/
IString IMultiLineEdit::selectedText() const
{
  unsigned long length = selectedTextLength();
  IString str("\0");
  if ( length)
  {
#ifdef IC_PM
    char  *pchMarkedText;           // Source text

    pchMarkedText = (char *)str;
    handle().sendEvent( MLM_QUERYSELTEXT,
                        IEventParameter1((unsigned long) pchMarkedText),
                        IEventParameter2(0) );
#endif // IC_PM
#ifdef IC_WIN
    /******************************************************************/
    /* No easy way to only get the selected text.                     */
    /* Must first get all text and build substring of it              */
    /******************************************************************/
    IRange rangeMarked = selectedRange();
    str = IString( (char*)text() + rangeMarked.lowerBound(),
                   (unsigned int)length, '\0' );
#endif // IC_WIN
#ifdef IC_MOTIF
    char *pchMarkedText = XmTextGetSelection( fMultiLineEditData->textHandle );   //a NULL-term'd string
    if (pchMarkedText)
      str = pchMarkedText;
    XtFree(pchMarkedText);
#endif // IC_MOTIF
  } /* endif */
  return str;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::hasSelectedText                                              |
|                                                                              |
| Query whether any text is currently marked.                                  |
------------------------------------------------------------------------------*/
bool IMultiLineEdit::hasSelectedText() const
{
#ifdef IC_PMWIN
  if (selectedTextLength() == 0)
    return( false );
  else
    return( true );
#endif // IC_PMWIN
#ifdef IC_MOTIF
  XmTextPosition
     left, right;
  if (!XmTextGetSelectionPosition(
         fMultiLineEditData->textHandle,            // widget
         &left,               // left selected pos (0 based)
         &right))             // right selected pos (0 based)
    return false;      // this widget doesn't own selection
  else
  {
    if (left == right )
      return false;    // widget owns selection, but no text currently selected
    else
      return true;
  }
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::isUndoable                                                   |
|                                                                              |
| Queries whether any undoable actions have been performed on the contents of  |
| the MLE.                                                                     |
------------------------------------------------------------------------------*/
bool IMultiLineEdit::isUndoable() const
{
  ITRACE_MOTIF_NOP();

#ifdef IC_PMWIN
  IEventResult evt(handle().sendEvent(MLM_QUERYUNDO,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));
  if (evt.asUnsignedLong())
     return true;
#endif // IC_PMWIN
  return false;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::cut                                                          |
|                                                                              |
| Copy any marked text to the clipboard, and then delete the marked text from  |
| the MLE.                                                                     |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::cut(unsigned long timestamp)
{
  IASSERTSTATE(hasSelectedText());
#ifdef IC_PMWIN
  IEventResult evt(handle().sendEvent(MLM_CUT,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));
#ifdef IC_PM
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("MLM_CUT");
#endif // IC_PM
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if ( !XmTextCut( fMultiLineEditData->textHandle, timestamp) )
    ITHROWLIBRARYERROR1( IC_NOMARKEDTEXT,         //or maybe more unusual error
                         IBaseErrorInfo::accessError,
                         IException::recoverable,
                         "XmTextCut");
#endif // IC_MOTIF
  return *this;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::copy                                                         |
|                                                                              |
| Copy any marked text to the clipboard.                                       |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::copy(unsigned long timestamp)
{
  IASSERTSTATE(hasSelectedText());

#ifdef IC_PMWIN
  IEventResult evt(handle().sendEvent(MLM_COPY,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));
#ifdef IC_PM
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("MLM_COPY");
#endif // IC_PM
#endif // IC_PMWIN
#ifdef IC_MOTIF
   if ( !XmTextCopy( fMultiLineEditData->textHandle, timestamp) )
     ITHROWLIBRARYERROR1( IC_NOMARKEDTEXT,         //or maybe more unusual error
                          IBaseErrorInfo::accessError,
                          IException::recoverable,
                          "XmTextCopy");
#endif // IC_MOTIF
  return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::paste                                                        |
|                                                                              |
| Paste text from the clipboard into the MLE at the current cursor position    |
| in the text.                                                                 |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::paste()
{
  IASSERTSTATE(clipboardHasTextFormat());
#ifdef IC_PMWIN
  IEventResult evt(handle().sendEvent(MLM_PASTE,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));
#ifdef IC_PM
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("MLM_PASTE");
#endif // IC_PM
#endif // IC_PMWIN
#ifdef IC_MOTIF
   if ( !XmTextPaste( fMultiLineEditData->textHandle ) )
     ITHROWLIBRARYERROR1( IC_NOMARKEDTEXT,         //or maybe more unusual error
                          IBaseErrorInfo::accessError,
                          IException::recoverable,
                          "XmTextPaste");
#endif // IC_MOTIF
  return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::clear                                                        |
|                                                                              |
| Replace the marked area with blanks.                                         |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::clear(unsigned long timestamp)
{
#ifdef IC_PMWIN
  char    *pchMarkedText,              // Source text
          *pchText;
  ULONG    num_char, i;                // char and loop count

  // Return if no marked area
  if ( !hasSelectedText() )
     return *this;

  IString str(selectedText());
  pchMarkedText = (char *)str;
  pchText = (char *) text();

  /***********************************************************************/
  /* Get the size of user marked area.                                   */
  /***********************************************************************/
  num_char = selectedTextLength();

  /******************************************************************/
  /* Replace the text with blanks, leaving CR and LF chars intact.  */
  /******************************************************************/
  for (i = 0; i < num_char; i++)
      if (*(pchMarkedText + i) != 0x0D && *(pchMarkedText +i) != 0x0A)
         *(pchMarkedText + i) = ' ';

  /******************************************************************/
  /* Replace the marked area with the blanked out text.             */
  /******************************************************************/
#ifdef IC_WIN
  handle().sendEvent( EM_REPLACESEL,
                      IEventParameter1(1),  // set undo flag to true
                      IEventParameter2((unsigned long)pchMarkedText));
  pchText = (char *) text();
#else
  bool bOldRefresh=bRefresh;
  unsigned long style = this->style();

  if ( bRefresh && (style & WS_VISIBLE) )
     disableUpdate();

  handle().sendEvent( MLM_INSERT,
                      IEventParameter1((unsigned long)pchMarkedText),
                      IEventParameter2(0));

  if (bOldRefresh && (style & WS_VISIBLE) )
     enableUpdate();
#endif
#endif // IC_PMWIN
#ifdef IC_MOTIF
  //  XmTextClearSelection doesn't work. Do it ourselves...
   if (hasSelectedText())
   {
     IRange selected = selectedRange();
     unsigned long length = selected.upperBound() - selected.lowerBound() + 1;
     IString blanks (0, length);     // a blank string of length "length"
     // replace the current selection with a string of blanks of equal length
     XmTextReplace(
        fMultiLineEditData->textHandle,                   // widget
        selected.lowerBound(),      // start pos
        selected.upperBound() + 1,  // char after end of those we want to replace
        blanks);                    // replacement string (blanks)
   }
#endif // IC_MOTIF
  return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::discard                                                      |
|                                                                              |
| Erase the marked text.                                                       |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::discard()
{
  IASSERTSTATE(hasSelectedText());
#ifdef IC_PMWIN
  IEventResult evt(handle().sendEvent(MLM_CLEAR,
                                      IEventParameter1(0),
                                      IEventParameter2(0)));
#ifdef IC_PM
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("MLM_CLEAR");
#endif
#endif // IC_PMWIN
#ifdef IC_MOTIF
   if ( !XmTextRemove( fMultiLineEditData->textHandle ) )
      ITHROWLIBRARYERROR1( IC_NOMARKEDTEXT,         //or maybe more unusual error
                           IBaseErrorInfo::accessError,
                           IException::recoverable,
                           "XmTextRemove");
#endif // IC_MOTIF

  return *this;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::undo                                                         |
|                                                                              |
| Restores the MLE contents to the state they were in before the last change.  |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::undo()
{
   ITRACE_MOTIF_NOP();

#ifdef IC_PMWIN
   /********************************************************************/
   /* Request system to undo the last operation, if there was one.     */
   /********************************************************************/
   IEventResult evt(handle().sendEvent(MLM_UNDO,
                                       IEventParameter1(0),
                                       IEventParameter2(0)));

#ifndef IC_WIN
   if (!(evt.asUnsignedLong()))
      /*****************************************************************/
      /* Undo failed, so lets reset the MLE undo flag.                 */
      /*****************************************************************/
      handle().sendEvent(MLM_RESETUNDO, IEventParameter1(0),
                                        IEventParameter2(0));
#endif
#endif // IC_PMWIN
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::removeAll                                                    |
|                                                                              |
| Deletes the entire contents of the MLE.                                      |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::removeAll()
{
#ifdef IC_MOTIFWIN
   // No delete all function in Windows so just set contents to NULL string
   setText((char*)IString(),0);
#endif // IC_MOTIFWIN
#ifdef IC_PM
   bool bOldRefresh(bRefresh);
   unsigned long style = this->style();

   if ( bRefresh && (style & WS_VISIBLE) )
      disableUpdate();

   handle().sendEvent(MLM_DELETE, IEventParameter1(0),
                                  IEventParameter2(textLengthAfterFormat()));

   if (bOldRefresh && (style & WS_VISIBLE) )
      enableUpdate(bOldRefresh);
#endif // IC_PM
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setEditRegionWidth                                           |
|                                                                              |
| Set the width (in pixels) of the MLE text region.  The edit region defines   |
| the area in which text will be visible.  It can be less than the actual      |
| MLE window size.                                                             |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setEditRegionWidth(long sWidth)
{
#ifdef IC_WIN
   RECT mleRect;

   handle().sendEvent( EM_GETRECT,
                       IEventParameter1(0),
                       IEventParameter2((unsigned long)&mleRect) );
   // Based on ref text, adjust returned rect by border size for set to work
   // correctly.
   if ((style() & border.asUnsignedLong()) ||
       (extendedStyle() & IMLS_BORDERNTHACK))
   {
      mleRect.left -= IQUERYSYSVALUE(SV_CXBORDER);
      mleRect.top -= IQUERYSYSVALUE(SV_CYBORDER);
      mleRect.right = mleRect.left + sWidth;
      mleRect.bottom += IQUERYSYSVALUE(SV_CYBORDER);
   }
   else
      mleRect.right = mleRect.left + sWidth;

   // Note no exception thrown since message does not return value
   IEventResult evt( handle().sendEvent(EM_SETRECT,
                       IEventParameter1(0),
                       IEventParameter2((unsigned long)&mleRect)));
#endif // IC_WIN
#ifdef IC_PM
   MLEFORMATRECT mleformrc;
   mleformrc.cxFormat = sWidth;
   bool bOldRefresh=bRefresh;
   unsigned long style = this->style();

   if ( bRefresh && (style & WS_VISIBLE) )
      disableUpdate();

   IEventResult evt(
           handle().sendEvent(MLM_SETFORMATRECT,
                              IEventParameter1((unsigned long)(&mleformrc)),
                              IEventParameter2((unsigned long)
                                                        MLFFMTRECT_LIMITHORZ)));
   if (bOldRefresh && (style & WS_VISIBLE) )
      enableUpdate();
   if (!(evt.asUnsignedLong()))
      ITHROWLIBRARYERROR(IC_INVALIDSIZE,IBaseErrorInfo::invalidParameter,
                         IException::recoverable);
#endif // IC_PM
#ifdef IC_MOTIF
  // In Motif, this is the area within the XmNmarginWidth margins.
  // Thus, edit region is set by adjusting the margin.
  Dimension newMargin, currentWidth;
  short rows;
  XtVaGetValues( fMultiLineEditData->textHandle, XmNwidth, &currentWidth,
                 XmNrows, &rows,
                 NULL);
  if (currentWidth < sWidth)
    sWidth = currentWidth;     // in Motif, can't go larger than window width
                               // (don't throw exception, this works in PM)
  newMargin = (Dimension) ((currentWidth - sWidth) / 2);
  // set marginWidth (also reset rows, as margin change trys to set it to 1)
  XtVaSetValues( fMultiLineEditData->textHandle, XmNmarginWidth, newMargin,
                 XmNrows, rows,
                 NULL);
  // reset width to keep it the same (margin tries to expand it)
  XtVaSetValues( fMultiLineEditData->textHandle,
                 XmNwidth, currentWidth,
                 NULL);
  // It's not an error in Motif if the window is too small to show all the
  // text (even it it's not a scrollable IMLE), so we don't throw an exception.
#endif // IC_MOTIF
  return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setEditRegionHeight                                          |
|                                                                              |
| Set the height of the text region inside of the MLE control.                 |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setEditRegionHeight(long sHeight)
{
#ifdef IC_WIN
   RECT mleRect;

   handle().sendEvent( EM_GETRECT,
                       IEventParameter1(0),
                       IEventParameter2((unsigned long)&mleRect) );
   // Based on ref text, adjust returned rect by border size for set to work
   // correctly.
   if ((style() & border.asUnsignedLong()) ||
       (extendedStyle() & IMLS_BORDERNTHACK))
   {
      mleRect.left -= IQUERYSYSVALUE(SV_CXBORDER);
      mleRect.top -= IQUERYSYSVALUE(SV_CYBORDER);
      mleRect.right += IQUERYSYSVALUE(SV_CXBORDER);
      mleRect.bottom = mleRect.top + sHeight;
   }
   else
      mleRect.bottom = mleRect.top + sHeight;

   // Note no exception thrown since message does not return value
   IEventResult evt( handle().sendEvent(EM_SETRECT,
                       IEventParameter1(0),
                       IEventParameter2((unsigned long)&mleRect)));
#endif // IC_WIN
#ifdef IC_PM
   MLEFORMATRECT mleformrc;
   mleformrc.cyFormat = sHeight;
   bool bOldRefresh=bRefresh;
   unsigned long style = this->style();

   if ( bRefresh && (style & WS_VISIBLE) )
      disableUpdate();

   IEventResult evt(
           handle().sendEvent(MLM_SETFORMATRECT,
                              IEventParameter1((unsigned long)(&mleformrc)),
                              IEventParameter2((unsigned long)
                                                     MLFFMTRECT_LIMITVERT)));
   if (bOldRefresh && (style & WS_VISIBLE) )
      enableUpdate();
   if (!(evt.asUnsignedLong()))
      ITHROWLIBRARYERROR(IC_INVALIDSIZE,IBaseErrorInfo::invalidParameter,
                         IException::recoverable);
#endif // IC_PM
#ifdef IC_MOTIF
  // In Motif, this is the area within the XmNmarginHeight margins.
  // Thus, edit region is set by adjusting the margin.
  Dimension newMargin, currentHeight;
  short columns;
  XtVaGetValues( fMultiLineEditData->textHandle, XmNheight, &currentHeight,
                 XmNcolumns, &columns,
                 NULL);
  if (currentHeight < sHeight)
    sHeight = currentHeight;     // in Motif, can't go larger than window height
                                 // (don't throw exception, this works in PM)
  newMargin = (Dimension) ((currentHeight - sHeight) / 2);
  // set marginHeight (also reset columns, as margin change screws it up)
  XtVaSetValues(fMultiLineEditData->textHandle, XmNmarginHeight, newMargin,
                XmNcolumns, columns,
                NULL);
  // reset height to keep it the same (margin tries to expand it)
  XtVaSetValues(fMultiLineEditData->textHandle,
                XmNheight, currentHeight,
                NULL);
  // It's not an error in Motif if the window is too small to show all the
  // text (even it it's not a scrollable IMLE), so we don't throw an exception.
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setEditRegion                                                |
|                                                                              |
| Set the width and the height of the text region inside of the MLE control.   |
| Method returns TRUE if the text fits within new format-rectangle dimension.  |
| Otherwise, it returns FALSE, indicating that the format rectangle was not    |
| set.                                                                         |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setEditRegion( const ISize& sizeNew )
{
#ifdef IC_WIN
   RECT mleRect;
   GetClientRect ( handle(), &mleRect );

   mleRect.right = mleRect.left + (long)sizeNew.width();
   mleRect.bottom = mleRect.top + (long)sizeNew.height();

   // Note no exception thrown since message does not return value
   IEventResult evt( handle().sendEvent(EM_SETRECT,
                       IEventParameter1(0),
                       IEventParameter2((unsigned long)&mleRect)));
#endif // IC_WIN
#ifdef IC_PM
   MLEFORMATRECT mleformrc;
   mleformrc.cxFormat = (long)sizeNew.width();
   mleformrc.cyFormat = (long)sizeNew.height();
   bool bOldRefresh=bRefresh;
   unsigned long style = this->style();

   if ( bRefresh && (style & WS_VISIBLE) )
      disableUpdate();

   IEventResult evt(
           handle().sendEvent(MLM_SETFORMATRECT,
                              IEventParameter1((unsigned long)(&mleformrc)),
                              IEventParameter2((unsigned long)
                                                  (MLFFMTRECT_LIMITVERT |
                                                   MLFFMTRECT_LIMITHORZ))));
   if (bOldRefresh && (style & WS_VISIBLE) )
      enableUpdate();

   if (!(evt.asUnsignedLong()))
      ITHROWLIBRARYERROR(IC_INVALIDSIZE,IBaseErrorInfo::invalidParameter,
                         IException::recoverable);
#endif // IC_PM
#ifdef IC_MOTIF
  long sWidth = (long)sizeNew.width();
  long sHeight = (long)sizeNew.height();
  setEditRegionWidth(sWidth);
  setEditRegionHeight(sHeight);
  // It's not an error in Motif if the window is too small to show all the
  // text (even it it's not a scrollable IMLE), so we don't throw an exception.
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setEditRegion                                                |
|                                                                              |
| Set the edit region to be the size of the entire MLE window (minus margins). |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setEditRegion()
{
#ifdef IC_WIN
   RECT mleRect;
   GetClientRect ( handle(), &mleRect );

   // Note no exception thrown since message does not return value
   IEventResult evt( handle().sendEvent(EM_SETRECT,
                     IEventParameter1(0),
                     IEventParameter2((unsigned long)&mleRect)));

#endif // IC_WIN
#ifdef IC_PM
   MLEFORMATRECT mleformrcNew;
   bool bOldRefresh=bRefresh;
   unsigned long style = this->style();

   if ( bRefresh && (style & WS_VISIBLE) )
      disableUpdate();
   IEventResult evt(
           handle().sendEvent(MLM_SETFORMATRECT,
                              IEventParameter1((unsigned long)(&mleformrcNew)),
                              IEventParameter2((unsigned long)
                                                      MLFFMTRECT_MATCHWINDOW)));
   if (bOldRefresh && (style & WS_VISIBLE) )
      enableUpdate();

   if (!(evt.asUnsignedLong()))
      ITHROWLIBRARYERROR(IC_INVALIDSIZE,IBaseErrorInfo::accessError,
                         IException::recoverable);
#endif // IC_PM
#ifdef IC_MOTIF
      Dimension currentWidth, currentHeight;
      short rows, columns;
      XtVaGetValues( fMultiLineEditData->textHandle, XmNheight, &currentHeight,
                     XmNwidth, &currentWidth,
                     XmNrows, &rows,
                     XmNcolumns, &columns,
                     NULL);
      // The Motif default margin is 5, so best meaning of "entire" is margin of 5
      // Reset rows & columns due to widget bug (tries to change rows to 1).
      XtVaSetValues(fMultiLineEditData->textHandle, XmNmarginHeight, 5,
                              XmNmarginWidth,  5,
                              XmNrows, rows,
                              XmNcolumns, columns,
                              NULL);
      // reset width and height to keep it the same (margin tries to expand it)
      XtVaSetValues(fMultiLineEditData->textHandle,
                     XmNwidth, currentWidth,
                     XmNheight, currentHeight,
                     NULL);
      // It's not an error in Motif if the window is too small to show all the
      // text (even it it's not a scrollable IMLE), so we don't throw an exception.
#endif // IC_MOTIF
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::editRegionWidth                                              |
|                                                                              |
| Returns the width of the MLE editing area.                                   |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::editRegionWidth() const
{
#ifdef IC_WIN
   RECT mleRect;

   handle().sendEvent( EM_GETRECT,
                       IEventParameter1(0),
                       IEventParameter2((unsigned long)&mleRect) );

   // Based on ref text, adjust returned rect by border size for set to work
   // correctly.
   if ((style() & border.asUnsignedLong()) ||
       (extendedStyle() & IMLS_BORDERNTHACK))
   {
      mleRect.left -= IQUERYSYSVALUE(SV_CXBORDER);
      mleRect.right += IQUERYSYSVALUE(SV_CXBORDER);
   }
   return (mleRect.right - mleRect.left);
#endif // IC_WIN
#ifdef IC_PM
   MLEFORMATRECT mleformrc;
   unsigned long         ulFormatFlag =  MLFFMTRECT_LIMITHORZ;

   /***********************************************************************/
   /* Get the extent of the edit area.                                    */
   /***********************************************************************/
   handle().sendEvent(MLM_QUERYFORMATRECT,
                      IEventParameter1((unsigned long)(&mleformrc)),
                      IEventParameter2((unsigned long)(&ulFormatFlag)));

   return (mleformrc.cxFormat);
#endif // IC_PM
#ifdef IC_MOTIF
   Dimension currentMargin, currentWidth;
   XtVaGetValues( fMultiLineEditData->textHandle, XmNmarginWidth, &currentMargin,
                            XmNwidth,       &currentWidth,  NULL);
   return ( (unsigned long) currentWidth - 2*currentMargin );
#endif
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::editRegionHeight                                             |
|                                                                              |
| Returns the height of the MLE editing area.                                  |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::editRegionHeight() const
{
#ifdef IC_WIN
   RECT mleRect;

   handle().sendEvent( EM_GETRECT,
                       IEventParameter1(0),
                       IEventParameter2((unsigned long)&mleRect) );

   // Based on ref text, adjust returned rect by border size for set to work
   // correctly.
   if ((style() & border.asUnsignedLong()) ||
       (extendedStyle() & IMLS_BORDERNTHACK))
   {
      mleRect.top -= IQUERYSYSVALUE(SV_CYBORDER);
      mleRect.bottom += IQUERYSYSVALUE(SV_CYBORDER);
   }
   return (mleRect.bottom - mleRect.top);
#endif // IC_WIN
#ifdef IC_PM
   MLEFORMATRECT mleformrc;
   unsigned long         ulFormatFlag =  MLFFMTRECT_LIMITVERT;

   /***********************************************************************/
   /* Get the extent of the edit area.                                    */
   /***********************************************************************/
   handle().sendEvent(MLM_QUERYFORMATRECT,
                      IEventParameter1((unsigned long)(&mleformrc)),
                      IEventParameter2((unsigned long)(&ulFormatFlag)));
   return (mleformrc.cyFormat);
#endif // IC_PM
#ifdef IC_MOTIF
   Dimension currentMargin, currentHeight;
   XtVaGetValues( fMultiLineEditData->textHandle, XmNmarginHeight, &currentMargin,
                            XmNheight,       &currentHeight,  NULL);
   return ( (unsigned long) currentHeight - 2*currentMargin );
#endif
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setTab                                                       |
|                                                                              |
| Sets the interval at which tab stops are placed (expressed in pixels).       |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setTab(unsigned long lTabPixelInterval)
{

   ITRACE_MOTIF_NOP();

#ifdef IC_WIN
   // Get Dialog base units and mask in lower value (horizontal base units)
   LONG gdbu = GetDialogBaseUnits() & 0x0000FFFF;

   // Calculate dialog units based on pixel interval passed in
   unsigned long lTabDistance = (lTabPixelInterval * 4) / gdbu;
   IEventResult evt(
           handle().sendEvent(EM_SETTABSTOPS,
                              IEventParameter1(1),
                              IEventParameter2(&lTabDistance)));

   if (evt.asLong() == 0)
      ITHROWGUIERROR("MLM_SETTABSTOP");
#endif // IC_WIN
#ifdef IC_PM
   IEventResult evt(
           handle().sendEvent(MLM_SETTABSTOP,
                              IEventParameter1((unsigned long)
                                                       lTabPixelInterval),
                              IEventParameter2(0)));

   if (evt.asLong() < 0)
      ITHROWGUIERROR("MLM_SETTABSTOP");
#endif // IC_PM
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::isWordWrap                                                   |
------------------------------------------------------------------------------*/
bool IMultiLineEdit::isWordWrap() const
{
#ifdef IC_PM
   IEventResult evt(handle().sendEvent(MLM_QUERYWRAP,
                                       IEventParameter1(0),
                                       IEventParameter2(0)));
   if (evt.asUnsignedLong())
      return true;
   else
      return false;
#endif // IC_PM
#ifdef IC_WIN
  // Check word wrap from style bits (extended) since only set on create
  return ( extendedStyle() & wordWrap.asExtendedUnsignedLong() ) ?
            true : false;
#endif // IC_WIN
#ifdef IC_MOTIF
  bool  wWrap = 0;
  XtVaGetValues(
     (Widget) fMultiLineEditData->textHandle,
     XmNwordWrap, &wWrap,
     NULL);
  if (wWrap)
     return true;
  else
     return false;
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::enableWordWrap                                               |
|                                                                              |
| Puts the MLE in word-wrap mode, which means lines will not be scrolled       |
| right or left.                                                               |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::enableWordWrap( bool enable )
{
  ITRACE_WIN_NOP();

#ifdef IC_PM
  bool wordWrap(this->isWordWrap());

  /***************************/
  /* Only set if we need to. */
  /***************************/
  if ((enable && !wordWrap) || (!enable && wordWrap))
  {
    IEventResult evt(handle().sendEvent(MLM_SETWRAP,
                                        IEventParameter1(enable),
                                        IEventParameter2(0)));

    if (!(evt.asUnsignedLong()))
    {
      ITHROWGUIERROR("MLM_SETWRAP");
    }
  }
#endif
#ifdef IC_MOTIF
  XtVaSetValues(
     (Widget) fMultiLineEditData->textHandle,
     XmNwordWrap, enable ? True : False,
     NULL);
#endif // IC_MOTIF
  return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::disableWordWrap                                              |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::disableWordWrap()
{
  enableWordWrap(false);
  return *this;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IMultiLineEdit::foregroundColor                                              |
|                                                                              |
| Returns the foreground color of the IMultiLineEdit control.                  |
------------------------------------------------------------------------------*/
IColor IMultiLineEdit::foregroundColor() const
{
  IGUIColor guiColor(IGUIColor::windowText);

  if (!isWriteable())
  {
    guiColor = IGUIColor(IGUIColor::outputText);
  }
  return (IWindow::color(PP_FOREGROUNDCOLOR, guiColor));
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::backgroundColor                                              |
|                                                                              |
| Returns the background color of the IMultiLineEdit control.                  |
------------------------------------------------------------------------------*/
IColor IMultiLineEdit::backgroundColor() const
{
  return (IWindow::color(PP_BACKGROUNDCOLOR,
                         IGUIColor(IGUIColor::entryFieldBgnd)));
}
#endif // IC_PMWIN

#ifdef IC_PM
/*------------------------------------------------------------------------------
| IMultiLineEdit::setFont                                                      |
|                                                                              |
| Change the font used for this MLE object.                                    |
| Notes: The font point size set by this routine is the best fit size          |
|          determined by the system instead of the size specified by the user. |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setFont(const IFont& fntm)
{
   _FATTRS* pfat = (_FATTRS*)fntm.fattrs();

   if (pfat->fsSelection & FATTR_SEL_OUTLINE)
   {
      pfat->fsFontUse |=FATTR_FONTUSE_OUTLINE;
   } /* endif */

   if (fntm.isVectorOnly()) {
      pfat->fsFontUse |=FATTR_FONTUSE_TRANSFORMABLE;
      long  lxFontResolution, lyFontResolution;
      HDC   hDC;
      HPS hps = WinGetPS(handle());
      hDC = GpiQueryDevice(hps);
      DevQueryCaps( hDC, CAPS_HORIZONTAL_FONT_RES,
                    (long)1, &lxFontResolution);
      DevQueryCaps( hDC, CAPS_VERTICAL_FONT_RES,
                    (long)1, &lyFontResolution);
      pfat->lMaxBaselineExt = fntm.pointSize() * lyFontResolution / 72;
      pfat->lAveCharWidth   = fntm.pointSize() * lxFontResolution / 72;
      WinReleasePS(hps);
      }

   IEventResult evt(handle().sendEvent(MLM_SETFONT,
                                       IEventParameter1((unsigned long)pfat),
                                       IEventParameter2(0)));

   if (!(evt.asUnsignedLong()))
      ITHROWGUIERROR("MLM_SETFONT");
   return *this;
}
#endif

/*------------------------------------------------------------------------------
| IMultiLineEdit::numberOfLines                                                |
|                                                                              |
| Query the number of lines of text in the MLE.                                |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::numberOfLines() const
{
#ifdef IC_PMWIN
  unsigned long ulRetVal,ipt;

   /******************************************************************/
   /* Query number of lines in the MLE                               */
   /******************************************************************/
   ulRetVal = (unsigned long) handle().sendEvent( MLM_QUERYLINECOUNT,
                                                  IEventParameter1(0),
                                                  IEventParameter2(0));

   /******************************************************************/
   /* Get the position of the first character on the last line       */
   /******************************************************************/
   ipt = (unsigned long) handle().sendEvent( MLM_CHARFROMLINE,
                                             IEventParameter1(ulRetVal-1),
                                             IEventParameter2(0) );

   /******************************************************************/
   /* Check last line, if line length is 0, subtract one from count  */
   /******************************************************************/
   if ((unsigned long) handle().sendEvent(MLM_QUERYLINELENGTH,
                  IEventParameter1(ipt), IEventParameter2(0)) != 0)
     return ulRetVal;
   else
     return ulRetVal-1;
#endif //IC_PMWIN
#ifdef IC_MOTIF
   unsigned long length = textLength();
   if (length)
     return lineFromPosition(textLength()-1) + 1;  //line nums are 0-based, add 1
   else
     return 0;
#endif
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::addLineAsLast                                                |
|                                                                              |
| Insert the specified NULL-terminated text at the last line.                  |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::addLineAsLast( const char* pszLineText,
                                               EOLFormat   type )
{
#ifdef IC_PMWIN
   addLine(pszLineText,numberOfLines()+1,type);
#endif // IC_PMWIN
#ifdef IC_MOTIF
   unsigned long insertPos = textLength();
   char * pnewline = "\n";
   if (insertPos)
   {
     XmTextInsert(fMultiLineEditData->textHandle, insertPos, pnewline);
     insertPos++;
   }
   XmTextInsert(fMultiLineEditData->textHandle, insertPos, (char *)pszLineText);
#endif // IC_MOTIF
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::addLine                                                      |
|                                                                              |
| Insert the specified line of text at the line location specified.            |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::addLine( const char*   pszLineText,
                                         unsigned long lLineNumber,
                                         EOLFormat     type )
{
#ifdef IC_PMWIN
   long ipt;
   unsigned long  ulBuffSize;
   char * pszTempBuff;
   char pszEolChar[3];
   unsigned long ulFormat;
   bool bTextSel;
   IRange  selRange;

   strcpy( pszEolChar, "\r\n");
   switch (type)
   {
     case cfText:
        ulFormat = MLFIE_CFTEXT;
        break;
     case noTran:
        ulFormat = MLFIE_NOTRANS;
        strcpy( pszEolChar, "\n");
        break;
     case MLEFormat:
        ulFormat = MLFIE_WINFMT;
        break;
   } /* endswitch */

#ifdef IC_WIN
   handle().sendEvent( EM_FMTLINES,
                       IEventParameter1(ulFormat == MLFIE_WINFMT),
                       IEventParameter2(0));
#else
   handle().sendEvent( MLM_FORMAT,
                       IEventParameter1(ulFormat),
                       IEventParameter2(0));
#endif

   if (bTextSel = hasSelectedText())
     selRange = selectedRange();

   // If line number to add is before end of file, calculate insertion point
   if (lLineNumber < numberOfLines())
   {
      ipt = (long)((unsigned long) handle().sendEvent(MLM_CHARFROMLINE,
                              IEventParameter1(lLineNumber),
                              IEventParameter2(0)));
      ulBuffSize = strlen(pszLineText) + strlen(pszEolChar) + 1;
      pszTempBuff = new char[ulBuffSize];        // Allocate storage

      strcpy( pszTempBuff, pszLineText);
      strcat( pszTempBuff, pszEolChar);          // Add line terminator

#ifdef IC_WIN
      handle().sendEvent( EM_SETSEL,
                          IEventParameter1((unsigned long)ipt),
                          IEventParameter2((unsigned long)ipt) );
      handle().sendEvent( EM_REPLACESEL,
                          IEventParameter1(0),
                          IEventParameter2(pszTempBuff) );
#else
      importFromBuffer(&ipt,ulBuffSize,pszTempBuff);                   // Import text,

      handle().sendEvent( MLM_DELETE,
                          IEventParameter1((unsigned long)ipt-1),
                          IEventParameter2(1));
#endif
      if (bTextSel)
        selectRange( selRange );
      delete pszTempBuff;

   }
   // otherwise line is to be added at the end of the file
   else
   {
      ipt = textLength();
      if (ipt!=0)
      {
#ifdef IC_WIN
         handle().sendEvent( EM_SETSEL,
                             IEventParameter1((unsigned long)ipt),
                             IEventParameter2((unsigned long)ipt) );
         handle().sendEvent( EM_REPLACESEL,
                             IEventParameter1(0),
                             IEventParameter2((void *)pszEolChar) );
         ipt += 2;
#else
         importFromBuffer(&ipt, strlen(pszEolChar)+1, pszEolChar );    // Import an eol char
         handle().sendEvent(MLM_DELETE,
                                 IEventParameter1((unsigned long)ipt-1),
                                 IEventParameter2(1));
         ipt--;
#endif
      } /* endif */

#ifdef IC_WIN
      handle().sendEvent( EM_SETSEL,
                          IEventParameter1((unsigned long)ipt),
                          IEventParameter2((unsigned long)ipt) );
      handle().sendEvent( EM_REPLACESEL,
                          IEventParameter1(0),
                          IEventParameter2((char*)pszLineText) );

      if (bTextSel)
        selectRange( selRange );
      else
        // Position cursor after newly inserted text
        setCursorPosition( ipt + strlen(pszLineText) );
#endif //IC_WIN
#ifdef IC_PM
      importFromBuffer(&ipt,strlen(pszLineText),pszLineText);  // import text,
      if (bTextSel)
        selectRange( selRange );
      else
        // Position cursor after newly inserted text; ipt now is insertion
        // point + buffer size
        setCursorPosition( ipt );
#endif
   } /* endif */
#endif // IC_PMWIN
#ifdef IC_MOTIF
   long ipt;
   unsigned long  ulBuffSize;
   char * pszTempBuff;
   char pszEolChar[3] = "\n";
   bool bTextSel;
   IRange sele;

   if (bTextSel = hasSelectedText())
     sele=selectedRange();

   if (lLineNumber < numberOfLines())   // lLineNumber is within existing lines
   {
      ipt = positionFromLine( lLineNumber );
      ulBuffSize = strlen(pszLineText) + strlen(pszEolChar) + 1;
      pszTempBuff = new char[ulBuffSize];        // Allocate storage

      strcpy( pszTempBuff, pszLineText);
      strcat( pszTempBuff, pszEolChar);          // Add line terminator

      // place temporary buffer into control...
      XmTextInsert(
         fMultiLineEditData->textHandle,         // widget
         ipt,              // character to insert after
         pszTempBuff);     // string with newline
      if (bTextSel)
        selectRange(sele);
      delete pszTempBuff;     // get rid of temp buffer

   } else {                             // lLineNumber is outside existing range
      ipt = textLength();
      if (ipt!=0)
      {
         //Not empty.   import an eol character
         XmTextInsert(
            fMultiLineEditData->textHandle,         // widget
            ipt,              // character to insert after
            pszEolChar);      // string with newline
         ipt++;            // increment past the eol char
      } /* endif */
      XmTextInsert(
         fMultiLineEditData->textHandle,         // widget
         ipt,              // character to insert after
         (char *)pszLineText);     // string from user
      if (bTextSel)
        selectRange(sele);
   } /* endif */

#endif // IC_MOTIF
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::removeLine                                                   |
|                                                                              |
| Deletes the text on the specified line of the MLE.                           |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::removeLine( unsigned long lLineNumber )
{
#ifdef IC_PMWIN
   unsigned long ipt;

   if (lLineNumber <= numberOfLines())
      ipt = (unsigned long) handle().sendEvent(MLM_CHARFROMLINE,
                                 IEventParameter1(lLineNumber),
                                 IEventParameter2(0));
   else
      return *this;
#ifdef IC_WIN
   IRange  initMarked, newMarked;
   bool bMustRestore = false;

   /*******************************************************************/
   /* If selected text exists, save range away to restore later       */
   /*******************************************************************/
   if (hasSelectedText())
   {
     bMustRestore = true;
     initMarked = selectedRange();
     newMarked = initMarked;
   }

   /*******************************************************************/
   /* Get ending point of area to delete                              */
   /*******************************************************************/
   unsigned long ept = (unsigned long)handle().sendEvent(
                                 MLM_CHARFROMLINE,
                                 IEventParameter1(lLineNumber+1),
                                 IEventParameter2(0));

   /*******************************************************************/
   /* Disable refresh while modifications are made to avoid flashing  */
   /*******************************************************************/
   bool bOldRefresh=bRefresh;
   unsigned long style = this->style();

   if ( bRefresh && (style & WS_VISIBLE) )
      disableUpdate();

   /*******************************************************************/
   /* Modify selection to select the line indicated and delete it     */
   /*******************************************************************/
   handle().sendEvent( EM_SETSEL,
                       IEventParameter1(ipt),
                       IEventParameter2(ept) );
   handle().sendEvent( EM_REPLACESEL,
                       IEventParameter1(0),
                       IEventParameter2((char*)""));

   /*******************************************************************/
   /* Restore refresh (if required) after text inserted.  Must enable */
   /* window prior to selection or cursor update.                     */
   /*******************************************************************/
   if (bOldRefresh && (style & WS_VISIBLE) )
     enableUpdate();

   /*******************************************************************/
   /* If a range was selected before, then restore that range         */
   /*******************************************************************/
   if (bMustRestore)
   {
     /*****************************************************************/
     /* If deleted line is totally inside selected area, shrink range */
     /*****************************************************************/
     if ((initMarked.lowerBound() <= ipt) && (initMarked.upperBound() >= ept))
       newMarked.setUpperBound(initMarked.upperBound() - (ept-ipt));

     /*****************************************************************/
     /* If deleted line is all below selected area, move range down   */
     /*****************************************************************/
     else if (initMarked.lowerBound() >= ept)
       newMarked -= (ept-ipt);

     /*****************************************************************/
     /* If deleted line contains selection start, but not end, change */
     /*  start point to be just after line deleted                    */
     /*****************************************************************/
     else if ( (initMarked.lowerBound() > ipt) &&
               (initMarked.lowerBound() < ept) &&
               (initMarked.upperBound() >= ept) )
     {
       newMarked.setLowerBound(ipt);
       newMarked.setUpperBound(initMarked.upperBound() - (ept-ipt));
     }

     /*****************************************************************/
     /* If deleted line contains selection end, but not start, change */
     /*  end point to be just before line deleted                     */
     /*****************************************************************/
     else if ( (initMarked.lowerBound() < ipt) &&
               (initMarked.upperBound() >= ipt) &&
               (initMarked.upperBound() < ept) )
       newMarked.setUpperBound( ipt-1 );

     /*****************************************************************/
     /* Now, reselect the range, for any of the above conditions or if*/
     /*  range was totally below deletion.  Only if the range wasn't  */
     /*  totally contained in the deleted area should we not reselect */
     /*****************************************************************/
     if (!((initMarked.lowerBound() >= ipt) &&
           (initMarked.upperBound() <= ept)))
       selectRange( newMarked );
   }
#endif
#ifdef IC_PM
   unsigned long ulNumChars;
   ulNumChars = (unsigned long) handle().sendEvent(MLM_QUERYLINELENGTH,
                                  IEventParameter1(ipt),
                                  IEventParameter2(0));

   handle().sendEvent(MLM_DELETE, IEventParameter1(ipt),
                                  IEventParameter2(ulNumChars));
#endif
#endif // IC_PMWIN
#ifdef IC_MOTIF
   unsigned long ipt, iptNext;

   if (lLineNumber < numberOfLines())
      ipt = positionFromLine( lLineNumber);
   else
      return *this;
   if ((lLineNumber+1) < numberOfLines())
     iptNext = positionFromLine(lLineNumber+1);     // end pos + 1
   else
     iptNext = textLength();                        // end of text + 1

   // delete text by replacing the string with an empty string
   XmTextReplace(
      fMultiLineEditData->textHandle,         // widget
      ipt,              // start pos
      iptNext,          // char after end of those we want to remove
      "");              // replacement string
#endif // IC_MOTIF
   return *this;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::setTop                                                       |
|                                                                              |
| Make the specified line be the first visible line of the MLE on the screen.  |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setTop( unsigned long lLineNumber )
{

#ifdef IC_WIN
   unsigned long scrollAmount = lLineNumber - (top() + 1);

   handle().sendEvent( EM_LINESCROLL,
                       IEventParameter1(0),
                       IEventParameter2(scrollAmount) );
#endif // IC_WIN
#ifdef IC_PM
   IEventResult evt(handle().sendEvent(MLM_CHARFROMLINE,
                                       IEventParameter1(lLineNumber),
                                       IEventParameter2(0)));

   IEventResult evt2(handle().sendEvent(MLM_SETFIRSTCHAR,
                                        IEventParameter1(evt.asUnsignedLong()),
                                        IEventParameter2(0)));

   if (!(evt2.asUnsignedLong()))
      ITHROWGUIERROR("MLM_SETFIRSTCHAR");
#endif // IC_PM
#ifdef IC_MOTIF
  unsigned long ipt = 0;

  if ( (lLineNumber < numberOfLines()) && (lLineNumber != 1) )
    ipt = positionFromLine( lLineNumber );

  XmTextSetTopCharacter( fMultiLineEditData->textHandle, ipt);
#endif // IC_MOTIF

   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::top                                                          |
|                                                                              |
| Returns the line number of the line currently displayed as the first visible |
| line on the MLE.                                                             |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::top() const
{
#ifdef IC_WIN
   IEventResult evt2(handle().sendEvent(EM_GETFIRSTVISIBLELINE,
                                        IEventParameter1(0),
                                        IEventParameter2(0)));
   return evt2.asUnsignedLong();
#endif // IC_WIN
#ifdef IC_PM
   IEventResult evt(handle().sendEvent(MLM_QUERYFIRSTCHAR,
                                       IEventParameter1(0),
                                       IEventParameter2(0)));

   IEventResult evt2(handle().sendEvent(MLM_LINEFROMCHAR,
                                        IEventParameter1(evt.asUnsignedLong()),
                                        IEventParameter2(0)));
   return evt2.asUnsignedLong();
#endif // IC_PM
#ifdef IC_MOTIF
   unsigned long ipt = (unsigned long) XmTextGetTopCharacter(
                                          fMultiLineEditData->textHandle );
   return lineFromPosition( ipt );
#endif // IC_MOTIF
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::setCursorLinePosition                                        |
|                                                                              |
| Position the cursor on the line specified.                                   |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setCursorLinePosition(unsigned long lLineNumber)
{
#ifdef IC_PMWIN
   IEventResult evt(handle().sendEvent(MLM_CHARFROMLINE,
                                       IEventParameter1(lLineNumber),
                                       IEventParameter2(0)));

   handle().sendEvent(MLM_SETSEL, IEventParameter1(evt.asUnsignedLong()),
                                  IEventParameter2(evt.asUnsignedLong()));
#endif // IC_PMWIN
#ifdef IC_MOTIF
   if ( lLineNumber < numberOfLines() )
   {
     unsigned long ipt = positionFromLine( lLineNumber );
     setCursorPosition( ipt );
   }
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::cursorLinePosition                                           |
|                                                                              |
| Returns the line number where the cursor is currently positioned.            |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::cursorLinePosition() const
{
#ifdef IC_PMWIN
   IEventResult evt(handle().sendEvent( MLM_LINEFROMCHAR,
                                        IEventParameter1(cursorPosition()),
                                        IEventParameter2(0)));
   return evt.asUnsignedLong();
#endif // IC_PMWIN
#ifdef IC_MOTIF
   unsigned long ipt = XmTextGetInsertionPosition( (Widget) fMultiLineEditData->textHandle );
   unsigned long length = textLength();
   unsigned long pos = ipt==length ? ipt - 1 : ipt;
   return lineFromPosition( pos );
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::cursorPosition                                               |
|                                                                              |
| Returns the character position of where the cursor currently is.             |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::cursorPosition() const
{
#ifdef IC_WIN
   unsigned long endPos;
   IEventResult evt(handle().sendEvent(MLM_QUERYSEL,
                                       IEventParameter1(0),
                                       IEventParameter2(&endPos)));
   return endPos;
#endif // IC_WIN
#ifdef IC_PM
   IEventResult evt(handle().sendEvent(MLM_QUERYSEL,
                                       IEventParameter1(MLFQS_CURSORSEL),
                                       IEventParameter2(0)));
   return evt.asUnsignedLong();
#endif // IC_PM
#ifdef IC_MOTIF
  return ((unsigned long)XmTextGetInsertionPosition( (Widget) fMultiLineEditData->textHandle));
#endif
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::setCursorPosition                                            |
|                                                                              |
| Position the cursor in front of the character specified.                     |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::setCursorPosition( unsigned long lCursorChar )
{
#ifdef IC_PMWIN
   handle().sendEvent(MLM_SETSEL, IEventParameter1(lCursorChar),
                                  IEventParameter2(lCursorChar));
#ifdef IC_WIN
  //scroll cursor into view
   handle().sendEvent(EM_SCROLLCARET,
                      IEventParameter1(0),
                      IEventParameter2(0));
#endif //IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF
   XmTextSetInsertionPosition(fMultiLineEditData->textHandle, lCursorChar );
#endif //IC_MOTIF
   return *this;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::visibleLines                                                 |
|                                                                              |
| Returns the number of visible lines that will fit in the MLE using the       |
| current font.                                                                |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::visibleLines() const
{
#ifdef IC_PMWIN
   long lRetVal=0;

   /*******************************************************************/
   /* Get the font and then the maximum height of one character.      */
   /*******************************************************************/
#ifdef IC_PM
   FATTRS fattrs;

   /*******************************************************************/
   /* In OS/2, must use API to get font since MLE is different        */
   /*******************************************************************/
   handle().sendEvent(MLM_QUERYFONT,
                      IEventParameter1((unsigned long)(PFATTRS(&fattrs))),
                      IEventParameter2(0));

   long lCharHeight = fattrs.lMaxBaselineExt;
#endif
#ifdef IC_WIN
   long lCharHeight = font().maxCharHeight();
#endif
   /*******************************************************************/
   /* Get the MLEs visible edit region                                */
   /*******************************************************************/
   long lRegionHeight = editRegionHeight();

   /*******************************************************************/
   /* If either character height or region is 0, then no visible lines*/
   /*******************************************************************/
   if ((lRegionHeight==0) || (lCharHeight==0))
      return 0;

   /*******************************************************************/
   /* Otherwise number of lines is overall region divided by character*/
   /* height.  Calculate it and then return that value                */
   /*******************************************************************/
   lRetVal = ( lRegionHeight / lCharHeight );
   return lRetVal;
#endif // IC_PMWIN
#ifdef IC_MOTIF
   short sRows;
   XtVaGetValues(fMultiLineEditData->textHandle, XmNrows, &sRows, NULL);
   unsigned long lRows = sRows;
   return lRows;
#endif
}


/*------------------------------------------------------------------------------
| Private methods                                                              |
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
| IMultiLineEdit::exportFile                                                   |
|                                                                              |
| Exports either the entire file, or only the marked area, to a file.          |
------------------------------------------------------------------------------*/
long IMultiLineEdit::exportFile( const char* pszFileName,
                                 bool     flMarkedAreaOnly )
{
#ifdef IC_PMWIN
   unsigned long      ulBufSize;        // Buffer size
   long        iptOrigin;               // Origin of the MLE object
   FILE        *filePtr;                // File pointer of specified file
   unsigned long      ulNumChars;       // Number of chars exported by MLE
   int         numItems=1;

   /***********************************************************************/
   /* Open file in binary mode.  If file exists, erase its contents.  If  */
   /* file does not exist, create it for writing or reading.              */
   /* If file cannot be opened for writing (i.e. readonly) return 0 as    */
   /* number of bytes written                                             */
   /***********************************************************************/
   if ((filePtr = fopen(pszFileName, "wb")) == (FILE *)0)
     return 0;

   /***********************************************************************/
   /* Check if we need to export all text or only selected text           */
   /***********************************************************************/
   if (flMarkedAreaOnly == FALSE)
   {
     ulNumChars = ulBufSize  = textLengthAfterFormat();
     iptOrigin = 0;
   }
   /***********************************************************************/
   /* If selected, determine area the user has marked area for exporting. */
   /***********************************************************************/
   else
   {
     IRange rang = selectedRange();
     iptOrigin = rang.lowerBound();
     ulNumChars = ulBufSize = selectedTextLength();
   }

   /***********************************************************************/
   /* Allocate Maximum buffer for the import/export operation.            */
   /***********************************************************************/
   IString pchBuf(0,(unsigned int)ulBufSize+1);

#ifdef IC_PM
   /***********************************************************************/
   /* Export MLE to the specified buffer - it returns number of characters*/
   /* actually copied to the buffer including CR and LF.                  */
   /***********************************************************************/
   ulNumChars = exportToBuffer( &iptOrigin, ulBufSize, (char*)pchBuf );
#else  //IC_WIN
   if (flMarkedAreaOnly == FALSE)
     pchBuf = text();
   else
     pchBuf = selectedText();
   ulNumChars = pchBuf.length();
#endif  //IC_WIN

   /***********************************************************************/
   /* Write number of chars from the buffer to the specified file.        */
   /***********************************************************************/
   if (ulNumChars)
     numItems = fwrite((char*)pchBuf, ulNumChars, 1, filePtr);

   /***********************************************************************/
   /* Write out an end of file character and close the file               */
   /***********************************************************************/
   long endfile=26;
   fwrite((char*) &endfile,1,1,filePtr);
   fclose(filePtr);

   /***********************************************************************/
   /* If the original write failed, then return 0 as count written        */
   /***********************************************************************/
   if (numItems != 1)
     return 0;

   return ulNumChars;                  // return number of chars exported
#endif // IC_PMWIN
#ifdef IC_MOTIF
   char       *pchBuf = 0;             /* pointer to the allocated buffer */
   unsigned long  ulNumChars;          /* # of chars exported by MLE      */
   long        rc = 0;

   /***********************************************************************/
   /* open file in binary mode.  If file exists, erase its contents.  If  */
   /* file does not exist, create it for writing or reading.              */
   /***********************************************************************/
   FILE       *filePtr = fopen(pszFileName, "wb");
   if ( filePtr )
      {
      IMLEOpenFile outFile( filePtr );

      /********************************************************************/
      /* Determine area that the user has marked for exporting.           */
      /********************************************************************/
      if ( flMarkedAreaOnly )
         {
         pchBuf = XmTextGetSelection( fMultiLineEditData->textHandle );
         }
      else
         {
         pchBuf = XmTextGetString( fMultiLineEditData->textHandle );
         }
      ulNumChars =  (pchBuf == NULL) ? 0 : strlen(pchBuf);

      /********************************************************************/
      /* write number of chars from the buffer to the specified file.     */
      /********************************************************************/
      if (ulNumChars)
         {
         if (fwrite(pchBuf, ulNumChars, 1, outFile) != 1)
            {
            rc = -2;          // error writing
            }
         }  // > 0  chars
      }  // file opened
   else
      {
      // could not open file
      return -1;
      }

   if (pchBuf)
      {
      /************************************/
      /*Clean up memory                   */
      /************************************/
      XtFree(pchBuf);          // Free the buffer, but only AFTER file is closed
                               // (or flush the file buffers explicitly).
      }

   if (rc != 0)
      return rc;
   else
      return ulNumChars;               /* return number of chars exported */
#endif
}

#ifdef IC_PM
/*------------------------------------------------------------------------------
| IMultiLineEdit::exportToBuffer                                                       |
|                                                                              |
| Export the block of text from the insertion point passed into the specified  |
| buffer                                                                       |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::exportToBuffer( long*          ipt,
                                      unsigned long  length,
                                      const char*    buffer )
{
  char* exportBuffer;
  char* tempBuffer = (char*)buffer;
  unsigned long numberToExport, origExport, totalExported=0;

  /********************************************************************/
  /* Allocate the memory to be used to transfer from MLE to buffer    */
  /* MLE can only export in chunks of less than 64K                   */
  /********************************************************************/
  unsigned long
    allocRc = DosAllocMem( (PPVOID) &exportBuffer, 63005,
                           PAG_WRITE | PAG_COMMIT | OBJ_TILE );
  if ( allocRc )
  {
     ITHROWSYSTEMERROR( allocRc, "DosAllocMem",
                        IBaseErrorInfo::accessError,
                        IException::recoverable );
  }

  /********************************************************************/
  /* Point the export to our recently allocated block of temp storage */
  /********************************************************************/
  handle().sendEvent( MLM_SETIMPORTEXPORT,
                      IEventParameter1(exportBuffer),
                      IEventParameter2(63000));

  /********************************************************************/
  /* As long as there is text to export, do the following             */
  /********************************************************************/
  while (length != 0)
  {
    /******************************************************************/
    /* If remainder is less than largest buffer, use it as export size*/
    /******************************************************************/
    numberToExport = 63000;
    if ( length < 63000 )
      numberToExport = length;

    /******************************************************************/
    /* Save original export size since MLM_EXPORT modifies it and then*/
    /* export the text into the buffer                                */
    /******************************************************************/
    origExport = numberToExport;
    IEventResult evt = handle().sendEvent( MLM_EXPORT,
                                   IEventParameter1(ipt),
                                   IEventParameter2(&numberToExport));

    /******************************************************************/
    /* Now copy the data out of the temp buffer to the final buffer   */
    /******************************************************************/
    memcpy( tempBuffer, exportBuffer, origExport );

    /******************************************************************/
    /* Update external pointer to where to write next block of text   */
    /******************************************************************/
    tempBuffer += origExport;

    /******************************************************************/
    /* Modify counts of text left to export and total exported        */
    /******************************************************************/
    length -= origExport;
//  totalExported += evt.asUnsignedLong();  // Bug in PM causes the return
                                            // value to be one less than
                                            // actual number exported
    totalExported += origExport;            // so use original requested #
  } /* endwhile */
  /********************************************************************/
  /* Free the memory allocated above                                  */
  /********************************************************************/
  DosFreeMem( exportBuffer );

  /********************************************************************/
  /* Return count of text exported                                    */
  /********************************************************************/
  return totalExported;
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::importFromBuffer                                                       |
|                                                                              |
| Import the specified block of text from a buffer into an MLE at the          |
| desired insertion point.                                                     |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::importFromBuffer( long*         ipt,
                                      unsigned long length,
                                      const char*   buffer )
{
  char* importBuffer;
  char* tempBuffer = (char*)buffer;
  unsigned long numberToImport=63000, totalImported=0;

  /********************************************************************/
  /* Verify that we will not exceed the currently set limit on the    */
  /* MLE before trying to import text                                 */
  /********************************************************************/
  if (length+textLength() <= limit())
  {
     /*****************************************************************/
     /* Allocate the memory to be used to transfer from buffer to MLE */
     /* MLE can only import in chunks of less than 64K that are       */
     /* segment aligned                                               */
     /*****************************************************************/
     unsigned long
       allocRc = DosAllocMem( (PPVOID) &importBuffer, 63005,
                              PAG_WRITE | PAG_COMMIT | OBJ_TILE );
     if ( allocRc )
     {
        ITHROWSYSTEMERROR( allocRc, "DosAllocMem",
                           IBaseErrorInfo::accessError,
                           IException::recoverable );
     }

     /*****************************************************************/
     /* Set up the buffer to import from to the newly allocated one   */
     /*****************************************************************/
     handle().sendEvent( MLM_SETIMPORTEXPORT,
                         IEventParameter1(importBuffer),
                         IEventParameter2(63005));

     /*****************************************************************/
     /* As long as there is data to import, bring it in               */
     /*****************************************************************/
     while (length != 0)
     {
        /**************************************************************/
        /* If smaller than the buffer, change from max to smaller val */
        /**************************************************************/
        if ( length < 63000 )
          numberToImport = length;

        /**************************************************************/
        /* Copy from the external buffer to the segment aligned buffer*/
        /**************************************************************/
        memcpy(importBuffer,tempBuffer,numberToImport);

        /**************************************************************/
        /* Update the external pointer to the next block of text      */
        /**************************************************************/
        tempBuffer += numberToImport;

        /**************************************************************/
        /* Import the text from the segment aligned block to the MLE  */
        /**************************************************************/
        IEventResult evt = handle().sendEvent( MLM_IMPORT,
                                      IEventParameter1(ipt),
                                      IEventParameter2(numberToImport));

        /**************************************************************/
        /* Modify counts of text left to import and total imported    */
        /**************************************************************/
        length -= numberToImport;
        totalImported += evt.asUnsignedLong();
     }

     /*****************************************************************/
     /* Free the memory allocated above                               */
     /*****************************************************************/
     DosFreeMem( importBuffer );
  }
  /********************************************************************/
  /* If limit exceeded, than throw exception stating this             */
  /********************************************************************/
  else
  {
     ITHROWLIBRARYERROR( IC_INVALIDSIZE_LIMIT,
                         IBaseErrorInfo::invalidParameter,
                         IException::recoverable );
  } /* endif */
  /********************************************************************/
  /* Return count of text imported                                    */
  /********************************************************************/
  return totalImported;
}
#endif

/*------------------------------------------------------------------------------
| IMultiLineEdit::textLength                                                   |
|                                                                              |
| Returns the current length in bytes (containing CR/LF) of the MLE text.      |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::textLength() const
{
#ifdef IC_WIN
   return Inherited::textLength();
#endif // IC_WIN
#ifdef IC_PM
   IEventResult evt(handle().sendEvent(MLM_QUERYTEXTLENGTH,
                                       IEventParameter1(0),
                                       IEventParameter2(0)));
   return evt.asUnsignedLong();
#endif // IC_PM
#ifdef IC_MOTIF
   unsigned long  ulNumChars;
   char          *pszNewBuf = XmTextGetString( fMultiLineEditData->textHandle );
   ulNumChars =  (pszNewBuf == NULL) ? 0 : strlen(pszNewBuf);
   XtFree(pszNewBuf);
   return ulNumChars;
#endif
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::textLengthAfterFormat                                        |
|                                                                              |
| Returns current length in bytes (containing CR/LF) of the MLE text.          |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::textLengthAfterFormat() const
{
#ifdef IC_WIN
   // Approximate format count by adding an additional CR per line
   //  since we cannot query current format
   return (textLength() + numberOfLines());
#endif // IC_WIN
#ifdef IC_PM
   IEventResult evt(handle().sendEvent(MLM_QUERYFORMATTEXTLENGTH,
                                 IEventParameter1(0),
                                 IEventParameter2((unsigned long) 0xFFFFFFFF)));
   return evt.asUnsignedLong();
#endif // IC_PM
#ifdef IC_MOTIF
   // For Motif this function is identical to textLength()
   return textLength();
#endif
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::selectedTextLength                                           |
|                                                                              |
| Returns the size of the user marked area in bytes (containing CR/LF). Does   |
| not count '\0'.                                                              |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::selectedTextLength() const
{
#ifdef IC_WIN
   unsigned long startPt;                          // Start point of marked area
   unsigned long endPt;                            // End point of marked area

   handle().sendEvent( EM_GETSEL,
                       IEventParameter1( &startPt ),
                       IEventParameter2( &endPt ) );
   if (startPt == endPt)
     return 0;
   else
   {
     /*******************************************************************/
     /* Get character index for start point and end point and subtract  */
     /* them.  Assume byte count for now by using 1 for each character  */
     /*******************************************************************/
     return (endPt - startPt);
   }
#endif // IC_WIN
#ifdef IC_PM
   IEventResult minSel( handle().sendEvent(MLM_QUERYSEL,
                                           IEventParameter1(MLFQS_MINSEL),
                                           IEventParameter2(0)));
   IEventResult maxSel( handle().sendEvent(MLM_QUERYSEL,
                                           IEventParameter1(MLFQS_MAXSEL),
                                           IEventParameter2(0)));
   unsigned long startPt(minSel.asUnsignedLong());   // Start point of marked area
   unsigned long endPt(maxSel.asUnsignedLong());     // End point of marked area
   if (startPt == endPt)
     return 0;
   else
   {
     IEventResult evt(handle().sendEvent(MLM_QUERYFORMATTEXTLENGTH,
                                         IEventParameter1(startPt),
                                         IEventParameter2(endPt - startPt)));
     return evt.asUnsignedLong();
   }
#endif // IC_PM
#ifdef IC_MOTIF
   if (hasSelectedText())
     {
     IRange rangMarked = selectedRange();
     return rangMarked.upperBound() - rangMarked.lowerBound() + 1;
     }
   else
     return 0;
#endif // IC_MOTIF
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::setLayoutDistorted                                           |
------------------------------------------------------------------------------*/
IMultiLineEdit&  IMultiLineEdit :: setLayoutDistorted(
                                             unsigned long layoutAttributeOn,
                                             unsigned long layoutAttributeOff )
{
  unsigned long
     editedFlagsOn = ( layoutAttributeOn &
                         (unsigned long) ~IWindow::fontChanged );

  Inherited::setLayoutDistorted (editedFlagsOn, layoutAttributeOff);

  return *this;
}


#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMultiLineEdit::isDragStarting                                               |
|                                                                              |
| Windows does not generate drag messages, so therefore it is up to a          |
| a control to decide if the conditions exist to start a drag. A drag          |
| occurs if text is selected in the edit control and a button down occurs      |
| whose position is within the selected text rectangle.                        |
|                                                                              |
| Note: if you don't want the event to continue up the owner chain,            |
|       then set the event result to true.                                     |
------------------------------------------------------------------------------*/
bool IMultiLineEdit::isDragStarting( IEvent &event )
{
  bool brc = false;
  switch ( event.eventId() )
    {
    case WM_LBUTTONDOWN:
      {
      ITRACE_DEVELOP("Got a button down, start to look for drag");
      // only allow drag operation if text selected
      if (hasSelectedText())
        {
        if (fMultiLineEditData->pointInSelectedText(event))
          {
          IMouseClickEvent mevt( event );
          ITRACE_DEVELOP("Mouse is in selected range");
          ITRACE_DEVELOP("We have a drag" );
          // Instead of setting the return code to true, we will start the
          // drag and drop from here. This is so the text is selected when
          // the drag is occurring.
          event.window()->sendEvent( WM_BEGINDRAG,
               IEventParameter1((unsigned short)mevt.mousePosition().x(),
                                (unsigned short)mevt.mousePosition().y()),
               IEventParameter2( 0 ));
          selectRange(IRange(-1,0));
          }
        }
      break;
      }
    case WM_RBUTTONDOWN:
      {
      ITRACE_DEVELOP("Got a right button down, start to look for drag");
      // only allow drag operation if text selected
      if (hasSelectedText())
        {
        if (fMultiLineEditData->pointInSelectedText(event))
          {
          ITRACE_DEVELOP("Mouse is in selected range");
          if ( ::GetCapture() == NULL )
            {
            IMouseClickEvent mevt( event );
            ::SetCapture( event.handle());
            fMultiLineEditData->bCheckingRightDragStart = True;
            fMultiLineEditData->pointRButtonDown = mevt.mousePosition();
            }
          }
        }
      break;
      }
    case WM_RBUTTONUP:
      {
      if ( fMultiLineEditData->bCheckingRightDragStart )
        {
        ::ReleaseCapture();
        SetCapture( NULL );
        fMultiLineEditData->bCheckingRightDragStart = False;
        fMultiLineEditData->pointRButtonDown = IPoint(0,0);
        }
      break;
      }
    case WM_MOUSEMOVE:
      {
      if ( fMultiLineEditData->bCheckingRightDragStart )
        {
        ITRACE_DEVELOP("Mouse move while checking drag start");
        IMouseClickEvent mevt( event );
        IPoint mPoint( fMultiLineEditData->pointRButtonDown );

        if ( abs((int)(mevt.mousePosition().x() - mPoint.x())) >
                 DD_DEFDRAGMINDIST ||
             abs((int)(mevt.mousePosition().y() - mPoint.y())) >
                 DD_DEFDRAGMINDIST )
          {
          /*-----------------------------------------
          | We are going to start the drag from here instead
          | of returning true, because we need to control
          | the lifetime of the text being selected.
          -----------------------------------------*/
          ITRACE_DEVELOP("Starting a drag" );
          ::ReleaseCapture();
          fMultiLineEditData->bCheckingRightDragStart = FALSE;
          event.window()->sendEvent( WM_BEGINDRAG,
             IEventParameter1((unsigned short)mevt.mousePosition().x(),
                              (unsigned short)mevt.mousePosition().y()),
             IEventParameter2( 0 ));
          selectRange(IRange(-1,0));
          }
        }
      break;
      }
    }
  return brc;
}
#endif //IC_WIN

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMultiLineEditData::pointInSelectedText                                      |
|                                                                              |
------------------------------------------------------------------------------*/
bool IMultiLineEditData::pointInSelectedText(const IEvent& evt)
{
  IMODTRACE_DEVELOP("IDMSourceHandlerData::pointInSelectedText");
  // Get the handle to the edit control
  IMultiLineEdit *pMLECntrl = (IMultiLineEdit *)evt.window();

  RECT selRect;
  POINT pt;
  SIZE sizeSel;
  sizeSel.cx = sizeSel.cy = 0;
  bool bPtinSel = false;

  IMouseClickEvent mevt( evt );

  // Get mouse position when button down
  IPoint pmPt = mevt.mousePosition();

  // convert if necessary.
  if ( ICoordinateSystem::applicationOrientation() ==
       ICoordinateSystem::originLowerLeft )
    {
    pmPt.setY(evt.window()->size().height() - mevt.mousePosition().y());
    }

  pt.x = pmPt.x();
  pt.y = pmPt.y();

  ITRACE_DEVELOP("Mouse position x: " + IString(pt.x));
  ITRACE_DEVELOP("Mouse position y: " + IString(pt.y));

  // get the range of the selected text
  IRange range = pMLECntrl->selectedRange();

  if ((IPlatform::isWin9x()) || (IPlatform::isNTNewShell()))
    {
    // Retrieve the zero-based character index of the character nearest the
    // mouse point on the button down.
    // Note:  This message is currently supported only in Windows 95 and NT Newshell
    IEventResult charEvt = pMLECntrl->handle().sendEvent(EM_CHARFROMPOS, 0,
        IEventData((unsigned short)pmPt.x(), (unsigned short)pmPt.y()));

    long position = (long)charEvt.number1();

    ITRACE_DEVELOP("Character position of mouse in MLE: " + IString(position));

    // Return true if the mouse position is within the selected range
    return (range.includes(position));
    }

  HDC hDC = GetDC(pMLECntrl->handle());
  TEXTMETRIC tm;
  GetTextMetrics(hDC, &tm);

  // initialize rectangles
  selRect.left = selRect.right = selRect.top = 0;
  // bottom of rectangle is height of first line;
  long lineHeight = tm.tmHeight + tm.tmExternalLeading;
  selRect.bottom = lineHeight;

  // get the line number of the first visible line
  unsigned long top = pMLECntrl->top();

  unsigned long lineNum = 0, accumLength = 0;
  IString text;

  // The accumulated length has to account for not only the visible portion of
  // text in the MLE, but all text in the mle leading up the to the selected
  // text.  This is necessary to accurately compute the position of the
  // selected text based on the offsets from the range.
  while (lineNum < top)
    {
    text = pMLECntrl->text(lineNum);
    accumLength += text.length();

    // Only add additional length if not the first line in the MLE.
    // selectedRange() appears to add two additional characters for CRLF
    // per line, so we have to adjust the accumulated length accordingly.
    if (lineNum)
      accumLength += 2;

    ITRACE_DEVELOP("accumLength: " + IString(accumLength));
        lineNum++;
        }

  // get the number of visible lines.  Subtract for zero based index
  unsigned long numVisible = pMLECntrl->visibleLines()-1;
  ITRACE_DEVELOP("Number of visible lines (visible lines -1) " + IString(numVisible));

  // get the text for the first visible line
  text = pMLECntrl->text(top);
  ITRACE_DEVELOP("1st visible line of text: " + text);
  IString selText = pMLECntrl->selectedText();

  // update accumulated text length to account for current line
  accumLength += text.length();

  // Only add additional length if not the first line in the MLE.
  // selectedRange() appears to add two additional characters for CRLF
  // per line, so we have to adjust the accumulated length accordingly.
  if (lineNum)
    accumLength += 2;

  ITRACE_DEVELOP("accumLength: " + IString(accumLength));

  ITRACE_DEVELOP("Line num: " + IString(lineNum));
  // Find the first line with selected text
  while ( (accumLength < range.lowerBound()) && (lineNum < (top + numVisible)))
    {
    lineNum++;
    ITRACE_DEVELOP("Line num: " + IString(lineNum));
    text = pMLECntrl->text(lineNum);
    accumLength += text.length()+2;
    ITRACE_DEVELOP("accumLength " + IString(accumLength));

    // Update top and bottom of rectangle for each new line
    selRect.top = selRect.bottom+1;
    selRect.bottom+=lineHeight;
    }

  // 1st visible line may be partially selected
  // handle as a special case

  // Determine the starting point of the selected text, which is either the
  // lower bound of the range or the beginning of the line (zero).  The only
  // case where it is zero is if there is text selected above the topmost
  // visible line
  ITRACE_DEVELOP("1st line with selected text: " + text);
  long lineStartPos = accumLength - text.length();
  ITRACE_DEVELOP("line start pos: " + IString(lineStartPos));

  // Calculate the selected text start position within the initial line
  // NOTE:  There is a need to determine the position relative to a line
  // and relative to the entire selected text range (which may be prior to
  // the current line). selTextStart is relative to the given line.
  long selTextStart = (range.lowerBound() < lineStartPos) ? 0 :
                      range.lowerBound() - lineStartPos;
  ITRACE_DEVELOP("selTextStart: " + IString(selTextStart));
  // get length of selected text
  long lenSelText = (long)( (accumLength >= range.upperBound()) ?
                            ( (range.upperBound()-(accumLength-text.length())) - selTextStart + 1 ) :
                            ( text.length() - selTextStart + 1 ) );

  ITRACE_DEVELOP("lenSelText value " + IString(lenSelText));

  ITRACE_DEVELOP("Range lower bound: " + IString(range.lowerBound()));
  ITRACE_DEVELOP("Range upper bound: " + IString(range.upperBound()));

  // calcute the relative position of the selected text starting point
  // for the 1st visible line with selected text.
  long selRangeStartPos = (range.lowerBound() < lineStartPos) ?
                      lineStartPos - range.lowerBound() : 0;
  IString topSelText = selText.subString((unsigned)selRangeStartPos,
                                         (unsigned)MAX(0,lenSelText));
  ITRACE_DEVELOP("Selected text on first line: " + topSelText);

  SIZE sizeLead;
  sizeLead.cx = sizeLead.cy = 0;

  GetTextExtentPoint32(hDC, topSelText, topSelText.length(), &sizeSel);

  IString leadingText("");
  if (range.lowerBound() > 0)
    {
    // Calculate the text on the line up to where selection starts, which
    // is the accumlength of previous lines to the beginning of selected range
    leadingText = text.subString(0,
                      (unsigned)MAX(0,(long)(range.lowerBound()-(accumLength-text.length()))));
    ITRACE_DEVELOP("Leading text: " + leadingText);
    }

  GetTextExtentPoint32(hDC, leadingText, leadingText.length(), &sizeLead);

  // update the left and right positions to equate to the selection rectangle
  selRect.left = sizeLead.cx;
  selRect.right = sizeLead.cx + sizeSel.cx;

  ITRACE_DEVELOP("Selected rectangle (left,right,top,bottom)");
  ITRACE_DEVELOP("\tLeft: " + IString(selRect.left));
  ITRACE_DEVELOP("\tRight: " + IString(selRect.right));
  ITRACE_DEVELOP("\tTop: " + IString(selRect.top));
  ITRACE_DEVELOP("\tBottom: " + IString(selRect.bottom));

  // If the mouse is in the selected rectangle
  if (PtInRect(&selRect, pt))
    bPtinSel = true;

  bool bSelTextProcessed = false;

  // if point not in current rectangle and end of selected text not reached
  if (!bPtinSel && accumLength < range.upperBound())
    {
    lineNum++;
    // Get the next line of text
    text = pMLECntrl->text(lineNum);
    accumLength += text.length()+2;
    ITRACE_DEVELOP("accumLength: " + IString(accumLength));

    // Update top and bottom of rectangle for each new line
    selRect.top = selRect.bottom+1;
    selRect.bottom+=lineHeight;

    // Now handle case of middle lines where all the text is selected
    while (!bPtinSel && (lineNum < (top + numVisible)) && (accumLength < range.upperBound()))
      {
      // Left always 0 since all of the line is selected
      selRect.left = 0;

      ITRACE_DEVELOP("next line of text: " + text);
      GetTextExtentPoint32(hDC, text, text.length(), &sizeSel);
      selRect.right = sizeSel.cx;

      ITRACE_DEVELOP("Selected rectangle (left,right,top,bottom)");
      ITRACE_DEVELOP("\tLeft: " + IString(selRect.left));
      ITRACE_DEVELOP("\tRight: " + IString(selRect.right));
      ITRACE_DEVELOP("\tTop: " + IString(selRect.top));
      ITRACE_DEVELOP("\tBottom: " + IString(selRect.bottom));

      if (PtInRect(&selRect, pt))
        bPtinSel = true;

      lineNum++;
      // Get the next line of text
      text = pMLECntrl->text(lineNum);
      accumLength += text.length()+2;
      ITRACE_DEVELOP("accumLength: " + IString(accumLength));

      // Update top and bottom of rectangle for each new line
      selRect.top = selRect.bottom+1;
      selRect.bottom+=lineHeight;
      }
    }
  else
    bSelTextProcessed = true;

  if (!bPtinSel && !bSelTextProcessed)
    {
    // Last line is all that remains.  Special case because the last line
    // could be partially selected.
    selRect.left = 0;

    SIZE sizeTrail;
    sizeTrail.cx = sizeTrail.cy = 0;

    ITRACE_DEVELOP("Last line of text: " + text);
    GetTextExtentPoint32(hDC, text, text.length(), &sizeSel);

    IString trailingText("");
    // Get the trailing text - which is end of selected text to the end
    // of the last line
    trailingText = text.subString((unsigned)MAX(0,(long)(range.upperBound()-(accumLength-text.length()))));
    ITRACE_DEVELOP("Trailing text: " + trailingText);

    GetTextExtentPoint32(hDC, trailingText, trailingText.length(), &sizeTrail);

    // set right side of rectangle
    selRect.right = MAX(0,sizeSel.cx-sizeTrail.cx);

    ITRACE_DEVELOP("Selected rectangle (left,right,top,bottom)");
    ITRACE_DEVELOP("\tLeft: " + IString(selRect.left));
    ITRACE_DEVELOP("\tRight: " + IString(selRect.right));
    ITRACE_DEVELOP("\tTop: " + IString(selRect.top));
    ITRACE_DEVELOP("\tBottom: " + IString(selRect.bottom));

    PtInRect(&selRect, pt) ? bPtinSel = true : bPtinSel = false;
    }

  // release device context
  ReleaseDC(pMLECntrl->handle(), hDC);
  return bPtinSel;
}
#endif


#ifdef IC_MOTIF
/******************************************************************/
/*The following are encapsulations of line oriented MLE functions */
/******************************************************************/

unsigned long IMultiLineEdit::lineLength (unsigned long ipt) const
/************************************************************/
/*Returns the number of bytes after the insertion point.    */
/************************************************************/
{
   IString        theText = text();
   unsigned long  length;

   if ( ipt == (unsigned long)-1 )
      {
      ipt = XmTextGetInsertionPosition( (Widget) fMultiLineEditData->textHandle );
      }

   length = theText.subString(ipt+1).indexOf(unixNewline);

   return length;
}  //lineLength


/******************************************************************/
/*The following are private helper routines                       */
/******************************************************************/

/*------------------------------------------------------------------------------
| IMultiLineEdit::positionFromLine                                             |
|                                                                              |
/ Returns the insertion point (0 based from the beginning of buffer)           /
/ of the first byte of the (0-based) specified line number.                    /
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit::positionFromLine ( unsigned long linenumber) const
{
   if ( linenumber==0 )   // linenumber 0 always starts with position 0
      return 0;
   IASSERTPARM( linenumber < numberOfLines() );   // guard against bad linenumber

   return lineToFromPosition(linenumber, dPositionFromLine);
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::lineFromPosition                                             |
|                                                                              |
| Private helper routine, return (0-based) line number where specified byte is |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit :: lineFromPosition(unsigned long pos) const
{
   unsigned long tLen = textLength();
   if ( pos==0 && tLen==0 )   // position 0 always is line 0
      return 0;
   IASSERTPARM( pos<tLen );   // guard against pos being a bad value

   return lineToFromPosition(pos, dLineFromPosition);
}


/*------------------------------------------------------------------------------
| IMultiLineEdit::lineToFromPosition                                           |
|                                                                              |
| Private helper routine, return EITHER (0-based) position of 1st byte of      |
| specified line (if "direction" flag is "PositionFromLine"), OR (0-based)     |
| line number where specified byte is (if flag is "LineFromPosition").         |
------------------------------------------------------------------------------*/
unsigned long IMultiLineEdit :: lineToFromPosition(unsigned long pos, LinePosDirection direction) const
{
   //whitespace, incl. newline 0x0A)
   const char pWhiteSpace[] = {0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x20, 0x00};
   unsigned long line = 0;
   short columns = 0;
   XtVaGetValues( fMultiLineEditData->textHandle,
                  XmNcolumns, &columns,
                  NULL);
   long linelength = columns;
   long curLinePos = 0;
   long curLine1stByte = 0;
   IString txt = text();
   // Since XmText widgets appear to have a hardcoded tab length of 10 blanks,
   // change all tabs in txt to 10 blanks. (otherwise, our wordwrap logic -
   // such as it is -  doesn't work right). Adjust "pos" to match.
   {
   long tabsAfterPos = txt.occurrencesOf( '\t', pos+1);   // if pos is ON a tab,
                                   // ...new pos is 1st blank in set of 10
   long totalTabs = txt.occurrencesOf( '\t', 1);
   long tabsBeforePos = totalTabs - tabsAfterPos;
   pos = pos + tabsBeforePos*9;      // 9 = 10 blanks - 1 tab removed
   txt.change("\t", "          ");
   }

   unsigned long txtLength = txt.length();

   // NOTE: since "pos" is 0-based, all working variables herein are also.
   // Indexes returned by IString methods (1-based) are adjusted, as are indexes
   // passed into IString methods (we use IString instead of I0String on
   // purpose, so we can distinguish between "char is not found" (0 returned)
   // and "char is 1st byte" (1 returned) ).
   while ( ( direction==dLineFromPosition && curLinePos<=pos ) ||
                              // stop if pos was within the line just processed
                              // (line is 1-based, due to logic of while) *OR*
           ( direction==dPositionFromLine && line<=pos )      )
     {                        // stop if line is the one specified by pos
     line++;
     //save position of 1st byte, for use if direction==LineToPosition
     curLine1stByte = curLinePos;
     long nextImpliedLineEnd = 0;
     //end of line char is always end (unless wordwrapped 1st)
     long nextEOL = txt.indexOf('\n', curLinePos+1);
     //if wasn't any EOL char, don't use returned 0 - use textLength instead
     if (!nextEOL) nextEOL=txtLength;
     nextEOL--;          // adjust so we stay 0-based

     if ( isWordWrap() ) {
       // Start at last column in this line, but not beyond the end of
       // full text (if we do happen to be at end of text, we skip the
       // "looking for Mr.WhiteSpace" logic)
       long maybeLast = txtLength-1;
       if ( maybeLast > (curLinePos+linelength-1) ) {   //if not at end of text
         maybeLast = curLinePos+linelength-1;
         // NOTE: in following statement, "maybeLast+2" is index of char AFTER
         // last char because IString text uses 1-based index. Same is true
         // for other statements involving IString methods.
         if ( IString(txt[maybeLast+2]).isWhiteSpace() ) {                         //if char after last char is whitespace
           nextImpliedLineEnd = txt.indexOfAnyBut('\n', maybeLast+3);              //incl. it and up to one contiguous newline in this line
           if (!nextImpliedLineEnd)                                               // if we hit EOF, this contig. whitespace runs to end of file
             nextImpliedLineEnd = txtLength-1;                                    // ... so include it all in this line
           else
             nextImpliedLineEnd--;                                                // adjust so we stay 0-based
         }
         else {                                                                   //if char after last char is not whitespace
           if ( !(IString(txt[maybeLast+1]).isWhiteSpace()) ) {                   //if last char (maybeLast+1) is not whitespace
             nextImpliedLineEnd = txt.lastIndexOfAnyOf(pWhiteSpace, maybeLast+1);   // backup to last preceeding whitespace char
             nextImpliedLineEnd--;                                                 // adjust so we stay 0-based
             if (nextImpliedLineEnd<=curLinePos) nextImpliedLineEnd=maybeLast;     //if we backed up beyond start of this line (i.e., no
                                                                                   //...whitespace in this line), use maybeLast instead
           }
           else                                                                    //last char is whitespace (remember, next one is not)
             nextImpliedLineEnd = maybeLast;                                       //line end implied cause contiguous text broken in the middle
         }
       }  //endif maybeLast > curLinePos+...
       else                                        //else, we are at the end of text
         nextImpliedLineEnd = maybeLast;
     }  // endif isWordWrap
     else
       nextImpliedLineEnd = txtLength-1;  // gee, non-wordwrap is simpler, isn't it????

     curLinePos = nextEOL;        // use shorter of next EOL or implied line end
     if (curLinePos > nextImpliedLineEnd) curLinePos = nextImpliedLineEnd;
     curLinePos++;      // increment from end of this line to start of next line
   }  //end while

   if (line)
     line--;     // adjust "line" to be 0-based (if textLength==0, it
                 //  already will be)

   if (direction == dLineFromPosition)
     return line;
   else
     return curLine1stByte;
}

/*------------------------------------------------------------------------------
| IMultiLineEdit::passEventToOwner                                             |
|                                                                              |
| Returns whether or not the event can be passed up to the owner of this       |
| control.                                                                     |
------------------------------------------------------------------------------*/
bool IMultiLineEdit::passEventToOwner( IEvent& event )
{
  switch ( event.eventId() )
  {
    case WM_BUTTON1CLICK:
    case WM_BUTTON2CLICK:
    case WM_BUTTON3CLICK:
    case WM_CHORD:
      event.setPassToOwner( false );
      break;
    case xEvent(KeyPress):
    case xEvent(KeyRelease):
      event.setPassToOwner( false );
      break;
    default:
      Inherited::passEventToOwner( event );
      break;
  }
  return event.passToOwner();
}

#endif // IC_MOTIF
#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMultiLineEdit::wrapIt                                                       |
------------------------------------------------------------------------------*/
IMultiLineEdit& IMultiLineEdit::wrapIt(const IWindowHandle& handle )
{
  if ( !(XtIsSubclass(handle, xmTextWidgetClass)) )
    ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                         IBaseErrorInfo::accessError,
                         IException::recoverable,
                         "XmText");

//   setAutoDestroyWindow(false);
  prepareForUse(handle);

  startHandlingEventsFor(handle);

  // Don't call setEditRegion() here, accept the widget as it is.

  return *this;
}

/*------------------------------------------------------------------------------
| imleMbcsCheck                                                                |
|                                                                              |
| This function checks for mbcs overflow in the MLE.                           |
| This is necessary as the setLimit method sets the maximum number of          |
| bytes the MLE can hold, while the Text widget used to implement the MLE      |
| treats the associated XmNmaxLength attribute as bytes but allows "bytes"     |
| number of characters to be inserted into the widget (hence we may overflow   |
| the underlying Text field without this check).                               |
|-----------------------------------------------------------------------------*/
static void imleMbcsCheck ( Widget handle,
                                  XtPointer clientdata,
                                  XtPointer calldata)
{
  int currentBytes;                /* the current length of text in bytes */
  int deltaBytes = 0;              /* change in text positions */
  int maxLength;                   /* max length of the field  */
  int charCount = 0;               /* character counter        */
  int rc;                          /* return code of mblen     */
  char *cptr;                      /* character pointer        */
  char *currentText;               /* current text in the text widget */
  XmTextVerifyCallbackStruct *cbs; /* callback structure data  */

    cbs = (XmTextVerifyCallbackStruct *)calldata;

    XtVaGetValues(handle,
                  XmNvalue, &currentText,
                  XmNmaxLength, &maxLength,
                  NULL);

    currentBytes = strlen(currentText);

    /*
     * handle range of characters being replaced.
     */
    if (cbs->endPos > cbs->startPos) {
        cptr = currentText;
        while (cbs->startPos != charCount) {
            rc = mblen(cptr, MB_CUR_MAX);
            if (rc < 0) {
                XtFree(currentText);
                cbs->doit = False;
                return;
            } else {
                cptr += rc;
            }
            ++charCount;
        }

        while (cbs->endPos != charCount) {
            rc = mblen(cptr, MB_CUR_MAX);
            if (rc < 0) {
                XtFree(currentText);
                cbs->doit = False;
                return;
            } else {
                cptr += rc;
                deltaBytes +=rc;
            }
            ++charCount;
        }
    }

    XtFree(currentText);

    if ((currentBytes - deltaBytes + cbs->text->length) > maxLength) {
        cbs->doit = False;
    }
}

/*------------------------------------------------------------------------------
| ifmleMotifCallback                                                           |
|                                                                              |
| This callback maintains state information in the Multiline Edit private      |
| data necessary to implement the "isChanged" function, replace mode,          |
| and the unreadable and autotab styles.  The clientdata parameter is          |
| a pointer to the private data area of the multiline edit object.             |
| This routine is used as an XmNvaluedChangedCallback and an                   |
| XmNmodifyVerifyCallback.                                                     |
------------------------------------------------------------------------------*/
extern void  imleMotifCallback( Widget handle,
                                       XtPointer clientdata,
                                       XtPointer calldata)
{
   IMultiLineEditData *fMultiLineEditData = (IMultiLineEditData *)clientdata;
   XmAnyCallbackStruct    *cbs = (XmAnyCallbackStruct *)calldata;

   // Get the IWindow from the text widget handle passed in
   IWindow* pwin = IWindow::windowWithHandle(handle);

   // Handle possible IMultiLineEdit w/ scroll bars
   if (!pwin && XtIsSubclass(handle, xmTextWidgetClass) )
   {
      // If it is an MLE with scroll bars, IWindow::handle() will be the
      // scrolledWindow that is the parent of the text widget.
      Widget parent = XtParent(handle);
      pwin = IWindow::windowWithHandle( parent );

   }

   // will need to use the XmTextVerifyCallbackStructWcs in
   // conjuction with the dbcs style
   //*****aj 3/28/94: should NOT have to use XmText...Wcs. Regular one
   // works with multi-byte strings (alternative to wcs), and multi-byte
   // is a) more compact, b) the one supported in the Collection Class Lib, and
   // c) equal or better than wcs functionally. If users wish, they can deal
   // with the widget itself to get a wcs-version of the data (most won't want to).
   // This means: we only deal with XmNvalue (not XmNvalueWcs), XmNmodifyVerifyCallback
   // (not XmNmodifyVerifyCallbackWcs), etc. IApplication must do XtSetLanguageProc().

   // Interpret the callback reason to see which it is
   if (cbs->reason == XmCR_VALUE_CHANGED)
   {
      /**********************************************************/
      // Maintain the changed flag
      /**********************************************************/
      fMultiLineEditData->flagsCl |= IMultiLineEditData::changed;

      /**********************************************************/
      // Create & dispatch a control event
      /**********************************************************/

      /**********************************************************/
      // The general mapping of Motif callback parameters
      // to IEvents is the      following:
      // handle - the widget parameter on the callback
      // eventid        - the reason of the callback
      // parameter1 - the call_data parameter ... typically the
      //               callback structure pointer
      // parameter2 - XEvent * from callback
      /**********************************************************/
      XmAnyCallbackStruct *motifEventData = (XmAnyCallbackStruct*) calldata;
      unsigned long eventID = motifEventData->reason + motifEventOffset;
      unsigned long parm1   = (unsigned long) calldata;
      unsigned long parm2   = (unsigned long) motifEventData->event;

      if ( pwin != 0 )
         {
         ITRACE_ALL(IString("pwin->handle=") +
                 IString( pwin->handle().asUnsigned()).d2x()  +
                 IString(" eventID=") + IString( eventID ).d2x()  +
                 IString(" handle=") +
                   IString( IWindowHandle(handle).asUnsigned()).d2x() );

         // Construct an IEvent from the system data.
         IEvent evt( pwin,
                  eventID,
                  parm1,
                  parm2);
         // Dispatch the window's event handler
         if ( pwin->dispatch( evt ) == True )
         {
            return;
          }
      } // if pwin

   } // if XmCR_VALUE_CHANGED

   else if (cbs->reason == XmCR_MODIFYING_TEXT_VALUE)
   {

      if (MB_CUR_MAX > 1) {
          imleMbcsCheck(handle, clientdata, calldata);
          if (((XmTextVerifyCallbackStruct *)calldata)->doit == False) {
              /* mbcs overflowed entry Field .. reject data */
              return;
          }
      }

      /**********************************************************/
      // First of all, create & dispatch an edit verify event
      /**********************************************************/
      // Retrieve the IWindow associated with the handle (Widget ID )

      /**********************************************************/
      // The general mapping of Motif callback parameters
      // to IEvents is the      following:
      // handle - the widget parameter on the callback
      // eventid        - the reason of the callback
      // parameter1 - the call_data parameter ... typically the
      //               callback structure pointer
      // parameter2 - XEvent * from callback
      /**********************************************************/
      XmTextVerifyCallbackStruct *tcbs = (XmTextVerifyCallbackStruct *)calldata;
      unsigned long eventID = tcbs->reason + motifEventOffset;
      unsigned long parm1   = (unsigned long) calldata;
      unsigned long parm2   = (unsigned long) tcbs->event;

      if ( pwin != 0 )
      {
         ITRACE_ALL(IString("pwin->handle=") +
                 IString( pwin->handle().asUnsigned() ).d2x() +
                 IString(" eventID=") + IString( eventID ).d2x() +
                 IString(" handle=") +
                   IString( IWindowHandle(handle).asUnsigned()).d2x() );

         // Construct an IEvent from the system data.
         IEvent evt( pwin,
                     eventID,
                     parm1,
                     parm2);
         // Dispatch the window's event handler
         pwin->dispatch( evt );
      } // if pwin

      if (tcbs->doit)      // if attempted change was not rejected by event handler
      {
      /**********************************************************/
      // Perform built-in processing (keep in mind, tcbs.text
      // may have been changed during event dispatch (e.g., by IEditVerifyHandlers).
      /**********************************************************/
      if ( ( fMultiLineEditData->flagsCl & IMultiLineEditData::replaceMode ) &&
           ( tcbs->startPos >= tcbs->endPos ) )
         {
         /**********************************************************/
         /*The XmTextVerifyCallbackStructure contains an           */
         /*XmTextPosition called endPos.  Over-write is achieved by*/
         /*incrementing this by 1. You check that the reason is    */
         /*XmCR_MODIFYING_TEXT_VALUE, increment call_data->endPos  */
         /*then leave XmText to do the rest.  If deleting text     */
         /*then we do nothing special.                             */
         /**********************************************************/
         tcbs->endPos++;
         }  //replaceMode

      if ( fMultiLineEditData->flagsCl & IMultiLineEditData::unreadable )
         {
         /************************************************************/
         /*Handle the unreadable style by having the widget actually */
         /*contain * and let the EntryField class keep the real data */
         /************************************************************/
         unsigned long newLength = 0;
         if ( (tcbs->text->ptr != NULL) && (tcbs->text->length > 0) )
            {
            newLength = tcbs->text->length;
            }

         if (newLength == 0)
            {
            // Delete.  Remove the characters from the real value.
            unsigned long numberDeleted = tcbs->endPos - tcbs->startPos;
            fMultiLineEditData->urValueCl.remove(tcbs->startPos+1, numberDeleted);
            }
         else
            {
            // Adding characters.  Update real value
            IString newtext(tcbs->text->ptr, newLength);
            if ( tcbs->startPos > tcbs->endPos)
               {
               // replace mode
               fMultiLineEditData->urValueCl.overlayWith(newtext, tcbs->startPos + 1);
               }
            else
               {
               // insert mode
//               fMultiLineEditData->urValueCl.insert(newtext, tcbs->startPos+1);
               fMultiLineEditData->urValueCl.insert(newtext, tcbs->startPos);      //fix: when inserting, don't adjust startPos by 1
               }

            // set value to pass back to widget
            memset(tcbs->text->ptr, '*', newLength );
            }
         }  // unreadable

      if ( fMultiLineEditData->flagsCl & IMultiLineEditData::autoTab )
         {
         /************************************************/
         /*Handle the autoTab style by detecting when the*/
         /*last character allowed has been entered by    */
         /*the user.                                     */
         /************************************************/
         unsigned long newLength = 0;
         if ( (tcbs->text->ptr != NULL) && (tcbs->text->length > 0) )
            {
            newLength = tcbs->text->length;
            }

         if (newLength != 0)
            {
            if (newLength + tcbs->startPos >= XmTextGetMaxLength( handle ) )
               {
               /**********************************************/
               /*An XmProcessTraversal needs to happen here. */
               /*O'Reilly VI (p505) warns of "instablity" in */
               /*the text widget during this callback, so it */
               /*might not work.                             */
               /**********************************************/
               XmProcessTraversal(
                  handle,
                  XmTRAVERSE_NEXT_TAB_GROUP);
               }
            }
         }  // autoTab
      if ( fMultiLineEditData->flagsCl & IMultiLineEditData::ignoreTab )
         {
         /************************************************/
         /*Handle the ignoreTab style by detecting tab   */
         /*characters as keyed in, and "eating" them,    */
         /*so the press of the tab key is ignored.       */
         /************************************************/
         if ( (tcbs->text->ptr != NULL) && (tcbs->text->length > 0) )
            {
            // efficiently handle common case: text is just one tab char
            if ( (tcbs->text->length==1) && (tcbs->text->ptr[0]=='\t') )
              tcbs->text->length = 0;    // with length set to 0, any text is ignored
            else
              {
              // don't bother unless there are some tabs present (string could be multi-meg bytes)
              if ( memchr(tcbs->text->ptr,'\t',tcbs->text->length) )
                {
                IString *str = new IString();
                int i;
                for (i = 0; i < tcbs->text->length; i++)
                   if ( tcbs->text->ptr[i] != '\t' )
                     str += tcbs->text->ptr[i];
                memcpy( tcbs->text->ptr, (char*)str, str->length() );
                tcbs->text->length = str->length();
                delete str;
                }
              }  // end else
            }  // endif ->ptr != NULL...
         }  // ignoreTab
      }  // if doit is True

   }  // if XmCR_MODIFYING_TEXT_VALUE

   return;
}
#endif // IC_MOTIF
