// Revision: 04 1.15 source/ui/basectl/imcelcv.hpp, canvas, ioc.v400, 001006 
#ifndef _IMCELCV_
  #define _IMCELCV_
/*******************************************************************************
* FILE NAME: imcelcv.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMultiCellCanvas                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IColor;
class IMCCvCell;
class IMultiCellCanvasData;
class IRCHeader;
class ISize;

#pragma enum(4)
#pragma pack(push,4)

class IMultiCellCanvas : public ICanvas {
typedef ICanvas
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  IMultiCellCanvas ( unsigned long     windowIdentifier,
                     IWindow*          parent,
                     IWindow*          owner,
                     const IRectangle& initialSize = IRectangle(),
                     const Style&      style = defaultStyle() );

virtual
 ~IMultiCellCanvas ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IMultiCellCanvas, ICanvas, IWindow);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU spaceAddedToLast,
  IC_IMPORTU dragLines,
  IC_IMPORTU gridLines;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;


/*------------------------------ Cell Contents -------------------------------*/
virtual IMultiCellCanvas
 &addToCell      ( IWindow*      childWindow,
                   unsigned long startingColumn,
                   unsigned long startingRow,
                   unsigned long numberOfColumns = 1,
                   unsigned long numberOfRows = 1 );
virtual IWindow
 *removeFromCell ( IWindow*      childWindow ),
 *removeFromCell ( unsigned long column,
                   unsigned long row );
virtual IWindow
 *windowInCell   ( unsigned long startingColumn,
                   unsigned long startingRow ) const;

/*-------------------------- Row and Column Sizing ---------------------------*/
virtual IMultiCellCanvas
 &setColumnWidth     ( unsigned long column,
                       unsigned long widthInPixels,
                       bool          expandable = false ),
 &setRowHeight       ( unsigned long row,
                       unsigned long heightInPixels,
                       bool          expandable = false );
unsigned long
  columnWidth        ( unsigned long column ) const,
  rowHeight          ( unsigned long row    ) const;

bool
  isColumnExpandable ( unsigned long column ) const,
  isRowExpandable    ( unsigned long row    ) const;

static void
  setDefaultCell     ( const ISize&  widthAndHeight );

static ISize
  defaultCell        ( );

/*--------------------------- Grid and Drag Lines ----------------------------*/
#ifndef IC_MOTIF_FLAGNOP
bool
  hasDragLines     ( ) const;
#endif // IC_MOTIF_FLAGNOP
bool
  hasGridLines     ( ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual IMultiCellCanvas
 &disableDragLines ( ),
 &enableDragLines  ( bool enable = true );
#endif // IC_MOTIF_FLAGNOP
virtual IMultiCellCanvas
 &disableGridLines ( ),
 &enableGridLines  ( bool enable = true );

/*------------------------------ Layout Support ------------------------------*/
virtual bool
  hasChildrenToLayout ( ) const;
virtual IMultiCellCanvas
 &setLayoutDistorted  ( unsigned long layoutAttributesOn,
                        unsigned long layoutAttributesOff );

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual IMultiCellCanvas
 &layout ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMultiCellCanvas ( const IMultiCellCanvas& canvas );
IMultiCellCanvas
 &operator=        ( const IMultiCellCanvas& canvas );

/*--------------------------------- Private ----------------------------------*/
friend class IMultiCellCanvasList;
friend class IMultiCellCanvasHandler;
friend class IRowColumnHeaderList;
friend class IMultiCellCanvasObserver;

IMultiCellCanvas
 &pass1                   ( ),
 &pass2                   ( ),
 &pass3                   ( ),
 &pass4                   ( ),
 &computeExpandedRowsCols ( );

static Style
  currentDefaultStyle;

static unsigned long
  ulDefaultWidth,
  ulDefaultHeight;

unsigned long
  fMultiCol,
  fMultiRow,
  fExpandCol,
  fExpandRow;
#ifdef IC_MOTIF
IMultiCellCanvas
 &drawGridLines           ( );
#endif

IMultiCellCanvasList
 *pCanvasList;

IRowColumnHeaderList
 *pRowColHeaderList;

IMultiCellCanvasHandler
 *pCanvasHandler;

friend bool IRowColHeaderInitializer ( IRCHeader* const& header,
                                       void*             anything );
friend bool IMultiCellCanvasDeleter  ( IMCCvCell* const& cell,
                                       void*             anything );
friend bool IRowColumnHeaderDeleter  ( IRCHeader* const& header,
                                       void*             anything );

IMultiCellCanvasData
 *fMultiCellCanvasData;

}; // IMultiCellCanvas

INESTEDBITFLAGCLASSFUNCS(Style, IMultiCellCanvas)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMCELCV_ */
