// Revision: 02 1.8.2.1 source/ui/basectl/ilistprv.hpp, listctls, ioc.v400, 001006 
/* NOSHIP */
#ifndef _ILISTPRV_
  #define _ILISTPRV_
/*******************************************************************************
* FILE NAME: ilistprv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IItemHandlesList   - This class defines a keyed set used to store the    *
*                          item handles of an IListBox or IComboBox object.    *
*     IItemHandleElement - This class defines an element in the                *
*                          IItemHandlesList.                                   *
*     IBaseListBoxData   - This class encapsulates private data and functions  *
*                          used by the IBaseListBox class.  An object of this  *
*                          class is created in the IBaseListBox constructors.  *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <Xm/Xm.h>

#include <ibase.hpp>
#include <ihandler.hpp>

#pragma info(none)
  #include <iksset2.h>
#pragma info(restore)

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBaseListBox;

#pragma enum(4)
#pragma pack(push,4)

/*------------------------------------------------------------------------------
| IItemHandleElement class                                                     |
------------------------------------------------------------------------------*/
class IItemHandleElement
{
public:
  IItemHandleElement (unsigned long itemPosition, unsigned long aHandle):
     itemKey (itemPosition), handle (aHandle)  { }
  ~IItemHandleElement ( ) { }
unsigned long
  itemHandle ( )  {return handle;}

private:
  unsigned long itemKey;
  unsigned long handle;

// friend classes & functions
  friend class IItemHandlesList;
  friend unsigned long const& key (IItemHandleElement* const&);
};

// for SUN platform, define as inline function --MK
#ifdef IC_SUN
  inline unsigned long const& key (IItemHandleElement* const& k)
  {
    return k->itemKey;
  }
#endif

/*------------------------------------------------------------------------------
| IItemHandlesList class                                                       |
------------------------------------------------------------------------------*/
class IItemHandlesList : public IVPtrKeySortedSet<IItemHandleElement*,
                                              unsigned long>
{
public:
  IItemHandlesList () : IVPtrKeySortedSet<IItemHandleElement*,
                                      unsigned long>(100) {};
  ~IItemHandlesList() {};
};



/*------------------------------------------------------------------------------
| The IBaseListHandler class is a default handler for list boxes.              |
------------------------------------------------------------------------------*/
class IBaseListHandler : public IHandler {
typedef IHandler
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IBaseListHandler ( );

virtual
  ~IBaseListHandler ( );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

}; // class IBaseListHandler


/*------------------------------------------------------------------------------
| IBaseListBox class                                                           |
------------------------------------------------------------------------------*/
class IBaseListBoxData  {
public:
  IBaseListBoxData() : parentIsTop (false),
                   horizontalScroll (0),
                   lbHandle(0),
                   minimumRows (4),
                   minimumCharacters (25)
 { itemHandlesList = new IItemHandlesList(); };

  virtual ~IBaseListBoxData() 
  { 
    int cnt = itemHandlesList->numberOfElements();
    IItemHandleElement* handleElement;
    for( int j=0;j<cnt;j++)
    {
      handleElement = itemHandlesList->elementWithKey (j);
      itemHandlesList->removeElementWithKey(j);
      delete handleElement;
    }    
    delete itemHandlesList; 
  };

  static  Widget listBoxHandle (const IBaseListBox& listBox);
  Widget listBoxWidget (Widget topParent);
  void registerCallbacks(IBaseListBox* listBox);
  void unregisterCallbacks(IBaseListBox* listBox);

  IItemHandlesList *itemHandlesList;
  Boolean          parentIsTop;
  Widget           horizontalScroll;
  unsigned long    minimumRows, minimumCharacters;
  IWindowHandle    lbHandle;
  IBaseListHandler fdefaultHandler;

private:
  IBaseListBoxData::IBaseListBoxData (const IBaseListBoxData&);
  IBaseListBoxData& operator= (const IBaseListBoxData&);
};    // IBaseListBoxData

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ILISTPRV_
