// Revision: 95 1.5.2.8 source/ui/basectl/ilistbox.cpp, listctls, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ilistbox.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ilistbox.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481424 )

extern "C"
{
  #define INCL_WINLISTBOXES      // LIT_xxx, LM_xxx, LS_xxx
  #define INCL_WINSYS            // SV_xxx, PP_xxx
  #include <iwindefs.h>
  #include <ilistbox.h>
}

#ifdef IC_MOTIF
  #include <Xm/List.h>
  #include <Xm/ScrolledW.h>
#endif //IC_MOTIF

#include <inotifev.hpp>
#include <ilistbox.hpp>
#include <istring.hpp>
#include <ireslib.hpp>
#include <iapp.hpp>
#include <ihandle.hpp>
#include <iexcept.hpp>
#include <icconst.h>
#include <itrace.hpp>
#include <icolor.hpp>
#include <ifont.hpp>

#ifdef IC_MOTIF
  #include <ilistprv.hpp>
#endif //IC_MOTIF

// Segment definitions
#ifdef IC_PAGETUNE
  #define _ILISTBOX_CPP_
  #include <ipagetun.h>
#endif

/***************************************************************/
/* Public list box styles.                                     */
/***************************************************************/
const IListBox::Style
#ifdef IC_WIN
  IListBox::classDefaultStyle ( LS_HORZSCROLL  |
                                LS_NOADJUSTPOS |
                                WS_VISIBLE,
                                WS_EX_CLIENTEDGE );
#endif
#ifdef IC_MOTIFPM
  IListBox::classDefaultStyle ( LS_HORZSCROLL  |
                                LS_NOADJUSTPOS |
                                WS_VISIBLE );
#endif

/***************************************************************/
/* Default style for new objects (initial value)               */
/***************************************************************/
IListBox::Style
#ifdef IC_WIN
  IListBox::currentDefaultStyle ( LS_HORZSCROLL  |
                                  LS_NOADJUSTPOS |
                                  WS_VISIBLE,
                                  WS_EX_CLIENTEDGE );
#endif
#ifdef IC_MOTIFPM
  IListBox::currentDefaultStyle ( LS_HORZSCROLL  |
                                  LS_NOADJUSTPOS |
                                  WS_VISIBLE );
#endif

#ifdef IC_WIN
class IListBoxData {
/*******************************************************************************
* The IListBoxData class encapsulates private data and functions used by the   *
* IListBox class.  An object of this class is created in the IListBox          *
* constructors.                                                                *
*******************************************************************************/
public:
  IListBoxData ( );
  ~IListBoxData ( );

unsigned long
  stringSize(IListBox* listBox, const char* string);
unsigned long
  stringSize(IFont* tempFont, const char* string);
unsigned long
  largestStringSize(IListBox* listBox);

unsigned long
  largestString;
bool
  horizontalScrollStyleSet;

private:
  IListBoxData ( const IListBoxData& );
IListBoxData
 &operator=    ( const IListBoxData& );

}; // IListBoxData

/*------------------------------------------------------------------------------
| IListBoxData::IListBoxData                                                   |
------------------------------------------------------------------------------*/
IListBoxData::IListBoxData ( )
    : largestString(0),
      horizontalScrollStyleSet(false)
{
}

/*------------------------------------------------------------------------------
| IListBoxData::~IListBoxData                                                   |
------------------------------------------------------------------------------*/
IListBoxData::~IListBoxData ( )
{
}

/*------------------------------------------------------------------------------
| IListBoxData::stringSize                                                     |
|                                                                              |
| Return the width of the string for the current font.                         |
------------------------------------------------------------------------------*/
unsigned long IListBoxData::stringSize ( IListBox* listBox, const char *string )
{
  IFont tempFont = listBox->font();
  return ( tempFont.textWidth(string) );
}
/*------------------------------------------------------------------------------
| IListBoxData::stringSize                                                     |
|                                                                              |
| Return the width of the string for the current font.                         |
------------------------------------------------------------------------------*/
unsigned long IListBoxData::stringSize ( IFont *tempFont, const char *string )
{
  return ( tempFont->textWidth(string) );
}

/*------------------------------------------------------------------------------
| IListBoxData::largestStringSize                                              |
|                                                                              |
| Compute and return the size of the longest string in the listbox.            |
------------------------------------------------------------------------------*/
unsigned long IListBoxData::largestStringSize (IListBox* listBox )
{
  IBaseListBox::Cursor theCursor(*listBox, IBaseListBox::Cursor::allItems);
  unsigned long largest = 0,itemSize = 0;
  IFont tempFont = listBox->font();
  theCursor.setToFirst();
  while (theCursor.isValid())
  {
     if ((itemSize = stringSize( &tempFont, listBox->itemText(theCursor.asIndex()) )) > largest)
        largest = itemSize;
     theCursor.setToNext();
  }
  return largest;
}
#endif //IC_WIN

/*------------------------------------------------------------------------------
| IListBox::IListBox                                                           |
|                                                                              |
| Construct an IListBox on an IWindow.                                         |
------------------------------------------------------------------------------*/
IListBox::IListBox ( unsigned long     Id,
                     IWindow*          pParent,
                     IWindow*          pOwner,
                     const IRectangle& rectInit,
                     const Style&      style )
  : fListBoxData( 0 ),
    IBaseListBox( Id,
                  pParent,
                  pOwner,
                  rectInit,
                  (const IBaseListBox::Style&) style )
{
#ifdef IC_WIN
  fListBoxData = new IListBoxData();
  fListBoxData->horizontalScrollStyleSet =
                 (style & IBaseListBox::horizontalScroll) ? true : false;
#endif //IC_WIN
}

/*------------------------------------------------------------------------------
| IListBox::IListBox                                                           |
|                                                                              |
| Construct an IListBox on a dialog.                                           |
------------------------------------------------------------------------------*/
IListBox::IListBox ( unsigned long id,
                     IWindow* parent )
  : fListBoxData( 0 ),
    IBaseListBox( id, parent )
{
#ifdef IC_WIN
  fListBoxData = new IListBoxData();
#endif //IC_WIN
}

/*------------------------------------------------------------------------------
| IListBox::IListBox                                                           |
|                                                                              |
| Wrapper an existing ListBox.                                                 |
------------------------------------------------------------------------------*/
IListBox::IListBox ( const IWindowHandle& handle )
  : fListBoxData( 0 ),
    IBaseListBox( handle )
{
#ifdef IC_WIN
  fListBoxData = new IListBoxData();
        unsigned long style = GetWindowLong( handle, GWL_STYLE);
        fListBoxData->horizontalScrollStyleSet = (style & WS_HSCROLL) ? true : false;
#endif //IC_WIN
}

/*------------------------------------------------------------------------------
| IListBox::~IListBox                                                          |
|                                                                              |
| Default destructor here for page tuning.                                     |
------------------------------------------------------------------------------*/
IListBox::~IListBox()
{
#ifdef IC_WIN
   delete fListBoxData;
#endif //IC_WIN
}

/*------------------------------------------------------------------------------
| IListBox::Style IListBox::defaultStyle                                       |
------------------------------------------------------------------------------*/
IListBox::Style IListBox::defaultStyle()
{
   return currentDefaultStyle;
}

/*------------------------------------------------------------------------------
| IListBox::setDefaultStyle                                                    |
------------------------------------------------------------------------------*/
void IListBox::setDefaultStyle(const Style& style)
{
  currentDefaultStyle = style;
}

/*------------------------------------------------------------------------------
| IListBox::setFont                                                            |
------------------------------------------------------------------------------*/
IWindow& IListBox::setFont ( const IFont& font )
{
  Inherited::setFont ( font );
#ifdef IC_WIN
  // If horizontal scroll bar style specified and listbox not owner draw
  if ( fListBoxData->horizontalScrollStyleSet && !isDrawItem() )
  {
     fListBoxData->largestString = fListBoxData->largestStringSize(this);
     handle().sendEvent( LB_SETHORIZONTALEXTENT,
                         fListBoxData->largestString + 4,  //add fudge of 4 pixels
                         0 );
  }
#endif //IC_WIN
  return *this;
}

/*------------------------------------------------------------------------------
| defect: 29260/29477                                                          |
| IListBox::enableHorizontalScrollBarSizing( bool bEnable );                   |
------------------------------------------------------------------------------*/
IListBox& IListBox::enableHorizontalScrollBarSizing( bool bEnable )
{
#ifdef IC_WIN
  if( bEnable == true )             // are we turing scrolling ON
  {
    // only set it if not already on or owner draw
    if ( fListBoxData->horizontalScrollStyleSet && !isDrawItem() )
        return *this;

    // Not on, so turn it on
    fListBoxData->largestString = fListBoxData->largestStringSize(this);
    handle().sendEvent( LB_SETHORIZONTALEXTENT,
                        fListBoxData->largestString + 4, //add fudge of 4 pixels
                        0 );
    fListBoxData->horizontalScrollStyleSet = true;
  }
  else
  {
    // are we currently on
    if ( fListBoxData->horizontalScrollStyleSet && !isDrawItem() )
    {
        // turn it off
        handle().sendEvent( LB_SETHORIZONTALEXTENT,
                            0,
                            0 );
        fListBoxData->horizontalScrollStyleSet = false;
    }
  }
#endif
  return *this;
}

#include <ilistbx4.hpp>
