// Revision: 70 1.41.1.28 source/ui/basectl/ientryfd.cpp, editctls, ioc.v400 
/*******************************************************************************
* FILE NAME: ientryfd.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ientryfd.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

#define IUSING_OLE
#ifdef WIN32_LEAN_AND_MEAN
  #undef WIN32_LEAN_AND_MEAN
#endif
#ifdef _OLE2_H_
  #undef _OLE2_H_
#endif

extern "C" {
  #define INCL_NLS                     //ES_ANY, ES_SBCS, ES_DBCS, ES_MIXED
  #define INCL_WINCLIPBOARD
  #define INCL_WINENTRYFIELDS
  #define INCL_WINERRORS               //PMERR_HEAP_MAX_SIZE_REACHED
  #define INCL_WININPUT                //WM_CHAR, etc.
  #define INCL_WINMESSAGEMGR           //WNDPARAM struct
  #define INCL_WINWINDOWMGR
  #define INCL_GPIPRIMITIVES
  #define INCL_WINSYS
  #define INCL_GPIBITMAPS
  #include <iwindefs.h>
}

#ifdef IC_MOTIF
#include <X11/IntrinsicP.h>     // for CoreP.h
#include <X11/CoreP.h>          // for core.being_destroyed
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <isizrect.hpp>
#endif

#ifdef IC_MOTIFPM
#include <ikeyevt.hpp>
#endif

#include <ientryfd.hpp>
#include <iefpriv.hpp>
#include <ibidiset.hpp>
#include <icconst.h>
#include <icolor.hpp>
#include <iexcept.hpp>
#include <ifont.hpp>
#include <iinhratt.hpp>
#include <ihandle.hpp>
#include <inotifev.hpp>
#include <irect.hpp>
#include <ireslib.hpp>
#include <istring.hpp>
#include <ithread.hpp>
#include <itrace.hpp>
#include <iwcname.hpp>
#include <iplatfrm.hpp>


#ifdef IC_WIN
#ifndef _IMCEVT_
  #include <imcevt.hpp>
#endif
#ifndef _ICOORDSY_
  #include <icoordsy.hpp>
#endif
  #include <ibrushdr.hpp>
#endif

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IENTRYFD_CPP_
  #include <ipagetun.h>
#endif

//-----------------------------------------------------------------------
// DEFECT 4624 : required for PM and WIN
//-----------------------------------------------------------------------
#ifdef IC_PMWIN
#ifndef IES_AUTOTAB
   #define IES_AUTOTAB            0x00000008ul   //IEntryField::autoTab
#endif 
#endif // IC_PMWIN


#ifdef IC_MOTIF
#define MARGINBORDERPIXELS 2     /* pixels for Margin style */
/*------------------------------------------------------------------------------
|  Callback function prototype.                                                |
------------------------------------------------------------------------------*/
extern void  ientryfMotifCallback( Widget    w,
                                   XtPointer clientdata,
                                   XtPointer calldata);

static void ientryfMbcsCheck ( Widget w,
                               XtPointer clientdata,
                               XtPointer calldata);
#endif
/*------------------------------------------------------------------------------
| Public entry field styles.                                                   |
------------------------------------------------------------------------------*/
const IEntryField::Style
  IEntryField::readOnly          = ES_READONLY,
  IEntryField::leftAlign         ( 0, IES_LEFTALIGN ),
  IEntryField::centerAlign       = ES_CENTER,
  IEntryField::rightAlign        = ES_RIGHT,
  IEntryField::autoScroll        = ES_AUTOSCROLL,
  IEntryField::margin            = ES_MARGIN,
  IEntryField::unreadable        = ES_UNREADABLE,
  IEntryField::anyData           ( 0, IES_ANYDATA ),
#ifdef IC_PMWIN // icl2_4624
  IEntryField::autoTab           ( 0, IES_AUTOTAB ),
#else
  IEntryField::autoTab           = ES_AUTOTAB,
#endif
  IEntryField::command           = ES_COMMAND,
  IEntryField::sbcsData          = ES_SBCS,
  IEntryField::dbcsData          = ES_DBCS,
  IEntryField::mixedData         ( 0, IES_MIXEDDATA ),
#ifdef IC_PMWIN
  IEntryField::border3D          ( 0, IWS_BORDER3D ),
#endif
#ifdef IC_MOTIF
  IEntryField::border3D          ( 0 ),
#endif
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_WIN
  IEntryField::upperCase         = ES_UPPERCASE,         //simulate under PM?
  IEntryField::lowerCase         = ES_LOWERCASE,         //simulate under PM?
#endif //IC_WIN
#endif //IC_OBSOLETE
  IEntryField::classDefaultStyle ( (WS_VISIBLE    |
                                    ES_MARGIN     |
                                    ES_AUTOSCROLL),
                                                    (IES_LEFTALIGN |
                                                     IES_ANYDATA | IWS_BORDER3D));
const long IEntryField::end = -2;

#ifdef IC_WIN
bool IEntryField::fgTextSelection = false;
#endif //IC_WIN

/*------------------------------------------------------------------------------
| Default style for new objects (initial value).                               |
------------------------------------------------------------------------------*/
IEntryField::Style
 IEntryField::currentDefaultStyle ( (WS_VISIBLE    |
                                     ES_MARGIN     |
                                     ES_AUTOSCROLL),
                                                     (IES_LEFTALIGN |
                                                      IES_ANYDATA | IWS_BORDER3D));

/*------------------------------------------------------------------------------
| IEntryFieldData::IEntryFieldData                                             |
|                                                                              |
------------------------------------------------------------------------------*/
IEntryFieldData::IEntryFieldData ( IWindow *pwin)
  : dispatchingWindow( pwin )
#ifdef IC_WIN
  , charLimit(30000)
  , bCheckingRightDragStart(false)
  , pointRButtonDown()
  , fBrushHandler( )
#endif // IC_WIN
#ifdef IC_MOTIF
  , flagsCl( 0 )
  , urValueCl( '\0' )
  , iClrestOfMinimumWidth( 36 )
  , iClrestOfMinimumHeight( 20 )
  , efHandle(0)
#endif // IC_MOTIF
#ifdef IC_MOTIFWIN
  , fdefaultHandler( )
#endif
{ }

/*------------------------------------------------------------------------------
| IEntryFieldData::~IEntryFieldData                                            |
|                                                                              |
------------------------------------------------------------------------------*/
IEntryFieldData::~IEntryFieldData ( )
{
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IEntryFieldData::registerCallbacks                                           |
------------------------------------------------------------------------------*/
void IEntryFieldData :: registerCallbacks ()
{
  if ( !XtIsSubclass((Widget)efHandle, xmTextWidgetClass) )
     ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                          IBaseErrorInfo::accessError,
                          IException::recoverable,
                          "XmText");
  // Add the callback to handle the changed flag
  XtAddCallback(
      (Widget)efHandle,           // widget
      XmNvalueChangedCallback,  // callback name
      ientryfMotifCallback, // callback routine
      this);                     // client data
  // Add the callback to handle replacemode and styles
  XtAddCallback(
      (Widget)efHandle,           // widget
      XmNmodifyVerifyCallback,  // callback name
      ientryfMotifCallback, // callback routine
      this);                     // client data

#if 0
  // Add the callback to handle gaining focus
  XtAddCallback(
     (Widget)efHandle,           // widget
     XmNfocusCallback,          // callback name
     iwindowMotifCallback,     // callback routine
     (XtPointer) entryField /* need ptr to IEntryField */);  // client data
  // Add the callback to handle losing focus
  XtAddCallback(
     (Widget)efHandle,           // widget
     XmNlosingFocusCallback,   // callback name
     iwindowMotifCallback,     // callback routine
     (XtPointer) entryField /* need ptr to IEntryField */);  // client data
#endif
}

/*------------------------------------------------------------------------------
| IEntryFieldData::unregisterCallbacks                                         |
------------------------------------------------------------------------------*/
void IEntryFieldData :: unregisterCallbacks (IEntryField* entryField)
{
  if (entryField->isValid())
  {
    Widget wHandle = (Widget)entryField->handle();
    // Only unregister callbacks if widget not to be destroyed
    if (!wHandle->core.being_destroyed)
    {

     if ( !XtIsSubclass((Widget)efHandle, xmTextWidgetClass) )
       ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                            IBaseErrorInfo::accessError,
                            IException::recoverable,
                            "XmText");

     // Remove the callback to handle the changed flag
     XtRemoveCallback(
        (Widget)efHandle,        // widget
        XmNvalueChangedCallback, // callback name
        ientryfMotifCallback, // callback routine
        this);                   // client data
     // remove the callback to handle replacemode and styles
     XtRemoveCallback(
        (Widget)efHandle,          // widget
        XmNmodifyVerifyCallback,   // callback name
        ientryfMotifCallback,   // callback routine
        this);                     // client data
#if 0
     // Add the callback to handle gaining focus
     XtRemoveCallback(
        (Widget)efHandle,           // widget
        XmNfocusCallback,         // callback name
        iwindowMotifCallback,     // callback routine
        (XtPointer) entryField);  // client data
     // Add the callback to handle losing focus
     XtRemoveCallback(
        (Widget)efHandle,           // widget
        XmNlosingFocusCallback,   // callback name
        iwindowMotifCallback,     // callback routine
        (XtPointer) entryField);  // client data
#endif
    }
  }
}

#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| IEntryHandler::IEntryHandler                                                 |
|                                                                              |
| Empty constructor here for page tuning.                                      |
------------------------------------------------------------------------------*/
IEntryHandler::IEntryHandler()
{ }

/*------------------------------------------------------------------------------
| IEntryHandler::~IEntryHandler                                                |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IEntryHandler::~IEntryHandler()
{ }

/*------------------------------------------------------------------------------
| IEntryHandler::dispatchHandlerEvent                                          |
|                                                                              |
| Intercepts enter or escape key event and sends it to the owner.              |
| If there is no owner the event is sent to the parent.                        |
| Needed to emulate single line control but still get alignment                |
| characteristics.                                                             |
| Also achieves dialog behavior in canvases and frames without                 |
| use of IsDialogMessage in the event loop.                                    |
|                                                                              |
| Intercepts control color events                                              |
|                                                                              |
|    This handler returns false for all other events.                          |
------------------------------------------------------------------------------*/
bool IEntryHandler::dispatchHandlerEvent( IEvent& event )
{
  IMODTRACE_ALL("IEntryHandler::dispatchHandlerEvent");
  bool
    result = false;

#ifdef IC_PMWIN
  switch( event.eventId() )
  {
#ifdef IC_PM
    case WM_CHAR:
    {
      IKeyboardEvent keyevt(event);
      IKeyboardEvent::VirtualKey vkKey;
      if (keyevt.isCharacter()  &&
          (keyevt.isVirtual() == false  ||
          ((vkKey = keyevt.virtualKey()) != IKeyboardEvent::tab  &&
         vkKey != IKeyboardEvent::backSpace  &&
         vkKey != IKeyboardEvent::esc)) )
      {
         IEntryField* ef = (IEntryField*)event.window();
         unsigned long efLimit = ef->limit() - 1;
         if ( (ef->isAutoTab()) && (ef->textLength() == efLimit)
           && (ef->cursorPosition() == efLimit)
           && (ef->selectedTextLength() == 0 ) ) 
         {
            ef->sendEvent(WM_CHAR,
                               IEventParameter1((unsigned short)KC_VIRTUALKEY,0,0),
                               IEventParameter2((unsigned short)0,VK_TAB,0));
         }
      }
    }
    break;
#endif
#ifdef IC_WIN
    case WM_CHAR:
    {
      unsigned long ep1 = (unsigned long)event.parameter1();
      if ((ep1 == VK_RETURN ) || (ep1 == VK_ESCAPE ) || (ep1 == VK_TAB ))
      {
        IWindow* window = event.window();
        IWindow* owner  = window->owner();
        if (!owner)
          owner = window->parent();
        // If owner is a combobox, then get its owner to send to
        // because on Windows, the combobox will just send it back.
        if ( IWindowClassName( owner->handle() ) == WC_COMBOBOX )
        {
          window = owner;
          owner  = window->owner();
          if (!owner)
            owner = window->parent();
        }
        owner->sendEvent(event);
        return true;
      }
      // Lets emulate auto-tabbing for Windows
      else if ((ep1 != VK_BACK ) && (ep1 != VK_BREAK ))
      {
        // Check if autotab style is set and if when this key was
        // pressed we are one character short of the limit (meaning that
        // after this key is processed, we will be at our limit and
        // that the cursor is in the last position in the field
        IEntryField* ef = (IEntryField*)event.window();
        unsigned long efLimit = ef->limit() - 1;
        if ( ef->isAutoTab() && (ef->textLength() == efLimit)
          && (ef->cursorPosition() == efLimit)
          && (ef->selectedTextLength() == 0 ) ) 

        {
          ef->postEvent( WM_CHAR, VK_TAB );
        }
      }
      break;
    }

    // Adding code to trap accelerator/mnemonics and send directly to
    // owner (allowing it to naturally progress through dispatcher results
    // in an audible beep caused by the default window procedure because
    // it cannot find a match for a mnemonic that we process in
    // ICanvas or IFrameWindow), eating original event.
    case WM_SYSCHAR:
    {
      IWindow* window = event.window();
      IWindow* owner = window->owner();
      if (!owner)
        owner = window->parent();
      if (owner)
      {
        owner->sendEvent( event );
        result = true;
      }
      break;
    }
#endif //IC_WIN

    default:
      break;
  }
#endif // IC_PMWIN

#ifdef IC_MOTIF
  if (0)  //ignore for now
//  if ( event.eventId() == xEvent(ConfigureNotify) )
  {
    ISizeRectangle *sizeRect =
      (ISizeRectangle *) event.parameter1().asUnsignedLong();

    // if the size has changed
    if ( sizeRect->sizeChanged() )
    {
      IEntryField *entryField = (IEntryField*)event.controlWindow();

      Dimension     margins, efHeight, shadowThickness, highlightThickness;
      unsigned char maxCharHeight = entryField->characterSize().height();
      short         columns;

      // Need to recalculate the margin height.
      XtVaGetValues (entryField->fEntryFieldData->efHandle,
                     XmNheight,             &efHeight,
                     XmNshadowThickness,    &shadowThickness,
                     XmNhighlightThickness, &highlightThickness,
                     XmNcolumns,            &columns,
                     NULL);
      margins = efHeight - maxCharHeight -
                   2 * (shadowThickness + highlightThickness);
      XtVaSetValues (entryField->fEntryFieldData->efHandle,
                     XmNmarginHeight, margins / 2,
                     XmNcolumns, columns,
                     NULL);
    }
  }
#endif //IC_MOTIF
  return result;
}


/*------------------------------------------------------------------------------
| IEntryField::IEntryField                                                     |
|                                                                              |
| Default constructor (needed by combo box).                                   |
------------------------------------------------------------------------------*/
IEntryField::IEntryField()
  : fEntryFieldData( new IEntryFieldData( this) )
  , eReadStatus(doesntMatter)
  , queryInsMode(false)
{
}


/*------------------------------------------------------------------------------
| IEntryField::IEntryField                                                     |
|                                                                              |
| Constructor to create an entry field control on a standard window.           |
------------------------------------------------------------------------------*/
IEntryField::IEntryField ( unsigned long ulId,
                           IWindow* parent,
                           IWindow* pwndOwner,
                           const IRectangle& rectInit,
                           const Style& style )
  : fEntryFieldData( new IEntryFieldData( this ) )
  , eReadStatus(doesntMatter)
  , queryInsMode(false)
{
  // assertions on input parms
  IASSERTPARM(parent!=0);

  // Save the extended style to make sure we have a copy of it stored
  setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

  /********************************************************************/
  /* Need to check alignment styles for conflicting styles            */
  /********************************************************************/
  if (((style & IEntryField::rightAlign) && (style & IEntryField::centerAlign)) ||
      ((style & IEntryField::leftAlign) && (style & IEntryField::rightAlign)) ||
      ((style & IEntryField::leftAlign) && (style & IEntryField::centerAlign)))
  {
    ITHROWLIBRARYERROR( IC_INVALIDSTYLE,
                        IBaseErrorInfo::invalidParameter,
                        IException::recoverable);
  }

#ifdef IC_PMWIN
  IWindowHandle parentHandle(0);
  IWindowHandle ownerHandle(0);
  if (parent)
    parentHandle = parent->handleForChildCreation();
  else
    parentHandle = IWindow::desktopWindow()->handle();
  if (pwndOwner)
    ownerHandle = pwndOwner->handle();

  Style
    createStyle = style;

#ifdef IC_WIN
  // Check if we need to supply bidi support to turn a left-aligned
  // entry field into a right-aligned one.
  if ( ! ( style & ( IEntryField::rightAlign |
                       IEntryField::centerAlign ) )  &&
       IBidiSettings::isBidiSupported() )
  {
     bool
       rtl = false;
     // IWindow bidi styles take precedence over inherited bidi
     // attributes.
     if ( style & IWindow::rightToLeft )
     {
        rtl = true;
     }
     else if ( ! ( style & IWindow::leftToRight ) )
     {
        // The entry field inherits bidi attributes from its parent
        // window.
        IBidiSettings
          bidiValues( *parent );
        if ( bidiValues.windowLayout() ==
                           IBidiSettings::layoutRightToLeft )
        {
           rtl = true;
        }
     }
     if ( rtl )
     {
        // Change the left-aligned control into a right-to-left one.
        createStyle &= ~IEntryField::leftAlign;
        createStyle |= IEntryField::rightAlign;
        this->setExtendedStyle( this->extendedStyle() & ~IES_LEFTALIGN );
     }
  }
#endif // IC_WIN

  IWindowHandle whEntryField =
         this -> create( ulId,
                         0,
                         convertToGUIStyle( createStyle ),
                         WC_ENTRYFIELD,
                         parentHandle,
                         ownerHandle,
                         rectInit,
                         0,
                         0,
                         defaultOrdering(),
                         convertToGUIStyle( createStyle, true ) );

  startHandlingEventsFor(whEntryField);
#ifdef IC_PMWIN // icl2_4624
  fEntryFieldData->fdefaultHandler.handleEventsFor( this );
#endif
#ifdef IC_WIN
  fEntryFieldData->fBrushHandler.handleEventsFor(this);
#endif
#ifdef IC_WIN
  // Set the limit to 32 (instead of 30000) to keep default the same as OS/2
  setLimit( 32 );
#endif

#ifdef IC_PM
  setTextChangedFlag(false);   //Reset the changed status to FALSE,
                               //status is set to TRUE on creation.
#endif //IC_PM
#endif /* IC_PMWIN */
#ifdef IC_MOTIF
  IWindowHandle  whEntryField;
  Arg            args[9];
  int            n = 0;

  if ( style != IWindow::noStyle )
  {
    // style flags
    if ( style & IEntryField::margin)
    {
      // sets a default border  -  in PM it is 1/2 a character
      XtSetArg(args[n], XmNborderWidth, MARGINBORDERPIXELS ); n++;
    }
    if (style & IEntryField::readOnly)
    {
      XtSetArg(args[n], XmNeditable, False ); n++;
    }
    if ( !(style & IEntryField::autoScroll) )
    {
      XtSetArg(args[n], XmNautoShowCursorPosition, False ); n++;
    }

//      // Some of the styles need to be handled by callbacks in the
//      // handler.   **** AJ: now done in initialize()
//      // Save the style flags for this purpose:
//      //  autoTab, unreadable, command and the insertmode accessors.
//      if (efsStyle & IEntryField::autoTab)
//         fEntryFieldData->flagsCl |= IEntryFieldData::autoTab;
//      if (efsStyle & IEntryField::unreadable)
//         fEntryFieldData->flagsCl |= IEntryFieldData::unreadable;
//      if (efsStyle & IEntryField::command)
//         fEntryFieldData->flagsCl |= IEntryFieldData::command;
  }  // if noStyle off


//   There appears to be a bug in XmTextField such that
//   XmNmodifyVerifyCallback does not work correctly.  To workaround
//   XmText is used instead, in single line mode.
//   whEntryField =
//      XmCreateTextField(
//         pwndParent->handle(),         // parent
//         (char *)IString(ulId),        // widget name
//         args,
//         n);
  XtSetArg( args[n], XmNeditMode, XmSINGLE_LINE_EDIT ); n++;

  IWindowHandle parentHandle(0);
  IWindowHandle ownerHandle(0);
  if (parent)
    parentHandle = parent->handleForChildCreation();
  else
    parentHandle = IWindow::desktopWindow()->handle();
  if (pwndOwner)
    ownerHandle = pwndOwner->handle();

  // Create the widget, and set it up to be an IWindow.
  whEntryField =
     Inherited::create(
        ulId,
        NULL,
        style.asUnsignedLong(),
        (IXmCreateFunction)XmCreateText,
        parentHandle,
        ownerHandle,
        rectInit,
        args,
        n);

  // Initialize fields in the IEntryFieldData structure
  // including stashing away text widget in efhandle
  initialize( style.asUnsignedLong(), whEntryField);

  startHandlingEventsFor(whEntryField);

  // I don't trust Motif, init to null (sometimes we got "." ).
  XmTextSetString(whEntryField, "");

#endif
#ifdef IC_MOTIFWIN
  // add the inheritColor attribute to the window. Entryfield does
  // not inherit color.
  IInheritColorAttribute
    inheritColor( IInheritColorAttribute::kForegroundColor );
  this->addOrReplaceAttribute( IAttributeName("IInheritColorAttribute"),
                               inheritColor );
#endif // IC_MOTIFWIN
#ifdef IC_WIN
  // the background color of the entry field is dialog independant.
  setColor( PP_BACKGROUNDCOLOR, IColor::kEntryFieldBgnd);
#endif // IC_WIN
}


/*------------------------------------------------------------------------------
| IEntryField::IEntryField                                                     |
|                                                                              |
| Constructor to instantiate an entry field object for a dialog template.      |
------------------------------------------------------------------------------*/
IEntryField::IEntryField( unsigned long ulId,
                          IWindow*      parent )
  : fEntryFieldData( new IEntryFieldData( this) )
  , eReadStatus(doesntMatter)
  , queryInsMode(false)
{
  // assertions on input parms
  IASSERTPARM(parent!=0);

  setAutoDestroyWindow(false);

#ifdef IC_PMWIN
#ifdef IC_PM
  // Work-around for window id breakage in Warp GA for the child
  // entry field of a spin button control (it should be the window
  // id of the parent spin button, but is 1).
  if (parent  &&
      parent->id() == ulId  &&
      IWindow::handleWithParent( ulId, parent->handle() ) == 0  &&
      IWindowClassName ( parent->handle() ) == WC_SPINBUTTON)
  {                // Can't find a child entry field of a spin button.
     ulId = 1;     // Replace the id with the one Warp GA uses.
  }
#endif  // IC_PM

#ifdef IC_PMWIN // icl2_4624
  fEntryFieldData->fdefaultHandler.handleEventsFor( this );
#endif
#ifdef IC_WIN
  fEntryFieldData->fBrushHandler.handleEventsFor(this);
#endif
  reserveUserWindowWord( false );
  startHandlingEventsFor(ulId, parent);

  setTextChangedFlag(false);   //Reset the changed status to FALSE,
                               //status is set to TRUE on creation.
#endif //IC_PMWIN

  // Get the system style and look for extended styles.  Set if found.
  unsigned long sysStyle = style();

  // Extended style should always be zero
  unsigned long extStyle = extendedStyle();

#ifdef IC_PMWIN
  // Check for the 3D border style - will be WS_EX_CLIENTEDGE in NT and zero
  // otherwise
  if ((sysStyle & IWS_BORDER3D) || (sysStyle & ES_MARGIN))
     extStyle |= IWS_BORDER3D;

  // If neither center align nor right align is set, then left align must be
  if (!((sysStyle & ES_CENTER) || (sysStyle & ES_RIGHT)))
     extStyle |= IES_LEFTALIGN;

  // If SBCS and DBCS are set, then extended style MIXED is on
  if ((sysStyle & ES_SBCS) && (sysStyle & ES_DBCS))
     extStyle |= IES_MIXEDDATA;

  // If neither SBCS or DBCS is set, then set ANY extended style
  if (!((sysStyle & ES_SBCS) || (sysStyle & ES_DBCS)))
     extStyle |= IES_ANYDATA;

#ifdef IC_WIN
  sysStyle |= WS_CHILD;
  // Set the style
  setStyle(sysStyle);
#endif
#endif /* IC_PMWIN */
#ifdef IC_MOTIF
  IWindowHandle whEntryField =
         XtNameToWidget(parent->handle(), (char *)IString(ulId) );
  if (whEntryField == 0)
    ITHROWLIBRARYERROR1( IC_CONTROL_NOT_FOUND,
                         IBaseErrorInfo::accessError,
                         IException::recoverable,
                         "XtNameToWidget (XmText)");
  if ( !(XtIsSubclass(whEntryField, xmTextWidgetClass)) )
    ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                         IBaseErrorInfo::accessError,
                         IException::recoverable,
                         "XmText");

  prepareForUse(whEntryField);

  startHandlingEventsFor(whEntryField);

  // Initialize fields in the IEntryFieldData structure
  initialize(IWindow::noStyle.asUnsignedLong(), whEntryField);

  hasTextChanged();                //Reset the changed status to FALSE,
                               //status is set to TRUE on creation.
#endif
  // Set the extended style
  setExtendedStyle (extStyle);

#ifdef IC_MOTIFWIN
  // add the inheritColor attribute to the window. Entryfield does
  // not inherit color.
  IInheritColorAttribute
    inheritColor( IInheritColorAttribute::kForegroundColor );
  this->addOrReplaceAttribute( IAttributeName("IInheritColorAttribute"),
                               inheritColor );
#endif
}


/*------------------------------------------------------------------------------
| IEntryField::IEntryField                                                     |
|                                                                              |
| Constructor to instantiate from an existing entry field control.             |
------------------------------------------------------------------------------*/
IEntryField::IEntryField( const IWindowHandle& wh )
  : fEntryFieldData( new IEntryFieldData( this) )
  , eReadStatus(doesntMatter)
  , queryInsMode(false)
{
  IASSERTPARM(wh!=0);

  setAutoDestroyWindow(false);

#ifdef IC_PMWIN
  fEntryFieldData->fdefaultHandler.handleEventsFor( this );
#ifdef IC_WIN
  fEntryFieldData->fBrushHandler.handleEventsFor(this);
#endif
  reserveUserWindowWord( false );
  startHandlingEventsFor(wh);
#endif //IC_PMWIN

  // Get the system style and look for extended styles.  Set if found.
  unsigned long sysStyle = style();

  // Extended style should always be zero
  unsigned long extStyle = extendedStyle();

#ifdef IC_PMWIN
  // Check for the 3D border style - will be WS_EX_CLIENTEDGE in NT and zero
  // otherwise
  if ((sysStyle & IWS_BORDER3D) || (sysStyle & ES_MARGIN))
     extStyle |= IWS_BORDER3D;

  // If neither center align nor right align is set, then left align must be
  if (!((sysStyle & ES_CENTER) || (sysStyle & ES_RIGHT)))
     extStyle |= IES_LEFTALIGN;

  // If SBCS and DBCS are set, then extended style MIXED is on
  if ((sysStyle & ES_SBCS) && (sysStyle & ES_DBCS))
     extStyle |= IES_MIXEDDATA;

  // If neither SBCS or DBCS is set, then set ANY extended style
  if (!((sysStyle & ES_SBCS) || (sysStyle & ES_DBCS)))
     extStyle |= IES_ANYDATA;

#ifdef IC_WIN
  sysStyle |= WS_CHILD;
  // Set the style
  setStyle(sysStyle);
#endif
#endif /* IC_PMWIN */
#ifdef IC_MOTIF

  if ( !(XtIsSubclass(wh, xmTextWidgetClass)) )
    ITHROWLIBRARYERROR1( IC_WRONG_CONTROL_TYPE,
                         IBaseErrorInfo::accessError,
                         IException::recoverable,
                         "XmText");

  prepareForUse(wh);
  startHandlingEventsFor(wh);
  // Initialize fields in the IEntryFieldData structure
  initialize(IWindow::noStyle.asUnsignedLong(), wh);
#endif
  // Set the extended style
  setExtendedStyle (extStyle);

#ifdef IC_MOTIFWIN
  // add the inheritColor attribute to the window. Entryfield does
  // not inherit color.
  IInheritColorAttribute
    inheritColor( IInheritColorAttribute::kForegroundColor );
  this->addOrReplaceAttribute( IAttributeName("IInheritColorAttribute"),
                               inheritColor );
#endif
}


/*------------------------------------------------------------------------------
| IEntryField::~IEntryField                                                    |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IEntryField::~IEntryField()
{
#ifdef IC_MOTIFWIN
  fEntryFieldData->fdefaultHandler.stopHandlingEventsFor( this );
#endif

#ifdef IC_WIN
  fEntryFieldData->fBrushHandler.stopHandlingEventsFor(this);
#endif
#ifdef IC_MOTIF
  fEntryFieldData->unregisterCallbacks(this);
#endif //IC_MOTIF

  if ( fEntryFieldData != 0 )
    delete fEntryFieldData;
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IEntryField::initialize                                                      |
|                                                                              |
| Initialize data in IEntryFieldData, assuming handle() is a valid             |
| widget (i.e., that someone has already called startHandlingEventsFor() ).    |
------------------------------------------------------------------------------*/
IEntryField&  IEntryField :: initialize(unsigned long efsStyle,
                                        const IWindowHandle& wh)
{
   if ( efsStyle != IWindow::noStyle.asUnsignedLong() )
      {
      // Some of the styles need to be handled by callbacks in the
      // handler.   Save the style flags for this purpose:
      //  autoTab, unreadable,  command  and the insertmode accessors.
      if (efsStyle & ES_AUTOTAB)
         fEntryFieldData->flagsCl |= IEntryFieldData::autoTab;
      if (efsStyle & ES_UNREADABLE)
         fEntryFieldData->flagsCl |= IEntryFieldData::unreadable;
      if (efsStyle & ES_COMMAND)
         fEntryFieldData->flagsCl |= IEntryFieldData::command;
      }  // if noStyle off

  // Stash away text widget handle
  fEntryFieldData->efHandle = wh;

  // Attach default handler.
  fEntryFieldData->fdefaultHandler.handleEventsFor( this );

  // Register appropriate callbacks
  fEntryFieldData->registerCallbacks();

  return *this;
}
#endif

/*------------------------------------------------------------------------------
| IEntryField::defaultStyle                                                    |
|                                                                              |
| Return the default style for new entry field objects.                        |
------------------------------------------------------------------------------*/
IEntryField::Style IEntryField::defaultStyle()
{
  return( currentDefaultStyle );
}


/*------------------------------------------------------------------------------
| IEntryField::setDefaultStyle                                                 |
|                                                                              |
| Replace the default style for new entry field objects.                       |
------------------------------------------------------------------------------*/
void IEntryField::setDefaultStyle( const Style& style )
{
  currentDefaultStyle = style;
}


/*------------------------------------------------------------------------------
| IEntryField::convertToGUIStyle                                               |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IEntryField::convertToGUIStyle( const IBitFlag& guiStyle,
                                              bool bExtOnly ) const
{
  // Obtain the style from the class (ITextControl) that we inherit from.
  unsigned long ulStyle = Inherited::convertToGUIStyle( guiStyle, bExtOnly );

  if (bExtOnly)
  {
    // Use mask to only return extended styles in the user defined range.
    // And extended GUI styles like client edge.
    ulStyle |= guiStyle.asExtendedUnsignedLong() & (IS_EXTMASK | ITC_EXTGUIMASK);
  }
  else
  {
    // Let the clean ES_ styles, flow thru.
    ulStyle |= guiStyle.asUnsignedLong() & IES_MASK;

#ifdef IC_PM
    // ES_MIXED is the result of (ES_SBCS | ES_DBCS).  Therefore, we
    // define a unique bit for it in the extended styles.  Map the
    // extended style definition, back to the system definition,
    // prior to creating the control.
    unsigned long ulTmp = guiStyle.asExtendedUnsignedLong() & IES_EXTMASK;

    if (ulTmp & mixedData.asExtendedUnsignedLong())
    {
       ulStyle |= ES_MIXED;
    }
#endif
#ifdef IC_WIN
    ulStyle |= WS_CHILD;
#endif
  }

  return( ulStyle );
}


/*------------------------------------------------------------------------------
| IEntryField::setAlignment                                                    |
|                                                                              |
| Replaces the text alignment style of the entry field while preserving the    |
| marked area and cursor position.                                             |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::setAlignment( Alignment alignType )
{
  ITRACE_WIN_NOP();
  ITRACE_MOTIF_NOP();

#ifdef IC_PM
  unsigned long ulStyle = style();
  unsigned long ulOldStyle = ulStyle;

  //Remove existing alignment
  ulStyle &= ~(centerAlign.asUnsignedLong() | rightAlign.asUnsignedLong());

  switch (alignType)
  {
    case left:
      // No additional processing required
    break;

    case right:
      ulStyle |= rightAlign.asUnsignedLong();
    break;

    case center:
      ulStyle |= centerAlign.asUnsignedLong();
    break;

    default:
      ITHROWLIBRARYERROR(IC_INVALIDENUMVALUE,
                         IBaseErrorInfo::invalidParameter,
                         IException::recoverable);
    break;
  }

  if (ulStyle != ulOldStyle)
  {
    setStyle(ulStyle);                   //Change style
    refresh();                           //Force repaint
  }
#endif
  return *this;
}


/*------------------------------------------------------------------------------
| IEntryField::alignment                                                       |
|                                                                              |
| Returns the current alignment value for the entry field.                     |
------------------------------------------------------------------------------*/
IEntryField::Alignment  IEntryField::alignment() const
{
#ifdef IC_PMWIN
  unsigned long ulStyle = style();
  if (ulStyle & rightAlign.asUnsignedLong())
      return( right );

  if (ulStyle & centerAlign.asUnsignedLong())
      return( center );
#endif
  return( left );
}


/*------------------------------------------------------------------------------
| IEntryField::setCharType                                                     |
|                                                                              |
| Replaces the text data type style of the entry field while preserving the    |
| marked area and cursor position.                                             |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::setCharType( CharType charType )
{
  ITRACE_WIN_NOP();
  ITRACE_MOTIF_NOP();

#ifdef IC_PM
  unsigned long ulStyle = style();
  unsigned long ulOldStyle = ulStyle;
    ulStyle &= ~(sbcsData.asUnsignedLong() | dbcsData.asUnsignedLong() |
                 ES_MIXED);

  switch (charType)
  {
     case sbcs:
       ulStyle |= sbcsData.asUnsignedLong();
     break;

     case dbcs:
       ulStyle |= dbcsData.asUnsignedLong();
     break;

     case any:
      // No additional processing required
     break;

     case mixed:
       ulStyle |= ES_MIXED;
     break;

     default:
      ITHROWLIBRARYERROR(IC_INVALIDENUMVALUE,
                         IBaseErrorInfo::invalidParameter,
                         IException::recoverable);
     break;
  }

  if (ulStyle != ulOldStyle)
  {
    setStyle(ulStyle);                   //Change style
    refresh();                           //Force refresh
    notifyObservers(INotificationEvent(IEntryField::characterTypeId,
                                       *this, true, (void *)charType));
  }
#endif
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::charType                                                        |
|                                                                              |
| Returns the text contents type.                                              |
------------------------------------------------------------------------------*/
IEntryField::CharType  IEntryField::charType() const
{
#ifdef IC_PM
  unsigned long ulStyle = style();
  if ((ulStyle & sbcsData.asUnsignedLong()) &&
      (ulStyle & dbcsData.asUnsignedLong()))
     return( mixed );

  if (ulStyle & dbcsData.asUnsignedLong())
     return( dbcs );

  if (ulStyle & sbcsData.asUnsignedLong())
     return( sbcs );
#endif
  return( any );
}


/*------------------------------------------------------------------------------
| IEntryField::enableAutoScroll                                                |
|                                                                              |
| Sets the autoScroll style on the entry field control.                        |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::enableAutoScroll( bool enable )
{
  ITRACE_WIN_NOP();

#ifdef IC_PM
  unsigned long ulStyle = style();
  unsigned long ulOldStyle = ulStyle;

  if (enable)
  {
    ulStyle |= autoScroll.asUnsignedLong();
  }
  else
  {
    ulStyle &= ~autoScroll.asUnsignedLong();
  }

  if (ulStyle != ulOldStyle)
  {
    setStyle(ulStyle);                   //Change style
    refresh();                           //Force refresh
  }
#endif
#ifdef IC_MOTIF
  XtVaSetValues(
     (Widget) fEntryFieldData->efHandle,
     XmNautoShowCursorPosition, ( enable ? True : False ),
     NULL);
#endif
  return *this;
}


/*------------------------------------------------------------------------------
| IEntryField::disableAutoScroll                                               |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::disableAutoScroll()
{
  ITRACE_WIN_NOP();

  enableAutoScroll(false);
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::isAutoScroll                                                    |
------------------------------------------------------------------------------*/
bool IEntryField::isAutoScroll() const
{
#ifdef IC_PMWIN
  return( (style() & autoScroll.asUnsignedLong()) ? true : false );
#endif
#ifdef IC_MOTIF
  ::Boolean isOn = 0;
  XtVaGetValues(
     (Widget) fEntryFieldData->efHandle,
     XmNautoShowCursorPosition, &isOn,
     NULL);
  return ( isOn ? true : false );
#endif
}


/*------------------------------------------------------------------------------
| IEntryField::enableMargin                                                    |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::enableMargin ( bool enable )
{
  ITRACE_WIN_NOP();

#ifdef IC_PM
  unsigned long ulStyle = style();
  unsigned long ulOldStyle = ulStyle;

  if (enable)
  {
    ulStyle |= margin.asUnsignedLong();
  }
  else
  {
    ulStyle &= ~margin.asUnsignedLong();
  }

  if (ulStyle != ulOldStyle)
  {
    setStyle(ulStyle);                   //Change style
    refresh();                           //Force refresh
  }
#endif
#ifdef IC_MOTIF
  Dimension border = 0;
  IRectangle originalRect = IRectangle (position(), size());
  if (enable)
     border = MARGINBORDERPIXELS;
  XtVaSetValues(
     (Widget) fEntryFieldData->efHandle,
     XmNborderWidth, border,
     NULL);

  // Handle size change (necessary for IComboBox).
  setLayoutDistorted (minimumSizeChanged, 0);
#endif
  return *this;
}


/*------------------------------------------------------------------------------
| IEntryField::disableMargin                                                   |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::disableMargin()
{
  ITRACE_WIN_NOP();

  enableMargin(false);
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::isMargin                                                        |
------------------------------------------------------------------------------*/
bool IEntryField::isMargin() const
{
#ifdef IC_PMWIN
  return((style() & margin.asUnsignedLong()) ? true : false );
#endif
#ifdef IC_MOTIF
  Dimension border = 0;
  XtVaGetValues(
     (Widget) fEntryFieldData->efHandle,
     XmNborderWidth, &border,
     NULL);
  return  ( (border != 0) ? true : false) ;
#endif
}


/*------------------------------------------------------------------------------
| IEntryField::enableCommand                                                   |
|                                                                              |
| Enables or disbles the command style on an entry field control.              |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::enableCommand( bool enable )
{
  ITRACE_WIN_NOP();

#ifdef IC_PM
  unsigned long ulStyle = style();
  bool styleChanged = false;

  if (enable)
  {
    if (!(ulStyle & command.asUnsignedLong()))
    {
      ulStyle |= command.asUnsignedLong();
      styleChanged = true;
    }
  }
  else if (ulStyle & command.asUnsignedLong())
  {
    ulStyle &= ~command.asUnsignedLong();
    styleChanged = true;
  }

  if (styleChanged)
  {
    setStyle(ulStyle);                   //Change style
    refresh();                           //Force refresh
  }
#endif
#ifdef IC_MOTIF
  if (enable)
     fEntryFieldData->flagsCl |= IEntryFieldData::command;
  else
     fEntryFieldData->flagsCl &= ~IEntryFieldData::command;
#endif
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::disableCommand                                                  |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::disableCommand()
{
  ITRACE_WIN_NOP();

  enableCommand(false);
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::isCommand                                                       |
------------------------------------------------------------------------------*/
bool IEntryField::isCommand() const
{
#ifdef IC_PMWIN
  return( (style() & command.asUnsignedLong()) ? true : false );
#endif
#ifdef IC_MOTIF
  return (fEntryFieldData->flagsCl & IEntryFieldData::command);
#endif
}


/*------------------------------------------------------------------------------
| IEntryField::enableAutoTab                                                   |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::enableAutoTab( bool enable )
{
#ifdef IC_PMWIN // icl2_4624
  unsigned long ulExtStyle = extendedStyle();
  unsigned long ulOldStyle = ulExtStyle;

  if (enable)
    ulExtStyle |= autoTab.asExtendedUnsignedLong();
  else
    ulExtStyle &= ~autoTab.asExtendedUnsignedLong();

  if (ulExtStyle != ulOldStyle)
    setExtendedStyle(ulExtStyle);
#endif // IC_WIN
#ifdef IC_MOTIF
  if (enable)
     fEntryFieldData->flagsCl |= IEntryFieldData::autoTab;
  else
     fEntryFieldData->flagsCl &= ~IEntryFieldData::autoTab;
#endif // IC_MOTIF
  return *this;
}


/*------------------------------------------------------------------------------
| IEntryField::disableAutoTab                                                  |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::disableAutoTab()
{
  enableAutoTab(false);
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::isAutoTab                                                       |
------------------------------------------------------------------------------*/
bool IEntryField::isAutoTab() const
{
#ifdef IC_PMWIN
  return( (extendedStyle() & autoTab.asExtendedUnsignedLong()) ? true : false );
#endif // IC_WIN
#ifdef IC_MOTIF
  return (fEntryFieldData->flagsCl & IEntryFieldData::autoTab);
#endif //IC_MOTIF
}


/*------------------------------------------------------------------------------
| IEntryField::cut                                                             |
|                                                                              |
| Removes the selected text from the entry field control and puts it in the    |
| clipboard.                                                                   |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::cut( unsigned long timestamp )
{
  IASSERTSTATE(hasSelectedText());

#ifdef IC_PMWIN
  IEventResult evt = handle().sendEvent(EM_CUT,
                                        IEventParameter1(0),
                                        IEventParameter2(0));
#ifdef IC_PM
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("EM_CUT");
#endif
#endif // IC_PMWIN
#ifdef IC_MOTIF
   if ( !XmTextCut(
           fEntryFieldData->efHandle,
           timestamp) )
   {
   // nothing marked to cut (or maybe more unlikely error)
      ITHROWLIBRARYERROR1( IC_NOMARKEDTEXT,
                           IBaseErrorInfo::accessError,
                           IException::recoverable,
                           "XmTextCut");
   }
#endif // IC_MOTIF
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::copy                                                            |
|                                                                              |
| Copy marked text to the clipboard.                                           |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::copy( unsigned long timestamp )
{
  IASSERTSTATE(hasSelectedText());
#ifdef IC_PMWIN
  IEventResult evt = handle().sendEvent(EM_COPY,
                                        IEventParameter1(0),
                                        IEventParameter2(0));
#ifdef IC_PM
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("EM_COPY");
#endif
#endif // IC_PMWIN
#ifdef IC_MOTIF
   if ( !XmTextCopy(
           fEntryFieldData->efHandle,
           timestamp) )
   {
   // nothing marked to cut (or maybe more unlikely error)
      ITHROWLIBRARYERROR1( IC_NOMARKEDTEXT,
                           IBaseErrorInfo::accessError,
                           IException::recoverable,
                           "XmTextCopy");
   }
#endif // IC_MOTIF

  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::paste                                                           |
|                                                                              |
| Replaces the selected text with the text in the clipboard                    |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::paste()
{
  IASSERTSTATE(clipboardHasTextFormat());

#ifdef IC_PMWIN
  IEventResult evt = handle().sendEvent(EM_PASTE,
                                        IEventParameter1(0),
                                        IEventParameter2(0));
#ifdef IC_PM
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("EM_PASTE");
#endif
#endif //IC_PMWIN
#ifdef IC_MOTIF
   if ( !XmTextPaste( fEntryFieldData->efHandle ))
   {
   // nothing marked to cut (or maybe more unlikely error)
     ITHROWLIBRARYERROR1( IC_CLIPBOARDEMPTY,
                          IBaseErrorInfo::accessError,
                          IException::recoverable,
                           "XmTextPaste");
   }
#endif

  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::clear                                                           |
|                                                                              |
| Replaces the selected text in the entry field with blanks.                   |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::clear( unsigned long timestamp )
{
  IASSERTSTATE(hasSelectedText());
#ifdef IC_PMWIN
  // If disableDataUpdate() has been called, then do nothing (like other
  // system clipboard operations).
  if (isWriteable())
  {
     IRange rangMark = selectedRange();
     IString strText  = text();

     // Compensate for 0-based index from selected range
     // and 1-based index used by IString.
     strText.overlayWith(IString(0, (unsigned int)
                         (rangMark.upperBound() - rangMark.lowerBound()+1)),
                         (unsigned int)rangMark.lowerBound()+1);
     setText((char *)strText);
  }
#endif
#ifdef IC_MOTIF
  if (hasSelectedText())
  {
    IRange selected = selectedRange();
    unsigned long length = selected.upperBound() - selected.lowerBound() + 1;
    IString blanks (0, length);     // a blank string of length "length"
    // replace the current selection with a string of blanks of equal length
    XmTextReplace(
       fEntryFieldData->efHandle,                           // widget
       selected.lowerBound(),              // start pos
       selected.upperBound() + 1,          // char after end of those we want to replace
       blanks);                            // replacement string (blanks)
  }
#endif //IC_MOTIF
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::discard                                                         |
|                                                                              |
| Deletes the selected text.  Compacts the marked area.                        |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::discard()
{
  IASSERTSTATE(hasSelectedText());

#ifdef IC_PMWIN
  IEventResult evt = handle().sendEvent(EM_CLEAR,
                                        IEventParameter1(0),
                                        IEventParameter2(0));
#ifdef IC_PM
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("EM_CLEAR");
#endif
#endif //IC_PMWIN
#ifdef IC_MOTIF
   if (this->isWriteable())
   {  // Ignore request if entryfield is not writeable (Intel compatibility)
     if ( !XmTextRemove( fEntryFieldData->efHandle ) )
        // or maybe more unlikely error
        ITHROWLIBRARYERROR1( IC_NOMARKEDTEXT,
                             IBaseErrorInfo::accessError,
                             IException::recoverable,
                             "XmTextRemove");
   }
#endif //IC_MOTIF
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::removeAll                                                       |
|                                                                              |
| Deletes the entire contents of the Entryfield.                               |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::removeAll()
{
  /*******************************************************************/
  /* Check to insure that Entryfield is not already empty            */
  /*******************************************************************/
  if (!isEmpty())
  {
    /*****************************************************************/
    /* Turn update off, select all of the text, then call discard()  */
    /* to remove all of the text from the entryfield.                */
    /*****************************************************************/
#ifdef IC_PM
    unsigned long style = this->style();
    if ( (style & WS_VISIBLE ))
      enableUpdate(false);
    selectRange();
    discard();
    if ( (style & WS_VISIBLE ))
      enableUpdate(true);
#endif //IC_PM

#ifdef IC_WIN
    unsigned long style = this->style();
    if ( (style & WS_VISIBLE ))
      enableUpdate(false);
    // No delete all function in Windows so just set contents to NULL string
    setText((char*)IString());
    if ( (style & WS_VISIBLE ))
      enableUpdate(true);
#endif //IC_WIN

#ifdef IC_MOTIF
    enableUpdate(false);

    // Modify editable state directly instead of using enableDataUpdate to
    // avoid generating notifications.
    bool wasReadOnly = !this->isWriteable();
    if (wasReadOnly)
       XmTextSetEditable( fEntryFieldData->efHandle, True );
    selectRange();
    discard();
    if (wasReadOnly)
       XmTextSetEditable( fEntryFieldData->efHandle, False );
    enableUpdate(true);
#endif //IC_MOTIF

  }
  return *this;
}


/*------------------------------------------------------------------------------
| IEntryField::isEmpty                                                         |
------------------------------------------------------------------------------*/
bool IEntryField::isEmpty() const
{
  if (text().length())
    return( false );
  else
    return( true );
}


/*------------------------------------------------------------------------------
| IEntryField::hasTextChanged                                                  |
|                                                                              |
| Queries whether the entry field has changed since the last query.            |
------------------------------------------------------------------------------*/
bool IEntryField::hasTextChanged( ) const
{
#ifdef IC_PMWIN
  //In PM, this message resets the change flag by default.
  //In Windows, this message does not reset the change flag by default.
  IEventResult evt = handle().sendEvent(EM_QUERYCHANGED,
                                        IEventParameter1(0),
                                        IEventParameter2(0));

  if (evt.asUnsignedLong())
  {
#ifdef IC_PM
    // Update change flag since reset by EM_QUERYCHANGED
    // Doesn't appear to be needed...
    //ISETWINDOWTEXT(handle(), (PSZ)text());
#endif
    return( true );
  }
  else
    return( false );
#endif // IC_PMWIN
#ifdef IC_MOTIF
  bool val = (fEntryFieldData->flagsCl & IEntryFieldData::changed);
  //Clear the value for next time.
  fEntryFieldData->flagsCl &= ~IEntryFieldData::changed;
  return val;
#endif
}


/*------------------------------------------------------------------------------
| IEntryField::isWriteable                                                     |
------------------------------------------------------------------------------*/
bool IEntryField::isWriteable() const
{
#ifdef IC_PMWIN
#ifdef IC_WIN
  if ( style() & readOnly.asUnsignedLong() )
#else
  IWindowHandle handleEf = handle();

  if ( IWindowClassName( handleEf ) == WC_COMBOBOX )
   {
   // Get the edit control child of the combobox.
   handleEf = WinWindowFromID(handle(), CBID_EDIT);
   }

  IEventResult evt = handleEf.sendEvent(EM_QUERYREADONLY,
                                        IEventParameter1(0),
                                        IEventParameter2(0));
  if (evt.asUnsignedLong())
#endif
    return( false );
  else
    return( true );
#endif // IC_PMWIN
#ifdef IC_MOTIF
  return XmTextGetEditable( fEntryFieldData->efHandle ) ;
#endif
}


/*------------------------------------------------------------------------------
| IEntryField::hasSelectedText                                                 |
------------------------------------------------------------------------------*/
bool IEntryField::hasSelectedText() const
{
// this logic should work for motif as well
#ifdef IC_PMWIN
  if (selectedTextLength() == 0)
    return( false );
  else
    return( true );
#endif // IC_PMWIN
#ifdef IC_MOTIF
  IRange rangMarked = getCursorInfo();
  if (rangMarked.lowerBound() == rangMarked.upperBound())
     return false;
  else
     return true;
#endif
}

/*------------------------------------------------------------------------------
| IEntryField::setTextChangedFlag                                              |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::setTextChangedFlag( bool changed )
{
#ifdef IC_PMWIN
#ifdef IC_PM
  if (changed)
    ISETWINDOWTEXT(handle(), (PSZ)text());
  else
    IEventResult evt = handle().sendEvent(EM_QUERYCHANGED,
                                          IEventParameter1(0),
                                          IEventParameter2(0));
#endif

#ifdef IC_WIN
  handle().sendEvent(EM_SETMODIFY, IEventParameter1(changed),
                                   IEventParameter2(0));
#endif
#endif // IC_PMWIN

#ifdef IC_MOTIF
  if (changed)
    fEntryFieldData->flagsCl |= IEntryFieldData::changed;
  else
    fEntryFieldData->flagsCl &= ~IEntryFieldData::changed;
#endif //IC_MOTIF

  return *this;
}

/*------------------------------------------------------------------------------
| IEntryField::resetTextChangedFlag                                            |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::resetTextChangedFlag( )
{
  setTextChangedFlag( false );
  return *this;
}

/*------------------------------------------------------------------------------
| IEntryField::disable                                                         |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::disable()
{
#ifdef IC_PMWIN
  if (isWriteable())
  {
     eReadStatus = wasInputButReset;
     disableDataUpdate();
  }
  IWindow::disable();

  if (hasFocus())
  {
     /**********************************************************/
     /* Send tab message to self (this will be sent on to the  */
     /* owner to be processed).                                */
     /* NOTE: The only additional information sent with the    */
     /*       VK_TAB message is that it is a virtual key.      */
     /**********************************************************/
#ifdef IC_PM
     handle().sendEvent(WM_CHAR,
                        IEventParameter1((unsigned short)KC_VIRTUALKEY,0,0),
                        IEventParameter2((unsigned short)0,VK_TAB,0));
#endif

#ifdef IC_WIN
     handle().sendEvent(WM_KEYDOWN,
                        IEventParameter1(VK_TAB),
                        IEventParameter2(0));
#endif
  }
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if ( isWriteable() )
  {
     eReadStatus = IEntryField::wasInputButReset;
     disableDataUpdate();
  }
  IWindow::disable();
  /**********************************************************/
  /* Take us out of the traversal (keyboard navigation) list*/
  /**********************************************************/
//  XtVaGetValues(handle(), XmNtraversalOn, False, NULL);    ?????? needed? or automatic?

  if (hasFocus())
  {
     /**********************************************************/
     /* Automatically tab to the next widget in the list.      */
     /**********************************************************/
     //????????? how do we do this?  is it done automatically by widget?
  }
#endif
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::enable                                                          |
|                                                                              |
| Enables the entry field.  Remove the read-only (if turned on by disable()    |
| and reset by enableReadOnly()).                                              |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::enable( bool enable )
{
#ifdef IC_PMWIN
  if (eReadStatus == wasInputButReset)
  {
     eReadStatus=doesntMatter;
     enableDataUpdate();
  }
  IENABLEWINDOW(handle(), enable);
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if (eReadStatus == IEntryField::wasInputButReset)
  {
     eReadStatus=IEntryField::doesntMatter;
     enableDataUpdate();
     /**********************************************************/
     /* Put us back in the traversal (keyboard navigation) list*/
     /**********************************************************/
//     XtVaGetValues(handle(), XmNtraversalOn, True, NULL); ?????? needed? or automatic?
  }
  IWindow::enable( enable);
#endif // IC_MOTIF
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::isInsertMode                                                    |
------------------------------------------------------------------------------*/
bool IEntryField::isInsertMode() const
{
#ifdef IC_PM
  ((IEntryField*)this)->queryInsMode = true;
  IEventResult evt = handle().sendEvent(EM_SETINSERTMODE,
                                        IEventParameter1(true),
                                        IEventParameter2(0));
  if (evt.asUnsignedLong())
  {
    ((IEntryField*)this)->queryInsMode = false;
    return( true );
  }

  handle().sendEvent(EM_SETINSERTMODE,
                     IEventParameter1(false),
                     IEventParameter2(0));

  ((IEntryField*)this)->queryInsMode = false;
  return( false );
#endif
#ifdef IC_WIN
  // Windows edit fields are always in insert mode
  return ( true );
#endif
#ifdef IC_MOTIF
  return ( !(fEntryFieldData->flagsCl & IEntryFieldData::replaceMode) );
#endif
}


/*------------------------------------------------------------------------------
| IEntryField::enableInsertMode                                                |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::enableInsertMode( bool insert )
{
  ITRACE_WIN_NOP();

#ifdef IC_PM
  handle().sendEvent(EM_SETINSERTMODE,
                     IEventParameter1(insert),
                     IEventParameter2(0));
#endif
#ifdef IC_MOTIF
  // This function is implemented in the default IEditVerifyHandler
  // Set flags for handler to look at.
  if ( insert )
     fEntryFieldData->flagsCl &= ~IEntryFieldData::replaceMode;
  else
     fEntryFieldData->flagsCl |= IEntryFieldData::replaceMode;
 return *this;
#endif // IC_MOTIF
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::disableInsertMode                                               |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::disableInsertMode()
{
  ITRACE_WIN_NOP();

  enableInsertMode(false);
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::enableDataUpdate                                                |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::enableDataUpdate( bool update )
{
#ifdef IC_PMWIN
  IWindowHandle handleEf = handle();

#ifdef IC_PM
  if ( IWindowClassName( handleEf ) == WC_COMBOBOX )
   {
   // Get the edit control child of the combobox.
   handleEf = WinWindowFromID(handle(), CBID_EDIT);
   }
#endif

  if (update)
  {
    if ( !(this->isWriteable()) )
    {
      handleEf.sendEvent(EM_SETREADONLY,
                         IEventParameter1(false),
                         IEventParameter2(0));
    }
  }
  else if ( this->isWriteable() )
  {
    handleEf.sendEvent(EM_SETREADONLY,
                       IEventParameter1(true),
                       IEventParameter2(0));
  }
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if ( ( update && !this->isWriteable() ) ||
       (!update &&  this->isWriteable() ) )
    this->notifyObservers(INotificationEvent(
                          IEntryField::dataUpdateId, *this,
                          true, update ? True : False ) );
  XmTextSetEditable( fEntryFieldData->efHandle, update ? True : False );
#endif
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::disableDataUpdate                                               |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::disableDataUpdate()
{
  enableDataUpdate(false);
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::setLimit                                                        |
|                                                                              |
| Sets the maximum number of characters allowed in the entry field.            |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::setLimit( unsigned long ulLimit )
{
  IASSERTSTATE(text().length() <= ulLimit);

  if (this->limit() != ulLimit)
  {
#ifdef IC_PMWIN
    /*************************************************************/
    /* Now set the new edit limit for the entry field.           */
    /*************************************************************/
    handle().sendEvent(EM_SETTEXTLIMIT,
                       IEventParameter1(ulLimit),
                       IEventParameter2(0));
#ifdef IC_WIN
    fEntryFieldData->charLimit = ulLimit;
#endif
#endif // IC_PMWIN

#ifdef IC_MOTIF
    /*************************************************************/
    /* Now set the new edit limit for the entry field.           */
    /*************************************************************/
    XmTextSetMaxLength( fEntryFieldData->efHandle, (int)ulLimit );

    this->notifyObservers(INotificationEvent(
                          IEntryField::limitId, *this,
                          true, ulLimit) );
#endif

    setLayoutDistorted(IWindow::minimumSizeChanged, 0);
  }

  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::setLimit                                                        |
|                                                                              |
| Sets the maximum number of characters allowed in the entry field given a     |
| string resource-id that defines the limit.                                   |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::setLimit( const IResourceId& residTextLimit )
{
  IString strTextLimit =
     residTextLimit.resourceLibrary().loadString(residTextLimit);
  setLimit(strTextLimit.asInt());
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::limit                                                           |
|                                                                              |
| Returns the maximum number of characters allowed to entered into the entry   |
| field.                                                                       |
------------------------------------------------------------------------------*/
unsigned long IEntryField::limit() const
{
#ifdef IC_PM
  WNDPARAMS     wprmData;
  ENTRYFDATA    efdCtlData;
  unsigned long ulClTextLimit = 0;

  wprmData.fsStatus = WPM_CTLDATA;          //Get control data
  wprmData.pCtlData = &efdCtlData;          //Area for control data
  wprmData.cbCtlData = sizeof(ENTRYFDATA);  //Size of control data

  /*******************************************************************/
  /* Because of an error in PMMERGE.DLL on an OS2J machine, do       */
  /* NOT check the return value of this call.  On an OS2J machine    */
  /* the return code from PM is 1, but we are getting 0 back here    */
  /* due to the EBX register getting trashed in PMMERGE.  Hence, we  */
  /* throw an exception when we shouldn't.                           */
  /*******************************************************************/
  handle().sendEvent(WM_QUERYWINDOWPARAMS,
                     IEventParameter1(&wprmData),
                     IEventParameter2(0));

  ulClTextLimit = efdCtlData.cchEditLimit;  // Edit limit
                                   // Note: wprmData.fsStatus does not get
                                   //       cleared on success, as advertised!
  return( ulClTextLimit );
#endif

#ifdef IC_WIN
  return( fEntryFieldData->charLimit );  //Return local variable since
                                         //EM_GETTEXTLIMIT doesn't work
#endif
#ifdef IC_MOTIF
  return XmTextGetMaxLength( fEntryFieldData->efHandle );
#endif
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IEntryField::setText                                                         |
|                                                                              |
| Changes the control text using the string table.                             |
------------------------------------------------------------------------------*/
IEntryField&  IEntryField::setText(const IResourceId& residText)
{
   Inherited::setText( residText );
   return *this;
}


/*------------------------------------------------------------------------------
| IEntryField::setText                                                         |
|                                                                              |
| Changes the control text given a string.                                     |
------------------------------------------------------------------------------*/
IEntryField&  IEntryField::setText(const char* pszText)
{
   IString newText(pszText);
   /**************************************************************/
   /* Windows won't check the string length against the limit, so*/
   /* we have to do it ourselves.                                */
   /* If the text is too long, truncate it like in OS/2.         */
   /**************************************************************/
   Inherited::setText( newText.subString( 1,
                       (unsigned int)MIN( newText.length(), limit())) );
   return *this;
}
#endif    // IC_WIN


/*------------------------------------------------------------------------------
| IEntryField::selectRange                                                     |
|                                                                              |
| Marks (selects) text in the entry field.  Index of characters to mark is     |
| assumed to be 0-based.                                                       |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::selectRange( const IRange& range,
                                       unsigned long timestamp )
{
  //Make upper the character following the last selected one
  IRange temprange = IRange(range.lowerBound(), range.upperBound() + 1);

  if (range.upperBound() == end)
    temprange.setUpperBound(text().length());

  setCursorInfo(temprange);
  return( *this );
}


/*------------------------------------------------------------------------------
| IEntryField::selectedRange                                                   |
|                                                                              |
| Returns the range of the selected text.  Index of characters marked is       |
| assumed to be 0-based.                                                       |
------------------------------------------------------------------------------*/
IRange IEntryField::selectedRange() const
{
  IASSERTSTATE(hasSelectedText());
  IRange rangMarked = getCursorInfo();
  if (rangMarked.lowerBound() != rangMarked.upperBound())
     rangMarked.setUpperBound(rangMarked.upperBound() - 1);
                                //Make upper the last selected character
  return( rangMarked );
}


/*------------------------------------------------------------------------------
| IEntryField::selectedTextLength                                              |
|                                                                              |
| Returns the size of the user marked area in bytes.  Does not count '\0'.     |
------------------------------------------------------------------------------*/
unsigned long IEntryField::selectedTextLength() const
{
  IRange rangMarked = getCursorInfo();

  return (rangMarked.upperBound() - rangMarked.lowerBound());
}


/*------------------------------------------------------------------------------
| IEntryField::selectedText                                                    |
|                                                                              |
| Returns the selected text.                                                   |
------------------------------------------------------------------------------*/
IString IEntryField::selectedText() const
{
  long    lMinOffset;     //0-based offset of 1st char in selection
  long    lMaxOffset;     //0-based offset of 1st char AFTER selection

  IRange rangMarked = getCursorInfo();

  if (rangMarked.lowerBound() == rangMarked.upperBound())
  {                                    //No selected text
    IString str("\0");
    return( str );
  }
  else
  {
    lMinOffset = rangMarked.lowerBound();
    lMaxOffset = rangMarked.upperBound();

    IString str((char *)text() + lMinOffset, (unsigned int)
                (lMaxOffset - lMinOffset), '\0');
    return( str );
  }
}


/*------------------------------------------------------------------------------
| IEntryField::setLeftIndex                                                    |
|                                                                              |
| Set the first character displayed at the left edge of the entry field        |
| control.  The index is 0-based.                                              |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::setLeftIndex( unsigned long ulIndex )
{
#ifdef IC_PM
  IEventResult evt = handle().sendEvent(EM_SETFIRSTCHAR,
                                        IEventParameter1(ulIndex),
                                        IEventParameter2(0));
  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("EM_SETFIRSTCHAR");
#endif // IC_WIN
#ifdef IC_WIN
   // Since we cannot get the current index, scroll to start of text
   // and then scroll forward the requested amount
   handle().sendEvent( EM_LINESCROLL,
                       IEventParameter1(-65000),
                       IEventParameter2(0) );
   handle().sendEvent( EM_LINESCROLL,
                       IEventParameter1(ulIndex),
                       IEventParameter2(0) );
#endif // IC_MOTIF
#ifdef IC_MOTIF
   XmTextShowPosition(
      fEntryFieldData->efHandle,             // widget
      (Position) ulIndex ); // position of 1st char to show
#endif // IC_MOTIF
  return *this;
}


/*------------------------------------------------------------------------------
| IEntryField::leftIndex                                                       |
|                                                                              |
| Get the offset position of the first character displayed at the left edge    |
| of the entry field.  The index is 0-based.                                   |
------------------------------------------------------------------------------*/
unsigned long IEntryField::leftIndex() const
{
#ifdef IC_PMWIN
  IEventResult evt = handle().sendEvent(EM_QUERYFIRSTCHAR,
                                        IEventParameter1(0),
                                        IEventParameter2(0));
  return( evt.asUnsignedLong() );
#endif // IC_PMWIN
#ifdef IC_MOTIF
  XmTextPosition pos =
          XmTextXYToPos(
             fEntryFieldData->efHandle,     // widget
             2,            // x position relative to widget; For some reason, x position
                           // must be 2 to correctly calculate left index.  Not sure why,
                           // seems independent of borderWidth and or marginWidth.
             0);           // y position relative to widget
  return (unsigned long) pos;
#endif
}


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IEntryField::setStyle                                                        |
|                                                                              |
| Replaces the style of the entry field control, while preserving the          |
| cursor position and selected text.                                           |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::setStyle( unsigned long ulStyle )
{
  IRange range = getCursorInfo();
  IWindow::setStyle(ulStyle);
  setCursorInfo(range);
  return( *this );
}
#endif

/*------------------------------------------------------------------------------
| IEntryField::calcMinimumSize                                                 |
|                                                                              |
| Calculate the minimum screen size needed by the control.  The height is      |
| based on the font height and the width is based on the average font width    |
| multiplied by the text limit.                                                |
------------------------------------------------------------------------------*/
ISize IEntryField::calcMinimumSize() const
{
#ifdef IC_PMWIN
  ISize sizChar = ((IEntryField *)this)->characterSize();
                                            //Cast to non-const object
  unsigned long ulWidth = sizChar.width();  //Average char width
  unsigned long ulHeight= sizChar.height();

  // Hack similar to the one in ITextControl::displaySize.  This will
  // keep entry fields with borders and static text controls, which use
  // the same font, about equal in height on a multi-cell or set canvas.
#ifdef IC_PM
  ulHeight += 2;
#endif
#ifdef IC_WIN
  if ( !(IPlatform::isWin9x() || IPlatform::isNTNewShell()) )
  {
    // For some reason we need a fudge factor of 7 for window platforms
    // that are using program manager. If this fudge factor is not added then
    // the entryfield will not accept focus and you can not type in it.
    ulHeight += 7;
  }
#endif
  unsigned long ulClTextLimit = limit();

  /*****************************************************************/
  /* Use a step function to reflect the fact that you are more     */
  /* likely to exceed an average character width with an           */
  /* individual character, but a long string will likely be ok     */
  /* with this average value.                                      */
  /*****************************************************************/

  IFont font(this);
  if ( !font.isFixed() )
  {
     if (ulClTextLimit <= 2)
        ulWidth = ulWidth * ulClTextLimit * 3;
     else
        ulWidth = ulWidth * (ulClTextLimit + 5);
  }  // is proportional
  else
  {
     ulWidth = (ulWidth * ulClTextLimit);
  }  // not proportional

  if ( ulWidth > ( sizChar.width() * 35 ))
  {
     ulWidth = sizChar.width() * 35;
  }

  if (isMargin())
  {
     ulWidth +=(3 * IQUERYSYSVALUE(SV_CXBORDER));
     ulHeight+=(3 * IQUERYSYSVALUE(SV_CYBORDER));
  } /* endif */

  ISize sizMin(ulWidth, ulHeight);

  if ( ( extendedStyle() & border3D.asExtendedUnsignedLong() ) &&
       ( IPlatform::isWin9x() || IPlatform::isNTNewShell() ))
  {
     // 22733 : use same API as that used in textctl::displaySize()
     int cx = IQUERYSYSVALUE( SV_CXSIZEBORDER );
     int cy = IQUERYSYSVALUE( SV_CYSIZEBORDER );

     sizMin += ISize(cx,cy);
  }

  return( sizMin );
#endif // IC_PMWIN
#ifdef IC_MOTIF
  ISize sizChar = ((IEntryField*)this)->characterSize();
                                            //Cast to non-const object
  unsigned long ulWidth = sizChar.width();  //Average char width
  unsigned long ulHeight= sizChar.height();

  unsigned long ulClTextLimit = limit();
  if (ulClTextLimit < 3  )
    ulWidth *= 3;
  else if (ulClTextLimit > 35)
    ulWidth *= 35;
  else
    ulWidth *= ulClTextLimit;

  ulWidth += fEntryFieldData->iClrestOfMinimumWidth;
  ulHeight+= fEntryFieldData->iClrestOfMinimumHeight;
  
  ISize sizMin(ulWidth, ulHeight);
  return sizMin;
#endif // IC_MOTIF
}


/*------------------------------------------------------------------------------
| IEntryField::cursorPosition                                                  |
|                                                                              |
| Returns the character position of where the cursor currently is.             |
------------------------------------------------------------------------------*/
unsigned long IEntryField::cursorPosition() const
{
#ifdef IC_PMWIN
  IWindowHandle handleEf = handle();

#ifdef IC_WIN
  if ( IWindowClassName( handleEf ) == WC_COMBOBOX )
   {
   // Find the edit control child of the combobox.
   handleEf = GetWindow(handle(), GW_CHILD);
   while ( (handleEf) && (IWindowClassName(handleEf) != WC_ENTRYFIELD))
      handleEf = GetWindow(handleEf, GW_HWNDNEXT);
   }
#endif
  IEventResult evt = handleEf.sendEvent(EM_QUERYSEL,
                                        IEventParameter1(0),
                                        IEventParameter2(0));
  return( evt.number2() );
#endif //IC_PMWIN
#ifdef IC_MOTIF
  return ((unsigned long)XmTextGetInsertionPosition( (Widget) fEntryFieldData->efHandle));
#endif //IC_MOTIF
}


/*------------------------------------------------------------------------------
| IEntryField::setCursorPosition                                               |
|                                                                              |
| Position the cursor in front of the character specified.                     |
------------------------------------------------------------------------------*/
IEntryField& IEntryField::setCursorPosition( unsigned long lCursorChar )
{
#ifdef IC_PM
  IEventResult evt = handle().sendEvent(EM_SETSEL,
                      IEventParameter1((unsigned short)lCursorChar,
                                       (unsigned short)lCursorChar),
                      IEventParameter2(0));

  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("EM_SETSEL");

  // if not in view, scroll cursor to first char position
  unsigned long ulIndex;
  ulIndex = ( (lCursorChar > 0 ? lCursorChar-1 : 0) );
  handle().sendEvent(EM_SETFIRSTCHAR,
                     IEventParameter1(ulIndex),
                     IEventParameter2(0));
#endif //IC_PM
#ifdef IC_WIN
  IWindowHandle handleEf = handle();

  if ( IWindowClassName( handleEf ) == WC_COMBOBOX )
   {
   // Find the edit control child of the combobox.
   handleEf = GetWindow(handle(), GW_CHILD);
   while ( (handleEf) && (IWindowClassName(handleEf) != WC_ENTRYFIELD))
      handleEf = GetWindow(handleEf, GW_HWNDNEXT);
   }

  IEventResult evt = handleEf.sendEvent(EM_SETSEL,
                      IEventParameter1(lCursorChar),
                      IEventParameter2(lCursorChar));

  // scroll cursor into view
  handleEf.sendEvent(EM_SCROLLCARET,
                     IEventParameter1(0),
                     IEventParameter2(0));
#endif //IC_WIN
#ifdef IC_MOTIF
  XmTextSetInsertionPosition((Widget) fEntryFieldData->efHandle, lCursorChar );
#endif //IC_MOTIF

  return *this;
}

/*------------------------------------------------------------------------------
| IEntryField::getCursorInfo                                                   |
|                                                                              |
| Gets the bound of the marked or selected text, which also includes where     |
| the cursor is placed.  (The values in the returned range have not been       |
| adjusted to match the format used by selectedRange.)                         |
------------------------------------------------------------------------------*/
IRange IEntryField::getCursorInfo() const
{
#ifdef IC_PMWIN
  IWindowHandle handleEf = handle();

#ifdef IC_WIN
  if ( IWindowClassName( handleEf ) == WC_COMBOBOX )
   {
   // Find the edit control child of the combobox.
   handleEf = GetWindow(handle(), GW_CHILD);
   while ( (handleEf) && (IWindowClassName(handleEf) != WC_ENTRYFIELD))
      handleEf = GetWindow(handleEf, GW_HWNDNEXT);
   }

#endif //IC_WIN
  IEventResult evt = handleEf.sendEvent(EM_QUERYSEL,
                                        IEventParameter1(0),
                                        IEventParameter2(0));

  return( IRange(evt.number1(), evt.number2()) );
#endif
#ifdef IC_MOTIF
  XmTextPosition
     left, right;
  if (!XmTextGetSelectionPosition(
         fEntryFieldData->efHandle,            // widget
         &left,               // left selected pos (0 based)
         &right))             // right selected pos (0 based)
     {
     XmTextPosition pos = XmTextGetInsertionPosition( fEntryFieldData->efHandle );
     return IRange(pos,pos);
     }     // this widget doesn't own selection, so return current cursor pos as a range
  else
    if (left == right )
      {
      XmTextPosition pos = XmTextGetInsertionPosition( fEntryFieldData->efHandle );
      return IRange(pos,pos);       // return current cursor position, as a range
      }
    else
      return IRange(left, right);
#endif // IC_MOTIF
}


/*------------------------------------------------------------------------------
| IEntryField::setCursorInfo                                                   |
|                                                                              |
| Marks (selects) text in the entry field, and sets the position of the cursor.|
------------------------------------------------------------------------------*/
void IEntryField::setCursorInfo( const IRange& range )
/***************************************************************/
/* Marks (selects) texts in the entry field, and also sets     */
/* the position of the cursor.                                 */
/***************************************************************/
{
#ifdef IC_PM
  IEventResult evt = handle().sendEvent(EM_SETSEL,
                      IEventParameter1((unsigned short)range.lowerBound(),
                                       (unsigned short)range.upperBound()),
                      IEventParameter2(0));

  if (!(evt.asUnsignedLong()))
     ITHROWGUIERROR("EM_SETSEL");
#endif
#ifdef IC_WIN
  IEventResult evt = handle().sendEvent(EM_SETSEL,
                      IEventParameter1((int)range.lowerBound()),
                      IEventParameter2((int)range.upperBound()));
#endif
#ifdef IC_MOTIF
   unsigned long timestamp = 0 ;  // need to add this to interface
   XmTextSetSelection(
      fEntryFieldData->efHandle,            // aWidget
      range.lowerBound(),  // first char (0 based)
      range.upperBound(),
      timestamp);
#endif
}


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IEntryField::foregroundColor                                                 |
|                                                                              |
| Returns the foreground color of the IEntryField.                             |
------------------------------------------------------------------------------*/
IColor IEntryField::foregroundColor () const
{
  IGUIColor guiColor(IGUIColor::windowText);

  if (!isWriteable())
  {
    guiColor = IGUIColor(IGUIColor::outputText);
  }
  return (IWindow::color(PP_FOREGROUNDCOLOR, guiColor));
}

/*------------------------------------------------------------------------------
| IEntryField::backgroundColor                                                 |
|                                                                              |
| Returns the background color of the IEntryField.                             |
------------------------------------------------------------------------------*/
IColor IEntryField::backgroundColor () const
{
  return (IWindow::color(PP_BACKGROUNDCOLOR,
                         IGUIColor(IGUIColor::entryFieldBgnd)));
}
#endif // IC_PMWIN

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IEntryField::isDragStarting                                                  |
|                                                                              |
| Windows does not generate drag messages, so therefore it is up to a          |
| a control to decide if the conditions exist to start a drag. A drag          |
| occurs if text is selected in the entry field and a button down occurs       |
| whose position is within the selected text rectangle.                        |
|                                                                              |
| Note: if you don't want the event to continue up the owner chain,            |
|       then set the event result to true.                                     |
------------------------------------------------------------------------------*/
bool IEntryField::isDragStarting( IEvent &event )
{
  IMODTRACE_DEVELOP("IEntryField::isDragStarting");
  bool brc = false;

  switch ( event.eventId() )
    {
    case WM_LBUTTONDOWN:
      {
      ITRACE_DEVELOP("Got a left button down, start to look for drag");

      // only allow drag operation if text selected
      if (hasSelectedText())
        {
        ITRACE_DEVELOP("Has selected text...");
        // If the mouse is in the selected text, initiate the drag
        if (fEntryFieldData->pointInSelectedText(event))
          {
          IMouseClickEvent mevt( event );
          ITRACE_DEVELOP("Mouse is in selected range");
          ITRACE_DEVELOP("We have a drag" );
          // We are going to start the drag from here instead of returning true, because
          // we need to control the lifetime of the text being selected.
          event.window()->sendEvent( WM_BEGINDRAG,
               IEventParameter1((unsigned short)mevt.mousePosition().x(),
                                (unsigned short)mevt.mousePosition().y()),
               IEventParameter2( 0 ));
          selectRange(IRange(-1,0));
          }
        }
      break;
      }
    case WM_RBUTTONDOWN:
      {
      ITRACE_DEVELOP("Got a right button down, start to look for drag");

      // only allow drag operation if text selected
      if (hasSelectedText())
        {
        // If the mouse is in the selected text, initiate the drag
        if (fEntryFieldData->pointInSelectedText(event))
          {
          ITRACE_DEVELOP("Mouse is in selected range");
          if ( ::GetCapture() == NULL )
            {
            IMouseClickEvent mevt( event );
            ::SetCapture( event.handle());
            fEntryFieldData->bCheckingRightDragStart = True;
            fEntryFieldData->pointRButtonDown = mevt.mousePosition();
            }
          }
        }
      break;
      }
    case WM_RBUTTONUP:
      {
      if ( fEntryFieldData->bCheckingRightDragStart )
        {
        ::ReleaseCapture();
        SetCapture( NULL );
        fEntryFieldData->bCheckingRightDragStart = False;
        fEntryFieldData->pointRButtonDown = IPoint(0,0);
        }
      break;
      }
    case WM_MOUSEMOVE:
      {
      if ( fEntryFieldData->bCheckingRightDragStart )
        {
        ITRACE_DEVELOP("Mouse move while checking drag start");
        IMouseClickEvent mevt( event );
        IPoint mPoint( fEntryFieldData->pointRButtonDown );

        if ( abs((int)(mevt.mousePosition().x() - mPoint.x())) >
                 DD_DEFDRAGMINDIST ||
             abs((int)(mevt.mousePosition().y() - mPoint.y())) >
                 DD_DEFDRAGMINDIST )
          {
          /*-----------------------------------------
          | We are going to start the drag from here instead
          | of returning true, because we need to control
          | the lifetime of the text being selected.
          -----------------------------------------*/
          ITRACE_DEVELOP("Starting a drag" );
          ::ReleaseCapture();
          fEntryFieldData->bCheckingRightDragStart = FALSE;
          event.window()->sendEvent( WM_BEGINDRAG,
             IEventParameter1((unsigned short)mevt.mousePosition().x(),
                              (unsigned short)mevt.mousePosition().y()),
             IEventParameter2( 0 ));
          selectRange(IRange(-1,0));
          }
        }
      break;
      }
    }
  return brc;
}
#endif

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IEntryFieldData::pointInSelectedText                                         |
|                                                                              |
------------------------------------------------------------------------------*/
bool IEntryFieldData::pointInSelectedText(const IEvent& evt)
{
  IMODTRACE_DEVELOP("IEntryFieldData::pointInSelectedText");

  // Get the handle to the edit control
  IEntryField *pEditCntrl = (IEntryField *)evt.window();

  POINT pt;
  RECT rect, selRect;
  selRect.left = selRect.right = selRect.top = selRect.bottom = 0;

  IMouseClickEvent mevt( evt );

  // Get mouse position when button down
  IPoint pmPt = mevt.mousePosition();

  // convert if necessary.
  if ( ICoordinateSystem::applicationOrientation() ==
       ICoordinateSystem::originLowerLeft )
    {
    pmPt.setY(evt.window()->size().height() - mevt.mousePosition().y());
    }

  // get the range of the selected text
  IRange range = pEditCntrl->selectedRange();

  if ((IPlatform::isWin9x()) || (IPlatform::isNTNewShell()))
    {
    ITRACE_DEVELOP("Platform is Win95 or NT newshell");
    // Retrieve the zero-based character index of the character nearest the
    // mouse point on the button down.
    // Note:  This message is currently supported only in Windows 95 and NT Newshell
    IEventResult charEvt = pEditCntrl->handle().sendEvent(EM_CHARFROMPOS, 0,
        IEventData((unsigned short)pmPt.x(), (unsigned short)pmPt.y()));

    long position = (long)charEvt.number1();

    ITRACE_DEVELOP("Character position of mouse in EF: " + IString(position));
    ITRACE_DEVELOP("Range: " + IString(range.lowerBound()) + "-" +
      IString(range.upperBound()));

    // Return true if the mouse position is within the selected range
    return (range.includes(position));
    }


  if (GetClientRect(pEditCntrl->handle(), &rect))
  {
    HDC hDC = GetDC(pEditCntrl->handle());
    IString text = pEditCntrl->text();

    IString selText = pEditCntrl->selectedText();

    SIZE sizeSel, sizeLead;
    sizeSel.cx = sizeSel.cy = sizeLead.cx = sizeLead.cy = 0;
    GetTextExtentPoint32(hDC, selText, selText.length(), &sizeSel);
    IString leadingText("");
    if (range.lowerBound() > 0)
      leadingText = text.subString(0, (unsigned int)range.lowerBound());

    GetTextExtentPoint32(hDC, leadingText, leadingText.length(), &sizeLead);

    // build the selection rectangle
    selRect = rect;
    // update the left and right positions to equate to the selection rectangle
    selRect.left = sizeLead.cx;
    selRect.right = sizeLead.cx + sizeSel.cx;

    ReleaseDC(pEditCntrl->handle(), hDC);
  }

  pt.x = pmPt.x();
  pt.y = pmPt.y();
  return (PtInRect(&selRect, pt));
}
#endif

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IEntryField::setLayoutDistorted                                              |
------------------------------------------------------------------------------*/
IEntryField&  IEntryField :: setLayoutDistorted(
                                             unsigned long layoutAttributeOn,
                                             unsigned long layoutAttributeOff )
{
  if ( (layoutAttributeOn & (minimumSizeChanged | windowCreated)) &&
       (fEntryFieldData->efHandle != IWindowHandle() ))
  {
     // Calculate rest of minimum height and minimum width.
     Dimension borderWidth, marginHeight, marginWidth,
               highlightThickness, shadowThickness;
     XtVaGetValues (fEntryFieldData->efHandle,
                    XmNshadowThickness,    &shadowThickness,
                    XmNhighlightThickness, &highlightThickness,
                    XmNmarginHeight,       &marginHeight,
                    XmNmarginWidth,        &marginWidth,
                    XmNborderWidth,        &borderWidth,
                    NULL);
     fEntryFieldData->iClrestOfMinimumHeight = 2 *
                        (shadowThickness + highlightThickness +
                         marginHeight + borderWidth);
     fEntryFieldData->iClrestOfMinimumWidth = 2 *
                        (shadowThickness + highlightThickness +
                         marginWidth + borderWidth);
  }
  Inherited::setLayoutDistorted (layoutAttributeOn, layoutAttributeOff);

  return *this;
}

/*------------------------------------------------------------------------------
| IEntryField::text                                                            |
|                                                                              |
| Returns the text value of the entry field.  This is overridden in Motif to   |
| achieve correct behavior for the unreadable style.                           |
------------------------------------------------------------------------------*/
IString  IEntryField :: text() const
{
   if ( fEntryFieldData->flagsCl & IEntryFieldData::unreadable )
      {
      /***********************************************************/
      /* unreadable: return the actual value kept in this object */
      /***********************************************************/
      return fEntryFieldData->urValueCl;
      }
   else
      {
      /****************************************/
      /* not unreadable...return widget value */
      /****************************************/
      return Inherited::text();
      }
}

/*------------------------------------------------------------------------------
| ientryfmleMbcsCheck                                                          |
|                                                                              |
| This function checks for mbcs overflow in the Entry Field.                   |
| This is necessary as the setLimit method sets the maximum number of          |
| bytes the Entry Field can hold, while the Text widget used to                |
| implement the Entry Field treats the associated XmNmaxLength attribute       |
| as bytes but allows "bytes" number of characters to be inserted into the     |
| widget (hence we may overflow the underlying Text field without this check). |
|-----------------------------------------------------------------------------*/
static void ientryfmleMbcsCheck ( Widget handle,
                                  XtPointer clientdata,
                                  XtPointer calldata)
{
  int currentBytes;                /* the current length of text in bytes */
  int deltaBytes = 0;              /* change in text positions */
  int maxLength;                   /* max length of the field  */
  int charCount = 0;               /* character counter        */
  int rc;                          /* return code of mblen     */
  char *cptr;                      /* character pointer        */
  char *currentText;               /* current text in the text widget */
  XmTextVerifyCallbackStruct *cbs; /* callback structure data  */

    cbs = (XmTextVerifyCallbackStruct *)calldata;

    XtVaGetValues(handle,
                  XmNvalue, &currentText,
                  XmNmaxLength, &maxLength,
                  NULL);

    currentBytes = strlen(currentText);

    /*
     * handle range of characters being replaced.
     */
    if (cbs->endPos > cbs->startPos) {
        cptr = currentText;
        while (cbs->startPos != charCount) {
            rc = mblen(cptr, MB_CUR_MAX);
            if (rc < 0) {
                XtFree(currentText);
                cbs->doit = False;
                return;
            } else {
                cptr += rc;
            }
            ++charCount;
        }

        while (cbs->endPos != charCount) {
            rc = mblen(cptr, MB_CUR_MAX);
            if (rc < 0) {
                XtFree(currentText);
                cbs->doit = False;
                return;
            } else {
                cptr += rc;
                deltaBytes +=rc;
            }
            ++charCount;
        }
    }

    XtFree(currentText);

    if ((currentBytes - deltaBytes + cbs->text->length) > maxLength) {
        cbs->doit = False;
    }
}

/*------------------------------------------------------------------------------
| ientryfMotifCallback                                                     |
|                                                                              |
| This callback maintains state information in the Entry Field private         |
| data necessary to implement the "isChanged" function, replace mode,          |
| and the unreadable and autotab styles.  The clientdata parameter is          |
| a pointer to the private data area of the entry field object.                |
| This routine is used as an XmNvaluedChangedCallback and an                   |
| XmNmodifyVerifyCallback.                                                     |
------------------------------------------------------------------------------*/
extern void  ientryfMotifCallback( Widget handle,
                                   XtPointer clientdata,
                                   XtPointer calldata)
{
   IMODTRACE_ALL("ientryfMotifCallback");
   IEntryFieldData *fEntryFieldData = (IEntryFieldData *)clientdata;
   XmAnyCallbackStruct    *cbs = (XmAnyCallbackStruct *)calldata;

   // Get the ef IWindow from the text widget handle passed in
   IWindow* pwin = IWindow::windowWithHandle(handle);

   // Handle possible IMultiLineEdit or IComboBox.
   if (!pwin && XtIsSubclass(handle, xmTextWidgetClass) )
   {
      // If it is an MLE with scroll bars, IWindow::handle() will be the
      // scrolledWindow that is the parent of the text widget.
      Widget parent = XtParent(handle);
      pwin = IWindow::windowWithHandle( parent );

      // In the case of an edit field in a combobox, the IWindow::handle widget
      // is an XmForm that is the grandparent of the edit field.  Another
      // XmForm is the parent of the edit field.
      if (!pwin && XtIsSubclass(parent, xmFormWidgetClass) )
         pwin = IWindow::windowWithHandle( XtParent(parent) );
   }

   ITRACE_ALL(IString("handle=") + IString((unsigned long)handle).d2x() +
              IString(" pwin=") + IString((unsigned long)pwin).d2x());

   // will need to use the XmTextVerifyCallbackStructWcs in
   // conjuction with the dbcs style
   //*****aj 3/28/94: should NOT have to use XmText...Wcs. Regular one
   // works with multi-byte strings (alternative to wcs), and multi-byte
   // is a) more compact, b) the one supported in the Collection Class Lib, and
   // c) equal or better than wcs functionally. If users wish, they can deal
   // with the widget itself to get a wcs-version of the data (most won't want to).
   // This means: we only deal with XmNvalue (not XmNvalueWcs), XmNmodifyVerifyCallback
   // (not XmNmodifyVerifyCallbackWcs), etc. IApplication must do XtSetLanguageProc().

   // Interpret the callback reason to see which it is
   if (cbs->reason == XmCR_VALUE_CHANGED)
   {
      /**********************************************************/
      // Maintain the changed flag
      /**********************************************************/
      fEntryFieldData->flagsCl |= IEntryFieldData::changed;

      /**********************************************************/
      // Create and dispatch an event
      /**********************************************************/

      /**********************************************************/
      // The general mapping of Motif callback parameters
      // to IEvents is the      following:
      // handle - the widget parameter on the callback
      // eventid        - the reason of the callback
      // parameter1 - the call_data parameter ... typically the
      //               callback structure pointer
      // parameter2 - XEvent * from callback
      /**********************************************************/
      XmAnyCallbackStruct *motifEventData = (XmAnyCallbackStruct*) calldata;
      unsigned long eventID = motifEventData->reason + motifEventOffset;
      unsigned long parm1   = (unsigned long) calldata;
      unsigned long parm2   = (unsigned long) motifEventData->event;

      if ( pwin != 0 )
         {
         ITRACE_ALL(IString("pwin->handle=") +
                 IString( pwin->handle().asUnsigned()).d2x()  +
                 IString(" eventID=") + IString( eventID ).d2x()  +
                 IString(" handle=") +
                 IString( IWindowHandle(handle).asUnsigned()).d2x() );

         // Construct an IEvent from the system data.
         IEvent evt( pwin,
                     eventID,
                     parm1,
                     parm2);

         // Dispatch the window's event handler
         if ( pwin->dispatch( evt ) == True )
         {
            return;
          }
      } // if pwin

   } // if XmCR_VALUE_CHANGED

   else if (cbs->reason == XmCR_MODIFYING_TEXT_VALUE)
   {

      if (MB_CUR_MAX > 1) {
          ientryfmleMbcsCheck(handle, clientdata, calldata);
          if (((XmTextVerifyCallbackStruct *)calldata)->doit == False) {
              /* mbcs overflowed entry Field .. reject data */
              return;
          }
      }

      /**********************************************************/
      // First of all, create & dispatch an edit verify event
      /**********************************************************/
      // Retrieve the IWindow associated with the handle (Widget ID )

      /**********************************************************/
      // The general mapping of Motif callback parameters
      // to IEvents is the      following:
      // handle - the widget parameter on the callback
      // eventid        - the reason of the callback
      // parameter1 - the call_data parameter ... typically the
      //               callback structure pointer
      // parameter2 - XEvent * from callback
      /**********************************************************/
      XmTextVerifyCallbackStruct *tcbs = (XmTextVerifyCallbackStruct *)calldata;
      unsigned long eventID = tcbs->reason + motifEventOffset;
      unsigned long parm1   = (unsigned long) calldata;
      unsigned long parm2   = (unsigned long) tcbs->event;

      if ( pwin != 0 )
      {
         ITRACE_ALL(IString("pwin->handle=") +
                 IString( pwin->handle().asUnsigned() ).d2x() +
                 IString(" eventID=") + IString( eventID ).d2x() +
                 IString(" handle=") +
                   IString( IWindowHandle(handle).asUnsigned()).d2x() );

         // Construct an IEvent from the system data.
         IEvent evt( pwin,
                     eventID,
                     parm1,
                     parm2);
         // Dispatch the window's event handler
         pwin->dispatch( evt );
      } // if pwin

      if (tcbs->doit)      // if attempted change was not rejected by event handler
      {
      /**********************************************************/
      // Perform built-in processing (keep in mind, tcbs.text
      // may have been changed during event dispatch (e.g., by IEditVerifyHandlers).
      /**********************************************************/
      if ( ( fEntryFieldData->flagsCl & IEntryFieldData::replaceMode ) &&
           ( tcbs->startPos >= tcbs->endPos ) )
         {
         /**********************************************************/
         /*The XmTextVerifyCallbackStructure contains an           */
         /*XmTextPosition called endPos.  Over-write is achieved by*/
         /*incrementing this by 1. You check that the reason is    */
         /*XmCR_MODIFYING_TEXT_VALUE, increment call_data->endPos  */
         /*then leave XmText to do the rest.  If deleting text     */
         /*then we do nothing special.                             */
         /**********************************************************/
         tcbs->endPos++;
         }  //replaceMode

      if ( fEntryFieldData->flagsCl & IEntryFieldData::unreadable )
         {
         /************************************************************/
         /*Handle the unreadable style by having the widget actually */
         /*contain * and let the EntryField class keep the real data */
         /************************************************************/
         unsigned long newLength = 0;
         if ( (tcbs->text->ptr != NULL) && (tcbs->text->length > 0) )
            {
            newLength = tcbs->text->length;
            }

         if (newLength == 0)
            {
            // Delete.  Remove the characters from the real value.
            unsigned long numberDeleted = tcbs->endPos - tcbs->startPos;
            fEntryFieldData->urValueCl.remove(tcbs->startPos+1, numberDeleted);
            }
         else
            {
            // Adding characters.  Update real value
            IString newtext(tcbs->text->ptr, newLength);
            if ( tcbs->startPos > tcbs->endPos)
               {
               // replace mode
               fEntryFieldData->urValueCl.overlayWith(newtext, tcbs->startPos + 1);
               }
            else
               {
               // insert mode
//               fEntryFieldData->urValueCl.insert(newtext, tcbs->startPos+1);
               fEntryFieldData->urValueCl.insert(newtext, tcbs->startPos);      //fix: when inserting, don't adjust startPos by 1
               }

            // set value to pass back to widget
            memset(tcbs->text->ptr, '*', newLength );
            }
         }  // unreadable

      if ( fEntryFieldData->flagsCl & IEntryFieldData::autoTab )
         {
         /************************************************/
         /*Handle the autoTab style by detecting when the*/
         /*last character allowed has been entered by    */
         /*the user.                                     */
         /************************************************/
         unsigned long newLength = 0;
         if ( (tcbs->text->ptr != NULL) && (tcbs->text->length > 0) )
            {
            newLength = tcbs->text->length;
            }

         if (newLength != 0)
            {
            if (newLength + tcbs->startPos >= XmTextGetMaxLength( handle ) )
               {
               /**********************************************/
               /*An XmProcessTraversal needs to happen here. */
               /*O'Reilly VI (p505) warns of "instablity" in */
               /*the text widget during this callback, so it */
               /*might not work.                             */
               /**********************************************/
               XmProcessTraversal(
                  handle,
                  XmTRAVERSE_NEXT_TAB_GROUP);
               }
            }
         }  // autoTab
      if ( fEntryFieldData->flagsCl & IEntryFieldData::ignoreTab )
         {
         /************************************************/
         /*Handle the ignoreTab style by detecting tab   */
         /*characters as keyed in, and "eating" them,    */
         /*so the press of the tab key is ignored.       */
         /************************************************/
         if ( (tcbs->text->ptr != NULL) && (tcbs->text->length > 0) )
            {
            // efficiently handle common case: text is just one tab char
            if ( (tcbs->text->length==1) && (tcbs->text->ptr[0]=='\t') )
              tcbs->text->length = 0;    // with length set to 0, any text is ignored
            else
              {
              // don't bother unless there are some tabs present (string could be multi-meg bytes)
              if ( memchr(tcbs->text->ptr,'\t',tcbs->text->length) )
                {
                IString *str = new IString();
                int i;
                for (i = 0; i < tcbs->text->length; i++)
                   if ( tcbs->text->ptr[i] != '\t' )
                     str += tcbs->text->ptr[i];
                memcpy( tcbs->text->ptr, (char*)str, str->length() );
                tcbs->text->length = str->length();
                delete str;
                }
              }  // end else
            }  // endif ->ptr != NULL...
         }  // ignoreTab
      }  // if doit is True

   }  // if XmCR_MODIFYING_TEXT_VALUE

   return;
}

#endif // IC_MOTIF


#ifdef IC_MOTIFWIN
/*------------------------------------------------------------------------------
| IEntryField::passEventToOwner                                                |
|                                                                              |
| Returns whether or not the event can be passed up to the owner of this       |
| control.                                                                     |
------------------------------------------------------------------------------*/
bool IEntryField::passEventToOwner( IEvent& event )

{
  switch ( event.eventId() )
  {
    case WM_BUTTON1DOWN:
    case WM_BUTTON2DOWN:
    case WM_BUTTON3DOWN:
    case WM_BUTTON1UP:
    case WM_BUTTON2UP:
    case WM_BUTTON3UP:
    case WM_BUTTON1CLICK:
    case WM_BUTTON2CLICK:
    case WM_BUTTON3CLICK:
    case WM_CHORD:
    {
      event.setPassToOwner(false);
      break;
    }
#ifdef IC_MOTIF
    case xEvent(KeyPress):
    case xEvent(KeyRelease):
    {
      event.setPassToOwner(false);
      // Don't eat the enter key, we want that for default button
      // behavior, so if we have a enter key let it go up the owner
      // chain. Also let the esc key go so we can allow dismissing
      // a dialog.
      IKeyboardEvent keyEvent( event );
      if (keyEvent.isVirtual() )
      {
        if ( ( keyEvent.virtualKey() == IKeyboardEvent::enter ) ||
             ( keyEvent.virtualKey() == IKeyboardEvent::esc ) )
          event.setPassToOwner(true);
      }
      break;
    }
#endif
    default:
      Inherited::passEventToOwner( event );
      break;
  }
  // return value is ignored.
  return event.passToOwner();
}
#endif // IC_MOTIFWIN

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IEntryField::enableTextSelection                                             |
| Enable Highlighting of text in entryfield while tabbing.                     |
------------------------------------------------------------------------------*/
void IEntryField::enableTextSelection( bool selection )
{
	fgTextSelection = selection;
}
/*------------------------------------------------------------------------------
| IEntryField::IsEnabledTextSelection                                          |
| Query to check whether Highlighting of text while tabbing is set.            |
------------------------------------------------------------------------------*/
bool IEntryField::isTextSelectionEnabled( )
{
	return fgTextSelection ;
}
#endif // IC_WIN
