/* NOSHIP */  
#ifndef _ICVOBSRV_
  #define _ICVOBSRV_
/*******************************************************************************
* FILE NAME: icvobsrv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICanvasObserver                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <iobservr.hpp>


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ICanvas;
class ISetCanvas;
class IMultiCellCanvas;

#pragma enum(4)
#pragma pack(push,4)

class ICanvasObserver : public IObserver {
typedef IObserver
  Inherited;

public:

/*------------------------- Constructors -------------------------------------*/
  ICanvasObserver ( ICanvas* canvas);
virtual
 ~ICanvasObserver ( );

protected:

/*------------------------- Notification Members -----------------------------*/
virtual IObserver
 &dispatchNotificationEvent ( const INotificationEvent& event );

private:

/*----------------------------- Data -----------------------------------------*/
ICanvas *pCanvas;

}; // ICanvasObserver

class IMultiCellCanvasObserver : public  ICanvasObserver {
typedef ICanvasObserver
  Inherited;

public:
/*----------------------------------Constructors ----------------------------------*/
IMultiCellCanvasObserver ( IMultiCellCanvas *mcellcanvas);
virtual
~IMultiCellCanvasObserver ( );

protected:

/*--------------------------- Notification Members ------------------------------*/
virtual IMultiCellCanvasObserver
  &dispatchNotificationEvent ( const INotificationEvent& event );

private:
/*-----------------------------------Data------------------------------------------*/
IMultiCellCanvas *pMultiCellCanvas;

}; //IMultiCellCanvasObserver

class ISetCanvasObserver : public ICanvasObserver {
typedef ICanvasObserver
  Inherited;

public:

/*--------------------------------Constructors-------------------------------------*/
ISetCanvasObserver ( ISetCanvas *scanvas );
virtual
~ISetCanvasObserver ( );

protected :

/*--------------------------- Notification Members ------------------------------*/
virtual ISetCanvasObserver
  &dispatchNotificationEvent ( const INotificationEvent& event );

private:
/*--------------------------------------Date-------------------------------------*/
ISetCanvas *pSetCanvas;

};//ISetCanvasObserver
#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /*  _ICVOBSRV_  */
