// Revision: 97 1.1.1.3 source/ui/basectl/icvobsrv.cpp, canvas, ioc.v400, 001030 
#ifndef _ICVOBSRV_CPP_
#define _ICVOBSRV_CPP_
/*******************************************************************************
* FILE NAME: icvobsrv.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icvobsrv.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <icvobsrv.hpp>
#include <iobservr.hpp>
#include <imcelcvl.hpp>
#include <imcelcv.hpp>
#include <isetcv.hpp>

ICanvasObserver :: ICanvasObserver ( ICanvas* canvas )
 :ICanvasObserver :: Inherited ( ),
  pCanvas( canvas )
{ }

ICanvasObserver :: ~ICanvasObserver ( )
{ }

IObserver&   ICanvasObserver::dispatchNotificationEvent( const INotificationEvent & anEvent )
{
  INotificationId id(anEvent.notificationId());

  if ( ( id == IWindow::attributeAddReplaceId) ||
       ( id == IWindow::attributeRemoveId) )
  {
    IWindow& window = (IWindow&)anEvent.notifier();
    if ( window.parent() == (IWindow*)pCanvas )
    {
    
       pCanvas->setLayoutDistorted(IWindow::layoutChanged |
                                   IWindow::immediateUpdate, 0);
    }
  }
  return *this;
}

IMultiCellCanvasObserver :: IMultiCellCanvasObserver ( IMultiCellCanvas *mcelcanvas)
    :IMultiCellCanvasObserver :: Inherited ( mcelcanvas )
    , pMultiCellCanvas ( mcelcanvas )
{ }
 
IMultiCellCanvasObserver :: ~IMultiCellCanvasObserver ( )
{ }

IMultiCellCanvasObserver& IMultiCellCanvasObserver :: dispatchNotificationEvent ( const INotificationEvent& anEvent )
{
  INotificationId id(anEvent.notificationId());
  // Check the notification for IMultiCellCanvas's ChildWindow
  // If it is, send the notification to the particular Child Window
  if ( id == IWindow::deleteId )
  {
  	IWindow& window = (IWindow&)anEvent.notifierAddress().notifier();
  	pMultiCellCanvas->removeFromCell(&window);
  }
  else
  	Inherited :: dispatchNotificationEvent(anEvent);
  return *this;
 }
 
 ISetCanvasObserver :: ISetCanvasObserver ( ISetCanvas *scanvas )
    :ISetCanvasObserver :: Inherited ( scanvas )
    , pSetCanvas ( scanvas )
  { }
  ISetCanvasObserver :: ~ISetCanvasObserver ( )
  { }
   
#endif // _ICVOBSRV_CPP_

