// Revision: 57 1.5.1.8 source/ui/basectl/icombovw.hpp, listctls, ioc.v400, 001006 
#ifndef _ICOMBOVW_
  #define _ICOMBOVW_
/*******************************************************************************
* FILE NAME: icombovw.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICollectionViewComboBox                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <icombobs.hpp>
#include <istrgen.hpp>
#include <icolobsv.hpp>
#include <irect.hpp>
#include <inotify.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IWindowHandle;
template <class Element, class Collection> class ICollectionViewComboBoxData;

#pragma define(ISequence <unsigned long > )

typedef IBaseComboBox
  Inherited;

#pragma enum(4)
#pragma pack(push,4)

template <class Element, class Collection>
  class ICollectionViewComboBox : public IBaseComboBox
{
public:
/*------------------------- Constructors -------------------------------------*/
  ICollectionViewComboBox ( unsigned long                    identifier,
                            IWindow*                         parent,
                            IWindow*                         owner,
                            const IRectangle&                initial =
                               IRectangle  ( ),
                            const IBaseComboBox::Style&      style   =
                               IBaseComboBox::defaultStyle( ),
                            const IStringGenerator<Element>& stringGenerator =
                               IStringGenerator<Element>( ) );

#ifdef IC_PMWIN
  ICollectionViewComboBox ( unsigned long                    identifier,
                            IWindow*                         parent,
                            const IStringGenerator<Element>& stringGenerator =
                               IStringGenerator<Element>( ) );

  ICollectionViewComboBox ( const IWindowHandle&             handle,
                            const IStringGenerator<Element>& stringGenerator =
                               IStringGenerator<Element>( ) );
#endif //IC_PMWIN

virtual
 ~ICollectionViewComboBox ( );


/*------------------------- Collection ---------------------------------------*/
virtual Collection
 *items                   ( ) const;

virtual ICollectionViewComboBox<Element,Collection>
 &setItems                ( Collection* collection );

/*------------------------- String Generator ---------------------------------*/
virtual IStringGenerator<Element>
 &setStringGenerator      ( const IStringGenerator<Element>& stringGenerator );

virtual IStringGenerator<Element>
 &stringGenerator         ( );

/*------------------------- Collection-Reporting Protocol --------------------*/
virtual ICollectionViewComboBox<Element,Collection>
 &elementChanged             ( unsigned long   position,
                               const Element&  element  ),
 &elementAdded               ( unsigned long   position,
                               const Element&  element  ),
 &elementDeleted             ( unsigned long   position ),
 &elementsChanged            ( ),
 &collectionReplaced         ( );

/*------------------------- Selection ----------------------------------------*/
static const unsigned long
  noSelection;

virtual ICollectionViewComboBox<Element, Collection>
 &select                     ( unsigned long   collectionPosition,
                               bool         select = true ),
 &deselect                   ( unsigned long   collectionPosition );

virtual Element
  selectedElement            ( ) const;

virtual unsigned long
  selectedCollectionPosition ( );


private:
/*------------------------- Hidden Members -----------------------------------*/
  ICollectionViewComboBox
             ( const ICollectionViewComboBox< Element, Collection > & source );
ICollectionViewComboBox<Element,Collection>
 &operator=  ( const ICollectionViewComboBox< Element, Collection > & source );

/*------------------------- Private ------------------------------------------*/
ICollectionViewComboBoxData<Element, Collection>
 *fCollectionViewComboBoxData;

unsigned long
  insert     ( unsigned long    index,
               const char*      text  ),
  deleteItem ( unsigned long    index );

ICollectionViewComboBox<Element, Collection>
 &deleteAll  ( );

}; // ICollectionViewComboBox<Element,Collection>

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if ! defined(__TEMPINC__)
#include <icombovw.c>
#endif

#endif // _ICOMBOVW_
