// Revision: 53 1.5.1.5 source/ui/basectl/icombobx.cpp, listctls, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: icombobx.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icombobx.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481424 )

/**********************************************************************/
/* Need IC_USE_CB defined before iwindefs since Windows macros are    */
/* different if processing listboxes that are part of comboboxes      */
/**********************************************************************/
extern "C" {
  #define INCL_WINENTRYFIELDS       // ES_xxx, CBS_xxx
  #define INCL_WINERRORS            // PMERR_HEAP_MAX_SIZE_REACHED
  #define INCL_WINLISTBOXES         // LS_HORZSCROLL
  #define INCL_NLS                  // ES_ANY, ES_SBCS, ES_DBCS, ES_MIXED
  #define INCL_WINWINDOWMGR         // WinQueryClassName
  #define INCL_WINSYS               // SV_CYBORDER
  #define INCL_GPICONTROL           // From ILISTBX2.HPP
  #define INCL_GPILCIDS             //
  #define INCL_GPILOGCOLORTABLE     //
  #define INCL_GPIPRIMITIVES        //

  #include <iwindefs.h>
  #include <icombobx.h>
  #include <stdlib.h>            // atoi
  #include <string.h>
}

#ifdef IC_MOTIF
  #include <Xm/List.h>
  #include <Xm/Form.h>
  #include <Xm/Text.h>
  #include <Xm/ArrowB.h>
  #include <Xm/ScrolledW.h>
#endif

#include <inotifev.hpp>
#include <icombobx.hpp>
#include <icmbxprv.hpp>
#include <iapp.hpp>
#include <icconst.h>
#include <icoordsy.hpp>
#include <iexcept.hpp>
#include <ifont.hpp>
#include <ihandle.hpp>
#include <ilistbox.hpp>
#include <imphdr.hpp>
#include <ireslib.hpp>
#include <istring.hpp>
#include <itrace.hpp>

#ifdef IC_MOTIF
  #include <ilistprv.hpp>
#endif
// Segment definitions
#ifdef IC_PAGETUNE
  #define _ICOMBOBX_CPP_
  #include <ipagetun.h>
#endif

/******************************************************************************/
/* Public entry field styles.                                                 */
/******************************************************************************/
const IComboBox::Style
#ifdef IC_WIN
  IComboBox::classDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE | CBS_AUTOHSCROLL),
                                 IES_ANYDATA | WS_EX_CLIENTEDGE );
#endif
#ifdef IC_PM
  IComboBox::classDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE),
                                 IES_ANYDATA );
#endif
#ifdef IC_MOTIF
  IComboBox::classDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE ),
                                 IES_ANYDATA );
#endif


/******************************************************************************/
/* Default style for new objects (initial value)                              */
/******************************************************************************/
IComboBox::Style
#ifdef IC_WIN
  IComboBox::currentDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE | CBS_AUTOHSCROLL),
                                   IES_ANYDATA | WS_EX_CLIENTEDGE );
#endif
#ifdef IC_PM
  IComboBox::currentDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE),
                                   IES_ANYDATA );
#endif
#ifdef IC_MOTIF
  IComboBox::currentDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE ),
                                   IES_ANYDATA );
#endif

#ifdef IC_WIN
class IComboBoxData
{
  public:
  IComboBoxData();
  ~IComboBoxData();
  
  unsigned long largestStringSize (IComboBox* comboBox );
  unsigned long fLargestStringSize; 
};
#endif

/*------------------------------------------------------------------------------
| IComboBox::IComboBox                                                         |
|                                                                              |
| Construct an IComboBox on an IWindow.                                        |
------------------------------------------------------------------------------*/
IComboBox::IComboBox( unsigned long id,
                      IWindow* pParent,
                      IWindow* pOwner,
                      const IRectangle& rectInit,
                      const Style& style) :
                      fComboBoxData( 0 ),
                      IBaseComboBox( id,
                                     pParent,
                                     pOwner,
                                     rectInit,
                                     (const IBaseComboBox::Style&) style )
{
#ifdef IC_WIN
  fComboBoxData = new(IComboBoxData);
#endif
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IComboBox::IComboBox                                                         |
|                                                                              |
| Construct an IComboBox on a dialog.                                          |
------------------------------------------------------------------------------*/
IComboBox::IComboBox( unsigned long id, IWindow* parent) :
                      fComboBoxData( 0 ),
                      IBaseComboBox( id, parent )
{
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IComboBox::IComboBox                                                         |
|                                                                              |
| Construct an IComboBox from an existing IComboBox.                           |
------------------------------------------------------------------------------*/
IComboBox::IComboBox( const IWindowHandle& handle) :
                      fComboBoxData( 0 ),
                      IBaseComboBox( handle )
{
#ifdef IC_WIN
  fComboBoxData = new(IComboBoxData);
#endif
}
#endif

/*------------------------------------------------------------------------------
| IComboBox::~IComboBox                                                        |
|                                                                              |
| Reomve the default mouse pointer handler.                                    |
------------------------------------------------------------------------------*/
IComboBox :: ~IComboBox()
{
#ifdef IC_PMWIN
  IMousePointerHandler::defaultHandler()->stopHandlingEventsFor(this);
#ifdef IC_WIN
  delete fComboBoxData;
#endif
#endif
}

/*------------------------------------------------------------------------------
| IComboBox::defaultStyle                                                      |
------------------------------------------------------------------------------*/
IComboBox::Style  IComboBox::defaultStyle ( )
{
  return currentDefaultStyle;
}

/*------------------------------------------------------------------------------
| IComboBox::setDefaultStyle                                                   |
------------------------------------------------------------------------------*/
void IComboBox::setDefaultStyle ( const Style& style )
{
  currentDefaultStyle = style;
}

#ifdef IC_WIN
IComboBoxData::IComboBoxData()
{ 
  fLargestStringSize = 0; 
}
IComboBoxData::~IComboBoxData()
{}
  
unsigned long IComboBoxData::largestStringSize (IComboBox* comboBox )
{
  IBaseComboBox::Cursor theCursor(*comboBox, IBaseComboBox::Cursor::allItems);
  unsigned long largest = 0,itemSize = 0;
  IFont tempFont = comboBox->font();
  theCursor.setToFirst();
  while (theCursor.isValid())
  {    
    itemSize = tempFont.textWidth(comboBox->itemText(theCursor.asIndex()) );
     if (itemSize  > largest)
        largest = itemSize;
     theCursor.setToNext();
  }
  return largest;
}
#endif //IC_WIN

#include <ilistbx4.hpp>
