// Revision: 43 1.4.2.1 source/ui/basectl/icmnfun.cpp, control, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: icmnfun.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icmnfun.hpp.                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/


extern "C"
{
  #define INCL_WINFRAMEMGR               // WM_QUERYFOCUSCHAIN.
  #define INCL_WINWINDOWMGR              // QWS_FLAGS.
  #define INCL_WINBUTTONS                // BM_ messages
  #include <iwindefs.h>
}

#include <icmnfun.hpp>
#include <icolor.hpp>
#include <ievtdata.hpp>
#include <iexcept.hpp>
#include <ihandle.hpp>
#include <itrace.hpp>
#include <istring.hpp>
#include <iwindow.hpp>
#include <iframe.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _ICMNFUN_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_WIN
void DrawTrackRect (HDC hdc, LPRECT lprc);
#endif

/*------------------------------------------------------------------------------
| defaultbackgroundcolor                                                       |
|                                                                              |
| Determine the background color to use for the specified window,              |
| assuming that none has explicitly been assigned (choose between the          |
| system window background and system dialog background colors).               |
------------------------------------------------------------------------------*/
IColor defaultbackgroundcolor ( IWindowHandle hwndmain )
{
  IColor clrBackground = IGUIColor( IGUIColor::windowBgnd );
                                  // Default to system window background.
#ifdef IC_PMWIN
  /******************************************************************/
  /* The default background color will be based on the type of      */
  /* frame window we are sitting on (dialog background if the frame */
  /* is supposed to look like a dialog box, window background       */
  /* otherwise).                                                    */
  /******************************************************************/
  // Find the frame window.
  IEventResult mr = hwndmain.sendEvent( WM_QUERYFOCUSCHAIN,
                                        IEventParameter1( QFC_FRAME ),
                                        IEventParameter2( 0 ));
#ifdef IC_WIN
  if (mr.asUnsignedLong())
     {
     IFrameWindow* frame =
        (IFrameWindow*) IWindow::windowWithHandle( IWindowHandle((HWND)mr) );
     if ((frame) && frame->usesDialogBackground() )
        clrBackground = IGUIColor( IGUIColor::dialogBgnd );
     }
#endif
#ifdef IC_PM
  IWindowHandle frame( mr.asUnsignedLong() );

  if ( frame  &&
       (IQUERYWINDOWUSHORT( frame, QWS_FLAGS ) & 0x100) )
  {           // Frame looks like a dialog box.
     clrBackground = IGUIColor( IGUIColor::dialogBgnd );
  }
#endif //IC_PM
#endif // IC_PMWIN
  return clrBackground;
}


#ifdef IC_WIN
/*------------------------------------------------------------------------------
| WinTrackRect                                                                 |
| This function lifted from cclnt\cnr\cnrs3p1.c.  It is an incomplete          |
| implementation of the PM function of the same name.  This version is         |
| designed specifically for use in the split canvas handler.                   |
------------------------------------------------------------------------------*/
int WinTrackRect (HWND hwnd, void* , PTRACKINFO lpTrackInfo)
{
  HWND    hwndFocus = GetFocus ();
  BOOL    fTrack = TRUE;
  RECT    rcTrack, rcBoundary;
  POINT   ptCursor;
  int     xLast, yLast;
  MSG     msg;
  HDC     hdc;
  DWORD   wQuitMessage;
  HBITMAP hbmHalftone;
  HBRUSH  hbrshHalftone;
  static  WORD wHalftoneBits[] = { 0xAA, 0x55, 0xAA, 0x55,
                                   0xAA, 0x55, 0xAA, 0x55 };

  if (!(hdc           = GetWindowDC (hwnd))                               ||
      !(hbmHalftone   = CreateBitmap (8, 8, 1, 1, (LPSTR) wHalftoneBits)) ||
      !(hbrshHalftone = CreatePatternBrush (hbmHalftone)))
  {
    if (hdc)          ReleaseDC (hwnd, hdc);
    if (hbmHalftone)  DeleteObject (hbmHalftone);
    return (FALSE);
  }

  /*-----------------------------------------------------------*/
  /* figure out which button will signal the end of the drag;  */
  /* if more than one button is pressed, the left takes        */
  /* precedence, followed by the right, followed by the middle */
  /*-----------------------------------------------------------*/
  wQuitMessage = (GetKeyState (VK_LBUTTON) < 0) ? WM_LBUTTONUP :
                 (GetKeyState (VK_RBUTTON) < 0) ? WM_RBUTTONUP :
                                                  WM_MBUTTONUP;

  /*------------------------------------------------------*/
  /* get the current mouse position in window coordinates */
  /* (we're overloading rcTrack here, but it saves stack) */
  /*------------------------------------------------------*/
  GetCursorPos (&ptCursor);
  GetWindowRect (hwnd, &rcTrack);
  xLast = (int)(ptCursor.x - rcTrack.left);
  yLast = (int)(ptCursor.y - rcTrack.top);

  /*------------------------------------------------*/
  /* make a working copy of the tracking rectangles */
  /*------------------------------------------------*/
  rcTrack    = lpTrackInfo->rclTrack;

  /*-----------------------------------------------------------------*/
  /* make sure the mouse doesn't move outside the boundary rectangle */
  /*-----------------------------------------------------------------*/
  ITRACE_ALL(IString("lpTrackInfo->rclBoundary=(") +
             IString( lpTrackInfo->rclBoundary.left) + IString(",") +
             IString( lpTrackInfo->rclBoundary.top) + IString(",") +
             IString( lpTrackInfo->rclBoundary.right) + IString(",") +
             IString( lpTrackInfo->rclBoundary.bottom) + IString(")") );
  /* Convert the boundary rectangle to screen coordinates for the */
  /* ClipCursor function.                                         */
  rcBoundary.left   = lpTrackInfo->rclBoundary.left +
                      (ptCursor.x - xLast);
  rcBoundary.right  = lpTrackInfo->rclBoundary.right +
                      (ptCursor.x - xLast);
  rcBoundary.top    = lpTrackInfo->rclBoundary.top +
                      (ptCursor.y - yLast);
  rcBoundary.bottom = lpTrackInfo->rclBoundary.bottom +
                      (ptCursor.y - yLast);
  ITRACE_ALL(IString("rcBoundary=(") +
             IString( rcBoundary.left) + IString(",") +
             IString( rcBoundary.top) + IString(",") +
             IString( rcBoundary.right) + IString(",") +
             IString( rcBoundary.bottom) + IString(")") );

  SetCapture (hwnd);
  ClipCursor (&rcBoundary);

  hbrshHalftone = (HBRUSH) SelectObject( hdc, hbrshHalftone );
  DrawTrackRect (hdc, &rcTrack);

  while (fTrack &&
         (GetFocus() == hwndFocus) &&
         (GetCapture() == hwnd)    &&
         GetMessage (&msg, 0, 0, 0))
  {
    if (msg.message == wQuitMessage)  fTrack = FALSE;

    else switch (msg.message)
    {
      /*-----------------------*/
      /* eat keyboard messages */
      /*-----------------------*/
      case WM_CHAR:
      case WM_KEYUP:
      case WM_KEYDOWN:
      case WM_SYSCHAR:
      case WM_SYSKEYUP:
      case WM_SYSKEYDOWN:
        if (msg.wParam == VK_ESCAPE)  fTrack = FALSE;
        break;

      case WM_MOUSEMOVE:
        {
           int  xDelta = LOWORD (msg.lParam) - xLast;
           int  yDelta = HIWORD (msg.lParam) - yLast;
           ITRACE_ALL(IString("xDelta=") + IString(xDelta)+
                      IString(" x=") + IString(LOWORD (msg.lParam))+
                      IString(" xLast=") + IString(xLast)+
                      IString(" yDelta=") + IString(yDelta)+
                      IString(" y=") + IString(HIWORD (msg.lParam))+
                      IString(" yLast=") + IString(yLast) );
           ITRACE_ALL(IString("rcTrack=(") +
                      IString( rcTrack.left) + IString(",") +
                      IString( rcTrack.top) + IString(",") +
                      IString( rcTrack.right) + IString(",") +
                      IString( rcTrack.bottom) + IString(")") );

           /* Update actual position of cursor */
           xLast += xDelta;
           yLast += yDelta;

           /* Determine amount of movement we can allow and still stay */
           /* within the boundary.                                     */
           if (xDelta > 0)
           {
              if (rcTrack.right + xDelta > lpTrackInfo->rclBoundary.right)
                 xDelta = lpTrackInfo->rclBoundary.right - rcTrack.right;
           }
           else
           {
              if (rcTrack.left + xDelta < lpTrackInfo->rclBoundary.left)
                 xDelta = lpTrackInfo->rclBoundary.left - rcTrack.left;
           }
           if (yDelta > 0)
           {
              if (rcTrack.bottom + yDelta > lpTrackInfo->rclBoundary.bottom)
                 yDelta = lpTrackInfo->rclBoundary.bottom - rcTrack.bottom;
           }
           else
           {
              if (rcTrack.top + yDelta < lpTrackInfo->rclBoundary.top)
                 yDelta = lpTrackInfo->rclBoundary.top - rcTrack.top;
           }

           /*-------------------*/
           /* erase, move, draw */
           /*-------------------*/
           DrawTrackRect (hdc, &rcTrack);
           OffsetRect (&rcTrack, xDelta, yDelta);
           DrawTrackRect (hdc, &rcTrack);
           ITRACE_ALL(IString("rcTrack=(") +
                      IString( rcTrack.left) + IString(",") +
                      IString( rcTrack.top) + IString(",") +
                      IString( rcTrack.right) + IString(",") +
                      IString( rcTrack.bottom) + IString(")") );
        }
        break;

      /*---------------------------------*/
      /* eat other mouse button messages */
      /*---------------------------------*/
      case WM_LBUTTONUP:
      case WM_MBUTTONUP:
      case WM_RBUTTONUP:
      case WM_LBUTTONDOWN:
      case WM_MBUTTONDOWN:
      case WM_RBUTTONDOWN:
      case WM_LBUTTONDBLCLK:
      case WM_MBUTTONDBLCLK:
      case WM_RBUTTONDBLCLK:
        break;

      default:
        DispatchMessage (&msg);
        break;
    }
  }

  /*----------------------------------------------------------------------*/
  /* if we fell out of the loop because GetMessage returned FALSE         */
  /* (i.e. PostQuitMessage was called), put the WM_QUIT back on the queue */
  /*----------------------------------------------------------------------*/
  if (fTrack && (GetFocus() == hwndFocus) && (GetCapture() == hwnd))
  {
    PostQuitMessage (msg.wParam);
  }

  DrawTrackRect (hdc, &rcTrack);
  ClipCursor (NULL);
  ReleaseCapture ();

  DeleteObject (SelectObject (hdc, hbrshHalftone));
  DeleteObject (hbmHalftone);
  ReleaseDC (hwnd, hdc);

  /*---------------------------------------*/
  /* if the user pressed ESC, return FALSE */
  /*---------------------------------------*/
  if ((msg.message == WM_KEYDOWN) && (msg.wParam == VK_ESCAPE))
  {
    return (FALSE);
  }
  /*---------------------------------------*/
  /* otherwise return the drop coordinates */
  /*---------------------------------------*/
  else
  {
    lpTrackInfo->rclTrack = rcTrack;
    return (TRUE);
  }
}

void DrawTrackRect (HDC hdc, LPRECT lprc)
{
  PatBlt (hdc, (int)lprc->left, (int)lprc->top, (int)(lprc->right - lprc->left),
               (int)(lprc->bottom - lprc->top), PATINVERT);
}
#endif  //IC_WIN

/*------------------------------------------------------------------------------
| clickButton                                                                  |
| This function is used to click buttons on Windows.                           |
------------------------------------------------------------------------------*/
void clickButton(const IWindowHandle& buttonHandle)
{
#ifdef IC_PMWIN
    buttonHandle.sendEvent(BM_CLICK);
#endif
#ifdef IC_MOTIF
  XtCallActionProc(buttonHandle, "ArmAndActivate", NULL, NULL, 0);
#endif

}

