// Revision: 42 1.8.1.5 source/ui/basectl/icmbxprv.hpp, listctls, ioc.v400, 980930  
/* NOSHIP */
#ifndef _ICMBXPRV_
  #define _ICMBXPRV_
/*******************************************************************************
* FILE NAME: icmbxprv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IBaseComboBoxData - This class encapsulates private data and functions   *
*                        used by the IBaseComboBox class.  An object of this   *
*                        class is created in the IBaseComboBox constructors.   *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C"
{
  #include <iwindefs.h>
}
#include <ibase.hpp>
#include <ihandle.hpp>

#ifdef IC_MOTIF
  #include <ilistprv.hpp>
#endif
#ifdef IC_WIN
  #include <ibrushdr.hpp>
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBaseComboHandler;
class IBaseKeyboardHandler;
class IBaseShowListHandler;
class IBaseResizeHandler;
#ifdef IC_MOTIF
	class IListResizeHandler;
#endif

#pragma enum(4)
#pragma pack(push,4)

class IBaseComboBoxData
{
/*******************************************************************************
* The IBaseComboBoxData class encapsulates private data and functions used by the  *
* IBaseComboBox class.  An object of this class is created in the IBaseComboBox        *
* constructors.                                                                *
*******************************************************************************/
public:
  IBaseComboBoxData();

virtual
 ~IBaseComboBoxData();

  unsigned long    minimumRows,
                   minimumCharacters;

#ifdef IC_WIN
  unsigned long    charLimit;
  IBrushHandler
    fBrushHandler;
  Boolean bChangedFlag;
#endif

#ifdef IC_PMWIN
//  Returns the handle of the entry field part of a combo box
static IWindowHandle
   handleOfEntryField(const IWindowHandle& combobox );

IWinProc*
  fdefaultEntryProc; // Default procedure for Entry field part of combo
IWindowHandle
  fentryHandle;      // handle of the entry field
#endif //IC_PMWIN

#ifdef IC_MOTIF
static IWindowHandle listBoxHandle (const IBaseComboBox& comboBox);

static IWindowHandle textHandle (const IBaseComboBox& comboBox);

void registerCallbacks(IBaseComboBox* comboBox);
void unregisterCallbacks(IBaseComboBox* comboBox);

friend void _System icbDropDownCallback (Widget w,
                                         void *client_data,
                                         void *call_data );

friend void _System icbLosingFocusCallback (Widget w,
                                            void *client_data,
                                            void *call_data );

IWindowHandle
  arrowButton, listBox;
IBaseComboBox::ControlType
  comboBoxType;
IPair::Coord
  comboHeight, entryHeight;
bool
  listShowing;
IItemHandlesList
  *itemHandlesList;
IWindowHandle
  efHandle;
Widget
  shell;
XtWorkProcId
  workProcId;
bool
  ignoreFocusOut,
  pendingFocusOut;
#endif  //IC_MOTIF
IBaseComboHandler*
  pdefaultHandler;
IBaseKeyboardHandler*
	pBaseKeyboardHandler;

#ifdef IC_MOTIF
 IListResizeHandler*
	 pListResizeHandler;
 friend class  IListResizeHandler;
#endif

#ifdef IC_PM
 ISize maxComboSize;
 bool flagBaseShowListHandlerResized;
 IBaseShowListHandler* pBaseShowListHandler;  
 IBaseResizeHandler* pBaseResizeHandler;  
#endif

private:

friend class IBaseComboHandler;
friend class IBaseKeyboardHandler;
friend class IBaseShowListHandler;
friend class IBaseResizeHandler;

IBaseComboBoxData::IBaseComboBoxData (const IBaseComboBoxData&);
IBaseComboBoxData& operator= (const IBaseComboBoxData&);
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICMBXPRV_ */
