// Revision: 38 1.5.2.1 source/ui/basectl/icctlsta.cpp, control, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: icctlsta.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icctlsta.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

extern "C"
  {
  #define INCL_WINWINDOWMGR
  #include <iwindefs.h>
  #ifdef IC_WIN
    #include <iclccl.h>
    #include <iclcnrw.h>
    #include <iclnbw.h>
    #include <iclsldw.h>
    #include <iclspbw.h>
  #endif
  }

#include <icctlsta.hpp>
#include <iexcept.hpp>
#include <istring.hpp>
#include <itrace.hpp>
#include <ireslib.hpp>     //jad icl2_7576

// Segment definitions
#ifdef IC_PAGETUNE
  #define _ICCTLSTA_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_WIN
// only need this code in Windows

HMODULE IControlStatics::controlDynLinkLib = 0;

IS32to16SendMessage IControlStatics::lpfn32to16SendMessage = 0;
IS32to16PostMessage IControlStatics::lpfn32to16PostMessage = 0;
IS16to32Message     IControlStatics::lpfn16to32Message = 0;

/*------------------------------------------------------------------------------
| IControlStatics::loadControlDLL                                              |
------------------------------------------------------------------------------*/
HMODULE IControlStatics::loadControlDLL ( )
{
  if (!controlDynLinkLib)
  {
    MEMORY_BASIC_INFORMATION mbi;
    VirtualQuery( &controlDynLinkLib, &mbi, sizeof(mbi) );

    // Retrieve the name of the UI DLL (or static linked EXE)
    char filename[260];
//  GetModuleFileName( mbi.AllocationBase, filename, 260 );  $HT!d
    GetModuleFileName( (HMODULE) mbi.AllocationBase, filename, 260 ); // $HT!c
    IString temp(filename);

    // Parse out just the filename (without extension)
    IString justFile = temp.subString( temp.lastIndexOfAnyOf( ":\\" )+1 );

    // Create string with default name
    temp = ICL_DLL;

    // Build a compound string using the first 4 characters of the
    // loading executable (the UI .dll or an .exe file containing this code)
    // and the rest of the name from the controls DLL.
    justFile = justFile.subString( 1,4 ) + temp.subString( 5 );

    // NOTE: Using native APIs here instead of IDynamicLinkLibrary class
    // to avoid try/catch block which would write trace information out to
    // file on retry case (which customers don't like if no error occurred).
    // Suppress the error message box that appears when the dll load fails
    unsigned int uiErrorMode = SetErrorMode( SEM_FAILCRITICALERRORS );

    // Now try and open the newly named controls DLL
    HMODULE hmod = LoadLibrary( justFile );

    // If it fails, then retry with the original name (but only if different)
    if (hmod == 0)
    {
      bool bDifferent = ( temp != justFile );
      if ( bDifferent )
        hmod = LoadLibrary( temp );

      // If it still fails or the filenames are the same, throw exception
      if ((hmod == 0) || !bDifferent)
      {
        SetErrorMode( uiErrorMode );
        ITHROWGUIERROR2( IString("LoadLibrary : ") + temp,
                         IBaseErrorInfo::accessError,
                         IException::recoverable );
      }
    }
    // Restore error message box for system
    SetErrorMode( uiErrorMode );

    // Get entry points from module for specific APIs
    controlDynLinkLib = hmod;
    lpfn32to16SendMessage = (IS32to16SendMessage)
                GetProcAddress( hmod, "DllS32to16SendMessage" );
    lpfn32to16PostMessage = (IS32to16PostMessage)
                GetProcAddress( hmod, "DllS32to16PostMessage" );
    lpfn16to32Message = (IS16to32Message)
                GetProcAddress( hmod, "DllS16to32Message" );
  }
  return controlDynLinkLib;
}
#endif  // IC_WIN


// jad 6-4-96 (icl2_7576) - rest of file
#ifdef IC_PM
// only need this code for PM

IDynamicLinkLibrary*      IControlStatics::mmctlDynLinkLib             = 0;
IRegisterCircularSlider*  IControlStatics::entryRegisterCircularSlider = 0;

/*------------------------------------------------------------------------------
| IControlStatics::registerCircularSlider                                      |
------------------------------------------------------------------------------*/
bool IControlStatics::registerCircularSlider()
{
  IMODTRACE_DEVELOP("IControlStatics::registerCircularSlider");

  HAB hab = WinQueryAnchorBlock(HWND_DESKTOP);
  CLASSINFO classInfo;

  // Before registering, check to make sure it is not already registered.
  bool fRegistered = WinQueryClassInfo( hab, WC_CIRCULARSLIDER, &classInfo);

//jad 9-26-97  if (!fRegistered)
//jad 9-26-97    {
    // Load the MM controls dll
    if (!mmctlDynLinkLib)
        mmctlDynLinkLib = new IDynamicLinkLibrary("sw");

    if (!entryRegisterCircularSlider)
        entryRegisterCircularSlider =
            (IRegisterCircularSlider*)mmctlDynLinkLib->procAddress("WinRegisterCircularSlider");
//jad 9-26-97    }

  return (*entryRegisterCircularSlider)();
}
#endif  // IC_PM
