// Revision: 11 1.12.2.3 source/ui/baseapp/iwinlsts.hpp, basewin, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IWINLSTS_
#define _IWINLSTS_
/*******************************************************************************
* FILE NAME: iwinlsts.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of classes that are used to              *
*   manage the collection of windows and the collection of handlers.           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ireslock.hpp>
#include <iseq2.h>
#include <ikshsh2.h>
#include <iss2.h>
#include <iwindow.hpp>
#include <ingthrdp.hpp>
#include <iobservr.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IThreadId;
class IWindowThreadDataList;
class ITheDesktopWindow;
class ITheObjectWindow;
class IDataHandleSet;

#pragma enum(4)
#pragma pack(push,4)

/*------------------------------------------------------------------------------
| IHandlerListObject class                                                     |
------------------------------------------------------------------------------*/
class IHandlerListObject  {
public:
  IHandlerListObject ( IHandler* handler=0 );
 ~IHandlerListObject ();
  IHandlerListObject ( const IHandlerListObject& object );
IHandlerListObject
  &operator= ( const IHandlerListObject& object );
bool operator< ( const IHandlerListObject& object )  const
   {  return fHandler < object.fHandler; }
bool operator== ( const IHandlerListObject& object ) const
   {  return fHandler == object.fHandler; }
IHandler
 *fHandler;
bool
  fRemovePending;
};

/*------------------------------------------------------------------------------
| IHandlerList class                                                           |
------------------------------------------------------------------------------*/
class IHandlerList : public ISequence<IHandlerListObject> {
public:
  IHandlerList ();
 ~IHandlerList();

IHandlerList::Cursor
  fcursor;

unsigned long
  totalHandlers,
  maxHandlers;
}; // IHandlerList

/*------------------------------------------------------------------------------
| IWindowList class                                                            |
------------------------------------------------------------------------------*/
class IWindowList : public IVPtrKeySetAsHshTable<IWindow*, unsigned long> {
public:
  IWindowList ( );
 ~IWindowList ( );

#ifdef IC_DEVELOP
static void
  incrementEventCount ( )
  { totalEvents++; }
static void
  incrementWindowAddedCount ( )
  { totalWindowsAdded++; }
static void
  incrementWindowDeletedCount ( )
  { totalWindowsDeleted++; }
static void
  incrementCacheCount ( )
  { cacheUsedCount++; }
static void
  dump ( );
#endif

static IWindowList
 *listForThread ( const IThreadId& threadId ),
 *current       ( );

static IPrivateResource
 &libraryKey ( );

#ifdef IC_DEVELOP
static unsigned long
  totalEvents,
  totalWindowsAdded,
  totalWindowsDeleted,
  cacheUsedCount;
#endif
}; // IWindowList

/*------------------------------------------------------------------------------
| hash                                                                         |
------------------------------------------------------------------------------*/
inline unsigned long hash(unsigned long const& key, unsigned long size)
{
#ifdef IC_WIN
   // hwnds usually (always?) even.  Shift right then return modulo size.
   return (key >> 1) % size;
#else
   return key % size;
#endif

}

#ifdef IC_WIN
class IDialogControl  {
/*******************************************************************************
  This class represents controls in a dialog.

  In Windows, native dialog navigation depends on a function
  (IsDialogMessage) being called in the event loop.  This function requires
  that the window handle of the dialog be known to call it.  This generally
  conflicts with the class library model of making application frame windows
  and dialog windows basically interchangable.  Therefore, we don't call
  this function in the event loop ( IThread::processMsgs() ).

  For IWindow objects, we insure via default handlers that keystroke messages
  make it to the canvas or frame window to provide keyboard navigation.
  With dialogs created via a dialog template, however, we have unwrappered
  controls in the dialog which by default simply eat keyboard events,  perhaps
  after doing something with them.  The IDialogControl class is basically
  a "mini" IWindow whose function is to allow us to subclass dialog child
  controls.  In the subclass window procedure, we make sure keyboard
  events get to the dialog IWindow for processing.

*******************************************************************************/

public:
   IDialogControl   ( );
   IDialogControl   ( const IDialogControl& control) ;
   IDialogControl
      &operator=    ( const IDialogControl& control );
   bool operator< ( const IDialogControl& control)  const
   {  return fHwnd < control.fHwnd; }
   bool operator== ( const IDialogControl& control) const
   {  return fHwnd == control.fHwnd; }

  ~IDialogControl   ();

  unsigned long fHwnd;           // HWND, as an unsigned long
  void*         fOriginalProc;   // WNDPROC, default window proc
  IWindowHandle fDialog;         // The parent dialog, typically IFrameWindow
};

/*******************************************************************************
// Key function for IDialogControl
*******************************************************************************/
inline unsigned long const& key (IDialogControl const& k)
{ return k.fHwnd; }


class IDialogControls : public IKeySetAsHshTable<IDialogControl, unsigned long> {
/*******************************************************************************
  This class represents a list of the controls in a dialog.  It is
  the list of IDialogControls for a frame window.

  The key into the collection is the window handle of the child control.

*******************************************************************************/
public:
  IDialogControls () ;
  ~IDialogControls() ;
static IDialogControls
 *listForThread ( const IThreadId& threadId );
};



/*******************************************************************************
 pfnwpICControlProc is the subclass procedure for IDialogControl
*******************************************************************************/
 #ifdef IC_WIN_STRICT
unsigned long __stdcall pfnwpICControlProc( struct HWND__* hwnd,
                                            unsigned long  ulMsg,
                                            void*          mp1,
                                            void*          mp2 );
 #else
unsigned long __stdcall pfnwpICControlProc( void*          hwnd,
                                            unsigned long  ulMsg,
                                            void*          mp1,
                                            void*          mp2 );
 #endif
#endif // IC_WIN

class IWindowThreadObserver : public IObserver {
/*******************************************************************************
  This class is an observer for thread terminations. When it is notified
  of a thread termination, it calls IWindowThreadData with the thread
  id of the terminated thread.
*******************************************************************************/
public:
  IWindowThreadObserver();
  ~IWindowThreadObserver();

virtual IWindowThreadObserver&
 dispatchNotificationEvent  ( const INotificationEvent& event );
}; //IWindowThreadObserver

class IWindowThreadData {
/*******************************************************************************
  This class is a container for all persistent thread specific data which
  IWindow uses.

  Resource Locking with IWindowThreadData and IWindowThreadDataList
    In general, the functions in these classes do not perform resource
    locking automatically.  You must create an IResourceLock object
    using the IPrivateResource returned by IWindowThreadData::libraryKey
    when you are:
      1) modifying the object, or
      2) accessing an IWindowThreadData object for another thread
    The functions follow this rule internally.

*******************************************************************************/
public:
/*------------------------- Constructors/Destructor ----------------------------
  The static functions dataForThread and current construct an
  IWindowThreadObject when called for the current thread and there
  is no existing object.  You cannot construct one directly.
------------------------------------------------------------------------------*/
  ~IWindowThreadData( );

/*-------------------------- Thread Data Management ----------------------------
  Use these functions to manage the thread data objects for a given
  thread.
------------------------------------------------------------------------------*/
static IWindowThreadData
  *dataForThread( const IThreadId& threadId );
static const IWindowThreadData
  *current( );
static void
  threadTerminated( const IThreadId& threadId );
static IPrivateResource
 &libraryKey ( );
static IWindowThreadDataList
 *list( );                    // List of all IWindowThreadData objects

/*----------------------- Access to Per-Thread Objects -------------------------
  Use these functions to access objects stored in an IWindowThreadData
  object.
------------------------------------------------------------------------------*/
IWindowList
  *windowList( ) const;
#ifdef IC_WIN
IDialogControls
  *dialogControls( ) const;
#endif //IC_WIN

IWindowThreadData
  &addBoundWindow( ),
  &removeBoundWindow( );
bool
   hasBoundWindow( ) const;


/*----------------------------------- Key --------------------------------------
  The key function returns the thread id used to create this object.
------------------------------------------------------------------------------*/
unsigned long const
  &key() const;

protected:
  IWindowThreadData( );

private:
  // Static objects

  // Objects allocated once per thread
unsigned long
   fKey;
IWindowList
  *fwindowList;
#ifdef IC_WIN
IDialogControls
  *fdialogControls;     // Pointer to dialog controls list
#endif

unsigned long
   fboundCount;

};   //IWindowThreadData

/*******************************************************************************
// IWindowThreadDataList is a collection of pointers to IWindowThreadData.
// The key is the thread Id as an unsigned long.
// NOTE: Due to the implementation of IKeySetAsHshTable,  this collection uses
// the same hash function as the IWindowList collection uses.  This does
// not appear to be a problem, because the hash function is reasonable
// for both thread ids and window handles.
*******************************************************************************/
class IWindowThreadDataList : public
          IVPtrKeySetAsHshTable<IWindowThreadData*, unsigned long> {
public:
  IWindowThreadDataList( );
  ~IWindowThreadDataList( );
};

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| ITheObjectWindowHandle class                                                 |
| This class is used to create a single instance of a window handle to be      |
| used as the object window.  In Windows, this object needs to be constructed  |
| during static initialization to insure that the thread owning the window     |
| remains active.                                                              |
------------------------------------------------------------------------------*/
class ITheObjectWindowHandle {
public:
   ITheObjectWindowHandle( );
   ~ITheObjectWindowHandle( );
IWindowHandle
   handle() const       { return fhandle; };
private:
   IWindowHandle fhandle;
};
#endif

/*******************************************************************************
// IWindowSortedSet is a collection of pointers to IWindow objects,
// sorted by address.
*******************************************************************************/
typedef ISortedSet< const IWindow* >
  IWindowSortedSet;

/*******************************************************************************
// IWindowStaticData provides construction/destruction for all IWindow
// static data which requires it.   There should only be one instance of
// this object in the system, and it should be a static object.  Do NOT use
// operator new to allocate this object.
*******************************************************************************/
class IWindowStaticData {
public:
/*------------------------------- Constructors ---------------------------------
  The constructor and destructor cause the static objects to be initialized
  or cleaned up, respectively.
------------------------------------------------------------------------------*/
  IWindowStaticData();
  ~IWindowStaticData();

/*-------------------------- Static Data Management ----------------------------
  These functions handle allocation of the basic static objects needed by
  IWindow, and the destruction of all the static objects.
------------------------------------------------------------------------------*/
static void initializeStatics( bool fromConstructor = false );
static void finalizeStatics( );

/*-------------------------------- Accessors -----------------------------------
  Call libraryKey to get the resource lock used to access the rest of these
  objects in a thread-safe fashion.
------------------------------------------------------------------------------*/
static IPrivateResource
 &libraryKey ( );             // Returns the PrivateResource object used
                              // within IWindow.

/*-------------------------- Static Data Pointers ------------------------------
   These pointers are initialized to 0.  It is the responsibility of the
   user of the object to allocate an object when needed.  At static
   destruction time, these objects are deleted by the IWindowStaticData
   destructor by using finalizeStatics.
------------------------------------------------------------------------------*/
static IWindowThreadObserver
  *fgObserver;                 // Watches for thread terminations
static IWindowThreadDataList
  *fgThreadList;               // collection of IWindowThreadData objects
static IDataHandleSet
  *fgDataHandleSet;            // IWindowData handle collection
static IPrivateResource
  *fgDictionaryKey;            // Resource lock for notification
#ifdef IC_MOTIF
static IWindowSortedSet
  *fgAllIWindowsSet;           // IWindowList-like collection for AIX
#endif
static IWindowSortedSet
  *fgAllAllocatedIWindowsSet;  // Collection of non-destructed IWindows
static ITheDesktopWindow
  *desktopWindow;
static ITheObjectWindow
  *objectWindow;

/*----------------------------- Data Objects ----------------------------------
   These objects are initialized when the IWindowStaticData object
   is constructed and deleted when it is destructed.  Note that with some
   compilers the order of such construction and deletion cannot be controlled
   relative to other static objects.
------------------------------------------------------------------------------*/
#ifdef IC_WIN
  // This is a solid static object to insure that the object window
  // is created in the primary thread.  In Windows, having it created
  // on demand can cause it to be created on a secondary thread and
  // subsequently deleted by Windows when that thread terminates.
ITheObjectWindowHandle
  fObjectWindowHandle;
#endif

private:

static IPrivateResource
  *flibKey;                    // Resource lock for IWindow.  This is private
                               // because its accessor function is the trigger
                               // for static initialization of some objects.
};

/*------------------------------------------------------------------------------
| IAllAllocatedIWindows                                                        |
| This class manages interaction with the collection that holds all IWindow    |
| objects that have been constructed and not yet destructed. This collection,  |
| IWindowStaticData::fgAllAllocatedIWindowsSet, differs from IWindowList and
| the AIX-only IWindowStaticData::fgAllIWindowsSet, both of which only
| hold IWindow objects until they are either destructed or their operating     |
| system windows/widgets are destroyed. This collection, on the other hand,    |
| only cares about the lifetime of the IWindow object, not the window or       |
| widget it represents.                                                        |
------------------------------------------------------------------------------*/
class IAllAllocatedIWindows {
public:
static void
  add     ( const IWindow* );
static bool
  remove  ( const IWindow* ),
  isValid ( const IWindow* );

private:
  IAllAllocatedIWindows ( );
 ~IAllAllocatedIWindows ( );

  IAllAllocatedWindows ( const IAllAllocatedIWindows& );
IAllAllocatedIWindows
 &operator=            ( const IAllAllocatedIWindows& );
}; // IAllAlloctedIWindows

/*------------------------------------------------------------------------------
| IWindowStaticData::libraryKey                                                |
------------------------------------------------------------------------------*/
inline IPrivateResource& IWindowStaticData::libraryKey( )
{
  if (!IWindowStaticData::flibKey)
     IWindowStaticData::initializeStatics();
  return *IWindowStaticData::flibKey;
}

/*------------------------------------------------------------------------------
| IWindowThreadData::windowList                                                |
------------------------------------------------------------------------------*/
inline IWindowList* IWindowThreadData::windowList() const
{ return fwindowList; }

/*------------------------------------------------------------------------------
| IWindowThreadData::dialogControls                                            |
------------------------------------------------------------------------------*/
#ifdef IC_WIN
inline IDialogControls* IWindowThreadData::dialogControls( ) const
{ return fdialogControls;}
#endif //IC_WIN

/*------------------------------------------------------------------------------
| IWindowThreadData::libraryKey                                                |
------------------------------------------------------------------------------*/
inline IPrivateResource& IWindowThreadData::libraryKey( )
{
  return IWindowStaticData::libraryKey();
}

/*------------------------------------------------------------------------------
| IWindowThreadData::list                                                      |
------------------------------------------------------------------------------*/
inline IWindowThreadDataList* IWindowThreadData::list( )
{
  return IWindowStaticData::fgThreadList;
}

/*------------------------------------------------------------------------------
| IWindowThreadData::key                                                       |
------------------------------------------------------------------------------*/
inline unsigned long const& IWindowThreadData::key( ) const
{ return fKey; }

/*------------------------------------------------------------------------------
| key - key function for IWindowThreadData                                     |
------------------------------------------------------------------------------*/
inline unsigned long const& key (IWindowThreadData* const& k)
{ return k->key(); }


/*------------------------------------------------------------------------------
| IWindowList::listForThread                                                   |
------------------------------------------------------------------------------*/
inline IWindowList* IWindowList::listForThread( const IThreadId& threadId )
{
  IWindowThreadData* list = IWindowThreadData::dataForThread( threadId );
  return list ? list->windowList() : 0;
}

/*------------------------------------------------------------------------------
| IWindowList::current                                                         |
|                                                                              |
| Return the window list for the current thread.                               |
------------------------------------------------------------------------------*/
inline IWindowList* IWindowList::current ( )
{
   // Current thread is guaranteed to return a valid pointer.
   return IWindowThreadData::current()->windowList();
}

/*------------------------------------------------------------------------------
| IWindowList::libraryKey                                                      |
------------------------------------------------------------------------------*/
inline IPrivateResource& IWindowList::libraryKey ( )
{
  return IWindowStaticData::libraryKey();
}

/*------------------------------------------------------------------------------
| IDialogControls::listForThread                                               |
------------------------------------------------------------------------------*/
#ifdef IC_WIN
inline IDialogControls* IDialogControls::listForThread( const IThreadId& threadId )
{
  IWindowThreadData* list = IWindowThreadData::dataForThread( threadId );
  return list ? list->dialogControls() : 0;
}
#endif //IC_WIN


/*------------------------------------------------------------------------------
| IWindowThreadData::addBoundWindow                                            |
------------------------------------------------------------------------------*/
inline IWindowThreadData& IWindowThreadData::addBoundWindow( )
{
   fboundCount++;
   return *this;
}

/*------------------------------------------------------------------------------
| IWindowThreadData::removeBoundWindow                                         |
------------------------------------------------------------------------------*/
inline IWindowThreadData& IWindowThreadData::removeBoundWindow( )
{
   if (fboundCount) fboundCount--;
   return *this;
}

/*------------------------------------------------------------------------------
| IWindowThreadData::hasBoundWindow                                            |
------------------------------------------------------------------------------*/
inline bool IWindowThreadData::hasBoundWindow( ) const
{
   return (fboundCount ? true : false);
}

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IWINLSTS_
