/* Revision: 99 1.26.2.1 source/ui/baseapp/iwindefs.h, datatype, ioc.v400, 001006  */
/* NOSHIP */
#ifndef _IWINDEFS_
#define _IWINDEFS_
/*******************************************************************************
* FILE NAME: iwindefs.h                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*    OS/2 / WINDOWS  Macro component                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ilanglvl.hpp>

/******************** Static Initialization/Termination ***************/
/* Set up a macro to indicate the level of static initialization      */
/* priority control the compiler offers.  If the compiler supports    */
/* object file level control or we are being built into a DLL, then   */
/* indicate support available.  If we are being static linked and the */
/* compiler does not support sufficient control, we indicate that     */
/* support is not available so that we do not have trouble with client*/
/* static object destruction.                                         */
/**********************************************************************/
#ifndef IC_STATIC_PRIORITY_SUPPORTED
   #if (defined(__IBMCPP__) || defined(__IMPORTLIB__) )
       #define IC_STATIC_PRIORITY_SUPPORTED 1
   #else
       #define IC_STATIC_PRIORITY_SUPPORTED 0
   #endif
#endif

/************************** Platform Macros ***************************/
/* If none of the platform indicator macros are defined yet, set up   */
/* defaults for them based on the compiler supplied platform macros.  */
/**********************************************************************/
#if ( !defined(IC_PM) && !defined(IC_MOTIF) && !defined(IC_WIN) )
  #ifdef __OS2__
     #define IC_PM
  #endif
  #ifdef _AIX
     #define IC_MOTIF
  #endif
  #ifdef __WINDOWS__
     #define IC_WIN
  #endif
#endif

#ifdef __WINDOWS__
     #undef IC_PM
     #ifndef IC_WIN
       #define IC_WIN
     #endif
#endif

/************************ Common File Macros **************************/
/* Now define any common file macros based on environment             */
/**********************************************************************/
#if defined(IC_PM)
  #define IC_PMWIN
  #define IC_MOTIFPM
#endif
#if defined(IC_MOTIF)
  #define IC_MOTIFPM
  #define IC_MOTIFWIN
#endif
#if defined(IC_WIN)
  #define IC_PMWIN
  #define IC_MOTIFWIN
#endif

#if defined(IC_PM_FLAGNOP)
  #define IC_PMWIN_FLAGNOP
  #define IC_MOTIFPM_FLAGNOP
#endif
#if defined(IC_MOTIF_FLAGNOP)
  #define IC_MOTIFPM_FLAGNOP
  #define IC_MOTIFWIN_FLAGNOP
#endif
#if defined(IC_WIN_FLAGNOP)
  #define IC_PMWIN_FLAGNOP
  #define IC_MOTIFWIN_FLAGNOP
#endif

/*------------------------------ Version Levels --------------------------------
| IC_OBSOLETE        Defines the level of obsolete functions which are to      |
|                    be included.  The default value for this macro matches    |
|                    the link libraries delivered with this version of the     |
|                    product.   To determine functions which may be removed    |
|                    from future versions, you may define this macro to        |
|                    be greater than the current IC_MAJOR_VERSION.             |
| IC_OBSOLETE_x      Generation "x" of obsolete functions.  The header files   |
|                    contain preprocessor statements around obsolete functions |
|                    which compare the value of IC_OBSOLETE with the           |
|                    IC_OBSOLETE_x value.  These obsolete functions are not    |
|                    included in the compilation if IC_OBSOLETE is greater     |
|                    than IC_OBSOLETE_x.  The value of the IC_OBSOLETE_x macro |
|                    is the IC_MAJOR_VERSION in which the functions wrappered  |
|                    with IC_OBSOLETE_x were declared to be obsolete.          |
| IC_OBSOLETE_1      IC_OBSOLETE_1 is used for functions obsoleted at major    |
|                    version 310 for OS/2 and 320 for Windows.                 |
------------------------------------------------------------------------------*/
#define IC_OBSOLETE_1    310
#define IC_OBSOLETE_2    400
#define IC_OBSOLETE_3    410

#ifndef IC_OBSOLETE
 #ifdef IC_WIN
   #define IC_OBSOLETE  400
 #endif
 #ifdef IC_PM
   #define IC_OBSOLETE  400
 #endif
 #ifdef IC_MOTIF
   #define IC_OBSOLETE  400
 #endif
 #ifdef IC_400
   #define IC_OBSOLETE  310
 #endif
 #ifdef IC_MVS
   #define IC_OBSOLETE  310
 #endif
#endif

/**********************************************************************/
/* Extended style definitions (Cross platform)                        */
/*     Bits 0-23 are reserved for ICLUI                               */
/*     Bits 24-31 are open for customer usage                         */
/**********************************************************************/

/*--------------------------------------------------------------------*/
/* IListBoxDrawItemHandler/IMenuDrawItemHandler::DrawFlag             */
/*--------------------------------------------------------------------*/
#define IDIF_SELECTED      0x00000001ul
#define IDIF_CHECKED       0x00000002ul
#define IDIF_DISABLED      0x00000004ul

/*--------------------------------------------------------------------*/
/* IMenuBar extended styles                                           */
/*--------------------------------------------------------------------*/
#define IMBS_EMPTY         0x00000001ul
#define IMBS_WRAPPER       0x00000002ul

/*--------------------------------------------------------------------*/
/* IMenuItem extended styles                                          */
/*--------------------------------------------------------------------*/
#define IMIS_TEXT          0x00000001ul                //IMenuItem::text
#define IMIS_STATIC        0x00000002ul                //IMenuItem::unavailable

/*--------------------------------------------------------------------*/
/* ICircularSlider extended styles - provided due to the styles being */
/* the opposite of the system defines.                                */
/*--------------------------------------------------------------------*/
#define ICSS_BUTTONS       0x00000001ul
#define ICSS_LABEL         0x00000002ul
#define ICSS_VALUE         0x00000004ul

/*--------------------------------------------------------------------*/
/* IStaticText extended styles                                        */
/*--------------------------------------------------------------------*/
// In WIN, these overlap with WS_EX_DLGMODALFRAME, WS_EX_NOPARENTNOTIFY,
// WS_EX_TOPMOST and a value unused in the SDK headers.   We don't use
// these styles in IOC static controls.  See IDT_EXTMASK
#define IDT_LEFT           0x00000001ul
#define IDT_TOP            0x00000002ul
#define IDT_UNDERSCORE     0x00000004ul
#define IDT_STRIKEOUT      0x00000008ul
#ifdef IC_WIN
  #define SS_BKGNDRECT             SS_WHITERECT
  #define SS_FGNDRECT              SS_BLACKRECT
  #define SS_HALFTONERECT          SS_GRAYRECT
  #define SS_BKGNDFRAME            SS_WHITEFRAME
  #define SS_FGNDFRAME             SS_BLACKFRAME
  #define SS_HALFTONEFRAME         SS_GRAYFRAME
  #define DT_QUERYEXTENT           DT_CALCRECT

  // Values for IDT_ flags overlap with the following WS_EX_* styles:
  // WS_EX_ACCEPTFILES, WS_EX_MDICHILD, WS_EX_TOOLWINDOW, WS_EX_CONTEXTHELP
  // See IDT_EXTMASK and ISS_EXTGUIMASK
  #define IDT_MNEMONIC             0x00000010ul  // ~DT_NOPREFIX
  #define IDT_HALFTONE             0x00000040ul
  #define IDT_ERASERECT            0x00000080ul
  #define IDT_CENTER               0x00000400ul  // DT_CENTER
  #define IDT_RIGHT                0x00100000ul  // DT_RIGHT
  #define IDT_VCENTER              0x00200000ul  // DT_VCENTER
  #define IDT_BOTTOM               0x00400000ul  // DT_BOTTOM
  #define IDT_WORDBREAK            0x00800000ul  // DT_WORDBREAK
#endif

/*--------------------------------------------------------------------*/
/* IBitmapControl extended styles                                     */
/*--------------------------------------------------------------------*/
#ifdef IC_WIN
#define ISS_BITMAP         0x00000001ul      //sizeToBitmap style
#endif

/*--------------------------------------------------------------------*/
/* IFxxxDialog extended styles                                        */
/*--------------------------------------------------------------------*/
#ifdef IC_WIN
#define IFNTS_MODELESS      0x00008000ul
#define IFDS_MODELESS       0x00008000ul
#endif

/*--------------------------------------------------------------------*/
/* IMessageWindow extended styles                                     */
/*--------------------------------------------------------------------*/
#define IMGW_DEFERCLIENTCREATION 0x00008000ul

/*--------------------------------------------------------------------*/
/* IMultiLineEdit extended styles                                     */
/*--------------------------------------------------------------------*/
#ifdef IC_WIN
#define IMLS_WORDWRAP       0x00000001ul
#define IMLS_IGNORETAB      0x00000002ul
#endif

/*--------------------------------------------------------------------*/
/* Button controls extended styles - provided due to overlapping BS_  */
/* styles.                                                            */
/*--------------------------------------------------------------------*/
#define IBS_PUSHBUTTON      0x00000001ul
#define IBS_CHECKBOX        0x00000002ul
#define IBS_AUTOCHECKBOX    0x00000004ul
#define IBS_RADIOBUTTON     0x00000008ul
#define IBS_AUTORADIOBUTTON 0x00000010ul
#define IBS_3STATE          0x00000020ul
#define IBS_AUTO3STATE      0x00000040ul
#define IBS_GRAPHICBUTTON   0x00000080ul   //IGraphicPushButton
#ifdef IC_WIN
#define IBS_DEFAULT         0x00000100ul   // default button overlaps in win
#define IBS_HELP            0x00000200ul   // not a native style in win
#define IBS_SYSCOMMAND      0x00000400ul   // not a native style in win
//BIDI 25652 #define IBS_NOPOINTERFOCUS  0x00001000ul   // not a native style in win
#define IBS_NOPOINTERFOCUS  0x00010000ul   // not a native style in win
#define IBS_ICON            0x00002000ul   // BS_ICON not a native style in NT
#endif

/*--------------------------------------------------------------------*/
/* Button controls extended styles - provided to support              */
/* BS_USERBUTTON extensions                                           */
/*--------------------------------------------------------------------*/
#define IBS_CUSTOMLATCHABLE 0x00000001ul //ICustomButton::latchable
#define IBS_CUSTOMAUTOLATCH 0x00000002ul //ICustomButton::autoLatch

#define IBS_ANIMATEDLATCHED 0x00000004ul //IAnimatedButton::animateLatched

#define IBS_TBARBMPVISIBLE  0x00000004ul //IToolBarButton::bitmapVisible
#define IBS_TBARTEXTVISIBLE 0x00000008ul //IToolBarButton::textVisible

#define IBS_TBARBOTHVISIBLE 0x00000010ul //IToolBarButton::bitmapAndTextVisible
#define IBS_TBARUSEBMPID    0x00000020ul //IToolBarButton::useIdForBitmap
#define IBS_TBARUSETEXTID   0x00000040ul //IToolBarButton::useIdForText
#define IBS_TBARSTDFORMAT   0x00000080ul //IToolBarButton::standardFormat
#define IBS_TBARDRAGDEL     0x00000200ul //IToolBarButton::dragDelete
#define IBS_TBARTRANSBITMAP 0x00004000ul //IToolBarButton::transparentBitmap

/*--------------------------------------------------------------------*/
/* Notebook control extended styles                                   */
/*--------------------------------------------------------------------*/
#define IBKS_SQUARETABS      0x00000001ul
#define IBKS_SOLIDBIND       0x00000002ul
#define IBKS_STATUSTEXTLEFT  0x00000004ul
#define IBKS_TABTEXTLEFT     0x00000008ul
#define IBKS_PMCOMPATIBLE    0x00000010ul  //INotebook::pmCompatible
#define IBKS_ALLTABSVISIBLE  0x00000020ul  //INotebook::allTabsVisible
#define IBKS_HANDLEDRAWTABS  0x00000040ul  //INotebook::handleDrawTabs
#define IBKS_AUTOSIZETABS    0x00000080ul  //INotebook::autoSizeTabs

/*--------------------------------------------------------------------*/
/* Notebook control unique color flags                                */
/*--------------------------------------------------------------------*/
#define IBKA_BACKGROUNDPAGECOLOR   0x00000001
#define IBKA_BACKGROUNDMAJORCOLOR  0x00000002
#define IBKA_BACKGROUNDMINORCOLOR  0x00000004
#define IBKA_FOREGROUNDMAJORCOLOR  0x00000008
#define IBKA_FOREGROUNDMINORCOLOR  0x00000010

/*--------------------------------------------------------------------*/
/* Container control extended styles                                  */
/*--------------------------------------------------------------------*/
#define ICCS_NOSHAREDOBJECTS       0x00000001ul
#define ICCS_PMCOMPATIBILITY       0x00000002ul

/*--------------------------------------------------------------------*/
/* Slider control extended styles                                     */
/*--------------------------------------------------------------------*/
#define ISLS_HORIZONTAL            0x00000001ul
                                      //IProgressIndicator::horizontal
#define ISLS_CENTER                0x00000002ul
                                      //IProgressIndicator::alignCentered
#define ISLS_HOMEBOTTOM            0x00000004ul
                                      //IProgressIndicator::homeBottom
#define ISLS_HOMELEFT              0x00000004ul
                                      //IProgressIndicator::homeLeft
#define ISLS_PRIMARYSCALE1         0x00000008ul
                                      //IProgressIndicator::primaryScale1
#define ISLS_PMCOMPATIBILITY       0x00000010ul
                                      //IProgressIndicator::pmCompatibility
#define ISLS_SNAPTOTICK            0x00000020ul
                                      //IProgressIndicator::snapToTickMark
#define ISLS_TOP                   0x00000040ul
                                      //IProgressIndicator::alignTop
#define ISLS_RIGHT                 0x00000040ul
                                      //IProgressIndicator::alignRight
#define ISLS_BOTTOM                0x00000080ul
                                      //IProgressIndicator::alignBottom
#define ISLS_LEFT                  0x00000080ul
                                      //IProgressIndicator::alignLeft
#define ISLS_HOMETOP               0x00000100ul
                                      //IProgressIndicator::homeTop
#define ISLS_HOMERIGHT             0x00000100ul
                                      //IProgressIndicator::homeRight
#define ISLS_BUTTONSBOTTOM         0x00000400ul
                                      //ISlider::buttonsBottom
#define ISLS_BUTTONSLEFT           0x00000400ul
                                      //ISlider::buttonsLeft
#define ISLS_BUTTONSTOP            0x00000800ul
                                      //ISlider::buttonsTop
#define ISLS_BUTTONSRIGHT          0x00000800ul
                                      //ISlider::buttonsRight

/*--------------------------------------------------------------------*/
/* Entry field control extended styles                                */
/*--------------------------------------------------------------------*/
#define IES_LEFTALIGN              0x00000001ul   //IEntryField::leftAlign
#ifdef IC_PM
  #define IES_ANYDATA              0x00000002ul   //IEntryField::anyData
  #define IES_MIXEDDATA            0x00000004ul   //IEntryField::mixedData
#endif
#ifdef IC_WIN
  #define IES_ANYDATA              0x00000000ul   //no equivalent in Windows
  #define IES_MIXEDDATA            0x00000000ul
  #define IES_AUTOTAB              0x00000002ul
#endif

/*--------------------------------------------------------------------*/
/* Spin button control extended styles                                */
/*--------------------------------------------------------------------*/
#define ISPBS_SERVANT           0x00000008ul  //IBaseSpinButton::servant
#define ISPBS_CENTERALIGN       0x00000010ul  //IBaseSpinButton::centerAlign
#define ISPBS_PMCOMPATIBILITY   0x00000020ul  //IBaseSpinButton::pmCompatibility
// #define ISPBS_ALLCHARACTERS     0x00000000ul //default (ITextSpinButton)
#define ISPBS_NUMERICONLY       0x00000040ul  // INumericSpinButton
#define ISPBS_READONLY          0x00000080ul  //IBaseSpinButton::readOnly
#define ISPBS_MASTER            0x00000100ul  //IBaseSpinButton::master
//BIDI 25652 #define ISPBS_JUSTLEFT          0x00004000ul  //IBaseSpinButton::leftAlign
#define ISPBS_JUSTLEFT          0x00040000ul  //IBaseSpinButton::leftAlign
#define ISPBS_JUSTRIGHT         0x00000400ul  //IBaseSpinButton::rightAlign
#define ISPBS_NOBORDER          0x00000800ul  //IBaseSpinButton::noBorder
//BIDI 25652 #define ISPBS_FASTSPIN          0x00001000ul  //IBaseSpinButton::fastSpin
#define ISPBS_FASTSPIN          0x00010000ul  //IBaseSpinButton::fastSpin
//BIDI 25652 #define ISPBS_PADWITHZEROS      0x00002000ul  //INumericSpinButton::padWithZeros
#define ISPBS_PADWITHZEROS      0x00020000ul  //INumericSpinButton::padWithZeros
#ifdef IC_WIN
// base styles for native spinbutton wrapper control (WC_NATIVESPINBUTTON)
#define INSPBS_NUMERICONLY      0x00000001ul  //NumericSpinButton
#define INSPBS_MASTER           0x00000002ul  //master
#define INSPBS_PADWITHZEROS     0x00000004ul  //padWithZeros
#endif

/*--------------------------------------------------------------------*/
/* Combo box control extended styles                                  */
/*--------------------------------------------------------------------*/
#ifdef IC_WIN
  #define ICBS_DROPDOWNLIST        0x00000008ul  //IComboBox::dropDownListType
#endif

/*--------------------------------------------------------------------*/
/* Scroll bar control extended styles                                 */
/*--------------------------------------------------------------------*/
#define ISBS_HORIZONTAL            0x00000001ul  //IScrollBar::horizontal

/*--------------------------------------------------------------------*/
/* Canvas controls extended styles                                    */
/*--------------------------------------------------------------------*/
#define ICNV_BORDER                0x00000001ul   //ICanvas::border
#define ICNV_GRID                  0x00000002ul   //IMultiCellCanvas::gridLines
#define ICNV_DRAG                  0x00000004ul   //IMultiCellCanvas::dragLines
#define ICNV_ADDTOLAST             0x00000008ul   //IMultiCellCanvas::spaceAddedToLast

#define ICNV_ASNEEDEDHORZSB        0x00000002ul
                                      //IViewPort::asNeededHorizontalScrollBar
#define ICNV_ALWAYSHORZSB          0x00000004ul
                                      //IViewPort::alwaysHorizontalScrollBar
#define ICNV_NOHORZSB              0x00000008ul
                                      //IViewPort::noHorizontalScrollBar
#define ICNV_ASNEEDEDVERTSB        0x00000010ul
                                      //IViewPort::asNeededVerticalScrollBar
#define ICNV_ALWAYSVERTSB          0x00000020ul
                                      //IViewPort::alwaysVerticalScrollBar
#define ICNV_NOVERTSB              0x00000040ul
                                      //IViewPort::noVerticalScrollBar
#define ICNV_EXPANDVIEWWIN         0x00000080ul
                                      //IViewPort::expandableViewWindow
#define ICNV_NOVIEWWINFILL         0x00000100ul
                                      //IViewPort::noViewWindowFill

#define ICNV_VERTICAL              0x00000002ul   //ISplitCanvas::vertical
#define ICNV_HORIZONTAL            0x00000004ul   //ISplitCanvas::horizontal
#define ICNV_NOSPLITBARS           0x00000008ul   //ISplitCanvas::noSplitBars

#define ICNV_EXTSETCV              0xFF180FFFul   // Set Canvas extended styles
#define ICNV_EXTTBAR               0xFF3F8FFFul   // Toolbar extended styles

#define ICNV_HORIZONTALDECKS       0x00000002ul   //ISetCanvas::horizontalDecks
#define ICNV_VERTICALDECKS         0x00000004ul   //ISetCanvas::verticalDecks
#define ICNV_PACKTIGHT             0x00000008ul   //ISetCanvas::packTight
#define ICNV_PACKEVEN              0x00000010ul   //ISetCanvas::packEven
#define ICNV_PACKEXPANDED          0x00000020ul   //ISetCanvas::packExpanded
#define ICNV_LEFTALIGN             0x00000040ul   //ISetCanvas::leftAlign
#define ICNV_RIGHTALIGN            0x00000080ul   //ISetCanvas::rightAlign
#define ICNV_CENTERALIGN           0x00000100ul   //ISetCanvas::centerAlign
#define ICNV_TOPALIGN              0x00000200ul   //ISetCanvas::topAlign
#define ICNV_BOTTOMALIGN           0x00000400ul   //ISetCanvas::bottomAlign
#define ICNV_CENTERVERTICALALIGN   0x00000800ul
                                      //ISetCanvas::centerVerticalAlign
//BIDI 25652 #define ICNV_DECKSBYGROUP          0x00001000ul   //ISetCanvas::decksByGroup
#define ICNV_DECKSBYGROUP          0x00080000ul   //ISetCanvas::decksByGroup
//BIDI 25652 #define ICNV_EXPLICITADDS          0x00002000ul   //ISetCanvas::explicitAddsNeeded
#define ICNV_EXPLICITADDS          0x00100000ul   //ISetCanvas::explicitAddsNeeded

//BIDI 25652 #define ICNV_HIDEMISFITS           0x00004000ul   //IToolbar::hideMisfits
#define ICNV_HIDEMISFITS           0x00200000ul   //IToolbar::hideMisfits
#define ICNV_BTNBMPVISIBLE         0x00008000ul
                                      //IToolbar::buttonBitmapVisible
#define ICNV_BTNTEXTVISIBLE        0x00010000ul
                                      //IToolbar::buttonTextVisible
#define ICNV_BTNBMPANDTEXTVISIBLE  0x00020000ul
                                      //IToolbar::buttonBitmapAndTextVisible
#define ICNV_DRAGDROP              0x00040000ul   //IToolbar::dragDrop

#define ICNV_ATTACHDEFAULTHANDLER  0x00000002ul
                                      //IDrawingCanvas::attachDefaultHandler

/*--------------------------------------------------------------------*/
/* Outline box extended styles                                        */
/*--------------------------------------------------------------------*/
#define IOBS_BACKGROUNDFRAME       0x00000001ul   //IOutlineBox:backgroundFrame
#define IOBS_FOREGROUNDFRAME       0x00000002ul   //IOutlineBox:foregroundFrame
#define IOBS_HALFTONEFRAME         0x00000004ul   //IOutlineBox:halftoneFrame

/**********************************************************************/
/* Define convenience macros.  Must be uppercase names to avoid clash */
/* with ANSI defined template functions.                              */
/**********************************************************************/
#ifndef MIN
  #define MIN(a, b) ( ( (a) <= (b) ) ? (a) : (b) )
#endif
#ifndef MAX
  #define MAX(a, b) ( ( (a) >= (b) ) ? (a) : (b) )
#endif

/**********************************************************************/
/* If Windows NT program, then set the macros to call Windows 32 APIs */
/**********************************************************************/
#ifdef IC_WIN
#define OEMRESOURCE  1
#ifndef NOMINMAX
  #define NOMINMAX
#endif
#include <windows.h>

/*--------------------------------------------------------------------*/
/* IFrame extended styles                                             */
/*--------------------------------------------------------------------*/
// These must not overlap with WS_EX_ styles included in IFS_EXTGUIMASK.
// Mask for these is IFS_EXTMASK.
#define IFS_DEFERCREATE   0x00010000ul
#define IFS_ACCELERATOR   0x00020000ul
#define IFS_MENU          0x00080000ul
#define IFS_MINICON       0x00100000ul
#define IFS_ALIGNNOADJ    0x00200000ul
#define IFS_SHELLPOS      0x00400000ul
#define IFS_ANIMATED      0x00000000ul  
#define IFS_APPDBCS       0x00000000ul  
#define IFS_DLGBACKGND    0x00800000ul
#define IFS_HIDEBUTTON    0x00000000ul  
#define IFS_NOMOVEOWNER   0x00000000ul  
#define IFS_SYSMODAL      0x00000000ul  

/*--------------------------------------------------------------------*/
/* IWindow border style (Win only, NOOP in PM)                        */
/*--------------------------------------------------------------------*/
#define IWS_BORDER3D      WS_EX_CLIENTEDGE

/***********************************************************************
   Windows style masks definitions
   There are 3 basic types of masks defined.
   _MASK       - mask for the base styles
   _EXTMASK    - mask for ICLUI defined extended styles
   _EXTGUIMASK - mask for GUI defined extended styles.  In Windows,
                 these are the extended styles for the first argument
                 to CreateWindowEx.
   The convertToGUIStyle function in the classes will return valid
   style bits to be passed to the GUI.  The ICLUI defined styles
   are translated to appropriate GUI flags by this function if
   needed.  For Windows, specifying extendedOnly=true will cause
   convertToGUIStyle to return any user style bits (24-31) ORed with
   the Windows extended styles (WS_EX_*) supported by the class.

   Classes which dont support any GUI extended styles typically use
   IS_EXTMASK to mask the extended styles.  If support is added for
   one or more GUI extended styles,  a _EXTGUIMASK definition should
   be added here and used instead.
***********************************************************************/
#define IWS_MASK        0xFFFF0000ul       // Window (WS_) reserved styles
#define IS_EXTMASK      0xFF000000ul       // Generic extended styles mask
#define IFS_MASK        0x00000000ul       // Frame window (FS_)
#define IFS_EXTMASK     0x00FB0000ul       // Frame window extended
#define IFS_EXTGUIMASK  0x000404C9ul       // Frame window. GUI defined extended
                                           // Excludes all WS_EX_* styles EXCEPT:
                                           //  WS_EX_DLGMODALFRAME
                                           //  WS_EX_TOPMOST
                                           //  WS_MDICHILD
                                           //  WS_EX_TOOLWINDOW
                                           //  WS_EX_CONTEXTHELP
                                           //  WS_EX_APPWINDOW,
#define IDT_MASK        0x0000FFE3ul       // DrawText (DT_) styles  Ref:SS_TYPEMASK
#define IDT_EXTMASK     0x007004D0ul       // DrawText extended styles
#define ITC_EXTGUIMASK  0x00000200ul       // Text Control(entry field and mle)
                                           //  WS_EX_CLIENTEDGE
#define IOB_EXTGUIMASK  0x00020000ul       // Outline Box extended GUI styles
                                           //  WS_EX_STATICEDGE
#define IGB_EXTGUIMASK  0x00020000ul       // Group Box extended GUI styles
                                           //  WS_EX_STATICEDGE
#define ISS_EXTGUIMASK  0x000FFF20ul       // Static  extended styles  EXCLUDES:
                                           //    WS_EX_DLGMODALFRAME
                                           //    WS_EX_NOPARENTNOTIFY
                                           //    WS_EX_TOPMOST
                                           //    WS_EX_ACCEPTFILES
                                           //    WS_EX_MDICHILD
                                           //    WS_EX_TOOLWINDOW
                                           //    WS_EX_CONTEXTHELP
                                           //    WS_EX_CLIENTEDGE
#define IFDS_MASK       0x002FFFFFul       // File Dialog (OFN_)
#define IFDS_EXTMASK    0x00008000ul       // File Dialog extended mask
#define IFNTS_MASK      0x01FFFFFFul       // Font Dialog (CF_)
#define IFNTS_EXTMASK   0x00008000ul       // Font Dialog extended mask
#define IMLS_MASK       0x00B01DFFul       // MLE (ES_ styles)
#define IMS_MASK        0x00000045ul       // Menu control
#define IMS_STYLEMASK   0x0000e974ul       // Menu styles (MF_)
#define IMS_ATTRMASK    0x0000028bul       // Menu attributes (MF_)
#define IMBS_MASK       0x00000000ul       // Menubar
#define IMBS_EXTMASK    0x00000003ul       // Menubar extended
#define IMIS_MASK       0x0000FFFFul       // Menu item
#define IMIS_EXTMASK    0x00000003ul       // Menu item extended
#define ILS_MASK        0x00107FFDul       // List box (LBS_) (strip LBS_SORT)
#define ILS_EXTGUIMASK  0x00000200ul       // List box extended
#define IBKS_MASK       0x0000F7FFul       // Notebook (BKS_)
#define ICCS_MASK       0x0000007Ful       // Container (CCS_)
#define ISLS_SHAFTMASK  0x00000FCFul       // Slider (SLS_) Shaft styles
#define ISLS_BUTTONMASK 0x00000030ul       // Slider (SLS_) Button styles
#define ISLS_EXTMASK    0x00000010ul       // Slider extended styles
#define ISLS_EXTGUIMASK 0x00000200ul       // Slider GUI extended styles
#define IES_MASK        0x00801DFFul       // Entry field styles
#define IES_EXTMASK     0x00000001ul       // Entry field extended styles
#define ICBS_MASK       0x00100FF3ul       // Combo box styles
#define ICBS_EXTMASK    0x00100008ul       // Combo box extended styles
#define ICBS_EXTGUIMASK 0x00000200ul       // Combo box GUI extended styles
#define IBS_MASK        0x00000020ul       // Button controls
#define IBS_EXTCHECKBX  0x00000006ul       // Button controls extended checkbox
#define IBS_EXTRADIOBTN 0x00000018ul       // Button controls extended radiobtn
#define IBS_EXT3STATE   0x00000060ul       // Button controls extended 3state
#define IBS_EXTPUSH     0x00000700ul       // Button controls extended push
#define IBS_EXTGPUSH    0x00000f00ul       // Graphic Button controls extended push
#define ISBS_MASK       0x0000000Ful       // Scroll bar styles
// need one of these for BS_NOPOINTERFOCUS (IButton)
#define ISPBS_MASK      0x000001BFul       // Spin button styles
#define ISPBS_EXTMASK   0x00000200ul       // Spin button extended styles
#define ISS_BMPMASK     0x00000000ul       // Static bitmap style (none in Win)
#define ISS_EXTBMPMASK  0x00000001ul       // Bitmap Extended
#define IGB_MASK        0x00000000ul       // Graphic button style (none in Win)
#define IOBS_EXTMASK    0x00000007ul       // Outline box extended styles
#define ICSS_MASK       0x000001FFul       // Circular Slider (CSS_)

/*--------------------------------------------------------------------*/
/* IGraphic defines                                                   */
/*--------------------------------------------------------------------*/
/* basic pattern symbols - do not move these out of order */
#define PATSYM_DIAG2         0xffffffed
#define PATSYM_DIAG4         0xffffffee
#define PATSYM_HALFTONE      0xffffffef
#define PATSYM_DENSE1        0xfffffff0
#define PATSYM_DENSE2        0xfffffff1
#define PATSYM_DENSE3        0xfffffff2
#define PATSYM_DENSE4        0xfffffff3
#define PATSYM_DENSE5        0xfffffff4
#define PATSYM_DENSE6        0xfffffff5
#define PATSYM_DENSE7        0xfffffff6
#define PATSYM_DENSE8        0xfffffff7
#define PATSYM_VERT          0xfffffff8
#define PATSYM_HORIZ         0xfffffff9
#define PATSYM_DIAG1         0xfffffffa
#define PATSYM_DIAG3         0xfffffffb
#define PATSYM_NOSHADE       0xfffffffc
#define PATSYM_SOLID         0xfffffffd
#define PATSYM_HATCH         0xfffffffe
#define PATSYM_DIAGHATCH     0xffffffff

/*--------------------------------------------------------------------*/
/* Extra window words mapping for WC_FRAME class (IFrameWindow)       */
/* DLGWINDOWEXTRA+4 extra words are allocated.                        */
/*--------------------------------------------------------------------*/
#define IGWL_ID                         DWL_USER

/**********************************************************************/
/* Some of the common DOS calls like dossleep                         */
/**********************************************************************/
#define ISLEEP(msec)                    (Sleep(msec))

/**********************************************************************/
/* The following functions have macro definitions which map fairly    */
/* well between environments except as specified                      */
/**********************************************************************/
#define IADDSYSATOM(psz)                (GlobalAddAtom( psz ))

/**********************************************************************/
/* Note: Last parameter is pointer to Paintstruct, not prcl as in OS/2*/
/**********************************************************************/
#define IBEGINPAINT(hwnd,hps,lpps)      (BeginPaint( hwnd, lpps ))

/**********************************************************************/
/* Note: No CalcFrameRect equivalent                                  */
/**********************************************************************/
#define ICALCCLIENTRECT(hwnd,prcl)      (GetClientRect( hwnd,           \
                                                        (PRECT)(void *)prcl ))

#define ICHARSTRINGAT(hdc,pptl,cnt,psz)                                 \
                                  (TextOut( hdc, pptl->x, pptl->y, psz, cnt ))
#define ICLOSEDC(hdc)                   (DeleteDC( hdc ))

/**********************************************************************/
/* Note: 2nd and 3rd parameters are primary and sub language ids, not */
/*       country code and code page ids as in OS/2                    */
/**********************************************************************/
#define ICOMPARESTRINGS(hab,idpl,idsl,psz1,psz2,fl)                     \
 (CompareStringW( MAKELCID( MAKELANGID( idpl,idsl ), fl, psz1, -1, psz2, -1 ))

#define ICREATEBITMAP(hdc,pbmp2,flOpt,pbd,pbmi2)                        \
             (CreateDIBitmap( hdc, pbmp2, flOpt, pbd, pbmi2, DIB_RGB_COLORS ))

/**********************************************************************/
/* CreateLogColorTable - Palette table structure is different in NT   */
/*                  then in OS/2 - Also returns a palette handle for  */
/*                  usage (as opposed to success flag)                */
/**********************************************************************/
#define ICREATELOGCOLORTABLE(hdc,flOpt,lFmt,lStrt,cnt,paTbl)            \
                                                 (CreatePalette( paTbl ))

/**********************************************************************/
/* CreateLogFont - Third parameter is HFONT (not LCID) and last param */
/* is pointer to LOGFONT (not PFATTRS)                                */
/**********************************************************************/
#define ICREATELOGFONT(hdc,psz,hfont,plf) \
                                    (hfont = (ULONG)CreateFontIndirect( plf ))

/**********************************************************************/
/* CreateMsgQueue - No Windows NT equivalent.  NT has only one system */
/*                  message queue and automatically creates a message */
/*                  queue per thread                                  */
/**********************************************************************/
#define ICREATEMSGQUEUE(hab,lqsiz)      (0)

#define ICREATEPS(hab,hdc,pszl,ulOpt)   (hdc)
#define ICREATEREGION(hps,cnt,prctl)    (CreateRectRgnIndirect( prctl ))
#define ICREATEWINDOW(hPar,pszCNam,pszWNam,fSt,x,y,wdt,                 \
                      hgt,hOwn,hBeh,idW,pCtl,fExtSt,hInst)              \
           (CreateWindowEx( fExtSt, pszCNam, pszWNam, fSt, x, y, wdt, hgt, \
                          hPar, (HMENU)idW, hInst, pCtl ))
/**********************************************************************/
/* DdeInitiate - Must send message to all top level windows           */
/*  Note: Server must get strings from atoms upon receipt for its use */
/**********************************************************************/
 #define IDDEINITIATE(hwndCl,pszA,pszT,pCntx)                            \
         {  ATOM  gaA, gaT;                                             \
            gaA = GlobalAddAtom( pszA );                                \
            gaT = GlobalAddAtom( pszT );                                \
            SendMessage( HWND_TOPMOST, WM_DDE_INITIATE, (WPARAM)hwndCl, \
                         MAKELPARAM( gaA, gaT ));                       \
            GlobalDeleteAtom( gaT );                                    \
            GlobalDeleteAtom( gaA );  }

/**********************************************************************/
/* DdePostMsg - Posts conversation message                            */
/*  Note: NT does not use PDDESTRUCT to pass info, but instead packs  */
/*        information into lParam, passing handle to buffer and atom  */
/*        identifying data item/notification sent                     */
/**********************************************************************/
 #define IDDEPOSTMSG(hwndTo,hwndFr,msg,hData,aItem)                      \
  (PostMessage( hwndTo, msg, (WPARAM)hwndFr, PackDDElParam(hData,aItem)))

/**********************************************************************/
/* DdeRespond - Must return message to client                         */
/**********************************************************************/
 #define IDDERESPOND(hwndCl,hwndSv,pszA,pszT,pCntx)                      \
         {  ATOM  gaA, gaT;                                             \
            gaA = GlobalAddAtom( pszA );                                \
            gaT = GlobalAddAtom( pszT );                                \
            SendMessage( hwndCl, WM_DDE_ACK, (WPARAM)hwndSv,            \
                         MAKELPARAM( gaA, gaT ));                       \
            GlobalDeleteAtom( gaT );                                    \
            GlobalDeleteAtom( gaA );  }

#define IDEFWINDOWPROC                  DefWindowProc
#define IDELETEBITMAP(hbm)              (DeleteObject( (LPVOID)hbm ))
#define IDELETESETID(hdc,hfont)         (DeleteObject( hfont ))
#define IDELETESYSATOM(atm)             (GlobalDeleteAtom( atm ))

/**********************************************************************/
/* DestroyMsgQueue - No Windows NT equivalent. NT has only one system */
/*                  message queue and automatically creates a message */
/*                  queue per thread                                  */
/**********************************************************************/
#define IDESTROYMSGQUEUE(hmq)           (0)

/**********************************************************************/
/* Note: Don't destroy pointers LOADED in Win/NT, only those created  */
/**********************************************************************/
#define IDESTROYPOINTER(hPtr)           (DestroyIcon( hPtr ))
#define IDESTROYPS(hps)                 (0)
#define IDESTROYREGION(hdc,hrgn)        (DeleteObject( hrgn ))
#define IDESTROYWINDOW(hwnd)            (DestroyWindow( (HWND)hwnd ))
#define IDISMISSDLG(hDlg,res)           (EndDialog( hDlg, res ))

/**********************************************************************/
/* Note: Last parameter is pointer to MSG structure which has the     */
/*       same structure as OS/2s QMSG structure                       */
/**********************************************************************/
#define IDISPATCHMSG(hab,pmsg)          (DispatchMessage( pmsg ))

#define IDRAWTEXT(hdc,len,psz,prcl,cF,cB,fs)                            \
                                         (DrawText( hdc, psz, len, prcl, fs ))
#define IENABLEWINDOW(hwnd,fEnable)     (EnableWindow( hwnd, fEnable ))
#define IENABLEWINDOWUPDATE(hwnd,fVis)                                   \
                    ( SendMessage( hwnd, WM_SETREDRAW, (WPARAM)fVis, 0) )
#define IENDPAINT(hwnd,hps,lpps)        (EndPaint( hwnd, lpps ))
#define IERASE(hps)                     (0)    // Paint or WM_ERASEBKGND needed
#define IFINDSYSATOM(psz)               (GlobalFindAtom( psz ))

/**********************************************************************/
/* Note: Last parameter needs brush handle, not clr ID                */
/**********************************************************************/
#define IFILLRECT(hps,prcl,hbr)         (FillRect( hps, prcl, hbr ))

#define IFLASHWINDOW(hwnd,bFlash)       (FlashWindow( hwnd, bFlash ))
#define IGETKEYSTATE(hwnd,vkey)         (GetKeyState( vkey ))
#define IGETMSG(hab,pqmsg,hwnd,f1,f2)   (GetMessage( pqmsg, hwnd, f1, f2 ))
#define IGETPS(hwnd)                    (GetDC( hwnd ))
#define IGETSYSBITMAP(idx)              (LoadBitmap( NULL, (LPCSTR)idx ))

/**********************************************************************/
/* Note: No anchor blocks necessary in Windows                        */
/**********************************************************************/
#define IINITIALIZE()                   (0)

#define IINVALIDATERECT(hwnd,prcl,fl)  \
  (RedrawWindow( hwnd, prcl, 0, \
    RDW_ERASE | RDW_FRAME | RDW_INVALIDATE | RDW_ERASENOW | \
    (fl ? RDW_ALLCHILDREN : 0) ))

#define IISCHILD(hwnd,hwndParent)       (IsChild( hwndParent, hwnd ))
#define IISWINDOW(hab,hwnd)             (IsWindow( (HWND)hwnd ))
#define IISWINDOWENABLED(hwnd)          (IsWindowEnabled( hwnd ))
#define IISWINDOWVISIBLE(hwnd)          (IsWindowVisible( hwnd ))
#define ILINE(hdc,pptl)            (LineTo( hdc, (int)pptl->x, (int)pptl->y ))

/**********************************************************************/
/* Requires instance handle of module passed                          */
/**********************************************************************/
#define ILOADBITMAP(hps,hmod,idBmp,lWd,lHt)                             \
                                 (LoadBitmap( hmod, MAKEINTRESOURCE( idBmp )))
#define ILOADDLG(hPar,hOwn,pfnwp,hInst,idDlg,pParms)                    \
     CreateDialogParam( hInst, MAKEINTRESOURCE( idDlg ), hOwn, pfnwp, pParms )
#define ILOADMENU(hwnd,hInst,idMenu)                                    \
                                 (LoadMenu( hInst, MAKEINTRESOURCE( idMenu )))
#define ILOADMESSAGE(hab,hmod,id,len,psz)                                    \
 (FormatMessage( FORMAT_MESSAGE_FROM_HMODULE | FORMAT_MESSAGE_IGNORE_INSERTS,\
                 hmod, id, MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT), \
                 psz, len, NULL ))
#define ILOADPOINTER(hInst,idPtr)                                       \
                        (LoadCursor( hInst, MAKEINTRESOURCE( idPtr ) ))
#define ILOADSTRING(hab,hInst,idStr,len,psz)                            \
                             (LoadString( hInst, (UINT)idStr, psz, (int)len ))
#define IMAPWINDOWPOINTS(hFrom,hTo,pptl,num)                            \
                     (MapWindowPoints( hFrom, hTo, (POINT*)(void*)pptl, num ))
#define IMESSAGEBOX(hPar,hOwn,pszTxt,pszCap,idBox,fType)                \
                             (MessageBox( hOwn, pszTxt, pszCap, (UINT)fType ))
#define IMOVE(hdc,pptl)    (MoveToEx( hdc, (int)pptl->x, (int)pptl->y, NULL ))
#define IOPENDC(hab,lType,psz,num,pdevData,hdcC)                        \
                                       (CreateDC( NULL, psz, NULL, pdevData ))
#define IPEEKMSG(hab,pqmsg,hwnd,f1,f2,f3) (PeekMessage(pqmsg,hwnd,f1,f2,f3))
#define IPOPUPMENU(hParent,hOwner,hMenu,x,y,idItem,fl)                  \
                          (TrackPopupMenu( hMenu, fl, x, y, 0, hOwner, NULL ))
#define IPOSTQUEUEMESSAGE(tid,msg,mp1,mp2)                             \
                          (PostThreadMessage( tid, (UINT)msg, mp1, mp2 ))
 #define IPOSTMESSAGE(hwnd,msg,mp1,mp2) \
                             (PostMessage( hwnd, (UINT)msg, mp1, mp2 ))

#define IQUERYACTIVEWINDOW(hwnd)        (GetActiveWindow())
#define IQUERYANCHOR(hwnd)              (0)
#define IQUERYBACKCOLOR(hdc)            (GetBkColor( hdc ))
#define IQUERYBITMAPDIMENSION(hbm,psizl)                                \
                                        (GetBitmapDimensionEx( hbm, psizl ))
/**********************************************************************/
/* Note: pbmp points to a BITMAP structure (not a BMPINFOHDR)         */
/**********************************************************************/
#define IQUERYBITMAPPARAMETERS(hbm,pbmp)                                \
                                      (GetObject( hbm, sizeof(BITMAP), pbmp ))

/**********************************************************************/
/* Note: Third paramter is last character, not count of characters    */
/**********************************************************************/
#define IQUERYCHARWIDTH(hps,lfc,llc,ppl)  (GetCharWidth( hps, lfc, llc, ppl ))
#define IQUERYCLASSNAME(hwnd,len,psz)   (GetClassName( hwnd, psz, len ))

/**********************************************************************/
/* Window classses for predefined controls                            */
/**********************************************************************/
#define WC_FRAME             "ICL Frame"

#define WC_COMBOBOX          "ComboBox"
#define WC_COMBOLBOX         "ComboLBox"
#define WC_BUTTON            "Button"
/*#define WC_MENU                                ????????????????? */
#define WC_STATIC            "Static"
#define WC_ENTRYFIELD        "Edit"
#define WC_LISTBOX           "ListBox"
#define WC_SCROLLBAR         "ScrollBar"
/*#define WC_TITLEBAR                            ????????????????? */
#define WC_MLE               "Edit"     /* Note: Must use ES_MULTILINE style */

#define WC_SPINBUTTON        "ICL Spin Button"
#define WC_CONTAINER         "ICL Container"
#define WC_SLIDER            "ICL Slider"
#define WC_NOTEBOOK          "ICL Notebook"
#define WC_CIRCULARSLIDER    "ICL Circular Slider"
#define WC_NATIVECONTAINER   "ICL Native Container"
#define WC_NATIVESPINBUTTON  "ICL Native SpinButton"
#define WC_NATIVESLIDER      "ICL Native Slider"
#define WC_TABPAGECLIP       "ICL Tab Page"

/**********************************************************************/
/* Doesn't return pInfo (probably not needed)                         */
/**********************************************************************/
#define IQUERYCLIPBRDFMTINFO(hab,ulfmt,pInfo)                           \
                                        (IsClipboardFormatAvailable( ulfmt ))

#define IQUERYCOLORINDEX(hpal,clrf)     (GetNearestPaletteIndex( hpal, clrf ))
#define IQUERYDESKTOPWINDOW(hab,hdc)    (GetDesktopWindow())
#define IQUERYDEVICE(hdc)               (hdc)
#define IQUERYDEVICECAPS(hdc,idx,pArr)  (*pArr = GetDeviceCaps( hdc, idx ))
#define IQUERYFOCUS(hwnd)               (GetFocus())
#define IQUERYFONTMETRICS(hdc,len,pfm)  (GetTextMetrics( hdc, pfm ))

/**********************************************************************/
/* Different structure used for returning information of min/max pos  */
/**********************************************************************/
#define IQUERYMAXPOSITION(hwnd,lpwp)    (GetWindowPlacement( hwnd, lpwp ))
#define IQUERYMINPOSITION(hwnd,lpwp)    (GetWindowPlacement( hwnd, lpwp ))

/**********************************************************************/
/* Returns DWORD value containing x,y coordinates of cursor position  */
/**********************************************************************/
#define IQUERYMSGPOS(hab,pptl)         { DWORD pt = GetMessagePos();    \
                                         (pptl)->x = LOWORD(pt);        \
                                         (pptl)->y = HIWORD(pt); }

/**********************************************************************/
/* QueryQueueInfo - No Windows NT equivalent.  NT has only one system */
/*                  message queue and automatically creates a message */
/*                  queue per thread                                  */
/**********************************************************************/
#define IQUERYQUEUEINFO(hmq,pmqi,cb)    (0)

/**********************************************************************/
/* Note: Last parameter is pointer to ICONINFO (not POINTERINFO)      */
/**********************************************************************/
#define IQUERYPOINTERINFO(hcur,pici)    (GetIconInfo( hcur, pici ))

/**********************************************************************/
/* Note: First pointer is palette handle (not hps)                    */
/**********************************************************************/
#define IQUERYRGBCOLOR(hpal,idx,pPe)    (GetPaletteEntries( hpal,idx,1,pPe ))

#define IQUERYSYSATOMNAME(atm,psz,len)  (GlobalGetAtomName( atm, psz, len ))
#define IQUERYSYSCOLOR(idx)             (GetSysColor( idx ))
#define IQUERYSYSPOINTER(idPtr,bCpy,iWin)                               \
                  ((iWin) ?                                             \
                  (LoadCursor( NULL, MAKEINTRESOURCE(idPtr) )) : \
                  (LoadIcon( NULL, MAKEINTRESOURCE(idPtr) )))
#define IQUERYSYSVALUE(idx)             (GetSystemMetrics( idx ))

/**********************************************************************/
/* Note: Last parameter is pointer to SIZEL (not array of POINTL)     */
/**********************************************************************/
#define IQUERYTEXTBOX(hdc,len,psz,pszl)                                 \
                                   (GetTextExtentPoint( hdc, psz, len, pszl ))
#define IQUERYUPDATERECT(hwnd,prcl)     (GetUpdateRect( hwnd, prcl, FALSE ))
#define IQUERYUPDATEREGION(hwnd,hrgn)   (GetUpdateRgn( hwnd, hrgn, FALSE ))

/**********************************************************************/
/* Note: Returned version numbers are not equivalent (obviously)      */
/**********************************************************************/
#define IQUERYVERSION(hab)              (GetVersion())

/**********************************************************************/
/* Note: Last parameter is pointer to rectangle whose coordinates are */
/*       returned relative to the screen (i.e. position)              */
/**********************************************************************/
#define IQUERYWINDOWPOS(hwnd,prcl)      (GetWindowRect( hwnd, prcl ))

/**********************************************************************/
/* Note: for future use, if only desiring process Id, don't use macro */
/**********************************************************************/
#define IQUERYWINDOWPROCESS(hwnd,ppid,ptid)                             \
                          (*((DWORD*)ptid) = GetWindowThreadProcessId(  \
                             (HWND)(hwnd), (DWORD*)(ppid) ))

#define IQUERYWINDOWPTR(hwnd,idx)       (GetWindowLong( hwnd, idx ))
#define IQUERYWINDOWRECT(hwnd,prcl)     (GetWindowRect( hwnd, prcl ))
#define IQUERYWINDOWTEXT(hwnd,len,psz)  (GetWindowText( hwnd, psz, (int)len ))
#define IQUERYWINDOWTEXTLENGTH(hwnd)    (GetWindowTextLength( hwnd ))
#define IQUERYWINDOWULONG(hwnd,idx)     (GetWindowLong( hwnd, (int)idx ))
#define IQUERYWINDOWUSHORT(hwnd,idx)    (GetWindowWord( hwnd, (int)idx ))
#define IRELEASEHOOK(hab,hwnd,lHk,pfnh,hmod,hHk)                        \
                                        (UnhookWindowsHookEx( hHk ))
#define IRELEASEPS(hwnd,hdc)            (ReleaseDC( hwnd, hdc ))
#define ISENDMESSAGE(hwnd,msg,mp1,mp2) \
                             (SendMessage( hwnd, (UINT)msg, mp1, mp2 ))

#define ISETBACKCOLOR(hdc,lColor)       (SetBkColor( hdc, lColor ))
#define ISETBACKMIX(hdc,lMix)           (SetBkMode( hdc, lMix ))
#define ISETBITMAP(hdc,hBmp)            (SelectObject( hdc, hBmp ))
#define ISETCHARSET(hdc,hFont)          (SelectObject( hdc, hFont ))
#define ISETCLIPREGION(hps,hrgn,phrgn)  (SelectClipRgn( hps, hrgn ))
#define ISETFOCUS(hwndDesktop,hwnd)     (SetFocus( hwnd ))
#define ISETHOOK(hab,hwnd,idHk,pfnh,hmod,hHk)                           \
 (hHk = SetWindowsHookEx( idHk, pfnh, hmod,                             \
                          GetWindowThreadProcessId( hwnd, NULL )))
#define ISETMIX(hdc,lMix)               (SetROP2( hdc, lMix ))

/**********************************************************************/
/* In Windows NT, after creating an owned window, an application      */
/* cannot transfer ownership of the window to another window          */
/**********************************************************************/
#define ISETOWNER(hwnd,hwndNewOwner)    (0)

/**********************************************************************/
/* If bRedraw is TRUE, must manually redraw windows if necessary      */
/*  NOTE: Might want to modify to add updatewindow call if true       */
/**********************************************************************/
#define ISETPARENT(hwnd,hwndNewParent,bRedraw)                          \
                                        (SetParent( hwnd, hwndNewParent ))
#define ISETPOINTER(hCur)               (SetCursor( hCur ))
#define ISETSYSCOLORS(cnt,pTab1,pTab2)  (SetSysColors( cnt, pTab1, pTab2 ))

/**********************************************************************/
/* Check logic when executed in Windows NT                            */
/**********************************************************************/
#define ISETWINDOWBITS(hwnd,idx,val,msk)                                \
                                { long temp;                            \
                                  temp = GetWindowLong( hwnd, idx );    \
                                  if (val)                              \
                                    temp |= (msk & val);                \
                                  else                                  \
                                    temp &= ^msk;                       \
                                  SetWindowLong( hwnd, idx, temp ); }

#define ISETWINDOWPOS(hwnd,hIns,x,y,cx,cy,fs)                           \
             (SetWindowPos( hwnd, hIns, (int)x, (int)y, (int)cx, (int)cy, fs ))
#define ISETWINDOWSTYLE(hwnd,val)   (SetWindowLong( hwnd, GWL_STYLE, val ))
#define ISETWINDOWTEXT(hwnd,psz)        (SetWindowText( hwnd, psz ))
#define ISETWINDOWULONG(hwnd,idx,val)   (SetWindowLong( hwnd, (int)idx, val ))
#define ISETWINDOWUSHORT(hwnd,idx,val)  (SetWindowWord( hwnd, (int)idx, val ))
#define ISHOWWINDOW(hwnd,sw)                                            \
                      (ShowWindow( hwnd, sw ? SW_SHOW : SW_HIDE ))
#define ISTARTTIMER(hab,hwnd,idx,intv)                                  \
                                   (SetTimer( hwnd, idx, intv, (TIMERPROC) 0))
#define ISTOPTIMER(hab,hwnd,idx)        (KillTimer( hwnd, idx ))
#define ISUBCLASSWINDOW(hwnd,pfnwp)                                     \
                       (SetWindowLong( (HWND)hwnd, GWL_WNDPROC, (LONG)pfnwp ))
#define ITERMINATE(hab)                 (0)
#define IUPDATEWINDOW(hwnd)             (UpdateWindow( hwnd  ))
#define IVALIDATERECT(hwnd,prcl)        (ValidateRect( hwnd, prcl ))
#define IWCBITBLT(hdcT,hdcS,aptl,lrop,opt)                              \
 (BitBlt( hdcT, aptl[0].x, aptl[0].y, aptl[1].x-aptl[0].x,              \
          aptl[1].y-aptl[0].y, hdcS, aptl[2].x, aptl[2].y, lrop ))
#define IWINDOWFROMID(hwnd,id)          (GetDlgItem( hwnd, (int)id ))
#define IWINDOWFROMPOINT(hwnd,ppt,fl)                                   \
                     (WindowFromPoint((*(POINT*)(void*)ppt) ))

/**********************************************************************/
/* The following are useful extensions of functions provided          */
/**********************************************************************/
#define ISTYLEOF(hwnd)                  (GetWindowLong( hwnd, GWL_STYLE ))
// IIDOF and ISETIDOF rely on all non-WS_CHILD windows having an
// extra window longword for the ID.  The IFrameWindow class insures
// this word is present.
// NOTE: ID's are always 2 bytes long, not 4.
#define IIDOF(hwnd)                                                     \
                   ( (GetWindowLong( hwnd, GWL_STYLE ) & WS_CHILD) ?    \
      (unsigned short)GetWindowLong( hwnd, GWL_ID  ) :                  \
      (unsigned short)GetWindowLong( hwnd, IGWL_ID ) )

#define ISETIDOF(hwnd,id)                                               \
                   ( (GetWindowLong( hwnd, GWL_STYLE ) & WS_CHILD) ?    \
                      SetWindowLong( hwnd, GWL_ID, id ) :               \
                      SetWindowLong( hwnd, IGWL_ID,id ) )
#define IPARENTOF(hwnd)                 (GetParent( hwnd ))
#define IOWNEROF(hwnd)                  (GetWindow( hwnd, GW_OWNER ))
#define ISETCAPTURE(rc, hwnd)                                           \
                    { HWND hwndCapture(SetCapture( hwnd ));             \
                      if (hwndCapture)                                  \
                      {                                                 \
                        SetCapture( hwndCapture );                      \
                        rc = false;                                     \
                      }                                                 \
                      else                                              \
                        rc = true; }
#define IRELEASECAPTURE                 (ReleaseCapture( ))
#define IQUERYCAPTURE                   (GetCapture( ))
#define IQUERYPOINTER                   (GetCursor( ))
#define IQUERYPOINTERPOSITION(ptx,pty)                                        \
                                  { POINT pt;                                 \
                                    GetCursorPos( &pt );                      \
                                    ptx = pt.x;                               \
                                    pty = pt.y; }
#define ISETPOINTERPOSITION(x,y)        (SetCursorPos( (int)x, (int)y ))
#define IQUERYUSERDATA(hwnd)            (GetWindowLong( hwnd, GWL_USERDATA ))
#define ISETUSERDATA(hwnd,valu) (SetWindowLong(hwnd, GWL_USERDATA, (LONG)valu))
#define IQUERYWINDOWPROCEDURE(hwnd) ((void*)GetWindowLong( hwnd, GWL_WNDPROC ))


/*------------------------------------------------------------------------------
| Macros for Win32 clipboard functions                                         |
------------------------------------------------------------------------------*/
/* The following functions not directly supported:                  */
/*    SetClipboardData, GetClipboardFormatName, SetClipboard owner  */
#define IOPENCLIPBOARD(hab, hwnd)           (OpenClipboard(hwnd))
#define ICLOSECLIPBOARD(hab)                (CloseClipboard())
#define IREGISTERCLIPBOARDFORMAT(psz)       (RegisterClipboardFormat(psz))
#define IFINDCLIPBOARDFORMAT(psz)           (GetClipboardFormat(psz))
#define IGETCLIPBOARDFORMATTEXT(fmt, psz, len)                          \
                                  (GetClipboardFormatName((UINT)fmt,psz, len))
#define IEMPTYCLIPBOARD(hab)                (EmptyClipboard())
#define IGETCLIPBOARDOWNER(hab)             (GetClipboardOwner())
#define ISETCLIPBOARDVIEWER(hab, hwnd)      (SetClipboardViewer(hwnd))
#define IGETCLIPBOARDVIEWER(hab)            (GetClipboardViewer())
#define IENUMCLIPBOARDFORMATS(hab, ulFormat)                            \
                                        (EnumClipboardFormats((UINT)ulFormat))
#define IGETCLIPBOARDDATA(hab, ulFormat )   (GetClipboardData((UINT)ulFormat))

/*------------------------------------------------------------------------------
| Macros for Windows accelerator table functions                               |
|   Note no direct equivalents for QueryAccelTable or SetAccelTable.  See      |
|   iacceltb code for ways to support these.                                   |
------------------------------------------------------------------------------*/
#define ICOPYACCELTABLE(haccel,pbuf,size)                               \
                             (CopyAcceleratorTable( haccel, pbuf, (int)size ))
#define ICREATEACCELTABLE(pbuf,count)                                   \
                             (CreateAcceleratorTable( pbuf, (int)count ))
#define IDESTROYACCELTABLE(hAccel)      (DestroyAcceleratorTable( hAccel ))
#define ILOADACCELTABLE(hab,hInst,idAcc)                                \
                         (LoadAccelerators( hInst, MAKEINTRESOURCE( idAcc ) ))

/*------------------------------------------------------------------------------
| Macro to get a palette-relative RGB for an unsigned long RGB value           |
------------------------------------------------------------------------------*/
#define NEARESTPALETTECOLOR(ulRGB)           (0x02000000L | ulRGB)

/**********************************************************************/
/* The following are type mappings for Windows NT                     */
/**********************************************************************/
#define MRESULT               LRESULT
#define PFIELDINFO            LPFIELDINFO
#define PRECORDCORE           LPRECORDCORE
#define PCNRDRAWITEMINFO      LPCNRDRAWITEMINFO
#define PCNREDITDATA          LPCNREDITDATA
#define PNOTIFYRECORDENTER    LPNOTIFYRECORDENTER
#define PNOTIFYRECORDEMPHASIS LPNOTIFYRECORDEMPHASIS
#define PNOTIFYSCROLL         LPNOTIFYSCROLL
#define PNOTIFYDELTA          LPNOTIFYDELTA
#define POWNERBACKGROUND      LPOWNERBACKGROUND

/**********************************************************************/
/* The following are macro mappings for Windows NT                    */
/**********************************************************************/
#define MPFROMLONG(l)              ((VOID *)(ULONG)(l))
#define MPFROMP(p)                 ((VOID *)((ULONG)(p)))
#define MPFROMSHORT(s)             ((VOID *)(USHORT)(s))
#define MPFROM2SHORT(s1, s2)       ((VOID *)MAKELONG(s1, s2))

/**********************************************************************/
/* The following are WM_COMMAND translations codes for Windows NT     */
/**********************************************************************/
#define CMDSRC_MENU            0       //value used by Windows
#define CMDSRC_ACCELERATOR     1       //value used by Windows
#define CMDSRC_PUSHBUTTON      2       //value defined for ICLUI
#define CMDSRC_OTHER           3       //value defined for ICLUI

/**********************************************************************/
/* The following are message API mappings for Windows NT              */
/*                                                                    */
/**********************************************************************/
/* ----------------------- General messages --------------------------*/
#define WM_BUTTON1DBLCLK  WM_LBUTTONDBLCLK
#define WM_BUTTON1DOWN    WM_LBUTTONDOWN
#define WM_BUTTON1UP      WM_LBUTTONUP
#define WM_BUTTON2DBLCLK  WM_RBUTTONDBLCLK
#define WM_BUTTON2DOWN    WM_RBUTTONDOWN
#define WM_BUTTON2UP      WM_RBUTTONUP
#define WM_BUTTON3DBLCLK  WM_MBUTTONDBLCLK   /* If a 2 button mouse,  */
#define WM_BUTTON3DOWN    WM_MBUTTONDOWN     /* WM_RBUTTON* is        */
#define WM_BUTTON3UP      WM_MBUTTONUP       /* WM_BUTTON2* ????????  */
#define WM_CONTROLPOINTER WM_SETCURSOR
#define WM_INITDLG        WM_INITDIALOG
#define WM_QUERYDLGCODE   WM_GETDLGCODE   /* OS/2 passes QMSG, NT no parms */

#ifdef IUSING_OLE
#define DO_MOVE    DROPEFFECT_MOVE
#define DO_COPY    DROPEFFECT_COPY
#define DO_LINK    DROPEFFECT_LINK
#define DO_DEFAULT 0x20

#define SETDefFormatEtc(fe, cf, med)   \
    {\
    (fe).cfFormat=cf;\
    (fe).dwAspect=DVASPECT_CONTENT;\
    (fe).ptd=NULL;\
    (fe).tymed=med;\
    (fe).lindex=-1;\
    }

#endif

#define DRT_BINDATA "BinaryData"
#define DRT_BITMAP  "Bitmap"
#define DRT_ICON    "ICon"
#define DRT_TEXT    "Text"
#define DRT_UNKNOWN "Unknown"

#define DRG_ICON         0x00000001
#define DRG_BITMAP       0x00000002
#define DRG_POLYGON      0x00000004
#define DRG_STRETCH      0x00000008
#define DRG_TRANSPARENT  0x00000010
#define DRG_CLOSED       0x00000020

#define DO_COPYABLE          0x1
#define DO_MOVEABLE          0x2
#define DO_LINKABLE          0x4
#define DO_UNKNOWN        0xBFFF

#define DC_OPEN              0x1
#define DC_REF               0x2
#define DC_GROUP             0x4
#define DC_CONTAINER         0x8
#define DC_PREPARE           0x10
#define DC_REMOVEABLEMEDIA   0x20

#define DRG_REGISTERED_DROP     0x01
#define DRG_REGISTERED_DRAG     0x02
#define DRG_REGISTERED_DRAGDROP 0x03
/* ----------------------- ICL misc values ---------------------------*/
#define MAXNAMEL              60         // From PMSHL.H
#define TID_USERMAX           0x7FFF     // From PMWIN.H
#define WS_PARENTCLIP          0
#define WS_SAVEBITS            0
#define WS_SYNCPAINT           0
#define QMSG  MSG                        //JJB
typedef unsigned long tib_t;             //JJB
#define HLPM_FRAME            (-1)       // From PMHELP.H
#define HLPM_WINDOW           (-2)       // From PMHELP.H
#define HLPM_MENU             (-3)       // From PMHELP.H
#define IHELPTABLERESOURCE      "HELPTABLE"
#define IHELPSUBTABLERESOURCE   "HELPSUBTABLE"
#define PP_FOREGROUNDCOLOR           1L  // From PMWIN.H
#define PP_FOREGROUNDCOLORINDEX      2L  // From PMWIN.H
#define PP_BACKGROUNDCOLOR           3L  // From PMWIN.H
#define PP_BACKGROUNDCOLORINDEX      4L  // From PMWIN.H

/* --------------------- Message Box values --------------------------*/
#define MB_NOICON          0
#define MB_INFORMATION     MB_ICONASTERISK
#define MB_WARNING         MB_ICONEXCLAMATION
#define MB_ERROR           MB_ICONHAND
#define MBID_OK            IDOK
#define MBID_CANCEL        IDCANCEL
#define MBID_ABORT         IDABORT
#define MBID_RETRY         IDRETRY
#define MBID_IGNORE        IDIGNORE
#define MBID_YES           IDYES
#define MBID_NO            IDNO
#define MBID_ERROR         0

/* ------------------------- Frame Control ---------------------------*/
#define FID_MENU               0x8005
#define FID_CLIENT             0x8008
#define DID_OK                 IDOK
#define DID_CANCEL             IDCANCEL

/* LOWORD(wParam) values for WM_QUERYFOCUSCHAIN, which is implemented */
/* as a  user message.                                                */
#define QFC_NEXTINCHAIN            0x0001
#define QFC_ACTIVE                 0x0002
#define QFC_FRAME                  0x0003
#define QFC_SELECTACTIVE           0x0004
#define QFC_PARTOFCHAIN            0x0005


/* --------------------- Control Notifications -----------------------*/
#define CBN_EFCHANGE    CBN_EDITCHANGE
#define CBN_SHOWLIST    CBN_DROPDOWN
#define CBN_ENTER       CBN_DBLCLK
#define CBN_MEMERROR    CBN_ERRSPACE
#define CBN_LBSELECT    CBN_SELCHANGE
#define LN_ENTER        LBN_DBLCLK
#define LN_KILLFOCUS    LBN_KILLFOCUS
#define LN_SETFOCUS     LBN_SETFOCUS
#define LN_SELECT       LBN_SELCHANGE

/* ------------------------- Button Control --------------------------*/
#define BM_QUERYHILITE    BM_GETSTATE
#define BM_SETHILITE      BM_SETSTATE
#define BM_QUERYCHECK     BM_GETCHECK
#define BN_DBLCLICKED     BN_DOUBLECLICKED
#define BS_PRIMARYSTYLES  0x000fL

/* ------------------------- ListBox/Combobox Control -----------------*/
#define LS_HORZSCROLL            WS_HSCROLL
#define LIT_SORTASCENDING        (ULONG)(-2)
#define LIT_SORTDESCENDING       (ULONG)(-3)
#define LIT_END                  (ULONG)(-1)
#define LIT_NONE                 (ULONG)(-1)
#define LIT_FIRST                (ULONG)(-1)

/* --------------------------- Menu Control --------------------------*/
#define MIT_END                  MF_END
#define MIS_SUBMENU              MF_POPUP
#define MIS_BITMAP               MFT_BITMAP
#define MIS_TEXT                 MFT_STRING
#define MIS_BREAK                MFT_MENUBREAK
#define MIS_BREAKSEPARATOR       MFT_MENUBARBREAK
#define MIS_OWNERDRAW            MFT_OWNERDRAW
#define MIS_SEPARATOR            MFT_SEPARATOR
#define MIA_CHECKED              MFS_CHECKED
#define MIA_DISABLED             MFS_GRAYED
#define MIA_HILITED              MFS_HILITE
#define MIS_SYSCOMMAND           0
#define MIS_HELP                 0
#define MIS_BUTTONSEPARATOR      0
#define MIA_NODISMISS            0
#define MIA_FRAMED               0
#define MIS_STATIC               MF_DISABLED
#define PROP_MENUBAR_OBJECT      "ICL_MENUBAR_OBJECT"
#define SC_TASKMANAGER           SC_TASKLIST
#define SC_SYSMENU               0   // Must be NULL

/* --------------------------- Edit Control --------------------------*/
#define EM_CLEAR                 WM_CLEAR
#define EM_COPY                  WM_COPY
#define EM_CUT                   WM_CUT
#define EM_PASTE                 WM_PASTE
#define EM_QUERYCHANGED          EM_GETMODIFY   /* use EM_SETMODIFY to reset */
                                                /* modification flag         */
#define EM_QUERYFIRSTCHAR        EM_GETFIRSTVISIBLELINE
#define EM_QUERYSEL              EM_GETSEL
#define EM_SETTEXTLIMIT          EM_LIMITTEXT
#define ES_AUTOSCROLL            ES_AUTOHSCROLL
#define ES_MARGIN                WS_BORDER
#define ES_UNREADABLE            ES_PASSWORD
#define ES_AUTOTAB               0
#define ES_COMMAND               0
#define ES_SBCS                  0
#define ES_DBCS                  0

/* --------------------------- MLE Control ---------------------------*/
#define MLM_SETREADONLY          EM_SETREADONLY
#define MLM_QUERYCHANGED         EM_GETMODIFY
#define MLM_SETCHANGED           EM_SETMODIFY
#define MLM_CHARFROMLINE         EM_LINEINDEX
#define MLM_QUERYLINELENGTH      EM_LINELENGTH
#define MLM_SETTEXTLIMIT         EM_LIMITTEXT
#define MLM_QUERYSEL             EM_GETSEL
#define MLM_SETSEL               EM_SETSEL
#define MLM_CLEAR                WM_CLEAR
#define MLM_COPY                 WM_COPY
#define MLM_CUT                  WM_CUT
#define MLM_PASTE                WM_PASTE
#define MLM_UNDO                 EM_UNDO
#define MLM_QUERYUNDO            EM_CANUNDO
#define MLM_SETFORMATRECT        EM_SETRECT
#define MLM_QUERYFORMATRECT      EM_GETRECT
#define MLM_SETTABSTOP           EM_SETTABSTOPS
#define MLM_QUERYLINECOUNT       EM_GETLINECOUNT
#define MLM_LINEFROMCHAR         EM_LINEFROMCHAR
#define MLS_BORDER               WS_BORDER
#define MLS_VSCROLL              WS_VSCROLL
#define MLS_HSCROLL              WS_HSCROLL
#define MLS_READONLY             ES_READONLY
#define MLFIE_CFTEXT             0
#define MLFIE_NOTRANS            1
#define MLFIE_WINFMT             2

/* ------------------------- Static Control --------------------------*/
#define SM_SETHANDLE             STM_SETICON
#define SM_QUERYHANDLE           STM_GETICON

/* ------------------------- Scrollbar Control -----------------------*/
#define SBM_QUERYPOS    SBM_GETPOS

/* ------------------------- Font Dialog -----------------------------*/
#define FNTS_HELPBUTTON          CF_SHOWHELP
#define FNTS_APPLYBUTTON         CF_APPLY
#define FNTS_RESETBUTTON         0
#define FNTS_PROPORTIONALONLY    0
#define FNTS_BITMAPONLY          CF_NOVECTORFONTS
#define FNTS_VECTORONLY          CF_SCALABLEONLY
#define FNTS_FIXEDWIDTHONLY      CF_FIXEDPITCHONLY
#define FNTS_NOSYNTHESIZEDFONTS  CF_NOSIMULATIONS
#define FNTS_INITFROMFATTRS      CF_INITTOLOGFONTSTRUCT
#define FNTS_CUSTOM              CF_ENABLETEMPLATE

/* ------------------------- File Dialog -----------------------------*/
#define FDS_HELPBUTTON           OFN_SHOWHELP
#define FDS_CUSTOM               OFN_ENABLETEMPLATE
#define FDS_MULTIPLESEL          OFN_ALLOWMULTISELECT
#define FDS_PRELOAD_VOLINFO      0
#define FDS_ENABLEFILELB         0x000000800L
#define FDS_FILTERUNION          0
#define FDS_APPLYBUTTON          0
#define FDS_INCLUDE_EAS          0

/* ------------------------- Font mappings ---------------------------*/
#define CHDIRN_DEFAULT              0
#define CHDIRN_LEFTRIGHT            0
#define CHDIRN_TOPBOTTOM         -900
#define CHDIRN_RIGHTLEFT         1800
#define CHDIRN_BOTTOMTOP          900
#define DEGREETENTHS_TO_RADS     572.9577951

/**********************************************************************/
/* WM_CLOSE   - equivalent                                            */
/* WM_DESTROY - equivalent                                            */
/*--------------------------------------------------------------------*/
/* WM_COMMAND has parameter differences and is overloaded in NT       */
/* If lParam is NULL, then WM_COMAND functions like it does in OS/2   */
/* with hi part of wParam being command code, lo part being control   */
/* id, otherwise if lParam has a value, then it functions like a      */
/* WM_CONTROL message, with direct mapping equivalence                */
/*--------------------------------------------------------------------*/
/* WM_DRAWITEM message passes a LPDRAWITEMSTRUCT in on lParam         */
/* as opposed to LPOWNERDRAW (but not always) in OS/2                 */
/*--------------------------------------------------------------------*/
/* WM_HELP available in NT and 95, but not 32s, so we handle VK_F1    */
/*--------------------------------------------------------------------*/
/* WM_MEASUREITEM message passes a MEASUREITEMSTRUCT in on lParam     */
/* as opposed to passing values inside the two parameters             */
/*--------------------------------------------------------------------*/
/* WM_INITMENU message, no id passed, menu handle is in wParam        */
/*--------------------------------------------------------------------*/
/* WM_MENUSELECT message, only difference is in flag values in high   */
/* order word of wParam                                               */
/*--------------------------------------------------------------------*/
/* WM_SYSCOMMAND has wParam equivalency, but lParam is not equivalent */
/* CMDSRC_* values are combined as SC_ values in wParam and lParam is */
/* used to return mouse position if mouse was used to select          */
/*--------------------------------------------------------------------*/
/* WM_QUERYBORDERSIZE - must write equivalent function to query the   */
/* correct SM_* value based on frame window style                     */
/*--------------------------------------------------------------------*/
/* WM_SETBORDERSIZE - must write equivalent function to set the       */
/* correct SM_* value based on frame window style                     */
/*--------------------------------------------------------------------*/
/* WM_WINDOWPOSCHANGED passes pointer to WINDOWPOS in lParam, where   */
/* as OS/2 passes  just a pointer to SWP in mp1 and status in mp2     */
/*--------------------------------------------------------------------*/
/* WM_HSCROLL,                                                        */
/* WM_VSCROLL have parameter differences.  wParam contains the scroll */
/* code and position (in OS/2 mp2 has position and code).  lParam     */
/* contains scroll bar window handle (in OS/2 mp1 has window id)      */
/**********************************************************************/
#define SCROLL_PARMS( mp1, mp2 )       { WORD   nScrCmd, nScrPos;       \
                                         HWND   hwndScr;                \
                                         nScrCmd = LOWORD(mp1);         \
                                         nScrPos = HIWORD(mp1);         \
                                         hwndScr = (HWND)mp2; }

/**********************************************************************/
/* Following are mappings for virtual key definitions in Windows NT   */
/**********************************************************************/
#define VK_BUTTON1              VK_LBUTTON
#define VK_BUTTON2              VK_MBUTTON
#define VK_BUTTON3              VK_RBUTTON
#define VK_BREAK                VK_CANCEL
#define VK_BACKSPACE            VK_BACK
#define VK_NEWLINE              VK_RETURN
#define VK_CTRL                 VK_CONTROL
#define VK_ALT                  VK_MENU
#define VK_CAPSLOCK             VK_CAPITAL
#define VK_ESC                  VK_ESCAPE
#define VK_PAGEUP               VK_PRIOR
#define VK_PAGEDOWN             VK_NEXT
#define VK_ENTER                VK_RETURN
#define VK_PRINTSCRN            VK_SNAPSHOT
#define VK_SCRLLOCK             VK_SCROLL

/**********************************************************************/
/* Following are scroll bar event mappings needed for Windows NT, all */
/* others map exactly, although NT does have two unique SB_ values    */
/**********************************************************************/
#define SB_SLIDERPOSITION       SB_THUMBPOSITION
#define SB_SLIDERTRACK          SB_THUMBTRACK

/**********************************************************************/
/* Following are guesses at the mix mode mappings for Windows NT      */
/**********************************************************************/
#define BM_OVERPAINT            OPAQUE
#define BM_LEAVEALONE           TRANSPARENT
#define FM_OVERPAINT            R2_NOP
#define FM_INVERT               R2_NOT
#define ROP_SRCAND              SRCAND
#define ROP_SRCCOPY             SRCCOPY
#define ROP_SRCINVERT           SRCINVERT
#define ROP_SRCPAINT            SRCPAINT

/**********************************************************************/
/* Following are device capabilities mappings needed for Windows NT   */
/**********************************************************************/
#define CAPS_HORIZONTAL_FONT_RES   LOGPIXELSX
#define CAPS_VERTICAL_FONT_RES     LOGPIXELSY

/**********************************************************************/
/* Following are mappings for dialog code returns                     */
/*  Note: Windows doesn't have values for all codes returned and it   */
/*        also has some of its own unique returned codes              */
/**********************************************************************/
#define DLGC_DEFAULT            DLGC_DEFPUSHBUTTON
#define DLGC_PUSHBUTTON         DLGC_UNDEFPUSHBUTTON
#define DLGC_ENTRYFIELD         DLGC_HASSETSEL           /* ???? */

/**********************************************************************/
/* Following are mappings for thread priority levels in Windows NT    */
/* Note that in Win32 the priority class affects the process, not     */
/* just the thread.                                                   */
/**********************************************************************/
#define PRTYC_NOCHANGE         0
#define PRTYC_IDLETIME         IDLE_PRIORITY_CLASS
#define PRTYC_REGULAR          NORMAL_PRIORITY_CLASS
#define PRTYC_TIMECRITICAL     REALTIME_PRIORITY_CLASS
#define PRTYC_FOREGROUNDSERVER HIGH_PRIORITY_CLASS

/**********************************************************************/
/* Following are mappings for system pointers in Windows NT           */
/*  - In NT, some use Load Cursor, some use LoadIcon to obtain        */
/**********************************************************************/
#define SPTR_ARROW             (long)IDC_ARROW
#define SPTR_TEXT              (long)IDC_IBEAM
#define SPTR_WAIT              (long)IDC_WAIT
#define SPTR_MOVE              (long)IDC_SIZEALL
#define SPTR_SIZENWSE          (long)IDC_SIZENWSE
#define SPTR_SIZENESW          (long)IDC_SIZENESW
#define SPTR_SIZEWE            (long)IDC_SIZEWE
#define SPTR_SIZENS            (long)IDC_SIZENS
#define SPTR_ILLEGAL           (long)IDC_NO

#define SPTR_APPICON           (long)IDI_APPLICATION
#define SPTR_ICONINFORMATION   (long)IDI_ASTERISK
#define SPTR_ICONQUESTION      (long)IDI_QUESTION
#define SPTR_ICONERROR         (long)IDI_HAND
#define SPTR_ICONWARNING       (long)IDI_EXCLAMATION

/**********************************************************************/
/* Following are resource IDs for icons found in shell32.dll.         */
/* These are not documented in the SDK                                */
/**********************************************************************/
#define IC_FILE_SHELL32        1
#define IC_FOLDER_SHELL32      4
#define IC_PROGRAM_SHELL32     3
#define IC_DRIVE_SHELL32       7
#define IC_MULTIFILE_SHELL32   133
#define IC_SHELL32_DLL         "shell32"

/**********************************************************************/
/* Following are mappings for system bitmaps in Windows NT            */
/**********************************************************************/
#define SBMP_SYSMENU           OBM_CLOSE
#define SBMP_SYSMENUDEP        OBM_CLOSE
#define SBMP_SBUPARROW         OBM_UPARROW
#define SBMP_SBUPARROWDEP      OBM_UPARROWD
#define SBMP_SBUPARROWDIS      OBM_UPARROWI
#define SBMP_SBDNARROW         OBM_DNARROW
#define SBMP_SBDNARROWDEP      OBM_DNARROWD
#define SBMP_SBDNARROWDIS      OBM_DNARROWI
#define SBMP_SBRGARROW         OBM_RGARROW
#define SBMP_SBRGARROWDEP      OBM_RGARROWD
#define SBMP_SBRGARROWDIS      OBM_RGARROWI
#define SBMP_SBLFARROW         OBM_LFARROW
#define SBMP_SBLFARROWDEP      OBM_LFARROWD
#define SBMP_SBLFARROWDIS      OBM_LFARROWI
#define SBMP_MENUCHECK         OBM_CHECK
#define SBMP_MENUATTACHED      OBM_MNARROW
#define SBMP_CHECKBOXES        OBM_CHECKBOXES
#define SBMP_COMBODOWN         OBM_COMBO
#define SBMP_BTNCORNERS        OBM_BTNCORNERS
#define SBMP_MINBUTTON         OBM_REDUCE
#define SBMP_MINBUTTONDEP      OBM_REDUCED
#define SBMP_MAXBUTTON         OBM_ZOOM
#define SBMP_MAXBUTTONDEP      OBM_ZOOMD
#define SBMP_RESTOREBUTTON     OBM_RESTORE
#define SBMP_RESTOREBUTTONDEP  OBM_RESTORED
#define SBMP_SIZEBOX           OBM_SIZE

/**********************************************************************/
/* Following are mappings for system value definitions in Windows NT  */
/**********************************************************************/
#define SV_CXSIZEBORDER        SM_CXFRAME
#define SV_CYSIZEBORDER        SM_CYFRAME
#define SV_CXBORDER            SM_CXBORDER
#define SV_CYBORDER            SM_CYBORDER
#define SV_CXHSCROLLARROW      SM_CXHSCROLL
#define SV_CYHSCROLL           SM_CYHSCROLL
#define SV_CXHSLIDER           SM_CXHTHUMB
#define SV_CXVSCROLL           SM_CXVSCROLL
#define SV_CYVSCROLLARROW      SM_CYVSCROLL
#define SV_CYVSLIDER           SM_CYVTHUMB
#define SV_CXPOINTER           SM_CXCURSOR
#define SV_CYPOINTER           SM_CYCURSOR
#define SV_CXICON              SM_CXICON
#define SV_CYICON              SM_CYICON
#define SV_MOUSEPRESENT        SM_MOUSEPRESENT
#define SV_CMOUSEBUTTONS       SM_CMOUSEBUTTONS
#define SV_SWAPBUTTON          SM_SWAPBUTTON
#define SV_DEBUG               SM_DEBUG
#define SV_CYMENU              SM_CYMENU
#define SV_CXFULLSCREEN        SM_CXFULLSCREEN
#define SV_CYFULLSCREEN        SM_CYFULLSCREEN
#define SV_CXSCREEN            SM_CXSCREEN
#define SV_CYSCREEN            SM_CYSCREEN
#define SV_CYTITLEBAR          SM_CYCAPTION
#define SV_CXDLGFRAME          SM_CXDLGFRAME
#define SV_CYDLGFRAME          SM_CYDLGFRAME
#define SV_CXDBLCLK            SM_CXDOUBLECLK
#define SV_CYDBLCLK            SM_CYDOUBLECLK
#define SV_CXMINMAXBUTTON      SM_CXSIZE
#define SV_CYMINMAXBUTTON      SM_CYSIZE

/**********************************************************************/
/* Following are mappings for system color definitions in Windows NT  */
/**********************************************************************/
#define SYSCLR_MENUDISABLEDTEXT        COLOR_GRAYTEXT
#define SYSCLR_BUTTONDARK              COLOR_BTNSHADOW
#define SYSCLR_SHADOW                  COLOR_BTNHIGHLIGHT   // was COLOR_SHADOW
#define SYSCLR_HILITEFOREGROUND        COLOR_HIGHLIGHTTEXT
#define SYSCLR_HILITEBACKGROUND        COLOR_HIGHLIGHT
#define SYSCLR_INACTIVETITLETEXT       COLOR_INACTIVECAPTIONTEXT
#define SYSCLR_ACTIVETITLETEXT         COLOR_CAPTIONTEXT
#define SYSCLR_SCROLLBAR               COLOR_SCROLLBAR
#define SYSCLR_BACKGROUND              COLOR_BACKGROUND
#define SYSCLR_ACTIVETITLE             COLOR_ACTIVECAPTION
#define SYSCLR_INACTIVETITLE           COLOR_INACTIVECAPTION
#define SYSCLR_MENU                    COLOR_MENU
#define SYSCLR_WINDOW                  COLOR_WINDOW
#define SYSCLR_WINDOWFRAME             COLOR_WINDOWFRAME
#define SYSCLR_MENUTEXT                COLOR_MENUTEXT
#define SYSCLR_WINDOWTEXT              COLOR_WINDOWTEXT
#define SYSCLR_TITLETEXT               COLOR_CAPTIONTEXT
#define SYSCLR_ACTIVEBORDER            COLOR_ACTIVEBORDER
#define SYSCLR_INACTIVEBORDER          COLOR_INACTIVEBORDER
#define SYSCLR_APPWORKSPACE            COLOR_APPWORKSPACE
// Following is per 4.0 SDK, "System Bitmaps and Colors".  Note that
// COLOR_3DFACE is also the same as COLOR_BTNFACE in this SDK version.
#define SYSCLR_DIALOGBACKGROUND        COLOR_3DFACE

// The following color areas are not separate areas in Windows, or
// are not directly changable.  These are the mappings which in most
// cases result in similar behavior ... particularly if default colors
// set via properties/control panel are used.
#define SYSCLR_SHADOWHILITEBGND        COLOR_HIGHLIGHT
#define SYSCLR_SHADOWHILITEFGND        COLOR_HIGHLIGHTTEXT
#define SYSCLR_SHADOWTEXT              COLOR_WINDOWTEXT
#define SYSCLR_ENTRYFIELD              COLOR_WINDOW
#define SYSCLR_MENUHILITE              COLOR_HIGHLIGHTTEXT
#define SYSCLR_MENUHILITEBGND          COLOR_HIGHLIGHT
#define SYSCLR_PAGEBACKGROUND          SYSCLR_DIALOGBACKGROUND
#define SYSCLR_FIELDBACKGROUND         COLOR_INACTIVECAPTION
#define SYSCLR_BUTTONLIGHT             COLOR_BTNHIGHLIGHT
#define SYSCLR_BUTTONMIDDLE \
        ( (IPlatform::isWin9x() || IPlatform::isNTNewShell()) ? \
           COLOR_3DFACE : COLOR_BTNFACE )

//no mapping  SYSCLR_BUTTONDEFAULT ... appears to be black or xor
#define SYSCLR_TITLEBOTTOM             COLOR_MENU
#define SYSCLR_ICONTEXT                COLOR_WINDOWTEXT
#define SYSCLR_INACTIVETITLETEXTBGND   COLOR_INACTIVECAPTION
#define SYSCLR_ACTIVETITLETEXTBGND     COLOR_ACTIVECAPTION
#define SYSCLR_OUTPUTTEXT              COLOR_WINDOWTEXT
#define SYSCLR_WINDOWSTATICTEXT        COLOR_WINDOWTEXT
// The help values could map to COLOR_INFOBK/COLOR_INFOTEXT, which apply
// to tooltip controls but not normal help
#define SYSCLR_HELPBACKGROUND          COLOR_WINDOW
#define SYSCLR_HELPTEXT                COLOR_WINDOWTEXT
#define SYSCLR_HELPHILITE              COLOR_WINDOWTEXT

/**********************************************************************/
/* The following functions are described here since they do not map   */
/* well (or at all) between environments                              */
/**********************************************************************/
/* BroadcastMessage - No Windows NT equivalent, must manually send to */
/*                    descendants of window                           */
/**********************************************************************/
/* CreateMsgQueue,- No Windows NT equivalent.  NT has only one system */
/* DestroyMsgQueue  message queue and automatically creates a message */
/*                  queue per thread                                  */
/**********************************************************************/
/* EnumeratingChildWindows - In Windows NT, call the EnumChildWindows */
/* API, passing in the hwndParent, a callback window procedure and    */
/* any application specified value for the callback.  This callback   */
/* will receive the child window handles until you have received them */
/* all, or you explicitly return FALSE to stop enumeration.           */
/**********************************************************************/
/* EnumeratingDlgItems - In Windows NT, there are specific calls to   */
/*                find dlg items with the characteristics requested   */
/*                GetNextDlgTabItem and GetNextDlgGroupItem are       */
/*                calls retrieving next,prev,first,last info as       */
/*                specified, which maps to function of WinEnumDlgItem */
/**********************************************************************/
/* ProcessDlg - No direct equivalent.  Must specify modal or modeless */
/*              dialog style through use of dialog creation calls,    */
/*              either DialogBox or CreateDialog                      */
/**********************************************************************/
/* RegisterClass - In Windows NT, a pointer to a WNDCLASS structure   */
/*                 is passed when registering a class.  This structure*/
/*                 contains information that is passed by parameters  */
/*                 in OS/2 on both the WinRegisterClass call as well  */
/*                 as the WinCreateWindow call via id resources       */
/**********************************************************************/
/* TrackRect - No Windows NT equivalent, See icmnfun.cpp or cnrs3p1.c */
/*             for 2 split bar implementations (canvas and container) */
/**********************************************************************/

/*--------------------------------------------------------------------*/
/* fields in RECT structure                                           */
/*--------------------------------------------------------------------*/
#define MINX   left
#define MINY   top
#define MAXX   right
#define MAXY   bottom

/*--------------------------------------------------------------------*/
/* Use for window origin related ifdefs on otherwise portable code.   */
/*--------------------------------------------------------------------*/
#define IC_ORIGINUPPERLEFT

/*-------------------------- Pragma Library Support --------------------------*/
#pragma library("KERNEL32.LIB")
#pragma library("GDI32.LIB")
#pragma library("USER32.LIB")
#pragma library("COMDLG32.LIB")
#pragma library("OLE32.LIB")
#pragma library("UUID.LIB")
#pragma library("COMCTL32.LIB")
#pragma library("SHELL32.LIB")
#pragma library("WINSPOOL.LIB")
#pragma library("ADVAPI32.LIB")
#pragma library("OLEAUT32.LIB")

#endif /* IC_WIN */

/**********************************************************************/
/* otherwise OS/2 2.x program, so set the macros to call OS/2 APIs    */
/**********************************************************************/
#ifdef IC_PM
#include <os2.h>
#ifdef IC_MULTIMEDIA
  #ifndef OS2ME_INCLUDED
     #include <os2me.h>
  #endif
#endif

/*--------------------------------------------------------------------*/
/* Macros for Windows compatibility                                   */
/*--------------------------------------------------------------------*/
#define LOWORD(l) ((USHORT)((ULONG)l))
#define HIWORD(l) ((USHORT)(((ULONG)(l) >> 16) & 0xffff))
#define WPARAM    MPARAM

/*--------------------------------------------------------------------*/
/* PM container semi-published styles.(Not in pmstddlg.h)             */
/*--------------------------------------------------------------------*/
#ifndef CMA_DATAWIDTH
  #define CMA_DATAWIDTH    0x0200
#endif

#ifndef CRA_SOURCE
  #define CRA_SOURCE       0x00004000L
#endif

#ifndef CV_EXACTMATCH
  #define CV_EXACTMATCH    0x10000000L
#endif

#ifndef CCS_MINIICONS
  #define CCS_MINIICONS    0x00000800L
#endif

/*--------------------------------------------------------------------*/
/* IFrame extended styles                                             */
/*--------------------------------------------------------------------*/
#define IFS_HIDEBUTTON    0x00000008ul
#define IFS_DEFERCREATE   0x00000100ul

/*--------------------------------------------------------------------*/
/* IWindow border style (Win only, NOOP in PM)                        */
/*--------------------------------------------------------------------*/
#define IWS_BORDER3D      0x00000000ul

/*--------------------------------------------------------------------*/
/* Map Windows style back to OS/2 style - most macros go the other    */
/* way but we already overload the ES_AUTOSCROLL for entryfield and   */
/* since we use this also in combo, we need to do it backwards        */
/*--------------------------------------------------------------------*/
#define CBS_AUTOHSCROLL   ES_AUTOSCROLL

/***********************************************************************
  PM style masks definitions
   There are 3 basic types of masks defined.
   _MASK       - mask for the base styles
   _EXTMASK    - mask for ICLUI defined extended styles
   _EXTGUIMASK - mask for GUI defined extended styles.  In PM,
                 the only current use of this is for the frame
                 creation flags (FCF_) in IFrameWindow.
   The convertToGUIStyle function in the classes will return valid
   style bits to be passed to the GUI.  The ICLUI defined styles
   are translated to appropriate GUI flags by this function if
   needed.  For Windows, specifying extendedOnly=true will cause
   convertToGUIStyle to return any user style bits (24-31) ORed with
   the Windows extended styles (WS_EX_*) supported by the class.

   Classes which dont support any GUI extended styles typically use
   IS_EXTMASK to mask the extended styles.  If support is added for
   one or more GUI extended styles,  a _EXTGUIMASK definition should
   be added here and used instead.
***********************************************************************/
#define IWS_MASK        0xFFFF0000ul       // Window (WS_) reserved styles
#define IS_EXTMASK      0xFF000000ul       // Generic extended styles mask
#define IFS_MASK        0x000089FFul       // Frame window (FS_)
#define IFS_EXTGUIMASK  0xFFFF00F7ul       // Frame window.  GUI defined extended
#define IFS_EXTMASK     0x00000108ul       // Frame window extended
#define IFDS_MASK       0x00000FFFul       // File Dialog (FDS_)
#define IFDS_EXTMASK    IS_EXTMASK         // File Dialog extended mask
#define IFNTS_MASK      0x00001FFBul       // Font Dialog
#define IFNTS_EXTMASK   IS_EXTMASK         // Font Dialog extended mask
#define IMS_MASK        0x00000045ul       // Menu control
#define IMBS_MASK       0x00000000ul       // Menubar
#define IMBS_EXTMASK    0xFFFF0003ul       // Menubar extended
#define IMIS_MASK       0x00000FDFul       // Menu item
#define IMIS_EXTMASK    0xFFFF0000ul       // Menu item extended
#define IBS_MASK        0x00003FC0ul       // Button controls
#define IBS_EXTCHECKBX  0x00000006ul       // Button controls extended checkbox
#define IBS_EXTRADIOBTN 0x00000018ul       // Button controls extended radiobtn
#define IBS_EXT3STATE   0x00000060ul       // Button controls extended 3state
#define ILS_MASK        0x0000001Ful       // List box (LS_)
#define ILS_EXTGUIMASK  0x00000000ul       // List box extended - none in PM
#define IBKS_MASK       0x0000F7FFul       // Notebook (BKS_)
#define ICCS_MASK       0x0000007Ful       // Container (CCS_)
#define ISLS_SHAFTMASK  0x000007CFul       // Slider (SLS_) Shaft styles
#define ISLS_BUTTONMASK 0x00000030ul       // Slider (SLS_) Button styles
#define ISLS_EXTGUIMASK 0x00000000ul       // Slider GUI extended styles  - none in PM
#define IDT_MASK        0x0000FF80ul       // WinDrawText (DT_) styles
#define IDT_EXTMASK     0x00000000ul       // DrawText extended styles
#define ISS_EXTGUIMASK  0x00000000ul       // Static GUI extended styles-none in PM
#define IMLS_MASK       0x0000007Ful       // MLE styles
#define IES_MASK        0x000032FFul       // Entry field styles
#define IES_EXTMASK     0x00000007ul       // Entry field extended styles
#define ITC_EXTGUIMASK  0x00000000ul       // Text Control(EF and MLE) - none in PM
#define ICBS_MASK       0x0000301Ful       // Combo box styles
#define ICBS_EXTGUIMASK 0x00000000ul       // Combo box GUI extended styles - none in PM
#define ISPBS_MASK      0x000001BFul       // Spin button styles
#define ISPBS_EXTMASK   0x00000038ul       // Spin button extended styles
#define ISBS_MASK       0x00002007ul       // Scroll bar styles
#define ISS_BMPMASK     0x00000004ul       // Static bitmap style (SS_BITMAP)
#define IGB_MASK        0x00000080ul       // Graphic button style (BS_ICON)
#define IGB_EXTGUIMASK  0x00000000ul       // Group Box extended GUI styles  - none in PM
#define IOBS_EXTMASK    0x00000007ul       // Outline box extended styles
#define IOB_EXTGUIMASK  0x00000000ul       // Outline Box extended GUI styles  - none in PM
#define ICSS_MASK       0x000001FFul       // Circular Slider (CSS_)


/**********************************************************************/
/* Some of the common DOS calls like dossleep                         */
/**********************************************************************/
#define ISLEEP(msec)                    (DosSleep(msec))

/*--------------------------------------------------------------------*/
/* Win API macros are listed here                                     */
/*--------------------------------------------------------------------*/
#define IADDSYSATOM(psz)                                                \
                                 (WinAddAtom( WinQuerySystemAtomTable(), psz ))
#define IBEGINPAINT(hwnd,hps,prcl)      (WinBeginPaint( hwnd, hps, prcl ))
#define ICALCCLIENTRECT(hwnd,prcl)      (WinCalcFrameRect( hwnd, prcl, TRUE ))
#define ICOMPARESTRINGS(hab,idcp,idcc,psz1,psz2,fl)                     \
                         (WinCompareStrings( hab, idcp, idcc, psz1, psz2, 0 ))
#define ICREATEMSGQUEUE(hab,lqsiz)      (WinCreateMsgQueue( hab, lqsiz ))
#define ICREATEWINDOW(hPar,pszCNam,pszWNam,fSt,x,y,wdt,                 \
                      hgt,hOwn,hBeh,idW,pCtl,pPP,hInst)                 \
        (WinCreateWindow( hPar, pszCNam, pszWNam, fSt, x, y, wdt, hgt,  \
                          hOwn, hBeh, idW, pCtl, pPP ))
#define IDDEINITIATE(hwndCl,pszA,pszT,pCntx)                            \
                                 (WinDdeInitiate( hwndCl, pszA, pszT, pCntx ))
#define IDDEPOSTMSG(hwndTo,hwndFr,msg,pDde,opts)                        \
                            (WinDdePostMsg( hwndTo, hwndFr, msg, pDde, opts ))
#define IDDERESPOND(hwndCl,hwndSv,pszA,pszT,pCntx)                      \
                          (WinDdeRespond( hwndCl, hwndSv, pszA, pszT, pCntx ))
#define IDEFWINDOWPROC                  WinDefWindowProc
#define IDELETESYSATOM(atm)                                             \
                             (WinDeleteAtom( WinQuerySystemAtomTable(), atm ))
#define IDESTROYMSGQUEUE(hmq)           (WinDestroyMsgQueue( hmq ))
#define IDESTROYPOINTER(hPtr)           (WinDestroyPointer( hPtr ))
#define IDESTROYWINDOW(hwnd)            (WinDestroyWindow( hwnd ))
#define IDISMISSDLG(hDlg,res)           (WinDismissDlg( hDlg, res ))
#define IDISPATCHMSG(hab,pqmsg)         (WinDispatchMsg( hab, pqmsg ))
#define IDRAWTEXT(hps,len,psz,prcl,cF,cB,fs)                            \
                              (WinDrawText( hps, len, psz, prcl, cF, cB, fs ))
#define IENABLEWINDOW(hwnd,fEnable)     (WinEnableWindow( hwnd, fEnable ))
#define IENABLEWINDOWUPDATE(hwnd,fVis)  (WinEnableWindowUpdate( hwnd, fVis ))
#define IENDPAINT(hwnd,hps,prcl)        (WinEndPaint( hps ))
#define IFILLRECT(hps,prcl,clr)         (WinFillRect( hps, prcl, clr ))
#define IFINDSYSATOM(psz)                                               \
                               (WinFindAtom( WinQuerySystemAtomTable(), psz ))
#define IFLASHWINDOW(hwnd,bFlash)       (WinFlashWindow( hwnd, bFlash ))
#define IGETKEYSTATE(hwnd,vkey)         (WinGetKeyState( hwnd, vkey ))
#define IGETMSG(hab,pqmsg,hwnd,f1,f2)   (WinGetMsg( hab, pqmsg, hwnd, f1, f2 ))
#define IGETPS(hwnd)                    (WinGetPS( hwnd ))
#define IGETSYSBITMAP(idx)              (WinGetSysBitmap( HWND_DESKTOP, idx ))
#define IINITIALIZE()                   (WinInitialize( 0 ))
#define IINVALIDATERECT(hwnd,prcl,fl)   (WinInvalidateRect( hwnd, prcl, fl ))
#define IISCHILD(hwnd,hwndParent)       (WinIsChild( hwnd, hwndParent ))
#define IISWINDOW(hab,hwnd)             (WinIsWindow( hab, hwnd ))
#define IISWINDOWENABLED(hwnd)          (WinIsWindowEnabled( hwnd ))
#define IISWINDOWVISIBLE(hwnd)          (WinIsWindowVisible( hwnd ))
#define ILOADDLG(hPar,hOwn,pfnwp,hmod,idDlg,pParms)                     \
                        (WinLoadDlg( hPar, hOwn, pfnwp, hmod, idDlg, pParms ))
#define ILOADMENU(hwnd,hmod,idPtr)      (WinLoadMenu( hwnd, hmod, idPtr ))
#define ILOADMESSAGE(hab,hmod,id,len,psz)                               \
                                   (WinLoadMessage( hab, hmod, id, len, psz ))
#define ILOADPOINTER(hmod,idPtr)                                        \
                                 (WinLoadPointer( HWND_DESKTOP, hmod, idPtr ))
#define ILOADSTRING(hab,hmod,idStr,len,psz)                             \
                                 (WinLoadString( hab, hmod, idStr, len, psz ))
#define IMAPWINDOWPOINTS(hFrom,hTo,pptl,num)                            \
                                 (WinMapWindowPoints( hFrom, hTo, pptl, num ))
#define IMESSAGEBOX(hPar,hOwn,pszTxt,pszCap,idBox,fType)                \
                   (WinMessageBox( hPar, hOwn, pszTxt, pszCap, idBox, fType ))
#define IPEEKMSG(hab,pqmsg,hwnd,f1,f2,f3) (WinPeekMsg(hab,pqmsg,hwnd,f1,f2,f3))
#define IPOPUPMENU(hParent,hOwner,hMenu,x,y,idItem,fl)                  \
                    (WinPopupMenu( hParent, hOwner, hMenu, x, y, idItem, fl ))
#define IPOSTMESSAGE(hwnd,msg,mp1,mp2)  (WinPostMsg( hwnd, msg, mp1, mp2 ))
#define IPOSTQUEUEMESSAGE(hmq,msg,mp1,mp2)                              \
                                       (WinPostQueueMsg( hmq, msg, mp1, mp2 ))
#define IQUERYACTIVEWINDOW(hwnd)        (WinQueryActiveWindow( hwnd ))
#define IQUERYANCHOR(hwnd)              (WinQueryAnchorBlock( hwnd ))
#define IQUERYCLASSNAME(hwnd,len,psz)   (WinQueryClassName( hwnd, len, psz ))
#define IQUERYCLIPBRDFMTINFO(hab,ulfmt,pInfo)                           \
                                 (WinQueryClipbrdFmtInfo( hab, ulfmt, pInfo ))
#define IQUERYDESKTOPWINDOW(hab,hdc)    (WinQueryDesktopWindow(hab,hdc))
#define IQUERYFOCUS(hwnd)               (WinQueryFocus( hwnd ))
#define IQUERYMAXPOSITION(hwnd,pswp)    (WinGetMaxPosition( hwnd, pswp ))
#define IQUERYMINPOSITION(hwnd,pswp)    (WinGetMinPosition( hwnd, pswp,NULL ))
#define IQUERYMSGPOS(hab,pptl)          (WinQueryMsgPos( hab, pptl ))
#define IQUERYPOINTERINFO(hptr,ppti)    (WinQueryPointerInfo( hptr, ppti ))
#define IQUERYQUEUEINFO(hmq,pmqi,cb)    (WinQueryQueueInfo( hmq, pmqi, cb ))
#define IQUERYSYSATOMNAME(atm,psz,len)                                  \
                (WinQueryAtomName( WinQuerySystemAtomTable(), atm, psz, len ))
#define IQUERYSYSCOLOR(idx)         (WinQuerySysColor( HWND_DESKTOP, idx, 0L ))
#define IQUERYSYSPOINTER(idPtr,bCpy,iWin)                               \
                            (WinQuerySysPointer( HWND_DESKTOP, idPtr, bCpy ))
#define IQUERYSYSVALUE(idx)             (WinQuerySysValue( HWND_DESKTOP, idx ))
#define IQUERYUPDATERECT(hwnd,prcl)     (WinQueryUpdateRect( hwnd, prcl ))
#define IQUERYUPDATEREGION(hwnd,hrgn)   (WinQueryUpdateRegion( hwnd, hrgn ))
#define IQUERYVERSION(hab)              (WinQueryVersion( hab ))
#define IQUERYWINDOWPOS(hwnd,pswp)      (WinQueryWindowPos( hwnd, pswp ))
#define IQUERYWINDOWPROCESS(hwnd,ppid,ptid)                             \
                                   (WinQueryWindowProcess( hwnd, ppid, ptid ))
#define IQUERYWINDOWPTR(hwnd,idx)       (WinQueryWindowPtr( hwnd, idx ))
#define IQUERYWINDOWRECT(hwnd,prcl)     (WinQueryWindowRect( hwnd, prcl ))
#define IQUERYWINDOWTEXT(hwnd,len,psz)  (WinQueryWindowText( hwnd, len, psz ))
#define IQUERYWINDOWTEXTLENGTH(hwnd)    (WinQueryWindowTextLength( hwnd ))
#define IQUERYWINDOWULONG(hwnd,idx)     (WinQueryWindowULong( hwnd, idx ))
#define IQUERYWINDOWUSHORT(hwnd,idx)    (WinQueryWindowUShort( hwnd, idx ))
#define IRELEASEHOOK(hab,hwnd,lHk,pfnh,hmod,hHk)                        \
 (WinReleaseHook( hab, WinQueryWindowULong( hwnd, QWL_HMQ ), lHk, pfnh, hmod ))
#define IRELEASEPS(hwnd,hps)            (WinReleasePS( hps ))
#define ISENDMESSAGE(hwnd,msg,mp1,mp2)  (WinSendMsg( hwnd, msg, mp1, mp2 ))
#define ISETFOCUS(hwndDesktop,hwnd)     (WinSetFocus( hwndDesktop, hwnd ))
#define ISETHOOK(hab,hwnd,idHk,pfnh,hmod,hHk)                           \
   (WinSetHook( hab, WinQueryWindowULong( hwnd, QWL_HMQ ), idHk, pfnh, hmod ))
#define ISETOWNER(hwnd,hwndNewOwner)    (WinSetOwner( hwnd, hwndNewOwner ))
#define ISETPARENT(hwnd,hwndNewParent,bRedraw)                          \
                                (WinSetParent( hwnd, hwndNewParent, bRedraw ))
#define ISETPOINTER(hPtr)               (WinSetPointer( HWND_DESKTOP, hPtr ))
#define ISETSYSCOLORS(cnt,pTab1,pTab2)                                  \
          (WinSetSysColors( HWND_DESKTOP, 0, LCOLF_INDRGB, 0L, 2*cnt, pTab1 ))
#define ISETWINDOWBITS(hwnd,idx,val,msk)                                \
                                     (WinSetWindowBits( hwnd, idx, val, msk ))
#define ISETWINDOWPOS(hwnd,hIns,x,y,cx,cy,fs)                           \
                             (WinSetWindowPos( hwnd, hIns, x, y, cx, cy, fs ))
#define ISETWINDOWSTYLE(hwnd,val)   (WinSetWindowULong( hwnd, QWL_STYLE, val ))
#define ISETWINDOWTEXT(hwnd,psz)        (WinSetWindowText( hwnd, psz ))
#define ISETWINDOWULONG(hwnd,idx,val)   (WinSetWindowULong( hwnd, idx, val ))
#define ISETWINDOWUSHORT(hwnd,idx,val)  (WinSetWindowUShort( hwnd, idx, val ))
#define ISHOWWINDOW(hwnd,sw)            (WinShowWindow( hwnd, sw ))
#define ISTARTTIMER(hab,hwnd,idx,intv)  (WinStartTimer( hab, hwnd, idx, intv ))
#define ISTOPTIMER(hab,hwnd,idx)        (WinStopTimer( hab, hwnd, idx ))
#define ISUBCLASSWINDOW(hwnd,pfnwp)     (WinSubclassWindow( hwnd, pfnwp ))
#define ITERMINATE(hab)                 (WinTerminate( hab ))
#define IUPDATEWINDOW(hwnd)             (WinUpdateWindow( hwnd  ))
#define IVALIDATERECT(hwnd,prcl)        (WinValidateRect( hwnd, prcl, FALSE ))
#define IWINDOWFROMID(hwnd,id)          (WinWindowFromID(hwnd,id))
#define IWINDOWFROMPOINT(hwnd,ppt,fl)   (WinWindowFromPoint( hwnd, ppt, fl ))

#define IQUEUEOF(hwnd)                  (WinQueryWindowULong( hwnd, QWL_HMQ ))
#define ISTYLEOF(hwnd)                  (WinQueryWindowULong( hwnd, QWL_STYLE ))
#define IIDOF(hwnd)                     (WinQueryWindowUShort( hwnd, QWS_ID ))
#define ISETIDOF(hwnd,id)               (WinSetWindowUShort( hwnd, QWS_ID, id ))
#define IPARENTOF(hwnd)                 (WinQueryWindow( hwnd, QW_PARENT ))
#define IOWNEROF(hwnd)                  (WinQueryWindow( hwnd, QW_OWNER ))
#define ISETCAPTURE(rc,hwnd)          (rc = WinSetCapture( HWND_DESKTOP, hwnd ))
#define IRELEASECAPTURE                 (WinSetCapture( HWND_DESKTOP, 0 ))
#define IQUERYCAPTURE                   (WinQueryCapture( HWND_DESKTOP ))
#define IQUERYPOINTER                   (WinQueryPointer( HWND_DESKTOP))
#define IQUERYPOINTERPOSITION(ptx,pty)                                        \
                                  { POINTL ptl;                               \
                                    WinQueryPointerPos( HWND_DESKTOP, &ptl ); \
                                    ptx = ptl.x;                              \
                                    pty = ptl.y; }
#define ISETPOINTERPOSITION(x,y)        (WinSetPointerPos( HWND_DESKTOP, x, y ))
#define IQUERYUSERDATA(hwnd)            (WinQueryWindowULong( hwnd, QWL_USER ))
#define ISETUSERDATA(hwnd,valu)                                               \
                      (WinSetWindowULong( hwnd, QWL_USER, (unsigned long)valu))
#define IQUERYWINDOWPROCEDURE(hwnd)     (WinQueryWindowPtr( hwnd, QWP_PFNWP ))

/*--------------------------------------------------------------------*/
/* Dev API macros are listed here                                     */
/*--------------------------------------------------------------------*/
#define IQUERYDEVICECAPS(hdc,idx,pArr)  (DevQueryCaps( hdc, idx, 1L, pArr ))
#define IOPENDC(hab,lType,psz,num,pdevData,hdcC)                        \
                           (DevOpenDC( hab, lType, psz, num, pdevData, hdcC ))
#define ICLOSEDC(hdc)                   (DevCloseDC( hdc ))

/*--------------------------------------------------------------------*/
/* Gpi API macros are listed here                                     */
/*--------------------------------------------------------------------*/
#define ICHARSTRINGAT(hps,pptl,cnt,psz) (GpiCharStringAt( hps, pptl, cnt, psz ))
#define ICREATEBITMAP(hps,pbmp2,flOpt,pbd,pbmi2)                        \
                            (GpiCreateBitmap( hps, pbmp2, flOpt, pbd, pbmi2 ))
#define ICREATELOGCOLORTABLE(hps,flOpt,lFmt,lStrt,cnt,paTbl)            \
               (GpiCreateLogColorTable( hps, flOpt, lFmt, lStrt, cnt, paTbl ))
#define ICREATELOGFONT(hps,psz,lcid,pFattrs)                            \
                                 (GpiCreateLogFont( hps, psz, lcid, pFattrs ))
#define ICREATEPS(hab,hdc,pszl,ulOpt)   (GpiCreatePS( hab, hdc, pszl, ulOpt ))
#define ICREATEREGION(hps,cnt,prctl)    (GpiCreateRegion( hps, cnt, prctl ))
#define IDELETEBITMAP(hbm)              (GpiDeleteBitmap( hbm ))
#define IDELETESETID(hps,lcid)          (GpiDeleteSetId( hps, lcid ))
#define IDESTROYPS(hps)                 (GpiDestroyPS( hps ))
#define IDESTROYREGION(hps,hrgn)        (GpiDestroyRegion( hps, hrgn ))
#define IERASE(hps)                     (GpiErase( hps ))
#define ILINE(hps,pptl)                 (GpiLine( hps, pptl ))
#define ILOADBITMAP(hps,hmod,idBmp,lWd,lHt)                             \
                                 (GpiLoadBitmap( hps, hmod, idBmp, lWd, lHt ))
#define IMOVE(hps,pptl)                 (GpiMove( hps, pptl ))
#define IQUERYBACKCOLOR(hps)            (GpiQueryBackColor( hps ))
#define IQUERYBITMAPDIMENSION(hbm,psizl)                                \
                                        (GpiQueryBitmapDimension( hbm, psizl ))
#define IQUERYBITMAPPARAMETERS(hbm,pbmp)                                \
                                        (GpiQueryBitmapParameters( hbm, pbmp ))
#define IQUERYCOLORINDEX(hps,lRGB)      (GpiQueryColorIndex( hps, 0, lRGB ))
#define IQUERYDEVICE(hps)               (GpiQueryDevice( hps ))
#define IQUERYFONTMETRICS(hps,len,pfm)  (GpiQueryFontMetrics( hps, len, pfm ))
#define IQUERYRGBCOLOR(hps,idx,pPe)   (*pPe = GpiQueryRGBColor( hps, 0L, idx ))
#define IQUERYTEXTBOX(hps,len,psz,pptl)                                 \
                        (GpiQueryTextBox( hps, len, psz, TXTBOX_COUNT, pptl ))
#define IQUERYCHARWIDTH(hps,lfc,cnt,ppl)                                \
                                    (GpiQueryWidthTable( hps, lfc, cnt, ppl ))
#define ISETBACKCOLOR(hps,lColor)       (GpiSetBackColor( hps, lColor ))
#define ISETBACKMIX(hps,lMix)           (GpiSetBackMix( hps, lMix ))
#define ISETBITMAP(hps,hBmp)            (GpiSetBitmap( hps, hBmp ))
#define ISETCHARSET(hps,lcid)           (GpiSetCharSet( hps, lcid ))
#define ISETCLIPREGION(hps,hrgn,phrgn)  (GpiSetClipRegion( hps, hrgn, phrgn ))
#define ISETMIX(hps,lMix)               (GpiSetMix( hps, lMix ))
#define IWCBITBLT(hps,hbm,aptl,lrop,opt)                                \
                                (GpiWCBitBlt( hps, hbm, 4L, aptl, lrop, opt ))

/*------------------------------------------------------------------------------
| Macros for PM Clipboard functions                                            |
------------------------------------------------------------------------------*/
/* The following functions not directly supported:         */
/*    WinSetClipbrdData, WinQueryClipbrdFormat             */
#define IOPENCLIPBOARD(hab, hwnd)           (WinOpenClipbrd(hab))
#define ICLOSECLIPBOARD(hab)                (WinCloseClipbrd(hab))
#define IREGISTERCLIPBOARDFORMAT(psz)                                   \
                                  (WinAddAtom(WinQuerySystemAtomTable(), psz))
#define IFINDCLIPBOARDFORMAT(psz) (WinFindAtom(WinQuerySystemAtomTable(), psz))
#define IGETCLIPBOARDFORMATTEXT(fmt, psz, len)                          \
                    (WinQueryAtomName(WinQuerySystemAtomTable(),fmt,psz, len))
#define IEMPTYCLIPBOARD(hab)                (WinEmptyClipbrd(hab))
#define IGETCLIPBOARDOWNER(hab)             (WinQueryClipbrdOwner(hab))
#define ISETCLIPBOARDVIEWER(hab, hwnd)      (WinSetClipbrdViewer(hab, hwnd))
#define IGETCLIPBOARDVIEWER(hab)            (WinQueryClipbrdViewer(hab))
#define IENUMCLIPBOARDFORMATS(hab, ulFormat) (WinEnumClipbrdFmts(hab, ulFormat))
#define IGETCLIPBOARDDATA(hab, ulFormat )   (WinQueryClipbrdData(hab, ulFormat))

/*------------------------------------------------------------------------------
| Macros for PM accelerator table functions                                    |
------------------------------------------------------------------------------*/
#define ICOPYACCELTABLE(haccel,pbuf,size)                               \
           (WinCopyAccelTable( haccel, pbuf, size ))
#define ICREATEACCELTABLE(pbuf,count)                                   \
           (WinCreateAccelTable( IThread::current().anchorBlock(), pbuf ))
#define IDESTROYACCELTABLE(hAccel)      (WinDestroyAccelTable( hAccel ))
#define ILOADACCELTABLE(hab,hmod,idAcc) (WinLoadAccelTable( hab, hmod, idAcc ))
#define IQUERYACCELTABLE(hwnd)                                          \
           (WinQueryAccelTable( IThread::current().anchorBlock(), hwnd ))
#define ISETACCELTABLE(haccel,hwnd)                                     \
           (WinSetAccelTable( IThread::current().anchorBlock(), haccel, hwnd ))


/*--------------------------------------------------------------------*/
/* WM_HSCROLL, WM_VSCROLL parameter macros                            */
/*--------------------------------------------------------------------*/
#define SCROLL_PARMS( mp1, mp2 )       { USHORT nScrCmd, nScrPos;       \
                                         HWND   hwndScr;                \
                                         nScrCmd = LOWORD(mp2);         \
                                         nScrPos = HIWORD(mp2);         \
                                         hwndScr = WinWindowFromID(mp1); }

/*--------------------------------------------------------------------*/
/* Fields in RECTL structure                                          */
/*--------------------------------------------------------------------*/
#define  MINX  xLeft
#define  MINY  yBottom
#define  MAXX  xRight
#define  MAXY  yTop

/*--------------------------------------------------------------------*/
/* Infinite timeout                                                   */
/*--------------------------------------------------------------------*/
#define INFINITE            0xFFFFFFFF  // (from winbase.h)

/*--------------------------------------------------------------------*/
/* Use for window origin related ifdefs on otherwise portable code.   */
/*--------------------------------------------------------------------*/
#define IC_ORIGINLOWERLEFT

/*--------------------------------------------------------------------*/
/* General messages                                                   */
/*--------------------------------------------------------------------*/
#define WM_MOUSEENTER     0x041E    // Temporary until these appear
#define WM_MOUSELEAVE     0x041F    //   in the OS/2 toolkit.

#endif /* IC_PM */

#ifdef IC_MOTIF
/**********************************************************************/
/* Motif program.  Set the macros to call Xt/Motif APIs               */
/**********************************************************************/
#include <X11/Intrinsic.h>
#include <ixconst.h>
#include <icconst.h>

#define DRT_BINDATA "BinaryData"
#define DRT_BITMAP  "Bitmap"
#define DRT_ICON    "ICon"
#define DRT_TEXT    "Text"
#define DRT_UNKNOWN "Unknown"

#define DRG_ICON         0x00000001
#define DRG_BITMAP       0x00000002
#define DRG_POLYGON      0x00000004
#define DRG_STRETCH      0x00000008
#define DRG_TRANSPARENT  0x00000010
#define DRG_CLOSED       0x00000020

#define DO_COPYABLE          0x1
#define DO_MOVEABLE          0x2
#define DO_LINKABLE          0x4
#define DO_UNKNOWN        0xBFFF

#define DC_OPEN              0x1
#define DC_REF               0x2
#define DC_GROUP             0x4
#define DC_CONTAINER         0x8
#define DC_PREPARE           0x10
#define DC_REMOVEABLEMEDIA   0x20

#define DRG_REGISTERED_DROP     0x01
#define DRG_REGISTERED_DRAG     0x02
#define DRG_REGISTERED_DRAGDROP 0x03

#define DO_COPY    0x0010
#define DO_MOVE    0x0020
#define DO_LINK    0x0018
#define DO_DEFAULT 0xBFFE

/*--------------------------------------------------------------------*/
/* Use for window origin related ifdefs on otherwise portable code.   */
/*--------------------------------------------------------------------*/
#define IC_ORIGINUPPERLEFT
#endif /* IC_MOTIF */


#endif // _IWINDEFS_
