// Revision: 91 1.10.2.2 source/ui/baseapp/ithreadp.hpp, thread, ioc.v400, 001006 
/*NOSHIP*/
#ifndef _ITHREADP_
#define _ITHREADP_
/*******************************************************************************
* FILE NAME: ithreadp.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*      ICurrentThreadData                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <iss2.h>
#include <iguinotf.hpp>
#include <ihandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ICurrentThreadData;
class IEvent;
class INonGUIThread;

#ifdef IC_MOTIF
extern XtAppContext* gAnchorBlock;
extern Widget gApplicationShell;
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_MOTIF

#define NUMBER_OF_BUTTONS 3
/*------------------------------------------------------------------------------
| IMouseEventData                                                              |
| Private data and implementation class.                                       |
------------------------------------------------------------------------------*/
class IMouseEventDetect {
public:
  IMouseEventDetect ( );
bool
  withinMultiClickTime ( const XEvent &event ),
  sameButton           ( const XEvent &event );

IMouseEventDetect
 &setMultiClickTime ( int clickTime );

bool
  synthesizeEvent   ( );
int
  synthesizeEventId ( ),
  eventId           ( const XEvent &event );

IMouseEventDetect
 &resetLevel     ( int button );

private:
bool
  sameButton     ( int button ),
  anyButtonEdge  ( ),
  anyButtonLevel ( );
IMouseEventDetect
 &resetEdge      ( ),
 &setButton      ( int button );

enum ButtonState {
  off, edge, level };
ButtonState
  bsClButtonState[ NUMBER_OF_BUTTONS ];
unsigned long
  ulClDoubleClickTime,
  ulClLastButtonTime;
int
  iClPreviousButton,
  iClPreviousMouseState,
  iClPreviousMouseDownState;
bool
  bClSynthesizeEvent;
int
  iClSynthesizeEventId;
}; // IMouseEventDetect
#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| IThreadData                                                                  |
| Private data and implementation class for IThread.                           |
------------------------------------------------------------------------------*/
class IThreadData {
public:
/*------------------------------- Constructors ---------------------------------
  Objects of this class are currently not constructed because it contains
  only static functions and data.
------------------------------------------------------------------------------*/

/*---------------------------- Thread Storage ---------------------------------
  The thread storage functions access objects which are stored on a
  per-thread basis.  The storage used persists as long as the system thread
  exists.
------------------------------------------------------------------------------*/
static IMessageQueueHandle::Value
  messageQueue    ( const INonGUIThread&       thread );
static void
  setMessageQueue ( INonGUIThread&             thread,
                    IMessageQueueHandle::Value hmq );

static IAnchorBlockHandle::Value
  anchorBlock    ( const INonGUIThread&      thread );
static void
  setAnchorBlock ( INonGUIThread&            thread,
                   IAnchorBlockHandle::Value hab );

static long
  queueSize    ( const INonGUIThread& thread );
static void
  setQueueSize ( INonGUIThread&       thread,
                 long                 queuesize );

static bool
  autoInitGUI    ( const INonGUIThread& thread );
static void
  setAutoInitGUI ( INonGUIThread&       thread,
                   bool                 autoinit );

static ICurrentThreadData*
  currentThreadData    ( const INonGUIThread& thread );
static void
  setCurrentThreadData ( INonGUIThread&       thread,
                         ICurrentThreadData*  data );

#ifdef IC_MOTIF
static IWindowHandle::Value
  applicationShell    ( const INonGUIThread& thread );
static void
  setApplicationShell ( INonGUIThread&       thread,
                        IWindowHandle::Value shell );

static int
  xerrorCode    ( const INonGUIThread& thread );
static void
  setXerrorCode ( INonGUIThread&       thread,
                  int                  code );

static bool
  isTopLevelShell  ( const INonGUIThread& thread );
static void
  setTopLevelShell ( INonGUIThread&       thread,
                     bool                 isTopLevel );
#endif //IC_MOTIF


#ifdef IC_MOTIF
static IString
  getArgs ( );
#endif //IC_MOTIF

private:
// The following strings are the keys used to store per-thread data
// using the INonGUIThread::variable and setVariable functions.   The
// function variableValue and setVariableValue actually get and set
// the values.
static const char
 *fgKeyBase,
 *fgHMQKey,
 *fgHABKey,
 *fgQueueSizeKey,
 *fgAutoInitGUIKey,
 *fgCurrentThreadDataKey,
 *fgMsgLoopSerialKey,
 *fgAppShellKey,
 *fgXerrorCode,
 *fgIsTopLevelShell;
static void
 *variableValue    ( const INonGUIThread& thread,
                     const char*          key );
static void
  setVariableValue ( INonGUIThread&       thread,
                     const char*          key,
                     void*                value);
}; // IThreadData


/*------------------------------------------------------------------------------
| ICurrentThreadData                                                           |
| Private data and implementation class for ICurrentThread.                    |
------------------------------------------------------------------------------*/
typedef ISortedSet<unsigned int>
  IWMQuitStack;

class ICurrentThreadData {
public:
  ICurrentThreadData ( );
 ~ICurrentThreadData ( );
unsigned long
  fMsgLoop;     // In-msg-polling-loop count (increment when polling loop
                // begins and decrement when polling loop ends to effectively
                // track stacked calls of processMsgs(), and issue
                // the quit message to each thread when it terminates.
IWMQuitStack
 *fquitStack;   // stack of WM_QUIT requests from modal dialogs

#ifdef IC_WIN
static bool
  translateAccelerator ( MSG& message );
#endif //IC_WIN

#ifdef IC_MOTIF
static bool
  translateAccelerator   ( const XEvent& event );
bool
  handleMouseButtonEvent ( const XEvent& event,
                           IEvent* &     lastEvent,
                           IEvent* &     lastSynthesizedEvent ),
  handleKeyboardEvent    ( const XEvent& event,
                           IEvent* &     lastEvent );
ICurrentThreadData
 &getMultiClickTime           ( IDisplayHandle display ),
 &getModifierMappings         ( ),
 &sendMouseEventsUpOwnerChain ( IEvent*        lastEvent,
                                IEvent*        lastSynthesizeEvent ),
 &sendKeyEventsUpOwnerChain   ( IEvent*        lastEvent );
ICurrentThreadData
 &resetButton                 ( int button );
#endif //IC_MOTIF

private:
  ICurrentThreadData ( const ICurrentThreadData& );
ICurrentThreadData
 &operator=          ( const ICurrentThreadData& );

#ifdef IC_MOTIF
static bool
  translateAccelerator ( const IWindowHandle&   hwnd,
                         const IAccelTblHandle& haccel,
                         const XEvent&          event );

IMouseEventDetect
  medClMouseEvent;
#endif //IC_MOTIF
}; // ICurrentThreadData

/*------------------------------------------------------------------------------
| ICurrentThreadDataRef                                                        |
| Wrapper for ICurrentThreadData* with destructor.                             |
| An instance of this object is created within ICurrentThread::processMsgs     |
| to manage references to the ICurrentThreadData object for the thread.        |
| The destructor is important to insure that the message loop nesting counter  |
| is properly handled when an exception occurs during processing of a message. |
------------------------------------------------------------------------------*/
class ICurrentThreadDataRef {
public:
   ICurrentThreadDataRef( );
   ~ICurrentThreadDataRef( );

ICurrentThreadData* operator-> ()  {return fLoopData; };

private:
  ICurrentThreadData* fLoopData;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif


#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::IMouseEventDetect                                         |
------------------------------------------------------------------------------*/
inline IMouseEventDetect::IMouseEventDetect ( ) :
   ulClDoubleClickTime(200),
   ulClLastButtonTime( 0 ),
   iClPreviousButton( 0 ),
   iClPreviousMouseState( 0 ),
   bClSynthesizeEvent( false ),
   iClSynthesizeEventId( 0 ),
   iClPreviousMouseDownState( 0 )
{
   for ( int i = 0; i < NUMBER_OF_BUTTONS; i++)
     bsClButtonState[ i ] = off;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::withinMultiClickTime                                      |
------------------------------------------------------------------------------*/
inline bool IMouseEventDetect::withinMultiClickTime ( const XEvent &event )
{
   return abs( event.xbutton.time - ulClLastButtonTime) <=
               ulClDoubleClickTime;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::sameButton                                                |
------------------------------------------------------------------------------*/
inline bool IMouseEventDetect::sameButton ( const XEvent &event )
{
   return ( event.xbutton.button == iClPreviousButton );
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::setMultiClickTime                                         |
------------------------------------------------------------------------------*/
inline IMouseEventDetect& IMouseEventDetect::setMultiClickTime ( int clickTime )
{
   ulClDoubleClickTime = clickTime;
   return *this;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::synthesizeEvent                                           |
------------------------------------------------------------------------------*/
inline bool IMouseEventDetect::synthesizeEvent ( )
{
   return bClSynthesizeEvent;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::synthesizeEventId                                         |
------------------------------------------------------------------------------*/
inline int  IMouseEventDetect::synthesizeEventId ( )
{
   iClPreviousMouseState = iClSynthesizeEventId;
   return iClSynthesizeEventId;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::sameButton                                                |
------------------------------------------------------------------------------*/
inline bool IMouseEventDetect::sameButton ( int button )
{
   return iClPreviousButton == button;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::anyButtonEdge                                             |
------------------------------------------------------------------------------*/
inline bool IMouseEventDetect::anyButtonEdge ( )
{
   for ( int i = 0; i < NUMBER_OF_BUTTONS; i++ )
   {
     if ( bsClButtonState[i] == edge )
       return true;
   }
   return false;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::anyButtonLevel                                            |
------------------------------------------------------------------------------*/
inline bool IMouseEventDetect::anyButtonLevel ( )
{
   for ( int i = 0; i < NUMBER_OF_BUTTONS; i++ )
   {
     if ( bsClButtonState[i] != off )
       return true;
   }
   return false;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::resetEdge                                                 |
------------------------------------------------------------------------------*/
inline IMouseEventDetect& IMouseEventDetect::resetEdge ( )
{
   // should only be one button in edge state!
   for ( int i = 0; i < NUMBER_OF_BUTTONS; i++ )
   {
      if ( bsClButtonState[ i ] == edge)
        bsClButtonState[ i ] = level;
   }
   return *this;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::resetLevel                                                |
------------------------------------------------------------------------------*/
inline IMouseEventDetect& IMouseEventDetect::resetLevel ( int button )
{
   bsClButtonState[ button - 1 ] = off;
   return *this;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMouseEventDetect::setButton                                                 |
------------------------------------------------------------------------------*/
inline IMouseEventDetect& IMouseEventDetect::setButton ( int button )
{
   bsClButtonState[ button - 1 ] = edge;
   return *this;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IThreadData::getMultiClickTime                                               |
------------------------------------------------------------------------------*/
inline ICurrentThreadData&
   ICurrentThreadData::getMultiClickTime ( IDisplayHandle display )
{
   medClMouseEvent.setMultiClickTime( XtGetMultiClickTime( display ) );
   return *this;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| ICurrentThreadData::resetButton                                              |
------------------------------------------------------------------------------*/
ICurrentThreadData& ICurrentThreadData::resetButton( int button )
{
   medClMouseEvent.resetLevel( button );
   return *this;
}
#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| IMessageQueueHandle::Value  IThreadData::messageQueue                        |
------------------------------------------------------------------------------*/
inline IMessageQueueHandle::Value
   IThreadData::messageQueue ( const INonGUIThread& thread )
{
#ifdef IC_MOTIF
    return (IMessageQueueHandle::Value)pthread_self();
#else
    return (IMessageQueueHandle::Value)
        IThreadData::variableValue(thread, IThreadData::fgHMQKey);
#endif
}

/*------------------------------------------------------------------------------
| IThreadData::setMessageQueue                                                 |
------------------------------------------------------------------------------*/
inline void IThreadData::setMessageQueue ( INonGUIThread& thread,
                                           IMessageQueueHandle::Value hmq )
{
#ifndef IC_MOTIF
    IThreadData::setVariableValue( thread,
                                   IThreadData::fgHMQKey,
                                   (void*) hmq );
#endif
}

/*------------------------------------------------------------------------------
| IAnchorBlockHandle::Value IThreadData::anchorBlock                           |
------------------------------------------------------------------------------*/
inline IAnchorBlockHandle::Value
   IThreadData::anchorBlock ( const INonGUIThread& thread )
{
#ifdef IC_MOTIF
    return (IAnchorBlockHandle::Value)gAnchorBlock;
#else
    return (IAnchorBlockHandle::Value)
        IThreadData::variableValue( thread, IThreadData::fgHABKey );
#endif
}

/*------------------------------------------------------------------------------
| IThreadData::setAnchorBlock                                                  |
------------------------------------------------------------------------------*/
inline void IThreadData::setAnchorBlock ( INonGUIThread& thread,
                                          IAnchorBlockHandle::Value hab )
{
#ifdef IC_MOTIF
    gAnchorBlock = (XtAppContext *)hab;
#else
    IThreadData::setVariableValue( thread,
                                   IThreadData::fgHABKey,
                                   (void*) hab );
#endif
}

/*------------------------------------------------------------------------------
| IThreadData::queueSize                                                       |
------------------------------------------------------------------------------*/
inline long IThreadData::queueSize ( const INonGUIThread& thread )
{
  return (long) IThreadData::variableValue( thread,
                                            IThreadData::fgQueueSizeKey );
}

/*------------------------------------------------------------------------------
| IThreadData::setQueueSize                                                    |
------------------------------------------------------------------------------*/
inline void IThreadData::setQueueSize ( INonGUIThread& thread, long queuesize )
{
  IThreadData::setVariableValue( thread,
                                 IThreadData::fgQueueSizeKey,
                                 (void*) queuesize );
}

/*------------------------------------------------------------------------------
| IThreadData::autoInitGUI                                                     |
------------------------------------------------------------------------------*/
inline bool IThreadData::autoInitGUI ( const INonGUIThread& thread )
{
  return (bool) IThreadData::variableValue( thread,
                                            IThreadData::fgAutoInitGUIKey );
}

/*------------------------------------------------------------------------------
| IThreadData::setAutoInitGUI                                                  |
------------------------------------------------------------------------------*/
inline void IThreadData::setAutoInitGUI ( INonGUIThread& thread, bool autoinit )
{
  IThreadData::setVariableValue ( thread,
                                  IThreadData::fgAutoInitGUIKey,
                                  (void*) autoinit );
}

/*------------------------------------------------------------------------------
| IThreadData::currentThreadData                                               |
------------------------------------------------------------------------------*/
inline ICurrentThreadData*
   IThreadData::currentThreadData ( const INonGUIThread& thread )
{
   return (ICurrentThreadData*)
       IThreadData::variableValue( thread,
                                   IThreadData::fgCurrentThreadDataKey );
}

/*------------------------------------------------------------------------------
| IThreadData::setCurrentThreadData                                            |
------------------------------------------------------------------------------*/
inline void IThreadData::setCurrentThreadData ( INonGUIThread& thread,
                                                ICurrentThreadData* data )
{
   IThreadData::setVariableValue( thread,
                                  IThreadData::fgCurrentThreadDataKey,
                                  data );
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IWindowHandle::Value IThreadData::applicationShell                           |
------------------------------------------------------------------------------*/
inline IWindowHandle::Value
IThreadData::applicationShell ( const INonGUIThread& thread )
{
    return gApplicationShell;
}

/*------------------------------------------------------------------------------
| IThreadData::setApplicationShell                                             |
------------------------------------------------------------------------------*/
inline void IThreadData::setApplicationShell ( INonGUIThread& thread,
                                               IWindowHandle::Value shell )
{
    gApplicationShell = shell;
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IThreadData::xerrorCode                                                      |
------------------------------------------------------------------------------*/
inline int IThreadData::xerrorCode ( const INonGUIThread& thread )
{
  return (int) IThreadData::variableValue( thread, IThreadData::fgXerrorCode );
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IThreadData::setXerrorCode                                                   |
------------------------------------------------------------------------------*/
inline void IThreadData::setXerrorCode ( INonGUIThread& thread, int code )
{
   IThreadData::setVariableValue( thread,
                                  IThreadData::fgXerrorCode,
                                  (void*) code );
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IThreadData::isTopLevelShell                                                 |
------------------------------------------------------------------------------*/
inline bool IThreadData::isTopLevelShell ( const INonGUIThread& thread )
{
  return (bool)
     IThreadData::variableValue( thread, IThreadData::fgIsTopLevelShell );
}
#endif //IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IThreadData::setTopLevelShell                                                |
------------------------------------------------------------------------------*/
inline void IThreadData::setTopLevelShell ( INonGUIThread& thread,
                                            bool isTopLevel )
{
   IThreadData::setVariableValue( thread,
                                  IThreadData::fgIsTopLevelShell,
                                  (void*) isTopLevel );
}
#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| ICurrentThreadData::ICurrentThreadData                                       |
------------------------------------------------------------------------------*/
inline ICurrentThreadData::ICurrentThreadData ( )
   : fMsgLoop( 0 ),
     fquitStack( 0 )
{
   IGUINotification::initialize();
}

/*------------------------------------------------------------------------------
| ICurrentThreadData::~ICurrentThreadData                                      |
------------------------------------------------------------------------------*/
inline ICurrentThreadData::~ICurrentThreadData ( )
{
  IGUINotification::exit();
  if ( fquitStack )
     delete fquitStack;
}

#endif //_ITHREADP_
