// Revision: 50 1.4.2.1 source/ui/baseapp/iprofprv.hpp, profile, ioc.v400, 001006  
/* NOSHIP */
#ifndef _IPROFPRV_
  #define _IPROFPRV_
/*******************************************************************************
* FILE NAME: iprofprv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IProfileData                                                             *
*     IProfileCursorData                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#ifdef IC_MOTIF
  #include <X11/Xlib.h>
  #include <X11/Xresource.h>
  #include <ihandle.hpp>
  #include <iprofile.hpp>
  #include <ireslock.hpp>
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IProfileData  {

public:
#ifdef IC_PMWIN
  IProfileData( );
#endif //IC_PMWIN
#ifdef IC_MOTIF
  IProfileData( IProfile* profile );
#endif //IC_MOTIF

 ~IProfileData( );

#ifdef IC_WIN
bool
  isSystemProfile;
const IString
  defaultString;
HKEY
  hKey;
HKEY
  parentKey;
IProfile::EAccess 
  accessMode;
bool newConstrctr;
#endif //IC_WIN

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
    openProfile         - Reads or creates a resource database using the named
                          profile
    closeProfile        - Writes then destroys the specified resource database
------------------------------------------------------------------------------*/
IProfileHandle
  openProfile ( const IString profileName );
IProfileData
 &closeProfile( const IProfileHandle  pDB );

/*------------------------------------------------------------------------------
    queryProfileString  - Returns the appl/key resource value from the current
                          database into the string buffer provided
    queryProfileData    - Returns the appl/key resource value from the current
                          database, converting into the long provided
    queryProfileSize    - Returns the size of the appl/key resource value in
                          the current database
    writeProfileString  - Sets the specified appl/key resource with the string
                          value provided
    writeProfileData    - Sets the specified appl/key resource with the
                          converted long value provided
    addProfileAppl      - Adds the specified appl to the database list
                          of appls (with key = "0:0")
------------------------------------------------------------------------------*/
IProfileData
 &queryProfileString( const IProfileHandle pDB, const IString applName,
                      const IString key, char *strBuf, unsigned long strBufLen );
IProfileData
 &queryProfileData( const IProfileHandle pDB, const IString applName,
                    const IString key, long *lData );
unsigned long
  queryProfileSize( const IProfileHandle pDB, const IString applName,
                    const IString key);
IProfileData
 &writeProfileString( const IProfileHandle pDB, const IString applName,
                      const IString key, char *strBuf, unsigned long strBufLen );
IProfileData
 &writeProfileData( const IProfileHandle pDB, const IString applName,
                    const IString key, long *lData );
IProfileData
 &addProfileAppl( const IProfileHandle pDB, const IString applName);

/*------------------------------------------------------------------------------
    deleteProfileString - Sets the specified appl/key resource to be the NULL
                          string
    deleteProfileAppl   - Deletes specified appl from the database list of
                          appls (with key = "0:0")
    deleteProfile       - Deletes the profile file
------------------------------------------------------------------------------*/
IProfileData
 &deleteProfileString( const IProfileHandle pDB, const IString applName,
                       const IString key );
IProfileData
 &deleteProfileAppl( const IProfileHandle pDB, const char *applName);
IProfileData
 &deleteProfile( const IProfileHandle pDB );

IString
  theProfile;    // profile file name; full path
IString
  applClass;     // application name
IProfile
 *pProfile;      // owning Profile of this object
#endif //IC_MOTIF

/*----------------------- Private -----------------------------------*/
private:
  IProfileData ( const IProfileData& aProfile );
IProfileData
 &operator=    ( const IProfileData& aProfile );

#ifdef IC_MOTIF
ISharedResource *profileRes;

friend class IProfile;
#endif //IC_MOTIF

}; // IProfileData

class IProfileCursorData  {

public:
#ifdef IC_PMWIN
  IProfileCursorData( );
#endif //IC_PMWIN
#ifdef IC_MOTIF
  IProfileCursorData( IProfile::Cursor* profileCursor );
#endif //IC_MOTIF
 ~IProfileCursorData( );

#ifdef IC_WIN
IString
  profileName;
bool
  isSystemProfile;
const IString
  defaultString;
IProfile
 *thisProfile;
#endif

#ifdef IC_MOTIF
IString IProfileCursorData :: initProfileCursor (const IProfileHandle pDB,
                                                        IString applName);
IProfile
 *thisProfile;
IProfile::Cursor
 *pProfileCursor;        // owning IProfile Cursor of this object
#endif //IC_MOTIF

/*----------------------- Private -----------------------------------*/
private:
  IProfileCursorData ( const IProfileCursorData& aCursor );
IProfileCursorData
 &operator=          ( const IProfileCursorData& aCursor );

}; // IProfileCursorData

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IPROFPRV_
