// Revision: 30 1.5.1.1 source/ui/baseapp/ipageevt.cpp, notebook, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ipageevt.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Implementation of the class(es):                                           *
*     IPageEvent                                                               *
*     IPageRemoveEvent                                                         *
*     IPageHelpEvent                                                           *
*     IPageSelectEvent                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#define INCL_WINDIALOGS           // Needed for PDLGTEMPLATE in BOOKPAGEINFO.
#define INCL_WINSTDBOOK
#define INCL_WINWINDOWMGR
extern "C" {
  #include <iwindefs.h>

#ifdef IC_WIN
  #ifndef _WIN32
    #define _WIN32
  #endif
  #include <commctrl.h>
#endif
}

#ifdef IC_MOTIF
  #include <notebk.h>
#endif

#ifdef IC_WIN
  #include <iclnbw.h>
#endif

#include <ipageevt.hpp>
#include <ihelp.hpp>
#include <inotebk.hpp>
#include <iwindow.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IPAGEEVT_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
#pragma enum(4)
#pragma pack(push,4)

// Note:  In order to keep this struct declaration out of the public
//        interface and to avoid creating a new file for just this
//        struct, this declaration appears here and in inotebk.cpp.
//        Any changes MUST be made in both files.
struct PageData
{
  unsigned long userData;
  unsigned long pageHandle;
  bool           isAutoSize;
};
#pragma pack(pop)
#pragma enum(pop)
#endif // IC_MOTIF

/*------------------------------------------------------------------------------
| IPageEvent::IPageEvent                                                       |
------------------------------------------------------------------------------*/
IPageEvent::IPageEvent ( const IEvent& event )
  : IPageEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageEvent::IPageEvent                                                       |
------------------------------------------------------------------------------*/
IPageEvent::IPageEvent ( const IControlEvent& event )
  : IPageEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageEvent::IPageEvent                                                       |
| Copy constructor                                                             |
------------------------------------------------------------------------------*/
IPageEvent::IPageEvent ( const IPageEvent& event )
  : IPageEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageEvent::~IPageEvent                                                      |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IPageEvent::~IPageEvent ( )
{ }


/*------------------------------------------------------------------------------
| IPageEvent::pageHandle                                                       |
|                                                                              |
| Return the id of the page appropriate for the event (e.g. the page being     |
| resized).                                                                    |
------------------------------------------------------------------------------*/
IPageHandle IPageEvent::pageHandle ( ) const
{
  IPageHandle topPageHandle (0);

#ifdef IC_PMWIN
  INotebook* pNotebk = notebook();

  if (pNotebk)
  {
    if ( pNotebk->isPMCompatible() )
    {
      /************************************************************************/
      /* CUA '91 notebook                                                     */
      /************************************************************************/
      unsigned long
        retVal = pNotebk->handle().sendEvent( BKM_QUERYPAGEID,
                                              IEventParameter1(),
                                              IEventParameter2( BKA_TOP, 0 ) );
      if (retVal)
#ifdef IC_WIN
        topPageHandle = (void*)retVal;
#else
        topPageHandle = retVal;
#endif
    }
    else
    {
      /************************************************************************/
      /* Windows tab control                                                  */
      /************************************************************************/
      topPageHandle = pNotebk->topPage();
    }
  }
#endif //IC_PMWIN

  return( topPageHandle );
}

/*------------------------------------------------------------------------------
| IPageEvent::notebook                                                         |
|                                                                              |
| Return the notebook.                                                         |
------------------------------------------------------------------------------*/
INotebook* IPageEvent::notebook ( ) const
{
#ifdef IC_WIN
   return (INotebook*)
            IWindow::windowWithHandle( (HWND) this->parameter2() );
#endif
#ifdef IC_PM
  return (INotebook*)
            IWindow::windowWithHandle( (unsigned long) this->parameter2() );
#endif
#ifdef IC_MOTIF
  return 0;  //stub
#endif
         // hwnd is in mp2.
}

/*------------------------------------------------------------------------------
| IPageRemoveEvent::IPageRemoveEvent                                           |
------------------------------------------------------------------------------*/
IPageRemoveEvent::IPageRemoveEvent ( const IEvent& event )
  : IPageRemoveEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageRemoveEvent::IPageRemoveEvent                                           |
------------------------------------------------------------------------------*/
IPageRemoveEvent::IPageRemoveEvent ( const IControlEvent& event )
  : IPageRemoveEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageRemoveEvent::IPageRemoveEvent                                           |
------------------------------------------------------------------------------*/
IPageRemoveEvent::IPageRemoveEvent ( const IPageEvent& event )
  : IPageRemoveEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageRemoveEvent::~IPageRemoveEvent                                          |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IPageRemoveEvent::~IPageRemoveEvent ( )
{ }

/*------------------------------------------------------------------------------
| IPageRemoveEvent::pageWindow                                                 |
|                                                                              |
| Return the window or control associated with the page.                       |
------------------------------------------------------------------------------*/
IWindow* IPageRemoveEvent::pageWindow ( ) const
{
#ifdef IC_PMWIN
  DELETENOTIFY* pdn = (DELETENOTIFY*)(void*)parameter2();
  IWindowHandle hwndPageWindow = pdn->hwndPage;
  IWindow* pwndPageWindow = IWindow::windowWithHandle( hwndPageWindow );
  return pwndPageWindow;
#endif
#ifdef IC_MOTIF
  return 0;
#endif
}

/*------------------------------------------------------------------------------
| IPageRemoveEvent::tabBitmap                                                  |
|                                                                              |
| Returns the bitmap of the tab associated with the page.                      |
------------------------------------------------------------------------------*/
IBitmapHandle IPageRemoveEvent::tabBitmap ( ) const
{
#ifdef IC_PMWIN
  DELETENOTIFY* pdn = (DELETENOTIFY*)(void*)parameter2();
  return pdn->hbmTab;
#endif
#ifdef IC_MOTIF
  return 0;
#endif
}

/*------------------------------------------------------------------------------
| IPageRemoveEvent::notebook                                                   |
|                                                                              |
| Returns the notebook.                                                        |
------------------------------------------------------------------------------*/
INotebook* IPageRemoveEvent::notebook ( ) const
{
  return (INotebook*)(this->controlWindow());
}

/*------------------------------------------------------------------------------
| IPageRemoveEvent::pageHandle                                                 |
|                                                                              |
| The page handle cannot be returned.                                          |
------------------------------------------------------------------------------*/
IPageHandle IPageRemoveEvent::pageHandle ( ) const
{
  return 0;
}

/*------------------------------------------------------------------------------
| IPageHelpEvent::IPageHelpEvent                                               |
------------------------------------------------------------------------------*/
IPageHelpEvent::IPageHelpEvent ( const IEvent& event )
  : IPageHelpEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageHelpEvent::IPageHelpEvent                                               |
------------------------------------------------------------------------------*/
IPageHelpEvent::IPageHelpEvent ( const IControlEvent& event )
  : IPageHelpEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageHelpEvent::IPageHelpEvent                                               |
------------------------------------------------------------------------------*/
IPageHelpEvent::IPageHelpEvent ( const IPageEvent& event )
  : IPageHelpEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageHelpEvent::~IPageHelpEvent                                              |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IPageHelpEvent::~IPageHelpEvent ( )
{ }


#ifndef IC_MOTIF_FLAGNOP
/*------------------------------------------------------------------------------
| IPageHelpEvent::helpWindow                                                   |
|                                                                              |
| Returns the help window for the notebook.                                    |
------------------------------------------------------------------------------*/
IHelpWindow  *IPageHelpEvent::helpWindow ( ) const
{
  IWindow* pwndNotebook = this->controlWindow();
  IHelpWindow* pHelp =
                 pwndNotebook ? IHelpWindow::helpWindow( pwndNotebook ) : 0;
  return pHelp;
}
#endif


#ifndef IC_MOTIF_FLAGNOP
/*------------------------------------------------------------------------------
| IPageHelpEvent::pageHandle                                                   |
|                                                                              |
| Returns the notebook page handle representing the page for which help        |
| is requested.                                                                |
------------------------------------------------------------------------------*/
IPageHandle IPageHelpEvent::pageHandle ( ) const
{
#ifdef IC_PMWIN
  return IPageHandle( this->parameter2() );
#endif
#ifdef IC_MOTIF
  return 0;
#endif
}
#endif


#ifndef IC_MOTIF_FLAGNOP
/*------------------------------------------------------------------------------
| IPageHelpEvent::notebook                                                     |
|                                                                              |
| Returns a pointer to the notebook control.                                   |
------------------------------------------------------------------------------*/
INotebook* IPageHelpEvent::notebook ( ) const
{
  IWindow* pwndNotebook = this->controlWindow();
  IWindowHandle hwndNotebook = 0;
  if ( pwndNotebook )
  {                               // Know the control object.
     hwndNotebook = pwndNotebook->handle();
  }
  else
  {                               // Assume parent == owner.
#ifdef IC_PMWIN
     hwndNotebook = IWINDOWFROMID( this->handle(), this->controlId() );
#else
     hwndNotebook = XtNameToWidget(handle(),
                                   (char *)IString( controlId() ) );
#endif
  }
  return (INotebook*)IWindow::windowWithHandle( hwndNotebook );
}
#endif

/*------------------------------------------------------------------------------
| IPageSelectEvent::IPageSelectEvent                                           |
------------------------------------------------------------------------------*/
IPageSelectEvent::IPageSelectEvent ( const IEvent& event )
  : IPageSelectEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageSelectEvent::IPageSelectEvent                                           |
------------------------------------------------------------------------------*/
IPageSelectEvent::IPageSelectEvent ( const IControlEvent& event )
  : IPageSelectEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageSelectEvent::IPageSelectEvent                                           |
------------------------------------------------------------------------------*/
IPageSelectEvent::IPageSelectEvent ( const IPageEvent& event )
  : IPageSelectEvent::Inherited( event )
{ }

/*------------------------------------------------------------------------------
| IPageSelectEvent::~IPageSelectEvent                                          |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IPageSelectEvent::~IPageSelectEvent ( )
{ }

/*------------------------------------------------------------------------------
| IPageSelectEvent::notebook                                                   |
|                                                                              |
| Returns a pointer to the notebook control.                                   |
------------------------------------------------------------------------------*/
INotebook* IPageSelectEvent::notebook ( ) const
{
#ifdef IC_PMWIN
  /****************************************************************************/
  /* Access the notebook's window handle via a field within the               */
  /* PAGESELECTNOTIFY structure.  Please note that we create this structure   */
  /* for the Windows tab control in order to make the selection notification  */
  /* support transparent.                                                     */
  /****************************************************************************/
  PAGESELECTNOTIFY* psn = (PAGESELECTNOTIFY*)(void*)parameter2();
  IWindowHandle hwndControl = psn->hwndBook;

  return( (INotebook*)IWindow::windowWithHandle( hwndControl ) );
#endif //IC_PMWIN

#ifdef IC_MOTIF
  return (INotebook*)controlWindow();
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IPageSelectEvent::pageHandle                                                 |
|                                                                              |
| Returns the notebook page handle representing the selected notebook page.    |
------------------------------------------------------------------------------*/
IPageHandle IPageSelectEvent::pageHandle ( ) const
{
#ifdef IC_PMWIN
  IPageHandle selectedPageHandle (0);
  INotebook* pNotebk = notebook();

  if (pNotebk)
  {
    PAGESELECTNOTIFY* psn = (PAGESELECTNOTIFY*)(void*)parameter2();
#ifdef IC_WIN
    selectedPageHandle = (void*)psn->ulPageIdNew;
#else
    selectedPageHandle = psn->ulPageIdNew;
#endif
  }

  return( selectedPageHandle );
#endif //IC_PMWIN

#ifdef IC_MOTIF
  IPageHandle selectedPageHandle( 0 );
  XmNotebookCallbackStruct* psn = (XmNotebookCallbackStruct*)(void*)parameter1();
  XmNotebookPageInfo pageInfo;

  XmNotebookPageStatus
     pageStatus = XmNotebookGetPageInfo( controlHandle(),
                                         psn->page_number,
                                         &pageInfo);
  if ((pageStatus == XmPAGE_FOUND || pageStatus == XmPAGE_EMPTY) &&
      pageInfo.status_area_widget)
  {
     unsigned long userData;
     XtVaGetValues( pageInfo.status_area_widget,
                    XmNuserData, &userData,
                    NULL );
     selectedPageHandle = IPageHandle( ((PageData*)userData)->pageHandle );
  }

  return selectedPageHandle;
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IPageSelectEvent::previousSelectedPageHandle                                 |
|                                                                              |
| Return the new id of the previously selected notebook page.                  |
------------------------------------------------------------------------------*/
IPageHandle IPageSelectEvent::previousSelectedPageHandle ( ) const
{
#ifdef IC_PMWIN
  IPageHandle previousPageHandle (0);
  INotebook* pNotebk = notebook();

  if (pNotebk)
  {
    PAGESELECTNOTIFY* psn = (PAGESELECTNOTIFY*)(void*)parameter2();
#ifdef IC_WIN
    previousPageHandle = (void*)psn->ulPageIdCur;
#else
    previousPageHandle = psn->ulPageIdCur;
#endif
  }

  return( previousPageHandle );
#endif //IC_PMWIN

#ifdef IC_MOTIF
  IPageHandle prevSelectedPageHandle( 0 );
  XmNotebookCallbackStruct* psn = (XmNotebookCallbackStruct*)(void*)parameter1();
  XmNotebookPageInfo pageInfo;

  XmNotebookPageStatus
     pageStatus = XmNotebookGetPageInfo( controlHandle(),
                                         psn->prev_page_number,
                                         &pageInfo);
  if ((pageStatus == XmPAGE_FOUND || pageStatus == XmPAGE_EMPTY) &&
      pageInfo.status_area_widget)
  {
     unsigned long userData;
     XtVaGetValues( pageInfo.status_area_widget,
                    XmNuserData, &userData,
                    NULL );
     prevSelectedPageHandle = IPageHandle( ((PageData*)userData)->pageHandle );
  }

  return prevSelectedPageHandle;
#endif //IC_MOTIF
}

