// Revision: 17 1.7.1.6 source/ui/baseapp/imoushdr.hpp, userinput, ioc.v400, 001006 
#ifndef _IMOUSHDR_
#define _IMOUSHDR_
/*******************************************************************************
* FILE NAME: imoushdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMouseHandler                                                            *
*     IMouseClickConnectionTo                                                  *
*     IMouseMoveConnectionTo                                                   *
*     IMouseConnectionTo                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ibitflag.hpp>
#include <imousevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMouseHandlerData;

#pragma enum(4)
#pragma pack(push,4)

class IMouseHandler : public IHandler {
typedef IHandler
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IMouseHandler ( const Style& style = defaultStyle() );
virtual
 ~IMouseHandler ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0 ( Style, IMouseHandler );
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noMouseMoves,
  IC_IMPORTU someMouseMoves,
  IC_IMPORTU allMouseMoves,
  IC_IMPORTU mouseEntersLeaves;

static Style
  defaultStyle    ( );
static void
  setDefaultStyle ( const Style& style );

/*---------------------------- Event Dispatching -----------------------------*/
virtual IMouseHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  mouseClicked       ( IMouseClickEvent&   event );

virtual bool
  mouseMoved         ( IMouseEvent&        event ),
  mouseEnter         ( IEvent&             event ),
  mouseLeave         ( IEvent&             event );

virtual bool
  mousePointerChange ( IMousePointerEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
static Style
  fgCurrentDefaultStyle;
Style
  fStyle;
IMouseHandlerData
 *fMouseHandlerData;
}; // IMouseHandler

#pragma info(nocpy)

template <class ATarget>
class IMouseClickConnectionTo : public IMouseHandler {
typedef IMouseHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef bool  (ATarget::* ClickMemberFunction)( IMouseClickEvent& );

/*------------------------------- Constructors -------------------------------*/
  IMouseClickConnectionTo ( ATarget&            target,
                            ClickMemberFunction clickMemberFunction );
virtual
 ~IMouseClickConnectionTo ( );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual bool
  mouseClicked ( IMouseClickEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
ClickMemberFunction
  fConnectedClickMember;
}; // IMouseClickConnectionTo

template <class ATarget>
class IMouseMoveConnectionTo : public IMouseHandler {
typedef IMouseHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef bool  (ATarget::* MoveMemberFunction)( IMouseEvent& );
typedef bool  (ATarget::* EnterMemberFunction)( IEvent& );
typedef bool  (ATarget::* LeaveMemberFunction)( IEvent& );

/*------------------------------- Constructors -------------------------------*/
  IMouseMoveConnectionTo ( ATarget&            target,
                           MoveMemberFunction  moveMemberFunction = 0,
                           EnterMemberFunction enterMemberFunction = 0,
                           LeaveMemberFunction leaveMemberFunction = 0 );
virtual
 ~IMouseMoveConnectionTo ( );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual bool
  mouseMoved ( IMouseEvent& event ),
  mouseEnter ( IEvent&      event ),
  mouseLeave ( IEvent&      event );

private:
/*--------------------------------- Private ----------------------------------*/
static Style
  styleForFunctions ( MoveMemberFunction  moveMemberFunction,
                      EnterMemberFunction enterMemberFunction,
                      LeaveMemberFunction leaveMemberFunction );
ATarget
 &fTarget;
MoveMemberFunction
  fConnectedMoveMember;
EnterMemberFunction
  fConnectedEnterMember;
LeaveMemberFunction
  fConnectedLeaveMember;
}; // IMouseMoveConnectionTo

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
#ifdef IC_PMWIN

template <class ATarget>
class IMouseConnectionTo : public IMouseHandler {
typedef IMouseHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef bool (ATarget::* ClickMemberFunction)( IMouseClickEvent& );
typedef bool (ATarget::* MoveMemberFunction)( IMouseEvent& );
typedef bool (ATarget::* PointerMemberFunction)( IMousePointerEvent& );

/*------------------------------- Constructors -------------------------------*/
  IMouseConnectionTo ( ATarget&              target,
                       ClickMemberFunction   clickMemberFunction = 0,
                       MoveMemberFunction    moveMemberFunction = 0,
                       PointerMemberFunction pointerMemberFunction = 0 );
virtual
 ~IMouseConnectionTo ( );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual bool
  mouseClicked       ( IMouseClickEvent&   event ),
  mouseMoved         ( IMouseEvent&        event ),
  mousePointerChange ( IMousePointerEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
ClickMemberFunction
  fConnectedClickMember;
MoveMemberFunction
  fConnectedMoveMember;
PointerMemberFunction
  fConnectedPointerMember;
}; // IMouseConnectionTo

#endif // IC_PMWIN
#endif // IC_OBSOLETE

#pragma info(restore)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if ! defined(__TEMPINC__)
#include <imoushdr.c>
#endif

#endif /* _IMOUSHDR_ */
