// Revision: 05 1.6.2.6 source/ui/baseapp/imenuprv.hpp, menu, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IMENUPRV_
#define _IMENUPRV_
/*******************************************************************************
* FILE NAME: imenuprv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of classes that are private              *
*   to the implementation of IMenu and its derived classes.                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1997             *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iwindefs.h>
#include <iwindow.hpp>
#include <iframe.hpp>
#include <ihandle.hpp>
#include <imenu.hpp>
#ifdef IC_MOTIF
  #include <ikeyset.h>
  #include <imnitem.hpp>
#endif
#ifdef IC_MOTIFPM
  #include <imrefcnt.hpp>
  #include <iattribt.hpp>
  #include <iatname.hpp>
  #include <ihandler.hpp>
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBidiSettings;
class IResourceId;
class ISubmenu;
class MenuWindow;
struct _WidgetRec;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| class IMenuItemHandle instances are the elements in a collection             |
| maintained by IMenu.   It correlates the menu item ID and window handle      |
| for each menu item.                                                          |
------------------------------------------------------------------------------*/
class IMenuItemHandle {
public:
/*------------------ Constructors/Destructor -----------------------------------
|  You construct instances of this class from 1) the menu item id and window   |
|  handle or 2) another instance of this class.                                |
------------------------------------------------------------------------------*/
   IMenuItemHandle(const unsigned long id, const IWindowHandle& handle) :
        idCl(id),
        handleCl(handle),
        submenuHandleCl(0),
        fHelpId( 0 ),
        fOwnerDrawCheckedStyle(false),
        fOwnerDrawCheckedState(false) {};
   IMenuItemHandle(const IMenuItemHandle& another) :
        idCl(another.idCl),
        handleCl(another.handleCl),
        submenuHandleCl(another.submenuHandleCl),
        fHelpId( another.fHelpId ),
        fOwnerDrawCheckedStyle(another.fOwnerDrawCheckedStyle),
        fOwnerDrawCheckedState(another.fOwnerDrawCheckedState) {};
   ~IMenuItemHandle() {};

IMenuItemHandle&
   operator=   (const IMenuItemHandle& another)
   { idCl = another.idCl;
     handleCl = another.handleCl;
     submenuHandleCl = another.submenuHandleCl;
     fHelpId = another.fHelpId;
     fOwnerDrawCheckedStyle = another.fOwnerDrawCheckedStyle;
     fOwnerDrawCheckedState = another.fOwnerDrawCheckedState;
     return *this; };

/*--------------------------accessors-------------------------------------------
|  id      - return the id component                                           |
|  handle  - returns the window handle component                               |
|  submenuHandle - returns the submenu handle component                        |
|  setHandle        - sets the  handle component                               |
|  setSubmenuHandle - sets the submenu handle component                        |
|  helpId - returns the helpId for this menu item                              |
|  setHelpId - sets the helpId for this menu item                              |
|  isOwnerDrawStyle - returns true of this item is owner-draw style            |
|  bitmap           - returns the bitmap handle for the menu item.             |
|  setBitmap        - sets the bitmap handle for the menu item.                |
------------------------------------------------------------------------------*/
unsigned long
   id() const                      { return idCl; };
IWindowHandle
   handle() const                  {return handleCl; };
IWindowHandle
   submenuHandle() const           {return submenuHandleCl; };
IMenuItemHandle
  &setHandle( IWindowHandle hwnd ) {handleCl = hwnd; return *this; };
IMenuItemHandle
  &setSubmenuHandle( IWindowHandle hwnd ) {submenuHandleCl = hwnd; return *this; };
unsigned long
  helpId( ) const                  {return fHelpId; };
IMenuItemHandle
 &setHelpId(unsigned long  helpTopicId) {fHelpId=helpTopicId; return *this; };
bool
  isOwnerDrawStyle() const;
void
  setOwnerDrawCheckedStyle(bool ownerDrawChecked) {fOwnerDrawCheckedStyle=ownerDrawChecked; };
bool
  isOwnerDrawCheckedStyle() const  {return fOwnerDrawCheckedStyle; };
void
  setOwnerDrawCheckedState(bool checked) {fOwnerDrawCheckedState=checked; };
bool
  ownerDrawCheckedState() const    {return fOwnerDrawCheckedState; };
void
  setSelectable(bool selectable)   {fSelectable=selectable; };
bool
  isSelectable() const             {return fSelectable; };
IBitmapHandle
  bitmap    ( ) const              { return fBitmap; };
void
  setBitmap (const IBitmapHandle& bitmap )  { fBitmap = bitmap; };

private:
   unsigned long        idCl;
   IWindowHandle        handleCl;
   IWindowHandle        submenuHandleCl;
   unsigned long        fHelpId;
   bool                 fOwnerDrawCheckedStyle;   //AJ26852
   bool                 fOwnerDrawCheckedState;   //AJ26852
   bool                 fSelectable;    //AJ27462
   IBitmapHandle        fBitmap;
friend const unsigned long & key( IMenuItemHandle const& elem );
};      // IMenuItemHandle


// collection of IMenuItemHandle objects keyed by the id.  It is
// used to find the menu item widget given the menu item id.
typedef IKeySet<IMenuItemHandle, unsigned long> IMenuItemList;

// Key function for the IMenuItemList collection
inline const unsigned long & key( IMenuItemHandle const& elem )
  { return elem.idCl; }

#endif //IC_MOTIF


#ifdef IC_WIN
/*--------------------------------------------------------------------*/
/* Menu lookup table layout (in support of old Windows menus)         */
/*--------------------------------------------------------------------*/
typedef struct _fmTable  {  /* fpmtbl */
  unsigned long    fId;               /* Menu item id to map       */
  HMENU            fHMenu;            /* Menu handle to map id to  */
  struct _fmTable* pfmtNext;          /* Ptr to next table entry   */
} FMTABLE;
#endif

/*--------------------------------------------------------------------*/
/* Help lookup table layout (in support of old Windows menus)         */
/*--------------------------------------------------------------------*/
typedef struct _mihTable  {  /* mihtbl */
  unsigned long     fId;                 /* Menu item id to map       */
  unsigned long     fHelpId;             /* Menu handle to map id to  */
  struct _mihTable* pmitNext;            /* Ptr to next table entry   */
} MIHELPTBL;

/*--------------------------------------------------------------------*/
/* Frame table, initialized for and updated in enumeration proc       */
/*--------------------------------------------------------------------*/
typedef struct _FRAMEINFO {   /* frmi */
  IMenuHandle   hmenu;           /* Menu handle to check table for    */
  IWindowHandle owner;           /* Owner window handle               */
  IFrameWindow* frame;           /* Frame window pointer              */
} FRAMEINFO, *PFRAMEINFO;

/*--------------------------------------------------------------------*/
/* Menu resource flags ids (used in new MENUEX format)                */
/*--------------------------------------------------------------------*/
#define MFR_POPUP 0x01
#define MFR_END   0x80

/*--------------------------------------------------------------------*/
/* Define length of menu text string to use to retrieve text from O/S */
/*--------------------------------------------------------------------*/
#define IC_MENUTEXTLENGTH 100


/*------------------------------------------------------------------------------
| IMenuPrivate - static menu functions                                         |
------------------------------------------------------------------------------*/
class IMenuPrivate {
public:
 ~IMenuPrivate ( );

#ifdef IC_WIN
static unsigned long
  findIdForPopup           ( const IMenuHandle&   hBaseMenu,
                             const IMenuHandle&   hMenuToFind );
static void
  addToLookUpTable         ( IFrameWindow*        owner,
                             const IMenuHandle&   menuHandle,
                             unsigned long        itemId ),
  removeFromLookUpTable    ( IFrameWindow*        owner,
                             const IMenuHandle&   menuHandle,
                             unsigned long        itemId ),
  deleteLookUpTable        ( IFrameWindow*        owner ),
  setBidiAttributes        ( IMenuHandle&         menuHandle,
                             const IBidiSettings& bidiSettings );
static HMENU
  getHMenuFromLookUpTable  ( IFrameWindow*        owner,
                             unsigned long        itemId );
static long
  getItemIdFromLookUpTable ( IFrameWindow*        owner,
                             const IMenuHandle&   hMenu );
static IFrameWindow
 *locateFrame              ( IWindow*             window );

static bool
  buildLookUpTableFromResourceLoad( IFrameWindow*      owner,
                                    const IMenuHandle& menuHandle,
                                    const IResourceId& menuResId ),
  locateMenuItem                  ( IFrameWindow*      owner,
                                    const IMenuHandle& hMenu,
                                    unsigned long      itemId,
                                    long*              pItemPos,
                                    IMenuHandle*       pMenu );

static int __stdcall
  EnumAllFrames        ( HWND  hwnd,
                         long  lpData );
#endif // IC_WIN

#ifdef IC_MOTIF
static MenuWindow
 *rootMenuWindowForHandle ( const IMenuHandle& handle );
static MenuWindow
 *menuWindowForHandle     ( const IMenuHandle& handle );
static void
  refreshMenuBar          ( const IMenuHandle& handle );
static void
  setActiveMenu           ( const IMenuHandle& handle );
// The default separator ID in the class interface is 0.  The resource compiler
// uses 65535 for separators.  Anything larger than 65535 is documented as
// non-portable.
static bool
  isDefaultSeparatorId    ( unsigned long menuItemId )
     { return ((menuItemId == 0) || (menuItemId >= 65535)) ? true : false;};
#endif // IC_MOTIF

static void
  setMenuItemHelpId    ( IFrameWindow*  owner,
                         unsigned long  menuItemId,
                         unsigned long  helpTopicId ),
  deleteHelpIdTable    ( IFrameWindow*  owner );
static unsigned long
  queryMenuItemHelpId  ( IFrameWindow*  owner,
                         unsigned long  menuItemId );

private:
  IMenuPrivate( );

}; // IMenuPrivate


/*------------------------------------------------------------------------------
| IMenuData class -  IMenu private data                                        |
------------------------------------------------------------------------------*/
#ifdef IC_MOTIF
class IMenuData : public IMRefCounted {                 // 28465
#else
class IMenuData {
#endif
public:
#ifdef IC_PMWIN
  IMenuData ( );
#endif //IC_PMWIN
#ifdef IC_MOTIF
  IMenuData( IMenu* menu );
#endif //IC_MOTIF
#ifdef IC_MOTIF
private:                                                // 28465
 // this is a ref counted object, thus removeRef() should be the only way
 // to delete this object.
 ~IMenuData ( );
#else
 ~IMenuData ( );
#endif

public:                                                 // 28465
bool
  fUpdateAllowed;

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
   itemWithId        - returns window handle of menu item with id
   submenuHandleWithId - returns handle of submenu popop window for submenu
                         item with id
   helpId            - return the help topic id of the menu item with this
                       menuItemId
   setHelpId         - set the help topic id of the menu item with this
                       menuItemId
   itemWithHandle    - returns id of menu item with handle w
   isOwnerDrawStyle  - returns true if item with given id has ownerdraw style
   ownerDrawCheckedState - returns true if item with given id is ownerdraw
                           and is checked.
   setOwnerDrawCheckedState - sets the checked state of an  ownerdraw item.
   menuDataForHandle - returns pointer to the IMenuData object for the menu
                       containing the item with the handle specified, or 0
                       if none found.
   itemWithIdExists     - returns true if an IMenuItemHandle object with the
                          specified id exists, false otherwise.
   menuItemHandleWithId - returns reference to IMenuItemHandle object
                          for the specified id.
------------------------------------------------------------------------------*/
IWindowHandle
  itemWithId( unsigned long id ) const,
  submenuHandleWithId( unsigned long id ) const;
unsigned long
  helpId   (unsigned long  menuItemId) const;
void
  setHelpId(unsigned long  menuItemId,
            unsigned long  helpTopicId);
unsigned long
  itemWithHandle( const IWindowHandle& w ) const;
bool
  isOwnerDrawStyle(unsigned long id) const;
static bool
  isHandleOwnerDrawStyle( const IWindowHandle& itemButton );
void
  setOwnerDrawCheckedStyle(unsigned long id, bool checkedStyle);   //27112
bool
  isOwnerDrawCheckedStyle(unsigned long id) const;       //26856
void
  setOwnerDrawCheckedState(unsigned long id, bool checked);   //26856
bool
  ownerDrawCheckedState(unsigned long id) const;      //26856
void
  setSelectable(unsigned long id, bool selectable);   //27462
bool
  isSelectable(unsigned long id) const;       //27462

IMenuData
  &getPData( );

static IMenuData*
  menuDataForHandle( const IWindowHandle& itemHandle );

bool
  itemWithIdExists    ( unsigned long id ) const;
IMenuItemHandle&
  menuItemHandleWithId( unsigned long id );
const IMenuItemHandle&
  menuItemHandleWithId( unsigned long id ) const;

/*------------------------------------------------------------------------------
    addItem   - creates a new menu item widget and adds it to the collection
                listing the existing items.   Id is the menu item id,
                afStyle is the style of the item, and intoSubmenuId is the
                id of the parent submenu, or 0,  Returns handle of new widget.
    addSubmenu - adds a submenu popup window widget
    deleteItem - removes menu item from list and destroys widget
    removeSubmenu - removes submenu popup widget and any menuitems which
                    are part of submenu.
------------------------------------------------------------------------------*/
IWindowHandle
  addItem( unsigned long id, unsigned long afStyle, unsigned long intoSubmenuId),
  addSubmenu( unsigned long id );
IMenuData
  &deleteItem( unsigned long id ),
  &removeSubmenu( unsigned long id ),
  &removeItemFromList( unsigned long id ),
  &removeSubmenuFromList( unsigned long id );

/*------------------------------------------------------------------------------
  Owner draw support
    makeCascadeOwnerDraw - configures cascade button to become an owner draw
                           item.
    makeCascadeNonOwnerDraw - configures a cacade button that was an owner draw
                           item to be a non owner draw item.
    handleDrawItems      - Determines need for and delivers draw item events
                           for the specified menu item.  Returns true if
                           draw item event was delivered and processed.
    sendDrawItemEvent    - Delivers a draw item event to the owner window
                           of the menu.
------------------------------------------------------------------------------*/
void
  makeCascadeOwnerDraw( IWindowHandle itemButton, unsigned long id ),
  makeCascadeNonOwnerDraw( IWindowHandle itemButton, unsigned long id );
static bool
  handleDrawItems     ( const IWindowHandle& itemButton, /* current button     */
                        unsigned long        itemId,     /* current id (or -1) */
                        unsigned long        odState);   /* ODA_ state flags   */
bool
  sendDrawItemEvent   ( const IWindowHandle& itemButton, /*widget of OD button */
                        unsigned long        itemId,     /*ID of item (or -1)  */
                        unsigned long        odState );  /*ODA_* state flags   */

/*------------------------------------------------------------------------------
  Cursor support
    positionMenuCursor   - positions the specified IMenu::Cursor.
    positionCursor       - function that does the work of positioning
                           a menu cursor on any rowcolumn.  Returns the new
                           cursor position (-1 is invalid).
------------------------------------------------------------------------------*/
enum ECursorPosition {
  kFirst, kNext, kLast, kPrevious
};
bool        positionMenuCursor( IMenu::Cursor& cursor, ECursorPosition position );
long        positionCursor    ( _WidgetRec* menuHandle,
                                long current,
                                ECursorPosition position );

/*------------------------------------------------------------------------------
  Resizing of realized rowcolumn.  When menu items are added to a realized
  rowcolumn (as in menuShowing) that cause the rowcolumn to get wider,
  clicking on menuitems in the area added due to the resize (the pad
  to the right of the text) does not generate the
  activate callback.  A workaround is to add a dummy
  dummy widget at the beginning of the rowcolumn's child list
  after the menuShowing function, and set its text such that it
  is the longest item.  We then  unmanage this widget when the menu
  is shown, and manage it again when the menu is unmapped.
    addSizingWidget - Creates the sizing widget if needed.  Returns the
                      handle of the widget if it was added, 0 otherwise.
    sizingWidget    - Returns sizing widget if it exists for the rowcolumn,
                      0 otherwise.
    adjustForSize   - Sets the text of the sizing widget such that it .
                      is as wide as the rowcolumn.  Returns the new width
                      of the rowcolumn.
    removeSizingWidget - removes the sizing widget.
------------------------------------------------------------------------------*/
static _WidgetRec*   addSizingWidget( _WidgetRec* rowcol, unsigned long oldSize);
static _WidgetRec*   sizingWidget   ( _WidgetRec* rowcol );
static unsigned long adjustForSize  ( _WidgetRec* rowcol );
static void          removeSizingWidget( _WidgetRec* rowcol );


IMenuItemList
  itemList;
bool
  creatingMenuUnmanaged;
IMenu
  *pMenu;       // owning IMenu of this object

#endif //IC_MOTIF
/*----------------------- Private -----------------------------------*/
private:
  IMenuData(const IMenuData&);
  IMenuData &operator=(const IMenuData&);

}; // IMenuData

#ifdef IC_MOTIF
void imenuPopUpCallback  ( _WidgetRec* handle,
                           void*       client_data,
                           void*       call_data);
void imenuPopDownCallback( _WidgetRec* handle,
                           void*       client_data,
                           void*       call_data);
#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| SubmenuRec class                                                             |
------------------------------------------------------------------------------*/
class SubmenuRec {
// ISubmenu does not call startHandlingEvents()
// as part of its ctor. We do need to handle cascaded
// menus that will nest WM_INITMENU and WM_MENUENDED pairs.
// Will use a collection of SubmenuRec's to do this.
public:
  SubmenuRec(unsigned long mnItem,
             IWindowHandle owner,
             ISubmenu* pSubmenu)
    : mnItemCl(mnItem), ownerCl(owner), pSubmenuCl(pSubmenu), nestedCnt(0) {}
  unsigned long mnItemCl;
  IWindowHandle ownerCl;
  ISubmenu*     pSubmenuCl;
  unsigned long nestedCnt;
};


#ifdef IC_MOTIFPM
class IMenuAttribute : public IAttribute {
public:
static char* const menuAttrName;

  IMenuAttribute(IMenu* menu);
virtual bool
  operator=(const IAttribute& anAttribute);
virtual bool
  operator==(const IAttribute& anAttribute) const;
virtual IAttribute
  *clone() const;
IMenu
 *fMenu;
}; // class IMenuAttribute


//------------------------------------------------------------------------
// 26329
// MenuWindow is the wrapper for the OS/2 window or Motif widget which
// underlies an IMenu or subclass object. Since IMenu et al. no longer derive
// from IWindow, they instead hold an instance of MenuWindow. The MenuWindow,
// in turn, holds a reference to its matching IMenu or subclass; the reference
// is held as an IWindowAttribute of type IMenuAttribute. Since the MenuWindow
// associated with ISubmenus are created internal to IOC and can thus never have any
// client handlers attached, they always re-dispatch any events they receive
// to their "root" MenuWindow; the "root" is defined as the MenuWindow
// associated with an IMenuBar or IPopUpMenu. ISystemMenu is it's own "root".
// NOTE: OS/2 event routing works fine without the above "re-dispatch" logic,
// so currently re-dispatch is only done for Motif MenuWindows.
//
// UniversalRedispatcher is the IHandler that helps with the re-dispatch.
//--------------------------------------------------------------------------
class UniversalRedispatcher : public IHandler {
public:
  UniversalRedispatcher(MenuWindow* menuWindow);
virtual
 ~UniversalRedispatcher();
virtual bool
  dispatchHandlerEvent(IEvent& evt);
private:
MenuWindow
 *fMenuWindow;

}; //UniversalRedispatcher


class MenuWindow : public IWindow, public IMRefCounted {
public:
  MenuWindow ( const IWindowHandle& handle, IWindow* rootMenu );
  MenuWindow ( );
virtual
 ~MenuWindow ( );

IMenu
 *menu   ( ) const;
MenuWindow
 &setMenu( IMenu* menu );

#ifdef IC_MOTIF
virtual bool
  passEventToOwner ( IEvent& event );
#endif

bool
  redispatchToRootMenu(IEvent& evt);
private:
MenuWindow
 *fRootMenu;
UniversalRedispatcher
 fUniversalRedispatcher;

  MenuWindow( const MenuWindow& );
  MenuWindow& operator=( const MenuWindow& );
}; //MenuWindow

#endif //IC_MOTIFPM


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _IMENUPRV_ */

