// Revision: 01 1.7.3.2 source/ui/baseapp/imenuhdr.cpp, menu, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: imenuhdr.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in imenuhdr.hpp                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

extern "C" {
   #define INCL_WINFRAMEMGR
   #define INCL_WININPUT
   #define INCL_WINPOINTERS
   #define INCL_WINSYS
   #define INCL_WINWINDOWMGR
   #include <iwindefs.h>
   #ifdef IC_MOTIF
     #include <X11/IntrinsicP.h>
     #include <X11/CoreP.h>     
     #include <Xm/RowColumn.h>
   #endif
}


#include <imenuhdr.hpp>
#include <imenuprv.hpp>
#include <isubmenu.hpp>
#include <ipopmenu.hpp>
#include <imenubar.hpp>  //for debug
#include <isysmenu.hpp>  //for debug
#include <itrace.hpp>
#include <iseq2.h>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IMENUHDR_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_WIN
/*--------------------------------------------------------------------*/
/* Structure declarations for caching font enumeration callback info  */
/*--------------------------------------------------------------------*/
typedef struct _POPUPCACHE {   /* popcach */
  unsigned long       popupId;       /* Popup id                      */
  HMENU               hmenu;         /* handle of the popup menu      */
  struct _POPUPCACHE* ppcNext;       /* next POPUPCACHE in the list   */
} POPUPCACHE, *PPOPUPCACHE;

/*------------------------------------------------------------------------------
| cachePopupIdForEnd                                                           |
|  Local function to save away initialized menus for navigating through and    |
|  sending out WM_MENUEND notifications for when complete                      |
------------------------------------------------------------------------------*/
void IMenuHandler::cachePopupIdForEnd ( const IMenuHandle& menuHandle,
                                        unsigned long      itemId )
{
  IMODTRACE_DEVELOP("IMenuHandler::cachePopupIdForEnd");
  // Create a new popup cache table entry and fill it with the info passed
  POPUPCACHE* pPopCache = new POPUPCACHE;
  pPopCache->popupId = itemId;
  pPopCache->hmenu = (HMENU)menuHandle;

  // Default the next entry to null
  pPopCache->ppcNext = 0;

  // Check if there are current entries, and if so chain to list
  if (fpPopCacheList)
    pPopCache->ppcNext = (POPUPCACHE*)fpPopCacheList;

  // Finally, since this is now the start of the list, save it
  fpPopCacheList = (void*)pPopCache;
}

/*------------------------------------------------------------------------------
| deletePopupCache                                                             |
|  Local function to delete the popup cache for the handler                    |
------------------------------------------------------------------------------*/
void IMenuHandler::deletePopupCache ( )
{
  IMODTRACE_DEVELOP("IMenuHandler::deletePopupCache");
  if (fpPopCacheList)
  {
    POPUPCACHE* pPopCache = (POPUPCACHE*)fpPopCacheList;
    POPUPCACHE* pNext;
    do {
      pNext = pPopCache->ppcNext;
      delete pPopCache;
      pPopCache = pNext;
    } while (pPopCache);
  }
  fpPopCacheList = 0;
}
#endif // IC_WIN


typedef ISequence<SubmenuRec*> SubmenuCol;
static SubmenuCol* pSubmenuCol = 0;

static bool
  IMenuDeleteElements ( SubmenuRec* const& pMenuRec,
                        void*              hmenu )
{
  bool rc = false;

  ISubmenu* pSubmenu = pMenuRec->pSubmenuCl;
  if ( pSubmenu )
  {
     IMenuHandle
       submenuHandle( pSubmenu->menuHandle() );
     if ( submenuHandle.asUnsigned() == (unsigned long) hmenu )
     {  // This matches the submenu object to be deleted.

        // Skip the submenu undo for any menus that have already
        // been destroyed (such as pop-up menus with auto-delete
        // object), because this would otherwise result in an
        // exception.
#ifdef IC_WIN
        if ( IsMenu( submenuHandle ) )
#else
        if ( submenuHandle.isValid() )
#endif
        {
#ifdef IC_MOTIF
           if ( ! ( (Widget) submenuHandle )->core.being_destroyed )
           {
              pSubmenu->undo();
           }
#else
           pSubmenu->undo();
#endif
        }
        delete pSubmenu;
        delete (SubmenuRec*)pMenuRec;
        rc = true;
     }
     else
     {
        // Clean out any stale ISubmenu objects from the collection
        // -- those that didn't get deleted through normal means
        // (for example, because the application removed or disabled
        // a menu handler between calls to the menuShowing and
        // menuEnded virtual functions). This won't kick in until
        // sometime after the menu is destroyed (a submenu is
        // destroyed when its owner window is destroyed).
#ifdef IC_WIN
        if ( ! IsMenu( submenuHandle ) )
#endif
#ifdef IC_MOTIFPM
        if ( ! submenuHandle.isValid() )
#endif
        {
           delete pSubmenu;
           delete (SubmenuRec*) pMenuRec;
           rc = true;
        }
     }
  }
  else
  {
     // Collection item without a submenu object. This is invalid,
     // so delete it.
     delete (SubmenuRec*) pMenuRec;
     rc = true;
  }
  return rc;
}

#ifdef IC_PM
// Define a static handler to delete popup menus when they disappear.
// This handler is only attached when the menu end message is received
// and autoDeleteObject is set.  This handler is needed to delay the
// deletion of the menu object until all of the menu handlers and/or PM
// have processed the menu end message (otherwise traps may occur).
#pragma enum(4)
#pragma pack(push,4)

class AutoDeleteHandler : public IHandler {
typedef IHandler
  Inherited;
public:
  AutoDeleteHandler ( );
virtual
 ~AutoDeleteHandler ( );
protected:
virtual bool
  dispatchHandlerEvent ( IEvent& event );
}; // AutoDeleteHandler

#pragma pack(pop)
#pragma enum(pop)

/*------------------------------------------------------------------------------
| AutoDeleteHandler::AutoDeleteHandler                                         |
------------------------------------------------------------------------------*/
AutoDeleteHandler::AutoDeleteHandler ( )
  : AutoDeleteHandler::Inherited( )
{ }

/*------------------------------------------------------------------------------
| AutoDeleteHandler::~AutoDeleteHandler                                        |
------------------------------------------------------------------------------*/
AutoDeleteHandler::~AutoDeleteHandler ( )
{ }

/*------------------------------------------------------------------------------
| AutoDeleteHandler::dispatchHandlerEvent                                      |
------------------------------------------------------------------------------*/
bool AutoDeleteHandler::dispatchHandlerEvent ( IEvent& event )
{
  IMODTRACE_DEVELOP("AutoDeleteHandler::dispatchHandlerEvent");
   if (event.eventId() == IC_UM_DESTROY_MENU)
   {
      stopHandlingEventsFor(event.window());
      // Use PM to destroy the window so that the handlers will
      // work correctly and the auto delete code in the dispatcher
      // is executed (when the WM_DESTROY msg is handled).
      // Assume that the destructor of the IWindow menu object will
      // then delete the IMenu object.
      IDESTROYWINDOW( event.handle() );
      return true;
   }

   return false;
}

static struct DefaultDeleteHandler {
  operator AutoDeleteHandler* ();
AutoDeleteHandler
 *operator -> ()
    {
    return *this;
    }
 ~DefaultDeleteHandler ( )
    {
    if (ptr)
      {
      delete ptr;
      ptr = 0;
      }
    }
AutoDeleteHandler
 *ptr;
} defaultDeleteHandler;

/*------------------------------------------------------------------------------
| DefaultDeleteHandler :: operator AutoDeleteHandler* ( )                      |
------------------------------------------------------------------------------*/
DefaultDeleteHandler :: operator AutoDeleteHandler* ( )
{
  IMODTRACE_DEVELOP("DefaultDeleteHandler::operator AutoDeleteHandler*");
  if ( !ptr )
     ptr = new AutoDeleteHandler;
  return ptr;
}

#endif // IC_PM

/*------------------------------------------------------------------------------
| IMenuHandler::IMenuHandler                                                   |
------------------------------------------------------------------------------*/
IMenuHandler::IMenuHandler ( )
#ifdef IC_WIN
  : fhMenuSelect(0), fpPopCacheList(0)
#endif
#ifdef IC_MOTIF
  : IMenuHandler::Inherited ()
#endif
{
   IMODTRACE_DEVELOP("IMenuHandler::IMenuHandler");
   if (pSubmenuCol == 0) {
      pSubmenuCol = new SubmenuCol(10);
   } /* endif */
}

/*------------------------------------------------------------------------------
| IMenuHandler::~IMenuHandler                                                  |
------------------------------------------------------------------------------*/
IMenuHandler::~IMenuHandler ( )
{
   IMODTRACE_DEVELOP("IMenuHandler::~IMenuHandler");
#ifdef IC_WIN
   deletePopupCache();
#endif
}

/*------------------------------------------------------------------------------
| IMenuHandler::dispatchHandlerEvent                                           |
------------------------------------------------------------------------------*/
bool IMenuHandler::dispatchHandlerEvent ( IEvent& evt )
{
   IMODTRACE_DEVELOP("IMenuHandler::dispatchHandlerEvent");

   switch (evt.eventId())
   {
#ifdef IC_PM
      case WM_TRANSLATEACCEL:
      {
         ITRACE_DEVELOP(IString("WM_TRANSLATEACCEL"));
         // Check for SV_CONTEXTMENUKB translation
         // Low word is the virtual key code (VK_*)
         // High word is the keyboard control code (KC_*)

         unsigned long
           svKeyPopUp = WinQuerySysValue(IWindow::desktopWindow()->handle(),
                                         SV_CONTEXTMENUKB);

         PQMSG pQmsg = (PQMSG) (unsigned long) evt.parameter1();

         // Because the keyboard does not really send the exact same
         // keyboard control codes, we need to do the checking in
         // several stages:
         //
         //  - bits 0 thru 2 must have the desired bits turned on, but
         //    may also have others (KC_CHAR, KC_VIRTUALKEY, KC_SCANCODE)
         //  - bits 3 thru 7 must match (KC_SHIFT, KC_CTRL, KC_ALT,
         //    KC_KEYUP, KC_KEYDOWN)
         //  - bits 8 thru 15 can be ignored
         //  - the virtual key (VK_*) values must match

         if (( SHORT1FROMMP(pQmsg->mp1) & SHORT2FROMMP(svKeyPopUp) & 0x07) &&
            (( SHORT1FROMMP(pQmsg->mp1) & 0xF8) ==
             ( SHORT2FROMMP(svKeyPopUp) & 0xF8) ) &&
             ( SHORT2FROMMP(pQmsg->mp2) == SHORT1FROMMP(svKeyPopUp)) )
         {
           // This is a popup menu request from the keyboard
           pQmsg->hwnd = evt.window()->handle();
           pQmsg->msg = WM_CONTEXTMENU;
           pQmsg->mp1 = 0;
           pQmsg->mp2 = (void *) 0x10000;
           evt.setResult(true);
           return true;
         }
      }
      break;
#endif //IC_PM

      case WM_CONTEXTMENU:
      {
         ITRACE_DEVELOP(IString("WM_CONTEXTMENU"));
         IMenuEvent mnEvt(evt);
         if (makePopUpMenu(mnEvt))
         {
            addSourceEmphasis(mnEvt);
            evt.setResult(true);   //Tell system action taken.
            return true;
         } /* endif */
      } /* endcase */
      break;

#ifdef IC_WIN
      case WM_INITMENU:
        ITRACE_DEVELOP(IString("WM_INITMENU (Win)"));
        fhMenuSelect = 0;   // If starting a new menu, initialize select handle
      break;

      case WM_INITMENUPOPUP:
      {
         ITRACE_DEVELOP(IString("WM_INITMENUPOPUP (Win)"));
         IMenuEvent mnEvt(evt);
         // Take previously saved menu handle (from select below), and add
         //  into the event for potential querying by application of id
         mnEvt.fPrevMenuParent = fhMenuSelect;

         // Since each init occurs only once per menu navigation, need to
         // cache away the ids and handles for use in menu ending
         cachePopupIdForEnd( IMenuHandle(evt.parameter1()), mnEvt.menuItemId() );
#endif
#ifdef IC_PM
      case WM_INITMENU:
      {
         ITRACE_DEVELOP(IString("WM_INITMENU (OS/2)"));
         IMenuEvent mnEvt(evt);
#endif
#ifdef IC_PMWIN
         bool found = false;
         SubmenuCol::Cursor cursor(*pSubmenuCol);
         for ( cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
         {
            SubmenuRec *pRec = pSubmenuCol->elementAt(cursor);
            if (pRec->mnItemCl == mnEvt.menuItemId())
            {
               // A submenu record already exists for this menu.  This
               // means it is a nested call
               pRec->nestedCnt++;
               found = true;
            }
         }

         if (!found)
         {
     #ifdef IC_WIN
           ISubmenu* pSubmenu = new ISubmenu(IMenuHandle(evt.parameter1()));
     #endif
     #ifdef IC_PM
           ISubmenu* pSubmenu = new ISubmenu(IWindowHandle(evt.parameter2()));
     #endif //IC_PM
           if (menuShowing(mnEvt, *pSubmenu)) {
              // Add only if action taken
              pSubmenuCol->addAsFirst(new SubmenuRec(mnEvt.menuItemId(),
                                              mnEvt.handle(), pSubmenu));
              return true;
           } /* endif */
           delete pSubmenu; //No action taken - delete ISubmenu*
         }
         else
           return true;

      } /* endcase */
      break;
#endif //IC_PMWIN

#ifdef IC_MOTIF
      case WM_INITMENU:
      {
        bool bRC( false );
        ITRACE_DEVELOP(IString("WM_INITMENU"));
        IMenuEvent mnEvt(evt);
        Widget rc = (Widget)mnEvt.parameter2().asUnsignedLong();
        ISubmenu* pSubmenu=0;
        if ( (rc) && (XmIsRowColumn(rc)) )
        {
//          unsigned long rcSize = IMenuData::addSizingWidget( rc );

          // Get the rowcolumn widget's current width.  We use this later
          // to see if we need a sizing widget.
          Dimension rcWidth = 0;
          XtVaGetValues(rc, XmNwidth, &rcWidth, 0);

          pSubmenu = new ISubmenu(IMenuHandle(rc));
          if (menuShowing(mnEvt, *pSubmenu))
          {

            // Add only if action taken
            pSubmenuCol->addAsFirst(new SubmenuRec(mnEvt.menuItemId(),
                                         mnEvt.controlHandle(), pSubmenu));

            // Handle the case where the rowcolumn has gotten wider due
            // to actions in menuShowing.   In this case, clicking on
            // menuitems in the area added due to the resize (the pad
            // to the right of the text) does not generate the
            // activate callback.  A workaround is to add a dummy
            // dummy widget at the beginning of the rowcolumns child list
            // after the menuShowing function, and
            // set its text such that it is the longest item.  We then
            // unmanage this widget when the menu is shown, and manage it
            // again when the menu is unmapped.
            Widget w = IMenuData::addSizingWidget( rc, rcWidth );
            if (w)
            {  // Widget not created if rowcolumn is not realized or
               // did not increase in size.

               // Apply the corrections to the sizing widget and then
               // unmanage it so that it does not show.
               IMenuData::adjustForSize( rc );
               XtUnmanageChild( w );
            }
            bRC = true;
          } /* endif */
          else
          {
            delete pSubmenu;   // No action taken, so delete it.
          }
        } /* endif */

        return bRC;
      } /* endcase */
      break;
#endif //IC_MOTIF

      case WM_MENUSELECT:
      {
         ITRACE_DEVELOP(IString("WM_MENUSELECT"));
#ifdef IC_WIN
         if (evt.parameter1().highNumber() != 0xFFFF)   //Don't process invalid
         {                                              //menu item ID
           // Save selected menu handle for use in event processing
           fhMenuSelect = evt.parameter2();
#endif
#ifdef IC_MOTIFPM
         if (evt.parameter1().lowNumber() != 0xFFFF)    //Don't process invalid
         {                                              //menu item ID
#endif
            IMenuEvent mnEvt(evt);
            mnEvt.setResult(true);             //default result to true to
            if (menuSelected(mnEvt)) {         //tell PM to post command
               evt.setResult(mnEvt.result());  //Apps can override with false.
               return true;
            } /* endif */
         } /* endif */
      }
      break;

#ifdef IC_WIN
      // If menu loop completes, need to send individual end messages for each
      //  popup that was shown - get these from cache list
      case WM_EXITMENULOOP:
      {
        ITRACE_DEVELOP(IString("WM_EXITMENULOOP"));
        POPUPCACHE* pPopCache = (POPUPCACHE*)fpPopCacheList;
        while (pPopCache)
        {
          evt.window()->sendEvent( WM_MENUEND,
                                   IEventParameter1( pPopCache->popupId ),
                                   IEventParameter2( pPopCache->hmenu ) );
          pPopCache = pPopCache->ppcNext;
        }
        deletePopupCache();
      }
      break;
#endif

      case WM_MENUEND:
      {
         ITRACE_DEVELOP(IString("WM_MENUEND"));
         IMenuEvent menuEvent(evt);

#ifdef IC_PMWIN
         bool nested = false;
         SubmenuCol::Cursor cursor(*pSubmenuCol);
         for ( cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
         {
            SubmenuRec *pRec = pSubmenuCol->elementAt(cursor);
            if ((pRec->mnItemCl == menuEvent.menuItemId()) &&
                (pRec->nestedCnt > 0))
            {
               // This is a nested call (to match a nested initmenu)
               nested = true;
               pRec->nestedCnt--;
            }
         }

         if (!nested)
         {
           bool endReturn = (menuEnded(menuEvent));

           if (!pSubmenuCol->isEmpty())
           {
              // We delay the delete of the submenu to after we call
              // all handlers to process the menuEnded event. We do
              // this by deleting the submenu during the processing of
              // a posted event, in which we store the submenu handle.
              // We post this event to this same handler (not to the 
              // AutoDeleteHandler). If this handler isn't around to
              // catch the event, code in IMenuDeleteElements can
              // still delete the submenu at a later time.
              menuEvent.dispatchingWindow()
               ->postEvent( IC_UM_DESTROY_MENU,
                            IEventParameter1( menuEvent.parameter2() ) );
           }
     #ifdef IC_PM
           // Auto-delete object processing.
           // Assume the menu handle will be destroyed in other
           // cases by the application explicitly deleting the
           // IMenu object.
           IWindow* popUpWindow =
                    IWindow::windowWithHandle(IWindowHandle(menuEvent.parameter2()));
           if (popUpWindow)
           {
              if ( popUpWindow->isAutoDeleteObject() )
              {
                 // Post a message so that all menu handlers get to
                 // handle this event before the menu handle is
                 // destroyed.
                 ITRACE_DEVELOP( IString("IWindow ") +
                                 IString((unsigned long)popUpWindow) +
                                 IString(" is getting an AutoDeleteHandler.") );
                 ((AutoDeleteHandler*)defaultDeleteHandler)->
                                      handleEventsFor(popUpWindow);
                 popUpWindow->postEvent(IC_UM_DESTROY_MENU);
              }
           } /* endif */
     #endif //IC_PM
           return endReturn;
         }
         else
           return true;
#endif //IC_PMWIN

#ifdef IC_MOTIF
         bool endReturn = (menuEnded(menuEvent));

         if (!pSubmenuCol->isEmpty())
         {
           //If there is a sizing widget for this rowcolumn, we need to
           //manage it here to insure that the activate callback occurs.
           //Because the rowcolumn is not mapped, the sizing widget never
           //shows up on the screen.
           Widget rc = (Widget)(char*)evt.parameter2();
           Widget w = IMenuData::sizingWidget( rc );
           if (w)
           {
              XtManageChild( w );
           }

           // We delay deletion of the submenu until we return from
           // this function (see where imenuMotifCallback in
           // aix/imenu.cpp dispatches an IC_UM_DESTROY_MENU event).

           if (w)
           {
              // Initiate the removal of the sizing widget.
              IMenuData::removeSizingWidget( rc );
           }
         }

         return endReturn;
#endif //IC_MOTIF
      } /* endcase */
      break;

      case IC_UM_DESTROY_MENU:
      {
         if ( ! pSubmenuCol->isEmpty() )
         {  // Remove the submenu created for menuShowing and placed
            // in the collection of submenus we are managing.
#ifdef IC_PMWIN
            // This message was posted from clean-up processing in
            // the WM_MENUEND code of this handler, following the
            // call to the menuEnded virtual function.
#endif
#ifdef IC_MOTIF
            // This message was dispatched from imenuMotifCallback
            // in aix/imenu.cpp, following the dispatch of WM_MENUEND.
#endif
            void
             *submenuHandle = (void*) (char*) evt.parameter1();
            ( *pSubmenuCol )
             .removeAll( &IMenuDeleteElements, submenuHandle );
         }
         return true;
      }

      default:
        break;

   } /* endswitch */

   return false;
}

/*------------------------------------------------------------------------------
| IMenuHandler::menuEnded                                                      |
------------------------------------------------------------------------------*/
bool IMenuHandler::menuEnded ( IMenuEvent& menuEvent )
{
   IMODTRACE_DEVELOP("IMenuHandler::menuEnded");
#ifdef IC_PM
   IWindow* popUpWindow =
            IWindow::windowWithHandle(IWindowHandle(menuEvent.parameter2()));
   if (popUpWindow && (popUpWindow->id() != FID_MENU)) {
      removeSourceEmphasis(menuEvent);
   } /* endif */
#endif //IC_PM

#ifdef IC_MOTIF
   Widget rc = (Widget)menuEvent.parameter2().asUnsignedLong();
   IWindow* popUpWindow =
            IWindow::windowWithHandle(IWindowHandle(rc));
   if (popUpWindow)
   {
      removeSourceEmphasis(menuEvent);
   } /* endif */
#endif //IC_MOTIF

   return false;
}

/*------------------------------------------------------------------------------
| IMenuHandler::addSourceEmphasis                                              |
|  Call owner to show source emphasis                                          |
------------------------------------------------------------------------------*/
void IMenuHandler::addSourceEmphasis ( const IMenuEvent& menuEvent )
{
  IMODTRACE_DEVELOP("IMenuHandler::addSourceEmphasis");
#ifdef IC_WIN
  // There is no emphasis defined, since WIN menus are not HWNDs.
#endif
#ifdef IC_PM
  menuEvent.window()->showSourceEmphasis();
#endif
#ifdef IC_MOTIF
  menuEvent.controlWindow()->hideSourceEmphasis();
#endif
}

/*------------------------------------------------------------------------------
| IMenuHandler::removeSourceEmphasis                                           |
|  Call owner to hide source emphasis                                          |
------------------------------------------------------------------------------*/
void IMenuHandler::removeSourceEmphasis ( const IMenuEvent& menuEvent )
{
  IMODTRACE_DEVELOP("IMenuHandler::removeSourceEmphasis");
#ifdef IC_WIN
  // There is no emphasis defined, since WIN menus are not HWNDs.
#endif
#ifdef IC_PM
  menuEvent.window()->hideSourceEmphasis();
#endif
#ifdef IC_MOTIF
  menuEvent.controlWindow()->hideSourceEmphasis();
#endif
}

/*------------------------------------------------------------------------------
   Do nothing virtual function implemenations.
------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
| IMenuHandler::makePopUpMenu                                                  |
------------------------------------------------------------------------------*/
bool IMenuHandler::makePopUpMenu ( IMenuEvent& menuEvent )
{
  IMODTRACE_DEVELOP("IMenuHandler::makePopUpMenu");
  return false;
}

/*------------------------------------------------------------------------------
| IMenuHandler::menuShowing                                                    |
------------------------------------------------------------------------------*/
bool IMenuHandler::menuShowing ( IMenuEvent& menuEvent,
                                 ISubmenu&   submenuAboutToShow )
{
  IMODTRACE_DEVELOP("IMenuHandler::menuShowing");
  return false;
}

/*------------------------------------------------------------------------------
| IMenuHandler::menuSelected                                                   |
------------------------------------------------------------------------------*/
bool IMenuHandler::menuSelected ( IMenuEvent& menuEvent )
{
  IMODTRACE_DEVELOP("IMenuHandler::menuSelected");
  return false;
}

