// Revision: 99 1.3.3.1 source/ui/baseapp/imenuevt.cpp, menu, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: imenuevt.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in imenuevt.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C" {
   #define INCL_WINMESSAGEMGR
   #define INCL_WINWINDOWMGR
   #define INCL_WININPUT
   #define INCL_WINPOINTERS
   #include <iwindefs.h>
   #ifdef IC_MOTIF
     #include <Xm/RowColumn.h>
     #include <Xm/CascadeBG.h>
   #endif //IC_MOTIF
}


#include <iapp.hpp>
#include <icoordsy.hpp>
#include <imnitem.hpp>
#include <imenuevt.hpp>
#include <imenuprv.hpp>
#include <iplatfrm.hpp>
#include <ipoint.hpp>
#include <isubmenu.hpp>
#include <ithread.hpp>
#include <iwindow.hpp>

#ifdef IC_MOTIF
  #include <iwinpriv.hpp>
#endif //IC_MOTIF


// Segment definitions
#ifdef IC_PAGETUNE
  #define _IMENUEVT_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IMenuEvent::IMenuEvent                                                       |
------------------------------------------------------------------------------*/
IMenuEvent :: IMenuEvent(IEvent& evt)
  : IEvent(evt) { IMODTRACE_DEVELOP("IMenuEvent::IMenuEvent"); }

/*------------------------------------------------------------------------------
| IMenuEvent::~IMenuEvent                                                      |
------------------------------------------------------------------------------*/
IMenuEvent :: ~IMenuEvent( ) {IMODTRACE_DEVELOP("IMenuEvent::~IMenuEvent");}

/*------------------------------------------------------------------------------
| IMenuEvent::menuItemId                                                       |
------------------------------------------------------------------------------*/
unsigned long IMenuEvent::menuItemId() const
{
  IMODTRACE_DEVELOP("IMenuEvent::menuItemId");
  ITRACE_DEVELOP(IString("eventId is: ")+IString(eventId()));
#ifdef IC_PMWIN
  // Check for menu start or end and return id info
#ifdef IC_PM
  if (eventId() == WM_INITMENU || eventId() == WM_MENUEND)
  {
    return parameter1();
  }
#endif
#ifdef IC_WIN
  MENUITEMINFO miItem;
  long id = 0;
  if (eventId() == WM_INITMENUPOPUP)
  {
    if (IPlatform::isWin9x() || IPlatform::isNTNewShell())
    {
      miItem.cbSize = sizeof(MENUITEMINFO);
      miItem.fMask = MIIM_ID;

      if (GetMenuItemInfo( (HMENU)fPrevMenuParent, parameter2().number1(),
                           TRUE, &miItem ))
        id = miItem.wID;

      // If no id returned, item may be a popup menu, so check lookup table
      if (!id)
        id = IMenuPrivate::getItemIdFromLookUpTable(
             IMenuPrivate::locateFrame( window() ), IMenuHandle(parameter1()) );
    }
    else
    {
      // Since the handle is always a new submenu, get it from the lookup table
      id = IMenuPrivate::getItemIdFromLookUpTable(
             IMenuPrivate::locateFrame( window() ), IMenuHandle(parameter1()) );
    }
    return id;
  }
  else if (eventId() == WM_MENUEND)
  {
    return parameter1();
  }
#endif
  else
  {
    // Otherwise menu select action, id info in different location
    if (eventId() == WM_MENUSELECT)
    {
#ifdef IC_WIN
      // If pop-up in Windows, check platform for how to get id
      if ( parameter1().number2() & MF_POPUP )
      {
        // If new Windows 32, then use extended menu support
	if (IPlatform::isWin9x() || IPlatform::isNTNewShell())
        {
          miItem.cbSize = sizeof(MENUITEMINFO);
          miItem.fMask = MIIM_ID;
          if (GetMenuItemInfo( (HMENU)parameter2(), parameter1().number1(),
                           TRUE, &miItem ))
            id = miItem.wID;
        }
        // If pop-up in Win32s or old shell, check lookup table for id
        else
        {
          HMENU hPop = GetSubMenu( (HMENU)parameter2(),
                                   parameter1().number1() );
          if (hPop)
            id = IMenuPrivate::getItemIdFromLookUpTable(
                          IMenuPrivate::locateFrame( window() ), hPop );
        }
        return id;
      }
#endif
      return parameter1().number1();
    }
  } /* endif */
#endif //IC_PMWIN

#ifdef IC_MOTIF
   if ( (eventId() == WM_INITMENU) ||
        (eventId() == WM_MENUEND) ||
        (eventId() == WM_MENUUNMAP) ||
        (eventId() == WM_MENUSELECT) )
      return parameter1();
#endif //IC_MOTIF

  return 0;
}

/*------------------------------------------------------------------------------
| IMenuEvent::mousePosition                                                    |
|  Returns mouse point mapped to the menu control owner window.                |
------------------------------------------------------------------------------*/
IPoint IMenuEvent::mousePosition() const
{
  IMODTRACE_DEVELOP("IMenuEvent::mousePosition");
#ifdef IC_PMWIN
   POINTL ptl;
   IQUERYMSGPOS(IThread::current().anchorBlock(), &ptl);
   return IWindow::mapPoint(
              ICoordinateSystem::convertToApplication(
                 ptl,
                 IWindow::desktopWindow()->size() ),
              HWND_DESKTOP,
              window()->handle() );
#endif //IC_PMWIN

#ifdef IC_MOTIF
   // The Motif WM_CONTEXTMENU is generated by IMenuHandler and has saved in
   // it the mouse position relative to the window at time of button3down.
   if (eventId() == WM_CONTEXTMENU)
      {
      // d7871 - Using coordinates relative to handle() does not work    AJ:oh?????
      //         when the Motif origins of handle() and realSizeWidget()
      //         are different.  Use desktop coordinates instead.
      //         Change it to be similar to IMouseClickEvent::mousePosition().
      //
      // IWindow *pwin = IWindow::windowWithHandle( handle() );
      // // Extract coordinates, convert to PM coordinates for interface
      // if (pwin)
      //    {
      //    ptl = IPoint(parameter1().lowNumber(),
      //                 pwin->size().height() - parameter1().highNumber() );
      //    }
      //
      Position xPos = parameter1().lowNumber();
      Position yPos = parameter1().highNumber();
//AJTUAN      IPoint fixedPoint = IWindowPrivateData::mapXdt2PM( xPos, yPos, handle() );
      IPoint tempPoint(xPos, yPos);
      return IWindow::mapPoint(
              ICoordinateSystem::convertToApplication(
                 tempPoint,
                 IWindow::desktopWindow()->size() ),
              IWindow::desktopWindow()->handle(),
              window()->handle() );

//AJTUAN      return fixedPoint;
//      long xPosLong = parameter1().lowNumber(),
//           yPosLong = parameter1().highNumber();
//      return IPoint(xPosLong, yPosLong);
      }
   return IPoint(0,0);
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMenuEvent::menuItem                                                         |
------------------------------------------------------------------------------*/
IMenuItem IMenuEvent::menuItem() const
{
   IMODTRACE_DEVELOP("IMenuEvent::menuItem");
   // Only have the id of an actual MenuItem for WM_MENUSELECT
   // All other msgs pertain to an entire menu
   if (eventId() == WM_MENUSELECT ) {
      IMenuHandle submenuHandle( (IMenuHandle::Value)
                                   this->parameter2().asUnsignedLong() );
      ISubmenu submenu(submenuHandle);
      return submenu.menuItem(menuItemId());
   } /* endif */
   return IMenuItem(0);
}

