// Revision: 16 1.4.2.1 source/ui/baseapp/ikeyevdt.hpp, userinput, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IKEYEVDT_
  #define _IKEYEVDT_
/*******************************************************************************
* FILE NAME: ikeyevdt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IKeyboardEventData                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ievtdata.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IKeyboardEventData {
public:
/*------------------------------ Constructors --------------------------------*/
  IKeyboardEventData ( );
  IKeyboardEventData ( const IKeyboardEventData& data );
IKeyboardEventData
 &operator=          ( const IKeyboardEventData& data );
 ~IKeyboardEventData ( );

/*------------------------------ Testing Members -----------------------------*/
static const unsigned long
#ifdef IC_MOTIFPM
  IC_IMPORTU fgCharacterFlag,
  IC_IMPORTU fgScanCodeFlag,
  IC_IMPORTU fgVirtualFlag,
  IC_IMPORTU fgRepeatFlag,
  IC_IMPORTU fgUncombinedFlag,
  IC_IMPORTU fgShiftFlag,
  IC_IMPORTU fgCtrlFlag,
  IC_IMPORTU fgForCompositeFlag,
  IC_IMPORTU fgCompositeFlag,
  IC_IMPORTU fgInvalidCompositeFlag,
#endif
#ifdef IC_MOTIF
  IC_IMPORTU fgShiftMask,
  IC_IMPORTU fgCtrlMask,
#endif
  IC_IMPORTU fgUpTransitionFlag,
  IC_IMPORTU fgAltFlag;

#ifdef IC_WIN
/*------------------------------ OS/2 Emulation ------------------------------*/
static bool
  isSpecialCharacter ( unsigned long virtualKeyCode );
unsigned int
  fMappedCharCode;
bool
  fSpecialCharacter;
#endif

#ifdef IC_MOTIF
/*-------------------------- Mapping of Event Data ---------------------------*/
IEventParameter1
 *fParm1;
IEventParameter2
 *fParm2;
#endif
}; // IKeyboardEventData

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IKEYEVDT_ */
