// Revision: 78 1.4.1.3 source/ui/baseapp/ikey.cpp, userinput, ioc.v400, 001006  
/*******************************************************************************
* FILE NAME: ikey.cpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ikey.hpp.                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481424 )

extern "C" {
  #define INCL_WININPUT                 // For VK_xxx.
  #include <iwindefs.h>
  }

#ifdef IC_MOTIF
extern "C" {
  #ifdef IC_SUN
    #include <X11/Sunkeysym.h>
  #else
    #include <X11/aix_keysym.h>
  #endif
  #include <X11/keysym.h>
  }
#endif

#include <ikey.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IKEY_CPP_
  #include <ipagetun.h>
#endif

const IKey::KeyModifier
  IKey::ctrl       ( 0, 1 ),
  IKey::alt        ( 0, 2 ),
  IKey::shift      ( 0, 4 ),
  IKey::noModifier ( 0, 8 );

#ifdef IC_PMWIN
const IKey::VirtualKey
  IKey::kEsc        ( VK_ESC ),
  IKey::kTab        ( VK_TAB ),
#ifdef IC_PM
  IKey::kBackTab    ( VK_BACKTAB ),
#endif
  IKey::kSpace      ( VK_SPACE ),
  IKey::kBackSpace  ( VK_BACKSPACE ),
  IKey::kEnter      ( VK_ENTER ),
  IKey::kNewLine    ( VK_NEWLINE ),
  IKey::kAlt        ( VK_ALT ),
  IKey::kCtrl       ( VK_CTRL ),
  IKey::kShift      ( VK_SHIFT ),
#ifdef IC_PM
  IKey::kAltGraf    ( VK_ALTGRAF ),
#endif
  IKey::kInsert     ( VK_INSERT ),
  IKey::kDelete     ( VK_DELETE ),
  IKey::kHome       ( VK_HOME ),
  IKey::kEnd        ( VK_END ),
  IKey::kPageUp     ( VK_PAGEUP ),
  IKey::kPageDown   ( VK_PAGEDOWN ),
  IKey::kLeft       ( VK_LEFT ),
  IKey::kRight      ( VK_RIGHT ),
  IKey::kUp         ( VK_UP ),
  IKey::kDown       ( VK_DOWN ),
  IKey::kCapsLock   ( VK_CAPSLOCK ),
  IKey::kNumLock    ( VK_NUMLOCK ),
  IKey::kScrollLock ( VK_SCRLLOCK ),
  IKey::kPause      ( VK_PAUSE ),
  IKey::kBreak      ( VK_BREAK ),
#ifdef IC_PM
  IKey::kSysRq      ( VK_SYSRQ ),
#endif
  IKey::kF1         ( VK_F1 ),
  IKey::kF2         ( VK_F2 ),
  IKey::kF3         ( VK_F3 ),
  IKey::kF4         ( VK_F4 ),
  IKey::kF5         ( VK_F5 ),
  IKey::kF6         ( VK_F6 ),
  IKey::kF7         ( VK_F7 ),
  IKey::kF8         ( VK_F8 ),
  IKey::kF9         ( VK_F9 ),
  IKey::kF10        ( VK_F10 ),
  IKey::kF11        ( VK_F11 ),
  IKey::kF12        ( VK_F12 ),
  IKey::kF13        ( VK_F13 ),
  IKey::kF14        ( VK_F14 ),
  IKey::kF15        ( VK_F15 ),
  IKey::kF16        ( VK_F16 ),
  IKey::kF17        ( VK_F17 ),
  IKey::kF18        ( VK_F18 ),
  IKey::kF19        ( VK_F19 ),
  IKey::kF20        ( VK_F20 ),
  IKey::kF21        ( VK_F21 ),
  IKey::kF22        ( VK_F22 ),
  IKey::kF23        ( VK_F23 ),
  IKey::kF24        ( VK_F24 ),
  IKey::kNoKey      ( 0 );
#endif // IC_PMWIN

#ifdef IC_MOTIF
const IKey::VirtualKey
  IKey::kEsc        ( XK_Escape ),          // Also XK_Cancel?
  IKey::kTab        ( XK_Tab ),             // Also XK_KP_Tab.
  IKey::kSpace      ( XK_space ),           // Also XK_KP_Space.
  IKey::kBackSpace  ( XK_BackSpace ),
  IKey::kEnter      ( XK_KP_Enter ),        // Also XK_Linefeed?
  IKey::kNewLine    ( XK_Return ),
  IKey::kAlt        ( XK_Alt_L ),           // Also XK_Alt_R.
  IKey::kCtrl       ( XK_Control_L ),       // Also XK_Control_R.
  IKey::kShift      ( XK_Shift_L ),         // Also XK_Shift_R.
  IKey::kInsert     ( XK_Insert ),
  IKey::kDelete     ( XK_Delete ),
  IKey::kHome       ( XK_Home ),
  IKey::kEnd        ( XK_End ),
  IKey::kPageUp     ( XK_Prior ),
  IKey::kPageDown   ( XK_Next ),
  IKey::kLeft       ( XK_Left ),
  IKey::kRight      ( XK_Right ),
  IKey::kUp         ( XK_Up ),
  IKey::kDown       ( XK_Down ),
  IKey::kCapsLock   ( XK_Caps_Lock ),       // Also XK_Shift_Lock?
  IKey::kNumLock    ( XK_Num_Lock ),
  IKey::kScrollLock ( XK_Scroll_Lock ),
  IKey::kPause      ( XK_Pause ),
  IKey::kBreak      ( XK_Break ),
  IKey::kF1         ( XK_F1 ),              // Also XK_KP_F1.  Also XK_Help?
  IKey::kF2         ( XK_F2 ),              // Also XK_KP_F2.
  IKey::kF3         ( XK_F3 ),              // Also XK_KP_F3.
  IKey::kF4         ( XK_F4 ),              // Also XK_KP_F4.
  IKey::kF5         ( XK_F5 ),
  IKey::kF6         ( XK_F6 ),
  IKey::kF7         ( XK_F7 ),
  IKey::kF8         ( XK_F8 ),
  IKey::kF9         ( XK_F9 ),
  IKey::kF10        ( XK_F10 ),
  IKey::kF11        ( XK_F11 ),
  IKey::kF12        ( XK_F12 ),
  IKey::kF13        ( XK_F13 ),
  IKey::kF14        ( XK_F14 ),
  IKey::kF15        ( XK_F15 ),
  IKey::kF16        ( XK_F16 ),
  IKey::kF17        ( XK_F17 ),
  IKey::kF18        ( XK_F18 ),
  IKey::kF19        ( XK_F19 ),
  IKey::kF20        ( XK_F20 ),
  IKey::kF21        ( XK_F21 ),
  IKey::kF22        ( XK_F22 ),
  IKey::kF23        ( XK_F23 ),
  IKey::kF24        ( XK_F24 ),
  IKey::kNoKey      ( 0 );

unsigned long
  IKey::fgAltModifier( Mod1Mask );
bool
  IKey::fgAltModifierIsSet( false );

/*------------------------------------------------------------------------------
| IKey::altModifier                                                            |
|                                                                              |
| Returns the key modifier mapped to the Alt key.                              |
------------------------------------------------------------------------------*/
unsigned long IKey::altModifier ( )
{
  return fgAltModifier;
}

/*------------------------------------------------------------------------------
| IKey::setAltModifier                                                         |
|                                                                              |
| Sets the key modifier mapped to the Alt key.                                 |
------------------------------------------------------------------------------*/
void IKey::setAltModifier ( unsigned long mask )
{
  // Note: Calling this function causes
  //       ICurrentThreadData::getModifierMappings to no longer update
  //       fgAltModifier as the key modifier mapped to the Alt key
  //       changes (such as via use of the xmodmap utility).
  fgAltModifier = mask;
  fgAltModifierIsSet = true;
}
#endif // IC_MOTIF
