// Revision: 74 1.9.2.1 source/ui/baseapp/ihelptbl.cpp, help, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ihelptbl.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ihelptbl.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481624 )

extern "C" {
  #include "iwindefs.h"
}
#include <ihelptbl.hpp>
#include <iapp.hpp>
#include <ireslib.hpp>
#include <iexcept.hpp>
#include <istring.hpp>
#include <itrace.hpp>
#ifdef IC_MOTIF
  #include <iresstat.hpp>
#endif //IC_MOTIF

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IHELPTBL_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
#pragma enum(4)
#pragma pack(push,4)

class IHelpTableParser  {
/*******************************************************************************
| The IHelpTableParser class is responsible for reading a resource string      |
| representation of help table information and loading it into the specified   |
| IHelpTable instance.                                                         |
*******************************************************************************/
public:
  IHelpTableParser( IHelpTable * help );
  ~IHelpTableParser() {};

  // resString points to string representing entire accelerator table that was
  // obtained from the Resource DataBase.
void
  parseResourceString( const char* resString );

protected:
// functions used in the parser
const char*
  nextWord();
unsigned long
  nextWordAsID();
virtual void
  parseCurrentWord();

// instance data
  IHelpTable*   helptable;      // Pointer to helptable being built.
  const char*   curWord;        // Pointer to current word in resString.
  unsigned long wordLen;        // Length in bytes of current word in resString.
};

class IHelpSubTableParser : public IHelpTableParser {
/*******************************************************************************
| The IHelpSubTableParser class is responsible for reading a resource string   |
| representation of help table information and loading it into the specified   |
| IHelpTable instance.                                                         |
*******************************************************************************/
public:
  IHelpSubTableParser( IHelpTable * help,
                       unsigned long subid ) ;
  ~IHelpSubTableParser() {};

protected:
// This method knows how to parse a word of a help sub table.
virtual void
  parseCurrentWord();

// instance data
  unsigned long subTableID;      // current subtable id for helpsubtable
};

#pragma pack(pop)
#pragma enum(pop)

#endif //IC_MOTIF

// used in parsing help table resources
static const char    helpBegin[]     = "BEGIN";
static const char    helpItem[]      = "HELPITEM";
static const char    helpTable[]     = "HELPTABLE";
static const char    helpSubTable[]  = "HELPSUBTABLE";
static const char    helpSubItem[]   = "HELPSUBITEM";
static const char    helpEnd[]       = "END";
static const char    helpDelimiter[] = " ";


/*------------------------------------------------------------------------------
| IHelpSubTable::IHelpSubTable                                                 |
------------------------------------------------------------------------------*/
IHelpSubTable::IHelpSubTable  ( unsigned short id ) :
                                subTableID( id ), subItemSize(2),
                                subItemList(10)
{

}

/*------------------------------------------------------------------------------
| IHelpSubTable::~IHelpSubTable                                                |
------------------------------------------------------------------------------*/
IHelpSubTable::~IHelpSubTable()
{

}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IHelpSubTable::processHelpSubtableData( rthelpsubtable * )                   |
------------------------------------------------------------------------------*/
void IHelpSubTable::processHelpSubtableData( rthelpsubtable * pRtHelpsubtable )
{
  helpsubtabledata *pHelpSubtableData =
     (helpsubtabledata*) &(pRtHelpsubtable->theHelpSubtableData);

  unsigned short subitemstructsize = sizeof(helpsubtabledata) +
     (pRtHelpsubtable->subitemsize - 2)*sizeof(short);

  while (  (short) pHelpSubtableData->childId != 0 )
  {
    IHelpSubItem subitem( pHelpSubtableData->childId,
                          pHelpSubtableData->helpPanelId );
    addItem( subitem );

    pHelpSubtableData =
       (helpsubtabledata*) ( (char*) pHelpSubtableData + subitemstructsize);
   }

}

/*------------------------------------------------------------------------------
| IHelpSubTable::addItem                                                       |
------------------------------------------------------------------------------*/
IHelpSubTable& IHelpSubTable::addItem( const IHelpSubItem& subitem )
{
  ITRACE_DEVELOP(subitem.asString());
  try
  {
    int rc = subItemList.add( subitem );
    ITRACE_DEVELOP(" add rc = " + IString(rc));
  }
  catch ( IException &excp )
  {
    ITRACE_DEVELOP( " add throw exception " +
                    IString(excp.name()) + IString(excp.text()) );
  }

  return *this;
}
#endif

/*------------------------------------------------------------------------------
| IHelpTableItem::IHelpTableItem                                               |
------------------------------------------------------------------------------*/
IHelpTableItem::IHelpTableItem ( unsigned short window,
                                 IHelpSubTableRef  subtable,
                                 unsigned short    helpID) :
                                 windowID( window ),
                                 subTableRef(subtable),
                                 extendedHelpID( helpID )
{

}

/*------------------------------------------------------------------------------
| IHelpTableItem::IHelpTableItem                                               |
------------------------------------------------------------------------------*/
IHelpTableItem::IHelpTableItem ( const IHelpTableItem& helpTableItem) :
                                 windowID( helpTableItem.windowID ),
                                 subTableRef(helpTableItem.subTableRef),
                                 extendedHelpID( helpTableItem.extendedHelpID )
{

}

/*------------------------------------------------------------------------------
| IHelpTableItem::~IHelpTableItem                                               |
------------------------------------------------------------------------------*/
IHelpTableItem::~IHelpTableItem ( )
{

}

/*------------------------------------------------------------------------------
| IHelpTableItem::subTable                                                     |
------------------------------------------------------------------------------*/
IHelpSubTable& IHelpTableItem::subTable() const
{
  return *subTableRef;
}


/*------------------------------------------------------------------------------
| IHelpTable::IHelpTable                                                       |
------------------------------------------------------------------------------*/
IHelpTable::IHelpTable ( IResourceId tableId ) :
   tableID (tableId.id() ),
   itemList( 10 )
{
#ifdef IC_WIN
  IFUNCTRACE_DEVELOP();
  HANDLE hHlpTblResource = 0;
   // load resources.  Exception thrown if not found
  this->hInstance = tableId.resourceLibrary().handle();

  HRSRC tempRsrc = FindResource( this->hInstance,
                                 MAKEINTRESOURCE(tableId.id()),
                                 IHELPTABLERESOURCE) ;

  if (tempRsrc)
  {
    hHlpTblResource = LoadResource( this->hInstance, tempRsrc );
  }

  if (!hHlpTblResource)
  {
     ITHROWGUIERROR(IString("IHelpTable LoadResource(")+
                            "IResourceId:"+IString(tableId.id())+")");
  }
  ITRACE_DEVELOP("hHlpTblResource = " + IString((unsigned long)hHlpTblResource) );

  #pragma pack(push,4)
  struct helpTableResBuf
  {
    unsigned short usTopic;
    unsigned short usHelpSubTable;
    unsigned short usExtPanel;
  } *pHTResBuf;
  #pragma pack(pop)

  pHTResBuf = (struct helpTableResBuf *) LockResource( hHlpTblResource );

  int idxHT = 0;
  while ( (pHTResBuf[idxHT].usTopic != 0) &&
          (pHTResBuf[idxHT].usHelpSubTable != 0) &&
          (pHTResBuf[idxHT].usExtPanel != 0) )
  {

    addItem(pHTResBuf[idxHT].usTopic,
            pHTResBuf[idxHT].usHelpSubTable,
            pHTResBuf[idxHT].usExtPanel);
    idxHT++;
  }
  UnlockResource( hHlpTblResource );
#endif //IC_WIN

#ifdef IC_MOTIF
  aixResource = new IAixResourceImp( tableId.resourceLibrary() );
  // load resources.  Exception thrown if not found
  rthelptable* helpTableData;
  helpTableData = (rthelptable*)
  aixResource->resourceByteAddress( RT_HELPTABLE, tableId.id() );
  if (helpTableData)
  {
    processHelpTableData( helpTableData );
  }
  else
  {
    char* resString =
      IResLibStaticPtr::getAppRes(tableID, "ICLHELPTABLE_");
    // construct the help table data from the resource string
    IHelpTableParser parser( this );
    parser.parseResourceString ( resString );
  }
#endif //IC_MOTIF

  // this trace dumps the entire help table as read in
  ITRACE_DEVELOP( this->asString() );
}

/*------------------------------------------------------------------------------
| IHelpTable::~IHelpTable                                                      |
------------------------------------------------------------------------------*/
IHelpTable::~IHelpTable          ( )
{

#ifdef IC_MOTIF
  if ( aixResource )
    delete aixResource;
#endif
}

/*------------------------------------------------------------------------------
| IHelpTable::extendedHelpForWindowID                                          |
------------------------------------------------------------------------------*/
unsigned short IHelpTable::extendedHelpForWindowID( unsigned short  frameID)
{
  IFUNCTRACE_DEVELOP();
   // default result is the same as the controlID
   unsigned short result = IHelpTable::noHelpFound;

   // first, locate the HELPITEM  in the helptable with the frameID
   IHelpTableItemList::Cursor cursor( itemList );
   bool  found = false;
   for (cursor.setToFirst(); (!found && cursor.isValid()); cursor.setToNext() )
   {
     // first, locate the HELPITEM  in the helptable with the frameID
     found = ( frameID == cursor.element().windowID );
     if (found)
     {
       result = cursor.element().extendedHelpID;
       break;
     }
   }

   /*****
   IHelpTableItemList::Cursor cursor( itemList );
   if ( itemList.locateElementWithKey( frameID, cursor ) )
      {
      // the current answer is the extended help panel for the frame...
      result = cursor.element().extendedHelpID;
      }
   ****/

   return result;
}

/*------------------------------------------------------------------------------
| IHelpTable::helpForWindowID                                                  |
------------------------------------------------------------------------------*/
unsigned short IHelpTable::helpForWindowID( unsigned short controlID,
                                            unsigned short frameID)
{
  IFUNCTRACE_DEVELOP();
   // default result is the same as the controlID
   unsigned short result = IHelpTable::noHelpFound;

  ITRACE_DEVELOP("Help requested on controlID " + IString(controlID) +
                 " frameID " + IString(frameID) );

   IHelpTableItemList::Cursor cursor( itemList );
   bool  found = false;
   for (cursor.setToFirst(); (!found && cursor.isValid()); cursor.setToNext() )
   {
     ITRACE_DEVELOP(" checking .... " + cursor.element().asString() );

     // first, locate the HELPITEM  in the helptable with the frameID
     found = ( frameID == cursor.element().windowID );
     if (found)
     {
       IHelpSubTable &subtable = cursor.element().subTable();
       IHelpSubItemList::Cursor subCursor( subtable.subItemList );
       // now, search the HELPSUBTABLE for this HELPITEM to see
       // if we have an exact match
       for (subCursor.setToFirst(); subCursor.isValid(); subCursor.setToNext() )
       {
         if ( controlID == subCursor.element().controlID )
         {
           result = subCursor.element().helpID;
           break;
         }
       }
       break;
     }
   }


   /***********
   // first, locate the HELPITEM  in the helptable with the frameID
   IHelpTableItemList::Cursor cursor( itemList );
   if ( itemList.locateElementWithKey( frameID, cursor ) )
      {

      // now, search the HELPSUBTABLE for this HELPITEM to see
      // if we have an exact match
      IHelpSubTable &subtable = cursor.element().subTable();
      IHelpSubItemList::Cursor subCursor( subtable.subItemList );
      if (subtable.subItemList.locateElementWithKey( controlID, subCursor) )
         {
         // got exact hit...
         result = subCursor.element().helpID;
         }
      }
    *****/
   return result;
}


#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IHelpTable::subtable                                                         |
------------------------------------------------------------------------------*/
IHelpSubTable * IHelpTable::subtable ( unsigned short subtableid )
{
  IFUNCTRACE_DEVELOP();

  // search itemList to see if subtable has already been referenced
  IHelpSubTable *subTable=0;
  IHelpTableItemList::Cursor stcursor( itemList );
  bool  stfound = false;
  for (stcursor.setToFirst(); (!stfound && stcursor.isValid()); stcursor.setToNext() )
  {
    stfound = ( subtableid == stcursor.element().subTable().subTableID );
    if (stfound)
      subTable=&(stcursor.element().subTable());
  }

  return subTable;
}

/*------------------------------------------------------------------------------
| IHelpTable::processHelpTableData                                             |
------------------------------------------------------------------------------*/
void IHelpTable::processHelpTableData ( rthelptable    * helpTableData )
{
  rthelpsubtable * helpSubtableData;
  IHelpSubTable  * aSubtable;
 // cout << endl;

  rthelptable    * pHelpItem = helpTableData;
  while (  (short) pHelpItem->appwindowId != 0 )
  {
//    cout << "  Application Window Id:   " << IString(pHelpItem->appwindowId) <<
//            "   (" << pHelpItem->appwindowId << ")" << endl;
//    cout << "  HelpSubtable Id:   " << IString(pHelpItem->helpsubtableId) <<
//            "   (" << pHelpItem->helpsubtableId << ")" << endl;
//    cout << "  Third Item:   " << IString(pHelpItem->thirdItem) <<
//            "   (" << pHelpItem->thirdItem << ")" << endl;
//    cout << "  Extended Help Panel Id:   " << IString(pHelpItem->exthelppanelId) <<
//            "   (" << pHelpItem->exthelppanelId << ")" << endl;
    aSubtable = subtable( pHelpItem->helpsubtableId );
    if (aSubtable)
    {
      aSubtable->addRef();
    }
    else
    {
      aSubtable = new IHelpSubTable( pHelpItem->helpsubtableId );
#if 1
      helpSubtableData = (rthelpsubtable *)
         aixResource->resourceByteAddress( RT_HELPSUBTABLE,
                                           pHelpItem->helpsubtableId );
#endif
      aSubtable->processHelpSubtableData( helpSubtableData );
    }

    // add the helpitem to the helptable
    IHelpTableItem helpItem( pHelpItem->appwindowId,
                             aSubtable,
                             pHelpItem->exthelppanelId );
    addItem( helpItem );

    pHelpItem = (rthelptable*) ( (char*) pHelpItem + sizeof(rthelptable) );
  }

}

/*------------------------------------------------------------------------------
| IHelpTable::addItem                                                          |
------------------------------------------------------------------------------*/
IHelpTable& IHelpTable::addItem( const IHelpTableItem& helpItem )
{
  IFUNCTRACE_DEVELOP();

  ITRACE_DEVELOP(helpItem.asString());
  try
  {
    int rc = itemList.add( helpItem );
    ITRACE_DEVELOP(" add rc = " + IString(rc));
  }
  catch ( IException &excp )
  {
    ITRACE_DEVELOP( " add throw exception " +
                    IString(excp.name()) + IString(excp.text()) );
  }
  return *this;

}
#endif

/*------------------------------------------------------------------------------
| IHelpTable::addItem                                                          |
------------------------------------------------------------------------------*/
IHelpTable & IHelpTable::addItem   ( unsigned short id,
                                     unsigned short subtableid,
                                     unsigned short helpid)
{
  IFUNCTRACE_DEVELOP();

  // search itemList to see if subtable has already been referenced
  IHelpSubTable *subTable=0;
  IHelpTableItemList::Cursor stcursor( itemList );
  bool  stfound = false;
  for (stcursor.setToFirst(); (!stfound && stcursor.isValid()); stcursor.setToNext() )
  {
    stfound = ( subtableid == stcursor.element().subTable().subTableID );
    if (stfound)
    {
      subTable=&(stcursor.element().subTable());
      subTable->addRef();
    }
  }

  // if this is a new subtable then create new subtable object, and later load it.
  if (!stfound)
    subTable = new IHelpSubTable(subtableid);

  // add the helpitem to the helptable
  IHelpTableItem helpItem( id, subTable, helpid );

  ITRACE_DEVELOP(helpItem.asString());
  try
  {
    int rc = itemList.add( helpItem );
    ITRACE_DEVELOP(" add rc = " + IString(rc));
  }
  catch ( IException &excp )
  {
    ITRACE_DEVELOP( " add throw exception " +
                    IString(excp.name()) + IString(excp.text()) );
  }

  // if the subtable was loaded for a prior item, then we're done.
  if (stfound)
    return *this;

#ifdef IC_WIN
  HANDLE hHlpSubTblResource = 0;
  // construct the rest of the subtable.  Load the resources
  // needed ... exception thrown if not found

  HRSRC tempRsrc = FindResource( this->hInstance,
                                 MAKEINTRESOURCE(subtableid),
                                 IHELPSUBTABLERESOURCE) ;

  if (tempRsrc)
  {
    hHlpSubTblResource = LoadResource( this->hInstance, tempRsrc );
  }

  if (!hHlpSubTblResource)
  {
     ITHROWGUIERROR(IString("IHelpTable LoadResource(")+
                            "IResourceId:"+IString(subtableid)+")");
  }
  ITRACE_DEVELOP("hHlpSubTblResource = " +
                IString((unsigned long)hHlpSubTblResource) );

  #pragma pack(push,4)
  struct helpSubTableResBuf
  {
    unsigned short usControlID;
    unsigned short usHelpID;
  } *pHSTResBuf;
  #pragma pack(pop)

  pHSTResBuf =
              (struct helpSubTableResBuf *) LockResource( hHlpSubTblResource );
  int idxHST = 0;
  while ( (pHSTResBuf[idxHST].usControlID != 0) &&
          (pHSTResBuf[idxHST].usHelpID != 0) )
  {

    addSubItem( subtableid,
                pHSTResBuf[idxHST].usControlID,
                pHSTResBuf[idxHST].usHelpID);
    idxHST++;
  }
  UnlockResource( hHlpSubTblResource );
#endif //IC_WIN

#ifdef IC_MOTIF
  // construct the rest of the subtable.  Load the resources
  // needed ... exception thrown if not found
  char* resString = IResLibStaticPtr::getAppRes(subtableid,
                                                "ICLHELPSUBTABLE_");
  IHelpSubTableParser parser( this, subtableid );
  parser.parseResourceString ( resString );
#endif //IC_MOTIF

  return *this;
}

/*------------------------------------------------------------------------------
| IHelpTable::addSubItem                                                       |
------------------------------------------------------------------------------*/
IHelpTable& IHelpTable::addSubItem( unsigned short subtableid,
                                    unsigned short controlid,
                                    unsigned short helpid)
{
  IFUNCTRACE_DEVELOP();
   IHelpTableItemList::Cursor cursor( itemList );
   bool  found = false;
   for (cursor.setToFirst(); (!found && cursor.isValid()); cursor.setToNext() )
   {
     found = ( subtableid == cursor.element().subTable().subTableID );
     if (found)
     {
       IHelpSubItem subitem( controlid, helpid );
       ITRACE_DEVELOP(subitem.asString());
       try
       {
         int rc = cursor.element().subTable().subItemList.add( subitem );
         ITRACE_DEVELOP(" add rc = " + IString(rc));
       }
       catch ( IException &excp )
       {
         ITRACE_DEVELOP( " add throw exception " +
                         IString(excp.name()) + IString(excp.text()) );
       }
     }
   }

   return *this;
}


/*------------------------------------------------------------------------------
| IHelpSubItem::asString                                                       |
------------------------------------------------------------------------------*/
IString  IHelpSubItem::asString() const
{
  IFUNCTRACE_DEVELOP();
   return IString(helpSubItem) + helpDelimiter +
          IString(controlID) + helpDelimiter + IString(helpID);
}

/*------------------------------------------------------------------------------
| IHelpSubTable::asString                                                      |
------------------------------------------------------------------------------*/
IString  IHelpSubTable::asString() const
{
  IFUNCTRACE_DEVELOP();
   IString result = IString(helpSubTable) + helpDelimiter + IString(subTableID) + IString('\n');
   result = result + helpBegin + IString('\n');
   IHelpSubItemList::Cursor cursor( subItemList );
   for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
      {
      result = result + cursor.element().asString() + IString('\n');
      }
   result = result + helpEnd;
   return result;
}

/*------------------------------------------------------------------------------
| IHelpTableItem::asString                                                     |
------------------------------------------------------------------------------*/
IString  IHelpTableItem::asString() const
{
  IFUNCTRACE_DEVELOP();
   return IString(helpItem) + helpDelimiter + IString(windowID) + helpDelimiter +
          IString( subTable().subTableID ) + helpDelimiter +
          IString( extendedHelpID );
}

/*------------------------------------------------------------------------------
| IHelpTable::asString                                                         |
------------------------------------------------------------------------------*/
IString  IHelpTable::asString() const
{
  IFUNCTRACE_DEVELOP();
   IString result = IString(helpTable) + helpDelimiter + IString(tableID) + IString('\n');
   result = result + helpBegin + IString('\n');
   IHelpTableItemList::Cursor cursor( itemList );
   for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
      {
      result = result + cursor.element().asString() + IString('\n');
      }
   result = result + helpEnd  + IString('\n');
   // extract the referenced subtables
   for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
      {
      result = result + cursor.element().subTable().asString() + IString('\n');
      }
   return result;
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IHelpTableParser::IHelpTableParser                                           |
------------------------------------------------------------------------------*/
IHelpTableParser::IHelpTableParser( IHelpTable * help )
: helptable( help ),
  curWord( 0 ),
  wordLen( 0 )
{
}

/*------------------------------------------------------------------------------
| IHelpTableParser::parseResourceString                                        |
| Get next blank-delimited token from resString and call parseIt for the       |
| token.  This routine causes an entire resource string to be parsed for       |
| help table information.                                                      |
------------------------------------------------------------------------------*/
void IHelpTableParser :: parseResourceString( const char* resString )
{
   curWord = resString;
   wordLen = 0;
   while ( *nextWord() )
    {
     parseCurrentWord();
    }
}

/*------------------------------------------------------------------------------
| IHelpTableParser::nextWord                                                   |
| Advances curWord to the next blank delimited word, or the zero string        |
| terminator.  Adjusts wordLen to the length of the word.  Returns the new     |
| curWord.                                                                     |
------------------------------------------------------------------------------*/
const char* IHelpTableParser :: nextWord()
{
 curWord += wordLen; // Skip over current word.
 wordLen = 0; // Until we know better.
 while ( *curWord && isspace( *curWord ) )
   ++curWord; // Skip over spaces to next word.
 const char* curPos = curWord;
 while ( *curPos && !isspace ( *curPos ) )
  {
   ++wordLen;  // Count how long the word is.
   ++curPos;
  }
 return curWord;
}

/*------------------------------------------------------------------------------
| IHelpTableParser::nextWordAsID                                               |
| Advances to next word, validates it as a numeric value and returns it.       |
------------------------------------------------------------------------------*/
unsigned long IHelpTableParser::nextWordAsID( )
{
  nextWord();
  IString valu( (void*)curWord, wordLen );
  if ( !valu.isDigits() )
     ITHROWGUIERROR("Expected numeric id and found: " + valu);
  return valu.asUnsigned();
}

/*------------------------------------------------------------------------------
| IHelpTableParser::parseCurrentWord                                           |
| Parse the current word and create appropriate help table data                |
------------------------------------------------------------------------------*/
void IHelpTableParser :: parseCurrentWord()
{
 if ( !strncmp( (char*)helpItem, (char*)curWord, wordLen ) )
  {
   unsigned long windowid = nextWordAsID();
   unsigned long subtableid = nextWordAsID();
   unsigned long helpid = nextWordAsID();
   helptable->addItem( (unsigned short)windowid,
                       (unsigned short)subtableid,
                       (unsigned short)helpid );
  }
}

/*------------------------------------------------------------------------------
| IHelpSubTableParser::IHelpSubTableParser                                     |
------------------------------------------------------------------------------*/
IHelpSubTableParser::IHelpSubTableParser( IHelpTable * help,
                                          unsigned long subid )
: IHelpTableParser( help ),
  subTableID(subid)
{
}

/*------------------------------------------------------------------------------
| IHelpSubTableParser::parseCurrentWord                                        |
| Parse the current word and create appropriate help table data                |
------------------------------------------------------------------------------*/
void IHelpSubTableParser :: parseCurrentWord()
{
 if ( !strncmp( (char*)helpSubItem, (char*)curWord, wordLen ) )
  {
   unsigned long windowid = nextWordAsID();
   unsigned long helpid = nextWordAsID();
   helptable->addSubItem( (unsigned short)subTableID,
                          (unsigned short)windowid,
                          (unsigned short)helpid );
  }
}
#endif //IC_MOTIF
