// Revision: 73 1.5.2.1 source/ui/baseapp/ihelpsta.hpp, help, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IHELPSTA_
#define _IHELPSTA_
/*******************************************************************************
* FILE NAME: ihelpsta.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration(s) of the IHelpStatics class, which     *
*   is used to dynamically load helpmgr.dll.                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>

#ifdef IC_MOTIFWIN
extern "C"
  {
    #include <ipfx.h>
  }
#endif

#ifdef IC_MOTIF
  #if !defined(__stdcall)
     #define __stdcall
  #endif
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifndef IC_MOTIF
class IDynamicLinkLibrary;
#else
class IResLibPrivateData;
#endif

class IFrameWindow;
class IWindow;

#ifdef IC_PM
typedef unsigned long
     (_System  ICreateInstance)( IAnchorBlockHandle, void * );
typedef bool
     (_System  IAssocInstance)( IWindowHandle, IWindowHandle );
typedef unsigned long
     (_System  IQueryInstance)( IWindowHandle );
typedef bool
     (_System  IDestroyInstance)( IWindowHandle );
typedef bool
     (_System  ILoadHelpTable)( IWindowHandle, unsigned long, IModuleHandle );
#endif

#ifdef IC_MOTIFWIN
typedef long
     (__stdcall ICreateInstance)( IWindowHandle::Value,
                                  PHELPINIT,
                                  IWindowHandle::Value* );
typedef long
     (__stdcall IAssocInstance)( IWindowHandle::Value, IWindowHandle::Value );
typedef long
     (__stdcall IQueryInstance)( IWindowHandle::Value, IWindowHandle::Value* );
typedef long
     (__stdcall IDestroyInstance)( IWindowHandle::Value );
typedef long
     (__stdcall ICallIPF)(IWindowHandle::Value, unsigned short , void *, void * );
#endif //IC_MOTIFWIN

#ifdef IC_WIN
typedef long
     (__stdcall ILoadHelpTable)( IWindowHandle::Value,
                                 unsigned long,
                                 IModuleHandle::Value );
#endif //IC_WIN


#pragma enum(4)
#pragma pack(push,4)

class IHelpStatics
{
public:
 ~IHelpStatics          ( );

#ifdef IC_PMWIN
static IDynamicLinkLibrary
 &helpDLL               ( );
#endif //IC_PMWIN

static IWindowHandle
#ifdef IC_PM
  createHelpInstance    ( const IAnchorBlockHandle& hab,
                          void* helpstruct ),
#endif
#ifdef IC_MOTIFWIN
  createHelpInstance    ( const IWindowHandle& windowHandle,
                          void* helpstruct ),
#endif
  queryHelpInstance     ( const IWindowHandle& windowHandle );

static bool
  associateHelpInstance ( const IWindowHandle& helpHandle,
                          const IWindowHandle& activeWindowHandle ),
  destroyHelpInstance   ( const IWindowHandle& helpHandle ),
  loadHelpTable         ( const IWindowHandle& helpHandle,
                          unsigned long id,
                          const IModuleHandle& hmod );
#ifdef IC_MOTIFWIN
static long
  callIPF               ( const IWindowHandle& helpHandle,
                          unsigned short usMsgType,
                          void* param1, void* param2);
static void
  addHooks              ( );
#endif

static ICreateInstance
 *entryCreate;
static IAssocInstance
 *entryAssoc;
static IQueryInstance
 *entryQuery;
static IDestroyInstance
 *entryDestroy;

#ifdef IC_PMWIN
static ILoadHelpTable
 *entryLoadHelpTable;
static IDynamicLinkLibrary
 *helpDynLinkLib;
#endif //IC_PMWIN

#ifdef IC_WIN
static ICallIPF
 *entryCallIPF;

static HHOOK
  msgFilterHook,
  keyboardHook;
static unsigned short
  activeMenuItem;
static HWND
  activeMenu;
#endif

};

#ifdef IC_MOTIFWIN
IFrameWindow* ihelpwindowSearchChain( IWindowHandle::Value contextHwnd,
                                      IWindowHandle::Value lastActiveFrame );
#endif

#ifdef IC_MOTIF
//class IAssociatedWindowHandle  {
///*******************************************************************************
//| The IAssociatedWindowHandle class represents an association between          |
//| a frame window and a help instance.  An instance of this class is created    |
//| and stored in an ordered collection when help is associated with a           |
//| frame.                                                                       |
//*******************************************************************************/
//public:
//  IAssociatedWindowHandle (IWindowHandle help, IWindowHandle frame) :
//      helpHandle (help), windowHandle(frame)
//      {};
//  IAssociatedWindowHandle (const IAssociatedWindowHandle & another ) :
//      helpHandle(another.helpHandle), windowHandle(another.windowHandle)
//      {};
//  ~IAssociatedWindowHandle()
//      {}
//
//IAssociatedWindowHandle& operator= (const IAssociatedWindowHandle & another )
//      {
//      helpHandle = another.helpHandle; windowHandle = another.windowHandle;
//      return *this;
//      };
//
//// instance data
//  IWindowHandle  helpHandle;
//  IWindowHandle  windowHandle;
//};

/*----------------------------------------------------------------------------*/
/* Callback routines used for IPF/X interface                                 */
/*----------------------------------------------------------------------------*/
extern "C" {
  // prototype for callback routine for XmNhelpCallback
  void ihelpwindowCallback( _WidgetRec   *handle,
                            void         *client_data,
                            void         *call_data);
  // IPF/X application notify proc prototype
  typedef int (*PAppNotifyProc)() ;
  int  ihelpwindowAppNotifyProc( _WidgetRec    *helpInstance,
                                 unsigned short messageId,
                                 void          *parm1,
                                 void          *parm2) ;
}

// // Functions of type PCheckWindowFunction are passed to the ihelpwindowSearchChain
// // function to validate an IWindow
// typedef IWindowHandle (*PCheckWindowFunction)( IWindow *pwin );
// IWindowHandle  checkForHelpInstance( IWindow *pwin );
// IWindowHandle  checkForFrameWindow( IWindow *pwin );
//
// // routine to search parent and owner chain for window validated by testfn
// IWindowHandle ihelpwindowSearchChain( IWindowHandle        handle,
//                                       PCheckWindowFunction testfn );
#endif // IC_MOTIF

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IHELPSTA_
