// Revision: 72 1.8.2.2 source/ui/baseapp/ihelpsta.cpp, help, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ihelpsta.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ihelpsta.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

extern "C"
  {
  #define INCL_WINHELP
  #include <iwindefs.h>
  #ifdef IC_WIN
    extern LRESULT CALLBACK _IHelpMsgFilterProc ( UINT, WPARAM, LPARAM );
    extern LRESULT CALLBACK _IHelpKeyboardProc ( UINT, WPARAM, LPARAM );
  #endif
  #ifndef IC_PM
    #include <ipfx.h>
  #endif
  #ifdef IC_MOTIF
    #include <Xm/RowColumn.h>
  #endif //IC_MOTIF
  }

#ifdef IC_MOTIFWIN
  #include <iwindow.hpp>
  #include <imenu.hpp>
  #include <iframe.hpp>
  #include <iplatfrm.hpp>
  #include <ihelpprv.hpp>
#endif
#ifdef IC_MOTIF
  #include <ihelp.hpp>
  #include <ihelptbl.hpp>
  #include <iresstat.hpp>
  #include <iseq2.h>
#endif //IC_MOTIF

#include <icconst.h>
#include <ihelpsta.hpp>
#include <itrace.hpp>
#include <ireslib.hpp>
#include <iexcept.hpp>
#include <imenuprv.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IHELPSTA_CPP_
  #include <ipagetun.h>
#endif


  IHelpStatics helpMgr;


ICreateInstance*     IHelpStatics::entryCreate        = 0;
IAssocInstance*      IHelpStatics::entryAssoc         = 0;
IQueryInstance*      IHelpStatics::entryQuery         = 0;
IDestroyInstance*    IHelpStatics::entryDestroy       = 0;
#ifdef IC_PMWIN
ILoadHelpTable*      IHelpStatics::entryLoadHelpTable = 0;
IDynamicLinkLibrary* IHelpStatics::helpDynLinkLib     = 0;
#endif //IC_PMWIN

#ifdef IC_WIN
ICallIPF*            IHelpStatics::entryCallIPF       = 0;
HHOOK                IHelpStatics::keyboardHook       = 0;
HHOOK                IHelpStatics::msgFilterHook      = 0;
unsigned short       IHelpStatics::activeMenuItem     = 0;
HWND                 IHelpStatics::activeMenu         = 0;
#endif

/*------------------------------------------------------------------------------
| IHelpStatics::~IHelpStatics                                                  |
------------------------------------------------------------------------------*/
IHelpStatics::~IHelpStatics ( )
{
    IMODTRACE_DEVELOP("IHelpStatics::~IHelpStatics");
#ifdef IC_WIN
    if (keyboardHook)
      UnhookWindowsHookEx( keyboardHook );
    if (msgFilterHook)
      UnhookWindowsHookEx( msgFilterHook );
#endif
#ifdef IC_PMWIN
#if    IC_STATIC_PRIORITY_SUPPORTED
    if (helpDynLinkLib)
      delete helpDynLinkLib;
#endif
#endif //IC_PMWIN
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IHelpStatics::helpDLL                                                        |
------------------------------------------------------------------------------*/
IDynamicLinkLibrary& IHelpStatics :: helpDLL ( )
  {
     if (!helpDynLinkLib)
#ifdef IC_PM
        helpDynLinkLib = new IDynamicLinkLibrary("helpmgr");
#endif
#ifdef IC_WIN
        helpDynLinkLib = new IDynamicLinkLibrary("libipf32.dll");
#endif

     return *helpDynLinkLib;
  }
#endif //IC_PMWIN

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IHelpStatics::addHooks                                                       |
------------------------------------------------------------------------------*/
void IHelpStatics :: addHooks ( )
  {
    if (!msgFilterHook)
      msgFilterHook = SetWindowsHookEx(WH_MSGFILTER,
                                       (HOOKPROC)&(_IHelpMsgFilterProc),
                                       0,
                                       GetCurrentThreadId());

    if (!keyboardHook)
      keyboardHook = SetWindowsHookEx(WH_KEYBOARD,
                                      (HOOKPROC)&(_IHelpKeyboardProc),
                                      0,
                                      GetCurrentThreadId());

  }
#endif

/*------------------------------------------------------------------------------
| IHelpStatics::createHelpInstance                                             |
------------------------------------------------------------------------------*/
#ifdef IC_PM
IWindowHandle
  IHelpStatics :: createHelpInstance ( const IAnchorBlockHandle& hab,
                                       void* helpstruct )
  {
     if (!entryCreate)
        entryCreate =
          (ICreateInstance*)helpDLL().procAddress( "Win32CreateHelpInstance");
     return (*entryCreate)(hab, helpstruct);
  }
#endif
#ifdef IC_MOTIFWIN
IWindowHandle
  IHelpStatics :: createHelpInstance ( const IWindowHandle& windowHandle,
                                       void* helpstruct )
  {
     IWindowHandle::Value hwndHelp=0;
     long rc=-1;
#ifdef IC_WIN
     if (!entryCreate)
      entryCreate =
             (ICreateInstance*)helpDLL().procAddress( "XhCreateHelpInstance");
     if (entryCreate)
     {
       rc = (*entryCreate)(windowHandle, (PHELPINIT)helpstruct, &hwndHelp );
     }
#endif //IC_WIN
#ifdef IC_MOTIF
     rc = XhCreateHelpInstance( windowHandle, (PHELPINIT)helpstruct, &hwndHelp);
#endif //IC_MOTIF

     switch (rc)
     {
       case 0:
       {
#ifdef IC_MOTIF
         // The USERDATA field in the help widget is used to store a pointer
         // to the help table.  Indicate that there is no help table loaded.
         IHelpStatics::callIPF( hwndHelp,
                    HM_SET_USERDATA,
                    IEventParameter1(0),
                    IEventParameter2(0) );
#endif //IC_MOTIF
         break;
       }
       case HMERR_INVALID_APPL_WIDGET:
       {
         ITHROWGUIERROR("WinCreateHelpInstance - Invalid Appl Handle");
         break;
       }
       case HMERR_INVALID_HELP_STRUCTURE:
       {
         ITHROWGUIERROR("WinCreateHelpInstance - Invalid Help Structure");
         break;
       }
       case HMERR_MEMORY_ERROR:
       {
         ITHROWGUIERROR("WinCreateHelpInstance - Insufficient Memory");
         break;
       }
       case HMERR_INVALID_RES_FILE:
       {
         ITHROWGUIERROR("WinCreateHelpInstance - Invalid DLL IPF.DLL");
         break;
       }
       case HMERR_INVALID_HELPTABLE:
       {
         ITHROWGUIERROR("WinCreateHelpInstance - Invalid Help Table");
         break;
       }
       case HMERR_OPEN_LIB_FILE:
       case HMERR_INVALID_LIB_FILE:
       case HMERR_READ_LIB_FILE:
       {
         ITHROWGUIERROR("WinCreateHelpInstance - Help File Cannot Be Opened");
         break;
       }
       default:
       {
         ITHROWGUIERROR("WinCreateHelpInstance - Unknown Error");
         break;
       }
     }

     return hwndHelp;
  }
#endif

/*------------------------------------------------------------------------------
| IHelpStatics::associateHelpInstance                                          |
------------------------------------------------------------------------------*/
bool
  IHelpStatics::associateHelpInstance ( const IWindowHandle& helpHandle,
                                        const IWindowHandle& activeWindowHandle )
  {
     if (!entryAssoc)
        entryAssoc = (IAssocInstance*)
#ifdef IC_PM
          helpDLL().procAddress("Win32AssociateHelpInstance");
#endif
#ifdef IC_WIN
          helpDLL().procAddress("XhAssociateHelpInstance");
#endif //IC_WIN
#ifdef IC_MOTIF
          &XhAssociateHelpInstance;
#endif //IC_MOTIF

     long rc = (*entryAssoc)(helpHandle, activeWindowHandle);

#ifdef IC_PM
     return rc ? true : false;
#else
     return rc ? false : true;
#endif
  }

/*------------------------------------------------------------------------------
| IHelpStatics::queryHelpInstance                                              |
------------------------------------------------------------------------------*/
IWindowHandle
  IHelpStatics::queryHelpInstance ( const IWindowHandle& windowHandle )
  {
#ifdef IC_PM
     if (!entryQuery)
        entryQuery =
          (IQueryInstance*)helpDLL().procAddress("Win32QueryHelpInstance");
     return (*entryQuery)(windowHandle);
#endif

#ifdef IC_MOTIFWIN
     IWindowHandle::Value hwndHelp=0;

     if (!entryQuery)
        entryQuery =
#ifdef IC_WIN
          (IQueryInstance*)helpDLL().procAddress("XhQueryHelpInstance");
#endif
#ifdef IC_MOTIF
          (IQueryInstance*)&XhQueryHelpInstance;
#endif

     if (entryQuery)
     {
        (*entryQuery)(windowHandle, &hwndHelp);
     }
     return hwndHelp;
#endif
  }

/*------------------------------------------------------------------------------
| IHelpStatics::destroyHelpInstance                                            |
------------------------------------------------------------------------------*/
bool IHelpStatics::destroyHelpInstance ( const IWindowHandle& helpHandle )
{
#ifdef IC_SUN
    // avoid the segmentation fault on closing
    // the window on SUN platform   -- MK
    return false;
#endif

     if (!entryDestroy)
        entryDestroy = (IDestroyInstance*)
#ifdef IC_PM
          helpDLL().procAddress("Win32DestroyHelpInstance");
#endif
#ifdef IC_WIN
          helpDLL().procAddress("XhDestroyHelpInstance");
#endif
#ifdef IC_MOTIF
          &XhDestroyHelpInstance;
#endif
     long rc = (*entryDestroy)(helpHandle);

#ifdef IC_PM
     return rc ? true : false;
#else
     return rc ? false : true;
#endif
}

/*------------------------------------------------------------------------------
| IHelpStatics::loadHelpTable                                                  |
------------------------------------------------------------------------------*/
bool IHelpStatics::loadHelpTable ( const IWindowHandle& helpHandle,
                                             unsigned long id,
                                             const IModuleHandle& hmod )
  {
#ifdef IC_PM
     if (!entryLoadHelpTable)
        entryLoadHelpTable =
          (ILoadHelpTable*)helpDLL().procAddress("Win32LoadHelpTable");
     return (*entryLoadHelpTable)(helpHandle, id, hmod);
#endif
#ifdef IC_WIN
     if (!entryLoadHelpTable)
        entryLoadHelpTable =
          (ILoadHelpTable*)helpDLL().procAddress("XhLoadHelpTable");

     long rc = (*entryLoadHelpTable)(helpHandle, id, hmod);

     if ( rc == 0 )
      return true;
     else
      return false;
#endif
#ifdef IC_MOTIF
  // get the pointer to any previous help table
  IHelpTable  *oldHT = (IHelpTable *)IHelpStatics::callIPF( helpHandle,
                                                HM_QUERY,
                                                IEventParameter1( 0, USERDATA),
                                                IEventParameter2(0) );
  // create the new helptable
  IHelpTable *ht = new IHelpTable( IResourceId(id) );

  // store a pointer to it in the help widget
  if (0 == IHelpStatics::callIPF( helpHandle,
                      HM_SET_USERDATA,
                      IEventParameter1(0),
                      IEventParameter2( (void *) ht) ) )
     {
     // clean up the old helptable
     if (oldHT)
        delete oldHT;
     return true;
     }
  else
     {
     return false;
     }
#endif //IC_MOTIF
  }

#ifdef IC_MOTIFWIN
/*------------------------------------------------------------------------------
| IHelpStatics::callIPF                                                        |
------------------------------------------------------------------------------*/
long IHelpStatics::callIPF ( const IWindowHandle& helpHandle,
                             unsigned short usMsgType,
                             void* param1, void* param2 )
{
  IFUNCTRACE_DEVELOP();
  ITRACE_DEVELOP(" MsgType= " + IString((unsigned long)usMsgType));
  ITRACE_DEVELOP(" param1 = " + IString((unsigned long)param1));

#ifdef IC_WIN
  if (!entryCallIPF)
    entryCallIPF =
          (ICallIPF*)helpDLL().procAddress("XhCallIPF");

  long rc = (*entryCallIPF)(helpHandle, usMsgType, param1, param2);
#endif

#ifdef IC_MOTIF
  long rc = XhCallIPF( helpHandle, usMsgType, param1, param2 );
#endif

  return rc;
}
#endif

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| _IHelpMsgFilterHook                                                          |
|                                                                              |
| Hook WM_KEYDOWN.                                                             |
------------------------------------------------------------------------------*/
LRESULT CALLBACK _IHelpMsgFilterProc (UINT msgFilterCode,
                                      WPARAM unused,
                                      LPARAM lpMsg)
{
  MSG input = *(LPMSG)lpMsg;
  if ( (msgFilterCode == MSGF_MENU) &&
       (input.message == WM_MENUSELECT) )
  {
    IFrameWindow *frame=ihelpwindowSearchChain(input.hwnd, 0);
    if (frame)
    {
      unsigned short itemID = (unsigned short)(unsigned long)input.wParam;
      unsigned short flags  = (unsigned short)((unsigned long)input.wParam>>16);
      if (flags==0xFFFF && input.lParam == 0)
      {
        IHelpStatics::activeMenuItem = 0;
        IHelpStatics::activeMenu = 0;
      }
      else
      {
        if (flags & MF_POPUP)
        {
          HMENU subMenuHandle = GetSubMenu( (HMENU) input.lParam, itemID );
          IMenu *subMenu = new IMenu( subMenuHandle );
          if (subMenu)
            itemID = subMenu->id();
        }
        IHelpStatics::activeMenuItem = itemID;
        IHelpStatics::activeMenu = (HWND) input.lParam;
      }
    }
  }

  return CallNextHookEx(IHelpStatics::msgFilterHook,msgFilterCode,unused,lpMsg);
}

/*------------------------------------------------------------------------------
| _IHelpKeyboardHook                                                           |
|                                                                              |
| Hook WM_KEYDOWN.                                                             |
------------------------------------------------------------------------------*/
LRESULT CALLBACK _IHelpKeyboardProc (UINT hookCode,
                                     WPARAM vkey,
                                     LPARAM flags)
{
  unsigned short keyFlags = (unsigned short)((unsigned long)flags>>16);
  if ( (hookCode == HC_ACTION) &&
     ( !(keyFlags & KF_UP) && vkey == VK_F1 ) )
  {
    HWND focus = IQUERYFOCUS(NULL);
    IFrameWindow *frame=ihelpwindowSearchChain(focus, 0);
    if (focus && frame)
    {
      IEventParameter1 parm1(0);
      IEventParameter2 parm2(focus);
      if (IHelpStatics::activeMenu)
      {
        parm1=IEventData(IHelpStatics::activeMenuItem,0);
        parm2=IEventData(IHelpStatics::activeMenu);
      }
      return IPOSTMESSAGE((HWND)frame->handle(),
                          IC_UM_CONTEXT_HELP,
                          parm1,
                          parm2);
    }
  }

  return CallNextHookEx(IHelpStatics::keyboardHook,hookCode,vkey,flags);
}
#endif //IC_WIN

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| ihelpwindowCallback -                                                        |
| Callback function for XmNhelpCallback.  The callback is registered for       |
| all IWindows by IWindow::registerCallbacks to call this routine.             |
| The registration of this callback places the ID of the window into the       |
| client_data pointer.   Menu items have the callback registered during        |
| their construction by the menuitem construction code.                        |
------------------------------------------------------------------------------*/
void ihelpwindowCallback( _WidgetRec   *handle,
                          void         *client_data,
                          void         *call_data)
{
   // This callback constructs a WM_HELP message which is dispatched to
   // the first IWindow found in the parent chain of the handle widget.
   // Unlike most IOC callbacks, this one uses the client_data field
   // for the ID of the window instead of its IWindow pointer.  This is
   // because:
   //  1) we need these callbacks on menu items (not IWindows)
   //  2) it is valid to have this callback on non-IWindow children of
   //     IWindow objects (such as in the file dialog).
   IMODTRACE_DEVELOP("ihelpwindowCallback");

   IWindowHandle  notifyHandle = handle;
   // Find the IWindow parent
   IWindow*    notifyWin = IWindow::windowWithHandle( notifyHandle );
   while ((notifyHandle != (IWindowHandle::Value)0) && !notifyWin )
      {
      notifyHandle = IPARENTOF(notifyHandle);
      notifyWin = IWindow::windowWithHandle( notifyHandle );
      }

   if (notifyWin &&
       (notifyWin != IWindow::desktopWindow()) &&
       (notifyWin != IWindow::objectWindow() ))
      {
      // Found a parent that is not the desktop or object window
      // Construct a WM_HELP event to send to this window.
      HELPINFO helpinfo;
      helpinfo.cbSize       = sizeof(HELPINFO);
      if ((unsigned long)client_data & HELP_FROMMENU_BIT)
          {
          // Item help was requested on is a menu item.
          helpinfo.iContextType = HELPINFO_MENUITEM;
          // "notifyWin" may be a temporary ISubmenu menu window, not
          // the root menu window. Locate the root menubar or popup window
          // by searching up the parent chain.
          helpinfo.hItemHandle  = 0;
          IWindowHandle::Value menuHandle = handle;
          while (menuHandle && !helpinfo.hItemHandle)
              {
              unsigned char rcType(0);
              if ( XmIsRowColumn(menuHandle) )
                  {
                  XtVaGetValues(menuHandle,
                                XmNrowColumnType, &rcType,
                                0);
                  }
              if (rcType == XmMENU_BAR)
                  {
                  helpinfo.hItemHandle = menuHandle;
                  }
              else if (rcType == XmMENU_POPUP)
                  {
                  // handle of IMenu object is menu shell
                  menuHandle = IPARENTOF( menuHandle );
                  helpinfo.hItemHandle = menuHandle;
                  }
              else
                  {
                  menuHandle = IPARENTOF(menuHandle);
                  }
              }  // while
          // Don't notify the temp ISubmenu menu window, notify the root window
          notifyWin = IWindow::windowWithHandle(menuHandle);  //AJ26660
      }  // is menu
      else
          {
          // Item help was requested on is a window.
          helpinfo.iContextType = HELPINFO_WINDOW;
          helpinfo.hItemHandle  = handle;
          }
      helpinfo.iCtrlId      = ((unsigned long)client_data) & ~(HELP_FROMMENU_BIT);
      helpinfo.dwContextId  = 0;
      //helpinfo.MousePos     = {0,0};

      // Construct the IEvent and send to window.  This event is dispatched up
      // the owner chain via IWindow.
      if ( notifyWin )
          {
          notifyWin->sendEvent( WM_HELP, 0, &helpinfo );
          }
      }

   return;

}

/*------------------------------------------------------------------------------
| ihelpwindowAppNotifyProc                                                     |
| IPF/X notification routine.  Called by IPF/X                                 |
------------------------------------------------------------------------------*/
int  ihelpwindowAppNotifyProc( _WidgetRec    *helpReceiver,
                               unsigned short messageId,
                               void          *parm1,
                               void          *parm2)
{
   IMODTRACE_DEVELOP("ihelpwindowAppNotifyProc");
   ITRACE_DEVELOP( IString("helpReceiver=") +
                   IString( IWindowHandle(helpReceiver).asUnsigned() ).d2x() +
                   IString( " messageId=") + IString( messageId ).d2x() +
                   IString( " parm1=") + IString( (unsigned long)parm1 ).d2x() +
                   IString( " parm2=") + IString( (unsigned long)parm2 ).d2x() );

   // Make sure that the help receiver window is an IWindow...if so
   // pass the event on to it to be potentially handled by an
   // IHelpHandler
   int  result = 0;
   IWindow *pwin = IWindow::windowWithHandle( helpReceiver ) ;

   if (pwin)
       {
       // pass the event on to our handler chain
       IWindowHandle hwindow = helpReceiver;
       result = hwindow.sendEvent( messageId, parm1, parm2 );
       }
   else
       {
       ITRACE_DEVELOP("Not an IWindow");
//      ITRACE_DEVELOP( IString("not an IWindow  name=" ) +
//                      IString( XtName( helpReceiver ) ) +
//                      IString( " widgetclass=") +
//                      IString( helpReceiver->core.widget_class->core_class.class_name ) );
       }
   return result;
}

#endif //IC_MOTIF

#ifdef IC_MOTIFWIN
/*------------------------------------------------------------------------------
| ihelpwindowSearchChain                                                       |
| Routine to search parent and owner chain for window.                         |
| If a validated window is found, its handle is returned.  Otherwise           |
| IFrameWindow(0) is returned.                                                 |
------------------------------------------------------------------------------*/
IFrameWindow* ihelpwindowSearchChain( IWindowHandle::Value contextHwnd,
                                      IWindowHandle::Value lastActiveFrame)
{
  bool          foundFrame(false);
  IFrameWindow* activeFrame(0);
  IWindow*      saveWindow(0);
  if (lastActiveFrame)
      saveWindow = IWindow::windowWithHandle(lastActiveFrame);

  if ( (saveWindow != 0) && (saveWindow->isFrameWindow()) )
      return (IFrameWindow *)saveWindow;

  if (contextHwnd==0)
      return 0;

  saveWindow = 0;                  // reuse this below
  IWindowHandle::Value currentHwnd = contextHwnd;
  IWindow* currentWindow;
  // If the first IWindow is not the desktop search the chain.  Otherwise
  // return 0.
  while ( !foundFrame && ( currentHwnd !=0 ) &&
        ( currentHwnd != (IWindowHandle::Value)IWindow::desktopWindow()->handle() ) )
      {
      currentWindow = IWindow::windowWithHandle( currentHwnd );
      if (currentWindow)
          saveWindow = currentWindow;      //save first IWindow for owner search
      if ( currentWindow && currentWindow->isFrameWindow() )
          {
          foundFrame = true;
          activeFrame = (IFrameWindow*)currentWindow;
          }
      else
          {
          currentHwnd = IPARENTOF(currentHwnd);
          }
      }

  currentWindow = saveWindow;
  // search for a suitable window in the owner tree
  while ( !foundFrame && currentWindow &&
          ( (currentWindow = currentWindow->owner()) != 0 ) &&
          ( currentWindow != IWindow::desktopWindow() )  )
      {
      if ( currentWindow && currentWindow->isFrameWindow() )
          {
          foundFrame = true;
          activeFrame = (IFrameWindow*)currentWindow;
          }
      }
  return activeFrame;
}
#endif //IC_MOTIFWIN

