// Revision: 64 1.8.3.2 source/ui/baseapp/ihelp1.cpp, help, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ihelp1.cpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ihelp.hpp.  (platform dependent)                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481424 )

#define INCL_WINHELP
#define INCL_WININPUT
#define INCL_WINMESSAGEMGR
#define INCL_WINWINDOWMGR
extern "C" {
  #include <iwindefs.h>
  #ifndef IC_PM
    #include <ipfx.h>
  #endif
}

#include <ihelp.hpp>
#include <ihelpprv.hpp>
#include <ihelpsta.hpp>
#include <itrace.hpp>
#include <iapp.hpp>
#if (!defined(IC_MOTIF) && !defined(_IWCNAME_))
  #include <iwcname.hpp>
#endif

#ifdef IC_MOTIFWIN
  #include <ihelptbl.hpp>
  #include <imenu.hpp>
  #include <imenuprv.hpp>
#endif

#include <icconst.h>
#include <icoordsy.hpp>
#include <iexcept.hpp>
#include <iframe.hpp>
#include <ipoint.hpp>
#include <iprocadr.hpp>
#include <irect.hpp>
#include <ireslib.hpp>
#include <istring.hpp>
#include <ithread.hpp>
#include <iwindow.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IHELP1_CPP_
  #include <ipagetun.h>
#endif

//***************************************************************
// Public styles.
//***************************************************************
const IHelpWindow::Style
  IHelpWindow::noStyle            = 0,
  IHelpWindow::classDefaultStyle  = 0,
  IHelpWindow::ipfCompatible      = 0x00000001;

#ifdef IC_WIN
  IHelpWindow::Style IHelpWindow::currentDefaultStyle = IHelpWindow::noStyle;
#else
  IHelpWindow::Style IHelpWindow::currentDefaultStyle = IHelpWindow::ipfCompatible;
#endif

/*------------------------------------------------------------------------------
| IHelpWindow::IHelpWindow                                                     |
|  Initialize the PM help structure and create an instance of the help         |
|  facility.                                                                   |
------------------------------------------------------------------------------*/
IHelpWindow::IHelpWindow ( IFrameWindow             *associatedWindow,
                           const IHelpWindow::Style &style )
            : fHelpWindowData ( new IHelpWindowData( *this ) )
{
  if (style & ipfCompatible)
  {
    fHelpWindowData->isUsingIPF = true;

    HELPINIT   helpstruct;

#ifdef IC_PM
    helpstruct.cb              = sizeof(HELPINIT);
    helpstruct.ulReturnCode    = 0;
    helpstruct.pszTutorialName = 0;
    helpstruct.phtHelpTable    = 0;

    helpstruct.hmodHelpTableModule =
                  IApplication::current().userResourceLibrary().handle();
    helpstruct.idAccelTable        = 0;
    helpstruct.idActionBar         = 0;
    helpstruct.pszHelpWindowTitle  = 0;
    helpstruct.fShowPanelId        = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryName  = 0;
    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance(IThread::current().anchorBlock(),
                                       &helpstruct);
    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("WinCreateHelpInstance");
    }
    startHandlingEventsFor(fHelpWindowData->helpHandle);
#endif //IC_PM
#ifdef IC_WIN
    helpstruct.hHelpTableModule = 0;
    helpstruct.hAccelMenuBarModule = 0;
    helpstruct.ulAccelTable = 0;
    helpstruct.menuBarHierarchy = 0;
    helpstruct.pszHelpWindowTitle = 0;
    helpstruct.usShowPanelId = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryNames = 0;
    helpstruct.pHelpTable = 0;
    helpstruct.usHelpTableID = 0;
    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance( IWindow::objectWindow()->handle(),
                                        &helpstruct);
    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("XhCreateHelpInstance");
    }
#endif //IC_WIN

#ifdef IC_MOTIF
    helpstruct.pszHelpWindowTitle   = 0;
    helpstruct.usShowPanelId        = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryNames  = 0;
    helpstruct.appNotifyProc        = (PAppNotifyProc)ihelpwindowAppNotifyProc;
    helpstruct.menuBarHierarchy     = NULL;

    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance(IWindow::desktopWindow()->handle(),
                                       &helpstruct);

    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("WinCreateHelpInstance");
    }
    startHandlingEventsFor(fHelpWindowData->helpHandle);

    // set the owner to specified window.   In Motif we manage "owner chain"
    setOwner( associatedWindow );
    // Force recoordination if needed
    IWindow::moveSizeTo( IRectangle() );
#endif //IC_MOTIF

  } // end of IPF Compatibility

  // IWinHelpHandler::handleEventsFor is called in setAssociatedWindow.
  if ( associatedWindow )
    setAssociatedWindow( associatedWindow );

}


/*------------------------------------------------------------------------------
| IHelpWindow::IHelpWindow                                                     |
|  Initialize the PM help structure and create an instance of the help         |
|  facility.                                                                   |
------------------------------------------------------------------------------*/
IHelpWindow::IHelpWindow ( const IResourceId        &helpTable,
                           IFrameWindow             *associatedWindow,
                           const IHelpWindow::Style &style )
            : fHelpWindowData ( new IHelpWindowData( *this ) )
{
  IASSERTPARM(associatedWindow!=0);
  if (style & ipfCompatible)
  {
    fHelpWindowData->isUsingIPF = true;

    HELPINIT   helpstruct;
#ifdef IC_PM
    helpstruct.cb              = sizeof(HELPINIT);
    helpstruct.ulReturnCode    = 0;
    helpstruct.pszTutorialName = 0;
    helpstruct.phtHelpTable    = (PHELPTABLE)MAKELONG(
                                          (unsigned long)(helpTable.id() ),
                                          0xffff);

    helpstruct.hmodHelpTableModule =
                  IApplication::current().userResourceLibrary().handle();
    helpstruct.idAccelTable        = 0;
    helpstruct.idActionBar         = 0;
    helpstruct.pszHelpWindowTitle  = 0;
    helpstruct.fShowPanelId        = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryName  = 0;
    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance(IThread::current().anchorBlock(),
                                       &helpstruct);
    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("WinCreateHelpInstance");
    }
    startHandlingEventsFor(fHelpWindowData->helpHandle);
#endif
#ifdef IC_WIN
    helpstruct.hHelpTableModule = 0;
    helpstruct.hAccelMenuBarModule = 0;
    helpstruct.ulAccelTable = 0;
    helpstruct.menuBarHierarchy = 0;
    helpstruct.pszHelpWindowTitle = 0;
    helpstruct.usShowPanelId = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryNames = 0;
    helpstruct.pHelpTable = 0;
    helpstruct.usHelpTableID = 0;
    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance(IWindow::objectWindow()->handle(),
                                       &helpstruct);
    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("XhCreateHelpInstance");
    }
#endif

#ifdef IC_MOTIF
    helpstruct.pszHelpWindowTitle   = 0;
    helpstruct.usShowPanelId        = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryNames  = 0;
    helpstruct.appNotifyProc        = (PAppNotifyProc)ihelpwindowAppNotifyProc;
    helpstruct.menuBarHierarchy     = NULL;

    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance(IWindow::desktopWindow()->handle(),
                                       &helpstruct);
    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("WinCreateHelpInstance");
    }

    ITRACE_ALL    ( IString("helpInstance name=" ) +
                    IString( XtName( (Widget)fHelpWindowData->helpHandle ) ) +
                    IString( " widgetclass=") +
                    IString( ((Widget)fHelpWindowData->helpHandle)->core.widget_class->core_class.class_name ) );

    startHandlingEventsFor(fHelpWindowData->helpHandle);

    // set the owner to specified window.   In Motif we manage "owner chain"
    setOwner( associatedWindow );
    // Force recoordination if needed
    IWindow::moveSizeTo( IRectangle() );

#endif //IC_MOTIF

  } // end of IPF Compatibility

  // IWinHelpHandler::handleEventsFor is called in setAssociatedWindow.
  setAssociatedWindow( associatedWindow );

#ifdef IC_MOTIFWIN
  if ( helpTable.id()!=0 )
    fHelpWindowData->pHlpTable = new IHelpTable(helpTable);
#endif   //IC_MOTIFWIN

}

/*------------------------------------------------------------------------------
| IHelpWindow::IHelpWindow                                                     |
|  Initialize the PM help structure from the given Settings class and          |
|  create an instance of the help facility.                                    |
------------------------------------------------------------------------------*/
IHelpWindow::IHelpWindow( const Settings           &settings,
                          IFrameWindow             *associatedWindow,
                          const IHelpWindow::Style &style )
            : fHelpWindowData ( new IHelpWindowData( *this ) )
{
#ifdef IC_PMWIN
  if ( settings.HTResLib.length() )
  {
     this->fHelpWindowData->pHTResLib =
              new IDynamicLinkLibrary( (char*)settings.HTResLib );
     this->fHelpWindowData->newHTResLib = true;
  }
  else
  {
     this->fHelpWindowData->pHTResLib =
             &( IApplication::current().userResourceLibrary() );
  }

  if ( settings.MAResLib.length() )
  {
     this->fHelpWindowData->pMAResLib =
              new IDynamicLinkLibrary( (char*)settings.MAResLib );
  }
#endif //IC_PMWIN

  //Store the initial libraries so we can concatenate when using addLibraries()
  fHelpWindowData->helpLibraries = settings.helpLibraries;

  if (style & ipfCompatible)
  {
    fHelpWindowData->isUsingIPF = true;
    HELPINIT   helpstruct;
#ifdef IC_PM
    helpstruct.cb              = sizeof(HELPINIT);
    helpstruct.ulReturnCode    = 0;
    helpstruct.pszTutorialName = settings.tutorial.length() ?
                                   (char*)(settings.tutorial) : 0;
    helpstruct.phtHelpTable    = (PHELPTABLE)MAKELONG(
                                   (unsigned long)(settings.helpTableId),
                                   0xffff);
    if ( settings.HTResLib.length() )
       helpstruct.hmodHelpTableModule =
                    this->fHelpWindowData->pHTResLib->handle();
    else
       helpstruct.hmodHelpTableModule =
                    IApplication::current().userResourceLibrary().handle();
    if ( settings.MAResLib.length() )
       helpstruct.hmodAccelActionBarModule =
                    this->fHelpWindowData->pMAResLib->handle();
    else
       helpstruct.hmodAccelActionBarModule = 0;
    helpstruct.idAccelTable       = settings.acceleratorId;
    helpstruct.idActionBar        = settings.menuBarId;
    helpstruct.pszHelpWindowTitle = (char*)settings.title;
    helpstruct.fShowPanelId       = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryName = (char*)(settings.helpLibraries);
    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance(IThread::current().anchorBlock(),
                                     &helpstruct);
    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("WinCreateHelpInstance");
    }
    if ( this->fHelpWindowData->pHTResLib )
       this->fHelpWindowData->pHTResLib->loadHelpTable( this,
                                               settings.helpTableId);
    startHandlingEventsFor(fHelpWindowData->helpHandle);
#endif
#ifdef IC_WIN
    helpstruct.pHelpTable = 0;
    helpstruct.usHelpTableID = 0;
    helpstruct.hHelpTableModule = 0;
    if ( settings.MAResLib.length() )
       helpstruct.hAccelMenuBarModule =
                    this->fHelpWindowData->pMAResLib->handle();
    else
       helpstruct.hAccelMenuBarModule = 0;
    helpstruct.ulAccelTable        = settings.acceleratorId;
    helpstruct.menuBarHierarchy    = settings.menuBarId;
    helpstruct.pszHelpWindowTitle  = (char*)settings.title;
    helpstruct.usShowPanelId       = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryNames = (char*)(settings.helpLibraries);;
    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance(IWindow::objectWindow()->handle(),
                                       &helpstruct);
    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("XhCreateHelpInstance");
    }
#endif

#ifdef IC_MOTIF
    // get the resource library for the help table
    fHelpWindowData->pHTResLib = (IResourceLibrary *)
       &IResourceId( settings.helpTableId ).resourceLibrary();

    helpstruct.pszHelpWindowTitle   = (char *)settings.title;
    helpstruct.usShowPanelId        = CMIC_HIDE_PANEL_ID;
    helpstruct.pszHelpLibraryNames  = (char*)(settings.helpLibraries);
    helpstruct.appNotifyProc        = (PAppNotifyProc)ihelpwindowAppNotifyProc;
    helpstruct.menuBarHierarchy     = NULL;


    fHelpWindowData->helpHandle =
      IHelpStatics::createHelpInstance(IWindow::desktopWindow()->handle(),
                                       &helpstruct);
    if (!fHelpWindowData->helpHandle)
    {
       ITHROWGUIERROR("WinCreateHelpInstance");
    }
    startHandlingEventsFor(fHelpWindowData->helpHandle);

    // set the owner to specified window.   In Motif we manage "owner chain"
    setOwner( associatedWindow );
    // Force recoordination if needed
    IWindow::moveSizeTo( IRectangle() );
#endif //IC_MOTIF

    if (settings.usingHelpId)
       this->setUsingHelp( settings.usingHelpId );

  } // end of IPF Compatibility

  // IWinHelpHandler::handleEventsFor is called in setAssociatedWindow.
  if ( associatedWindow )
     setAssociatedWindow( associatedWindow );

#ifdef IC_MOTIFWIN
  if ( settings.helpTableId != 0 )
    fHelpWindowData->pHlpTable =
         new IHelpTable( IResourceId(settings.helpTableId,
                                    *(this->fHelpWindowData->pHTResLib)));
#endif

}


/*------------------------------------------------------------------------------
| IHelpWindow::IHelpWindow                                                     |
|  Create an IHelpWindow object from an existing window handle.                |
------------------------------------------------------------------------------*/
IHelpWindow::IHelpWindow(const IWindowHandle& helpWindowHandle)
            : fHelpWindowData ( new IHelpWindowData( *this ) )
{
  IASSERTPARM(helpWindowHandle!=0);

  fHelpWindowData->helpHandle = helpWindowHandle;
  fHelpWindowData->isUsingIPF = true;
#ifdef IC_MOTIFPM
  startHandlingEventsFor(fHelpWindowData->helpHandle);
#endif
  setAutoDestroyWindow(false);

}


/*------------------------------------------------------------------------------
| IHelpWindow::~IHelpWindow                                                    |
------------------------------------------------------------------------------*/
IHelpWindow::~IHelpWindow()
{
  if (this->isIPFCompatible())
  {
#ifdef IC_MOTIFWIN
    if ( fHelpWindowData->helpHandle && !deleteIsInProcess() )
      IHelpStatics::destroyHelpInstance( fHelpWindowData->helpHandle );
#endif //IC_MOTIFWIN
#ifdef IC_PM
    IHelpStatics::destroyHelpInstance( fHelpWindowData->helpHandle );
#endif //IC_PM
  }
#ifdef IC_WIN
  else
  {
    if ( !deleteIsInProcess() )
      WinHelp((HWND)this->handle(),
              fHelpWindowData->helpLibraries,
              HELP_QUIT,
              0);
  }
#endif

#ifdef IC_WIN
  if (fHelpWindowData->pHlpTable)
    delete fHelpWindowData->pHlpTable;
#endif

#ifdef IC_PMWIN
  if (fHelpWindowData->pMAResLib)
    delete fHelpWindowData->pMAResLib;
#endif

  delete fHelpWindowData;
}

#ifdef IC_MOTIFWIN
/*------------------------------------------------------------------------------
| IWinHelpHandler::IWinHelpHandler                                             |
|  Save pointer to help window private data.                                   |
------------------------------------------------------------------------------*/
IWinHelpHandler::IWinHelpHandler(IHelpWindow&     helpWindow,
                                 IHelpWindowData& helpWindowData)
           : fHelpWindow(helpWindow)
           , fHlpWndData(helpWindowData)
{
}

/*------------------------------------------------------------------------------
| IWinHelpHandler::IWinHelpHandler (private dummy)                             |
------------------------------------------------------------------------------*/
IWinHelpHandler::IWinHelpHandler( const IWinHelpHandler& another)
           : fHelpWindow(another.fHelpWindow)
           , fHlpWndData(another.fHlpWndData)
{
}

/*------------------------------------------------------------------------------
| IWinHelpHandler::operator= (private dummy)                                   |
------------------------------------------------------------------------------*/
IWinHelpHandler& IWinHelpHandler::operator=( const IWinHelpHandler& )
{
  return *this;
}

/*------------------------------------------------------------------------------
| IWinHelpHandler::~IWinHelpHandler                                            |
------------------------------------------------------------------------------*/
IWinHelpHandler::~IWinHelpHandler()
{
}

/*------------------------------------------------------------------------------
| IWinHelpHandler::dispatchHandlerEvent                                        |
|  Dispatch WM_HELP messages.                                                  |
------------------------------------------------------------------------------*/
bool IWinHelpHandler::dispatchHandlerEvent(IEvent &evt)
{

   // Handle WM_HELP messages
   if ( evt.eventId() == WM_HELP )
   {
     return winHelpRequested(evt);
   }
   else if ( evt.eventId() == IC_UM_QUERY_HELP_WINDOW )
   {
     evt.setResult( (void *) &fHelpWindow );
     return true;
   }
#ifdef IC_WIN
   // dismiss the helpwindow when the last frame that showed help dismisses.
   else if ( evt.eventId() == WM_DESTROY ||
            (evt.eventId() == WM_SHOWWINDOW && evt.parameter2() == SW_HIDE) )
   {
     if ( evt.handle()==fHlpWndData.ownerForIPF )
     {
       // For WinHelp, we rely upon the IHelpWindow destructor to call
       // WinHelp with HELP_QUIT.  Allowing hide to occur here can cause
       // a winhelp instance to be left around if the user dismisses the help
       // window.
       if (fHelpWindow.isIPFCompatible())
          fHelpWindow.hide();
       return false;
     }
   }
#endif

 return false;
}

/*------------------------------------------------------------------------------
| IWinHelpHandler::winHelpRequested                                            |
|  Process WM_HELP messages by getting mapping control id to help id from the  |
|  resource file help table.  If no help table, display general help.          |
------------------------------------------------------------------------------*/
bool IWinHelpHandler::winHelpRequested(IEvent &evt)
{
  unsigned short frameID = 0;
  unsigned short controlID = 0;
  unsigned short helpID = 0;
  unsigned short frameOrMenu = (unsigned short)HLPM_FRAME;
  IWindowHandle::Value requestingHwnd = 0;
  IFrameWindow* activeFrame = 0;
  IWindow* assocWindow = 0;

  HELPINFO* helpInfo=(LPHELPINFO)(void *)(evt.parameter2());
  requestingHwnd = (IWindowHandle::Value) helpInfo->hItemHandle;
  controlID   = (unsigned short) helpInfo->iCtrlId;
  helpID      = (unsigned short) helpInfo->dwContextId;

  if (helpInfo->iContextType == HELPINFO_MENUITEM)
  {
    frameOrMenu = (unsigned short)HLPM_MENU;
    if ( helpID == 0 )
    {
#ifdef IC_WIN
      IMenuHandle::Value requestingHmenu =
                            (IMenuHandle::Value) requestingHwnd;
      IMenu* tempMenu = new IMenu( requestingHmenu );
      if (tempMenu)
        {
        helpID = (unsigned short) tempMenu->itemHelpId( controlID );
        delete tempMenu;
        }
#endif
#ifdef IC_MOTIF
      IWindow* tempWin = IWindow::windowWithHandle( requestingHwnd );
      ITRACE_DEVELOP( IString("Help requested window=") +
                      IString((unsigned long)tempWin).d2x() +
                      IString(" handle=") +
                      IString((unsigned long)requestingHwnd).d2x() );
      if (tempWin)
      {
         // Locate the IMenu object, if any, associated with the
         // requesting menu.
         const IAttributeName menuName(IMenuAttribute::menuAttrName);
         const IMenuAttribute* menuAttr =
              dynamic_cast<const IMenuAttribute*>(tempWin->attributeWithName(menuName));
         if (menuAttr)
         {
            IMenu* tempMenu = dynamic_cast<IMenu*>(menuAttr->fMenu);
            ITRACE_DEVELOP( IString("IMenu object is ") +
                            IString((unsigned long)tempMenu).d2x() );
            if (tempMenu)
                helpID = (unsigned short) tempMenu->itemHelpId( controlID );
         }
      }
#endif
    }
    requestingHwnd = evt.window()->handle();
  }
  else
  {
    // See if a help ID is stored in the window.
    // If GetWindowContextHelpId does not find a help ID in the
    // requestingHwnd, it searches the parent (for child window) or
    // owner chain so that it can inherit help IDs.

    if ( helpID == 0 )
    {
      IWindowHandle::Value wnd = requestingHwnd;
      while ( helpID == 0  &&  wnd != 0 )
      {
#if !defined(IC_WIN)
        IWindow* iwnd = IWindow::windowWithHandle( wnd );
        if ( iwnd )
          helpID = (unsigned short) iwnd->helpId();
#else
        helpID = (unsigned short) GetWindowContextHelpId( wnd );
#endif

        IWindowHandle::Value parent = IPARENTOF( wnd );
        if ( parent != 0 && parent != IWindow::desktopWindow()->handle() )
          wnd = parent;
        else
          {
#ifdef IC_MOTIF
          IWindow* ownerwin = iwnd ? iwnd->owner() : 0;
          wnd = ownerwin ? (IWindowHandle::Value)ownerwin->handle() : 0;
#endif
#ifdef IC_WIN
          wnd = IOWNEROF( wnd );
#endif
          }
      }
    }
  }

#ifdef IC_MOTIFWIN
  // If setActiveWindow has been called, then we have its handle saved in
  // private data. Use it for searching the help table and as the frame
  // requesting help for native windows help. If not, search the parent
  // and owner chain of the control for a frame to use.
  activeFrame = ihelpwindowSearchChain(requestingHwnd,
                                       fHlpWndData.lastActiveHandle);
#endif
  if ( activeFrame == 0 )
    return false;

  // If we don't have a helpId already, but we do have a helpTable and the
  // of the control for which help was requested, then search the helpTable.
  if ( helpID == 0 )
  {
    // look up controlID in helptable if we have one
    if (fHlpWndData.pHlpTable)
    {
      frameID = (unsigned short) activeFrame->id();
      helpID = fHlpWndData.pHlpTable->helpForWindowID(controlID, frameID);
    }

    if ( helpID == IHelpTable::noHelpFound || helpID == 0)
    {
      // Emulate the processing done on the message parameters in OS/2,
      // as documented for the values that PM passes to the help hook.
      unsigned short topicID = frameID;
      IWindowHandle::Value parentHwnd = IPARENTOF( requestingHwnd );
      if ( IIDOF( parentHwnd ) != IC_FRAME_CLIENT_ID )
      {
         frameOrMenu = (unsigned short)HLPM_WINDOW;
         topicID = IIDOF( parentHwnd );
      }

      IEventParameter1 parm1( frameOrMenu, 0 );
      IEventParameter2 parm2( topicID, controlID );
      bool processedByHandler =
         activeFrame->sendEvent(HM_HELPSUBITEM_NOT_FOUND, parm1, parm2).asUnsignedLong();

      // if subitemnotfound was processed by the helphandler, return.
      if (processedByHandler)
      {
        evt.setResult( true );
        return true;
      }

      // look for extended help in helptable, if there is one
      if (fHlpWndData.pHlpTable )
        helpID = fHlpWndData.pHlpTable->extendedHelpForWindowID(frameID);

      // if there is no extended help, then return
      if ( helpID == 0 )
      {
        evt.setResult( true );
        return true;
      }

    }
  }

  // If we do have a helpId, then call the appropriate help manager.
  if (fHlpWndData.isUsingIPF)
  {
    unsigned long rc;
    rc = IHelpStatics::callIPF(fHlpWndData.helpHandle, HM_DISPLAY_HELP,
                          (void*)helpID, 0);
    switch(rc)
	 {
	 	case 0:
			break;
		case HM_HELPSUBITEM_NOT_FOUND:
			break;
		default:{
			assocWindow = evt.dispatchingWindow();
			IEventParameter1 parm1(rc);
			assocWindow->sendEvent(HM_ERROR, parm1);
		}
	 }
  }
#ifdef IC_WIN
  else
  {
    WinHelp(fHelpWindow.handle(),
            fHlpWndData.helpLibraries,
            HELP_CONTEXT,
            helpID);
  }
#endif

  fHlpWndData.ownerForIPF = activeFrame->handle();

  evt.setResult( true );
  return true;
}
#endif  // IC_MOTIFWIN

/*------------------------------------------------------------------------------
| IHelpWindow::sizeTo                                                          |
------------------------------------------------------------------------------*/
IHelpWindow& IHelpWindow::sizeTo(const ISize& newSize)
{
#ifdef IC_PM
    RECTL   rectl;
    IWindowHandle hwnd = coverPageWindow();
    if ( !hwnd )
    {
       ITHROWLIBRARYERROR(IC_NO_HELP_COVERPAGE, IBaseErrorInfo::invalidRequest,
                          IException::recoverable);
    }
    WinQueryWindowRect(hwnd, &rectl);
    WinMapWindowPoints(hwnd, HWND_DESKTOP, (PPOINTL)&rectl, 2);

    IRectangle newRect =  ICoordinateSystem::convertToApplication(
                          IRectangle(rectl),
                          desktopWindow()->size() ) ;

    moveSizeTo( newRect.sizeTo( newSize ) );
#endif
#ifdef IC_MOTIFWIN
  if (this->isIPFCompatible())
  {
    Inherited::sizeTo(newSize);
  } // end ipfCompatibility
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IHelpWindow::moveTo                                                          |
------------------------------------------------------------------------------*/
IHelpWindow& IHelpWindow::moveTo(const IPoint& newPos)
{
#ifdef IC_PM
    RECTL   rectl;
    IWindowHandle hwnd = coverPageWindow();
    if ( !hwnd )
    {
       ITHROWLIBRARYERROR(IC_NO_HELP_COVERPAGE, IBaseErrorInfo::invalidRequest,
                          IException::recoverable);
    }
    WinQueryWindowRect(hwnd, &rectl);

  /* Note: WinQueryWindowRect always returns bottom left = (0,0)   */
    rectl.xLeft    = newPos.x();
    rectl.yBottom  = newPos.y();
    rectl.xRight  += newPos.x();
    rectl.yTop    += newPos.y();

    moveSizeTo( IRectangle( rectl ) );
#endif
#ifdef IC_MOTIFWIN
  if (this->isIPFCompatible())
  {
    Inherited::moveTo(newPos);
  } // end ipfCompatibility
#endif

  return *this;
}


/*------------------------------------------------------------------------------
| IHelpWindow::moveSizeTo                                                      |
------------------------------------------------------------------------------*/
IHelpWindow& IHelpWindow::moveSizeTo(const IRectangle& newRect)
{
#ifdef IC_PM
  RECTL   rectl = ICoordinateSystem::convertToNative (
                  newRect,
                  desktopWindow()->size() ).asRECTL();
  this->sendEvent(HM_SET_COVERPAGE_SIZE,
                  IEventParameter1(&rectl),
                  IEventParameter2(0) );
#endif
#ifdef IC_WIN
  if (this->isIPFCompatible())
  {
    Inherited::moveSizeTo(newRect);
  }
  else
  {
    HELPWININFO helpWinInfo;
    LPHELPWININFO lpHelpWinInfo=&helpWinInfo;

    helpWinInfo.wStructSize = sizeof(HELPWININFO);
    helpWinInfo.x           = newRect.left();
    helpWinInfo.y           = newRect.bottom();
    helpWinInfo.dx          = newRect.right();
    helpWinInfo.dy          = newRect.top();
    helpWinInfo.wMax        = SW_RESTORE;
//  helpWinInfo.rgchMember  = 0;

    WinHelp((HWND)this->handle(),
            fHelpWindowData->helpLibraries,
            HELP_SETWINPOS,
            (DWORD)lpHelpWinInfo);
  }
#endif
#ifdef IC_MOTIF
  if (this->isIPFCompatible())
  {
    Inherited::moveSizeTo(newRect);
  }
#endif //IC_MOTIF

  return *this;
}

/*------------------------------------------------------------------------------
| IHelpWindow::setActiveWindow                                                 |
------------------------------------------------------------------------------*/
IHelpWindow& IHelpWindow::setActiveWindow( IFrameWindow* activeWindow,
                                           IFrameWindow* relativeWindow )
{
  if (this->isIPFCompatible())
  {
#ifdef IC_PM
    HWND defaultRelWin = HWND_PARENT;
    if (activeWindow)
    {
      if (relativeWindow)
      {
        this->sendEvent(HM_SET_ACTIVE_WINDOW,
                        IEventParameter1( activeWindow->handle() ),
                        IEventParameter2( relativeWindow->handle() ) );
      }
      else
      {
        this->sendEvent(HM_SET_ACTIVE_WINDOW,
                        IEventParameter1( activeWindow->handle() ),
                        IEventParameter2( defaultRelWin ) );
      }
    }
    else
       this->sendEvent(HM_SET_ACTIVE_WINDOW,
                       IEventParameter1(0),
                       IEventParameter2(0) );
#endif
#ifdef IC_MOTIFWIN
    if (activeWindow)
    {
      if (relativeWindow)
      {
        this->sendEvent(HM_SET_ACTIVE_WINDOW,
                        IEventParameter1( relativeWindow->handle() ),
                        IEventParameter2(0) );
      }
      else
      {
        this->sendEvent(HM_SET_ACTIVE_WINDOW,
                        IEventParameter1( activeWindow->handle() ),
                        IEventParameter2(0) );
      }
    }
    else
       this->sendEvent(HM_SET_ACTIVE_WINDOW,
                       IEventParameter1(0),
                       IEventParameter2(0) );
#endif
  } // NOP for Native windows help

#ifdef IC_MOTIFWIN
  fHelpWindowData->lastActiveHandle =
    activeWindow ? activeWindow->handle() : (IWindowHandle)0;
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IHelpWindow::setAssociatedWindow                                             |
------------------------------------------------------------------------------*/
IHelpWindow& IHelpWindow::setAssociatedWindow( IFrameWindow* associatedWindow )
{
  IASSERTPARM( associatedWindow != 0 );

#ifdef IC_MOTIFPM
  if (this->isIPFCompatible())
  {

    IWindowHandle frameHandle = associatedWindow->handle();

    if (!IHelpStatics::associateHelpInstance(fHelpWindowData->helpHandle, frameHandle))
       ITHROWGUIERROR("WinAssociateHelpInstance");
  }
#endif

#ifdef IC_MOTIFWIN
  fHelpWindowData->winHelpHandler.handleEventsFor( associatedWindow );
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IHelpWindow::sendEvent                                                       |
------------------------------------------------------------------------------*/
IEventResult IHelpWindow::sendEvent( unsigned long  eventId,
                                     const IEventParameter1 &parm1,
                                     const IEventParameter2 &parm2) const
{
#ifdef IC_WIN
  long rc=0;
  // should only be called for ipf compatibility
  if (this->isIPFCompatible())
  {
    rc = IHelpStatics::callIPF(fHelpWindowData->helpHandle, eventId,
                               parm1, parm2);

  }
  return IEventResult((void *)rc);
#endif //IC_WIN

#ifdef IC_PM
  return Inherited::sendEvent( eventId, parm1, parm2 );
#endif //IC_PM

#ifdef IC_MOTIF
   ITRACE_DEVELOP(IString("sendEvent helpHandle=") +
                   IString( fHelpWindowData->helpHandle.asUnsigned() ).d2x() +
                   IString( " eventId=") + IString( eventId ).d2x() +
                   IString( " parm1=") + IString( (unsigned long)parm1 ).d2x() +
                   IString( " parm2=") + IString( (unsigned long)parm2 ).d2x() );

   switch (eventId) {
     case HM_DISMISS_WINDOW:
     case HM_DISPLAY_HELP:
     case HM_GENERAL_HELP:  // same as HM_EXT_HELP:
     case HM_SET_ACTIVE_WINDOW:
     case HM_LOAD_HELP_TABLE:
     case HM_CREATE_HELP_TABLE:
     case HM_SET_HELP_WINDOW_TITLE:
     case HM_SET_SHOW_PANEL_ID:
     case HM_REPLACE_HELP_USING_HELP: // same as HM_REPLACE_USING_HELP:
     case HM_HELP_INDEX:
     case HM_HELP_CONTENTS:
     case HM_KEYS_HELP:
     case HM_SET_HELP_LIBRARY_NAME:
        {
        // verify lastActiveHandle is still valid ... if not update it
        if ( ( fHelpWindowData->lastActiveHandle )  &&
             (0 == IWindow::windowWithHandle( fHelpWindowData->lastActiveHandle ) ) )
           {
          IHelpWindow *localthis = (IHelpWindow *) this;  // cast away const
          localthis->setActiveWindow(0);
           }

        int  result = (int)
           IHelpStatics::callIPF( fHelpWindowData->helpHandle,
                                  (unsigned short)eventId, parm1, parm2 ) ;
        return  IEventResult( result );
        }
     default:
        break;
   }
   return Inherited::sendEvent (eventId, parm1, parm2);
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IHelpWindow::sendEvent                                                       |
------------------------------------------------------------------------------*/
IEventResult IHelpWindow::sendEvent ( const IEvent& event ) const
{
  return Inherited::sendEvent(event);
}

/*------------------------------------------------------------------------------
| IHelpWindow::sendEvent                                                       |
------------------------------------------------------------------------------*/
IEventResult IHelpWindow::sendEvent ( EventType eventType,
                                      const IEventParameter1& parm1,
                                      const IEventParameter2& parm2 ) const
{
  return Inherited::sendEvent( eventType, parm1, parm2 );
}

/*------------------------------------------------------------------------------
| IHelpWindow::defaultStyle                                                    |
|                                                                              |
| Return the default style for new help window objects.                        |
------------------------------------------------------------------------------*/
IHelpWindow::Style  IHelpWindow::defaultStyle()
{
  return currentDefaultStyle;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IHelpWindow::setDefaultStyle                                                 |
|                                                                              |
| Set the default style for new help window objects.                           |
------------------------------------------------------------------------------*/
void IHelpWindow::setDefaultStyle( const IHelpWindow::Style& newDefault )
{
  currentDefaultStyle = newDefault;
}
#endif
