// Revision: 52 1.12.2.3 source/ui/baseapp/ihandle.cpp, datatype, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ihandle.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ihandle.hpp.                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#ifdef IC_MOTIF
#include <pthread.h>
#endif

extern "C"
  {
  #define INCL_WINPOINTERS
  #define INCL_GPIBITMAPS
  #define INCL_WINMESSAGEMGR
  #define INCL_WINWINDOWMGR
  #include <iwindefs.h>
  #include <malloc.h>
  #ifdef IC_MOTIF
    #include <Xm/MainW.h>
    #include <X11/Intrinsic.h>
    #include <X11/Xatom.h>
    #include <X11/Xlib.h>
    #include <X11/IntrinsicP.h>
    #include <X11/CoreP.h>
  #endif
  }

#include <ihandle.hpp>
#include <ireslib.hpp>
#include <iexcept.hpp>
#include <istring.hpp>
#include <ithread.hpp>
#include <iwindow.hpp>
#include <iwcname.hpp>
#ifdef IC_MOTIF
  #include <iownitem.hpp>
  #include <iwinpriv.hpp>
  #include <iseq2.h>
#endif
#include <icconst.h>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IHANDLE_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_WIN
  #ifndef _ICLCCL_
   #include <iclccl.h>
  #endif
  #include <icctlsta.hpp>

#pragma enum(4)
#pragma pack(push,4)
// Define a structure used on the EnumWindows/EnumChildWindows callback function
typedef struct _CallbackParms {
  bool                    fPost;
  unsigned long              fEventId;
  IEventData                 fParameter1;
  IEventData                 fParameter2;
  IWindowHandle::BroadcastTo fValue;
} CallbackParms;
#pragma pack(pop)
#pragma enum(pop)

// Callback function for EnumWindows/EnumChildWindows
static BOOL CALLBACK iwindowhandleEnumCB( HWND hwnd, LPARAM callbackParms);

#endif

#ifdef IC_MOTIF
// Callback function for XtAppAddTimeOut
static void _System postATimeHandlerEvent (XtPointer, XtIntervalId*)
{}
#endif

#ifdef IC_MOTIF

class IPostEventLater {
//******************************************************************************
// This class represents an action which has been deferred.  Typically, this
// is needed when an action is requested which will not work correctly until
// the frame window is shown.
//******************************************************************************
public:
  // Request that the specified frame be shown
  IPostEventLater ( IWindowHandle hwnd,
                    unsigned long eventId,
                    const IEventParameter1 &parm1,
                    const IEventParameter2 &parm2 )
  : fHwnd( hwnd )
  , fEventId( eventId )
  , fParm1( parm1 )
  , fParm2( parm2 )
  {
  }
//process the action
bool
  applyTo ( IWindow* fWindow );

private:
  // Copy ctor and assignment (not allowed).
  IPostEventLater ( const IPostEventLater& another );
IPostEventLater
 &operator=                  ( const IPostEventLater& another );

public:
IWindowHandle
  fHwnd;
unsigned long
  fEventId;
IEventParameter1
  fParm1;
IEventParameter2
  fParm2;
};

IPostEventLater
 *fDeferredActions;

class IPostEventDeferred : public IVPtrSequence<IPostEventLater*> {};

static IPostEventDeferred* fDeferredEvents(0);
static bool fTryToDefer( true );
#endif  //IC_MOTIF

#include <itrace.hpp>

/*------------------------------------------------------------------------------
 isValid - Is this a valid window handle for the presentation system?
------------------------------------------------------------------------------*/
bool IWindowHandle::isValid ( ) const
{
#ifdef IC_PM
  bool valid = IQUERYANCHOR( this->fhandle );
  if ( ! valid )
  {
     // Handle the slim chance that the application is relying on this
     // function to call WinInitialize via ICurrentThread::anchorBlock.
     valid = IISWINDOW( IThread::current().anchorBlock(), this->fhandle );
  }
  return valid;
#endif
#ifdef IC_WIN
  return IISWINDOW( 1, this->fhandle );
#endif
#ifdef IC_MOTIF
  return (XtIsWidget( (Widget)this->fhandle ));
#endif
}


/*------------------------------------------------------------------------------
 sendEvent - send a window system message/event to the window
 represented by this handle, using the specified parameters.
------------------------------------------------------------------------------*/
IEventResult IWindowHandle::sendEvent ( unsigned long eventId,
                                        const IEventParameter1 &parm1,
                                        const IEventParameter2 &parm2 ) const
{
#ifdef IC_PMWIN
  MRESULT rs;

  rs = ISENDMESSAGE( this->fhandle, (unsigned int) eventId, parm1, parm2 );

  return IEventResult( (int) rs ); // NEED TO ADD A LONG CONSTRUCTOR
#endif

#ifdef IC_MOTIF
  IEventResult fEventResult( 0 );
  if ( this->isValid() )
  {
     Window window = XtWindow( this->fhandle );
     if ( window )
     {
        Display *display = XtDisplay( this->fhandle );
        Atom     msgAtom = XInternAtom( display, ICLUI_MESSAGE, FALSE );
        // Construct the canned stuff needed for a client message.
        XEvent  event;
        long result = 0;

        event.xclient.display = display;
        event.xclient.window  = window;
        event.xclient.type    = ClientMessage;
        event.xclient.message_type = msgAtom;
        event.xclient.format  = 32;
        // Put in the information for this specific message.
        event.xclient.data.l[0] = eventId;
        event.xclient.data.l[1] = parm1;
        event.xclient.data.l[2] = parm2;
        event.xclient.data.l[3] = (long)(&result);
        event.xclient.data.l[4] = 0;

        if ( IWindow::windowWithHandle( this->fhandle, false ) )
        {
           // This Widget was created on this thread.
           // Calling XtDispatch is good enough.
           XtDispatchEvent( &event );
        }
        else
        {
           // Treat this as a cross-thread message send. We call
           // XSendEvent so that the GUI thread can process the event.
           long wait_upon = 1;
           event.xclient.data.l[4] = (long)(&wait_upon);
           if ( ! XSendEvent( display, window, TRUE,
                              (long)IC_XALLEVENTSMASK, &event ) )
           {
              ITHROWGUIERROR2( "XSendEvent",
                               IBaseErrorInfo::invalidParameter,
                               IException::recoverable );
           }

           // Do a semaphore-like wait, waiting on the receiver to
           // process the message to achieve intel-like behavior.
           // However, we don't expect a generic receiver to clear
           // the semaphore-like memory value. Instead we do this in
           // IOC code (e.g. iwindowXEventCallback) on behalf of the
           // receiver. As a result, we should use the semaphore-like
           // wait only if the widget has a corresponding IWindow
           // object (and IOC callback code) for it.
           if ( ! ( (Widget) this->fhandle )->core.being_destroyed  &&
                IWindow::windowWithHandle( this->fhandle, true ) )
           {
              // Flush the event queue to get a quicker result.
              XFlush( display );

              // Yield to other threads until we're done waiting.
              while ( wait_upon )
              {
                 pthread_yield();
              }
           }
        }

        // Return the result value. The IWindow XEvent callback puts the
        // result from the IEvent in this field of the XEvent.
        fEventResult = (unsigned long)result;
     }
     else
     {
        // If there is no window associated with the widget, we can't
        // send it a message. In this case we will directly call dispatch.
        IWindow *pwin = IWindow::windowWithHandle( this->fhandle );
        if ( pwin )
        {
           // Most events should not be propagated up the owner chain.
           bool passToOwner = false;
           int howFar = -1;
           switch ( eventId )
           {
              case WM_CONTROL:
                 passToOwner = true;
                 howFar = 2;
                 break;
              case WM_HELP:
              case IC_UM_MEASUREITEM:
              case IC_UM_DRAWITEM:
                 passToOwner = true;
                 howFar = -1;
                 break;
              case WM_SYSCOMMAND:
              case WM_COMMAND:
                 // Don't propagate messages with the special IOC flag.
                 if ( !(parm2 & 0x8000) )
                    passToOwner = true;
                 howFar = -1;
                 break;
              default:
                 break;
           }

           IEvent evt( pwin,
                       eventId,
                       parm1,
                       parm2 );

           // Set the event propagation information.
           evt.setPassToOwner( passToOwner );
           evt.setNumberOfLevels( howFar );

           // Dispatch the event to the window's event handlers.
           pwin->dispatch( evt );
           fEventResult = evt.result();
           switch ( eventId )
           {
              case IC_UM_PAINT:
              {
                if ( pwin->pWindowData->fInvalidatedRegion != IRegionHandle() )
                {
                   XDestroyRegion( (Region)(void *)pwin->pWindowData->fInvalidatedRegion );
                   // and free it
                   pwin->pWindowData->fInvalidatedRegion = IRegionHandle();
                }
                break;
              }
              default:
                 break;
           }
        }
     } // end XtWindow == 0
  } // end this->isValid() == true
  return fEventResult;
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
 sendEvents -  send a window system message/event to the children
 or decendents of the window represented by this handle,
 using the specified parameters.
------------------------------------------------------------------------------*/
void IWindowHandle::sendEvents ( unsigned long eventId,
         const IEventParameter1 &parm1, const IEventParameter2 &parm2,
         BroadcastTo value ) const
{
#ifdef IC_PM
   unsigned long ulCmd = BMSG_SEND;
   switch(value)
   {
     case descendants:
       ulCmd |= BMSG_DESCENDANTS;
       break;
     case frames:
       ulCmd |= BMSG_FRAMEONLY;
       break;
     default:
       ulCmd |= (BMSG_FRAMEONLY | BMSG_DESCENDANTS);
       break;
   } /* endSwitch */
   if (!WinBroadcastMsg(this->fhandle, eventId, parm1, parm2, ulCmd))
      ITHROWGUIERROR2("WinBroadcastMsg", IBaseErrorInfo::invalidParameter, IException::recoverable);
#endif
#ifdef IC_WIN
  // Enumerate windows and send the event
  CallbackParms callbackParms;
  callbackParms.fPost       = false;
  callbackParms.fEventId    = eventId;
  callbackParms.fParameter1 = parm1;
  callbackParms.fParameter2 = parm2;
  callbackParms.fValue      = value;
  switch(value)
  {
    case frames:
      EnumWindows( (WNDENUMPROC)iwindowhandleEnumCB,
                   (LPARAM)(&callbackParms));
      break;
    default:
      EnumChildWindows(this->fhandle,
                       (WNDENUMPROC)iwindowhandleEnumCB,
                       (LPARAM)(&callbackParms));
      break;
  } /* endSwitch */
#endif
#ifdef IC_MOTIF
   WidgetList   children = 0;
   Cardinal     numChildren = 0;
   int          i;

   /*---------------------------------------------------------------------------
   Find list of and number of children
   ---------------------------------------------------------------------------*/
   if ( XtIsComposite( (Widget)this->fhandle ) )
      {
      XtVaGetValues(
        (Widget) this->fhandle,
         XmNchildren, &children,
         XmNnumChildren, &numChildren,
         NULL);
      } // if

   /*---------------------------------------------------------------------------
   Loop thru children list.  Exact processing for each depends on
   the setting of the value parameter.
   ---------------------------------------------------------------------------*/
   for (i=0; i < numChildren; i++)
      {
      IWindowHandle widget( children[i] );
      switch(value)
         {
         case descendants:
           // Post the event to immediate child.  If the child
           // is a composite then handle its children recursively
           widget.sendEvent( eventId, parm1, parm2 );
           if ( XtIsComposite( (Widget) widget ) )
              widget.sendEvents( eventId, parm1, parm2, value );
           break;

         case frames:
           // If the child is a MainWindow (IFrameWindow), then
           // send the message.  Don't recurse to children.
           if ( XtIsSubclass ( (Widget) widget, xmMainWindowWidgetClass ) )
              widget.sendEvent( eventId, parm1, parm2 );
           break;

         default:
           // Post the event to immediate child if it is a
           // MainWindow (FrameWindow).  Then search all children
           // recursively for more frames.
           if ( XtIsSubclass ( (Widget) widget, xmMainWindowWidgetClass ) )
              widget.sendEvent( eventId, parm1, parm2 );
           if ( XtIsComposite( (Widget) widget ) )
              widget.sendEvents( eventId, parm1, parm2, value );
           break;
         } /* endSwitch */
      } // for
#endif
}


/*------------------------------------------------------------------------------
 postEvent - post (asynchronously)  a window system message/event to the window
 represented by this handle, using the specified parameters.
------------------------------------------------------------------------------*/
void IWindowHandle::postEvent ( unsigned long eventId,
         const IEventParameter1 &parm1, const IEventParameter2 &parm2 ) const
{
#ifdef IC_PMWIN
  MRESULT rs;


  rs = (MRESULT)IPOSTMESSAGE(this->fhandle, (unsigned int)eventId, parm1, parm2);
  if ( ! rs )
     ITHROWGUIERROR2("WinPostMsg", IBaseErrorInfo::invalidParameter, IException::recoverable);
#endif

#ifdef IC_MOTIF
  if ( eventId == IC_UM_FLUSH_POSTS )
  {
     // Only allow one shot at deferred messages for now.
     fTryToDefer = false;
     if ( fDeferredEvents )
     {
        ITRACE_DEVELOP("Sending deferred messages");
        IPostEventDeferred::Cursor cursor(*fDeferredEvents);
        for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
        {
           IPostEventLater* action = cursor.element();
           action->fHwnd.sendEvent( action->fEventId,
                                    action->fParm1,
                                    action->fParm2 );
           delete action;
        }
        delete fDeferredEvents;
        fDeferredEvents = 0;
     }
     // We have no reason to push this message through our handlers.
     return;
  }

  Window window = XtWindow( this->fhandle );
  if ( window )
  {
     Display *display = XtDisplay( this->fhandle );
     Atom     msgAtom = XInternAtom( display, ICLUI_MESSAGE, FALSE );
     // Construct the canned stuff needed for a client message.
     XEvent  event;
     event.xclient.display = display;
     event.xclient.window  = window;
     event.xclient.type    = ClientMessage;
     event.xclient.message_type = msgAtom;
     event.xclient.format  = 32;
     // Put in the information for this specific message.
     event.xclient.data.l[0] = eventId;
     event.xclient.data.l[1] = parm1;
     event.xclient.data.l[2] = parm2;
     event.xclient.data.l[3] = 0;
     event.xclient.data.l[4] = 0;
     // Place the message on the event queue.
     if ( !XSendEvent(display, window, TRUE, (long)IC_XALLEVENTSMASK, &event) )
     {
       ITHROWGUIERROR2("XSendEvent", IBaseErrorInfo::invalidParameter, IException::recoverable);
     }
     //
     // d5264
     // Add a timeout event to be sent as soon as possible, to make
     // XtAppNextEvent wake up and look at its event queue.
     //
     XtAppAddTimeOut( XtWidgetToApplicationContext (this->fhandle),
                      0,  // Time out right now.
                      (XtTimerCallbackProc) postATimeHandlerEvent,
                      0); // No client data.
  }
  else
  {
     if (fTryToDefer)
     {
       // If there is no window associated with the widget, we can't
       // send it a message. In this case we will directly call dispatch.
       if (!fDeferredEvents)
         fDeferredEvents = new IPostEventDeferred;
       IPostEventLater* fEvent =
           new IPostEventLater(this->fhandle, eventId, parm1, parm2);
       fDeferredEvents->add( fEvent );
     }
     else
       // Did the best we could. Call the dispatcher directly.
       this->sendEvent( eventId, parm1, parm2 );
  }
#endif
}

/*------------------------------------------------------------------------------
 postEvents -  post (asynchronously)  a window system message/event to
 the  children/decendents of the window represented by this handle,
 using the specified parameters.
------------------------------------------------------------------------------*/
void IWindowHandle::postEvents ( unsigned long eventId,
      const IEventParameter1 &parm1, const IEventParameter2 &parm2,
      BroadcastTo value) const
{
#ifdef IC_PM
   unsigned long ulCmd = BMSG_POST;
   switch(value)
   {
     case descendants:
       ulCmd |= BMSG_DESCENDANTS;
       break;
     case frames:
       ulCmd |= BMSG_FRAMEONLY;
       break;
     default:
       ulCmd |= (BMSG_FRAMEONLY | BMSG_DESCENDANTS);
       break;
   } /* endSwitch */

   if (!WinBroadcastMsg(this->fhandle, eventId, parm1, parm2, ulCmd))
      ITHROWGUIERROR2("WinBroadcastMsg", IBaseErrorInfo::invalidParameter, IException::recoverable);
#endif
#ifdef IC_WIN
  // Enumerate windows and post the event
  CallbackParms callbackParms;
  callbackParms.fPost       = true;
  callbackParms.fEventId    = eventId;
  callbackParms.fParameter1 = parm1;
  callbackParms.fParameter2 = parm2;
  callbackParms.fValue      = value;
  switch(value)
  {
    case frames:
      EnumWindows( (WNDENUMPROC)iwindowhandleEnumCB,
                   (LPARAM)(&callbackParms));
      break;
    default:
      EnumChildWindows(this->fhandle,
                       (WNDENUMPROC)iwindowhandleEnumCB,
                       (LPARAM)(&callbackParms));
      break;
  } /* endSwitch */
#endif
#ifdef IC_MOTIF
   WidgetList   children = 0;
   Cardinal     numChildren = 0;
   int          i;

   /*---------------------------------------------------------------------------
   Find list of and number of children
   ---------------------------------------------------------------------------*/
   if ( XtIsComposite( (Widget)this->fhandle ) )
      {
      XtVaGetValues(
        (Widget) this->fhandle,
         XmNchildren, &children,
         XmNnumChildren, &numChildren,
         NULL);
      } // if

   /*---------------------------------------------------------------------------
   Loop thru children list.  Exact processing for each depends on
   the setting of the value parameter.
   ---------------------------------------------------------------------------*/
   for (i=0; i < numChildren; i++)
      {
      IWindowHandle widget( children[i] );
      switch(value)
         {
         case descendants:
           // Post the event to immediate child.  If the child
           // is a composite then handle its children recursively
           widget.postEvent( eventId, parm1, parm2 );
           if ( XtIsComposite( (Widget) widget ) )
              widget.postEvents( eventId, parm1, parm2, value );
           break;

         case frames:
           // If the child is a MainWindow (IFrameWindow), then
           // send the message.  Don't recurse to children.
           if ( XtIsSubclass ( (Widget) widget, xmMainWindowWidgetClass ) )
              widget.postEvent( eventId, parm1, parm2 );
           break;

         default:
           // Post the event to immediate child if it is a
           // MainWindow (FrameWindow).  Then search all children
           // recursively for more frames.
           if ( XtIsSubclass ( (Widget) widget, xmMainWindowWidgetClass ) )
              widget.postEvent( eventId, parm1, parm2 );
           if ( XtIsComposite( (Widget) widget ) )
              widget.postEvents( eventId, parm1, parm2, value );
           break;
         } /* endSwitch */
      } // for
#endif
}


#ifdef IC_WIN
/*------------------------------------------------------------------------------
| iwindowhandleEnumCB                                                          |
| Callback function for EnumWindows/EnumChildWindows                           |
| Used to implement sendEvents/postEvents                                      |
------------------------------------------------------------------------------*/
BOOL CALLBACK iwindowhandleEnumCB( HWND hwnd, LPARAM callbackParms)
{
   CallbackParms* parms( (CallbackParms*)callbackParms );
   bool bSend( parms->fValue != IWindowHandle::frameDescendants );
   if ( !bSend )
      {
      // only need this if using frameDescendants
      IWindow* win = IWindow::windowWithHandle( hwnd );
      if (win && win->isFrameWindow())
         bSend = true;
      }

   // post or send to this window
   if (bSend)
      {
      if (parms->fPost)
         IPOSTMESSAGE(hwnd,
                      (unsigned int)parms->fEventId,
                      parms->fParameter1,
                      parms->fParameter2 );
      else
         ISENDMESSAGE(hwnd,
                      (unsigned int)parms->fEventId,
                      parms->fParameter1,
                      parms->fParameter2 );
      }
   return 1;      // continue enumeration
}
#endif


/*------------------------------------------------------------------------------
| IWindowHandle::asString                                                      |
------------------------------------------------------------------------------*/
IString IWindowHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IWindowHandle::asDebugInfo                                                   |
------------------------------------------------------------------------------*/
IString IWindowHandle::asDebugInfo ( ) const
{
  IString result( "IWindowHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}


/*------------------------------------------------------------------------------
| IStringHandle::asString                                                      |
------------------------------------------------------------------------------*/
IString IStringHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IStringHandle::asDebugInfo                                                   |
------------------------------------------------------------------------------*/
IString IStringHandle::asDebugInfo ( ) const
{
  IString result( "IStringHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}


/*------------------------------------------------------------------------------
| IProfileHandle::asString                                                     |
------------------------------------------------------------------------------*/
IString IProfileHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IProfileHandle::asDebugInfo                                                  |
------------------------------------------------------------------------------*/
IString IProfileHandle::asDebugInfo ( ) const
{
  IString result( "IProfileHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}

/*------------------------------------------------------------------------------
| IMessageQueueHandle::asString                                                |
------------------------------------------------------------------------------*/
IString IMessageQueueHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IMessageQueueHandle::asDebugInfo                                             |
------------------------------------------------------------------------------*/
IString IMessageQueueHandle::asDebugInfo ( ) const
{
  IString result( "IMessageQueueHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}

/*------------------------------------------------------------------------------
 postEvent - post (asynchronously)  a window system message/event to this
 message queue , using the specified parameters.
------------------------------------------------------------------------------*/
void IMessageQueueHandle::postEvent  ( unsigned long eventId,
         const IEventParameter1 &parm1, const IEventParameter2 &parm2) const
{
   IMessageQueueHandle::postEvent( *this, eventId, parm1, parm2 );
}
/*------------------------------------------------------------------------------
 postEvent - post (asynchronously)  a window system message/event to the
 specified message queue fhandle, using the specified parameters.
------------------------------------------------------------------------------*/
void IMessageQueueHandle::postEvent  ( const IMessageQueueHandle& handle,
         unsigned long eventId, const IEventParameter1 &parm1,
         const IEventParameter2 &parm2)
{
#ifdef IC_PMWIN
   if (!IPOSTQUEUEMESSAGE(handle.asUnsigned(), eventId, parm1, parm2))
      ITHROWGUIERROR2("WinPostQueueMsg", IBaseErrorInfo::invalidParameter, IException::recoverable);
#endif
#ifdef IC_MOTIF
   IThread thread( IThreadId((unsigned long)handle.fhandle) );
   thread.postEvent( eventId, parm1, parm2);
#endif
}

/*------------------------------------------------------------------------------
 postEvent - post (asynchronously)  a window system message/event to
 all threads that have a message queue, using the specified parameters.
------------------------------------------------------------------------------*/
void IMessageQueueHandle::postEvents ( unsigned long eventId,
      const IEventParameter1 &parm1, const IEventParameter2 &parm2)
{
   IThread::postEvents( eventId, parm1, parm2);
}

/*------------------------------------------------------------------------------
| IAccelTblHandle::asString                                                    |
------------------------------------------------------------------------------*/
IString IAccelTblHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IAccelTblHandle::asDebugInfo                                                 |
------------------------------------------------------------------------------*/
IString IAccelTblHandle::asDebugInfo ( ) const
{
  IString result( "IAccelTblHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}


#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IDisplayHandle::asString                                                     |
------------------------------------------------------------------------------*/
IString IDisplayHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IDisplayHandle::asDebugInfo                                                  |
------------------------------------------------------------------------------*/
IString IDisplayHandle::asDebugInfo ( ) const
{
  IString result( "IDisplayHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}

#endif

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMenuHandle::asString                                                        |
------------------------------------------------------------------------------*/
IString IMenuHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IMenuHandle::asDebugInfo                                                     |
------------------------------------------------------------------------------*/
IString IMenuHandle::asDebugInfo ( ) const
{
  IString result( "IMenuHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}

#endif // IC_WIN

#pragma info(noext)

