// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 50 1.5.2.2 source/ui/baseapp/iguinotf.cpp, thread, ioc.v400, 001006 

#ifndef TEST_OLD_JUNO
#include <ithread.hpp>
#else
#define private public
#include <ithread.hpp>
#undef private
#endif

#include <iguinotf.hpp>
#include <ireqproc.hpp>
#include <iobjwin.hpp>
#include <ithread.hpp>
#include <ihandler.hpp>

#ifdef IC_MOTIF
#include <ixdc.hpp>
#endif

#ifdef TEST_REQPROC
#ifndef _IDSKTPPL_H
#include <idsktppl.hpp>
#endif
#endif //TEST_REQPROC

// Segment definitions.
#ifdef IC_PAGETUNE
    #define _IGUINOTF_CPP_
    #include <ipagetun.h>
#endif

class ServiceHandler;

//-----------------------------------------------------
#pragma enum(4)
#pragma pack(push,4)

class IGUIObserver : public IRequestQueueObserver {
public:

    IGUIObserver();
    virtual ~IGUIObserver();
    virtual void ObserveNewRequest( const IRequest& theRequest );   //Override

private:

    IGUIObserver(const IGUIObserver &copy) {};
    IGUIObserver & operator = (const IGUIObserver &copy) { return *this; };

    IThread             fQueueThread;
    IObjectWindow*      fObjWin;
    ServiceHandler*     fServiceHandler;
};

//-----------------------------------------------------

class ServiceHandler : public IHandler {
public:

//    static const IEventParameter1&   kNotificationEvent;

    ServiceHandler ( IObjectWindow* objWin );
    virtual bool    dispatchHandlerEvent ( IEvent &event );
    void            SetRequestHandler ( IRequestHandler* handler );

private:
     IRequestHandler*    fHandler;
};

#pragma pack(pop)
#pragma enum(pop)

//-----------------------------------------------------

IGUIObserver::IGUIObserver() :
    fQueueThread( IThread::current() )
{
    // Insure object window is not bound to message queue, because we delete
    // it after message queue termination.
    fObjWin = new IObjectWindow( IObjectWindow::noStyle );
    fServiceHandler = new ServiceHandler( fObjWin );
}


IGUIObserver::~IGUIObserver()
{
    delete fObjWin;
    delete fServiceHandler;
}


void
IGUIObserver::ObserveNewRequest( const IRequest& theRequest )   //Override
{
#ifndef TEST_OLD_JUNO
    if ( fQueueThread.isProcessingMsgs() ) {
#else
    if ( fQueueThread.inMsgLoop() ) {
#endif
        fServiceHandler->SetRequestHandler( handler() );
        fObjWin->postEvent( IWindow::command,
                            IEventParameter1( 501 ),
                            IEventParameter2( 0 ) );

				#ifdef IC_MOTIF
        XFlush(IXDisplay::display());
        #endif
    }
}


//-----------------------------------------------------

//IEventParameter1 gRealEventParameter1( 501 );
//const IEventParameter1& ServiceHandler::kNotificationEvent = gRealEventParameter1;

ServiceHandler::ServiceHandler ( IObjectWindow* objWin )
    : fHandler( NULL )
{
    handleEventsFor( objWin );
}

bool
ServiceHandler::dispatchHandlerEvent ( IEvent &event )
{
    if ( fHandler != NULL )
        if ( event.parameter1() == 501 ) {
            fHandler->DispatchNextPendingRequest();
            return true;
        }
    return false;
}

void
ServiceHandler::SetRequestHandler ( IRequestHandler* handler )
{
    fHandler = handler;
}

//-----------------------------------------------------

void
IGUINotification::initialize ()
{
    delete IRequestQueue::SetDefaultRequestQueueObserver( new IGUIObserver() );
}

void
IGUINotification::exit ()
{
    delete IRequestQueue::SetDefaultRequestQueueObserver( NULL );
}

