// Revision: 49 1.6.2.2 source/ui/baseapp/iftdpriv.hpp, font, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IFTDPRIV_
#define _IFTDPRIV_
/*******************************************************************************
* FILE NAME: iftdpriv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration(s) of the class(es):                    *
*     IFontDialogSettingsData                                                  *
*     IFontDlgCommandHandler                                                   *
*     IFontDlgSelectHandler                                                    *
*     IFontDialogData                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997 All Rights Reserved               *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
* $Log$                                                                        *
*******************************************************************************/
#include <ibase.hpp>
#include <icombobx.hpp>
#include <icmdhdr.hpp>
#include <ifontprv.hpp>
#include <imcelcv.hpp>
#include <ipushbut.hpp>
#include <iselhdr.hpp>
#include <iedithdr.hpp>
#include <isetcv.hpp>
#include <istattxt.hpp>
#include <istring.hpp>
#include <irel.h>
#include <iss2.h>

#ifdef IC_MOTIF
#include <ixlfdstr.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)


// Collection to hold the list of fonts returned by the system.  IRelation
// is fastest (we don't need sorted because we can sort when we add the much
// smaller list to the combo box).
typedef IRelation<IXLFDString*, IString> IFontSetDLG;
IString const& key(IXLFDString* const f);


// Collection to hold the list of point sizes for each type of font.
typedef ISortedSet<int> IPointSizeSet;

// Required key function for the IFontSet class.
//IString const& key (IXLFDString* const& f)
//{
//   return f->keyName();
//}

class IFontDialogSettingsData  {
/*******************************************************************************
* Private data for font dialog settings class.                                 *
*******************************************************************************/
public:
IFontDialogSettingsData( IFont * font = 0);
IFontDialogSettingsData( const IFontDialogSettingsData& another );
~IFontDialogSettingsData();
IFontDialogSettingsData
   &operator=          ( const IFontDialogSettingsData& another );

IFontDialogSettingsData
   &setFont( IFont* font );

   IFont           *papplyFont;            /* font supplied on ctor           */
   IPresSpaceHandle hpsScreen;             /* Screen presentation space       */
   IPresSpaceHandle hpsPrinter;            /* Printer presentation space      */
   IString          title;                 /* Application supplied title      */
   IString          previewText;           /* String to print in preview wndw */
   IString          ptSizeList;            /* Application provided size list  */
   IPoint           position;              /* position of dialog */
   unsigned long    fl;                    /* FNTS_* flags - dialog styles    */
   IFontPrivateData fontData;              /* font data                       */
   IString          familyName;            /* selected family name            */
};   // IFontDialogSettingsData


class IFontDlgCommandHandler : public ICommandHandler {
/*******************************************************************************
* This handler processes the button pressed events from the font dialog        *
* buttons.                                                                     *
*******************************************************************************/
  typedef ICommandHandler Inherited;
public:
  IFontDlgCommandHandler( IFontDialogData * fd ) : dlgData(fd) {};
  ~IFontDlgCommandHandler( ) {};
virtual bool
  command     ( ICommandEvent       &event  );

private:
  IFontDialogData  *dlgData;
};    // IFontDlgCommandHandler


class IFontDlgSelectHandler : public ISelectHandler {
/*******************************************************************************
* This handler processes the selection events from the font selection box      *
* in the font dialog.                                                          *
*******************************************************************************/
  typedef ISelectHandler Inherited;
public:
  IFontDlgSelectHandler( IFontDialogData * fd ) : dlgData(fd) {};
  ~IFontDlgSelectHandler( ) {};
virtual bool
  enter        ( IControlEvent& event ),
  selected     ( IControlEvent       &event  );

private:
  IFontDialogData  *dlgData;
};    // IFontDlgSelectHandler

class IFontDlgEditHandler : public IEditHandler {
/*******************************************************************************
* This handler processes the selection events from the font selection box      *
* in the font dialog.                                                          *
*******************************************************************************/
  typedef IEditHandler Inherited;
public:
  IFontDlgEditHandler( IFontDialogData * fd ) : dlgData(fd) {};
  ~IFontDlgEditHandler( ) {};
virtual bool
  edit        ( IControlEvent& event );

private:
  IFontDialogData  *dlgData;
};    // IFontDlgEditHandler

class IFontDialogData  {
/*******************************************************************************
* This class is the private data area for the IFontDialog Motif implementation *
*                                                                              *
*******************************************************************************/
public:
  IFontDialogData( IFontDialog* fd,
                          IFontDialog::Style style,
                          const IFontDialogSettingsData& settingsData );
  ~IFontDialogData();

char
  **fontNameList();
int
  fontNameListSize() const {return nameEntries; };
IFontPrivateData
  &fontData()               {return settings.fontData;};
IFont
  *applyFont()              {return settings.papplyFont; };
IFontDialogData
  &apply(),
  &refresh(),
  &reset(),
  &setSelectedItem(),
  &sizeSelected(),
  &styleSelected();

// member data
      IFontDialog            *frame;        // pointer to real object
      IFontDialogSettingsData settings;     // settings structure
      IFontPrivateData       *resetFontData; // reset font
      long                    returnVal;    // return value
      IMultiCellCanvas        cv;           // canvas for whole dialog
      IStaticText             selectionLabel; // selectin box label
      IComboBox               selectionBox; // selection box
      IStaticText             preview;      // preview area
      IStaticText             pointSelectionLabel; // point selection box
      IStaticText             styleLabel;   // style box label
      IComboBox               pointSizeSel; // point size
      ISetCanvas              buttoncv;     // button canvas
      IComboBox               styleBox;     // font style selection box
      IPushButton            *okButton;     // OK button
      IPushButton            *cancelButton; // cancel button
      IPushButton            *applyButton;  // apply button
      IPushButton            *resetButton;  // reset button
      IPushButton            *helpButton;   // help button
      IFontDlgCommandHandler  cmdhdr;       // command handler for buttons
      IFontDlgSelectHandler   selhdr;       // selection handler
      IFontDlgEditHandler     edithdr;       // edit handler
      char                  **nameList;     // results of XFontList
      IFontSetDLG*            fontSet;      // collection of fonts
      bool                    firstTime;    // we need to know first time through
      bool                    needBold;     // is initial font bold
      bool                    needBoldItalic; // is initial font bold/italic
      bool                    needItalic;   // is initial font italic
      int                     nameEntries;  // how many fonts did we get
      unsigned long           firstPointSize; // point size of initial font
      int                     selectedResetItem; // font to reset to if they
      int                     selectedStyleResetItem; // style to reset to if they
      int                     selectedSizeResetItem; // size to reset to if they
                                                 // press the reset button
      bool                    resetRequested; // flag to know if reset was requested
      IFontDialog::Style      fstyle;    // saved dialog style flags
private:

  IFontDialogData(const IFontDialogData& );
IFontDialogData
  &operator=            (const IFontDialogData& );

}; //IFontDialogData


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif //IC_MOTIF

#endif // _IFTDPRIV_
