// Revision: 48 1.23.2.3 source/ui/baseapp/iframprv.hpp, frame, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IFRAMPRV_
  #define _IFRAMPRV_
/*******************************************************************************
* FILE NAME: iframprv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFrameWindowData                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifdef IC_WIN
extern "C"
{
  #include <iwindefs.h>
}
#endif

#include <ibase.hpp>
#include <iframhdr.hpp>
#include <icvhdr.hpp>
#include <ihandle.hpp>
#include <iperthr.hpp>
#include <irect.hpp>
#include <istring.hpp>
#include <iwindow.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IArgList;
class IColorMapHandler;
class IFrameExtensions;
class IFrameWindowDeferred;
class IMenuBar;
class ITimer;
class IToolBarList;

#pragma enum(4)
#pragma pack(push,4)

class IFrameWindowThreadData {
/*------------------------------------------------------------------------------
| Class IFrameWindowThreadData is thread local storage for IFrameWindow.       |
------------------------------------------------------------------------------*/
public:
  IFrameWindowThreadData ( )
    : fNesting(0)
    { }
unsigned long
  fNesting;       // modal nesting counter
}; // IFrameWindowThreadData

class IFrameWindowData {
/*------------------------------------------------------------------------------
| Class IFrameWindowData is private data class for IFrameWindow.               |
------------------------------------------------------------------------------*/
public:

/*-------------------------------- Functions ---------------------------------*/
  IFrameWindowData ( unsigned flags );
 ~IFrameWindowData ( );

// calcFrameRect performs conversion between a window rectangle and
// the window's client area rectangle.  The frameToClient argument controls
// which way the conversion is done.  If true, the input rectangle is
// the frame window rectangle, if false the rectangle is the client
// rectangle.  Similar in function to PM WinCalcFrameRect.
bool
  calcFrameRect ( IWindowHandle hwnd,
                  IRectangle   &rect,
                  bool          frameToClient );

#ifdef IC_MOTIFWIN
void
  createScrollBar ( IWindowHandle hwnd,
                    unsigned long style );
#endif // IC_MOTIFWIN

#ifdef IC_WIN
void
  timerExpired ( unsigned long timerId );  // flashes ftimerHwnd
#endif //IC_WIN

#ifdef IC_MOTIF
IMenuBar
 *menuBar ( );
// Register and unregister callbacks.
void
  registerCallbacks   ( ),
  unregisterCallbacks ( IFrameWindow* frame );
#endif //IC_MOTIF

/*----------------------------------- Data -----------------------------------*/
IFrameExtensions
 *pExtensions;
unsigned
  flags;
unsigned long
  rc;

bool
  isChild;
IPointerHandle
  frameIcon;
IToolBarList
 *toolBarList;
void
 *fpHelpList;
IWindowHandle
  fDefaultPushButton,
  fDefaultEmphasisButton;

IColorMapHandler
 *fColorMapHandler;

bool
  bMinFrameSizeSet,
  bMaxFrameSizeSet;
ISize
  minimumFrameSize,
  maximumFrameSize;

IFrameHandler
  fdefaultHandler;

#ifdef IC_MOTIFWIN
IRectangle
  logicalClientRect;    // Client rectangle.
// Member for showModally.
unsigned long
  fModalNesting;        // Value of fgThreadData.fNesting when showModally done.

#endif
#ifdef IC_WIN
void
 *fpSubmenuList;

// Members to implement flashing.
ITimer
 *ftimer;                                  // a timer
IWindowHandle
  ftimerHwnd;                              // window to flash

// Members to implement setting title bar font.
HFONT
  fhFont;               // Font handle for title bar (== 0 if default).

IWindowHandle
  fLastFocus;           // Last focus window when deactivated.
#endif   //IC_WIN

#ifdef IC_MOTIFWIN
ICVKeyboardHandler
  fKeyboardHandler;     // Handler for dialog navigation.
#endif

#ifdef IC_MOTIF
IMenuBar
 *frameMenu;
IWindowHandle
  shell;
IWindowHandle
  mainW;
IWindowHandle
  motifClient;
IWindowHandle
  parentForChildren;
IArgList
 *fModalSavedResources;
IFrameWindowDeferred
 *fDeferredActions;
#endif //IC_MOTIF

/*------------------------------- Static Data --------------------------------*/

static const unsigned
#ifdef IC_MOTIFWIN
  needsClientSized,
#endif
#ifdef IC_WIN
  enableOwner,          // Enable owner on modal dismiss.
  beingSized,
  inTitlePaint,         // Painting title.
  dlgInitialized,
#endif
#ifdef IC_MOTIF
  minimized,
  maximized,
#endif
  destroyOnClose,
  hasDefaultHandler,
  modal,
  needsUpdating,
  fromDlgTemplate,
  standardFrame,
  hasBeenClosed,
  modalAutoDelete;      // Support auto-delete object for modal frames.

// Number of showModally calls active for this thread.
#ifdef IC_PM
static IThreadLocalStorage<IFrameWindowThreadData>
  fgThreadData;
#endif

static IWindow::DataHandle     // for IFrameWindow
  fClassDataHandle;

#ifdef IC_MOTIFWIN
static IRectangle
  fgNextRect;           // Next value for nextShellRect.
#endif //IC_MOTIFWIN

#ifdef IC_WIN
static unsigned long
  fgClassID;            // Next ID word for Frame window class.
#endif //IC_WIN

#ifdef IC_PM
bool
  disableBidiChildUpdate;
#endif

#ifdef IC_MOTIF
static unsigned long
  wmDeleteWindow,
  wmSaveYourself,
  wmTakeFocus;
#endif

private:
  IFrameWindowData ( const IFrameWindowData& );
IFrameWindowData
 &operator=        ( const IFrameWindowData& );
}; // IFrameWindowData

class IFrameWindowChildData : public IWindowData {
typedef IWindowData
  Inherited;
/*******************************************************************************
* This class is used to store data with the child windows of a frame.     *
* IFrameWindow uses this data for extension and client managment.              *
*******************************************************************************/
public:
  IFrameWindowChildData ( IWindow* child );
virtual
 ~IFrameWindowChildData ( );

IFrameWindowChildData
 &saveWindowSettings    ( ),
 &restoreWindowSettings ( );

private:
enum ChildSettings {
  eValid   = 1,
  eVisible = 2,
  eEnabled = 4
};
unsigned long
  fchildSettings;
IWindow
 *fchild;
}; // IFrameWindowChildData

#ifdef IC_MOTIF
class IFrameWindowDeferredAction {
//******************************************************************************
// This class represents an action which has been deferred.  Typically, this
// is needed when an action is requested which will not work correctly until
// the frame window is shown.
//******************************************************************************
public:
  // Request that the specified frame be shown.
  IFrameWindowDeferredAction ( long frameToShow );  //ekim
  // Request a moveSizeToClient to the specified rectangle.
  IFrameWindowDeferredAction ( const IRectangle& clientRectangle );
  // Dtor (required).
 ~IFrameWindowDeferredAction ( );

  // Process the action.
bool
  applyTo ( IFrameWindow* frame );

private:
  // Copy ctor and assignment (not allowed).
  IFrameWindowDeferredAction ( const IFrameWindowDeferredAction& another );
IFrameWindowDeferredAction
 &operator=                  ( const IFrameWindowDeferredAction& another );

// Type of action
// NOTE: Consider making this a base class and applyTo a virtual function if
//       this enum gets too big.
enum EAction {
  kShow,               // Show the specified frame, with this frame as parent.
  kMoveSizeToClient    // Process moveSizeToClient for this frame.
};
EAction
  faction;
void
 *fdata;
}; // IFrameWindowDeferredAction
#endif  //IC_MOTIF

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IFRAMPRV_
