// Revision: 36 1.58.3.8 source/ui/baseapp/iframe.cpp, frame, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: iframe.cpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iframe.hpp.                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

extern "C"
{
  #define INCL_WIN
  #define INCL_NLS
  #define INCL_DOSNLS
  #define INCL_SHLERRORS
  #include <iwindefs.h>
  #ifdef IC_MOTIF
    #include <Xm/Xm.h>
    #include <Xm/MainW.h>
    #include <Xm/MwmUtil.h>
    #include <Xm/BulletinB.h>
    #include <Xm/Form.h>
    #include <Xm/ScrollBar.h>
    #include <Xm/Separator.h>
    #include <Xm/DialogS.h>
    #include <X11/Shell.h>
    #include <Xm/AtomMgr.h>
    #include <Xm/Protocols.h>
    #include <X11/Xmu/Editres.h>
    #include <canvas.h>
    #include <X11/cursorfont.h>
  #endif
}

#include <iframe.hpp>
#include <iaccel.hpp>
#include <ibidiset.hpp>
#include <icconst.h>
#include <icmaphdr.hpp>
#include <icolor.hpp>
#include <icoordsy.hpp>
#include <icvhdr.hpp>
#include <idefstyl.h>
#include <iexcept.hpp>
#include <ifont.hpp>
#include <iframevt.hpp>
#include <iframext.hpp>
#include <iframhdr.hpp>
#include <iframprv.hpp>
#include <imenubar.hpp>
#include <imenuprv.hpp>
#include <inotifev.hpp>
#include <iplatfrm.hpp>
#include <iprocadr.hpp>
#include <irecohdr.hpp>
#include <irect.hpp>
#include <iscroll.hpp>
#include <istring.hpp>
#include <iswp.hpp>
#include <isysmenu.hpp>
#include <itbpriv.hpp>
#include <ithread.hpp>
#include <ithreadp.hpp>
#include <itimer.hpp>
#include <ititle.hpp>
#include <itrace.hpp>
#include <iwcname.hpp>
#ifdef IC_WIN
  #include <icctlsta.hpp>
#endif
#ifdef IC_MOTIF
  #include <iarglist.hpp>
  #include <ibmpstat.hpp>
  #include <iseq2.h>
  #include <ixdc.hpp>
  #include <iwinlsts.hpp>
#endif

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IFRAME_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
Widget fTopLevelShell = 0;
#endif

#ifdef IC_WIN
extern unsigned long propagationInProgress;
#endif
#ifdef IC_MOTIF
class IFrameWindowDeferred : public IVPtrSequence<IFrameWindowDeferredAction*> {
};
#endif

/*------------------------------------------------------------------------------
| Static style definitions.                                                    |
|                                                                              |
| These values exploit the specific values used for the PM toolkit             |
| WS_* and FS_* values.  Frame creation must support the "flags"               |
| corresponding to the WS_* values (except for certain flags that              |
| don't apply to frames), the FS_* values (except for certain flags that       |
| only apply to dialogs loaded from resource templates), and additional        |
| "attributes" corresponding to the particular FCF_* values for which there    |
| is no corresponding FS_* value.                                              |
|                                                                              |
| The FS_ and WS_ flags are placed in the lower DWORD, whereas the FCF_        |
| flags are placed in the low order word of the upper DWORD.                   |
| to their normal values.  All of the flags are documented below for clarity.  |
------------------------------------------------------------------------------*/
const IFrameWindow::Style
  IFrameWindow::deferCreation      ( 1, IFrameWindow__deferCreation ),
  IFrameWindow::accelerator        ( 1, IFrameWindow__accelerator),
  IFrameWindow::menuBar            ( 1, IFrameWindow__menuBar),
  IFrameWindow::minimizedIcon      ( 1, IFrameWindow__minimizedIcon),
  IFrameWindow::alignNoAdjust      ( 1, IFrameWindow__alignNoAdjust),
  IFrameWindow::shellPosition      ( 1, IFrameWindow__shellPosition),
  IFrameWindow::dialogBackground   ( 1, IFrameWindow__dialogBackground),
  IFrameWindow::animated           ( 1, IFrameWindow__animated),
  IFrameWindow::appDBCSStatus      ( 1, IFrameWindow__appDBCSStatus),
  IFrameWindow::noMoveWithOwner    ( 1, IFrameWindow__noMoveWithOwner),
  IFrameWindow::systemModal        ( 1, IFrameWindow__systemModal),
  IFrameWindow::windowList         ( 1, IFrameWindow__windowList),
#ifdef IC_WIN
  IFrameWindow::titleBar           ( 2, IFrameWindow__titleBar),
#endif
#ifdef IC_MOTIFPM
  IFrameWindow::titleBar           ( 1, IFrameWindow__titleBar),
#endif
  IFrameWindow::maximizeButton     ( 1, IFrameWindow__maximizeButton),
  IFrameWindow::minimizeButton     ( 1, IFrameWindow__minimizeButton),
  IFrameWindow::hideButton         ( 1, IFrameWindow__hideButton),
  IFrameWindow::sizingBorder       ( 1, IFrameWindow__sizingBorder),
  IFrameWindow::systemMenu         ( 1, IFrameWindow__systemMenu),
  IFrameWindow::horizontalScroll   ( 1, IFrameWindow__horizontalScroll),
  IFrameWindow::verticalScroll     ( 1, IFrameWindow__verticalScroll),
  IFrameWindow::dialogBorder       ( 1, IFrameWindow__dialogBorder),
  IFrameWindow::border             ( 1, IFrameWindow__border),
  IFrameWindow::maximized          ( 1, IFrameWindow__maximized),
  IFrameWindow::minimized          ( 1, IFrameWindow__minimized),
#ifdef IC_PM
  IFrameWindow::classDefaultStyle  ( 7, IFrameWindow__classDefaultStyle);
#endif
#ifdef IC_WIN
  IFrameWindow::classDefaultStyle  ( 7, IFrameWindow__classDefaultStyle);
#endif
#ifdef IC_MOTIF
  IFrameWindow::classDefaultStyle  ( 6, IFrameWindow__classDefaultStyle);
#endif
    // styleBits is mask with just the style bits "on":
//  IFrameWindow::styleBits          ( sizeof(IFrameWindow__styleBits),
//                                     IFrameWindow__styleBits);

/*------------------------------------------------------------------------------
| Default style for new objects (initial value).                               |
------------------------------------------------------------------------------*/
#ifdef IC_MOTIFWIN
IRectangle
  IFrameWindowData::fgNextRect(0,0,0,0); // Next value for nextShellRect
#endif

#ifdef IC_WIN
unsigned long
  IFrameWindowData::fgClassID = 0;       // Next ID word for Frame window class
#endif

#ifdef IC_MOTIF
unsigned long
  IFrameWindowData::wmDeleteWindow=0,
  IFrameWindowData::wmSaveYourself=0,
  IFrameWindowData::wmTakeFocus=0;
#endif

IFrameWindow::Style
  IFrameWindow::currentDefault ( 7, IFrameWindow__classDefaultStyle );

IWindow::SiblingOrder
  IFrameWindow::siblingCreateOrder = IWindow::onTopOfSiblings;

IWindow::DataHandle
  IFrameWindowData::fClassDataHandle ( 0 );

#ifdef IC_PM
IThreadLocalStorage<IFrameWindowThreadData>
  IFrameWindowData::fgThreadData(true);
#endif //IC_PM


#ifdef IC_WIN
extern "C" {
extern LRESULT CALLBACK _pfnwpICDlgProc ( HWND, UINT, WPARAM, LPARAM );
}
#endif  // IC_WIN


/*------------------------------------------------------------------------------
| Static IFrameWindow members                                                  |
------------------------------------------------------------------------------*/
const unsigned
#ifdef IC_MOTIFWIN
  IFrameWindowData::needsClientSized  = 0x00000080,
#endif
#ifdef IC_WIN
  IFrameWindowData::enableOwner       = 0x00000200,
  IFrameWindowData::beingSized        = 0x00000000,    //unused, reserved
  IFrameWindowData::inTitlePaint      = 0x00001000,
  IFrameWindowData::dlgInitialized    = 0x00002000,
#endif
#ifdef IC_MOTIF
  IFrameWindowData::minimized         = 0x00000200,
  IFrameWindowData::maximized         = 0x00000400,
#endif
  IFrameWindowData::destroyOnClose    = 0x00000001,
  IFrameWindowData::hasDefaultHandler = 0x00000002,
  IFrameWindowData::modal             = 0x00000004,
  IFrameWindowData::needsUpdating     = 0x00000008,
  IFrameWindowData::fromDlgTemplate   = 0x00000010,
  IFrameWindowData::standardFrame     = 0x00000020,
  IFrameWindowData::hasBeenClosed     = 0x00000040,
  IFrameWindowData::modalAutoDelete   = 0x00000800;

/*------------------------------------------------------------------------------
| IFrameWindowData::IFrameWindowData                                           |
|                                                                              |
| This class contains the frame window data pointers.                          |
------------------------------------------------------------------------------*/
IFrameWindowData::IFrameWindowData ( unsigned flags )
  : pExtensions (0)
  , flags(flags)
  , rc( DID_CANCEL )      // default result
  , frameIcon(0)
  , toolBarList(0)
  , fpHelpList(0)
  , fDefaultPushButton(0)
  , fDefaultEmphasisButton(0)
  , fColorMapHandler(0)
#ifdef IC_WIN
  , logicalClientRect( )
  , fpSubmenuList(0)
  , ftimer(0)
  , ftimerHwnd(0)
  , fhFont(0)
  , fModalNesting(0)
  , fLastFocus(0)
  , fKeyboardHandler( )
#endif
#ifdef IC_PM
  , disableBidiChildUpdate(false)
#endif
#ifdef IC_MOTIF
  , frameMenu( 0 )
  , shell(0)
  , mainW(0)
  , motifClient(0)
  , fModalSavedResources(0)
  , fDeferredActions(0)
#endif
  , bMinFrameSizeSet(false)
  , bMaxFrameSizeSet(false)
  , minimumFrameSize()
  , maximumFrameSize()
  , fdefaultHandler()
{
  if (!fClassDataHandle)
    fClassDataHandle = IWindow::dataHandleWithKey( "IFrameWindowChildData" );
}

/*------------------------------------------------------------------------------
| IFrameWindowData::~IFrameWindowData                                          |
|                                                                              |
| Destructor here for page tuning.                                             |
------------------------------------------------------------------------------*/
IFrameWindowData::~IFrameWindowData ( )
{ }

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFrameWindowData::menuBar                                                    |
------------------------------------------------------------------------------*/
IMenuBar* IFrameWindowData::menuBar ()
{
  if (frameMenu)
    return (frameMenu);
  else
    return (NULL);
}
#endif

/*------------------------------------------------------------------------------
| IFrameWindow::IFrameWindow                                                   |
|                                                                              |
| Constructor to create a frame window object:                                 |
| - from a dialog template,                                                    |
| - by creating a plain PM frame window with the default frame styles, or      |
| - from a dialog template, and if not found, by creating a plain PM frame     |
|   window with the default frame styles.                                      |
------------------------------------------------------------------------------*/
IFrameWindow::IFrameWindow ( unsigned long id,
                             FrameSource   source )
  : IWindow( ),
    fFrameWindowData(new IFrameWindowData(IFrameWindowData::destroyOnClose))
{
  this -> tryToLoadDialog( IResourceId( id ), 0, 0, source );
}

/*------------------------------------------------------------------------------
| IFrameWindow::IFrameWindow                                                   |
|                                                                              |
| Constructor to create a frame window object:                                 |
| - from a dialog template,                                                    |
| - by creating a plain PM frame window with the default frame styles, or      |
| - from a dialog template, and if not found, by creating a plain PM frame     |
|   window with the default frame styles.                                      |
------------------------------------------------------------------------------*/
IFrameWindow::IFrameWindow ( const IResourceId &resId,
                             IWindow           *owner,
                             FrameSource        source )
  : IWindow( ),
    fFrameWindowData(new IFrameWindowData(IFrameWindowData::destroyOnClose))
{
  this -> tryToLoadDialog( resId, 0, owner, source );

}

/*------------------------------------------------------------------------------
| IFrameWindow::IFrameWindow                                                   |
|                                                                              |
| Constructor to create a frame window object:                                 |
| - from a dialog template,                                                    |
| - by creating a plain PM frame window with the default frame styles, or      |
| - from a dialog template, and if not found, by creating a plain PM frame     |
|   window with the default frame styles.                                      |
------------------------------------------------------------------------------*/
IFrameWindow::IFrameWindow ( const IResourceId &resId,
                             IWindow           *parent,
                             IWindow           *owner,
                             FrameSource        source )
  : IWindow( ),
    fFrameWindowData(new IFrameWindowData(IFrameWindowData::destroyOnClose))
{
  this -> tryToLoadDialog( resId, parent, owner, source );

}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IFrameWindow::IFrameWindow                                                   |
|                                                                              |
| Constructor to instantiate a frame window object from an existing window.    |
------------------------------------------------------------------------------*/
IFrameWindow::IFrameWindow ( const IWindowHandle &hwnd )
  : IWindow( ),
    fFrameWindowData(new IFrameWindowData(IFrameWindowData::destroyOnClose))
{
  this -> setAutoDestroyWindow ( false );
  this -> start( hwnd );

}
#endif

/*------------------------------------------------------------------------------
| IFrameWindow::IFrameWindow                                                   |
|                                                                              |
| Constructor to create a frame window object using styles and a given         |
| resource id.                                                                 |
------------------------------------------------------------------------------*/
IFrameWindow::IFrameWindow ( const IResourceId         &resId,
                             const IFrameWindow::Style &style )
  : IWindow( ),
    fFrameWindowData(new IFrameWindowData(IFrameWindowData::destroyOnClose))
{
  // When the frame window rectangle is allowed to default, we use
  // the system recommended position without coordinate conversion.
  // This is so that resizing the frame will work as expected with the
  // application implemented in application coordinates.  To implement this
  // we convert the application coordinates returned by nextShellRect
  // back to native before calling initialize.
  IRectangle initRect = nextShellRect();
  if ( ICoordinateSystem::isConversionNeeded() )
     initRect = ICoordinateSystem::convertToNative( initRect,
                                                    desktopWindow()->size() );
  this -> initialize( resId, style, 0, 0, initRect );

}

/*------------------------------------------------------------------------------
| IFrameWindow::IFrameWindow                                                   |
|                                                                              |
| Constructor to create a frame window object using styles and a given         |
| resource id.                                                                 |
------------------------------------------------------------------------------*/
IFrameWindow::IFrameWindow ( const IFrameWindow::Style &style,
                             const IResourceId         &resId )
  : IWindow( ),
    fFrameWindowData(new IFrameWindowData(IFrameWindowData::destroyOnClose))
{
  // When the frame window rectangle is allowed to default, we use
  // the system recommended position without coordinate conversion.
  // This is so that resizing the frame will work as expected with the
  // application implemented in application coordinates.  To implement this
  // we convert the application coordinates returned by nextShellRect
  // back to native before calling initialize.
  IRectangle initRect = nextShellRect();
  if ( ICoordinateSystem::isConversionNeeded() )
     initRect = ICoordinateSystem::convertToNative( initRect,
                                                    desktopWindow()->size() );
  this -> initialize( resId, style, 0, 0, initRect );

}

/*------------------------------------------------------------------------------
| IFrameWindow::IFrameWindow                                                   |
|                                                                              |
| Constructor to create a frame window object using the given title, resource  |
| id, and style.                                                               |
------------------------------------------------------------------------------*/
IFrameWindow::IFrameWindow ( const char                *title,
                             const IResourceId         &resId,
                             const IFrameWindow::Style &style )
  : IWindow( ),
    fFrameWindowData(new IFrameWindowData(IFrameWindowData::destroyOnClose))
{
  // When the frame window rectangle is allowed to default, we use
  // the system recommended position without coordinate conversion.
  // This is so that resizing the frame will work as expected with the
  // application implemented in application coordinates.  To implement this
  // we convert the application coordinates returned by nextShellRect
  // back to native before calling initialize.
  IRectangle initRect = nextShellRect();
  if ( ICoordinateSystem::isConversionNeeded() )
     initRect = ICoordinateSystem::convertToNative( initRect,
                                                    desktopWindow()->size() );
  this -> initialize( resId, style, 0, 0, initRect, title );

}

/*------------------------------------------------------------------------------
| IFrameWindow::IFrameWindow                                                   |
|                                                                              |
| Constructor to create a frame window object using the argument values.       |
------------------------------------------------------------------------------*/
IFrameWindow::IFrameWindow ( const IResourceId         &resId,
                             IWindow                   *parent,
                             IWindow                   *owner,
                             const IRectangle          &initRect,
                             const IFrameWindow::Style &style,
                             const char                *title )
  : IWindow( ),
    fFrameWindowData(new IFrameWindowData(IFrameWindowData::destroyOnClose))
{
  this -> initialize( resId, style, parent, owner, initRect, title );

}

/*------------------------------------------------------------------------------
| IFrameWindow::~IFrameWindow                                                  |
|                                                                              |
| Destructor must iterate extensions, delete each extension, and delete the    |
| collection.                                                                  |
------------------------------------------------------------------------------*/
IFrameWindow::~IFrameWindow ( )
{
  IMODTRACE_DEVELOP( "IFrameWindow::dtor" );
#ifdef IC_MOTIF
  // Need to insure ownees are deleted.
  if ( this->isValid() &&
       !(fFrameWindowData->flags & IFrameWindowData::hasBeenClosed) )
      {
        this->sendEvent(WM_CLOSE);
        this->hide();
      }

  fFrameWindowData->unregisterCallbacks(this);
#endif

  this -> removeDefaultHandler();      // Remove our handler.

#ifdef IC_WIN
  // We use the keyboard part of the canvas handler to get keyboard
  // navigation in Windows
  fFrameWindowData->fKeyboardHandler.stopHandlingEventsFor( this );

  // clean up timer for flashing.
  if (this->isFlashing())
     this->endFlashing();
#endif

  // Remove the recoordination handler.
  IRecoordHandler::defaultHandler()->stopHandlingEventsFor( this );

  IFrameExtensions                     // Process extensions...
   *exts = this->extensions();

  if ( exts )
  {                                  // Remove each one...
    IFrameExtensions::Cursor
      cursor( *exts );
    for( cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
    {
      IFrameExtension
       *ext = exts -> elementAt( cursor );
      delete ext;
    }

    delete exts;                       // Remove collection...
  }
#ifdef IC_WIN
  if (!(IPlatform::isWin9x() || IPlatform::isNTNewShell()))
  {
    /******************************************************************/
    /* If a submenu lookup table exists on old shell, free the memory */
    /******************************************************************/
    if ( fFrameWindowData->fpSubmenuList )
      IMenuPrivate::deleteLookUpTable( this );
  }
#endif
#ifdef IC_MOTIF
  if (fFrameWindowData->frameMenu)
    delete fFrameWindowData->frameMenu;
#endif
  /********************************************************************/
  /* If a help id lookup table exists, get rid of it.                 */
  /********************************************************************/
  if ( fFrameWindowData->fpHelpList )
    IMenuPrivate::deleteHelpIdTable( this );


  /********************************************************************/
  /* If we added a colormap handler, delete it.                       */
  /********************************************************************/
  if(fFrameWindowData->fColorMapHandler)
  {
     delete fFrameWindowData->fColorMapHandler;
  }

  delete fFrameWindowData;
}

/*------------------------------------------------------------------------------
| IFrameWindow::defaultStyle                                                   |
|                                                                              |
| Return the current default style (static member).                            |
------------------------------------------------------------------------------*/
IFrameWindow::Style IFrameWindow::defaultStyle ( )
{
  return IFrameWindow::currentDefault;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setDefaultStyle                                                |
|                                                                              |
| Set the current default static member to the argument style.                 |
------------------------------------------------------------------------------*/
void IFrameWindow::setDefaultStyle ( const Style &style )
{
  IFrameWindow::currentDefault = style;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IFrameWindow::convertToGUIStyle                                              |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IFrameWindow::convertToGUIStyle ( const IBitFlag& style,
                                                bool extendedOnly ) const
{
  // Obtain the style from the class (IWindow) that we inherit from
  unsigned long ulStyle =
             Inherited::convertToGUIStyle( style, extendedOnly );

  const IFrameWindow::Style
   &bitStyle = (const IFrameWindow::Style &) style;

  if (extendedOnly)
  {
    // IFS is our styles, do not add to ulStyle for use with OS.
//    if (bitStyle & IFrameWindow::deferCreation )
//      ulStyle |= IFS_DEFERCREATE;
//    if (bitStyle & IFrameWindow::accelerator )
//      ulStyle |= IFS_ACCELERATOR;
//    if (bitStyle & IFrameWindow::menuBar )
//      ulStyle |=  IFS_MENU;
//    if (bitStyle & IFrameWindow::minimizedIcon )
//      ulStyle |=  IFS_MINICON;
//    if (bitStyle & IFrameWindow::alignNoAdjust )
//      ulStyle |=  IFS_ALIGNNOADJ;
//    if (bitStyle & IFrameWindow::shellPosition )
//      ulStyle |=  IFS_SHELLPOS;
//    if (bitStyle & IFrameWindow::dialogBackground )
//      ulStyle |=  IFS_DLGBACKGND;
//    if (bitStyle & IFrameWindow::animated )
//      ulStyle |=  IFS_ANIMATED;
//    if (bitStyle & IFrameWindow::appDBCSStatus )
//      ulStyle |=  IFS_APPDBCS;
//    if (bitStyle & IFrameWindow::noMoveWithOwner )
//      ulStyle |=  IFS_NOMOVEOWNER;
//    if (bitStyle & IFrameWindow::systemModal )
//      ulStyle |=  IFS_SYSMODAL;
    if (bitStyle & IFrameWindow::windowList )
      ulStyle |=  WS_EX_APPWINDOW;
    if (bitStyle & IFrameWindow::dialogBorder )
      ulStyle |=  WS_EX_DLGMODALFRAME;
  }
  else
  {
    if (bitStyle.bitwiseAnd(IFrameWindow::titleBar) == IFrameWindow::titleBar)
      ulStyle |=  WS_CAPTION;
    if (bitStyle & IFrameWindow::maximizeButton )
      ulStyle |=  WS_MAXIMIZEBOX;
    if (bitStyle & IFrameWindow::minimizeButton )
      ulStyle |=  WS_MINIMIZEBOX;
    if (bitStyle & IFrameWindow::hideButton )
      ulStyle |=  WS_MINIMIZEBOX;
    if (bitStyle & IFrameWindow::sizingBorder )
      ulStyle |=  WS_THICKFRAME;
    if (bitStyle & IFrameWindow::systemMenu )
      ulStyle |=  WS_SYSMENU;
    if (bitStyle & IFrameWindow::border )
      ulStyle |=  WS_BORDER;
    if (bitStyle & IFrameWindow::maximized )
      ulStyle |=  WS_MAXIMIZE;
    if (bitStyle &  IFrameWindow::minimized )
      ulStyle |=  WS_MINIMIZE;


    // Remove conflicting styles.
    if ( fFrameWindowData->isChild )
      ulStyle |=  WS_CHILD; // This dialog is a child window.
    else
      ulStyle &= ~(unsigned long)WS_CHILD; // This dialog is not a child window.

    // If either minimize or maximize button wanted, must have system menu
    if ( ((IPlatform::isWin9x()) || (IPlatform::isNTNewShell())) &&
         ((bitStyle & IFrameWindow::minimizeButton) ||
          (bitStyle & IFrameWindow::maximizeButton)) )
      ulStyle |=  WS_SYSMENU;

    // If a system menu is wanted must have WS_CAPTION
    if ( bitStyle & IFrameWindow::systemMenu )
      ulStyle |=  WS_CAPTION;

    // If a sizing border is wanted must have WS_BORDER to paint
    // correctly on NT3.51 old shell
    if ( bitStyle & IFrameWindow::sizingBorder )
      ulStyle |= WS_BORDER;

    // If a dialog border is wanted must not have WS_THICKFRAME on
    // to paint correctly on NT3.51 old shell
    if ( bitStyle & IFrameWindow::dialogBorder )
    {
      ulStyle &=  ~(unsigned long)WS_THICKFRAME;
      // if dialogBorder is specified then don't allow the window to be maximized.
      // dialog windows are not resizeable, but can be minimized.
      ulStyle &=  ~(unsigned long)WS_MAXIMIZEBOX;
    }
    // Clear the visible flag, we call show in initialize if the frame
    // should be visible.
    ulStyle &= ~(unsigned long)WS_VISIBLE;

    if ( !(bitStyle.bitwiseAnd(IFrameWindow::titleBar) == IFrameWindow::titleBar) )
    {
      // WS_OVERLAPPED implies titlebar.  Make it a popup if we dont need
      // the titlebar area for buttons or system menu
      if ( !((ulStyle & WS_CHILD) ||
             (bitStyle & IFrameWindow::minimized) ||
             (bitStyle & IFrameWindow::maximized) ||
             (bitStyle & IFrameWindow::systemMenu )) )
      {
        ulStyle |= WS_POPUP;
      }
    }
  }

  return ulStyle;
}
#endif // IC_WIN


#ifdef IC_PM
/*------------------------------------------------------------------------------
| IFrameWindow::convertToGUIStyle                                              |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IFrameWindow::convertToGUIStyle ( const IBitFlag& style,
                                                bool extendedOnly ) const
{
  // Obtain the style from the class (IWindow) that we inherit from
  unsigned long ulStyle =
             Inherited::convertToGUIStyle( style, extendedOnly );

  IFrameWindow::Style& bitStyle = (IFrameWindow::Style &) style;

  if (extendedOnly)
  {
//    if (bitStyle & IFrameWindow::deferCreation )
//      ulStyle |= IFS_DEFERCREATE;
    if (bitStyle & IFrameWindow::menuBar )
      ulStyle |=  FCF_MENU;
    if (bitStyle & IFrameWindow::titleBar )
      ulStyle |=  FCF_TITLEBAR;
    if (bitStyle & IFrameWindow::maximizeButton )
      ulStyle |=  FCF_MAXBUTTON;
    if (bitStyle & IFrameWindow::minimizeButton )
      ulStyle |=  FCF_MINBUTTON;
//    if (bitStyle & IFrameWindow::hideButton )
//      ulStyle |=  IFS_HIDEBUTTON;
    if (bitStyle & IFrameWindow::systemMenu )
      ulStyle |=  FCF_SYSMENU;
    if (bitStyle & IFrameWindow::horizontalScroll )
      ulStyle |=  FCF_HORZSCROLL;
    if (bitStyle & IFrameWindow::verticalScroll )
      ulStyle |=  FCF_VERTSCROLL;

    // Handle overlapping styles
    if (bitStyle & IFrameWindow::hideButton )
      ulStyle |= FCF_HIDEBUTTON;

    // The next 2 lines hack around bugs in OS/2 PM
    if (bitStyle & IFrameWindow::dialogBackground )
      ulStyle |= FCF_AUTOICON;
    if (bitStyle & IFrameWindow::appDBCSStatus)
      ulStyle |= FCF_DBE_APPSTAT;

    if (bitStyle & IFrameWindow::dialogBorder)
    {
       // don't allow dialogs to be maximized
       ulStyle &= ~(unsigned long)FCF_MAXBUTTON;
    }

  }
  else
  {
    if (bitStyle & IFrameWindow::accelerator )
      ulStyle |= FS_ACCELTABLE;
    if (bitStyle & IFrameWindow::minimizedIcon )
      ulStyle |=  FS_ICON;
    if (bitStyle & IFrameWindow::alignNoAdjust )
      ulStyle |=  FS_NOBYTEALIGN;
    // Don't set the shell position yet.
//    if (bitFlag & IFrameWindow::shellPosition )
//      ulStyle |=  FS_SHELLPOSITION;
//    if (bitStyle & IFrameWindow::dialogBackground )
//      ulStyle |=  FS_AUTOICON;
    if (bitStyle & IFrameWindow::animated )
      ulStyle |=  WS_ANIMATE;
    if (bitStyle & IFrameWindow::appDBCSStatus )
      ulStyle |=  FS_DBE_APPSTAT;
    if (bitStyle & IFrameWindow::noMoveWithOwner )
      ulStyle |=  FS_NOMOVEWITHOWNER;
    if (bitStyle & IFrameWindow::systemModal )
      ulStyle |=  FS_SYSMODAL;
    if (bitStyle & IFrameWindow::windowList )
      ulStyle |=  FS_TASKLIST;
    if (bitStyle & IFrameWindow::sizingBorder )
      ulStyle |=  FS_SIZEBORDER;
    if (bitStyle & IFrameWindow::dialogBorder )
      ulStyle |=  FS_DLGBORDER;
    if (bitStyle & IFrameWindow::border )
      ulStyle |=  FS_BORDER;
    if (bitStyle & IFrameWindow::maximized )
      ulStyle |=  WS_MAXIMIZED;
    if (bitStyle &  IFrameWindow::minimized )
      ulStyle |=  WS_MINIMIZED;

    if (bitStyle & IFrameWindow::dialogBorder)
    {
       ulStyle &= ~(unsigned long)FS_SIZEBORDER;
    }

    // Clear the visible flag, we call show in initialize if the frame
    // should be visible.
    ulStyle &= (unsigned long)~WS_VISIBLE;
  }
  return ulStyle;
}
#endif // IC_PM

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFrameWindow::convertToGUIStyle                                              |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IFrameWindow::convertToGUIStyle ( const IBitFlag& style,
                                                bool extendedOnly ) const
{
  // Obtain the style from the class (IWindow) that we inherit from
  unsigned long ulStyle =
             Inherited::convertToGUIStyle( style, extendedOnly );

  IFrameWindow::Style& bitStyle = (IFrameWindow::Style &) style;

  if (extendedOnly)
  {
    if (bitStyle & IFrameWindow::windowList )
      ulStyle |=  WS_EX_APPWINDOW;
    if (bitStyle & IFrameWindow::dialogBorder )
      ulStyle |=  WS_EX_DLGMODALFRAME;
  }
  else
  {
    if (bitStyle & IFrameWindow::titleBar )
      ulStyle |=  WS_CAPTION;
    if (bitStyle & IFrameWindow::maximizeButton )
      ulStyle |=  WS_MAXIMIZEBOX;
    if (bitStyle & IFrameWindow::minimizeButton )
      ulStyle |=  WS_MINIMIZEBOX;
    if (bitStyle & IFrameWindow::hideButton )
      ulStyle |=  WS_MINIMIZEBOX;
    if (bitStyle & IFrameWindow::sizingBorder )
      ulStyle |=  WS_THICKFRAME;
    if (bitStyle & IFrameWindow::systemMenu )
      ulStyle |=  WS_SYSMENU;
    if (bitStyle & IFrameWindow::horizontalScroll )
      ulStyle |=  WS_HSCROLL;
    if (bitStyle & IFrameWindow::verticalScroll )
      ulStyle |=  WS_VSCROLL;
    if (bitStyle & IFrameWindow::border )
      ulStyle |=  WS_BORDER;
    if (bitStyle & IFrameWindow::maximized )
      ulStyle |=  WS_MAXIMIZE;
    if (bitStyle &  IFrameWindow::minimized )
      ulStyle |=  WS_MINIMIZE;
  }
  return ulStyle;
}
#endif // IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFrameWindow::convertToArgList                                               |
|                                                                              |
| Returns arg list for the styles that are requested.                          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
IArgList IFrameWindow::convertToArgList ( const IBitFlag& style ) const
{
  IArgList theArgList( Inherited::convertToArgList( style  ));

  IFrameWindow::Style& bitStyle = (IFrameWindow::Style &) style;

  unsigned long decorations(0);
  if (bitStyle & IFrameWindow::maximizeButton )
    decorations |= MWM_DECOR_MAXIMIZE;
  if ((bitStyle & IFrameWindow::minimizeButton) |
      (bitStyle & IFrameWindow::hideButton))
    decorations |= MWM_DECOR_MINIMIZE;
  if (bitStyle & IFrameWindow::sizingBorder)
    decorations |= MWM_DECOR_RESIZEH;
  if (bitStyle & IFrameWindow::systemMenu)
    decorations |= MWM_DECOR_MENU;
  // Must check for sizingBorder so that the application looks correct under
  // PMX.
  if ((bitStyle & IFrameWindow::border) |
      (bitStyle & IFrameWindow::dialogBorder) |
      (bitStyle & IFrameWindow::sizingBorder) )
    decorations |= MWM_DECOR_BORDER;
  if (bitStyle.bitwiseAnd(IFrameWindow::titleBar) == IFrameWindow::titleBar)
    decorations |= MWM_DECOR_TITLE;
  // if no bits set then no decorations are wanted
  if (decorations == 0)
    decorations = MWM_DECOR_ALL |       // all EXCEPT following:
                  MWM_DECOR_MAXIMIZE | MWM_DECOR_MINIMIZE | MWM_DECOR_RESIZEH |
                  MWM_DECOR_MENU     | MWM_DECOR_BORDER   | MWM_DECOR_TITLE;

  // Handle decorations
  theArgList.setResource( XmNmwmDecorations, decorations );

  unsigned long systemMenuStyles = MWM_FUNC_CLOSE | MWM_FUNC_MOVE;
  // Handle functions on system menu
  if (decorations & MWM_DECOR_MAXIMIZE)
    systemMenuStyles |= MWM_FUNC_MAXIMIZE;
  if (decorations & MWM_DECOR_MINIMIZE)
    systemMenuStyles |= MWM_FUNC_MINIMIZE;
  if (decorations & MWM_DECOR_RESIZEH)
    systemMenuStyles |= MWM_FUNC_RESIZE;
  theArgList.setResource( XmNmwmFunctions, systemMenuStyles );

  // Set the title string
  if (!(decorations & MWM_DECOR_TITLE))
  {
    IString text(" ");
    theArgList.setResource( XmNtitle, (XtArgVal)(char *)text )
              .setResource( XmNiconName,
               (XtArgVal) XtName( IWindow::desktopWindow()->handle()) );
  }
  else
  {
    theArgList.setResource( XmNiconName,
                       (XtArgVal) XtName(IWindow::desktopWindow()->handle() ))
              .setResource( XmNtitle,
                       ( XtArgVal) XtName( IWindow::desktopWindow()->handle() ));
  }

  // Set the delete window response to none so that the library handles
  // the delete message and closes the window.
  theArgList.setResource( XmNdeleteResponse, XmDO_NOTHING );

  // Make sure there is no border on the shell.
  theArgList.setResource( XmNborderWidth, 0 );

  // Don't want the frame to have any inside margins.
  theArgList.setResource( XmNmarginHeight, 0 )
            .setResource( XmNmarginWidth, 0 );

  if ( bitStyle & minimized)
  {
    theArgList.setResource( XmNinitialState, IconicState )
              .setResource( XmNiconic, true );
  }

  // Select modality
  if ( bitStyle & systemModal)
    theArgList.setResource( XmNmwmInputMode, MWM_INPUT_SYSTEM_MODAL );
  else
    // Set the input mode to be modeless
    theArgList.setResource( XmNmwmInputMode, MWM_INPUT_MODELESS );

  // The Style flags have to be passed to the shell
  return theArgList;
}
#endif

/*------------------------------------------------------------------------------
| IFrameWindow::close                                                          |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::close ( )
{
  this -> postEvent( WM_CLOSE );
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::minimize                                                       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::minimize ( )
{
#ifdef IC_WIN
  // Ignore request if no minimize button ... PM does this automatically
  if (this->style() & WS_MINIMIZEBOX )
     this -> sendEvent( WM_SYSCOMMAND,
                        SC_MINIMIZE,
                        IEventParameter2( 0 ) );
#endif
#ifdef IC_PM
  this -> sendEvent( WM_SYSCOMMAND,
                     SC_MINIMIZE,
                     IEventParameter2( CMDSRC_OTHER, false ) );
#endif
#ifdef IC_MOTIF
  bool isMin = true;
  XtVaSetValues(
       fFrameWindowData->shell,
       XmNiconic, isMin,
       NULL);
  Screen *screen = XtScreen( (Widget)IWindow::desktopWindow()->handle() );
  XIconifyWindow(
     screen->display,                                     // Display
     XtWindow( (Widget)fFrameWindowData->shell ),                // Window
     XScreenNumberOfScreen(screen) );                     // Screen Number

  fFrameWindowData->flags = fFrameWindowData->flags |
                              IFrameWindowData::minimized;
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::maximize                                                       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::maximize ( )
{
  ITRACE_MOTIF_NOP();
#ifdef IC_WIN
  // Ignore request if no maximize button ... PM does this automatically
  if (this->style() & WS_MAXIMIZEBOX )
     this -> sendEvent( WM_SYSCOMMAND,
                        SC_MAXIMIZE,
                        IEventParameter2( 0 ) );
#endif
#ifdef IC_PM
  this -> sendEvent( WM_SYSCOMMAND,
                     SC_MAXIMIZE,
                     IEventParameter2( CMDSRC_OTHER, false ) );
#endif
  // ignored in Motif
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::restore                                                        |
|                                                                              |
| Restores a minimized or maximized window.                                    |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::restore ( )
{
  // this function is not completely supported on Motif
  ITRACE_MOTIF_NOP();

#ifdef IC_PMWIN
  this -> sendEvent( WM_SYSCOMMAND,
                     SC_RESTORE,
#ifdef IC_WIN
                     IEventParameter2( 0 ) );
#endif
#ifdef IC_PM
                     IEventParameter2( CMDSRC_OTHER, false ) );
#endif
#endif //IC_PMWIN

#ifdef   IC_MOTIF
  // Restore from minimized only.. maximize not supported.
  if (isMinimized() )
   {
   Screen *screen = XtScreen( (Widget)IWindow::desktopWindow()->handle() );
   bool isMin = false;

   XtVaSetValues(
       fFrameWindowData->shell,
       XmNiconic, isMin,
       NULL);

   XMapRaised(
      screen->display,
      XtWindow( (Widget)fFrameWindowData->shell ) );

   fFrameWindowData->flags = fFrameWindowData->flags &
                              ~IFrameWindowData::minimized;
   }
#endif   //IC_MOTIF
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::moveSizeToClient                                               |
|                                                                              |
| Size and position the frame window around the client rectangle.              |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::moveSizeToClient ( const IRectangle& clientRect )
{
#ifdef IC_MOTIF
  if ( !XtIsRealized( this->handle() ) )
  {
      // To get correct values, the request must be applied after the
      // widget is realized.  Add to the deferred queue.   We go ahead
      // and do the moveSizeTo now anyway to minimize flashing.
      if (!this->fFrameWindowData->fDeferredActions)
          this->fFrameWindowData->fDeferredActions = new IFrameWindowDeferred;
      IFrameWindowDeferredAction* action =
          new IFrameWindowDeferredAction(clientRect);
      this->fFrameWindowData->fDeferredActions->add( action );
  }
#endif
  this->moveSizeTo( this->frameRectFor( clientRect ) );
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::clientRectFor                                                  |
|                                                                              |
| Obtain the client window rectangle based on the size and position of         |
| the frame window and its' extensions.                                        |
------------------------------------------------------------------------------*/
IRectangle IFrameWindow::clientRectFor ( const IRectangle& frameRect ) const
{
#ifdef IC_MOTIFWIN
  // In Windows, the system has no support for adjusting the client
  // size for frame extensions.  Therefore we have to compute a logical
  // client rectangle.  We store this in the frame window data area.
  // The needClientSized flag is set in update() when needsUpdating is
  // seen.  The separate flag is needed because this function is called
  // during processing caused by update().
  if ( ( fFrameWindowData->flags & IFrameWindowData::needsUpdating) ||
       ( fFrameWindowData->flags & IFrameWindowData::needsClientSized ))
     {
     // clear the invalid flag
     fFrameWindowData->flags &= ~IFrameWindowData::needsClientSized;
     // calculate rectangle
     IRectangle rc;
     // convert from interface coordinates to system coordinates
     if ( frameRect != IRectangle() )
         rc = ICoordinateSystem::convertToNative( frameRect, parentSize() );
     fFrameWindowData->calcFrameRect( this->handle(), rc, true );
     // store the updated rectangle
     fFrameWindowData->logicalClientRect =
         ICoordinateSystem::convertToApplication( rc,  parentSize()  );
     }  // needs client sized
  return fFrameWindowData->logicalClientRect;
#endif
#ifdef IC_PM
  IRectangle rc;
  // convert from interface coordinates to system coordinates
  if ( frameRect != IRectangle() )
      rc = ICoordinateSystem::convertToNative( frameRect, parentSize() );
  fFrameWindowData->calcFrameRect( this->handle(), rc, true );
  return ICoordinateSystem::convertToApplication( rc, parentSize() );
#endif
}

/*------------------------------------------------------------------------------
| IFrameWindow::frameRectFor                                                   |
|                                                                              |
| Obtain the frame window rectangle based on the size and position of          |
| the client rectangle and the frame windows extensions.                       |
------------------------------------------------------------------------------*/
IRectangle IFrameWindow::frameRectFor ( const IRectangle& clientRect ) const
{
  ITRACE_ALL(IString("frameRectFor: clientRect=") + clientRect.asString() );
  IRectangle rc =
     ICoordinateSystem::convertToNative(
        clientRect,
        IWindow::desktopWindow()->size() );
  if ( !fFrameWindowData->calcFrameRect( this->handle(), rc, false) )
  {
     ITHROWGUIERROR("calcFrameRect");
  }
  return ICoordinateSystem::convertToApplication(
            IRectangle( rc),
            IWindow::desktopWindow()->size()  );
}

/*------------------------------------------------------------------------------
| IFrameWindow::maximizeRect                                                   |
|                                                                              |
| Obtain the window's maximized position.                                      |
------------------------------------------------------------------------------*/
IRectangle IFrameWindow::maximizeRect ( ) const
{
  ITRACE_MOTIF_NOP();
#ifdef IC_WIN
  //
  // If dialog border then we cannot maximize or if no
  // maximize button we still can't maximize.
  //
  if ( ( this->extendedStyle() & WS_EX_DLGMODALFRAME ) ||
       ( ( this->style() & WS_MAXIMIZEBOX ) != WS_MAXIMIZEBOX ) )
    return this->rect();

  RECT workArea;
  //
  // The Windows documentation (include with JUNO) says that the
  // following regarding the SPI_GETWORKAREA parameter:
  //
  // SPI_GETWORKAREA    Windows 95 only: Retrieves the size of
  //                    the working area. The working area is
  //                    the portion of the screen not obscured
  //                    by the tray. The pvParam parameter points
  //                    to the RECT structure that receives the
  //                    coordinates of the working area.
  //
  // which I think can be interpreted to work on the new shell
  // (win95, winnt 4.0, win98).  I have tried it on NT351 and
  // it looks the API still returns a valid rect.
  //
  // Also, I tried in on a system with multiple tray-like windows
  // (referred to as APPBARs) and the returned work area excluded
  // thoses areas as well.
  //
  if (!::SystemParametersInfo( SPI_GETWORKAREA, 0, &workArea, 0 ) )
  {
    ITHROWGUIERROR("SystemParametersInfo");
  }

  unsigned long bWidth  = this->borderWidth();
  unsigned long bHeight = this->borderHeight();

  IRectangle result( IPoint( workArea.left   - bWidth,
                             workArea.top    - bHeight ),
                     IPoint( workArea.right  + bWidth,
                             workArea.bottom + bHeight ) );
#endif // IC_WIN
#ifdef IC_PM
  SWP
    posInfo = { 0 };
  if (! IQUERYMAXPOSITION( this->handle(), &posInfo ) )
  {
     ITHROWGUIERROR("IQUERYMAXPOSITION");
  }

  IRectangle result ;
  if (fFrameWindowData->bMaxFrameSizeSet)
     result = IRectangle( IPoint( posInfo.x, posInfo.y ),
                          maximumFrameSize()) ;
  else
     result = IRectangle( IPoint( posInfo.x, posInfo.y ),
                          ISize( posInfo.cx, posInfo.cy ) );
#endif //IC_PM

#ifdef IC_MOTIF
  // Return a default rectangle... positioning is a window
  // manager function.
  IRectangle result ;
#endif //IC_MOTIF

  return ICoordinateSystem::convertToApplication( result,
                                                  parentSize() );
}

/*------------------------------------------------------------------------------
| IFrameWindow::minimizeRect                                                   |
|                                                                              |
| Obtain the window's minimized position.                     .                |
|                                                                              |
| Note: The WinGetMinPosition API turns on the WS_MINIMIZED style flags which  |
|       leaves the frame in an odd state.  Thus, we must turn the style back   |
|       off (if it was not on before the call).                                |
------------------------------------------------------------------------------*/
IRectangle IFrameWindow::minimizeRect ( ) const
{
  ITRACE_MOTIF_NOP();
#ifdef IC_WIN
  WINDOWPLACEMENT
    posInfo;
  posInfo.length = sizeof(WINDOWPLACEMENT);
  if (! IQUERYMINPOSITION( this->handle(), &posInfo ) )
  {
    ITHROWGUIERROR("IQUERYMINPOSITION");
  }

  ISize minsize;
  if ((IPlatform::isWin9x()) || (IPlatform::isNTNewShell()) )
     minsize = ISize(GetSystemMetrics( SM_CXMINIMIZED ),
                     GetSystemMetrics( SM_CYMINIMIZED ) );
  else
     minsize = ISize( GetSystemMetrics( SM_CXICON ) + 4,   // 4 determined emprically
                      GetSystemMetrics( SM_CYICON ) + 4 );

  IRectangle result( IPoint( posInfo.ptMinPosition ), minsize  );
#endif  // IC_WIN

#ifdef   IC_PM
  bool
    wasMinimized = ( this->style() & WS_MINIMIZED ) ? true : false;
  SWP
    posInfo = { 0 };
  // Don't really want to minimize so undo this style if need be...
  if ( !wasMinimized )
    // Have to cast away const-ness!
     ((IFrameWindow*)this) -> setStyle( this->style() &
                                         (unsigned long)~WS_MINIMIZED );

  IRectangle result( IPoint( posInfo.x, posInfo.y ),
                     ISize( posInfo.cx, posInfo.cy ) );
#endif   //IC_PM

#ifdef   IC_MOTIF
  // Return a default rectangle... positioning is a window
  // manager function.
  IRectangle result ;
#endif   //IC_MOTIF

  return ICoordinateSystem::convertToApplication( result,
                                                  parentSize() );
}

/*------------------------------------------------------------------------------
| IFrameWindow::restoreRect                                                    |
|                                                                              |
| Obtain the restore rectangle position and size from the window words.        |
------------------------------------------------------------------------------*/
IRectangle IFrameWindow::restoreRect ( ) const
{
  ITRACE_MOTIF_NOP();
#ifdef IC_WIN
  WINDOWPLACEMENT
    placeInfo;
  placeInfo.length = sizeof(WINDOWPLACEMENT);
  if (! GetWindowPlacement( this->handle(), &placeInfo ) )
  {
     ITHROWGUIERROR("GetWindowPlacement");
  }

  IRectangle result( placeInfo.rcNormalPosition );
#endif  // IC_WIN
#ifdef IC_PM
  IPoint
    pos( this->windowUShort( QWS_XRESTORE ),
         this->windowUShort( QWS_YRESTORE ) );
  ISize
    size( this->windowUShort( QWS_CXRESTORE ),
          this->windowUShort( QWS_CYRESTORE ) );

  IRectangle result( pos, size );
#endif   //IC_PM
#ifdef   IC_MOTIF
  // Return a default rectangle... positioning is a window
  // manager function.
  IRectangle result ;
#endif   //IC_MOTIF
  return ICoordinateSystem::convertToApplication( result,
                                                  parentSize() );
}

/*------------------------------------------------------------------------------
| IFrameWindow::setRestoreRect                                                 |
|                                                                              |
| Set the restore position and size in the window words.                       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setRestoreRect ( const IRectangle &rect )
{
  ITRACE_MOTIF_NOP();
#ifdef IC_PMWIN
  // Avoid going way off screen...
  ISize newsize( rect.size().minimum( IWindow::desktopWindow()->size() )  );
  IRectangle nativeRect =
     ICoordinateSystem::convertToNative(
        IRectangle( rect.minXMinY(), newsize ) , parentSize() );
#ifdef IC_WIN
  WINDOWPLACEMENT
    placeInfo;
  // Get original values for minimize and maximize positions.
  placeInfo.length = sizeof(WINDOWPLACEMENT);
  if (! GetWindowPlacement( this->handle(), &placeInfo ) )
  {
     ITHROWGUIERROR("GetWindowPlacement");
  }
  // update restore rectangle
  placeInfo.flags   = 0;
  placeInfo.showCmd = SW_SHOWNA,
  placeInfo.rcNormalPosition.left   = nativeRect.minX();
  placeInfo.rcNormalPosition.top    = nativeRect.minY();
  placeInfo.rcNormalPosition.right  = nativeRect.maxX();
  placeInfo.rcNormalPosition.bottom = nativeRect.maxY();
  if (! SetWindowPlacement( this->handle(), &placeInfo ) )
  {
     ITHROWGUIERROR("SetWindowPlacement");
  }
#endif  // IC_WIN
#ifdef IC_PM
  this -> setWindowData( QWS_XRESTORE,  (unsigned short)nativeRect.minX() );
  this -> setWindowData( QWS_YRESTORE,  (unsigned short)nativeRect.minY() );
  this -> setWindowData( QWS_CXRESTORE, (unsigned short)nativeRect.width() );
  this -> setWindowData( QWS_CYRESTORE, (unsigned short)nativeRect.height() );
#endif  // IC_PM
#endif  // IC_PMWIN
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::nextShellRect                                                  |
|                                                                              |
| Returns the system-recommended coordinates of the next main window.          |
------------------------------------------------------------------------------*/
IRectangle IFrameWindow::nextShellRect ( )
{
  IRectangle
    result;

#ifdef IC_MOTIFWIN

  // We calculate our own nextShellRect since the one returned by
  // GetStartupInfo is typically 100x100 which is too small for many
  // ported applications.
  IRectangle desktopRect = IWindow::desktopWindow()->nativeRect();
  if ( IFrameWindowData::fgNextRect == IRectangle() )
  {
     // calculate the initial rectangle
     IFrameWindowData::fgNextRect = IRectangle(
                         IPoint( 0, 0 ),
                         ISize( (desktopRect.width() * 2) / 3,
                                (desktopRect.height() * 2) / 3 ));
  }

  // Move next rectangle by 25,25.  If it is no longer contained in the
  // desktop move its origin back to 25,25
  IFrameWindowData::fgNextRect.moveBy( IPair(25,25) );
  if ( !desktopRect.contains( IFrameWindowData::fgNextRect ) )
     IFrameWindowData::fgNextRect.moveTo( IPoint(25,25 ) );

  result = IFrameWindowData::fgNextRect;

#endif
#ifdef IC_PM

  SWP
    swp;
  unsigned long
    rc;
  rc = WinQueryTaskSizePos( IThread::current().anchorBlock(),
                            0,
                            &swp );

  // Note: If PMERR_INVALID_SESSION_ID is returned, the size and position
  //       values are still valid.  PM has a bug that returns this error
  //       if all of the frame windows for the current process have been
  //       removed from the task list.

  if (( rc == 0 ) || ( rc == PMERR_INVALID_SESSION_ID ))
  {
     result = IRectangle( IPoint( swp.x, swp.y ), ISize( swp.cx, swp.cy ) );
  }
  else
  {
     ITHROWGUIERROR("WinQueryTaskSizePos");
  }
#endif  // IC_PM
  if ( ICoordinateSystem::isConversionNeeded() )
     result = ICoordinateSystem::convertToApplication( result,
                                                       desktopWindow()->size() );
  return result;
}

/*------------------------------------------------------------------------------
| IFrameWindow::borderWidth                                                    |
|                                                                              |
| Returns the border width of the frame window.                                |
------------------------------------------------------------------------------*/
unsigned long IFrameWindow::borderWidth ( ) const
{
  IMODTRACE_DEVELOP( "IFrameWindow::borderWidth" );

  ITRACE_MOTIF_NOP();
#ifdef IC_WIN
  int borderType = 0;   // Assume frame has no border.

  // Assume frame has only one border style.
  unsigned long style = this->style();
  if ( style & WS_THICKFRAME )
  {
     borderType = SV_CXSIZEBORDER;
  }
  else if ( style & WS_DLGFRAME )
  {
     borderType = SV_CXDLGFRAME;
  }
  else if ( style & WS_BORDER )
  {
     borderType = SV_CXBORDER;
  }
  else if( IQUERYWINDOWULONG( this->handle(), GWL_EXSTYLE ) &
                                           WS_EX_DLGMODALFRAME )
  {
     borderType = SV_CXDLGFRAME;
  }

  return borderType ? IQUERYSYSVALUE( borderType ) : 0;
#endif   // IC_WIN
#ifdef IC_PM
  return this->borderSize().width();
#endif  // IC_PM
#ifdef IC_MOTIF
  return this->borderSize().width();
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::borderHeight                                                   |
|                                                                              |
| Returns the border height of the frame window.                               |
------------------------------------------------------------------------------*/
unsigned long IFrameWindow::borderHeight ( ) const
{
  IMODTRACE_DEVELOP( "IFrameWindow::borderHeight" );
   ITRACE_MOTIF_NOP();
#ifdef IC_WIN
  int borderType = 0;   // Assume frame has no border.

  // Assume frame has only one border style.
  unsigned long style = this->style();
  if ( style & WS_THICKFRAME )
  {
     borderType = SV_CYSIZEBORDER;
  }
  else if ( style & WS_DLGFRAME )
  {
     borderType = SV_CYDLGFRAME;
  }
  else if ( style & WS_BORDER )
  {
     borderType = SV_CYBORDER;
  }
  else if( IQUERYWINDOWULONG( this->handle(), GWL_EXSTYLE ) &
                                           WS_EX_DLGMODALFRAME )
  {
     borderType = SV_CYDLGFRAME;
  }

  return borderType ? IQUERYSYSVALUE( borderType ) : 0;
#endif   // IC_WIN
#ifdef IC_PM
  return this->borderSize().height();
#endif  // IC_PM
#ifdef IC_MOTIF
  return this->borderSize().height();
#endif  // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::borderSize                                                     |
|                                                                              |
| Returns the border width and height of the frame window.                     |
------------------------------------------------------------------------------*/
ISize IFrameWindow::borderSize ( ) const
{
  IMODTRACE_DEVELOP( "IFrameWindow::borderSize" );
  ITRACE_MOTIF_NOP();

#ifdef IC_WIN
  return ISize( this->borderWidth(), this->borderHeight() );
#endif
#ifdef IC_PM
  POINTL ptl;

  this -> sendEvent( WM_QUERYBORDERSIZE,
                     IEventParameter1( (PWPOINT)&ptl ),
                     0 );

  return ISize( ptl.x, ptl.y );
#endif //IC_PM
#ifdef IC_MOTIF
  return ISize( 1, 1 );
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::setBorderWidth                                                 |
|                                                                              |
| Set the border width of the frame window.                                    |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setBorderWidth ( unsigned long cx )
{
  IMODTRACE_DEVELOP( "IFrameWindow::setBorderWidth" );
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

#ifdef IC_MOTIFWIN
  // This is a problem, since it appears that Windows only lets you
  // change the system border sizes.  Border size doesn't look like
  // something that each frame keeps track of.
#endif
#ifdef IC_PM
  IASSERTPARM( this->style() & IFrameWindow::sizingBorder.asUnsignedLong() );

  this -> sendEvent( WM_SETBORDERSIZE,
                     IEventParameter1( cx ),
                     IEventParameter2( this->borderHeight() ));
#endif //IC_PM
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setBorderHeight                                                |
|                                                                              |
| Set the border height of the frame window.                                   |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setBorderHeight ( unsigned long cy )
{
  IMODTRACE_DEVELOP( "IFrameWindow::setBorderHeight" );
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

#ifdef IC_MOTIFWIN
  // This is a problem, since it appears that Windows only lets you
  // change the system border sizes.  Border size doesn't look like
  // something that each frame keeps track of.
#endif
#ifdef IC_PM
  IASSERTPARM( this->style() & IFrameWindow::sizingBorder.asUnsignedLong() );

  this -> sendEvent( WM_SETBORDERSIZE,
                     IEventParameter1( this->borderWidth() ),
                     IEventParameter2( cy ));
#endif //IC_PM
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setBorderSize                                                  |
|                                                                              |
| Set the border width and height of the frame window.                         |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setBorderSize ( const ISize& size )
{
  IMODTRACE_DEVELOP( "IFrameWindow::setBorderSize" );
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

#ifdef IC_MOTIFWIN
  // This is a problem, since it appears that Windows only lets you
  // change the system border sizes.  Border size doesn't look like
  // something that each frame keeps track of.
#endif
#ifdef IC_PM
  IASSERTPARM( this->style() & IFrameWindow::sizingBorder.asUnsignedLong() );

  this -> sendEvent( WM_SETBORDERSIZE,
                     IEventParameter1( (unsigned long)size.width() ),
                     IEventParameter2( (unsigned long)size.height() ));
#endif //IC_PM
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setBorderSize                                                  |
|                                                                              |
| Set the border width and height of the frame window.                         |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setBorderSize ( unsigned long cxcy )
{
  IMODTRACE_DEVELOP( "IFrameWindow::setBorderSize" );
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

#ifdef IC_MOTIFWIN
  // This is a problem, since it appears that Windows only lets you
  // change the system border sizes.  Border size doesn't look like
  // something that each frame keeps track of.
#endif
#ifdef IC_PM
  IASSERTPARM( this->style() & IFrameWindow::sizingBorder.asUnsignedLong() );

  this -> sendEvent( WM_SETBORDERSIZE,
                     IEventParameter1( cxcy ),
                     IEventParameter2( cxcy ));
#endif  //IC_PM
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setBorderSize                                                  |
|                                                                              |
| Set the border width and height of the frame window.                         |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setBorderSize ( unsigned long cx,
                                            unsigned long cy )
{
  IMODTRACE_DEVELOP( "IFrameWindow::setBorderSize" );
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

#ifdef IC_MOTIFWIN
  // This is a problem, since it appears that Windows only lets you
  // change the system border sizes.  Border size doesn't look like
  // something that each frame keeps track of.
#endif
#ifdef IC_PM
  IASSERTPARM( this->style() & IFrameWindow::sizingBorder.asUnsignedLong() );

  if ( this->style() & IFrameWindow::sizingBorder.asUnsignedLong() )
    this -> sendEvent( WM_SETBORDERSIZE,
                       IEventParameter1( cx ),
                       IEventParameter2( cy ));
#endif  //IC_PM
  return *this;
}


#ifdef IC_PM
/*------------------------------------------------------------------------------
| IFrameWindowData_ModalInputHook                                              |
------------------------------------------------------------------------------*/
BOOL EXPENTRY IFrameWindowData_ModalInputHook( HAB hab, PQMSG pmsg, unsigned long fs)
{
    BOOL result = 0;       // pass on
    // Testing
    if (pmsg->msg == WM_QUIT)
    {
        ITRACE_DEVELOP(
            IString("Modal Hook HWND=") + IString((unsigned long)pmsg->hwnd).d2x()+
            IString(", Msg=") + IString(pmsg->msg).d2x() +
            IString(", MP1=") + IString((unsigned long)pmsg->mp1).d2x() +
            IString(", MP2=") + IString((unsigned long)pmsg->mp2).d2x() );
        ITRACE_DEVELOP("WM_QUIT");
        IWindowHandle frame( (unsigned long)( pmsg->mp2 ) );
        if ( frame && frame.isValid() )
        {     // (A modal frame closed via the task list will
              // have its now invalid window handle here.)
           frame.postEvent( WM_SYSCOMMAND,
                            SC_CLOSE,
                            IEventData( CMDSRC_OTHER, false ) );
           result = 1;        // eat the WM_QUIT
        }
    }
    return result;
}
#endif

/*------------------------------------------------------------------------------
| IFrameWindow::showModally                                                    |
| Causes the frame to be displayed in application-modal mode.                  |
------------------------------------------------------------------------------*/
unsigned long IFrameWindow::showModally ( )
{
  IMODTRACE_DEVELOP( "IFrameWindow::showModally" );
  unsigned long result = DID_CANCEL;
#ifdef IC_PM
  IASSERTPARM( this->parent() != this->owner() );
#endif

#ifdef IC_MOTIF
  // Need to hide before changing the resources.
  // Otherwise the window decorations and modality behaviour
  // is wrong sometimes (in particular for Ja_JP locale).
  this->show(false);
#endif //IC_MOTIF

#ifdef IC_MOTIF
  // update will be called when the main window is shown.
  fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
#endif
#ifdef IC_PMWIN
  this -> update();
#endif

  fFrameWindowData->flags |= IFrameWindowData::modal;

  //-------------------------------------------------------------------
  // Locate the owner.  We need to ensure owner is disabled for modal behavior
  //-------------------------------------------------------------------
  IWindow* owner = this->owner();
  // if owner is desktop do not disable it
  if ( owner == IWindow::desktopWindow() )
     owner = 0;

  //-------------------------------------------------------------------
  // Prepare the frame and its owner for modal display.
  //-------------------------------------------------------------------

  // Within a thread, it is possible to have more than
  // one frame window in showModally at a time.  The call stack in this
  // situation has more than one instance of showModally on it.  We need to
  // insure that we exit the showModally calls in a LIFO manner to avoid
  // stack corruption.  We store the current nesting level in thread local
  // storage, and place the current value in each frame that is being shown
  // modally.
  // Windows/Motif: When the frame is being dismissed, we place the nesting
  //   value it has stored in lParam of the IC_UM_QUIT message.  IThread
  //   will not return from processMsgs until the nesting level is at or below
  //   this value.
  // PM: use the nesting level to manage the hook we set to properly handle
  //   close of the modal window from the task list.  WinProcessDlg handles
  //   nesting of event loops.

  // Get current nesting level for this thread.  Increment and store
  // new value in the frame window data and in thread storage.
#ifdef IC_PM
  if (IFrameWindowData::fgThreadData.storage() == 0)
     {
     // Initialize the nesting counter for this thread.
     IFrameWindowData::fgThreadData.adoptStorage(new IFrameWindowThreadData);
     // Account for IApplication::current().run() possibly active.
     if (IThread::current().isProcessingMsgs())
        IFrameWindowData::fgThreadData->fNesting++;
     }

  IFrameWindowData::fgThreadData->fNesting++;
#endif //IC_PM

#ifdef IC_WIN
  // if owner is already disabled then do nothing.  App is probably
  // broke but we don't want to change state of owner.
  fFrameWindowData->flags &= ~IFrameWindowData::enableOwner;
  if ( (owner) && (owner->isEnabled() ))
  {
     owner->disable();
     // set flag for use by dismiss to re-enable owner.
     fFrameWindowData->flags |= IFrameWindowData::enableOwner;
  }
#endif //IC_WIN

#ifdef IC_PM
  // If this window is in the task list, then we have to do some special stuff.
  // PM will unwind the entire modal stack if close done from the task list
  // to a modal window owned by another modal window.  Our hook catches the
  // WM_QUIT that PM sends and turns it into a close message to the frame so
  // that things clean up normally.  We only need one hook per thread, so
  // we use the nesting counter to determine the first pass through this code.
  PFN  phook = 0;
  if ( IFrameWindowData::fgThreadData->fNesting == 2 )
  {
     // First level of nesting.  Set a hook to inspect the messages.
     ITRACE_DEVELOP("Setting IFrameWindowData_ModalInputHook");
     phook = (PFN)&IFrameWindowData_ModalInputHook;
     unsigned long rc = WinSetHook(IThread::current().anchorBlock(),
                                   IThread::current().messageQueue(),
                                   HK_INPUT,
                                   phook,
                                   0);
     if (!rc)
         phook = 0;    // hook not set
  }
  // Insure WinProcessDlg does not return immediately.
  WinSetWindowUShort( this->handle(),
                      QWS_FLAGS,
                      (unsigned short)(WinQueryWindowUShort( this->handle(),
                                            QWS_FLAGS ) & ~FF_DLGDISMISSED ));
#endif //IC_PM

#ifdef IC_MOTIF
  // Save resources we mess with for modality
  Widget     myShellWidget    = this->fFrameWindowData->shell;
  int        mwmInputMode    = -1;
  ::Boolean  transient       = False;
  ::Boolean  saveUnder       = False;
  XtVaGetValues(
     myShellWidget,
     XmNmwmInputMode,  &mwmInputMode,
     XmNtransient,     &transient,
     XmNsaveUnder,     &saveUnder,
     NULL);

  // Save the resources we alter for restoration by dismiss().
  this->fFrameWindowData->fModalSavedResources = new IArgList;
  (*this->fFrameWindowData->fModalSavedResources)
      .setResource( XmNmwmInputMode,  mwmInputMode)
      .setResource( XmNtransient,     transient)
      .setResource( XmNsaveUnder,     saveUnder);

  IArgList args;
  if (mwmInputMode != MWM_INPUT_SYSTEM_MODAL)
  {
     // Set this window to be application modal
//      args.setResource( XmNmwmInputMode, MWM_INPUT_FULL_APPLICATION_MODAL);
      args.setResource( XmNmwmInputMode, MWM_INPUT_PRIMARY_APPLICATION_MODAL);
  }
  // Treat this as a dialog, this window will be treated as a transient window
  // Save the contents of the screen beneath this window to avoid expose events
  args.setResource(  XmNtransient, True)
      .setResource(  XmNsaveUnder, True);

  // Find the correct window group for this window
  // Check owner first, and set it as the primary application
  // window if its not the app shell.   Otherwise, use the window's parent.
  // Find first appropriate shell for the primary application and
  // set the windowGroup resource.  This is to get modality to work
  // correctly.
  Widget parentWidget = (owner != 0) ?
         (IWindowHandle::Value)owner->handle() : XtParent(this->handle());
  while (!((XtIsApplicationShell(parentWidget)) ||
           (XtIsTopLevelShell(parentWidget)) ))
      parentWidget = XtParent(parentWidget);
  args.setResource( XmNwindowGroup, XtWindow(parentWidget));

  // Apply resource changes
  XtSetValues( myShellWidget, (ArgList)args.argList(), args.numberOfArgs() );

  // make all frame windows in this app ignore the system close event
  IWindowList* winList = IWindowList::current();
  ICursor* pWindowCursor = winList->newCursor();
  pWindowCursor->setToFirst();

  while( pWindowCursor->isValid() )
  {
    IWindow* pWindow = winList->elementAt( *pWindowCursor );
    if( pWindow && pWindow != this && pWindow->isFrameWindow())
    {
      int WMFunctions;

      XtVaGetValues( pWindow->handle(), XmNmwmFunctions, &WMFunctions, NULL );
	  WMFunctions &= ~MWM_FUNC_CLOSE;
      XtVaSetValues( pWindow->handle(), XmNmwmFunctions, WMFunctions, NULL );
    }
    pWindowCursor->setToNext();
  }
  delete pWindowCursor;

#endif //IC_MOTIF

  //-------------------------------------------------------------------
  // Show the modal window.
  // We need to catch any exceptions that might happen in the modal
  // window so that we can insure cleanup of the modal loop occurs.
  //-------------------------------------------------------------------
  IException* exceptionCaught(0);
  try
  {
#ifdef IC_MOTIFWIN
      // Save nesting value for use by dismiss.
      ICurrentThread& thread( IThread::current() );
      ICurrentThreadData*  fLoopData = IThreadData::currentThreadData( thread );

      if ( fLoopData )
        fFrameWindowData->fModalNesting = fLoopData->fMsgLoop+1;
      else
        fFrameWindowData->fModalNesting = 1;

      this -> show();
      // Enter an event loop.
      IThread::current().processMsgs();
#endif //IC_MOTIFWIN

#ifdef IC_PM
      // Make sure new window has focus
      WinSetFocus( HWND_DESKTOP, this->handle() );

      // WinProcessDlg creates an event loop within itself.
      WinProcessDlg( this->handle() );
#endif
  }
  catch (IException& exc)
  {
      this->dismiss();
      // Copy exception info for rethrow
      exceptionCaught = new IException( exc );
  }

  //-------------------------------------------------------------------
  // Clean up after modal window is dismissed
  //-------------------------------------------------------------------
  // Decrement nesting value stored in thread storage.  We don't get here
  // until this dialog is dismissed.
#ifdef IC_PM
  (IFrameWindowData::fgThreadData->fNesting)--;
#endif //IC_PM

  fFrameWindowData->flags &= ~IFrameWindowData::modal;
  result = this->result();

  // Windows: If we disabled the owner then we need to reenable it.  The doc
  // on EnableWindow says that this should happen before the modal window
  // is destroyed to get focus back to the owner.   Therefore the
  // processing is done in IFrameWindow::dismiss, since we may
  // destroy the dialog before we get here.

#ifdef IC_PM
  // Remove hook if last modal window has been closed and it is no longer needed.
  if (IFrameWindowData::fgThreadData->fNesting == 1)
  {
      ITRACE_DEVELOP("Releasing IFrameWindowData_ModalInputHook");
      WinReleaseHook(IThread::current().anchorBlock(),
                     IThread::current().messageQueue(),
                     HK_INPUT,
                     (PFN)&IFrameWindowData_ModalInputHook,
                     0);
  }
#endif //IC_PM
#ifdef IC_MOTIF
  // reactivate the system close for frame windows
  pWindowCursor = winList->newCursor();
  pWindowCursor->setToFirst();

  while( pWindowCursor->isValid() )
  {
    IWindow* pWindow = winList->elementAt( *pWindowCursor );
    if( pWindow && pWindow != this && pWindow->isFrameWindow())
    {
      int WMFunctions;

      XtVaGetValues( pWindow->handle(), XmNmwmFunctions, &WMFunctions, NULL );
	  WMFunctions |= MWM_FUNC_CLOSE;
      XtVaSetValues( pWindow->handle(), XmNmwmFunctions, WMFunctions, NULL );
    }
    pWindowCursor->setToNext();
  }
  delete pWindowCursor;

#endif
  // Now do auto-delete object processing.  The modalAutoDelete flag
  // is set by IFrameHandler during WM_DESTROY processing.
  if ( fFrameWindowData->flags & IFrameWindowData::modalAutoDelete )
  {
     delete this;
  }

  if (exceptionCaught)
  {
     IException exc(*exceptionCaught);
     delete exceptionCaught;
     ITHROW(exc);
  }

  return result;
}

/*------------------------------------------------------------------------------
| IFrameWindow::result                                                         |
|                                                                              |
| Return the most recent result for this frame.                                |
------------------------------------------------------------------------------*/
unsigned long IFrameWindow::result ( ) const
{
  return fFrameWindowData->rc;
}

/*------------------------------------------------------------------------------
| IFrameWindow::dismiss                                                        |
|                                                                              |
| Dismisses a frame window by hiding it, and, if modal, causes the completion  |
| of the showModally function call that triggered its display.                 |
| Notes: Set the frame "result" to the argument value.                         |
|        If the frame is modal, dismiss it.                                    |
|        Otherwise, simply hide the frame.                                     |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::dismiss ( unsigned long result )
{
  this -> setResult( result );

  if ( this->isModal() )
  {
#ifdef IC_WIN
		IWindowHandle captorHandle( handleWithPointerCaptured() );

		if( captorHandle.isValid() )
		{
			// find out if the captor is a child of this modal frame
			// if so, release the capture
	
			IWindow* pCaptor = IWindow::windowWithHandle(captorHandle);
			IWindow* pParent = pCaptor;
			bool bFound = false;

			while( pParent && pParent != IWindow::desktopWindow() )
			{
				if( pParent == this )
				{
					bFound = true;
					break;
				}
				pParent = pParent->parent();
			}

			if( bFound && pCaptor )
			{
				pCaptor->releasePointer();
			}
		}

     // Re-enable the owner.  This has to happen before destruction
     // of the modal window.  Do it before the hide to minimize flashing
     // in cases where focus was changed by user to another app during
     // lifetime of dialog.
     if (fFrameWindowData->flags & IFrameWindowData::enableOwner )
     {
        fFrameWindowData->flags &= ~IFrameWindowData::enableOwner;
        IWindow* owner = this->owner();
        if (owner)
        {
           owner->enable();
           // Move owner to top of Z-order.
           owner->positionOnSiblings();
           owner->setFocus();
        }
     }

     // hide the window
     this->hide();

     // Bail out of the event loop we started when the modal
     // frame was shown.  See showModally for usage of fModalNesting.
     IThread::current().messageQueue().postEvent(
        IC_UM_QUIT, 0, fFrameWindowData->fModalNesting );
#endif //IC_WIN

#ifdef IC_PM
     IDISMISSDLG( this->handle(), (unsigned short)result );
#endif //IC_PM

#ifdef IC_MOTIF
     // Hide this window.
     if ( this->isValid() && isVisible() )
     {
        if( owner() )
        {
           owner()->setFocus();
        }
        this->hide();
     }

     // Restore previous values of modality related resources.
     if ( this->fFrameWindowData->fModalSavedResources )
     {
         XtSetValues(
            this->fFrameWindowData->shell,
            (ArgList)this->fFrameWindowData->fModalSavedResources->argList(),
            this->fFrameWindowData->fModalSavedResources->numberOfArgs() );
         delete this->fFrameWindowData->fModalSavedResources;
         this->fFrameWindowData->fModalSavedResources = 0;
     }

     // Bail out of the event loop we started when the modal
     // frame was shown.  See showModally for usage of fModalNesting.
     IThread::current().messageQueue().postEvent(
        WM_QUIT, 0, fFrameWindowData->fModalNesting );
#endif //IC_MOTIF

  }
  else
  {
     this->hide();

#ifdef IC_PMWIN
     // Check if we are the active window, and if so set the focus
     // to the owner.
     if ( IQUERYACTIVEWINDOW(desktopWindow()->handle()) == handle() )
     {
        if ( this->owner() )
           this->owner()->setFocus();
        else
           this->parent()->setFocus();
     }
#endif //IC_PMWIN
  }

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setResult                                                      |
|                                                                              |
| Simply set the "rc" data member to the argument value.                       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setResult ( unsigned long result )
{
  fFrameWindowData->rc = result;
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::notifyOwner                                                    |
|                                                                              |
| Posts a command event to the frame's (or dialog's) owner.                    |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::notifyOwner ( unsigned long         id,
                                          ICommandEvent::Source source,
                                          bool                  pointerDevice )
{
  IWindow* pwinOwner = this->owner();
  if (pwinOwner)
  {                               // Have an owner to notify.
     (void)pointerDevice;
     pwinOwner->postEvent( WM_COMMAND, IEventData(id, source), 0);

  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::icon                                                           |
------------------------------------------------------------------------------*/
IPointerHandle IFrameWindow::icon ( ) const
{
#ifdef IC_WIN
  return IPointerHandle( (HICON)GetClassLong( this -> handle(), GCL_HICON ));
#endif //IC_WIN
#ifdef IC_PM
  return IPointerHandle( this -> sendEvent( WM_QUERYICON ) );
#endif //IC_PM
#ifdef IC_MOTIF
  Pixmap iconPixmap;
  XtVaGetValues(fFrameWindowData->shell,   //handle = client
                XmNiconPixmap,      // whose grandparent is WMShell-
                &iconPixmap,        // who has the icon
                NULL);
  return IPointerHandle(iconPixmap);
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::setIcon                                                        |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setIcon ( const IPointerHandle &icon )
{
#ifdef IC_WIN
  IWindowClassName className( handle() );
  if (className.asString().indexOf(WC_FRAME) == 1)
     SetClassLong( this->handle(), GCL_HICON, (ULONG)((void *)icon) );
  else
     this->sendEvent( WM_SETICON, true, icon.asUnsigned() );
#endif //IC_WIN
#ifdef IC_PM
  this->sendEvent( WM_SETICON, (unsigned long)icon );
#endif //IC_PM
#ifdef IC_MOTIF
  Arg args[2];
  int n= 0;

  XtSetArg(args[n],
           XmNiconPixmap,
           icon); n++;
  XtSetValues(fFrameWindowData->shell, args, n);
#endif //IC_MOTIF
  fFrameWindowData->frameIcon = icon;
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setIcon                                                        |
|                                                                              |
| Set icon after loading it from resource library.                             |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setIcon ( const IResourceId &iconResId )
{
#ifdef IC_WIN
  this -> setIcon( iconResId.resourceLibrary().loadIcon( iconResId ));
#endif //IC_WIN

#ifdef IC_PM
  if ( this->style() & IFrameWindow::minimizedIcon.asUnsignedLong() )
     this -> setIcon( iconResId.resourceLibrary().loadIcon( iconResId, false ));
  else
     this -> setIcon( iconResId.resourceLibrary().loadIcon( iconResId ));
#endif  //IC_PM

#ifdef IC_MOTIF
  // Find out size for icons.
  XIconSize *iconSizes;
  int iconSizesCount;
  ISize goodIconSize;

  Display* display = XtDisplay(IWindow::desktopWindow()->handle());
  if (XGetIconSizes(display,
                RootWindow(display, DefaultScreen(display)),
                &iconSizes,
                &iconSizesCount))
  {
     goodIconSize.setWidth(iconSizes->max_width);
     goodIconSize.setHeight(iconSizes->max_height);
     XFree(iconSizes);
  }

  IPointerHandle iconHandle =
                  iconResId.resourceLibrary().loadIcon(iconResId);
  IPointerHandle newIconHandle =
                  IBitmapStaticPtr::sizePointerTo(iconHandle, goodIconSize );
  this -> setIcon( iconHandle);
#endif //IC_MOTIF
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setIcon                                                        |
|                                                                              |
| Set icon after loading it from default resource library.                     |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setIcon ( unsigned long iconResId )
{
  this -> setIcon( IResourceId( iconResId ) );
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::clientHandle                                                   |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::clientHandle ( ) const
{
#ifdef IC_PMWIN
  return IWindow::handleWithParent( FID_CLIENT, this->handle() );
#endif //IC_PMWIN

#ifdef IC_MOTIF
  if (fFrameWindowData->motifClient == 0L)
    return (0);
  else if (((windowWithHandle(fFrameWindowData->motifClient))!=0) &&
           (windowWithHandle(fFrameWindowData->motifClient)->isValid()))
    return ((windowWithHandle(fFrameWindowData->motifClient))->handle());
  else
    return (0);
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::client                                                         |
------------------------------------------------------------------------------*/
IWindow *IFrameWindow::client ( ) const
{
  return IWindow::windowWithHandle( this->clientHandle() );
}

/*------------------------------------------------------------------------------
| IFrameWindow::setClient                                                      |
|                                                                              |
| Sets one of the frame's children as the client area.                         |
| Notes: First, if there is a current client control (different than the       |
|          argument) then disable and hide that control, and set its           |
|          identifier to an unused value.                                      |
|        Next, set the pClient member to the argument.  If it really is a      |
|          client (pointer not 0) then set its parent and owner to this frame  |
|          and set its window ID to FID_CLIENT.                                |
|        If the client changed, refresh the frame.                             |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setClient ( IWindow *newClient )
{
  IMODTRACE_DEVELOP( "IFrameWindow::setClient" );

  IASSERTPARM( (newClient != this) && (newClient != 0) );

  IWindowHandle previousClient = this->clientHandle();
  IWindowHandle newClientHandle = 0;
#ifdef IC_MOTIF
  fFrameWindowData->motifClient = newClient->handle();
#endif

  bool
    updateIt       = false;
  bool
    showing        = this->isVisible(),
    clientHasFocus = false;

#ifdef IC_PMWIN
  // Check for case where previous client is 0.
  clientHasFocus = ( previousClient && ( previousClient ==
                     IQUERYFOCUS( IWindow::desktopWindow()->handle() )));
#endif

  if ( newClient )
  {
     IASSERTPARM( IWindow::isWindowValid(newClient) );
     newClientHandle = newClient->handle();
  }

  if ( previousClient != newClientHandle )
  {
     // If there is a previous client, save some state information about
     // the client in case it is re-added later.  Need to do this
     // before enableUpdate to get valid visibility information.
     unsigned long oldClientID = IC_ID_BASE;
     if (previousClient)
     {
#ifdef IC_PMWIN
        // Determine a new window identifier for the old client.
        do
        {
           oldClientID--;
           // Handle unlikely event that all IDs are in use.
           IASSERTSTATE( oldClientID != 0 );
        }
        while (IWINDOWFROMID( this->handle(), oldClientID )) ;
#endif // IC_PMWIN

        IWindow* clientWin = windowWithHandle( previousClient );
        if (clientWin)
        {
           IFrameWindowChildData* childSettings = (IFrameWindowChildData*)
              clientWin->windowData( IFrameWindowData::fClassDataHandle);
           if (!childSettings)
           {
              childSettings = new IFrameWindowChildData( clientWin );
              clientWin->adoptWindowData(
                 IFrameWindowData::fClassDataHandle, childSettings );
           }
           childSettings->saveWindowSettings();
        }
     }

     if (showing)
        this->enableUpdate( false );

     if ( clientHasFocus )
        this->setFocus();

     if ( previousClient )
     {
        // Hide, disable, and assign a new ID to the old client.
        ISHOWWINDOW( previousClient, false );
        IENABLEWINDOW( previousClient, false );
        ISETIDOF( previousClient, oldClientID );
     }
     if ( newClient )
     {
#ifdef IC_PMWIN
        newClient -> setParent( this );
#endif //IC_PMWIN
        // If the new client has been a client or an extension previously,
        // restore the settings before we changed them.
        IFrameWindowChildData* childSettings = (IFrameWindowChildData*)
           newClient->windowData( IFrameWindowData::fClassDataHandle);
        if (childSettings)
        {
           childSettings->restoreWindowSettings();
        }
        // this is a nop on Motif, name(id) of a widget can't be changed.
        ISETIDOF( newClient->handle(), FID_CLIENT );
        if ( clientHasFocus )
           newClient -> setFocus();
     }
#ifdef IC_PM
     else
     {
        // To work around an OS/2 bug where the client rectangle is
        // not correct when we remove a client, we need to force an
        // extra update of the frame.
        fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
        this->update();
     }
#endif

     updateIt = true;
  }
  else
  {
     // Check for the case where setClient was done with a window
     // whose original id was FID_CLIENT.  If the frame is showing
     // compare client rectangle to see if update needed.   If not
     // showing, always set needsUpdating.  In latter case cannot call
     // clientRectFor since rect may be null and cause WinCalcFrameRect
     // to fail.
     if ( showing )
     {
        IRectangle newClientRect = IRectangle();
        if (newClient)
           newClientRect = newClient->rect();
        if (clientRectFor( this->rect() )  != newClientRect )
           updateIt = true;
     }
     else
     {
        // Always set update if not showing.
        updateIt = true;
     }
  }

  if ( updateIt )
  {
     fFrameWindowData->flags |= IFrameWindowData::needsUpdating;

     if ( showing )
     {
        this -> show();
     }
  }

  // Ensure that the client window gets shown.
  newClient->show();

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::addExtension                                                   |
|                                                                              |
| Create and add new extensions.                                               |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::addExtension ( IWindow       *newExtension,
                                           Location       location,
                                           unsigned long  widthOrHeight,
                                           SeparatorType  separator )
{
  return this -> addExtension( new IFrameExtension( newExtension,
                                                    location,
                                                    widthOrHeight,
                                                    separator ) );
}

/*------------------------------------------------------------------------------
| IFrameWindow::addExtension                                                   |
|                                                                              |
| Convert width/height arg to unsigned long and use overloaded function.       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::addExtension ( IWindow       *newExtension,
                                           Location       location,
                                           int            widthOrHeight,
                                           SeparatorType  separator )
{
  return this -> addExtension( newExtension,
                               location,
                               (unsigned long)widthOrHeight,
                               separator );
}

/*------------------------------------------------------------------------------
| IFrameWindow::addExtension                                                   |
|                                                                              |
| Create and add new extensions.                                               |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::addExtension ( IWindow       *newExtension,
                                           Location       location,
                                           double         percentage,
                                           SeparatorType  separator )
{
  return this -> addExtension( new IFrameExtension( newExtension,
                                                    location,
                                                    percentage,
                                                    separator ) );
}

/*------------------------------------------------------------------------------
| IFrameWindow::addExtension                                                   |
|                                                                              |
| Create and add new extensions.                                               |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::addExtension ( IWindow       *newExtension,
                                           Location       location,
                                           SeparatorType  separator )
{
  return this -> addExtension( new IFrameExtension( newExtension,
                                                    location,
                                                    separator ) );
}

/*------------------------------------------------------------------------------
| IFrameWindow::addExtension                                                   |
|                                                                              |
| If this is the first extension, create the collection.  Add the argument     |
| extension at end of sequence.                                                |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::addExtension ( IFrameExtension *extension )
{
  IMODTRACE_DEVELOP( "IFrameWindow::addExtension" );
  IASSERTPARM ( extension->control() != 0 );
  bool
    alreadyUsed = false;

  IFrameExtensions
   *exts = this->extensions();

  if ( !exts )
     this -> setExtensions( exts = new IFrameExtensions );
  else
  {
     unsigned long
       result = exts->numberOfElements();
     while ( result )
       if ( exts->elementAtPosition( result )->control()
                                    == extension->control() )
       {
          alreadyUsed = true;
          break;
       }
       else
          result--;
  }

  if ( alreadyUsed || extension->control()->handle() == this->clientHandle() )
  {
     ITHROWLIBRARYERROR( IC_FRAME_EXTENSION_IN_USE,
                         IBaseErrorInfo::invalidParameter,
                         IException::recoverable );
  }

  exts -> addAsLast( extension );
  if ( extension->control()->parent() != this)
  {
#ifdef IC_PMWIN
    extension->control() -> setParent( this );
#endif
#ifdef IC_MOTIF
    ITRACE_DEVELOP( "This should not happen!, throw an exception?" );
#endif
  }

  // Check for the case where we have previously removed this
  // window and saved its settings.  Restore them.
  IFrameWindowChildData* childSettings = (IFrameWindowChildData*)
     extension->control()->windowData(IFrameWindowData::fClassDataHandle);
  if (childSettings)
     childSettings->restoreWindowSettings();

  fFrameWindowData->flags |= IFrameWindowData::needsUpdating;

  if ( this->isVisible() )
  {
    this -> show();
  }

  // Ensure the frame extension gets shown.
  extension->control()->show();

  return *this;
}

/*------------------------------------------------------------------------------
| bool IFrameWindow::isAnExtension                                             |
------------------------------------------------------------------------------*/
bool IFrameWindow::isAnExtension( const IWindow* window ) const
{
  IFrameExtensions *exts = this->extensions();
  if ( exts )
  {
     unsigned long
       result = exts->numberOfElements();
     while ( result )
     {
        if ( exts->elementAtPosition( result )->control() == window )
           return true;
        else
           result--;
     }
  }
  return false;
}

/*------------------------------------------------------------------------------
| IFrameWindow::findExtension                                                  |
|                                                                              |
| Iterate over extensions, looking for the one matching the argument IWindow   |
| pointer.  If not found, throw exception.                                     |
------------------------------------------------------------------------------*/
unsigned IFrameWindow::findExtension ( IWindow *window )
{
  IFrameExtensions
   *exts = this->extensions();

  unsigned long
    result = 0;

  if ( exts )
  {
     result = exts->numberOfElements();
     while ( result )
       if ( exts->elementAtPosition( result ) -> control() == window )
          break;
       else
          result--;
  }

  if ( !result )
  {
     ITHROWLIBRARYERROR( IC_FRAME_EXTENSION_NOT_FOUND,
                         IBaseErrorInfo::invalidParameter,
                         IException::recoverable );
  }

  return (unsigned)result;
}

/*------------------------------------------------------------------------------
| IFrameWindow::removeExtension                                                |
|                                                                              |
| Search the extensions for argument window.  If found, remove this extension  |
| and delete it.  Otherwise, throw exception.                                  |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::removeExtension ( IWindow *extension,
                                              bool     updateDisplay )
{
  IMODTRACE_DEVELOP( "IFrameWindow::removeExtension" );

  IFrameExtensions
   *exts = this->extensions();

  unsigned long
    n = 0;

  if ( exts )
  {
     n = exts->numberOfElements();
     while ( n )
        if ( exts->elementAtPosition( n ) -> control() == extension )
           break;
        else
           n--;
  }

  if ( n )
  {
     IFrameExtension
      *ext = this->extensions() -> elementAtPosition( n );
     this->extensions() -> removeAtPosition( n );
     delete ext;

     if ( updateDisplay )
     {
        // Save some state information about the extension in case
        // it is re-added later.
        IFrameWindowChildData* childSettings = (IFrameWindowChildData*)
           extension->windowData( IFrameWindowData::fClassDataHandle);
        if (!childSettings)
        {

           childSettings = new IFrameWindowChildData( extension );
           extension->adoptWindowData(
              IFrameWindowData::fClassDataHandle, childSettings );
        }
        childSettings->saveWindowSettings();

        bool
          reShow = this -> isVisible();
        if ( reShow )
           this->enableUpdate( false );
        if ( extension -> isValid() )
        {
           if ( extension -> hasFocus() )
              this->setFocus();

           // Hide and disable the extension so it does not interfere
           // with navigation.
           (*extension)
             .hide()
             .disable();
        }

        fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
        if ( reShow )
        {
           this -> show();
        }
     }
  }

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setExtensionSize                                               |
|                                                                              |
| Locate extension and reset its size.                                         |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setExtensionSize ( IWindow *extension,
                                               unsigned long widthOrHeight )
{
  unsigned
    n = this -> findExtension( extension );
  if ( n )
  {
     this->extensions() -> elementAtPosition( n ) -> setSize( widthOrHeight );
     fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
     if ( this->isVisible() )
        this->update();
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setExtensionSize                                               |
|                                                                              |
| Convert width/height arg to unsigned long and use overloaded function.       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setExtensionSize ( IWindow *extension,
                                               int      widthOrHeight )
{
  return this->setExtensionSize( extension, (unsigned long)widthOrHeight );
}

/*------------------------------------------------------------------------------
| IFrameWindow::setExtensionSize                                               |
|                                                                              |
| Locate extension and reset its size.                                         |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setExtensionSize ( IWindow *extension,
                                               double   widthOrHeight )
{
  unsigned
    n = this -> findExtension( extension );
  if ( n )
  {
     this->extensions() -> elementAtPosition( n ) -> setSize( widthOrHeight );
     fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
     if ( this->isVisible() )
        this->update();
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::useExtensionMinimumSize                                        |
|                                                                              |
| Locate extension and change its type to be based on its minimum size.        |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::useExtensionMinimumSize ( IWindow *extension )
{
  unsigned n = this->findExtension( extension );
  if ( n )
  {
     this->extensions()->elementAtPosition( n )->useMinimumSize();
     fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
     if ( this->isVisible() )
        this->update();
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::show                                                           |
|                                                                              |
| Update the frame (if necessary) then invoke inherited version.               |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::show ( bool showWindow )
{
#ifdef IC_PMWIN
  if ( showWindow )
  {
     this -> update();
  }
  Inherited::show( showWindow );
#endif
#ifdef IC_MOTIF
  bool deferPopup(false);
  if ( showWindow )
  {
     fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
     if ( XtIsRealized( fFrameWindowData->shell ))
     {
       // if we are already showing then call update now, otherwise wait until
       // the main window is realized( ie gets a map notify ) before calling update.
       this -> update();
     }
     // first realize the app shell if we need to.

     // we use the following test to tell when the VB is setting the frame
     // widget. If the shell is not a top level shell then the vb has supplied
     // a widget to use. In this case we should not realize the desktop window.
     if (XtIsTopLevelShell( fFrameWindowData->shell) )
     {
       if ( !XtIsRealized( IWindow::desktopWindow()->handle() ) )
       {
          XtRealizeWidget( IWindow::desktopWindow()->handle() );
       }
     }
     // If this frame is owned by another frame or is the child of another
     // frame, we need to set resources to achieve the desired behavior.
     // If this is a child frame, we use the parent (and ignore the owner)
     // Otherwise, we use the owner if there is one.
     IFrameWindow* frame(0);
     Widget groupWidget = XtParent(handle());
     if ((groupWidget != 0) && (groupWidget != IWindow::desktopWindow()->handle()))
     {
        // groupWidget will be parent of this frame.
        while (!((XtIsApplicationShell(groupWidget)) ||
                (XtIsTopLevelShell(groupWidget)) ))
           groupWidget = XtParent(groupWidget);
        IWindow* win = IWindow::windowWithHandle(groupWidget);
        // Get a pointer to the groupWidget frame
        frame = (IFrameWindow*)
           ( (win && win->isFrameWindow()) ? win : 0);
     }
     else
     {
        // groupWidget will be owner of this frame if it is a frame.
        IWindow* win = this->owner();
        if (win && (win != IWindow::desktopWindow()) && win->isFrameWindow() )
        {
            frame = (IFrameWindow*)win;
            groupWidget = frame->handle();
        }
        else
        {
            groupWidget = 0;
        }
     }

     // If there is a groupWidget, set the necessary resources.
     if (groupWidget)
     {
        if (XtIsRealized( groupWidget ) || !frame || this->isModal() )
        {   // If groupWidget is realized (have info needed), groupWidget
            // is not an IFrameWindow (can't do anything) or this is a
            //  modal show, go ahead and show the window now.
            IArgList args;
            args.setResource(XmNtransient, True);
            args.setResource( XmNwindowGroup, XtWindow(groupWidget) );
            XtSetValues(fFrameWindowData->shell,
                        (ArgList)args.argList(), args.numberOfArgs() );
        }
        else
        {   // The groupWidget is an IFrameWindow but is not showing.  We need
            // to defer the XtPopup until the groupWidget is realized and
            // we can use its Window.  Save the handle of this frame
            // into a list in the groupWidget.  The groupWidget pops up these
            // shell's when it is realized.
            ITRACE_DEVELOP("IFrameWindow::show - delayed popup");
            deferPopup = true;
            if (!frame->fFrameWindowData->fDeferredActions)
                frame->fFrameWindowData->fDeferredActions = new IFrameWindowDeferred;
            IFrameWindowDeferredAction* action =
                new IFrameWindowDeferredAction((long)this->handle().asUnsigned());
            frame->fFrameWindowData->fDeferredActions->add( action );
        }
     }
  }
  if (!deferPopup)
     Inherited::show( showWindow );

  // Popup or down the shell, depending on whether we are showing or hiding
  if (showWindow)
  {
     if (!deferPopup)
     {
        if (XtIsTopLevelShell( fFrameWindowData->shell) )
        {
          XtPopup(fFrameWindowData->shell, XtGrabNone);
        }
        // The following code runs when this widget is first realized.  It
        // is needed to apply operations which only work correctly when the
        // widget is realized.
        if (fFrameWindowData->fDeferredActions )
        {
            ITRACE_DEVELOP("IFrameWindow::show - applying deferred actions");
            IFrameWindowDeferred::Cursor cursor(*fFrameWindowData->fDeferredActions);
            for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
            {
                IFrameWindowDeferredAction* action = cursor.element();
                action->applyTo( this );
                delete action;
            }
            delete fFrameWindowData->fDeferredActions;
            fFrameWindowData->fDeferredActions = 0;
        }
     }
  }
  else
  {
    // only popdown the window if it is a topLevelShell. Other
    // wise we did not create it, and it is up to the supplier
    // to figure out how to hide it.
    if (XtIsTopLevelShell( fFrameWindowData->shell) )
    {
      XtPopdown(fFrameWindowData->shell);
    }
  }
#endif //IC_MOTIF

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::update                                                         |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::update ( bool forceUpdate )
{
  if ( (fFrameWindowData->flags & IFrameWindowData::needsUpdating) ||
        forceUpdate )
  {
     fFrameWindowData->flags &= ~IFrameWindowData::needsUpdating;
#ifdef IC_MOTIFWIN
     // Set the needsClientSized flag so we know to recalculate the stored
     // logical client rectangle during the update processing.
     fFrameWindowData->flags |= IFrameWindowData::needsClientSized;
     this -> sendEvent( IC_UM_UPDATEFRAME );
#endif

#ifdef IC_PM
     this -> sendEvent( WM_UPDATEFRAME, ~0 );
#endif  // !IC_WIN
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setDestroyOnClose                                              |
|                                                                              |
| Sets the destroy window flag on or off.                                      |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setDestroyOnClose ( bool destroy )
{
  if ( destroy )
     fFrameWindowData->flags |= IFrameWindowData::destroyOnClose;
  else
     fFrameWindowData->flags &= ~IFrameWindowData::destroyOnClose;

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::willDestroyOnClose                                             |
|                                                                              |
| Returns the state of the destroy window flag.                                |
------------------------------------------------------------------------------*/
bool IFrameWindow::willDestroyOnClose ( ) const
{
  if ( fFrameWindowData->flags & IFrameWindowData::destroyOnClose )
     return true;
  else
     return false;
}

/*------------------------------------------------------------------------------
| IFrameWindow::isFlashing                                                     |
------------------------------------------------------------------------------*/
bool IFrameWindow::isFlashing ( ) const
{
  ITRACE_MOTIF_NOP();

#ifdef IC_WIN
  return fFrameWindowData->ftimer ? true : false;
#endif //IC_WIN
#ifdef IC_PM
  unsigned short
    flags = this -> windowUShort( QWS_FLAGS );
  return ( flags & FF_FLASHWINDOW ) ? true : false;
#endif //IC_PM
#ifdef IC_MOTIF
  return false; // Motif does not support flashing windows
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::isMaximized                                                    |
------------------------------------------------------------------------------*/
bool IFrameWindow::isMaximized ( ) const
{
  ITRACE_MOTIF_NOP();

  return( (this->style() & IFrameWindow::maximized.asUnsignedLong())
                 ?  true
                 :  false );
}

/*------------------------------------------------------------------------------
| IFrameWindow::isMinimized                                                    |
------------------------------------------------------------------------------*/
bool IFrameWindow::isMinimized ( ) const
{
#ifdef IC_PMWIN
  return( (this->style() & IFrameWindow::minimized.asUnsignedLong())
                 ?  true
                 :  false );
#endif //IC_PMWIN

#ifdef IC_MOTIF
  unsigned long * property = NULL;
  unsigned long nitems;
  unsigned long leftover;
  Atom xa_WM_STATE, actual_type;
  int actual_format;
  int status;
  bool isMin = false;
  Screen *screen = XtScreen( (Widget)IWindow::desktopWindow()->handle() );

  xa_WM_STATE = XInternAtom(
                    screen->display,                // Display
                    "WM_STATE",
                    False);

  status = XGetWindowProperty( screen->display,
                               XtWindow( (Widget)fFrameWindowData->shell ),
                               xa_WM_STATE, 0L, 1,
                               False, xa_WM_STATE, &actual_type,
                               &actual_format, &nitems, &leftover,
                               (unsigned char **)&property);

  if ( ! ((status == Success) &&
         (actual_type == xa_WM_STATE) &&
         (nitems == 1)))
  {
     if (property)
     {
        XFree((char *)property);
        property = NULL;
     }
  }
  else if (*property == IconicState)
     isMin = True;

  return ( isMin );
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::isModal                                                        |
------------------------------------------------------------------------------*/
bool IFrameWindow::isModal ( ) const
{
  return fFrameWindowData->flags & IFrameWindowData::modal;
}

/*------------------------------------------------------------------------------
| IFrameWindow::addToWindowList                                                |
|                                                                              |
| Adds this frame's title as a window list entry.                              |
| Notes: Get title text from title bar.                                        |
|        If the frame already has a window list entry, change it.              |
|        Otherwise, add a new entry.                                           |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::addToWindowList ( )
{
  IMODTRACE_DEVELOP( "IFrameWindow::addToWindowList" );
  ITRACE_MOTIF_NOP();

#ifdef IC_WIN
  // This is only advertised to work in Windows 95.   The
  // WS_EX_APPWINDOW controls the placement of the minimized application
  // in the task bar.
  unsigned long exStyle = GetWindowLong( this->handle(), GWL_EXSTYLE );
  exStyle |= WS_EX_APPWINDOW;
  SetWindowLong( this->handle(), GWL_EXSTYLE, exStyle );
#endif //IC_WIN

#ifdef IC_PM
  IWindowHandle                       // Get window title.
    hwndTitleBar = this -> handleFor( titleBar );

  if (hwndTitleBar == 0)
  {
     ITHROWGUIERROR( "" );
  } /* endif */

  ULONG uLen = IQUERYWINDOWTEXTLENGTH( hwndTitleBar );
  ++uLen;
  IString
    buffer( 0, MAXNAMEL + 1 );

  if ( uLen > 1 )
  {
     IQUERYWINDOWTEXT( this->handle(), MAXNAMEL + 1, buffer );
  } /* endif */
  /*********************************************************/
  /* Add or change window list entry.                      */
  /*********************************************************/
  HSWITCH hsw = WinQuerySwitchHandle( this->handle(), 0 );
  if ( hsw == 0 )
  {
     SWCNTRL swctl;
     swctl.hwnd = this->handle();
     swctl.hwndIcon = this->icon();
     swctl.hprog = 0;
     swctl.idProcess = IApplication::current().id();
     swctl.idSession = 0;
     swctl.uchVisibility = SWL_VISIBLE;
     swctl.fbJump = SWL_JUMPABLE;
     strcpy( swctl.szSwtitle, buffer );

     // Create the switch entry.
     HSWITCH hswitch;
     hswitch = WinCreateSwitchEntry( IThread::current().anchorBlock(),
                                     &swctl );
     if ( hswitch == 0 )
     {
        ITHROWGUIERROR( "WinCreateSwitchEntry" );
     } /* endif */
  }
  else
  {
     SWCNTRL swctl;
     unsigned long rc = WinQuerySwitchEntry( hsw, &swctl );

     strcpy( swctl.szSwtitle, buffer );
     rc = WinChangeSwitchEntry( hsw, &swctl );

     if ( rc != 0 )
     {
        ITHROWGUIERROR( "WinChangeSwitchEntry" );
     } /* endif */
  } /* endif */
#endif //IC_PM

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::removeFromWindowList                                           |
|                                                                              |
| Remove this frame's window list entry.                                       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::removeFromWindowList ( )
{
  IMODTRACE_DEVELOP( "IFrameWindow::removeFromWindowList" );
  ITRACE_MOTIF_NOP();

#ifdef IC_WIN
  // This is only advertised to work in Windows 95.   The
  // WS_EX_APPWINDOW controls the placement of the minimized application
  // in the task bar.
  unsigned long exStyle = GetWindowLong( this->handle(), GWL_EXSTYLE );
  exStyle &= (unsigned long)~WS_EX_APPWINDOW;
  SetWindowLong( this->handle(), GWL_EXSTYLE, exStyle );
#endif //IC_WIN

#ifdef IC_PM
  HSWITCH hswitch = WinQuerySwitchHandle( this->handle(), 0 );

  if ( hswitch != 0 )
  {
     if ( WinRemoveSwitchEntry( hswitch ) != 0 )
     {
        ITHROWGUIERROR( "WinRemoveSwitchEntry" );
     }
  }
#endif //IC_PM

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::handleFor                                                      |
|                                                                              |
| Return the IWindowHandle corresponding to a standard frame control.          |
| Notes: Determine the appropriate FID_* value for the requested control.      |
|        Then, issue handleWithId to get the corresponding window handle.      |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::handleFor ( const Style &standardControl ) const
{
#ifdef IC_PMWIN
  IWindowHandle
    result(0);
  unsigned long
    id = 0;
  if ( standardControl == horizontalScroll )
     id = FID_HORZSCROLL;
  else if ( standardControl == verticalScroll )
     id = FID_VERTSCROLL;
#ifdef IC_PM
  else if ( standardControl == hideButton
            ||
            standardControl == minimizeButton
            ||
            standardControl == maximizeButton )
     id = FID_MINMAX;
  else if ( standardControl == menuBar )
     id = FID_MENU;
  else if ( standardControl == titleBar )
     id = FID_TITLEBAR;
  else if ( standardControl == systemMenu )
     id = FID_SYSMENU;
#endif // IC_PM
  if ( id )
     result = IWindow::handleWithParent( id, this->handle() );
  return result;
#endif  //IC_PMWIN

#ifdef IC_MOTIF
  Widget control = 0;
  char*  controlResource = 0;
  if (standardControl == horizontalScroll)
     controlResource = XmNhorizontalScrollBar;
  else if (standardControl == verticalScroll)
     controlResource = XmNverticalScrollBar;
  if (controlResource)
  {
     XtVaGetValues( fFrameWindowData->mainW,
                    controlResource, &control,
                    NULL );
  }
  return IWindowHandle( control );
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::beginFlashing                                                  |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::beginFlashing ( )
{
  ITRACE_MOTIF_NOP();

#ifdef IC_WIN
  if (!fFrameWindowData->ftimer)
  {
     // Start the timer to begin the flashing...The timerExpired function
     // periodically flashes the window until endFlashing is called.
     fFrameWindowData->ftimerHwnd = this->handle();
     fFrameWindowData->ftimer =
        new ITimer ( new ITimerMemberFn<IFrameWindowData> (
                            *fFrameWindowData, &IFrameWindowData::timerExpired ),
                     500 );
     // Do the first time
     IFLASHWINDOW( this->handle(), true );
  }
#endif  //IC_WIN
#ifdef IC_PM
  bool bFlash = IFLASHWINDOW( this->handle(), true );
  if ( !bFlash )
     ITHROWGUIERROR( "WinFlashWindow" );
#endif  //IC_PM
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::endFlashing                                                    |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::endFlashing ( )
{
  ITRACE_MOTIF_NOP();

#ifdef IC_WIN
  if (fFrameWindowData->ftimer)
  {
     // Stop the timer to end the flashing.
     fFrameWindowData->ftimer->stop();
     fFrameWindowData->ftimerHwnd = 0;
     delete fFrameWindowData->ftimer;
     fFrameWindowData->ftimer = 0;
     // make sure the window is returned to original state
     IFLASHWINDOW( this->handle(), false );
  }
#endif  //IC_WIN
#ifdef IC_PM
  bool bFlash = IFLASHWINDOW( this->handle(), false );
  if ( !bFlash )
     ITHROWGUIERROR( "WinFlashWindow" );
#endif
  return *this;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IFrameWindowData::timerExpired                                               |
------------------------------------------------------------------------------*/
void IFrameWindowData::timerExpired( unsigned long  )
{
   if (ftimerHwnd.asUnsigned())
   {
      // valid handle ... flash it
      IFLASHWINDOW( ftimerHwnd, true );
   }
}
#endif

#ifdef IC_PM
/*------------------------------------------------------------------------------
| IFrameWindow::shareParentDBCSStatus                                          |
|                                                                              |
| Causes a child frame to share the DBCS status control of its parent.         |
| Notes: Get DBCS environment info.                                            |
|        If in a DBCS environment, issue calls to share parent's DBCS status   |
|        area control.                                                         |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::shareParentDBCSStatus ( )
{
  IMODTRACE_DEVELOP( "IFrameWindow::shareParentDBCSStatus" );

  COUNTRYCODE
    countryCode = { 0 };
  char
    buffer[12];

  // Get OS/2 DBCS info...
  DosQueryDBCSEnv( sizeof( buffer ), &countryCode, buffer );

  // See if DBCS environment is active...
  if ( buffer[0] || buffer[1] )
  {
     // DBCS active, hook to parent DBCS status area...
     IDynamicLinkLibrary
       dbcsLib( "pmnlsssc" );

     typedef int (_System * T1)( HAB, HWND, ULONG, PIMEMODE );

     IProcedureAddress< T1 >
       entryPt1( "WIN32DBCSIMECONTROL", dbcsLib );

     if ( entryPt1 )
     {
       IMODTRACE_DEVELOP( "Calling WIN32DBCSIMECONTROL" );
       IMEMODE
         imemode;
       imemode.lenIMEMODE = sizeof( imemode );
       imemode.fIMEMode = DBE_IMCTL_INHERIT_PFRAME;
       entryPt1( IThread::current().anchorBlock(),
                 this->handle(),
                 DBE_IMCTL_SET,
                 &imemode );
     }

     typedef int (_System * T2)( HAB, HWND, ULONG, ULONG, PUSHORT );

     IProcedureAddress< T2 >
       entryPt2( "WIN32DBCSMODECONTROL", dbcsLib );

     if ( entryPt2 )
     {
       IMODTRACE_DEVELOP( "Calling WIN32DBCSMODECONTROL" );
       USHORT
         mode = DBE_MCTL_INHERIT_PFRAME;
         entryPt2( IThread::current().anchorBlock(),
                   this->handle(),
                   DBE_MCTL_SET,
                   DBE_MCTL_INPUTMODEREQUEST,
                   &mode );
     }
  }

  return *this;
}
#endif  //IC_PM

/*------------------------------------------------------------------------------
| IFrameWindow::setDefaultOrdering                                             |
|                                                                              |
| Static function that sets the default placement of new windows.              |
------------------------------------------------------------------------------*/
void IFrameWindow::setDefaultOrdering ( IWindow::SiblingOrder ordering )
{
  IFrameWindow::siblingCreateOrder = ordering;

}

/*------------------------------------------------------------------------------
| IFrameWindow::defaultOrdering                                                |
|                                                                              |
| Static function that returns the default placement of new windows.           |
------------------------------------------------------------------------------*/
IWindow::SiblingOrder IFrameWindow::defaultOrdering ( )
{

  return IFrameWindow::siblingCreateOrder;
}

/*------------------------------------------------------------------------------
| IFrameWindow::tryToLoadDialog                                                |
|                                                                              |
| Attempt to load the dialog window and if it fails, calls initialize.         |
| Notes: Initialize PM before trying to load the resource.                     |
|        Attempt to load the dialog template.                                  |
|        Note: No attempt will be made to load a system menu icon, or          |
|              accelerator table for the dialog.                               |
|              It looks like WinNT will load a menu bar, while PM won't.       |
|        If that fails, try to create a plain frame by calling initialize().   |
|        Otherwise, "start" the dialog by calling "start".                     |
|        Some of these steps will be skipped, based on the value of the        |
|        passed-in FrameSource enumerator.                                     |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::tryToLoadDialog ( const IResourceId &resId,
                                              IWindow           *parent,
                                              IWindow           *owner,
                                              FrameSource        source )
{
  IMODTRACE_DEVELOP( "IFrameWindow::tryToLoadDialog" );

  if ( source != dialogResource  &&
       source != noDialogResource  &&
       source != tryDialogResource )
  {           // Validate the enumerator value.
     ITHROWLIBRARYERROR( IC_INVALIDENUMVALUE,
                         IBaseErrorInfo::invalidParameter,
                         IException::recoverable );
  }

#ifdef IC_MOTIF
  source = noDialogResource;     // dialog resources not supported
#endif //IC_MOTIF

  IWindowHandle
    dialog( 0 );

  IThread::current().initializeGUI();

  IWindowHandle
    hParent = ( parent ) ? parent->handle() : IWindow::desktopWindow()->handle(),
    hOwner  = ( owner )  ? owner->handle()  : IWindowHandle( 0 );

#ifdef IC_WIN
  // Some applications may have some of the controls in a resource file
  // so we need to load the DLL before the dialog so that the window
  // classes are registered.
  IControlStatics::loadControlDLL();
#endif

  if ( source != noDialogResource )
  {           // Try to load dialog resource.
#ifdef IC_WIN
     dialog = ILOADDLG( hParent,
                        hOwner,
                        (DLGPROC)_pfnwpICDlgProc,
                        resId.resourceLibrary().handle(),
                        resId.id(),
                        0 );
#endif //IC_WIN
#ifdef IC_PM
     dialog = ILOADDLG( hParent,
                        hOwner,
                        WinDefDlgProc,
                        resId.resourceLibrary().handle(),
                        resId.id(),
                        0 );
#endif //IC_PM
  }

  if ( dialog )
  {           // Dialog was loaded successfully.
     fFrameWindowData->flags |= IFrameWindowData::fromDlgTemplate;
     fFrameWindowData->flags &= ~IFrameWindowData::standardFrame;

#ifdef IC_WIN
     // Make sure we update so that we pick up the list of child controls
     fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
     if ( hParent != hOwner )
     {
        // ILOADDLG (CreateDialogParm) ignores the parent and
        // appears to set it to the owner.
        if ( hParent != IWindow::desktopWindow()->handle() )
        {
           ISETPARENT( dialog, hParent, TRUE );
        }
     }
     // set the extra window longword with the ID
     ISETIDOF( dialog, resId.id() );

     // Must set this style so that control wrappers for controls loaded
     // from a dlg template properly paint their backgrounds.
//     this->setExtendedStyle( this->extendedStyle() |
//                             dialogBackground.asExtendedUnsignedLong() );
     fCopyOfStyle |= IFrameWindow::dialogBackground;

     // If the dialog has standard scroll bars, we need to replace them
     // with scroll bar controls so they can be wrappered/handled.
     unsigned long dialogStyle = ISTYLEOF( dialog );
     if (dialogStyle & (WS_HSCROLL | WS_VSCROLL))
     {
        ISETWINDOWSTYLE( dialog,
                         dialogStyle &
                           (unsigned long) ~(WS_HSCROLL | WS_VSCROLL) );
        // Need to repaint the non-client area prior to adding the scroll bar
        // control(s).  This is necessary in order to remove the standard
        // scroll bars and get the new client rectangle.
        SetWindowPos( dialog,
                      NULL,
                      0, 0, 0, 0,
                      SWP_FRAMECHANGED | SWP_NOACTIVATE
                       | SWP_NOSIZE | SWP_NOMOVE | SWP_NOZORDER);

        fFrameWindowData->createScrollBar( dialog, dialogStyle );
     }
#endif  // IC_WIN
     this -> start( dialog );
  }
  else
  {           // Dialog was not loaded.
     IGUIErrorInfo loadDlgError( "ILOADDLG" );

     ITRACE_DEVELOP(IString("CreateDialogParam errorId=") +
                    IString(loadDlgError.errorId())   );
#ifdef IC_WIN
     if ( source == noDialogResource  ||
          ( source == tryDialogResource  &&
            ( loadDlgError.errorId() == ERROR_RESOURCE_DATA_NOT_FOUND  ||
              loadDlgError.errorId() == ERROR_RESOURCE_TYPE_NOT_FOUND  ||
              loadDlgError.errorId() == ERROR_RESOURCE_NAME_NOT_FOUND  ||
              (IPlatform::isWin9x()) )))           // Win95 build 950 returns 0
#endif //IC_WIN
#ifdef IC_PM
     if ( source == noDialogResource  ||
          ( source == tryDialogResource  &&
            ( loadDlgError.errorId() == PMERR_RESOURCE_NOT_FOUND )))
#endif //IC_PM
#ifdef IC_MOTIF
     if ( source == noDialogResource )
#endif //IC_MOTIF
     {         // Dialog was not found, try to create new frame window.
        // When the frame window rectangle is allowed to default, we use
        // the system recommended position without coordinate conversion.
        // This is so that resizing the frame will work as expected with
        // the application implemented in application coordinates.  To
        // implement this, we convert the application coordinates returned
        // by nextShellRect back to native before calling initialize.
        IRectangle initRect = IFrameWindow::nextShellRect();
        if ( ICoordinateSystem::isConversionNeeded() )
        {
           initRect = ICoordinateSystem::convertToNative(
                         initRect,
                         desktopWindow()->size() );
        }

        this -> initialize( resId,
                            IFrameWindow::defaultStyle(),
                            parent,
                            owner,
                            initRect,
                            0 );
     }
     else
     {         // Dialog was not found, error case.
        loadDlgError.throwError( IEXCEPTION_LOCATION() );
     }
  }

  return *this;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| _pfnwpICDlgProc                                                              |
|                                                                              |
| Dialog procedure for Windows to call.                                        |
------------------------------------------------------------------------------*/
LRESULT CALLBACK _pfnwpICDlgProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )

{
  IMODTRACE_ALL("_pfnwpICDlgProc");
  ITRACE_ALL( IString("_pfnwpICDlgProc hwnd=" ) +
              IString( (unsigned long)hwnd ).d2x() +
              IString( " msg=" ) +
              IString( msg ).d2x() +
              IString( " wParam=" ) +
              IString( wParam ).d2x() +
              IString( " lParam=" ) +
              IString( lParam ).d2x() );
  switch ( msg )
  {
     case WM_INITDIALOG:
     {
        ITRACE_ALL( IString( "WM_INITDIALOG" ) );
        return true;
     }
     case WM_COMMAND:
     {
        ITRACE_ALL( IString( "WM_COMMAND " ) );
        unsigned long notifyCode = HIWORD( wParam );
        IWindowHandle hwndCtl( (HWND) lParam );
        if ( hwndCtl && ( notifyCode == BN_CLICKED ) )
        {
           // It is a control message indicating button clicked.
           // If it is an unwrappered pushbutton we need to generate
           // a WM_COMMAND to the dialog.  Wrappered pushbuttons handle
           // this with a default handler.
           unsigned long ulstyle = ISTYLEOF( hwndCtl ) & BS_PRIMARYSTYLES;
           if ( (ulstyle == BS_DEFPUSHBUTTON ) ||
                (ulstyle == BS_PUSHBUTTON ) )
           {
              if ( 0 == IWindow::windowWithHandle( hwndCtl ) )
              {
                 // Post the PM style WM_COMMAND.  We don't support
                 // the PM HELP or SYSCOMMAND styles on unwrappered buttons.
                 IWindowHandle hwndDlg = hwnd;
                 ITRACE_ALL( IString( "hwndDlg=" ) +
                             IString( hwndDlg.asUnsigned() ).d2x() +
                             IString( " hwnd=" ) +
                             IString( hwndCtl.asUnsigned() ).d2x() );
                 hwndDlg.postEvent( WM_COMMAND,
                                    IEventData( LOWORD( wParam ),
                                                CMDSRC_PUSHBUTTON ),
                                    0 );
              }  // unwrappered
           }  // is pushbutton
        }  // BN_CLICKED
        break;
     }  // WM_COMMAND
     default:
        break;
  }  // switch

  return false;
}

#endif // IC_WIN


/*------------------------------------------------------------------------------
| IFrameWindow::initialize                                                     |
|                                                                              |
| Specifies to use a common frame window construction.                         |
| Notes: Build arguments and call IFrameWindow::create.                        |
|        The style and frame creation flags come from the argument style.  If  |
|          shellPosition is desired, then determine the shell position and     |
|          turn off the flag (this results in better behavior for subsequent   |
|          size/position set/query calls).                                     |
|        If the IWindow::visible style is indicated, then store this fact,     |
|          create the window invisible, and do a show after the frame is       |
|          refreshed.  This is to overcome a quirk in the standard frame       |
|          whereby the first time the window is shown, the titlebar, etc. are  |
|          not drawn right.                                                    |
|        Likewise, if minimized/maximized are specified, then minimize/maximize|
|          the frame after construction.                                       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::initialize ( const IResourceId &resId,
                                         const Style       &style,
                                         IWindow           *parent,
                                         IWindow           *owner,
                                         const IRectangle  &initRect,
                                         const char        *title )
{
  IMODTRACE_DEVELOP( "IFrameWindow::initialize" );

  // Save the extended style to make sure we have a copy of it stored
  fCopyOfStyle = style;

  // Do nothing if creation is deferred.
  if ( style & IFrameWindow::deferCreation )
     return *this;

  // Determine the title of the frame window.
  IString titleString;
  if ( (style.bitwiseAnd(IFrameWindow::titleBar) == IFrameWindow::titleBar)
        && !title )
  {
     if (!(IThread::current().isGUIInitialized()))
     {
        // Initialize GUI...
        IThread::current().initializeGUI();
     }
     titleString =
        resId.resourceLibrary().tryToLoadString(resId.id());

     if ( titleString.length() )
     {
        title = titleString;
     }
     else
     {
        // Look for a frame window as a source of the title text.
        // Search owner tree for frame window
        IWindow*      titleWin(owner);
        IFrameWindow* titleFrame(dynamic_cast<IFrameWindow*>(titleWin));
        while (titleWin && !titleFrame)
        {
           titleWin = titleWin->owner();
           titleFrame = dynamic_cast<IFrameWindow*>(titleWin);
        }
        if (!titleFrame)
        {
           // Search parent tree for frame window
           titleWin = parent;
           titleFrame = dynamic_cast<IFrameWindow*>(titleWin);
           while (titleWin && !titleFrame)
           {
              titleWin = titleWin->parent();
              titleFrame = dynamic_cast<IFrameWindow*>(titleWin);
           }
        }
        if (titleFrame)
        {
           // Use the reference frame window for title.
           titleString = titleFrame->titleText();
        }
        else
        {
           // If the title is still not determined, use the application name.
#ifdef IC_WIN
           titleString = IString((void*)0, 80);
           GetModuleFileName( 0, (char*)titleString, 80 );
#endif
#ifdef IC_PM
           titleString = IString((void*)0, 80);
           WinQuerySessionTitle( IThread::current().anchorBlock(),
                                 0, (char*)titleString, 80);
#endif
#ifdef IC_MOTIF
           titleString = XtName( IThread::current().applicationShell() );
#endif
        }
        title = titleString;
     }
  }
  else if ( !(style.bitwiseAnd(IFrameWindow::titleBar)== IFrameWindow::titleBar) )
  {
#ifdef IC_PMWIN
     title = 0;      // Insure it is 0.
#endif
#ifdef IC_MOTIF
     title = " ";    // Insure it is blank. (0 would default to widget name)
#endif
  }

#ifdef IC_MOTIF
  else if ( (style.bitwiseAnd(IFrameWindow::titleBar)==IFrameWindow::titleBar)
          && (*title == NULL) )
  {
     title = " ";    // Insure it is blank. (0 would default to widget name)
  }
#endif

#ifdef IC_PMWIN
  unsigned long
    frameId    = resId.id();
  IWindowHandle
    hParent = ( parent ) ? parent->handle() : IWindow::desktopWindow()->handle(),
    hOwner  = ( owner )  ? owner->handle()  : IWindowHandle( 0 );

  IRectangle
    rect = initRect;

#ifdef IC_WIN
  // Create our window classes for the frame if necessary.
  char* frameClass = (char*)
    registerFrameClass( style, resId );
  // Get the extended styles we want to pass on
//  unsigned long exFrameStyle = convertToGUIStyle( style, true );
  HANDLE   fcdata = resId.resourceLibrary().handle();
#else
  FRAMECDATA
    fcdata;
  fcdata.cb            = sizeof( FRAMECDATA );
  fcdata.flCreateFlags = convertToGUIStyle( style, true);
  fcdata.hmodResources = resId.resourceLibrary().handle(),
  fcdata.idResources   = (unsigned short)frameId;
//  unsigned long exFrameStyle = 0;
#endif

  fFrameWindowData->isChild = ( hParent != IWindow::desktopWindow()->handle());


  // Find the parent frame window of this frame being created.
  IWindow* parentFrame = parent;
  while ( parentFrame  &&
          parentFrame->isFrameWindow() == false )
  {             // Go up the parent chain until a frame is found
     parentFrame = parentFrame->parent();
  }

#ifdef IC_PM
  // If child window, and it can share its parent's DBCS status
  // area, then suppress its status area.
  if ( fFrameWindowData->isChild  &&
       parentFrame  &&
       WinQueryWindowULong( parentFrame->handle(), QWL_STYLE ) &
                                                  FS_DBE_APPSTAT )
  {
     fcdata.flCreateFlags &= ~FCF_DBE_APPSTAT;
     // (But don't wipe out style which PM seems to ignore --
     // use the style as a flag that it uses a status area
     // for the above check.)
  }
#endif


  if ( style & IFrameWindow::shellPosition )
     rect = IFrameWindow::nextShellRect();

  // Create the window...
#ifdef IC_WIN
//  this -> create( frameId,
//                  title,
//                  frameStyle & (unsigned long)~WS_VISIBLE,
//                  frameClass,
//                  hParent,
//                  hOwner,
//                  rect,
//                  fcdata,                    // resource lib handle
//                  0,
//                  defaultOrdering(),
//                  exFrameStyle );            // extended styles

  this -> create( frameId,
                  title,
                  style,
                  frameClass,
                  parent,
                  owner,
                  rect,
                  fcdata,                    // resource lib handle
                  0,
                  defaultOrdering() );

#endif // IC_WIN
#ifdef IC_PM
//  this -> create( frameId,
//                  title,
//                  frameStyle & (unsigned long)~WS_VISIBLE
//                             & (unsigned long)~FS_SHELLPOSITION,
//                  WC_FRAME,
//                  hParent,
//                  hOwner,
//                  rect,
//                  &fcdata,
//                  0 );
  this -> create( frameId,
                  title,
                  style,
                  WC_FRAME,
                  parent,
                  owner,
                  rect,
                  &fcdata,
                  0 );
#endif //IC_PM

#ifdef IC_PM
  // If dialog background is specified, set the presentation parameter.
  if ( style & IFrameWindow::dialogBackground )
  {
     this -> setBackgroundColor         ( IColor( IColor::kDialogBgnd ) );
     this -> setDisabledBackgroundColor ( IColor( IColor::kDialogBgnd ) );
  }
#endif //IC_PM

#ifdef IC_PMWIN
  // If one or both of the minimize/maximize buttons is missing and
  // there is still a system menu, disable the corresponding item in
  // the system menu.  Disabling rather than removing is what is recommended
  // in the SDK.
  if (style & IFrameWindow::systemMenu)
  {
    ISystemMenu sysMenu(this );
#ifdef IC_WIN
    if ( !(style & IFrameWindow::minimizeButton) )
      sysMenu.disableItem( ISystemMenu::idMinimize );
    if ( !(style & IFrameWindow::maximizeButton) )
      sysMenu.disableItem( ISystemMenu::idMaximize );
#endif // IC_WIN
    // disable maximize when dialogBorder is asked for.
    if ( style & IFrameWindow::dialogBorder)
    {
      // when dialog border is asked for we don't allow maximize
      sysMenu.disableItem( ISystemMenu::idMaximize );
    }

    // if we don't have a minimize or a maximize button then remove
    // the restore button ( Note that if the dialogBorder sytle is specified
    // then we don't have maximize button.
    if (    !(style & IFrameWindow::minimizeButton) &&
          ( !(style & IFrameWindow::maximizeButton) ||
             (style & IFrameWindow::dialogBorder )) )
    {
      sysMenu.disableItem( ISystemMenu::idRestore );
    }
    if ( !(style & IFrameWindow::sizingBorder) ||
          (style & IFrameWindow::dialogBorder ) )
    {
      sysMenu.disableItem( ISystemMenu::idSize );
    }

  }
#endif // IC_PMWIN

#ifdef IC_WIN
  // Add any requested scroll bars as controls.
  if (fCopyOfStyle & (horizontalScroll | verticalScroll))
  {
     fFrameWindowData->createScrollBar( handle(), fCopyOfStyle.asUnsignedLong() );
     fCopyOfStyle &= ~(horizontalScroll | verticalScroll);
  }
#endif

  // Update the frame so controls are in place...
  fFrameWindowData->flags |= IFrameWindowData::needsUpdating;

#ifdef IC_PM
  // Connect to parent's DBCS status field, if necessary...
  if ( fFrameWindowData->isChild && (style & IFrameWindow::appDBCSStatus ))
     this -> shareParentDBCSStatus();
#endif

  // Handle max/min requests
  if ( style & IFrameWindow::minimized )
     this -> minimize();
  else if ( style & IFrameWindow::maximized )
     this -> maximize();

  // If requested, show the window...
  if ( style & IWindow::visible )
     this -> show();
#endif //IC_PMWIN

#ifdef IC_MOTIF
  unsigned long
    frameId    = resId.id();

  IWindowHandle
    hOwner  = ( owner )  ? owner->handle()  : IWindowHandle(0),
    hParent = 0;

  IRectangle
    rect = initRect;

  if ((parent != 0) && (parent != IWindow::desktopWindow()))
    hParent = parent->handleForChildCreation();
  else
    hParent = IWindow::desktopWindow()->handle();


  if ( style & IFrameWindow::shellPosition )
     rect = IFrameWindow::nextShellRect();

  // Create the window...the manager child of the MainWindow is an XmForm
  this -> create( frameId,
                  title,
                  style,
                  (IXmCreateFunction)XiclCreateCanvas,
                  parent,
                  owner,
                  rect,
                  defaultOrdering() );

  /* Create a menu bar object.  This menu bar object will be wrappered  */
  /* by IMenuBar when the menuBar ctor is called.                       */
  if (style & menuBar)
     fFrameWindowData ->frameMenu = new IMenuBar(resId, this);

  if (style & minimizedIcon)
  {
     try
     {
       setIcon(frameId);
     }

    catch(...) {}
  }

  // Try to load the accelerator table with ID matching the ID of the
  // frame window.  If successful, store it with this IWindow object.
  if ( style & IFrameWindow::accelerator )
  {
     IAccelTblHandle
       haccel = resId.resourceLibrary().loadAccelTable( frameId );
     this->setAcceleratorHandle( haccel );
  }

  if (style != IWindow::noStyle)
  {
     IWindow::setStyle (style.asUnsignedLong());
  }

  fFrameWindowData->registerCallbacks();
#endif //IC_MOTIF

  return *this;
}


#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IFrameWindow::registerFrameClass                                             |
------------------------------------------------------------------------------*/
unsigned long IFrameWindow::registerFrameClass ( const Style& style,
                                                 const IResourceId& resId )
{

  ATOM
     frameClass = 0;

  // Initialize instance handle.  This is the instance used to load
  // resources.
  HINSTANCE
     hInstance = resId.resourceLibrary().handle();

  WNDCLASS
    wndclass;

  // Prime the WNDCLASS structure by copying the standard WC_DIALOG class
  if (!GetClassInfo( 0, WC_DIALOG, &wndclass))
     ITHROWGUIERROR( "GetClassInfo" );

  // COLOR_3DFACE (same as COLOR_BTNFACE in 4.0 SDK) is what is used
  // for dialog and static backgrounds in Win95
  if (style & IFrameWindow::dialogBackground )
     wndclass.hbrBackground = (HBRUSH)(COLOR_3DFACE + 1);
  else
     wndclass.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE + 1);

  wndclass.cbWndExtra = DLGWINDOWEXTRA + 4;

  // We used to use CS_VREDRAW and CS_HREDRAW but these styles caused to many redraws of the
  // children of the frame window, most notibly the toolbar. These styles cause a WM_PAINT
  // even when a window is resize smaller.
  unsigned int
    classStyle = CS_DBLCLKS | CS_OWNDC; // | CS_VREDRAW | CS_HREDRAW ;

  // Update class style to include byte align flag if requested
  if ( !( style & IFrameWindow::alignNoAdjust ) )
  {
     classStyle |= CS_BYTEALIGNWINDOW;
  }
  wndclass.style = classStyle;


  // If minimized Icon style set, then load icon resource and place it
  // into the class structure.  Otherwise, use the default icon for dialogs.
  if ( style & IFrameWindow::minimizedIcon )
  {
     HICON
       hIcon;
     if ( !(hIcon = LoadIcon( hInstance, MAKEINTRESOURCE( resId.id() ))))
     {
        ITHROWGUIERROR( "LoadIcon" );
     }
     else
     {
        wndclass.hIcon = hIcon;
     }
  }

  // Don't register class menu as no support exists for DLL resourced menus
  wndclass.lpszMenuName = NULL;

  // set the instance
  wndclass.hInstance   = GetModuleHandle(0);

  // Register a class whose name is WC_FRAME + nnnn, where nnnn is
  // the ASCII string for the value of IFrameWindowData::fgClassID.  This
  // results in each frame window having a unique class name
  // similar to "ICL Frame1".

  IString newFrameClass;
  WNDCLASS wctemp;
  // If the class already exists try again with the next ID value.
  do
  {
     newFrameClass =  IString(WC_FRAME) +
                      IString(IFrameWindowData::fgClassID);
     IFrameWindowData::fgClassID++;
  }
  while (GetClassInfo( wndclass.hInstance, newFrameClass, &wctemp));

  wndclass.lpszClassName = newFrameClass;
  wndclass.lpfnWndProc = (WNDPROC)IDEFWINDOWPROC;
  frameClass = RegisterClass( &wndclass );
  if (!frameClass)
  {
     ITHROWGUIERROR( "RegisterClass" );
  }

  return MAKELONG( frameClass, 0 );
}
#endif // IC_WIN

#ifdef IC_MOTIFWIN
/*------------------------------------------------------------------------------
| IFrameWindowData::createScrollBar                                            |
------------------------------------------------------------------------------*/
void IFrameWindowData::createScrollBar ( IWindowHandle   hwnd,
                                         unsigned long   style )
{
   IMODTRACE_DEVELOP( "IFrameWindowData::createScrollBar" );

#ifdef IC_WIN
   if (style & ( WS_HSCROLL | WS_VSCROLL))
   {
     IWindowHandle hwndHorzScroll = 0,
                   hwndVertScroll = 0;
     if (style & WS_HSCROLL)
     {
        int scrollHeight = GetSystemMetrics( SM_CYHSCROLL );
        HINSTANCE hInst = GetModuleHandle(0);
        hwndHorzScroll = ICREATEWINDOW( hwnd,
                                        WC_SCROLLBAR,
                                        0,
                                        WS_CHILD | WS_VISIBLE | SBS_HORZ,
                                        0,
                                        0,
                                        0,
                                        scrollHeight,
                                        hwnd,
                                        HWND_BOTTOM,
                                        FID_HORZSCROLL,
                                        0,
                                        0,
                                        hInst );

        if (!hwndHorzScroll)
          ITHROWGUIERROR(IString("WinCreateWindow: Id=")+IString(FID_HORZSCROLL)+
                 IString(" Class=")+IString((unsigned short)(unsigned long)WC_SCROLLBAR));
     }

     if (style & WS_VSCROLL)
     {
        int scrollWidth = GetSystemMetrics( SM_CXVSCROLL );
        HINSTANCE hInst = GetModuleHandle(0);
        hwndVertScroll = ICREATEWINDOW( hwnd,
                                        WC_SCROLLBAR,
                                        0,
                                        WS_CHILD | WS_VISIBLE | SBS_VERT,
                                        0,
                                        0,
                                        scrollWidth,
                                        0,
                                        hwnd,
                                        HWND_BOTTOM,
                                        FID_VERTSCROLL,
                                        0,
                                        0,
                                        hInst );

        if (!hwndVertScroll)
          ITHROWGUIERROR(IString("WinCreateWindow: Id=")+IString(FID_VERTSCROLL)+
                 IString(" Class=")+IString((unsigned short)(unsigned long)WC_SCROLLBAR));
     }

     if (hwndHorzScroll || hwndVertScroll)
     {
        // Initialize scroll bars.
        SCROLLINFO scrollInfo;
        scrollInfo.cbSize = sizeof(SCROLLINFO);
        scrollInfo.fMask  = SIF_POS | SIF_RANGE;

        // Set the lower bound to 0 and upper bound to 100 which are the default
        // values for the standard frame window scrollbars.
        scrollInfo.nMin = 1;
        scrollInfo.nMax = 100;

        scrollInfo.nPos = 1;

        if (hwndHorzScroll)
        {
           SetScrollInfo( hwndHorzScroll,
                          SB_CTL,
                          &scrollInfo,
                          TRUE );
        }

        if (hwndVertScroll)
        {
           SetScrollInfo( hwndVertScroll,
                          SB_CTL,
                          &scrollInfo,
                          TRUE );
        }
        flags |= needsClientSized;
     }
  }
#endif // IC_WIN

#ifdef IC_MOTIF
  if (style &
      (IFrameWindow::horizontalScroll.asUnsignedLong()
       | IFrameWindow::verticalScroll.asUnsignedLong()))
  {
     IArgList      scrollArgs;

     scrollArgs.setResource( XmNminimum, 0 );
     scrollArgs.setResource( XmNmaximum, 100 );
     scrollArgs.setResource( XmNpageIncrement, 25 );

     if (style & IFrameWindow::horizontalScroll.asUnsignedLong())
     {
        scrollArgs.setResource( XmNorientation, XmHORIZONTAL );
        IWindowHandle
           hwndHorizontalScroll = XtCreateManagedWidget(
                                       IString( FID_HORZSCROLL ),
                                       xmScrollBarWidgetClass,
                                       hwnd,
                                       (ArgList)scrollArgs.argList(),
                                       scrollArgs.numberOfArgs() );
     }

     if (style & IFrameWindow::verticalScroll.asUnsignedLong())
     {
        scrollArgs.setResource( XmNorientation, XmVERTICAL );
        IWindowHandle
           hwndVerticalScroll = XtCreateManagedWidget(
                                       IString( FID_VERTSCROLL ),
                                       xmScrollBarWidgetClass,
                                       hwnd,
                                       (ArgList)scrollArgs.argList(),
                                       scrollArgs.numberOfArgs() );
     }
  }
#endif // IC_MOTIF
}
#endif  // IC_MOTIFWIN

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IFrameWindow::create                                                         |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::create ( unsigned long         id,
                                     const char           *title,
                                     const IBitFlag       &style,
                                     const char           *windowClass,
                                     const IWindow        *parent,
                                     const IWindow        *owner,
                                     const IRectangle     &initRect,
                                     const void           *ctlData,
                                     const void           *presParams,
                                     IWindow::SiblingOrder ordering )
{
  IMODTRACE_DEVELOP( "IFrameWindow::create" );


  return this->create( id,
                       title,
                       convertToGUIStyle( style, false ),
                       windowClass,
                       (parent ) ? parent->handleForChildCreation() :
                                   IWindow::desktopWindow()->handle(),
                       (owner) ? owner->handle() :
                                 IWindowHandle(0),
                       initRect,
                       ctlData,
                       presParams,
                       ordering,
                       convertToGUIStyle( style, true ));
}

/*------------------------------------------------------------------------------
| IFrameWindow::create                                                         |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::create ( unsigned long         id,
                                     const char           *title,
                                     unsigned long         style,
                                     const char           *windowClass,
                                     const IWindowHandle  &parent,
                                     const IWindowHandle  &owner,
                                     const IRectangle     &initRect,
                                     const void           *ctlData,
                                     const void           *presParams,
                                     IWindow::SiblingOrder ordering ,
                                     unsigned long         extendedStyle)
{
  IMODTRACE_DEVELOP( "IFrameWindow::create" );

  IThread::current().initializeGUI();

#ifdef IC_PM
  // Don't pass text strings > 60 bytes to IWindow::create.  PM seems
  // to have a problem in this case (the end of the title is garbage).
  const char* createText = 0;
  if ( title  &&  strlen( title ) < MAXNAMEL )
  {
     createText = title;
  }
#endif
#ifdef IC_WIN
  // If menu bar is to be loaded on construction of frame, load it first
  unsigned long hmenu = 0;
  if ( !(style & WS_CHILD) &&
       ( fCopyOfStyle & IFrameWindow::menuBar ))
  {
     hmenu = (unsigned long)ILOADMENU( 0, (HINSTANCE)ctlData, id );
     if ( !hmenu )
        ITHROWGUIERROR( "LoadMenu" );
  }
#endif

  IWindowHandle hwnd =
     Inherited::create(
#ifdef IC_WIN
                        (style & WS_CHILD) ? id : hmenu,
                        title,
#endif  // IC_WIN
#ifdef IC_PM
                        id,
                        createText,
#endif //IC_PM
                        style,
                        windowClass,
                        parent,
                        owner,
                        initRect,
                        ctlData,
                        presParams,
                        ordering,
                        extendedStyle );

  // OK: add frame handler (via start()).
  fFrameWindowData->flags |= IFrameWindowData::standardFrame;
  fFrameWindowData->flags &= ~IFrameWindowData::fromDlgTemplate;

#ifdef IC_WIN
  // Set the extra window longword with the ID.
  if (! (style & WS_CHILD) )
  {
     ISETIDOF( hwnd, id );
  }
  // Set the address of the DialogProc.
  ISETWINDOWULONG( hwnd, DWL_DLGPROC, (LONG)_pfnwpICDlgProc);

  // Try to load the accelerator table with ID matching the ID of the
  // frame window.  If successful, store it with this IWindow object.
  if ( fCopyOfStyle & IFrameWindow::accelerator )
  {
     IDynamicLinkLibrary reslib( IModuleHandle( (HINSTANCE)ctlData ) );
     IAccelTblHandle haccel = reslib.loadAccelTable( id );
     if (haccel)
     {
        this->setAcceleratorHandle( haccel );
     }
  }
#endif // IC_WIN

  this->start( hwnd );

#ifdef IC_PM
  if ( createText != title )
  {      // Couldn't pass long title to IWindow::create, so add now.
     ITitle titleBar( this );
     titleBar.setTitleText( title );
  }
#endif // IC_PM
#ifdef IC_WIN
  // Add property to frame containing IFrameWindow object pointer
  // This allows HMENU handles to be mapped to their owning frame object,
  // which is needed for ISubmenu ctor, IMenu ctor and menu event origination.
  SetProp( hwnd, PROP_MENUBAR_OBJECT, (HANDLE)this );

  // If a menu was loaded (non-null only if not-child and menu style set)),
  //  then create the base lookup table for menu handling.
  if (!((IPlatform::isWin9x()) || (IPlatform::isNTNewShell())))
  {
     // If oldshell/win32s, if a menu was loaded, then build a lookup table
     // This is needed so that menu-events on non-extended menus can access
     // the lookup table for mapping HMENUs to menuitem IDs.
     if ( hmenu )
     {
        IResourceId resId( id );
        IMenuPrivate::buildLookUpTableFromResourceLoad( this,
                                                        (HMENU) hmenu,
                                                       resId.id() );
     }
  }

  // If a menu was loaded and we this is a right-to-left frame
  // window, reverse the order of the menu items.
  if ( hmenu  &&  IBidiSettings::isBidiSupported() )
  {
     IBidiSettings
       bidiSettings( *this );
     IMenuHandle
       menuHandle( (IMenuHandle::Value) hmenu );
     IMenuPrivate::setBidiAttributes( menuHandle, bidiSettings );
  }
#endif  // IC_WIN

  return hwnd;
}

#endif //IC_PMWIN

#ifdef IC_MOTIF
Bool isThereAConfigureNotify( Display *dsp, XEvent *evt, XPointer arg )
{
  Widget handle = (Widget) arg;

  if ( (evt->type == ConfigureNotify) && (XtWindow(handle) == evt->xany.window ) )
  {
    return true;
  }
  return false;
}

void _System mainWindowCallback(
    Widget    handle,
    XtPointer client_data,
    XEvent    *event,
    ::Boolean *continue_to_dispatch )
{
  *continue_to_dispatch = true;

  switch ( event->type)
  {
    case MapNotify:
    {
      IFrameWindow* frame = (IFrameWindow*) client_data;
	  if( IWindow::isWindowValid( frame ))
	  {
        Widget parent = XtParent( (Widget) frame->handleForChildCreation() );

     	  frame->postEvent( IC_UM_UPDATEFRAME );

        XtRemoveEventHandler(
         parent
         , StructureNotifyMask |        // ask for ConfigureNotify events
           VisibilityChangeMask     // for shows
         , false                       // indicate we also want nonmaskable events
         , mainWindowCallback      // event handler routine
         , (XtPointer*)frame );          // save reference to this IWindow in client data
      }
    }
    break;

    break;
  }
}

/*------------------------------------------------------------------------------
| IFrameWindow::create                                                         |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::create ( unsigned long         id,
                                     const char*           text,
                                     const IBitFlag&       style,
                                     IXmCreateFunction     createFunction,
                                     const IWindow*        parent,
                                     const IWindow*        owner,
                                     const IRectangle&     initRect,
                                     IWindow::SiblingOrder order )
{
  IMODTRACE_DEVELOP( "IFrameWindow::create" );
  IASSERTPARM( createFunction != 0 );

  if (!(IThread::current().isTopLevelShell()))
  {
     IThread::current().initializeGUI();
     IThread::current().setTopLevelShell();
  }

  // Use the window id (as as string) as the name of this
  // shell.
  IString appName = IString(id);

  IArgList argList( this->convertToArgList( style ));

  IWindowHandle parentHandle(0);
  if ( parent )
     parentHandle = parent->handleForChildCreation();
  else
     parentHandle = IWindow::desktopWindow()->handle();

  if (::fTopLevelShell)
  {
    ITRACE_DEVELOP( "Top Level is set");
    fFrameWindowData->shell = ::fTopLevelShell;
  }
  else
  {
    ITRACE_DEVELOP( "Top Level is NOT set");
    fFrameWindowData->shell = XtCreatePopupShell(appName,
                                      topLevelShellWidgetClass,
                                      parentHandle,
                                      (ArgList)argList.argList(),
                                      argList.numberOfArgs() );
  }

  // try to fix setting the title.
  IFrameWindow::Style &bitStyle = (IFrameWindow::Style &) style;

  // Set the title text.
  if ( bitStyle.bitwiseAnd(IFrameWindow::titleBar)==IFrameWindow::titleBar)
  {
     if ((text != NULL) &&  (strlen(text) != 0))
     {
        IArgList shellArgs;
        shellArgs.setResource( XmNtitle, (long)text )
                 .setResource( XmNiconName, (long)text);
        // The title text has to be passed to the shell.
        XtSetValues(
           fFrameWindowData->shell,
           (ArgList)shellArgs.argList(), shellArgs.numberOfArgs() );
     }
  }

  IString mwName = IString("mw_")+IString(id);

  // Get the bidi resources to use when creating the window,
  // emulating the way a window inherits bidi attributes on OS/2.
  IArgList
    bidiArgList;
  if ( IBidiSettings::isBidiSupported() )
  {
     // A window inherits the bidi attributes of its parent window,
     // unless it is parented to the desktop window, in which case
     // it uses application-wide bidi settings.
     IBidiSettings
       bidiSettings = IBidiSettings::applicationDefaults();
     if ( parent  &&
          parent != IWindow::desktopWindow() )
     {  // Use the bidi attributes of the parent window.
        bidiSettings = IBidiSettings( *parent );
     }

     // IWindow bidi styles take precedence over inherited bidi
     // attributes and bidi Motif attributes.
     if ( bitStyle & IWindow::rightToLeft )
     {
        bidiSettings
         .setWindowLayout( IBidiSettings::layoutRightToLeft )
         .setTextOrientation( IBidiSettings::textRightToLeft );
     }
     else if ( bitStyle & IWindow::leftToRight )
     {
        bidiSettings
         .setWindowLayout( IBidiSettings::layoutLeftToRight )
         .setTextOrientation( IBidiSettings::textLeftToRight );
     }
     // Else use inherited bidi attributes.

     bidiArgList = bidiSettings.asArgList();
  }

  // Set the scroll bar styles for the main window.  We will use application
  // defined scrolling to better map to the Windows and OS/2 behavior.
  // Start the arg list with bidi attributes so that the frame has
  // the appropriate bidi behavior.
  IArgList
    mainArgs = bidiArgList;
  mainArgs.setResource( XmNborderWidth, 0 );
  if ((bitStyle & IFrameWindow::horizontalScroll) ||
      (bitStyle & IFrameWindow::verticalScroll))
  {
     mainArgs.setResource( XmNscrollBarDisplayPolicy, XmSTATIC );
     mainArgs.setResource( XmNscrollingPolicy, XmAPPLICATION_DEFINED );
  }
  // Create the main window widget.
  IWindowHandle
    hwndMain =
      XmCreateMainWindow(
        fFrameWindowData->shell,                    // Parent window
        (char *)mwName,              // Name of the widget
        (ArgList)mainArgs.argList(), // Argument list
        mainArgs.numberOfArgs() );   // Number of Arguments

  XtAddEventHandler(
         hwndMain
       , StructureNotifyMask |        // ask for ConfigureNotify events
         VisibilityChangeMask     // for shows
       , false                       // indicate we also want nonmaskable events
       , mainWindowCallback      // event handler routine
       , (XtPointer*)this );          // save reference to this IWindow in client data
  // Manage the main window.

  XtManageChild (hwndMain);

  // Create any requested scroll bars for the main window.
  if ((bitStyle & IFrameWindow::horizontalScroll) ||
      (bitStyle & IFrameWindow::verticalScroll))
  {
     fFrameWindowData->createScrollBar( hwndMain,
                                        bitStyle.asUnsignedLong() );
  }

  ITRACE_ALL( IString("XmCreateMainWindow: widget=") +
              IString( hwndMain.asUnsigned() ).d2x() );

  // Make sure there is no border on hwnd.  When we support being able to
  // set and query the border width, re-consider this.
  // Start the arg list with bidi attributes so that the IFrameWindow
  // returns the correct bidi attributes when queried.
  IArgList
    workArgs = bidiArgList;
  workArgs.setResource(XmNborderWidth, 0 );

  // Create the manager widget to be the parent of the application windows
  // The nature of this widget depends on what the caller specified for
  // createFunction (the creation function).
  IWindowHandle
    hwnd =
      (*createFunction)(
        hwndMain,                    // Parent (the main window)
        (char *)IString(id),         // Name of the widget
        (ArgList)workArgs.argList(), // Argument list
        workArgs.numberOfArgs() );   // Argument count

  IArgList focusArg;
  focusArg.setResource( XmNinitialFocus, hwnd.asUnsigned() );
  XtSetValues( hwndMain, (ArgList)focusArg.argList(), focusArg.numberOfArgs());

  // Manage the created widget.
  XtManageChild(hwnd);

  fFrameWindowData->parentForChildren = hwnd;

  ITRACE_ALL( IString("XmCreateMainWindow: widget=") +
              IString(hwndMain.asUnsigned()).d2x() );

  // OK: add frame handler (via start()).
  this->fFrameWindowData->flags |= IFrameWindowData::standardFrame;

  // Add the main window handle to private data area.
  this->fFrameWindowData->mainW = hwndMain;

  // start will call startHandlingEventsFor.
  this->start( fFrameWindowData->shell );

  setOwner( owner );

  // This is needed to set the size of an IFrameWindow that is specified on the
  // constructor.
  moveSizeTo(initRect);

  // The shell widget is managed via the show() function
  // in initialize if that is what was requested.
  return hwnd;
}

/*------------------------------------------------------------------------------
| IFrameWindow::create                                                         |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::create ( unsigned long         id,
                                     const char*           text,
                                     unsigned long         style,
                                     IXmCreateFunction     createFunction,
                                     const IWindowHandle&  parent,
                                     const IWindowHandle&  owner,
                                     const IRectangle&     initRect,
                                     const void*           callerArgList,
                                     unsigned int    callerNumberArguments,
                                     IWindow::SiblingOrder order,
                                     unsigned long         extendedStyle)
{
  IMODTRACE_DEVELOP( "IFrameWindow::create (deprecated)" );

  IASSERTPARM( createFunction != 0 );

  // This function is only supported for parent or owner windows which
  // are IWindow objects in Motif.
  IWindow* parentW = parent ? IWindow::windowWithHandle(owner) : 0;
  IASSERTPARM((parent == IWindow::desktopWindow()->handle()) || (parentW != 0));
  IWindow* ownerW  = owner ? IWindow::windowWithHandle(owner) : 0;
  IASSERTPARM((owner == IWindow::desktopWindow()->handle()) || (ownerW != 0));

  // Construct the IBitFlag styles from the unsigned long styles
  unsigned long count = 0;
  unsigned long bitindex[64];
  for (unsigned long i=0; i < 32; i++)
  {
     if (style & (1 << i))
     {
        bitindex[count] = i;
        count++;
     }
     if (extendedStyle & (1 << i))
     {
        bitindex[count] = i + 32;
        count++;
     }
  }
  IFrameWindow::Style styleFlags(count, bitindex);

  // Call the preferred version of create.
  return this->create( id,
                       text,
                       styleFlags,
                       createFunction,
                       parentW,
                       ownerW,
                       initRect,
                       order);
}
#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| IFrameWindow::start                                                          |
|                                                                              |
| Create a new frame handler, add it to this frame window, and initiate        |
| message handling for the window.                                             |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::start ( const IWindowHandle &hwnd )
{
#ifdef IC_WIN
#ifdef IC_TRACE_ALL  // debugging code
  unsigned long ulstyle = ISTYLEOF( hwnd );
  ITRACE_ALL(IString("Frame Style=") + IString( ulstyle ).d2x() );
  HWND oldParent = IPARENTOF( hwnd );
  HWND oldOwner  = IOWNEROF( hwnd );
  ITRACE_ALL(IString( "GetParent=" ) + IString( (unsigned long)oldParent).d2x() );
  ITRACE_ALL(IString( "owner=" ) + IString( (unsigned long)oldOwner).d2x() );
  oldParent = (void*)GetWindowLong( hwnd, GWL_HWNDPARENT );
  ITRACE_ALL(IString( "GWL_HWNDPARENT=" ) + IString( (unsigned long)oldParent).d2x() );
#endif
#endif

  // Add the recoordination handler.
  IRecoordHandler::defaultHandler()->handleEventsFor( this );

#ifdef IC_MOTIFWIN
  // We use the keyboard part of the canvas handler to get keyboard
  // navigation in Windows.
  fFrameWindowData->fKeyboardHandler.handleEventsFor( this );
#endif

  this -> addDefaultHandler( );

#ifdef IC_MOTIF
#ifdef IC_DEVELOP
  // Add handler for editres.
  XtAddEventHandler( fFrameWindowData->shell, (::EventMask) 0, true,
                     (XtEventHandler) _XEditResCheckMessages, 0 );
#endif
#endif // IC_MOTIF


  this -> startHandlingEventsFor( hwnd );

  // add color map handler to the frame
  setColorMap(&(IApplication::current().colorMap()));

  // If frame wasn't created via tryToLoadDialog or create, then
  // set type according to whether there's a client.
  if ( !( fFrameWindowData->flags & IFrameWindowData::fromDlgTemplate )
       &&
       !( fFrameWindowData->flags & IFrameWindowData::standardFrame ) )
     if ( this->clientHandle() )
        fFrameWindowData->flags |= IFrameWindowData::standardFrame;
     else
        fFrameWindowData->flags |= IFrameWindowData::fromDlgTemplate;

#ifdef IC_PM
  unsigned long ulClr=0;
  unsigned long ulRetLen = WinQueryPresParam ( hwnd
                                             , PP_BACKGROUNDCOLOR
                                             , 0
                                             , 0
                                             , sizeof(ulClr)
                                             , &ulClr
                                             , 0);

  if (ulRetLen == 0)
  {
    // no color has been set so set the background color if the frame
    // is a dialog.
    if (fFrameWindowData->flags & IFrameWindowData::fromDlgTemplate)
    {
      IColor fBackgroundColor = IColor(IColor::kDialogBgnd);
      setBackgroundColor( fBackgroundColor );
    }
  }
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::addDefaultHandler                                              |
|                                                                              |
| Adds the default frame handler to a newly created frame.                     |
| Notes: If pHandler is null, create static handler.                           |
|        Add handler to frame and increment frame count.                       |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::addDefaultHandler ( )
{
  if ( !(fFrameWindowData->flags & IFrameWindowData::hasDefaultHandler) )
  {
      this -> addHandler( &fFrameWindowData->fdefaultHandler );
      fFrameWindowData->flags |= IFrameWindowData::hasDefaultHandler;

#ifdef IC_MOTIF
      // We want to get the expose events for the client area widget,
      // which is the handleForChildCreation() widget.  We need these so
      // that we can draw the frame extension separators.  Note that the
      // frame handler will also see expose events for the handle() widget
      // (the shell) because IWindow adds a handler for them.
      XtAddEventHandler(
         this->handleForChildCreation() ,   // widget
         ExposureMask,               // ask for exposure (paint) events
         False,                      // Don't need nonmaskable events
         iwindowXEventCallback,      // Event handler routine
         (XtPointer*)this);          // save reference to this IWindow in client data
#endif
  }

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::removeDefaultHandler                                           |
|                                                                              |
| Remove default handler and decrement frame count.  If frame count goes to    |
| zero, delete static handler and zero pointer.                                |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::removeDefaultHandler ( )
{
  if ( fFrameWindowData->flags & IFrameWindowData::hasDefaultHandler )
  {
#ifdef IC_MOTIF
     if (this->isValid())
     {
        XtRemoveEventHandler(
           this->handleForChildCreation() ,   // widget
           ExposureMask,               // ask for exposure (paint) events
           False,                      // Don't need nonmaskable events
           iwindowXEventCallback,      // Event handler routine
           (XtPointer*)this);          // save reference to this IWindow in client data
     }
#endif

     this -> removeHandler( &fFrameWindowData->fdefaultHandler );
     fFrameWindowData->flags &= ~IFrameWindowData::hasDefaultHandler;
  }

  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::extensions                                                     |
|                                                                              |
| Return the "pointer to extensions" data member.                              |
------------------------------------------------------------------------------*/
IFrameExtensions *IFrameWindow::extensions ( ) const
{
  return fFrameWindowData->pExtensions;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setExtensions                                                  |
|                                                                              |
| Set the "pointer to extensions" data member.                                 |
------------------------------------------------------------------------------*/
IFrameWindow &IFrameWindow::setExtensions ( IFrameExtensions *extensions )
{
  fFrameWindowData->pExtensions = extensions;
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setLayoutDistorted                                             |
|                                                                              |
| If the minimum size of a frame extension that should be sized based on its   |
| minimum size has changed, update the size and position of all frame          |
| extensions and the client window.                                            |
------------------------------------------------------------------------------*/
IFrameWindow&
  IFrameWindow::setLayoutDistorted ( unsigned long layoutAttributesOn,
                                     unsigned long layoutAttributesOff )
{
  if ( layoutAttributesOn & IWindow::childMinimumSizeChanged )
  {                     // Minimum size of a child has changed.
     IFrameExtensions *exts = this->extensions();  // Get extensions.
     if ( exts )        // Check if a frame extension changed size.
     {                  // (Otherwise it may be the client window.)
        bool found = false;
        IFrameExtensions::Cursor cursor( *exts );
        for ( cursor.setToFirst();
              !found  &&  cursor.isValid();
              cursor.setToNext() )
        {
           IFrameExtension *ext = exts->elementAt( cursor );
           if ( ext->type() == IFrameExtension::minimumSize)
           {
              ISize
                sizMinimum = ext->control()->minimumSize(),
                sizActual = ext->control()->size();
              switch ( ext->location() )
              {
                case IFrameWindow::aboveClient:
                case IFrameWindow::belowClient:
                  // Horizontal frame extension.
                  if ( sizMinimum.height() != sizActual.height() )
                  {          // Frame extension not sized to min size.
                     found = true;
                  }
                  break;
                default:
                  // Vertical frame extension.
                  if ( sizMinimum.width() != sizActual.width() )
                  {          // Frame extension not sized to min size.
                     found = true;
                  }
                  break;
              }
           }
        }

        if ( found )
        {               // Need to update size of frame extension.
           fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
           if ( this->isVisible() )
           {
              this->update();
           }
        }
     }
  }

  Inherited::setLayoutDistorted( layoutAttributesOn, layoutAttributesOff );
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setToolBarList                                                 |
|                                                                              |
| Stores the list of toolbars for a frame window.                              |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setToolBarList ( IToolBarList* toolBarList )
{
  fFrameWindowData->toolBarList = toolBarList;
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::toolBarList                                                    |
|                                                                              |
| Returns the list of toolbars for a frame window.                             |
------------------------------------------------------------------------------*/
IToolBarList* IFrameWindow::toolBarList ( ) const
{
  return fFrameWindowData->toolBarList;
}

/*------------------------------------------------------------------------------
| WIN32 Color Support                                                          |
|                                                                              |
| Windows has no API equivalent for Presentation Parameters.  The following    |
| frame color functions are NOPed for Windows.  The query functions return     |
| an appropriate default IColor object.  The reset functions just return *this.|
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
| IFrameWindow::backgroundColor                                                |
|                                                                              |
| Returns the background color for a frame window.                             |
------------------------------------------------------------------------------*/
IColor IFrameWindow::backgroundColor ( ) const
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  IColor guiColor( IColor::kWindowBgnd );

  if ( (fFrameWindowData->flags & IFrameWindowData::fromDlgTemplate) ||
       ( this->usesDialogBackground() ))
  {
     guiColor = IColor( IColor::kDialogBgnd );
  }
#ifdef IC_PM
  return ( IWindow::color( PP_BACKGROUNDCOLOR, guiColor ));
#endif
#ifdef IC_MOTIFWIN
  return (guiColor);
#endif
}

/*------------------------------------------------------------------------------
| IFrameWindow::disabledBackgroundColor                                        |
|                                                                              |
| Returns the disabled background color for a frame window.                    |
------------------------------------------------------------------------------*/
IColor IFrameWindow::disabledBackgroundColor ( ) const
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

  IColor guiColor( IColor::kWindowBgnd );

  if ( (fFrameWindowData->flags & IFrameWindowData::fromDlgTemplate) ||
       ( this->usesDialogBackground() ))
  {
     guiColor = IColor( IColor::kDialogBgnd );
  }
#ifdef IC_PM
  return ( IWindow::color( PP_DISABLEDBACKGROUNDCOLOR, guiColor ));
#else
  return (guiColor);
#endif
}

/*------------------------------------------------------------------------------
| IFrameWindow::resetBackgroundColor                                           |
|                                                                              |
| Resets the background color by undoing a previous set.                       |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::resetBackgroundColor ( )
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

#ifdef IC_PM
  this -> setBackgroundColor( IColor( IColor::kDialogBgnd ) );
#endif //IC_PM
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::resetDisabledBackgroundColor                                   |
|                                                                              |
| Resets the disabled background color by undoing a previous set.              |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::resetDisabledBackgroundColor ( )
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

#ifdef IC_PM
  this -> setDisabledBackgroundColor( IColor( IColor::kDialogBgnd ) );
#endif //IC_PM
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::usesDialogBackground                                           |
|                                                                              |
| Returns if the frame has the FCF_AUTOICON frame creation flag set, by        |
| testing for a by-product of setting FCF_AUTOICON.                            |
------------------------------------------------------------------------------*/
bool IFrameWindow::usesDialogBackground ( ) const
{

#ifdef IC_MOTIFWIN
  return ( (fFrameWindowData->flags & IFrameWindowData::fromDlgTemplate) ||
           (fCopyOfStyle & IFrameWindow::dialogBackground )) ? true : false;
#endif //IC_WIN
#ifdef IC_PM
  return (this->windowUShort( QWS_FLAGS ) & 0x100) ? true : false;
#endif //IC_PM
}


/*------------------------------------------------------------------------------
| IFrameWindow::setolorMap                                                     |
|                                                                              |
| Forwards the request to the frame's IColorMapHandler, creating the handler   |
| if it doesn't already exist.                                                 |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setColorMap ( IColorMap* colorMap )
{
   if (colorMap == 0)
   {
      // Back door to turn off color map handlers.
      delete fFrameWindowData->fColorMapHandler;
      fFrameWindowData->fColorMapHandler = 0;
      return *this;
   }

   if(fFrameWindowData->fColorMapHandler == 0)
      fFrameWindowData->fColorMapHandler = new IColorMapHandler(this, colorMap);
   else
      fFrameWindowData->fColorMapHandler->setColorMap(colorMap);

   return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::colorMap                                                       |
|                                                                              |
| Return the colormap from the colormap handler.  Throw an invalid request     |
| exception if the frame is not using a colormap.                              |
------------------------------------------------------------------------------*/
IColorMap* IFrameWindow::colorMap ( ) const
{
   IASSERTSTATE(fFrameWindowData->fColorMapHandler != 0);

   IColorMap* colorMap = 0;
   if(fFrameWindowData->fColorMapHandler)
     colorMap = &(fFrameWindowData->fColorMapHandler->colorMap());

   return colorMap;
}

/*------------------------------------------------------------------------------
| IFrameHandler::numberOfExtensions                                            |
|                                                                              |
| Return the number of frame extensions that the argument frame possesses.     |
------------------------------------------------------------------------------*/
unsigned long
  IFrameHandler::numberOfExtensions ( const IFrameWindow* pFrame ) const
{
  unsigned long
    result = 0;

  // Get pointer to frame extensions collection...
  const IFrameExtensions
   *extensions = pFrame->extensions();

  // If there are any, result is number of elements in collection...
  if ( extensions )
     result = extensions->numberOfElements();

  return result;
}

/*------------------------------------------------------------------------------
| IFrameHandler::format                                                        |
|                                                                              |
| Fills an array of window position structures, one for each frame control.    |
| This function does this for the frame extensions that have been added to the |
| frame using IFrameWindow::addExtension.                                      |
------------------------------------------------------------------------------*/
bool IFrameHandler::format ( IFrameFormatEvent &fmtEvent )
{
#ifdef IC_PMWIN
  RECTL
    temp = { 0, 0 };

  IFrameFormatEvent
    localEvent = fmtEvent;
  if ( fmtEvent.parameter2().asUnsignedLong() == 0 )
  {
     localEvent = IEvent( fmtEvent.handle(),
                          fmtEvent.eventId(),
                          fmtEvent.parameter1(),
                          &temp );
  }

  // Get count of standard controls (and thus index of extensions)...
  unsigned long
    controls = this -> defaultProcedure( localEvent );

#ifdef IC_WIN
  // Explicitly check for scrollbars in Windows.  Their ISWP entries will
  // be at the beginning of the ISWPArray.
  IWindowHandle
     hwndHorzScroll = IWINDOWFROMID( localEvent.handle(), FID_HORZSCROLL ),
     hwndVertScroll = IWINDOWFROMID( localEvent.handle(), FID_VERTSCROLL );
  unsigned long
    horzScrollHeight = 0,
    vertScrollWidth  = 0;
  if ( hwndHorzScroll )
  {
     controls++;
     RECT
       horzScrollRect;
     GetWindowRect( hwndHorzScroll, &horzScrollRect );
     horzScrollHeight = horzScrollRect.bottom - horzScrollRect.top;
  }
  if ( hwndVertScroll )
  {
     controls++;
     RECT
       vertScrollRect;
     GetWindowRect( hwndVertScroll, &vertScrollRect );
     vertScrollWidth = vertScrollRect.right - vertScrollRect.left;
  }

  if ( controls )
  {
     // We must have some Windows scrollbar controls to position.
     ISWPArray swpArray( localEvent.swpArray(), controls );
     IRectangle clientRect = localEvent.clientRect();
     long origClientMinX = clientRect.minX();

     // Scroll bars and client window need to be positioned differently
     // if bidi is enabled (specifically right-to-left window orientation).
     bool
       rightToLeft = false;
     if ( IBidiSettings::isBidiSupported() )
     {
        IBidiSettings
          settings( *( fmtEvent.dispatchingWindow() ) );
        rightToLeft =
          ( settings.windowLayout() == IBidiSettings::layoutRightToLeft );
     }

     for ( int i=0; i<controls; i++ )
     {
        IWindowHandle child = swpArray[i].windowHandle();
        if ( child == hwndHorzScroll )
        {
           // Position and size the horizontal scroll bar.
           swpArray[i].setMove();
           swpArray[i].setSizeFlag();
           clientRect
            .sizeTo( clientRect.size() - ISize( 0, horzScrollHeight ) );
           ISize
             scrollBarSize( clientRect.width(), horzScrollHeight );
           IPoint
             scrollBarPos( origClientMinX, clientRect.maxY() );
           // If there is also a vertical scroll bar, we need to subtract
           // its width.
           if ( hwndVertScroll )
           {
              scrollBarSize
               .setWidth( scrollBarSize.width() - vertScrollWidth );
              if ( rightToLeft )
              {  // Vertical scroll bar is left of the client window,
                 // so adjust the location of the horizontal scroll
                 // bar to remain below the client window.
                 scrollBarPos.setX( scrollBarPos.x() + vertScrollWidth );
              }
           }
           swpArray[i].setPosition( scrollBarPos );
           swpArray[i].setSize( scrollBarSize );
        }
        else if ( child == hwndVertScroll )
        {
           // Position and size the vertical scroll bar.
           swpArray[i].setMove();
           swpArray[i].setSizeFlag();
           clientRect
            .sizeTo( clientRect.size() - ISize( vertScrollWidth, 0 ) );
           if ( rightToLeft )
           {  // Vertical scroll bar is left of the client window.
              swpArray[i].setPosition( IPoint( origClientMinX,
                                               clientRect.minY() ) );
              clientRect.moveBy( ISize( vertScrollWidth, 0 ) );
           }
           else
           {
              swpArray[i].setPosition( IPoint( clientRect.maxX(),
                                               clientRect.minY() ) );
           }
           swpArray[i].setSize( ISize( vertScrollWidth,
                                       clientRect.height() ) );
        }
     }
     localEvent.setClientRect( clientRect );
  }
#endif // IC_WIN

  fmtEvent.setResult( IEventResult(this->positionExtensions(
                                           localEvent, controls ) ));
#endif //IC_PMWIN
#ifdef IC_MOTIF
  IRectangle temp;

  IFrameFormatEvent
    localEvent = fmtEvent;
  if ( fmtEvent.parameter2().asUnsignedLong() == 0 )
  {
     localEvent = IEvent( fmtEvent.handle(),
                          fmtEvent.eventId(),
                          fmtEvent.parameter1(),
                          &temp );
  }

  // Get count of standard controls (and thus index of extensions)...
  unsigned long
    controls = 0; // = this -> defaultProcedure( localEvent );

  fmtEvent.setResult( IEventResult(this->positionExtensions(
                                           localEvent, controls ) ));
#endif
  return true;
}

/*------------------------------------------------------------------------------
| IFrameHandler::positionExtensions                                            |
|                                                                              |
| Called from format.  This function will position and size the frame          |
| extensions after the size and position of the standard frame controls        |
| have been set in the ISWPArray in the IFrameFormatEvent.                     |
------------------------------------------------------------------------------*/
unsigned long IFrameHandler::positionExtensions( IFrameFormatEvent &formatEvent,
                                                 unsigned long numStdControls )
{
  IMODTRACE_DEVELOP( "IFrameHandler::positionExtensions" );

  unsigned
    index( (unsigned)numStdControls );

  // Construct "array of SWPs" object...
  ISWPArray
    swpArray( formatEvent.swpArray(),
              (unsigned)( numStdControls +
                          this->numberOfExtensions( formatEvent.frame() ) ) );

  // Iterate over the frame extensions (if there are any)...
  IFrameExtensions
   *extensions = formatEvent.frame()->extensions();
  if ( extensions )
  {
    IFrameExtensions::Cursor
       cursor( *extensions );

    for ( cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
    {
      // Access this extension...
      IFrameExtension
       &ext = *( extensions->elementAt( cursor ) );

      ISWP
       &extSWP = swpArray[ index++ ];

      // Locate standard control that this extension is attached to...
      unsigned long
        baseId = ext.attachedToId();

      unsigned
        baseIndex = swpArray.indexOf( baseId );

      // See if extension will show...
      // This check is actually correct on Motif as well even though we
      // can't set the name of the client to be FID_CLIENT.
      if ( baseId == FID_CLIENT
                  ||
           baseIndex < swpArray.size() )
      {
         // The baseIndex is compared to the number of standard controls
         // (rather than the size of the swpArray) below to make sure
         // client area attachment works in cases where there is no
         // client control.   We can only attach extensions to the
         // standard controls or client area.   There are certain
         // scenarios during addExtension where
         // the slots in the swpArray for our extensions are filled in
         // with residue from some other system event and we get a false
         // hit.  This will cause incorrect sizing of the extension/client
         // area until the user resizes the frame manually.  In Windows,
         // we only support client attachment so we always use the clientSWP.
         ISWP
           clientSWP,
          &baseSWP = ( baseIndex < numStdControls ) ?
                         swpArray[ baseIndex ]
                       :
                         clientSWP;

         // Dummy swp has "empty" client area dimensions...
         clientSWP
           .setSize( formatEvent.clientRect().size() )
           .setPosition( formatEvent.clientRect().minXMinY() );

         // Update extension and base SWPs per location...
         extSWP = ext.attachTo( baseSWP );

         // Remember client adjustment (if one was made)...
         if ( baseId == FID_CLIENT )
            formatEvent.setClientRect( IRectangle( baseSWP.position(),
                                                   baseSWP.size() ) );
      }
      else
        // Base is absent, hide this extension...
        extSWP.setSize( ISize( 0, 0 ) );

      // Set hwnd of associated control...
      extSWP.hwnd = ext.control()->handle();
       // Always set flags to move/size/noadjust...
#ifdef IC_WIN
      extSWP.flags() = SWP_NOOWNERZORDER;  // Default is move/size.
#endif //IC_WIN
#ifdef IC_MOTIFPM
      extSWP.flags() = SWP_MOVE | SWP_SIZE | SWP_NOADJUST;
#endif //IC_PM
      // Always place on "top" since no frame controls overlap...
      extSWP.behind = HWND_TOP;

    } // extension loop

  } // has extensions
  return index;
}

/*------------------------------------------------------------------------------
| IFrameHandler::draw                                                          |
|                                                                              |
| Called when the frame window needs to be redrawn.  This function draws the   |
| separator lines between frame extensions and returns false.                  |
| Notes: Iterate extensions, drawing each via IFrameExtension::drawSeparator.  |
------------------------------------------------------------------------------*/
bool IFrameHandler::draw ( IFrameEvent &frameEvent )
{
  IMODTRACE_DEVELOP( "IFrameHandler::draw" );
#ifdef IC_PMWIN
  // Get the basic frame drawing done...
  frameEvent.setResult( this -> defaultProcedure( frameEvent ) );
#endif
#ifdef IC_MOTIF
  // We need to inspect the event and determine that it is an expose event
  // for the handleForChildCreation window.  Only if the event is for this
  // window does this routine need to do anything.  Otherwise, it
  // just returns false.   Also, return false for any expose event which
  // indicates that more are to follow, because we do all of the drawing
  // needed at once.
  Widget  drawWidget = frameEvent.frame()->handleForChildCreation();
  Window  drawWindow = XtWindow( drawWidget );
  if (frameEvent.eventId() == xEvent(Expose))
  {
      XExposeEvent* event = (XExposeEvent*)(char*)frameEvent.parameter2();
      if ((event->window != drawWindow) || (event->count != 0))
         return false;          //Don't do anything for other windows/events
                                //or when more events are coming.
  }
  frameEvent.setResult(1);      // indicate event handled.
#endif

  // Iterate over the frame extensions (if there are any)...
  IFrameExtensions
   *extensions = frameEvent.frame()->extensions();

#ifdef IC_WIN
  // For Windows, we will also need to determine whether the frame has
  // both horizontal and vertical scroll bars.  If so, we need to fill
  // the rectangle where the two scroll bars meet.
  IWindowHandle
     hwndHorzScroll = IWINDOWFROMID( frameEvent.handle(), FID_HORZSCROLL ),
     hwndVertScroll = IWINDOWFROMID( frameEvent.handle(), FID_VERTSCROLL );
#endif // IC_WIN

#ifdef IC_WIN
  if (extensions || (hwndHorzScroll && hwndVertScroll))
#else
  if (extensions)
#endif // IC_WIN
  {
     // Get presentation space handle for drawing...
#ifdef IC_PMWIN
     IPresSpaceHandle
       psh = frameEvent.frame()->presSpace();
#endif
#ifdef IC_MOTIF
     IPresSpaceHandle
       psh (new IXDC(XtDisplay( drawWidget), drawWindow) );
#endif

#ifdef IC_WIN
     if (extensions)
     {
#endif // IC_WIN
     IFrameExtensions::Cursor
       cursor( *extensions );

     // Iterate extensions, drawing separator for each...
     for ( cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
        // Draw separator for next extension...
        extensions->elementAt( cursor ) -> drawSeparator( psh );
#ifdef IC_WIN
     }
#endif // IC_WIN

#ifdef IC_WIN
     // Fill the rectangle where the two scroll bars meet.
     if (hwndHorzScroll && hwndVertScroll)
     {
        // Fill the rectangle with the frame background color.
        HBRUSH brush = GetSysColorBrush( COLOR_BTNFACE );
        RECT clientRect,
             horzScrollRect,
             vertScrollRect,
             fillRect;
        IQUERYWINDOWRECT( frameEvent.handle(), &clientRect );
        IQUERYWINDOWRECT( hwndHorzScroll, &horzScrollRect );
        IQUERYWINDOWRECT( hwndVertScroll, &vertScrollRect );
        fillRect.top = horzScrollRect.top;
        fillRect.bottom = horzScrollRect.bottom;

        // The vertical scroll bar may be at the right or left side of
        // the client rectangle.  The position depends on whether the
        // window orientation of the frame window is left-to-right or
        // right-to-left (for bidi).
        if ( vertScrollRect.left > horzScrollRect.left )
        {  // Rectangle to fill is in the bottom right corner.
           fillRect.left = horzScrollRect.right;
           fillRect.right = clientRect.right;
        }
        else
        {  // Rectangle to fill is in the bottom left corner.
           fillRect.left = clientRect.left;
           fillRect.right = horzScrollRect.left;
        }

        MapWindowPoints( HWND_DESKTOP, frameEvent.handle(),
                         (POINT*) &fillRect, 2 );
        FillRect( psh, &fillRect, brush );

        DeleteObject( brush );
     }
#endif // IC_WIN

     // Release presentation space...
#ifdef IC_PMWIN
     frameEvent.frame()->releasePresSpace( psh );
#endif
     //Motif presentation space cleanup handled by IPresSpaceHandle destructor
  }

  return true;
}

/*------------------------------------------------------------------------------
| IFrameHandler::calcRect                                                      |
|                                                                              |
| Iterate extensions, expand frame rectangle by height and width of            |
| each extension if given a client rectangle. Shrink client rectangle          |
| by height and width of each extension if given a frame rectangle.            |
------------------------------------------------------------------------------*/
bool IFrameHandler::calcRect ( IFrameEvent &frameEvent )
{
  IMODTRACE_DEVELOP( "IFrameHandler::calcRect" );

  bool result = false;

#ifdef IC_MOTIF
  // Find the mainWindow widget and the workArea widget, and get
  // the dimensions of each.  The size adjustment in either direction
  // is the difference in size between the two, with the result positioned
  // at the mainWindow (to Frame) or at the workArea (to Client).
  ISize   sizeDifference;
  IPoint  workPosition;
  if ( XtIsRealized(frameEvent.handle()) )
  {  // Get info from widgets
      Position  mX=0,     mY=0,      wX=0,     wY=0;
      Dimension mWidth=0, mHeight=0, wWidth=0, wHeight=0;
      Widget mainW = XtNameToWidget(
          frameEvent.handle(),
          IString("mw_") + IString( XtName(frameEvent.handle()) ) );
      Widget workW = 0;
      XtVaGetValues( mainW, XmNworkWindow, &workW, 0);
      if (workW)
         XtVaGetValues(workW,
                       XmNx, &wX, XmNy, &wY,
                       XmNwidth, &wWidth, XmNheight, &wHeight,
                       0);
      // Interestingly, the mainW includes adjustment for decorations,
      // but the shell widget does not.
      XtVaGetValues(mainW,
                    XmNx, &mX, XmNy, &mY,
                    XmNwidth, &mWidth, XmNheight, &mHeight,
                    0);
      ITRACE_ALL( IString("client rect=") +
                  IRectangle(IPoint(wX,wY), ISize( wWidth, wHeight)).asString());
      ITRACE_ALL( IString("shell rect=") +
                  IRectangle(IPoint(mX,mY), ISize( mWidth, mHeight)).asString());
      sizeDifference = ISize(mWidth-wWidth, mHeight-wHeight);
      workPosition = IPoint(wX, wY);
  }
  else
  {   // Not realized.
      // Handle the shell decorations.  We currently use hardcoded values
      // for the border width and title bar height because there is no
      // simple way to obtain these parameters.
      int decorations = 0;
      XtVaGetValues( frameEvent.handle(), XmNmwmDecorations, &decorations, 0);
      if (decorations & MWM_DECOR_BORDER)
      {   // adjust for border
         sizeDifference += ISize(6,6);
         workPosition += IPoint(6,6);
      }
      if (decorations & (MWM_DECOR_TITLE|MWM_DECOR_MENU|
                         MWM_DECOR_MINIMIZE|MWM_DECOR_MAXIMIZE) )
      {  // adjust for title bar
         sizeDifference += ISize(0,23);
         workPosition += IPoint(0,23);
      }
  }
#endif

  // Going from frame to client.
  if ( frameEvent.parameter2().number1() )
  {
#ifdef IC_WIN
     // Using a dummy rectangle, compute difference between frame and
     // client to account for standard controls.
     RECT  testClient = {100,100,200,200};
     unsigned long ulStyle = ISTYLEOF( frameEvent.handle() );
     bool  hasMenu = false;
     if ( !(ulStyle & WS_CHILD) && GetMenu( frameEvent.handle() ) )
        hasMenu = true;
     AdjustWindowRectEx( &testClient,
                         ulStyle,
                         hasMenu,
                         GetWindowLong( frameEvent.handle(), GWL_EXSTYLE ));

     ITRACE_ALL( IString("adjusted testClient=") +
                 IRectangle(testClient).asString() );

     RECT* pRc = (RECT*)frameEvent.parameter1().asUnsignedLong();
     ITRACE_ALL( IString("frame=") + IRectangle(*pRc).asString() );

     pRc->left   = pRc->left   - (testClient.left   - 100);
     pRc->top    = pRc->top    - (testClient.top    - 100);
     pRc->right  = pRc->right  - (testClient.right  - 200);
     pRc->bottom = pRc->bottom - (testClient.bottom - 200);

     ITRACE_ALL( IString("default client=") + IRectangle(*pRc).asString() );

     frameEvent.setResult( 1 );
#endif
#ifdef IC_MOTIF
     IRectangle *pRc = (IRectangle *)frameEvent.parameter1().asUnsignedLong();
     (*pRc)
        .sizeTo( pRc->size() - sizeDifference )
        .moveTo( pRc->minXMinY() + workPosition );

     ITRACE_DEVELOP( IString("default client=") + IRectangle(*pRc).asString() );

     frameEvent.setResult( 1 );
#endif
#ifdef IC_PM
     // Call default window procedure to subtract base controls.
     frameEvent.setResult( this->defaultProcedure( frameEvent ));
#endif
     // Don't call the default window procedure.
     result = true;
  }

  // Iterate over the frame extensions (if there are any),
  // adding or subtracting the frame extensions.
  IFrameExtensions
   *extensions = frameEvent.frame()->extensions();

  if ( extensions )
  {
#ifdef IC_PMWIN
     PRECTL     pRc = (PRECTL)frameEvent.parameter1().asUnsignedLong();
#endif
#ifdef IC_MOTIF
     IRectangle* pRc = (IRectangle *)frameEvent.parameter1().asUnsignedLong();
#endif
     IRectangle rectl( *pRc );
     IFrameExtensions::Cursor cursor( *extensions );

     // Frame --> client.
     if ( frameEvent.parameter2().number1() )
     {
        for ( cursor.setToLast(); cursor.isValid(); cursor.setToPrevious() )
        {
           // Access this extension...
           IFrameExtension
             &ext = *( extensions->elementAt( cursor ) );

           if ( ext.attachedToId() == FID_CLIENT )
           {
             rectl = ext.baseRectFor( rectl );
           }
        }
     }
     // Client --> frame.
     else
     {
        for ( cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
        {
           // Access this extension...
           IFrameExtension
            &ext = *( extensions->elementAt( cursor ) );

           if ( ext.attachedToId() == FID_CLIENT )
           {
              rectl = ext.totalRectFor( rectl );
           }
        }
     }
#ifdef IC_PMWIN
     *pRc = rectl.asRECTL();
#endif
#ifdef IC_MOTIF
     *pRc = rectl;
#endif
  } // has extensions

#ifdef IC_WIN
  // Account for any frame window scroll bars.
  IWindowHandle
     hwndHorzScroll = IWINDOWFROMID( frameEvent.handle(), FID_HORZSCROLL ),
     hwndVertScroll = IWINDOWFROMID( frameEvent.handle(), FID_VERTSCROLL );
  if (hwndHorzScroll)
  {
     PRECTL pRc = (PRECTL)frameEvent.parameter1().asUnsignedLong();
     RECT horzScrollRect;
     GetWindowRect( hwndHorzScroll, &horzScrollRect );
     if (frameEvent.parameter2().number1())
     {
        // Frame --> client.
        pRc->bottom -= (horzScrollRect.bottom - horzScrollRect.top);
     }
     else
     {
        // Client --> frame.
        pRc->bottom += (horzScrollRect.bottom - horzScrollRect.top);
     }
  }
  if (hwndVertScroll)
  {
     PRECTL pRc = (PRECTL)frameEvent.parameter1().asUnsignedLong();
     RECT vertScrollRect;
     GetWindowRect( hwndVertScroll, &vertScrollRect );
     unsigned long
       vertScrollWidth = vertScrollRect.right - vertScrollRect.left;

     // Determine whether the vertical scroll bar appears on the right
     // or left side of the client window, based on whether the frame
     // window is enabled for bidi layouts.
     bool
       rightToLeft = false;
     if ( IBidiSettings::isBidiSupported() )
     {
        IBidiSettings
          settings( *( frameEvent.dispatchingWindow() ) );
        rightToLeft =
          ( settings.windowLayout() == IBidiSettings::layoutRightToLeft );
     }
     if (frameEvent.parameter2().number1())
     {
        // Frame --> client.
        if ( rightToLeft )
        {  // Scroll bar will be on left of client window.
           pRc->left += vertScrollWidth;
        }
        else
        {  // Scroll bar will be on right of client window.
           pRc->right -= vertScrollWidth;
        }
     }
     else
     {
        // Client --> frame.
        if ( rightToLeft )
        {  // Scroll bar will be on left of client window.
           pRc->left -= vertScrollWidth;
        }
        else
        {  // Scroll bar will be on right of client window.
           pRc->right += vertScrollWidth;
        }
     }
  }
#endif // IC_WIN

#ifdef IC_MOTIFWIN
  if ( frameEvent.parameter2().number1() == 0 )
  {
     // Do the stuff that the PM default procedure does.
     // Compute the rectangle for the frame in screen coordinates
     // including the standard controls present.

#ifdef   IC_WIN
     RECT* pRc = (RECT*)frameEvent.parameter1().asUnsignedLong();
     ITRACE_ALL( IString("Client rect with extensions=") +
                 IRectangle(*pRc).asString() );
     unsigned long ulStyle = ISTYLEOF( frameEvent.handle() );
     bool  hasMenu = false;
     if ( !(ulStyle & WS_CHILD) && GetMenu( frameEvent.handle() ) )
        hasMenu = true;
     AdjustWindowRectEx( pRc,
                         ulStyle,
                         hasMenu,
                         GetWindowLong( frameEvent.handle(), GWL_EXSTYLE ));
#endif //IC_WIN
#ifdef   IC_MOTIF

     IRectangle* pRc = (IRectangle*)frameEvent.parameter1().asUnsignedLong();
     ITRACE_ALL( IString("Client rect with extensions=") +
                 IRectangle(*pRc).asString() );
     (*pRc)
        .sizeTo( pRc->size() + sizeDifference )
        .moveTo( pRc->minXMinY() - workPosition );

#endif //IC_MOTIF

     ITRACE_ALL( IString( "Frame rectangle=" ) +
                   IRectangle(*pRc).asString() );
     frameEvent.setResult( 1 );
     result = true;     // dont waste time with default proc
  }
#endif   //IC_MOTIFWIN

  return result;
}


/*------------------------------------------------------------------------------
| bool IFrameWindowData::calcFrameRect                                         |
| calcFrameRect performs conversion between a window rectangle and             |
| the window's client area rectangle.  The frameToClient argument controls     |
| which way the conversion is done.  If true, the input rectangle is           |
| the frame window rectangle, if false the rectangle is the client             |
| rectangle.  Similar in function to PM WinCalcFrameRect.                      |
------------------------------------------------------------------------------*/
bool IFrameWindowData::calcFrameRect ( IWindowHandle  hwnd,
                                       IRectangle     &rect,
                                       bool           frameToClient )
{
  IMODTRACE_ALL( "IFrameWindowData::calcFrameRect" );
  ITRACE_ALL( IString("rect=") + rect.asString() );
  bool result = false;

#ifdef IC_PM
  RECTL rectl = rect.asRECTL();
  result = WinCalcFrameRect( hwnd, &rectl, frameToClient );
  rect = result ? IRectangle(rectl) : IRectangle();
#endif //IC_PM

#ifdef IC_WIN
  RECTL rectl = rect.asRECTL();
  RECT* prect = (RECT*)(&rectl);   // RECT and RECTL identical in windef.h.

  IWindowClassName className( hwnd );
  // We check substring as we create new frame classes to
  // implement certain styles
  if (className.asString().indexOf(WC_FRAME) != 1)
  {
     // Not a frame window.
     if ( frameToClient )
     {
        result = GetClientRect( hwnd, prect );
        if ( result )
        {
           // Get result in screen coordinates.
           MapWindowPoints( hwnd, HWND_DESKTOP, (POINT*)prect, 2 );
        }
     }
     else
     {
        unsigned long ulStyle = ISTYLEOF( hwnd );
        bool  hasMenu = false;
        if ( !(ulStyle & WS_CHILD) && GetMenu( hwnd ) )
           hasMenu = true;
        result = AdjustWindowRectEx( prect,
                                     ulStyle,
                                     hasMenu,
                                     GetWindowLong( hwnd, GWL_EXSTYLE ));
     }
  }
  else
  {
     // Is a frame window.  We need to take into account frame extensions.
     // Do this by sending a user message to the frame handler.
     result = hwnd.sendEvent( IC_UM_CALCFRAMERECT,
                              IEventData( prect ),
                              IEventData( frameToClient ) ).asUnsignedLong();
  }

  rect = result ? IRectangle(rectl) : IRectangle();
#endif //IC_WIN

#ifdef IC_MOTIF
  IWindow *win = IWindow::windowWithHandle( hwnd );
  // implement certain styles
  if ( win && !win->isFrameWindow() )
  {
     // Not a frame window.
     Position x, y;
     Dimension width, height, border;
     XtVaGetValues( hwnd,
       XmNx, &x,
       XmNy, &y,
       XmNwidth, &width,
       XmNheight, &height,
       XmNborderWidth, &border,
       NULL );
     IRectangle rc( IPoint(x, y), ISize( width + 2 * border,
                                         height + 2 * border ) );
     if ( frameToClient )
     {
        rc.moveTo( IWindow::mapPoint( rc.minXMinY(),
                                      hwnd,
                                      IWindow::desktopWindow()->handle()));
     }
     else
     {
        rc.moveTo( IWindow::mapPoint( rc.minXMinY(),
                                      IWindow::desktopWindow()->handle(),
                                      hwnd) );
     }
     result = true;
  }
  else
  {
     // Is a frame window.  We need to take into account frame extensions.
     // Do this by sending a user message to the frame handler.
     if ( XtIsRealized( hwnd ) )
     {
        result = hwnd.sendEvent( IC_UM_CALCFRAMERECT,
                                 IEventData( &rect ),
                                 IEventData( frameToClient ) );
     }
     else
     {
        // if the hwnd is not realized then there is no window. No window,
        // no sendEvent so we need to call calcRect directly.
        // call the member function directly.

        if ( win &&  win->isFrameWindow() )
        {
           IEvent event( hwnd,
                         IC_UM_CALCFRAMERECT,
                         IEventData( &rect ),
                         IEventData( frameToClient ) );
           IFrameEvent
             frameEvent( event );
           // Bypass handler and call member function directly.
           result = fdefaultHandler.calcRect( frameEvent );
        }
     }
  }
#endif //IC_MOTIF
  ITRACE_ALL( IString( "rect=" ) + rect.asString() );
  return result;
}
/*------------------------------------------------------------------------------
| IFrameWindow::matchForMnemonic                                               |
|                                                                              |
| Returns the first child window that uses the specified character as a        |
| mnemonic.                                                                    |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::matchForMnemonic ( unsigned short character ) const
{
  return ICanvasStatics::matchForMnemonic( this, character );
}

/*------------------------------------------------------------------------------
| IFrameWindow::defaultPushButton                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::defaultPushButton ( ) const
{
#ifdef IC_PM
  return ( IQUERYWINDOWULONG( this->handle(), QWL_DEFBUTTON) );
#else
  return fFrameWindowData->fDefaultPushButton;
#endif // IC_PM
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IFrameWindow::setFont                                                        |
|                                                                              |
| Sets the font for the frame and propagates the font to the client/children.  |
------------------------------------------------------------------------------*/
IWindow& IFrameWindow::setFont( const IFont& fm )
{
  Inherited::setFont( fm );

#ifdef IC_PM
    // have to set title text if there is a title

    if( IWINDOWFROMID( handle(), FID_TITLEBAR ))
    {
        try
        {
           ITitle title( this );
           title.setFont(fm);
        }
        catch( IInvalidRequest& )
        {
           // frame doesn't have a title bar - do nothing
        }
    }
#endif  // IC_PM

  return *this;
}
#endif   //IC_PMWIN

/*------------------------------------------------------------------------------
| IFrameWindow::setMinimumFrameSize                                            |
|                                                                              |
| Sets minimum size that user can resize frame to                              |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setMinimumFrameSize(const ISize &minimumFrameSize)
{
  IMODTRACE_DEVELOP("IFrameWindow::setMinimumFrameSize") ;
  if (fFrameWindowData->bMaxFrameSizeSet)
  {
     unsigned long
       iProposedMinimumArea(minimumFrameSize.width() * minimumFrameSize.height()) ;
     unsigned long
       iMaximumFrameArea(fFrameWindowData->maximumFrameSize.width() * fFrameWindowData->maximumFrameSize.height()) ;
     IASSERTPARM(iProposedMinimumArea < iMaximumFrameArea) ;
  }
  fFrameWindowData->minimumFrameSize = minimumFrameSize ;
  fFrameWindowData->bMinFrameSizeSet = true ;
#ifdef IC_MOTIF
  Dimension fWidth ( minimumFrameSize.width()  ),
            fHeight( minimumFrameSize.height() );
  XtVaSetValues( (Widget)this->handle(),
                 XmNminWidth,  fWidth,
                 XmNminHeight, fHeight,
                 NULL );
#endif
  return *this ;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setMaximumFrameSize                                            |
|                                                                              |
| Sets maximum size that user can resize frame to                              |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setMaximumFrameSize(const ISize &maximumFrameSize)
{
  IMODTRACE_DEVELOP("IFrameWindow::setMaximumFrameSize") ;
  if (fFrameWindowData->bMinFrameSizeSet)
  {
     unsigned long
       iProposedMaximumArea(maximumFrameSize.width() * maximumFrameSize.height()) ;
     unsigned long
       iMinimumFrameArea(fFrameWindowData->minimumFrameSize.width() * fFrameWindowData->minimumFrameSize.height()) ;
     IASSERTPARM(iProposedMaximumArea > iMinimumFrameArea) ;
  }
  fFrameWindowData->maximumFrameSize = maximumFrameSize ;
  fFrameWindowData->bMaxFrameSizeSet = true ;
#ifdef IC_MOTIF
  Dimension fWidth ( maximumFrameSize.width()  ),
            fHeight( maximumFrameSize.height() );
  XtVaSetValues( (Widget)this->handle(),
                 XmNmaxWidth,  fWidth,
                 XmNmaxHeight, fHeight,
                 NULL );
#endif
  return *this ;
}

/*------------------------------------------------------------------------------
| IFrameWindow::maximumTrackingSize                                            |
|                                                                              |
| returns maximum size that user can resize frame to                           |
------------------------------------------------------------------------------*/
ISize IFrameWindow::maximumFrameSize() const
{

  IMODTRACE_DEVELOP("IFrameWindow::maximumFrameSize") ;
  if (fFrameWindowData->bMaxFrameSizeSet)
     return fFrameWindowData->maximumFrameSize ;
#ifdef IC_WIN
  else
     return ISize(GetSystemMetrics( SM_CXSCREEN),
                  GetSystemMetrics( SM_CYSCREEN) ) ;  // SM_CxMAXTRACK only supported on Win95
#endif
#ifdef IC_PM
  else
  {
     TRACKINFO trackInformation ;
     IEventParameter1 parm1(0) ;
     IEventParameter2 parm2(&trackInformation) ;
     IEvent trackEvent((IWindow *) this,
                       WM_QUERYTRACKINFO,
                       parm1,
                       parm2) ;
     ((IFrameWindow *) this)->defaultProcedure(trackEvent) ;
     return ISize(trackInformation.ptlMaxTrackSize.x, trackInformation.ptlMaxTrackSize.y) ;
  }
#endif
#ifdef IC_MOTIF
  else
     return desktopWindow()->size();
#endif
}

/*------------------------------------------------------------------------------
| IFrameWindow::minimumTrackingSize                                            |
|                                                                              |
| returns minimum size that user can resize frame to                           |
------------------------------------------------------------------------------*/
ISize IFrameWindow::minimumFrameSize() const
{

  IMODTRACE_DEVELOP("IFrameWindow::minimumFrameSize") ;
  if (fFrameWindowData->bMinFrameSizeSet)
     return fFrameWindowData->minimumFrameSize ;
#ifdef IC_WIN
  else
     return ISize(GetSystemMetrics( SM_CXMINTRACK),
                  GetSystemMetrics( SM_CYMINTRACK) ) ;
#endif
#ifdef IC_PM
  else
  {
     TRACKINFO trackInformation ;
     IEventParameter1 parm1(0) ;
     IEventParameter2 parm2(&trackInformation) ;
     IEvent trackEvent((IWindow *) this,
                       WM_QUERYTRACKINFO,
                       parm1,
                       parm2) ;
     ((IFrameWindow *) this)->defaultProcedure(trackEvent) ;
     return ISize(trackInformation.ptlMinTrackSize.x, trackInformation.ptlMinTrackSize.y) ;
  }
#endif
#ifdef IC_MOTIF
  else
     // Need to figure out an implementation for this.
     return ISize( 20, 20 );
#endif
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFrameWindowData::registerCallbacks                                          |
|                                                                              |
| Register callbacks needed for IFrameHandler.                                 |
------------------------------------------------------------------------------*/
void IFrameWindowData::registerCallbacks ( )
{
  IMODTRACE_DEVELOP( "IFrameWindowData::registerCallbacks" );

  if ( ((XtIsTopLevelShell(this->shell))) ||
       ((XtIsApplicationShell(this->shell))))

  {
    // Set the values for the static atom variables
    IFrameWindowData::wmDeleteWindow =
                        // Display id
           XmInternAtom( XtDisplay( IWindow::desktopWindow()->handle()),
                         ICLUI_WMDELETE,       // Atom name
                         false);               // OnlyIfExists

    IFrameWindowData::wmSaveYourself =
           XmInternAtom( XtDisplay( IWindow::desktopWindow()->handle() ),
                         ICLUI_WMSAVE,         // Atom name
                         false);               // OnlyIfExists

    IFrameWindowData::wmTakeFocus =
           XmInternAtom( XtDisplay( IWindow::desktopWindow()->handle() ),
                         ICLUI_WMFOCUS,        // Atom name
                         false);               // OnlyIfExists
  }
}

/*------------------------------------------------------------------------------
| IFrameWindowData::unregisterCallbacks                                        |
|                                                                              |
| Deregister callbacks needed for IFrameHandler.                               |
------------------------------------------------------------------------------*/
void IFrameWindowData::unregisterCallbacks (IFrameWindow* frame )
{
  IMODTRACE_DEVELOP( "IFrameWindowData::unregisterCallbacks" );

//  if (frame->isValid())
//  {
//     if ( (!(XtIsTopLevelShell(this->shell))) &&
//          (!(XtIsApplicationShell(this->shell))))
//        ITHROWLIBRARYERROR(IC_INVALID_FRAME_SHELL,
//                           IBaseErrorInfo::invalidParameter,
//                           IException::recoverable);
//  }
}
#endif // IC_MOTIF

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFrameWindow::handleForChildCreation                                         |
|                                                                              |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::handleForChildCreation( ) const
{
  return fFrameWindowData->parentForChildren;
}
#endif

/*------------------------------------------------------------------------------
| IFrameWindowChildData::IFrameWindowChildData                                 |
------------------------------------------------------------------------------*/
IFrameWindowChildData::IFrameWindowChildData( IWindow* child )
  : IWindowData(),
    fchildSettings( 0 ),
    fchild( child )
{ }

/*------------------------------------------------------------------------------
| IFrameWindowChildData::~IFrameWindowChildData                                |
------------------------------------------------------------------------------*/
IFrameWindowChildData::~IFrameWindowChildData(  )
{ }

/*------------------------------------------------------------------------------
| IFrameWindowChildData::saveWindowSettings                                    |
------------------------------------------------------------------------------*/
IFrameWindowChildData& IFrameWindowChildData::saveWindowSettings( )
{
  fchildSettings = 0;      // reset state
  if (fchild && fchild->isValid())
  {
     fchildSettings |= eValid;
     if (fchild->isVisible())
        fchildSettings |= eVisible;
     if (fchild->isEnabled())
        fchildSettings |= eEnabled;
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindowChildData::restoreWindowSettings                                 |
------------------------------------------------------------------------------*/
IFrameWindowChildData& IFrameWindowChildData::restoreWindowSettings( )
{
  if (fchild && fchild->isValid() && (fchildSettings & eValid))
  {
     if (fchildSettings & eVisible)
        fchild->show();
     if (fchildSettings & eEnabled)
        fchild->enable();
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setTitleText                                                   |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setTitleText ( const char* titleText )
{
#ifdef IC_PM
  IWindowHandle hwndTitle( this->handleFor(IFrameWindow::titleBar) );
  ITitle* title = dynamic_cast<ITitle*>(IWindow::windowWithHandle( hwndTitle ));
  if (hwndTitle && title)
  {
     title->setTitleText( titleText );
  }
  else
#endif
  {
     ITitle fTitle( this );
     fTitle.setTitleText( titleText );
  }
  this->notifyObservers(
    INotificationEvent(IFrameWindow::titleTextId, *this));
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setTitleText                                                   |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setTitleText ( const IResourceId& titleResId )
{
  IString titleString = titleResId.resourceLibrary().loadString( titleResId );
  return this->setTitleText( titleString );
}

/*------------------------------------------------------------------------------
| IFrameWindow::titleText                                                      |
------------------------------------------------------------------------------*/
IString IFrameWindow::titleText ( ) const
{
#ifdef IC_PMWIN
#ifdef IC_PM
  IWindowHandle hwndTitle( this->handleFor(IFrameWindow::titleBar) );
#endif
#ifdef IC_WIN
  IWindowHandle hwndTitle( handle() );
#endif
  IString result;
  if (hwndTitle)
  {
    unsigned long uLen = IQUERYWINDOWTEXTLENGTH( hwndTitle );
    ++uLen;                                    // Add 1 for null terminator.

    if ( uLen > 1 )
    {
       char* pszClBuf = new char[ uLen ];

       IQUERYWINDOWTEXT( hwndTitle,
                         uLen,
                         (PSZ)pszClBuf );
       result = pszClBuf;
       delete [] pszClBuf;
    }
  }
  return result;
#endif //IC_PMWIN

#ifdef IC_MOTIF
   String data;
   XtVaGetValues( handle(),
                 XmNtitle, &data,
                 NULL);

   IString title((char *)data);
   return title;
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IFrameWindow::setDefaultPushButton                                           |
|                                                                              |
| Set the defaultPushButton.                                                   |
|                                                                              |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setDefaultPushButton(
                                       const IWindowHandle& defaultPushButton )
{
  // Replace current default push button, if one exists, and reset the
  //   emphasis to the new default.
  if ( defaultPushButton )
  {
     if ( (fFrameWindowData->fDefaultEmphasisButton != IWindowHandle(0)) &&
          (fFrameWindowData->fDefaultEmphasisButton != defaultPushButton ) )
       fFrameWindowData->fDefaultEmphasisButton.sendEvent( IC_UM_DEFAULT_BUTTON,
                                                   IEventData(false),
                                                   IEventData(0) );
  }
#ifdef IC_PM
  ISETWINDOWULONG( this->handle(), QWL_DEFBUTTON, defaultPushButton );
#else
  fFrameWindowData->fDefaultPushButton = defaultPushButton;
#endif // IC_PM

  if ( defaultPushButton )
  {
     fFrameWindowData->fDefaultEmphasisButton = defaultPushButton;
     defaultPushButton.sendEvent( IC_UM_DEFAULT_BUTTON,
                                  IEventData(true),
                                  IEventData(0) );
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::setDefaultEmphasisButton                                       |
|                                                                              |
| Set the defaultEmphasisButton.                                               |
|                                                                              |
------------------------------------------------------------------------------*/
IFrameWindow& IFrameWindow::setDefaultEmphasisButton(
                                    const IWindowHandle& defaultEmphasisButton,
                                    bool  enable)
{
  if (enable)
  {
    if ( (fFrameWindowData->fDefaultEmphasisButton != IWindowHandle(0)) &&
         (fFrameWindowData->fDefaultEmphasisButton != defaultEmphasisButton) )
    // Turn off current emphasis button and enable emphasis for the
    //    specified button.
      fFrameWindowData->fDefaultEmphasisButton.sendEvent( IC_UM_DEFAULT_EMPHASIS,
                                                          IEventData(false),
                                                          IEventData(0) );
    fFrameWindowData->fDefaultEmphasisButton = defaultEmphasisButton;
    defaultEmphasisButton.sendEvent( IC_UM_DEFAULT_EMPHASIS,
                                     IEventData(true),
                                     IEventData(0) );
  }
  else
  {
    IWindow* but(IWindow::windowWithHandle(defaultEmphasisButton));
    if ( (but) && (defaultEmphasisButton ==
                   fFrameWindowData->fDefaultEmphasisButton) &&
                  (defaultEmphasisButton != IWindowHandle(0)) )
    {
      fFrameWindowData->fDefaultEmphasisButton = 0;
      defaultEmphasisButton.sendEvent( IC_UM_DEFAULT_EMPHASIS,
                                       IEventData(false),
                                       IEventData(0) );
    }
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFrameWindow::defaultEmphasisButton                                          |
|                                                                              |
| Return the defaultEmphasisButton.                                            |
|                                                                              |
------------------------------------------------------------------------------*/
IWindowHandle IFrameWindow::defaultEmphasisButton() const
{
  return fFrameWindowData->fDefaultEmphasisButton;
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFrameWindowDeferredAction::IFrameWindowDeferredAction                       |
------------------------------------------------------------------------------*/
IFrameWindowDeferredAction::IFrameWindowDeferredAction(
                                long frameToShow )
   : faction( kShow ),
     fdata  ( (void*)frameToShow )
{
}

/*------------------------------------------------------------------------------
| IFrameWindowDeferredAction::IFrameWindowDeferredAction                       |
------------------------------------------------------------------------------*/
IFrameWindowDeferredAction::IFrameWindowDeferredAction(
                                const IRectangle&    clientRectangle )
   : faction( kMoveSizeToClient ),
     fdata  ( new IRectangle( clientRectangle ) )
{
}

/*------------------------------------------------------------------------------
| IFrameWindowDeferredAction::~IFrameWindowDeferredAction                      |
------------------------------------------------------------------------------*/
IFrameWindowDeferredAction::~IFrameWindowDeferredAction( )
{
   // Delete fdata object if needed
   switch (faction)
   {
       case kMoveSizeToClient:
           delete (IRectangle*)fdata;
           break;
       default:
           break;
   }
}

/*------------------------------------------------------------------------------
| IFrameWindowDeferredAction::applyTo                                          |
------------------------------------------------------------------------------*/
bool IFrameWindowDeferredAction::applyTo( IFrameWindow* frame )
{
   bool result = true;
   switch (faction)
   {
     case kShow:
     {
	   // make sure frame hasn't been destroyed
       IWindow* w = IWindow::windowWithHandle( (Widget)fdata );
       if ( w && w->isValid())
         w->show(true);
       break;
     }
     case kMoveSizeToClient:
     {
       frame->moveSizeToClient( *((IRectangle*)fdata) );
       break;
     }
     default:
       break;
   }
   return result;
}

/*------------------------------------------------------------------------------
| IFrameWindowDeferredAction::IFrameWindowDeferredAction                       |
------------------------------------------------------------------------------*/
IFrameWindowDeferredAction::IFrameWindowDeferredAction(
                                const IFrameWindowDeferredAction& another )
{   // Dummy private
}

/*------------------------------------------------------------------------------
| IFrameWindowDeferredAction::IFrameWindowDeferredAction&  operator=           |
------------------------------------------------------------------------------*/
IFrameWindowDeferredAction& IFrameWindowDeferredAction::operator=(
                                const IFrameWindowDeferredAction& another )
{
   return *this;    // Dummy private
}
#endif  //IC_MOTIF

#ifdef IC_MOTIFWIN
/*------------------------------------------------------------------------------
| IFrameWindow::passEventToOwner                                                |
|                                                                              |
| Returns whether or not the event can be passed up to the owner of this       |
| control.                                                                     |
------------------------------------------------------------------------------*/
bool IFrameWindow::passEventToOwner( IEvent& event )

{
  switch ( event.eventId() )
  {
    case WM_BUTTON1DOWN:
    case WM_BUTTON2DOWN:
    case WM_BUTTON3DOWN:
    case WM_BUTTON1UP:
    case WM_BUTTON2UP:
    case WM_BUTTON3UP:
    case WM_BUTTON1CLICK:
    case WM_BUTTON2CLICK:
    case WM_BUTTON3CLICK:
    case WM_CHORD:
    {
      event.setPassToOwner(false);
      break;
    }
#ifdef IC_MOTIF
    case xEvent(KeyPress):
    {
      IKeyboardEvent keyEvent( event );
      if (keyEvent.isVirtual() )
      {
        if (keyEvent.virtualKey() == IKeyboardEvent::enter )
        {
          event.setPassToOwner(false);
          break;
        }
      }
      break;
    }
#endif // IC_MOTIF

    default:
      Inherited::passEventToOwner( event );
      break;
  }
  return event.passToOwner();
}
#endif // IC_MOTIFWIN

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IFrameWindow::setBidiSettings                                                |
|                                                                              |
| Provide processing specific to a frame window for a change to its            |
| bidirectional attributes.                                                    |
|                                                                              |
------------------------------------------------------------------------------*/
IFrameWindow&
  IFrameWindow::setBidiSettings ( const IBidiSettings& bidiSettings,
                                  bool childInherit,
                                  bool refresh )
{
  // The below is needed only to work around a PM bug.
//this->sendEvent( IC_UM_BIDI_CHANGE );

  if ( childInherit )
  {
#ifdef IC_WIN
     // Update the menu bar.
     IMenuHandle
       menuHandle = IMenu::menuWithParent( *this );
     if ( menuHandle )
     {
        IMenuPrivate::setBidiAttributes( menuHandle, bidiSettings );
     }
#endif // IC_WIN

     //-----------------------------------------------------------------
     // To update floating or hidden tool bars, we send a private
     // message to the frame window.  The tool bar handler that
     // the tool bar attaches to the frame window is responsible
     // for updating the bidi attributes of the tool bar.
     //-----------------------------------------------------------------
     this->sendEvent( IC_UM_TOOLBAR, IC_UM_TBAR_BIDI_CHANGE );
  }

  this->IFrameWindow::Inherited::setBidiSettings( bidiSettings,
                                                  childInherit,
                                                  refresh );

  return *this;
}
#endif // IC_PMWIN
