// Revision: 29 1.16.2.4 source/ui/baseapp/ifontdlg.cpp, views, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ifontdlg.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ifontdlg.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Priority INT_MIN (-2147483647 - 1) + 1024 + 512
#pragma priority( -2147482112 )

extern "C" {
  #define INCL_WINSTDFONT
  #define INCL_WINWINDOWMGR
  #define INCL_WINSYS
  #define INCL_WINBUTTONS
  #define IUSING_OLE
  #ifdef WIN32_LEAN_AND_MEAN
    #undef WIN32_LEAN_AND_MEAN
  #endif
  #include <iwindefs.h>
  #include <string.h>
  #ifdef IC_MOTIF
    #include <Xm/Xm.h>
    #include <Xm/AtomMgr.h>
  #endif
}

#include <ifontdlg.hpp>
#ifdef IC_PM
  #include <ipmexsta.hpp>
#endif
#include <icconst.h>
#include <icoordsy.hpp>
#include <idefstyl.h>
#include <ievent.hpp>
#include <iexcept.hpp>
#include <ifildprv.hpp>
#include <ifont.hpp>
#include <ihandler.hpp>
#include <ihelp.hpp>
#include <iobjwin.hpp>
#include <iplatfrm.hpp>
#include <ireslib.hpp>
#include <ithread.hpp>
#include <itrace.hpp>
#include <imsgtext.hpp>
#ifdef IC_WIN
  #include <icolor.hpp>
#endif // IC_WIN

#ifdef IC_MOTIF
  #include <iftdpriv.hpp>
  #include <ixlfdstr.hpp>
#endif

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IFONTDLG_CPP_
  #include <ipagetun.h>
#endif

const IFontDialog::Style
  IFontDialog::helpButton        ( 1, IFontDialog__helpButton        ),
  IFontDialog::applyButton       ( 1, IFontDialog__applyButton       ),
  IFontDialog::resetButton       ( 1, IFontDialog__resetButton       ),
  IFontDialog::modeless          ( 1, IFontDialog__modeless          ),
  IFontDialog::proportionalOnly  ( 1, IFontDialog__proportionalOnly  ),
  IFontDialog::bitmapOnly        ( 1, IFontDialog__bitmapOnly        ),
  IFontDialog::vectorOnly        ( 1, IFontDialog__vectorOnly        ),
  IFontDialog::fixedWidthOnly    ( 1, IFontDialog__fixedWidthOnly    ),
  IFontDialog::noSynthesize      ( 1, IFontDialog__noSynthesize      ),
  IFontDialog::noStyle           ( 1, IFontDialog__noStyle           ),
  IFontDialog::classDefaultStyle ( 1, IFontDialog__classDefaultStyle );

const unsigned long
  IFontDialog::ok                = DID_OK,
  IFontDialog::cancel            = DID_CANCEL;

  IFontDialog::Style
    IFontDialog::currentDefaultStyle ( 1, IFontDialog__classDefaultStyle );

#ifdef IC_PMWIN
#ifdef IC_PM
#define IFLAGDATA  fData->fl
#endif
#ifdef IC_WIN
#define IFLAGDATA  fData->Flags
#define IC_PREVIEW_SET     0x0001
#define IC_TITLE_SET       0x0002
#define IC_POSITION_SET    0x0004
#endif

#pragma enum(4)
#pragma pack(push,4)

class IFontDialogData  {
/*------------------------------------------------------------------------------
| The IFontDialogData class encapsulates private data and functions            |
| used by the IFontDialog class.  An object of this class is created in        |
| the IFontDialog constructors.  This is the Windows/OS/2 version.             |
------------------------------------------------------------------------------*/
public:
  IFontDialogData ( );
 ~IFontDialogData ( );

IFontDialog::Style
  fstyle;
#ifdef IC_WIN
IColor
  clrbackground;

HBRUSH
  bkgrndbrush;
#endif

#ifdef IC_PM
bool
  fMadeHPS;
#endif

}; // IFontDialogData

#pragma pack(pop)
#pragma enum(pop)

/*------------------------------------------------------------------------------
| IFontDialogData::IFontDialogData                                             |
|                                                                              |
------------------------------------------------------------------------------*/
IFontDialogData::IFontDialogData ( )
  : fstyle( IFontDialog::noStyle ),
#ifdef IC_WIN
    clrbackground ( IColor::dialogBgnd ),
    bkgrndbrush( 0 )
#else
    fMadeHPS ( false )
#endif
{ }

/*------------------------------------------------------------------------------
| IFontDialogData::~IFontDialogData                                            |
|                                                                              |
------------------------------------------------------------------------------*/
IFontDialogData::~IFontDialogData ( )
{
#ifdef IC_WIN
  if ( bkgrndbrush != 0 )
    DeleteObject(bkgrndbrush);
#endif
}

//
// Implementation for nested Settings

/*------------------------------------------------------------------------------
| IFontDialog::Settings::Settings                                              |
------------------------------------------------------------------------------*/
IFontDialog::Settings::Settings (IFont* pfont)
{
   fApplyFont = pfont;
#ifdef IC_PM
   fData = new FONTDLG;
   memset(fData, 0, sizeof(FONTDLG) );

   fData->cbSize = sizeof(FONTDLG);
   fData->clrFore = SYSCLR_OUTPUTTEXT;
   fData->clrBack = SYSCLR_ENTRYFIELD;
   fData->usWeight = 5;
   fData->usWidth = 5;
   fData->fAttrs.usRecordLength = sizeof(FATTRS);
#endif
#ifdef IC_WIN
   // Initialize settings data for the new data block
   fSettingsChanged = 0;
   fData = new CHOOSEFONT;
   memset(fData, 0, sizeof(CHOOSEFONT) );
   fData->lStructSize = sizeof(CHOOSEFONT);

   // Copy the font information out of the font passed
   fData->lpLogFont = new LOGFONT;
   fData->Flags |= CF_SCREENFONTS;
   fData->nFontType = SCREEN_FONTTYPE;
#endif
   if (fApplyFont)
   {
#ifdef IC_PM
     memcpy(&(fData->fAttrs), fApplyFont->fattrs(), sizeof(FATTRS));
     fData->fxPointSize = MAKEFIXED(fApplyFont->pointSize(), 0);
#endif
#ifdef IC_WIN
     memcpy( fData->lpLogFont, fApplyFont->logfont(), sizeof(LOGFONT) );
#endif
     IFLAGDATA |= FNTS_INITFROMFATTRS;

     if (fApplyFont->isBitmapOnly())
       IFLAGDATA |= FNTS_BITMAPONLY;

     if (fApplyFont->isVectorOnly())
       IFLAGDATA |= FNTS_VECTORONLY;

     if (fApplyFont->isNonPropOnly())
       IFLAGDATA |= FNTS_FIXEDWIDTHONLY;
   }
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::~Settings                                             |
------------------------------------------------------------------------------*/
IFontDialog::Settings::~Settings ()
{
#ifdef IC_PM
   delete [] fData->pszTitle;
   delete [] fData->pszPreview;
   delete [] fData->pszPtSizeList;
   delete [] fData->pszFamilyname;
#endif
#ifdef IC_WIN
   delete fData->lpLogFont;
#endif
   delete fData;
}

/*------------------------------------------------------------------------------
| IFontDialog::Settings::setFont                                               |
------------------------------------------------------------------------------*/
IFontDialog::Settings& IFontDialog::Settings::setFont( IFont* font )
{
   fApplyFont = font;

   if (fApplyFont)
   {
#ifdef IC_PM
     memcpy(&(fData->fAttrs), fApplyFont->fattrs(), sizeof(FATTRS));
     fData->fxPointSize = MAKEFIXED(fApplyFont->pointSize(), 0);
#endif
#ifdef IC_WIN
     memcpy( fData->lpLogFont, fApplyFont->logfont(), sizeof(LOGFONT) );
#endif
     IFLAGDATA |= FNTS_INITFROMFATTRS;

     if (fApplyFont->isBitmapOnly())
       IFLAGDATA |= FNTS_BITMAPONLY;

     if (fApplyFont->isVectorOnly())
       IFLAGDATA |= FNTS_VECTORONLY;

     if (fApplyFont->isNonPropOnly())
       IFLAGDATA |= FNTS_FIXEDWIDTHONLY;
   }
   return *this;
}

/*------------------------------------------------------------------------------
| IFontDialog::Settings::setTitle                                              |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setTitle (const char* pszTitle)
{
#ifdef IC_PM
   delete [] fData->pszTitle;
   if (pszTitle) {
      fData->pszTitle = (PSZ)new char[strlen(pszTitle)+1];
      strcpy((char*)fData->pszTitle, pszTitle);
   } else {
      fData->pszTitle = 0;
   } /* endif */
#endif
#ifdef IC_WIN
   if (pszTitle)
   {
     fTitle = IString( pszTitle );
     fSettingsChanged |= IC_TITLE_SET;
   }
#endif
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings& IFontDialog::Settings::setTitle                       |
------------------------------------------------------------------------------*/
IFontDialog::Settings& IFontDialog::Settings::setTitle(const IResourceId& id)
{
    IString newText = id.resourceLibrary().loadString(id);
    if (newText.length())
      setTitle(newText);
    return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setPreviewText                                        |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setPreviewText (const char* pszPreview)
{
#ifdef IC_PM
   delete [] fData->pszPreview;
   if (pszPreview) {
      fData->pszPreview = (PSZ)new char[strlen(pszPreview)+1];
      strcpy((char*)fData->pszPreview, pszPreview);
   } else {
      fData->pszPreview = 0;
   } /* endif */
#endif
#ifdef IC_WIN
   if (pszPreview)
   {
     fPreview = IString( pszPreview );
     fSettingsChanged |= IC_PREVIEW_SET;
   }
#endif
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings ::setPosition                                          |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings ::setPosition (const IPoint& position)
{
#ifdef IC_PM
   fData->x = (short)(position.x());
   fData->y = (short)(position.y());
#endif
#ifdef IC_WIN
   fPosition = position;
   fSettingsChanged |= IC_POSITION_SET;
#endif
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setDialogTemplate                                     |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setDialogTemplate(const IResourceId& resId)
{
#ifdef IC_PM
   fData->usDlgId = (unsigned short)(resId.id());
   fData->hMod = resId.resourceLibrary().handle();
#endif
#ifdef IC_WIN
   dlgId = resId.id();
   fData->lpTemplateName = MAKEINTRESOURCE(resId.id());
   fData->hInstance = resId.resourceLibrary().handle();
#endif
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setSizeList                                           |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setSizeList (const char* pszSizeList)
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   delete [] fData->pszPtSizeList;
   if (pszSizeList) {
      fData->pszPtSizeList = (PSZ)new char[strlen(pszSizeList)+1];
      strcpy((char*)fData->pszPtSizeList, pszSizeList);
   } else {
      fData->pszPtSizeList = 0;
   } /* endif */
#endif
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setDisplayPS                                          |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setDisplayPS (const IPresSpaceHandle& hpsDisplay)
{
#ifdef IC_PM
   fData->hpsScreen = hpsDisplay;
#endif
#ifdef IC_WIN
   fData->hDC = 0;
   fData->Flags &= ~CF_PRINTERFONTS;
#endif
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setPrinterPS                                          |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setPrinterPS (const IPresSpaceHandle& hpsPrinter)
{
#ifdef IC_PM
   fData->hpsPrinter = hpsPrinter;
#endif
#ifdef IC_WIN
   fData->hDC = hpsPrinter;
   fData->Flags |= CF_PRINTERFONTS;
#endif
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setFamily                                             |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setFamily (const char* pszFontFamily)
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   delete [] fData->pszFamilyname;
   fData->pszFamilyname = new char[strlen(pszFontFamily) + 1];
   strcpy(fData->pszFamilyname, pszFontFamily);
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IFontDialog::Settings::setPointSize                                          |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setPointSize (unsigned long usPointSize)
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   fData->fxPointSize = MAKEFIXED(usPointSize, 0);
#endif
   return *this;
}

//
// Implementation for IFontDialog
//
/*------------------------------------------------------------------------------
| IFontDialog::IFontDialog                                                     |
------------------------------------------------------------------------------*/
IFontDialog::IFontDialog(IWindow*     parent,
                         IWindow*     owner,
                         const Style& style )
             : IFrameWindow(IFrameWindow::deferCreation),
               fFontDialogData( new IFontDialogData )
{
   Settings tempSettings;
   initialize(parent, owner, style, (IHandler*)0, tempSettings );
}

/*------------------------------------------------------------------------------
| IFontDialog::IFontDialog                                                     |
------------------------------------------------------------------------------*/
IFontDialog::IFontDialog(IWindow*        parent,
                         IWindow*        owner,
                         const Settings& settings,
                         const Style&    style )
             : IFrameWindow(IFrameWindow::deferCreation),
               fFontDialogData( new IFontDialogData )
{
   initialize(parent, owner, style, (IHandler*)0, settings );
}

/*------------------------------------------------------------------------------
| IFontDialog::IFontDialog                                                     |
------------------------------------------------------------------------------*/
IFontDialog::IFontDialog(IWindow*    parent,
                         IWindow*    owner,
                         const Style&    style,
                         const Settings& settings )
             : IFrameWindow(IFrameWindow::deferCreation),
               fFontDialogData( new IFontDialogData )
{
   initialize(parent, owner, style, (IHandler*)0, settings );

}

/*------------------------------------------------------------------------------
| IFontDialog::IFontDialog                                                     |
------------------------------------------------------------------------------*/
IFontDialog::IFontDialog(IWindow*        parent,
                         IWindow*        owner,
                         IHandler*       handler,
                         const Style&    style,
                         const Settings& settings )
             : IFrameWindow(IFrameWindow::deferCreation),
               fFontDialogData( new IFontDialogData )
{
   initialize(parent, owner, style, handler, settings );
}


/*------------------------------------------------------------------------------
| IFontDialog::~IFontDialog                                                    |
------------------------------------------------------------------------------*/
IFontDialog::~IFontDialog  ()
{
#ifdef IC_PM
   delete [] fData->pszTitle;
   delete [] fData->pszPreview;
   delete [] fData->pszPtSizeList;
   delete [] fData->pszFamilyname;
#endif
#ifdef IC_WIN
   // Cleanup modeless dialog window for non-AutoDeleteObject case.
   if (!this->isAutoDeleteObject() )
   {
      IModelessDialogWindow* objwin = dynamic_cast<IModelessDialogWindow*>(
         IWindow::windowWithHandle( this->fData->hwndOwner ) );

      // Force the destruction of the object window if there is one.
      // This will occur later because close() is processed via a post event.
      if (objwin)
      {
         objwin->setDialogWindow(0);   // we are already deleting the dialog.
         objwin->close();
      }
   }
   delete fData->lpLogFont;
#endif
   if (fFontDialogData != 0)
      delete fFontDialogData;
   delete fData;
}


/*------------------------------------------------------------------------------
| IFontDialog::pointSize                                                       |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::pointSize () const
{
#ifdef IC_PM
   return FIXEDINT(fData->fxPointSize);
#endif
#ifdef IC_WIN
   return (unsigned long)(fData->iPointSize/10);
#endif
}


/*------------------------------------------------------------------------------
| IFontDialog::fontFamily                                                      |
------------------------------------------------------------------------------*/
IString IFontDialog::fontFamily () const
{
   ITRACE_WIN_NOP();

   IString strTemp;
#ifdef IC_PM
   strTemp = (char*)fData->pszFamilyname;
#endif
   return strTemp;
}


/*------------------------------------------------------------------------------
| IFontDialog::emHeight                                                        |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::emHeight () const
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   return fData->lEmHeight;
#else
   return 0;
#endif
}


/*------------------------------------------------------------------------------
| IFontDialog::xHeight                                                         |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::xHeight () const
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   return fData->lXHeight;
#else
   return 0;
#endif
}


/*------------------------------------------------------------------------------
| IFontDialog::externalLeading                                                 |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::externalLeading () const
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   return fData->lExternalLeading;
#else
   return 0;
#endif
}


/*------------------------------------------------------------------------------
| IFontDialog::nominalPointSize                                                |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::nominalPointSize () const
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   return fData->sNominalPointSize;
#else
   return 0;
#endif
}


/*------------------------------------------------------------------------------
| IFontDialog::fontWeight                                                      |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::fontWeight () const
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   return fData->usWeight;
#else
   return 0;
#endif
}


/*------------------------------------------------------------------------------
| IFontDialog::fontWidth                                                       |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::fontWidth () const
{
   ITRACE_WIN_NOP();

#ifdef IC_PM
   return fData->usWidth;
#else
   return 0;
#endif
}


/*------------------------------------------------------------------------------
| IFontDialog::isModeless                                                      |
------------------------------------------------------------------------------*/
bool IFontDialog::isModeless () const
{
   return (fFontDialogData->fstyle & IFontDialog::modeless);
}


/*------------------------------------------------------------------------------
| IFontDialog::buttonPressedId                                                 |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::buttonPressedId () const
{
#ifdef IC_PM
   return fData->lReturn;
#endif
#ifdef IC_WIN
   return fReturnVal;
#endif
}

/*------------------------------------------------------------------------------
| IFontDialog::pressedOK                                                       |
------------------------------------------------------------------------------*/
bool IFontDialog::pressedOK () const
{
   return buttonPressedId() == DID_OK;
}

/*------------------------------------------------------------------------------
| IFontDialog::returnValue                                                     |
| Returns the system return code from the font                                 |
| dialog.  FNTS_SUCCESSFUL means no error occured.                             |
| A positive return indicates an error.  The codes                             |
| are listed in the fcldlgp.h file.                                            |
------------------------------------------------------------------------------*/
long IFontDialog::returnValue () const
{
#ifdef IC_PM
   return fData->lSRC;
#endif
#ifdef IC_WIN
   return fSRC;
#endif
}

/*------------------------------------------------------------------------------
| IFontDialog::defaultStyle                                                    |
|                                                                              |
| Return the default style for new font dialog objects.                        |
------------------------------------------------------------------------------*/
IFontDialog::Style  IFontDialog::defaultStyle()
{
  return currentDefaultStyle;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IFontDialog::setDefaultStyle                                                 |
|                                                                              |
| Set the default style for new font dialog objects.                           |
------------------------------------------------------------------------------*/
void IFontDialog::setDefaultStyle( const IFontDialog::Style& newDefault )
{
  currentDefaultStyle = newDefault;
}
#endif

/*------------------------------------------------------------------------------
| IFontDialog::convertToGUIStyle                                               |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::convertToGUIStyle(const IBitFlag& guiStyle,
                                             bool bExtOnly) const
{
  unsigned long ulStyle(0);
  const IFontDialog::Style& bitStyle = (const IFontDialog::Style&)guiStyle;

#ifdef IC_WIN
  if (bExtOnly)
  {
     ulStyle = Inherited::convertToGUIStyle( guiStyle, bExtOnly );
     if (bitStyle & IFontDialog::modeless)
        ulStyle |= IFDS_MODELESS;
  }
  else
  {
     // The font dialog styles are completely disjoint from the IFrameWindow
     // styles because they are specified in the CHOOSEFONT structure rather
     // than in CreateWindow.  Do not call Inherited::convertToGUIStyle.

     ulStyle |= CF_SCREENFONTS | CF_EFFECTS;  //Always on.

     if (bitStyle & IFontDialog::helpButton)
        ulStyle |= CF_SHOWHELP;
     if (bitStyle & IFontDialog::applyButton)
        ulStyle |= CF_APPLY;
     if (bitStyle & IFontDialog::bitmapOnly)
        ulStyle |= CF_NOVECTORFONTS;
     if (bitStyle & IFontDialog::vectorOnly)
        ulStyle |= CF_SCALABLEONLY;
     if (bitStyle & IFontDialog::fixedWidthOnly)
        ulStyle |= CF_FIXEDPITCHONLY;
     if (bitStyle & IFontDialog::noSynthesize)
        ulStyle |= CF_NOSIMULATIONS;
  }
#endif //IC_WIN
#ifdef IC_PM
  if (bExtOnly)
  {
     ulStyle = Inherited::convertToGUIStyle( guiStyle, bExtOnly );
  }
  else
  {
     // The font dialog styles are completely disjoint from the IFrameWindow
     // styles because they are specified in the FONTDLG structure rather
     // than in WinCreateWindow.  Do not call Inherited::convertToGUIStyle.
     if (bitStyle & IFontDialog::helpButton)
        ulStyle |= FNTS_HELPBUTTON;
     if (bitStyle & IFontDialog::applyButton)
        ulStyle |= FNTS_APPLYBUTTON;
     if (bitStyle & IFontDialog::resetButton)
        ulStyle |= FNTS_RESETBUTTON;
     if (bitStyle & IFontDialog::modeless)
        ulStyle |= FNTS_MODELESS;
     if (bitStyle & IFontDialog::proportionalOnly)
        ulStyle |= FNTS_PROPORTIONALONLY;
     if (bitStyle & IFontDialog::bitmapOnly)
        ulStyle |= FNTS_BITMAPONLY;
     if (bitStyle & IFontDialog::vectorOnly)
        ulStyle |= FNTS_VECTORONLY;
     if (bitStyle & IFontDialog::fixedWidthOnly)
        ulStyle |= FNTS_FIXEDWIDTHONLY;
     if (bitStyle & IFontDialog::noSynthesize)
        ulStyle |= FNTS_NOSYNTHESIZEDFONTS;
  }
#endif //IC_PM

  return( ulStyle );
}

/*------------------------------------------------------------------------------
| IFontDialog::id                                                              |
|                                                                              |
| Get the object identity                                                      |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::id() const
{
#ifdef IC_WIN
  return fDialogId;
#else
  return Inherited::id( );
#endif

}

/*------------------------------------------------------------------------------
| IFontDialog::setId                                                           |
|                                                                              |
| Set the object identifier                                                    |
------------------------------------------------------------------------------*/
IFontDialog& IFontDialog::setId( unsigned long ulId )
{
#ifdef IC_WIN
  fDialogId = ulId;
#else
  Inherited::setId( ulId );
#endif
  return *this;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IFontDialog::backgroundColor                                                 |
|                                                                              |
| Returns the background color of the font dialog.                             |
------------------------------------------------------------------------------*/
IColor IFontDialog::backgroundColor () const
{
  return fFontDialogData->clrbackground;
}

/*------------------------------------------------------------------------------
| IFontDialog::setBackgroundColor                                              |
|                                                                              |
| Stores the background color of the font dialog.                              |
------------------------------------------------------------------------------*/
IFontDialog& IFontDialog::setBackgroundColor (const IColor &color)
{
  fFontDialogData->clrbackground = color;
  return *this;
}
#endif // IC_WIN

/*------------------------------------------------------------------------------
| IFontDialog::initialize                                                      |
------------------------------------------------------------------------------*/
void IFontDialog::initialize (IWindow*        parent,
                              IWindow*        owner,
                              const Style&    style,
                              IHandler*       handler,
                              const Settings& settings)
{
   // Save the style flags for later use.
   fFontDialogData->fstyle = style;
#ifdef IC_PM
   // It's possible that the first thing an application may do is
   // create a IFontDialog. Since we deferCreation of our parent IFrameWindow
   // we should be sure that PM has been initialized.
   IThread::current().initializeGUI();

   fApplyFont = settings.fApplyFont;

   _handlerToAdd = handler;

   fData = new FONTDLG;
   memcpy(fData, settings.fData, sizeof(FONTDLG) );

   if (settings.fData->pszTitle) {
      char* src = settings.fData->pszTitle;
      fData->pszTitle = new char[strlen(src) + 1];
      strcpy(fData->pszTitle, src);
   }

   if (settings.fData->pszPreview) {
      char* src = settings.fData->pszPreview;
      fData->pszPreview = new char[strlen(src) + 1];
      strcpy(fData->pszPreview, src);
   }

   if (settings.fData->pszPtSizeList) {
      char* src = settings.fData->pszPtSizeList;
      fData->pszPtSizeList = new char[strlen(src) + 1];
      strcpy(fData->pszPtSizeList, src);
   }

   fData->pszFamilyname = new char[FACESIZE];
   fData->usFamilyBufLen = FACESIZE;
   if (settings.fData->pszFamilyname)
      strncpy(fData->pszFamilyname, settings.fData->pszFamilyname, FACESIZE);

   // Save the extended style to make sure we have a copy of it stored
//   setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

   // Convert the style bits into the GUI native style settings
   fData->fl = convertToGUIStyle( style );

   if (fApplyFont) {
      fData->fl |= FNTS_INITFROMFATTRS;
      // Even with FNTS_INITFROMATTRS set, wants the name to be displayed
      // set in pszFamilyname.
      strncpy(fData->pszFamilyname, settings.fData->fAttrs.szFacename, FACESIZE);

   }

   if (fData->x == 0 && fData->y ==0)
      fData->fl |= FNTS_CENTER;

   if (fData->usDlgId) {
      fData->fl |= FNTS_CUSTOM;
   }

   fData->ulUser = (unsigned long)this;

   fData->pfnDlgProc = (FNWP*)_IFontDlgProc;

   if (!fData->hpsScreen && !fData->hpsPrinter) {
      fData->hpsScreen = WinGetPS(HWND_DESKTOP);
      fFontDialogData->fMadeHPS = true;
   } /* endif */


   // Need to set a variable in IWindow that holds the default procedure
   // so that IFrameHandler will work.
   setDefaultProcedure(IPMCtlStatics::defFontDlgProcAddr());

   if (!IPMCtlStatics::fontDlg(
           parent == 0 ? desktopWindow()->handle() :
                            parent->handleForChildCreation(),
           owner  == 0 ? IWindowHandle(0) : owner->handle(),
           fData))
   {
      ITHROWGUIERROR("WinFontDlg");
   }

   if (fFontDialogData->fMadeHPS &&
       !(fFontDialogData->fstyle & IFontDialog::modeless) )
      WinReleasePS(fData->hpsScreen);

#endif
#ifdef IC_WIN
   /*******************************************************************/
   /* Declare a variable for saving font to apply to the dialog, save */
   /* handler passed into the dialog data (for use in subclass proc)  */
   /*******************************************************************/
   BOOL rc;
   fReturnVal = 0;
   fSRC = 0;
   fApplyFont = settings.fApplyFont;
   _handlerToAdd = handler;

   /*******************************************************************/
   /* Copy the settings data passed into a new settings data block    */
   /*******************************************************************/
   fData = new CHOOSEFONT;
   memcpy( fData, settings.fData, sizeof(CHOOSEFONT) );
   fData->lStructSize = sizeof(CHOOSEFONT);

   /*******************************************************************/
   /* Copy the font information out of the old settings data block    */
   /*******************************************************************/
   fData->lpLogFont = new LOGFONT;
   memcpy( fData->lpLogFont, settings.fData->lpLogFont, sizeof(LOGFONT) );

   /*******************************************************************/
   /* Save the extended style to make sure we have a copy of it stored*/
   /*******************************************************************/
//   setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

   /*******************************************************************/
   /* Convert the style bits into the GUI native style settings and   */
   /* default it to display fonts                                     */
   /*******************************************************************/
   fData->Flags = convertToGUIStyle( style );
   fData->nFontType = SCREEN_FONTTYPE;

   /*******************************************************************/
   /* Check if an initial font was set and if so, set flag to         */
   /* dialog from that fonts information                              */
   /*******************************************************************/
   if (fApplyFont)
     fData->Flags |= CF_INITTOLOGFONTSTRUCT;

   /*******************************************************************/
   /* Set the dialog id.                                              */
   /*******************************************************************/
   fDialogId = IC_FONT_DIALOG;

   /*******************************************************************/
   /* Check if a custom dialog template was specified                 */
   /*******************************************************************/
   if (fData->lpTemplateName)
   {
     fDialogId = settings.dlgId;
     fData->Flags |= CF_ENABLETEMPLATE;
   }

   /*******************************************************************/
   /* Set the owner of the dialog based on parameters passed          */
   /* If dialog is modeless, create an object window and make it owner*/
   /*******************************************************************/
   IModelessDialogWindow* objWin = 0;
   if (style & IFontDialog::modeless)
   {
     objWin = new IModelessDialogWindow( this );
     fData->hwndOwner = objWin->handle();
   }
   /*******************************************************************/
   /*  otherwise use the owner handle passed (if any)                 */
   /*******************************************************************/
   else
     fData->hwndOwner = owner == 0 ? IWindowHandle(0) : owner->handle();

   /*******************************************************************/
   /* Save the this pointer in the application data field in template */
   /* to allow access back to IFontDialog object from within hook proc*/
   /*******************************************************************/
   fData->lCustData = (unsigned long)this;

   /*******************************************************************/
   /* Set the hook proc to our dialog procedure since we need to get  */
   /* in to process interactions                                      */
   /*******************************************************************/
   fData->lpfnHook = (LPCFHOOKPROC)_IFontDlgProc;
   fData->Flags |= CF_ENABLEHOOK;

   /*******************************************************************/
   /* Copy settings specific items out of the settings block          */
   /*******************************************************************/
   fPreview = settings.fPreview;
   fTitle = settings.fTitle;
   fSettingsChanged = settings.fSettingsChanged;
   fPosition = settings.fPosition;

   /*******************************************************************/
   /* Everything is now set up, so invoke the dialog                  */
   /*******************************************************************/
   rc = ChooseFont( fData );

   /*******************************************************************/
   /* Check return code to determine correct return value to set      */
   /*******************************************************************/
   if ( rc )
   {
     fReturnVal = DID_OK;
   }
   else
   {
     fReturnVal = DID_CANCEL;
     fSRC = CommDlgExtendedError();
     if (fSRC)
      ITHROWGUIERROR("ChooseFont");
   }
#endif
}

/*------------------------------------------------------------------------------
| _IFontDlgProc                                                                |
|                                                                              |
| This is the custom dialog procedure that is used to initialize the dialog    |
| and perform the ICLUI magic under the covers.  It does the following tasks:  |
|                                                                              |
|  1) Completes the IFrameWindow initialization that had to be deferred in     |
|     the constructor since the window was not yet created                     |
|  2) Attaches any handlers (like an IFontDialogHandler) requested             |
|  3) Processes font information when the dialog is dismissed                  |
|  4) Routes messages in conformance with our general dispatching logic        |
|  5) Performs special case initialization for Windows functions that are      |
|     not provided in the native operating system API                          |
------------------------------------------------------------------------------*/
#ifdef IC_WIN
void* __stdcall _IFontDlgProc( HWND          hwnd,
#else
void*   _System _IFontDlgProc( unsigned long hwnd,
#endif
                               unsigned long msg,
                               void* mp1, void* mp2 )

{
   void* result(FALSE);       // default result
#ifdef IC_PM
   /*****************************************************************/
   /* Get the "this" pointer for window object from the window word */
   /* which was set by WM_CREATE in above.                          */
   /*****************************************************************/
   FONTDLG* pfntstruct = (FONTDLG*)WinQueryWindowPtr(hwnd, QWL_USER);
   IFontDialog* pfntd = (IFontDialog*)pfntstruct->ulUser;

   if (pfntd == 0)                   // No window object pass to defWin.
       return IPMCtlStatics::defFontDlgProc(hwnd, msg, mp1, mp2);
#else
   IFontDialog* pfntd = (IFontDialog*)IQUERYWINDOWULONG( hwnd, DWL_USER );
   if ((pfntd == 0) && (msg != WM_INITDLG))     // No window object to pass
     return FALSE;
#endif

   switch(msg)
   {
#ifdef IC_WIN
      case WM_CTLCOLORDLG:
      case WM_CTLCOLORSTATIC:
      case WM_CTLCOLORBTN:
      {
        IColor clrBgnd = pfntd->backgroundColor();
        IEvent evt(hwnd, msg, mp1, mp2);

        // Set background colors in device context
        SetBkColor( (HDC)evt.parameter1(), clrBgnd.asRGBLong() );

        // Return HBRUSH for painting controls background
        if ( pfntd->fFontDialogData->bkgrndbrush != 0 )
          DeleteObject( pfntd->fFontDialogData->bkgrndbrush );
        pfntd->fFontDialogData->bkgrndbrush =
          CreateSolidBrush (NEARESTPALETTECOLOR(clrBgnd.asRGBLong()));
        return( pfntd->fFontDialogData->bkgrndbrush );
      }
      break;
#endif //IC_WIN

      case WM_INITDLG:
      {
#ifdef IC_WIN
         /*************************************************************/
         /* Get the "this" pointer for font dialog object from lparam */
         /* (saved in custData) and typecast for usage.               */
         /*************************************************************/
         CHOOSEFONT* cfs = (CHOOSEFONT*)mp2;
         pfntd = (IFontDialog*)cfs->lCustData;


         /*************************************************************/
         /* Modify the preview text string, if one was set            */
         /*************************************************************/
         if (pfntd->fSettingsChanged & IC_PREVIEW_SET)
           ISETWINDOWTEXT( IWINDOWFROMID( hwnd, stc5 ), pfntd->fPreview );

         /*************************************************************/
         /* Modify the title text string, if one was set              */
         /*************************************************************/
         if (pfntd->fSettingsChanged & IC_TITLE_SET)
           ISETWINDOWTEXT( hwnd, pfntd->fTitle );

         /*************************************************************/
         /* Hide the color control since we don't support it in OC    */
         /*************************************************************/
         ISHOWWINDOW( IWINDOWFROMID( hwnd, stc4 ), FALSE );
         ISHOWWINDOW( IWINDOWFROMID( hwnd, cmb4 ), FALSE );

         /*************************************************************/
         /* If the dialog position was set, move it to that spot      */
         /*************************************************************/
         if (pfntd->fSettingsChanged & IC_POSITION_SET)
         {
           /***********************************************************/
           /* Get the position requested which is relative to the     */
           /*  owner window and convert it to screen coordinates      */
           /***********************************************************/
			     RECT rectOwner = {0,0,0,0};
           IPoint pos = pfntd->fPosition;

					 if( cfs->hwndOwner )	
           		GetWindowRect( cfs->hwndOwner, &rectOwner );
           		
           pos.setX( rectOwner.left + pos.x() );

           /***********************************************************/
           /* If coordinate system is different, recoordinate here    */
           /***********************************************************/
           if (ICoordinateSystem::applicationOrientation() ==
                                      ICoordinateSystem::kOriginLowerLeft )
           {
             	RECT rectDlg = {0,0,0,0};
           		GetWindowRect( hwnd, &rectDlg );

					 		if( cfs->hwndOwner )	
					 		{
             		pos.setY( rectOwner.bottom - pos.y() -
                       (rectDlg.bottom - rectDlg.top) );
              }
              else
							{
			  	     	long desktopHeight = IWindow::desktopWindow()->size().height();
		         		pos.setY( desktopHeight - pos.y() -
                       (rectDlg.bottom - rectDlg.top) );
								
							}
           }
           else
             pos.setY( rectOwner.top + pos.y() );

           /***********************************************************/
           /* Once position is calculated in screen coord,move window */
           /***********************************************************/
           ISETWINDOWPOS( hwnd, NULL, pos.x(), pos.y(), 0, 0,
                          SWP_NOZORDER | SWP_NOSIZE | SWP_NOACTIVATE );
         }
         if (cfs->hwndOwner)
         {
           // Insure that owner is behind this window
           ISETWINDOWPOS( cfs->hwndOwner, hwnd, 0,0,0,0,
                          SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE );
         }
         /*************************************************************/
         /* Since this is only passed on WM_INITDIALOG, save in the   */
         /* user window word so that we can retrieve it on other msgs */
         /*************************************************************/
         ISETWINDOWULONG( hwnd, DWL_USER, (LPARAM)pfntd );

         /*************************************************************/
         /*  Unless there is a user provided handler that processes   */
         /*  WM_INITDIALOG, we want to return true to Windows.  This  */
         /*  tells Windows to set focus to the dialog.                */
         /*************************************************************/
         result = (void*)1;
#endif
         /*************************************************************/
         /* Default IFrameWindow handler needed since we created the  */
         /* Frame with the deferCreation flag.  Also need to add the  */
         /* window to the window list for the same reason             */
         /*************************************************************/
         pfntd->addDefaultHandler();
         pfntd->addToWindowSet(pfntd, IWindowHandle(hwnd));

         /*************************************************************/
         /* If an additional handler is to be used, add it now        */
         /*************************************************************/
         if (pfntd->_handlerToAdd != 0)
            pfntd->_handlerToAdd->handleEventsFor(pfntd);

         break;
      }

      case WM_COMMAND:
      {
         /*************************************************************/
         /* Setup id of apply pushbutton                              */
         /*************************************************************/
         unsigned short applyButton =
#ifdef IC_WIN
                                      psh3;
#else
                                      DID_APPLY_BUTTON;
#endif
         /*************************************************************/
         /* Check if the apply button was hit for a modeless dialog   */
         /*************************************************************/
#ifdef IC_WIN
         if (pfntd->isModeless() && (LOWORD((WPARAM)mp1) == applyButton)
             && (HIWORD((WPARAM)mp1) == BN_CLICKED))
#else
         if (pfntd->isModeless() && (LOWORD((WPARAM)mp1) == applyButton))
#endif
         {
           /***********************************************************/
           /* Get font device context                                 */
           /***********************************************************/
#ifdef IC_WIN
           HDC device = pfntd->fData->hDC;
#else
           HPS device;
           if (pfntd->fData->flFlags & FNTF_SCREENFONTSELECTED)
              device = pfntd->fData->hpsScreen;
           else if (pfntd->fData->flFlags & FNTF_PRINTERFONTSELECTED)
              device = pfntd->fData->hpsPrinter;
           else
              device = 0;
#endif
           /***********************************************************/
           /* If so, then modify any settings font passed             */
           /***********************************************************/
           if (pfntd->fApplyFont)
             pfntd->fApplyFont->setFontFromDialog( *pfntd,
                                                   IPresSpaceHandle( device,
                                                                     IWindowHandle() ) );
              // Note: No attempt is made to construct the IPresSpaceHandle
              // with an IWindowHandle that matches the device.  For at
              // least the time being, IFont provides no way to query the
              // IPresSpaceHandle, and the only use of the IWindowHandle is
              // when using grafport functions to draw on OS/2 (and IFont
              // provides no mechanism for drawing itself).

           /***********************************************************/
           /* then send message to self that font should be applied   */
           /***********************************************************/
           pfntd->handle().sendEvent( IC_UM_DLG_APPLY_PRESSED,
                                      IEventParameter1( pfntd->fApplyFont ),
                                      IEventParameter2( 0 ) );
         }
#ifdef IC_WIN
         /*************************************************************/
         /* Check if the OK button was hit for the dialog             */
         /*************************************************************/
         if (( LOWORD((WPARAM)mp1) == DID_OK ) &&
             ( HIWORD((WPARAM)mp1) == BN_CLICKED ))
         {
           // If Windows 95, copy the logfont structure, since it does
           // not copy it until after the window is destroyed
         if (IPlatform::isWin9x())
           pfntd->handle().sendEvent( WM_CHOOSEFONT_GETLOGFONT,
                         IEventParameter1( 0 ),
                         IEventParameter2( pfntd->fData->lpLogFont ));

           pfntd->fReturnVal = DID_OK;
         }

         /*************************************************************/
         /* If Help button pressed,                                   */
         /*************************************************************/
         if (( LOWORD((WPARAM)mp1) == pshHelp ) &&
             ( HIWORD((WPARAM)mp1) == BN_CLICKED ))
         {
             POINT nullPoint;
             HELPINFO helpInfo;
             helpInfo.cbSize = sizeof(HELPINFO);
             helpInfo.MousePos = nullPoint;
             helpInfo.dwContextId  = 0;
             helpInfo.hItemHandle = pfntd->handle();
             helpInfo.iCtrlId = (int)pfntd->id();
             helpInfo.iContextType = HELPINFO_WINDOW;
             IEvent evt(pfntd, WM_HELP, 0, &helpInfo);
             // Allow our handlers a chance at help first.
             // processed then send on to system.
             if ( !pfntd->dispatch(evt) )
             {
                 IWindow* owner = pfntd->owner();
                 if (owner)
                    owner->sendEvent( evt );
             }
         }
#endif
         // Intentional fall through to next case.
      }
      case WM_SYSCOMMAND:
      case WM_CLOSE:
#ifdef IC_WIN
      /****************************************************************/
      /* Do not dispatch paint messages since doing so causes problems*/
      /*  with painting in the preview window in Windows              */
      /****************************************************************/
      case WM_PAINT:
         return 0;
#else
         return IPMCtlStatics::defFontDlgProc(hwnd, msg, mp1, mp2);
#endif

   } /* end switch */

#ifdef IC_WIN
  // Call dispatch so that any handlers will get called.  We do not dispatch
  // WM_DESTROY because that could cause IWindow to delete the dialog while
  // we still need it.
  if (msg == WM_DESTROY)
  {
     if (pfntd->pressedOK() && pfntd->fApplyFont)
     {
       HDC activeDevice = pfntd->fData->hDC;
       pfntd->fApplyFont->setFontFromDialog( *pfntd,
                                             IPresSpaceHandle( activeDevice,
                                                               IWindowHandle() ) );
         // Note: No attempt is made to construct the IPresSpaceHandle
         // with an IWindowHandle that matches the device.  For at
         // least the time being, IFont provides no way to query the
         // IPresSpaceHandle, and the only use of the IWindowHandle is
         // when using grafport functions to draw on OS/2 (and IFont
         // provides no mechanism for drawing itself).
     }

     // We need to dispatch a message to the dialog handler to indicate that
     // the dialog is closing.  This is to insure modelessResults gets called.
     // Note that parameter2 is 1, which is the indication that this message
     // is for a destroy and not the apply button.
     IEvent newEvt(pfntd, IC_UM_DLG_APPLY_PRESSED, 0, 1);
     pfntd->dispatch(newEvt);

     // The handle is no longer valid.  Remove from window list.
     pfntd->removeFromWindowSet(pfntd);

     if (pfntd->isAutoDeleteObject() )
     {
        IModelessDialogWindow* objwin = dynamic_cast<IModelessDialogWindow*>(
           IWindow::windowWithHandle( pfntd->fData->hwndOwner ) );

        // Force the destruction of the object window and the file dialog object.
        // This will occur later because close() is processed via a post event.
        if (objwin)
           objwin->close();
     }
  }
  else
  {
     IEvent newEvt(pfntd, msg, mp1, mp2);
     if (pfntd->dispatch(newEvt))
        result = newEvt.result();
  }

  ISETWINDOWULONG(hwnd, DWL_MSGRESULT, (unsigned long)result);

#endif //IC_WIN
#ifdef IC_PM

  IEvent newEvt(hwnd, msg, mp1, mp2);

  if(msg==WM_DESTROY)
  {

     if (pfntd->pressedOK() && pfntd->fApplyFont)
     {
       HPS activeDevice;
       if (pfntd->fData->flFlags & FNTF_SCREENFONTSELECTED)
          activeDevice = pfntd->fData->hpsScreen;
       else if (pfntd->fData->flFlags & FNTF_PRINTERFONTSELECTED)
          activeDevice = pfntd->fData->hpsPrinter;
       else
          activeDevice = 0;
       pfntd->fApplyFont->setFontFromDialog( *pfntd,
                                             IPresSpaceHandle( activeDevice,
                                                               IWindowHandle() ) );
         // Note: No attempt is made to construct the IPresSpaceHandle
         // with an IWindowHandle that matches the device.  For at
         // least the time being, IFont provides no way to query the
         // IPresSpaceHandle, and the only use of the IWindowHandle is
         // when using grafport functions to draw on OS/2 (and IFont
         // provides no mechanism for drawing itself).
     }

     if (pfntd->fFontDialogData &&
         pfntd->fFontDialogData->fMadeHPS &&
         pfntd->isModeless())
        WinReleasePS(pfntd->fData->hpsScreen);
  }

  if (pfntd->dispatch(newEvt))
     result = newEvt.result();
  else
     result = IPMCtlStatics::defFontDlgProc(hwnd, msg, mp1, mp2);

//  dispatch will delete object on WM_DESTROY if autoDeleteObject specified.

#endif //IC_PM

  return result;
}

#endif  //IC_PMWIN

#ifdef IC_MOTIF

// Command event ID sent to refresh the dialog
#define FONTDLG_REFRESH_COMMAND 323

// Loads the button label text from the message catalog
static IString loadButtonLabel( unsigned long messageId,
                                const char   *defaultText ) ;

IString const& key(IXLFDString* const f)
{
   return f->keyNameLong();
}

/*------------------------------------------------------------------------------
| IFontDialogSettingsData::IFontDialogSettingsData                             |
------------------------------------------------------------------------------*/
IFontDialogSettingsData::IFontDialogSettingsData( IFont * font) :
   papplyFont(font),
   hpsScreen(0),
   hpsPrinter(0),
   title(),
   previewText("abcdABCD"),
   ptSizeList(),
   fl(0),
   position( 0, 0 ),
   fontData( (font == 0) ? IFontPrivateData() : *(font->ppd) ),
   familyName()
{
   IMODTRACE_ALL("IFontDialogSettingsData::IFont * ctor");
}

/*------------------------------------------------------------------------------
| IFontDialogSettingsData::IFontDialogSettingsData                             |
------------------------------------------------------------------------------*/
IFontDialogSettingsData::IFontDialogSettingsData(
                            const IFontDialogSettingsData& another  ) :
   papplyFont (another.papplyFont ),
   hpsScreen  (another.hpsScreen  ),
   hpsPrinter (another.hpsPrinter ),
   title      (another.title      ),
   previewText(another.previewText),
   ptSizeList (another.ptSizeList ),
   fl         (another.fl         ),
   position   (another.position   ),
   fontData   (another.fontData   ),
   familyName (another.familyName )
{
   IMODTRACE_ALL("IFontDialogSettingsData::copy ctor");
}

/*------------------------------------------------------------------------------
| IFontDialogSettingsData::operator=                                           |
------------------------------------------------------------------------------*/
IFontDialogSettingsData& IFontDialogSettingsData::operator=
                                     ( const IFontDialogSettingsData& another )
{
   if (&another != this)
      {
      papplyFont = another.papplyFont ;
      hpsScreen  = another.hpsScreen  ;
      hpsPrinter = another.hpsPrinter ;
      title      = another.title      ;
      previewText= another.previewText;
      ptSizeList = another.ptSizeList ;
      fl         = another.fl         ;
      position   = another.position   ;
      fontData   = another.fontData   ;
      familyName = another.familyName ;
      }
   return *this;
}

/*------------------------------------------------------------------------------
| IFontDialogSettingsData::~IFontDialogSettingsData                            |
------------------------------------------------------------------------------*/
IFontDialogSettingsData::~IFontDialogSettingsData( )
{
   IMODTRACE_ALL("IFontDialogSettingsData::~IFontDialogSettingsData");
}


/*------------------------------------------------------------------------------
| IFontDialogSettingsData::setFont                                             |
------------------------------------------------------------------------------*/
IFontDialogSettingsData& IFontDialogSettingsData::setFont( IFont* font )
{
   papplyFont = font;
   if (font)
   {
      fontData = *(font->ppd);
      fl = fl | FNTS_INITFROMFATTRS;
   }
   else
   {
      fontData = IFontPrivateData();;
      fl = fl & ~FNTS_INITFROMFATTRS;
   }
   return *this;
}


// Implementation for private data class

/*------------------------------------------------------------------------------
| IFontDialogData::IFontDialogData                               |
------------------------------------------------------------------------------*/
IFontDialogData::IFontDialogData(
                            IFontDialog*   fd,
                            IFontDialog::Style style,
                            const IFontDialogSettingsData& settingsData ) :
    frame        (fd),
    settings     (settingsData),
    resetFontData(0),
    returnVal    ( DID_CANCEL_BUTTON ),
    cv           (DID_CANVAS, frame, frame),
    selectionLabel (DID_NAME_PREFIX, &cv, &cv,
                  IRectangle(),
                  IStaticText::vertCenter | IStaticText::left |
                  IWindow::visible ),
    selectionBox (DID_NAME,  &cv, &cv, IRectangle(),
                  IComboBox::simpleType |
                  IComboBox::horizontalScroll |
                  IComboBox::anyData |
                  IWindow::tabStop |
                  IWindow::visible ),
    preview      (DID_SAMPLE, &cv, &cv,
                  IRectangle(),
                  IStaticText::vertCenter | IStaticText::center |
                  IWindow::visible ),
    pointSelectionLabel (DID_SIZE_PREFIX, &cv, &cv,
                  IRectangle(),
                  IStaticText::vertCenter | IStaticText::left |
                  IWindow::visible ),
    pointSizeSel (DID_SIZE, &cv, &cv,
                  IRectangle(),
                  IComboBox::simpleType |
                  IComboBox::horizontalScroll |
                  IComboBox::anyData |
                  IWindow::tabStop |
                  IWindow::visible ),
    styleLabel   (DID_STYLEBOXLABEL, &cv, &cv,
                  IRectangle(),
                  IStaticText::vertCenter | IStaticText::left |
                  IWindow::visible ),
    styleBox     (DID_STYLEBOX, &cv, &cv,
                  IRectangle(),
                  IComboBox::simpleType |
                  IComboBox::horizontalScroll |
                  IComboBox::anyData |
                  IWindow::tabStop |
                  IWindow::visible ),
    buttoncv     (DID_CANVAS2, frame, frame, IRectangle(),
                  ISetCanvas::horizontalDecks |
                  ISetCanvas::packExpanded |
                  ISetCanvas::leftAlign |
                  IWindow::visible ),
    okButton     (0),
    cancelButton (0),
    applyButton  (0),
    resetButton  (0),
    helpButton   (0),
    cmdhdr       (this),
    selhdr       (this),
    edithdr      (this),
    nameList     (0),
    fontSet      (new IFontSetDLG()),
    firstTime    (true),
    needBold     (false),
    needBoldItalic(false),
    needItalic   (false),
    firstPointSize (0),
    selectedResetItem (IBaseComboBox::notFound),
    selectedStyleResetItem (IBaseComboBox::notFound),
    selectedSizeResetItem (IBaseComboBox::notFound),
    resetRequested (false),
    fstyle        (style)
{
   const unsigned long marginPixels = 20;
   // Client area layout.
   //-------------------------------------
   //    <margin>
   //m selectionLabel  styleLabel  pointSelectionLabel m
   //a selectionBox    styleBox    pointSizeSel        a
   //r                                                 r
   //g                preview                          g
   //i                                                 i
   //n   buttons                                       n
   //--------------------------------------
   const unsigned long selectionColumns = 3;
   const unsigned long styleColumns = 2;
   const unsigned long pointSizeColumns = 1;
   const unsigned long previewRows = 3;
   const unsigned long previewColumns = 8;
   const IPoint  selectionLabelPos(2,2);
   const IPoint  selectionPos(selectionLabelPos.x(),
                              selectionLabelPos.y() + 1);
   const IPoint  styleLabelPos(selectionLabelPos.x() + selectionColumns + 1,
                               selectionLabelPos.y());
   const IPoint  stylePos( styleLabelPos.x(),
                           styleLabelPos.y()  + 1 );
   const IPoint  pointSizeLabelPos(styleLabelPos.x() + styleColumns + 1,
                                   styleLabelPos.y());
   const IPoint  pointSizePos( pointSizeLabelPos.x(),
                               pointSizeLabelPos.y()  + 1 );
   const IPoint  previewPos( selectionPos.x(),
                             selectionPos.y() + 2 );

   IMODTRACE_ALL("IFontDialogData::IFontDialogData");

   settings.fl = 0;
   if (style & IFontDialog::helpButton)
      settings.fl |= FNTS_HELPBUTTON;
   if (style & IFontDialog::applyButton)
      settings.fl |= FNTS_APPLYBUTTON;
   if (style & IFontDialog::resetButton)
      settings.fl |= FNTS_RESETBUTTON;
   if (style & IFontDialog::modeless)
      settings.fl |= FNTS_MODELESS;
   if (style & IFontDialog::proportionalOnly)
      settings.fl |= FNTS_PROPORTIONALONLY;
   if (style & IFontDialog::bitmapOnly)
      settings.fl |= FNTS_BITMAPONLY;
   if (style & IFontDialog::vectorOnly)
      settings.fl |= FNTS_VECTORONLY;
   if (style & IFontDialog::fixedWidthOnly)
      settings.fl |= FNTS_FIXEDWIDTHONLY;
   if (style & IFontDialog::noSynthesize)
      settings.fl |= FNTS_NOSYNTHESIZEDFONTS;

   frame->setClient( &cv );

   // set text for preview area
   preview.setText( settings.previewText );

   // set text for labels
   selectionLabel.setText( loadButtonLabel(IC_LABEL_FONTDLG_SEL,
                                           "Description") );
   pointSelectionLabel.setText( loadButtonLabel(IC_LABEL_FONTDLG_POINTSEL,
                                                "Point Size") );
   styleLabel.setText( loadButtonLabel(IC_LABEL_FONTDLG_STYLESEL,
                                                "Font Style") );

   // Set limits and minimum rows on the combo boxes so they will
   // calculate their minimum sizes correctly.
   selectionBox.setLimit(35);
   selectionBox.setMinimumRows(16);
   styleBox.setLimit (12);
   styleBox.setMinimumRows (16);
   pointSizeSel.setLimit (4);
   pointSizeSel.setMinimumRows (16);

   // Get the minimum sizes of the three combo boxes.
   ISize selectionBoxSize = selectionBox.minimumSize();
   ISize pointSizeSelSize = pointSizeSel.minimumSize();
   ISize styleBoxSize = styleBox.minimumSize();

   // position the elements of the client area
   // Set top, left, and bottom margins.
   cv.setRowHeight(selectionLabelPos.y() - 1, marginPixels);
   cv.setColumnWidth(selectionLabelPos.x() - 1, marginPixels);
   cv.setRowHeight(previewPos.y() + previewRows, marginPixels);

   // add selection label and box
   cv.addToCell( &selectionLabel, selectionLabelPos.x(), selectionLabelPos.y(),
                 selectionColumns);
   cv.addToCell( &selectionBox, selectionPos.x(), selectionPos.y(),
                 selectionColumns);
   // add styleLabel and styleBox
   cv.addToCell( &styleLabel, styleLabelPos.x(), styleLabelPos.y());
   cv.addToCell( &styleBox, stylePos.x(), stylePos.y(), styleColumns);
   // add pointSizeLabel and pointSizeSel
   cv.addToCell( &pointSelectionLabel, pointSizeLabelPos.x(), pointSizeLabelPos.y());
   cv.addToCell( &pointSizeSel, pointSizePos.x(), pointSizePos.y(),pointSizeColumns);
   // Make row that holds all the combo boxes expandable.
//   cv.setRowHeight(selectionPos.y(), selectionBoxSize.height(), true);
   // add preview box
   cv.addToCell( &preview, previewPos.x(), previewPos.y(), previewColumns, previewRows);

   // Make all the combo box initial columns expandable.
   cv.setColumnWidth(pointSizePos.x(),
                     pointSizeSelSize.width() ,
                     true);
   cv.setColumnWidth(stylePos.x(),
                     styleBoxSize.width() ,
                     true);
   cv.setColumnWidth(selectionPos.x(),
                     selectionBoxSize.width(),
                     true);
   // Set the right margin.
   cv.setColumnWidth(pointSizePos.x() + pointSizeColumns, marginPixels);
   // Calculate a row height for the preview area based on the height
   // of the combo boxes.
   unsigned long rowSize =
      (selectionBoxSize.height() / 2) / previewRows;
   // Make the row containing the preview box expandable.
   cv.setRowHeight(previewPos.y() + 1,
                   rowSize,
                   true);

   // Construct the buttons.  Must be in order of appearance
   okButton = new IPushButton(DID_OK_BUTTON, &buttoncv, &cv );
   okButton->setText( loadButtonLabel(IC_LABEL_OK, "OK") );
   okButton->enableDefault();
   if (style & IFontDialog::applyButton)
      {
      applyButton = new IPushButton( DID_APPLY_BUTTON, &buttoncv, &cv );
      applyButton->setText(  loadButtonLabel(IC_LABEL_APPLY, "Apply") );
      }
   if (style & IFontDialog::resetButton)
      {
      resetButton = new IPushButton( DID_RESET_BUTTON, &buttoncv, &cv );
      resetButton->setText(  loadButtonLabel(IC_LABEL_RESET, "Reset") );
      if ( applyFont() )
         resetFontData = new IFontPrivateData( *(applyFont()->ppd) );
      }
   cancelButton = new IPushButton(DID_CANCEL_BUTTON, &buttoncv, &cv ),
   cancelButton->setText(  loadButtonLabel(IC_LABEL_CANCEL, "Cancel") );
   if (style & IFontDialog::helpButton)
      {
      helpButton = new IPushButton( DID_HELP_BUTTON, &buttoncv, &cv,
                                    IRectangle(),
                                    IPushButton::defaultStyle() |
                                    IPushButton::help);
      helpButton->setText( loadButtonLabel(IC_LABEL_HELP, "Help") );
      }

   // Add button canvas to the frame as an extension.  Set size based
   // on area needed by button
   ISize buttonSize = okButton->characterSize();
   frame->addExtension( &buttoncv,
                        IFrameWindow::belowClient,
                        (int)buttonSize.height() * 2 + marginPixels,
                        IFrameWindow::none);


   // Handle positioning of the dialog.  Client area is main canvas
   // minimum size plus the button canvas extension minimum size.
   ISize dlgSize = cv.minimumSize();
   IRectangle dlgRect = IRectangle( settings.position, dlgSize );
   // If there was no position specified in the settings, center on
   // the frame.
   if (settings.position == IPoint(0,0) )
      {
      IRectangle ownerRect;
      IWindow * owner = frame->owner();
      if (owner)
         ownerRect = owner->rect();
      if ( ownerRect != IRectangle() )
         {
         IPoint centerPt = ownerRect.center();
         IRectangle wholeRect = frame->frameRectFor(dlgRect);
         // Center the dialog on the owner.
         wholeRect.centerAt( centerPt );
         // Ensure that the result will be on screen.
         IRectangle desktopRect( IWindow::desktopWindow()->rect() );
         if ( !desktopRect.contains( wholeRect ) )
            {
            IPair adjustment(0,0);
            // Move on screen in X direction.
            if (desktopRect.minX() > wholeRect.minX() )
               adjustment.setCoord1( desktopRect.minX() - wholeRect.minX() );
            else if (desktopRect.maxX() < wholeRect.maxX() )
               adjustment.setCoord1( desktopRect.maxX() - wholeRect.maxX() );
            // Move on screen in Y direction.
            if (desktopRect.minY() > wholeRect.minY() )
               adjustment.setCoord2( desktopRect.minY() - wholeRect.minY() );
            else if (desktopRect.maxY() < wholeRect.maxY() )
               adjustment.setCoord2( desktopRect.maxY() - wholeRect.maxY() );

            wholeRect.moveBy(adjustment);
            }
         // Move the client area to the computed origin.
         if ( ICoordinateSystem::applicationOrientation() ==
              ICoordinateSystem::kOriginLowerLeft )
            dlgRect.moveTo( wholeRect.minXMaxY() -
                            IPair(0, dlgRect.maxY() - dlgRect.minY()) );
         else
            dlgRect.moveTo( wholeRect.minXMinY() );
         }
      }

   frame->moveSizeToClient( dlgRect );

   // Add all handlers.  We use the same selection handler for all three
   // combo boxes.
   cmdhdr.handleEventsFor( &cv );
   selhdr.handleEventsFor( &selectionBox );
   edithdr.handleEventsFor( &pointSizeSel );
   selhdr.handleEventsFor( &pointSizeSel );
   selhdr.handleEventsFor( &styleBox );
}

/*------------------------------------------------------------------------------
| IFontDialogData::~IFontDialogData                                            |
------------------------------------------------------------------------------*/
IFontDialogData::~IFontDialogData()
{
   IMODTRACE_ALL("IFontDialogData::~IFontDialogData");
   delete resetFontData;         // saved reset info
   delete okButton;              // ok button
   delete cancelButton;          // cancel button
   delete applyButton;           // reset button
   delete resetButton;           // reset button
   delete helpButton;            // help button
   // Free the fonts loaded from the system.
   if (nameList) XFreeFontNames( nameList );
   // Free the IXLFDStrings that were newed and placed into the collection.
   IFontSetDLG::Cursor myCursor( *fontSet );
   for (myCursor.setToFirst(); myCursor.isValid(); myCursor.setToNext())
   {
      IXLFDString* xlfd = fontSet->elementAt(myCursor);
      delete xlfd;
   }
   // Delete the collection itself.
   delete fontSet;
}

/*------------------------------------------------------------------------------
| IFontDialogData::apply                                                       |
------------------------------------------------------------------------------*/
IFontDialogData& IFontDialogData::apply()
{
   IMODTRACE_ALL("IFontDialogData::apply");
   IFont *applyToFont = applyFont();
   if ( applyToFont )
      {
      applyToFont->setFontFromDialog( &(fontData()) );
      }
   return *this;
}

/*------------------------------------------------------------------------------
| IFontDialogData::refresh                                              |
------------------------------------------------------------------------------*/
IFontDialogData &IFontDialogData::refresh()
{
   IMODTRACE_ALL("IFontDialogData::refresh");
   // get a list of fonts matching the criteria and
   // add to the selection box.

   // get current XLFD list.
   char** fontList = nameList;
      // load the font list from X
    if( fontSet->numberOfElements() == 0 )
      fontNameList();

    if( fontSet->numberOfElements() > 0 )
    {
      // Cursor through each unique key and add to the font description combo
      // box.  The key is the string shown in the box.
      // It is much faster to sort on insertion than to keep a sorted collection
      // because the list in the combo box is much smaller than the original
      // list.

      IFontSetDLG::Cursor myCursor( *fontSet );
      for (myCursor.setToFirst(); myCursor.isValid(); fontSet->setToNextWithDifferentKey(myCursor))
      {
         selectionBox.addAscending((fontSet->elementAt(myCursor))->keyNameLong());
      }

      // If there was an initializing font specified, look for it in the
      // collection and select it.
      if (applyFont())
      {
         IXLFDString activeFont(IString(fontData().xFontName()).lowerCase());
         // Set these "need" flags and the point size of the requested font
         // so we know what to select in the style and point size combo boxes.
         if (activeFont.isBold() && !activeFont.isItalic())
            needBold = true;
         else if (activeFont.isBold() && activeFont.isItalic())
            needBoldItalic = true;
         else if (activeFont.isItalic())
            needItalic = true;
         firstPointSize = activeFont.pointSize();
         if ((selectedResetItem = selectionBox.locateText(activeFont.keyNameLong())) != IBaseComboBox::notFound)
            selectionBox.select( (unsigned long) selectedResetItem );
      }
      // Otherwise, select the first item.
      else
      {
         selectedResetItem = 0;
         selectionBox.select( selectedResetItem );
      }
   }
   return *this;
}

/*------------------------------------------------------------------------------
| IFontDialogData::reset                                                |
------------------------------------------------------------------------------*/
IFontDialogData &IFontDialogData::reset()
{
   IMODTRACE_ALL("IFontDialogData::reset");
   // If there is reset font information, use it to repopulate the selection
   // boxes.
   resetRequested = true;
   if (selectedResetItem != IBaseComboBox::notFound)
      selectionBox.select( (unsigned long) selectedResetItem );
   IFont *applyToFont = applyFont();
   if ( ( applyToFont ) && (resetFontData) )
   {
      // reset the IFont object
      applyToFont->setFontFromDialog( resetFontData );

      // reset the font data we have stored to the saved copy
      settings.fontData = *resetFontData;
   }
   resetRequested = false;
   return *this;
}

/*------------------------------------------------------------------------------
|  IFontDialogData::fontNameList                                        |
------------------------------------------------------------------------------*/
char **IFontDialogData::fontNameList()
{
   IMODTRACE_ALL("IFontDialogData::fontNameList");
     if (nameList) XFreeFontNames( nameList);
     // construct a search string based on the style flags
     IXLFDString xlfdFontSrch;

     // Family (2) set the font family we are looking for
      if ( settings.familyName.length() != 0)
        xlfdFontSrch.setWord(settings.familyName,IXLFDString::NAME);
     else
        xlfdFontSrch.setWord("*",IXLFDString::NAME);

    //add entries which are locale friendly
    IXLFDString* newFont;

    if( fontSet->numberOfElements() == 0 )
    {
      IFontList* validFontList = IXLFDString::getFontListForCurrentLocale(fontData().display());
      IFontList::Cursor myCursor( *validFontList );
      myCursor.setToFirst();
      IString theKey = xlfdFontSrch.keyName();
      if( xlfdFontSrch.familyName() == "*")
      {
        myCursor.setToNext();
      }
      else
      {
        if( !validFontList->locateElementWithKey(theKey,myCursor))
          return nameList;
      }

      while( myCursor.isValid() )
      {
        newFont = new IXLFDString(validFontList->elementAt(myCursor));
        if( xlfdFontSrch.familyName() == "*")
          myCursor.setToNext();
        else
          validFontList->locateNextElementWithKey(theKey,myCursor);

        // Don't add it to the list if there is no family name.  (Usability)
        if ( (newFont->familyName().length() != 0)
            && (newFont->familyName() != "*") )
        {

          if ( settings.fl & FNTS_VECTORONLY )
          {
            if(newFont->isVector())
            {
              if ( settings.fl & FNTS_PROPORTIONALONLY )
              {
                if( !newFont->isFixed() )
                  fontSet->add(newFont);
              }
              else if ( settings.fl & FNTS_FIXEDWIDTHONLY )
              {
                if( newFont->isFixed() )
                  fontSet->add(newFont);
              }
              else if ( settings.fl & FNTS_BITMAPONLY )
              {
                if( newFont->isFixed() )
                  fontSet->add(newFont);
              }
              else
                fontSet->add(newFont);
            }
          }

          else if ( settings.fl & FNTS_BITMAPONLY )
          {
            if(!newFont->isVector())
            {
              if ( settings.fl & FNTS_PROPORTIONALONLY )
              {
                if( !newFont->isFixed() )
                  fontSet->add(newFont);
              }
              else if ( settings.fl & FNTS_FIXEDWIDTHONLY )
              {
                if( newFont->isFixed() )
                  fontSet->add(newFont);
              }
              else
              {
                fontSet->add(newFont);
              }
            }
          }

          else
          {
            if ( settings.fl & FNTS_PROPORTIONALONLY )
            {
              if( !newFont->isFixed() )
                fontSet->add(newFont);
            }
            else if ( settings.fl & FNTS_FIXEDWIDTHONLY )
            {
              if( newFont->isFixed() )
                fontSet->add(newFont);
            }
            else if ( settings.fl & FNTS_BITMAPONLY )
            {
              if( newFont->isFixed() )
                fontSet->add(newFont);
            }
            else
              fontSet->add(newFont);
          }
        }
      }
    }

  return nameList;
}



/*------------------------------------------------------------------------------
| IFontDialogData::setSelectedItem                                             |
------------------------------------------------------------------------------*/
IFontDialogData& IFontDialogData::setSelectedItem()
{
   IMODTRACE_ALL("IFontDialogData::setSelectedItem");
   // A selection has been made in selection box.  Respond to it.
   int selectedItem = selectionBox.selection();
   if (selectedItem != IBaseComboBox::notFound)
   {
      // If this is the first time through, the selection was made by us
      // programatically.  Look for the initializing font and select the
      // appropriate style in the style combo box.
      if (firstTime)
      {
         IFontSetDLG::Cursor myCursor( *fontSet );
         // The collection key is always the text in the combo box.
         IString theKey = selectionBox.itemText(selectedItem);
         // Flags to avoid duplicates in the style combo box.
         bool boldAdded = false, boldItalicAdded = false, italicAdded = false, regularAdded = false;
         // Go through the collection looking for keys that match the selection
         // in the font name combo box.  When one is found, add its "weight" to
         // the style combo box.  Don't duplicate.
         for (fontSet->locateElementWithKey(theKey,myCursor)
              ; myCursor.isValid()
              ; fontSet->locateNextElementWithKey(theKey,myCursor))
         {
            IXLFDString* tempXlfd = fontSet->elementAt(myCursor);
            if (tempXlfd->isBold() && !tempXlfd->isItalic() && !boldAdded)
            {
               styleBox.addAscending(loadButtonLabel(IC_LABEL_FONTDLG_BOLD, "Bold"));
               boldAdded = true;
            }
            else if (tempXlfd->isBold() && tempXlfd->isItalic() && !boldItalicAdded)
            {
               styleBox.addAscending(loadButtonLabel(IC_LABEL_FONTDLG_BOLDITALIC, "Bold Italic"));
               boldItalicAdded = true;
            }
            else if (tempXlfd->isItalic() && !italicAdded)
            {
               styleBox.addAscending(loadButtonLabel(IC_LABEL_FONTDLG_ITALIC, "Italic"));
               italicAdded = true;
            }
            else if (!regularAdded)
            {
               styleBox.addAscending(loadButtonLabel(IC_LABEL_FONTDLG_REGULAR, "Regular"));
               regularAdded = true;
            }
         }
         // Select the weight of the initializing font in the style combo box.
         // Note that this causes a call to ISelectHandler::select to occur, and
         // we will enter our styleSelected routine.
         if (needBold)
            styleBox.select(styleBox.locateText(loadButtonLabel(IC_LABEL_FONTDLG_BOLD, "Bold")));
         else if (needBoldItalic)
            styleBox.select(styleBox.locateText(loadButtonLabel(IC_LABEL_FONTDLG_BOLDITALIC, "Bold Italic")));
         else if (needItalic)
            styleBox.select(styleBox.locateText(loadButtonLabel(IC_LABEL_FONTDLG_ITALIC, "Italic")));
         else if (applyFont())
            styleBox.select(styleBox.locateText(loadButtonLabel(IC_LABEL_FONTDLG_REGULAR, "Regular")));
         else
            styleBox.select((unsigned long) 0);
      }
      // If this is the not the first time through, the selection was made by
      // the user.  Get the selected font and initialize the style combo box
      // with all the alternatives.
      else
      {
         // Empty the dependent combo boxes.
         pointSizeSel.removeAll();
         styleBox.removeAll();
         IFontSetDLG::Cursor myCursor( *fontSet );
         IString theKey = selectionBox.itemText(selectedItem);
         // Flags to avoid duplicates in the style combo box.
         bool boldAdded = false, boldItalicAdded = false, italicAdded = false, regularAdded = false;
         // Go through the collection looking for keys that match the selection
         // in the font name combo box.  When one is found, add its "weight" to
         // the style combo box.  Don't duplicate.
         for (fontSet->locateElementWithKey(theKey,myCursor)
              ; myCursor.isValid()
              ; fontSet->locateNextElementWithKey(theKey,myCursor))
         {
            IXLFDString* tempXlfd = fontSet->elementAt(myCursor);
            if (tempXlfd->isBold() && !tempXlfd->isItalic() && !boldAdded)
            {
               styleBox.addAscending(loadButtonLabel(IC_LABEL_FONTDLG_BOLD, "Bold"));
               boldAdded = true;
            }
            else if (tempXlfd->isBold() && tempXlfd->isItalic() && !boldItalicAdded)
            {
               styleBox.addAscending(loadButtonLabel(IC_LABEL_FONTDLG_BOLDITALIC, "Bold Italic"));
               boldItalicAdded = true;
            }
            else if (tempXlfd->isItalic() && !italicAdded)
            {
               styleBox.addAscending(loadButtonLabel(IC_LABEL_FONTDLG_ITALIC, "Italic"));
               italicAdded = true;
            }
            else if (!regularAdded)
            {
               styleBox.addAscending(loadButtonLabel(IC_LABEL_FONTDLG_REGULAR, "Regular"));
               regularAdded = true;
            }
         }
         // Select the first in the style combo box.
         // Note that this causes a call to ISelectHandler::select to occur, and
         // we will enter our styleSelected routine.
         if (resetRequested)
            styleBox.select(selectedStyleResetItem);
         else
            styleBox.select(0);
      }
   }
   return *this;
}

/*------------------------------------------------------------------------------
| IFontDialogData::sizeSelected                                                |
------------------------------------------------------------------------------*/
IFontDialogData& IFontDialogData::sizeSelected()
{
   // A selection has been made in size box.  Respond to it.
   int selectedItem = selectionBox.selection();
   int styleItem = styleBox.selection();
   int sizeItem = pointSizeSel.selection();
   if ((selectedItem != IBaseComboBox::notFound) &&
       (styleItem != IBaseComboBox::notFound))
   {
      if (firstTime)
      {
         firstTime = false;
         selectedSizeResetItem = sizeItem;
      }
      IFontSetDLG::Cursor myCursor( *fontSet );
      // The text selected in the font description combo box is the key.
      IString theKey = selectionBox.itemText(selectedItem);
      // Get the style type and point size that were selected.
      IString styleType = styleBox.itemText(styleItem);
      IString size  = pointSizeSel.text();

      if( size == "" )
      {
        pointSizeSel.setText("10");
        size = pointSizeSel.text();
      }

      firstPointSize = size.asInt();
      // Pointer to the XLFD string that we will try to load from the
      // system.
      IXLFDString* xlfd = (IXLFDString*) 0;
      // Go through the collection looking for keys that match the selection
      // in the font name combo box.  When one is found, check to see if
      // its weight matches the selection in the style combo box and point size
      // matches the selection in the point size combo box.  If it does,
      // set the xlfd pointer to that element in the collection and use it
      // to load the font from the system below.
      for (fontSet->locateElementWithKey(theKey,myCursor);
           myCursor.isValid() && (xlfd == (IXLFDString*) 0);
           fontSet->locateNextElementWithKey(theKey,myCursor))
      {
         IXLFDString* tempXlfd = fontSet->elementAt(myCursor);
        if( ( settings.fl & FNTS_VECTORONLY ) )
          tempXlfd->setPointSize( size.asInt() );

        if( tempXlfd->isVector() )
          tempXlfd->setPointSize( size.asInt() );

        int ptSize = tempXlfd->pointSize();

        // Check for a match on the point size.
         if (ptSize == size.asInt())
         {
            // Check for a match on the style type.
            if (tempXlfd->isBold()
            && !tempXlfd->isItalic()
            && styleType == loadButtonLabel(IC_LABEL_FONTDLG_BOLD, "Bold"))
               xlfd = tempXlfd;

            else if (tempXlfd->isBold() && tempXlfd->isItalic() &&
                     styleType == loadButtonLabel(IC_LABEL_FONTDLG_BOLDITALIC, "Bold Italic"))
               xlfd = tempXlfd;

            else if (tempXlfd->isItalic() && styleType == loadButtonLabel(IC_LABEL_FONTDLG_ITALIC, "Italic"))
               xlfd = tempXlfd;

            else if (!tempXlfd->isBold() && !tempXlfd->isItalic() &&
                      styleType == loadButtonLabel(IC_LABEL_FONTDLG_REGULAR, "Regular"))
               xlfd = tempXlfd;
         }


      }
      if (xlfd)
      {
         // Create an IFont and set it in the preview area.
         try
         {
            fontData().loadXLFD( *xlfd );
            // set the font in the sample area
            IFont previewFont( &preview );
            previewFont.setFontFromDialog( &(fontData()) );
            preview.setFont( previewFont );
         }
         catch ( IAccessError& )
         {
            // trouble loading font ... XServer does not know it
            // The exception that we want to catch is generated
            // by IFontPrivateData when it cant get font from XServer
            // Currently this is a ITHROWLIBRARYERROR
            ITRACE_ALL( "font load exception" );
            IFont previewFont;
            previewFont.setFontFromDialog( &(fontData()) );
            preview.setFont( previewFont );
         }
      }
      else
      {
         // No match for some reason.  Load a default font.
         IFont previewFont;
         previewFont.setFontFromDialog( &(fontData()) );
         preview.setFont( previewFont );
      }
   }
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialogData::styleSelected                                               |
------------------------------------------------------------------------------*/
IFontDialogData& IFontDialogData::styleSelected()
{
   // A selection has been made in style box.  Respond to it.
   int selectedItem = selectionBox.selection();
   int styleItem = styleBox.selection();
   if ((selectedItem != IBaseComboBox::notFound) &&
       (styleItem != IBaseComboBox::notFound))
   {
      if (firstTime)
         selectedStyleResetItem = styleItem;
      IFontSetDLG::Cursor myCursor( *fontSet );
      // Create a collection to hold the point sizes.  We do this to
      // avoid point size duplicates.
      IPointSizeSet ptSet;
      // The collection key is always the text in the combo box.
      IString theKey = selectionBox.itemText(selectedItem);
      // Get the selected style type.
      IString styleType = styleBox.itemText(styleItem);
      // Go through the collection looking for items that match the selection
      // in the font description combo box.  When one is found that matches
      // the weight selection in the style combo box, add its point size
      // the point size set.  Using an ISet for the collection of point sizes
      // helps us avoid duplicates.

    if( settings.fl & FNTS_VECTORONLY )
    {
        ptSet.add(8);
        ptSet.add(10);
        ptSet.add(12);
        ptSet.add(14);
        ptSet.add(24);
    }
    else
    {
      for (fontSet->locateElementWithKey(theKey,myCursor)
          ; myCursor.isValid()
          ; fontSet->locateNextElementWithKey(theKey,myCursor))
      {
         IXLFDString* tempXlfd = fontSet->elementAt(myCursor);
         // Get the font's point size.
         int ptSize = tempXlfd->pointSize();
         // Don't add it to the point size set if it's zero.
         if (ptSize)
         {
            if (tempXlfd->isBold() && !tempXlfd->isItalic() &&
                styleType == loadButtonLabel(IC_LABEL_FONTDLG_BOLD, "Bold"))
               ptSet.add(ptSize);
            else if (tempXlfd->isBold() && tempXlfd->isItalic() &&
                     styleType == loadButtonLabel(IC_LABEL_FONTDLG_BOLDITALIC, "Bold Italic"))
               ptSet.add(ptSize);
            else if (tempXlfd->isItalic() && styleType == loadButtonLabel(IC_LABEL_FONTDLG_ITALIC, "Italic"))
               ptSet.add(ptSize);
            else if (!tempXlfd->isBold() && !tempXlfd->isItalic() &&
                     styleType == loadButtonLabel(IC_LABEL_FONTDLG_REGULAR, "Regular"))
               ptSet.add(ptSize);
         }
      }
    }

//ekim
      if( ptSet.numberOfElements() == 0 )
      {
        fontSet->locateElementWithKey(theKey,myCursor);
        IXLFDString* tempXlfd = fontSet->elementAt(myCursor);
        if( tempXlfd->isVector() )
        {
          ptSet.add(8);
          ptSet.add(10);
          ptSet.add(12);
          ptSet.add(14);
          ptSet.add(24);
        }
      }
//ekim
      // Make sure the point size combo box is empty.
      pointSizeSel.removeAll();

      // The point size set is ordered numerically.  Add to the combo box in
      // order so that list is sorted ascending.
      IPointSizeSet::Cursor myPtCursor( ptSet );
      for (myPtCursor.setToFirst(); myPtCursor.isValid(); myPtCursor.setToNext())
         pointSizeSel.addAsLast(IString(ptSet.elementAt(myPtCursor)));

      // Select the point size specified in the intializing font or in the
      // previously selected font, if it exists.
      // Note that this will generate a call to ISelectHandler::select, causing
      // our sizeSelected function to be called.
      if (resetRequested)
         pointSizeSel.select(selectedSizeResetItem);
      else if ((firstPointSize != 0) && ptSet.contains(firstPointSize))
         pointSizeSel.select(pointSizeSel.locateText(IString(firstPointSize)));
      else if (pointSizeSel.count())
         pointSizeSel.select(0);
   }
   return *this;
}

//
// Implementation for nested Settings
/*------------------------------------------------------------------------------
| IFontDialog::Settings :: Settings                                            |
------------------------------------------------------------------------------*/
IFontDialog::Settings :: Settings (IFont* font)
{
   fSettingsData = new IFontDialogSettingsData(font);
   if (font)
      fSettingsData->fl = fSettingsData->fl | FNTS_INITFROMFATTRS;
   else
      fSettingsData->fontData.setPointSize(5);
}

/*------------------------------------------------------------------------------
| IFontDialog::Settings :: Settings                                            |
------------------------------------------------------------------------------*/
IFontDialog::Settings :: Settings (const IFontDialog::Settings& another) :
   fSettingsData( new IFontDialogSettingsData( *(another.fSettingsData) ) )
{ }

/*------------------------------------------------------------------------------
| IFontDialog::Settings :: operator=                                           |
------------------------------------------------------------------------------*/
IFontDialog::Settings& IFontDialog::Settings::operator=
                           (const IFontDialog::Settings& another)
{
   if (this != &another)
      {
      delete fSettingsData;
      fSettingsData = new IFontDialogSettingsData( *(another.fSettingsData) );
      }
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::~Settings                                             |
------------------------------------------------------------------------------*/
IFontDialog::Settings::~Settings ()
{
   delete fSettingsData;
}

/*------------------------------------------------------------------------------
| IFontDialog::Settings::setFont                                               |
------------------------------------------------------------------------------*/
IFontDialog::Settings& IFontDialog::Settings::setFont( IFont* font )
{
   fSettingsData->setFont(font);
   return *this;
}

/*------------------------------------------------------------------------------
| IFontDialog::Settings::setTitle                                              |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setTitle (const char* pszTitle)
{
   if (pszTitle) {
      fSettingsData->title = pszTitle;
   } else {
      fSettingsData->title = IString();
   } /* endif */
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings& IFontDialog::Settings::setTitle                       |
------------------------------------------------------------------------------*/
IFontDialog::Settings& IFontDialog::Settings::setTitle(const IResourceId& id)
{
    IString newText = id.resourceLibrary().loadString(id);
    if (newText.length())
      setTitle(newText);
    return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setPreviewText                                        |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setPreviewText (const char* pszPreview)
{
   if (pszPreview) {
      fSettingsData->previewText = pszPreview;
   } else {
      fSettingsData->previewText = IString();
   } /* endif */
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setSizeList                                           |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setSizeList (const char* pszSizeList)
{
   if (pszSizeList) {
      fSettingsData->ptSizeList = pszSizeList;
   } else {
      fSettingsData->ptSizeList = IString();
   } /* endif */
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setDialogTemplate                                     |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setDialogTemplate(const IResourceId& resId)
{
   ITRACE_MOTIF_NOP();
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings ::setPosition                                          |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings ::setPosition (const IPoint& position)
{
   fSettingsData->position = position;
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setDisplayPS                                          |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setDisplayPS (const IPresSpaceHandle& hpsDisplay)
{
   ITRACE_MOTIF_NOP();

   fSettingsData->hpsScreen = hpsDisplay;
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setPrinterPS                                          |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setPrinterPS (const IPresSpaceHandle& hpsPrnter)
{
   ITRACE_MOTIF_NOP();

   fSettingsData->hpsPrinter = hpsPrnter;
   return *this;
}


/*------------------------------------------------------------------------------
| IFontDialog::Settings::setFamily                                             |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setFamily (const char* pszFontFamily)
{
   fSettingsData->familyName = IString( pszFontFamily );
   return *this;
}

/*------------------------------------------------------------------------------
| IFontDialog::Settings::setPointSize                                          |
------------------------------------------------------------------------------*/
IFontDialog::Settings&
  IFontDialog::Settings::setPointSize (unsigned long usPointSize)
{
   fSettingsData->fontData.setPointSize( usPointSize );
   return *this;
}


//
// Implementation for IFontDialog
//


/*------------------------------------------------------------------------------
| IFontDialog::~IFontDialog                                                    |
------------------------------------------------------------------------------*/
IFontDialog::~IFontDialog  ()
{
   delete fFontDialogData;
}

/*------------------------------------------------------------------------------
| IFontDialog::fontFamily                                                      |
------------------------------------------------------------------------------*/
IString IFontDialog::fontFamily () const
{
   return fFontDialogData->fontData().faceName();
}

/*------------------------------------------------------------------------------
| IFontDialog::emHeight                                                        |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::emHeight () const
{
   return fFontDialogData->fontData().capHeight();
}


/*------------------------------------------------------------------------------
| IFontDialog::xHeight                                                         |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::xHeight () const
{
   return fFontDialogData->fontData().xHeight();
}


/*------------------------------------------------------------------------------
| IFontDialog::externalLeading                                                 |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::externalLeading () const
{
   // No value available. Since all fonts built into PM are designed with
   // external leading of zero, this seems safe to return here.
   return 0;
}


/*------------------------------------------------------------------------------
| IFontDialog::pointSize                                                       |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::pointSize () const
{
   return fFontDialogData->fontData().pointSize() ;
}


/*------------------------------------------------------------------------------
| IFontDialog::nominalPointSize                                                |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::nominalPointSize () const
{

//  return fFontDialogData->fontdlg.sNominalPointSize;
//   Not really the same?
   return fFontDialogData->fontData().pointSize();
}


/*------------------------------------------------------------------------------
| IFontDialog::fontWeight                                                      |
| UNX_NOP                                                                      |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::fontWeight () const
{
   ITRACE_MOTIF_NOP();

//   return fFontDialogData->fontdlg.usWeight;

   return 0;
}


/*------------------------------------------------------------------------------
| IFontDialog::fontWidth                                                       |
| UNX_NOP                                                                      |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::fontWidth () const
{
   ITRACE_MOTIF_NOP();

//   return fFontDialogData->fontdlg.usWidth;

   return 0;
}


/*------------------------------------------------------------------------------
| IFontDialog::buttonPressedId                                                 |
------------------------------------------------------------------------------*/
unsigned long IFontDialog::buttonPressedId () const
{
   return fFontDialogData->returnVal;
}


/*------------------------------------------------------------------------------
| IFontDialog::isModeless                                                      |
------------------------------------------------------------------------------*/
bool IFontDialog::isModeless () const
{
   return (fFontDialogData->fstyle & IFontDialog::modeless);

}


/*------------------------------------------------------------------------------
| IFontDialog::pressedOK                                                       |
------------------------------------------------------------------------------*/
bool IFontDialog::pressedOK () const
{
   return buttonPressedId() == DID_OK;

}


/*------------------------------------------------------------------------------
| IFontDialog::returnValue                                                     |
| Returns the system return code from the font                                 |
| dialog.  FNTS_SUCCESSFUL means no error occured.                             |
| A positive return indicates an error.  The codes                             |
| are listed in the fcldlgp.h file.                                            |
------------------------------------------------------------------------------*/
long IFontDialog::returnValue () const
{
   // always return 0
   return 0;
}


/*------------------------------------------------------------------------------
| IFontDialog::Style  IFontDialog::defaultStyle                                |
------------------------------------------------------------------------------*/
IFontDialog::Style  IFontDialog::defaultStyle()
{
  return currentDefaultStyle;
}


/*------------------------------------------------------------------------------
| unsigned long &IFontDialog::id                                               |
------------------------------------------------------------------------------*/
unsigned long  IFontDialog::id() const
{
  return Inherited::id();
}


/*------------------------------------------------------------------------------
| IFontDialog &IFontDialog::setId                                             |
------------------------------------------------------------------------------*/
IFontDialog&  IFontDialog::setId( unsigned long uiId)
{
  Inherited::setId( uiId );
  return *this;
}

/*------------------------------------------------------------------------------
| IFontDialog::initialize                                                      |
------------------------------------------------------------------------------*/
void IFontDialog::initialize (IWindow*        parent,
                              IWindow*        owner,
                              const Style&    style,
                              IHandler*       handler,
                              const Settings& settings)
{
   // Initialize the frame window
   Inherited::initialize( IResourceId(DID_FONT_DIALOG),
                          IFrameWindow::defaultStyle(),
                          parent, owner,
                          IRectangle(),
                          settings.fSettingsData->title.length() ?
                          (char*)settings.fSettingsData->title : (char*)0 );

   // Set up the private data object
   fFontDialogData = new IFontDialogData( this, style, *(settings.fSettingsData) );

   // if there is a handler, install it now
   if (handler)
      handler->handleEventsFor( this );


   // Show the dialog while the long process of loading fonts from X
   // happens.
   XtRealizeWidget( this->handle() );

   fFontDialogData->cv.postEvent( IWindow::command,
                        IEventData( FONTDLG_REFRESH_COMMAND ),
                        IEventData( ICommandEvent::unknown, 0) );

   // We do it this way so that we get something up on the
   // screen while the slow refresh occurs.
   if ( !this->isModeless() )
      showModally();
   else
      show();
}

/*------------------------------------------------------------------------------
| bool IFontDlgCommandHandler::command                               |
------------------------------------------------------------------------------*/
bool IFontDlgCommandHandler::command   ( ICommandEvent       &event  )
{
   unsigned long buttonId = event.commandId();

   // Most events passed on to other handlers
   bool       result   = false;

   // store the button pressed in the dialog data area for retrieval later
   // via interface
   dlgData->returnVal = buttonId;

   switch ( event.commandId() )
      {
      // help button handled by using help style.
      case  DID_APPLY_BUTTON   :
         dlgData->sizeSelected();
         dlgData->apply();
         // Send message to self for the font dialog handler to see.
         dlgData->frame->handle().sendEvent(
                                      IC_UM_DLG_APPLY_PRESSED,
                                      IEventParameter1( dlgData->applyFont() ),
                                      IEventParameter2( 0 ) );
         result = true;
         break;
      case  DID_RESET_BUTTON   :
         dlgData->reset();
         result = true;
         break;
      case  DID_OK_BUTTON      :
         dlgData->sizeSelected();
         dlgData->apply();
         if ( dlgData->frame->isModal() )
            {
            dlgData->frame->dismiss(buttonId);
            }
         else
            {
            dlgData->frame->close();
            }
         result = true;
         break;
      case  DID_CANCEL_BUTTON  :
         dlgData->frame->close();
         result = true;
         break;
      case  FONTDLG_REFRESH_COMMAND  :
         dlgData->refresh();
         result = true;          // dont pass this one on
         break;
      }     // switch

   return result;
}

/*------------------------------------------------------------------------------
| bool IFontDlgSelectHandler::selected                                         |
| Handle a selection in any of the three combo boxes.                          |
------------------------------------------------------------------------------*/
bool IFontDlgSelectHandler::selected   ( IControlEvent       &event  )
{
   if (event.controlId() == DID_NAME)
      dlgData->setSelectedItem();
   else if (event.controlId() == DID_STYLEBOX)
      dlgData->styleSelected();
   return false;
}

/*------------------------------------------------------------------------------
| bool IFontDlgEditHandler::edit                                         |
| Handle a selection in any of the three combo boxes.                          |
------------------------------------------------------------------------------*/
bool IFontDlgEditHandler::edit   ( IControlEvent       &event  )
{
   if (event.controlId() == DID_SIZE)
{
  dlgData->sizeSelected();
}

   return false;
}

/*------------------------------------------------------------------------------
| bool IFontDlgSelectHandler::enter                                            |
------------------------------------------------------------------------------*/
bool IFontDlgSelectHandler::enter      ( IControlEvent       &event  )
{
   // Send a command event to simulate OK button pressed
   dlgData->cv.postEvent( IWindow::command,
                          IEventData( (unsigned long) DID_OK_BUTTON ),
                          IEventData(ICommandEvent::unknown, 0) );
   return false;
}

/*------------------------------------------------------------------------------
| loadButtonLabel - loads the string for the button label from the             |
| application message file.                                                    |
------------------------------------------------------------------------------*/
IString loadButtonLabel( unsigned long messageId,
                         const char   *defaultText)
{
   IMessageText msgText ( messageId );
   msgText.setDefaultText( defaultText );
   return IString( msgText.text() );
}
#endif // IC_MOTIF
