// Revision: 20 1.19.1.21 source/ui/baseapp/ifiledlg.cpp, views, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: ifiledlg.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ifiledlg.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Priority INT_MIN (-2147483647 - 1) + 1024 + 512
#pragma priority( -2147482112 )

extern "C"
{
  #define INCL_WINSTDFILE
  #define INCL_WINWINDOWMGR
  #define INCL_WINBUTTONS
  #define IUSING_OLE
  #ifdef WIN32_LEAN_AND_MEAN
    #undef WIN32_LEAN_AND_MEAN
  #endif
  // Flag via _WIN32_WINNT that we're enabling support at compile time
  // for features added to the Windows 2000 SDK.
  #define _WIN32_WINNT  0x500
  #include <iwindefs.h>
  #include <string.h>
  #include <stdlib.h>
  #include <stdio.h>
  #ifdef IC_MOTIF
    #include <glob.h>
    #include <dirent.h>
    #include <sys/types.h>
    #include <sys/stat.h>
    #include <Xm/FileSB.h>
    #include <Xm/List.h>
  #endif
  #ifdef IC_WIN
    #include <ShFolder.h>    // For CSIDL_xxx, etc.
  #endif
}

#include <ifiledlg.hpp>
#include <ifildprv.hpp>
#include <icconst.h>
#include <icoordsy.hpp>
#include <idefstyl.h>
#include <ievent.hpp>
#include <iexcept.hpp>
#include <ihandler.hpp>
#include <ihelp.hpp>
#include <imsgtext.hpp>
#include <iobjwin.hpp>
#include <ireslib.hpp>
#include <ithread.hpp>
#include <itrace.hpp>
#ifdef IC_PM
  #include <ipmexsta.hpp>
#endif
#ifdef IC_WIN
  #include <icolor.hpp>
  #include <iplatfrm.hpp>             // defect: 29799, 29824
#endif
#ifdef IC_MOTIF
  #include <ihelpsta.hpp>
  #include <imstring.hpp>
#endif

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IFILEDLG_CPP_
  #include <ipagetun.h>
#endif


const IFileDialog::Style
  IFileDialog::helpButton        ( 1,IFileDialog__helpButton        ),
  IFileDialog::multiSelection    ( 1,IFileDialog__multiSelection    ),
  IFileDialog::filter            ( 1,IFileDialog__filter            ),
  IFileDialog::applyButton       ( 1,IFileDialog__applyButton       ),
  IFileDialog::includeEAS        ( 1,IFileDialog__includeEAS        ),
  IFileDialog::modeless          ( 1,IFileDialog__modeless          ),
  IFileDialog::preload           ( 1,IFileDialog__preload           ),
  IFileDialog::selectableListbox ( 1,IFileDialog__selectableListbox ),
  IFileDialog::noStyle           ( 1,IFileDialog__noStyle           ),
  IFileDialog::classDefaultStyle ( 1,IFileDialog__classDefaultStyle );

const unsigned long
  IFileDialog::ok                = DID_OK,
  IFileDialog::cancel            = DID_CANCEL;

#ifdef IC_MOTIF

#pragma pack(push,4)
typedef struct {
   unsigned char   childId;   // for XmFileSelectionBoxGetChild
   unsigned long   helpId;    // client data for help callback (ID in helptable)
   } FileDialogHelpEntry;

typedef struct _FILEDLG {
  // Empty.  Currently unused.
} FILEDLG;
#pragma pack(pop)

static const FileDialogHelpEntry FileDialogHelpList[] =
   {
   XmDIALOG_APPLY_BUTTON,   DID_APPLY_PB,
   XmDIALOG_CANCEL_BUTTON,  DID_CANCEL_PB,
   XmDIALOG_OK_BUTTON,      DID_OK_PB,
   XmDIALOG_FILTER_TEXT,    DID_FILTER_CB,
   XmDIALOG_HELP_BUTTON,    DID_HELP_PB,
   XmDIALOG_LIST,           DID_FILES_LB,
   XmDIALOG_TEXT,           DID_FILENAME_ED,
   XmDIALOG_DIR_LIST,       DID_DIRECTORY_LB,
   XmDIALOG_NONE,           0
   } ;
#endif

IFileDialog::Style
  IFileDialog::currentDefaultStyle (1, IFileDialog__classDefaultStyle);

#ifdef IC_MOTIF
  // default qualify procedure for FileSelectionBox
  XmQualifyProc  defaultQualifyProc = 0;
  XmSearchProc  defaultSearchProc = 0;
#endif


#ifdef IC_WIN
#define IC_OKBUTTON_SET    0x0001
#define IC_POSITION_SET    0x0004
#define IC_ENABLELISTBOX_SET 0x0008
#define IC_OPEN_SET        0x0010
#define IC_MULTISELECTION_DELIMITER '\0'  // '\0' for explorer, ' ' for old style
#endif

#ifdef IC_MOTIF
static IString loadButtonLabel( unsigned long messageId,
                                const char *defaultText );

void ifiledialogSearchProc( Widget w, XtPointer search_data );
void ifiledialogQualifyProc( Widget w, XtPointer input, XtPointer output );
void ifiledialogHelpCallback(Widget     w,
                             XtPointer  client_data,
                             XtPointer  call_data );

#endif //IC_MOTIF

//
// Implementation for nested Settings class
//

/*------------------------------------------------------------------------------
| IFileDialog::Settings::Settings                                              |
------------------------------------------------------------------------------*/
IFileDialog::Settings::Settings( ) :
  fSettingsData( new IFileDialogSettingsData ),
  titleStr(),
  OKButtonStr(),
  initialDriveStr(),
  initialFileTypeStr(),
  fileNameStr(),
  isOpenDlg(true),
  isPosSet(false)
{
}

/*------------------------------------------------------------------------------
| IFileDialog::Settings& IFileDialog::Settings::setTitle                       |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::setTitle(const IResourceId& id)
{
  IString newText = id.resourceLibrary().loadString(id);
  if (newText.length())
    setTitle(newText);
  return *this;
}


/*------------------------------------------------------------------------------
| IFileDialog::Settings& IFileDialog::Settings::setOKButtonText                |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::setOKButtonText(const IResourceId& id)
{
  IString newText = id.resourceLibrary().loadString(id);
  if (newText.length())
    setOKButtonText(newText);
  return *this;
}

/*------------------------------------------------------------------------------
| IFileDialog::Settings& IFileDialog::Settings::addFileType                    |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::addFileType(const char* fileType,
                                                          const char* filter)

{
   ITRACE_MOTIF_NOP();

   if (fSettingsData->fileTypes == 0)
     fSettingsData->fileTypes = new StringSeq;

   IString* pString;
#ifdef IC_WIN
   if (filter != 0)
   {
      // Separate description from filter with a private string.
      pString = new IString(fileType + IString(" FS ") + filter);
      fSettingsData->isUsingFileFilters = true;
   }
   else
#endif // IC_WIN
      pString = new IString(fileType);
   fSettingsData->fileTypes->add(pString);

   return *this;
}


/*------------------------------------------------------------------------------
| IFileDialog::Settings& IFileDialog::Settings::addDrive                       |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::addDrive(const char* drive)
{
   ITRACE_MOTIF_NOP();
   ITRACE_WIN_NOP();

   IMODTRACE_DEVELOP("IFileDialog::Settings::addDrive");
   if (fSettingsData->drives == 0)
     fSettingsData->drives = new StringSeq;

   IString* pString = new IString(drive);
   fSettingsData->drives->add(pString);

   return *this;
}


/*------------------------------------------------------------------------------
| IFileDialog::Settings::~Settings                                             |
------------------------------------------------------------------------------*/
IFileDialog::Settings::~Settings()
{
  IMODTRACE_DEVELOP("~IFileDialog::Settings");
  delete fSettingsData->fileTypes;
  delete fSettingsData->drives;
  delete fSettingsData;
}


/*------------------------------------------------------------------------------
| IFileDialog::Settings&  IFileDialog::Settings::setTitle                      |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::setTitle (const char* newTitle)
{
  titleStr = newTitle;
  return *this;
}

/*------------------------------------------------------------------------------
| IFileDialog::Settings&  IFileDialog::Settings::setOKButtonText               |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::setOKButtonText(const char* newText)
{
  OKButtonStr = newText;
  return *this;
}

/*------------------------------------------------------------------------------
| IFileDialog::Settings& IFileDialog::Settings::setFileName                    |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::setFileName(const char* fileName,
                                                          bool fileNameIsFilter)
{
#ifdef IC_WIN
  IString temp( fileName );

  if ( temp.lastIndexOfAnyOf( ":\\" ) )
  {
    /******************************************************************/
    /* Get just path name out of the string (text up to last token)   */
    /******************************************************************/
    IString pathName = temp.subString( 1, temp.lastIndexOfAnyOf( ":\\" ));
    IString justFile = temp.subString( temp.lastIndexOfAnyOf( ":\\" )+1 );

    fSettingsData->fDirectory = pathName;
    fileNameStr = justFile;
    fSettingsData->isDirectorySet = true;
  }
  else
#endif
#ifdef IC_MOTIF
  fSettingsData->fFileAsFilter = fileNameIsFilter;
#endif // IC_MOTIF
  fileNameStr = fileName;
  return *this;
}

/*------------------------------------------------------------------------------
| IFileDialog::Settings& IFileDialog::Settings::setInitialDrive                |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::setInitialDrive(const char* drive)
{
  ITRACE_MOTIF_NOP();

  initialDriveStr = drive;
  return *this;
}

/*------------------------------------------------------------------------------
| IFileDialog::Settings&  IFileDialog::Settings::setInitialFileType            |
------------------------------------------------------------------------------*/
IFileDialog::Settings& IFileDialog::Settings::setInitialFileType(const char* type)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();

  initialFileTypeStr = type;
  // On PM, the initial file type has to be in the file type list also because the
  // dialog returns an index into that list (via sEAType) for what has been selected.
#ifdef IC_PM
  addFileType(type);
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IFileDialog::Settings::setDialogTemplate                                     |
------------------------------------------------------------------------------*/
IFileDialog::Settings&
  IFileDialog::Settings::setDialogTemplate ( const IResourceId& resId )
{
  ITRACE_MOTIF_NOP();

#ifdef IC_PMWIN
  fSettingsData->isDlgTemplateSet = true;
  fSettingsData->dlgId = resId.id();
  fSettingsData->dlgHandle = resId.resourceLibrary().handle();
#endif
  return *this;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| StringSeq*  IFileDialog::Settings::fileTypes ( ) const                       |
------------------------------------------------------------------------------*/
StringSeq*  IFileDialog::Settings::fileTypes ( ) const
{
  return fSettingsData->fileTypes;
}
#endif
#ifdef IC_PM
/*------------------------------------------------------------------------------
| StringSeq*  IFileDialog::Settings::drives( ) const                           |
------------------------------------------------------------------------------*/
StringSeq*  IFileDialog::Settings::drives( ) const
{
  return fSettingsData->drives;
}
#endif

/*------------------------------------------------------------------------------
| bool  IFileDialog::Settings::isDialogTemplateSet ( ) const         |
------------------------------------------------------------------------------*/
bool  IFileDialog::Settings::isDialogTemplateSet ( ) const
{
  return fSettingsData->isDlgTemplateSet;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| _IFileDlgProc                                                                |
|                                                                              |
| Override the dialog procedure so that the handler scheme                     |
| will work for Modal dialogs.                                                 |
------------------------------------------------------------------------------*/
void* __stdcall _IFileDlgProc( HWND          hwnd,
                               unsigned long msg,
                               void* mp1, void* mp2 )
{
   void* result(0);       // default return value
   IFileDialog* pfildlg = (IFileDialog*)IQUERYWINDOWULONG( hwnd, DWL_USER );
   if ((pfildlg == 0) && (msg != WM_INITDLG))     // No window object to pass
      return 0;

   switch(msg)
   {
      case WM_CTLCOLORDLG:
      case WM_CTLCOLORSTATIC:
      case WM_CTLCOLORBTN:
      {
        IColor clrBgnd = pfildlg->backgroundColor();
        IEvent evt(hwnd, msg, mp1, mp2);

        // Set background colors in device context
        SetBkColor( (HDC)evt.parameter1(), clrBgnd.asRGBLong() );

        // Return HBRUSH for painting controls background
        if ( pfildlg->fFileDialogData->fbkgrndbrush != 0 )
          DeleteObject( pfildlg->fFileDialogData->fbkgrndbrush );
        pfildlg->fFileDialogData->fbkgrndbrush =
          CreateSolidBrush (NEARESTPALETTECOLOR(clrBgnd.asRGBLong()));
        return ( pfildlg->fFileDialogData->fbkgrndbrush );
      }

      case WM_INITDLG:
      {
         // Get the "this" pointer for font dialog object from lparam
         // (saved in custData) and typecast for usage.
         OPENFILENAME* cfs = (OPENFILENAME*)mp2;
         pfildlg = (IFileDialog*)cfs->lCustData;

         // Since this is only passed on WM_INITDIALOG, save in the
         // user window word so that we can retrieve it on other msgs
         ISETWINDOWULONG( hwnd, DWL_USER, (LPARAM)pfildlg );

         // Get the handle to the actual file dialog.  For the explorer
         // style dialog this is the parent of the hwnd passed in.
         HWND hwndDlg = GetParent(hwnd);

         // Modify the OK button text string, if text was provided.
         if (pfildlg->fFileDialogData->fSettingsChanged & IC_OKBUTTON_SET)
           CommDlg_OpenSave_SetControlText( hwndDlg, IDOK,
                (char*) pfildlg->fFileDialogData->fOKButton );
//           ISETWINDOWTEXT( IWINDOWFROMID( hwnd, IDOK ),
//                           pfildlg->fFileDialogData->fOKButton );

         // If the dialog position was set, move it to that spot
         if (pfildlg->fFileDialogData->fSettingsChanged & IC_POSITION_SET)
         {
           // Get the position requested which is relative to the
           //  owner window and convert it to screen coordinates
           RECT rectOwner = {0,0,0,0};
           IPoint pos = pfildlg->fFileDialogData->fPosition;

           if( cfs->hwndOwner )
               GetWindowRect( cfs->hwndOwner, &rectOwner );

           pos.setX( rectOwner.left + pos.x() );

           // If coordinate system is different, recoordinate here
           if (ICoordinateSystem::applicationOrientation() ==
                                      ICoordinateSystem::kOriginLowerLeft )
           {
             RECT rectDlg = {0,0,0,0};
             GetWindowRect( hwndDlg, &rectDlg );

             if( cfs->hwndOwner )
             {
                pos.setY( rectOwner.bottom - pos.y() -
                       (rectDlg.bottom - rectDlg.top) );
             }
             else
             {
                long desktopHeight = IWindow::desktopWindow()->size().height();
                                     pos.setY( desktopHeight - pos.y() -
                                     (rectDlg.bottom - rectDlg.top) );

             }
           }
           else
             pos.setY( rectOwner.top + pos.y() );

           // Once position is calculated in screen coord,move window
           /***********************************************************/
           ISETWINDOWPOS( hwndDlg, NULL, pos.x(), pos.y(), 0, 0,
                          SWP_NOZORDER | SWP_NOSIZE | SWP_NOACTIVATE );
        }
        if (cfs->hwndOwner)
           {
           // Insure that owner is behind this window
           ISETWINDOWPOS( cfs->hwndOwner, hwndDlg, 0,0,0,0,
                          SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE );
           }
        //  Unless there is a user provided handler that processes
        //  WM_INITDIALOG, we want to return true to Windows.  This
        //  tells Windows to set focus to the dialog.
        result = (void*)1;
        pfildlg->addDefaultHandler();    // for IFrameWindow

        pfildlg->addToWindowSet(pfildlg, IWindowHandle(hwndDlg));

        if (pfildlg->fFileDialogData->handlerToAdd != 0)
           pfildlg->fFileDialogData->handlerToAdd->handleEventsFor(pfildlg);
     }
     break;

     case WM_COMMAND:
     {
       /***************************************************************/
       /* Setup id of apply pushbutton                                */
       /***************************************************************/
       unsigned short applyButton = psh3;
       /***************************************************************/
       /* Check if the apply button was hit for a modeless dialog     */
       /***************************************************************/
       if (pfildlg->isModeless() && (LOWORD((WPARAM)mp1) == applyButton)
           && (HIWORD((WPARAM)mp1) == BN_CLICKED)
           )
       {
         /*************************************************************/
         /* then send message to self that file should be applied     */
         /*************************************************************/
         pfildlg->handle().sendEvent(  IC_UM_DLG_APPLY_PRESSED,
                   IEventParameter1( pfildlg->pFileDlgData->lpstrFile ),
                   IEventParameter2( 0 ) );
       }
       return 0;   // do not dispatch
     }
     case WM_NOTIFY:
     {
        OFNOTIFY* ofn = (OFNOTIFY*)mp2;
        switch (ofn->hdr.code)
        {
           case CDN_FILEOK:
              pfildlg->fFileDialogData->fReturnVal = DID_OK;
              break;
           case CDN_HELP:
           {
              POINT nullPoint;
              HELPINFO helpInfo;
              helpInfo.cbSize = sizeof(HELPINFO);
              helpInfo.MousePos = nullPoint;
              helpInfo.dwContextId  = 0;
              helpInfo.hItemHandle = pfildlg->handle();
              helpInfo.iCtrlId = (int)pfildlg->id();
              helpInfo.iContextType = HELPINFO_WINDOW;
              IEvent evt(pfildlg, WM_HELP, 0, &helpInfo);
              // Allow our handlers a chance at help first.
              // processed then send on to system.
              if ( !pfildlg->dispatch(evt) )
              {
                  IWindow* owner = pfildlg->owner();
                  if (owner)
                     owner->sendEvent( evt );
              }
              return 0;       // do not dispatch
           }
        }
        break;
     }
     case WM_SYSCOMMAND:            // Keep these from going to default
     case WM_CLOSE:                 // frame handler
         return 0;

  } /* end switch */

  // Call dispatch so that any handlers will get called.  We do not dispatch
  // WM_DESTROY because that could cause IWindow to delete the dialog while
  // we still need it.
  if (msg == WM_DESTROY)
  {
     // We need to dispatch a message to the dialog handler to indicate that
     // the dialog is closing.  This is to insure modelessResults gets called.
     // Note that parameter2 is 1, which is the indication that this message
     // is for a destroy and not the apply button.
     IEvent newEvt(pfildlg, IC_UM_DLG_APPLY_PRESSED, 0, 1);
     pfildlg->dispatch(newEvt);

     // The handle is no longer valid.  Remove from window list.
     pfildlg->removeFromWindowSet(pfildlg);

     if (pfildlg->isAutoDeleteObject() )
     {
        IModelessDialogWindow* objwin = dynamic_cast<IModelessDialogWindow*>(
           IWindow::windowWithHandle( pfildlg->pFileDlgData->hwndOwner ) );

        // Force the destruction of the object window and the file dialog object.
        // This will occur later because close() is processed via a post event.
        if (objwin)
           objwin->close();
     }
  }
  else
  {
     IEvent newEvt(pfildlg, msg, mp1, mp2);
     if (pfildlg->dispatch(newEvt))
        result = newEvt.result();
  }

  ISETWINDOWULONG(hwnd, DWL_MSGRESULT, (unsigned long)result);
  return result;
}

#endif //IC_WIN

#ifdef IC_PM
/*------------------------------------------------------------------------------
| _IFileDlgProc                                                                |
|                                                                              |
| Override the WinFileDlg dialog procedure so that the handler scheme          |
| will work for Modal dialogs.                                                 |
------------------------------------------------------------------------------*/
void*   _System _IFileDlgProc( unsigned long hwnd,
                               unsigned long msg,
                               void* mp1, void* mp2 )
{
  void* result(0);       // default return value
   /*****************************************************************/
   /* Get the "this" pointer for window object from the window word */
   /* which was set by WM_CREATE in above.                          */
   /*****************************************************************/
   FILEDLG* pfildData = (FILEDLG*)WinQueryWindowPtr(hwnd, QWL_USER);
   IFileDialog* pfildlg = (IFileDialog*)pfildData->ulUser;

   if (pfildlg == (IFileDialog*)0)
      return IPMCtlStatics::defFileDlgProc(hwnd, msg, mp1, mp2);

   switch(msg)
   {
      case WM_INITDLG:
      {
        pfildlg->addDefaultHandler();    // for IFrameWindow

        pfildlg->addToWindowSet(pfildlg, IWindowHandle(hwnd));

        if (pfildlg->fFileDialogData->handlerToAdd != 0)
           pfildlg->fFileDialogData->handlerToAdd->handleEventsFor(pfildlg);
     }
        break;

     case WM_COMMAND:
     {
       /***************************************************************/
       /* Setup id of apply pushbutton                                */
       /***************************************************************/
       unsigned short applyButton = DID_APPLY_PB;
       /***************************************************************/
       /* Check if the apply button was hit for a modeless dialog     */
       /***************************************************************/
       if (pfildlg->isModeless() && (LOWORD((WPARAM)mp1) == applyButton)
           )
       {
         /*************************************************************/
         /* then send message to self that file should be applied     */
         /*************************************************************/
         IString strFile( pfildlg->pFileDlgData->szFullFile );

         IWindowHandle hwndEdit = IWindow::handleWithParent(
                   DID_FILENAME_ED,
                   hwnd );
         unsigned long ulClBufLen =
           (unsigned long)IQUERYWINDOWTEXTLENGTH(hwndEdit) + 1;

         char* pszClBuf = new char[ulClBufLen];
         IQUERYWINDOWTEXT(hwndEdit, ulClBufLen, (PSZ)pszClBuf);

         strFile += pszClBuf;
         delete [] pszClBuf;

         pfildlg->handle().sendEvent(  IC_UM_DLG_APPLY_PRESSED,
                   IEventParameter1( (char*)strFile ),
                   IEventParameter2( 0 ) );
       }
     }
     case WM_SYSCOMMAND:            // Keep these from going to default
     case WM_CLOSE:                 // frame handler
         return IPMCtlStatics::defFileDlgProc(hwnd, msg, mp1, mp2);

  } /* end switch */

  // call dispatch so that any handlers will get called
  IEvent newEvt(hwnd, msg, mp1, mp2);

  if (pfildlg->dispatch(newEvt))
     result = newEvt.result();
   else
     result = IPMCtlStatics::defFileDlgProc(hwnd, msg, mp1, mp2);

  if(msg==WM_DESTROY)
  {
     pfildlg->removeFromWindowSet(pfildlg);
  }

  return result;
}
#endif //IC_PM

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| ifiledlgMotifCallback                                                        |
| This callback is used to get correct behavior with multiple selection.       |
| It forces deselection if something is typed in the entry field and           |
| primes the entry field with the first selection when multiple selection      |
| is done.                                                                     |
------------------------------------------------------------------------------*/
void _System ifiledlgMotifCallback( _WidgetRec *w,
                                    void       *clientData,
                                    void       *callData )
{
  IFileDialog* pfd = (IFileDialog*)clientData;
  int cbreason = ((XmAnyCallbackStruct*)callData)->reason;
  ITRACE_ALL( IString("ifiledlgMotifCallback reason=") + IString(cbreason) );
  switch ( cbreason )
     {
     case XmCR_MULTIPLE_SELECT:
        {
        XmListCallbackStruct* pListCallback = (XmListCallbackStruct*)callData;

        if ( pListCallback->selected_item_count )
           {
           pfd->fFileDialogData->fDeselectList = false;
           XtVaSetValues(  pfd->handleForChildCreation(),
                           XmNdirSpec, pListCallback->selected_items[0],
                           NULL );
           }
        }
        break;

     case XmCR_VALUE_CHANGED:
        if ( pfd->fFileDialogData->fDeselectList )
           {
           XmListDeselectAllItems(
              XmFileSelectionBoxGetChild( (Widget)pfd->handleForChildCreation(),
                                           XmDIALOG_LIST ));
           }
        pfd->fFileDialogData->fDeselectList = true;
        break;
     }
}

/*------------------------------------------------------------------------------
| ifiledialogSearchProc                                                        |
| Need this to implement IFileDialogHandler::filter and filterName             |
------------------------------------------------------------------------------*/
void ifiledialogSearchProc( Widget w, XtPointer search_data )
{
   bool noneFiltered = true;  // If none are filtered, let the default search
                              // procedure fill the list box to avoid an
                              // annoying clipping bug.
   int           iFileCount = 0;
   unsigned char ucFileType;
   IWindowHandle hwndFileBox = w;
   IWindowHandle hwndFileDialog = XtParent( XtParent( (Widget)hwndFileBox ));

   XmFileSelectionBoxCallbackStruct *fsb =
      (XmFileSelectionBoxCallbackStruct *)search_data;

   XtVaGetValues( hwndFileBox,
                  XmNfileTypeMask, &ucFileType,
                  NULL );

   // Construct a command for the glob subroutine based on the
   // current contents of the dialog
   // initialialize to NULL string on SUN platform   -- SY
   #ifdef IC_SUN
     char* dir = "";
     char* pattern = "";
   #else
     char* dir = 0;
     char* pattern = 0;
   #endif

   XmStringGetLtoR( fsb->dir,     XmFONTLIST_DEFAULT_TAG, &dir     );
   XmStringGetLtoR( fsb->pattern, XmFONTLIST_DEFAULT_TAG, &pattern );

   char* pszCommand = new char[ strlen(dir) + strlen(pattern) + 3 ];
   sprintf( pszCommand, "%s%s", dir, pattern );

   if (dir) XtFree(dir);
   if (pattern) XtFree(pattern);

   // Call glob with the command string built from the dialog.
   glob_t globbuf;
   glob( pszCommand, 0, NULL, &globbuf );

   // Examine the results of glob one at a time.  For each one found
   // matching the directory/file specified we call the file dialog
   // handler via sendEvent to filter.
   if (globbuf.gl_pathc > 0)
      {
      int i;
      XmString *pXmStrings = new XmString[globbuf.gl_pathc];
      for ( i=0, iFileCount=0; i<globbuf.gl_pathc; i++)
         {
         struct stat buf;
         stat( globbuf.gl_pathv[i], &buf );
         if  (( ucFileType == XmFILE_REGULAR && S_ISREG(buf.st_mode) ) ||
              ( ucFileType == XmFILE_DIRECTORY && S_ISDIR(buf.st_mode) ) ||
              ( ucFileType == XmFILE_ANY_TYPE ))
            {

            //  ( pIFileDialogHandler->filterName( globbuf.gl_pathv[i],
            //                                     pIFileDialogHandler->pIFileDialog )))
            // Construct a fake event and send it via the handler chain
            // to the file dialog handler.  If result is true the file
            // is validated.
            if ( (unsigned long) hwndFileDialog.sendEvent(
                                    FDM_FILTER,
                                    (char *)globbuf.gl_pathv[i],
                                    0ul ) )
               {
               pXmStrings[iFileCount] = XmStringCreateLtoR( globbuf.gl_pathv[i],
                                                            XmFONTLIST_DEFAULT_TAG );
               iFileCount++;
               }
            else
               {
               noneFiltered = false;
               }
            }
         }

      // Set the results of the search into the widget resources.
      // Only set the resource if some have been filtered.  Otherwise,
      // let the default procedure handle it below.
      if (!noneFiltered)
      {
      XtVaSetValues(hwndFileBox,
                    XmNfileListItems, (XmStringTable)pXmStrings,
                    XmNfileListItemCount, iFileCount,
                    XmNlistUpdated, True,
                    XmNdirSpec, fsb->dir,
                    NULL );

      }
      // clean up
      for ( i=0; i<iFileCount; i++)
         {
         XmStringFree( pXmStrings[i] );
         }
      delete [] pXmStrings;
      }
   else
      {
      // nothing found matching by glob
      XtVaSetValues(hwndFileBox,
                    XmNfileListItems, (XmStringTable)NULL,
                    XmNfileListItemCount, 0,
                    XmNlistUpdated, True,
                    XmNdirSpec, fsb->dir,
                    NULL );
      }
   globfree( &globbuf );
   delete [] pszCommand;
   // If none were filtered, let the default search procedure fill the files
   // list box to avoid annoying clipping bug.
   if (noneFiltered)
   {
      (*defaultSearchProc)(w, search_data);
   }
}

/*------------------------------------------------------------------------------
| ifiledialogQualifyProc                                                       |
------------------------------------------------------------------------------*/
void ifiledialogQualifyProc( Widget w, XtPointer input, XtPointer output )
{
   XmFileSelectionBoxCallbackStruct * inStruct =
       (XmFileSelectionBoxCallbackStruct *) input;
   XmFileSelectionBoxCallbackStruct * outStruct =
       (XmFileSelectionBoxCallbackStruct *) output;
   char* mask = 0;
   if ( (inStruct->mask) &&
        (XmStringGetLtoR( inStruct->mask, XmFONTLIST_DEFAULT_TAG, &mask  ) ) )
      {
      // try to open the entire pattern as a directory
      DIR * openDIR = opendir( mask );
      if (openDIR)
         {
         closedir(openDIR);        // clean up the open
         // the pattern is a directory ... override the FileSelectionWidget
         // default pattern maching by setting pattern to "*" and
         // setting the directory to search = the old directory + pattern.
         // this makes the pattern /u/home/src search /u/home/src/* instead
         // the default /u/home with pattern src
         // If mask ends with '/', do not append an extra '/'.
         char suffix[3];
         if ( mask[strlen(mask)-1]=='/') strcpy(suffix,"*");
         else strcpy(suffix,"/*");
         XmString temp = XmStringCreateLocalized( suffix );
         XmString oldMask = inStruct->mask;
         inStruct->mask = XmStringConcat(oldMask, temp);
         inStruct->mask_length = XmStringLength( inStruct->mask );
         XmStringFree(temp);
         XmStringFree(oldMask);
         }
      if (mask) XtFree( mask );
      }
   (*defaultQualifyProc)(w, input, output);

}

/*------------------------------------------------------------------------------
| ifiledialogHelpCallback                                                      |
------------------------------------------------------------------------------*/
void ifiledialogHelpCallback(Widget     w,
                             XtPointer  client_data,
                             XtPointer  call_data )
{
   // Simulate a help callback for the dialog as a whole
   ihelpwindowCallback( XtParent(w), (XtPointer)DID_FILE_DIALOG, call_data);
   return;
}

// Loads the button label text from the message catalog
IString loadButtonLabel( unsigned long messageId,
                                const char   *defaultText )
{
   IMessageText msgText ( messageId );
   msgText.setDefaultText( defaultText );
   return IString( msgText.text() );
}
#endif
//
// Implementation for IFileDialog
//

/*------------------------------------------------------------------------------
| IFileDialog::IFileDialog                                                     |
------------------------------------------------------------------------------*/
IFileDialog::IFileDialog ( IWindow*  parent,
                           IWindow*  owner,
                           const Style& style )
  : IFrameWindow ( IFrameWindow::deferCreation ),
    fFileDialogData(new IFileDialogData)
{
  Settings tempSettings;
  initialize(parent, owner, style, 0, tempSettings);
}

/*------------------------------------------------------------------------------
| IFileDialog::IFileDialog                                                     |
------------------------------------------------------------------------------*/
IFileDialog::IFileDialog ( IWindow*        parent,
                           IWindow*        owner,
                           const Settings& settings,
                           const Style&    style )
  : IFrameWindow ( IFrameWindow::deferCreation ),
    fFileDialogData(new IFileDialogData)
{
  initialize(parent, owner, style, 0, settings);
}

/*------------------------------------------------------------------------------
| IFileDialog::IFileDialog                                                     |
------------------------------------------------------------------------------*/
IFileDialog::IFileDialog ( IWindow*        parent,
                           IWindow*        owner,
                           const Style&    style,
                           const Settings& settings )
  : IFrameWindow ( IFrameWindow::deferCreation ),
    fFileDialogData(new IFileDialogData)
{
  initialize(parent, owner, style, 0, settings);
}

/*------------------------------------------------------------------------------
| IFileDialog::IFileDialog                                                     |
------------------------------------------------------------------------------*/
IFileDialog::IFileDialog ( IWindow*        parent,
                           IWindow*        owner,
                           IHandler*       handler,
                           const Style&    style,
                           const Settings& settings )
  : IFrameWindow ( IFrameWindow::deferCreation ),
    fFileDialogData(new IFileDialogData)
{
  initialize(parent, owner, style, handler, settings);
}


/*------------------------------------------------------------------------------
| IFileDialog::~IFileDialog                                                    |
------------------------------------------------------------------------------*/
IFileDialog::~IFileDialog( )
{
  IMODTRACE_DEVELOP("~IFileDialog");

#ifdef IC_PM
  int i;
  delete [] pFileDlgData->pszTitle;
  delete [] pFileDlgData->pszOKButton;
  delete [] pFileDlgData->pszIType;
  delete [] pFileDlgData->pszIDrive;

  if(pFileDlgData->papszITypeList)
  {
    for(i=0; *pFileDlgData->papszITypeList[i]; i++)
       delete [] *pFileDlgData->papszITypeList[i];
    delete [] pFileDlgData->papszITypeList;
  }

  if(pFileDlgData->papszIDriveList)
  {
    for(i=0; *pFileDlgData->papszIDriveList[i]; i++)
       delete [] *pFileDlgData->papszIDriveList[i];
    delete [] pFileDlgData->papszIDriveList;
  }

  if (pFileDlgData->papszFQFilename)
     IPMCtlStatics::freeFileDlgList((char**)(pFileDlgData->papszFQFilename));
#endif
#ifdef IC_WIN
  // Cleanup modeless dialog window for non-AutoDeleteObject case.
  if (!this->isAutoDeleteObject() )
  {
     IModelessDialogWindow* objwin = dynamic_cast<IModelessDialogWindow*>(
        IWindow::windowWithHandle( this->pFileDlgData->hwndOwner ) );

     // Force the destruction of the object window if there is one.
     // This will occur later because close() is processed via a post event.
     if (objwin)
     {
        objwin->setDialogWindow(0);   // we are already deleting the dialog.
        objwin->close();
     }
  }
  delete [] fFileDialogData->fTitle;
  delete [] pFileDlgData->lpstrFile;
  delete [] fFileDialogData->fDrive;
#endif

#ifdef IC_MOTIF
  Widget w = handleForChildCreation();
  if (w != 0 && !w->core.being_destroyed)
  {
    XtRemoveCallback( w,                                // widget
                      XmNokCallback,                    // callback name
                      iwindowMotifCallback,             // callback routine
                      (XtPointer) this);                // client data
    XtRemoveCallback( w,                                // widget
                      XmNcancelCallback,                // callback name
                      iwindowMotifCallback,             // callback routine
                      (XtPointer) this);                // client data
    XtRemoveCallback( w ,
                      XmNunmapCallback,                 // callback name
                      iwindowMotifCallback,             // callback routine
                      (XtPointer) this);                // client data

    Widget child = XmFileSelectionBoxGetChild( w, XmDIALOG_LIST );
    if (child)
       {
       XtRemoveCallback( child,
                         XmNmultipleSelectionCallback,     // callback name
                         ifiledlgMotifCallback,            // callback routine
                         (XtPointer)this);                 // client data
       }

    if ( fFileDialogData->fStyle & IFileDialog::multiSelection )
      {
      child = XmFileSelectionBoxGetChild( w, XmDIALOG_TEXT );
      if (child )
         {
         XtRemoveCallback( child,
                           XmNvalueChangedCallback,        // callback name
                           ifiledlgMotifCallback,          // callback routine
                           (XtPointer)this);               // client data
         }
      }

    // Remove the help callbacks for each widget
    int i;
    for (i = 0; FileDialogHelpList[i].childId != XmDIALOG_NONE ; i++)
       {
       child = XmFileSelectionBoxGetChild( w, FileDialogHelpList[i].childId);
       if (child)
          {
          XtRemoveCallback( child,
                            XmNhelpCallback,             // callback name
                            ihelpwindowCallback,         // callback routine  (ihelpsta.cpp)
                            (XtPointer)FileDialogHelpList[i].helpId );
          }
       }

    // Remove callback for the help button
    child = XmFileSelectionBoxGetChild( w, XmDIALOG_HELP_BUTTON);
    if (child)
       {
       XtRemoveCallback( child,
                         XmNactivateCallback,         // callback name
                         ifiledialogHelpCallback,     // callback routine
                         NULL );
       }

  }
  fFileDialogData->fDefaultHandler.stopHandlingEventsFor( this );
#endif // IC_MOTIF

  delete pFileDlgData;
  delete fFileDialogData;
}

/*------------------------------------------------------------------------------
| IFileDialog::isModeless                                                      |
------------------------------------------------------------------------------*/
bool IFileDialog::isModeless () const
{
   return (fFileDialogData->fStyle & IFileDialog::modeless);
}

/*------------------------------------------------------------------------------
| IFileDialog::buttonPressedId                                                 |
------------------------------------------------------------------------------*/
unsigned long IFileDialog::buttonPressedId ( ) const
{
#ifdef IC_PM
   return pFileDlgData->lReturn;
#endif
#ifdef IC_WIN
   return fFileDialogData->fReturnVal;
#endif
#ifdef IC_MOTIF
   // result is stored in the frame with setResult
   return result();
#endif
}

/*------------------------------------------------------------------------------
| IFileDialog::pressedOK                                                       |
------------------------------------------------------------------------------*/
bool IFileDialog::pressedOK ( ) const
{
   return buttonPressedId() == DID_OK ;
}

/*------------------------------------------------------------------------------
| IFileDialog::selectedFileCount                                               |
------------------------------------------------------------------------------*/
unsigned IFileDialog::selectedFileCount() const
{
#ifdef IC_PM
   return pFileDlgData->ulFQFCount;
#endif
#ifdef IC_WIN
   /*******************************************************************/
   /* If multiple select, then need to count the number of filenames  */
   /* returned in lpstrFile buffer for Windows multifile select       */
   /*******************************************************************/
   if (fFileDialogData->fStyle & IFileDialog::multiSelection)
   {
     IString endMarker(0, 2, IC_MULTISELECTION_DELIMITER);  //two delimiter chars
     IString temp(pFileDlgData->lpstrFile,
                   (unsigned int)pFileDlgData->nMaxFile);
     unsigned int count = temp.indexOf(endMarker);
     temp.remove(count+1);
     count = temp.occurrencesOf( IC_MULTISELECTION_DELIMITER,
                                 pFileDlgData->nFileOffset+1 );
     return ( (count) ? count : 1 );
   }
   else
     return 1;
#endif
#ifdef IC_MOTIF
   int iSelectedItemCount = 0;
   IWindowHandle fileBoxHandle = handleForChildCreation();

   Widget List = XmFileSelectionBoxGetChild( fileBoxHandle, XmDIALOG_LIST );

   XtVaGetValues( List, XmNselectedItemCount, &iSelectedItemCount, NULL );

   // if the number of selected files is 0 check the entry field
   if ( iSelectedItemCount <= 0 )
      {
      IMString xms = IMString( fileBoxHandle, XmNdirSpec) ;
      IString  selectedFile = xms.asString();
      if ( selectedFile.length()  != 0 )
         {
         iSelectedItemCount = 1;
         }
      else
         {
         iSelectedItemCount = 0;
         }
      }
   return (unsigned)iSelectedItemCount;
#endif
}


/*------------------------------------------------------------------------------
| IFileDialog::returnValue                                                     |
------------------------------------------------------------------------------*/
long IFileDialog::returnValue () const
{
  ITRACE_MOTIF_NOP();

#ifdef IC_PM
   return pFileDlgData->lSRC;
#endif
#ifdef IC_WIN
   return fFileDialogData->fSRC;
#endif
#ifdef IC_MOTIF
   // always 0 in Motif
   return 0;
#endif
}

/*------------------------------------------------------------------------------
| IFileDialog::fileName                                                        |
------------------------------------------------------------------------------*/
IString IFileDialog::fileName (unsigned fileNumber) const
{
#ifdef IC_PM
   if (fileNumber == 0) {
     return IString(pFileDlgData->szFullFile);
   }

   if (fileNumber < 1 ||
       fileNumber > selectedFileCount() +1 ||
       !pFileDlgData->papszFQFilename )
        return IString();

  return IString((char*)(*pFileDlgData->papszFQFilename[fileNumber]));
#endif
#ifdef IC_WIN
  if ((fileNumber == 0) && (selectedFileCount() == 1))
    return IString(pFileDlgData->lpstrFile);
  else
  {
    /*****************************************************************/
    /* If an invalid fileNumber is passed, return a null string      */
    /*****************************************************************/
    if (fileNumber >= selectedFileCount() )
      return IString();

    /*****************************************************************/
    /* Create a temp string of the entire buffer returned            */
    /*****************************************************************/
    IString temp(pFileDlgData->lpstrFile,
                 (unsigned int)pFileDlgData->nMaxFile);
    IString endMarker(0, 2, IC_MULTISELECTION_DELIMITER);  //two delimiter chars
    unsigned int index = temp.indexOf(endMarker);
    temp.remove(index);

    /*****************************************************************/
    /* Get just path name out of the string (text up to first space) */
    /*****************************************************************/
    IString pathName =
      temp.subString( 1, temp.indexOf( IC_MULTISELECTION_DELIMITER )-1 );

    /*****************************************************************/
    /* Loop through selected files to find the requested one         */
    /*****************************************************************/
    unsigned int nextIndex(0), i;
    index = 0;
    for ( i=0; i <= fileNumber; i++ )
    {
      index = temp.indexOf( IC_MULTISELECTION_DELIMITER, index+1 );
      nextIndex = temp.indexOf( IC_MULTISELECTION_DELIMITER, index+1 );
    }

    /*****************************************************************/
    /* Finally, build the fully qualified name from the parts        */
    /*****************************************************************/
    IString currName;
    if (nextIndex)
      currName = temp.subString( index+1, (nextIndex-index-1) );
    else
      currName = temp.subString( index+1 );
    return pathName + temp.subString( 3,1 ) + currName;
  }
#endif
#ifdef IC_MOTIF
   int            iSelectedItemCount;
   IWindowHandle  fileBoxHandle = handleForChildCreation();

   if ( fFileDialogData->fStyle & IFileDialog::multiSelection )
   {
      Widget List = XmFileSelectionBoxGetChild( fileBoxHandle, XmDIALOG_LIST );

      XtVaGetValues( List, XmNselectedItemCount, &iSelectedItemCount, NULL );
      // check for the case where no item is selected in the listbox but
      // an item is in the entryfield.
      if (fileNumber == 0 && iSelectedItemCount == 0)
         {
         return IMString( fileBoxHandle, XmNdirSpec).asString( );
         }
      else
         {
         XmStringTable  xmsTable;
         if ( fileNumber > selectedFileCount() + 1 )
           return IString();

         XtVaGetValues( List, XmNselectedItems, &xmsTable, NULL );

         return IMString::asString( xmsTable[fileNumber] );
         }
      }
   else
      {
      return IMString( fileBoxHandle, XmNdirSpec).asString( );
      }
#endif
}

/*------------------------------------------------------------------------------
| IFileDialog::saveAsEAType                                                    |
------------------------------------------------------------------------------*/
IString IFileDialog::saveAsEAType ( ) const
{
#ifdef IC_PM
   if ((pFileDlgData->sEAType != -1) && pFileDlgData->papszITypeList)
      return IString((char*)(*pFileDlgData->papszITypeList[pFileDlgData->sEAType]));
#endif

   return IString();
}

/*------------------------------------------------------------------------------
| IFileDialog::defaultStyle                                                    |
|                                                                              |
| Return the default style for new file dialog objects.                        |
------------------------------------------------------------------------------*/
IFileDialog::Style  IFileDialog::defaultStyle()
{
  return currentDefaultStyle;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IFileDialog::setDefaultStyle                                                 |
|                                                                              |
| Set the default style for new file dialog objects.                           |
------------------------------------------------------------------------------*/
void IFileDialog::setDefaultStyle( const IFileDialog::Style &style )
{
  currentDefaultStyle = style;
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IFileDialog::convertToGUIStyle                                               |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IFileDialog::convertToGUIStyle(const IBitFlag& guiStyle,
                                             bool bExtOnly) const
{
  unsigned long ulStyle(0);

  const IFileDialog::Style& bitStyle = (const IFileDialog::Style &) guiStyle;

#ifdef IC_PM
  if (bExtOnly)
  {
     ulStyle = Inherited::convertToGUIStyle( guiStyle, bExtOnly );
  }
  else
  {
     // The file dialog styles are completely disjoint from the IFrameWindow
     // styles because they are specified in the FILEDLG structure rather
     // than in WinCreateWindow.  Do not call Inherited::convertToGUIStyle.

     if (bitStyle & IFileDialog::helpButton)
        ulStyle |= FDS_HELPBUTTON;
     if (bitStyle & IFileDialog::multiSelection)
        ulStyle |= FDS_MULTIPLESEL;
     if (bitStyle & IFileDialog::filter)
        ulStyle |= FDS_FILTERUNION;
     if (bitStyle & IFileDialog::applyButton)
        ulStyle |= FDS_APPLYBUTTON;
     if (bitStyle & IFileDialog::includeEAS)
        ulStyle |= FDS_INCLUDE_EAS;
     if (bitStyle & IFileDialog::modeless)
        ulStyle |= FDS_MODELESS;
     if (bitStyle & IFileDialog::preload)
        ulStyle |= FDS_PRELOAD_VOLINFO;
     if (bitStyle & IFileDialog::selectableListbox)
        ulStyle |= FDS_ENABLEFILELB;
  }
#endif //IC_PM
#ifdef IC_WIN
  if (bExtOnly)
  {
     ulStyle = Inherited::convertToGUIStyle( guiStyle, bExtOnly );
     if (bitStyle & IFileDialog::modeless)
        ulStyle |= IFDS_MODELESS;
  }
  else
  {
     // The file dialog styles are completely disjoint from the IFrameWindow
     // styles because they are specified in the OPENFILENAME structure rather
     // than in CreateWindow.  Do not call Inherited::convertToGUIStyle.

     ulStyle |= OFN_HIDEREADONLY | OFN_NOCHANGEDIR;  //Always on.

     if (bitStyle & IFileDialog::helpButton)
        ulStyle |= OFN_SHOWHELP;
     if (bitStyle & IFileDialog::multiSelection)
        ulStyle |= OFN_ALLOWMULTISELECT;
  }
#endif //IC_WIN
  return( ulStyle );
}
#endif

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFileDialog::convertToArgList                                                |
|                                                                              |
| Returns arg list for the styles that are requested.                          |
| No styles are passed through on the call to IFrameWindow::create, so do      |
| nothing for now.                                                             |
------------------------------------------------------------------------------*/
IArgList IFileDialog::convertToArgList ( const IBitFlag& style ) const
{
  IArgList theArgList;

  return theArgList;
}
#endif // IC_MOTIF

/*------------------------------------------------------------------------------
| IFileDialog::id                                                              |
|                                                                              |
| Get the object identity                                                      |
------------------------------------------------------------------------------*/
unsigned long IFileDialog::id() const
{
  ITRACE_PM_NOP();
#ifdef IC_WIN
  return fFileDialogData->fDialogId;
#endif
#ifdef IC_MOTIF
  return Inherited::id();
#endif
#ifdef IC_PM
  return 0;
#endif
}

/*------------------------------------------------------------------------------
| IFileDialog::setId                                                           |
|                                                                              |
| Set the object identifier                                                    |
------------------------------------------------------------------------------*/
IFileDialog& IFileDialog::setId( unsigned long ulId )
{
  ITRACE_MOTIF_NOP();
  ITRACE_PM_NOP();

#ifdef IC_WIN
  fFileDialogData->fDialogId = ulId;
#endif
  return *this;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IFileDialog::backgroundColor                                                 |
|                                                                              |
| Returns the background color of the font dialog.                             |
------------------------------------------------------------------------------*/
IColor IFileDialog::backgroundColor () const
{
  return fFileDialogData->fclrbackground;
}

/*------------------------------------------------------------------------------
| IFileDialog::setBackgroundColor                                              |
|                                                                              |
| Stores the background color of the font dialog.                              |
------------------------------------------------------------------------------*/
IFileDialog& IFileDialog::setBackgroundColor (const IColor &color)
{
  fFileDialogData->fclrbackground = color;
  return *this;
}

#endif // IC_WIN

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFileDialog::show                                                            |
|                                                                              |
| Invoke inherited version, then                                               |
| generate events that need to be handled before the dialog is displayed.      |
------------------------------------------------------------------------------*/
IFileDialog &IFileDialog::show ( bool showWindow )
  {
  Inherited::show( showWindow );

  if ( showWindow )
   {
    // Setting the dirMask causes the ifiledialogQualifyProc
    // and ifiledialogSearchProc callbacks to be invoked.  They
    // determine the default values for the directory and pattern,
    // and create the initial list of files to be shown.  Only files
    // validated by the event handler are shown.
    IWindowHandle h = handleForChildCreation();
    IMString mdirSpec( h, XmNdirSpec );
    XtVaSetValues( (Widget)h, XmNdirMask, (XmString)mdirSpec, NULL );
    // If the file name given was not supposed to be a filter, then we used
    // the default ("*"), and now we need to set the file name in the
    // selection field.
    if (!fFileDialogData->fFileAsFilter)
    {
       IMString mfileName (h, XmNdirSpec);
       if (fFileDialogData->fFileName.indexOf("/"))
       {
          mfileName = fFileDialogData->fFileName;
       }
       else
       {
          mfileName += fFileDialogData->fFileName;
       }
       XtVaSetValues( (Widget)h, XmNdirSpec, (XmString) mfileName, NULL);
    }
   }

  return *this;
  }
#endif

/*------------------------------------------------------------------------------
| IFileDialog::initialize                                                          |
|                                                                              |
| Called by constructor to actually start the dialog.                          |
| For a modal dialog does not return until user has dismissed dialog.          |
| Because of this, we have override the PM dialog procedure with our own       |
| so that the handler scheme will work.                                        |
------------------------------------------------------------------------------*/
void IFileDialog::initialize (IWindow*        parent,
                              IWindow*        owner,
                              const Style&    style,
                              IHandler*       handler,
                              const Settings& settings)
{
   IMODTRACE_DEVELOP("IFileDialog::initialize");
   // Store a copy of the style flags for later use.
   fFileDialogData->fStyle = style;
#ifdef IC_PM
   // It's possible that the first thing an application may do is
   // create a IFileDialog. Since we deferCreation of our parent IFrameWindow
   // we should be sure that PM has been initialized.
   IThread::current().initializeGUI();

   fFileDialogData->handlerToAdd = handler;

   pFileDlgData = new FILEDLG;
   memset(pFileDlgData, 0, sizeof(FILEDLG) );
   pFileDlgData->cbSize = sizeof(FILEDLG);

   // Save the extended style to make sure we have a copy of it stored
   setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

   // Convert the style bits into the GUI native style settings
   pFileDlgData->fl = convertToGUIStyle( style );

   if (settings.isOpenDialog()) {
      pFileDlgData->fl |= FDS_OPEN_DIALOG;
   } else {
      pFileDlgData->fl |= FDS_SAVEAS_DIALOG;
   } /* endif */

   if (settings.isPositionSet()) {
      pFileDlgData->x = (short)(settings.position().x());
      pFileDlgData->y = (short)(settings.position().y());
   } else {
      pFileDlgData->fl |= FDS_CENTER;
   } /* endif */

   if (settings.isDialogTemplateSet()) {
      pFileDlgData->fl |= FDS_CUSTOM;
      pFileDlgData->hMod = settings.fSettingsData->dlgHandle;
      pFileDlgData->usDlgId = (unsigned short)(settings.fSettingsData->dlgId);
   }

   pFileDlgData->ulUser = (unsigned long)this;

   if (settings.title().length()) {
      pFileDlgData->pszTitle = (PSZ)new char[settings.title().length()+1];
      strcpy(pFileDlgData->pszTitle, settings.title() );
   }

   if (settings.okButtonText().length()) {
      pFileDlgData->pszOKButton = (PSZ)new char[settings.okButtonText().length()+1];
      strcpy(pFileDlgData->pszOKButton, settings.okButtonText() );
   }

   if (settings.initialDrive().length()) {
      pFileDlgData->pszIDrive = (PSZ)new char[settings.initialDrive().length()+1];
      strcpy(pFileDlgData->pszIDrive, settings.initialDrive() );
   }

   if (settings.initialFileType().length()) {
      pFileDlgData->pszIType = (PSZ)new char[settings.initialFileType().length()+1];
      strcpy(pFileDlgData->pszIType, settings.initialFileType() );
   }

   strcpy(pFileDlgData->szFullFile, settings.fileName() );

   pFileDlgData->pfnDlgProc = (FNWP*)_IFileDlgProc;

   IString* curString;
   int i;

   // Settings maintains the list of Types and Drives as BB collections
   // of strings. These have to be filled into an array of char pointers
   // in the PM FILEDIALOG structure...
   StringSeq* curQ = settings.fileTypes();
   if (curQ) {
     i = 0;
     // allocate space for the table of char pointers
     pFileDlgData->papszITypeList = (PAPSZ) new char*[curQ->numberOfElements() + 1];
     StringSeq::Cursor current(*curQ);
     for (current.setToFirst(); current.isValid(); current.setToNext() ) {
        curString = curQ->elementAt(current);
        // allocate space for the current string
        *pFileDlgData->papszITypeList[i] = new char[curString->length() + 1];
        // copy current string into storage just allocated
        strcpy(*pFileDlgData->papszITypeList[i], *curString);
        i++;
     } /* end for */
     *pFileDlgData->papszITypeList[i] = 0;       // array terminator
   }

   curQ = settings.drives();
   if (curQ) {
     i = 0;
     // allocate space for the table of char pointers
     pFileDlgData->papszIDriveList = (PAPSZ) new char*[curQ->numberOfElements() + 1];
     StringSeq::Cursor current(*curQ);
     for (current.setToFirst(); current.isValid(); current.setToNext() ) {
        curString = curQ->elementAt(current);
        // allocate space for the current string
        *pFileDlgData->papszIDriveList[i] = new char[curString->length() + 1];
        // copy current string into storage just allocated
        strcpy(*pFileDlgData->papszIDriveList[i], *curString);
        i++;
     } /* end for */
     *pFileDlgData->papszIDriveList[i] = 0;
   }

   // Need to set a variable in IWindow that holds the default procedure
   // so that IFrameHandler will work.
   setDefaultProcedure(IPMCtlStatics::defFileDlgProcAddr());

   // Make call to WinFileDlg via IPMCtlStatics. Trying to avoid reference
   // to WinFileDlg until actually needed.
   if (!IPMCtlStatics::fileDlg(parent == 0 ? desktopWindow()->handle() :
                                                parent->handleForChildCreation(),
                   owner  == 0 ? IWindowHandle(0)        : owner->handle(),
                   pFileDlgData) )
   {
      ITHROWSYSTEMERROR(pFileDlgData->lSRC,"WinFileDlg",IBaseErrorInfo::invalidRequest,IException::recoverable);
   }
#endif // IC_PM
#ifdef IC_WIN
   /*******************************************************************/
   /* Declare a variable for saving return code of API call and save  */
   /* handler passed into the dialog data (for use in subclass proc)  */
   /*******************************************************************/
   DWORD fileBufferLength = MAX_PATH;
   bool rc;
   fFileDialogData->handlerToAdd = handler;

   /*******************************************************************/
   /* Copy the settings data passed into a new settings data block    */
   /*******************************************************************/
   // defect 29799 start
   // - Use the Windows 2000 SDK structure here instead of the NT40
   //   structure.
   pFileDlgData = new OPENFILENAME;
   memset( pFileDlgData, 0, sizeof( OPENFILENAME ) );
   // Depending on the current execution environment, we must set up the
   // correct size of this structure to enable the Win 2000 new features.
   if( IPlatform::isWin2000() )
   {
      pFileDlgData->lStructSize = sizeof( OPENFILENAME );
   }
   else
   {
      pFileDlgData->lStructSize = OPENFILENAME_SIZE_VERSION_400;
   }
   // defect 29799 end

   /*******************************************************************/
   /* Save the extended style to make sure we have a copy of it stored*/
   /*******************************************************************/
   setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

   /*******************************************************************/
   /* Convert the style bits into the GUI native style settings and   */
   /* remove read-only checkbox                                       */
   /*******************************************************************/
   pFileDlgData->Flags = convertToGUIStyle( style );

   /*******************************************************************/
   /* Check if a custom title was set                                 */
   /*******************************************************************/
   if (settings.title().length())
   {
     /*****************************************************************/
     /* If so, then copy the title over for updating                  */
     /*****************************************************************/
     fFileDialogData->fTitle = (LPSTR)new char[settings.title().length()+1];
     strcpy( fFileDialogData->fTitle, settings.titleStr );
     pFileDlgData->lpstrTitle = fFileDialogData->fTitle;
   }

   /*******************************************************************/
   /* Check if custom button text was set                             */
   /*******************************************************************/
   if (settings.okButtonText().length())
   {
     /*****************************************************************/
     /* If so, then copy the text over for updating and set flag to   */
     /* tell subclass procedure to do this on dialog initialization   */
     /*****************************************************************/
     fFileDialogData->fOKButton = settings.OKButtonStr;
     fFileDialogData->fSettingsChanged |= IC_OKBUTTON_SET;
   }

   /*******************************************************************/
   /* Check if a selectable list box is desired.  With the explorer   */
   /* dialog we cause the dialog to display a prompt if               */
   /* selectableListbox is NOT selected and the user selects an       */
   /* existing file.                                                  */
   /*******************************************************************/
   if ( !settings.isOpenDialog() &&
        !(style & IFileDialog::selectableListbox) )
      pFileDlgData->Flags |= OFN_OVERWRITEPROMPT;

   /*******************************************************************/
   /* Check if a custom position was set                              */
   /*******************************************************************/
   if (settings.isPositionSet())
   {
     /*****************************************************************/
     /* If so, then copy the position over for updating and set flag  */
     /* to tell subclass procedure to do this on dialog initialization*/
     /*****************************************************************/
     fFileDialogData->fPosition = settings.pos;
     fFileDialogData->fSettingsChanged |= IC_POSITION_SET;
   }

   /*******************************************************************/
   /* Check if a previous directory was set (via previous invocation) */
   /*******************************************************************/
   if (settings.fSettingsData->isDirectorySet)
   {
     /*****************************************************************/
     /* If so, then copy the drive over to initial directory string   */
     /*****************************************************************/
     fFileDialogData->fDrive =
         (LPSTR)new char[settings.fSettingsData->fDirectory.length()+1];
     strcpy( fFileDialogData->fDrive, settings.fSettingsData->fDirectory );
     pFileDlgData->lpstrInitialDir = fFileDialogData->fDrive;
   }

   /*******************************************************************/
   /* Otherwise check if an initial drive was specified               */
   /*******************************************************************/
   else if (settings.initialDrive().length())
   {
     /*****************************************************************/
     /* If so, then copy the drive over to initial directory string   */
     /*****************************************************************/
     fFileDialogData->fDrive =
                    (LPSTR)new char[settings.initialDrive().length()+1];
     strcpy( fFileDialogData->fDrive, settings.initialDriveStr );
     pFileDlgData->lpstrInitialDir = fFileDialogData->fDrive;
   }
   // defect 29799 start
   else
   {
       // no initial drive was set by the user.
       // If we are running windows 2000, then MS recommends putting the user
       // into the CSIDL_PERSONAL directory.
       if( IPlatform::isWin2000() )
       {
           // Get the user personal directory file location
           // We dynamically call the api to get us the path information because
           // we do not link this library in with NT builds, since it is a
           // special win 2000 api.  Thus, we try to load it and then call it.
           HMODULE hm = LoadLibrary( "shfolder.dll" );
           if( hm != NULL )
           {
               PFNSHGETFOLDERPATHA fp = (PFNSHGETFOLDERPATHA)
                                        GetProcAddress( hm, "SHGetFolderPathA" );
               if( fp )
               {
                   char buf[MAX_PATH];
                   buf[0] = '\0';
                   if( fp( NULL, CSIDL_PERSONAL|CSIDL_FLAG_CREATE, NULL, 0, buf ) == S_OK )
                   {
                       // set the current directory
                       fFileDialogData->fDrive =
                           (LPSTR)new char[strlen(buf)+1];
                       strcpy( fFileDialogData->fDrive, buf );
                       pFileDlgData->lpstrInitialDir = fFileDialogData->fDrive;
                   }
               }
               // free the loaded module
               FreeLibrary( hm );
           }
       }   // end if win 2000
   }
   // defect 29799 end

   /*******************************************************************/
   /* Check if a custom dialog template was specified                 */
   /*******************************************************************/
   if (settings.isDialogTemplateSet())
   {
     /*****************************************************************/
     /* If so, copy the id and instance handle over for updating      */
     /*****************************************************************/
     pFileDlgData->Flags |= OFN_ENABLETEMPLATE;
     pFileDlgData->lpTemplateName = MAKEINTRESOURCE( settings.fSettingsData->dlgId );
     pFileDlgData->hInstance = settings.fSettingsData->dlgHandle;
   }

   /*******************************************************************/
   /* If multiple selection, make it a large buffer for many filenames*/
   /* NOTE: In testing, Windows does not seem to use any more than    */
   /*  2K of buffer, meaning only about 150-170 files can be selected */
   /*******************************************************************/
   if ( style & IFileDialog::multiSelection )
     fileBufferLength = 4096;

   /*******************************************************************/
   /* Allocate a buffer for initializing AND receiving the path/file  */
   /* name.  Default the buffer to NULL and pass the buffer length    */
   /*******************************************************************/
   pFileDlgData->lpstrFile = (PSZ)new char[fileBufferLength];
   pFileDlgData->lpstrFile[0] = 0;
   pFileDlgData->nMaxFile = fileBufferLength;

   /*******************************************************************/
   /* Check if initial filename is to be specified and if so, copy it */
   /*******************************************************************/
   if (settings.fileName().length())
     strcpy( pFileDlgData->lpstrFile, settings.fileNameStr );

   /*******************************************************************/
   /* Settings maintains the list of Types as BB collections of       */
   /* strings. These have to be filled into a string of null-separated*/
   /* string in the Windows OPENFILEDIALOG structure.                 */
   /* Only do this if they've specified a filter on a call to         */
   /* addFileType.                                                    */
   /*******************************************************************/
   StringSeq* curQ = settings.fileTypes();
   if ((curQ) && (settings.fSettingsData->isUsingFileFilters))
   {
     IString* curString;
     StringSeq::Cursor current(*curQ);
     int i = 0;
     // Allocate space for the type string.  Add size for the final null (to
     // make the last one a double null).
     IString filter;
     // Copy all the type strings to the master string.
     for (current.setToFirst(); current.isValid(); current.setToNext() )
     {
        curString = curQ->elementAt(current);
        // Only add this string to the filter list if it contains the filter
        // separator.
        if (curString->indexOf(" FS "))
        {
           filter += *curString;
           filter += IString('\0');
           i++;
        }
     }
     // Add another null at the end to make this the last one.
     filter += IString('\0');
     filter.change(" FS ", IString('\0'));
     pFileDlgData->lpstrFilter = filter;
     pFileDlgData->nFilterIndex = i;
   }
   /*******************************************************************/
   /* If no types specified, set initial filter to All files in order */
   /* to fill listbox on dlg initialization.  Without this, the       */
   /* listbox will be blank.                                          */
   /*******************************************************************/
   else
   {
      pFileDlgData->lpstrFilter = "All Files\0*.*\0\0";
      pFileDlgData->nFilterIndex = 1;
   }

   /*******************************************************************/
   /* Set the owner of the dialog based on parameters passed          */
   /* If dialog is modeless, create an object window and make it owner*/
   /*******************************************************************/
   IModelessDialogWindow* objWin = 0;
   if (style & IFileDialog::modeless)
   {
     objWin = new IModelessDialogWindow( this );
     pFileDlgData->hwndOwner = objWin->handle();
   }
   /*******************************************************************/
   /*  otherwise use the owner handle passed (if any)                 */
   /*******************************************************************/
   else
     pFileDlgData->hwndOwner = owner == 0 ? IWindowHandle(0) :
                                                        owner->handle();

   /*******************************************************************/
   /* Save the this pointer in the application data field in template */
   /* to allow access back to IFileDialog object from within hook proc*/
   /*******************************************************************/
   pFileDlgData->lCustData = (unsigned long)this;

   /*******************************************************************/
   /* Set the hook proc to our dialog procedure since we need to get  */
   /* in to process interactions                                      */
   /*******************************************************************/
   pFileDlgData->lpfnHook = (LPOFNHOOKPROC)_IFileDlgProc;
   pFileDlgData->Flags |= OFN_ENABLEHOOK | OFN_PATHMUSTEXIST | OFN_EXPLORER;

   /*******************************************************************/
   /* Set the window id for the dialog                                */
   /*******************************************************************/
   if (settings.isDialogTemplateSet())
     // use template id for dialog id
     fFileDialogData->fDialogId = settings.fSettingsData->dlgId;
   else
     if (pFileDlgData->Flags & FDS_MULTIPLESEL)
       // use system multiselect open file dialog id
       fFileDialogData->fDialogId = IC_FILE_DIALOG_MULTSELECT;
     else
       // use normal system open file dialog id
       fFileDialogData->fDialogId = IC_FILE_DIALOG;

   /*******************************************************************/
   /* Everything is now set up, so invoke the correct dialog          */
   /*******************************************************************/
   if (settings.isOpenDialog())
   {
      fFileDialogData->fSettingsChanged |= IC_OPEN_SET;
      rc = GetOpenFileName( pFileDlgData );
   }
   else
   {
     rc = GetSaveFileName( pFileDlgData );
   }

   /*******************************************************************/
   /* If complete, then perform any cleanup necessary                 */
   /*******************************************************************/

   /*******************************************************************/
   /* Check the return code from the dialog and set the return value  */
   /* accordingly                                                     */
   /*******************************************************************/
   if (rc)
   {
     fFileDialogData->fReturnVal = DID_OK;

     /*****************************************************************/
     /* If a selection was made, then update the settings initial path*/
     /* string with selection, for future invocations to start at the */
     /* same place that the previous one did                          */
     /*****************************************************************/
     settings.fSettingsData->fDirectory = pFileDlgData->lpstrFile;
     settings.fSettingsData->fDirectory.remove( pFileDlgData->nFileOffset );
     settings.fSettingsData->isDirectorySet = true;

     ((Settings&)settings).fileNameStr = pFileDlgData->lpstrFile;
     settings.fileNameStr.remove( 1, pFileDlgData->nFileOffset );
   }
   else
   {
     // Set result to cancel, and store error code if any.
     fFileDialogData->fReturnVal = DID_CANCEL;
     fFileDialogData->fSRC = CommDlgExtendedError();
     // If error, throw exception.
     if ( fFileDialogData->fSRC )
        ITHROWSYSTEMERROR(fFileDialogData->fSRC,"OpenFileName",IBaseErrorInfo::invalidRequest,IException::recoverable);
   }
#endif // IC_WIN
#ifdef IC_MOTIF
   Widget   w;
   int      n = 0;
   Arg      args[5];

   pFileDlgData = 0;  // currently unused
   fFileDialogData->fDeselectList = true;

   // Establish the title of the dialog.
   IString titleString;
   if (settings.title().length())
   {
      titleString = settings.title();
   }
   else
   {
      // Look for a frame window as a source of the title text.

      // Search owner tree for frame window
      IWindow*      titleWin(owner);
      IFrameWindow* titleFrame(dynamic_cast<IFrameWindow*>(titleWin));
      while (titleWin && !titleFrame)
      {
         titleWin = titleWin->owner();
         titleFrame = dynamic_cast<IFrameWindow*>(titleWin);
      }
      if (!titleFrame)
      {
         // Search parent tree for frame window
         titleWin = parent;
         titleFrame = dynamic_cast<IFrameWindow*>(titleWin);
         while (titleWin && !titleFrame)
         {
            titleWin = titleWin->parent();
            titleFrame = dynamic_cast<IFrameWindow*>(titleWin);
         }
      }
      if (titleFrame)
      {
         // Use the reference frame window for title.
         titleString = titleFrame->titleText();
      }
      else
      {
         // If the title is still not determined, use the application name.
         titleString = XtName( IThread::current().applicationShell() );
      }
   }

   // create the FrameWindow.  This creates a shell, a main window, and
   // an XmFileSelectionBox.
   w = Inherited::create(
          DID_FILE_DIALOG,             // dummy resource id
          titleString,
          IFrameWindow::classDefaultStyle,
          (IXmCreateFunction)XmCreateFileSelectionBox,
          parent,
          owner,
          IRectangle());


   if (w == 0)
      {
      ITHROWLIBRARYERROR1( IC_XMCREATE_FAILURE,
                           IBaseErrorInfo::invalidRequest,
                           IException::recoverable,
                           "XmCreateFileSelectionBox");
      }

   XtAddCallback( w,                                // widget
                  XmNokCallback,                    // callback name
                  iwindowMotifCallback,             // callback routine
                  (XtPointer) this);                // client data
   XtAddCallback( w,                                // widget
                  XmNcancelCallback,                // callback name
                  iwindowMotifCallback,             // callback routine
                  (XtPointer) this);                // client data
   XtAddCallback( w ,
                  XmNunmapCallback,                 // callback name
                  iwindowMotifCallback,             // callback routine
                  (XtPointer) this);                // client data


   Widget child = XmFileSelectionBoxGetChild( w, XmDIALOG_LIST );
   if (child)
      {
      XtAddCallback( child,
                     XmNmultipleSelectionCallback,     // callback name
                     ifiledlgMotifCallback,            // callback routine
                     (XtPointer)this);                 // client data
      }

   if ( style & IFileDialog::multiSelection )
     {
     child = XmFileSelectionBoxGetChild( w, XmDIALOG_TEXT );
     if (child )
        {
        XtAddCallback( child,
                       XmNvalueChangedCallback,        // callback name
                       ifiledlgMotifCallback,          // callback routine
                       (XtPointer)this);               // client data
        }
     }

   // Add the help callbacks for each widget
   int i;
   for (i = 0; FileDialogHelpList[i].childId != XmDIALOG_NONE ; i++)
      {
      child = XmFileSelectionBoxGetChild( w, FileDialogHelpList[i].childId);
      if (child)
         {
         XtAddCallback( child,
                        XmNhelpCallback,             // callback name
                        ihelpwindowCallback,         // callback routine  (ihelpsta.cpp)
                        (XtPointer) FileDialogHelpList[i].helpId );
         }
      }

   // add a callback for the help button
   child = XmFileSelectionBoxGetChild( w, XmDIALOG_HELP_BUTTON);
   if (child)
      {
      XtAddCallback( child,
                     XmNactivateCallback,         // callback name
                     ifiledialogHelpCallback,     // callback routine
                     NULL );
      }


   if (!(style & IFileDialog::modeless))
      XtVaSetValues( w, XmNdialogStyle, XmDIALOG_APPLICATION_MODAL, NULL );

   // if this is a save as dialog
   if (!settings.isOpenDialog())
      {
      if (!(style & IFileDialog::selectableListbox))
         {
         XtSetSensitive( XmFileSelectionBoxGetChild( w, XmDIALOG_LIST ), False );
         }
      }

   if ( style & IFileDialog::multiSelection )
      {
      XtVaSetValues( XmFileSelectionBoxGetChild( w, XmDIALOG_LIST ),
                     XmNselectionPolicy, XmMULTIPLE_SELECT,
                     NULL );
      }

   // get the default qualify proc
   if (defaultQualifyProc == 0)
      {
      XtVaGetValues( w,
                     XmNqualifySearchDataProc, &defaultQualifyProc ,
                     NULL );
      }

   // get the default search proc
   if (defaultSearchProc == 0)
      {
      XtVaGetValues( w,
                     XmNfileSearchProc, &defaultSearchProc ,
                     NULL );
      }

   // Set up to use our search proc so that per file filtering can
   // be done in the handler.
   XtVaSetValues( w,
                  XmNfileSearchProc, ifiledialogSearchProc,
                  XmNqualifySearchDataProc, ifiledialogQualifyProc ,
                  NULL );

   // custom text for the OK button
   if (settings.okButtonText().length())
      {
      Widget ok = XmFileSelectionBoxGetChild( w, XmDIALOG_OK_BUTTON);
      IMString  xms( settings.okButtonText() );
      XtVaSetValues(ok,
                    XmNlabelString, (XmString)xms,
                    NULL );
      }
   else
      {
      IMString  imok( loadButtonLabel( IC_LABEL_OK, "OK" ) );
      XtVaSetValues(w, XmNokLabelString, (XmString)imok, NULL );
      }

    // text for the Filter button (which is really the apply button
    // inherited from Selection Box)
    IMString imfilter = loadButtonLabel( IC_LABEL_FILTER, "Filter" );
    XtVaSetValues(w, XmNapplyLabelString, (XmString)imfilter, NULL );

    // text for the Cancel button
    IMString imcancel = loadButtonLabel( IC_LABEL_CANCEL, "Cancel" );
    XtVaSetValues(w, XmNcancelLabelString, (XmString)imcancel, NULL );

    // text for the Help button
    IMString imhelp = loadButtonLabel( IC_LABEL_HELP, "Help" );
    XtVaSetValues(w, XmNhelpLabelString, (XmString)imhelp, NULL );

   // default file selection
   if (settings.fileName().length() != 0)
   {
      // If the file name given is supposed to be a filter, set that in
      // the Selection field.  We query it later in ::show and fire
      // the filtering there.
      if (settings.fSettingsData->fFileAsFilter)
      {
         IString dirSpec = settings.fileName();
         IMString  mdirSpec(dirSpec);
         XtVaSetValues( w, XmNdirSpec, (XmString)mdirSpec, NULL );
      }
      // If the file name given is NOT a filter, save the file name
      // and let the filter default to "*".  Then in ::show, we
      // set the file name in the Selection field.
      // We must also check to see if the file name contains a directory
      // and make sure it gets transferred to the filter field.
      else
      {
         fFileDialogData->fFileName = settings.fileName();
         fFileDialogData->fFileAsFilter = false;
         int fileNamePos = fFileDialogData->fFileName.lastIndexOf("/");
         if (fileNamePos != 0)
         {
            IString directory = fFileDialogData->fFileName;
            // Remove file name
            directory = directory.remove (fileNamePos+1) + "*";
            IMString  mdirSpec(directory);
            XtVaSetValues( w, XmNdirSpec, (XmString)mdirSpec, NULL );
         }
      }
    }

   // Was a help button specified?  If not unmanage the help button.
   if (!(style & IFileDialog::helpButton))
      {
      XtUnmanageChild( XmFileSelectionBoxGetChild( w, XmDIALOG_HELP_BUTTON ));
      }

   // Allow both list boxes to grow.
   // To get more user friendly behavior on list boxes.
   XtVaSetValues(w, XmNresizePolicy, XmRESIZE_NONE,
                 NULL);

   // Handle positioning of the dialog.  Client area is the
   // FileSelectionBox, whose size we set to 400,400.
   ISize dlgSize(400,400);
   IRectangle dlgRect = IRectangle( settings.position(), dlgSize );

   // If there was no position specified in the settings, center on
   // the frame.
   if ( !settings.isPositionSet() )
      {
      IRectangle ownerRect;
      if (owner)
         ownerRect = owner->rect();
      if ( ownerRect != IRectangle() )
         {
         IPoint centerPt = ownerRect.center();
         IRectangle wholeRect = this->frameRectFor(dlgRect);
         // Center the dialog on the owner.
         wholeRect.centerAt( centerPt );
         // Ensure that the result will be on screen.
         IRectangle desktopRect( IWindow::desktopWindow()->rect() );
         if ( !desktopRect.contains( wholeRect ) )
            {
            IPair adjustment(0,0);
            // Move on screen in X direction.
            if (desktopRect.minX() > wholeRect.minX() )
               adjustment.setCoord1( desktopRect.minX() - wholeRect.minX() );
            else if (desktopRect.maxX() < wholeRect.maxX() )
               adjustment.setCoord1( desktopRect.maxX() - wholeRect.maxX() );
            // Move on screen in Y direction.
            if (desktopRect.minY() > wholeRect.minY() )
               adjustment.setCoord2( desktopRect.minY() - wholeRect.minY() );
            else if (desktopRect.maxY() < wholeRect.maxY() )
               adjustment.setCoord2( desktopRect.maxY() - wholeRect.maxY() );

            wholeRect.moveBy(adjustment);
            }
         // Move the client area to the computed origin.
         if ( ICoordinateSystem::applicationOrientation() ==
              ICoordinateSystem::kOriginLowerLeft )
            dlgRect.moveTo( wholeRect.minXMaxY() -
                            IPair(0, dlgRect.maxY() - dlgRect.minY()) );
         else
            dlgRect.moveTo( wholeRect.minXMinY() );
         }
      }
   else
   {
      IRectangle ownerRect;
      if (owner)
         ownerRect = owner->rect();
      if ( ownerRect != IRectangle() )
         dlgRect.moveBy (ownerRect.minXMinY());

     if ( ICoordinateSystem::applicationOrientation() ==
           ICoordinateSystem::kOriginLowerLeft )
                        {
                                IRectangle wholeRect = this->frameRectFor(dlgRect);
                                dlgRect.moveBy(IPair(0,wholeRect.maxY() - dlgRect.maxY()));
                        }

   }

   // Don't call moveSizeToClient() because it creates a deferred action
   // which might override users's customization in handleEventsFor().
   this->moveSizeTo(dlgRect);

   setResult( DID_CANCEL );         // assume this till proven otherwise

   // Attach the default handler.  We need a default handler for IFileDialog
   // so that something can return "true" for all filter requests, and handle      |
   // OK and Cancel selections.                                                    |
   fFileDialogData->fDefaultHandler.handleEventsFor( this );

   // attach the user supplied handler if one was passed in
   if ( handler != 0 )
      {
      handler->handleEventsFor( this );
      } /* endif */

   if (style & IFileDialog::modeless)
      {
      show();
      }
   else
      {
      showModally();
      }   // if modal
#endif // IC_MOTIF
}

